<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Nadzor dostopa';
$string['actionaftercorrectanswer'] = 'Dejanje po pravilnem odgovoru';
$string['actionaftercorrectanswer_help'] = '<p>Običajno dejanje je sledenje skoku, kot je določen v odgovoru. V večini primerov bo to verjetno prikazalo naslednjo stran lekcije. Udeleženec sledi lekciji na logičen način z začetkom na začetku in koncem na koncu.</p>

<p>Modul lekcije pa je lahko uporabljen tudi kot vrsta naloge <i>Opomnih kartic</i>. Udeležencu se lahko prikaže nekaj informacij in vprašanje v naključnem vrstnem redu. Ni nastavljenega začetka in nastavljenega konca. Samo nabor <i>Kartic</i> prikazanih ena za drugo brez določenega vrstnega reda.</p>

<p>Ta možnost omogoča dve podobni različici obnašanja opomnih kartic. Možnost "Prikaži še ne videno stran" nikoli ne prikaže iste strani dvakrat (tudi, če udeleženec <b>ni</b> pravilno odgovoril na povezano vprašanje kartice / strani). Druga možnost, ki ni privzeta, "Prikaži še ne odgovorjeno stran" omogoča, da udeleženec vidi strani, ki so se morda že pojavile, v primeru, če je na vprašanje odgovoril napačno.</p>

<p>V obeh dveh vrstah lekcije Opomnih kartic, lahko izvajalec določi uporabo bodisi vseh kartic / strani v lekciji ali zgolj (naključnega) dela nabora. To se doseže prek parametra "Število strani (kartic) za prikaz".</p>';
$string['actions'] = 'Dejanja';
$string['activitylink'] = 'Povezava na dejavnost';
$string['activitylink_help'] = '<p>Padajoči meni vsebuje vse dejavnosti za ta predmet. Če katero izberete, se bo povezava na to dejavnost pojavila na koncu lekcije.</p>';
$string['activitylinkname'] = 'Pojdi na: {$a}';
$string['addabranchtable'] = 'Dodaj tabelo razvejanja';
$string['addanendofbranch'] = 'Dodaj konec veje';
$string['addanewpage'] = 'Dodaj novo stran';
$string['addaquestionpage'] = 'Dodaj stran z vprašanji';
$string['addaquestionpagehere'] = 'Tu dodaj stran z vprašanji';
$string['addbranchtable'] = 'Dodaj stran z vsebino';
$string['addcluster'] = 'Dodaj gručo';
$string['addedabranchtable'] = 'Tabela razvejanja dodana';
$string['addedanendofbranch'] = 'Dodan konec veje';
$string['addedaquestionpage'] = 'Dodana stran z vprašanjem';
$string['addedcluster'] = 'Dodana gruča';
$string['addedendofcluster'] = 'Dodan konec gruče';
$string['addendofcluster'] = 'Dodaj konec gruče';
$string['addpage'] = 'Dodaj stran';
$string['anchortitle'] = 'Začetek glavne vsebine';
$string['and'] = 'IN';
$string['answer'] = 'Odgovor';
$string['answeredcorrectly'] = 'odgovorjeno pravilno.';
$string['answersfornumerical'] = 'Odgovori za številčna vprašanja naj bodo pari enakih vrednosti Najmanj in Največ';
$string['arrangebuttonshorizontally'] = 'Uredi gumbe razvejanja vodoravno v načinu diaprojekcije?';
$string['attempt'] = 'Poskus: {$a}';
$string['attempts'] = 'Poskusi';
$string['attemptsdeleted'] = 'Poskusi izbrisani';
$string['attemptsremaining'] = 'Število vaših preostalih poskusov: {$a}';
$string['available'] = 'Na voljo od';
$string['averagescore'] = 'Povprečen rezultat';
$string['averagetime'] = 'Povprečen čas';
$string['branch'] = 'Vsebina';
$string['branchtable'] = 'Tabela razvejanja';
$string['cancel'] = 'Prekliči';
$string['cannotfindanswer'] = 'Napaka: ne morem najti odgovora';
$string['cannotfindattempt'] = 'Napaka: ne morem najti poskusa';
$string['cannotfindfirstgrade'] = 'Napaka: ne morem najti ocen';
$string['cannotfindfirstpage'] = 'Ne morem najti prve strani';
$string['cannotfindgrade'] = 'Napaka: ne morem najti ocene';
$string['cannotfindnewestgrade'] = 'Napaka: ne morem najti najnovejše ocene';
$string['cannotfindnextpage'] = 'Varnostna kopija lekcije: Naslednja stran ni najdena!';
$string['cannotfindpagerecord'] = 'Dodajte konec podveje: Zapis strani ni najden';
$string['cannotfindpages'] = 'Ne morem najti strani lekcij';
$string['cannotfindpagetitle'] = 'Portdite izbris: stran ni najdena';
$string['cannotfindpreattempt'] = 'Prejšnji poskus zapisa ni najden!';
$string['cannotfindrecords'] = 'Napaka: ne morem najti zapisov lekcij';
$string['cannotfindtimer'] = 'Napaka: ne morem najti zapisov lekcijskega merilnika časa';
$string['cannotfinduser'] = 'Napaka: ne morem najti uporabnikov';
$string['canretake'] = '{$a} lahko ponovi';
$string['casesensitive'] = 'Uporabi regularni izraz';
$string['casesensitive_help'] = '<p>Nekatere vrste vprašanj imajo možnosti, ki se vključijo z označbo ustreznega potrditvenega polja. Vrste vprašanj in pomen možnosti so pojasnjeni spodaj.</p>

<ol>
<li><p><b>Več izbir</b> Obstaja različica vprašanj z večimi izbirami, ki se imenuje <b>"Več izbir več odgovorov"</b>. Če je izbrana ta možnost vprašanja, potem mora udeleženec izbrati vse pravilne odgovore iz nabora odgovorov. Vprašanje lahko, ali pa tudi ne, pove udeležencu, <i>koliko</i> je pravilnih odgovorov . Vprašanje "Kdo izmed naslednjih oseb je bil predsednik Slovenije?" na primer tega ne pove, vprašanje "Izberite dva predsednika Slovenije iz seznama", pa to pove. Dejansko število pravilnih odgovorov je lahko od <b>ena</b> in vse do števila možnosti. (Vprašanje z večimi izbirami in večimi odgovori ter enim pravilnim odgovorom <b>je</b> drugačno od vprašanja z večimi izbirami, saj prvi omogoča izbor več kot enega odgovora, medtem ko drugi tega ne omogoča.)</p></li>

<li>
  <p><b>Kratek odgovor</b> Obstajata dva različna sistema primerjave, ki sta na voljo za vrsto vprašanja kratek odgovor: privzeto je uporabljen enostaven sistem, sistem "Regularni izraz" je uporabljen, če je označeno polje "Uporabi regularni izraz".  Za več informacij, preberite datoteko pomoči o vrstah vprašanj lekcije.</p>
</li>
</ol>
<p>Druge vrste vprašanj ne uporabljajo možnosti vprašanja.</p>';
$string['checkbranchtable'] = 'Preveri tabelo razvejanja';
$string['checkedthisone'] = 'označil to.';
$string['checknavigation'] = 'Preveri navigacijo';
$string['checkquestion'] = 'Preveri vprašanje';
$string['classstats'] = 'Statistika razreda';
$string['clicktodownload'] = 'Kliknite na povezavo za prenos datoteke.';
$string['clicktopost'] = 'Kliknite tu za oddajo vaše ocena na Lestvico najboljših.';
$string['cluster'] = 'Gruča';
$string['clusterjump'] = 'Še ne videno vprašanje v gruči';
$string['clustertitle'] = 'Gruča';
$string['collapsed'] = 'Strnjeno';
$string['comments'] = 'Vaši komentarji';
$string['completed'] = 'Dokončano';
$string['completederror'] = 'Dokončaj lekcijo';
$string['completethefollowingconditions'] = 'Izpolniti morate naslednje pogoje v lekciji <b>{$a}</b>, preden lahko nadaljujete.';
$string['conditionsfordependency'] = 'Pogoji za odvisnost';
$string['configactionaftercorrectanswer'] = 'Privzeta dejavnost po pravilnem odgovoru';
$string['configmaxanswers'] = 'Privzeto največje število številk odgovorov na stran';
$string['configmaxhighscores'] = 'Število prikazanih najvišjih ocen';
$string['configmediaclose'] = 'Prikaži gumb za zaprtje kot del pojavnega okna ustvarjenega za povezavo medijske datoteke';
$string['configmediaheight'] = 'Določi višino pojavnega okna prikazanega za povezano medijsko datoteko';
$string['configmediawidth'] = 'Določi širino pojavnega okna prikazanega za povezano medijsko datoteko';
$string['configslideshowbgcolor'] = 'Barva ozadja za slikovno predstavitev, če je omogočena';
$string['configslideshowheight'] = 'Določi višino slikovne predstavitve, če je omogočena';
$string['configslideshowwidth'] = 'Določi širino slikovne predstavitve, če je omogočena';
$string['confirmdelete'] = 'Izbriši stran';
$string['confirmdeletionofthispage'] = 'Potrdite brisanje te strani';
$string['congratulations'] = 'Čestitamo - prišli ste do konca lekcije';
$string['continue'] = 'Nadaljuj';
$string['continuetoanswer'] = 'Nadaljuj s spreminjanjem odgovorov.';
$string['continuetonextpage'] = 'Nadaljuj na naslednjo stran';
$string['correctanswerjump'] = 'Skok ob pravilnem odgovoru';
$string['correctanswerscore'] = 'Točke za pravilni odgovor';
$string['correctresponse'] = 'Odziv ob pravilnem odgovoru';
$string['credit'] = 'Točke';
$string['customscoring'] = 'Točkovanje po meri';
$string['customscoring_help'] = '<p>To vam bo omogočilo nastaviti številčno točko vrednosti za vsak odgovor. Odgovori imajo lahko pozitivne ali negativne vrednosti. Uvožena vprašanja bodo imela samodejno dodeljeno 1 točko za pravilne odgovore in 0 za napačne, vendar lahko to spremenite po uvozu.</p>';
$string['deadline'] = 'Skrajni rok';
$string['defaultessayresponse'] = 'Vaš esej bo ocenil izvajalec predmeta.';
$string['deleteallattempts'] = 'Izbriši vse poskuse v lekciji';
$string['deletedefaults'] = 'Izbrisano {$a} x privzete lekcije';
$string['deletedpage'] = 'Izbrisana stran';
$string['deleting'] = 'Brisanje';
$string['deletingpage'] = 'Brisanje strani: {$a}';
$string['dependencyon'] = 'Odvisno od';
$string['dependencyon_help'] = '<p>Ta nastavitev omogoča, da je trenutna lekcija odvisna od udeleženčeve uspešnosti v drugi lekciji, ki je v istem predmetu.  Če zahtevam uspešnosti ni zadovoljeno, udeleženec ne bo mogel dostopati do te lekcije.</p>

<p>Pogoji za odvisnost vključujejo:
    <ul>
        <li><b>Porabljen čas:</b> udeleženec mora porabiti nastavljeno količino časa v zahtevani lekciji.</li>
        <li><b>Dokončano:</b> udeleženec mora dokončati zahtevano lekcijo.</li>
        <li><b>Ocena boljša od:</b> udeleženec mora prejeti boljšo oceno, kot je tu določena, v zahtevani lekciji.</li>
    </ul>
    Če je tako potrebno, lahko uporabite poljubno kombinacijo zgornjega.
</p>';
$string['description'] = 'Opis';
$string['detailedstats'] = 'Podrobna statistika';
$string['didnotanswerquestion'] = 'Ni odgovora na to vprašanje.';
$string['didnotreceivecredit'] = 'Ni štelo v dobro';
$string['displaydefaultfeedback'] = 'Prikaži privzeti odziv';
$string['displaydefaultfeedback_help'] = '<p align="center"><strong>Prikaži privzeti odziv</strong></p>

<p>Če to možnost nastavite na <strong>Da</strong>, se bosta v primeru, da ni določenega odziva pri nekem vprašanju, uporabila privzeta odziva "To je pravilen odgovor" in "To je napačen odgovor".</p>
<p>Če to možnost nastavite na <strong>Ne</strong>, potem se v primeru, da ni določenega odziva pri nekem vprašanju, ne bo prikazal noben odziv. Uporabnik bo v lekciji v tem primeru neposredno napoten na naslednjo stran lekcije.</p>';
$string['displayhighscores'] = 'Prikaži najboljše rezultate';
$string['displayinleftmenu'] = 'Prikaži v levem meniju?';
$string['displayleftif'] = 'Prikaži levi meni samo, če je ocena višja od:';
$string['displayleftif_help'] = 'Ta nastavitev določa ali mora udeleženec dobiti določeno oceno preden vidi levi meni. To prisili udeleženca da gre skozi celotno lekcijo v prvem poskusu, ko nato dobi določeno oceno lahko uporablja levi meni za pregled.';
$string['displayleftmenu'] = 'Prikaži levi meni';
$string['displayleftmenu_help'] = '<p>To bo prikazalo seznam strani (tabelo razvejanja) v lekciji.</p>
<p>Z navedbo ocene višje od 0, mora imeti udeleženec lekcije oceno enako ali višjo od nastavljene ocene, da bi videl levi meni. To omogoča snovalcem lekcije prisilo, da uporabniki obdelajo celotno lekcijo ob uporabnikovem prvem poskusu. Če nato uporabnik po pridobitvi zahtevane ocene znova poskusi lekcijo, lahko za lažji pregled vidi levi meni.</p>';
$string['displayofgrade'] = 'Prikaz ocen (samo za udeležence)';
$string['displayreview'] = 'Prikaži gumb za pregled';
$string['displayreview_help'] = '<p>To bo prikazalo gumb po napačno odgovorjenem vprašanju in udeležencu omogočilo, da poskusi znova. To ni združljivo z esejskimi vprašanji, zato pustite to možnost izključeno, če uporabljate esejska vprašanja.</p>';
$string['displayscorewithessays'] = 'Prejeli ste {$a->score} točk od {$a->tempmaxgrade} za samodejno ocenjevana vprašanja.<br />Vaših {$a->essayquestions} odgovorov v eseju bo ocenjenih in dodanih<br />v vaš skupni rezultat pozneje.<br /><br />Vaša trenutna ocena brez odgovorov v eseju je {$a->score} od {$a->grade}';
$string['displayscorewithoutessays'] = 'Vaš rezultat je {$a->score} (od {$a->grade}).';
$string['edit'] = 'Uredi';
$string['editingquestionpage'] = 'Urejanje {$a} strani z vprašanjem';
$string['editlessonsettings'] = 'Uredi nastavitve lekcije';
$string['editpage'] = 'Uredi vsebino strani';
$string['editpagecontent'] = 'Uredi vsebino strani';
$string['email'] = 'E-pošta';
$string['emailallgradedessays'] = 'Pošlji VSE<br />ocenjene eseje po e-pošti';
$string['emailgradedessays'] = 'Pošlji ocenjene eseje po e-pošti';
$string['emailsuccess'] = 'E-pošta je bila uspešno poslana';
$string['endofbranch'] = 'Konec veje';
$string['endofcluster'] = 'Konec  gruče';
$string['endofclustertitle'] = 'Konec gruče';
$string['endoflesson'] = 'Konec lekcije';
$string['enteredthis'] = 'vnesel to.';
$string['entername'] = 'Vnesite vzdevek za lestvico najboljših rezultatov';
$string['enterpassword'] = 'Prosimo, vnesite geslo:';
$string['eolstudentoutoftime'] = 'Pozor:  Zmanjkalo vam je časa za to lekcijo. Vaš zadnji odgovor morda ni štel, če ste odgovorili po poteku časa.';
$string['eolstudentoutoftimenoanswers'] = 'Niste odgovorili na nobeno vprašanje.  Za to lekcijo ste prejeli 0.';
$string['essay'] = 'Esej';
$string['essayemailmessage'] = '<p>Esejsko vprašanje:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentar izvajalca ({$a->teacher}):<blockquote><em>{$a->comment}</em></blockquote></p><p>Dobili ste {$a->earned} od {$a->outof} za to esejsko vprašanje.</p><p>Vaša ocena za lekcijo je sedaj {$a->newgrade}&#37;.</p>';
$string['essayemailmessage2'] = '<p>Esejsko vprašanje:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentarji ocenjevalca:<blockquote><em>{$a->comment}</em></blockquote></p><p>dobili ste {$a->earned} od {$a->outof} za to esejsko vprašanje.</p><p>Vaša lekcijska ocena je bila spremenjena v {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Vaša ocena za vprašanje {$a}';
$string['essays'] = 'Eseji';
$string['essayscore'] = 'Točke za eseje';
$string['fileformat'] = 'Format datoteke';
$string['firstanswershould'] = 'Prvi odgovor naj skoči na stran "Pravilno"';
$string['firstwrong'] = 'Žal, te točke ne zaslužite, saj vaš odgovor ni bil pravilen. Bi želeli nadaljevati z ugibanjem, iz čistega veselja do učenja (a ne za točke)?';
$string['flowcontrol'] = 'Nadzor toka';
$string['full'] = 'Razširjeno';
$string['general'] = 'Splošno';
$string['gotoendoflesson'] = 'Pojdite na konec lekcije';
$string['grade'] = 'Ocena';
$string['gradebetterthan'] = 'Ocena boljša od (&#37;)';
$string['gradebetterthanerror'] = 'Zasluži oceno boljšo od {$a} odstotkov';
$string['gradeessay'] = 'Ocene esejskih vprašanj ({$a->notgradedcount} ne ocenjenih in {$a->notsentcount} ne poslanih)';
$string['gradeis'] = 'Ocena je {$a}';
$string['gradeoptions'] = 'Možnosti ocene';
$string['handlingofretakes'] = 'Obravnava ponovitev';
$string['handlingofretakes_help'] = '<p>Ko udeleženci smejo ponoviti lekcijo, ta možnost omogoča izvajalcu prikaz ocen za lekcijo na primer na strani ocen bodisi kot <b>povprečje</b>, kar pomeni povprečno oceno prvega in vseh nadaljnjih poskusov ali oceno udeleženčevega <b>najboljšega</b> poskusa.</p>

<p>To možnost lahko kadarkoli spremenite.</p>';
$string['havenotgradedyet'] = 'Še niso ocenili.';
$string['here'] = 'tukaj';
$string['highscore'] = 'Najboljši rezultat';
$string['highscores'] = 'Najboljši rezultati';
$string['hightime'] = 'Najboljši čas';
$string['importcount'] = 'Uvažanje {$a} vprašanj';
$string['importquestions'] = 'Uvozi vprašanja';
$string['importquestions_help'] = '<p>Ta funkcija vam omogoča uvoz vprašanj iz zunanje besedilne datoteke, naložene prek obrazca.  </p>

<p>Podprta je vrsta formatov:</p>

<h2>GIFT format</h2>
<ul>
<p>GIFT je najbolj vsestranski format za uvoz vprašanj iz Moodle kvizov iz datoteke z besedilom. Zasnovan je bil kot enostaven način s katerim lahko izvajalci pišejo vprašanja kot datoteko z besedilom. Podpira večkratno izbiro, drži - ne drži, kratek odgovor, ujemanje in številčna vprašanja, kakor tudi obliko za vstavljanje ____ za &quot;manjkajoče besede&quot;.  Različne vrste vprašanj so lahko mešane v eni datoteki besedila in oblika podpira tudi vrstice s komentarji, imena vprašanj, povratno informacijo in odstotke oz. utežene ocene.  Spodaj je nekaj primerov:</p>
<pre>
Kdo je pokopan v Grantovi grobnici?{~Grant ~Jefferson =nihče}

Grant je {~pokopan =položen ~živ} v Grantovi grobnici.

Grant je pokopan v Grantovi grobnici.{FALSE}

Kdo je pokopan v Grantovi grobnici?{=nihče =nobeden}

Kdaj je bil Ulysses S. Grant rojen?{#1822}
</pre>

<p align="right"><a href="help.php?file=formatgift.html&module=quiz">Več informacij o zapisu &quot;GIFT&quot;</a></p>
</ul>

<h2>Aiken format</h2>
<ul>
<p>Format Aiken je zelo preprost način ustvarjanja vprašanj z večimi možnimi odgovori, ki uporablja jasen in berljiv zapis. Tu je primer formata:</p>
<pre>
Kaj je namen prve pomoči?
A. Rešiti življenje, preprečiti dodatne poškodbe, ohraniti zdravje
B. Ponuditi zdravniško oskrbo vsem poškodovanim ali ranjenim osebam
C. Preprečiti dodatne poškodbe
D. Pomagati žrtvam, ki iščejo pomoč
ANSWER: A
</pre>

<p align="right"><a href="help.php?file=formataiken.html&module=quiz">Več informacij o zapisu &quot;Aiken&quot;</a></p>
</ul>

<h2>Manjkajoča beseda</h2>
<ul>
<p>Ta zapis podpira samo vprašanja z večimi možnimi odgovori. Vsak odgovor je ločen s tildo (~) in pravilni odgovor ima predpono znak enakosti (=).   Tu je primer:</p>

<blockquote>Kakor hitro začnemo kot dojenčki raziskovati dele svojega telesa postanemo študenti {=anatomije in psihologije ~refleksologije ~znanosti ~eksperimenta} in na nek način to ostanemo celo življenje.
</blockquote>

<p align="right"><a href="help.php?file=formatmissingword.html&module=quiz">Več informacij o zapisu &quot;Manjkajoče besede&quot;</a></p>
</ul>

<h2>AON</h2>
<ul>
<p>Ta format je enak formatu manjkajoče besede s to razliko, da se po uvozu vprašanj vsa vprašanja kratkih odgovorov pretvorijo v vprašanja z ujemanjem po štiri hkrati.</p>
<p>Dodatno se odgovori vprašanj z večimi izbirami naključno premešajo po uvozu.</p>
<p>Imenuje se po organizaciji, ki je podprla razvoj mnogih možnosti kviza</p>
</ul>

<h2>Blackboard</h2>
<ul>
<p>Ta modul zna uvažati vprašanja shranjena v izvoznem zapisu programa Blackboard.  Temelji na XML funkcijah, ki jih mora podpirati vaš PHP.</p>

<p align="right"><a href="help.php?file=formatblackboard.html&module=quiz">Več informacij o zapisu &quot;Blackboard&quot;</a></p>
</ul>

<h2>Course Test Manager</h2>
<ul>
<p>Ta modul zna uvoziti vprašanja shranjena v zbirki testov Course Test Manager. Sloni na raznih načinih dostopa do baze testov, ki je v podatkovni zbirki Microsoft Access, odvisno od tega ali Moodle teče v okolju Windows ali Linux.</p>
<p>V okolju Windows vam omogoča nalaganje podatkovne zbirke Access tako kot katerekoli druge datoteke s podatki za uvoz.</p>
<p>V okolju Linux morate vzpostaviti Windows računalnik v istem omrežju kot je podatkovna zbirka Course Test Manager in programsko opremo z imenom ODBC Socket Server, ki uporablja XML za prenos podatkov v Moodle na strežniku Linux.</p>

<p>Prosimo, preberite celotno spodnjo datoteko s pomočjo preden uporabite ta razred za uvoz.</p>

<p align="right"><a href="help.php?file=formatctm.html&module=quiz">Več informacij o zapisu &quot;CTM&quot;</a></p>
</ul>

<h2>Po meri</h2>
<ul>
<p>Če imate lasten format, ki ga morate uvoziti, ga lahko izvedete sami z urejanjem mod/quiz/format/custom.php</p>

<p>Potrebna količina nove kode je majhna - samo toliko, da izluščite samo vprašanje iz podanega besedila.</p>

<p align="right"><a href="help.php?file=formatcustom.html&module=quiz">Več informacij o formatu &quot;Po meri&quot;</a></p>
</ul>

<p>Več zapisov bo še sledilo, vključno z WebCT, IMS QTI in karkoli drugega bodo lahko prispevali uporabniki Moodle! </p>';
$string['insertedpage'] = 'Vstavljena stran';
$string['invalidfile'] = 'Nepravilna datoteka';
$string['invalidid'] = 'ID predmetnega modula ali ID lekcije ni bil sprejet';
$string['invalidlessonid'] = 'ID lekcije je napačen';
$string['invalidpageid'] = 'Nepravilni Id strani';
$string['jump'] = 'Skok';
$string['jumps'] = 'Skoki';
$string['jumps_help'] = '<p>Vsak odgovor (za vprašanja) ali opis (za strani vej) ima povezavo za skok. Ko je izbran ta odgovor, je odziv na ta odgovor prikazan udeležencu. Po tem udeleženec vidi stran podano v povezavi za skok. Ta povezava je lahko bodisi relativna ali absolutna. Relativni povezavi sta <b>Ta stran</b> in <b>Naslednja stran</b>. <b>Ta stran</b> pomeni, da udeleženec ponovno vidi trenutno stran. <b>Naslednja stran</b> prikaže stran, ki sledi tej strani v logičnem zaporedju strani. Absolutna povezava strani je določena z izborom <b>imena</b> strani.</p>
<p>Vedite, da (relativna) povezava za skok <b>Naslednja stran</b> lahko prikaže drugo stran, če so bile strani premaknjene. Nasprotno povezave za skok, ki uporabljajo <b>imena</b> strani, vedno prikažejo isto stran tudi, če so bile strani premaknjene.</p>
<p>Posebni skoki</p>
<p>Še ne videno vprašanje v okviru veje</p>
<p>To bo ustvarilo povezavo z naključno izbranim še ne videnim (s strani udeleženca v tem poskusu) vprašanjem v tej tabeli razvejanja in koncem lekcije ali naslednjim koncem veje.</p>

<p>Naključno vprašanje v okviru veje</p>
<p>To bo ustvarilo povezavo na naključno izbrano vprašanje med trenutno tabelo razvejanja in koncem lekcije ali naslednjim koncem veje. Če je udeleženec že videl vprašanje in je število poskusov večje od 1, bo imel novo možnost, da zasluži točke za to vprašanje. Če so poskusi nastavljeni na 1 bo vprašanje preskočeno in bo prikazano naslednje naključno vprašanje.</p>

<p>Naključna tabela razvejanja</p>
<p>To bo skočilo na naključno tabelo razvejanja med trenutno tabelo razvejanja in koncem lekcije ali naslednjim koncem veje.</p>';
$string['jumpsto'] = 'Skoki na <em>{$a}</em>';
$string['leftduringtimed'] = 'Časovno merjeno lekcijo ste zapustili.<br />Prosimo, kliknite Nadaljuj za ponovni začetek lekcije.';
$string['leftduringtimednoretake'] = 'Časovno merjeno lekcijo ste zapustili in ne smete<br />ponoviti ali nadaljevati lekcije.';
$string['lesson:addinstance'] = 'Dodaj novo lekcijo';
$string['lessonattempted'] = 'Lekcija je bila opravljena';
$string['lessonclosed'] = 'Ta lekcija je bila zaprta v {$a}.';
$string['lessoncloses'] = 'Lekcija se zapre';
$string['lessoncloseson'] = 'Lekcija se zapre v {$a}';
$string['lesson:edit'] = 'Urejanje dejavnosti lekcije';
$string['lessonformating'] = 'Oblikovanje lekcije';
$string['lesson:manage'] = 'Upravljanje dejavnosti lekcije';
$string['lessonmenu'] = 'Meni lekcije';
$string['lessonnotready'] = 'Ta lekcija še ni pripravljena za poskus. Za pomoč povprašajte vašega {$a}.';
$string['lessonnotready2'] = 'Ta lekcija ni pripravljena da jo sprejmete.';
$string['lessonopen'] = 'Ta lekcija bo odprta v {$a}.';
$string['lessonopens'] = 'Lekcija se odpre';
$string['lessonpagelinkingbroken'] = 'Prve strani ni možno najti. Povezovanje strani lekcije je kot kaže poškodovano.  Obrnite se na skrbnika.';
$string['lessonstats'] = 'Statistika lekcije';
$string['linkedmedia'] = 'Povezane medijske vsebine';
$string['loginfail'] = 'Spodletela prijava, prosimo, poskusite znova...';
$string['lowscore'] = 'Nizek rezultat';
$string['lowtime'] = 'Nizek čas';
$string['manualgrading'] = 'Oceni eseje';
$string['matchesanswer'] = 'Se ujema z odgovorom';
$string['matching'] = 'Ujemanje';
$string['matchingpair'] = 'Ujemajoči par {$a}';
$string['maxgrade'] = 'Najvišja ocena';
$string['maxgrade_help'] = '<p>Ta vrednost določa najvišjo oceno, ki je lahko dodeljena v lekciji. Obseg je od 0 do 100 %. To vrednost lahko spremenite kadarkoli med lekcijo. Vsaka sprememba ima neposreden učinek na strani ocen in na udeležencem prikazanih ocenah na raznih seznamih. Če je ocena nastavljena na 0 se lekcija ne pojavi na nobeni strani ocen.</p>';
$string['maxhighscores'] = 'Število prikazanih najboljših rezultatov';
$string['maximumnumberofanswersbranches'] = 'Največje število odgovorov / vej';
$string['maximumnumberofanswersbranches_help'] = '<p>Ta vrednost določa največje število odgovorov, ki jih lahko uporabi izvajalec. Privzeta vrednost je 4. Če recimo lekcija uporablja samo vprašanja DRŽI ali NE DRŽI je pametno nastaviti to vrednost na 2.</p>

<p>Ta parameter tudi nastavi največje število vej, ki jih lahko uporabite v tabeli razvejanja.</p>

<p>Spremeniti vrednost tega parametra v lekciji z obstoječo vsebino je varno. Dejansko bo potrebno spremeniti ta parameter, če boste želeli dodati vprašanje z mnogimi možnimi odgovori ali dolgo tabelo razvejanja. Ko dodate tako (nenavadno) vprašanje ali tabelo razvejanja lahko ta parameter zmanjšate na bolj "standardno" vrednost.</p>';
$string['maximumnumberofattempts'] = 'Največje število poskusov';
$string['maximumnumberofattempts_help'] = '<p>Ta vrednost določa največje število poskusov, ki jih lahko udeleženec opravi z odgovarjanje na <b>vsa</b> vprašanja v lekciji. V primeru vprašanj, ki ne nudijo odgovora, na primer Kratek odgovor in Številčna vprašanja, ta vrednost ponuja potrebno <i>ubežno rutino</i> na naslednjo stran v lekciji. </p>

<p>Privzeta vrednost je 5. Manjše vrednosti lahko odvrnejo udeleženca od razmišljanja o vprašanjih. Večje število lahko pripelje do večjega razočaranja.</p>

<p>Nastavitev te vrednosti na ena, ponudi udeležencu samo eno možnost za odgovor na vsako vprašanje. To pripelje do podobne vrste naloge kot je modul kviza, s to razliko, da so vprašanja predstavljena na posameznih straneh.</p>

<p>Vedite, da je ta vrednost globalni parameter in vpliva na vsa vprašanja v lekciji ne glede na njihovo vrsto.</p>

<p>Vedite, da ta parameter <b>ne</b> velja za izvajalce, ko preverjajo vprašanja ali navigacijo skozi lekcijo. Preverjanje števila poskusov temelji na vrednostih shranjenih v podatkovni zbirki in poskusi odgovorov izvajalca se ne beležijo. Izvajalec bi konec koncev moral poznati odgovore!</p>';
$string['maximumnumberofattemptsreached'] = 'Doseženo največje dovoljeno število poskusov - premikanje na naslednjo stran';
$string['maxtime'] = 'Časovna omejitev (minute)';
$string['maxtimewarning'] = 'Imate {$a} minut za dokončanje lekcije.';
$string['mediaclose'] = 'Prikaži gumb zapiranja:';
$string['mediafile'] = 'Pojavno v datoteko ali spletno stran';
$string['mediafile_help'] = '<p>To bo ustvarilo pojavno okno na začetku lekcije za datoteko (na primer: datoteka MP3) ali spletno stran. Dodatno bo na vsaki strani lekcije prikazana povezava, ki ponovno odpre pojavno okno, če je to potrebno.</p>

<p>Dodatno se na dnu pojavnega okna lahko prikaže gumb "Zapri okno" za katerega je možno nastaviti višino in širino.</p>

<p>Podprte vdelane (embedded) vrste datotek:</p>
    <ul>
        <li>MP3</li>
        <li>Media Player</li>
        <li>Quicktime</li>
        <li>Realmedia</li>
        <li>HTML</li>
        <li>Plain Text</li>
        <li>GIF</li>
        <li>JPEG</li>
        <li>PNG</li>
    </ul>
<p>Vse ostale vrste datotek bodo privzeto postale povezave, ki uporabnikom omogočajo prenos.</p>';
$string['mediafilepopup'] = 'Kliknite tukaj za ogled';
$string['mediaheight'] = 'Višina okna:';
$string['mediawidth'] = 'širina:';
$string['messageprovider:graded_essay'] = 'Obvestilo o ocenjenem eseju';
$string['minimumnumberofquestions'] = 'Najmanjše število vprašanj';
$string['minimumnumberofquestions_help'] = '<p>Ko lekcija vsebuje eno ali več tabel razvejanja, mora ponavadi izvajalec nastaviti ta parameter. Njegova vrednost nastavi najnižjo omejitev števila videnih vprašanj ob izračunu ocene. To <b>ne</b> prisili udeležencev, da bi odgovorili na toliko vprašanj v lekciji.</p>

<p>Z nastavitvijo tega parametra na - recimo - 20, bo zagotovilo, da se dodelijo ocene, kot da bi udeleženci videli <b>vsaj</b> toliko vprašanj. Vzemimo za primer udeleženca, ki si ogleda samo eno vejo v lekciji s petimi stranmi in odgovori na vsa povezana vprašanja pravilno. Nato se udeleženec odloči in konča lekcijo (predvidevamo, da ta možnost obstaja na "vrhnji ravni" tabele razvejanja, kar je razumno predvidevanje). Če bi ta parameter pustili nenastavljen, bi ocena udeleženca bila 5 od 5, kar je 100 odstotkov. Če pa je ta parameter nastavljen na 20, bi bila njegova ocena zmanjšana na 5 od 20, kar predstavlja 25 odstotkov. V primeru drugega udeleženca, ki obišče vse veje in vidi recimo 25 strani in odgovori na vsa vprašanja razen dveh pravilno, bo njegova ocena 23 od 25, kar pomeni 92 odstotkov.</p>

<p>Če je ta parameter uporabljen, naj otvoritvena stran lekcije sporoča nekaj podobnega:</p>

<p><blockquote>V tej lekciji se pričakuje, da boste poskusili odgovoriti vsaj na n vprašanj. Poskusite lahko tudi več, če tako želite. Če boste odgovorili na manj kot n vprašanj, bo vaša ocena izračunana, kot da bi odgovorili na n vprašanj.</blockquote></p>

<p>Kjer seveda "n" zamenjate z dejansko vrednostjo tega parametra, kakor ste ga nastavili.</p>

<p>Ko je ta parameter nastavljen, so udeleženci obveščeni o tem, na koliko vprašanj so odgovorili in koliko odgovorov je pričakovanih.</p>';
$string['missingname'] = 'Prosimo vpišite vzdevek';
$string['modattempts'] = 'Dovoli pregled udeležencev';
$string['modattempts_help'] = '<p>To bo omogočilo, da se udeleženci premikajo po lekciji nazaj in spremenijo svoje odgovore.</p>';
$string['modattemptsnoteacher'] = 'Pregled udeležencev deluje samo za udeležence.';
$string['modulename'] = 'Lekcija';
$string['modulename_help'] = '<p><img alt="" src="<?php echo $CFG->wwwroot?>/mod/lesson/icon.gif" /> <b>Lekcija</b></p>

<div class="indent">
Lekcija ponuja vsebino na zanimiv in prilagodljiv način. Sestavljena je iz vrste strani. Vsaka stran se običajno konča z raznovrstnimi vprašanji (več izbir, kratki odgovori ...). Glede na udeleženčev izbor odgovora lahko bodisi napreduje na naslednjo stran ali se vrne na prejšnjo stran. Navigacija prek lekcije je lahko preprosta ali kompleksna, odvisno od strukture predstavljenega gradiva.
</div>

Lekcija se lahko ocenjuje, ocena pa se beleži v redovalnici.

Lekcijo lahko uporabite za:

* samostojno učenje novih vsebin

* študijo primera oz. različnih scenarijev in vaje za simulacijo odločitev';
$string['modulenameplural'] = 'Lekcije';
$string['move'] = 'Premakni stran';
$string['movedpage'] = 'Premaknjena stran';
$string['movepagehere'] = 'Premakni stran sem';
$string['moving'] = 'Premikanje strani: {$a}';
$string['multianswer'] = 'Več odgovorov';
$string['multianswer_help'] = '<p>Nekatere vrste vprašanj imajo možnosti, ki se vključijo z označbo ustreznega potrditvenega polja. Vrste vprašanj in pomen možnosti so pojasnjeni spodaj.</p>

<ol>
<li><p><b>Več izbir</b> Obstaja različica vprašanj z večimi izbirami, ki se imenuje <b>"Več izbir več odgovorov"</b>. Če je izbrana ta možnost vprašanja, potem mora udeleženec izbrati vse pravilne odgovore iz nabora odgovorov. Vprašanje lahko, ali pa tudi ne, pove udeležencu, <i>koliko</i> je pravilnih odgovorov . Vprašanje "Kdo izmed naslednjih oseb je bil predsednik Slovenije?" na primer tega ne pove, vprašanje "Izberite dva predsednika Slovenije iz seznama", pa to pove. Dejansko število pravilnih odgovorov je lahko od <b>ena</b> in vse do števila možnosti. (Vprašanje z večimi izbirami in večimi odgovori ter enim pravilnim odgovorom <b>je</b> drugačno od vprašanja z večimi izbirami, saj prvi omogoča izbor več kot enega odgovora, medtem ko drugi tega ne omogoča.)</p></li>

<li>
  <p><b>Kratek odgovor</b> Obstajata dva različna sistema primerjave, ki sta na voljo za vrsto vprašanja kratek odgovor: privzeto je uporabljen enostaven sistem, sistem "Regularni izraz" je uporabljen, če je označeno polje "Uporabi regularni izraz".  Za več informacij, preberite datoteko pomoči o vrstah vprašanj lekcije.</p>
</li>
</ol>
<p>Druge vrste vprašanj ne uporabljajo možnosti vprašanja.</p>';
$string['multichoice'] = 'Več izbr';
$string['multipleanswer'] = 'Več odgovorov';
$string['nameapproved'] = 'Ime odobreno';
$string['namereject'] = 'Oprostite, vaše ime je zavrnil filter.<br />Prosimo, poskusite z drugim imenom.';
$string['new'] = 'novo';
$string['nextpage'] = 'Naslednja stran';
$string['noanswer'] = 'Ni podanega odgovora.  Prosimo, vrnite se in oddajte odgovor.';
$string['noattemptrecordsfound'] = 'Ni najdenih zapisov o poskusu: ni podeljene ocene';
$string['nobranchtablefound'] = 'Ni najdenih tabel razvejanja';
$string['nocommentyet'] = 'Še brez komentarja.';
$string['nocoursemods'] = 'Ni najdenih dejavnosti';
$string['nocredit'] = 'Brez točk';
$string['nodeadline'] = 'Brez roka';
$string['noessayquestionsfound'] = 'V tej lekciji ni najdenih esejskih vprašanj.';
$string['nohighscores'] = 'Ni najboljših rezultatov';
$string['nolessonattempts'] = 'Za to lekcijo še ni bilo opravljenega poskusa.';
$string['nooneansweredcorrectly'] = 'Nihče ni odgovoril pravilno.';
$string['nooneansweredthisquestion'] = 'Nihče ni odgovoril na to vprašanje.';
$string['noonecheckedthis'] = 'Nihče ni označil tega.';
$string['nooneenteredthis'] = 'Nihče ni vnesel tega.';
$string['noonehasanswered'] = 'Na esejska vprašanja še nihče ni odgovoril.';
$string['noretake'] = 'Te lekcije ne smete ponoviti.';
$string['normal'] = 'Navadno - sledi poti lekcije';
$string['notcompleted'] = 'Ni dokončano';
$string['notdefined'] = 'Ni definirano';
$string['nothighscore'] = 'Ni vam uspelo priti na seznam {$a} najboljših rezultatov.';
$string['notitle'] = 'Brez naslova';
$string['numberofcorrectanswers'] = 'Število pravilnih odgovorov: {$a}';
$string['numberofcorrectmatches'] = 'Število pravilnih ujemanj: {$a}';
$string['numberofpagestoshow'] = 'Število strani (kartic) za prikaz';
$string['numberofpagestoshow_help'] = '<p>Ta parameter je uporabljen samo v vrsti lekcije opomnih kartic. Privzeta vrednost je nič, kar pomeni, da se vse strani / kartice prikažejo v lekciji. Nastavitev tega parametra na vrednost, ki ni nič, povzroči prikaz samo toliko strani. Ko se prikaže določeno število strani / kartic, je lekcija zaključena in udeležencu je prikazana njegova ocena.</p>

<p>Če je parameter nastavljen na število, ki je večje od števila strani, je lekcija zaključena, ko so prikazane vse strani.</p>';
$string['numberofpagesviewed'] = 'Število odgovorjenih vprašanj: {$a}';
$string['numberofpagesviewednotice'] = 'Število odgovorjenih vprašanj: {$a->nquestions}; (Odgovoriti bi morali najmanj na {$a->minquestions} vprašanj)';
$string['numerical'] = 'Numerična';
$string['ongoing'] = 'Prikaz trenutnega rezultata';
$string['ongoingcustom'] = 'Do sedaj ste osvojili {$a->score} točk od {$a->currenthigh}.';
$string['ongoing_help'] = '<p>S to možnostjo vključeno, bo vsaka stran prikazala trenutno dosežene točke udeleženca od vseh do zdaj možnih. Primer:  udeleženec je odgovoril na štiri vprašanja za 5 točk in od tega je na eno vprašanje odgovoril napačno. Trenuten rezultat bi prikazal trenutno doseženih 15/20 točk.</p>';
$string['ongoingnormal'] = 'Pravilno ste odgovorili v {$a->correct} od {$a->viewed} poskusov.';
$string['onpostperpage'] = 'Samo ena objava na oceno';
$string['options'] = 'Možnosti';
$string['or'] = 'ALI';
$string['ordered'] = 'Razporejeno';
$string['other'] = 'Drugo';
$string['outof'] = 'Izmed {$a}';
$string['overview'] = 'Pregled';
$string['overview_help'] = '<ol>
<li>Lekcija je sestavljena iz vrste <b>strani</b> in dodatno <b>tabel razvejanja</b>.</li>
<li>Stran vsebuje nekaj <b>vsebine</b> in se običajno konča z <b>vprašanjem</b>. Od tu izvira izraz <b>Stran vprašanja</b>.</li>
<li>Za vprašanja spisa, ni odgovora, samo rezultat, povratna informacija in skok na stran.</li>
<li>Vsak odgovor ima lahko kratek del besedila, ki se prikaže, če je izbran odgovor. Ta del besedila se imenuje <b>odziv</b>.</li>
<li>Z vsakim odgovorom je povezan tudi <b>skok</b>. Skok je lahko relativen - ta stran, naslednja stran - ali absoluten - določen s poljubno stranjo v lekciji ali konec lekcije.</li>
<li>Kot privzeto prvi odgovor skoči na <b>naslednjo stran</b> v lekciji. Naslednji odgovori skočijo na isto stran. To pomeni, da se udeležencu ponovno prikaže ista stran, če ne izberejo prvega odgovora. Če ste že ustvarili gručo s koncem gruče in v njej vprašanje, lahko izberete tudi skok na še ne videno vprašanje v okviru gruče. Ta možnost ne bo prikazana, če niste v gruči. Niz vprašanj lahko vedno obdate z gručo in koncem gruče.</li>
<li>Naslednja stran se določi z <b>logičnim vrstnim redom</b> lekcije. To je vrstni red strani kot ga vidi izvajalec. Ta vrstni red je možno spremeniti s premikanjem strani v lekciji.</li>
<li>Lekcija ima tudi <b>vrstni red navigacije</b>. To je vrstni red strani kot ga vidi udeleženec. Tega določajo skoki določeni za posamezne odgovore in je lahko zelo drugačen od logičnega vrstnega reda. (Čeprav sta oba tesno povezana, če skokom <i>niso</i> spremenjene njihove privzete vrednosti.) Izvajalec lahko preveri vrstni red navigacije.</li>
<li>Ko so prikazani udeležencem so odgovori po navadi premešani. To pomeni, da prvi odgovor z vidika izvajalca ne bo nujno prvi odgovor na seznamu odgovorov prikazanem udeležencu. (Dodatno bo vrstni red prikazanih odgovorov verjetno z vsakim prikazom drugačen.) Izjema je nabor odgovorov za vprašanja ujemanja, kjer so odgovori prikazani v istem vrstnem redu, kot jih je vnesel izvajalec. </li>
<li>število odgovorov je lahko različno od strani do strani. Tako se lahko na primer nekatere strani zaključijo z vprašanjem drži/ne drži, medtem ko lahko druge strani vsebujejo vprašanje z enim pravilnim in tremi zavajajočimi odgovori. </li>
<li>Možno je nastaviti stran brez odgovorov. Udeležencu se prikaže povezava <b>Nadaljuj</b> namesto nabora premešanih odgovorov.</li>
<li>Če je točkovanje po meri izključeno: za namen ocenjevanja lekcij vodijo <b>pravilni</b> odgovori do skoka na stran, ki je <i>naslednja</i> v logičnem vrstnem redu glede na trenutno stran. <b>Napačni</b> odgovori so tisti, ki bodisi skočijo na isto stran ali na <i>prejšnjo</i> stran v logičnem vrstnem redu glede na trenutno stran. Tako, če skoki <i>niso</i> spremenjeni, je prvi odgovor pravilen in drugi odgovori so napačni odgovori. <br /><br /> Če je točkovanje po meri vključeno: ocenjevanje odgovorov je določeno z vrednostjo v točkah za odgovor, skupno število osvojenih točk vprašanja služi kot del skupne vrednosti točk za lekcijo - do 100 %.</li>
<li>Vprašanja imajo lahko več kot en pravilen odgovor. Če na primer dva odgovora vodita na naslednjo stran, se oba odgovora štejeta kot pravilna odgovora. (Čeprav je prikazana udeležencem ista ciljna stran so prikazani odzivi na poti do te strani lahko različni za ta dva odgovora.)
<li>V pogledu izvajalca v lekciji so pri pravilnih odgovorih podčrtane oznake odgovora.</li>
<li><b>Tabele razvejanja</b> so preprosto strani, ki imajo mnogo povezav na druge strani v lekciji. Tipično se lahko lekcija prične s tabelo razvejanja, ki deluje kot <b>Kazalo vsebine</b>.</li>
<li>Vsaka povezava v tabeli razvejanja ima dve komponenti - opis in ime strani na katero naj bo opravljen skok.</li>
<li>Tabela razvejanja v praksi ločuje lekcijo v vrsto <b>vej</b> (ali odsekov). Vsaka veja lahko vsebuje vrsto strani (po možnosti vseh povezanih z istim poglavjem). Konec veje je po navadi označen s stranjo <b>Konec veje</b>. To je posebna stran, ki privzeto vrne udeleženca na predhodno tabelo razvejanja. (Skok &quot;nazaj&quot; na strani konca veje je možno spremeniti, če je tako potrebno z urejanjem strani.) </li>
<li>V lekciji je lahko več kot ena tabela razvejanja. Lekcija je lahko na primer uporabno strukturirana tako, da so podrobnejša pojasnila podveje v okviru vej glavnega predmeta.</li>
<li>Pomembno je dati udeležencem možnost končanja lekcije. To je možno doseči z vključitvijo povezave &quot;Konec lekcije&quot; v glavni tabeli razvejanja. To povzroči skok na (navidezno) stran <b>Konec lekcije</b>. Druga možnost je, da se zadnja veja v lekciji (tu je &quot;zadnja&quot; mišljena v smislu logičnega vrstnega reda lekcije) preprosto nadaljuje v konec lekcije, kar pomeni da <i>ni</i> zaključena s stranjo Konec veje.</li>
<li>Ob izključenem točkovanju po meri, je priporočljivo nastaviti parameter &quot;Najmanjše število odgovorov&quot; na razumno vrednost, če lekcija vključuje eno ali več tabel razvejanja. To določi spodnjo mejo števila videnih strani, ko se izračuna ocena. Brez tega parametra bi lahko udeleženec obiskal samo eno vejo v lekciji, odgovoril vsa vprašanja pravilni in zapustil lekcijo z najboljšo možno oceno. <br /><br /> Ob vključenem točkovanju po meri, je udeleženec ocenjen na osnovi števila točk, ki jih je osvojil, kot odstotek od skupnega števila točk v lekciji.</li>
<li>Dodatno ima udeleženec ob izključenem točkovanju po meri možnost večkratnega ponovnega obiska iste veje, če obstajajo tabele razvejanja. Kljub temu je ocena izračunana ob uporabi števila odgovorjenih <i>enoličnih</i> vprašanj. Tako ponovno odgovarjanje na isti nabor vprašanj <i>ne</i> povečuje ocene. (Dejansko drži obratno in zmanjšuje oceno, saj je število videnih strani uporabljeno kot imenovalec, ko računanje ocen vključuje ponavljanja.) Da bi imeli udeleženci dober občutek o svojem napredovanju v lekciji, se jim na vsaki strani tabele razvejanja prikazujejo podrobnosti o tem, na koliko vprašanj so odgovorili pravilno, številu videnih strani in njihovi trenutni oceni. <br /> <br /> Z vključenim točkovanjem po meri lahko udeleženec ponovno obišče vprašanje, če navigacijska pot to dovoljuje in ponovno osvoji točke za to vprašanje, če je število poskusov nastavljeno na več kot 1. Da bi to preprečili, nastavite število poskusov na 1.</li>
<li><b>Konec lekcije</b> je dosežen bodisi z izrecnim skokom na to lokacijo ali s skokom z zadnje (logične) strani lekcije na naslednjo stran. Ob izključenem točkovanjem po meri prejme udeleženec ob doseženem koncu lekcije sporočilo s čestitko in se mu prikaže njegova ocena. Ocena je (število pravilno odgovorjenih vprašanj / število videnih strani) * ocena lekcije. Ob vključenem točkovanju po meri je ocena število doseženih točk kot odstotek vseh točk (npr. 3 osvojene točke od 3 točk v lekciji = 100 odstotkov od 3 točk).</li>
<li>Če konec lekcije <i>ni</i> dosežen in udeleženec samo zapusti lekcijo, je udeležencu ob ponovnem vstopu v lekcijo ponujena možnost ponovnega začetka lekcije od začetka ali nadaljevanje lekcije pri zadnjem pravilno odgovorjenem vprašanju.</li>
<li>Za lekcije, ki omogočajo ponovitve, ima izvajalec možnost uporabe najboljših ali povprečnih ocen za &quot;končno&quot; oceno lekcije. Ta ocena je na primer prikazana na strani ocen.</li>
<li>Strani gruč: gruča predstavlja nabor vprašanj izmed katerih je lahko naključno izbrano eno ali več vprašanj. Gruče se morajo za najboljše rezultate zaključiti s stranjo Konec gruče (sicer se za konec gruče šteje konec lekcije). Vprašanja v gruči se naključno izberejo z izborom skoka &quot;Naključno vprašanje iz gruče&quot;. Vprašanja v gruči so lahko povezana bodisi s koncem gruče za izhod iz gruče, skokom na še ne videno vprašanje v gruči ali skokom na poljubno stran v lekciji. To tudi omogoča ustvarjanje scenarijev z naključnimi elementi z uporabo modula lekcije.</li>
</ol>';
$string['page'] = 'Stran: {$a}';
$string['pagecontents'] = 'Vsebina strani';
$string['page-mod-lesson-edit'] = 'Uredi stran lekcije';
$string['page-mod-lesson-view'] = 'Prikaži stran lekcije';
$string['page-mod-lesson-x'] = 'Vsaka stran lekcije';
$string['pages'] = 'Strani';
$string['pagetitle'] = 'Naslov strani';
$string['password'] = 'Geslo';
$string['passwordprotectedlesson'] = '{$a} je lekcija zaščitena z geslom.';
$string['pleasecheckoneanswer'] = 'Prosimo, označite en odgovor';
$string['pleasecheckoneormoreanswers'] = 'Prosimo, označite en ali več odgovorov';
$string['pleaseenteryouranswerinthebox'] = 'Prosimo, vnesite svoj odgovor v polje';
$string['pleasematchtheabovepairs'] = 'Prosimo, povežite zgornje pare';
$string['pluginadministration'] = 'Administracija lekcij';
$string['pluginname'] = 'Lekcija';
$string['pointsearned'] = 'Zaslužene točke';
$string['postprocesserror'] = 'Po obdelavi je prišlo do napake!';
$string['postsuccess'] = 'Oddaja uspešna';
$string['practice'] = 'Vaja lekcije';
$string['practice_help'] = '<p>Vaja lekcije se ne bo prikazala v redovalnici.</p>';
$string['preprocesserror'] = 'Pred obdelavo je prišlo do napake!';
$string['preview'] = 'Predogled';
$string['previewlesson'] = 'Predogled {$a}';
$string['previouspage'] = 'Prejšnja stran';
$string['processerror'] = 'Med obdelavo je prišlo do napake!';
$string['progressbar'] = 'Kazalo napredovanja';
$string['progressbar_help'] = '<p>Prikaže vrstico napredovanja na dnu lekcije. Trenutno je vrstica napredovanja najbolj točna v zveznih lekcijah.</p>
<p>Ob izračunavanju odstotka dokončane lekcije, se za napredek lekcije štejejo razvejitvene tabele in strani vprašanj, ki so pravilno odgovorjene. Ob izračunu skupnega števila strani v lekciji, se gruče in strani v gručah štejejo kot posamezna stran, konec gruče ter stran konca razvejitvene tabele pa sta izključeni. Vse druge strani štejejo v skupno število strani v lekciji.</p>
<p>Opomba: privzeti slogi vrstičnega kazala napredka niso navdušujoči ;)  Vsi slogi (npr.: barva, slika ozadja in podobno) za kazalo napredovanja se lahko spremenijo v datoteki mod/lesson/styles.php.';
$string['progressbarteacherwarning'] = 'Kazalo napredovanja se ne prikazuje za {$a}';
$string['progressbarteacherwarning2'] = 'Ker lahko urejate to lekcijo, ne boste videli vrstice napredovanja';
$string['progresscompleted'] = 'Predelali ste {$a}% lekcije';
$string['qtype'] = 'Vrsta strani';
$string['question'] = 'Vprašanje';
$string['questionoption'] = 'Vprašanje';
$string['questiontype'] = 'Vrsta vprašanja';
$string['randombranch'] = 'Naključna veja strani';
$string['randompageinbranch'] = 'Naključno vprašanje v okviru veje';
$string['rank'] = 'Razvrstitev';
$string['rawgrade'] = 'Vmesna ocena';
$string['receivedcredit'] = 'Prejete točke';
$string['redisplaypage'] = 'Ponovno prikaži stran';
$string['report'] = 'Poročilo';
$string['reports'] = 'Poročila';
$string['response'] = 'Odziv';
$string['retakesallowed'] = 'Dovoljeni ponavljalci';
$string['retakesallowed_help'] = '<p>Ta nastavitev določa ali lahko udeleženci lekcijo ponovijo ali jo lahko obiščejo samo enkrat. Izvajalec se lahko odloči, da lekcija vsebuje vsebino, ki bi jo morali udeleženci temeljito poznati. V tem primeru bi moral biti ponoven ogled lekcije dovoljen. Če je gradivo uporabljeno bolj kot izpit, potem udeležencem ne bi smelo biti dovoljeno ponavljanje lekcije.</p>

<p>Ko je udeležencem dovoljeno ponavljanje lekcije, so <b>ocene</b> prikazane na strani ocen lahko bodisi njihovo <b>povprečje</b> ocen za vse poskuse ali njihova <b>najboljša</b> ocena za lekcijo. Naslednji parameter določa katera izmed teh dveh alternativ ocenjevanja se uporabi.</p>

<p>Vedite, da <b>Analiza vprašanj</b> vedno uporabi odgovore prvih poskusov lekcije, naslednji poskusi udeležencev so prezrti.</p>

<p>Kot privzeto je ta možnost nastavljena na <b>Da</b>, kar pomeni, da udeleženci smejo ponavljati lekcijo. Pričakovati je, da bo ta možnost samo v izjemnih okoliščinah nastavljena na <b>Ne</b>.</p>';
$string['returnto'] = 'Vrni se na {$a}';
$string['returntocourse'] = 'Vrnitev v predmet';
$string['review'] = 'Pregled';
$string['reviewlesson'] = 'Pregled lekcije';
$string['reviewquestionback'] = 'Da, želim poskusiti znova';
$string['reviewquestioncontinue'] = 'Ne, želim nadaljevati z naslednjim vprašanjem';
$string['sanitycheckfailed'] = 'Spodletelo preverjanje smiselnosti: Ta poskus je bil izbrisan';
$string['savechanges'] = 'Shrani spremembe';
$string['savechangesandeol'] = 'Shrani vse spremembe in pojdi na konec lekcije.';
$string['savepage'] = 'Shrani stran';
$string['score'] = 'Rezultat';
$string['scores'] = 'Rezultati';
$string['secondpluswrong'] = 'Ne povsem. Bi želeli poskusiti znova?';
$string['selectaqtype'] = 'Izberi vrsto vprašanja';
$string['shortanswer'] = 'Kratek odgovor';
$string['showanunansweredpage'] = 'Prikaži še ne odgovorjeno stran';
$string['showanunseenpage'] = 'Prikaži še ne videno stran';
$string['singleanswer'] = 'En odgovor';
$string['skip'] = 'Preskoči navigacijo';
$string['slideshow'] = 'Diaprojekcija';
$string['slideshowbgcolor'] = 'Barva ozadja diaprojekcije';
$string['slideshowheight'] = 'Višina diaprojekcije';
$string['slideshow_help'] = '<p>To omogoča prikaz lekcije kot diaprojekcije, z določeno širino, višino in barvo ozadja po meri. Če širina ali višina diapozitiva presega vsebino strani, bo prikazan drsnik na osnovi CSS. Vprašanja bodo "pobegnila" iz načina prikaza diaprojekcije, kot privzeto bodo prikazane v diaprojekciji samo strani (tabele razvejanja). Gumbi označeni z jezikovno privzetimi oznakami "Naprej" in "Nazaj" bodo prikazani na skrajni desnem in levi stani diapozitiva, če je ta možnost izbrana na strani. Ostali gumbi bodo postavljeni sredinsko pod diapozitivom.</p>';
$string['slideshowwidth'] = 'Širina diaprojekcije';
$string['startlesson'] = 'Začni lekcijo';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} poskus številka {$a->attempt}';
$string['studentname'] = '{$a} Ime';
$string['studentoneminwarning'] = 'Opozorilo: Imate 1 minuto ali manj za zaključek lekcije.';
$string['studentresponse'] = 'Odgovor {$a}';
$string['submit'] = 'Oddaj';
$string['submitname'] = 'Oddaj ime';
$string['teacherjumpwarning'] = 'V tej lekciji je uporabljen skok {$a->cluster} ali {$a->unseen}.  Namesto tega bo uporabljen skok na naslednjo stran.  Prijavite se kot udeleženec za preizkus teh skokov.';
$string['teacherongoingwarning'] = 'Trenutni rezultat je prikazan samo udeležencem. Prijavite se kot udeleženec za preizkus prikaza trenutnega rezultata';
$string['teachertimerwarning'] = 'Merilec časa deluje samo za udeležence.  Preizkusite merilec časa s prijavo kot udeleženec.';
$string['thatsthecorrectanswer'] = 'To je pravilen odgovor';
$string['thatsthewronganswer'] = 'To je napačen odgovor';
$string['thefollowingpagesjumptothispage'] = 'Naslednje strani skočijo na to stran';
$string['thispage'] = 'Ta stran';
$string['timeremaining'] = 'Preostali čas';
$string['timespenterror'] = 'Porabi vsaj {$a} minut za lekcijo';
$string['timespentminutes'] = 'Porabljen čas (minute)';
$string['timetaken'] = 'Porabljeni čas';
$string['topscorestitle'] = 'Prvih {$a} najboljših rezultatov';
$string['truefalse'] = 'resnično/neresnično';
$string['unknownqtypesnotimported'] = '{$a} vprašanja z nepodprtimi vprašalnimi vrstami niso bila uvožena';
$string['unseenpageinbranch'] = 'Še ne videno vprašanje v okviru veje';
$string['unsupportedqtype'] = 'Nepodprta vrsta vprašanja ({$a})!';
$string['updatedpage'] = 'Posodobljena stran';
$string['updatefailed'] = 'Posodobitev spodletela';
$string['usemaximum'] = 'Uporabi največ';
$string['usemean'] = 'Uporabi srednje';
$string['usepassword'] = 'Lekcija zaščitena z geslom';
$string['usepassword_help'] = '<p>To bo udeležencem onemogočilo dostop do lekcije, dokler ne vnesejo gesla.</p>';
$string['viewgrades'] = 'Ogled ocen';
$string['viewhighscores'] = 'Ogled seznama najboljših rezultatov';
$string['viewreports'] = 'Ogled {$a->attempts} zaključenih poskusov ({$a->student})';
$string['viewreports2'] = 'Ogled {$a} končanih poskusov';
$string['welldone'] = 'Dobro narejeno!';
$string['whatdofirst'] = 'Kaj bi želeli narediti najprej?';
$string['wronganswerjump'] = 'Napačen skok odgovora';
$string['wronganswerscore'] = 'Napačne točke odgovora';
$string['wrongresponse'] = 'Napačen odziv';
$string['xattempts'] = '{$a} poskusov';
$string['youhaveseen'] = 'Za to lekcijo ste videli že več kot eno stran.<br />Želite nadaljevati na zadnji strani, ki ste si jo ogledali?';
$string['youmadehighscore'] = 'Prišli ste na seznam najboljših {$a} rezultatov.';
$string['youranswer'] = 'Vaš odgovor';
$string['yourcurrentgradeis'] = 'Vaša trenutna ocena je {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaša trenutna ocena je {$a->grade} od {$a->total}';
$string['youshouldview'] = 'Odgovoriti morate vsaj na: {$a}';
