<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Določen skrbniški imenik ni pravilen';
$string['admindirname'] = 'Skrbniški imenik';
$string['admindirsetting'] = 'Le redka spletna mesta uporabljajo /admin kot poseben URL za dostop
    do nadzorne plošče ali česa drugega.  Žal je to v sporu s
    standardno lokacijo Moodle skrbniških stran.  To lahko popravite s
    preimenovanjem skrbniškega imenika v vaši namestitvi in vstavljanjem tega
    novega imena tu.  Na primer: <br /> <br /><b>moodleadmin</b><br /> <br />
    To bo popravilo skrbniške povezave za Moodle.';
$string['admindirsettinghead'] = 'Nastavitev skrbniškega imenika ...';
$string['admindirsettingsub'] = 'Le redka spletna mesta uporabljajo /admin kot poseben URL za dostop
    do nadzorne plošče ali česa drugega.  Žal je to v sporu s
    standardno lokacijo Moodle skrbniških stran.  To lahko popravite s
    preimenovanjem skrbniškega imenika v vaši namestitvi in vstavljanjem tega
    novega imena tu.  Na primer: <br /> <br /><b>moodleadmin</b><br /> <br />
    To bo popravilo skrbniške povezave za Moodle.';
$string['availablelangs'] = 'Jezikovni paketi na voljo';
$string['caution'] = 'Pozor';
$string['chooselanguage'] = 'Izberite jezik';
$string['chooselanguagehead'] = 'Izberite jezik';
$string['chooselanguagesub'] = 'Izberite jezika SAMO za namestitev. Pozneje boste lahko izbrali tudi jezike strani in uporabniške jezike.';
$string['cliadminpassword'] = 'Novo skrbniško geslo';
$string['cliadminusername'] = 'Uporabniško ime skrbniškega računa';
$string['clialreadyinstalled'] = 'Datoteka config.php že obstaja, prosimo uporabite admin/cli/upgrade.php, če želite posodobiti vašo stran.';
$string['cliinstallfinished'] = 'Namestitev uspešno dokončana.';
$string['cliinstallheader'] = 'Moodle {$a} namestitveni program z ukazno vrstico';
$string['climustagreelicense'] = 'V neinteraktivnem načinu se morate strinjati z licenco tako da določite možnost strinjanja z licenco';
$string['clitablesexist'] = 'Tabele podatkovne baze so že prisotne, sli namestitev se ne more nadaljevati.';
$string['compatibilitysettings'] = 'Preverjanje vaših PHP nastavitev ...';
$string['compatibilitysettingshead'] = 'Preverjanje vaših PHP nastavitev ...';
$string['compatibilitysettingssub'] = 'Da bi Moodle pravilno deloval, mora vaš strežnik opraviti vse naslednje preizkuse';
$string['configfilenotwritten'] = 'Skripta nameščanja ni mogla samodejno ustvariti datoteke config.php, ki bi vsebovala vaše izbrane nastavitve. Verjetno v Moodle imenik ni možno zapisovanje. Ročno lahko prekopirate sledečo kodo v datoteko z imenom config.php v korenskem imeniku Moodle.';
$string['configfilewritten'] = 'datoteka config.php je bila uspešno ustvarjena';
$string['configurationcomplete'] = 'Konfiguracija je dokončana';
$string['configurationcompletehead'] = 'Konfiguracija je dokončana';
$string['configurationcompletesub'] = 'Moodle je poskušal shraniti vašo konfiguracijo v datoteko v korenu vaše namestitve Moodle.';
$string['database'] = 'Podatkovna zbirka';
$string['databasehead'] = 'Nastavitve podatkovne baze';
$string['databasehost'] = 'Gostitelj podatkovne baze';
$string['databasename'] = 'Ime podatkovne baze';
$string['databasepass'] = 'Geslo podatkovne baze';
$string['databasesocket'] = 'Unix reža';
$string['databasetypehead'] = 'Izberite gonilnik podatkovne baze';
$string['databasetypesub'] = 'Moodle podpira več vrst strežnikov podatkovnih baz. Prosimo kontaktirajte sistemskega skrnika, če želite itzedeti katere vrste uporabiti.';
$string['databaseuser'] = 'Uporabnik podatkovne baze';
$string['dataroot'] = 'Imenik za podatke';
$string['datarooterror'] = '\'Imenika za podatke\', ki ste ga navedli, ni možno najti ali ustvariti.  Bodisi popravite pot ali ustvarite imenik ročno.';
$string['datarootpublicerror'] = '\'Imenik za podatke\', ki ste ga navedli, je dostopen s spleta. Uporabite drug imenik.';
$string['dbconnectionerror'] = 'S podatkovno zbirko, ki ste jo navedli, ni moč vzpostaviti povezave. Prosimo, preverite vaše nastavitve podatkovne zbirke.';
$string['dbcreationerror'] = 'Napaka ustvarjanja podatkovne zbirke. S podanimi nastavitvami ni možno ustvariti podatkovne zbirke z navedenim imenom';
$string['dbhost'] = 'Gostiteljski strežnik';
$string['dbpass'] = 'Geslo';
$string['dbprefix'] = 'Predpona tabel';
$string['dbtype'] = 'Vrsta';
$string['directorysettings'] = '<p>Prosimo, potrdite lokacije te namestitve Moodle.</p>

<p><b>Spletni naslov:</b>
Navedite polni spletni naslov za dostop do Moodle.
Če je vaše spletno mesto dostopno prek večih URL naslovov izberite
najbolj pogostega, ki ga bodo uporabljali udeleženci.  Ne vključite
zaključne poševnice.</p>

<p><b>Imenik Moodle:</b>
Navedite polno pot imenika do te namestitve
Pazite, da bodo pravilne velike in male črke.</p>

<p><b>Imenik za podatke:</b>
Potrebujete prostor kamor lahko Moodle shranjuje naložene datoteke.  Ta
imenik mora omogočati branje IN PISANJE za uporabniško ime spletnega strežnika
(običajno \'nobody\' ali \'apache\'), a ne sme biti dostopen
neposredno prek spleta.</p>';
$string['directorysettingshead'] = 'Potrdite lokacije te namestitve Moodle';
$string['directorysettingssub'] = '<b>Spletni naslov:</b>
Navedite polni spletni naslov za dostop do Moodle.
Če je vaše spletno mesto dostopno prek večih URL naslovov izberite
najbolj pogostega, ki ga bodo uporabljali udeleženci.  Ne vključite
zaključne poševnice.
<br />
<br />
<b>Imenik Moodle:</b>
Navedite polno pot imenika do te namestitve
Pazite, da bodo pravilne velike in male črke.
<br />
<br />
<b>Podatkovni imenik:</b>
Potrebujete prostor kamor lahko Moodle shranjuje naložene datoteke.  Ta
imenik mora omogočati branje IN PISANJE za uporabniško ime spletnega strežnika
(običajno \'nobody\' ali \'apache\'), a ne sme biti dostopen
neposredno prek spleta.';
$string['dirroot'] = 'Imenik Moodle';
$string['dirrooterror'] = 'Nastavitev \'Imenik Moodle\' je kot kaže napačna - tam ni najti namestitve Moodle. Spodnja vrednost je bila ponovno nastavljena.';
$string['download'] = 'Prenos';
$string['downloadlanguagebutton'] = 'Prenesite jezikovni paket &quot;{$a}&quot;';
$string['downloadlanguagehead'] = 'Prenos jezikovnega paketa';
$string['downloadlanguagenotneeded'] = 'Nadaljujete lahko postopek namestitve z uporabo privzetega jezikovnega paketa, "{$a}".';
$string['downloadlanguagesub'] = 'Zdaj imate možnost prenosa jezikovnega paketa in nadaljevanja s postopkom namestitve v tem jeziku.<br /><br />Če ne morete prenesti jezikovnega paketa, se bo namestitveni postopek nadaljeval v angleščini. (Ko bo namestitveni postopek zaključen, boste imeli možnost prenosa in namestitve dodatnih jezikovnih paketov.)';
$string['doyouagree'] = 'Se strinjate? (da/ne):';
$string['environmenthead'] = 'Preverjanje vašega okolja ...';
$string['environmentsub'] = 'Preverjamo, če razne komponente vašega sistema ustrezajo sistemskim zahtevam';
$string['environmentsub2'] = 'Vsaka moodle izdaja ima nekatere minimalne PHP zahteve in številne mandatorne PHP razširitve. Pred vsako namestitvijo ali posodobitvijo se izvede popolna preverba okolja. Prosimo kontaktirajte strežniškega administratorja, če ne veste kako namestiti novo verzijo ali omogočiti PHP razširitev.';
$string['errorsinenvironment'] = 'Preverjanje okolja ni uspelo!';
$string['fail'] = 'Neuspeh';
$string['fileuploads'] = 'Nalaganje datotek';
$string['fileuploadserror'] = 'To bi moralo biti vključeno';
$string['fileuploadshelp'] = '<p>Nalaganje datotek je kot kaže onemogočeno na vašem strežniku.</p>

<p>Moodle je še vedno možno namestiti, vendar brez te možnosti, ne boste mogli
   nalagati datotek predmetov ali novih slik uporabniških profilov.</p>

<š>Za omogočanje nalaganja datotek boste (ali vaš skrbnik sistema) morali
   urediti glavno datoteko php.ini na vašem sistemu in spremeniti nastavitev za
   <b>file_uploads</b> na \'1\'.</p>';
$string['installation'] = 'Namestitev';
$string['langdownloaderror'] = 'Žal jezik "{$a}" ni bil nameščen. Postopek namestitve se bo nadaljeval v angleščini.';
$string['langdownloadok'] = 'Jezik "{$a}" je bil uspešno nameščen. Postopek namestitve se bo nadaljeval v tem jeziku.';
$string['magicquotesruntime'] = 'Magic Quotes Run Time';
$string['magicquotesruntimeerror'] = 'To bi moralo biti izključeno';
$string['magicquotesruntimehelp'] = '<p>Možnost Magic quotes runtime bi morala biti izključena za pravilno delovanje Moodle.</p>

<p>Po navadi je privzeta vrednost izključena ... poglejte nastavitev <b>magic_quotes_runtime</b> v vaši datoteki php.ini.</p>

<p>Če nimate dostopa do datoteke php.ini, boste morda lahko vstavili sledečo vrstico v datoteko
   imenovano .htaccess v vašem imeniku Moodle:
   <blockquote>php_value magic_quotes_runtime Off</blockquote>
</p>';
$string['memorylimit'] = 'Omejitev pomnilnika';
$string['memorylimiterror'] = 'Omejitev pomnilnika PHP je nastavljena precej nizko ... pozneje lahko pride do težav.';
$string['memorylimithelp'] = '<p>Omejitev pomnilnika PHP je trenutno na vašem strežniku nastavljena na {$a}.</p>

<p>To lahko povzroči, da bo imel Moodle pozneje težave s pomnilnikom. Še posebej,
   če imate vključenih veliko modulov oziroma veliko uporabnikov.</p>

<p>Priporočamo, da konfigurirate PHP z višjo omejitvijo, če je možno npr. 40M.
   To lahko poskusite storiti na več načinov:</p>
<ol>
<li>Če lahko, ponovno prevedite PHP z <i>--enable-memory-limit</i>.
    To bo omogočilo, da bo Moodle sam nastavil omejitev pomnilnik zase.</li>
<li>Če imate dostop do vaše datoteke php.ini, lahko spremenite vrednost <b>memory_limit</b>
    v tej datoteki na, recimo, 40M.  Če nimate dostopa, boste morda
    lahko prosili vašega skrbnika, da to naredi za vas.</li>
<li>Na nekaterih strežnikih PHP lahko ustvarite datoteko .htaccess v imeniku Moodle,
    ki naj vsebuje to vrstico:
    <p><blockquote>php_value memory_limit 40M</blockquote></p>
    <p>Vendar lahko to prepreči delovanje <b>vseh</b> PHP strani
    (ob prikazu strani boste videli napake) in boste morali odstraniti datoteko .htaccess.</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'Nastavitev MSSQL v PHP je napačna, zato ne more komunicirati z MSSQL strežnikom. Prosimo, preverite datoteko php.ini ali ponovno prevedite PHP.';
$string['mysqliextensionisnotpresentinphp'] = 'Nastavitev MySQLi v PHP je napačna, zato ne more komunicirati s strežnikom MySQL. Prosimo, preverite datoteko php.ini ali ponovno prevedite PHP. Razširitev MySQLi za PHP4 ni dostopna.';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Sedaj morate nastaviti podatkovno bazo, kjer bodo shranjeni Moodle podatki. Ta podatkovna baza mora biti že ustvarjena z uporabniškim imenom ter geslom za dostop. Prefix tabele je obvezen.';
$string['nativemysqli'] = 'Izboljšan MySQL (native/mysqli)';
$string['nativemysqlihelp'] = 'Sedaj morate nastaviti podatkovno bazo, kjer bodo shranjeni Moodle podatki. Ta podatkovna baza mora biti že ustvarjena z uporabniškim imenom ter geslom za dostop. Prefix tabele je obvezen.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Sedaj morate nastaviti podatkovno bazo, kjer bodo shranjeni Moodle podatki. Ta podatkovna baza mora biti že ustvarjena z uporabniškim imenom ter geslom za dostop. Prefix tabele je obvezen.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Sedaj morate nastaviti podatkovno bazo, kjer bodo shranjeni Moodle podatki. Ta podatkovna baza mora biti že ustvarjena z uporabniškim imenom ter geslom za dostop. Prefix tabele je obvezen.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Sedaj morate nastaviti podatkovno bazo, kjer bodo shranjeni Moodle podatki. Ta podatkovna baza mora biti že ustvarjena z uporabniškim imenom ter geslom za dostop. Prefix tabele je obvezen.';
$string['ociextensionisnotpresentinphp'] = 'Nastavitev OCI8 v PHP je napačna, zato ne more komunicirati s strežnikom Oracle. Prosimo, preverite datoteko php.ini ali ponovno prevedite PHP.';
$string['pass'] = 'Uspešno';
$string['paths'] = 'Poti';
$string['pathserrcreatedataroot'] = 'Podatkovna mapa ({$a->dataroot}) ne more biti ustvarjena z namestitvenim programom.';
$string['pathshead'] = 'Potrdite poti';
$string['pathsrodataroot'] = 'Korenska mapa ni za pisanje.';
$string['pathsroparentdataroot'] = 'Starševska mapa ({$a->parent}) ni za pisanje. Podatkovna mapa ({$a->dataroot}) ne more biti ustvarjena preko namestitvenega programa.';
$string['pathssubadmindir'] = 'Zelo malo Spletnih gostiteljev uporablja /admin kot posebni URL preko katerega dostopate do nadzorn plošče. Na žalost je to v konfliktu s standardno lokacijo za Moodlove skrbniške strani. To lahko popravite s preimenovanjemskrbniške mape v vaši namestitvi in vnesete tukaj to novo ime. Na primer: <em>moodleadmin</em>. To bo popravilo skrbniške povezave v Moodlu.';
$string['pathssubdataroot'] = 'Potrebujete prostor, kamor bo Moodle shranjeval naložene datoteke. Ta mapa naj ima omogočeno branje IN PISANJE s strani uporabnika spletnega strežnika (po navadi \'brez\' ali \'apache\'), ampak ne sme biti dostopno neposredno preko spleta. Namestitveni program jo bo poskušal ustvariti, če že ne obstaja.';
$string['pathssubdirroot'] = 'Polna pot do Moodle nameščene mape.';
$string['pathssubwwwroot'] = 'Polni spletni naslov kjer bo Moodle dostopan. Dostop do Moodla z uporabo več naslovov ni mogoč. Če ima vaša stran več javnih naslovov, morate nastaviti trajne preusmeritve na vse naslove razen tega. Če je vaša stran dosropana preko interneta in omrežja, uporabite tukaj javne naslove in nastaviet DNS tako, da lahko uporabniki znotraj omrežja uporabljajo tudi javne naslove. Če naslovi niso pravilni prosimo spremenite URL v vašem brskalniku in ponovno poženite namestitev z drugo vrednostjo.';
$string['pathsunsecuredataroot'] = '({$a->dataroot})';
$string['pathswrongadmindir'] = 'Skrbniška mapa ne obstaja';
$string['pgsqlextensionisnotpresentinphp'] = 'Nastavitev PGSQL v PHP je napačna, zato ne more komunicirati s strežnikom PostgreSQL. Prosimo, preverite datoteko php.ini ali ponovno prevedite PHP.';
$string['phpextension'] = '{$a} PHP razširitev';
$string['phpversion'] = 'Različica PHP';
$string['phpversionhelp'] = '<p>Moodle zahteva različico PHP vsaj 4.3.0 ali 5.1.0 (5.0.x ima vrsto znanih težav).</p>
<p>Vaša trenutna različica je {$a}</p>
<p>Posodobiti in nadgraditi morate PHP ali premakniti program na strežnik s novejšo različico PHP!<br />
(V primeru različice 5.0.x lahko namestite tudi različico 4.4.x)</p>';
$string['releasenoteslink'] = 'Za informacije o tej Moodle različici, si prosim oglejte informacije o različici na {$a}';
$string['safemode'] = 'Varni način';
$string['safemodeerror'] = 'Moodle lahko ima težave z vključenim varnim načinom';
$string['safemodehelp'] = '<p>Moodle ima lahko razne težave z vključenim varnim načinom. Ne samo, da
   verjetno ne bo smel ustvarjati novih datotek.</p>

<p>Varni način je običajno vključen pri paranoidnih javnih spletnih gostiteljih in boste morda morali
   poiskati novo podjetje za gostovanje vašega Moodle spletnega mesta.</p>

<p>Če želite lahko poskusite nadaljevati z namestitvijo, a pričakujte nekaj težav pozneje.</p>';
$string['sessionautostart'] = 'Samodejni začetek seje';
$string['sessionautostarterror'] = 'To bi moralo biti izključeno';
$string['sessionautostarthelp'] = '<p>Moodle zahteva podporo za seje in ne bo deloval brez tega.</p>

<p>Seje lahko omogočite v datoteki php.ini ... poiščite parameter session.auto_start.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP ni bil pravilno konfiguriran z SQLite razširitvijo. Prosimo preglejte php.ini datoteko ali ponovno prevedite PHP.';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'To stran vidite, ker ste uspešno namestili in
    zagnali paket <strong>{$a->packname} {$a->packversion}</strong> na vašem računalniku. Čestitamo!';
$string['welcomep30'] = 'Ta različica <strong>{$a->installername}</strong> vključuje aplikacije
    za ustvarjanje okolja v katerem bo deloval <strong>Moodle</strong> in sicer:';
$string['welcomep40'] = 'Ta paket vključuje tudi <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Uporabo vseh aplikacij v tem paketu določajo njihove ustrezne
    licence. Celoten paket <strong>{$a->installername}</strong> je
    <a href="http://www.opensource.org/docs/definition_plain.html">odprta koda</a> in se razširja
    pod licenco <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'Naslednje strani vas bodo popeljale skozi nekaj enostavno sledljivih korakov za
    konfiguracijo in nastavitev <strong>Moodle</strong>  na vašem računalniku. Sprejmete lahko privzete
    nastavitve ali jih, če tako želite, spremenite, da bodo ustrezale vašim potrebam.';
$string['welcomep70'] = 'Kliknite spodnji gumb "Naprej" za nadaljevanje nastavitve <strong>Moodle</strong>.';
$string['wwwroot'] = 'Spletni naslov';
$string['wwwrooterror'] = 'Spletni naslov kot kaže ni veljaven - te namestitve Moodle, kot kaže, ni tam. Spodnja vrednost je bila ponovno nastavljena.';
