<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Dodaj komentar';
$string['addentry'] = 'Dodaj nov vnos';
$string['addingcomment'] = 'Dodaj komentar';
$string['alias'] = 'Ključna beseda';
$string['aliases'] = 'Ključne besede';
$string['aliases_help'] = '<p>Vsak vnos v slovarju ima lahko povezan seznam ključnih besed (ali sinonimov).</p>

<p><b>Vnesite vsak sinonim v novo vrstico</b> (ne ločujte jih z vejicami!).</p>

<p>Besede in fraze sinonima so lahko uporabljene kot alternativni sklic na vnos. Če boste na primer uporabili filter samodejnega povezovanja, bodo ob odločitvi, katere besede naj se povežejo s tem vnosom, poleg glavnega imena vnosa uporabljene tudi te besede.</p>';
$string['allcategories'] = 'Vse kategorije';
$string['allentries'] = 'Vse';
$string['allowcomments'] = 'Dovoljeni komentarji vnosov';
$string['allowcomments_help'] = '<p>Udeležencem lahko dovolite, da dodajo komentarje vnosov slovarja.</p>

<p>Izberete lahko, ali je ta možnost omogočena ali onemogočena.</p>

<p>Izvajalci lahko vedno dodajo komentarje k vnosom slovarja.</p>';
$string['allowduplicatedentries'] = 'Dovoljeni podvojeni vnosi';
$string['allowduplicatedentries_help'] = '<p>Če to možnost vključite, so dovoljeni večkratni vnosi z enakim imenom pojma.</p>';
$string['allowprintview'] = 'Dovoli ogled za tisk';
$string['allowprintview_help'] = '<p>Udeleženci smejo uporabiti ogled slovarja za tisk.</p>

<p>Izberete lahko ali je ta možnost omogočena ali onemogočena.</p>

<p>Izvajalci lahko vedno uporabijo ogled za tisk.</p>';
$string['andmorenewentries'] = 'in {$a} novih vnosov.';
$string['answer'] = 'Odgovor';
$string['approve'] = 'Odobri';
$string['areaattachment'] = 'Priponke';
$string['areaentry'] = 'Definicije';
$string['areyousuredelete'] = 'Ste prepričani, da želite izbrisati ta vnos?';
$string['areyousuredeletecomment'] = 'Ste prepričani, da želite izbrisati ta komentar?';
$string['areyousureexport'] = 'Ste prepričani, da želite izvoziti ta vnos v';
$string['ascending'] = '(naraščajoče)';
$string['attachment'] = 'Priloga';
$string['attachment_help'] = '<p>Vsakemu vnosu slovarja lahko priložite tudi ENO datoteko s svojega računalnika. Datoteka se naloži na strežnik in shrani z vašim vnosom.</p>

<p>To je uporabno, če želite z ostalimi deliti na primer sliko ali dokument Word.</p>

<p>Ta datoteka je lahko poljubne vrste, vendar je zelo priporočljivo, da je datoteka poimenovana s standardno pripono s tremi črkami, kot je .doc za Wordov dokument, .jpg ali .png za sliko in tako naprej. To bo drugim olajšalo prenos in ogled datoteke v njihovih brskalnikih.</p>

<p>Če vnos ponovno urejate in priložite novo datoteko, bodo vse predhodno priložene datoteke za ta vnos zamenjane.</p>

<p>Če vnos s prilogo ponovno urejate in pustite to polje prazno, bo prvotna priloga ohranjena.</p>';
$string['author'] = 'avtor';
$string['authorview'] = 'Prebrskaj po avtorju';
$string['back'] = 'Nazaj';
$string['cantinsertcat'] = 'Kategorije ni možno vstaviti';
$string['cantinsertrec'] = 'Zapisa ni možno vstaviti';
$string['cantinsertrel'] = 'Relacije kategorija-vnos ni možno vstaviti';
$string['casesensitive'] = 'Ta vnos razlikuje velike in male črke';
$string['casesensitive_help'] = '<p>Ta nastavitev določa ali je potrebno natančno ujemanje velikih in malih črk ob izvajanju samodejnega povezovanja s temi vnosi.</p>

<p>Na primer, če je to vklopljeno, potem beseda kot je "html" v objavi foruma NE bo samodejno povezana z vnosom slovarja z imenom "HTML".</p>';
$string['cat'] = 'kat';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categorydeleted'] = 'Kategorija izbrisana';
$string['categoryview'] = 'Prebrskaj po kategoriji';
$string['changeto'] = 'spremeni v {$a}';
$string['cnfallowcomments'] = 'Določite, ali naj slovar privzeto sprejema komentarje vnosov';
$string['cnfallowdupentries'] = 'Določite, ali naj slovar privzeto omogoča podvojene vnose';
$string['cnfapprovalstatus'] = 'Določite privzeto stanje odobritve vnosov, ki jih oddajo udeleženci';
$string['cnfcasesensitive'] = 'Določite, ali naj povezan vnos privzeto ločuje med velikimi in malimi črkami';
$string['cnfdefaulthook'] = 'Izberite privzet izbor za prikaz ob prvem ogledu slovarja';
$string['cnfdefaultmode'] = 'Izberite privzet okvir za prikaz ob prvem ogledu slovarja.';
$string['cnffullmatch'] = 'Določite, ali naj se povezan izraz privzeto ujema z velikimi in malimi črkami v ciljnem besedilu';
$string['cnflinkentry'] = 'Določite, ali naj je vnos privzeto samodejno povezan';
$string['cnflinkglossaries'] = 'Določite, ali naj je slovar privzeto samodejno povezan';
$string['cnfrelatedview'] = 'Izberite obliko prikaza za samodejno povezovanje in ogled vnosa.';
$string['cnfshowgroup'] = 'Določite ali naj se prelom skupine prikaže ali ne.';
$string['cnfsortkey'] = 'Izberite privzet ključ urejanja.';
$string['cnfsortorder'] = 'Izberite privzeto razvrstitev urejanja.';
$string['cnfstudentcanpost'] = 'Določite, ali lahko udeleženci privzeto objavijo vnose ali ne';
$string['comment'] = 'Komentar';
$string['commentdeleted'] = 'Komentar je bil izbrisan.';
$string['comments'] = 'Komentarji';
$string['commentson'] = 'Komentarji za';
$string['commentupdated'] = 'Komentar je bil posodobljen.';
$string['completionentries'] = 'Udeleženci morajo ustvariti vnose:';
$string['completionentriesgroup'] = 'Zahtevaj vnose';
$string['concept'] = 'Pojem';
$string['concepts'] = 'Pojmi';
$string['configenablerssfeeds'] = 'To stikalo bo omogočilo možnost RSS virov za vse slovarje. Še vedno boste morali vire ročno vključiti v nastavitvah za vsak slovar.';
$string['current'] = 'Trenutno razvrščeno {$a}';
$string['currentglossary'] = 'Trenuten slovar';
$string['date'] = 'datum';
$string['dateview'] = 'Prebrskaj po datumu';
$string['defaultapproval'] = 'Privzeto odobreno';
$string['defaultapproval_help'] = '<p>Ta nastavitev omogoča izvajalcu določiti, kaj se zgodi z novimi vnosi, ki jih dodajo udeleženci.  Vnosi so lahko samodejno na voljo vsem, sicer mora izvajalec odobriti vsakega posebej.</p>';
$string['defaulthook'] = 'Privzet hook';
$string['defaultmode'] = 'Privzet način';
$string['defaultsortkey'] = 'Privzet razvrstitveni ključ';
$string['defaultsortorder'] = 'Privzet razvrstitveni red';
$string['definition'] = 'Definicija';
$string['definitions'] = 'Definicije';
$string['deleteentry'] = 'Izbriši vnos';
$string['deletenotenrolled'] = 'Izbriše vnose uporabnikov, ki niso vpisani';
$string['deletingcomment'] = 'Brisanje komentarja';
$string['deletingnoneemptycategory'] = 'Brisanje te kategorije ne bo izbrisalo vnosov, ki jih vsebuje - ti bodo označeni  kot brez kategorije.';
$string['descending'] = '(padajoče)';
$string['destination'] = 'Cilj';
$string['destination_help'] = '<p>Določite lahko, kam želite uvoziti vnose:</p>
<ul>
<li><strong>Trenuten slovar:</strong> Bo dodalo uvožene vnose v trenutno odprt slovar.</li>
<li><strong>Nov slovar:</strong> Bo ustvarilo nov slovar, ki bo temeljil na podatkih najdenih v izbrani datoteki za uvoz in bo vanj vstavilo nove vnose.</li>
</ul>';
$string['displayformat'] = 'Oblika prikaza';
$string['displayformatcontinuous'] = 'Zvezno brez avtorja';
$string['displayformatdictionary'] = 'Preprosto, slog slovarja';
$string['displayformatencyclopedia'] = 'Enciklopedija';
$string['displayformatentrylist'] = 'Seznam vnosov';
$string['displayformatfaq'] = 'Pogosto zastavljena vprašanja';
$string['displayformatfullwithauthor'] = 'Polno z avtorjem';
$string['displayformatfullwithoutauthor'] = 'Polno brez avtorja';
$string['displayformat_help'] = '<p>Ta nastavitev določa, kako bo vsak vnos prikazan v slovarju.  Privzete oblike so:</p>

<dl class="indent">
<dt><b>Enostaven slovar</b>:</dt>
<dd>Prikazano kot običajen slovar z ločenimi vnosi. Avtorji niso prikazani, priloge pa se prikažejo kot povezave.</dd>
<dt><b>Zvezno</b>:</dt>
<dd>Prikaže vnose enega za drugim brez kakršnegakoli ločevanja razen ikon za urejanje.</dd>
<dt><b>Polno z avtorjem</b>:</dt>
<dd>Prikaz v obliki, podobni forumu, s prikazom podatkov o avtorju. Priloge se prikažejo kot povezave.</dd>
<dt><b>Polno brez avtorja</b>:</dt>
<dd>Prikaz v obliki, podobni forumu, brez prikaza podatkov o avtorju. Priloge se prikažejo kot povezave.</dd>
<dt><b>Enciklopedija</b>:</dt>
<dd>Podobno kot \'Polno z avtorjem\', vendar se priložene slike prikažejo ob besedilu.</dd>
<dt><b>Pogosto zastavljena vprašanja</b>:</dt>
<dd>Uporabno za prikaz seznama pogosto zastavljenih vprašanj. Samodejno doda ustrezni besedi VPRAŠANJE in ODGOVOR ob pojmu in definiciji.</dd>
</dl>

<hr />
<p>Skrbniki Moodla lahko ustvarijo nove oblike, če sledijo navodilom v <b>mod/glossary/formats/README.txt</b>.</p>';
$string['displayformats'] = 'Oblike prikaza';
$string['displayformatssetup'] = 'Nastavitev oblik prikaza';
$string['duplicateentry'] = 'Podvoji vnos';
$string['editalways'] = 'Vedno uredi';
$string['editalways_help'] = '<p>Ta možnost omogoča, da se odločite, ali lahko udeleženci kadarkoli urejajo svoje vnose.</p>

<p>Izberete lahko:</p>

<ul>
<li><b>Da:</b> Vnose je vedno možno urejati.</li>

<li><b>Ne:</b> Vnose je možno urejati samo v toliko časa, kot je določeno v nastavitvah.</li>
</ul>';
$string['editcategories'] = 'Uredi kategorije';
$string['editentry'] = 'Uredi vnos';
$string['editingcomment'] = 'Urejanje komentarja';
$string['entbypage'] = 'Število vnosov na stran';
$string['entries'] = 'Vnosi';
$string['entrieswithoutcategory'] = 'Vnosi brez kategorije';
$string['entry'] = 'Vnos';
$string['entryalreadyexist'] = 'Vnos že obstaja';
$string['entryapproved'] = 'Ta vnos je bil odobren';
$string['entrydeleted'] = 'Vnos izbrisan';
$string['entryexported'] = 'Vnos uspešno izvožen';
$string['entryishidden'] = '(ta vnos je trenutno skrit)';
$string['entryleveldefaultsettings'] = 'Privzete nastavitve na ravni vnosa';
$string['entrysaved'] = 'Ta vnos je bil shranjen';
$string['entryupdated'] = 'Ta vnos je bil posodobljen';
$string['entryusedynalink'] = 'Ta vnos naj bo samodejno povezan';
$string['entryusedynalink_help'] = '<p>Z vključitvijo te možnosti boste omogočili samodejno povezovanje vnosa, kadarkoli se besede pojma in fraze pojavijo drugje v istem predmetu.  To vključuje objave v forumu, notranje vire, tedenske povzetke in tako naprej.  </p>

<p>Če določenega besedila ne želite povezovati (recimo v objavi foruma), potem morate dodati oznake <nolink> in </nolink> okoli besedila.</p>

<p>Da bi lahko to možnost vključili, mora biti omogočeno samodejno povezovanje na ravni slovarja.</p>';
$string['errcannoteditothers'] = 'Ne morete urejati objave drugih oseb.';
$string['errconceptalreadyexists'] = 'Pojem že obstaja. Slovar ne omogoča podvojenih vnosov.';
$string['errdeltimeexpired'] = 'Tega ne morete izbrisati. Čas je potekel!';
$string['erredittimeexpired'] = 'Čas urejanja vnosa je potekel.';
$string['errorparsingxml'] = 'Pojavile so se napake med obdelovanjem (parsing) datoteke XML. Prepričajte se, da ima veljavno XML sintakso.';
$string['explainaddentry'] = 'Dodajte nov vnos v trenuten slovar.<br />Pojem in definicija sta obvezni polji.';
$string['explainall'] = 'Prikaži VSE vnose na eni strani';
$string['explainalphabet'] = 'Brskaj po slovarju z uporabo tega kazala';
$string['explainexport'] = 'Kliknite na spodnji gumb za izvoz vnosov slovarja.<br />Uvozite jih lahko kadarkoli želite v ta ali drug predmet.</p>Prosimo vedite, da priloge (npr. slike) in avtorji niso izvoženi.</p>';
$string['explainimport'] = 'Navesti morate datoteko za uvoz in določiti kriterije postopka.<p>Oddajte svojo zahtevo in preglejte rezultate.</p>';
$string['explainspecial'] = 'Prikaže vnose, ki se ne začnejo s črko';
$string['exportedentry'] = 'Izvožen vnos';
$string['exportentries'] = 'Izvozi vnose';
$string['exportentriestoxml'] = 'Izvozi vnose v datoteko XML';
$string['exportfile'] = 'Izvozi vnose v datoteko';
$string['exportglossary'] = 'Izvozi slovar';
$string['exporttomainglossary'] = 'Izvozi v glavni slovar';
$string['filetoimport'] = 'Datoteka za uvoz';
$string['filetoimport_help'] = '<p>Izberite XML datoteko na svojem računalniku, ki vsebuje vnose za uvoz.</p>';
$string['fillfields'] = 'Pojem in definicija sta obvezni polji.';
$string['filtername'] = 'Samodejno povezovanje slovarja';
$string['fullmatch'] = 'Ujemanje samo celih besed';
$string['fullmatch_help'] = '<p>Če je omogočeno samodejno povezovanje, bo vključitev te nastavitve vsililo povezovanje izključno celih besed.</p>

<p>Na primer vnos slovarja z imenom "konstrukt" ne bo ustvaril povezave znotraj besede "konstruktivizem".</p>';
$string['glossary:approve'] = 'Odobritev neodobrenih vnosov';
$string['glossary:comment'] = 'Ustvarjanje komentarjev';
$string['glossary:export'] = 'Izvoz vnosov';
$string['glossary:exportentry'] = 'Izvozi enojni vnos';
$string['glossary:exportownentry'] = 'Izvozi lastni enojni vnos';
$string['glossary:import'] = 'Uvoz vnosov';
$string['glossaryleveldefaultsettings'] = 'Privzete nastavitve na ravni slovarja';
$string['glossary:managecategories'] = 'Upravljanje kategorij';
$string['glossary:managecomments'] = 'Upravljanje komentarjev';
$string['glossary:manageentries'] = 'Upravljanje vnosov';
$string['glossary:rate'] = 'Ocenjevanje vnosov';
$string['glossarytype'] = 'Vrsta slovarja';
$string['glossarytype_help'] = '<p>Sistem slovarjev omogoča izvoz vnosov iz poljubnega pomožnega slovarja v glavni slovar predmeta. Če želite to narediti, morate enega izmed slovarjev označiti kot glavnega.</p>

<p>Opomba: Za vsak predmet imate lahko samo en glavni slovar.</p>

<p>Pred Moodle verzijo 1.7 so lahko glavni slovar urejali samo izvajalci. Če želite v Moodle verziji 1.7 in kasnejših nadzirati, kdo lahko ureja katerikoli slovar (vključujoč z glavnim), morate uporabiti vmesnik Povozi dovoljenja.</p>';
$string['glossary:view'] = 'Ogled slovarja';
$string['glossary:viewallratings'] = 'Ogled vseh grobih ocen dodeljenih od posameznikov';
$string['glossary:viewanyrating'] = 'Ogled vseh ocen ki jih je kdorkoli prejel';
$string['glossary:viewrating'] = 'Ogled ocen za vnose';
$string['glossary:write'] = 'Ustvarjanje novih vnosov';
$string['guestnoedit'] = 'Gostom ni dovoljeno urejati slovarjev';
$string['importcategories'] = 'Uvozi kategorije';
$string['importedcategories'] = 'Uvožene kategorije';
$string['importedentries'] = 'Uvoženi vnosi';
$string['importentries'] = 'Uvozi vnose';
$string['importentriesfromxml'] = 'Uvozi vnose iz datoteke XML';
$string['includegroupbreaks'] = 'Vključi prelome skupin';
$string['isglobal'] = 'Je ta slovar globalen?';
$string['isglobal_help'] = '<p>Skrbniki lahko določijo slovar kot globalni slovar.</p>

<p>Ti slovarji so lahko del poljubnega predmeta in predvsem naslovne strani.</p>

<p>Razlika v primerjavi z navadnim lokalnim slovarjem je v tem, da so vnosi uporabljeni za ustvarjanje samodejnih povezav prek celotne strani (in ne samo v tistem predmetu, ki mu slovar pripada).</p>';
$string['linkcategory'] = 'Samodejno povezuj to kategorijo';
$string['linkcategory_help'] = '<p>Določite lahko, ali želite, da se kategorije samodejno povezujejo ali ne.</p>

<p>Opomba: Kategorije se povezujejo z razlikovanjem velikih in malih črk ter samo ob polnem ujemanju.</p>';
$string['linking'] = 'Samodejno povezovanje';
$string['mainglossary'] = 'Glavni slovar';
$string['maxtimehaspassed'] = 'Žal je poteklo časovno obdobje za urejanje tega komentarja ({$a})!';
$string['modulename'] = 'Slovar';
$string['modulename_help'] = 'Modul slovarja omogoča udeležencem ustvarjanje in vzdrževanje seznama definicij, kot je slovar. Vnosi v slovarju so lahko avtomatično povezani kjerkoli se pojmi in fraze pojavijo skozi celoten predmet.';
$string['modulenameplural'] = 'Slovarji';
$string['newentries'] = 'Novi vnosi slovarja';
$string['newglossary'] = 'Nov slovar';
$string['newglossarycreated'] = 'Nov slovar ustvarjen.';
$string['newglossaryentries'] = 'Novi vnosi slovarja:';
$string['nocomment'] = 'Nobenega najdenega komentarja';
$string['nocomments'] = '(Za ta vnos ni najdenega nobenega komentarja)';
$string['noconceptfound'] = 'Ni najdenega pojma ali definicije.';
$string['noentries'] = 'Ni najdenih vnosov v tem odseku';
$string['noentry'] = 'Ni najdenih vnosov.';
$string['notcategorised'] = 'Brez kategorije';
$string['numberofentries'] = 'Število vnosov';
$string['onebyline'] = '(en na vrstico)';
$string['page-mod-glossary-edit'] = 'Vnosna stran slovarja';
$string['page-mod-glossary-view'] = 'Prikaži vnosno stran slovarja';
$string['page-mod-glossary-x'] = 'Vsaka stran modula slovarja';
$string['pluginadministration'] = 'Administracija slovarja';
$string['pluginname'] = 'Slovar';
$string['popupformat'] = 'Pojavna oblika';
$string['printerfriendly'] = 'Različica primerna za tisk';
$string['printviewnotallowed'] = 'Pogled za tisk ni dovoljen';
$string['question'] = 'Vprašanje';
$string['rejectedentries'] = 'Zavrnjeni vnosi';
$string['rejectionrpt'] = 'Poročilo o zavrnitvi';
$string['resetglossaries'] = 'Izbriši vnose od';
$string['resetglossariesall'] = 'Izbriši vnose iz vseh slovarjev';
$string['rssarticles'] = 'Število zadnjih RSS člankov';
$string['rssarticles_help'] = '<p>Ta možnost omogoča, da izberete število prispevkov, ki naj bodo vključeni v RSS vir.</p>

<p>Število med 5 in 20 bi bilo primerno za večino slovarjev. Povečajte to število, če je slovar pogosto posodobljen.</p>';
$string['rsssubscriberss'] = 'Prikaži RSS vir za pojme \'{$a}\'';
$string['rsstype'] = 'RSS vir za to dejavnost';
$string['rsstype_help'] = '<p>Ta možnost vam omogoča, da omogočite RSS vir iz tega slovarja.</p>

<p>Izberete lahko med dvema vrstama virov:</p>

<ul>
<li><b>Z avtorjem:</b> Generirani viri bodo vključevali ime avtorja ob vsakem članku.</li>

<li><b>Brez avtorja:</b> Generirani viri ne bodo vključevali imena avtorja ob vsakem članku.</li>
</ul>';
$string['searchindefinition'] = 'Išči po polnem besedilu';
$string['secondaryglossary'] = 'Pomožni slovar';
$string['showall'] = 'Prikaži povezavo \'VSE\'';
$string['showall_help'] = '<p>Način, kako uporabnik pregleduje slovar, lahko prilagodite po meri. Pregledovanje in iskanje sta vedno na voljo, vendar lahko določite tri dodatne možnosti:</p>

<p><b>PRIKAŽI POSEBNO</b> Omogoči ali onemogoči pregledovanje po posebnih znakih, kot sta @, # in tako naprej.</p>

<p><b>PRIKAŽI ABECEDO</b> Omogoči ali onemogoči pregledovanje po črkah abecede.</p>

<p><b>PRIKAŽI VSE</b> Omogoči ali onemogoči pregledovanje vseh vnosov hkrati.</p>';
$string['showalphabet'] = 'Prikaži abecedo';
$string['showalphabet_help'] = '<p>Način, kako uporabnik pregleduje slovar, lahko prilagodite po meri. Pregledovanje in iskanje sta vedno na voljo, vendar lahko določite tri dodatne možnosti:</p>

<p><b>PRIKAŽI POSEBNO</b> Omogoči ali onemogoči pregledovanje po posebnih znakih, kot sta @, # in tako naprej.</p>

<p><b>PRIKAŽI ABECEDO</b> Omogoči ali onemogoči pregledovanje po črkah abecede.</p>

<p><b>PRIKAŽI VSE</b> Omogoči ali onemogoči pregledovanje vseh vnosov hkrati.</p>';
$string['showspecial'] = 'Prikaži povezavo \'Posebno\'';
$string['showspecial_help'] = '<p>Način, kako uporabnik pregleduje slovar, lahko prilagodite po meri. Pregledovanje in iskanje sta vedno na voljo, vendar lahko določite tri dodatne možnosti:</p>

<p><b>PRIKAŽI POSEBNO</b> Omogoči ali onemogoči pregledovanje po posebnih znakih, kot sta @, # in tako naprej.</p>

<p><b>PRIKAŽI ABECEDO</b> Omogoči ali onemogoči pregledovanje po črkah abecede.</p>

<p><b>PRIKAŽI VSE</b> Omogoči ali onemogoči pregledovanje vseh vnosov hkrati.</p>';
$string['sortby'] = 'Razvrsti po';
$string['sortbycreation'] = 'po datum nastanka';
$string['sortbylastupdate'] = 'po zadnji posodobitvi';
$string['sortchronogically'] = 'Razvrsti kronološko';
$string['special'] = 'Posebno';
$string['standardview'] = 'Prebrskaj po abecedi';
$string['studentcanpost'] = 'Udeleženci lahko dodajo vnose';
$string['totalentries'] = 'Skupaj vnosov';
$string['usedynalink'] = 'Samodejno povezovanje vnosov slovarja';
$string['usedynalink_help'] = '<p>Z vključitvijo te možnosti boste omogočili samodejno povezovanje posameznih vnosov v tem slovarju, kadarkoli se besede pojma in fraze pojavijo drugje v istem predmetu.  To vključuje objave v forumu, notranje vire, tedenske povzetke in tako naprej.  </p>

<p>Vedite, da omogočanje povezovanja za slovar ne vključi samodejno povezovanja za vsak vnos - povezovanje mora biti nastavljeno za vsak vnos posebej.</p>

<p>Če določenega besedila ne želite povezovati (recimo v objavi foruma), potem morate dodati oznake <nolink> in </nolink> okoli besedila.</p>

<p>Vedite, da so povezana tudi imena kategorij.</p>';
$string['waitingapproval'] = 'Čaka na odobritev';
$string['warningstudentcapost'] = '(Velja samo, če slovar ni glavni slovar)';
$string['withauthor'] = 'Pojmi z avtorjem';
$string['withoutauthor'] = 'Pojmi brez avtorja';
$string['writtenby'] = 'od';
$string['youarenottheauthor'] = 'Niste avtor tega komentarja, zato ga ne smete urejati.';
