<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Ste že prijavljeni kot {$a}, morate se odjaviti, preden se lahko prijavite kot drug uporabnik.';
$string['blockcannotconfig'] = 'Ta blok ne podpira globalne konfiguracije';
$string['blockcannotinistantiate'] = 'Problem v instanciranju objekta';
$string['blockdoesnotexist'] = 'Ta blok ne obstaja';
$string['blockdoesnotexistonpage'] = 'Ta blok (id={$a->instanceid}) ne obstaja na tej strani ({$a->url}).';
$string['blocknameconflict'] = 'Konflikt pri poimenovanju: blok {$a->name} ima enak naziv kot obstoječi blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Povratni klic komentarja je odklonil ta komentar.';
$string['cannotaddcoursemodule'] = 'Ne morem dodati novega modula predmeta';
$string['cannotaddcoursemoduletosection'] = 'Ne morem dodati novega modula predmeta';
$string['cannotaddnewmodule'] = 'Ne morem dodati novega modula od {$a}';
$string['cannotaddthisblocktype'] = 'Ne morete dodati {$a} bloka na to stran';
$string['cannotassignrole'] = 'Vloge v predmetu ni moč določiti';
$string['cannotassignrolehere'] = 'Ni vam dovoljena dodelitev te vloge (id = {$a->roleid}) v tem kontekstu ({$a->context})';
$string['cannotassignselfasparent'] = 'Sebe ne morete določiti kot starša!';
$string['cannotcallscript'] = 'Te skripte tako ne morete poklicati';
$string['cannotcallusgetselecteduser'] = 'You cannot call user_selector::get_selected_user if multi select is true.';
$string['cannotcreatecategory'] = 'Kategorija ni bila vstavljena';
$string['cannotcreatelangdir'] = 'Imenika jezika ni možno ustvariti.';
$string['cannotcreateorfindstructs'] = 'Napaka pri iskanju ali kreiranju sekcijskih struktur za ta predmet';
$string['cannotcreatetempdir'] = 'Začasnega imenika ni možno ustvariti.';
$string['cannotcustomisefiltersblockuser'] = 'Ne morete prilagajati nastavitev filtrov v uporabnikovem ali kontekstu bloka.';
$string['cannotdeletecategorycourse'] = 'Predmet \'{$a}\' ni bil izbrisan.';
$string['cannotdeletecategoryquestions'] = 'Iz te kategorije ne morem izbrisati vprašanj \'{$a}\'';
$string['cannotdeletecourse'] = 'Nimate dovoljenja za izbris tega predmeta';
$string['cannotdeletecustomfield'] = 'Napaka pri izbrisu podatkov';
$string['cannotdeletefile'] = 'Te datoteke ne morem izbrisati';
$string['cannotdeleterolewithid'] = 'Ne morem izbrisati vloge z ID {$a}';
$string['cannotdeletethisrole'] = 'Te vloge ne morete izbrisati ker je v uporabi sistema, ali ker je to zadnja vloga z administratorskimi kompatibilnostmi.';
$string['cannotdownloadcomponents'] = 'Komponent ni možno prenesti.';
$string['cannotdownloadlanguageupdatelist'] = 'Ne morem prenesti spiska osveženih jezikovnih paketov z download.moodle.org';
$string['cannotdownloadzipfile'] = 'Datoteke ZIP ni možno prenesti.';
$string['cannoteditcommentexpired'] = 'Urejanje ni možno. Čas je potekel.';
$string['cannoteditsiteform'] = 'Ne morete urejati strani predmeta z uporabo tega obrazca';
$string['cannotedityourprofile'] = 'Ne morete urejati svojega profila';
$string['cannotfindcategory'] = 'Ne morem najti zapisa kategorije iz podatkovne baze z ID-jem {$a}';
$string['cannotfindcomponent'] = 'Komponente ni možno najti.';
$string['cannotfindcourse'] = 'Ne morem najti predmeta';
$string['cannotfindgradeitem'] = 'Ne morem najti grade_item';
$string['cannotfindteacher'] = 'Ne morem najti učitelja';
$string['cannotfinduser'] = 'Ne najdem uporabnika imenovanega "{$a}"';
$string['cannotgradeuser'] = 'Ne morem oceniti tega uporabnika';
$string['cannothaveparentcate'] = 'Kategorija predmeta ne more imeti starša!';
$string['cannotimport'] = 'Napaka pri uvozu';
$string['cannotimportformat'] = 'Uvoz tega formata ni še implementiran!';
$string['cannotimportgrade'] = 'Napaka pri uvozu ocene';
$string['cannotinsertgrade'] = 'Ne mroem vstaviti ocene brez ID-ja predmeta!';
$string['cannotinsertrecord'] = 'Ne morem dodati novega zapisa z ID {$a}';
$string['cannotmailconfirm'] = 'Napaka pri pošiljanju potrdilne e-pošte o spremembi gesla';
$string['cannotmanualctrack'] = 'Aktivnost ne pridobi sledenja ročnega dokončanja';
$string['cannotmapfield'] = 'Zaznani trki preslikav - dve polji map za isto oceno {$a}';
$string['cannotmoverolewithid'] = 'Ne morete premakniti vloge z ID-jem {$a}';
$string['cannotopencsv'] = 'Ne morem odpreti CSV datoteke';
$string['cannotopenfile'] = 'Ne mroem odpreti datoteke ({$a})';
$string['cannotopenzip'] = 'Ne morem odpreti zip datoteke, najverjetneje je hrošč v zip končnici na 64 bitnih operacijskih sistemih';
$string['cannotoverridebaserole'] = 'Ne morem povoziti zmožnosti osnovnih vlog';
$string['cannotoverriderolehere'] = 'ni vam dovoljeno da povozite te vloge (id = {$a->roleid}) v tem kontekstu ({$a->context})';
$string['cannotreadfile'] = 'Ne morem brati datoteke ({$a})';
$string['cannotreadtmpfile'] = 'Napaka pri branju začasne datoteke';
$string['cannotreaduploadfile'] = 'Ne morem prebrati naložene datoteke';
$string['cannotresetguestpwd'] = 'Ne morete ponastaviti gesla gosta';
$string['cannotresetmail'] = 'Napaka pri ponastavitvi gesla in';
$string['cannotrestore'] = 'Prišlo je do napake in obnovitev ni bila dokončana!';
$string['cannotsavemd5file'] = 'Datoteke MD5 ni možno shraniti.';
$string['cannotsavezipfile'] = 'Datoteke ZIP ni možno shraniti.';
$string['cannotservefile'] = 'Ne morem postreči datoteke - napačna konfiguracija strežnika.';
$string['cannotsetparentforcatoritem'] = 'Ne morem določiti starša za kategorijo ali predmet!';
$string['cannotsetpassword'] = 'Ne morem nastaviti uporabniškega gesla!';
$string['cannotunassigncap'] = 'Ne morem oddeliti opuščene zmožnosti {$a->cap} od vloge {$a->role}';
$string['cannotunzipfile'] = 'Datoteke ni možno razširiti (unzip).';
$string['cannotupdatemod'] = 'Ne morem posodobiti {$a}';
$string['cannotupdatepasswordonextauth'] = 'Posodabljanje gesla na zunanjem auth ni uspelo: {$a}. Za več podrobnosti si oglejte dnevnik strežnika.';
$string['cannotupdateprofile'] = 'Napaka pri nalaganju uporabniških zapisov';
$string['cannotupdaterecord'] = 'Ne morem osvežiti zapisa z ID {$a}';
$string['cannotupdateusermsgpref'] = 'Ne morem posodobiti preferenc uporabniških sporočil';
$string['cannotupdateuseronexauth'] = 'Napaka pri posodabljanju uporabniških podatkov na zunanjem auth: {$a}. Za več podrobnosti si oglejte serverske dnevnike.';
$string['cannotuploadfile'] = 'Napaka pri procesiranju naložene datoteke';
$string['cannotusepage2'] = 'Te strani ne morete uporabljati';
$string['cannotviewprofile'] = 'Profila tega uporabnika ne morete videti.';
$string['cannotviewreport'] = 'Tega poročila ne morete pogledati';
$string['componentisuptodate'] = 'Komponenta je posodobljena.';
$string['confirmsesskeybad'] = 'Vašega ključa seje ni možno potrditi za izvedbo tega dejanja.  Ta varnostna možnost preprečuje nenamerno ali zlonamerno izvajanje pomembnih funkcij v vašem imenu.  Prepričajte se, da ste res želeli izvesti to funkcijo.';
$string['couldnotassignrole'] = 'Med dodeljevanjem vaše vloge se je pojavila resna, a neznana napaka.';
$string['countriesphpempty'] = 'Napaka: datoteka countries.php v jezikovnem paketu {$a} je prazna ali manjka.';
$string['coursedoesnotbelongtocategory'] = 'Predmet ne pripada tej kategoriji';
$string['coursegroupunknown'] = 'Predmet, ki ustreza skupini {$a} ni določen';
$string['courseidnotfound'] = 'Id predmeta ne obstaja';
$string['coursemisconf'] = 'Predmet je narobe skonfiguriran';
$string['courserequestdisabled'] = 'Zahtevane predmete je administrator onemogočil.';
$string['csvcolumnduplicates'] = 'Zaznani podvojeni stolpci';
$string['csvemptyfile'] = 'Datoteka CSV je prazna';
$string['csvfewcolumns'] = 'Premalo stolpcev - prosim, preverite nastavitev ločila';
$string['csvinvalidcols'] = '<b>Napačna CSV datoteka:</b> Prva vrstica mora vsebovati "Polja Glave" in datoteka mora biti vrsta od <br />"Razširjena Polja/Z vejico ločena"<br />ali<br /> "Razširjena Polja z CAVV kodo rezultata/ločeno z vejicami"';
$string['csvinvalidcolsnum'] = 'Napačna CSV datoteka - vsaka vrstica mora vsebovati 49 ali 70 polj';
$string['csvloaderror'] = 'Prišlo je do napake med nalaganjem CSV datoteke!';
$string['csvweirdcolumns'] = 'Napačen format datoteke CSV - število stolpcev ni stalno!';
$string['dbconnectionfailed'] = '<p>Napaka: Povezava s podatkovno bazo je bila prekinjena</p>
<p>Podatkovna baza je preobremenjena ali pa samo ne deluje pravilno. </p>
<p>Skrbnik strani naj preveri tudi, če so bili podrobnejši podatke podatkovne baze pravilno določeni v config.php</p>';
$string['dbdriverproblem'] = '<p>Napaka: Najden je bil problem pri gonilniku podatkovne baze</p> <p>Skrbnik strani naj preveri konfiguracijo strežnika</p><p>{$a}</p>';
$string['dbsessionhandlerproblem'] = 'Nastavljanje seje podatkovne baze ni uspelo.<br /><br />Prosimo obvestite skrbnika strežnika.';
$string['dbsessionmysqlpacketsize'] = 'Odkrita je bila resna napaka v seji.<br /><br />Prosimo obvestite skrbnika sistema, da je ta problem najverjetneje nastal zaradi nizke vrednosti v max_allowed_packet MySQL nastavitvah.';
$string['dbupdatefailed'] = 'Posodobitev podatkovne baze ni uspela';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" ne more biti spremenjena. Najdena je odvisnost z {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Napaka pri izvajanju DLL sql';
$string['ddlfieldalreadyexists'] = 'Polje "{$a}" že obstaja';
$string['ddlfieldnotexist'] = 'Polje "{$a->fieldname}" ne obstaja v tabeli "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabela "{$a}" že obstaja';
$string['ddltablenotexist'] = 'Tabela "{$a}" že obstaja';
$string['ddlunknownerror'] = 'Nepoznana napaka v DLL knjižnici';
$string['ddlxmlfileerror'] = 'Najdene so napake v XML podatkovni bazi';
$string['ddsequenceerror'] = 'Nepravilna definicja tabele  "{$a}"; Obstaja lahko samo en avtomatični stolpec, ki mora biti definiran kot ključ.';
$string['detectedbrokenplugin'] = 'Vtičnik "{$a}" je pokvarjen ali zastarel in se ne more več izvajati, oprostite.';
$string['dmlreadexception'] = 'Napaka pri branju iz podatkovne baze';
$string['dmltransactionexception'] = 'Napaka pri branju iz podatkovne baze';
$string['dmlwriteexception'] = 'Napaka pri pisanju v podatkovno bazo';
$string['downgradedcore'] = 'NAPAKA!!! Koda, ki jo uporabljate je STAREJŠA od različice, ki je bila uporabljena za ustvarjanje te podatkovne baze!';
$string['downloadedfilecheckfailed'] = 'Preverjanje prenesene datoteke je spodletelo.';
$string['duplicatefieldname'] = 'Zaznano podvojeno ime polja "{$a}"';
$string['duplicateparaminsql'] = 'NAPAKA: Podvojeno ime parametra v povpraševanju';
$string['duplicateusername'] = 'Podvojeno uporabniško ime - zapis preskočen.';
$string['error'] = 'Prišlo je do napake';
$string['errorcleaningdirectory'] = 'Napaka ob čiščenju imenika "{$a}"';
$string['errorcopyingfiles'] = 'Napaka pri kopiranju datotek';
$string['errorcreatingdirectory'] = 'Napaka pri ustvarjanju imenika "{$a}"';
$string['errorcreatingfile'] = 'Napaka pri ustvarjanju datoteke "{$a}"';
$string['errorfetchingrssfeed'] = 'Napaka pri pridobivanju RSS vira.';
$string['erroronline'] = 'Napaka v vrstici {$a}';
$string['errorparsingxml'] = 'Napaka pri razčlenjevanju XML: {$a->errorstring} pri vrstici {$a->errorline}, znak {$a->errorchar}';
$string['errorreadingfile'] = 'Napaka pri branju datoteke "{$a}"';
$string['errorsavingrequest'] = 'Prišlo je do napake med shranjevanjem vaše zahteve.';
$string['errorsettinguserpref'] = 'Napaka pri nastavljanju uporabniške preference';
$string['errorunzippingfiles'] = 'Napaka pri razširjanju datotek';
$string['expiredkey'] = 'Ključ je pretekel';
$string['externalauthpassworderror'] = 'Neprazno geslo pri zunanji avtentikaciji';
$string['fieldrequired'] = '"{$a}" je zahtevano polje';
$string['fileexists'] = 'Datoteka obstaja';
$string['filenotfound'] = 'Zahtevane datoteke ni bilo mogoče najti';
$string['filenotreadable'] = 'Datoteke ni za branje';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} ne dovoljuje lokalnih nastavitev.';
$string['filternotenabled'] = 'Filter ni omogočen!';
$string['filternotinstalled'] = 'Filter {$a} ni nameščen';
$string['forumblockingtoomanyposts'] = 'Presegli ste nastavljen prag dovoljenih objav za ta forum.';
$string['generalexceptionmessage'] = 'Izjema - {$a}';
$string['gradepubdisable'] = 'Objavljanje ocen je onemogočeno';
$string['groupalready'] = 'Uporabnik že pripada skupini {$a}';
$string['groupexistforcourse'] = 'Skupina "{$a}" že obstaja v tem predmetu';
$string['groupnotaddederror'] = 'Skupina "{$a}" ni bila dodana';
$string['groupunknown'] = 'Skupina {$a} ni povezana z določenim predmetom';
$string['groupusernotmember'] = 'Uporabnik ni član te skupine.';
$string['guestnoeditprofile'] = 'Gostujoči uporabnik ne more urejati svojega profila';
$string['guestnoeditprofileother'] = 'Profila gostujočega uporabnika ni možno urejati';
$string['guestsarenotallowed'] = 'Gostujoči uporabnik nima dostopa do te funkcije';
$string['hashpoolproblem'] = 'Nepravilna vsebina pool datoteke {$a}.';
$string['headersent'] = 'Glave so že poslane';
$string['idnumbertaken'] = 'ID številka je že uporabljena v drugem predmetu';
$string['internalauthpassworderror'] = 'Manjkajoče geslo ali neveljavna politika gesel za notranjo avtentikacijo';
$string['invalidaccess'] = 'Ta stran ni bila pravilno dostopana';
$string['invalidaccessparameter'] = 'Nepravilni parameter dostopa';
$string['invalidaction'] = 'Nepravilni parameter dostopa';
$string['invalidadminsettingname'] = 'Nepravilne nastavitve skrbnika ({$a})';
$string['invalidargorconf'] = 'Dobavljenih ni bilo pravilnih argumentov ali pa se strežnik napačno konfigururan';
$string['invalidarguments'] = 'Dobavljenih ni bilo pravilnih argumentov';
$string['invalidbulkenrolop'] = 'Dobavljenih ni bilo pravilnih argumentov';
$string['invalidcategory'] = 'Nepravilna kategorija!';
$string['invalidcategoryid'] = 'Nepravilni id kategorije!';
$string['invalidcomment'] = 'Komentar je nepravilen';
$string['invalidcommentarea'] = 'Nepravilno področje komentarja';
$string['invalidcommentid'] = 'Nepravilni id komentarja';
$string['invalidcommentitemid'] = 'Nepravilni itemid komentarja';
$string['invalidcommentparam'] = 'Nepravilni parametri komentarja';
$string['invalidcomponent'] = 'Nepravilno ime komponente';
$string['invalidconfirmdata'] = 'Nepravilni potrditveni podatki';
$string['invalidcontext'] = 'Neveljaven kontekst';
$string['invalidcourse'] = 'Neveljaven predmet';
$string['invalidcourseid'] = 'ID predmeta {$a} ne obstaja';
$string['invalidcourselevel'] = 'Nepravilni kontekstni nivo';
$string['invalidcoursemodule'] = 'ID modula predmeta ne obstaja';
$string['invalidcoursenameshort'] = 'Nepravilno ime kratkega predmeta';
$string['invaliddata'] = 'Prejeti podatki so nepravilni';
$string['invaliddatarootpermissions'] = 'Zaznana so nepravilna dovoljenja v $CFG->dataroot direktoriju, skrbnik naj popravi dovoljenja.';
$string['invaliddevicetype'] = 'Napačna vrsta naprave';
$string['invalidelementid'] = 'Napačni id elementa!';
$string['invalidentry'] = 'To ni dovoljen vnos!';
$string['invalidfieldname'] = '"{$a}" ni veljavno ime polja';
$string['invalidfiletype'] = '"{$a}" ni veljavna vrsta datoteke';
$string['invalidformdata'] = 'Napačni podatki obrazca';
$string['invalidfunction'] = 'Napačna funkcija';
$string['invalidgradeitemid'] = 'Napačen id ocene';
$string['invalidgroupid'] = 'Določen je napačen id skupine';
$string['invalidipformat'] = 'Neveljavna oblika IP naslova';
$string['invaliditemid'] = 'Napačen id predmeta';
$string['invalidkey'] = 'Napačen ključ';
$string['invalidlegacy'] = 'Napačna definicija dediščine vloge za vrsto: {$a}';
$string['invalidmd5'] = 'Neveljaven MD5';
$string['invalidmode'] = 'Nepravilni način ({$a})';
$string['invalidnum'] = 'Nepravilna numerična vrednost';
$string['invalidnumkey'] = '$conditions array ne sme vsebovati numeričnih ključev, prosimo popravite kodo!';
$string['invalidoutcome'] = 'Napačen id rezultata';
$string['invalidpagesize'] = 'Napačna velikost strani';
$string['invalidpasswordpolicy'] = 'Nepravilna politika gesla';
$string['invalidpaymentmethod'] = 'Nepravilna metoda plačina: {$a}';
$string['invalidqueryparam'] = 'NAPAKA: Napačno število porametrov povpraševanja. Pričakovano {$a->expected}, dobljeno {$a->actual}.';
$string['invalidratingarea'] = 'Nepravilno območje ocenjevanja';
$string['invalidrecord'] = 'Ne najdem podatkovnega zapisa v tabeli podatkovne baze {$a}.';
$string['invalidrecordunknown'] = 'Ne najdem podatkovnega zapisa v  podatkovni bazi';
$string['invalidrequest'] = 'Neveljavna zahteva';
$string['invalidrole'] = 'Neveljavna vloga';
$string['invalidroleid'] = 'Nepravilni ID vloge';
$string['invalidscaleid'] = 'Nepravilni id velikosti';
$string['invalidsection'] = 'Modul zapisov predmeta vsebuje neveljavni oddelek';
$string['invalidsesskey'] = 'Napačen ključ seje - obrazec ni sprejet!';
$string['invalidshortname'] = 'To je nepravilno kratko ime predmeta';
$string['invalidstatedetected'] = 'Nekaj se je zalomilo: {$a}. To se po navadi ne bi smelo zgoditi.';
$string['invalidurl'] = 'Neveljaven URL';
$string['invaliduser'] = 'Nepravilni uporabnik';
$string['invaliduserfield'] = 'Neveljavno uporabniško polje: {$a}';
$string['invaliduserid'] = 'Nepravilni id uporabnika';
$string['invalidxmlfile'] = '"{$a}" ni veljavna datoteka XML';
$string['iplookupfailed'] = 'Ne najdem geografske informacije o IP naslovu {$a}';
$string['iplookupprivate'] = 'Ne morem pokazati informacij o zasebnem IP naslovu';
$string['ipmismatch'] = 'IP naslov uporabnika se ne ujema';
$string['listcantmovedown'] = 'Element je zadnji med vrstniki, tako da ga ne morem premakniti nižje.';
$string['listcantmoveleft'] = 'Element nima nadrejenih elementov, zato ga ne morem premakniti levo.';
$string['listcantmoveright'] = 'Ker element nima vrstnika, pod katerega bi ga premaknili, ga ne morem premakniti desno. Premaknite ga pod vrstnika - potem ga boste lahko premaknili desno.';
$string['listcantmoveup'] = 'Element je prvi med vrstniki, tako da ga ne morem premakniti višje.';
$string['listnochildren'] = 'Ne najdem podrejenih elementov';
$string['listnoitem'] = 'Ne najdem elementa';
$string['listnopeers'] = 'Ne najdem vrstnikov elementa';
$string['listupdatefail'] = 'Napaka podatkovne zbirke pri poskusu urejanja hierarhije elementov';
$string['logfilenotavailable'] = 'Dnevniški zapisi niso na voljo';
$string['loginasnoenrol'] = 'Možnosti vpisa in izpisa v predmetu ni moč uporabljati med sejo "Prijavite se kot".';
$string['loginasonecourse'] = 'V predmet ne morete vstopiti.<br />Pred vstopom v druge predmete morate končati sejo "Prijavite se kot".';
$string['maxbytes'] = 'Ta datoteka je večja ob največje možne velikosti datoteke';
$string['messagingdisable'] = 'Na tej strani je onemogočeno sporočanje';
$string['mimetexisnotexist'] = 'Vaš sistem ni nastavljen za poganjanje mimeTwX. Prenesti si morate primerno zaganjalno datoteko za vašo PHP-OS platformo iz <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, ali si pridobite C izvorno kodo iz <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, jo skompilirajtein skopirajte zagonsko datoteko v vašp moodle/filter/tex/ mapo.';
$string['mimetexnotexecutable'] = 'Mimtex po meri ni izvršljiv!';
$string['missingfield'] = 'Polje "{$a}" manjka';
$string['missingkeyinsql'] = 'NAPAKA: manjkajoč paramater "{$a}" pri povpraševanju';
$string['missing_moodle_backup_xml_file'] = 'V varnostni kopiji manjka XML datoteka: {$a}';
$string['missingparam'] = 'Potreben parameter ({$a}) manjka';
$string['missingparameter'] = 'Manjkajoč paramater';
$string['missingrequiredfield'] = 'Eno izmed zahtevanih polj manjka';
$string['missinguseranditemid'] = 'Manjkajoč userid ali itemid';
$string['mixedtypesqlparam'] = 'NAPAKA: Mešani tipi sql quera parametrov!!';
$string['mnetdisable'] = 'MNET je onemogočen';
$string['mnetlocal'] = 'Oddaljeni MNET uporabniki se ne morejo lokalno prijaviti';
$string['moduledisable'] = 'Ta modul ({$a}) je bil onemogočen za ta določen predmet';
$string['moduledoesnotexist'] = 'Ta modul ne obstaja';
$string['modulemissingcode'] = 'Modulu {$a} manjka potrebna koda za izvajanje te funkcije';
$string['multiplerecordsfound'] = 'Najdenih je več zapisov, pričakovan je bil samo en zapis.';
$string['mustbeloggedin'] = 'Če želite to narediti, morate biti prijavljeni';
$string['mustbeteacher'] = 'Za ogled te strani morate biti izvajalec';
$string['myisamproblem'] = 'Tabele v podatkovni bazi uporabljajo MyISAM pogon. Priporočljiva je uporaba ACID pogona s popolno transakcijsko podporo kot naprimer InnoDB.';
$string['needcopy'] = 'Najprej morate nekaj kopirati!';
$string['needcoursecategroyid'] = 'Določena mora biti kategorija sli id predmeta';
$string['needphpext'] = 'Dodati morate {$a} podporo v vašo PHP namestitev';
$string['noadmins'] = 'Ni skrbnikov!';
$string['noblocks'] = 'Ni najdenih blokov!';
$string['nocapabilitytousethisservice'] = 'Uporabnik nima potrebnih zmožnosti za uporabo tega servisa';
$string['nocategorydelete'] = 'Kategorije \'{$a}\' ni moč izbrisati!';
$string['nocontext'] = 'Žal predmet ni v veljavnem kontekstu';
$string['nodata'] = 'Ni podatkov';
$string['nofile'] = 'Datoteka ni določena';
$string['nofiltersenabled'] = 'Filtri niso omogočeni.';
$string['noformdesc'] = 'Za to aktivnost ni najdenege opisne datoteke za formslib obrazec';
$string['noguest'] = 'Tukaj ni gostov!';
$string['noinstances'] = 'V tem predmetu ni nobenega primerka modula {$a}!';
$string['nologinas'] = 'Nimate dovoljenja za prijavo kot ta uporabnik.';
$string['nonmeaningfulcontent'] = 'Brez smiselne vsebine';
$string['noparticipants'] = 'Za ta predmet ni najdenih udeležencev';
$string['noparticipatorycms'] = 'Žal nimate sodelovalnih modulov predmeta o katerih bi lahko poročali.';
$string['nopermissions'] = 'Žal trenutno nimate dovoljenje za dejanje ({$a})';
$string['nopermissiontocomment'] = 'Ne morete dodajat komentarjev';
$string['nopermissiontodelentry'] = 'Ne morete izbrisati vnosov drugih ljudi!';
$string['nopermissiontohide'] = 'Ni dovoljen, ki bi jih lahko skrili!';
$string['nopermissiontoimportact'] = 'Nimate potrebovanih dovoljenj za uvoz aktivnosti v ta predmet';
$string['nopermissiontolock'] = 'Ni dovoljenj, ki bi jih lahko ztaklenili!';
$string['nopermissiontoshow'] = 'Nimate dovoljenj za ogled tega!';
$string['nopermissiontounlock'] = 'Nimate dovoljenj za odklep!';
$string['nopermissiontoupdatecalendar'] = 'Trenutno nimate dovoljenj za posodobitev dogodka na koledarju';
$string['nopermissiontoviewgrades'] = 'Ne morete si ogledati ocen.';
$string['nopermissiontoviewletergrade'] = 'Manjkajoče dovoljenje za ogled ocen';
$string['nosite'] = 'Ne morem najti vrhnjega predmeta!';
$string['nostatstodisplay'] = 'Žal statistični podatki niso na voljo.';
$string['notallowedtoupdateprefremotely'] = 'Ni vam dovoljena oddaljena posodobitev te uporabniške preference';
$string['notavailable'] = 'To trenutno ni na voljo';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Niste član tga predmeta skupine';
$string['notownerofkey'] = 'Niste lastnik tega ključa';
$string['nousers'] = 'Ni takega uporabnika!';
$string['onlyadmins'] = 'To lahko storijo samo skrbniki.';
$string['onlyeditingteachers'] = 'To lahko storijo samo izvajalci s pravico urejanja.';
$string['onlyeditown'] = 'Urejate lahko samo svoje podatke';
$string['orderidnotfound'] = 'ID naročila {$a} ni najden';
$string['pagenotexist'] = 'Prišlo je do nenavadne napake (poskus dostopa do strani, ki ne obstaja).';
$string['pathdoesnotstartslash'] = 'Pravilni argument ni dobavljen, pot se ne začne s poševnoco!';
$string['pleasereport'] = 'Če utegnete, nam prosim javite, kaj ste poskušali narediti, ko je prišlo do napake:';
$string['pluginrequirementsnotmet'] = 'Vtičnika "{$a->pluginname}" ({$a->pluginversion}) ni bilo možno namestiti. Zahteva novejšo različico Moodla (trenutno uporabljate {$a->currentmoodle}, potrebujete {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Napaka: predpogoj tabele podatkovne baze ne sme biti prazen ({$a})</p>
<p>Skrbnik strani mora popraviti ta problem.</p>';
$string['prefixtoolong'] = '<p>Napaka: predpogoj tabele podatkovne baze je predolg ({$a->dbfamily})</p>
<p>Skrbnik sistema mora popraviti ta problem. Največja dolžina za predpogoj tabele v {$a->dbfamily} je {$a->maxlength} znakov.</p>';
$string['processingstops'] = 'Obdelava se tu konča. Preostali zapisi so prezrti.';
$string['redirecterrordetected'] = 'Zaznana je bila nepodprta preusmeritev, izvajanje skripte je bilo ustavljeno';
$string['refoundto'] = 'Ne morem povrniti na {$a}';
$string['refoundtoorigi'] = 'Povrnjeno na prvotno vrednost {$a}';
$string['remotedownloaderror'] = 'Prenos komponent na vaš strežnik ni uspel. Prosimo, da preverite nastavitve prehodnega strežnika. Priporočamo uporabo razširitve cURL za PHP.<br /><br />Datoteko <a href="{$a->url}">{$a->url}</a> morate prenesti ročno - skopirajte jo v imenik "{$a->dest}" in razširite.';
$string['remotedownloadnotallowed'] = 'Nalaganje komponent na vaš strežnik ni dovoljeno (allow_url_fopen je onemogočen).<br /><br />Ročno morate prenesti datoteko <a href="{$a->url}">{$a->url}</a>, jo kopirati v imenik "{$a->dest}" na vašem strežniku in jo tam razširiti (unzip).';
$string['reportnotavailable'] = 'Ta vrsta poročila je na voljo samo za to stran predmeta';
$string['requireloginerror'] = 'Predmet ali aktivnost ni na voljo.';
$string['restore_path_element_missingmethod'] = 'Povrnitvena metoda {$a} manjka. Določena mora biti od razvijalca.';
$string['restore_path_element_noobject'] = 'Povrnjeni objekt {$a} ni objekt.';
$string['restrictedcontextexception'] = 'Izvajanje zunanje funkcije krši omejitve vsebine.';
$string['restricteduser'] = 'Oprostite, toda vaš trenutni račun "{$a}" ne sme narediti tega.';
$string['reverseproxyabused'] = 'Obrni proxy omogočen, server ne more biti direktno dostopan, oprostite.<br />Prosimo kontaktirajte strežniškega skrbnika.';
$string['rpcerror'] = 'Oooops! MNET komunikacija ni uspela! Tukaj je sporočilo o napaki, ki ga posredujte skrbniku sistema: {$a}';
$string['scheduledbackupsdisabled'] = 'Ustvarjanje vnaprej določenih varnostnih kopije je onemogočil skrbnik strežnika.';
$string['secretalreadyused'] = 'Povezava za potrditev spremembe gesla je že bila uporabljena, geslo ni bilo spremenjeno';
$string['sectionnotexist'] = 'Ta oddelek ne obstaja!';
$string['sendmessage'] = 'Pošlji sporočilo';
$string['sessioncookiesdisable'] = 'Nepravilna uporaba require_key_login() - piškotki seje morajo biti onemogočeni!!';
$string['sessiondiskfull'] = 'Particija seje je polna. Trenutno prijava ni mogoča.<br /><br />Prosimo obvestite sistemskega skrbnika.';
$string['sessionerroruser'] = 'Vaša seja je potekla. Prosimo, ponovno se prijavite.';
$string['sessionerroruser2'] = 'Zaznana je bila napaka strežnika, ki vpliva na vašo sejo prijave. Prosimo, ponovno se prijavite ali ponovno zaženite brskalnik.';
$string['sessionipnomatch'] = 'Oprostite, toda vaša IP številka se je kot kaže spremenila od kar ste se prvič prijavili. Ta varnostna možnost preprečuje zlonamerno krajo vaše identitete med tem, ko ste prijavljeni na tej strani. Navadni uporabniki tega sporočila ne bi smeli videti - prosimo, povprašajte skrbnika strani za pomoč.';
$string['sessionipnomatch2'] = 'Oprostite, vendar izgleda da je bila vaša IP številka spremenjna odkar ste se prvič prijavili. Ta varnostna opcija preprečuje hekerjem krajo vaše identitete, medtem ko ste prijavljeni na to stran. To napako lahko vidite, ko uporabljate brezžično omrežje ali če preklapljate med različnimi omrežji. Prosimo vprašajte skrbnika sistema za več pomoči.<br /><br /> Če želite nadaljevati prosimo pritisnite F5 tipko, da osvežite to stran.';
$string['shortnametaken'] = 'Kratko ime je že uporabljeno za drugi predmet';
$string['socksnotsupported'] = 'Prehodni strežnik SOCKS5 v PHP4 ni podprt';
$string['sslonlyaccess'] = 'Zaradi varnostnih razlogov so dovoljene samo https povezave, oprostite.';
$string['statscatchupmode'] = 'Statistika je trenutno v načinu sledenja. Do zdaj je bilo obdelanih {$a->daysdone} dni in na obdelavo čaka {$a->dayspending} dni. Kmalu spet preverite!';
$string['statsdisable'] = 'Statistika ni omogočena';
$string['statsnodata'] = 'Za to kombinacijo predmeta in časovnega obdobja ni podatkov na voljo';
$string['storedfilecannotcreatefiledirs'] = 'Ne morem ustvariti lokalnih datotečnih pool map, prosimo preverite dovoljenja v dataroot.';
$string['storedfilecannotread'] = 'Ne morem prebrati datoteke, ali datoteka ne obstaja ali do problemi z dovoljenji';
$string['storedfilenotcreated'] = 'Ne morem ustvariti datoteke "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}/{$a->filepath}/{$a->filename}"';
$string['storedfileproblem'] = 'Nepoznana izjema, ki se navezuje na lokalne datoteke ({$a})';
$string['tagdisabled'] = 'Oznake so onemogočene!';
$string['tagnotfound'] = 'Izbrane oznake ni v podatkovni bazi';
$string['targetdatabasenotempty'] = 'Ciljna podatkovna baza ni prazna. Prenos je prekinjen zavoljo varnostnih razlogov.';
$string['textconditionsnotallowed'] = 'Primerjava pogojev tekstovnih stolpcev ni dovoljena. Prosimo uporabite sql_compare_text() pri vašem povpraševanju.';
$string['TODO'] = 'TODO';
$string['tokengenerationfailed'] = 'Ne morem ustvariti novega žetona.';
$string['transactionvoid'] = 'Transakcija ne more biti razveljavljena, ker je že bila razveljavljena';
$string['unicodeupgradeerror'] = 'Žal vaša podatkovna zbirka ni v standardu Unicode in trenutna verzija Moodla vaše podatkovne zbirke ne more posodobiti v Unicode. Prosimo, da najprej naredite nadgradnjo na Moodle 1.7.x in v tej verziji na Skrbniški strani izvedete Unicode posodobitev. Za tem boste lahko prešli na Moodle {$a}';
$string['unknowaction'] = 'Nepoznana akcija!';
$string['unknowcategory'] = 'Kategorija ni poznana!';
$string['unknowcontext'] = 'To je nepoznan kontekst ({$a}) v get_child_contexts!';
$string['unknowformat'] = 'Format ni poznan ({$a})';
$string['unknownbackupexporterror'] = 'Nepoznana napaka
pripravljam informacije za uvoz';
$string['unknownblockregion'] = 'Regija bloka \'{$a}\' na tej strani ni prepoznana.';
$string['unknowncontext'] = 'To je nepoznan kontekst.';
$string['unknowncourse'] = 'Neznan predmet z imenom "{$a}"';
$string['unknowncourseidnumber'] = 'Neznani ID predmeta "{$a}"';
$string['unknowncourserequest'] = 'Neznani zahtevek za predmet';
$string['unknowncoursesection'] = 'Neznano področje predmeta v predmetu "{$a}"';
$string['unknowngroup'] = 'Neznana skupna "{$a}"';
$string['unknownmodulename'] = 'Nepoznano ime modula za obrazec';
$string['unknownrole'] = 'Neznana vloga "{$a}"';
$string['unknownsortcolumn'] = 'Nepoznan sortirni stolpec {$a}';
$string['unknownuseraction'] = 'Žal tega uporabniškega dejanja ne razumem.';
$string['unknownuserselector'] = 'Nepoznan uporabniški izbirnik';
$string['unknoworder'] = 'Nepoznano naročanje';
$string['unknowparamtype'] = 'Nepoznana vrsta parametra {$a}';
$string['unknowuploadaction'] = 'Napaka: Nepoznana nalagalna funkcija ({$a})';
$string['unspecifycourseid'] = 'Določiti morate id predmeta, kratko ime ali idštevilko';
$string['unsupportedstate'] = 'Nepodprt status dokončanja';
$string['unsupportedwebserver'] = 'Programska oprema spletnega strežnika ({$a}) ni podprta, oprostite.';
$string['upgraderequires19'] = 'Napaka: Na strežnik je bila nameščena nova različica Moodla, vendar na žalost ni podprta nadgradnja iz prejšnjih različic. <br/>Prosimo najprej posodobite na zadnjo 1.9.x različico. Lahko se tudi vrnete na prejšnjo različico z namestitvijo originalnik datotek.';
$string['upgraderunning'] = 'Stran je v posodabljanju, prosimo poskusite pozneje.';
$string['useradmineditadmin'] = 'Samo skrbnikom je dovoljeno spreminjanje ostalih skrbniških računov';
$string['useradminodelete'] = 'Skrbniški računi ne morejo biti izbrisani';
$string['userautherror'] = 'Neznani vtičnik za preverjanje pristnosti';
$string['userauthunsupported'] = 'Vtičnik za preverjanje pristnosti tu ni podprt';
$string['useremailduplicate'] = 'Podvojen e-poštni naslov';
$string['usermustbemnet'] = 'Uporabniki v MNET dostopnem kontrolnem seznamu morajo biti oddaljeni MNET uporabniki';
$string['usernotaddederror'] = 'Uporabnik "{$a}" ni bil dodan - neznana napaka';
$string['usernotaddedregistered'] = 'Uporabnik "{$a}" ni bil dodan - že registriran';
$string['usernotavailable'] = 'Podrobnosti tega uporabnika vam niso na voljo.';
$string['usernotdeletedadmin'] = 'Uporabnik ni izbrisan -n morem izbrisati skrbniških računov';
$string['usernotdeletederror'] = 'Napaka - uporabnik ni izbrisan';
$string['usernotdeletedmissing'] = 'Ne najdem uporabniškega imena - uporabnik ni izbrisan';
$string['usernotdeletedoff'] = 'Brisanje ni dovoljeno - uporabnik ni izbrisan';
$string['usernotincourse'] = 'Ta uporabnik ni v tem predmetu!';
$string['usernotrenamedadmin'] = 'Skrbniških uporabniških imen ni moč preimenovati';
$string['usernotrenamedexists'] = 'Uporabnik ni preimenovan - novo uporabniško ime je že uporabljeno.';
$string['usernotrenamedmissing'] = 'Uporabnik ni preimenovan - starega uporabniškega imena ni bilo možno najti.';
$string['usernotrenamedoff'] = 'Preimenovanje ni dovoljeno - uporabnik ni preimenovan';
$string['usernotupdatedadmin'] = 'Ne morem posodobiti skrbniških uporabniških imen';
$string['usernotupdatederror'] = 'Napaka - uporabnik ni posodobljen';
$string['usernotupdatednotexists'] = 'Uporabnik ne obstaja - uporabnik ni posodobljen';
$string['userquotalimit'] = 'Dosegli ste limito kvote vaše datoteke';
$string['userselectortoomany'] = 'user_selector je dobil več kot enega izbranega uporabnika, pravilno ni niti skozi več izbir.';
$string['wrongcall'] = 'Ta skripta je narobe klicana';
$string['wrongdestpath'] = 'Napačna ciljna pot.';
$string['wrongsourcebase'] = 'Napačna osnova URL vira.';
$string['wrongusernamepassword'] = 'Napačen uporabnik/geslo';
$string['wrongzipfilename'] = 'Napačno ime datoteke ZIP.';
$string['wwwrootmismatch'] = 'Zaznan je bil nepravilni dostop, ta strežnik je lahko dostopan samo preko "{$a}" naslovov, oprostite.<br />Prosimo obvestite skrbnika strežnika.';
$string['wwwrootslash'] = 'zaznan je bil nepravilni $CFG->wwwroot v config.php, ne sme vsebovati poševnice <br />Prosimo obvestite skrbnika strežnika.';
$string['xmldberror'] = 'XMLDB napaka!';
$string['youcannotdeletecategory'] = 'Kategorije \'{$a}\' ni moč izbrisati, ker nimate dovoljenja za brisanje vsebine ali premik vsebine drugam.';
