<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   auth_shibboleth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_method'] = 'Ime metode avtentikacije';
$string['auth_shib_auth_method_description'] = 'Navedite ime za metodo avtentikacije Shibboleth, ki je znana vašim uporabnikom. Lahko je ime vaše zveze Shibboleth, npr <tt> SWITCHaai Prijava </ tt> ali <tt> InCommon Prijava </ tt> ali podobno.';
$string['auth_shibbolethdescription'] = 'Z uporabo tega načina se uporabniki ustvarijo in se njihova pristnost preveri prek <a href="http://shibboleth.internet2.edu/" target="_blank">Shibboleth</a>.<br>Preberite si <a href="../auth/shibboleth/README.txt" target="_blank">README</a> za Shibboleth o tem kako nastaviti Moodle s Shibboleth';
$string['auth_shibboleth_errormsg'] = 'Izberite organizacijo, ki ji pripadate!';
$string['auth_shibboleth_login'] = 'Prijava Shibboleth';
$string['auth_shibboleth_login_long'] = 'Prijava v Moodle prek Shibboleth';
$string['auth_shibboleth_manual_login'] = 'Ročna prijava';
$string['auth_shibboleth_select_member'] = 'Sem član ...';
$string['auth_shibboleth_select_organization'] = 'Za prijavo prek Shibboleth izberite svojo organizacijo iz padajočega menija:';
$string['auth_shib_changepasswordurl'] = 'URL naslov za spreminjanje gesla';
$string['auth_shib_convert_data'] = 'API spreminjanja podatkov';
$string['auth_shib_convert_data_description'] = 'Ta programski vmesnik (API) lahko uporabite za dodatno spreminjanje podatkov, ki jih zagotavlja Shibboleth. Preberite <a href="../auth/shibboleth/README.txt" target="_blank">README</a> za dodatna navodila.';
$string['auth_shib_convert_data_warning'] = 'Datoteka ne obstaja ali ni berljiva za proces spletnega strežnika!';
$string['auth_shib_idp_list'] = 'Ponudniki identitet';
$string['auth_shib_idp_list_description'] = 'Navede seznam ID identitet ponudnikov identitet, da lahko uporabnik izbere na strani za prijavo. <br /> Pri vsaki vrstici mora biti z vejicami ločena n-terica za ID identitet IdP-ja (glej datoteko metapodatkov Shibboleth) in ime za IdP-ja, kot se prikažejo na spustnem seznamu. <br /> Kot izbirni tretji parameter lahko dodate lokacijo pobudnika seje Shibboleth, ki se uporablja v primeru, če je vaša Moodle namestitev del multi-setup zveze.';
$string['auth_shib_instructions'] = 'Uporabite <a href="{$a}">prijavo Shibboleth</a> za pridobitev dostopa prek Shibboleth, če vaša organizacija to podpira.<br />Sicer uporabite navaden tu prikazan prijavni obrazec.';
$string['auth_shib_instructions_help'] = 'Tu morate zagotoviti lastna navodila za vaše uporabnike, da jim razložite Shibboleth.  Prikazana bodo na strani prijave v področju navodil. Navodila morajo vključevati povezavo do "<b>{$a}</b>", ki jo uporabniki kliknejo, ko se želijo prijaviti.';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF storitev';
$string['auth_shib_integrated_wayf_description'] = 'Če potrdite to, bo Moodle uporabljal svojo storitev WAYF namesto storitve konfigurirane za Shibboleth. Moodle bo prikazal spustni seznam na alternativni stran za prijavo, kjer uporabnik izbere identiteto svojega ponudnika.';
$string['auth_shib_logout_return_url'] = 'Alternativni URL naslov odjave';
$string['auth_shib_logout_return_url_description'] = 'Navedite spletni naslov, kamor bodo po odjavi preusmerjeni Shibboleth uporabniki. <br /> Če pustite prazno, bodo uporabniki preusmerjeni na mesto, kamor moodle preusmerja uporabnike';
$string['auth_shib_logout_url'] = 'Shibboleth Service Provider odjavni upravljalec URL';
$string['auth_shib_logout_url_description'] = 'Navedite spletni naslov za Shibboleth Service Provider odjavnega upravljalca. To je običajno <tt> / Shibboleth.sso/Logout  </ tt>';
$string['auth_shib_no_organizations_warning'] = 'Če želite uporabiti vključeno storitev WAYF, morate dodati ID spisek ponudnikov preverjanja pristnosti (Identity Provider entityID), ločenih z vejico, njihova imena in opcijsko pobudnika seje (session initiator).';
$string['auth_shib_only'] = 'Samo Shibboleth';
$string['auth_shib_only_description'] = 'Označite to možnost, če naj bo preverjanje pristnosti Shibboleth vsiljeno';
$string['auth_shib_username_description'] = 'Ime spremenljivke okolja spletnega strežnika Shibboleth, ki naj se uporabi kot Moodle uporabniško ime';
$string['pluginname'] = 'Shibboleth';
$string['shib_no_attributes_error'] = 'Kot kaže je vaša pristnost potrjena z mehanizmom Shibboleth, vendar Moodle ni prejel nobenih uporabniških atributov. Prosimo preverite, če vaš ponudnik identitete objavlja potrebne lastnosti ({$a}) ponudniku storitev kjer teče Moodle ali obvestite skrbnika tega strežnika.';
$string['shib_not_all_attributes_error'] = 'Moodle potrebuje nekatere lastnosti Shibboleth, ki v vašem primeru niso prisotne. Te lastnosti so: {$a}<br />Prosimo povprašajte skrbnika tega strežnika ali vašega ponudnika identitete.';
$string['shib_not_set_up_error'] = 'Preverjanje pristnosti Shibboleth kot kaže ni pravilno nastavljeno, saj za to stran ni prisotnih spremenljivk okolja Shibboleth. Preverite v datoteki <a href="README.txt">README</a> za nadaljna navodila, kako nastaviti preverjanje pristnosti Shibboleth ali povprašajte skrbnika te namestitve Moodle.';
