<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Imate naloge za pregled';
$string['addsubmission'] = 'Oddaj nalogo';
$string['allowdeleting'] = 'Dovoli brisanje';
$string['allowdeleting_help'] = '<p>Če je možnost omogočena, bodo lahko udeleženci naložene datoteke izbrisali kadarkoli pred oddajo za ocenjevanje.</p>';
$string['allowmaxfiles'] = 'Največje število naloženih datotek';
$string['allowmaxfiles_help'] = '<p>To določa največje število datotek, ki jih lahko vsak udeleženec naloži pri nalogi. Ta številka se udeležencem ne prikaže, zato je priporočljivo, da zahtevano število datotek napišete med opisom naloge.</p>';
$string['allownotes'] = 'Dovoli opombe';
$string['allownotes_help'] = '<p>Če možnost omogočite, bodo lahko udeleženci v polje besedila dodali svoje opombe. Podobno je pomoče pri nalogi vrste Besedilo prek spleta.</p>

<p>To besedilo (opombe) se lahko uporablja za komunikacijo z ocenjevalcem, beleženje napredka pri dejavnosti ali za drugo pisno dejavnost.</p>';
$string['allowresubmit'] = 'Dovoli ponovno oddajo';
$string['allowresubmit_help'] = '<p>Kot privzeto udeleženci ne morejo ponovno oddati nalog po tem, ko jih je izvajalec ocenil.</p>

<p>Če to možnost vključite, bodo udeleženci smeli ponovno oddati naloge po tem, ko so bile ocenjene (za ponovno oceno).  To je lahko uporabno, če želi izvajalec spodbujati udeležence k izboljšanju svojega dela v ponavljajočem procesu.</p>

<p>Ta možnost seveda ni smiselna za naloge brez povezave.</p>';
$string['alreadygraded'] = 'Vaša naloga je bila že ocenjena in ponovna oddaja ni dovoljena.';
$string['assignment:addinstance'] = 'Dodaj novo nalogo';
$string['assignmentdetails'] = 'Podrobnosti naloge';
$string['assignment:exportownsubmission'] = 'Izvozi svojo oddajo';
$string['assignment:grade'] = 'Oceni nalogo';
$string['assignmentmail'] = '{$a->teacher} je objavil/a odziv na vašo
oddano nalogo \'{$a->assignment}\'

Odziv je bil dodan vaši nalogi:

    {$a->url}';
$string['assignmentmailhtml'] = '{$a->teacher} je objavil/a odziv na vašo oddano nalogo \'<i>{$a->assignment}</i>\'<br /><br /> Odziv je dodan <a href="{$a->url}">vaši nalogi</a>.';
$string['assignmentmailsmall'] = '{$a->teacher} je objavil/a odziv na vašo
oddano nalogo \'{$a->assignment}\'. Odziv je dodan vaši nalogi.';
$string['assignmentname'] = 'Ime naloge';
$string['assignmentsubmission'] = 'Oddaje nalog';
$string['assignment:submit'] = 'Oddaj nalogo';
$string['assignmenttype'] = 'Vrsta naloge';
$string['assignment:view'] = 'Poglej nalogo';
$string['availabledate'] = 'Na voljo od';
$string['cannotdeletefiles'] = 'Prišlo je do napake in datotek ni bilo moč izbrisati';
$string['cannotviewassignment'] = 'Te naloge ne morete pogledati';
$string['changegradewarning'] = 'Naloga že vsebuje ocenjene prispevke in s spremembo ocene le-ti ne bodo samodejno ponovno ocenjeni. Če želite spremeniti oceno naloge, morate vse oddane prispevke ponovno oceniti.';
$string['closedassignment'] = 'Naloga je zaključena, ker je rok za oddajo potekel.';
$string['comment'] = 'Komentar';
$string['commentinline'] = 'Medvrstični komentarji';
$string['commentinline_help'] = '<p>Če je izbrana ta možnost, bo izvorno oddano delo kopirano v polje povratnega komentarja ob ocenjevanju. Tako je lažje vstavljati komentarje (verjetno z uporabo druge barve) ali urediti izvorno besedilo.</p>';
$string['configitemstocount'] = 'Vrsta elementov, ki naj bodo šteti pri oddanih nalogah na spletu.';
$string['configmaxbytes'] = 'Privzeta največja velikost naloge za vse naloge na spletnem mestu (predmet omejitev predmeta in drugih lokalnih nastavitev)';
$string['configshowrecentsubmissions'] = 'Vsak lahko vidi obvestila o oddanih nalogah v poročilih o nedavnih dejavnostih.';
$string['confirmdeletefile'] = 'Ali ste prepričani, da želite izbrisati to datoteko?<br /><strong>{$a}</strong>';
$string['coursemisconf'] = 'Predmet je narobe konfiguriran';
$string['currentgrade'] = 'Trenutno ocena v redovalnici';
$string['deleteallsubmissions'] = 'Zbriši vse oddane naloge';
$string['deletefilefailed'] = 'Izbris ni bil uspešen.';
$string['description'] = 'Opis';
$string['downloadall'] = 'Prenesi vse naloge v stisnjeni (.zip) obliki';
$string['draft'] = 'Osnutek';
$string['due'] = 'Naloga poteče';
$string['duedate'] = 'Rok za oddajo';
$string['duedateno'] = 'Brez roka';
$string['early'] = '{$a} do roka';
$string['editmysubmission'] = 'Uredi oddano nalogo';
$string['editthesefiles'] = 'Uredi te datoteke';
$string['editthisfile'] = 'Posodobi to datoteko';
$string['emailstudents'] = 'Obvesti udeležence prek e-pošte';
$string['emailteachermail'] = '{$a->username} je posodobil/a svojo oddano nalogo \'{$a->assignment}\' ob {$a->timeupdated}.

Na voljo je tu:

    {$a->url}';
$string['emailteachermailhtml'] = '{$a->username} je <i>{$a->timeupdated}</i> posodobil/a svojo oddano nalogo
za <i>\'{$a->assignment}\'</i><br /><br />
Oddana naloga <a href="{$a->url}">je na voljo na spletni strani</a>.';
$string['emailteachers'] = 'Obvesti izvajalce prek e-pošte';
$string['emailteachers_help'] = '<p>Če je možnost omogočena, bodo izvajalci obveščeni s kratkim e-poštnim sporočilom, ko bodo udeleženci dodali ali posodobili oddajo naloge.</p>

<p>Obveščeni bodo samo izvajalci, ki smejo ocenjevati določeno oddajo. Tako na primer v predmetu z ločenimi skupinami izvajalci, omejeni na določeno skupino, ne bodo obveščeni o dejavnosti udeležencev iz drugih skupin.</p>

<p>Za dejavnosti brez povezave e-pošta seveda ne bo nikoli poslana, saj udeleženci nikoli ne oddajo ničesar.</p>';
$string['emptysubmission'] = 'Ničesar še niste oddali';
$string['enablenotification'] = 'Pošlji obvestila preko e-pošte';
$string['enablenotification_help'] = '<p>Če vklopite to možnost, bodo študenti prek e-pošte obveščeni o svojih ocenah in drugih odzivih.</p>

<p>Vaša izbira se shrani in bo uporabljena za vse ocene oddanih nalog.</p>';
$string['errornosubmissions'] = 'Ni oddanih nalog za prenos';
$string['existingfiledeleted'] = 'Obstoječa datoteka je bila izbrisana: {$a}';
$string['failedupdatefeedback'] = 'Neuspešno posodabljanje odziva za uporabnika {$a}';
$string['feedback'] = 'Odziv';
$string['feedbackfromteacher'] = 'Odziv od {$a}';
$string['feedbackupdated'] = 'Odziv na oddano nalogo posodobljen za {$a} oseb';
$string['finalize'] = 'Prepreči spremembe oddanih nalog';
$string['finalizeerror'] = 'Prišlo je do napake in oddaje ni bilo mogoče zaključiti';
$string['futureaassignment'] = 'Ta naloga še ni na voljo.';
$string['graded'] = 'Ocenjen';
$string['guestnosubmit'] = 'Žal gostom oddajanje nalog ni dovoljeno. Pred oddajo odgovora se morate prijaviti / registrirati.';
$string['guestnoupload'] = 'Žal gostom nalaganje datotek ni dovoljeno';
$string['helpoffline'] = '<p>To je koristno, če se naloga izvaja izven sistema Moodle. Lahko je nekaj drugje na spletu ali izvedena v živo.</p><p>Udeleženci lahko vidijo opis naloge,
   a ne morejo nalagati datotek ali česa drugega. Ocenjevanje deluje normalno in udeleženci bodo obveščeni o svojih ocenah.</p>';
$string['helponline'] = '<p>Ta vrsta naloge zahteva od uporabnikov urejanje besedila z uporabo normalnih orodij za urejanje. Izvajalci jih lahko ocenjujejo prek spleta in celo dodajo medvrstične komentarje ali spremembe.</p>
   <p>(Če ste seznanjeni s starejšimi različicami okolja Moodle, ta vrsta naloge
   počne isto, kot je počel stari modul dnevnika (Journal).)</p>';
$string['helpupload'] = '<p>Ta vrsta naloge dovoljuje vsakemu sodelujočemu nalaganje ene ali več datotek v kateremkoli formatu. Datoteke so lahko Wordovi dokumenti, slike, spletna stran v datoteki .zip ali v kateremkoli drugem zahtevanem formatu.</p>
<p>Ta vrsta naloge omogoča tudi nalaganje več datotek z odzivi. Datoteke z odzivi se lahko naložijo tudi pred oddajo, kar se lahko uporabi za to, da se vsakemu udeležencu dodeli druga datoteka, s katero mora udeleženec delati.</p> <p>Oddane naloge pri tej vrsti dejavnosti morajo biti ročno zaključene s strani udeleženca. Kot izvajalec lahko stanje preverite kadarkoli; nedokončane naloge so označene kot Osnutki. Katerikoli neocenjeni nalogi lahko stanje spremenite nazaj v \'Osnutek\'.</p>';
$string['helpuploadsingle'] = '<p>Ta vrsta naloge vsakemu udeležencu dovoljuje nalaganje ene datoteke poljubne vrste.</p><p>To je lahko Wordov dokument, slika, spletna stran v datoteki .zip ali v katerikoli drugi zahtevan format.</p>';
$string['hideintro'] = 'Skrij opis pred datumom dostopnosti naloge';
$string['hideintro_help'] = '<p>Če je ta možnost omogočena, se opis naloge ne bo prikazal pred datumom, od katerega je dejavnost dostopna.</p>';
$string['invalidassignment'] = 'Nepravilna nologa';
$string['invalidfileandsubmissionid'] = 'Manjkajoča datoteka ali ID oddaje';
$string['invalidid'] = 'ID naloge je napačen';
$string['invalidsubmissionid'] = 'Neveljaven ID oddaje';
$string['invalidtype'] = 'Napačen tip naloge';
$string['invaliduserid'] = 'Napačen uporabniški ID';
$string['itemstocount'] = 'Štetje';
$string['lastgrade'] = 'Zadnja ocena';
$string['late'] = '{$a} prepozno';
$string['maximumgrade'] = 'Najvišja ocena';
$string['maximumsize'] = 'Največja velikost';
$string['messageprovider:assignment_updates'] = 'Obvestila o nalogi';
$string['modulename'] = 'Naloga (2.2)';
$string['modulename_help'] = '<p><img alt="" src="<?php echo $CFG->wwwroot?>/mod/assignment/icon.gif" /> <b>Naloge</b></p>
<div class="indent">
Naloge omogočajo izvajalcu določiti opravilo, ki zahteva od udeležencev pripravo digitalne vsebine (v poljubni obliki) in njeno oddajo z nalaganjem na strežnik. Običajne naloge vsebujejo eseje, projekte, poročila in tako naprej. Ta modul vsebuje pripomoček za ocenjevanje.
</div>';
$string['modulenameplural'] = 'Naloge';
$string['newsubmissions'] = 'Oddane naloge';
$string['noassignments'] = 'Ni še nalog';
$string['noattempts'] = 'Za to nalogo še ni bilo opravljenega poskusa';
$string['nofiles'] = 'Ni bilo oddanih datotek';
$string['nofilesyet'] = 'Ni še oddanih datotek';
$string['nomoresubmissions'] = 'Ponovne oddaje naloge niso dovoljene.';
$string['norequiregrading'] = 'Ni nalog za ocenjevanje';
$string['nosubmisson'] = 'Ni oddanih nalog';
$string['notavailableyet'] = 'Žal naloga še ni na voljo.<br /> Navodila za nalogo bodo prikazana tukaj od spodnjega datuma naprej.';
$string['notes'] = 'Opombe';
$string['notesempty'] = 'Brez vnosa';
$string['notesupdateerror'] = 'Pri posodabljanju opomb je prišlo do napake';
$string['notgradedyet'] = 'Še neocenjeno';
$string['notsubmittedyet'] = 'Še ne oddano';
$string['onceassignmentsent'] = 'Ko je naloga poslana za ocenjevanje, ji ne boste mogli več izbrisati ali posodobiti datotek(e). Želite nadaljevati?';
$string['optionalsettings'] = 'Opcijske nastavitve';
$string['overwritewarning'] = 'Opozorilo: ponovno nalaganje bo ZAMENJALO vaše trenutno oddano delo';
$string['page-mod-assignment-submissions'] = 'Stran za oddajo naloge';
$string['page-mod-assignment-view'] = 'Glavna stran za modula Naloga';
$string['page-mod-assignment-x'] = 'Katerakoli stran modula Naloga';
$string['pagesize'] = 'Število prikazanih oddaj na stran';
$string['pluginadministration'] = 'Administracija modula Naloga';
$string['pluginname'] = 'Naloga (2.2)';
$string['popupinnewwindow'] = 'Odpri v pojavnem oknu';
$string['preventlate'] = 'Prepreči prepozno oddajanje';
$string['quickgrade'] = 'Dovoli hitro ocenjevanje';
$string['quickgrade_help'] = '<p>Z omogočenim hitrim ocenjevanjem lahko hitro ocenite več nalog na eni strani.</p>

<p>Samo spremenite ocene in komentarje in uporabite gumb Shrani na dnu, da hkrati shranite vse vaše spremembe za to stran.</p>

<p>Običajni gumbi za ocenjevanje na desni prav tako delujejo še naprej v primeru, če bi potrebovali več prostora. Vaša nastavitev hitrega ocenjevanja je shranjena in bo veljala za vse naloge v vseh predmetih.</p>';
$string['requiregrading'] = 'Potrebno ocenjevanje';
$string['responsefiles'] = 'Datoteke z odzivi';
$string['reviewed'] = 'Pregledano';
$string['saveallfeedback'] = 'Shrani vse moje odzive';
$string['sendformarking'] = 'Pošlji za ocenjevanje';
$string['showrecentsubmissions'] = 'Prikaži nedavno oddane naloge';
$string['submission'] = 'Oddaja';
$string['submissiondraft'] = 'Osnutek oddaje';
$string['submissionfeedback'] = 'Odziv na oddane naloge';
$string['submissions'] = 'Oddaje';
$string['submissionsaved'] = 'Vaše spremembe so bile shranjene';
$string['submissionsnotgraded'] = '{$a} oddanih nalog še ni ocenjenih';
$string['submitassignment'] = 'Oddajte vašo nalogo prek tega obrazca';
$string['submitedformarking'] = 'Naloga je bila poslana v ocenjevanje in je ni mogoče posodobiti';
$string['submitformarking'] = 'Končna oddana naloga za ocenjevanje';
$string['submitted'] = 'Oddano';
$string['submittedfiles'] = 'Oddane datoteke';
$string['subplugintype_assignment'] = 'Vrsta naloge';
$string['subplugintype_assignment_plural'] = 'Vrste nalog';
$string['trackdrafts'] = 'Omogoči "Pošlji za ocenjevanje"';
$string['trackdrafts_help'] = '<p>Gumb "Pošlji v ocenjevanje" uporabnikom omogoča, da ocenjevalcem sporočijo, da so končali z delom na nalogi. Ocenjevalci se lahko odločijo, da status naloge ponovno spremenijo v osnutek (če je na primer nalogo potrebno dopolniti).</p>';
$string['typeblog'] = 'Blog objava';
$string['typeoffline'] = 'Dejavnost brez povezave';
$string['typeonline'] = 'Besedilo prek spleta';
$string['typeupload'] = 'Napredno nalaganje datotek';
$string['typeuploadsingle'] = 'Nalaganje ene datoteke';
$string['unfinalize'] = 'Spremeni nazaj v osnutek';
$string['unfinalizeerror'] = 'Prišlo je do napake in oddane naloge ni bilo moč spremeniti v osnutek';
$string['unfinalize_help'] = 'Sprememba v osnutek omogoča udeležencu nadaljnje posodobitve njegove naloge';
$string['uploadafile'] = 'Naloži datoteko';
$string['uploadbadname'] = 'Datoteke ni bilo moč naložiti, saj vsebuje nenavadne znake';
$string['uploadedfiles'] = 'naložene datoteke';
$string['uploaderror'] = 'Prišlo je do napake pri shranjevanju datoteke na strežnik';
$string['uploadfailnoupdate'] = 'Datoteka je bila uspešno naložena, a vaše oddaje bilo možno posodobiti!';
$string['uploadfiles'] = 'Naloži datoteke';
$string['uploadfiletoobig'] = 'Datoteka je prevelika (omejitev je {$a} bajtov)';
$string['uploadnofilefound'] = 'Nobene datoteke ni bilo mogoče najti - ste prepričani, da ste izbrali datoteko za nalaganje?';
$string['uploadnotregistered'] = '\'{$a}\' je bila uspešno naložena, a se oddaja ni zabeležila!';
$string['uploadsuccess'] = 'Uspešno naloženo \'{$a}\'';
$string['usermisconf'] = 'Uporabnik ni pravilno konfiguriran';
$string['usernosubmit'] = 'Žal nimate dovoljenja za oddajo naloge.';
$string['viewfeedback'] = 'Poglej ocene naloge in odzive nanjo';
$string['viewmysubmission'] = 'Poglej mojo oddajo';
$string['viewsubmissions'] = 'Pregled oddanih nalog ({$a})';
$string['yoursubmission'] = 'Vaša oddana naloga';
