<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sl', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Dostop zavrnjen';
$string['accounts'] = 'Računi';
$string['addcategory'] = 'Dodaj kategorijo';
$string['additionalhtml'] = 'Dodatni HTML';
$string['additionalhtml_desc'] = 'Te nastavitve vam omogočajo, da navedete HTML kodo, ki bi jo radi dodali na vsako stran. Določite lahko HTML kodo, ki bo dodana znotraj HEAD oznake, neposredno za odprtjem BODY oznake ali neposredno pred zaprtjem BODY oznake.<br />To vam bo omogočilo, da zelo enostavno in neodvisno od izbrane teme, na vsako stran dodate po meri izdelano glavo ali nogo strani, ali dodate podporo za storitve kot na primer Google Analytics.';
$string['additionalhtmlfooter'] = 'Pred zaprtjem BODY oznake';
$string['additionalhtmlfooter_desc'] = 'Tukajšnja vsebina bo dodana v vsako stran neposredno pred zaprtjem BODY oznake.';
$string['additionalhtmlhead'] = 'Znotraj HEAD';
$string['additionalhtmlhead_desc'] = 'Tukajšnja vsebina bo dodana na dno HEAD oznake za vsako stran.';
$string['additionalhtml_heading'] = 'Dodatna HTML koda, ki naj bo dodana na vsako stran.';
$string['additionalhtmltopofbody'] = 'Ob odprtju BODY oznake';
$string['additionalhtmltopofbody_desc'] = 'Tukajšnja vsebina bo dodana v vsako stran neposredno pred odprtjem BODY oznake.';
$string['admincategory'] = 'Kategorija: {$a}';
$string['adminseesall'] = 'Skrbniki vidijo vse';
$string['adminseesallevents'] = 'Skrbniki vidijo vse dogodke';
$string['adminseesownevents'] = 'Skrbniki so enaki drugim uporabnikom';
$string['advancedfeatures'] = 'Napredne zmožnosti';
$string['allcountrycodes'] = 'Vse oznake držav';
$string['allowbeforeblock'] = 'Seznam dovoljenih bo najprej obdelan';
$string['allowbeforeblockdesc'] = 'Privzeto so vpisi na seznamu blokiranih IP-jev prikazani prvi. Če je ta možnost omogočena, so vpisi v seznamu dovoljenih IP-jev obdelani pred blokiranimi.';
$string['allowblockstodock'] = 'Dovoli blokom, da uporabljajo odlagališče';
$string['allowcategorythemes'] = 'Dovoli teme kategorij';
$string['allowcoursethemes'] = 'Dovoli teme predmetov';
$string['allowediplist'] = 'Seznam dovoljenih IP naslovov';
$string['allowemailaddresses'] = 'Dovoljene domene e-poštnih naslovov';
$string['allowframembedding'] = 'Omogočite vstavljanje okvirjev';
$string['allowframembedding_help'] = 'Dovolite vstavljanje te strani v okvirje na zunanjih spletnih straneh. Omogočanje te funkcije ni priporočljivo zaradi varnostnih razlogov.';
$string['allowguestmymoodle'] = 'Dovoli dostop gosta do strani Moj dom';
$string['allowobjectembed'] = 'Dovoli oznake EMBED in OBJECT';
$string['allowthemechangeonurl'] = 'Dovoli spremembo teme v URL-ju';
$string['allowuserblockhiding'] = 'Uporabnikom dovoli skrivanje blokov';
$string['allowuserswitchrolestheycantassign'] = 'Dovoli uporabnikom brez zmožnosti za dodeljevanje vlog, da zamenjajo vloge';
$string['allowuserthemes'] = 'Dovoli uporabniške teme';
$string['antivirus'] = 'Antivirus';
$string['appearance'] = 'Videz';
$string['aspellpath'] = 'Pot do črkovalnika aspell';
$string['authentication'] = 'Avtentikacija';
$string['authpreventaccountcreation'] = 'Prepreči ustvarjanje računa med avtentikacijo';
$string['authpreventaccountcreation_help'] = 'Ko se uporabnik avtenticira, se njegov račun avtomatično ustvari, če ta še ne obstaja. Izberite to možnost, če za overjanje uporabljate zunanjo podatkovno zbirko (npr. LDAP) in želite dovoliti dostop le uporabnikom, ki že imajo svoj račun. Nove račune boste morali ustvariti ročno ali pa s pomočjo funkcije nalaganja uporabnikov. Upoštevajte, da ta nastavitev ne velja za MNet avtentikacijo.';
$string['authsettings'] = 'Nastavi avtentikacijo';
$string['autolang'] = 'Samodejno zaznavanje jezika';
$string['autologinguests'] = 'Samodejna prijava gostov';
$string['availablelicenses'] = 'Licence na voljo';
$string['availableto'] = 'Na voljo za';
$string['backgroundcolour'] = 'Prosojna barva';
$string['backups'] = 'Varnostne kopije';
$string['backup_shortname'] = 'Uporabite ime predmeta v imenu datoteke varnostne kopije.';
$string['backup_shortnamehelp'] = 'Uporabite ime predmeta kot del imena datoteke varnostne kopije.';
$string['badwordsconfig'] = 'Vnesite svoj seznam slabih besed. Besede ločite z vejicami.';
$string['badwordsdefault'] = 'Če je seznam po meri prazen, bo uporabljen privzet seznam iz jezikovnega paketa.';
$string['badwordslist'] = 'Seznam slabih besed po meri';
$string['blockediplist'] = 'Seznam blokiranih IP naslovo';
$string['blockinstances'] = 'Št. primerkov';
$string['blockmultiple'] = 'Večkraten';
$string['blockprotect'] = 'Zaščita primerkov';
$string['blockprotect_help'] = 'Če zaklenete določen tip bloka, nihče ne more vanj dodajati ali brisati elementov. (Seveda ga lahko odklenete in elemente popravite.)

Ta možnost je namenjena varovanju blokov, kot je navigacija ali nastavitve, ki jih je zelo težko povrnit, če so po nesreči izbrisani.';
$string['blocksettings'] = 'Nastavi bloke';
$string['blockunprotect'] = 'Odstrani zaščito';
$string['bloglevel'] = 'Vidnost bloga';
$string['bookmarkadded'] = 'Zaznamek je dodan.';
$string['bookmarkalreadyexists'] = 'Stran je bila že dodana med zaznamke.';
$string['bookmarkdeleted'] = 'Zaznamek je izbrisan.';
$string['bookmarkthispage'] = 'dodaj stran kot zaznamek';
$string['cacheapplication'] = 'Aplikacijski predpomnilnik';
$string['cacheapplicationhelp'] = 'Predpomnjene elemente si lahko delijo vsi uporabniki. Potečejo glede na vrednost parametra TTL.';
$string['cachejs'] = 'Predpomni JavaScript';
$string['cachejs_help'] = 'Predpomnjenje in stiskanje JavaScript-a močno izboljša zmogljivost nalaganje strani. Za produkcijske strani je zelo priporočeno. Razvijalci bodo verjetno želeli to zmožnost onesposobiti.';
$string['cacherequest'] = 'Zahtevajte predpomnjenje';
$string['cacherequesthelp'] = 'Poseben uporabniški predpomnilnik, ki poteče, ko je zahteva izpolnjena. Nadomešča območja, kjer uporabljamo statične pomnilnike.';
$string['cachesession'] = 'Predpomnilnik seje';
$string['cachesessionhelp'] = 'Poseben uporabniški predpomnilnik, ki poteče, ko se konča uporabniška seja. Ustvarjen je za zmanjšanje učinkov rasti/obremenitve sej.';
$string['cachesettings'] = 'Nastavitve predpolnilnika';
$string['cachetext'] = 'Čas hranjenja teksta v predpomnilniku';
$string['caching'] = 'Predpomnjenje';
$string['calendarexportsalt'] = 'Varnostni niz za izvoz koledarja';
$string['calendarsettings'] = 'Koledar';
$string['calendartype'] = 'Tip koledarja';
$string['calendar_weekend'] = 'Dnevi vikenda';
$string['cannotdeletemodfilter'] = 'Namestitev \'{$a->filter}\' ne morete odstraniti, ker je del \'{$a->module}\' modula.';
$string['cannotuninstall'] = '{$a} ne more biti odstranjen';
$string['cfgwwwrootslashwarning'] = 'Pri nastavitvi $CFG->wwwroot v datoteki config.php je prišlo do napake. Na koncu niza ste vključili znak \'/\'. Prosimo, odstranite znak, drugače lahko povzročite sistemske napake, kot denimo <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Pri nastavitvi $CFG->wwwroot v datoteki config.php je prišlo do napake. Nastavitev se ne ujema z URL naslovom, ki ga uporabljate za dostop do te strani. Prosimo, odpravite napako, drugače lahko povzročite sistemske napake, kot denimo <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'spremeni';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Da';
$string['choosefiletoedit'] = 'V zgornjem polju izberite datoteko za urejanje';
$string['clamfailureonupload'] = 'Ob odpovedi Clam AV';
$string['cleanup'] = 'Čiščenje';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'd';
$string['cliincorrectvalueerror'] = 'Napaka, nepravilna vrednost "{$a->value}" za "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nepravilna vrednost, prosimo poskusite znova.';
$string['clistatusdisabled'] = 'Status: onemogočeno';
$string['clistatusenabled'] = 'Status: omogočeno';
$string['clistatusenabledlater'] = 'status: CLI vzdrževalni način bo omogočen na {$a}';
$string['clitypevalue'] = 'tip vrednosti';
$string['clitypevaluedefault'] = 'tip vrednosti, kliknite Enter za uporabo privzete vrednosti ({$a})';
$string['cliunknowoption'] = 'Neprepoznane možnosti:
{$a}
Uporabite --help opcijo.';
$string['cliupgradefinished'] = 'Nadgradnja v ukazni vrstici zaključena uspešno.';
$string['cliupgradenoneed'] = 'Nadgradnja za nameščeno verzijo {$a} ni potrebna. Vseeno hvala, ker ste prišli!';
$string['cliyesnoprompt'] = 'pritisnite d (pomeni da) ali n (pomeni ne)';
$string['commentsperpage'] = 'Število komentarjev, prikazanih na strani';
$string['commonfiltersettings'] = 'Skupne nastavitve filtra';
$string['commonsettings'] = 'Skupne nastavitve';
$string['componentinstalled'] = 'Komponenta je nameščena';
$string['computedfromlogs'] = 'Izračunano iz dnevniških datotek od dneva {$a}.';
$string['condifmodeditdefaults'] = 'Vrednosti, ki jih nastavite tukaj, določajo privzete vrednosti, ki se uporabljajo v nastavitvah dejavnostih, ko ustvarite novo dejavnost. Prav tako lahko nastavite, katere nastavitve dejavnosti so smatrajo za napredne.';
$string['confeditorhidebuttons'] = 'Izberite gumbe, ki bodo skriti v HTML urejevalniku.';
$string['configallcountrycodes'] = 'To je seznam držav, ki se lahko izberejo na različnih mestih, na primer v profilu uporabnika. Če je prazen (privzeto) bo uporabljen seznam iz countries.php datoteke v standardnem angleškem jezikovnem paketu. To je seznam iz ISO 3166-1. V nasprotnem primeru lahko določite z vejico ločen seznam oznak, na primer "GB, FR, ES". Če sem dodate novo, nestandardno oznako, jo morate dodati tudi v countries.php v "en" in vašem jezikovnem paketu.';
$string['configallowassign'] = 'Vlogam na levi strani dovoli določitev vlog označenih v posamezni koloni';
$string['configallowblockstodock'] = 'Če je omogočeno in podprto z izbrano temo, lahko uporabniki premikajo bloke v posebno odlagališče.';
$string['configallowcategorythemes'] = 'Ta nastavitev omogoča nastavljanje tem na nivoju kategorije. Nastavitev vpliva na vse podrejene kategorije in predmete, razen v primeru, da imajo nastavljeno svojo temo. OPOZORILO: Omogočanje tem kategorij lahko vpliva na hitrost delovanja.';
$string['configallowcoursethemes'] = 'Če to omogočite, bo pri predmetih možna nastavitev lastnih tem.  Teme predmetov povozijo vse druge izbore tem (teme spletnega mesta, uporabnika ali seje).';
$string['configallowemailaddresses'] = 'Če želite omejiti vse nove e-poštne naslove na določene domene, jih navedite tu in ločite s presledki.  Vse druge domene bodo zavrnjene.  Primer: <strong>nasasola.arnes.si uni-mb.si gov.si</strong>';
$string['configallowguestmymoodle'] = 'Če je omogočeno, bo gostom dovoljen dostop do strani Moj dom, sicer bodo preusmerjeni na vstopno stran.';
$string['configallowobjectembed'] = 'Kot privzet varnostni ukrep navadnim uporabnikom v besedilih ni dovoljeno vključiti večpredstavnosti (kot je Flash) z uporabo oznak EMBED in OBJECT v HTML kodi (čeprav je to še vedno moč varno narediti  z uporabo filtra medijskih vtičnikov). Če želite dovoliti te oznake, omogočite to možnost.';
$string['configallowoverride'] = 'Vlogam na levi strani dovoli, da povozijo vloge označene v posamezni koloni';
$string['configallowoverride2'] = 'Določite, katere vloge lahko povozijo vloge na levi strani.<br />Nastavitev velja samo za uporabnike, ki imajo dovoljeno funkcijo moodle/role:override ali moodle/role:safeoverride.';
$string['configallowswitch'] = 'Izberite, katere vloge lahko uporabnik zamenja glede na vloge, ki jih že ima. Poleg vnosa v teh tabeli mora uporabnik imeti tudi pravico moodle/role:switchroles če želi menjati vloge.<br />To je možno le za zamenjavo v vloge, ki imajo zmožnost moodle/course:view in nimajo zmožnosti moodle/site:doanything, zato so nekateri stolpci v tej tabeli onemogočeni.';
$string['configallowthemechangeonurl'] = 'Če je omogočeno, se lahko temo spremeni z dodajanjem theme={themename} v katerikoli Moodle URL.';
$string['configallowuserblockhiding'] = 'Želite uporabnikom dovoliti skrivanje/prikazovanje stranskih blokov na celotnem spletnem mestu?  Ta možnost uporablja JavaScript in piškotke za pomnjenje stanja vsakega zložljivega bloka in vpliva samo na uporabnikov lastni pogled.';
$string['configallowuserswitchrolestheycantassign'] = 'Privzeto je moodle/role:assign treba nastaviti, da uporabniki lahko zamenjajo vloge. S tem ko omogočite to nastavitev, odstranite prejšnjo zahtevo. Posledično se prikazane vloge v spustnem meniju "Zamenjaj vlogo v" določijo le v nastavitvah tabele "Dovoli dodelitev vlog".';
$string['configallowuserthemes'] = 'Če to omogočite, bodo lahko uporabniki nastavili svoje lastne teme. Uporabniške teme povozijo teme spletnega mesta (a ne tem predmetov)';
$string['configallusersaresitestudents'] = 'Naj bodo VSI uporabniki šteti kot udeleženci dejavnosti na naslovni strani spletnega mesta?  Če odgovorite "Da", bo vsak potrjen uporabniški račun smel sodelovati kot udeleženec v teh dejavnostih.  Če odgovorite "Ne", bodo samo uporabniki, ki že sodelujejo v vsaj enem predmetu, smeli sodelovati v dejavnostih naslovne strani. Samo skrbniki in posebej dodeljeni izvajalci smejo delovati kot izvajalci za dejavnosti naslovne strani.';
$string['configauthenticationplugins'] = 'Prosimo, izberite administracijske vtičnike, ki jih želite uporabljati, in jih razvrstite v vrstnem redu, v katerem želite, da se poskusijo uporabiti. Za samo-registracijo skrbi vtičnik, izbran v stolpcu "Registracije" (običajno \'email\').';
$string['configautolang'] = 'Zaznaj privzeti jezik glede na nastavitve brskalnika. Če ni vključeno, je privzeti jezik odvisen od nastavitev spletnega mesta.';
$string['configautologinguests'] = 'Naj bodo obiskovalci ob vstopu v predmete z dostopom za goste samodejno prijavljeni kot gosti?';
$string['configbloglevel'] = 'Ta nastavitev omogoča omejitev ravni, do katere je možen ogled uporabniških blogov na spletnem mestu.  Vedite, da to določa najvišji kontekst BRALCA in ne pisca ali vrste objav bloga. Blogi so lahko tudi popolnoma onemogočeni, če jih sploh ne želite.';
$string['configcachetext'] = 'Za večje spletna mesta ali spletna mesta, ki uporabljajo besedilne filtre, lahko ta nastavitev resnično pospeši zadeve.  Kopije besedil bodo ohranjene v obdelani obliki za tu določeno časovno obdobje.  Nastavitev prekratkega časovnega obdobja lahko dejansko zadeve nekoliko upočasni, nastavitev predolgega obdobja pa lahko povzroči predolgo čakanje na osvežitev besedil (na primer z novimi povezavami).';
$string['configcalendarcustomexport'] = 'Omogoči izvoz po meri prilagojenega datumskega razpona iz koledarja';
$string['configcalendarexportsalt'] = 'Ta naključni tekst pomaga izboljšati varnost avtentikacijskih kod, uporabljenih za izvoz koledarja. Opozorilo: če spremenite ta niz, obstoječe kode niso več veljavne.';
$string['configclamactlikevirus'] = 'Obravnavaj datoteke kot viruse';
$string['configclamdonothing'] = 'Obravnavaj datoteke kot v redu';
$string['configclamfailureonupload'] = 'Če ste nastavili Clam, naj pregleda naložene datoteke, a je nastavljen nepravilno ali se iz neznanega vzroka ne uspe zagnati, kako naj se obnaša?  Če izberete \'Obravnavaj datoteke kot viruse\', bodo premaknjene v področje karantene ali izbrisane. Če izberete \'Obravnavaj datoteke kot v redu\', bodo datoteke premaknjene v ciljni imenik kot običajno. V obeh primerih bodo skrbniki opozorjeni, da Clam ni bil uspešen. Če izberete \'Obravnavaj datoteke kot viruse\' in se Clam ne uspe zagnati (običajno zaradi napačno vnesene poti do Clam-a), bodo VSE naložene datoteke premaknjene v podano področje karantene ali izbrisane. Bodite previdni s to nastavitvijo.';
$string['configconvertformat'] = 'Če so <i>latex</i>, <i>dvips</i> in <i>convert</i> na voljo, so slike ustvarjene v navedenem formatu. Če ne, bo uporabljen mimeTeX in ustvarjene bodo GIF slike.';
$string['configcookiehttponly'] = 'Omogoči novo funkcijo PHP 5.2.0, ki brskalnikom naroča, da naj piškotke pošljejo le s pravimi HTTP zahtevami, ne pa na zahtevo skripte. Vsi brskalniki te funkcije ne podpirajo, možno pa je tudi, da ni popolnoma združljiva s trenutno kodo. Pomaga pri preprečevanju določenih vrst napadov XSS.';
$string['configcookiesecure'] = 'Če strežnik sprejema samo povezave https, je priporočen vklop funkcije pošiljanja varnih piškotkov. Če je ta funkcija omogočena, zagotovite, da strežnik ne sprejema povezav tipa http:// ali pa nastavite stalno preusmeritev na naslov https://. V primeru, da se <em>wwwroot</em> ne začne s https://, se ta nastavitev samodejno onemogoči.';
$string['configcountry'] = 'Če tu nastavite državo, bo ta država privzeto izbrana za nove uporabniške račune. Če želite uporabnike prisiliti k izbiri državi, pustite možnost nenastavljeno.';
$string['configcourseoverviewfilesext'] = 'Z vejicami ločen seznam dovoljenih končnic datotek v povzetku predmeta.';
$string['configcourseoverviewfileslimit'] = 'Največje število datotek, ki jih lahko pripnete povzetku predmeta.';
$string['configcourserequestnotify'] = 'Vnesite uporabniško ime uporabnika, ki bo obveščen v primeru zahteve po novem predmetu.';
$string['configcourserequestnotify2'] = 'Uporabniki, ki bodo obveščeni v primeru zahteve po novem predmetu. Izpisani so samo uporabniki, ki lahko potrdijo zahtevo.';
$string['configcoursesperpage'] = 'Vnesite število predmetov, ki naj se prikažejo na posamezni strani seznama predmetov.';
$string['configcourseswithsummarieslimit'] = 'Največje število prikazanih predmetov na seznamu, ki vključuje povzetke, preden se prikaže preprostejši seznama.';
$string['configcronclionly'] = 'Če označite to možnost, bo mogoče skripto cron pognati le iz ukazne vrstice (commandline) in ne preko spleta. Ta možnost povozi nastavitev cron gesla spodaj.';
$string['configcronremotepassword'] = 'To pomeni, da skripto cron.pho ni mogoče pognati iz spletnega brskalnika brez vnosa gesla z uporabo naslednje oblike URLja: <pre>
http://stran.primer.com/admin/cron.php?password=opensesame
</pre> Če polje pustite prazno, geslo ni potrebno.';
$string['configcurlcache'] = 'Življenjska doba za predpomnilnik cURL v sekundah';
$string['configcustommenuitems'] = 'Tukaj lahko nastavite meni po meri za prikaz v temah. Vsaka vrstica je sestavljena iz besedila menija, URL povezave (izbirno) in naslova (izbirno) orodnega namiga, ločenimi z navpičnicami. Strukturo lahko določite z vezaji. Na primer:
<pre>
Moodle skupnost|http://moodle.org
-Moodle brezplačna podpora|http://moodle.org/support
-Moodle razvoj|http://moodle.org/development
-Moodle Sledilec|http://tracker.moodle.org
-Moodle Dokumenti|http://docs.moodle.org
-Moodle Novice|http://moodle.org/news
Moodle podjetje
-Moodle komercialno gostovanje|http://moodle.com/hosting
-Moodle komercialna podpora|http://moodle.com/support
</ pre>';
$string['configdbsessions'] = 'Če je ta nastavitev omogočena, bo za hranjenje informacij o trenutnih sejah uporabljena podatkovna zbirka. To je še posebej uporabno za velika/obremenjena spletna mesta ali spletna mesta zasnovana na gruči strežnikov. Za večino spletnih mest bi verjetno morala biti ta možnost onemogočena in bo namesto tega uporabljen trdi disk strežnika. Vedite, da bo spreminjanje te nastavitve takoj odjavilo vse trenutno prijavljene uporabnike (vključno z vami). Če uporabljate MySQL, se prepričajte, da je \'max_allowed_packet\' v my.cnf (ali my.ini) nastavljen na vsaj 4M.';
$string['configdebug'] = 'Če to vključite, bo povečana raven javljanja napak PHP (error_reporting) in bo prikazanih več opozoril.  To je koristno samo za razvijalce.';
$string['configdebugdisplay'] = 'Če je vklopljeno, se bo sporočilo o napaki prikazalo na HTML strani. Čeprav priročno, ta funkcija onemogoči delovanje XHTML, JS, piškotkov in HTTP zaglavij. Če je izklopljeno, se bo sporočilo o napaki shranilo v strežniški dnevnik, kar omogoča lažje razhroščevanje. PHP nastavitev error_log določa, v kateri dnevnik se bodo shranila sporočila o napaki.';
$string['configdebugpageinfo'] = 'Omogočite, če želite informacije o strani prikazati v nogi strani.';
$string['configdebugsmtp'] = 'Vklopi obširno obveščanje o napakah med pošiljanjem poštnih sporočil strežniku SMTP.';
$string['configdebugvalidators'] = 'Omogočite, če želite imeti v nogi strani povezave do zunanjih preverjevalnikov veljavnosti. Morda boste morali ustvariti novega uporabnika z uporabniškim imenom <em>w3cvalidator</em> in omogočiti dostop gostom. Te spremembe lahko povzročijo nepooblaščen dostop do strežnika, ne omogočite tega na produkcijskih straneh!';
$string['configdefaulthomepage'] = 'To določa domačo stran za prijavljene uporabnike';
$string['configdefaultrequestcategory'] = 'Predmeti, ki jih bodo zahtevali uporabniki, bodo samodejno uvrščeni v to kategorijo.';
$string['configdefaultrequestedcategory'] = 'Privzeta kategorija, v katero se uvrstijo zahtevani predmeti, če so odobreni.';
$string['configdefaultuserroleid'] = 'Vsem prijavljenim uporabnikom bodo na nivoju spletnega mesta dodeljene zmožnosti vloge, ki jo tu določite, in bodo DODANE vsem ostalim vlogam, ki jih uporabniki že imajo. Privzeta vloga je Avtenticiran uporabnik (ali vloga Gosta v starejših verzijah). Vedite, da ta nastavitev ne bo v sporu z ostalimi vlogami uporabnikov, ampak uporabnikom zagotovi zmožnosti, ki jih ni mogoče nastaviti na nivoju predmeta (npr. objava prispevkov na blogu, upravljanje z lastnim koledarjem, ipd.).';
$string['configdeleteincompleteusers'] = 'Po preteku tega obdobja bodo delni uporabniški računi, ki niso do konca nastavljeni, izbrisani.';
$string['configdeleteunconfirmed'] = 'Če uporabljate e-poštno avtentikacijo, je to obdobje, v katerem bo sprejet uporabnikov odgovor.  Po tem obdobju bodo stari nepotrjeni računi izbrisani.';
$string['configdenyemailaddresses'] = 'Za zavrnitev e-poštnih naslovov določenih domen, jih tu naštejte na enak način. Vse druge domene bodo sprejete.  Primer: <strong>386mail.com hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Onemogoči uporabnikom spreminjanje slike v profilu.';
$string['configdisplayloginfailures'] = 'To bo izbranim uporabnikom prikazalo informacije o prejšnjih neuspešnih prijavah.';
$string['configdndallowtextandlinks'] = 'Omogočite ali onemogočite način "povleci in spusti" tudi za besedilo in povezave, poleg obstoječe možnosti za datoteke. Upoštevajte, da ta funkcija v Firefoxu ali med brskalniki ne deluje zanesljivo. Lahko se zgodi, da se podatki ne naložijo ali pa da je naloženo besedilo poškodovano.';
$string['configdocroot'] = 'Določa pot do Moodle Docs. To lahko spremenite, če želite imeti lastno spletno dokumentacijo po meri. Če to storite, morate poskrbeti, da poti v vaši dokumentaciji sledijo isti obliki kot http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Če to omogočite, se bodo povezave na Moodle Docs odprle v novem oknu.';
$string['configeditordictionary'] = 'Ta vrednost bo uporabljena v primeru, da aspell nima slovarja za jezik uporabnika.';
$string['configeditorfontlist'] = 'Izberite pisave, ki bodo prikazane v padajočem meniju urejevalnika.';
$string['configemailchangeconfirmation'] = 'Zahtevaj potrditev novega naslova v primeru, da uporabniki zamenjajo e-poštni naslov v profilu.';
$string['configenableajax'] = 'Ta nastavitev omogoča nadzorovanje uporabe AJAX-a (naprednih vmesnikov odjemalec/strežnik, ki uporabljajo Javascript) na celotnem spletnem mestu. V primeru, da možnost omogočite, bodo uporabniki vseeno lahko izbiro spremenili v lastnem profilu, v nasprotnem primeru pa bo AJAX onemogočen za vse uporabnike.';
$string['configenableblogs'] = 'To stikalo omogoča, da ima vsak uporabnik svoj blog.';
$string['configenablecalendarexport'] = 'Omogoči izvoz ali naročanje na koledarje.';
$string['configenablecomments'] = 'Omogoči komentarje';
$string['configenablecourserequests'] = 'S tem boste vsem uporabnikom dovolili zahteve za ustvarjanja novega predmeta.';
$string['configenabledevicedetection'] = 'Omogoča odkrivanje mobilnikov, pametnih telefonov, tabličnih računalnikov ali privzetih naprav (namizni računalniki, prenosni računalniki, itd) za uporabo tem in drugih funkcij.';
$string['configenablegroupmembersonly'] = 'Če je omogočeno, je dostop do dejavnosti omejen le na člane skupine. To lahko povzroči večjo obremenitev strežnika. Poleg tega je potrebno kategorije redovalnice pripraviti na določen način, da se zagotovi, da so dejavnosti skrite za tiste, ki niso člani skupine.';
$string['configenablemobilewebservice'] = 'Omogoči mobilno storitev za uradno Moodle aplikacijo  ali druge aplikacije, ki jo zahtevajo. Za več informacij, preberite {$a}';
$string['configenablerssfeeds'] = 'To stikalo bo omogočilo vire RSS za celotno spletno mesto. Da bi dejansko videli kakšno spremembo, boste morali vire RSS omogočiti tudi v posameznih modulih - pojdite v Nastavitve modulov pod Skrbniško konfiguracijo.';
$string['configenablerssfeedsdisabled'] = 'Ni na voljo, ker so viri RSS onemogočeni za celotno spletno mesto. Da bi jih omogočili, pojdite na možnost Spremenljivke pod Skrbniško konfiguracijo.';
$string['configenablerssfeedsdisabled2'] = 'RSS viri so onemogočeni na strežniku. Najprej jih morate omogočiti v meniju Server/RSS.';
$string['configenablesafebrowserintegration'] = 'To doda možnost \'Zahtevaj Safe Exam Browser\' v polje \'varnost brskalnika\' v nastavitvah kviza. Obiščite http://www.safeexambrowser.org/ za več informacij.';
$string['configenablestats'] = 'Če tu izberete \'da\', bo Moodle cron opravilo obdelalo dnevniške zapise in zbralo nekaj statistike. Trajanje opravilo bo odvisno od obsega prometa na spletnem mestu. Če to omogočite, boste lahko videli nekaj zanimivih grafov in statistik za vsak posamezen predmet ali za celotno spletno mesto.';
$string['configenabletrusttext'] = 'Privzeto bo Moodle vedno prečistil uporabniško vnesena besedila in odstranil potencialno nevarne skripte, objekte ipd. Sistem Zanesljive Vsebine je način, ki posameznim uporabnikom omogoča, da v svoje besedilo vključijo napredne funkcije brez posredovanja. Če želite omogočiti sistem, morate najprej omogočiti to nastavitev, nato pa določiti dovoljenje Zanesljive Vsebine za določeno vlogo. Besedila, ki jih bodo tovrstni uporabniki vnesli, bodo označena kot vredna zaupanja in ne bodo prečiščena pred objavo.';
$string['configenablewebservices'] = 'Spletne storitve omogočajo drugim sistemom prijavo v ta Moodle in opravljanje operacij. Za večjo varnost mora biti ta funkcija onemogočena, razen v primeru da jo zares potrebujete.';
$string['configenablewsdocumentation'] = 'Omogoči samodejno generacijo dokumentacije spletnih storitev. Uporabnik lahko dostopa do svoje dokumentacije na svoji strani z varnostnimi ključi {$a}. Na njej je prikazana dokumentacija samo za omogočene protokole.';
$string['configerrorlevel'] = 'Izberite količino opozoril PHP, ki naj se prikazujejo. Navadno je \'običajno\' najboljša izbira.';
$string['configexportlookahead'] = 'Prihodnji dnevi, ki naj se upošteva pri izvozu';
$string['configexportlookback'] = 'Pretekli dnevi, naj se upošteva pri izvozu';
$string['configextendedusernamechars'] = 'Omogočite to nastavitev, če želite uporabnikom omogočiti uporabo poljubnih znakov v njihovih uporabniških imenih (to ne vpliva na vnos dejanskih imen). Privzeto je "ne" kar omejuje uporabniška imena samo na alfanumerične male znake, podčrtaje (_) vezaje (-), pike (.) ali pri simbol (@).';
$string['configextramemorylimit'] = 'Nekatere skripte, npr. iskanje, varnostna kopija/obnavljanje ali cron zahtevajo več spomina. Nastavite večje vrednosti za večja spletna mesta.';
$string['configfilterall'] = 'Filtriraj vse nize vključno z glavami, naslovi, navigacijo in tako naprej. To je predvsem koristno, če uporabljate večjezični filter, sicer bo to samo povzročalo dodatno obremenitev strani z majhnim učinkom.';
$string['configfiltermatchoneperpage'] = 'Samodejno povezovanje filtrov bo ustvarilo eno samo povezavo za prvo najdeno ujemajoče besedilo na celotni strani. Vse ostale bodo prezrte.';
$string['configfiltermatchonepertext'] = 'Samodejno povezovanje filtrov bo ustvarilo eno samo povezavo za prvo najdeno ujemajoče besedilo v vsakem elementu (npr. vir ali blok) na strani. Vse ostale bodo prezrte. Ta nastavitev je prezrta, če je nastavitev ena na stran nastavljena na <i>da</i>.';
$string['configfilteruploadedfiles'] = 'Obdela vse naložene HTML in besedilne datoteke s filtri pred prikazovanjem, samo naložene HTML datoteke ali nobene.';
$string['configforcelogin'] = 'Običajno lahko naslovno stran spletnega mesta in seznam predmetov (a ne samih predmetov) obiskovalci berejo, ne da bi se prijavili v spletno mesto.  Če želite vsiliti prijavo obiskovalcev preden storijo KARKOLI na strani, potem omogočite to nastavitev.';
$string['configforceloginforprofiles'] = 'Omogočite to nastavitev, da boste prisilili osebe k prijavi z lastnimi računi (ne kot gost) preden bodo smeli pregledovati uporabniške profile. Privzeto je možnost omogočena.';
$string['configfrontpage'] = 'Zgoraj izbrani elementi bodo prikazani na naslovni strani spletnega mesta.';
$string['configfrontpagecourselimit'] = 'Največje število predmetov';
$string['configfrontpagecourselimithelp'] = 'Največje število prikazanih predmetov v seznamu predmetov na vstopni strani spletnega mesta.';
$string['configfrontpageloggedin'] = 'Zgoraj izbrani elementi bodo prikazani prijavljenih uporabnikom na naslovni strani spletnega mesta.';
$string['configfullnamedisplay'] = 'To določa kako naj se prikazujejo celotna imena. Za večino enojezičnih strani je najučinkovitejša privzeta nastavitev "Ime + Priimek", vendar se lahko odločite in skrijete priimke oziroma prepustite odločitev trenutnemu jezikovnemu paketu (nekateri jeziki imajo različna pravila).';
$string['configgeoipfile'] = 'Lokacija binarne datoteke GeoIP City. Ta datoteka ni del distribucije Moodle - prenesti jo morate sami z naslova <a href="http://www.maxmind.com/">MaxMind</a>. Lahko se odločite za nakup komercialne različice ali pa uporabite zastonjsko.<br />Preprosto prenesite <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> in ga razširite v imenik "{$a}" vašega strežnika.';
$string['configgetremoteaddrconf'] = 'Če je vaš strežnik za vhodnim prehodnim strežnikom (reverse proxy), lahko s to nastavitvijo določite, katera polja iz glave HTTP (HTTP headers) smejo vključevati oddaljeni IP naslov. Polja so brana po vrsti, pri tem se uporabi prvi, ki je na voljo.';
$string['configgradebookroles'] = 'Ta nastavitev vam omogoča nadzor nad tem, kdo se pojavlja v redovalnici. Uporabniki morajo imeti vsaj eno izmed teh vlog, da se pojavijo v redovalnici predmeta.';
$string['configgradeexport'] = 'Izberite, kateri izvozni formati redovalnice predstavljajo vaše primarne metode za izvažanje ocen. Izbrani vtičniki bodo nato za vsako oceno nastavili in uporabili polje "zadnje izvoženo". To lahko npr. povzroči, da so izvoženi zapisi identificirani kot "novi" ali "posodobljeni". Če niste prepričani o tej nastavitvi, pustite vse neoznačeno.';
$string['confighiddenuserfields'] = 'Izberite katera polja informacij o uporabnikih želite skriti pred drugimi uporabniki, ki niso izvajalci ali skrbniki predmeta. To bo povečalo zasebnost udeležencev. Držite tipko CTRL za izbor večih polj.';
$string['configidnumber'] = 'Ta možnost določa ali (a) Uporabnikov se sploh ne sprašuje po identifikacijski številki, (b) Uporabnike se vpraša po identifikacijski številki, a lahko pustijo polje prazno ali (c) Uporabnike se vpraša po identifikacijski številki, ki jo morajo vnesti. Če je podana se uporabnikova identifikacijska številka prikaže v njihovem profilu.';
$string['configintro'] = 'Na tej strani lahko določite vrsto konfiguracijskih spremenljivk, ki pripomorejo k pravilnem delovanju Moodle na vašem strežniku.  Ne skrbite preveč glede tega - privzete vrednosti bodo običajno delovale v redu in vedno se lahko vrnete nazaj na to stran in te nastavitve spremenite.';
$string['configintroadmin'] = 'Na tej strani morate konfigurirati vaš glavni skrbniški račun, ki bo imel popoln nadzor nad tem spletnim mestom. Zagotovite varno uporabniško ime in geslo ter veljaven naslov elektronske pošte.  Pozneje lahko ustvarite več skrbniških računov.';
$string['configintrosite'] = 'Ta stran vam omogoča konfiguracijo naslovnice in imena tega novega spletnega mesta.  Pozneje se lahko vrnete sem in spremenite te nastavitve s povezavo \'Nastavitve spletnega mesta\' na domači strani.';
$string['configiplookup'] = 'Ko kliknete na IP naslov (kot npr. 34.12.222.93) npr. v dnevniških zapisih, se vam prikaže mapa z najboljšo domnevo o lokaciji IPja. Pri tem lahko izbirate med različnimi vtičniki; vsak imajo svoje prednosti in slabosti.';
$string['configkeeptagnamecase'] = 'Označite, če želite ohraniti velike in male črke tako, kot so jih vnesli uporabniki';
$string['configlang'] = 'Izberite privzet jezik za celotno spletno mesto. Uporabniki lahko to nastavitev prepišejo z uporabo jezikovnega menija ali nastavitvijo v svojem profilu.';
$string['configlanglist'] = 'Pustite to prazno, da bi uporabnikom omogočite izbor poljubnega nameščenega jezika. Če želite skrajšati meni jezikov, lahko vnesete z vejicami ločen seznam jezikovnih kod, ki jih želite. Na primer:  sl,en,es_es,fr,it';
$string['configlangmenu'] = 'Izberite, ali želite prikazovati splošen jezikovni meni na domači strani, strani prijave itn. To ne vpliva na možnost, ki jo ima uporabnik, da si nastavi zaželen jezik v svojem lastnem profilu.';
$string['configlangstringcache'] = 'Predpomni vse jezikovne nize v pripravljeno datoteko v podatkovnem imeniku. Če prevajate Moodle ali spreminjate nize v izvorni kodi Moodle, potem boste morda želeli to izklopiti. Sicer pustite vklopljeno, če želite videti koristi v zmogljivosti.';
$string['configlatinexcelexport'] = 'Izberite kodni nabor za izvoze v Excel.';
$string['configlocale'] = 'Nastavite lokacijo (locale) za celotno spletno mesto - to bo vplivalo na obliko in jezik datumov za vse jezikovne pakete (vendar bodo imena dni in koledar nespremenjeni). Podatke za to namestitev morate imeti nameščene v vašem operacijskem sistemu. (npr. sl_SI ali en_US). Če ne veste kaj izbrati pustite polje prazno.';
$string['configloginhttps'] = 'Če vključite to možnost, bo Moodle uporabil varno https povezavo zgolj za stran prijave (in s tem zagotovil varno prijavo) in po tem preklopil nazaj na navaden http URL za običajno hitrost.  POZOR: ta nastavitev ZAHTEVA izrecno omogočen protokol https na spletnem strežniku - če ni SE LAHKO ZAKLENETE IZ VAŠEGA SPLETNEGA MESTA.';
$string['configloglifetime'] = 'To določa časovno obdobje, za katero želite hraniti dnevnike o dejavnosti uporabnikov.  Starejši dnevniki od te starosti bodo samodejno izbrisani. Najbolje je hraniti dnevnike čim dlje, če jih potrebujete. Če imate zelo obremenjen strežnik in se soočate z zmogljivostnimi težavami, boste morda želeli skrajšati življenjsko dobo dnevnikov. Vrednosti, nižje od 30, niso priporočljive, ker statistika morda ne bo delovala pravilno.';
$string['configlookahead'] = 'Dnevi za pogled v naprej';
$string['configmaxbytes'] = 'To določa največjo velikost naloženih datotek za celotno spletno mesto. To nastavitev omejujejo nastavitve PHP post_max_size in upload_max_filesize, kakor tudi nastavitev Apache LimitRequestBody. Posledično maxbytes omejuje obseg velikosti, ki ga lahko izbirate na ravni predmeta ali modula.';
$string['configmaxconsecutiveidentchars'] = 'Gesla ne smejo imeti več kot to število zaporednih enakih znakov. Uporabite 0 za onemogočanje tega pregleda.';
$string['configmaxeditingtime'] = 'To določa časovni okvir v katerem lahko osebe ponovno uredijo objave v forumu, komentarji pojmovnika ipd.  Običajno je dobra vrednost 30 minut.';
$string['configmaxevents'] = 'Dogodki za pogled v naprej';
$string['configmaxusersperpage'] = 'Največje število prikazanih uporabnikov v uporabniškem izbirniku znotraj predmeta, skupine, kohorte, spletne storitve itd.';
$string['configmessaging'] = 'Naj bo omogočen sporočilni sistem med uporabniki spletnega mesta?';
$string['configmessagingallowemailoverride'] = 'Omogočite, da uporabnik lahko prejme elektronsko sporočilo tudi na drug naslov, ne le na naslov v svojem profilu.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Prebrana obvestila so lahko izbrisana, da bi prihranili prostor. Koliko časa po tem, ko je obvestilo prebrano, je lahko izbrisano?';
$string['configmessaginghidereadnotifications'] = 'Skrij prebrana obvestila dogodkov kot so objave foruma, ob pregledovanju zgodovine sporočil';
$string['configminpassworddigits'] = 'Geslo mora imeti najmanj toliko številk.';
$string['configminpasswordlength'] = 'Geslo mora biti dolgo vsaj toliko znakov.';
$string['configminpasswordlower'] = 'Geslo mora imeti najmanj toliko malih črk.';
$string['configminpasswordnonalphanum'] = 'Geslo mora imeti vsaj toliko znakov, ki niso črke ali številke.';
$string['configminpasswordupper'] = 'Geslo mora imeti vsaj toliko velikih črk.';
$string['configmobilecssurl'] = 'CSS datoteka za prilagoditev vmesnika za mobilno aplikacijo.';
$string['configmodchooserdefault'] = 'Ali naj bo izbirnik dejavnosti privzeto viden uporabnikom?';
$string['configmycoursesperpage'] = 'Maksimalno število predmetov za prikaz v kateremkoli seznamu uporabnikovih lastnih predmetov.';
$string['configmymoodleredirect'] = 'Ta nastavitev vsili preusmeritev na /my ob prijavi za uporabnike, ki niso skrbniki in zamenja vrhnjo drobtino strani z /my';
$string['configmypagelocked'] = 'Ta nastavitev preprečuje urejanje privzete strani vsem ne-administrativnim uporabnikom.';
$string['confignavcourselimit'] = 'Omeji število predmetov, prikazanih uporabniku, ko ni prijavljen ali ni vpisan v noben predmet.';
$string['confignavshowallcourses'] = 'Nastavitev tega zagotavlja, da so vsi predmeti ves čas prikazani v navigaciji.';
$string['confignavshowcategories'] = 'Prikaže kategorije predmeta v navigacijski vrstici in v navigacijskih blokih. To se ne dogodi pri predmetih v katere je uporabnik vpisan. Ti bodo še vedno navedeni v seznamu "Moji predmeti" brez prikaza kategorij.';
$string['confignotifyloginfailures'] = 'Če se spodletele prijave beležijo, se lahko pošiljajo e-poštna obvestila. Kdo naj vidi ta obvestila?';
$string['confignotifyloginthreshold'] = 'Če so vključena obvestila o spodletelih prijavah, koliko spodletelih prijav posameznega uporabnika ali IP naslova zadošča za obveščanje?';
$string['confignotloggedinroleid'] = 'Uporabniki, ki niso prijavljeni na spletnem mestu, bodo obravnavani kot da imajo v kontekstu strani dodeljeno to vlogo. Tu si ponavadi želite imeti vlogo Gosta, vendar lahko ustvarite tudi vloge, ki so bolj ali manj omejujoče. Zmožnosti kot ustvarjanje prispevkov še vedno od uporabnikov zahteva prijavo na stran.';
$string['configopentogoogle'] = 'Če omogočite to nastavitev, bo lahko Google vstopal v spletno mesto kot gost.  Dodatno bodo osebe, ki bodo na vašo stran prišle prek iskanja na iskalniku Google samodejno prijavljene kot gost. Vedite, da to omogoča le dostop do predmetov, ki že dovoljujejo dostop uporabniškemu računu gost.';
$string['configoverride'] = 'Določeno v config.php';
$string['configpasswordpolicy'] = 'Če omogočite to nastavitev, bo Moodle preveril, če geslo ustreza varnostni politiki. Uporabite nastavitve spodaj, da jo določite. Če ta nastavitev ni onemogočena, bodo nastavitve spodaj ignorirane.';
$string['configpathtoclam'] = 'Pot do Clam AV. Verjetno nekaj podobnega /usr/bin/clamscan ali /usr/bin/clamdscan. To potrebujete za zagon Clam AV.';
$string['configpathtodu'] = 'Pot do du. Verjetno nekaj podobnega /usr/bin/du. Če to vnesete, bodo strani, ki prikazujejo vsebino imenika, delovale veliko hitreje pri imenikih z veliko datotekami.';
$string['configperfdebug'] = 'Če to vključite, bo prikazana informacija o zmogljivosti delovanja v nogi standardne teme';
$string['configprofileroles'] = 'Seznam vlog, ki so vidne v uporabnikovih profilih in na sodelovalnih straneh.';
$string['configprofilesforenrolledusersonly'] = 'Za onemogočanje zlorabe so opisi uporabnikov, ki še niso vpisani v noben predmet, skriti. Novi uporabniki morajo biti člani vsaj enega predmeta, preden lahko dodajo opis v svoj profil.';
$string['configprotectusernames'] = 'Privzeto forget_password.php ne prikazuje namigov, ki bi omogočali ugibanje uporabniških imen ali e-poštnih naslovov.';
$string['configproxybypass'] = 'Z vejicami ločen seznam (delnih) imen gostiteljev ali IP naslovov, ki naj obidejo posredniški strežnik (proxy) (npr. 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Če ta <b>strežnik</b> za dostop do interneta zahteva uporabo prehodnega strežnika (proxy) (npr. požarni zid), potem tu vpišite ime in vrata prehodnega strežnika. Sicer pustite to prazno.';
$string['configproxypassword'] = 'Geslo za dostop do interneta prek prehodnega (proxy) strežnika. Pustite prazno, če prehodni strežnik ne uporablja gesla (zahtevana PHP cURL razširitev).';
$string['configproxyport'] = 'Če ta strežnik potrebuje prehodni strežnik, tu vpišite vrata prehodnega strežnika.';
$string['configproxytype'] = 'Vrsta prehodnega (proxy) strežnika (razširitvi PHP5 in cURL morata biti omogočeni za podporo SOCKS5).';
$string['configproxyuser'] = 'Uporabniško ime za dostop do interneta prek prehodnega (proxy) strežnika. Pustite prazno, če prehodni strežnik ne uporablja uporabniškega imena (zahtevana PHP cURL razširitev).';
$string['configquarantinedir'] = 'Če želite, da Clam AV premakne okužene datoteke v imenik karantene, ga vnesite tu. Spletni strežnik mora imeti v njem pravico pisanja. Če to pustite prazno ali vnesete imenik, ki ne obstaja ali vanj ni možno pisati, bodo okužene datoteke izbrisane.  Ne vključite končne poševnice.';
$string['configrecaptchaprivatekey'] = 'Niz znakov za komunikacijo med strežnikom Moodle in strežnikom recaptcha.net. Svoj niz za strežnik lahko dobite, če obiščete strežnik http://recaptcha.net.';
$string['configrecaptchapublickey'] = 'Niz znakov, ki prikaže element reCAPTCHA v vpisnem obrazcu. Generira ga stran http://recaptcha.net.';
$string['configrequestcategoryselection'] = 'Omogočite izbiro kategorije pri zahtevi za predmet.';
$string['configrequestedstudentname'] = 'Beseda za udeleženca, ki se uporablja v zahtevanih predmetih';
$string['configrequestedstudentsname'] = 'Beseda za udeležence, ki se uporablja v zahtevanih predmetih';
$string['configrequestedteachername'] = 'Beseda za izvajalca, ki se uporablja v zahtevanih predmetih';
$string['configrequestedteachersname'] = 'Beseda za izvajalce, ki se uporablja v zahtevanih predmetih';
$string['configrequiremodintro'] = 'Onemogočite to možnost, če ne želite vsiliti uporabnikom vnos opisa vsake dejavnosti.';
$string['configrunclamavonupload'] = 'Ko boste to omogočili, bo clam AV pregledal vse naložene datoteke.';
$string['configrunclamonupload'] = 'Zagon Clam AV ob nalaganju datoteke? Potrebovali boste pravilno pot v pathtoclam, da bo to delovalo. (Clam AV je brezplačen antivirusni pregledovalnik, ki ga lahko dobite na naslovu http://www.clamav.net/)';
$string['configsectioninterface'] = 'Vmesnik';
$string['configsectionmail'] = 'Pošta';
$string['configsectionmaintenance'] = 'Vzdrževanje';
$string['configsectionmisc'] = 'Razno';
$string['configsectionoperatingsystem'] = 'Operacijski sistem';
$string['configsectionpermissions'] = 'Dovoljenja';
$string['configsectionrequestedcourse'] = 'Zahteve za predmet';
$string['configsectionsecurity'] = 'Varnost';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Uporabnik';
$string['configsecureforms'] = 'Moodle lahko uporablja dodatno raven varnosti ob sprejemanju podatkov prek spletnih obrazcev. Če je to omogočeno je spremenljivka brskalnika HTTP_REFERER primerjana s trenutnim naslovom obrazca.  V nekaterih redkih primerih to lahko povzroči težave, če uporabnik uporablja požarni zid (npr. Zonealarm) konfiguriran tako, da odreže HTTP_REFERER iz spletnega prometa. Simptomi so, da \'obtičite\' na obrazcu. Če imajo uporabniki težave (na primer) na prijavni strani lahko onemogočite to nastavitev, čeprav s tem pustite spletno mesto bolj odprto napadom ugibanja gesla s programskim ugibanjem.  Če ste v dvomih, pustite to nastavljeno na \'Da\'.';
$string['configsessioncookie'] = 'Ta nastavitev prilagodi ime piškotka, ki ga uporablja seja Moodle. To je dodatna možnost in je uporabna v izogib zamenjave piškotov kjer teče več kot ena kopija Moodle na isti spletni strani.';
$string['configsessioncookiedomain'] = 'a nastavitev omogoča, da spremenite domeno Moodle piškotkov. To je uporabno za prilagojene namestitve Moodle (denimo uporaba avtentikacijskih ali vpisnih vtičnikov), ki si morajo informacije o seji Moodle deliti s spletnimi aplikacijami na drugi pod-domeni.<strong>OPOZORILO: priporočamo, da to nastavitev pustite na privzeti vrednosti (prazno) - napačna nastavitev bo onemogočila vse prijave v Moodle.</strong>';
$string['configsessioncookiepath'] = 'Če morate spremeniti kam brskalnik pošilja piškotke Moodle, lahko spremenite to nastavitev in navedete podimenik vaše spletne strani. Sicer bi morala biti v redu privzeta vrednost \'/\'.';
$string['configsessiontimeout'] = 'Če so osebe prijavljene v to spletno mesto dlje nedejavne (ne da bi naložile kakšno stran) potem so samodejno odjavljene (njihova seja se zaključi). Ta spremenljivka določa kako dolg naj bo ta čas.';
$string['configshowcommentscount'] = 'Pokaži število komentarjev. To bo, ob prikazu povezave na komentarje, povzročilo še eno dodatno poizvedbo.';
$string['configshowicalsource'] = 'Prikaži izvorne informacije za iCal dogodke.';
$string['configshowsiteparticipantslist'] = 'Vsi izvajalci in udeleženci tega spletnega mesta bodo našteti v seznamu udeležencev spletnega mesta. Komu naj bo dovoljeno videti ta seznam udeležencev spletnega mesta?';
$string['configsitedefaultlicense'] = 'Privzeta licenca spletnega mesta';
$string['configsitedefaultlicensehelp'] = 'Privzeta licenca za objavljanje vsebin na tem spletnem mestu';
$string['configsitemaxcategorydepth'] = 'Največja globina kategorij';
$string['configsitemaxcategorydepthhelp'] = 'Določi največjo prikazano globino podrejenih kategorij';
$string['configslasharguments'] = 'Datoteke (slike, naložene datoteke ipd.) so na voljo prek skripte z uporabo argumentov s poševnico (slash arguments) (tu druga možnost). Ta način omogoča lažje predpomnenje datotek v spletnih brskalnikih, proxy strežnikih ipd. Žal nekateri strežniki PHP ne dovoljujejo tega načina zato nastavite to spremenljivko na prvo možnost, če imate težave z ogledom naloženih datotek ali slik (npr. slik uporabnikov).';
$string['configsmartpix'] = 'S to možnostjo vključeno, se ikone pridobivajo preko PHP skripte, ki najprej preišče trenutno temo, nato vse nadrejene teme, za tem pa še Moodle /pix mapo. To zmanjša potrebo po podvojenih slikovnih datotekah, vendar lahko v manjši meri vpliva na delovanje strežnika.';
$string['configstartwday'] = 'Začetek tedna';
$string['configstatsfirstrun'] = 'To določa, koliko stari dnevniški zapiski naj se obdelajo <b>prvič</b>, ko bo cronjob obdeloval statistiko. Če imate precej prometa in uporabljate skupno gostovanje, verjetno ni dobro iti predaleč nazaj, saj lahko izvajanje traja precej dolgo in zahteva precej sistemskih virov. (Opomba za to nastavitev, 1 mesec = 28 dni. V grafih in generiranih poročilih, 1 mesec = 1 koledarski mesec.)';
$string['configstatsmaxruntime'] = 'Obdelava statistke je lahko precej intenzivna, zato uporabite kombinacijo tega in naslednjega polja za določitev, kdaj naj se izvaja in kako dolgo.';
$string['configstatsmaxruntime2'] = 'Obdelava statistke je lahko precej intenzivna, zato določite najdaljši čas, ki je dovoljen za zbiranje statistik enega dne. Največje število dni, obdelanih v okviru enega poganjanja cron, je 31.';
$string['configstatsmaxruntime3'] = 'Določite najdaljši čas, dovoljen za izračun statistik enega dneva. Imejte v mislih, da izračun statistike zelo obremeni strežnik. Največje število dni, ki bodo obdelani v okviru enega poganjanja cron, lahko določite spodaj.';
$string['configstatsruntimedays'] = 'Določite največje število dni, obdelanih med enim računanjem statistike. Če se statistika izvaja redno, bo obdelan samo en dan. Prilagodite to vrednost obremenitvi vašega strežnika - zmanjšajte vrednost, če se cron izvaja predolgo.';
$string['configstatsruntimestart'] = 'Kdaj naj se opravilo cronjob, ki obdeluje statistiko, <b>zažene</b>?';
$string['configstatsuserthreshold'] = 'Ta nastavitev določa najmanjše število vpisanih uporabnikov da se predmet vključi v statistične izračune.';
$string['configstrictformsrequired'] = 'Če je omogočeno, uporabnik v obvezna polja obrazca ne more vnesti presledka ali skočiti v novo vrstico.';
$string['configstripalltitletags'] = 'Odznačite to nastavitev za omogočanje oznak HTML v dejavnosti in virih.';
$string['configsupportemail'] = 'Ta e-poštni naslov bo posredovan uporabnikom v primeru, da potrebujejo splošno pomoč (denimo, ko si novi uporabniki ustvarijo svoje uporabniške račune). Če pustite to polje prazno, uporabnikom ne bo javljen e-poštni naslov za pomoč.';
$string['configsupportname'] = 'Ime osebe ali oddelka, zadolženega za splošno pomoč prek e-pošte ali spletnega naslov.';
$string['configsupportpage'] = 'Ta spletni naslov bo posredovan uporabnikom v primeru, da potrebujejo splošno pomoč (denimo, ko si novi uporabniki ustvarijo svoje uporabniške račune). Če pustite to polje prazno, uporabnikom ne bo javljen spletni naslov za pomoč.';
$string['configthemedesignermode'] = 'Običajno se vse slike in slogovne predloge, zaradi hitrejšega izvajanja, zelo dolgo predpomnijo v brskalnikih in na strežniku. Če oblikujete teme ali razvijate kodo, potem boste verjetno želeli ta način vklopiti, da vam ne bodo posredovane predpomnjene različice. Opozorilo: to bo upočasnilo vaše spletno mesto za vse uporabnike! Predpomnjeno temo lahko na strani za izbiro teme ponastavite tudi ročno.';
$string['configthemelist'] = 'Pustite to prazno, če želite dovoliti uporabo vseh veljavnih tem. Če želite skrajšati meni tem, lahko tu določite z vejicami ločen seznam imen (Ne uporabljajte presledkov!).
Na primer: standard,orangewhite.';
$string['configtimezone'] = 'Tu lahko nastavite privzet časovni pas.  To je zgolj PRIVZET časovni pas za prikaz datumov - vsak uporabnik lahko to nastavitev preglasi z lastno nastavitvijo v svojem profilu. Če nastavite "Čas strežnika" bo Moodle prevzel nastavitve operacijskega sistema strežnika, "Čas strežnika" v uporabniškem profilu pa bo za uporabnika prevzel to nastavitev.  Opravila cron, katerih izvajanje je odvisno od časa v dnevu bodo uporabljalo ta časovni pas.';
$string['configuseblogassociations'] = 'Ali naj bo uporabnikom omogočeno, da svoj blog organizirajo s povezovanjem vnosov na predmete in module predmeta?';
$string['configuseexternalyui'] = 'Namesto lokalnih datotek uporabite spletne datoteke, ki so na voljo na Yahoo-jevih strežnikih. OPOZORILO: To zahteva internetno povezavo ali pa noben AJAX ne bo deloval na vašem spletnem mestu.';
$string['configuserquota'] = 'Največje število bajtov, ki jih lahko uporabnik shrani v svojem zasebnem datotečnem prostoru. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Če je omogočeno, bo v bloku Navigacija uporabljeno kratko ime strani, namesto "Strani spletnega mesta"';
$string['configusetags'] = 'Naj bodo oznake omogočene na vsem strežniku?';
$string['configvariables'] = 'Spremenljivke';
$string['configverifychangedemail'] = 'Omogoči preverjanje spremenjenih e-poštnih naslovov z uporabo dovoljenih in prepovedanih e-poštnih domen. Če ta nastavitev ni aktivirana, se domene preverjajo samo za nove uporabnike.';
$string['configvisiblecourses'] = 'Normalno prikazuje predmete v skritih kategorijah';
$string['configwarning'] = 'Bodite previdni pri spreminjanju teh nastavitev - čudne vrednosti lahko povzročijo težave.';
$string['configyuicomboloading'] = 'Ta možnost omogoča kombinirano optimizacijo nalaganja datotek za YUI knjižnice. Ta nastavitev naj bo, zaradi zmogljivostnih razlogov, na produkcijskih strežnikih omogočena.';
$string['confirmation'] = 'Potrditev';
$string['confirmdeletecomments'] = 'Izbrisali boste komentarje. Ste prepričani?';
$string['confirmed'] = 'Potrjeno';
$string['convertformat'] = '<i>pretvori</i> izhodni format';
$string['cookiehttponly'] = 'Samo http piškotki';
$string['cookiesecure'] = 'Samo varni piškotki';
$string['country'] = 'Privzeta država';
$string['coursecontact'] = 'Urejevalci predmeta';
$string['coursecontact_desc'] = 'Ta nastavitev omogoča nadzor oseb, ki se izpišejo pri opisu predmeta. Za izpis pri opisu predmeta, morajo imeti uporabniki pri predmetu vsaj eno izmed navedenih vlog.';
$string['courselistshortnames'] = 'Prikaži razširjena imena predmetov';
$string['courselistshortnames_desc'] = 'Če je omogočeno, bodo na seznamu predmetov prikazana kratka in dolga imena predmetov. Po potrebi se lahko dolga imena predmetov prilagodi z urejanjem jezikovnega niza \'courseextendednamedisplay\' preko vmesnika za prilagajanje jezika.';
$string['coursemgmt'] = 'Dodaj/Izbriši predmete';
$string['courseoverview'] = 'Pregled predmeta';
$string['courserequestnotify'] = 'Obvestilo o zahtevi po predmetu';
$string['courserequestnotifyemail'] = 'Uporabnik {$a->user} je zahteval nov predmet na naslovu {$a->link}';
$string['courserequests'] = 'Zahteve predmetov';
$string['courserequestspending'] = 'Čakajoče zahteve po predmetih';
$string['courses'] = 'Predmeti';
$string['coursesperpage'] = 'Predmeti na stran';
$string['courseswithsummarieslimit'] = 'Meja za prikaz predmetov z povzetki';
$string['creatornewroleid'] = 'Vloga ustvarjalcev v novih predmetih';
$string['creatornewroleid_help'] = 'Če uporabnik še nima dovoljenja za upravljanje novega predmeta, je uporabnik samodejno vpisan s to vlogo.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Izvajanje Cron-a samo prek ukazne vrstice';
$string['cronerrorclionly'] = 'Internetni dostop do te strani je žal skrbnik onemogočil.';
$string['cronerrorpassword'] = 'Žal niste vnesli veljavnega gesla za dostop do te strani';
$string['cron_help'] = 'Vzdrževalna skripta cron.php pomaga nekaterim modulom Moodla pri opravljanju nalog po časovnem razporedu, kot na primer  pošiljanje kopije novih objav na forumu. Potreben je mehanizem za redno izvajanje skripta npr. vsakih 5 minut.';
$string['cronremotepassword'] = 'Cron geslo za oddaljen dostop';
$string['cronwarning'] = '<a href="cron.php">Vzdrževalna skripta cron.php</a> ni bila zagnana vsaj 24 ur.';
$string['ctyperecommended'] = 'Namestitev razširitve ctype za PHP je priporočena za hitrejše delovanje strežnika, še posebej v primeru, da vaš strežnik podpira jezike, ki niso v skupini latin.';
$string['ctyperequired'] = 'Razširitev ctype za PHP je sedaj nujna za delovanje strežnika Moodle. Omogoča hitrejše delovanje in podporo večjezični združljivosti.';
$string['curlcache'] = 'Življenjska doba (TTL) cURL predpomnilnika';
$string['curlrecommended'] = 'Zelo priporočena je namestitev opcijske Curl knjižice za omogočanje funkcij Moodle omrežja.';
$string['curlrequired'] = 'Za komunikacijo z Moodle odložišči, Moodle zdaj zahteva PHP razširitev cURL.';
$string['curltimeoutkbitrate'] = 'Bitrate za uporabo pri izračunavanju CURL časovne omejitve (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ta nastavitev se uporablja za izračun ustrezne časovne omejitve med velikimi CURL zahtevki. V okviru tega se ustvari HTTP HEAD zahteva za določitev velikosti vsebine. Nastavitev tega na 0 onemogoči to zahtevo, da bi se izvršila.';
$string['currenttheme'] = 'Trenutna tema';
$string['customcheck'] = 'Drugi pregledi';
$string['custommenu'] = 'Meni po meri';
$string['custommenuitems'] = 'Elementi menija po meri';
$string['datarootsecurityerror'] = '<p><strong>VARNOSTNO OPOZORILO!</strong></p><p>Korenski imenik (dataroot) je na napačni lokaciji in je viden s spleta. To pomeni, da so vaše zasebne datoteke vidne vsemu svetu, nekatere od teh pa bi lahko zlonamernim uporabnikom omogočile pridobitev nepooblaščenega administracijskega dostopa do vašega strežnika!</p>
<p>Vaš korenski imenik ({$a}) <em>morate</em> premakniti na novo lokacijo, ki ni del vašega javnega spletnega imenika. Potem popravite nastavitev <code>$CFG->dataroot</code> v datoteki config.php na novo lokacijo.</p>';
$string['datarootsecuritywarning'] = 'Konfiguracija vašega spletnega mesta morda ni varna. Prosimo, prepričajte se, da vaš korenski podatkovni imenik ({$a})(dataroot) ni neposredno dostopen s spleta.';
$string['dbmigrate'] = 'Selitev podatkovne zbirke Moodle';
$string['dbmigrateconnecerror'] = 'Povezave z navedeno podatkovno zbirko ni mogoče vzpostaviti.';
$string['dbmigrateencodingerror'] = 'Navedena podatkovna zbirka uporablja kodni nabor {$a} namesto zahtevanega UNICODE / UTF-8.<br />Prosimo, navedite drugo.';
$string['dbmigratepostgres'] = 'Kot kaže, uporabljate za podatkovni strežnik PostgreSQL. Za nadaljevanje postopka selitve morate ročno ustvariti novo podatkovno zbirko s kodno tabelo "UNICODE" (PostgreSQL 7) ali "UTF8" (PostgreSQL 8) za shranjevanje preseljenih podatkov. Za nadaljevanje spodaj vnesite nove nastavitve za povezavo:';
$string['dbmigratewarning'] = 'Prosimo poskrbite za varnostno kopijo vaše podatkovne zbirke moodle, preden pričnete ta postopek. Če niste prepričani, kako to narediti, se obrnite na skrbnika vašega sistema. Vaša stran bo prestavljena v način vzdrževanja, ko boste pričeli s postopkom selitve';
$string['dbmigratewarning2'] = '<b>Opozorilo: Zagnali poste postopek selitve podatkovne zbirke. Temeljito preverite, da imate varnostno kopijo vaše celotne Moodle podatkovne zbirke.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Ta podatkovna zbirka je preseljena v novo UTF-8 podatkovno zbirko in ni več priporočljiva za uporabo. Uredite config.php in uporabite novo podatkovno zbirko za ta sistem.</font>';
$string['dbmigrationdupfailed'] = 'Podvajanje podatkovne zbirke je spodletelo z možno napako:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Shranjuj podatke o seji v podatkovno bazo';
$string['debug'] = 'Sporočila za iskanje napak';
$string['debugall'] = 'VSA: prikaži vsa sporočila PHP za odpravljanje napak';
$string['debugdeveloper'] = 'RAZVIJALSKA: prikaži dodatna Moodle sporočila za odpravljanje napak, namenjena razvijalcem';
$string['debugdisplay'] = 'Prikaži sporočila za odpravljanje napak';
$string['debugging'] = 'Odpravljanje napak';
$string['debugminimal'] = 'MINIMALNA: prikaži samo sporočila o najhujših napakah';
$string['debugnone'] = 'BREZ: ne prikaže nobenih napak in opozoril';
$string['debugnormal'] = 'NORMALNO: Prikaži napake, opozorila in obvestila';
$string['debugpageinfo'] = 'Prikaži informacijo o strani.';
$string['debugsmtp'] = 'Pošiljanje e-pošte s sporočili za odpravljanje napak';
$string['debugstringids'] = 'Prikaži izvor jezikovnih nizov';
$string['debugstringids_desc'] = 'Ta možnost je v pomoč prevajalcem. Ko je omogočena, se prikaže identifikator jezikovne datoteke in besedilnega niza ob vsakem izhodnem besedilu, če dodate parameter strings=1 URL zahtevku.';
$string['debugvalidators'] = 'Prikaži povezave preverjalnika';
$string['defaultcity'] = 'Privzeto mesto';
$string['defaultcity_help'] = 'Mesto, ki je tukaj vnešeno, bo privzeto mesto, ko se bodo ustvarjali novi uporabniški računi.';
$string['defaultformatnotset'] = 'Napaka pri določanju privzete oblike predmeta. Preverite nastavitve spletnega mesta.';
$string['defaulthomepage'] = 'Privzeta prva stran za uporabnike';
$string['defaultrequestcategory'] = 'Privzeta kategorija za zahtevke predmetov';
$string['defaultsettinginfo'] = 'Privzeto: {$a}';
$string['defaultuserroleid'] = 'Privzeta vloga za vse uporabnike';
$string['deleteincompleteusers'] = 'Izbris delnih uporabniških računov po';
$string['deleteunconfirmed'] = 'Izbriši nepotrjene uporabnike po';
$string['deleteuser'] = 'Izbriši uporabnika';
$string['density'] = 'Gostota';
$string['denyemailaddresses'] = 'Prepovedane e-poštne domene';
$string['development'] = 'Razvoj';
$string['devicedetectregex'] = 'Naprava za odkrivanje regularnih izrazov';
$string['devicedetectregex_desc'] = '<p>Privzeto lahko Moodle zazna naprave tipa privzeto (namizni ali prenosni računalnik, ...), mobilni (telefoni in dlančniki), tablični (iPad-i in Android tablice) in zapuščina (Internet Explorer 6). Za dodelitev ločenih tem za vse te tipe lahko uporabite izbirnik tem. Ta nastavitev dovoljuje uporabo logičnih izrazov, kar omogoča zaznavanje dodatnih tipov naprav (te imajo prednost pred privzetimi tipi).</p>
<p>Na primer: vnesete lahko logični izraz \'/(MIDP-1.0|Maemo|Windows CE)/\' za zaznavanje nekaterih pogosto uporabljanih pametnih telefonov in dodate povratno frazo \'pametnitelefon\'. To doda \'pametnitelefon\' v izbirnik tem, kar vam omogoča dodati temo, ki bo uporabljena na teh napravah. Ostali telefoni bodo še naprej uporabljali temo izbrano za tip mobilnih naprav. </p>';
$string['devicedetectregexexpression'] = 'Regularni izraz';
$string['devicedetectregexvalue'] = 'Vrednost Return';
$string['devicetype'] = 'Tip naprave';
$string['disableuserimages'] = 'Onemogoči slike uporabnikov v profilu';
$string['displayerrorswarning'] = 'Omogočanje PHP nastavitve <em>display_errors</em> ni priporočena na produkcijskih strežnikih, ker lahko določena sporočila o napaki odkrijejo občutljive varnostne informacije o vašem strežniku.';
$string['displayloginfailures'] = 'Prikaži podatke o neuspelih prijavah na';
$string['dndallowtextandlinks'] = '"Povleci in spusti" za besedila/povezave';
$string['docroot'] = 'Korenski imenik Moodle Docs';
$string['doctonewwindow'] = 'Odpri v novem oknu';
$string['download'] = 'Prenos';
$string['edithelpdocs'] = 'Uredi dokumente pomoči';
$string['editingnoncorelangfile'] = 'Poskušate spremeniti prevod dodatnega modula ali vtiča. Prevode dodatnih modulov lahko shranite samo v imenik _local. Predlagamo, da datoteko s prevodom premaknete v imenik lang modula ali pa jo pošljete skrbniku modula.';
$string['editlang'] = '<b>Uredi</b>';
$string['editorbackgroundcolor'] = 'Barva ozadja';
$string['editordictionary'] = 'Slovar urejevalnika';
$string['editorfontfamily'] = 'Družina pisave';
$string['editorfontlist'] = 'Seznam pisav';
$string['editorfontsize'] = 'Velikost pisave';
$string['editorhidebuttons'] = 'Skriti gumbi';
$string['editorkillword'] = 'Filter besed';
$string['editorspelling'] = 'Črkovanje urejevalnika';
$string['editorspellinghelp'] = 'Omogoči ali onemogoči črkovalnik. Ko imate možnost omogočeno, morate na strežniku imeti nameščen <strong>aspell</strong>.';
$string['editstrings'] = 'Uredi besede ali fraze';
$string['emailchangeconfirmation'] = 'Potrjevanje spremembe e-poštnega naslova';
$string['emoticonalt'] = 'Nadomestno besedilo';
$string['emoticoncomponent'] = 'Komponenta slike';
$string['emoticonimagename'] = 'Ime slike';
$string['emoticons'] = 'Smeški';
$string['emoticons_desc'] = 'Ta obrazec določa izrazne ikone (smeške), ki se uporabljajo na vašem spletnem mestu. Če želite odstraniti vrstico iz tabele, shranite obrazec s prazno vrednostjo v vsakem od zahtevanih polj. Če želite registrirati novo izrazno ikono, izpolnite polja v zadnji prazni vrstici. Če želite ponastaviti vsa polja na privzete vrednosti, sledite povezavi zgoraj.

* Besedilo (obvezno) - To besedilo bo zamenjano s sličico smeška. Dolžina besedila mora biti vsaj dva znaka.
* Ime slike (obvezno) - ime datoteke izrazne ikone brez končnice, v odvisnosti na pix mapo komponente.
* Komponenta slike (obvezno) - komponenta, ki zagotavlja ikono.
* Alternativno besedilo (neobvezno) - identifikator niza in del alternativnega besedila izrazne ikone.';
$string['emoticonsreset'] = 'Ponastavi nastavitve izraznih ikon na privzete vrednosti';
$string['emoticontext'] = 'Besedilo';
$string['emptysettingvalue'] = 'Prazno';
$string['enableajax'] = 'Omogoči AJAX';
$string['enableblogs'] = 'Omogoči bloge';
$string['enablecalendarexport'] = 'Omogoči izvoz koledarja';
$string['enablecomments'] = 'Omogoči komentarje';
$string['enablecourserequests'] = 'Omogoči zahteve za predmete';
$string['enablecssoptimiser'] = 'Omogoči CSS optimizator';
$string['enablecssoptimiser_desc'] = 'Ko je optimizator omogočen, gre CSS skozi optimizacijski proces, preden se shrani v predpomnilnik. Pri tem se odstranijo dvojniki pravil in stilov, prazni znaki se tudi preoblikujejo. Vključitev te možnosti ob istočasno vključenem načinu za oblikovanje tem zelo slabo vpliva odzivnost sistema, vendar pa pomaga oblikovalcem ustvariti optimiziran CSS.';
$string['enabled'] = 'Omogočeno';
$string['enabledevicedetection'] = 'Omogoči odkrivanje naprav';
$string['enablegravatar'] = 'Omogoči Gravatar';
$string['enablegravatar_help'] = 'Če je omogočen, bo Moodle poskusil pridobiti sliko za uporabniški profil iz Gravatarja, v kolikor uporabnik ni naložil slike.';
$string['enablegroupmembersonly'] = 'Omogoči samo za člane skupine';
$string['enablemobilewebservice'] = 'Omogoči mobilne spletne storitve';
$string['enablerecordcache'] = 'Omogoči predpomnilnik zapisov';
$string['enablerssfeeds'] = 'Omogoči vire RSS';
$string['enablesafebrowserintegration'] = 'Omogoči integracijo brskalnika "Safe Exam Browser"';
$string['enablestats'] = 'Omogoči statistiko';
$string['enabletrusttext'] = 'Omogoči zanesljivo vsebino';
$string['enablewebservices'] = 'Omogoči spletne storitve';
$string['enablewsdocumentation'] = 'Dokumentacija spletnih storitev';
$string['enrolinstancedefaults'] = 'Privzete vrednosti primerov vpisa';
$string['enrolinstancedefaults_desc'] = 'Privzete nastavitve za vpis v novih predmetih.';
$string['enrolmultipleusers'] = 'Vpiši uporabnike';
$string['environment'] = 'Okolje';
$string['environmenterrortodo'] = 'Pred nadaljevanjem namestitve te različice Moodle morate razrešiti zgoraj odkrite težave okolja (napake).';
$string['environmenterrorupgrade'] = 'Opozorilo: vse zgoraj odkrite težave okolja (napake) bi morali razrešiti pred nadaljevanjem z posodobitvijo trenutne različice Moodla. Posodobitev brez popravljanja teh zahtev utegne povzročiti napake kot npr. izgubo podatkov. Ali ste prepričani, da želite nadaljevati s posodobitvijo?';
$string['environmentmustfixsetting'] = 'PHP nastavitve se morajo spremeniti.';
$string['environmentok'] = 'Vaša strežniška oprema je v skladu z minimalnimi zahtevami.';
$string['environmentrecommendcustomcheck'] = 'Če ta test ne uspe, to kaže na potencialen problem';
$string['environmentrecommendinstall'] = 'namestitev oz. omogočanje je priporočeno';
$string['environmentrecommendversion'] = 'različica {$a->needed} je priporočena, vi uporabljate {$a->current}';
$string['environmentrequirecustomcheck'] = 'ta test mora biti uspešen';
$string['environmentrequireinstall'] = 'namestitev oz. omogočanje je zahtevano.';
$string['environmentrequireversion'] = 'različica {$a->needed} je zahtevana, vi uporabljate {$a->current}';
$string['environmentsettingok'] = 'priporočene nastavitve zaznane';
$string['environmentshouldfixsetting'] = 'PHP nastavitve bi se morale spremeniti.';
$string['environmentxmlerror'] = 'Napaka pri branju podatkov okolja ({$a->error_code})';
$string['errordeletingconfig'] = 'Napaka pri brisanju konfiguracijskih zapisov za vtičnik \'{$a}\'.';
$string['errorsetting'] = 'Nastavitve ni bilo moč shraniti:';
$string['errorwithsettings'] = 'Nekatere nastavitve niso bile spremenjene zaradi napake:';
$string['everyonewhocan'] = 'Vsi z dostopom do \'{$a}\'';
$string['exceptions'] = 'izjeme';
$string['experimental'] = 'Eksperimentalno';
$string['experimentalsettings'] = 'Eksperimenatlne nastavitve';
$string['extendedusernamechars'] = 'Dovoli razširjene znake v uporabniških imenih';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['fatalmagicquotesruntime'] = '<p>Zaznana je bila resna napaka v nastavitvah, prosimo obvestite skrbnika strežnika.</p><p>Za pravilno delovanje Moodle zahteva, da skrbnik spremeni PHP nastavitve.</p><p><code>magic_quotes_runtime</code> mora biti nastavljena na <code>off</code>.</p><p>To nastavitev se upravlja z urejanjem <code>php.ini</code>, Apache/IIS <br />konfiguracije ali <code>.htaccess</code> datoteke na strežniku.</p>';
$string['fatalsessionautostart'] = '<p>Med nameščanjem je prišlo do hude napake, obvestite skrbnika strežnika.</p><p> Za pravilno delovanje mora skrbnik spremeni nastavitve PHP.</p><p><code>session.auto_start</code> mora biti nastavljena na <code>off</code>.</p><p>To se nastavi v <code>php.ini</code>,  v nastavitvah Apache/IIS <br /> ali v datoteki <code>.htaccess</code> na strežniku.</p>';
$string['filecreated'] = 'Nova datoteka ustvarjena';
$string['filestoredin'] = 'Shrani datoteko v mapo :';
$string['filestoredinhelp'] = 'Kje bo shranjena datoteka';
$string['filterall'] = 'Filtriraj vse nize sporočil';
$string['filtermatchoneperpage'] = 'Ujemanje filtra enkrat na stran';
$string['filtermatchonepertext'] = 'Ujemanje filtra enkrat na besedilo';
$string['filters'] = 'Filtri';
$string['filtersettings'] = 'Nastavitve filtra';
$string['filtersettingsgeneral'] = 'Splošne nastavitve filtra';
$string['filteruploadedfiles'] = 'Filtriraj naložene datoteke';
$string['forcelogin'] = 'Prisili uporabnike k prijavi';
$string['forceloginforprofileimage'] = 'Prisili uporarbnike k prijavi za ogled slik uporabnikov.';
$string['forceloginforprofileimage_help'] = 'Če je omogočeno, se morajo uporabniki prijaviti za ogled slik uporabnikov v profilih. Privzeta slika uporabnika bo prikazana v vseh elektronskih sporočilih.';
$string['forceloginforprofiles'] = 'Prisili uporabnike k prijavi za profile';
$string['forcetimezone'] = 'Vsili privzet časovni pas';
$string['formatuninstallwithcourses'] = 'Število predmetov oblike {$a->format}: {$a->count}. Njihova oblika bo spremenjena v {$a->defaultformat} (privzeta oblika za to spletno mesto). Nekateri podatki, značilni za določeno obliko predmeta, se lahko izgubijo. Ali želite nadaljevati?';
$string['frontpage'] = 'Naslovna stran';
$string['frontpagebackup'] = 'Varnostna kopija naslovne strani';
$string['frontpagedefaultrole'] = 'Privzeta vloga prve strani';
$string['frontpagefilters'] = 'Filtri naslovne strani';
$string['frontpageloggedin'] = 'Elementi naslovne strani ob prijavi';
$string['frontpageoverrides'] = 'Razveljavitev dovoljenj vstopne strani';
$string['frontpagequestions'] = 'Vprašanja prve strani';
$string['frontpagerestore'] = 'Obnovi naslovno stran';
$string['frontpageroles'] = 'Vloge naslovne strani';
$string['frontpagesettings'] = 'Nastavitve naslovne strani';
$string['fullnamedisplay'] = 'Oblika polnega imena';
$string['gdrecommended'] = 'Razširitev GD se uporablja za pretvorbo slik. Določene funkcije, kot denimo slike uporabnikov v profilu, ne bodo omogočene, če razširitev ni nameščena.';
$string['gdrequired'] = 'Moodle sedaj zahteva razširitev GD za pretvorbo slik.';
$string['generalsettings'] = 'Splošne nastavitve';
$string['geoipfile'] = 'GeoIP City datoteka';
$string['getremoteaddrconf'] = 'Lokacija shranjenega IP naslova';
$string['globalswarning'] = '<p><strong>VARNOSTNO OPOZORILO!</strong></p><p> Za pravilno delovanje Moodle morate <br />spremeniti nekatere od trenutnih PHP nastavitev.</p><p> <em>Morate</em> nastaviti <code>register_globals=off</code>.</p><p>Te nastavitve upravljate z urejanjem datoteke <code>php.ini</code>, nastavitvami Apache/IIS <br /> ali datoteke <code>.htaccess</code>.</p>';
$string['googlemapkey3'] = 'Ključ za Google Maps API V3';
$string['googlemapkey3_help'] = 'Vnesti morate poseben ključ, da bi lahko uporabljali Google Maps za prikaz lokacije IP naslova. Ključ lahko brezplačno pridobite na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Pojdi na prvi manjkajoči niz';
$string['gradebook'] = 'Redovalnica';
$string['gradebookroles'] = 'Ocenjene vloge';
$string['gradeexport'] = 'Osnovni način izvoza ocen';
$string['gravatardefaulturl'] = 'Privzet URL za Gravatarjevo sliko';
$string['gravatardefaulturl_help'] = 'Če Gravatar ne najde uporabnikove slike, prikaže privzeto sliko. Vnesite polni URL slike. Če pustite prazno, bo Moodle uporabil najprimernejšo privzeto sliko strani, ki si jo ogledujete. Upoštevajte, da ima Gravatar številne kode za <a href="https://en.gravatar.com/site/implement/images/#default-image">ustvarjanje privzetih slik</a>.';
$string['groupenrolmentkeypolicy'] = 'Politika skupinskih ključev za vpis';
$string['groupenrolmentkeypolicy_desc'] = 'Vklop tega bo povzročilo, da bo Moodle preverjal skupinske ključe za vpis kljub veljavni politiki gesel.';
$string['guestroleid'] = 'Vloga za gosta';
$string['guestroleid_help'] = 'Ta vloga je samodejno dodeljena gostom. Prav tako je začasno dodeljena uporabnikom, ki niso vpisani v predmet, a bodo vstopili prek vtičnika za vpis gostov.';
$string['helpadminseesall'] = 'Ali skrbniki vidijo vse dogodke koledarja ali samo tiste, ki se nanašajo na njih?';
$string['helpcalendarcustomexport'] = 'Omogočite možnost prilagoditve razpona datuma v izvozu koledarja';
$string['helpexportlookahead'] = 'Koliko dni vnaprej naj koledar išče dogodke med izvažanjem, glede na prilagojene nastavitve izvoza.';
$string['helpexportlookback'] = 'Koliko dni nazaj naj koledar išče dogodke med izvažanjem, glede na prilagojene nastavitve izvoza.';
$string['helpforcetimezone'] = 'Uporabnikom lahko dovolite, da sami izberejo svoj časovni pas ali vsilite časovni pas vsem.';
$string['helpshowicalsource'] = 'Če je omogočeno, bosta naročniško ime in povezava prikazana za iCal dogodke.';
$string['helpsitemaintenance'] = 'Za posodobitve in drugo delo';
$string['helpstartofweek'] = 'S katerim dnem se prične teden v koledarju?';
$string['helpupcominglookahead'] = 'Koliko dni v naprej naj koledar kot privzeto išče prihajajoče dogodke?';
$string['helpupcomingmaxevents'] = 'Koliko (največ) prihajajočih dogodkov se privzeto prikaže uporabnikom?';
$string['helpweekenddays'] = 'Katere dni v tednu se obravnava kot "vikend" in so prikazani v drugi barvi?';
$string['hiddenuserfields'] = 'Skrij uporabniška polja';
$string['hidefromall'] = 'Skrij pred vsemi uporabniki';
$string['hidefromnone'] = 'Ne skrij pred nobenim';
$string['hidefromstudents'] = 'Skrij pred študenti';
$string['htmleditor'] = 'Urejevalnik HTML';
$string['htmleditorsettings'] = 'Nastavitve HTML urejevalnika';
$string['htmlsettings'] = 'Nastavitve HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP varnost';
$string['iconvrecommended'] = 'Namestitev dodatne knjižnice ICONV je zelo priporočljiva za izboljšanje zmogljivosti strani, še posebej, če stran uporablja dodatne jezike.';
$string['iconvrequired'] = 'Namestitev ICONV razširitve je zahtevana.';
$string['ignore'] = 'Prezri';
$string['includemoduleuserdata'] = 'Vključi uporabniške podatke modula';
$string['incompatibleblocks'] = 'Nezdružljivi bloki';
$string['installhijacked'] = 'Namestitev mora biti zaključena iz prvotnega IP naslova, žal.';
$string['installsessionerror'] = 'Ni mogoče inicializirati PHP seje, preverite, če vaš brskalnik omogoča piškotke.';
$string['intlrecommended'] = 'Intl razširitev se uporablja za izboljšanje podore internacionalizacije, kot je npr. lokalno sortiranje.';
$string['invalidsection'] = 'Neveljavni odsek.';
$string['invaliduserchangeme'] = 'Uporabniško ime "changeme" je rezervirano -- z njim ne morete ustvariti uporabniškega računa.';
$string['ipblocked'] = 'Spletno mesto trenutno ni na voljo.';
$string['ipblocker'] = 'IP blokada';
$string['ipblockersyntax'] = 'Vstavite vsak zapis v eno vrstico. Veljavni vnosi so bodisi polni IP naslov (kot je <b> 192.168.10.1 </ b>), ki se ujema z enim gostiteljem; ali delen naslov  (kot <b> 192.168 </ b>), ki bo ustrezal kateremu koli naslovu, začenši s temi številkami; ali CIDR zapis (na primer <b> 231.54.211.0/20 </ b>), ali razpon IP naslovov (na primer <b> 231.3.56.10-20 </ b>), kjer območje velja za zadnji del naslova. Domenska imena (kot je "example.com) niso podprta. Prazne vrstice so prezrte.';
$string['iplookup'] = 'Iskanje IP naslovov';
$string['iplookupgeoplugin'] = 'Trenutno se uporablja storitev <a href="http://www.geoplugin.com">geoPlugin</a> za iskanje geografskih informacij. Za natančnejše rezultate je priporočljivo, da si namestite lokalno različico podatkovne baze MaxMind GeoLite.';
$string['iplookupinfo'] = 'Moodle privzeto uporablja zastonjski ctrežnik NetGeo za lociranje uporabnikov glede na IP naslov. Žal ta zbirka uporabnikov ni vzdrževana, zato lahko vrne <em>zelo napačne</em> podatke. Priporočamo, da si namestite lokalno kopijo zastonjske podatkovne baze GeoLite City podjetja MaxMind.<br />
Lokacija IP naslova je prikazana na preprostem zemljevidu ali pa z uporabo Google Maps. Opozorilo: za uporabo Google Maps potrebujete uporabniški račun Google, za interaktivne zemljevide pa potrebujete tudi zastonjski API ključ Google Maps.';
$string['iplookupmaxmindnote'] = 'Ta izdelek vključuje podatke GeoLite podjetja MaxMind, dostopnega na naslovu <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>';
$string['keeptagnamecase'] = 'Ohrani velike in male črke';
$string['lang'] = 'Privzeti jezik';
$string['langcache'] = 'Hranjenje menija jezika';
$string['langcache_desc'] = 'Predpomni jezikovni meni. Če je omogočeno, je seznam razpoložljivih prevodov shranjen v predpomnilniku. Predpomnilnik se samodejno osveži, ko namestite ali izbrišete jezikovni paket prek vgrajenega orodja za upravljanje z jezikovnimi paketi. Če namestite nov jezikovni paket ročno, boste morali uporabiti funkcijo "Poičisti vse predpomnilnike" za osvežitev seznama.';
$string['langlist'] = 'Jeziki v jezikovnem meniju';
$string['langmenu'] = 'Prikaži jezikovni meni';
$string['langpackwillbeupdated'] = 'Opomba za prevajalce: med nadgradnjo bo Moodle poskusil ohraniti vaš jezikovni paket. Vaše spremembe v imenikih, različnih od local, bodo prepisane.';
$string['langstringcache'] = 'Predpomni vse jezikovne nize';
$string['languagesettings'] = 'Nastavitve jezika';
$string['latexpreamble'] = 'LaTeX uvod';
$string['latexsettings'] = 'Nastavitve LaTeX prikazovalnika';
$string['latinexcelexport'] = 'Excel kodni nabor';
$string['legacyfilesinnewcourses'] = 'Podedovane datoteke predmeta v novih predmetih';
$string['legacyfilesinnewcourses_help'] = 'Privzeto so opuščene datoteke predmeta na voljo le v nadgrajenih predmetih. Upoštevajte prosim, da določene zmožnosti, ko je varnostno kopiranje/obnova posamezne aktivnosti, niso združljive s to nastavitvijo.';
$string['licensesettings'] = 'Nastavitve licence';
$string['linkadmincategories'] = 'Povezave do administratorskih kategorij';
$string['linkadmincategories_help'] = 'Če je omogočeno, bodo kategorije administratorskih nastavitev prikazane kot povezave do administratorskih strani posamezne kategorije.';
$string['loading'] = 'Nalagam';
$string['localetext'] = 'Regionalne nastavitve strežnika';
$string['localstringcustomization'] = 'Posodabljanje lokalnih nizov';
$string['location'] = 'Lokacija';
$string['locationsettings'] = 'Lokacijske nastavitve';
$string['locked'] = 'zaklenjeno';
$string['lockoutduration'] = 'Čas, ko je račun zakljenjen';
$string['lockoutduration_desc'] = 'Zakljenjen račun bo samodejno odklenjen po preteku tega časa.';
$string['lockoutemailbody'] = 'Račun z uporabniškim imenom {$a->username} na strežniku \'{$a->sitename} se je po večkratnih neuspelih poskusih prijave zaklenil.

Da bi račun takoj odklenili, pojdite na povezavo: {$a->link}

V e-poštnem sporočilu se pokaže modra povezava, na katero kliknete. Če to ne deluje, naslov skopirajte in prilepite v naslovno okno vašega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika spletnega mesta {$a->admin}';
$string['lockoutemailsubject'] = 'Vaš račun na {$a} je zaklenjen';
$string['lockouterrorunlock'] = 'Vnesli ste neveljavno geslo za odklenitev računa.';
$string['lockoutthreshold'] = 'Dovoljeno število neveljavnih poskusov prijave.';
$string['lockoutthreshold_desc'] = 'Izberite število dovoljenih neveljavnih poskusov prijave. Ta nastavitev se lahko izrabi pri napadih DoS.';
$string['lockoutwindow'] = 'Časovno okno, znotraj katerega se spremljajo neuspele prijave';
$string['lockoutwindow_desc'] = 'Čas spremljanja neuspelih prijav. Če ni neuspelih prijav, se čas začne šteti znova po preteku nastavljenega časa.';
$string['log'] = 'Dnevniški zapisi';
$string['logguests'] = 'Zabeleži dostop gosta';
$string['logguests_help'] = 'Ta nastavitev omogoča beleženje aktivnosti po uporabniških računih in neprijavljenih uporabnikih. Visoko profilne strani lahko zahtevajo, da onemogočite beleženje zaradi boljšega delovanja. Priporočljivo je, da na zelo obiskanih straneh pustite to nastavitev omogočeno. ';
$string['loginhttps'] = 'Uporabi HTTPS za prijave';
$string['loginpageautofocus'] = 'Avtomatsko fokusiraj obrazec za prijavo';
$string['loginpageautofocus_help'] = 'Omogočanje te možnosti izboljša uporabnost prijavne strani, vendar je lahko avtomatsko fokusiranje polj iz stališča dostopnosti sporno.';
$string['loginpasswordautocomplete'] = 'Prepreči samoizpolnitev gesla v prijavnem oknu.';
$string['loglifetime'] = 'Obdrži zapise za';
$string['longtimewarning'] = '<b>Pomnite, da lahko ta proces traja dolgo časa.</b>';
$string['maintenancemode'] = 'V vzdrževalnem načinu';
$string['maintenancemodeisscheduled'] = 'Strežnik bo prešel v vzdrževalni način v {$a} minutah';
$string['maintfileopenerror'] = 'Napaka pri odpiranju vzdrževalnih datotek!';
$string['maintinprogress'] = 'Vzdrževanje se izvaja...';
$string['manageformats'] = 'Upravljaj oblike predmetov.';
$string['manageformatsgotosettings'] = 'Privzeto obliko lahko spremenite v {$a}';
$string['managelang'] = '<b>Upravljaj</b>';
$string['managelicenses'] = 'Urejaj licence';
$string['manageqbehaviours'] = 'Upravljaj vedenja vprašanj';
$string['manageqtypes'] = 'Upravljaj vedenja vprašanj';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Sprosti kandidata';
$string['maturity200'] = 'Stabilna različica';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Namig: to ukazno datoteko lahko zaženete z opcijo  --allow-unstable';
$string['maturitycoreinfo'] = 'Vaša stran trenutno deluje na nestabilni "{$a}" kodi razvijalca.';
$string['maturitycorewarning'] = 'Različica Moodla, ki jo želite namestiti ali posodobiti  vsebuje nestabilno {$a} kodo razvijalca, ki ni primerna za uporabo na večini razvojnih strani. Če to ni kar ste želeli, potem se prepričajte da posodabljate iz STABILNE Moodle kode. Za več podrobnosti poglejte Moodle Docs. ';
$string['maxbytes'] = 'Največja velikost naložene datoteke';
$string['maxconsecutiveidentchars'] = 'Zaporedno enaki znaki';
$string['maxeditingtime'] = 'Časovna omejitev za urejanje prispevkov';
$string['maxusersperpage'] = 'Največje število uporabnikov na stran';
$string['mbstringrecommended'] = 'Namestitev dodatne knjižnice MBSTRING je zelo priporočljiva za izboljšanje zmogljivosti strani, še posebej, če stran uporablja dodatne jezike.';
$string['mediapluginavi'] = 'Omogoči .avi filter';
$string['mediapluginflv'] = 'Omogoči .flv filter';
$string['mediapluginimg'] = 'Omogoči samo-vgrajevanje povezanih slik';
$string['mediapluginmov'] = 'Omogoči .mov filter';
$string['mediapluginmp3'] = 'Omogoči .mp3 filter';
$string['mediapluginmpg'] = 'Omogoči .mpg filter';
$string['mediapluginogg'] = 'Omogoči .ogg filter';
$string['mediapluginogv'] = 'Omogoči .ogv filter';
$string['mediapluginram'] = 'Omogoči .ram filter';
$string['mediapluginrm'] = 'Omogoči .rm filter';
$string['mediapluginrpm'] = 'Omogoči .rpm filter';
$string['mediapluginswf'] = 'Omogoči .swf filter';
$string['mediapluginswfnote'] = 'Kot privzeta varnostna nastavitev navadnim uporabnikom ni dovoljeno vdelovanje (embed) swf flash datotek.';
$string['mediapluginwmv'] = 'Omogoči .wmv filter';
$string['mediapluginyoutube'] = 'Omogoči filter YouTube povezav';
$string['messaging'] = 'Omogoči sistem za sporočanje';
$string['messagingdeletereadnotificationsdelay'] = 'Izbriši prebrana obvestila';
$string['messaginghidereadnotifications'] = 'Skrij prebrana obvestila';
$string['minpassworddigits'] = 'Številke';
$string['minpasswordlength'] = 'Dolžina gesla';
$string['minpasswordlower'] = 'Male črke';
$string['minpasswordnonalphanum'] = 'Ne-alfanumerični znaki';
$string['minpasswordupper'] = 'Velike črke';
$string['misc'] = 'Razno';
$string['mnetrestore_extusers'] = '<strong>Opozorilo:</strong> Ta varnostna kopija vsebuje uporabniške račune oddaljenega Moodle omrežja, ki bodo povrnjeni kot del procesa.';
$string['mnetrestore_extusers_admin'] = '<strong>Opozorilo:</strong> Ta varnostna kopija očitno izvira iz druge Moodle inštalacije in vsebuje uporabniške račune oddaljenega Moodle omrežja. Postopek obnovitve bo poskusil določiti strežnike Moodle Network za vse nove uporabnike. Uporabniki, za katere to ne bo mogoče, bodo samodejno nastavljeni na interno avtentikacijo (ne prek Moodle Network). Natančen seznam takih uporabnikov bo v dnevniku obnovitve (restore log).';
$string['mnetrestore_extusers_mismatch'] = '<strong>Opozorilo:</strong> Ta varnostna kopija očitno izvira iz druge Moodle inštalacije in vsebuje uporabniške račune oddaljenega Moodle omrežja, ki morda ne bodo povrnjeni. Ta operacije je nepodprta. Če ste prepričani, da je bila varnostna kopija narejena na tej Moodle inštalaciji ali če lahko zagotovite, da so zahtevani gostitelji Moodle omrežja konfigurirani, boste morda želeli nadaljevati s povrnitvijo.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Opozorilo:</strong> Ta varnostna kopija očitno izvira iz druge Moodle inštalacije in vsebuje uporabniške račune oddaljenega Moodle omrežja. Nimate pravic za izvajanje te vrste obnovitve. Stopite v stik z administratorjem ali obnovite ta predmet brez informacij o uporabnikih (modulov, datotek, ..).';
$string['mnetrestore_extusers_switchuserauth'] = 'Oddaljeni uporabnik Moodle Network {$a->username} (s strežnika {$a->mnethosturl}) je bil prirejen lokalno avtenticiranemu uporabniku {$a->auth} .';
$string['mobile'] = 'Mobilno';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Privzeta vrednost izbirnika dejavnosti';
$string['modeditdefaults'] = 'Privzete vrednosti za nastavitve dejavnosti';
$string['modsettings'] = 'Nastavi dejavnosti';
$string['modulesecurity'] = 'Moodle varnost';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Vsili staro večjezično sintakso: &lt;span&gt; brez class="multilang" in &lt;lang&gt;';
$string['mustenablestats'] = 'Statistika za to spletno mesto še ni bila omogočena.';
$string['mycoursesperpage'] = 'Število predmetov';
$string['mydashboard'] = 'Sistemsko privzeta plošča';
$string['mymoodle'] = 'Moj Moodle';
$string['mymoodleredirect'] = 'Uporabnikom vsili stran "Moj Moodle"';
$string['mypage'] = 'Privzeta stran Moj Moodle';
$string['mypagelocked'] = 'Zakleni privzeto stran';
$string['myprofile'] = 'Privzeta profilna stran';
$string['mysql416bypassed'] = 'Če vaša stran uporablja SAMO jezike v kodni tabeli ISO-8859-1, lahko nadaljujete z uporabo trenutno nameščene različice MySQL 4.1.12 (ali višje).';
$string['mysql416required'] = 'MySQL 4.1.16 je najnižja zahtevana različica za Moodle 1.6 z jamstvom, da bodo lahko vsi podatki pretvorjeni v UTF-8 v prihodnje.';
$string['navadduserpostslinks'] = 'Dodaj povezave za ogled uporabniških objav';
$string['navadduserpostslinks_help'] = 'Če je omogočeno, bosta vsakemu uporabniku dodeljeni dve povezavi za ogled svojih diskusij in objav v forumih v predmetih ali v celotnem spletnem mestu.';
$string['navcourselimit'] = 'Meja predmeta';
$string['navigationupgrade'] = 'Ta posodobitev prinaša dva nova navigacijska bloka, ki bosta nadomestila te bloke: Administracija, Predmeti, Aktivnosti in Udeleženci. Če ste nastavili kakšna posebna dovoljenja na te bloke, preverite če vse deluje, kot vi želite.';
$string['navshowallcourses'] = 'Prikaži vse predmete';
$string['navshowcategories'] = 'Prikaži kategorije predmetov';
$string['navshowfrontpagemods'] = 'Prikaži dejavnosti na vstopni strani v Navigaciji';
$string['navshowfrontpagemods_help'] = 'Če je omogočeno, bodo dejavnosti vstopne strani prikazane v Navigaciji pod Strani spletnega mesta.';
$string['navshowfullcoursenames'] = 'Prikaži polna imena predmetov';
$string['navshowfullcoursenames_help'] = 'Če je omogočeno, bodo predmeti v Navigaciji prikazani s polnim namesto s kratkim imenom.';
$string['navshowmycoursecategories'] = 'Prikaži moje kategorije predmetov';
$string['navshowmycoursecategories_help'] = 'Če je omogočeno, bodo predmeti v izbiri Moji predmeti prikazani v kategorijah.';
$string['navsortmycoursessort'] = 'Razvrsti moje predmete';
$string['navsortmycoursessort_help'] = 'Nastavitev določa, ali bodo predmeti v Moji predmeti urejeni po vrstnem redu (kot je nastavljeno v Nastavitve > Skrbništvo strani > Predmeti > Dodaj/Izbriši predmete) ali po abecednem redu.';
$string['neverdeleteruns'] = 'Nikoli ne izbriši izvajanj';
$string['nobookmarksforuser'] = 'Nimate nobenih zaznamkov';
$string['nodatabase'] = 'Ni podatkovne baze';
$string['nohttpsformobilewarning'] = 'Priporočljivo je, da omogočite HTTPS z veljavnim certifikatom. Moodle aplikacija bo vedno najprej poskusila z uporabo varne povezave.';
$string['nomissingstrings'] = 'Ni manjkajočih nizov';
$string['nonewsettings'] = 'Med nadgradnjo ni bilo dodanih novih nastavitev.';
$string['nonexistentbookmark'] = 'Zahtevan zaznamek ne obstaja.';
$string['noresults'] = 'Ni bilo najdenih rezultatov.';
$string['noroles'] = 'Ni vlog';
$string['notifications'] = 'Obvestila';
$string['notifyloginfailures'] = 'Pošlji e-pošto ob neuspelih prijavah';
$string['notifyloginthreshold'] = 'Prag za pošiljanje opozoril po e-pošti';
$string['notloggedinroleid'] = 'Vloga za obiskovalce';
$string['numberofmissingstrings'] = 'Število manjkajočih nizov: {$a}';
$string['numberofstrings'] = 'Skupaj nizov: {$a->strings}<br />Manjka: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'Namestitev opcijske knjižnice OpenSSL je zelo priporočena, saj omogoča funkcije Moodle omrežja.';
$string['opentogoogle'] = 'Odpri Googlu';
$string['optionalmaintenancemessage'] = 'Neobvezno sporočilo o vzdrževanju';
$string['order1'] = 'Prvi';
$string['order2'] = 'Drugi';
$string['order3'] = 'Tretji';
$string['order4'] = 'Četrti';
$string['passwordpolicy'] = 'Varnostna politika gesel';
$string['pathconvert'] = 'Pot do binarne datoteke <i>convert</i>';
$string['pathdvips'] = 'Pot do binarne datoteke <i>dvips</i>';
$string['pathlatex'] = 'Pot do binarne datoteke <i>latex</i>';
$string['pathtoclam'] = 'pot clam AV';
$string['pathtodot'] = 'Pot do pike';
$string['pathtodot_help'] = 'Pot do pike. Najverjetneje nekaj kot /usr/bin/dot. Da boste lahko generirali grafiko iz DOT datotek, morate namestiti dot izvršilno datoteke in tukaj označiti pot do nje. Pomnite, da je sedaj to uporabljeno za profilne lastnosti (Development->Profiling), vgrajene v Moodle.';
$string['pathtodu'] = 'Pot do du';
$string['pathtopgdump'] = 'Pot do pg_dump';
$string['pathtopgdumpdesc'] = 'To je potrebno vnesti samo, če imate na vašem strežniku več kot en pg_dump (na primer, če imate nameščeno več kot eno različico postgresql)';
$string['pathtopgdumpinvalid'] = 'Neveljavno pot do pg_dump - bodisi napačna pot, ali se datoteke ne da izvajati';
$string['pathtopsql'] = 'Pot do psql';
$string['pathtopsqldesc'] = 'To je potrebno vnesti samo, če imate na vašem strežniku več kot en psql (na primer, če imate nameščeno več kot eno različico postgresql)';
$string['pathtopsqlinvalid'] = 'Neveljavno pot do psql - bodisi napačna pot, ali se datoteke ne da izvajati';
$string['perfdebug'] = 'Podatki o zmogljivosti';
$string['performance'] = 'Zmogljivost';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'PostgreSQL parameter različica/cluster za operacije ukazne vrstice. Če imate samo en postgresql na vašem strežniku, ali ne veste kaj je to, pustite prazno.';
$string['php50restricted'] = 'PHP 5.0.x ima vrsto znanih težav, posodobite na 5.1.x ali namestite starejšo različico 4.3.x ali 4.4.x';
$string['php533warning'] = 'Priporočljiv je PHP 5.3.3 in novejši';
$string['phpfloatproblem'] = 'Zaznal nepričakovano težavo pri obravnavi PHP števil s plavajočo vejico - {$a}';
$string['pleaserefreshregistration'] = 'Vaš strežnik je bil registriran na moodle.org. Prosimo, osvežite registracijo, če je od zadnje spremembe dne {$a} prišlo do večjih sprememb.';
$string['pleaseregister'] = 'Prosimo, registrirajte svojo stran za odstranitev tega gumba';
$string['plugin'] = 'Vtičnik';
$string['plugins'] = 'Vtičniki';
$string['pluginsoverview'] = 'Pregled vtičnikov';
$string['pluginsoverviewsee'] = 'Za podrobnosti glej stran<a href="{$a->url}">pregled vtičnikov</a>.';
$string['profilecategory'] = 'Kategorija';
$string['profilecategoryname'] = 'Ime kategorije (mora biti enkratno)';
$string['profilecategorynamenotunique'] = 'Ime kategorije je že v uporabi';
$string['profilecommonsettings'] = 'Splošne nastavitve';
$string['profileconfirmcategorydeletion'] = 'V tej kategoriji je {$a} polj, ki bodo premaknjena v zgornjo kategorijo (ali v spodnjo, če so polja v najvišji kategoriji).<br />Ali ste prepričani, da želite izbrisati to kategorijo?';
$string['profileconfirmfielddeletion'] = 'V tem polju je {$a} uporabniških zapisov, ki bodo izbrisani.<br />Ali ste prepričani, da želite izbrisati to polje?';
$string['profilecreatecategory'] = 'Ustvari novo kategorijo profila';
$string['profilecreatefield'] = 'Ustvari novo polje profila:';
$string['profilecreatenewcategory'] = 'Ustvarjanje nove kategorije';
$string['profilecreatenewfield'] = 'Ustvarjanje novega polja profila &quot;{$a}&quot;';
$string['profiledefaultcategory'] = 'Druga polja';
$string['profiledefaultchecked'] = 'Privzeto označeno';
$string['profiledefaultdata'] = 'Privzeta vrednost';
$string['profiledeletecategory'] = 'Brisanje kategorije';
$string['profiledeletefield'] = 'Brisanje polja';
$string['profiledescription'] = 'Opis polja';
$string['profiledscript'] = 'Ta skripta je bila profilirana';
$string['profiledscriptview'] = 'Ogled profilirane informacije za to skripto';
$string['profileeditcategory'] = 'Urejanje kategorije: {$a}';
$string['profileeditfield'] = 'Urejanje polja profila: {$a}';
$string['profilefield'] = 'Polje profila';
$string['profilefieldcolumns'] = 'Stolpci';
$string['profilefieldispassword'] = 'Je to polje za geslo?';
$string['profilefieldlink'] = 'Povezava';
$string['profilefieldlink_help'] = 'Za preobrazbo besedila v povezavo, vnesite URL ki vsebuje $$, kjer bo $$ zamenjano z besedilom. Na primer, za preobrazbo Twitter ID-ja v povezavo, vnesite http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Cilj povezave';
$string['profilefieldmaxlength'] = 'Največja dolžina';
$string['profilefieldrows'] = 'Vrstice';
$string['profilefields'] = 'Polja uporabniškega profila';
$string['profilefieldsize'] = 'Velikost prikazanega polja';
$string['profileforceunique'] = 'Ali naj bodo podatki edinstveni?';
$string['profileinvaliddata'] = 'Neveljavna vrednost';
$string['profilelocked'] = 'Ali je to polje zaklenjeno?';
$string['profilemenudefaultnotinoptions'] = 'Privzeta vrednost ni ena izmed možnosti';
$string['profilemenunooptions'] = 'Ni ponujenih možnosti za meni';
$string['profilemenuoptions'] = 'Možnosti menija (vsaka v svojo vrstico)';
$string['profilemenutoofewoptions'] = 'Ponuditi morate vsaj 2 možnosti';
$string['profilename'] = 'Ime';
$string['profilenofieldsdefined'] = 'Ni bilo določenih polj';
$string['profilerequired'] = 'Ali je to polje zahtevano?';
$string['profileroles'] = 'Vidne vloge profila';
$string['profilesforenrolledusersonly'] = 'Profili samo za vpisane uporabnike';
$string['profileshortname'] = 'Kratko ime (mora biti enkratno)';
$string['profileshortnamenotunique'] = 'To kratko ime je že v uporabi';
$string['profilesignup'] = 'Prikaži na strani za prijavo?';
$string['profilespecificsettings'] = 'Posebne nastavitve';
$string['profilevisible'] = 'Kdo lahko vidi to polje?';
$string['profilevisibleall'] = 'Vidno vsem';
$string['profilevisible_help'] = '<p>Vsakemu izmed polj po meri lahko določite eno izmed treh nastavitev vidnosti: Nevidno, Vidno vsem in Vidno uporabniku. Nastavitev \'Nevidno\' bo ponavadi uporabil skrbnik, ki želi imeti zasebne podatke o uporabniku. Nastavitev \'Vidno uporabniku\' bo ponavadi izbrana za polje, ki vsebuje občutljive informacije, medtem ko je nastavitev \'Vidno vsem\' moč uporabiti za katerokoli vrto informacije.</p>';
$string['profilevisiblenone'] = 'Nevidno';
$string['profilevisibleprivate'] = 'Vidno uporabniku';
$string['profiling'] = 'Profiliranje';
$string['profilingallowall'] = 'Neprekinjeno profiliranje';
$string['profilingallowall_help'] = '';
$string['profilingallowme'] = 'Selektivno profiliranje';
$string['profilingautofrec'] = 'Avtomatsko profiliranje';
$string['profilingenabled'] = 'Omogoči profiliranje';
$string['profilingexcluded'] = 'Izključi profiliranje';
$string['protectusernames'] = 'Zaščiti uporabniška imena';
$string['proxyhost'] = 'Prehodni strežnik';
$string['proxypassword'] = 'Geslo prehodnega strežnika';
$string['proxyport'] = 'Vrata prehodnega strežnika';
$string['proxytype'] = 'Vrsta prehodnega strežnika';
$string['proxyuser'] = 'Uporabniško ime prehodnega strežnika';
$string['purgecaches'] = 'Počisti vse predpomnilnike';
$string['purgecachesconfirm'] = 'Moodle lahko predpomni teme, JavaScript, jezikovne nastavitve, tekstovne filtre, RSS vire in mnoge druge primerke preračunanih podatkov. Čiščenje teh predpomnilnikov bo izbrisalo te podatke iz strežnika in prisililo brskalnike, da ponovno pridobijo podatke, tako da ste lahko prepričani, da vidite najbolj sveže vrednosti, ki jih proizvaja trenutna koda. Čiščenje predpomnilnikov ni nevarno, vaša stran bo morda nekaj časa delovala počasne, dokler strežnik in klienti ne preračunajo novih informacij in jih predpomnijo.';
$string['purgecachesfinished'] = 'Vsi predpomnilniki so bilo počiščeni.';
$string['qtyperqpwillberemoved'] = 'Med nadgradnjo bodo odstranjena vprašanje vrste RQP. Te vrste vprašanj niste uporabljali, zato naj to ne bi bil problem.';
$string['qtyperqpwillberemovedanyway'] = 'Med nadgradnjo bodo odstranjena vprašanje vrste RQP. V podatkovni zbirki imate nekaj vprašanj vrste RQP, ki bodo prenehala delovati, če ne namestite ponovno kode iz http://moodle.org/mod/data/view.php?d=13&amp;rid=797 pred nadaljevanjem nadgradnje.';
$string['quarantinedir'] = 'Imenik za karanteno';
$string['question'] = 'Vprašanje';
$string['questionbehaviours'] = 'Vedenja vprašanj';
$string['questioncwqpfscheck'] = 'Eno ali več \'naključnih\' vprašanj v kvizu je nastavljenih za izbiro vprašanj iz nabora objavljenih in ne objavljenih kategorij vprašanj. Podrobnejše poročilo lahko najdete <a href="{$a->reporturl}">tukaj</a> in si pogledate stran v Moodle dokumentaciji <a href="{$a->docsurl}">tukaj</a>.';
$string['questioncwqpfsok'] = 'Dobro. V vaših kvizih ni \'naključnih\' vprašanj, ki bi izbirala iz nabora objavljenih in ne objavljenih kategorij vprašanj';
$string['questiontype'] = 'Tip vprašanja';
$string['questiontypes'] = 'Tipi vprašanj';
$string['recaptchaprivatekey'] = 'ReCAPTCHA zasebni ključ';
$string['recaptchapublickey'] = 'ReCAPTCHA javni ključ';
$string['register'] = 'Registrirajte vaše spletno mesto';
$string['registermoodleorg'] = 'Ko registrirate vaše spletno mesto pri {$a}';
$string['registermoodleorgli2'] = 'Statistika vašega spletnega mesta bo dodana {$a} svetovne Moodle skupnosti.';
$string['registerwithmoodleorg'] = 'Registrirajte pri Moodle.org';
$string['registration'] = 'Registracija';
$string['registration_help'] = 'Registacija vašega spletnega mesta pri Moodle.org je priporočljiva. S tem boste prejemali varnostna opozorila, prispevali boste k <a href="http://moodle.org/stats">statistični uporabi Moodla</a> in lahko boste predmete dali v skupno rabo na  <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Vaše spletno mesto še ni registrirano.';
$string['releasenoteslink'] = 'Za informacije o tej različici Moodle si oglejte spletne <a target="_new" href="{$a}">Opombe o različici</a>';
$string['rememberusername'] = 'Shrani uporabniško ime';
$string['reportsmanage'] = 'Upravljaj poročila';
$string['requestcategoryselection'] = 'Omogoči izbiro kategorij';
$string['requiredentrieschanged'] = '<strong>POMEMBNO - PROSIMO PREBERITE<br/>(To opozorilo bo prikazano samo ob tej nadgradnji)</strong><br/>Zaradi popravka hrošča bo spremenjeno vedenje aktivnosti podatkovnih zbirk, ki uporabljajo nastavitev \'Zahtevani vnosi\' in \'Zahtevanih vnosov pred ogledom\'. Bolj podrobno razlago lahko preberete na <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">forumu modula podatkovne zbirke</a>. Pričakovano vedenje teh nastavitev lahko preberete tudi v <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle dokumentaciji</a>. <br/><br/>Te spremembe vplivajo na sledeče podatkovne zbirke na vašem sistemu: (Prosimo, da zdaj shranite ta seznam in po nadgradnji preverite, če te aktivnosti še delujejo tako, kot si je zamislil učitelj.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Zahtevaj opis aktivnosti';
$string['requires'] = 'Zahteva';
$string['reverseproxy'] = 'Vhodni prehodni strežnik (reverse proxy)';
$string['riskconfig'] = 'Uporabniki bi lahko spremenili konfiguracijo in obnašanje spletnega mesta';
$string['riskconfigshort'] = 'Tveganje glede konfiguracije';
$string['riskdataloss'] = 'Uporabniki lahko uničijo veliko količino vsebine ali informacij';
$string['riskdatalossshort'] = 'Tveganje izgube podatkov';
$string['riskmanagetrust'] = 'Uporabniki bi lahko spremenili nastavitve zaupanja pri drugih uporabnikih';
$string['riskmanagetrustshort'] = 'Upravljanje zaupanja';
$string['riskpersonal'] = 'Uporabniki bi lahko dobili dostop do zasebnih informacij drugih uporabnikov';
$string['riskpersonalshort'] = 'Tveganje glede zasebnosti';
$string['riskspam'] = 'Uporabniki bi lahko drugim uporabnikom spletnega mesta ali drugim uporabnikom pošiljali nezaželena sporočila (spam)';
$string['riskspamshort'] = 'Spam tveganje';
$string['riskxss'] = 'Uporabniki lahko dodajajo datoteke in tekste, ki dovoljujejo izvajanje skript na drugih strežnikih (XSS)';
$string['riskxssshort'] = 'XSS tveganje';
$string['roleswithexceptions'] = '{$a->roles}, z {$a->exceptions}';
$string['rssglobaldisabled'] = 'Onemogočeno na nivoju strežnika';
$string['runclamavonupload'] = 'Pri naloženih datotekah uporabi clam AV';
$string['save'] = 'Shrani';
$string['savechanges'] = 'Shrani spremembe';
$string['search'] = 'Iskanje';
$string['searchinsettings'] = 'Išči po nastavitvah';
$string['searchresults'] = 'Rezultati iskanja';
$string['sectionerror'] = 'Napaka pri odsekih!';
$string['secureforms'] = 'Uporabi dodatno varovanje pri obrazcih';
$string['security'] = 'Varnost';
$string['selectdevice'] = 'Izberi napravo';
$string['selecttheme'] = 'Izberi temo za {$a} napravo';
$string['server'] = 'Strežnik';
$string['serverchecks'] = 'Preverjanje strežnika';
$string['serverlimit'] = 'Omejitev na strežniku';
$string['sessionautostartwarning'] = '<p>Zaznana je bila resna napaka v nastavitvah, prosimo obvestite skrbnika strežnika.</p><p>Za pravilno delovanje Moodle zahteva, da skrbnik spremeni PHP nastavitve.</p><p><code>session.auto_start</code> mora biti nastavljena na <code>off</code>.</p><p>To nastavitev se upravlja z urejanjem <code>php.ini</code>, Apache/IIS <br />konfiguracije ali <code>.htaccess</code> datoteke na strežniku.</p>';
$string['sessioncookie'] = 'Predpona za piškotke';
$string['sessioncookiedomain'] = 'Domena piškotkov';
$string['sessioncookiepath'] = 'Pot za piškotke';
$string['sessionhandling'] = 'Nadzor seje';
$string['sessiontimeout'] = 'Časovna omejitev';
$string['settingfileuploads'] = 'Za normalno delovanje je potrebna možnost nalaganja datotek, prosimo omogočite jo v PHP nastavitvah.';
$string['settingmemorylimit'] = 'Nezadostna količina pomnilnika, prosimo nastavite višjo mejo pomnilnika v PHP nastavitvah.';
$string['settingsafemode'] = 'Moodle ni polno združljiv z varnim načinom (safe mode), prosite skrbnika strežnika, da ta način izklopi. Delovanje Moodla v varnem načinu ni podprto, pričakujte raznovrstne težave, če ga boste uporabljali v tem načinu.';
$string['showcommentscount'] = 'Prikaži števec komentarjev';
$string['showdetails'] = 'Prikaži podrobnosti';
$string['showuseridentity'] = 'Prikaži identiteto uporabnika';
$string['showuseridentity_desc'] = 'V prikazu izbranih ali iskanih uporabnikov, so lahko ta polja prikazana dodatno k njihovemu polnemu imenu. Ta polja vidijo samo tisti uporabniki, ki imajo omogočeno možnost moodle/site:viewuseridentity capability.
(Ta nastavitev je najbolj smiselna, če izberete eno ali dve polji, ki jih uporabljate v vaši organizaciji)';
$string['simplexmlrequired'] = 'SimpleXML PHP razširitev je potrebna.';
$string['sitemaintenance'] = 'To stran pravkar vzdržujemo in trenutno ni na voljo';
$string['sitemaintenancemode'] = 'Vzdrževalni način';
$string['sitemaintenanceoff'] = 'Vzdrževalni način je bil onemogočen in stran znova deluje normalno';
$string['sitemaintenanceon'] = 'Vaša stran je trenutno v vzdrževalnem načinu (samo skrbniki se lahko prijavijo ali uporabljajo stran)';
$string['sitemaintenanceoncli'] = 'Strežnik se trenutno nahaja v vzdrževalnem načinu CLI, zato spletni dostop ni dovoljen.';
$string['sitemaintenancewarning'] = 'Vaša stran je trenutno v vzdrževalnem načinu (samo skrbniki se lahko prijavijo).  Za vrnitev strani v normalno delovanje, <a href="maintenance.php">onemogočite vzdrževalni način</a>.';
$string['sitemaintenancewarning2'] = 'Vaša stran je trenutno v načinu vzdrževanja (samo skrbniki se lahko prijavijo). Za vrnitev te strani v normalno delovanje, <a href="{$a}">disable maintenance mode</a>.';
$string['sitepolicies'] = 'Pravila za uporabo';
$string['sitepolicy'] = 'URL do pravil za uporabo';
$string['sitepolicyguest'] = 'Politika URL strani za goste';
$string['sitepolicyguest_help'] = 'Če imate politiko strani, katero morajo gosti pregledati in se z njo strinjati pred uporabo te strani, specificirajte tukaj URL strani, v nasprotnem primeru pustite polje prazno. Ta nastavitev lahko vsebuje kateri koli javni URL. Pomnite: dostop nevpisanih uporabnikov je lahko preprečen s prisiljeno vpisanimi nastavitvami.  ';
$string['sitepolicy_help'] = 'Če ima spletno mesto pravila, ki jih morajo vsi uporabniki videti in se z njimi strinjati pred uporabo tega spletnega mesta, potem tu navedite URL teh pravil, ali pustite polje prazno. URL lahko kaže kamorkoli - primerno mesto bi bila datoteka med datotekami spletnega mesta. Npr. http://spletninaslov/file.php/1/pravila.html';
$string['sitesectionhelp'] = 'Če izberete to možnost, bo na naslovni strani spletnega mesta (v osrednjem delu) prikazan nov odsek poglavja, ki ga boste lahko urejali in mu dodajali vire in dejavnosti.';
$string['slasharguments'] = 'Uporaba poševnice v argumentih';
$string['smartpix'] = 'Pametno iskanje slik';
$string['soaprecommended'] = 'Namestitev opcijske soap razširitve je uporabna za spletne storitve in nekatere contrib module.';
$string['sort_fullname'] = 'Polno ime predmeta';
$string['sort_idnumber'] = 'ID številka predmeta';
$string['sort_shortname'] = 'Kratko ime predmeta';
$string['sort_sortorder'] = 'Vrstni red';
$string['spellengine'] = 'Orodje za črkovanje';
$string['spelllanguagelist'] = 'Seznam jezikov za črkovanje';
$string['splrequired'] = 'Moodle potrebuje SPL PHP razširitev ';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Najdaljši interval procesiranja';
$string['statsmaxruntime'] = 'Najdaljši čas delovanja';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Število dni za obdelavo';
$string['statsruntimestart'] = 'Zagnano ob';
$string['statsuserthreshold'] = 'Prag uporabnikov';
$string['stickyblocks'] = 'Lepljivi bloki';
$string['stickyblockscourseview'] = 'Stran predmeta';
$string['stickyblocksduplicatenotice'] = 'Če je katerikoli blok, ki ga tu dodate, že prisoten na določeni strani, se bo podvojil.<br />Samo pripetega bloka ne bo možno urejati, dvojnik bo še vedno možno urejati.';
$string['stickyblocksmymoodle'] = 'Moj Moodle';
$string['stickyblockspagetype'] = 'Vrsta strani za konfiguracijo';
$string['strictformsrequired'] = 'Natančno potrjevanje veljavnosti obveznih polj';
$string['stripalltitletags'] = 'Izbriši HTML oznake iz imen dejavnosti';
$string['supportcontact'] = 'Podpora kontakta';
$string['supportemail'] = 'Podporni e-poštni naslov';
$string['supportname'] = 'Podporno ime';
$string['supportpage'] = 'Podporna stran';
$string['suspenduser'] = 'Začasno onemogočeni račun';
$string['switchlang'] = 'Zamenjaj imenik z jezikom';
$string['systempaths'] = 'Pot do sistemskih imenikov';
$string['tablenosave'] = 'Spremembe v zgornji tabeli so samodejno shranjene.';
$string['tablesnosave'] = 'Spremembe v zgornji tabeli so samodejno shranjene.';
$string['tabselectedtofront'] = 'V tabelah z zavihki prikaži vrstico s trenutno izbranim zavihkom spredaj';
$string['tabselectedtofronttext'] = 'Prikaži izbrani zavihek vrstice spredaj';
$string['themedesignermode'] = 'Način oblikovanja tem';
$string['themelist'] = 'Seznam tem';
$string['themenoselected'] = 'Ni izbrane teme';
$string['themeresetcaches'] = 'Počisti predpomnilnik teme';
$string['themeselect'] = 'Izberi temo';
$string['themeselector'] = 'Izbira tem';
$string['themesettings'] = 'Nastavitve tem';
$string['therewereerrors'] = 'V vaših podatkih so bile napake';
$string['thirdpartylibrary'] = 'Knjižnica';
$string['timezone'] = 'Privzet časovni pas';
$string['timezoneforced'] = 'To je vsiljeno s strani skrbnika strani';
$string['timezoneisforcedto'] = 'Vsili vsem uporabnikom naj uporabljajo';
$string['timezonenotforced'] = 'Uporabniki lahko izberejo lasten časovni pas';
$string['tokenizerrecommended'] = 'Priporočamo namestitev razširitve PHP Tokenizer - izboljša delovanje Moodle omrežja';
$string['tools'] = 'Orodja za administracijo';
$string['toolsmanage'] = 'Upravljaj orodja za administracijo';
$string['unattendedoperation'] = 'Samodejno delovanje';
$string['unbookmarkthispage'] = 'odstrani to stran iz zaznamkov';
$string['unicoderecommended'] = 'Priporočamo, da svoje podatke hranite v formatu Unicode (UTF-8). Nove namestitve bi morale biti nameščene na podatkovnih zbirkah s privzeto kodno stranjo Unicode. Če nadgrajujete sistem, morate izvesti migracijo na UTF-8 (več informacij na strani za administratorje)';
$string['unicoderequired'] = 'Vaši podatki morajo biti shranjeni v formatu Unicode (UTF-8). Nove namestitve morajo biti nameščene na podatkovnih zbirkah s privzeto kodno stranjo Unicode. Če nadgrajujete sistem, morate izvesti migracijo na UTF-8 (več informacij na strani za administratorje)';
$string['uninstallplugin'] = 'Odstrani';
$string['unlockaccount'] = 'Odkleni račun';
$string['unsettheme'] = 'Nenameščena tema';
$string['unsupported'] = 'Nepodprt';
$string['unsuspenduser'] = 'Aktiviraj uporabniški račun';
$string['updateaccounts'] = 'Posodobi obstoječe uporabniške račune';
$string['updateautocheck'] = 'Samodejno preveri, ali so na voljo posodobitve';
$string['updateautocheck_desc'] = 'Če je omogočeno, bo strežnik samodejno preveril, ali so na voljo posodobitve Moodla in dodatnih vtičnikov. V tem primeru bodo skrbniki spletnega mesta obveščeni.';
$string['updateautodeploy'] = 'Omogoči nameščanje posodobitev';
$string['updateautodeploy_desc'] = 'Če je omogočeno, boste lahko';
$string['updateavailable'] = 'Na voljo je novejša različica Moodla!';
$string['updateavailabledetailslink'] = 'Za več podrobnosti glej {$a->url}';
$string['updateavailableforplugin'] = 'Na voljo so novejše verzije nekaterih vtičnikov!';
$string['updateavailableinstall'] = 'Namesti to posodobitev';
$string['updateavailable_moreinfo'] = 'Več o tem...';
$string['updateavailablenot'] = 'Moodle je posodobljen!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Različica {$a}';
$string['updatecomponent'] = 'Posodobi komponento';
$string['updatenotificationfooter'] = 'Vaše spletno mesto {$a->siteurl} je nastavljeno tako, da samodejno preverja, če so na voljo posodobitve. To obvestilo ste prejeli kot skrbnik spletnega mesta. Samodejno preverjanje za posodobitvami lahko izklopite v Skrbništvu strani v bloku Nastavitve. Nastavitve glede pošiljanja tega obvestila lahko nastavite v bloku Navigacija > Moj profil > Sporočila.';
$string['updatenotifications'] = 'Posodobi obvestila';
$string['updatenotificationsubject'] = 'Na voljo so posodobitve Moodla ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Pošlji obvestilo o novih gradnjah';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 vsebuje veliko število varnostnih popravkov za uporabniška gesla in varnostne kopije, ki ščitijo uporabniške podatke na vaši strani. Kot rezultat bodo spremenjene vaše nastavitve in dovoljenja za varnostne kopije.<br />
See the <a href="http://docs.moodle.org/dev/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 zapiski izdaje</a> za vse podrobnosti.</p>';
$string['upgrade197noticesubject'] = 'Varnostna obvestila Moodle 1.9.7 posodobitve ';
$string['upgrade197salt'] = 'Za zmanjševanje rizika kraje gesla, vam je močno priporočeno, da nastavite "salt" gesla. <br />Poglejte <a href="{$a}" target="_blank"> dokumentacijo salting gesla</a> za podrobnosti.';
$string['upgradeerror'] = 'Neznana napaka pri posodobitvi {$a->plugin} na verzijo {$a->version}, se ne more nadaljevati.';
$string['upgradeforumread'] = 'V Moodle 1.5 je bila dodana nova možnost sledenja prebranih/neprebranih objav foruma.<br />Za uporabo te funkcionalnosti morate <a href="{$a}">posodobiti vaše tabele</a>.';
$string['upgradeforumreadinfo'] = 'V Moodle 1.5 je bila dodana nova možnost sledenja prebranih/neprebranih objav foruma. Za uporabo te funkcionalnosti morate vaše tabele posodobiti z vsemi informacijami o sledenju za obstoječe objave. Postopek lahko traja več ur (odvisno od velikosti vašega spletnega mesta) in je lahko obremenjujoč za podatkovno zbirko, zato je to najbolje storiti v obdobjih, ko ni veliko uporabnikov. Kljub temu bo vaša stran med to posodobitvijo še naprej delovala in to ne bo vplivalo na uporabnike. Ko boste zagnali ta proces, ga morate pustiti, da se zaključi (pustite okno brskalnika odprto). Če kljub temu prekinete postopek z zaprtjem okna: ne skrbite - lahko začnete znova.<br /><br />Želite sedaj začeti s postopkom posodobitve?';
$string['upgradelogs'] = 'Za polno funkcionalnost je potrebno nadgraditi stare dnevniške zapise. <a href="{$a}">Več informacij</a>';
$string['upgradelogsinfo'] = 'V zadnjem času je bilo nekaj sprememb v načinu shranjevanja dnevniških zapisov. Da bi si lahko ogledali starejše zapise za dejavnosti, je potrebno stare dnevniške zapise nadgraditi. Postopek lahko traja več ur (odvisno od velikosti vašega spletnega mesta) in je lahko obremenjujoč za podatkovno zbirko na večjih straneh. Ko boste zagnali ta proces, ga morate pustiti, da se zaključi (tako, da pustite okno brskalnika odprto). Ne skrbite - vaša stran bo delovala v redu za ostale osebe med tem, ko se bodo dnevniki nagrajevali.<br /><br />Želite sedaj nadgraditi dnevniške zapise?';
$string['upgradepluginsfirst'] = 'Priporočljivo je najprej namestiti vse posodobitve';
$string['upgradepluginsinfo'] = 'Posodabljam vtičnike';
$string['upgradepluginsinfo_help'] = 'Za nekatere vtičnike so na voljo posodobitve. Priporočljivo je, da jih namestite pred nadgradnjo Moodla. Če nastavitev vašega strežnika ne omogoča samodejne namestitve posodobitev, jih morate ročno prenesti in namestiti.';
$string['upgradesettings'] = 'Nove nastavitve';
$string['upgradesettingsintro'] = 'Spodaj prikazane nastavitve so bile dodane med vašo zadnjo Moodle nadgradnjo. Po potrebi spremenite privzete nastavitve ter nato kliknite &quot;Shrani spremembe&quot; na dnu strani.';
$string['upgradestalefiles'] = 'Obstajajo neskladne različice Moodla, zato se nadgradnja ne more nadaljevati.';
$string['upgradestalefilesinfo'] = 'Proces nadgradnja Moodla je bila začasno ustavljena, ker se v mapi Moodla nahajata vsaj dve PHP skripti različnih verzij.

To lahko kasneje povzroči resne težave, zato morate zagotoviti, da mapa Moodle vsebuje datoteke samo ene verzije.

Priporočljivo je storiti naslednje:

* preimenujte trenutno mapo Moodle v "moodle_old"
* ustvarite novo mapo Moodle, ki vsebuje le datoteke iz standardnega paketa, ki ste ga prenesli ali pa iz Moodle Git skladišča
* premaknite originalno datoteko config.php in druge nestandardne vtičnike iz mape "moodle_old" v novo Moodle mapo

Ko ste tako očistili mapo Moodle, osvežite to stran za nadaljevanje procesa nadgradnje.

To opozorilo se najpogosteje pojavi, če odzipate standardni Moodle paket čez prejšnjo različico Moodla. Za manjše posodobitve je to sprejemljivo, močno pa se odsvetuje za večje posodobitve.

Vzrok za to sporočilo je lahko tudi spodletela preveritev oz. posodobitev iz Git skladišča. V tem primeru morate le počakati, da se dejanje zaključi ali pa zagnati ukaz za brisanje in ponoviti operacijo.

Več o tem lahko najdete v dokumentaiji za nadgradnjo na <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Nadgradnja';
$string['upgradesure'] = 'Vaše programske datoteke so bile spremenjene in sedaj boste samodejno nadgradili vaš strežnik na to različico: <br /> <br />
<strong>{$a}</strong> <br /><br />
Ko enkrat to naredite, se ne morete več vrniti. <br /> <br />
Ste prepričani, da želite nadgraditi ta strežnik na to različico?';
$string['upgradetimedout'] = 'Nadgradnja je potekla, prosimo ponovno zaženite nadgradnjo.';
$string['upgradingdata'] = 'Nadgrajevanje podatkov';
$string['upgradinglogs'] = 'Nadgrajevanje dnevnikov';
$string['upgradingversion'] = 'Nadgradnja na novo različico';
$string['upwards'] = 'navzgor';
$string['useblogassociations'] = 'Omogoči združenja';
$string['useexternalyui'] = 'Uporabi mrežne YUI knjižnice';
$string['user'] = 'Uporabnik';
$string['userbulk'] = 'Dejanja na množici uporabnikov';
$string['userlist'] = 'Prebrskaj seznam uporabnikov';
$string['userpolicies'] = 'Uporabniška politika';
$string['userpreference'] = 'Uporabniške preference';
$string['userquota'] = 'Uporabniška kvota';
$string['users'] = 'Uporabniki';
$string['usesitenameforsitepages'] = 'Uporabi ime spletnega mesta za strani spletnega mesta.';
$string['usetags'] = 'Omogoči funkcije oznak';
$string['validateerror'] = 'Ta vnesena vrednost ni veljavna:';
$string['verifychangedemail'] = 'Omeji domene pri spremembi e-poštnega naslova';
$string['warningcurrentsetting'] = 'Neveljavna vrednost: {$a}';
$string['webproxy'] = 'Prehodni strežnik';
$string['webproxyinfo'] = 'Nastavite sledeče nastavitve, če vaš Moodle strežnik ne more direktno dostopati do interneta. Dostop do interneta je potreben za prenos podatkov o okolju, jezikovnih paketov, RSS virov, podatkov o časovnih pasovih ipd.<br /><em>Priporočamo namestitev razširitve cURL za PHP.</em>';
$string['xmlrpcrecommended'] = 'Xmlrpc razširitev je potrebna za komunikacijo med vozlišči in je uporabna za spletne servise in Moodle mreženje';
$string['yuicomboloading'] = 'YUI combo nalaganje';
$string['ziprequired'] = 'Razširitev Zip PHP je sedaj nujna za delovanje Moodle. Knjižnice info-ZIP in PclZIP niso več v uporabi.';
