<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_xmldb', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   tool_xmldb
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actual'] = 'Važeće';
$string['aftertable'] = 'Nakon tabele:';
$string['back'] = 'Nazad';
$string['backtomainview'] = 'Nazad na glavni prikaz';
$string['cannotuseidfield'] = 'Nije moguće umetnuti "ID" polje. Riječ je o automatski numerisanoj koloni.';
$string['change'] = 'Promijeni';
$string['charincorrectlength'] = 'Netačna dužina polja karaktera';
$string['checkbigints'] = 'Provjeri velike cijelobrojne vrijednosti (bigint)';
$string['check_bigints'] = 'Potraga za pogrešnim cijelobrojnim vrijednostima u bazi podataka';
$string['checkdefaults'] = 'Provjeri zadane vrijednosti';
$string['check_defaults'] = 'Potraga za nekonzistentnim zadanim vrijednostima';
$string['checkforeignkeys'] = 'Provjeri strane ključeve';
$string['check_foreign_keys'] = 'Potraga za prekršajima stranih ključeva';
$string['checkindexes'] = 'Provjeri indekse';
$string['check_indexes'] = 'Potraga za indeksima baze podataka koji nedostaju';
$string['checkoraclesemantics'] = 'Provjeri semantiku';
$string['check_oracle_semantics'] = 'Potraga za semantikom pogrešne dužine';
$string['completelogbelow'] = '(pogledaj kompletan zapis pretrage)';
$string['confirmcheckbigints'] = 'Ova funkcionalnost će potražiti <a href="http://tracker.moodle.org/browse/MDL-11038">potencijalno pogrešna polja sa cijelobrojnim vrijednostima</a> na vašem Moodle serveru, i automatski generirati (ali ne i izvršiti!) potrebne SQL naredbe kako bi sve cijelobrojne vrijednosti u vašoj bazi podataka bile pravilno definirane.<br /><br /> Jednom, kada su naredbe generirane, možete ih kopirati i izvršiti sigurno u svom omiljenom SQL klijentu (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br /> Više je nego preporučljivo da koristite najnoviju dostupnu verziju (tzv. + verziju) vašeg izdanja Moodlea (1.8, 1.9, 2.x), prije nego što izvršite pretraživanje pogrešnih cijelobrojnih vrijednosti.<br /><br /> Ova funkcionalnost ne izvodi bilo kakve akcije nad Vašom bazom podataka (već samo čita iz nje), tako da se može sigurno izvršiti u svakom trenutku.';
$string['confirmcheckdefaults'] = 'Ova funkcionalnost će potražiti nekonzistentne zadane vrijednosti na vašem Moodle serveru, i automatski generirati (ali ne i izvršiti!) potrebne SQL naredbe kako bi sve zadane vrijednosti bile pravilno definirane.<br /><br /> Jednom, kada su naredbe generirane, možete ih kopirati i izvršiti sigurno u svom omiljenom SQL klijentu (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br /> Više je nego preporučljivo da koristite najnoviju dostupnu verziju (tzv. + verziju) vašeg izdanja Moodlea (1.8, 1.9, 2.x), prije nego što izvršite pretraživanje nekonzistentnih zadanih vrijednosti.<br /><br /> Ova funkcionalnost ne izvodi bilo kakve akcije nad Vašom bazom podataka (već samo čita iz nje), tako da se može sigurno izvršiti u svakom trenutku.';
$string['confirmcheckforeignkeys'] = 'Ova funkcionalnost će potražiti potencijalne prekršaje stranih ključeva definiranih u install.xml (Moodle trenutno ne stvara ograničenja aktuelnih stranih ključeva u bazi podataka, zbog čega u njoj mogu biti prisutni neispravni podaci.) <br /><br /> Više je nego preporučljivo da koristite najnoviju dostupnu verziju (tzv. + verziju) vašeg izdanja Moodlea (1.8, 1.9, 2.x ...) prije nego što izvršite pretraživanje potencijalnih prekršaja stranih ključeva.<br /><br /> Ova funkcionalnost ne izvodi bilo kakve akcije nad vašom bazom podataka (već samo čita iz nje), tako da se može sigurno izvršiti u svakom trenutku.';
$string['confirmcheckindexes'] = 'Ova funkcionalnost će potražiti indekse koji potencijalno nedostaju na vašem Moodle serveru, i automatski generirati (ali ne i izvršiti!) potrebne SQL naredbe kako bi sve ostalo ažurno.<br /><br /> Jednom, kada su naredbe generirane, možete ih kopirati i izvršiti sigurno u svom omiljenom SQL klijentu (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br /> Više je nego preporučljivo da koristite najnoviju dostupnu verziju (tzv. + verziju) vašeg izdanja Moodlea (1.8, 1.9, 2.x), prije nego što izvršite pretraživanje indeksa koji nedostaju.<br /><br /> Ova funkcionalnost ne izvodi bilo kakve akcije nad vašom bazom podataka (već samo čita iz nje), tako da se može sigurno izvršiti u svakom trenutku.';
$string['confirmcheckoraclesemantics'] = 'Ova funkcionalnost će potražiti <a href="http://tracker.moodle.org/browse/MDL-29322">Oracle varchar2 kolone koje koriste BYTE semantiku</a na vašem Moodle serveru, i automatski generirati (ali ne i izvršiti!) potrebne SQL naredbe kako bi sve kolone bile konvertovane za upotrebu CHAR semantike (koja je bolja za kompatibilnost između baza podataka, kao i za povećani sadržaj maks. dužine).<br /><br /> Jednom, kada su naredbe generirane, možete ih kopirati i izvršiti sigurno u svom omiljenom SQL klijentu (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br /> Više je nego preporučljivo da koristite najnoviju dostupnu verziju (tzv. + verziju) vašeg izdanja Moodlea (2.2, 2.3, 2.x), prije nego što izvršite pretraživanje BYTE semantike.<br /><br /> Ova funkcionalnost ne izvodi bilo kakve akcije nad vašom bazom podataka (već samo čita iz nje), tako da se može sigurno izvršiti u svakom trenutku.';
$string['confirmdeletefield'] = 'Da li ste potpuno sigurni da želite da obrišete polje?';
$string['confirmdeleteindex'] = 'Da li ste potpuno sigurni da želite da obrišete indeks?';
$string['confirmdeletekey'] = 'Da li ste potpuno sigurni da želite da obrišete ključ?';
$string['confirmdeletetable'] = 'Da li ste potpuno sigurni da želite da obrišete tabelu?';
$string['confirmdeletexmlfile'] = 'Da li ste potpuno sigurni da želite da obrišete datoteku?';
$string['confirmrevertchanges'] = 'Da li ste potpuno sigurni da želite da poništite promjene koje ste napravili?';
$string['create'] = 'Kreiraj';
$string['createtable'] = 'Kreiraj tabelu:';
$string['defaultincorrect'] = 'Netačna zadana vrijednost';
$string['delete'] = 'Obriši';
$string['delete_field'] = 'Obriši polje';
$string['delete_index'] = 'Obriši indeks';
$string['delete_key'] = 'Obriši ključ';
$string['delete_table'] = 'Obriši  tabelu';
$string['delete_xml_file'] = 'Obriši XML datoteku';
$string['doc'] = 'Dokumentacija';
$string['docindex'] = 'Indeks dokumentacijе:';
$string['documentationintro'] = 'Ova dokumentacija je automatski generirana iz definicije XMLDB baze podataka. Dostupna je samo na engleskom jeziku.';
$string['down'] = 'Dole';
$string['duplicate'] = 'Dupliraj';
$string['duplicatefieldname'] = 'Postoji još jedno polje sa tim nazivom';
$string['duplicatefieldsused'] = 'Koriste se duplikati polja';
$string['duplicateindexname'] = 'Dupliraj naziv indeksa';
$string['duplicatekeyname'] = 'Postoji još jedan ključ sa tim imenom';
$string['duplicatetablename'] = 'Postoji još jedna tabela sa tim imenom';
$string['edit'] = 'Uredi';
$string['edit_field'] = 'Uredi polje';
$string['edit_field_save'] = 'Sačuvaj polje';
$string['edit_index'] = 'Uredi indeks';
$string['edit_index_save'] = 'Sačuvaj indeks';
$string['edit_key'] = 'Uredi ključ';
$string['edit_key_save'] = 'Sačuvaj ključ';
$string['edit_table'] = 'Uredi tabelu';
$string['edit_table_save'] = 'Sačuvaj tabelu';
$string['edit_xml_file'] = 'Uredi XML datoteku';
$string['enumvaluesincorrect'] = 'Netačna vrednost za numeričko polje';
$string['expected'] = 'Očekivano';
$string['extensionrequired'] = 'Žao nam je - Za ovu akciju je neophodna PHP ekstenzija \'{$a}\'. Molimo vas da je instalirate ukoliko želite da koristite ovu funkciju.';
$string['field'] = 'Polje';
$string['fieldnameempty'] = 'Polje naziva je prazno';
$string['fields'] = 'Polja';
$string['fieldsnotintable'] = 'Polje ne postoji u tabeli';
$string['fieldsusedinindex'] = 'Ovo polje se koristi kao indeks';
$string['fieldsusedinkey'] = 'Ovo polje se koristi kao ključ.';
$string['filemodifiedoutfromeditor'] = 'Upozorenje: Datoteka je lokalno izmijenjena dok ste koristili XMLDB editor. Pokušaj da se datoteka sačuva će poništiti lokalne izmjene.';
$string['filenotwriteable'] = 'U datoteku se ne može ništa upisati';
$string['fkviolationdetails'] = 'Strani ključ {$a->keyname} u tabeli {$a->tablename} prekršen je od strane {$a->numviolations} od ukupno {$a->numrows} redova.';
$string['float2numbernote'] = 'Napomena: iako su polja "s pokretnim zarezom" 100% podržana od strane XMLDB, preporučuje se prelazak na polja "brojevi".';
$string['floatincorrectdecimals'] = 'Neispravan broj decimala u polju za brojeve sa pokretnim zarezom';
$string['floatincorrectlength'] = 'Neispravna dužina polja za brojeve sa pokretnim zarezom';
$string['generate_all_documentation'] = 'Cijelokupna dokumentacija';
$string['generate_documentation'] = 'Dokumentacija';
$string['gotolastused'] = 'Idi na posljednje korištenu datoteku';
$string['incorrectfieldname'] = 'Netačan naziv';
$string['incorrectindexname'] = 'Netačan naziv indeksa';
$string['incorrectkeyname'] = 'Neispravan naziv ključa';
$string['incorrecttablename'] = 'Netačan naziv tabele';
$string['index'] = 'Indeks';
$string['indexes'] = 'Indeksi';
$string['indexnameempty'] = 'Naziv indeksa nije unesen';
$string['integerincorrectlength'] = 'Netačna dužina za polje sa cijelobrojnim vrijednostima';
$string['key'] = 'Ključ';
$string['keynameempty'] = 'Naziv ključa mora da se unese';
$string['keys'] = 'Ključevi';
$string['listreservedwords'] = 'Spisak rezervisanih riječi<br/>(koji se koristi za održavanje <a href="http://docs.moodle.org/en/XMLDB_reserved_words" target="_blank">XMLDB_reserved_words</a>)';
$string['load'] = 'Učitaj';
$string['main_view'] = 'Glavni prikaz';
$string['masterprimaryuniqueordernomatch'] = 'Polja u vašem stranom ključu moraju biti navedena istim redoslijedom kao što su navedena u JEDINSTVENOM KLJUČU korištene tabele.';
$string['missing'] = 'Nedostaje';
$string['missingindexes'] = 'Pronađeni su indeksi koji nedostaju';
$string['mustselectonefield'] = 'Morate da izaberete jedno polje da biste vidjeli akcije koje se odnose na polja!';
$string['mustselectoneindex'] = 'Morate da izaberete jedan indeks da biste vidjeli akcije koje se odnose na indekse!';
$string['mustselectonekey'] = 'Morate da izaberete jedan ključ da biste vidjeli akcije koje se odnose na ključeve!';
$string['newfield'] = 'Novo polje';
$string['newindex'] = 'Novi indeks';
$string['newkey'] = 'Novi ključ';
$string['newtable'] = 'Nova tabela';
$string['newtablefrommysql'] = 'Nova tabela iz MySQL-a';
$string['new_table_from_mysql'] = 'Nova tabela iz MySQL-a';
$string['nofieldsspecified'] = 'Nema specificiranih polja';
$string['nomasterprimaryuniquefound'] = 'Kolona/e na koje se odnosi vaš strani ključ moraju biti uključene u primarni ili jedinstveni KLJUČ u referenciranoj tabeli. Imajte u vidu da nije dovoljno da kolona ima JEDINSTVENI INDEKS.';
$string['nomissingindexesfound'] = 'Nije pronađen nijedan indeks koji nedostaje - vaša baza ne zahtiijeva dodatne intervencije.';
$string['noreffieldsspecified'] = 'Nema specificiranih polja referenci';
$string['noreftablespecified'] = 'Specificirana tabela referenci nije pronađena';
$string['noviolatedforeignkeysfound'] = 'Nisu pronađeni prekršeni strani ključevi';
$string['nowrongdefaultsfound'] = 'Nisu pronađene nelogične zadana vrijednosti - vaša baza ne zahtijeva dodatne intervencije.';
$string['nowrongintsfound'] = 'Nisu pronađene pogrešne cijelobrojne vrijednosti - vaša baza ne zahtijeva dodatne intervencije.';
$string['nowrongoraclesemanticsfound'] = 'Nije pronađena nijedna Oracle kolona koja koristi BYTE semantiku - vaša baza ne zahtijeva dodatne intervencije.';
$string['numberincorrectdecimals'] = 'Netačan broj decimala za numeričko polje';
$string['numberincorrectlength'] = 'Netačna dužina numeričkog polja';
$string['pendingchanges'] = 'Napomena: Napravili ste promjene u ovoj datoteci. Promjene mogu biti sačuvane u bilo kojem trenutku.';
$string['pendingchangescannotbesaved'] = 'Postoje promjene u ovoj datoteci ali one ne mogu biti sačuvane! Molimo vas, provjerite da li direktorij i datoteka "install.xml" unutar njega imaju dozvole za upisivanje, od strane web servera.';
$string['pendingchangescannotbesavedreload'] = 'Postoje promjene u ovoj datoteci ali one ne mogu biti sačuvane! Molimo vas, provjerite da li direktorij i datoteka "install.xml" unutar njega imaju dozvole za upisivanje, od strane web servera. Zatim ponovo učitajte ovu stranicu, i trebalo bi da možete da sačuvate te promjene.';
$string['pluginname'] = 'XMLDB editor';
$string['primarykeyonlyallownotnullfields'] = 'Primarni ključevi ne mogu imati null vrednost';
$string['reserved'] = 'Rezervisano';
$string['reservedwords'] = 'Rezervisane riječi';
$string['revert'] = 'Poništi';
$string['revert_changes'] = 'Poništi promjene';
$string['save'] = 'Sačuvaj';
$string['searchresults'] = 'Rezultati pretrage';
$string['selectaction'] = 'Izaberite akciju:';
$string['selectdb'] = 'Izaberite bazu podataka:';
$string['selectfieldkeyindex'] = 'Izaberite polje/ključ/indeks:';
$string['selectonecommand'] = 'Molimo, izaberite jednu akciju sa spiska da biste vidjeli PHP kôd';
$string['selectonefieldkeyindex'] = 'Molimo izaberite jedno polje/ključ/indeks sa spiska da biste vidjeli PHP kôd';
$string['selecttable'] = 'Izaberite tabelu:';
$string['table'] = 'Tabela';
$string['tablenameempty'] = 'Naziv tabele se mora unijeti';
$string['tables'] = 'Tabele';
$string['unload'] = 'Isprazni';
$string['up'] = 'Gore';
$string['view'] = 'Pregled';
$string['viewedited'] = 'Pogledaj uređene';
$string['vieworiginal'] = 'Pogledaj originalne';
$string['viewphpcode'] = 'Pogledaj PHP kôd';
$string['view_reserved_words'] = 'Pogledaj rezervisane riječi';
$string['viewsqlcode'] = 'Pogledaj SQL kôd';
$string['view_structure_php'] = 'Pregled PHP-a strukture';
$string['view_structure_sql'] = 'Pregled SQL-a strukture';
$string['view_table_php'] = 'Pregled PHP-a tabele';
$string['view_table_sql'] = 'Pregled SQL-a tabele';
$string['viewxml'] = 'XML';
$string['violatedforeignkeys'] = 'Prekršeni strani ključevi';
$string['violatedforeignkeysfound'] = 'Pronađeni su prekršeni strani ključevi';
$string['violations'] = 'Prekršaji';
$string['wrong'] = 'Pogrešno';
$string['wrongdefaults'] = 'Pronađene pogrešne zadane vrijednosti';
$string['wrongints'] = 'Pronađene pogrešne cijelobrojne (integer) vrijednosti';
$string['wronglengthforenum'] = 'Netačna dužina numeričkog polja';
$string['wrongnumberofreffields'] = 'Pogrešan broj polja referenci';
$string['wrongoraclesemantics'] = 'Pronađena je pogrešna Oracle BYTE semantika';
$string['wrongreservedwords'] = 'Trenutno korištene rezervisane riječi<br />(imajte u vidu da nazivi tabela nisu važni ukoliko koristite $CFG->prefix)';
$string['yesmissingindexesfound'] = 'U vašoj bazi podataka pronađeni su indeksi koji nedostaju. Ovdje su detaljnije informacije o njima, kao i SQL naredbe koje treba izvršiti u vašem omiljenom SQL klijentu, kako biste kreirali sve indekse koji nedostaju (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br />Nakon što to uradite, više je nego preporučljivo da pokrenete ovaj alat ponovo kako biste provjerili da više nema indeksa koji nedostaju.';
$string['yeswrongdefaultsfound'] = 'U vašoj bazi podataka pronađene su nekonzistentne zadane vrijednosti. Ovdje su detaljnije informacije o njima, kao i SQL naredbe koje treba izvršiti u vašem omiljenom SQL klijentu, kako biste ih sve popravili (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br />Nakon što to uradite, više je nego preporučljivo da pokrenete ovaj alat ponovo kako biste provjerili da više nema nekonzistentnih zadanih vrijednosti.';
$string['yeswrongintsfound'] = 'U vašoj bazi podataka pronađene su pogrešne cijelobrojne vrijednosti. Ovdje su detaljnije informacije o njima, kao i SQL naredbe koje treba izvršiti u vašem omiljenom SQL klijentu, kako biste ih sve popravili (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br />Nakon što to uradite, više je nego preporučljivo da pokrenete ovaj alat ponovo kako biste provjerili da više nema pogrešnih cijelobrojnih vrijednosti.';
$string['yeswrongoraclesemanticsfound'] = 'U vašoj Oracle bazi podataka pronađene su neke kolone koje koriste BYTE semantiku. Ovdje su detaljnije informacije o njima, kao i potrebne SQL naredbe koje treba izvršiti u vašem omiljenom SQL klijentu, kako biste popravili ove kolone (ne zaboravite da prethodno napravite rezervnu kopiju podataka).<br /><br />Nakon što to uradite, više je nego preporučljivo da pokrenete ovaj alat ponovo kako biste provjerili da više nema kolona koje koriste pogrešnu semantiku.';
