<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   report_security
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_configrw_details'] = '<p>Preporuka je da nakon instalacije ovlaštenja nad datotekom config.php budu promijenjena tako da Web server ne može da je modifikuje. Imajte u vidu da ova mjera ne povećava značajno sigurnost servera, iako može da uspori ili ograniči mogućnost opće zloupotrebe.</p>';
$string['check_configrw_name'] = 'Upisuje config.php datoteka';
$string['check_configrw_ok'] = 'PHP skripe ne mogu da izmijene config.php datoteku.';
$string['check_configrw_warning'] = 'PHP skripe mogu da izmijene config.php.';
$string['check_cookiesecure_details'] = '<p>Ukoliko je omogućena https komunikacija preporučuje se, takođe, da omogućite sigurnosne cookies. Trebalo bi, takođe, da dodate permanentnu redirekciju sa http na https.</p>';
$string['check_cookiesecure_error'] = 'Molimo da omogućite sigurnosne cookies';
$string['check_cookiesecure_name'] = 'Sigurnosni cookies';
$string['check_cookiesecure_ok'] = 'Sigurnosni cookies omogućeni';
$string['check_defaultuserrole_details'] = '<p>Svim korisnicima koji su prijavljeni na sistem daje se mogućnost koju ima zadanu korisnička uloga. Molimo Vas, provjerite da za tu ulogu nisu dozvoljene opasne mogućnosti.</p> <p>Jedini podržani tip nasljeđivanja za zadanu korisničku ulogu je<em>Provjereni korisnik</em>. Mogućnost za pregled kursa ne smije biti omogućena.</p>';
$string['check_defaultuserrole_error'] = 'Zadana uloga korisnika "{$a}" je pogrešno definirana!';
$string['check_defaultuserrole_name'] = 'Zadana uloga za sve korisnike';
$string['check_defaultuserrole_notset'] = 'Zadana uloga nije podešena.';
$string['check_defaultuserrole_ok'] = 'Definicija zadane uloge za sve korisnike je uredu.';
$string['check_displayerrors_details'] = '<p>Uključivanje PHP podešavanja <code>display_errors</code> se ne preporučuje na sajtovima sa aktivnim kursevima zato što poruke o greškama mogu otkriti osjetljive informacije o vašem serveru.</p>';
$string['check_displayerrors_error'] = 'PHP podešavanje za prikazivanje grešaka je uključeno. Preporučuje se da ga isključite.';
$string['check_displayerrors_name'] = 'Prikaz PHP grešaka';
$string['check_displayerrors_ok'] = 'Prikaz PHP grešaka je onemogućen.';
$string['check_emailchangeconfirmation_details'] = '<p>Preporučuje se da potvrda e-mail adrese bude neophodna kada korisnici mijenjaju e-mail adrese u svojim profilima. Ako je ova opcija isključena, spameri mogu pokušati da iskoriste server za slanje neželjene poruke.</p> <p>Polje za e-mail adresu, takođe, može biti zaključano od strane dodataka za provjeru identiteta. Ova mogućnost se ovdje ne razmatra.</p>';
$string['check_emailchangeconfirmation_error'] = 'Korisnici mogu da unesu bilo koju e-mail adresu';
$string['check_emailchangeconfirmation_info'] = 'Korisnici mogu mogu da unesu samo e-mail adrese dozvoljenih domena.';
$string['check_emailchangeconfirmation_name'] = 'Potvrda promjene e-mail adrese';
$string['check_emailchangeconfirmation_ok'] = 'Potvrda promjene e-mail adrese u korisničkom profilu';
$string['check_embed_details'] = 'Neograničeno umetanje objekata je veoma opasno - bilo koji registrovani korisnik može da pokrene XSS napad protiv drugih korisnika. Ovo podešavanje treba onemogućiti na serverima sa aktivnim kursevima.</p>';
$string['check_embed_error'] = 'Neograničeno umetanje objekata je omogućeno - to je veoma opasno za većinu servera.';
$string['check_embed_name'] = 'Dozvoli EMBED i OBJECT';
$string['check_embed_ok'] = 'Neograničeno umetanje objekata nije dozvoljeno.';
$string['check_frontpagerole_details'] = '<p>Zadana uloga naslovne stranice je data svim registrovanim korisnicima za aktivnosti na naslovnoj stranici. Molimo vas da provjerite da li su za ovu ulogu dozvoljene rizične mogućnosti.</p> <p>Preporučljivo je da se za ovu namjenu kreira posebna uloga, bez upotrebe tipa nasljeđivanja uloge</p>';
$string['check_frontpagerole_error'] = 'Otkrivena je pogrešno definirana uloga naslovne stranice "{$a}"!';
$string['check_frontpagerole_name'] = 'Uloga na naslovnoj stranici';
$string['check_frontpagerole_notset'] = 'Uloga na naslovnoj stranici nije podešena';
$string['check_frontpagerole_ok'] = 'Definicija uloge naslovne stranice je uredu.';
$string['check_globals_details'] = '<p>Register globals se smatra jako nesigurnim PHP podešavanjem.</p>
<p><code>register_globals=off</code> mora biti postavljeno u PHP konfiguracionoj datoteci. Ovo podešavanje možete kontrolisati tako što ćete urediti Vaš <code>php.ini</code>, Apache/IIS konfiguraciju ili <code>.htaccess</code> datoteku.</p>';
$string['check_globals_error'] = 'Register globals MORA biti isključen. Molimo da odmah izmjenite PHP podešavanja!';
$string['check_globals_name'] = 'Register globals';
$string['check_globals_ok'] = 'Register globals je isključen.';
$string['check_google_details'] = '<p>Podešavanje Otvoreno za Google pretraživač dopušta pretraživačkim mašinama da pristupe kursevima kao gosti. Ne postoji način da se ovo podešavanje uključi ukoliko prijavljivanje u ulozi gosta nije dozvoljeno.</p>';
$string['check_google_error'] = 'Pristup pretraživačima je dozvoljen ali je pristup gostima onemogućen.';
$string['check_google_info'] = 'Pretraživači mogu ući kao gosti';
$string['check_google_name'] = 'Otvoreno za Google pretraživač';
$string['check_google_ok'] = 'Pristup pretraživačima nije omogućen';
$string['check_guestrole_details'] = '<p>Uloga Gost se koristi za goste, korisnike koji nisu prijavljeni na sistem kao i za privremeni pristup kursu. Molimo da provjerite da nisu dozvoljene rizične mogućnosti za ovu ulogu.</p> <p>Jedini podržani nasljeđeni tip za ulogu gosta je <em>Gost</em>.</p>';
$string['check_guestrole_error'] = 'Uloga gosta "{$a}" je pogrešno definirana';
$string['check_guestrole_name'] = 'Uloga gosta';
$string['check_guestrole_notset'] = 'Uloga gosta nije postavljena';
$string['check_guestrole_ok'] = 'Definicija za ulogu gosta je uredu.';
$string['check_mediafilterswf_details'] = '<p>Automatsko umetanje swf datoteka je veoma opasno - bilo koji registrovani korisnik može da pokrene XSS napad protiv drugih korisnika. Molimo Vas da onemogućite ovu opciju na serverima sa aktivnim kursevima.</p>';
$string['check_mediafilterswf_error'] = 'Flash media filter je omogućen - ovo je vrlo opasno za većinu servera.';
$string['check_mediafilterswf_name'] = '.swf media filter je omogućen';
$string['check_mediafilterswf_ok'] = 'Flash media filter nije omogućen';
$string['check_noauth_details'] = '<p>Dodatak <em>Bez provjere identiteta</em> nije namijenjen sajtovima sa aktivnim kursevima. Molimo Vas da onemogućite ovaj dodatak osim ako ovo nije razvojni sajt koji služi za testiranje.</p>';
$string['check_noauth_error'] = 'Dodatak \'Bez provjere identiteta\' ne može biti korišten ni na sajtovima sa aktivnim kursevima.';
$string['check_noauth_name'] = 'Bez provjere identiteta';
$string['check_noauth_ok'] = 'Dodatak \'Bez provjere identiteta\' je onemogućen';
$string['check_openprofiles_details'] = '<p>Otvorene korisničke profile mogu da zloupotrebe spameri. Preporučuje se da bude uključena opcija <code>Obavezno prijavljivanje korisnika za pristup stranici sa profilom</code> ili <code>Obavezno prijavljivanje korisnika na sistem</code>.</p>';
$string['check_openprofiles_error'] = 'Svako može da vidi korisničke profile bez prijavljivanja na sistem';
$string['check_openprofiles_name'] = 'Otvori korisničke profile';
$string['check_openprofiles_ok'] = 'Za gledanje korisničkih profila neophodna je prethodna prijava na sistem.';
$string['check_passwordpolicy_details'] = '<p>Preporuka je da pravilnik o lozinkama bude podešen jer je pogađanje lozinki vrlo često najlakši način za sticanje neovlaštenog pristupa. Nemojte postavljati previše stroga pravila, zato što to za posljedicu može imati da korisnici ne budu u stanju da zapamte svoje lozinke, pa će ih ili zaboravljati ili zapisivati.</p>';
$string['check_passwordpolicy_error'] = 'Pravilnik o lozinkama nije podešen.';
$string['check_passwordpolicy_name'] = 'Pravilnik o lozinkama';
$string['check_passwordpolicy_ok'] = 'Pravilnik o lozinkama je omogućen';
$string['check_riskadmin_detailsok'] = '<p>Molimo Vas da potvrdite sljedeći spisak administratora sistema:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Molimo Vas da potvrdite sljedeći spisak administratora sistema:</p>{$a->admins} <p>Preporučuje da se da ulogu administratora dodjeljujete samo u kontekstu sistema. Sljedeći korisnici imaju dodijeljene administratorske uloge koje nisu podržane:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Administratori';
$string['check_riskadmin_ok'] = 'Pronađen/o je {$a} server administrator/a.';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) pregledaj dodijeljene uloge</a>';
$string['check_riskadmin_warning'] = 'Pronađeno je {$a->admincount} administratora servera i {$a->unsupcount} dodijeljenih administratorskih uloga koje nisu podržane.';
$string['check_riskbackup_detailsok'] = 'Nema uloge koja eksplicitno dozvoljava kreiranje rezervne kopije korisničkih podataka. Međutim imajte na umu da će administratori, koji imaju sposobnost "sve dozvoljeno" vjerovatno i dalje moći ovo da urade.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Ove aktivne izmjene ovlaštenja daju korisnicima mogućnost da uključe korisničke podatke u rezervne kopije. Molimo, provjerite da li je ovo ovlaštenje neophodno.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Sljedeće sistemske uloge dopuštaju korisnicima da uključe korisničke podatke u rezervne kopije. Molimo, provjerite da li je ovo ovlaštenje neophodno.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Zbog gore navedenih uloga ili lokalnih izmjena ovlaštenja, sljedeći korisnički nalozi trenutno imaju ovlaštenje da kreiraju rezervne kopije podataka koje sadrže privatne podatke bilo kojeg korisnika upisanog na kurs. Provjerite da li su ti korisnici (a) pouzdani i (b) zaštićeni jakim lozinkama:</p> {$a}';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} u {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Rezervna kopija korisničkih podataka';
$string['check_riskbackup_ok'] = 'Nema uloge koja eksplicitno dozvoljava kreiranje rezervne kopije korisničkih podataka';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) u {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Pronađeno je {$a->rolecount} uloga/e, {$a->overridecount} izmjena ovlaštenja i {$a->usercount} korisnika koji imaju mogućnost da kreiraju rezervne kopije korisničkih podataka.';
$string['check_riskxss_details'] = '<p>RISK_XSS označava sve opasne sposobnosti koje mogu da koriste samo pouzdani korisnici.</p> <p>Molimo, potvrdite sljedeći spisak korisnika na ovom serveru i provjerite da li imate potpuno povjerenje u njih:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS pouzdani korisnici';
$string['check_riskxss_warning'] = 'RISK_XSS - pronađeno je {$a} korisnika koji moraju da budu pouzdani.';
$string['check_unsecuredataroot_details'] = '<p>Direktorij dataroot ne smije biti dostupan preko Weba. Najbolji način da budete sigurni da direktorij nije dostupan je da koristite onaj koji je izvan javnog Web direktorija.</p> <p>Ako premjestite direktorij, morate da ažurirate <code>$CFG->dataroot</code> podešavanje u <code>config.php</code> datoteci.</p>';
$string['check_unsecuredataroot_error'] = 'Vaš direktorij podataka <code>{$a}</code> je na pogrešnoj lokaciji i dostupan je preko Weba!';
$string['check_unsecuredataroot_name'] = 'Nesiguran direktorij podataka';
$string['check_unsecuredataroot_ok'] = 'Direktorij podataka ne smije biti dostupan preko Weba';
$string['check_unsecuredataroot_warning'] = 'Vaš dataroot direktorij <code>{$a}</code> je na pogrešnom mjestu i može mu se pristupiti putem Weba!';
$string['configuration'] = 'Konfiguracija';
$string['description'] = 'Opis';
$string['details'] = 'Detalji';
$string['issue'] = 'Pregled sigurnosti';
$string['pluginname'] = 'Pregled sigurnosti sistema';
$string['security:view'] = 'Pogledaj izvještaj o sigurnosti';
$string['status'] = 'Status';
$string['statuscritical'] = 'Kritično';
$string['statusinfo'] = 'Informacija';
$string['statusok'] = 'Uredu';
$string['statusserious'] = 'Ozbiljno';
$string['statuswarning'] = 'Upozorenje';
$string['timewarning'] = 'Obrada podataka može potrajati, molimo Vas da budete strpljivi';
