<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Možete pregledati ovaj kviz, ali ako je ovo stvarni pokušaj riješavanja, bićete blokirani jer:';
$string['action'] = 'Akcija';
$string['adaptive'] = 'Adaptivni režim';
$string['adaptive_help'] = 'Ako je omogućen adaptivni režim, onda je studentu dozvoljeno da unutar istog pokušaja riješavanja kviza više puta odgovori na pitanje. Na primjer, ako je odgovor označen kao netačan, studentu će biti dozvoljeno da odmah ponovo odgovori. Međutim, zavisno od podešavanja "Primjeni kaznene poene", za svaki pogrešan odgovor obično će biti oduzet odgovarajući broj kaznenih poena.';
$string['addaquestion'] = 'Dodaj pitanje...';
$string['addarandomquestion'] = 'Dodaj nasumično pitanje';
$string['addarandomquestion_help'] = 'Kada se dodaju nasumična pitanja, to rezultira time da se u kviz dodaju, iz kategorije, nasumično odabrana pitanja. Ovo znači da će svaki student vjerovatno dobiti različit set pitanja, a kada kviz dozvoljava ponovne pokušaje onda je vjerovatno da će svaki pokušaj sadržati novi set pitanja.';
$string['adddescriptionlabel'] = 'Dodaj opis/natpis';
$string['addingquestion'] = 'Dodavanje pitanja';
$string['addingquestions'] = 'Na ovom dijelu stranice uređujete svoju bazu pitanja. Pitanja su sačuvana po kategorijama kako bi se što lakše organizovala, i mogu biti upotrebljena u bilo kojem kvizu unutar Vašeg kursa ili nekog drugog kursa ako odaberete opciju \'objavljivanja\' pitanja. <br /><br /> Nakon što odaberete određenu kategoriju pitanja, možete kreirati nova ili uređivati već postojeća pitanja. Možete označiti bilo koje od tih pitanja i dodati ga (ih) u Vaš kviz koji se nalazi s lijeve strane ekrana.';
$string['addmoreoverallfeedbacks'] = 'Dodaj {no} još polja za povratne informacije';
$string['addnewgroupoverride'] = 'Dodaj promjenu pravila za grupu';
$string['addnewpagesafterselected'] = 'Dodaj nove stranice poslije odabranih pitanja';
$string['addnewquestionsqbank'] = 'Dodaj pitanja u kategoriju {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj promjenu pravila za korisnika';
$string['addpagehere'] = 'Dodaj stranicu ovdje';
$string['addquestion'] = 'Dodaj pitanje';
$string['addquestions'] = 'Dodaj pitanja';
$string['addquestionstoquiz'] = 'Dodaj pitanja u tekući kviz';
$string['addrandom'] = 'Dodaj {$a} slučajnih pitanja';
$string['addrandom1'] = '<< Dodaj';
$string['addrandom2'] = 'slučajna pitanja';
$string['addrandomfromcategory'] = 'Dodaj nasumično odabrana pitanja iz kategorije';
$string['addrandomquestion'] = 'Dodaj nasumično odabrana pitanja';
$string['addrandomquestiontoquiz'] = 'Dodaj nasumično odabrana pitanja u kviz {$a}';
$string['addselectedtoquiz'] = 'Dodaj odabrano u kviz';
$string['addtoquiz'] = 'Dodaj u kviz';
$string['affectedstudents'] = 'Uticalo je na {$a}';
$string['aftereachquestion'] = 'Nakon dodavanja svakog pitanja';
$string['afternquestions'] = 'Nakon dodavanja {$a} pitanja';
$string['age'] = 'starost';
$string['allattempts'] = 'Svi pokušaji';
$string['allinone'] = 'Neograničeno';
$string['allowreview'] = 'Dozvoli pregled';
$string['alreadysubmitted'] = 'Vjerovatno ste već predali ovaj pokušaj.';
$string['alternativeunits'] = 'Alternativne mjerne jedinice';
$string['alwaysavailable'] = 'Uvijek dostupno';
$string['analysisoptions'] = 'Opcije analize';
$string['analysistitle'] = 'Tabela analize pitanja';
$string['answer'] = 'Odgovor';
$string['answered'] = 'Odgovoreno';
$string['answerhowmany'] = 'Jedan ili više tačnih odgovora?';
$string['answers'] = 'Odgovori';
$string['answersingleno'] = 'Dozvoljeno je više tačnih odgovora';
$string['answersingleyes'] = 'Samo jedan odgovor je tačan';
$string['answertoolong'] = 'Odgovor je predugačak nakon linije {$a} (maks. 255 znakova)';
$string['aon'] = 'AON format';
$string['areyousureremoveselected'] = 'Da li ste sigurni da želite da obrišete sva pitanja';
$string['asshownoneditscreen'] = 'Kao što je prikazano na stranici za uređivanje';
$string['attempt'] = 'Pokušaj broj {$a}';
$string['attemptalreadyclosed'] = 'Ovaj pokušaj je već završen.';
$string['attemptclosed'] = 'Pokušaj još uvijek nije zatvoren';
$string['attemptduration'] = 'Utrošeno vrijeme';
$string['attemptedon'] = 'Datum predaje kviza';
$string['attempterror'] = 'Trenutno vam nije dozvoljeno da pokušate ovaj kviz zbog {$a}';
$string['attemptfirst'] = 'Prvi pokušaj';
$string['attemptincomplete'] = 'Ovaj pokušaj (korisnika: {$a}) još nije završen.';
$string['attemptlast'] = 'Posljednji pokušaj';
$string['attemptnumber'] = 'Pokušaj';
$string['attemptquiznow'] = 'Započni kviz';
$string['attempts'] = 'Pokušaji';
$string['attemptsallowed'] = 'Dozvoljen broj pokušaja';
$string['attemptsdeleted'] = 'Broj izbrisanih pokušaja';
$string['attemptselection'] = 'Izaberite koje pokušaje treba analizirati po korisniku:';
$string['attemptsexist'] = 'Kviz je već u upotrebi, ne možete više dodavati ili brisati pitanja.';
$string['attemptsnum'] = 'Pokušaji: {$a}';
$string['attemptsnumthisgroup'] = 'Pokušaji: {$a->total} ({$a->group} iz ove grupe)';
$string['attemptsnumyourgroups'] = 'Pokušaji: {$a->total} ({$a->group} iz vaše grupe)';
$string['attemptsonly'] = 'Prikaži samo studente sa pokušajima';
$string['attemptstate'] = 'Stanje';
$string['attemptstillinprogress'] = 'Pokušaj je još u toku';
$string['attemptsunlimited'] = 'Neograničen broj pokušaja';
$string['back'] = 'Nazad na pregled pitanja';
$string['backtocourse'] = 'Nazad na kurs';
$string['backtoquestionlist'] = 'Nazad na spisak pitanja';
$string['backtoquiz'] = 'Nazad na uređivanje kviza';
$string['basicideasofquiz'] = 'Osnovne ideje pravljenja kviza';
$string['bestgrade'] = 'Najviša ocjena';
$string['bothattempts'] = 'Prikaži studente sa i bez pokušaja';
$string['browsersecurity'] = 'Sigurnost prozora Web pretraživača';
$string['browsersecurity_help'] = 'Ako je izabrano pop-up prozor preko cijelog ekrana sa djelimično uključenim JavaScript opcijama za sigurnost", * kviz će se pokrenuti samo ako student ima Web pretraživač sa uključenom podrškom za JavaScript * kviz će se pojaviti u pop-up prozoru preko cijelog ekrana, koji pokriva sve ostale prozore i koji nema dugmad za navigaviju * studentima će, koliko je god to moguće, biti onemogućeno da koriste komande poput "kopiraj" i "nalijepi"';
$string['calculated'] = 'Računsko';
$string['calculatedquestion'] = 'Računsko pitanje nije podržano u liniji {$a}. Pitanje će biti ignorisano.';
$string['cannotcreatepath'] = 'Ne može se kreirati putanja ({$a})';
$string['cannoteditafterattempts'] = 'Ne možete da dodate ili uklonite pitanja zbog toga što već ima pokušaja riješavanja kviza. ({$a})';
$string['cannotfindprevattempt'] = 'Nije moguće pronaći prethodni pokušaj';
$string['cannotfindquestionregard'] = 'Nije bilo moguće dobiti pitanja za ponovno ocjenjivanje';
$string['cannotinsert'] = 'Ne može se umetnuti pitanje';
$string['cannotinsertrandomquestion'] = 'Nije bilo moguće ubaciti novo nasumično odabrano pitanje';
$string['cannotloadquestion'] = 'Nije bilo moguće učitati opcije pitanja';
$string['cannotloadtypeinfo'] = 'Nije moguće učitati informacije vezane za tip pitanja';
$string['cannotopen'] = 'Ne može se otvoriti prenesena datoteka ({$a})';
$string['cannotrestore'] = 'Nije bilo moguće vratiti podatke za sesije pitanja';
$string['cannotreviewopen'] = 'Ne možete da pregledate ovaj pokušaj, još uvijek je otvoren';
$string['cannotsavelayout'] = 'Nije bilo moguće sačuvati';
$string['cannotsavenumberofquestion'] = 'Nije bilo moguće sačuvati broj pitanja po jednoj stranici';
$string['cannotsavequestion'] = 'Ne može se sačuvati spisak pitanja';
$string['cannotsetgrade'] = 'Nije bilo moguće postaviti novu maksimalnu ocjenu za kviz';
$string['cannotsetsumgrades'] = 'Pokušaj da se podesi suma ocjena nije uspio';
$string['cannotstartgradesmismatch'] = 'Nije moguće započeti pokušaj riješavanja ovog kviza. Ocjena kviza je podešena na {$a->grade}, ali nijedno od pitanja u kvizu nema podešenu ocjenu. Ovo može biti popravljeno na stranici \'Uredi kviz\'.';
$string['cannotstartmissingquestion'] = 'Ne možete da započnete rješavanje ovog kviza. U kviz je uključeno pitanje koje ne postoji.';
$string['cannotstartnoquestions'] = 'Nije moguće započeti pokušaj rješavanja ovog kviza. Kviz još uvijek nije podešen. Nijedno pitanje nije dodano.';
$string['cannotwrite'] = 'Ne može se upisivati u datoteku za prenos ({$a})';
$string['caseno'] = 'Ne treba voditi računa o malim i velikim slovima';
$string['casesensitive'] = 'Vođenje računa o malim i velikim slovima';
$string['caseyes'] = 'Da, moraju se poklapati čak i mala i velika slova';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Kategorija \'{$a}\' je dodana';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je obrisana';
$string['categorynoedit'] = 'Nemate ovlaštenja za mjenjanje kategorije \'{$a}\'.';
$string['categoryupdated'] = 'Kategorija je uspješno izmjenjena';
$string['close'] = 'Zatvori prozor';
$string['closebeforeopen'] = 'Nije moguće ažurirati kviz. Odredili ste datum zatvaranja prije datuma otvaranja.';
$string['closed'] = 'Zatvoreno';
$string['closepreview'] = 'Zatvori pregled';
$string['closereview'] = 'Zatvori pregled';
$string['comment'] = 'Komentar';
$string['commentorgrade'] = 'Komentarajte ili promijenite ocjenu';
$string['comments'] = 'Komentari';
$string['completedon'] = 'Završeno dana';
$string['configadaptive'] = 'Ukoliko izaberete "Da" na ovu opciju onda će studentu biti dozvoljeno da više puta odgovori na pitanja čak u okviru istog pokušaja rješavanja kviza.';
$string['configattemptsallowed'] = 'Ograničenje u broju pokušaja koji su studentima dozvoljeni na kvizu.';
$string['configdecimaldigits'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocjene.';
$string['configdecimalplaces'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocjene za kviz.';
$string['configdecimalplacesquestion'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocjene za pojedinačna pitanja.';
$string['configdelay1'] = 'Ukoliko podesite vremenski razmak, onda će student nakon prvog pokušaja morati toliko vremena da sačeka prije nego što bude mogao ponovo da pokuša da uradi kviz.';
$string['configdelay1st2nd'] = 'Ukoliko ovdje podesite vremenski razmak, studenti ne mogu da drugi put urade kviz prije nego što ne protekne toliko vremena od njihovog prvog pokušaja.';
$string['configdelay2'] = 'Ukoliko ovdje podesite vremenski razmak, onda student mora da sačeka toliko vremena da prođe prije nego što započne svoj treći (i svaki naredni) pokušaj rješavanja kviza.';
$string['configdelaylater'] = 'Ukoliko ovdje podesite vremenski razmak, onda student ne može da započne treći, četvrti,... pokušaj prije nego toliko vremena ne prođe od kraja prethodnog pokušaja rješavanja kviza.';
$string['configeachattemptbuildsonthelast'] = 'Ukoliko su dozvoljeni višestruki pokušaji onda svaki novi pokušaj sadrži rezultate prethodnog pokušaja.';
$string['configgrademethod'] = 'Kada su višestruki pokušaji dozvoljeni koji metod treba koristiti za izračunavanje studentove završne ocjene za kviz.';
$string['configintro'] = 'Vrijednosti koje ste ovdje podesili definišu zadanu vrijednosti koje se koriste u obrascu za podešavanje kada kreirate novi kviz. Možete, također, da konfigurišete koja podešavanja kviza se smatraju naprednim.';
$string['configmaximumgrade'] = 'Zadana ocjena na osnovu koje će se gradirati ocjene na kvizu.';
$string['confignavmethod'] = 'Kod slobodne navigacije, na pitanja se može odgovarati bilo kojim redoslijedom, Kod sekvencijalne navigacije na pitanja se mora odgovarati strogo utvrđenim redoslijedom.';
$string['confignewpageevery'] = 'Kod dodavanja pitanja u kviz, prekid stranice će automatski biti ubačen prema podešavanju koje ovdje odaberete.';
$string['configpenaltyscheme'] = 'Kazneni poeni koji se oduzimaju za svaki pogrešan odgovor u adaptivnom modu.';
$string['configpopup'] = 'Prinudno otvaranje kviza u pop-up prozoru, uz korištenje JavaScript opcija, koje će pokušati da ograniče korištenje komandi "kopiraj", "zalijepi" itd., u toku rješavanja kviza.';
$string['configrequirepassword'] = 'Studenti moraju da unesu ovu lozinku prije nego što pokušaju da riješe kviz.';
$string['configrequiresubnet'] = 'Studenti mogu da pokušaju da riješe kviz samo sa ovih računara.';
$string['configreviewoptions'] = 'Ove opcije kontrolišu koje informacije će korisnici moći da vide kada budu pregledali pokušaj ili kada budu gledali izvještaje o kvizu.';
$string['configshowblocks'] = 'Prikaži blokove tokom riješavanja kviza';
$string['configshowuserpicture'] = 'Prikaži sliku korisnika na ekranu tokom pokušaja rješavanja kviza.';
$string['configshufflequestions'] = 'Ukoliko omogućite ovu opciju, onda će redoslijed pitanja u kvizu biti nasumično izmiješan svaki put kada student pokuša da riješi kviz.';
$string['configshufflewithin'] = 'Ako omogućite ovu opciju, onda će dijelovi koji sačinjavaju pojedinačno pitanje biti nasumično izmiješani svaki put kada student započne da rješava ovaj kviz. Ponuđena opcija je također uključena u podešavanjima pitanja.';
$string['configtimelimit'] = 'Zadano vremensko ograničenje za kvizove u minutima. 0 znači da nema vremenskog ograničenja.';
$string['configtimelimitsec'] = 'Zadano vremensko ograničenje za kvizove u sekundama. 0 znači da nema vremenskog ograničenja.';
$string['configurerandomquestion'] = 'Konfiguriši pitanje';
$string['confirmclose'] = 'Kada predate kviz nećete više biti u mogućnosti da mjenjate svoje odgovore.';
$string['confirmserverdelete'] = 'Da li ste sigurni da želite da uklonite server <b>{$a}</b> sa spiska?';
$string['confirmstartattemptlimit'] = 'Broj dozvoljenih pokušaja: {$a}. Upravo se spremate da započnete novi pokušaj. Da li želite da nastavite?';
$string['confirmstartattempttimelimit'] = 'Kviz ima vremensko ograničenje, a moguće ga je raditi {$a} put(a). Svaki pristup kvizu se računa kao pokušaj njegovog rješavanja. Da li želite da nastavite?';
$string['confirmstarttimelimit'] = 'Kviz ima vremensko ograničenje. Da li ste sigurni da želite da počnete?';
$string['containercategorycreated'] = 'Ova kategorija je kreirana sa ciljem da se u nju smjeste sve originalne kategorije koje se pomjere na nivo sajta iz dole navedenih razloga.';
$string['continueattemptquiz'] = 'Nastavite posljednji pokušaj';
$string['continuepreview'] = 'Nastavi posljednji pregled';
$string['copyingfrom'] = 'Kreiranje kopije pitanja \'{$a}';
$string['copyingquestion'] = 'Kopiranje pitanja';
$string['correct'] = 'Tačno';
$string['correctanswer'] = 'Tačan odgovor';
$string['correctanswerformula'] = 'Formula tačnih odgovora';
$string['correctansweris'] = 'Tačan odgovor: {$a}';
$string['correctanswerlength'] = 'Značajne cifre';
$string['correctanswers'] = 'Tačni odgovori';
$string['correctanswershows'] = 'Prikaz tačnih odgovora';
$string['corrresp'] = 'Tačan odgovor';
$string['countdown'] = 'Brojač';
$string['countdownfinished'] = 'Kviz se uskoro zatvara, vrijeme je da predate svoje odgovore.';
$string['countdowntenminutes'] = 'Kviz se zatvara za deset minuta.';
$string['coursetestmanager'] = 'Kviz Menadžer format';
$string['createcategoryandaddrandomquestion'] = 'Kreiraj kategoriju i dodaj nasumičnо odabranо pitanjе';
$string['createfirst'] = 'Morate prvo kreirati neka pitanja sa kratkim odgovorima.';
$string['createmultiple'] = 'Dodajte u kviz nekoliko slučajnih pitanja';
$string['createnewquestion'] = 'Kreiraj novo pitanje';
$string['createquestionandadd'] = 'Kreiraj novo pitanje i dodaj ga kvizu.';
$string['custom'] = 'Proizvoljan format';
$string['dataitemneed'] = 'Morate dodati bar jedan skup stavki podataka da biste dobili validno pitanje';
$string['datasetdefinitions'] = 'Ponovo upotrebljene definicije seta podataka za kategoriju {$a}';
$string['datasetnumber'] = 'Broj';
$string['daysavailable'] = 'Dostupni dani';
$string['decimaldigits'] = 'Broj decimala u ocjenama';
$string['decimalplaces'] = 'Decimalna mjesta u ocjenama';
$string['decimalplaces_help'] = 'Ovo podešavanje određuje broj cifara koji treba prikazati iza decimalne tačke kada se prikazuju rezultati ili ocjena. Ovo utiče samo na prikaz ocjena, ali ne i na ocjene sačuvane u bazi podataka, niti na interna izračunаvanja koja se izvode sa punom preciznošću.';
$string['decimalplacesquestion'] = 'Decimalna mjesta u ocjenama pitanja';
$string['decimalplacesquestion_help'] = 'Ovo podešavanje određuje broj cifara koji treba prikazati iza decimalne tačke kada se prikazuju ocjene za pojedinačna pitanja.';
$string['decimalpoints'] = 'Decimalna mjesta';
$string['default'] = 'Zadano';
$string['defaultgrade'] = 'Zadana ocjena pitanja';
$string['defaultinfo'] = 'Zadana kategorija za pitanja';
$string['delay1'] = 'Vremenski razmak između prvog i drugog pokušaja';
$string['delay1st2nd'] = 'Prinudni vremenski razmak između prvog i drugog pokušaja';
$string['delay1st2nd_help'] = '<p>Ukoliko podesite vremenski razmak, student mora nakon svog prvog pokušaja da sačeka da toliko vremena prođe prije nego što mu bude dozvoljeno da ponovo pokuša da riješi kviz.</p>';
$string['delay2'] = 'Vremenski razmak između svih ostalih pokušaja';
$string['delaylater'] = 'Prinudni vremenski razmak između naknadni pokušaja';
$string['delaylater_help'] = '<p>Ukoliko ovdje podesite vremenski razmak, student mora da sačeka da toliko vremena prođe prije nego što započne svoj treći i svaki naredni pokušaj rješavanja kviza.</p>';
$string['deleteattemptcheck'] = 'Da li ste sigurni da želite da obrišete ove pokušaje?';
$string['deleteselected'] = 'Obriši označeno';
$string['deletingquestionattempts'] = 'Obriši pokušaje pitanja';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogućeno';
$string['displayoptions'] = 'Opcije za prikaz';
$string['download'] = 'Kliknite za preuzimanje prenesene datoteke sa kategorijama';
$string['downloadextra'] = '(datoteka se čuva i među datotekama kursa u /backupdata/quiz direktoriju)';
$string['duplicateresponse'] = 'Ovo predano rješenje je ignorisano jer ste već ranije dali ekvivalentan odgovor.';
$string['eachattemptbuildsonthelast'] = 'Svaki pokušaj se nastavlja na prethodni';
$string['eachattemptbuildsonthelast_help'] = '<p>Ako je dozvoljeno više pokušaja rješavanja kviza i ovo podešavanje je postavljeno na <b>Da</b>, onda će svaki novi pokušaj sadržavati rezultate prethodnog. To dozvoljava da se rješavanje kviza završi u više pokušaja.</p> <p>Da bi se prikazao novi primjerak kviza pri svakom pokušaju, izaberite vrijednost <b>Ne</b> za ovo podešavanje.</p>';
$string['editcategories'] = 'Uređivanje kategorija';
$string['editcategory'] = 'Uređivanje kategorije';
$string['editcatquestions'] = 'Uređivanje pitanja u kategoriji';
$string['editingquestion'] = 'Uređivanje pitanja';
$string['editingquiz'] = 'Uređivanje kviza';
$string['editingquiz_help'] = 'Prilikom kreiranja kviza, osnovni pojmovi su: * Kviz, koji sadrži pitanja na jednoj ili više stranica * Baza pitanja, koja sadrži kopije svih pitanja organizovanih u kategorije * Nasumično odabrano pitanje - student dobija različita pitanja svaki put kada pokuša da rješava kviz, odnosno različiti studenti mogu da dobiju različita pitanja tj. kviz.';
$string['editingquizx'] = 'Uređivanje kviza: {$a}';
$string['editoverride'] = 'Uredi izmjene podešavanja';
$string['editqcats'] = 'Uređivanje kategorija pitanja';
$string['editquestions'] = 'Uređivanje pitanja';
$string['editquiz'] = 'Uredi kviz';
$string['editquizquestions'] = 'Uredi pitanja kviza';
$string['emailconfirmbody'] = 'Dragi/a {$a->username}, Hvala što ste poslali svoje odgovore na kviz \'{$a->quizname}\' na kursu \'{$a->coursename}\' u {$a->submissiontime}. Ova poruka je potvrda da smo primili vaše odgovore. Ovom kvizu možete da pristupite na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Hvala što se predali svoje odogovore za kviz \'{$a->quizname}';
$string['emailconfirmsubject'] = 'Potvrda o slanju kviza: {$a->quizname}';
$string['emailnotifybody'] = 'Poštovani/a {$a->username}, {$a->studentname} je završio/la kviz \'{$a->quizname}\' ({$a->quizurl}) na kursu \'{$a->coursename}\'. Ovaj pokušaj možete pregledati na {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} je završio/la kviz {$a->quizname}. Pogledajte na {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} je završio/la kviz {$a->quizname}';
$string['emailoverduebody'] = 'Poštovani/a {$a->username}, započeli ste rješavanje kviza \'{$a->quizname}\' na kursu \'{$a->coursename}\', ali ga niste poslali. Ako, još uvijek želite da pošaljete svoje odgovore, molimo vas da odete na {$a->attemptsummaryurl} i kliknete na dugme \'Predaj\'. Ovo morate da uradite prije {$a->attemptgraceend}, u suprotnom vaš pokušaj rješavanja kviza se neće računati.';
$string['emailoverduesmall'] = 'Niste predali svoj pokušaj rješavanja kviza {$a->quizname}. Molimo vas da odete na {$a->attemptsummaryurl} prije {$a->attemptgraceend}, ako još uvijek želite da predate svoje odgovore.';
$string['emailoverduesubject'] = 'Pokušaj rješavanja kviza {$a->quizname} kasni';
$string['empty'] = 'Prazno';
$string['enabled'] = 'Omogućeno';
$string['endtest'] = 'Završi pokušaj...';
$string['erroraccessingreport'] = 'Ne možete da pristupite ovom izvještaju';
$string['errorinquestion'] = 'Greška u pitanju';
$string['errormissingquestion'] = 'Greška: Sistem ne može da pronađe pitanje čiji je identifikator {$a}';
$string['errornotnumbers'] = 'Greška - odgovori moraju biti numerički';
$string['errorunexpectedevent'] = 'Neočekivani kod događaja {$a->event} pronađen za pitanje {$a->questionid} u pokušaju {$a->attemptid}.';
$string['essay'] = 'Esej';
$string['essayquestions'] = 'Pitanja';
$string['eventquizattemptabandoned'] = 'Pokušaj izrade kviza prekinut';
$string['eventquizattemptstarted'] = 'Pokušaj izrade kviza započet';
$string['eventquizattemptsubmitted'] = 'Izrada kviza predana';
$string['eventquizattempttimelimitexceeded'] = 'Vremensko ograničenje za izradu kviza je proteklo';
$string['everynquestions'] = 'Svaka/ih {$a} pitanja';
$string['everyquestion'] = 'Svako pitanje';
$string['everythingon'] = 'Sve na';
$string['export'] = 'Prenos';
$string['exportcategory'] = 'Prenesi kategoriju';
$string['exporterror'] = 'Došlo je do greške prilikom procesiranja prenosa';
$string['exportingquestions'] = 'Pitanja se prenose u datoteku';
$string['exportname'] = 'Naziv datoteke';
$string['exportquestions'] = 'Prenesi pitanja u datoteku';
$string['extraattemptrestrictions'] = 'Dodatna ograničenja prilikom pokušaja';
$string['false'] = 'Pogrešno';
$string['feedback'] = 'Povratne informacije';
$string['feedbackerrorboundaryformat'] = 'Ograničenja ocjenjivanja povratnih informacija moraju biti ili procentualne ili numeričke. Vrijednost koju ste unijeli ograničena sa {$a} nije podržana.';
$string['feedbackerrorboundaryoutofrange'] = 'Ograničenja ocjenjivanja povratnih informacija moraju biti između 0% i 100%. Vrijednost koju ste unijeli ograničena sa {$a} je van dozvoljenog opsega.';
$string['feedbackerrorjunkinboundary'] = 'Morate popuniti polja sa ograničenjima ocjenjivanja povratnih informacija, bez ostavljanja bilo kakvih praznina.';
$string['feedbackerrorjunkinfeedback'] = 'Morate popuniti polja povratnih informacija, bez ostavljanja bilo kakvih praznina.';
$string['feedbackerrororder'] = 'Granične vrijednosti ocjena za povratne informacija moraju biti poredane počevši od najviše. Vrijednost koju ste unijeli za granicu {$a} je izvan niza.';
$string['file'] = 'Datoteka';
$string['fileformat'] = 'Format datoteke';
$string['fillcorrect'] = 'Unesite tačan odgovor';
$string['filloutnumericalanswer'] = 'Osigurajte bar jedan mogući odgovor i odstupanje. Prvi odgovor koji se poklapa biće korišten za utvrđivanje ocjene i povratnih informacija. Ako postavite povratne informacije bez odgovora na kraju, one će biti prikazane studentima čiji se odgovori ne poklapaju ni sa jednim od ostalih odgovora.';
$string['filloutoneanswer'] = 'Morate ponuditi najmanje jedan mogući odgovor. Odgovori koji se ne popune neće se koristiti. \'*\' se može koristiti kao džoker znak koji zamjenjuje bilo koji niz karaktera. Prvi odgovor koji se poklopi sa datim koristiće se za određivanje rezultata i povratnih informacija.';
$string['filloutthreequestions'] = 'Morate ispuniti bar tri pitanja sa odgovarajućim rješenjima. Možete dodati još netačnih odgovora davanjem rješenja uz prazna pitanja. Stavke u kojima su i pitanje i odgovor prazni neće se uzimati u obzir.';
$string['fillouttwochoices'] = 'Morate ispuniti bar dva odgovora. Prazni odgovori se neće koristiti.';
$string['finishattemptdots'] = 'Završi pokušaj...';
$string['finishreview'] = 'Završi pregled';
$string['forceregeneration'] = 'Obavezno obnavljanje';
$string['formatnotfound'] = 'Nije pronađen format {$a} za unos/prenos';
$string['formatnotimplemented'] = 'Ovaj format nije ispravno implementiran, molimo podnesite izvještaj o grešci';
$string['formulaerror'] = 'Greška u formuli!';
$string['fractionsaddwrong'] = 'Pozitivne ocjene koje ste odabrali u zbiru ne daju 100%<br />Naime njihov zbir je {$a}%<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['fractionsnomax'] = 'Jedan od odgovora bi trebao nositi 100% ocjene, tako da je <br />moguće dobiti maksimalnu ocjenu za ovo pitanje.<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['fromfile'] = 'iz datoteke:';
$string['functiondisabledbysecuremode'] = 'Ova funkcionalnost je trenutno onemogućena';
$string['generalfeedback'] = 'Opće povratne informacije';
$string['generalfeedback_help'] = 'Opće povratne informacije predstavljaju tekst koji se prikazuje nakon davanja odgovora na pitanje. Za razliku od povratnih informacija za pojedinačno pitanje koje zavise od datog odgovora, opće povratne informacije su uvijek iste.';
$string['graceperiod'] = 'Dodatno vrijeme za predaju kviza.';
$string['graceperiod_desc'] = 'Ako je opcija \'Šta raditi kada vrijeme istekne\' podešeno na \'Dozvoli dodatno vrijeme za predaju kviza, ali ne i za promjenu odgovora\', ovo će biti zadano dodatno vrijeme (u sekundama) koje se dozvoljava za predaju.';
$string['graceperiod_help'] = 'Ako je opcija \'Šta raditi kada vrijeme istekne\' podešeno na \'Dozvoli dodatno vrijeme za predaju kviza, ali ne i za promjenu odgovora\', ovo će biti zadano dodatno vrijeme (u sekundama) koje se dozvoljava za predaju.';
$string['graceperiodmin'] = 'Dodatno vrijeme za konačnu predaju.';
$string['graceperiodmin_desc'] = 'Postoji potencijalni problem na samom kraju kviza. Sa jedne strane, želimo da studenti nastave da rade kviz sve do posljednje sekunde - uz pomoć timera koji automatski predaje kviz kada vrijeme istekne. Sa druge strane, server može biti preopterećen pa će mu biti potrebno neko vrijeme da obradi odgovore. Dakle, prihvatićemo odgovore nakon što rok za predaju istekne, unutar ovog dodatnog vremena (u sekundama), tako da studenti neće biti oštećeni zbog toga što je server spor. Međutim, studenti ovo mogu da zloupotrijebe tako što će u toku ovog dodatnog vremena odgovarati na pitanja. Morate da napravite kompromis na osnovu toga koliko imate povjerenja u performanse svog servera u toku rješavanja kviza.';
$string['graceperiodtoosmall'] = 'Dodatno vrijeme mora biti veće od {$a}.';
$string['grade'] = 'Ocjena';
$string['gradeall'] = 'Ocijeni sve';
$string['gradeaverage'] = 'Prosječna ocjena';
$string['gradeboundary'] = 'Ograničenje ocjene';
$string['gradeessays'] = 'Ocijeni eseje';
$string['gradehighest'] = 'Najviša ocjena';
$string['grademethod'] = 'Metod ocjenjivanja';
$string['grademethod_help'] = '<p>Kada je dozvoljen veći broj pokušaja rješavanja kviza, postoje različiti načini za izračunavanje studentove konačne ocjene.</p> <p><b>Najviša ocjena</b><p> <ul> <p>Konačna ocjena je najviša (najbolja) ocjena postignuta u bilo kojem pokušaju.</p> </ul> <p><b>Prosječna ocjena</b><p> <ul> <p>Konačna ocjena je prosječna ocjena (aritmetička sredina) svih pokušaja.</p> </ul> <p><b>Prva ocjena</b><p> <ul> <p>Konačna ocjena je ocjena dobijena prilikom prvog pokušaja rješavanja kviza (ostali pokušaji se ignorišu).</p> </ul> <p><b>Posljednja ocjena</b><p> <ul> <p>Konačna ocjena je ocjena dobijena prilikom posljednjeg pokušaja rješavanja kviza.</p> </ul>';
$string['gradesdeleted'] = 'Izbrisano ocjena kviza:';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Ocjena za ovaj odgovor je: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Sa prethodnim kaznenim bodovima ocjena je <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Ovim odgovorom ste zaradili {$a} kaznenih bodova.';
$string['gradingdetailszeropenalty'] = 'Niste zaradili kaznene bodove za ovaj odgovor';
$string['gradingmethod'] = 'Metod ocjenjivanja: {$a}';
$string['groupoverrides'] = 'Izmjene za grupe';
$string['groupsnone'] = 'Nema grupa na ovom kursu';
$string['guestsno'] = 'Žao nam je, gosti ne mogu ni da vide ni da riješavaju kvizove.';
$string['hidebreaks'] = 'Sakrij prekide stranica';
$string['hidereordertool'] = 'Sakrij alatku za reorganizaciju';
$string['history'] = 'Historijat odziva sistema:';
$string['howquestionsbehave_desc'] = 'Zadano podešavanje za to kako se pitanja ponašaju u kvizu.';
$string['imagedisplay'] = 'Slika za prikaz';
$string['import'] = 'Unos';
$string['importcategory'] = 'Kategorija unosa';
$string['importerror'] = 'Došlo je do greške prilikom procesiranja unosa';
$string['importfilearea'] = 'Unos iz datoteke koja je već među datotekama kursa';
$string['importfileupload'] = 'Unos iz novoučitane datoteke...';
$string['importfromthisfile'] = 'Unos iz ove datoteke';
$string['import_help'] = 'Ova funkcija Vam omogućava da pitanja unesete iz vanjskih tekstualnih datoteka. Ako Vaša datoteka sadrži tzv. non-ascii karaktere onda ona mora da koristi UTF-8 kodni raspored. Posebno budite oprezni sa datotekama koje su generirale Microsoft Office aplikacije, pošto one obično koriste specijalan kodni raspored koji neće biti ispravno obrađen. Formati za unos i prijenos prilagodljivi resursi. Drugi, opcioni, formati mogu se pronaći u bazi "Modules and Plugins" na sajtu moodle.org.';
$string['importingquestions'] = 'Unos {$a} pitanja iz datoteke';
$string['importmax10error'] = 'Postoji greška u pitanju. Ne može biti više od deset odgovora';
$string['importmaxerror'] = 'Postoji greška u pitanju. Ima previše odgovora.';
$string['importquestions'] = 'Unos pitanja iz datoteke';
$string['inactiveoverridehelp'] = '* Student nema ispravnu grupu ili ulogu da bi mogao da rješava ovaj kviz.';
$string['incorrect'] = 'Netačno';
$string['indivresp'] = 'Odgovori pojedinaca na svako pitanje';
$string['info'] = 'Informacije';
$string['infoshort'] = 'i';
$string['inprogress'] = 'U toku';
$string['introduction'] = 'Uvod';
$string['invalidattemptid'] = 'Takav ID pokušaj ne postoji';
$string['invalidcategory'] = 'Identifikator kategorije nije valjan';
$string['invalidnumericanswer'] = 'Jedan od odgovora koji ste unijeli nije ispravan broj.';
$string['invalidnumerictolerance'] = 'Jedna od tolerancija koji ste unijeli nije ispravan broj.';
$string['invalidoverrideid'] = 'Neispravan identifikator izmjene.';
$string['invalidquestionid'] = 'Neispravan ID pitanja.';
$string['invalidquizid'] = 'Neispravan identifikator kursa.';
$string['invalidsource'] = 'Izvor nije prihvaćen kao validan.';
$string['invalidsourcetype'] = 'Nije validan tip izvora';
$string['invalidstateid'] = 'Neispravan ID stanja';
$string['lastanswer'] = 'Vaš odgovor je bio';
$string['layout'] = 'Izgled (raspored pitanja)';
$string['layoutasshown'] = 'Izgled stranice kao što je prikazano.';
$string['layoutasshownwithpages'] = 'Izgled stranice kao što je prikazano. <small>(Nova stranica automatski na svakih  {$a} pitanja.)</small>';
$string['layoutshuffledandpaged'] = 'Pitanja su nasumično izmiješana sa {$a} pitanja po stranici.';
$string['layoutshuffledsinglepage'] = 'Pitanja nasumično izmiješana, sva prikazana na jednoj stranici.';
$string['link'] = 'Link';
$string['listitems'] = 'Lista stavki u kvizu.';
$string['literal'] = 'Znak';
$string['loadingquestionsfailed'] = 'Broj neuspjelih učitavanja pitanja: {$a}';
$string['makecopy'] = 'Sačuvaj kao novo pitanje';
$string['managetypes'] = 'Upravljanje tipovima pitanja i serverima';
$string['manualgrading'] = 'Ocjenjivanje';
$string['mark'] = 'Predajte';
$string['markall'] = 'Predajte stranicu';
$string['marks'] = 'Ocjene';
$string['marks_help'] = 'Numeričke ocjene za svako pitanje, kao i sveukupni rezultat pokušaja';
$string['match'] = 'Sparivanje';
$string['matchanswer'] = 'Sparivanje odgovora';
$string['matchanswerno'] = 'Sparivanje odgovora {$a}';
$string['max'] = 'Maksimalno';
$string['messageprovider:attempt_overdue'] = 'Upozorenje kada vaš pokušaj rješavanja kviza kasni.';
$string['messageprovider:confirmation'] = 'Potvrda o predaji Vaših pokušaja rješavanja kviza.';
$string['messageprovider:submission'] = 'Obavještenje o predanim kvizovima.';
$string['min'] = 'Minimalno';
$string['minutes'] = 'Minut(a)';
$string['missingcorrectanswer'] = 'Morate zadati tačan odgovor';
$string['missingitemtypename'] = 'Nedostaje naziv';
$string['missingquestion'] = 'Nedostaje naziv pitanja nakon linije {$a}';
$string['modulename'] = 'Kviz';
$string['modulename_help'] = 'Modul \'Kviz\' omogućava predavačima da dizajniraju kvizove koji se sastoje od različitih tipova pitanja, uključujući višestruki izbor, sparivanje, kratak odgovor, numerička pitanja itd. Predavač može da dozvoli da se kviz rješava više puta, sa izmiješanim redosljedom pitanja ili nasumično izabranim pitanjima iz baze, prilikom svakog pokušaja. Takođe, moguće je podesiti vremensko ograničenje za rješavanje kviza. Svaki pokušaj se automatski ocjenjuje, sa izuzetkom esejskog tipa pitanja, a ocjena se bilježi u knjigu ocjena. Predavač može da izabere da li će i kada studentima biti prikazni savjeti, povratne informacije i tačni odgovori. Kvizovi mogu da se koriste: * kao završni ispiti * kao mini kvizovi nakon što studenti imaju zadatak da pročitaju određeni tekst, ili na kraju neke teme (oblasti) * kao priprema za završni ispit, koristeći pitanja sa prethodnih ispita * za pružanje neposrednih povratnih informacija o postignućima * za samostalnu procjenu znanja.';
$string['modulenameplural'] = 'Kvizovi';
$string['moveselectedonpage'] = 'Premjesti izabrana pitanja na stranicu: {$a}';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswers'] = 'Odaberite bar jedan odgovor.';
$string['multiplier'] = 'Množitelj';
$string['mustbesubmittedby'] = 'Ovaj pokušaj mora biti predat do {$a}.';
$string['name'] = 'Naziv';
$string['navmethod'] = 'Metod navigacije';
$string['navmethod_free'] = 'Slobodna navigacija';
$string['navmethod_help'] = 'Kada je uključena sekvencijalna navigacija studenti moraju da odgovaraju na pitanja onim redosljedom kako su ona poredana u kvizu, i ne mogu da se vraćaju na prethodne ili preskaču stranice.';
$string['navmethod_seq'] = 'Sekvencijalna navigacija';
$string['navnojswarning'] = 'Upozorenje: ovi linkovi neće sačuvati vaše odgovore. Koristite dugme "Sljedeće" na dnu stranice.';
$string['neverallononepage'] = 'Nikad, sva pitanja na jednu stranicu';
$string['newattemptfail'] = 'Greška: Nije bilo moguće započeti novi pokušaj rješavanja kviza.';
$string['newpage'] = 'Nova stranica';
$string['newpageevery'] = 'Automatski pokreni novu stranicu.';
$string['newpage_help'] = '<p>Kod kvizova sa puno pitanja ima smisla podijeliti kviz na nekoliko stranica tako što će se ograničiti broj pitanja po jednoj stranici. Kada se kvizu dodaju pitanja, prekidi stranica biće automatski umetnuti shodno podešavanju koje ste ovdje izabrali. Ipak, također je moguće da kasnije, tokom uređivanja stranice, ručno premještate prekide stranica. </p>';
$string['noanswers'] = 'Nijedan odgovor nije odabran!';
$string['noattempts'] = 'Nije bilo pokušaja da se riješi ovaj kviz.';
$string['noattemptsfound'] = 'Nije pronađen nijedan pokušaj.';
$string['noattemptstoshow'] = 'Nema pokušaja za prikaz';
$string['nocategory'] = 'Pogrešna ili nespecificirana kategorija';
$string['noclose'] = 'Nema datuma zatvaranja kviza';
$string['nocommentsyet'] = 'Još nema komentara';
$string['noconnection'] = 'Trenutno nije uspostavljena veza sa Web servisom koji može da obradi ovo pitanje. Molimo kontaktirajte svog administratora';
$string['nodataset'] = 'ništa - nije džoker znak';
$string['nodatasubmitted'] = 'Nijedan podatak nije poslan.';
$string['noessayquestionsfound'] = 'Nisu pronađena pitanja koja se ručno ocjenjuju';
$string['nogradewarning'] = 'Ovaj kviz se ne ocjenjuje, tako da ne možete da podesite sveobuhvatnu povratnu informaciju.';
$string['nomoreattempts'] = 'Nemate više pravo da pokušavate da rješite kviz.';
$string['none'] = 'Nema';
$string['noopen'] = 'Nema datuma otvaranja kviza.';
$string['nooverridedata'] = 'Morate da promjenite najmanje jedno od podešavanja kviza.';
$string['nopossibledatasets'] = 'Nema mogućih skupova podataka';
$string['noquestionintext'] = 'Tekst pitanja ne sadrži umetnuta pitanja';
$string['noquestions'] = 'Nijedno pitanje još nije dodano';
$string['noquestionsfound'] = 'Nema pitanja';
$string['noquestionsinquiz'] = 'Ne postoje pitanja u ovom kvizu.';
$string['noquestionsnotinuse'] = 'Ovo nasumično odrabrano pitanje nije u upotrebi jer je njegova kategorija prazna';
$string['noquestionsonpage'] = 'Prazna stranica';
$string['noresponse'] = 'Bez odziva sistema';
$string['noreview'] = 'Nije Vam dozvoljen pregled ovog kviza.';
$string['noreviewattempt'] = 'Nije Vam dozvoljeno da pregledate ovaj pokušaj';
$string['noreviewshort'] = 'Nije dozvoljeno';
$string['noreviewuntil'] = 'Nije Vam dozvoljen pregled ovog kviza do {$a}';
$string['noreviewuntilshort'] = 'Dostupno {$a}';
$string['noscript'] = 'JavaScript mora biti omogućen da biste nastavili dalje!';
$string['notavailabletostudents'] = 'Napomena: Ovaj kviz nije još dostupan Vašim studentima.';
$string['notenoughrandomquestions'] = 'Nema dovoljno pitanja u kategoriji {$a->category} za kreiranje pitanja {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nije definisano dovoljno podpitanja!<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['notimedependentitems'] = 'Modul za kvizove trenutno ne podržava vremenski ograničena pitanja. Podesite vremenko ograničenje za čitav kviz. Da li želite da izaberete drugo pitanje (ili da ipak upotrebite trenutno pitanje)?';
$string['notyetgraded'] = 'Još nije ocjenjeno';
$string['notyetviewed'] = 'Još nije pregledano';
$string['notyourattempt'] = 'Ovo nije Vaš pokušaj!';
$string['noview'] = 'Prijavljenom korisniku nije dozvoljeno da pregleda ovaj kviz.';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} su načinili {$a->attemptnum} pokušaja';
$string['numattemptsmade'] = '{$a} učinjenih pokušaja rješavanja ovog kviza.';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeričko';
$string['numquestionsx'] = 'Pitanja: {$a}';
$string['oneminute'] = '1 minuta';
$string['onlyteachersexport'] = 'Samo predavači mogu da prenose pitanja';
$string['onlyteachersimport'] = 'Samo predavači sa pravima uređivanja mogu da unose pitanja';
$string['onthispage'] = 'Ova stranica';
$string['open'] = 'Nije odgovoreno';
$string['openclosedatesupdated'] = 'Ažurirani su datumi otvaranja i zatvaranja kviza.';
$string['optional'] = 'opciono';
$string['orderandpaging'] = 'Redosljed pitanja i organizacija stranica.';
$string['orderandpaging_help'] = 'Brojevi 10, 20, 30... pored svakog pitanja ukazuju na redosljed pitanja u kvizu. Brojevi se povećavaju u koracima po 10 kako bi se ostavio prostor za ubacivanje dodatnih pitanja. Da biste promjenili redosljed pitanja, promjenite broj, a onda kliknite na dugme "Promjeni redosljed pitanja". Da biste dodali prijelom stranice nakon određenog pitanja, označite polje za potvrdu odmah pored samog pitanja, a zatim kliknite na dugme "Dodaj nove stranice poslije izabranih pitanja" Da biste orgranizovali pitanja na više stranica kliknite na dugme "Reoraganizuj stranice" i izaberite željeni broj pitanja po stranici.';
$string['orderingquiz'] = 'Redoslijed pitanja i organizacija stranica.';
$string['orderingquizx'] = 'Redoslijed i prijelom stranica: {$a}';
$string['outof'] = '{$a->grade} od maksimalnih {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} od maksimuma {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['overallfeedback_help'] = 'Sveobuhvatna povratna informacija predstavlja tekst koji se prikazuje nakon rješavnja kviza. Ako se dodatno odrede granične vrijednosti ocjena (kao procenti ili brojevi), tekst koji će biti prikazan zavisi od dobijene ocjene.';
$string['overdue'] = 'Zakašnjeli';
$string['overduehandling'] = 'Kada vrijeme istekne';
$string['overduehandlingautoabandon'] = 'Pokušaj mora biti predan prije nego što vrijeme istekne, ili se neće računati';
$string['overduehandlingautosubmit'] = 'Otvoreni pokušaji rješavanja kviza se automatski predaju';
$string['overduehandling_desc'] = 'Šta se obično događa ako student ne preda kviz prije nego što vrijeme istekne.';
$string['overduehandlinggraceperiod'] = 'Postoji dodatan rok u kojem se otvoreni pokušaj rješavanja može predati, ali se više ne može odgovarati na pitanja.';
$string['overduehandling_help'] = 'Ovo podešavanje kontroliše šta se događa ako student ne uspije da preda svoj pokušaj rješenja kviza prije nego što vrijeme istekne. Ako student aktivno rade na kvizu u tom trenutku, onda će timer automatski predati pokušaj umjesto njega, ali ako je odjavljen sa sistema, onda ovo podešavanje kontroliše šta će se desiti.';
$string['overduemustbesubmittedby'] = 'Vrijeme za ovaj pokušaj rješavanje kviza je isteklo. Pokušaj je već trebalo predati. Ako želite da ovaj kviz bude ocjenjen morate ga predati do {$a}. Ako to ne uradite do navedenog roka, ocjene za ovaj pokušaj se neće računati.';
$string['override'] = 'Izmjena podešavanja kviza.';
$string['overridedeletegroupsure'] = 'Da li ste sigurni da želite da obrišete izmjene za grupu {$a}?';
$string['overridedeleteusersure'] = 'Da li ste sigurni da želite da obrišete izmjene za korisnika {$a}?';
$string['overridegroup'] = 'Izmijeni podešavanja za grupu.';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Izmjene';
$string['overrideuser'] = 'Izmijeni podešavanja za korisnika.';
$string['overrideusereventname'] = 'Izmjene.';
$string['page-mod-quiz-edit'] = 'Uredi stranu kviza.';
$string['page-mod-quiz-x'] = 'Bilo koja strana kviz modula.';
$string['pagesize'] = 'Veličina stranice';
$string['parent'] = 'Nadređeni';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parsingquestions'] = 'Parsiranje pitanja iz unesene datoteke.';
$string['partiallycorrect'] = 'Djelimično tačno';
$string['penalty'] = 'Kazneni bodovi';
$string['penaltyscheme'] = 'Primijeni kaznene poene';
$string['penaltyscheme_help'] = '<p>Ako je kviz pokrenut u adaptivnom modu onda je studentima dozvoljeno da, nakon pogrešnog odgovora, pokušaju ponovo. U tom slučaju možda ćete poželjeti da uvedete kaznene poene za svaki pogrešan odgovor kako biste umanjili finalnu ocjenu. Vrijednost kaznenih poena se određuje pojedinačno za svako pitanje prilikom podešavanja i uređivanja pitanja.</p> <p>Ovo podešavanje je bez uticaja ukoliko kviz nije pokrenut u adaptivnom modu.</p>';
$string['percentcorrect'] = 'Postotak tačnosti';
$string['pleaseclose'] = 'Vaš zahtjev je proslijeđen. Možete da zatvorite prozor.';
$string['pluginadministration'] = 'Administracija kviza.';
$string['pluginname'] = 'Kviz.';
$string['popup'] = 'Prikaži kviz u \'sigurnom\' prozoru';
$string['popupblockerwarning'] = 'Ovaj dio kviza se radi u sigurnosnom modu, što znači da morate rješavati kviz u sigurnosnom prozoru. Molimo isključite sve alate za spriječavanje pojave pop-up prozora. Hvala.';
$string['popupnotice'] = 'Studenti će vidjeti kviz u \'sigurnom\' prozoru';
$string['preprocesserror'] = 'Došlo je do greške u toku preprocesiranja!';
$string['preview'] = 'Pregled';
$string['previewquestion'] = 'Pregled pitanja';
$string['previewquiz'] = 'Pregledaj {$a}';
$string['previewquiznow'] = 'Pregledaj kviz sada.';
$string['previous'] = 'Prethodno stanje';
$string['publish'] = 'Objavi';
$string['publishedit'] = 'Da bi ste dodali ili uredili pitanja u ovoj kategoriji morate imati odgovarajuće pravo pristupa';
$string['qbrief'] = 'P. {$a}';
$string['qname'] = 'ime';
$string['qti'] = 'IMS QTI format';
$string['qtypename'] = 'tip, ime';
$string['question'] = 'Pitanje';
$string['questionbankcontents'] = 'Sadržaj baze pitanja';
$string['questionbankmanagement'] = 'Upravljanje bazom pitanja';
$string['questionbehaviour'] = 'Karakteristike pitanja';
$string['questioncats'] = 'Kategorije pitanja';
$string['questiondeleted'] = 'Ovo pitanje je obrisano. Molimo kontaktirajte svog predavača.';
$string['questioninuse'] = 'Pitanje \'{$a->questionname}\' se trenutno koristi u <br />{$a->quiznames}<br />Pitanje neće biti obrisano iz ovih kvizova, već samo sa spiska kategorije.';
$string['questionmissing'] = 'Nedostaje pitanje za ovu sesiju';
$string['questionname'] = 'Naziv pitanja';
$string['questionnonav'] = '<span class="accesshide">Pitanje </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacija </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pitanje {$a} nije učitano iz baze podataka';
$string['questionorder'] = 'Redoslijed pitanja';
$string['questionposition'] = 'Nova pozicija u redoslijedu za pitanje {$a}';
$string['questions'] = 'Pitanja';
$string['questionsinclhidden'] = 'Pitanja (uključujući i skrivena)';
$string['questionsinthisquiz'] = 'Pitanja u ovom kvizu.';
$string['questionsperpage'] = 'Broj pitanja po stranici';
$string['questionsperpageselected'] = 'Broj pitanja po stranici je podešen, tako da je trenutno broj stranica fiksiran. Usljed toga kontrole za reorganizaciju stranica su isključene. Ovo možete da promjenite na {$a}.';
$string['questionsperpagex'] = 'Pitanja po jednoj stranici: {$a}';
$string['questiontext'] = 'Tekst pitanja';
$string['questiontextisempty'] = '[Nema teksta pitanja]';
$string['questiontype'] = 'Tip pitanja {$a}';
$string['questiontypesetupoptions'] = 'Opcije podešavanja za tipove pitanja:';
$string['quiz:addinstance'] = 'Dodaj novi kviz.';
$string['quiz:attempt'] = 'Pokušaj rješavanja kvizova.';
$string['quizavailable'] = 'Kviz je dostupan do: {$a}';
$string['quizclose'] = 'Zatvorite kviz.';
$string['quizclosed'] = 'Kviz je zatvoren dana {$a}';
$string['quizcloses'] = 'Kviz se zatvara';
$string['quizcloseson'] = 'Ovaj kviz se zatvara {$a}';
$string['quiz:deleteattempts'] = 'Brisanje pokušaja rješavanja kvizova.';
$string['quiz:emailconfirmsubmission'] = 'Dobijanje poruke sa potvrdom o predaji kviza.';
$string['quiz:emailnotifysubmission'] = 'Dobijanje poruke sa obavještenjem o predaji kviza.';
$string['quiz:emailwarnoverdue'] = 'Dobijanje poruke sa obavještenjem da pokušaj rješavanja kviza kasni i da treba da se preda.';
$string['quiz:grade'] = 'Ocijeni kvizove ručno.';
$string['quiz:ignoretimelimits'] = 'Ignoriše vremenska ograničenja kvizova.';
$string['quizisclosed'] = 'Ovaj kviz je zatvoren';
$string['quizisclosedwillopen'] = 'Kviz je zatvoren (otvara se {$a})';
$string['quizisopen'] = 'Ovaj kviz je otvoren';
$string['quizisopenwillclose'] = 'Kviz je otvoren (zatvara se {$a})';
$string['quiz:manage'] = 'Upravljanje kvizovima.';
$string['quiz:manageoverrides'] = 'Uređivanje izmjena podešavanja kviza.';
$string['quiznavigation'] = 'Navigacija kviza';
$string['quizopen'] = 'Otvorite kviz';
$string['quizopenclose'] = 'Datumi otvaranja i zatvaranja';
$string['quizopenclose_help'] = 'Studenti mogu samo da započnu svoje pokušaje rješavanja kviza nakon datuma otvaranja i moraju da ih završe prije datuma zatvaranja.';
$string['quizopened'] = 'Ovaj kviz je otvoren';
$string['quizopenedon'] = 'Ovaj kviz otvoren u {$a}';
$string['quizopens'] = 'Kviz se otvara dana';
$string['quizopenwillclose'] = 'Ovaj kviz je otvoren, biće zatvoren {$a}';
$string['quizordernotrandom'] = 'Redosljed kviza nije izmješan';
$string['quizorderrandom'] = '* Redosljed kviza je izmješan';
$string['quiz:preview'] = 'Pregled kvizova.';
$string['quiz:regrade'] = 'Ponovo ocijeni pokušaje.';
$string['quiz:reviewmyattempts'] = 'Pregledaj vlasitite pokušaje';
$string['quizsettings'] = 'Podešavanja kviza';
$string['quiztimer'] = 'Praćenje utrošenog vremena';
$string['quiz:view'] = 'Pregled informacija o kvizu.';
$string['quiz:viewreports'] = 'Pregled izvještaja o kvizu.';
$string['quizwillopen'] = 'Ovaj kviz se otvara {$a}';
$string['random'] = 'Nasumično odabrano pitanje';
$string['randomcreate'] = 'Kreiraj nasumično odabrana pitanja';
$string['randomfromcategory'] = 'Nasumično odabrano pitanje iz kategorije';
$string['randomfromexistingcategory'] = 'Nasumično odabrano pitanje iz postojeće kategorije';
$string['randomnosubcat'] = 'Pitanja samo iѕ ove kategorije, ne i njenih podkategorija';
$string['randomquestionusinganewcategory'] = 'Nasumično odabrano pitanje korištenjem nove kategorije';
$string['randomwithsubcat'] = 'Pitanja iz ove kategorije i njenih podkategorija';
$string['readytosend'] = 'Upravo ćete poslati svoje rješenje kviza na ocjenjivanje. Da li ste sigurni da želite da nastavite?';
$string['reattemptquiz'] = 'Ponovni pokušaj rješavanja kviza';
$string['recentlyaddedquestion'] = 'Nedavno dodato pitanje!';
$string['recurse'] = 'Uključi i pitanja iz podkategorija';
$string['regrade'] = 'Ponovo ocijeni sve pokušaje';
$string['regradecomplete'] = 'Svi pokušaji su ponovo ocijenjeni';
$string['regradecount'] = '{$a->changed} od ukupno {$a->attempt} ocjena je promijenjeno';
$string['regradedisplayexplanation'] = 'Pokušaji koji se mjenjaju tokom ponovnog ocjenjivanja se prikazuju kao linkovi na prozor za pregled pitanja';
$string['regradenotallowed'] = 'Nemate dozvolu za ponovno ocjenjivanje ovog kviza.';
$string['regradingquestion'] = 'Ponovno ocjenjivanje "{$a}".';
$string['regradingquiz'] = 'Ponovno ocjenjivanje testa "{$a}"';
$string['remove'] = 'Ukloni';
$string['removeallquizattempts'] = 'Izbriši sve pokušaje rješavanja kviza.';
$string['removeemptypage'] = 'Ukloni praznu stranicu';
$string['removeselected'] = 'Ukloni izabrane';
$string['rename'] = 'Preimenuj';
$string['renderingserverconnectfailed'] = 'Server {$a} nije uspio da obradi RQP zahtev. Provjerite da li je URL adresa tačna.';
$string['reorderquestions'] = 'Promjeni redoslijed pitanja.';
$string['reordertool'] = 'Prikaži alat za reorganizovanje';
$string['repaginate'] = 'Reorganizuj stranice sa {$a} pitanja po jednoj stranici';
$string['repaginatecommand'] = 'Reorganizuj stranice';
$string['repaginatenow'] = 'Reorganizuj stranice sad';
$string['replace'] = 'Zamjeni';
$string['replacementoptions'] = 'Opcije za zamjenu';
$string['report'] = 'Izvještaji';
$string['reportanalysis'] = 'Analiza stavki';
$string['reportattemptsfrom'] = 'Pokušaji od';
$string['reportattemptsthatare'] = 'Pokušaji koji su';
$string['reportdisplayoptions'] = 'Opcije prikaza';
$string['reportfullstat'] = 'Detaljna statistika';
$string['reportmulti_percent'] = 'Postoci';
$string['reportmulti_q_x_student'] = 'Odgovori studenata';
$string['reportmulti_resp'] = 'Individualni odgovori';
$string['reportmustselectstate'] = 'Potrebno je da izaberete bar jedno stanje';
$string['reportnotfound'] = 'Izvještaj nije poznat ({$a})';
$string['reportoverview'] = 'Pregled';
$string['reportregrade'] = 'Ponovna ocjena pokušaja rješavanja kviza.';
$string['reportresponses'] = 'Detaljni odzivi sistema';
$string['reports'] = 'Izvještaji';
$string['reportshowonly'] = 'Prikaži samo pokušaje';
$string['reportsimplestat'] = 'Jednostavna statistika';
$string['reportusersall'] = 'Svi korisnici koji su rješavali kviz.';
$string['reportuserswith'] = 'Upisani korisnici koji su rješavali kviz.';
$string['reportuserswithorwithout'] = 'upisani korisnici koji jesu ili nisu rješavali kviz.';
$string['reportuserswithout'] = 'upisani korisnici koji nisu rješavali kviz.';
$string['reportwhattoinclude'] = 'Šta uključiti u izvještaj';
$string['requirepassword'] = 'Neophodna je lozinka';
$string['requirepassword_help'] = '<p>Ovo polje nije obavezno</p> <p>Ako ovdje odredite lozinku od učesnika će se zahtjevati da istu unesu prije nego što im se dozvoli da pokušaju da rješe kviz.</p>';
$string['requiresubnet'] = 'Zahtijevana mrežna adresa';
$string['requiresubnet_help'] = '<p>Ovo polje nije obavezno.</p> <p>Možete ograničiti pristup kvizu samo na neke podmreže u okviru LAN mreže ili Interneta navođenjem spiska parcijalnih ili potpunih IP adresnih brojeva odvojenih zarezima.</p> <p>To je posebno korisno za nadgledane kvizove, kada želite da budete sigurni da samo prisutni u određenoj prostoriji mogu da pristupe kvizu.</p> <p>Na primjer: <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p> <p>Postoje tri tipa IP brojeva koje možete koristiti (ne možete upotrijebiti tekstualna imena domena, kao što je recimo primjer.com): <ol> <li>Potpune IP adrese, kao što je <b>192.168.10.1</b>, koje će označavati pojedinačne računare (ili proxy servere).</li> <li>Parcijalne adrese, kao što je <b>192.168</b>, koje će obuhvatati sve adrese koje počinju tim brojevima.</li> <li>CIDR notacija, kao što je <b>231.54.211.0/20</b>, koja dozvoljava detaljniju specifikaciju podmreža.</li> </ol> </p> <p>Praznine se ignorišu.</p>';
$string['response'] = 'Odziv sistema';
$string['responses'] = 'Odzivi sistema';
$string['results'] = 'Rezultati';
$string['returnattempt'] = 'Povratak na pokušaj';
$string['reuseifpossible'] = 'ponovo iskoristi prethodno uklonjeno';
$string['reverttodefaults'] = 'Vrati na zadanu podešavanja kviza.';
$string['review'] = 'Pregled';
$string['reviewafter'] = 'Dozvoliti pregled nakon što se kviz zatvori';
$string['reviewalways'] = 'Dozvoliti pregled u bilo koje vrijeme';
$string['reviewattempt'] = 'Pregledaj pokušaj';
$string['reviewbefore'] = 'Dozvoliti pregled dok je kviz otvoren';
$string['reviewclosed'] = 'Nakon što se kviz zatvori';
$string['reviewduring'] = 'Tokom pokušaja rješavanja';
$string['reviewimmediately'] = 'Odmah nakon pokušaja';
$string['reviewnever'] = 'Nikad nemoj dozvoliti pregled';
$string['reviewofattempt'] = 'Pregled pokušaja {$a}';
$string['reviewofpreview'] = 'Pregled prikaza';
$string['reviewopen'] = 'Kasnije, dok je kviz još uvijek otvoren';
$string['reviewoptions'] = 'Studenti mogu da pregledaju';
$string['reviewoptionsheading'] = 'Opcije za pregled';
$string['reviewoptionsheading_help'] = 'Ova opcije kontrolišu koje informacije studenti mogu da vide kada pregledaju pokušaj rješavanja kviza odnosno kada gledaju izvještaj sa kviza. **U toku pokušaja** - ovo podešavanje je relevantno samo za neka ponašanja, kao što je \'interaktivno sa višestrukim pokušajima\', koje može da prikazuje povratne informacije u toku pokušaja. **Odmah nakon pokušaja** - ovo podešavanje se primjenjuje u prva dva minuta nakon što je student kliknuo na dugme \'Predaj sve i završi\'. . **Kasnije, dok je kviz još uvijek otvoren** - ovo podešavanje primjenjuje, nakon ta prva dva minuta pa sve dok je kviz otvoren. **Nakon što je kviz zatvoren** - ovo podešavanje se primjenjuje nakon što prođe datum zatvaranja kviza. Ako kviz nema datum zatvaranja, ovaj uslov nikada neće biti postignut.';
$string['reviewoverallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['reviewoverallfeedback_help'] = 'Povratne informacije koje se daju na kraju pokušaja rješavanja kviza, u zavisnosti od ukupne ocjene studenta.';
$string['reviewresponse'] = 'Pregled odziva sistema';
$string['reviewresponsetoq'] = 'Pregledaj odgovore (pitanje {$a})';
$string['reviewthisattempt'] = 'Pregledaj svoj odgovor na ovaj pokušaj';
$string['rqp'] = 'Udaljeno pitanje';
$string['rqps'] = 'Udaljena pitanja';
$string['sameasoverall'] = 'Isto kao i za sveukupne ocjene';
$string['save'] = 'Sačuvaj';
$string['saveandedit'] = 'Sačuvaj promjene i uredi pitanja';
$string['saveattemptfailed'] = 'Neuspjelo čuvanje aktuelnog pokušaja rješenja kviza.';
$string['savedfromdeletedcourse'] = 'Sačuvano sa kursa "{$a}" koji je obrisan';
$string['savegrades'] = 'Sačuvaj ocjene';
$string['savemyanswers'] = 'Sačuvaj moje odgovore';
$string['savenosubmit'] = 'Sačuvaj bez predavanja';
$string['saveoverrideandstay'] = 'Sačuvaj i unesi novu izmjenu podešavanja';
$string['savequiz'] = 'Sačuvaj cijeli kviz';
$string['saving'] = 'Čuvanje';
$string['savingnewgradeforquestion'] = 'Čuvanje nove ocjene za pitanjе sa identifikatorom {$a}.';
$string['savingnewmaximumgrade'] = 'Čuvanje nove maksimalne ocjene';
$string['score'] = 'Neobrađeni rezultat';
$string['scores'] = 'Rezultati';
$string['select'] = 'Selektuj';
$string['selectall'] = 'Izaberi sve';
$string['selectcategory'] = 'Izaberi kategoriju';
$string['selectedattempts'] = 'Izabrani pokušaji...';
$string['selectnone'] = 'Deselektuj sve';
$string['selectquestiontype'] = '-- Izaberi tip pitanja --';
$string['serveradded'] = 'Server je dodan';
$string['serveridentifier'] = 'Identifikator';
$string['serverinfo'] = 'Informacije o serveru';
$string['servers'] = 'Serveri';
$string['serverurl'] = 'URL servera';
$string['settingsoverrides'] = 'Izmjene podešavanja';
$string['shortanswer'] = 'Pitanje sa kratkim odgovorom';
$string['show'] = 'Prikaži';
$string['showall'] = 'Prikaži sva pitanja na jednoj stranici';
$string['showblocks'] = 'Prikaži blokove tokom rješavanja kviza';
$string['showblocks_help'] = 'Ako je podešeno na "Da", onda će u toku rješavanja kviza biti prikazani uobičajeni blokovi.';
$string['showbreaks'] = 'Prikaži prekide između stranica';
$string['showcategorycontents'] = 'Prikaži sadržaj kategorija {$a->arrow}';
$string['showcorrectanswer'] = 'Da li da se uz povratne informacije prikažu i tačni odgovori?';
$string['showdetailedmarks'] = 'Prikaži detalje ocjene';
$string['showeachpage'] = 'Prikaži jednu po jednu stranicu';
$string['showfeedback'] = 'Da li da se prikažu i povratne informacije nakon davanja odgovora na pitanja?';
$string['showinsecurepopup'] = 'Upotrebiti "sigurnosni" pop-up prozor za pokušaje';
$string['shownoattempts'] = 'Prikaži studente bez pokušaja';
$string['shownoattemptsonly'] = 'Prikaži samo studente bez pokušaja';
$string['showreport'] = 'Prikaži izvještaj';
$string['showteacherattempts'] = 'Prikaži pokušaje predavača da riješi kviz';
$string['showuserpicture'] = 'Prikaži sliku korisnika';
$string['showuserpicture_help'] = 'Ako je ova opcija omogućena, ime i slika studenta biće prikazana na ekranu tokom rješavanja kviza, kao i prilikom pregleda. Ovo olakšava provjeru identiteta prijavljenog studenta, na kvizovima koji se rade u učionici (npr. na završnom kvizu).';
$string['shuffle'] = 'Izmješaj';
$string['shuffleanswers'] = 'Izmješaj odgovore';
$string['shuffledrandomly'] = 'Nasumično izmješano';
$string['shufflequestions'] = 'Izmješaj pitanja';
$string['shufflequestionsselected'] = 'S obzirom da je opcija za mješanje pitanja uključena, neke akcije koje se tiču stranica nisu dostupne. Za promjenu opcije mješanja, {$a}.';
$string['shufflewithin'] = 'Izmješaj u okviru pitanja';
$string['shufflewithin_help'] = '<p>Ako omogućite ovu opciju, dijelovi od kojih se sastoje pojedinačna pitanja biće nasumično izmješani svaki put kad student pokuša da riješi ovaj kviz, pod uslovom da je ista opcija omogućena i u podešavanjima samih pitanja.</p> <p>Svrha svega ovoga je da se studentima makar malo oteža međusobno prepisivanje.</p> <p>Naravno, ovo se odnosi samo na pitanja koja se sastoje iz više dijelova, kao što su pitanja tipa višestrukog izbora ili ona sa uparivanjem odgovora. Kad je riječ o pitanjima višestrukog izbora, redosljed u kojem će biti prikazani odgovori se nasumično mjenja samo ako je ova opcija postavljena na &quot;Da&quot;. Za pitanja sa uparivanjem odgovora, mješanje ponuđenih odgovora se uvijek radi, a ovo podešavanje kontroliše da li se dodatno nasumično određuje redoslijed prikazanih parova pitanje-odgovor.</p> <p>Ova opcija nije ni u kakvoj vezi sa korištenjem slučajnih pitanja.</p>';
$string['singleanswer'] = 'Odaberite jedan odgovor';
$string['sortage'] = 'Sortiraj po vremenu kreiranja';
$string['sortalpha'] = 'Sortiraj po imenu';
$string['sortquestionsbyx'] = 'Poredaj pitanja po {$a}';
$string['sortsubmit'] = 'Sortiraj pitanja';
$string['sorttypealpha'] = 'Sortiraj po tipu, imenu';
$string['specificapathnotonquestion'] = 'Zadana putanja datoteke nije na datom pitanju';
$string['specificquestionnotonquiz'] = 'Zadano pitanje nije u datom kvizu';
$string['startagain'] = 'Počni ponovo';
$string['startattempt'] = 'Započni pokušaj rješavanja';
$string['startedon'] = 'Započeto';
$string['startnewpreview'] = 'Započnite novi pregled';
$string['stateabandoned'] = 'Nikad predano';
$string['statefinished'] = 'Završeno';
$string['statefinisheddetails'] = 'Predano {$a}';
$string['stateinprogress'] = 'U toku';
$string['statenotloaded'] = 'Stanje za pitanje  {$a} nije učitano iz baze podataka';
$string['stateoverdue'] = 'Zakašnjela predaja';
$string['stateoverduedetails'] = 'Mora se predati do {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stani pri pojavi greške';
$string['submitallandfinish'] = 'Predaj sve odgovore i završi kviz';
$string['subneterror'] = 'Nažalost, ovaj kviz je zaključan, odnosno dostupan je samo sa pojedinih lokacija. Trenutno Vaš računar nije jedan od onih kojima je dozvoljeno da koriste ovaj kviz.';
$string['subnetnotice'] = 'Ovom kvizu se može pristupiti samo sa određenih lokacija. Vaš računar se ne nalazi u mreži sa koje je pristup dozvoljen. Ipak, kao predavač svakako možete da pregledate kviz.';
$string['subplugintype_quiz'] = 'Izvještaj';
$string['subplugintype_quizaccess'] = 'Pravilo za pristup kvizu';
$string['subplugintype_quizaccess_plural'] = 'Pravila za pristup kvizu';
$string['subplugintype_quiz_plural'] = 'Izvještaji';
$string['substitutedby'] = 'biće zamjenjeno sa';
$string['summaryofattempt'] = 'Rezime pokušaja';
$string['summaryofattempts'] = 'Kratak pregled vaših prethodnih pokušaja';
$string['temporaryblocked'] = 'Privremeno Vam nije dozvoljeno da ponovo pokušate da rješite kviz.<br /> Moći ćete ponovo da mu pristupite dana:';
$string['theattempt'] = 'Pokušaj rješavanja';
$string['theattempt_help'] = 'Da li student uopće može da pregleda pokušaj.';
$string['time'] = 'Vrijeme';
$string['timecompleted'] = 'Završeno';
$string['timedelay'] = 'Nije Vam dozvoljeno da radite kviz jer još nije prošao zadani razmak od Vašeg posljednjeg do sljedećeg mogućeg pokušaja rješavanja drugog kviza.';
$string['timeleft'] = 'Preostalo vrijeme';
$string['timelimit'] = 'Vremensko ograničenje';
$string['timelimitexeeded'] = 'Žao nam je, vrijeme za rješavanje kviza je isteklo!';
$string['timelimit_help'] = 'Ako je ova opcija omogućena, na početnoj stranici kviza biće navedeno vremensko ograničenje, a u bloku za navigaciju kviza biće prikazan timer.';
$string['timelimitmin'] = 'Vremensko ograničenje (u minutima)';
$string['timelimitsec'] = 'Vremensko ograničenje (sekunde)';
$string['timestr'] = '%H:%M:%S dana %d.%m.%y.';
$string['timesup'] = 'Vrijeme je isteklo!';
$string['timetaken'] = 'Utrošeno vrijeme';
$string['timing'] = 'Podešavanje vremena';
$string['tofile'] = 'u datoteku';
$string['tolerance'] = 'Tolerancija';
$string['toomanyrandom'] = 'Broj slučajnih pitanja potrebnih za kviz je veći od ukupnog broja pitanja raspoloživih u zadanoj kategoriji!';
$string['top'] = 'Najviši nivo';
$string['totalmarksx'] = 'Ukupno ocjena: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Ukupno {$a} pitanja u kategoriji.';
$string['true'] = 'Tačno';
$string['truefalse'] = 'Tačno/Netačno';
$string['type'] = 'Tip';
$string['unfinished'] = 'otvoreno';
$string['ungraded'] = 'Neocjenjeno';
$string['unit'] = 'Jedinica';
$string['unknowntype'] = 'Tip pitanja koji nije podržan u liniji {$a}. Ovo pitanje će biti ignorisano.';
$string['unusedcategorydeleted'] = 'Nakon brisanja kursa, ova kategorija je, takođe, obrisana, zbog toga što se pitanja iz ove kategorija ne koriste u kvizovima drugih kurseva.';
$string['updatesettings'] = 'Ažuriraj podešavanja kviza';
$string['updatingatttemptgrades'] = 'Ažuriranje ocjena pokušaja';
$string['updatingfinalgrades'] = 'Ažuriranje konačnih ocjena';
$string['updatingthegradebook'] = 'Ažuriranje knjige ocjena';
$string['upgradesure'] = '<div>Modul \'Kviz\' će izvesti obimne promjene tabela sa kvizovima u bazi podataka. Ova nadogradnja još uvijek nije dovoljno testirana. Prije nego što nastavite strogo vam preporučujemo da napravite rezervnu kopiju vaše baze podataka.</div>';
$string['upgradingquizattempts'] = 'Nadogradnja pokušaja rješavanja kviza: kviz {$a->done}/{$a->outof} (Identifikator kviza {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Nadogradnja vrlo starih pokušaja rješavanja kviza: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Nakon brisanja kursa, ova kategorija je sačuvana i premještena na nivo sajta, zbog toga što se pitanja iz ove kategorije koriste u kvizovima drugih kurseva.';
$string['useroverrides'] = 'Izmjene za korisnike';
$string['usersnone'] = 'Nijedan student nema pristup ovom kvizu';
$string['validate'] = 'Provjeri';
$string['viewallanswers'] = 'Prikaz {$a} pokušaja rješavanja kviza';
$string['viewallreports'] = 'Pogledaj izvještaje za {$a} pokušaja';
$string['viewed'] = 'Pregledano';
$string['warningmissingtype'] = '<b>Ovo pitanje pripada tipu koji još uvijek nije instaliran na vašem Moodleu.<br />Molimo obavijestite svog Moodle administratora.</b>';
$string['wheregrade'] = 'Gdje je moja ocjena?';
$string['wildcard'] = 'Džoker znak';
$string['windowclosing'] = 'Ovaj prozor će se ubrzo zatvoriti.';
$string['withsummary'] = 'sa sumarnom statistikom';
$string['wronguse'] = 'Ne možete tako da koristite ovu stranicu';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Potrebno je da se upišete na ovaj kurs prije nego što pokušate rješavanje ovog kviza';
$string['yourfinalgradeis'] = 'Vaša konačna ocjena na ovom kvizu je {$a}.';
