<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcija';
$string['addanotherhint'] = 'Dodaj još jedan savjet';
$string['addcategory'] = 'Dodaj kategoriju';
$string['adminreport'] = 'Izvještaj o mogućim problemima u Vašoj bazi podataka sa pitanjima';
$string['answer'] = 'Odgovor';
$string['answers'] = 'Odgovori';
$string['answersaved'] = 'Odgovor je sačuvan';
$string['attemptfinished'] = 'Pokušaj je završen';
$string['attemptfinishedsubmitting'] = 'Predaja završenih pokušaja:';
$string['attemptoptions'] = 'Opcije pokušaja';
$string['availableq'] = 'Dostupno?';
$string['badbase'] = 'Loša baza prije **: {$} **';
$string['behaviour'] = 'Ponašanje';
$string['behaviourbeingused'] = 'ponašanje koje se koristi: {$a}';
$string['broken'] = 'Ovo je "prekinut link", pokazuje na nepostojeći fajl.';
$string['byandon'] = 'uredio/la <em>{$a->user}</em> (<em>{$a->time}</em>)';
$string['cannotcopybackup'] = 'Nije moguće kopirati datoteku rezervne kopije';
$string['cannotcreate'] = 'Nije moguće kreirati novi unos u tabeli  question_attempts';
$string['cannotcreatepath'] = 'Nije moguće kreirati putanju: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Ne možete da obrišete ponašanje \'{$a}\'. Već postoje pokušaji rješavanja pitanja koje koristi ovo ponašanje.';
$string['cannotdeletecate'] = 'Ne možete da obrišete ovu kategoriju, pošto je u ovom kontekstu to zadana kategorija.';
$string['cannotdeleteneededbehaviour'] = 'Nije moguće obrisati ponašanje pitanja \'{$a}\'. Postoje i druga instalirana ponašanja koja se oslanjaju na njega.';
$string['cannotdeleteqtypeinuse'] = 'Ne možete da obrišete tip pitanja \'{$a}\'. U bazi pitanja postoje pitanja ovog tipa.';
$string['cannotdeleteqtypeneeded'] = 'Ne možete da obrišete tip pitanja \'{$a}\'. Postoje drugi tipovi pitanja koji su povezani sa ovim tipom.';
$string['cannotenable'] = 'Tip pitanja {$a} ne može biti kreiran direktno.';
$string['cannotenablebehaviour'] = 'Ponašanje pitanja {$a} ne može da se koristi direktno. Ono služi samo za internu upotrebu.';
$string['cannotfindcate'] = 'Nije moguće pronaći zapis kategorije';
$string['cannotfindquestionfile'] = 'Nije moguće pronaći datoteku sa pitanjima u zip arhivi';
$string['cannotgetdsfordependent'] = 'Nije moguće preuzeti navedeni skup podataka za pitanje zavisno od tog skupa podataka! (pitanje: {$a[0]}, datasetitem: {a[1]})';
$string['cannotgetdsforquestion'] = 'Nije moguće preuzeti navedeni skup podataka za računsko pitanje! (pitanje: {$a})';
$string['cannothidequestion'] = 'Nije bilo moguće sakriti pitanje';
$string['cannotimportformat'] = 'Žao nam je, unos ovog formata još nije implementiran!';
$string['cannotinsertquestion'] = 'Nije moguće ubaciti novo pitanje!';
$string['cannotinsertquestioncatecontext'] = 'Nije moguće umetnuti novu kategoriju pitanja {$a->cat} ilegalni contextid {$a->ctx}';
$string['cannotloadquestion'] = 'Nije moguće učitati pitanje';
$string['cannotmovequestion'] = 'Ne možete da koristite ovaj skript za prebacivanje pitanja koja sa sobom imaju pridružene datoteke iz različitih područja.';
$string['cannotopenforwriting'] = 'Nije moguće otvoriti za upisivanje: {$a}';
$string['cannotpreview'] = 'Ne možete da pregledate ova pitanja!';
$string['cannotread'] = 'Ne može se čitati unesena datoteka (ili je prazna)';
$string['cannotretrieveqcat'] = 'Nije moguće povratiti ovu kategoriju pitanja';
$string['cannotunhidequestion'] = 'Nije moguće otkriti kategoriju pitanja.';
$string['cannotunzip'] = 'Nije moguće raspakovati arhiviranu zip datoteku';
$string['cannotwriteto'] = 'Nije moguće upisati prenesena pitanja u {$a}';
$string['category'] = 'Kategorija';
$string['categorycurrent'] = 'Trenutna kategorija';
$string['categorycurrentuse'] = 'Koristiti ovu kategoriju';
$string['categorydoesnotexist'] = 'Ova kategorija ne postoji';
$string['categoryinfo'] = 'Informacije o kategoriji';
$string['categorymove'] = 'Kategorija \'{$a->name}\' sadrži {$a->count} pitanja. (neka od njih mogu biti stara, skrivena ili pitanja koja se i dalje koriste u postojećim kvizovima).<br /> Odaberite drugu kategoriju u koju ćete ih premjestiti.';
$string['categorymoveto'] = 'Snimi u kategoriju';
$string['categorynamecantbeblank'] = 'Potrebno je da upišete naziv kategorije.';
$string['changeoptions'] = 'Promijeni opcije';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategoriji "{$a->name}"</a> će u okviru kursa "{$a->coursename}" biti promijenjen status dijeljenja iz <strong>{$a->changefrom} u {$a->changeto}</strong>.';
$string['check'] = 'Provjeri';
$string['chooseqtypetoadd'] = 'Izaberi tip pitanja za dodavanje';
$string['clearwrongparts'] = 'Obriši netačne odgovore';
$string['clickflag'] = 'Obilježi pitanje indikatorom (zastavicom)';
$string['clicktoflag'] = 'Obilježi ovo pitanje za buduće reference';
$string['clicktounflag'] = 'Ukloni indikator (zastavicu)';
$string['clickunflag'] = 'Ukloni indikator (zastavicu)';
$string['closepreview'] = 'Zatvori pregled';
$string['combinedfeedback'] = 'Kombinovane povratne informacije';
$string['comment'] = 'Komentar';
$string['commented'] = 'Komentarisao: {$}';
$string['commentormark'] = 'Komentarišite ili izmijenite ocjenu';
$string['comments'] = 'Komentari';
$string['commentx'] = 'Komentar: {$a}';
$string['complete'] = 'Završeno';
$string['contexterror'] = 'Ne biste smjeli da budete ovdje ukoliko niste premjestili kategoriju u drugi kontekst.';
$string['copy'] = 'Kopiraj iz {$a} i promijeni linkove.';
$string['correct'] = 'Tačno';
$string['correctfeedback'] = 'Za svaki tačan odgovor';
$string['created'] = 'Kreirano';
$string['createdby'] = 'Kreirao/la';
$string['createdmodifiedheader'] = 'Kreirano / Posljednja izmjena';
$string['createnewquestion'] = 'Kreiraj novo pitanje';
$string['cwrqpfs'] = 'Nasumično izabrana pitanja se biraju iz podkategorija.';
$string['cwrqpfsinfo'] = '<p>Tokom nadogradnje na Moodle 1.9 verziju kategorije pitanja će biti podijeljene u različite kontekste. Nekim pitanjima i kategorijama pitanja na Vašem sajtu će morati da bude promijenjen status dijeljenja. Ovo je neophodno u rijetkim slučajevima kada je jedno ili više ‘nasumičnih’ pitanja u nekom kvizu podešeno tako da se biraju iz mješavine dijeljenih i ne dijeljenih kategorija (kao što je to slučaj na ovom sajtu). Ovo se događa kada je podešeno da se ‘nasumično’ pitanje bira iz podkategorija, a pri tome jedna ili više podkategorija imaju različit status dijeljenja u odnosu na nadređenu kategoriju, u kojoj je ‘nasumično’ pitanje kreirano.</p> <p>Sljedećim kategorijama pitanja, iz kojih nadređene kategorije biraju ‘nasumična’ pitanja, status dijeljenja će biti promijenjen u isti onaj status kakav važi za kategoriju sa ‘nasumičnim’ pitanjem prilikom nadogradnje na verziju Moodle 1.9. Sljedećim kategorijama će status dijeljenja biti promijenjen. Pitanja na koja će ove izmjene uticati nastaviće normalno da funkcionira u svim postojećim kvizovima sve dok ih ne uklonite iz tih kvizova.</p>';
$string['cwrqpfsnoprob'] = 'Nema kategorija pitanja na Vašem sajtu na koje bi mogao uticati problem \'Nasumično izabranih pitanja biranih iz potkategorija\'.';
$string['decimalplacesingrades'] = 'Decimalna mjesta u ocjenama';
$string['defaultfor'] = 'Zadano za {$a}';
$string['defaultinfofor'] = 'Zadana kategorija za pitanja dijeljena u kontekstu \'{$a}\'.';
$string['defaultmark'] = 'Zadana ocjena';
$string['deletecoursecategorywithquestions'] = 'Postoje pitanja u bazi pitanja pridruženoj ovoj kategoriji kurseva. Ako nastavite, ona će biti obrisana. Možda biste željeli da ih prvo premjestite, koristeći interface za baze pitanja.';
$string['deletequestioncheck'] = 'Da li ste potpuno sigurni da želite da obrišete \'{$a}\'?';
$string['deletequestionscheck'] = 'Da li ste sigurni da želite da obrišete sljedeća pitanja?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Brisanje ponašanja pitanja \'{$a}';
$string['deletingqtype'] = 'Brisanje tipa pitanja \'{$a}';
$string['didnotmatchanyanswer'] = '[Ne poklapa se ni sa jednim odgovorom]';
$string['disabled'] = 'Onemogućeno';
$string['displayoptions'] = 'Prikaži opcije';
$string['disterror'] = 'Distribucija {$a} je izazvala probleme';
$string['donothing'] = 'Nemojte kopirati/premeštati datoteke ili mijenjati linkove.';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategories_help'] = 'Umjesto da sva budu na jednom velikom popisu, pitanja mogu biti organizovana u kategorije i podkategorije. Svaka kategorija ima kontekst koji određuje gdje pitanja iz određene kategorije mogu da se koriste: * Kontekst aktivnosti - pitanja su dostupna samo unutar određene aktivnosti * Kontekst kursa - pitanja su dostupna u svim aktivnostima određenog kursa * Kontekst kategorije kursa - pitanja su dostupna u svim aktivnostima i kursevima određene kategorije kurseva * Kontekst sistema - pitanja su dostupna svim kursevima i aktivnostima na sajtu Kategorije se koriste i za nasumično izabrana pitanja, budući da se pitanja biraju iz određenih kategorija.';
$string['editcategory'] = 'Uredi kategoriju';
$string['editingcategory'] = 'Uređivanje kategorije';
$string['editingquestion'] = 'Uređivanje pitanja';
$string['editquestion'] = 'Uredi pitanje';
$string['editquestions'] = 'Uredi pitanja';
$string['editthiscategory'] = 'Uredi ovu kategoriju';
$string['emptyxml'] = 'Nepoznata greška - prazna imsmanifest.xml datoteka';
$string['enabled'] = 'Omogućeno';
$string['erroraccessingcontext'] = 'Ne može se pristupiti kontekstu';
$string['errordeletingquestionsfromcategory'] = 'Greška pri brisanju pitanja iz kategorije {$a}.';
$string['errorduringpost'] = 'Pojavila se greška u toku post-procesiranja!';
$string['errorduringpre'] = 'Pojavila se greška u toku pre-procesiranja!';
$string['errorduringproc'] = 'Pojavila se greška u toku procesiranja!';
$string['errorduringregrade'] = 'Nije moguće ponovo ocijeniti pitanje {$a->qid}, prelazim na stanje {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Greška, ne može se kopirati fajl {$a}.';
$string['errorfilecannotbemoved'] = 'Greška, ne može se premjestiti fajl {$a}.';
$string['errorfileschanged'] = 'Greška: Datoteke povezane sa pitanjima su izmijenjene od momenta kada je obrazac bio prikazan.';
$string['errormanualgradeoutofrange'] = 'Ocjena {$a->grade} nije između 0 i {$a->maxgrade} za pitanje {$a->name}. Rezultat i komentar nisu sačuvani.';
$string['errormovingquestions'] = 'Greška pri premiještanju pitanja sa ID vrednostima {$a}.';
$string['errorpostprocess'] = 'Pojavila se greška u toku post-procesiranja!';
$string['errorpreprocess'] = 'Pojavila se greška u toku pre-procesiranja!';
$string['errorprocess'] = 'Pojavila se greška u toku procesiranja!';
$string['errorprocessingresponses'] = 'Došlo je do greške prilikom obrade vaših odgovora ({$a}). Kliknite na dugme \'Nastavi\' da se vratite na stranicu na kojoj ste bili i pokušajte ponovo.';
$string['errorsavingcomment'] = 'Greška pri čuvanju komentara za pitanje {$a->name} u bazi podataka.';
$string['errorsavingflags'] = 'Greška prilikom pokušaja da se sačuva status indikatora.';
$string['errorupdatingattempt'] = 'Greška pri pokušaju ažuriranja {$a->id} u bazi podataka.';
$string['exportcategory'] = 'Prenesi kategoriju';
$string['exportcategory_help'] = 'Ovo podešavanje određuje kategoriju iz koje će biti preuzeta prenesena pitanja. Određeni formati za unos pitanja, kao što su GIFT i Moodle XML, dozvoljavaju da u datoteku koja se prenosi budu uključeni i podaci o kategoriji i kontekstu, što ovim formatima daje mogućnost (opciono) da, prilikom unosa pitanja, ponovo kreiraju kategoriju i kontekst. Ako je neophodno, treba označiti odgovarajuće polje za izbor.';
$string['exporterror'] = 'Pojavila se greška u toku prenosa!';
$string['exportfilename'] = 'pitanja';
$string['exportnameformat'] = '%g.%m.%d.-%S.%M';
$string['exportquestions'] = 'Prenesi pitanja u datoteku';
$string['exportquestions_help'] = 'Ova funkcija omogućava prenos kompletne kategorije (sa svim njenim podkategorijama) u tekstualnu datoteku. Obratite pažnju, u zavisnosti od izabranog formata datoteke, da neke baze pitanja, kao i tipovi pitanja možda neće biti preneseni.';
$string['feedback'] = 'Povratne informacije';
$string['filecantmovefrom'] = 'Datoteke sa pitanjima ne mogu biti premještene zato što nemate ovlaštenja da uklanjate datoteke sa mjesta sa kojeg pokušavate da premjestite pitanja.';
$string['filecantmoveto'] = 'Datoteke sa pitanjima ne mogu biti premještene ili kopirane zato što nemate ovlaštenja da dodajete datoteke na mjesto na koje pokušavate da premjestite pitanja.';
$string['fileformat'] = 'Format datoteke';
$string['filesareacourse'] = 'Mjesto fajlova sa kursa';
$string['filesareasite'] = 'Mjesto fajlova sa sajta';
$string['filestomove'] = 'Kopiraj / premjesti fajlove u {$a}?';
$string['fillincorrect'] = 'Popunite tačne odgovore';
$string['flagged'] = 'Obilježeno';
$string['flagthisquestion'] = 'Obilježi ovo pitanje';
$string['formquestionnotinids'] = 'Obrazac sadrži pitanje koje nije u questionids';
$string['fractionsnomax'] = 'Jedan od odgovora bi trebao nositi 100% rezultata tako da je moguće dobiti maksimalan mogući broj bodova za ovo pitanje.';
$string['generalfeedback'] = 'Opće povratne informacije';
$string['generalfeedback_help'] = 'Opće povratne informacije se prikazuje studentima nakon što su završili pitanje. Za razliku od specifičnih povratnih informacija, koje zavise od tipa pitanja i odgovora koji je student dao, isti tekst općih povratnih informacija se prikazuje svim studentima. Opće povratne informacije možete koristiti kako biste studentima dali potpuno tačan odgovor i, eventualno, link ka detaljnijim informacijama koje mogu da koriste ukoliko nisu razumjeli pitanja.';
$string['getcategoryfromfile'] = 'Preuzmi kategoriju iz datoteke';
$string['getcontextfromfile'] = 'Preuzmi kontekst iz datoteke';
$string['hidden'] = 'Skriveno';
$string['hintn'] = 'Savjet {no}';
$string['hinttext'] = 'Tekst savjeta';
$string['howquestionsbehave'] = 'Kako se ponašaju pitanja';
$string['howquestionsbehave_help'] = 'Studenti mogu da stupaju u brojne, različite interakcije sa pitanjima unutar kviza. Na primjer, možda ćete htjeti da studenti unesu odgovore za sva pitanja i onda predaju kompletan kviz, prije nego što budu ocijenjeni ili prije nego što dobiju bilo kakve povratne informacije. Ovaj režim se zove \'Odložene povratne informacije\'. Alternativno, možda ćete htjeti da studenti predaju svaki odgovor zasebno u toku riješavanja kviza kako bi odmah dobili povratne informacije, a ako ih ne dobiju da mogu ponovo da pokušaju da daju novi odgovor za nižu ocjenu. Ovaj režim se zove \'Interaktivno sa višestrukim pokušajima\'. Ovo su vjerovatno dva najčešće korištena režima ponašanja pitanja.';
$string['ignorebroken'] = 'Ignoriši neispravne linkove';
$string['importcategory'] = 'Unesi kategoriju';
$string['importcategory_help'] = 'Ovo podešavanje određuje kategoriju u koju će unesena pitanja biti smještena. Određeni formati unosa, kao što su GIFT i Moodle XML, mogu da uključe u unesenu datoteku i informacije o kategoriji i kontekstu. Ako želite da koristite te podatke, umjesto odabrane kategorije, potrebno je da označite odgovarajuća polja za izbor. Ako kategorije navedene u unesenoj datoteci ne postoje, one će biti kreirane.';
$string['importerror'] = 'Došlo je do greške u toku obrade unosa';
$string['importerrorquestion'] = 'Greška prilikom unosa pitanja';
$string['importfromcoursefiles'] = '... ili izaberite datoteku kursa za unos';
$string['importfromupload'] = 'Izaberite datoteku za postavljanje';
$string['importingquestions'] = 'Unos {$a} pitanja iz datoteke';
$string['importparseerror'] = 'Pronađena je greška/e u toku parsiranja datoteke koja se unosi. Da biste unijeli pitanja koja su dobra pokušajte ponovo tako što ćete podešavanje \'Zaustavi kada se pojavi greška\' podesiti na \'Ne';
$string['importquestions'] = 'Unesi pitanja iz datoteke';
$string['importquestions_help'] = 'Ova funkcija omogućava da pitanja u različitim formatima budu unesena putem tekstualne datoteke. Imajte u vidu da datoteka mora da koristi UTF-8 kodni format.';
$string['importwrongfiletype'] = 'Tip datoteke koji ste izabrali ({$a->actualtype}) se ne poklapa sa tipom koji očekuje ovaj format unosa ({$a->expectedtype}).';
$string['impossiblechar'] = 'Otkriven je neodgovarajući karakter {$a} kao znak za zagrade';
$string['includesubcategories'] = 'Prikaži i pitanja iz podkategorija';
$string['incorrect'] = 'Netačno';
$string['incorrectfeedback'] = 'Za svaki netačan odgovor';
$string['incorrectfeedbackdefault'] = 'Odgovor nije tačan.';
$string['information'] = 'Informacija';
$string['invalidanswer'] = 'Nepotpun odgovor';
$string['invalidarg'] = 'Nisu dostavljeni ispravni argumenti ili je pogrešna konfiguracija servera';
$string['invalidcategoryidforparent'] = 'Neispravan identifikator nadređene kategorije!';
$string['invalidcategoryidtomove'] = 'Neispravan identifikator kategorije koja se premiješta!';
$string['invalidconfirm'] = 'Izraz za potvrdu je neispravan';
$string['invalidcontextinhasanyquestions'] = 'Neispravan kontekst proslijeđen u  question_context_has_any_questions.';
$string['invalidpenalty'] = 'Neispravna kazna';
$string['invalidwizardpage'] = 'Navedena stranica sa "čarobnjakom" (<i>wizard page</i>) je neispravna ili ne postoji!';
$string['lastmodifiedby'] = 'Posljednji put izmijenio/la';
$string['linkedfiledoesntexist'] = 'Datoteka {$a} do koje vodi link ne postoji';
$string['makechildof'] = 'Napravi potomak od \'{$a}';
$string['makecopy'] = 'Napravi kopiju';
$string['maketoplevelitem'] = 'Pomjeri na najviši nivo';
$string['manualgradeoutofrange'] = 'Ova ocjena je izvan važećeg opsega';
$string['manuallygraded'] = 'Ručno ocijenjeno {$a->mark} sa komentarom: {$a->comment}';
$string['mark'] = 'Ocijeni';
$string['markedoutof'] = 'Maksimalna ocjena';
$string['markedoutofmax'] = 'Maksimalna ocjena {$a}';
$string['markoutofmax'] = 'Ocjena {$a->mark} od {$a->max}';
$string['marks'] = 'Ocjene';
$string['matchgrades'] = 'Upari ocjene';
$string['matchgradeserror'] = 'Greška ako ocjena nije navedena';
$string['matchgrades_help'] = '<p>Unesene ocjene<b>moraju</b> da odgovaraju ocjenama nekih od fiksnih lista sa validnim ocjenama, kao što slijedi...</p> <ul> <li>100%</li> <li>90%</li> <li>80%</li> <li>75%</li> <li>70%</li> <li>66.666%</li> <li>60%</li> <li>50%</li> <li>40%</li> <li>33.333</li> <li>30%</li> <li>25%</li> <li>20%</li> <li>16.666%</li> <li>14.2857</li> <li>12.5%</li> <li>11.111%</li> <li>10%</li> <li>5%</li> <li>0%</li> </ul> <p>takođe su dozvoljene negativne vrijednosti ocjena sa gornje liste.</p> <p>Postoje dva načina podešavanja ovog prekidača. Oni utiču na to kako rutine za unos ocjena tretiraju vrijednosti koje ne odgovaraju <strong>u potpunosti</strong> nekoj od vrijednosti sa gornjeg popisa</p> <ul> <li><strong>Greška ako ocjene nema na listi</strong><br /> Ako pitanje sadrži bilo koju ocjenu koja se ne nalazi na popisu prikazaće se poruka o grešci i takvo pitanje neće biti uneseno.</li> <li><strong>Najbliža ocjena ako ocjene nema na popisu</strong><br /> Ako unesena ocjena ne odgovara ni jednoj sa popisa, onda se ona mijenja u ocjenu sa popisa koja je najbliža po vrijednosti </li> </ul> <p><i>Upozorenje: neki prilagođeni formati za unos direktno upisuju vrijednosti u bazu podataka i mogu preskočiti ovu provjeru</i></p>';
$string['matchgradesnearest'] = 'Najbliža ocjena ako ocjena nije navedena';
$string['missingcourseorcmid'] = 'Print_question zahtjeva courseid ili cmid.';
$string['missingcourseorcmidtolink'] = 'Get_question_edit_link zahtjeva courseid ili cmid.';
$string['missingimportantcode'] = 'Ovom tipu pitanja nedostaje važan kod: {$a}.';
$string['missingoption'] = 'Pitanju tipa Umetnuti odgovori {$a} nedostaju opcije';
$string['modified'] = 'Posljednja izmjena';
$string['move'] = 'Premjesti iz {$a} i promijeni linkove.';
$string['movecategory'] = 'Premjesti kategoriju';
$string['movedquestionsandcategories'] = 'Premještena su pitanja i kategorije pitanja sa {$a->oldplace} na {$a->newplace}.';
$string['movelinksonly'] = 'Samo promijenite destinacije linkova, nemojte premještati niti kopirati datoteke.';
$string['moveq'] = 'Premjesti pitanje(a)';
$string['moveqtoanothercontext'] = 'Premjesti pitanje u drugi kontekst.';
$string['moveto'] = 'Premjesti u >>';
$string['movingcategory'] = 'Premještanje kategorije';
$string['movingcategoryandfiles'] = 'Da li ste sigurni da želite da premjestite kategoriju {$a->name} i sve njoj podređene kategorije u kontekst za "{$a->contextto}"?<br /> Postoji {$a->urlcount} datoteka u vezi sa pitanjima u {$a->fromareaname}. Da li želite da je(ih) kopirate ili premjestite u {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Da li ste sigurni da želite da premjestite kategoriju "{$a->name}" i sve podkategorije u kontekst za "{$a->contextto}"?';
$string['movingquestions'] = 'Premještanje pitanja i svih datoteka';
$string['movingquestionsandfiles'] = 'Da li ste sigurni da želite da premjestite pitanje(a) {$a->questions} u kontekst za <strong>"{$a->tocontext}"</strong>?<br /> Postoji <strong>{$a->urlcount} datoteka</strong> do koje(kojih) vode linkovi iz ovog(ovih) pitanja u {$a->fromareaname}. Da li želite da je(ih) kopirate ili premjestite u {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Da li ste sigurni da želite da premjestite pitanje(a) {$a->questions} u kontekst za <strong>"{$a->tocontext}"</strong>?<br /> <strong>Nema datoteka</strong> povezanih sa njim(a) u {$a->fromareaname}.';
$string['needtochoosecat'] = 'Morate odabrati kategoriju u koju želite da premjestite ovo pitanje ili pritisnuti \'otkaži\'.';
$string['nocate'] = 'Ne postoji kategorija {$a}!';
$string['nopermissionadd'] = 'Nemate odobrenje da dodate pitanje ovdje.';
$string['nopermissionmove'] = 'Nemate dozvole da premještate pitanja odavde. Morate sačuvati pitanje u ovoj kategoriji ili ga sačuvati kao novo pitanje.';
$string['noprobs'] = 'Nije nađen ni jedan problem u vašoj bazi podataka sa pitanjima.';
$string['noquestions'] = 'Nije pronađeno nijedno pitanje koje bi moglo da se prenese. Provjerite da li ste za prenos izabrali kategoriju koja sadrži pitanja.';
$string['noquestionsinfile'] = 'Nema pitanja u datoteci odabranoj za unos';
$string['noresponse'] = '[Nema odgovora]';
$string['notanswered'] = 'Nije odgovoreno';
$string['notchanged'] = 'Nema promjene od poslijednjeg pokušaja';
$string['notenoughanswers'] = 'Ovaj tip pitanja zahtjeva najmanje {$} odgovora';
$string['notenoughdatatoeditaquestion'] = 'Nisu specificirani ni identifikator pitanja, ni identifikator kategorije sa tipom pitanja.';
$string['notenoughdatatomovequestions'] = 'Morate navesti identifikatore pitanja koja želite da premjestite.';
$string['notflagged'] = 'Nije obilježeno';
$string['notgraded'] = 'Nije ocijenjeno';
$string['notshown'] = 'Nije prikazano';
$string['notyetanswered'] = 'Još nije odgovoreno';
$string['notyourpreview'] = 'Ovaj pregled ne pripada vama';
$string['novirtualquestiontype'] = 'Ne postoji virtuelni tip pitanja za pitanje tipa {$a}';
$string['numqas'] = 'Broj pokušaja';
$string['numquestions'] = 'Broj pitanja';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skriven)';
$string['options'] = 'Opcije';
$string['page-question-category'] = 'Stranica kategorije pitanja';
$string['page-question-edit'] = 'Stranica za uređivanje pitanja';
$string['page-question-export'] = 'Stranica za prenos pitanja';
$string['page-question-import'] = 'Stranica za prenos pitanja';
$string['page-question-x'] = 'Bilo koja stranica pitanja';
$string['parent'] = 'Nadređeno';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parentcategory_help'] = 'Nadređena kategorija je ona u koju će nova kategorija biti smještena. "Top" znači da se ta kategorija ne nalazi unutar bilo koje druge kategorije. Konteksti kategorije su prikazani podebljanim slovima. Mora da postoji bar jedna kategorija u svakom kontekstu.';
$string['parenthesisinproperclose'] = 'zagrade prije ** nisu pravilno zatvorene u {$a}*';
$string['parenthesisinproperstart'] = 'zagrade prije ** nisu pravilno otvorene u {$a}*';
$string['parsingquestions'] = 'Parsiranje pitanja iz datoteke za unos.';
$string['partiallycorrect'] = 'Djelimično tačno';
$string['partiallycorrectfeedback'] = 'Za svaki djelimično tačan odgovor';
$string['partiallycorrectfeedbackdefault'] = 'Odgovor je djelimično tačan.';
$string['penaltyfactor'] = 'Kazneni faktor';
$string['penaltyfactor_help'] = '<p>Možete odrediti koji dio postignutog rezultata bi trebalo oduzeti za svaki pogrešan odgovor. Ovo je relevantno samo ukoliko je kviz podešen tako da koristi adaptivni mod koji omogućava studentu da ponavlja odgovore na isto pitanje. Kaznenini faktor treba da bude broj između 0 i 1. Kazneni faktor koji ima vrijednost 1 znači da student mora da tačan odgovor iz prvog puta da bi uopće dobio bodove za pitanje. Kazneni faktor 0 znači da student može da pokušava onoliko puta koliko želi i uvijek će dobiti maskimalan broj bodova.</p>';
$string['penaltyforeachincorrecttry'] = 'Kazneni bodovi za svaki netačan pokušaj';
$string['penaltyforeachincorrecttry_help'] = 'Kada u kvizu koristite pitanje koristeći režim \'Interaktivno sa višestrukim pokušajima\' ili \'Adaptivni režim\', tako da student ima na raspolaganju veći broj pokušaja da tačno odgovori na pitanje, onda ova opcija kontroliše sa koliko bodova će biti kažnjen svaki netačan pokušaj. Kazna predstavlja dio ukupne ocjene za pitanje. Na primjer ako pitanje nosi tri boda, a kazna je 0.3333333, onda će student osvojiti 3 boda ukoliko iz prvog pokušaja tačno odgovori, 2 ako tačno odgovori iz drugog pokušaja i 1 ukoliko je odgovorio tačno u trećem pokušaju.';
$string['permissionedit'] = 'Uredite ovo pitanje';
$string['permissionmove'] = 'Premjestite ovo pitanje';
$string['permissionsaveasnew'] = 'Snimite ovo pitanje kao novo';
$string['permissionto'] = 'Imate dozvolu da:';
$string['previewquestion'] = 'Pregledaj pitanje: {$a}';
$string['published'] = 'objavljeno';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Pitanje "{$a->name}" ({$a->qtype})</a> je u ovoj kategoriji pitanja ali se koristi i u <a href="{$a->qurl}">testu "{$a->quizname}"</a> koji pripada drugom kursu "{$a->coursename}".';
$string['questionbank'] = 'Baza pitanja';
$string['questionbehaviouradminsetting'] = 'Podešavanja ponašanja pitanja';
$string['questionbehavioursdisabled'] = 'Ponašanja pitanja koje želite da onemogućite';
$string['questionbehavioursdisabledexplained'] = 'Unesite popis ponašanja odvojenih zarezima koja ne želite da se pojavljuju u padajućem meniju.';
$string['questionbehavioursorder'] = 'Redoslijed ponašanja pitanja';
$string['questionbehavioursorderexplained'] = 'Unesite popis ponašanja rezdvojenih zarezom onim redoslijedom kojim želite da se ona pojavljuju u padajućem meniju';
$string['questioncategory'] = 'Kategorija pitanja';
$string['questioncatsfor'] = 'Kategorije pitanja za \'{$a}';
$string['questiondoesnotexist'] = 'Ovo pitanje ne postoji';
$string['questionidmismatch'] = 'Nepoklapanje identifikacionih oznaka pitanja';
$string['questionname'] = 'Naziv pitanja';
$string['questionno'] = 'Pitanje {$a}';
$string['questionpreviewdefaults'] = 'Osnovne postavke pregleda pitanja';
$string['questionpreviewdefaults_desc'] = 'Osnovne postavke se koriste pri prvom pristupu korisnika setu pitanja. Nakon što korisnik pregleda pitanje, njegove željene preference se čuvaju kao korisničke preference.';
$string['questions'] = 'Pitanja';
$string['questionsaveerror'] = 'U toku pokušaja da se sačuva pitanje  ({$a}) pojavila se greška';
$string['questionsinuse'] = '(* Pitanja obilježena zvjezdicom su već u upotrebi u nekim kvizovima. Ova pitanje neće biti izbrisana iz tih kvizova, već samo sa popisakategorije.)';
$string['questionsmovedto'] = 'Pitanje koje se još uvijek koristi je premješteno u "{$a}" u okviru nadređene kategorije.';
$string['questionsrescuedfrom'] = 'Pitanje sačuvano iz konteksta {$a}.';
$string['questionsrescuedfrominfo'] = 'Ova pitanja (od kojih neka mogu biti skrivena) sačuvana su kada je kontekst {$a} bio obrisan, zato što se još uvijek koriste u nekim kvizovima ili drugim aktivnostima.';
$string['questiontext'] = 'Tekst pitanja';
$string['questiontype'] = 'Tip pitanja';
$string['questionuse'] = 'Koristi pitanje u ovoj aktivnosti';
$string['questionvariant'] = 'Varijanta pitanja';
$string['questionx'] = 'Pitanje {$a}';
$string['requiresgrading'] = 'Zahtjeva ocjenjivanje';
$string['responsehistory'] = 'Historija odgovora';
$string['restart'] = 'Počnite ponovo';
$string['restartwiththeseoptions'] = 'Počnite ponovo sa ovim opcijama';
$string['reviewresponse'] = 'Pregledaj odgovore';
$string['rightanswer'] = 'Tačan odgovor';
$string['rightanswer_help'] = 'automatski generisani rezime tačnog odgovora. Ovo ima svoja ograničenja, pa ćete možda poželjeti da razmotrite mogućnost da tačan odgovor detaljnije objasnite u općim povratnim informacijama za pitanje, a ovu opciju isključite.';
$string['save'] = 'Sačuvaj';
$string['saved'] = 'Sačuvano: {$a}';
$string['saveflags'] = 'Sačuvaj stanje inditkatora (zastavica)';
$string['selectacategory'] = 'Izaberi kategoriju';
$string['selectaqtypefordescription'] = 'Izaberi tip pitanja da bi se vidio njegov opis';
$string['selectcategoryabove'] = 'Izaberite kategoriju od gore navedenih';
$string['selectquestionsforbulk'] = 'Izaberi pitanja za masovne operacije';
$string['settingsformultipletries'] = 'Podešavanja za višestruke pokušaje';
$string['shareincontext'] = 'Podijeli u kontekstu za {$a}';
$string['showhidden'] = 'Prikaži i stara pitanja';
$string['showmarkandmax'] = 'Prikaži maksimalnu ocjenu';
$string['showmaxmarkonly'] = 'Prikaži samo maksimalnu ocjenu';
$string['shown'] = 'Prikazano';
$string['shownumpartscorrect'] = 'Prikaži broj tačnih odgovora';
$string['shownumpartscorrectwhenfinished'] = 'Prikaži broj tačnih odgovora';
$string['showquestiontext'] = 'Prikaži tekst pitanja na popisu pitanja';
$string['specificfeedback'] = 'Specifične povratne informacije';
$string['specificfeedback_help'] = 'Povratna informacija koja zavisi od odgovora koji je student dao';
$string['started'] = 'Započeto';
$string['state'] = 'Stanje';
$string['step'] = 'Korak';
$string['stoponerror'] = 'Zaustavi kada se pojavi greška';
$string['stoponerror_help'] = 'Ovo podešavanje određuje da li se proces unosa zaustavlja kada se otkrije greška, što će rezultirati time da nijedno pitanje neće biti unoseno, ili se pitanja sa greškom ignorišu dok se sva ispravna pitanja unose.';
$string['submissionoutofsequence'] = 'Pristup van redoslijeda. Molimo vas, nemojte da klikate na dugme \'Nazad\' kada odgovarate na pitanja sa kviza.';
$string['submissionoutofsequencefriendlymessage'] = 'Unijeli ste podatke van normalnog redoslijeda. To se može desiti ako koristite dugmad \'Nazad\' (Back) ili \'Naprijed\' (Forward) u svom Web pretraživaču. Molimo vas da ih ne koristite tokom kviza. Ovo se, takođe, može dogoditi ako kliknete na nešto dok se stranica učitava. Kako biste nastavili kliknite na <strong>Nastavi</strong>.';
$string['submit'] = 'Predaj';
$string['submitandfinish'] = 'Predaj i završi';
$string['submitted'] = 'Predaj: {$a}';
$string['technicalinfo'] = 'Tehničke informacije';
$string['technicalinfo_help'] = 'Ove tehničke informacije su vjerovatno korisne samo programerima koji rade na razvoju novih tipova pitanja. Takođe, mogu biti korisne kada se pokušava da dijagnostikuje problem sa pitanjima.';
$string['technicalinfominfraction'] = 'Minimalni dio: {$a}';
$string['technicalinfoquestionsummary'] = 'Rezime pitanja: {$a}';
$string['technicalinforightsummary'] = 'Rezime tačnog odgovora: {$a}';
$string['technicalinfostate'] = 'Stanje pitanja: {$a}';
$string['tofilecategory'] = 'Upiši kategoriju u datoteku';
$string['tofilecontext'] = 'Upiši kontekst u datoteku';
$string['uninstallbehaviour'] = 'Reinstaliraj ovo ponašanje pitanja';
$string['uninstallqtype'] = 'Reinstaliraj ovaj tip pitanja';
$string['unknown'] = 'Nepoznato';
$string['unknownbehaviour'] = 'Nepoznato ponašanje: {$a}.';
$string['unknownquestion'] = 'Nepoznato pitanje: {$a}.';
$string['unknownquestioncatregory'] = 'Nepoznata kategorija pitanja: {$a}.';
$string['unknownquestiontype'] = 'Nepoznat tip pitanja: {$a}.';
$string['unknowntolerance'] = 'Nepoznata vrsta tolerancije {$}';
$string['unpublished'] = 'neobjavljeno';
$string['upgradeproblemcategoryloop'] = 'Otkriven je problem pri pokušaju ažuriranja kategorija pitanja. Postoji petlja u stablu kategorija. Pogođene su time kategorije sa id vrednostima {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nije moguće ažurirati kategoriju pitanja {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Otkriven je problem pri pokušaju ažuriranja kategorija pitanja. Kategorija {$a->id} ukazuje na nadređenu kategoriju {$a->parent}, koja ne postoji. Promijeni nadređenu kategoriju da bi se riješio problem.';
$string['whethercorrect'] = 'Da li je odgovor tačan';
$string['whethercorrect_help'] = 'Ovo pokriva kako tekstualni opis tipa \'Tačno\', \'Djelimično tačno\' ili \'Netačno\', tako i svaki bojom istaknut tekst koji nosi istu informaciju';
$string['withselected'] = 'Sa odabranim';
$string['wrongprefix'] = 'Pogrešno formatiran nameprefix {$a}';
$string['xoutofmax'] = '{$a->mark} od {$a->max}';
$string['yougotnright'] = 'Ispravno ste izabrali {$a->num}.';
$string['youmustselectaqtype'] = 'Morate da izaberete tip pitanja.';
$string['yourfileshoulddownload'] = 'Vaša datoteka za prenos - trebalo bi da uskoro započne preuzimanje. U suprotnom, molimo <a href="{$a}">kliknite ovdje</a>.';
