<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'uskoro će biti instalirano';
$string['action'] = 'Akcija';
$string['actionchoice'] = 'Šta želite da uradite sa datotekom \'{$a}\'?

&strings=1';
$string['actions'] = 'Akcije';
$string['active'] = 'Aktivan';
$string['activeusers'] = 'Aktivni korisnici';
$string['activities'] = 'Aktivnosti';
$string['activities_help'] = 'Aktivnosti, kao što su forumi, kvizovi i wiki dokumenti omogućavaju da kursu bude dodan interaktivni sadržaj.';
$string['activity'] = 'Aktivnost';
$string['activityclipboard'] = 'Premještanje ove aktivnosti: {$a}';
$string['activityiscurrentlyhidden'] = 'Žao nam je, ova aktivnost trenutno nije dostupna';
$string['activitymodule'] = 'Modul aktivnosti';
$string['activitymodules'] = 'Moduli aktivnosti';
$string['activityreport'] = 'Izvještaj o aktivnosti';
$string['activityreports'] = 'Izvještaji o aktivnostima';
$string['activityselect'] = 'Odaberite ovu aktivnost kako biste je premjestili na drugo mjesto';
$string['activitysince'] = 'Aktivnost od {$a}';
$string['activityweighted'] = 'Aktivnost po korisniku';
$string['add'] = 'Dodaj';
$string['addactivity'] = 'Dodaj aktivnost...';
$string['addadmin'] = 'Dodaj administratora';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentar...';
$string['addcountertousername'] = 'Kreiraj korisnika dodavanjem broja korisničkom imenu';
$string['addcreator'] = 'Dodaj kreatora kursa';
$string['adddots'] = 'Dodaj...';
$string['added'] = 'Dodano';
$string['addedrecip'] = 'Broj novih primatelja: {$a}';
$string['addedrecips'] = 'Broj novih primatelja: {$a}';
$string['addedtogroup'] = 'Dodan(а) grupi {$a}';
$string['addedtogroupnot'] = 'Nije dodan(а) grupi {$a}';
$string['addedtogroupnotenrolled'] = 'Nije dodan(a) grupi {$a}, jer nije upisan(a) na kurs';
$string['addfilehere'] = 'Dodaj datoteku/e ovdje';
$string['addinganew'] = 'Dodavanje novog: {$a}';
$string['addinganewto'] = 'Dodavanje novog {$a->what} u {$a->to}';
$string['addingdatatoexisting'] = 'Dodavanje podataka postojećim';
$string['additionalnames'] = 'Dodatna imena';
$string['addlinkhere'] = 'Dodaj link ovdje';
$string['addnewcategory'] = 'Dodaj novu kategoriju';
$string['addnewcourse'] = 'Dodaj novi kurs';
$string['addnewuser'] = 'Dodaj novog korisnika';
$string['addnousersrecip'] = 'Dodavanje korisnika koji nisu pristupili ovome {$a} na listu primatelja';
$string['addpagehere'] = 'Dodaj stranicu ovdje';
$string['addresource'] = 'Dodaj resurs...';
$string['addresourceoractivity'] = 'Dodaj aktivnost ili resurs';
$string['addresourcetosection'] = 'Dodaj resurs sekciji \'{$a}';
$string['address'] = 'Adresa';
$string['addstudent'] = 'Dodaj studenta';
$string['addsubcategory'] = 'Dodaj podkategoriju';
$string['addteacher'] = 'Dodaj predavača';
$string['admin'] = 'Administracija';
$string['adminhelpaddnewuser'] = 'Ručno kreiranje novog korisničkog računa';
$string['adminhelpassignadmins'] = 'Administratori imaju potpuna ovlaštenja na ovom sajtu';
$string['adminhelpassigncreators'] = 'Kreatori mogu kreirati nove kurseve';
$string['adminhelpassignsiteroles'] = 'Primjena definiranih uloga na stranici na specifične korisnike';
$string['adminhelpassignstudents'] = 'Idite na kurs i dodajte nove studente iz administratorskog menija';
$string['adminhelpauthentication'] = 'Možete koristiti interne korisničke račune ili eksterne baze podataka';
$string['adminhelpbackup'] = 'Uobličite automatsko kreiranje rezervnih kopija i vremenski raspored njihovog izvršavanja';
$string['adminhelpconfiguration'] = 'Uobličite kako sajt izgleda i funkcionira';
$string['adminhelpconfigvariables'] = 'Uobličite varijable koje utiču na opću funkcionalnost sajta';
$string['adminhelpcourses'] = 'Odredite kurseve i kategorije i upišite polaznike u njih, uredite kurseve na čekanju';
$string['adminhelpeditorsettings'] = 'Definirajte osnovna podešavanja HTML editora';
$string['adminhelpedituser'] = 'Pretražite listu korisničkih računa i uredite bilo koji od njih';
$string['adminhelpenvironment'] = 'Provjerite kako Vaš server zadovoljava trenutne i buduće preduslove za uspješnu instalaciju';
$string['adminhelpfailurelogs'] = 'Pregledajte zapise o neuspješnim prijavama na sistem';
$string['adminhelplanguage'] = 'Provjera i uređivanje važećeg jezičkog paketa';
$string['adminhelplogs'] = 'Pregledajte zapise o svim aktivnostima na sajtu';
$string['adminhelpmanageblocks'] = 'Upravljanje instaliranim blokovima i njihovim podešavanjima';
$string['adminhelpmanagedatabase'] = 'Direktno pristupite bazi podataka (budite oprezni!)';
$string['adminhelpmanagefilters'] = 'Izbor tekst filtera i njihova podešavanja';
$string['adminhelpmanagemodules'] = 'Upravljanje instaliranim modulima i njihovim podešavanjima';
$string['adminhelpmanageroles'] = 'Kreiranje i defininiranje uloga koje se mogu primjeniti na korisnike';
$string['adminhelpmymoodle'] = 'Uobličite "My Moodle" blokove za korisnike';
$string['adminhelpreports'] = 'Izvještaji na nivou sajta';
$string['adminhelpsitefiles'] = 'Služi za objavljivanje općih datoteka ili postavljanje rezervnih kopija';
$string['adminhelpsitesettings'] = 'Definirajte kako izgleda početna stranica sajta';
$string['adminhelpstickyblocks'] = 'Uobličite fiksne blokove na čitavom sajtu';
$string['adminhelpthemes'] = 'Odaberite kako da izgleda sajt (boje, fontovi i sl.)';
$string['adminhelpuploadusers'] = 'Unesite nove korisničke račune iz tekstualne datoteke';
$string['adminhelpusers'] = 'Odredite svoje korisnike i podesite način provjere identiteta';
$string['adminhelpxmldbeditor'] = 'Interface za uređivanje XMLDB datoteka. Samo za korisnike sa uređivačkim pravima.';
$string['administration'] = 'Administracija';
$string['administrationsite'] = 'Administracija sajta';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratori obično mogu da rade šta god žele u okviru sajta, na bilo kom kursu.';
$string['administrators'] = 'Administratori';
$string['administratorsall'] = 'Svi administratori';
$string['administratorsandteachers'] = 'Administratori i predavači';
$string['advanced'] = 'Napredno';
$string['advancedfilter'] = 'Napredno pretraživanje';
$string['advancedsettings'] = 'Napredna podešavanja';
$string['again'] = 'ponovo';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX i Javascript';
$string['all'] = 'Sve';
$string['allactions'] = 'Sve akcije';
$string['allactivities'] = 'Sve aktivnosti';
$string['allcategories'] = 'Sve kategorije';
$string['allchanges'] = 'Sve promjene';
$string['alldays'] = 'Svi dani';
$string['allfieldsrequired'] = 'Sva polja su obavezna';
$string['allfiles'] = 'Sve datoteke';
$string['allgroups'] = 'Sve grupe';
$string['alllogs'] = 'Svi zapisi o aktivnostima';
$string['allmods'] = 'Svi {$a}';
$string['allow'] = 'Dozvoliti';
$string['allowinternal'] = 'Dozvoliti i interne načine također';
$string['allownone'] = 'Ne dozvoliti ništa';
$string['allownot'] = 'Ne dozvoliti';
$string['allparticipants'] = 'Svi učesnici';
$string['allteachers'] = 'Svi predavači';
$string['alphanumerical'] = 'Može jedino da sadrži alfanumeričke karaktere (slova i brojeve), crticu (-) ili tačku (.)';
$string['alreadyconfirmed'] = 'Registracija je već potvrđena';
$string['alternatename'] = 'Alternativno ime';
$string['always'] = 'Uvijek';
$string['and'] = '{$a->one} i {$a->two}';
$string['answer'] = 'Odgovor';
$string['any'] = 'Bilo koje';
$string['appearance'] = 'Izgled';
$string['approve'] = 'Odobriti';
$string['areyousuretorestorethis'] = 'Želite li da nastavite?';
$string['areyousuretorestorethisinfo'] = 'Tokom ovog postupka moći ćete odabrati da li želite da dodate ovu datoteku sa rezervnim kopijama već postojećem kursu ili da kreirate potpuno novi kurs.';
$string['asc'] = 'Rastući';
$string['assessment'] = 'Procjena';
$string['assignadmins'] = 'Određivanje administratora';
$string['assigncreators'] = 'Određivanje kreatora';
$string['assignsiteroles'] = 'Određivanje uloga na nivou sajta';
$string['authenticateduser'] = 'Identificirani korisnik';
$string['authenticateduserdescription'] = 'Svi prijavljeni korisnici.';
$string['authentication'] = 'Provjera identiteta';
$string['authenticationplugins'] = 'Dodaci za autentifikaciju';
$string['autosubscribe'] = 'Automatska prijava na forum';
$string['autosubscribeno'] = 'Ne želim automatsku prijavu na forume';
$string['autosubscribeyes'] = 'Da, kad pošaljem poruku, upišite me u taj forum';
$string['availability'] = 'Dostupnost';
$string['availablecourses'] = 'Dostupni kursevi';
$string['back'] = 'Nazad';
$string['backto'] = 'Nazad na {$a}';
$string['backtocourselisting'] = 'Povratak na popis kurseva';
$string['backtopageyouwereon'] = 'Povratak na stranicu na kojoj ste bili';
$string['backtoparticipants'] = 'Povratak na popis učesnika';
$string['backup'] = 'Kreiranje rezervne kopije';
$string['backupactivehelp'] = 'Odaberite da li treba ili ne automatski kreirati rezervne kopije.';
$string['backupcancelled'] = 'Kreiranje rezervne kopije je otkazano';
$string['backupcoursefileshelp'] = 'Ako je ovo podešavanje omogućeno,  datoteke kursa će biti uključene u automatski kreirane rezervne kopije';
$string['backupdate'] = 'Datum kreiranja rezervne kopije';
$string['backupdatenew'] = '&nbsp; {$a->TAG} je sada {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} je bio {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalji o rezervnoj kopiji';
$string['backupexecuteathelp'] = 'Odaberite vrijeme za automatsko kreiranje rezervnih kopija.';
$string['backupfailed'] = 'Neki od Vaših kurseva nisu sačuvani!';
$string['backupfilename'] = 'rezervna kopija';
$string['backupfinished'] = 'Kreiranje rezervne kopije je uspješno završeno';
$string['backupfromthissite'] = 'Da li je rezervna kopija kreirana na ovom sajtu?';
$string['backupgradebookhistoryhelp'] = 'Ako je ovo podešavanje omogućeno, onda će historija knjige ocjena biti uključena u automatsku rezervnu kopiju. Imajte u vidu, da historija ocjena ne smije biti onemogućena u podešavanjima servera (disablegradehistory) kako bi ovo moglo da funkcionira.';
$string['backupincludemoduleshelp'] = 'Odaberite želite li u automatsku proceduru kreiranja rezervnih kopija da uključite i module kursa, sa ili bez korisničkih podataka';
$string['backupincludemoduleuserdatahelp'] = 'Odaberite da li želite da uključite podatke korisnika modula u automatski kreirane rezervne kopije.';
$string['backupkeephelp'] = 'Koliki broj nedavnih rezervnih kopija za svaki kurs želite da čuvate? (Starije kopije biće automatski obrisane po isteku navedenog roka)';
$string['backuplogdetailed'] = 'Detaljni izvještaj o izvršavanju';
$string['backuploglaststatus'] = 'Izvještaj o posljednjem izvršavanju';
$string['backupmissinguserinfoperms'] = 'Napomena: Ova rezervna kopija podataka ne sadrži korisničke podatke. Aktivnosti kao što su "Vježba" i "Radionica" neće biti uključene u rezervnu kopiju, obzirom da ovi moduli nisu kompatibilni sa ovim tipom rezervne kopije podataka.';
$string['backupnext'] = 'Sljedeća rezervna kopija';
$string['backupnonisowarning'] = 'Upozorenje: ova rezervna kopija je kreirana u verziji Moodle sistema koja nije podržavala Unicode (prije verzije 1.6). Ako ova rezervna kopija sadrži tekstove koji se ne slažu sa ISO-8859-1 može biti OŠTEĆENA ako pokušate da je restaurirate u ovoj Unicode Moodle verziji. Pogledajte <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>za više informacija o tome kako da pravilno uradite oporavak ove rezervne kopije.';
$string['backupnotyetrun'] = 'Automatska rezervna kopija na čekanju';
$string['backuporiginalname'] = 'Naziv rezervne kopije';
$string['backuproleassignments'] = 'Napravi rezervnu kopiju dodjele ovih uloga';
$string['backupsavetohelp'] = 'Cijeli put do direktorija u kojem želite da sačuvate datoteke sa rezervnim kopijama<br /> (ostavite ovo polje prazno kako biste podatke sačuvali u zadani direktorij za čuvanje svih podataka vezanih za ovaj kurs)';
$string['backupsitefileshelp'] = 'Ako je ovo podešavanje omogućeno, onda će datoteke sajta korištene u kursevima biti uključene u automatsku rezervnu kopiju.';
$string['backuptakealook'] = 'Molimo pogledajte zapise o kreiranju vaših rezervnih kopija u: {$a}';
$string['backupuserfileshelp'] = 'Odaberite da li bi trebalo da se korisničke datoteke (npr. slike za lične profile korisnika) uključe u automatski kreirane rezervne kopije';
$string['backupversion'] = 'Verzija rezervne kopije';
$string['badges'] = 'Bedževi';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurisanje bloka {$a}';
$string['blockconfigbad'] = 'Ovaj blok nije pravilno implementiran i zato ne možete koristiti konfiguracijski interfejs.';
$string['blocks'] = 'Blokovi';
$string['blocksaddedit'] = 'Dodaj/Uredi blokove';
$string['blockseditoff'] = 'Uređivanje blokova je isključeno';
$string['blocksediton'] = 'Uređivanje blokova je uključeno';
$string['blocksetup'] = 'Podešavanje tabela blokova';
$string['blocksuccess'] = '{$a} tabela je ispravno podešena';
$string['brief'] = 'Ukratko';
$string['bulkactions'] = 'Bulk akcije';
$string['bulkactionselect'] = '{$a} odabir bulk akcije';
$string['bulkmovecoursessuccess'] = 'Kursevi {$a->courses} su uspješno premješteni u {$a->category}';
$string['bycourseorder'] = 'Poredak po kursevima';
$string['byname'] = 'od {$a}';
$string['bypassed'] = 'Izbjegnuto';
$string['cachecontrols'] = 'Cache kontrole';
$string['cancel'] = 'Odustani';
$string['cancelled'] = 'Otkazano';
$string['categories'] = 'Kategorije kurseva';
$string['categoriesandcoures'] = 'Kategorije kurseva i kursevi';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Dodana je kategorija \'{$a}';
$string['categorybulkaction'] = 'Bulk akcije za odabrane kategorije';
$string['categorycontents'] = 'Podkategorije i kursevi';
$string['categorycurrentcontents'] = 'Sadržaji kategorije {$a}';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je izbrisana';
$string['categoryduplicate'] = 'Kategorija pod nazivom \'{$a}\' već postoji';
$string['categorymodifiedcancel'] = 'Kategorija je izmjenjena! Molimo Vas da izađete i pokušate ponovo.';
$string['categoryname'] = 'Naziv kategorije';
$string['categorysubcategoryof'] = '{$a->category} - podkategorija od {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorija \'{$a}\' je ažurirana';
$string['changedpassword'] = 'Šifra je promijenjena';
$string['changepassword'] = 'Promjena šifre';
$string['changesmadereallygoaway'] = 'Napravili ste promjene. Da li ste sigurni da želite da odete i izgubite svoje promjene?';
$string['changessaved'] = 'Promjene su sačuvane';
$string['check'] = 'Provjeri';
$string['checkall'] = 'Provjeri sve';
$string['checkingbackup'] = 'Provjera rezervne kopije';
$string['checkingcourse'] = 'Provjera kursa';
$string['checkingforbbexport'] = 'Provjera BlackBoard prenesenih podataka';
$string['checkinginstances'] = 'Provjera instanci';
$string['checkingsections'] = 'Provjera sekcija';
$string['checklanguage'] = 'Provjera jezika';
$string['checknone'] = 'Bez provjera';
$string['childcoursenotfound'] = 'Podređeni kurs nije pronađen!';
$string['childcourses'] = 'Podređeni kursevi';
$string['choose'] = 'Odaberi';
$string['choosecourse'] = 'Izbor kursa';
$string['choosedots'] = 'Odaberi...';
$string['chooselivelogs'] = 'Ili nadgledajte trenutnu aktivnost';
$string['chooselogs'] = 'Odaberite koje zapise (logove) želite vidjeti';
$string['choosereportfilter'] = 'Izbor filtera za izvještaj';
$string['choosetheme'] = 'Odaberite temu';
$string['chooseuser'] = 'Izbor korisnika';
$string['city'] = 'Mjesto';
$string['clambroken'] = 'Vaš administrator je uključio antivirusnu provjeru prilikom dodavanja datoteka, ali je nažalost nešto pogrešno konfigurisao.<br /> Dodavanje Vaše datoteke NIJE bilo uspješno. Administratoru je upućena automatska e-mail poruka i očekujemo njegove ispravke podešavanja. <br /> Molimo pokušajte učitavanje datoteke kasnije.';
$string['clamdeletedfile'] = 'Datoteka je izbrisana';
$string['clamdeletedfilefailed'] = 'Datoteka nije mogla biti izbrisana';
$string['clamemailsubject'] = '{$a} :: Clam AV obavještenje';
$string['clamfailed'] = 'Clam AV se nije mogao pokrenuti. Obavještenje o grešci je sljedeće: {$a}. Slijedi Clam AV izlaz:';
$string['clamlost'] = 'Moodle je konfigurisan tako da provjerava postavljanje datoteka sa Clam AV alatom, ali podešena putanja ({$a}) do Clam AV alata je neispravna.';
$string['clamlostandactinglikevirus'] = 'Pored toga, Moodle je konfigurisan tako da ukoliko Clam AV ne uspije da bude pokrenut, datoteke će biti tretirane kao virusi. Ovo u praksi znači da NIJEDAN student ne može poslati datoteku na server sve dok ne riješite ovaj problem.';
$string['clammovedfile'] = 'Datoteka je premještena u specificirani karantinski direktorij, nova lokacija je {$a}';
$string['clammovedfilebasic'] = 'Datoteka je premještena u karantinski direktorij.';
$string['clamquarantinedirfailed'] = 'Nije bilo moguće premjestiti datoteku u specificirani karantinski direktorij {$a}. Trebali biste ovo popraviti jer se datoteke automatski brišu ako su prepoznate kao zaražene.';
$string['clamunknownerror'] = 'Nepoznata greška pri korištenju Clam-a.';
$string['cleaningtempdata'] = 'Brisanje privremenih podataka';
$string['clear'] = 'Izbriši';
$string['clickhelpiconformoreinfo'] = '... nastavlja se... Kliknite na ikonicu za pomoć kako biste pročitali cijeli članak';
$string['clickhere'] = 'Klikni ovdje ...';
$string['clicktochangeinbrackets'] = '{$a} (Klikni za promjenu)';
$string['clicktohideshow'] = 'Kliknite da biste raširili ili skupili';
$string['closewindow'] = 'Zatvorite ovaj prozor';
$string['collapse'] = 'Skupi';
$string['collapseall'] = 'Skupi sve';
$string['collapsecategory'] = 'Skupi {$a}';
$string['commentincontext'] = 'Pronađi ovaj komentar u kontekstu';
$string['comments'] = 'Komentari';
$string['commentsnotenabled'] = 'Komentarisanje nije omogućeno';
$string['commentsrequirelogin'] = 'Potrebno je da se prijavite na sistem kako biste vidjeli komentare';
$string['comparelanguage'] = 'Uporedite i uredite trenutno odabrani jezik';
$string['complete'] = 'Potpuno';
$string['completereport'] = 'Potpuni izvještaj';
$string['configuration'] = 'Konfiguracija';
$string['confirm'] = 'Potvrdi';
$string['confirmcheckfull'] = 'Da li ste apsolutno sigurni da želite da potvrdite {$a}?';
$string['confirmcoursemove'] = 'Da li ste sigurni da želite premjestiti ovaj kurs ({$a->course}) u ovu kategoriju ({$a->category})?';
$string['confirmed'] = 'Vaša registracija je potvrđena';
$string['confirmednot'] = 'Vaša registracija još nije potvrđena!';
$string['content'] = 'Sadržaj';
$string['continue'] = 'Nastavak';
$string['continuetocourse'] = 'Kliknite ovdje da biste ušli na svoj kurs';
$string['convertingwikitomarkdown'] = 'Pretvaranje wiki formata u Markdown format';
$string['cookiesenabled'] = 'Vaš Web pretraživač mora imati omogućene "kolačiće"';
$string['cookiesenabled_help'] = 'Na ovom sajtu se koriste dva "kolačića" (<i>cookies</i>): Osnovni "kolačić" sesije (<i>session cookie</i>) se obično zove MoodleSession. U vašem Web pretraživaču morate dozvoliti upotrebu ovog "kolačića", kako biste osigurali kontinuiranu prijavu na sistem pri prelasku sa jedne na drugu stranicu sajta. Kada se odjavite sa sistema ili zatvorite Web pretraživač "kolačić" se uništava (i u vašem Web pretraživaču i na serveru). Drugi "kolačić" je tu zbog praktičnosti u radu i obično se naziva MOODLEID. On samo pamti vaše korisničko ime unutar Web pretraživača. To znači, da će, kada se vratite na ovaj sajt, polje za unos korisničkog imena na stranicu za prijavu, automatski biti popunjeno Vašim korisničkim imenom. Iz razloga sigurnosti (posebno kada Internetu pristupate sa javnog računara) bolje je da odbijete ovaj "kolačić" - u tom slučaju ćete morati da unesete svoje korisničko ime svaki put kada se budete prijavljivali na sistem.';
$string['cookiesnotenabled'] = 'Nažalost, "kolačići" nisu omogućeni u Vašem Web pretraživaču';
$string['copy'] = 'kopirati';
$string['copyasnoun'] = 'kopija';
$string['copyingcoursefiles'] = 'Kopiranje datoteka kursa';
$string['copyingsitefiles'] = 'Kopiranje datoteka sa sajta koji su korišteni u kursu';
$string['copyinguserfiles'] = 'Kopiranje korisničkih datoteka';
$string['copyingzipfile'] = 'Kopiranje zip datoteka';
$string['copyrightnotice'] = 'Napomena o zaštiti autorskih prava';
$string['coresystem'] = 'Sistem';
$string['cost'] = 'Cijena';
$string['costdefault'] = 'Zadana cijena';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Država';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Administracija kursa';
$string['courseapprovedemail'] = 'Zahtjev za kursom, {$a->name}, koji ste podnijeli je odobren, kurs je kreiran i Vama je dodijeljena sljedeća uloga na njemu: {$a->teacher}. Da biste pristupili svom novom kursu, idite na {$a->url}';
$string['courseapprovedemail2'] = 'Kurs koji ste tražili, {$a->name}, je odobren. Da biste pristupili Vašem novom kursu idite na {$a->url}';
$string['courseapprovedfailed'] = 'Nije uspjelo spremanje kursa onako kako je odobreno!';
$string['courseapprovedsubject'] = 'Vaš kurs je odobren!';
$string['courseavailable'] = 'Ovaj kurs je dostupan studentima';
$string['courseavailablenot'] = 'Ovaj kurs nije dostupan studentima';
$string['coursebackup'] = 'Rezervna kopija kursa';
$string['coursebulkaction'] = 'Bulk akcije za odabrane kurseve';
$string['coursecategories'] = 'Kategorije kurseva';
$string['coursecategory'] = 'Kategorija kursa';
$string['coursecategorydeleted'] = 'Izbrisana kategorija {$a}';
$string['coursecategory_help'] = 'Ova opcija određuje kategoriju u kojoj će se kurs pojavljivati na listi kurseva.';
$string['coursecatmanagement'] = 'Upravljanje kursevima i kategorijama';
$string['coursecompletion'] = 'Kompletiranost kursa';
$string['coursecompletions'] = 'Kompletiranost kurseva';
$string['coursecreators'] = 'Kreatori kursa';
$string['coursecreatorsdescription'] = 'Kreatori kurseva mogu da kreiraju nove kurseve.';
$string['coursedeleted'] = 'Izbrisan kurs {$a}';
$string['coursedisplay'] = 'Prelom stranice kursa';
$string['coursedisplay_help'] = 'Ova podešavanje određuje da li će cijeli kurs biti prikazan na jednoj stranici ili će biti podijeljen na nekoliko stranica. Podešavanje nema uticaja na neke formate kursa, kao što je SCORM format.';
$string['coursedisplay_multi'] = 'Prikaži jednu sekciju po stranici';
$string['coursedisplay_single'] = 'Prikaži sve sekcije na jednoj stranici';
$string['coursefiles'] = 'Naslijeđene datoteke kursa';
$string['coursefilesedit'] = 'Uredi naslijeđene datoteke kursa';
$string['coursefileswarning'] = 'Datoteke kursa su zastarjele';
$string['coursefileswarning_help'] = 'Opcija \'Datoteke kursa\' se ne koristi od verzije Moodle 2.0, Molimo da umjesto toga koristite vanjske repozitorije što je više moguće.';
$string['courseformatdata'] = 'Formati podataka kursa';
$string['courseformatoptions'] = 'Opcije formatiranja za {$a}';
$string['courseformats'] = 'Formati kursa';
$string['courseformatudpate'] = 'ažuriraj format';
$string['coursegrades'] = 'Ocjene na kursu';
$string['coursehelpcategory'] = 'Postavite kurs na popis kurseva tako da studenti mogu lakše da ga pronađu.';
$string['coursehelpforce'] = 'Obavezan grupni mod za sve aktivnosti na kursu';
$string['coursehelpformat'] = 'Glavna stranica kursa će biti prikazana u ovom formatu.';
$string['coursehelphiddensections'] = 'Kako će skrivene sekcije kursa biti prikazane studentima';
$string['coursehelpmaximumupload'] = 'Odredite maksimalnu veličinu datoteke koja se može postaviti u okviru kursa. Ova veličina je ograničena podešavanjem na nivou sajta.';
$string['coursehelpnewsitemsnumber'] = 'Broj najnovijih vijesti koje će se pojaviti na početnoj stranici kursa, u bloku Vijesti (0 znači da se blok sa najnovijim vijestima neće pojaviti ).';
$string['coursehelpnumberweeks'] = 'Broj sedmica/tema prikazanih na naslovnoj stranici kursa';
$string['coursehelpshowgrades'] = 'Omogući prikaz knjige sa ocjenama. Ovo ne sprječava da ocjene budu prikazane unutar pojedinačnih aktivnosti.';
$string['coursehidden'] = 'Ovaj kurs trenutno nije dostupan studentima';
$string['courseinfo'] = 'Informacije o kursu';
$string['courselegacyfiles'] = 'Izvorne datoteke kursa';
$string['courselegacyfiles_help'] = 'Područje datoteka kursa osigurava određenu kompatibilnost sa Moodle 1.9 i starijim verzijama. Sve datoteke u ovom području uvijek su dostupne svim učesnicima kursa (neovisno od toga da li su povezani sa kursom ili ne) i ne postoji način da se sazna gdje je bilo koja od ovih datoteka korištena u Moodle. Ako ovo područje koristite da bi ste u njemu čuvali datoteke kursa, možete sebe da izložite brojnim problemima koji se tiču privatnosti i sigurnosti sistema. Isto tako može doći do gubitka datoteka pri kreiranju rezervnih kopija, unosu podataka iz jednog u drugi kurs, kao i svaki put kada sadržaj dijelite ili ponovo koristite. Zbog toga preporučujemo da ne koristite ovo područje, osim ako niste sasvim sigurni da znate šta radite. Dole navedeni link pruža više informacije o svemu ovome, i pokazati će Vam bolje načine za rad sa datotekama u Moodleu 2.';
$string['courselegacyfilesofcourse'] = 'Izvorne datoteke kursa: {$a}';
$string['coursemessage'] = 'Slanje poruke korisnicima kursa';
$string['coursenotaccessible'] = 'Kurs ne dozvoljava javni pristup';
$string['courseoverview'] = 'Pregled kursa';
$string['courseoverviewfiles'] = 'Datoteke sažetka kursa';
$string['courseoverviewfilesext'] = 'Ekstenzije datoteka sažetka kursaa';
$string['courseoverviewfiles_help'] = 'Datoteke sažetka kursa, kao što su slike, su prikazane na listi kurseva skupa sa sažetkom';
$string['courseoverviewfileslimit'] = 'Limit datoteka sažetka kursaa';
$string['courseoverviewgraph'] = 'Pregled grafikona kursa';
$string['courseprofiles'] = 'Profili kursa';
$string['coursereasonforrejecting'] = 'Vaši razlozi za odbijanje ovog zahtjeva';
$string['coursereasonforrejectingemail'] = 'Ovo će biti poslano e-mailom podnositelju zahtjeva.';
$string['coursereject'] = 'Odbacite zahtjev kursa';
$string['courserejected'] = 'Kurs je odbijen i podnositelj zahtjeva je obaviješten o tome.';
$string['courserejectemail'] = 'Žao nam je, ali Vaš zahtjev za kurs je odbijen. Evo datog obrazloženja: {$a}';
$string['courserejectreason'] = 'Navedite Vaše razloge za odbijanje ovog kursa<br />(ovo će biti poslano e-mail porukom podnositelju zahtjeva)';
$string['courserejectsubject'] = 'Vaš kurs je odbijen';
$string['coursereport'] = 'Izvještaj o kursu';
$string['coursereports'] = 'Izvještaji kursa';
$string['courserequest'] = 'Zahtjev za pokretanje novog kursa';
$string['courserequestdetails'] = 'Detaljnije informacije o kursu čije pokretanje tražite';
$string['courserequestfailed'] = 'Iz nekog razloga nije moguće sačuvati Vaš zahtjev za pokretanje kursa';
$string['courserequestintro'] = 'Upotrijebite ovaj obrazac kako bi ste zatražili da bude kreiran novi kurs za Vas.<br />Pokušajte da popunite obrazac sa što više informacija, kako bi ste pomogli<br />administratorima da bolje razumiju Vaše razloge zbog kojih želite ovaj kurs.';
$string['courserequestreason'] = 'Razlozi za pokretanje ovog kursa';
$string['courserequestsuccess'] = 'Vaš zahtjev za pokretanje novog kursa uspješno je sačuvan. U toku nekoliko narednih dana možete očekivati e-mail poruku sa odgovorom na Vaš zahtjev.';
$string['courserequestsupport'] = 'Dodatne informacije koje će pomoći administratoru da procjeni ovaj zahtjev';
$string['courserestore'] = 'Vraćanje kursa';
$string['courses'] = 'Kursevi';
$string['coursesectionsummaries'] = 'Rezime sekcija kursa';
$string['coursesettings'] = 'Zadana podešavanja kursa';
$string['coursesmovedout'] = 'Kurs pomjeren iz {$a}';
$string['coursespending'] = 'Kursevi koji čekaju na odobrenje';
$string['coursestart'] = 'Početak kursa';
$string['coursesummary'] = 'Rezime kursa';
$string['coursesummary_help'] = 'Sažetak kursa se prikazuje u okviru popisa kurseva. Pretraga kurseva pretražuje i tekst sažetaka uz pregledanje naziva kurseva.';
$string['courseupdates'] = 'Ažuriranja kursa';
$string['create'] = 'Kreiraj';
$string['createaccount'] = 'Kreiraj moj novi korisnički račun';
$string['createcategory'] = 'Kreiraj kategoriju';
$string['createfolder'] = 'Kreiranje direktorija u {$a}';
$string['createnew'] = 'Kreiraj novo';
$string['createnewcategory'] = 'Kreiraj novu kategoriju';
$string['createnewcourse'] = 'Kreiraj novi kurs';
$string['createnewsubcategory'] = 'Kreiraj novu podkategoriju';
$string['createsubcategoryof'] = 'Kreiraj podkategoriju od {$a}';
$string['createuser'] = 'Kreiraj korisnika';
$string['createuserandpass'] = 'Odaberite svoje korisničko ime i lozinku za pristup sistemu';
$string['createziparchive'] = 'Kreiranje zip arhive';
$string['creatingblocks'] = 'Kreiranje blokova';
$string['creatingblocksroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou bloka';
$string['creatingblogsinfo'] = 'Kreiranje informacija o blogovima';
$string['creatingcategoriesandquestions'] = 'Kreiranje kategorija i pitanja';
$string['creatingcoursemodules'] = 'Kreiranje modula kursa';
$string['creatingcourseroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou kursa';
$string['creatingevents'] = 'Kreiranje događaja';
$string['creatinggradebook'] = 'Kreiranje knjige ocjena';
$string['creatinggroupings'] = 'Kreiranje grupisanja';
$string['creatinggroupingsgroups'] = 'Dodavanje grupa u grupisanja';
$string['creatinggroups'] = 'Kreiranje grupa';
$string['creatinglogentries'] = 'Kreiranje stavki izvještaja o aktivnostima';
$string['creatingmessagesinfo'] = 'Kreiranje informacija o porukama';
$string['creatingmodroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou modula';
$string['creatingnewcourse'] = 'Kreiranje novog kursa';
$string['creatingrolesdefinitions'] = 'Kreiranje definicija uloga';
$string['creatingscales'] = 'Kreiranje skala za ocjenjivanje';
$string['creatingsections'] = 'Kreiranje sekcija';
$string['creatingtemporarystructures'] = 'Kreiranje privremenih struktura';
$string['creatinguserroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou korisnika';
$string['creatingusers'] = 'Kreiranje korisnika';
$string['creatingxmlfile'] = 'Kreiranje XML datoteke';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Trenutni kurs';
$string['currentcourseadding'] = 'Tekući kurs, dodavanje podataka već postojećima';
$string['currentcoursedeleting'] = 'Tekući kurs, uz prethodno brisanje postojećih podataka';
$string['currentlanguage'] = 'Trenutno važeći jezik';
$string['currentlocaltime'] = 'Vaše trenutno lokalno vrijeme';
$string['currentlyselectedusers'] = 'Trenutno odabrani korisnici';
$string['currentpicture'] = 'Trenutna slika';
$string['currentrelease'] = 'Informacija o trenutnoj verziji programa';
$string['currentversion'] = 'Trenutna verzija';
$string['databasechecking'] = 'Nadogradnja baze podataka sa verzije {$a->oldversion} na verziju {$a->newversion}';
$string['databaseperformance'] = 'Performanse baze podataka';
$string['databasesetup'] = 'Podešavanje baze podataka';
$string['databasesuccess'] = 'Baza podataka je uspješno nadograđena';
$string['databaseupgradebackups'] = 'Trenutna verzija rezervne kopije je {$a}';
$string['databaseupgradeblocks'] = 'Trenutna verzija blokova je {$a}';
$string['databaseupgradegroups'] = 'Verzija grupa je sada {$a}';
$string['databaseupgradelocal'] = 'Trenutna verzija prilagođavanja lokalne baze podataka je {$a}';
$string['databaseupgrades'] = 'Nadogradnja baze podataka';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum promjene';
$string['datemostrecentfirst'] = 'Datum - prvo najnoviji';
$string['datemostrecentlast'] = 'Datum - prvo najstariji';
$string['day'] = 'dan';
$string['days'] = 'dana';
$string['decodinginternallinks'] = 'Dekodiranje unutrašnjih linkova';
$string['default'] = 'Zadano';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenti generalno imaju manje privilegije u okviru kursa.';
$string['defaultcoursestudents'] = 'Studenti';
$string['defaultcoursesummary'] = 'Napišite kratak i zanimljiv rezime koji objašnjava koje teme pokriva Vaš kurs.';
$string['defaultcourseteacher'] = 'Predavač';
$string['defaultcourseteacherdescription'] = 'Predavači mogu da rade bilo šta u okviru kursa, uključujući promjenu aktivnosti i ocjenjivanje studenata.';
$string['defaultcourseteachers'] = 'Predavači';
$string['defaulteditor'] = 'Zadati uređivač';
$string['delete'] = 'Izbriši';
$string['deleteablock'] = 'Izbriši blok';
$string['deleteall'] = 'Izbriši sve';
$string['deleteallcannotundo'] = 'Izbriši sve - ova akcija je nepovratna';
$string['deleteallcomments'] = 'Izbriši sve komentare';
$string['deleteallratings'] = 'Izbriši sva ocjenjivanja';
$string['deletecategory'] = 'Izbriši kategoriju: {$a}';
$string['deletecategorycheck'] = 'Da li ste sigurni da želite da izbrišetekategoriju pod nazivom <b>\'{$a}\'</b>?<br /> Na taj način će se premjestiti svi kurseve koji se nalaze u toj kategoriji u nadređenu kategoriju (ako ista postoji) ili u kategoriju "Razno".';
$string['deletecategorycheck2'] = 'Ukoliko izbrišete ovu kategoriju, morate izabrati šta ćete uraditi sa kursevima i podkategorijama koje ona sadrži.';
$string['deletecategoryempty'] = 'Ova kategorija je prazna';
$string['deletecheck'] = 'Izbrisati {$a} ?';
$string['deletecheckfiles'] = 'Da li ste sigurni da želite da izbrišete ove datoteke?';
$string['deletecheckfull'] = 'Da li ste sigurni da želite da potpuno izbrišete {$a}?';
$string['deletechecktype'] = 'Da li ste sigurni da želite da izbrišete ovaj {$a->type}?';
$string['deletechecktypename'] = 'Da li ste sigurni da želite da izbrišete {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Upravo ćete izbrisati ove datoteke';
$string['deletecomment'] = 'Izbriši ovaj komentar';
$string['deletecompletely'] = 'Kompletno brisanje';
$string['deletecourse'] = 'Brisanje kursa';
$string['deletecoursecheck'] = 'Da li ste sigurni da želite da izbrišete ovaj kurs i sve podatke koje on sadrži?';
$string['deleted'] = 'Izbrisano';
$string['deletedactivity'] = 'Izbrisano {$a}';
$string['deletedcourse'] = '{$a} je potpuno izbrisan';
$string['deletednot'] = '{$a} se ne može izbrisati!';
$string['deletelogs'] = 'Izbriši zapise';
$string['deleteselected'] = 'Izbrisati izabrano';
$string['deleteselectedkey'] = 'Izbriši izabrani ključ';
$string['deletingcourse'] = 'Brisanje {$a}';
$string['deletingexistingcoursedata'] = 'Brisanje postojećih podataka kursa';
$string['deletingolddata'] = 'Brisanje starih podataka';
$string['department'] = 'Odjel/Odsjek';
$string['desc'] = 'Opadajuće';
$string['description'] = 'Opis';
$string['deselectall'] = 'Poništite sve';
$string['detailedless'] = 'Manje detaljno';
$string['detailedmore'] = 'Detaljnije';
$string['directory'] = 'Direktorij';
$string['disable'] = 'Onemogući';
$string['disabledcomments'] = 'Komentarisanje je onemogućeno';
$string['displayingfirst'] = 'Prikazano je samo prvih(a) {$a->count} {$a->things}';
$string['displayingrecords'] = 'Prikaz {$a} zapisa';
$string['displayingusers'] = 'Prikaz korisnika od {$a->start} do {$a->end}';
$string['displayonpage'] = 'Prikaži na stranici';
$string['dndcourse'] = 'Možete "prevući i spustiti" ovaj kurs kako bi izmijenili njegovo sortiranje ili kako bi ga premjestili u drugu kategoriju.';
$string['dndenabled_inbox'] = '"Prevucite i spustite" datoteke ovdje kako biste ih dodali';
$string['dndnotsupported'] = 'Upload putem opcije "prevuci i spusti" nije podržan';
$string['dndnotsupported_help'] = 'Vas pretraživač ne podržava "prevuci i spusti" način upload-a <br />T Ova mogućnost je podržana na posljednjim verzijama Chrome, Firefox, Safari, kao i Internet Explorer v10 (i iznad).';
$string['dndnotsupported_insentence'] = '"Prevuci i spusti" nije podržan';
$string['dnduploadwithoutcontent'] = 'Ovo postavljanje nema nikakav sadržaj';
$string['dndworkingfile'] = 'Prevucite i spustite datoteke na sekciju kursa kako biste ih postavili';
$string['dndworkingfilelink'] = 'Prevucite i spustite datoteke ili linkove na sekciju kursa kako biste ih postavili';
$string['dndworkingfiletext'] = 'Prevucite i spustite datoteke ili tekst na sekciju kursa kako biste ih postavili';
$string['dndworkingfiletextlink'] = 'Prevucite i spustite datoteke, tekst ili linkove na sekciju kursa kako biste ih postavili';
$string['dndworkinglink'] = 'Prevucite i spustite linkove na sekciju kursa kako biste ih postavili';
$string['dndworkingtext'] = 'Prevucite i spustite tekst na sekciju kursa kako biste ga postavili';
$string['dndworkingtextlink'] = 'Prevucite i spustite tekst ili linkove na sekciju kursa kako biste ih postavili';
$string['documentation'] = 'Moodle dokumentacija';
$string['dontsortcategories'] = 'Ne sortiraj kategorije';
$string['dontsortcourses'] = 'Ne sortiraj kurseve';
$string['down'] = 'Dolje';
$string['download'] = 'Preuzmi';
$string['downloadall'] = 'Preuzmi sve';
$string['downloadexcel'] = 'Preuzmi u Excel formatu';
$string['downloadfile'] = 'Preuzmi datoteku';
$string['downloadods'] = 'Preuzmi u ODS formatu';
$string['downloadtext'] = 'Preuzmi u tekstualnom formatu';
$string['doyouagree'] = 'Jeste li pročitali navedene uslove i razumjeli ih u potpunosti?';
$string['droptoupload'] = 'Spusti ovdje datoteke za slanje';
$string['duplicate'] = 'Dupliraj';
$string['duplicateconfirm'] = 'Jeste li ste sigurni da želite da duplirate {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Povratak na kurs';
$string['duplicatecontedit'] = 'Uredi novu kopiju';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' je uspješno dupliran';
$string['duplicatinga'] = 'Dupliranje: {$a}';
$string['edhelpaspellpath'] = 'Da bi ste koristili provjeru pravopisa u editoru, MORATE imati <strong>aspell 0.50</strong> ili noviju verziju instaliranu na Vašem serveru, i morate specificirati tačnu putanju za pristup aspell binarnoj datoteci. Na Unix/Linux sistemima, ova putanja je obično <strong>/usr/bin/aspell</strong>, ali može biti i neka druga.';
$string['edhelpbgcolor'] = 'Odredite pozadinsku boju polja za uređivanje.<br />Primjer vrijednosti koje se mogu zadati su: #ffffff ili white';
$string['edhelpcleanword'] = 'Ovo podešavanje omogućava ili onemogućava filtriranje Word-specifičnog formata.';
$string['edhelpenablespelling'] = 'Uključite ili isključite provjeru pravopisa (spell-checking). Ako je provjera uključena, <strong>aspell</strong> mora biti instaliran na serveru. Druga vrijednost je <strong>podrazumijevani rječnik</strong>. Ova vrijednost će biti korištena ako aspell nema rječnik za jezik koji koristi korisnik.';
$string['edhelpfontfamily'] = 'Karakteristika font-familije je lista naziva grupe fontova srodnih jezika i/ili generičkih naziva grupa srodnih fontova. Imena grupa srodnih jezika moraju biti odvojena zarezom.';
$string['edhelpfontlist'] = 'Odredite fontove koji će se koristiti u padajućem meniju.';
$string['edhelpfontsize'] = 'Zadana veličina fonta. <br />Primjeri vrijednosti koje se mogu zadati su: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Uredi';
$string['edita'] = 'Uredi {$a}';
$string['editcategorysettings'] = 'Uredi podešavanja kategorije';
$string['editcategorythis'] = 'Uredi ovu kategoriju';
$string['editcoursesettings'] = 'Uređivanje podešavanja kursa';
$string['editfiles'] = 'Uređivanje datoteka';
$string['editgroupprofile'] = 'Uređivanje profila grupe';
$string['editinga'] = 'Uređivanje';
$string['editingteachershort'] = 'Urednik';
$string['editlock'] = 'Ova vrijednost se ne može promjeniti!';
$string['editmyprofile'] = 'Uređivanje profila';
$string['editorbgcolor'] = 'Boja pozadine';
$string['editorcleanonpaste'] = 'Obriši Word HTML oznake prilikom kopiranja';
$string['editorcommonsettings'] = 'Opšta podešavanja';
$string['editordefaultfont'] = 'Zadani font';
$string['editorenablespelling'] = 'Omogući provjeru pravopisa';
$string['editorfontlist'] = 'Popis fontova';
$string['editorfontsize'] = 'Zadana veličina slova';
$string['editorresettodefaults'] = 'Vrati na zadane vrijednosti';
$string['editorsettings'] = 'Podešavanja editora';
$string['editorshortcutkeys'] = 'Prečice sa tastature editora';
$string['editsettings'] = 'Uredi podešavanja';
$string['editsummary'] = 'Uredi rezime';
$string['editthisactivity'] = 'Uređivanje ove aktivnosti';
$string['editthiscategory'] = 'Uređivanje ove kategorije';
$string['edittitle'] = 'Uredi naslov';
$string['edittitleinstructions'] = 'Pritisnite tipku \'Escape\' za otkazivanje, a tipku \'Enter\' kada završite';
$string['edituser'] = 'Uređivanje korisničkih računa';
$string['email'] = 'E-mail adresa';
$string['emailactive'] = 'E-mail aktiviran';
$string['emailagain'] = 'E-mail (ponovno)';
$string['emailalreadysent'] = 'E-mail sa resetovanom šifrom je već poslan. Molimo provjerite svoj E-mail.';
$string['emailcharset'] = 'E-mail set karaktera';
$string['emailconfirm'] = 'Potvrdite svoj korisnički račun';
$string['emailconfirmation'] = 'Poštovana/i {$a->firstname}, Neko je zatražio otvaranje korisničkog računa na sajtu \'{$a->sitename}\' koristeći Vašu e-mail adresu. Da bi ste potvrdili otvaranje Vašeg računa, posjetite sljedeću lokaciju: {$a->link} U većini e-mail programa, u redu iznad ovog bi ste trebali vidjeti plavo obojeni link na koji možete kliknuti. Ako ta funkcija ne radi, onda samo kopirajte navedenu adresu u liniju za adrese na vrhu Vašeg Web pretraživača. U slučaju da Vam je potrebna tehničku pomoć, molimo kontaktirajte administratora sistema, {$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: potvrda registracije korisničkog računa';
$string['emailconfirmsent'] = '<p>Uskoro bi ste trebali primiti e-mail poruku na Vašu adresu <b>{$a}</b></p> <p>Poruka sadrži jednostavna uputstva o daljnjem postupku registracije.</p> <p>Ako imate tehničkih problema sa registracijom ili pitanja u vezi iste, kontaktirajte administratora sistema.</p>';
$string['emaildigest'] = 'Način obavještavanja putem e-maila';
$string['emaildigestcomplete'] = 'Kompletno (jedna e-mail poruka dnevno sa kompletnim sadržajem svih poruka sa foruma)';
$string['emaildigest_help'] = 'Ovo je dnevna opcija za obavještavanje koju će forumi prema zadanim postavkama koristiti. * Bez obavještavanja - primati ćete jedno obajveštenje putem e-maila za svaki upis na forumu; * Obavještavanje - kompletni postovi - primati ćete jedno obavještenje putem e-maila koji će sadržavati kompletne sadržaje svakog upisa na forumu, *Obavještavanje - samo naslovi - primati ćete jedno obavještenje putem e-maila svaki dan koje će sadržavati samo naslove svakog upisa na forumu. Također ako želite, možete odabrati različite postavke za svaki forum.';
$string['emaildigestoff'] = 'Bez skraćivanja (po jedna e-mail poruka za svaku poruku sa foruma)';
$string['emaildigestsubjects'] = 'Naslovi (jedna e-mail poruka dnevno samo sa naslovima)';
$string['emaildisable'] = 'Ova e-mail adresa nije dostupna';
$string['emaildisableclick'] = 'Kliknite ovdje za onemogućavanje slanja bilo kakve e-mail poruke na ovu adresu.';
$string['emaildisplay'] = 'Prikaz e-mail adrese';
$string['emaildisplaycourse'] = 'Dozvoli jedino drugim učesnicima kursa (studentima i predavaču) da vide moju e-mail adresu';
$string['emaildisplayhidden'] = 'E-mail adresa skrivena';
$string['emaildisplayno'] = 'Sakrij moju e-mail adresu od svih';
$string['emaildisplayyes'] = 'Dozvoli svima da vide moju e-mail adresu';
$string['emailenable'] = 'Ova e-mail adresa je dostupna';
$string['emailenableclick'] = 'Kliknite ovdje za ponovno omogućavanje slanja svih e-mail poruka na ovu adresu';
$string['emailexists'] = 'Ova e-mail adresa je već registrovana.';
$string['emailformat'] = 'E-mail format';
$string['emailmustbereal'] = 'Napomena: Vaša e-mail adresa mora biti stvarna.';
$string['emailnotallowed'] = 'E-mail adrese koje pripadaju ovim domenama nisu dozvoljene ({$a})';
$string['emailnotfound'] = 'E-mail adresa nije nađena u bazi podataka';
$string['emailonlyallowed'] = 'Ova e-mail adresa nije jedna od dozvoljenih ({$a})';
$string['emailpasswordchangeinfo'] = 'Poštovana/i {$a->firstname}, neko (vjerovatno Vi) je tražio novu šifru za Vaš korisnički račun na \'{$a->sitename}\'. Da bi ste promjenili Vašu šifru, molim idite na sljedeću internet stranicu: {$a->link} U većini programa namenjenih za e-mail ovo bi trebalo da se prikaže kao link u plavoj boji na koji možete da kliknete. U slučaju da to ne funkcioniše, kopirajte i prenesite adresu u adresnu liniju prozora Vašeg Web pretraživača. Ako Vam je potrebna pomoć, molim Vas kontaktirajte sistem administratora, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Poštovana/i {$a->firstname}, neko (vjerovatno Vi) je tražio novu šifru za Vaš korisnički račun na \'{$a->sitename}\'. Na žalost, Vaš račun na ovoj lokaciji je nedostupan i ne može biti ponovo aktiviran, molimo kontaktirajte svog administratora, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Poštovana/i {$a->firstname}, neko (vjerovatno Vi) je tražio novu šifru za Vaš korisnički račun na \'{$a->sitename}\'. Na žalost, šifre se ne mogu mijenjati na ovoj lokaciji, molimo kontaktirajte svog administratora, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informacije o promjeni šifre';
$string['emailpasswordconfirmation'] = 'Poštovana/i {$a->firstname}, neko (najvjerojatnije Vi) je zatražio novu lozinku za Vaš korisnički račun u sistemu \'{$a->sitename}\'. Kako bi ste potvrdili potrebu za novom lozinkom i dobili novu lozinku putem e-mail adrese, posjetite ovu Web adresu: {$a->link} U većini programa za e-mail, u redu iznad ovog bi ste trebali vidjeti plavo obojeni link na koji možete kliknuti. Ako ta funkcija ne radi, označite i kopirajte adresu u adresnu liniju Vašeg Web pretraživača. U slučaju da Vam treba tehnička pomoć, molimo Vas da kontaktirate administratora sistema, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Potvrda promjene šifre';
$string['emailpasswordconfirmmaybesent'] = '<p>Ako ste naveli tačno korisničko ime ili e-mail adresu, trebalo bi da vam je poslana e-mail poruka.</p> <p>Ona sadrži jednostavna uputstva za potvrdu i završetak procesa promjene šifre. Ako budete i dalje imali poteškoće, molimo kontaktirajte administratora svog sajta.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Korisnički profil koji ste naveli nema evidentiranu e-mail adresu.</p> <p>Molimo kontaktirajte administratora svog sajta</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Korisnički podaci koje ste pružili ne prepoznaju postojeći korisnički profil</p> <p>Molimo provjerite podatke koje ste unijeli, zatim pokušajte ponovo. Ukoliko i dalje budete imali poteškoće, molimo kontaktirajte administratora svog sajta.</p>';
$string['emailpasswordconfirmsent'] = 'Trebali bi ste primiti e-mail poruku poslanu na Vašu adresu <b>{$a}</b>. <p>Poruka sadrži jednostavna uputstva za potvrđivanje i kompletiranje promjene Vaše lozinke. Ako budete imali poteškoća prilikom ovog procesa, možete se obratiti administratoru.';
$string['emailpasswordsent'] = 'Zahvaljujemo na potvrdi zahtjeva za promjenu lozinke. <p>E-mail poruka koja sadrži Vašu novu lozinku je poslana na Vašu e-mail adresu <b>{$a->email}</b>.</p> <p>Nova lozinka je automatski generisana - preporučujemo da je <a href="{$a->link}">promjenite </a> čim je dobijete u neku drugu koju ćete lakše zapamtiti.</p>';
$string['emailresetconfirmationsubject'] = '{$a}: Zahtjev za resetovanjem šifre';
$string['emailresetconfirmsent'] = 'E-mail je poslan na vašu adresu <b>{$a}</b>. <br />Sadrži jednostavne upute kako bi potvrdili i završili proces promjene šifre. Ako i dalje budete imali poteškoće, kontaktirajte administratora sajta.';
$string['emptydragdropregion'] = 'prazno polje';
$string['enable'] = 'Omogući';
$string['encryptedcode'] = 'Šifrirani kod';
$string['english'] = 'Engleski';
$string['enrolmentmethods'] = 'Načini upisa';
$string['entercourse'] = 'Kliknite za pristup kursu';
$string['enteremail'] = 'Unesite svoju e-mail adresu';
$string['enteremailaddress'] = 'Da bi ste poništili trenutnu šifru i dobili novu, treba da unesete Vašu važeću e-mail adresu, na koju će Vam biti poslana nova šifra.';
$string['enterusername'] = 'Unesite svoje korisničko ime';
$string['entries'] = 'Prijave';
$string['error'] = 'Greška';
$string['errorcreatingactivity'] = 'Nije moguće kreirati instancu aktivnosti \'{$a}';
$string['errorfiletoobig'] = 'Datoteka je bila veća od ograničenja od {$a} bajta (bajtova)';
$string['errornouploadrepo'] = 'Na ovom sajtu ne postoji repozitorij za postavljanje datoteka koji je omogućen';
$string['errorwhenconfirming'] = 'Vaš korisnički račun još nije još potvrđen zbog greške koja se dogodila. Ako ste kliknuli na link koji ste dobili u e-mail poruci, molimo provjerite da li je linija u kojoj se nalazi navedeni link ispravna (odnosno da je nije Vaš e-mail klijent  možda formatirao u dva reda, čime je dio linka završio u drugom redu). Postoji mogućnost da ćete morati ručnim kopiranjem i unosom rekonstruisati originalni link.';
$string['eventcontentviewed'] = 'Pregledani sadržaj';
$string['eventcoursecategorydeleted'] = 'Kategorija izbrisana';
$string['eventcoursecontentdeleted'] = 'Sadržaj kursa izbrisan';
$string['eventcoursecreated'] = 'Kurs kreiran';
$string['eventcoursedeleted'] = 'Kurs izbrisan';
$string['eventcoursemodulecreated'] = 'Modul kurs kreiran';
$string['eventcoursemoduledeleted'] = 'Modul kursa izbrisan';
$string['eventcoursemoduleupdated'] = 'Modul kursa ažuriran';
$string['eventcourseresetended'] = 'Ponovna postavka kursa završena';
$string['eventcourseresetstarted'] = 'Ponovna postavka kursa započeta';
$string['eventcourserestored'] = 'Kurs ponovno uspostavljen';
$string['eventcoursesectionupdated'] = 'Sekcija kursa ažurirana';
$string['eventcourseupdated'] = 'Kurs ažuriran';
$string['eventusercreated'] = 'Korisnik kreiran';
$string['eventuserdeleted'] = 'Korisnik izbrisan';
$string['eventuserlistviewed'] = 'Pregledana lista korisnika';
$string['eventuserloggedout'] = 'Korisnik se odjavio';
$string['eventuserprofileviewed'] = 'Pregledani profili korisnika';
$string['eventuserupdated'] = 'Korisnik ažuriran';
$string['everybody'] = 'Svi';
$string['executeat'] = 'Izvršiti u';
$string['existing'] = 'Postojeći';
$string['existingadmins'] = 'Postojeći administratori';
$string['existingcourse'] = 'Postojeći kurs';
$string['existingcourseadding'] = 'Postojeći kurs - dodavanje podataka postojećim';
$string['existingcoursedeleting'] = 'Postojeći kurs - prethodno brisanje kursa';
$string['existingcreators'] = 'Postojeći kreatori kursa';
$string['existingstudents'] = 'Upisani studenti';
$string['existingteachers'] = 'Postojeći predavači';
$string['expand'] = 'Proširi';
$string['expandall'] = 'Proširi sve';
$string['expandcategory'] = 'Proširi {$a}';
$string['explanation'] = 'Objašnjenje';
$string['extendenrol'] = 'Produži (pojedinačno) trajanje članstva';
$string['extendperiod'] = 'Produženi period';
$string['failedloginattempts'] = '{$a->attempts} neuspješnih pristupa sistemu od Vaše posljednje prijave';
$string['failedloginattemptsall'] = '{$a->attempts} neuspješnih pristupa sistemu za {$a->accounts} korisničke račune';
$string['feedback'] = 'Povratne informacije';
$string['file'] = 'Datoteka';
$string['fileexists'] = 'Već postoji datoteka pod nazivom {$a}';
$string['filemissing'] = '{$a} nedostaje';
$string['files'] = 'Datoteke';
$string['filesanduploads'] = 'Datoteke i ažuriranja';
$string['filesfolders'] = 'Datoteke/Direktoriji';
$string['filetoolarge'] = 'je preveliko za dodavanje';
$string['fileuploadwithcontent'] = 'Dodavanje datoteka ne treba da uključuje parametre sadržaja';
$string['filloutallfields'] = 'Molimo ispunite sva polja u ovoj formi';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Pronađite još kurseva...';
$string['first'] = 'Prvi';
$string['firstaccess'] = 'Prvi pristup';
$string['firstname'] = 'Ime';
$string['firstnamephonetic'] = 'Ime - fonetski';
$string['firsttime'] = 'Da li ste ovdje prvi put?';
$string['folder'] = 'Direktorij';
$string['folderclosed'] = 'Zatvoreni direktorij';
$string['folderopened'] = 'Otvoreni direktorij';
$string['followingoptional'] = 'Sljedeća polja nisu obavezna';
$string['followingrequired'] = 'Sljedeća polja su obavezna';
$string['for'] = 'Za';
$string['force'] = 'Obavezno';
$string['forcelanguage'] = 'Obavezan jezik';
$string['forceno'] = 'Nije obavezno';
$string['forcepasswordchange'] = 'Primoraj na promjenu lozinke';
$string['forcepasswordchangecheckfull'] = 'Jeste li apsolutno sigurni da želite da prisilite na promjenu lozinke korisnika {$a}?';
$string['forcepasswordchange_help'] = 'Ako je ovo polje za potvrdu označeno, od korisnika će se tražiti da promjene lozinku kada se naredni put budu prijavili na sistem';
$string['forcepasswordchangenot'] = 'Nije bilo moguće prisiliti {$a} na promjenu lozinke.';
$string['forcepasswordchangenotice'] = 'Morate promjeniti svoju lozinku da biste nastavili.';
$string['forcetheme'] = 'Obavezna grafička tema';
$string['forgotaccount'] = 'Zaboravili ste lozinku?';
$string['forgotten'] = 'Zaboravili ste svoje korisničko ime ili lozinku?';
$string['forgottenduplicate'] = 'e-mail adresu dijeli više korisničkih računa, molim Vas unesite korisničko ime umjesto iste';
$string['forgotteninvalidurl'] = 'Ponovno postavljanje adrese u slučaju pogrešne lozinke';
$string['format'] = 'Format';
$string['format_help'] = 'Oblik kursa određuje izgled naslovne stranice kursa. * SCORM - koristi se za prikaz SCORM paketa u prvoj sekciji stranice kursa (kao alternativa korištenju SCORM/AICC modula) * Društveni format - na naslovnoj stranici kursa se prikazuje forum * Tematski format - naslovna stranica kursa je organizirana u tematske sekcije * Sedmični format - naslovna stranica kursa je organizirana u sedmične sekcije, pri čemu prva sedmica odgovara datumu početka kursa';
$string['formathtml'] = 'HTML format';
$string['formatmarkdown'] = 'Markdown format';
$string['formatplain'] = 'Tekstualni format';
$string['formattext'] = 'Moodle auto-format';
$string['formattexttype'] = 'Formatiranje';
$string['framesetinfo'] = 'Ovaj skup okvira sadrži:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Kombinovani popis';
$string['frontpagecategorynames'] = 'Popis kategorija';
$string['frontpagecourselist'] = 'Popis kurseva';
$string['frontpagecoursesearch'] = 'Polje za pretragu kursa';
$string['frontpagedescription'] = 'Opis na naslovnoj stranici';
$string['frontpagedescriptionhelp'] = 'Ovaj opis sajta će biti prikazan na naslovnoj stranici.';
$string['frontpageenrolledcourselist'] = 'Upisani kursevi';
$string['frontpageformat'] = 'Format naslovne stranice';
$string['frontpageformatloggedin'] = 'Format naslovne stranice kada je korisnik prijavljen';
$string['frontpagenews'] = 'Vijesti';
$string['frontpagesettings'] = 'Podešavanja naslovne stranice';
$string['fulllistofcourses'] = 'Svi kursevi';
$string['fullname'] = 'Puno ime';
$string['fullnamecourse'] = 'Puni naziv kursa';
$string['fullnamecourse_help'] = 'Puni naziv kursa se prikazuje na vrhu svake stranice kursa kao i na popisu kurseva.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Puno ime korisnika';
$string['fullprofile'] = 'Potpuni profil';
$string['fullsitename'] = 'Puno ime sajta';
$string['functiondisabled'] = 'Navedena funkcionalnost trenutno nije dostupna';
$string['general'] = 'Opšte';
$string['geolocation'] = 'širina - dužina';
$string['gettheselogs'] = 'Preuzmi ove zapise o aktivnostima';
$string['go'] = 'Dalje';
$string['gpl'] = 'Autorska prava 1999-2004 Martin Dougiamas (http://dougiamas.com) Ovaj program je besplatan softver; možete vršiti njegovu distribuciju i/ili mijenjati ga samo pod uslovima GNU General Public License koju je objavila Free Software Foundation, verzija 2 ili (po Vašem izboru) bilo koja novija verzija. Ovaj program se distribuira u nadi da će biti koristan, ali BEZ IKAKVIH GARANCIJA; čak i bez impliciranih garancija ISPLATIVOSTI ili POGODNOSTI ZA KONKRETNU PRIMJENU. Pogledajte Moodle License stranicu sa informacijama za više detalja: http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Autorska prava od 1999 pa nadalje Martin Dugiamas (http://moodle.com) Ovaj program je besplatan softver; možete vršiti njegovu redistribuciju i/ili mijenjati ga samo pod uslovima GNU General Public License koju je objavila Free Software Foundation, verzija 3 ili (po Vašem izboru) bilo koja novija verzija. Ovaj program se distribuira u nadi da će biti koristan, ali BEZ IKAKVIH GARANCIJA; čak i bez implicitnih garancija ISPLATIVOSTI ili POGODNOSTI ZA KONKRETNU PRIMJENU. Pogledajte Moodle License stranicu sa informacijama za više detalja: http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL licenca';
$string['grade'] = 'Ocjena';
$string['grades'] = 'Ocjene';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> je omogućen za ovaj sajt. Ako sami ne postavite svoju sliku Moodle će pokušati da je umjesto Vas učita sa Gravatar.';
$string['group'] = 'Grupa';
$string['groupadd'] = 'Dodavanje nove grupe';
$string['groupaddusers'] = 'Dodavanje izabranih polaznika grupi';
$string['groupextendenrol'] = 'Produži trajanje članstva svim studentima';
$string['groupfor'] = 'za grupu';
$string['groupinfo'] = 'Informacije o izabranoj grupi';
$string['groupinfoedit'] = 'Uređivanje podešavanja grupe';
$string['groupinfomembers'] = 'Informacije o izabranim članovima';
$string['groupinfopeople'] = 'Informacije o izabranim ljudima';
$string['groupmembers'] = 'Članovi grupe';
$string['groupmemberssee'] = 'Prikaz članova grupe';
$string['groupmembersselected'] = 'Članovi izabrane grupe';
$string['groupmode'] = 'Grupni način rada';
$string['groupmodeforce'] = 'Obavezan grupni mod';
$string['groupmy'] = 'Moja grupa';
$string['groupnonmembers'] = 'Polaznici koji nisu u grupi';
$string['groupnotamember'] = 'Žao nam je, niste član te grupe';
$string['grouprandomassign'] = 'Slučajnim odabirom rasporedi sve polaznike u grupe';
$string['groupremove'] = 'Ukloni izabranu grupu';
$string['groupremovemembers'] = 'Uklanjanje izabranih članova';
$string['groups'] = 'Grupe';
$string['groupsnone'] = 'Bez grupa';
$string['groupsseparate'] = 'Odvojene grupe';
$string['groupsvisible'] = 'Vidljive grupe';
$string['guest'] = 'Gost';
$string['guestdescription'] = 'Gosti imaju minimalne privilegije i obično nigdje ne mogu da unesu tekst.';
$string['guestskey'] = 'Dozvoljen pristup gostima koji imaju lozinku kursa';
$string['guestsno'] = 'Zabranjen pristup gostima';
$string['guestsnotallowed'] = 'Žao nam je, kurs \'{$a}\' ne dozvoljava pristup gostima.';
$string['guestsyes'] = 'Dozvoljen pristup gostima bez lozinke kursa';
$string['guestuser'] = 'Korisnik u ulozi gosta';
$string['guestuserinfo'] = 'Ovaj korisnik je poseban koji dozvoljava pristup nekim kursevima samo za čitanje.';
$string['help'] = 'Pomoć';
$string['helpprefix2'] = 'Pomoć za {$a}';
$string['helpwiththis'] = 'Pomoć za ovo';
$string['hiddenassign'] = 'Sakriveni zadaci';
$string['hiddenfromstudents'] = 'Sakriveno od studenta';
$string['hiddensections'] = 'Skrivene sekcije';
$string['hiddensectionscollapsed'] = 'Skrivene sekcije su prikazane u skupljenom obliku';
$string['hiddensections_help'] = 'Ovo podešavanje određuje da li će studentima skrivene sekcije kursa biti prikazane u sažetom obliku (npr. za kurseve u sedmičnom formatu, da bi se označili praznici ili raspust između dva semestra), ili će biti u potpunosti sakrivene.';
$string['hiddensectionsinvisible'] = 'Skrivene sekcije su u potpunosti nevidljive';
$string['hide'] = 'Sakrij';
$string['hideadvancedsettings'] = 'Sakrij napredna podešavanja';
$string['hidepicture'] = 'Sakrij sliku';
$string['hidesection'] = 'Sakrij sekciju {$a}';
$string['hidesettings'] = 'Sakrij podešavanja';
$string['hideshowblocks'] = 'Sakrij ili prikaži blokove';
$string['hits'] = 'Posjete';
$string['hitsoncourse'] = 'Posjete korisnika {$a->username} kursu {$a->coursename}';
$string['hitsoncoursetoday'] = 'Današnje posjete korisnika {$a->username} kursu {$a->coursename}';
$string['home'] = 'Početna strana';
$string['hour'] = 'h';
$string['hours'] = 'h';
$string['howtomakethemes'] = 'Kako napraviti nove grafičke teme';
$string['htmleditor'] = 'Koristi HTML editor';
$string['htmleditoravailable'] = 'HTML editor je dostupan';
$string['htmleditordisabled'] = 'Isključili ste upotrebu HTML editora za Vaš korisnički profil';
$string['htmleditordisabledadmin'] = 'Administrator sistema je isključio upotrebu HTML editora na nivou cijelog sistema';
$string['htmleditordisabledbrowser'] = 'HTML editor nije dostupan jer Vaš web pretraživač nije kompatibilan sa njim';
$string['htmlfilesonly'] = 'Samo HTML datoteke';
$string['htmlformat'] = 'Uljepšani HTML format';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'ICQ broj';
$string['idnumber'] = 'ID broj';
$string['idnumbercourse'] = 'ID broj kursa';
$string['idnumbercoursecategory'] = 'ID broj kategorije';
$string['idnumbercoursecategory_help'] = 'ID broj kategorije kursa se koristi samo za poređenje sa vanjskim sistemom ID brojeva, i nigdje se ne prikazuje na sajtu. Ako kategorija ima zvaničan kodni naziv, on može biti unijet, u suprotnom polje može biti ostavljeno prazno.';
$string['idnumbercourse_help'] = 'ID broj kursa se koristi samo prilikom upoređivanja sa vanjskim sistemima i ne prikazuje se nigdje na sajtu. Ako kurs ima neku oficijelnu šifru, ona može ovdje biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbergroup'] = 'ID broj grupe';
$string['idnumbergroup_help'] = 'ID broj grupe se koristi samo prilikom upoređivanja sa vanjskim sistemima i ne prikazuje se nigdje na sajtu. Ako grupa ima neku oficijelnu šifru, ona može ovdje biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbergrouping'] = 'ID broj grupisanja';
$string['idnumbergrouping_help'] = 'ID broj grupisanja se koristi samo prilikom upoređivanja sa vanjskim sistemima i ne prikazuje se nigdje na sajtu. Ako grupisanje ima neku oficijelnu šifru, ona može ovdje biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbermod'] = 'ID broj';
$string['idnumbermod_help'] = 'Postavljanje ID broja omogućuje identifikaciju aktivnosti u svrhu računanja ocjena. Ako aktivnost nije uključena u neko od ocjenjivanja, polje za ID broj može ostati prazno. ID broj se, također, može postaviti u knjizi ocjena, ali se jedino može uređivati na stranici za podešavanje aktivnosti.';
$string['idnumbertaken'] = 'Ovaj ID broj je već zauzet';
$string['imagealt'] = 'Opis slike';
$string['import'] = 'Unos';
$string['importdata'] = 'Unos podataka kursa';
$string['importdataexported'] = 'Prijenos podataka iz izvornog kursa prošao je uspješno. <br /> Slijedi unos podataka u odredišni kurs';
$string['importdatafinished'] = 'Unos podataka je uspješno završen! Nastavite prema Vašem kursu';
$string['importdatafrom'] = 'Pronađite kurs iz kojeg želite da unesete podatke:';
$string['inactive'] = 'Neaktivan';
$string['include'] = 'Uključi';
$string['includeallusers'] = 'Uključi sve korisnike';
$string['includecoursefiles'] = 'Uključi datoteke kursa';
$string['includecourseusers'] = 'Uključi polaznike kursa';
$string['included'] = 'Uključeni';
$string['includelogentries'] = 'Uključi stavke izvještaja o aktivnostima';
$string['includemodules'] = 'Uključi module';
$string['includemoduleuserdata'] = 'Uključi podatke korisnika modula';
$string['includeneededusers'] = 'Uključi potrebne korisnike';
$string['includenoneusers'] = 'Bez uključivanja korisnika';
$string['includeroleassignments'] = 'Obuhvati dodjelu uloga';
$string['includesitefiles'] = 'Uključujući datoteke korištene u ovom kursu';
$string['includeuserfiles'] = 'Uključi korisničke datoteke';
$string['increasesections'] = 'Povećaj broj sekcija';
$string['info'] = 'Informacija';
$string['institution'] = 'Institucija';
$string['instudentview'] = 'u studentskom pogledu';
$string['interests'] = 'Interesovanja';
$string['interestslist'] = 'Lista interesovanja';
$string['interestslist_help'] = 'Unesite svoja interesovanja odvojena zarezima. Vaša interesovanja će biti prikazana na Vašem profilu kao oznake (tagovi).';
$string['invalidemail'] = 'Nevažeća e-mail adresa';
$string['invalidlogin'] = 'Pogrešno korisničko ime ili lozinka. Molimo pokušajte ponovo.';
$string['invalidusername'] = 'Korisničko ime može sadržati samo mala slova i/ili brojeve, donju crtu (_), crticu (-), tačku (.) ili simbol @';
$string['invalidusernameupload'] = 'Neispravno korisničko ime';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Prelaz';
$string['jumpto'] = 'Prelaz na...';
$string['keep'] = 'Zadržite';
$string['keepsearching'] = 'Nastavi s pretragom';
$string['langltr'] = 'Smjer pisanja s lijeva na desno';
$string['langrtl'] = 'Smjer pisanja s desna na lijevo';
$string['language'] = 'Jezik';
$string['languagegood'] = 'Ovaj jezički paket je ažuran! :-)';
$string['last'] = 'Posljednji';
$string['lastaccess'] = 'Posljednji pristup';
$string['lastedited'] = 'Posljednji put uređeno';
$string['lastlogin'] = 'Posljednji pristup sistemu';
$string['lastmodified'] = 'Posljednja izmjena';
$string['lastname'] = 'Prezime';
$string['lastnamephonetic'] = 'Prezime - fonetski';
$string['lastyear'] = 'Prošle godine';
$string['latestlanguagepack'] = 'Pogledajte najnovije jezičke pakete na moodle.org';
$string['layouttable'] = 'Raspored u tabeli';
$string['leavetokeep'] = 'Ostavite prazno polje da zadržite trenutnu lozinku';
$string['legacythemeinuse'] = 'Ovaj sajt vam se prikazuje u tzv. kompatibilnom modu zato što je vaš web pretraživač zastario.';
$string['license'] = 'Licenca';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Želite li sad da pristupite sistemu s pravim korisničim računom?';
$string['list'] = 'Popis';
$string['listfiles'] = 'Popis datoteka u {$a}';
$string['listofallpeople'] = 'Popis svih korisnika';
$string['listofcourses'] = 'Popis kurseva';
$string['loadinghelp'] = 'Pokreće se...';
$string['local'] = 'Lokalno';
$string['localplugins'] = 'Lokalni dodaci';
$string['localpluginsmanage'] = 'Uredi lokalne dodatke';
$string['location'] = 'Lokacija';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Prijavljeni ste kao {$a}';
$string['loggedinasguest'] = 'Trenutno pristupate kao gost';
$string['loggedinnot'] = 'Niste prijavljeni.';
$string['login'] = 'Prijavite se';
$string['loginalready'] = 'Već ste prijavljeni na sistem';
$string['loginas'] = 'Prijavite se kao';
$string['loginaspasswordexplain'] = '<p>Morate unijeti specijalnu "pristupi sistemu kao" lozinku da biste koristili ovu mogućnost.<br />Ako ne znate tu lozinku, pitajte administratora svog servera.</p>';
$string['login_failure_logs'] = 'Zapisi o neuspješnim prijavama';
$string['loginguest'] = 'Prijavite se kao gost';
$string['loginsite'] = 'Prijavite se na sajt';
$string['loginsteps'] = 'Dobrodošli! Kako biste imali puni pristup kursevima na ovom web sajtu, morate kreirati novi korisnički račun. Svaki od pojedinih kurseva može također imati jednokratnu "šifru kursa", koju treba da dobijete od svog predavača i koja se unosi samo prilikom prvog prijavljivanja na kurs. Slijedite ova uputstva: <ol size="2"> <li>Ispunite obrazac <a href="{$a}">Novi korisnički račun</a> svojim ličnim podacima.</li> <li>Odmah ćete na e-mail adresu dobiti dalja uputstva.</li> <li>Pažljivo pročitajte poruku i kliknite na link koji se nalazi u njoj.</li> <li>Vaš korisnički račun će time biti potvrđen i bićete prijavljeni na sistem.</li> <li>Potom odaberite kurs u kojem želite da učestvujete.</li> <li>Ako vam sistem zatraži "šifru kursa" - upotrijebite onu koju vam je dao vaš predavač na navedenom kursu. Tako ćete se upisati na kurs</li> <li>Nakon unosa ispravne "šifre kursa" možete pristupiti kursu (odnosno, od tog trenutka ste upisani na isti). Ubuduće, pri dolasku na sajt, biće potrebno da unesete samo svoje korisničko ime i šifru (u obrazac na ovoj strani) kako biste pristupili svim kursevima koje ste upisali.</li> </ol>';
$string['loginstepsnone'] = '<p>Poštovani budući korisniče!</p> <p>Za potpuni pristup kursevima morate kreirati korisnički račun.</p> <p>Sve što treba da uradite je da smislite korisničko ime i šifru i unesete ih u za to određena polja u obrascu na ovoj stranici!</p> <p>Ako je neko prije Vas već odabrao identično korisničko ime, morate odabrati neko drugo i pokušati ponovo.</p>';
$string['loginto'] = 'Prijavite se na {$a}';
$string['logout'] = 'Odjavite se';
$string['logoutconfirm'] = 'Da li se zaista želite odjaviti?';
$string['logs'] = 'Zapisi o aktivnostima';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">više</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">više</a> ]';
$string['lookback'] = 'Pogledaj unazad';
$string['mailadmins'] = 'Obavijestiti administratore';
$string['mailstudents'] = 'Obavijestiti studente';
$string['mailteachers'] = 'Obavijestiti predavače';
$string['maincoursepage'] = 'Glavna stranica kursa';
$string['makeafolder'] = 'Kreiraj direktorij';
$string['makeeditable'] = 'Ako podesite \'{$a}\' da se može urediti procesom Web servera, onda možete mijenjati ovu datoteku direktno sa ove stranice';
$string['makethismyhome'] = 'Postavi ovo kao moju zadanu početnu stranicu';
$string['manageblocks'] = 'Blokovi';
$string['managecategorythis'] = 'Uredi ovu kategoriju';
$string['managecourses'] = 'Upravljanje kursevima';
$string['managedatabase'] = 'Baza podataka';
$string['manageeditorfiles'] = 'Uredi datoteke korištene od strane editora';
$string['managefilters'] = 'Filteri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Uloge i prava pristupa';
$string['markedthistopic'] = 'Ova tema je označena kao trenutna tema';
$string['markthistopic'] = 'Označite ovu temu kao trenutnu temu';
$string['matchingsearchandrole'] = 'Sparivanje \'{$a->search}\' i {$a->role}';
$string['maxareabytesreached'] = 'Datoteka (ili ukupna veličina nekoliko datoteka) je veća od preostalog prostora u ovom području.';
$string['maxbytesforfile'] = 'Datoteka {$a} je veća od maksimalne dozvoljene veličine.';
$string['maxfilesize'] = 'Maksimalna veličina za nove datoteke {$a}';
$string['maxfilesreached'] = 'Dozvoljeno vam je da uz ovu stavku priložite najviše {$a} datoteku/e/a';
$string['maximumchars'] = 'Maksimalno {$a} karaktera';
$string['maximumgrade'] = 'Maksimalna ocjena';
$string['maximumgradex'] = 'Najveća ocjena: {$a}';
$string['maximumshort'] = 'Maks.';
$string['maximumupload'] = 'Maksimalna veličina datoteka za dodavanje';
$string['maximumupload_help'] = 'Ovo podešavanje određuje najveću veličinu datoteke koja se može dodati na kurs, a ograničeno je podešavanjem na nivou cijelog sajta koje određuje administrator. Moduli aktivnosti takođe sadrže podešavanje kojima se određuje i dodatno ograničava najveća dozvoljena veličina datoteke za postavljanje.';
$string['maxnumberweeks'] = 'Maksimalan broj sedmica/tema';
$string['maxnumberweeks_desc'] = 'Ovo kontroliše maksimalan broj koji se pojavljuje u podešavanju kursa za "Broj sedmica/tema"';
$string['maxnumcoursesincombo'] = 'Pretraži <a href="{$a->link}">{$a->numberofcourses} kurseve</a>';
$string['maxsize'] = 'Maksimalna veličina: {$a}';
$string['maxsizeandareasize'] = 'Maksimalna veličina novih datoteka: {$a->size}, ukupni limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksimalna veličina za nove datoteke: {$a->size}, maksimalan broj priloga: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksimalna veličina novih datoteka: {$a->size}, maksimalan prilog: {$a->attachments}, ukupni limit: {$a->areasize}';
$string['memberincourse'] = 'Učesnici u kursu';
$string['messagebody'] = 'Sadržaj poruke';
$string['messagedselectedusers'] = 'Izabranim studentima je poslana poruka i resetovan je popis primatelja.';
$string['messagedselectedusersfailed'] = 'Nešto nije bilo u redu pri slanju poruke izabranim korisnicima. Neki od njih su ipak možda primili poslanu poruku.';
$string['messageprovider:availableupdate'] = 'Dostupna obavještenja o ažuriranju';
$string['messageprovider:backup'] = 'Obavještenja o kreiranju rezervne kopije';
$string['messageprovider:badgecreatornotice'] = 'Obavještenja kreatora bedža';
$string['messageprovider:badgerecipientnotice'] = 'Obajveštenja primatelja bedža';
$string['messageprovider:courserequestapproved'] = 'Obavještenje o odobrenju zahtjeva za kreiranje kursa';
$string['messageprovider:courserequested'] = 'Obavještenje o zahtjevu za kreiranje kursa';
$string['messageprovider:courserequestrejected'] = 'Obavještenje o odbijanju zahtjeva za kreiranje kursa';
$string['messageprovider:errors'] = 'Važne greške u vezi sa sajtom';
$string['messageprovider:errors_help'] = 'Ovo su važne greške o kojima administrator mora da bude upoznat.';
$string['messageprovider:instantmessage'] = 'Lične poruke između korisnika';
$string['messageprovider:instantmessage_help'] = 'Ova sekcija konfiguriše šta se događa sa porukama koji su vam direktno poslane od strane drugih korisnika na ovom sajtu.';
$string['messageprovider:notices'] = 'Obavještenja o manjim problemima';
$string['messageprovider:notices_help'] = 'Ovo su obavještenja koja bi mogla da interesuju administratora, potrebno je da ih pogleda.';
$string['messageselect'] = 'Odaberite ovog korisnika kao primatelj poruke';
$string['messageselectadd'] = 'Pošalji poruku';
$string['middlename'] = 'Srednje ime';
$string['migratinggrades'] = 'Premještanje ocjena';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minuta';
$string['minutes'] = 'min';
$string['miscellaneous'] = 'Razno';
$string['missingcategory'] = 'Morate odabrati kategoriju';
$string['missingcity'] = 'Nedostaje grad/naselje';
$string['missingcountry'] = 'Nedostaje država';
$string['missingdescription'] = 'Nedostaje opis';
$string['missingemail'] = 'Nedostaje e-mail adresa';
$string['missingfirstname'] = 'Nedostaje ime';
$string['missingfromdisk'] = 'Nedostaje na disku';
$string['missingfullname'] = 'Nedostaje puno ime';
$string['missinglastname'] = 'Nedostaje prezime';
$string['missingname'] = 'Nedostaje ime';
$string['missingnewpassword'] = 'Nedostaje nova lozinka';
$string['missingpassword'] = 'Nedostaje lozinka';
$string['missingrecaptchachallengefield'] = 'Nedostaje polje za reCAPTCHA';
$string['missingreqreason'] = 'Nedostaje razlog';
$string['missingshortname'] = 'Nedostaje kratki naziv';
$string['missingshortsitename'] = 'Nedostaje kratki naziv sajta';
$string['missingsitedescription'] = 'Nedostaje opis sajta';
$string['missingsitename'] = 'Nedostaje naziv sajta';
$string['missingstrings'] = 'Provjera neprevedenih riječi ili izraza';
$string['missingstudent'] = 'Morate nešto odabrati';
$string['missingsummary'] = 'Nedostaje rezime';
$string['missingteacher'] = 'Morate nešto odabrati';
$string['missingurl'] = 'Nedostaje URL';
$string['missingusername'] = 'Nedostaje korisničko ime';
$string['modchooserdisable'] = 'Isključi birač aktivnosti';
$string['modchooserenable'] = 'Uključi birač aktivnost';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} ne podržava postavljanja tipa {$a->type}';
$string['modified'] = 'Izmijenjeno';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Podešavanje tabela modula';
$string['modulesuccess'] = '{$a} tabela je ispravno podešena';
$string['modulesused'] = 'Korišteni moduli';
$string['month'] = 'Mjesec';
$string['months'] = 'Mjeseci';
$string['moodledocs'] = 'Moodle dokumentacija';
$string['moodledocslink'] = 'Moodle dokumentacija za ovu stranicu';
$string['moodlerelease'] = 'Moodle verzija';
$string['moodleversion'] = 'Moodle verzija';
$string['more'] = 'još';
$string['morehelp'] = 'Više pomoći';
$string['moreinformation'] = 'Više informacija vezano za grešku';
$string['moreprofileinfoneeded'] = 'Molimo recite nam nešto više o sebi';
$string['mostrecently'] = 'najnovije';
$string['move'] = 'Premjesti';
$string['movecategoriessuccess'] = 'Uspješno premještene {$a->count} kategorije u kategoriju  \'{$a->to}';
$string['movecategoriestotopsuccess'] = 'Uspješno premještene {$a->count} kategorije na najviši nivo';
$string['movecategorycontentto'] = 'Premjesti u:';
$string['movecategorysuccess'] = 'Uspješno premještena kategorija \'{$a->moved}\' u kategoriju \'{$a->to}';
$string['movecategoryto'] = 'Premjesti kategoriju u:';
$string['movecategorytotopsuccess'] = 'Uspješno premještena kategorija \'{$a->moved}\' na najviši nivo';
$string['movecontent'] = 'Premjesti {$a}';
$string['movecontentstoanothercategory'] = 'Premjesti sadržaj u drugu kategoriju';
$string['movecourseto'] = 'Premjesti kurs u:';
$string['movedown'] = 'Premjesti dole';
$string['movefilestohere'] = 'Premjesti datoteke ovdje';
$string['movefull'] = 'Premjesti {$a} na ovu lokaciju';
$string['movehere'] = 'Premjesti ovdje';
$string['moveleft'] = 'Pomakni lijevo';
$string['moveright'] = 'Pomakni desno';
$string['movesection'] = 'Premjesti sekciju {$a}';
$string['moveselectedcategoriesto'] = 'Premjesti odabrane kategorije u';
$string['moveselectedcoursesto'] = 'Premjesti odabrane kurseve u...';
$string['movetoanotherfolder'] = 'Premjesti u drugi direktorij';
$string['moveup'] = 'Premjesti gore';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Nova šifra mora biti drugačija od trenutne';
$string['mustconfirm'] = 'Morate potvrditi svoju prijavu na sistem';
$string['mycourses'] = 'Moji kursevi';
$string['myfiles'] = 'Moje privatne datoteke';
$string['myfilesmanage'] = 'Uredi moje privatne datoteke';
$string['myhome'] = 'Moja naslovna strana';
$string['mymoodledashboard'] = 'Moja Moodle komandna tabla';
$string['myprofile'] = 'Moj profil';
$string['name'] = 'Naziv';
$string['nameforlink'] = 'Kako želite da nazovete ovaj link?';
$string['nameforpage'] = 'Kako želite da nazovete ovu stranicu?';
$string['navigation'] = 'Navigacija';
$string['needed'] = 'Potrebno';
$string['never'] = 'Nikad';
$string['neverdeletelogs'] = 'Nikad ne brisati dnevnik aktivnosti';
$string['new'] = 'Novo';
$string['newaccount'] = 'Novi korisnički račun';
$string['newcourse'] = 'Novi kurs';
$string['newpassword'] = 'Nova šifra';
$string['newpasswordfromlost'] = '<strong>OBAVJEŠTENJE:</strong> Vaša <strong>trenutna šifra</strong> biće vam poslana u <strong>drugoj</strong> od dvije poruke poslane u toku postupka za ponovno dobijanje izgubljene šifre. Provjerite da li ste primili zamjensku šifru prije nego što nastavite sa ovom akcijom';
$string['newpassword_help'] = 'Unesite novu šifru ili ostavite prazno polje kako biste zadržali trenutnu šifru.';
$string['newpasswordtext'] = 'Pozdrav {$a->firstname}, Vaša šifra za pristup sistemu \'{$a->sitename}\' je resetovana i dodijeljena Vam je nova privremena šifra. Vaši trenutni podaci za pristup sistemu su: korisničko ime: {$a->username} lozinka: {$a->newpassword} Molimo posjetite ovu stranicu kako biste promjenili svoju šifru: {$a->link} U većini programa za čitanje e-mail pošte, u redu iznad ovog biste trebali vidjeti plavi link na koji možete kliknuti. Ukoliko to nije slučaj, označite i kopirajte gornju adresu u adresnu liniju Vašeg Web pretraživača (Firefox, Mozilla, Internet Explorer, Opera,Chrome). Pozdrav, \'{$a->sitename}\' administrator, {$a->signoff}';
$string['newpicture'] = 'Nova slika';
$string['newpicture_help'] = 'Da biste dodali novu sliku, pronađite i odaberite jednu (u JPG ili PNG formatu) i kliknite na "Ažuriraj profil". Slika će biti isječena u obliku kvadrata a njena veličina smanjena na 100x100 piksela.';
$string['newsitem'] = 'vijest';
$string['newsitems'] = 'vijesti';
$string['newsitemsnumber'] = 'Broj vijesti koje treba prikazati';
$string['newsitemsnumber_help'] = 'Ovo podešavanje određuje koliko će se najnovijih vijesti pojaviti u bloku Najnovije vijesti, na stranici kursa. Ako podesite na "0 vijesti" ovaj blok neće biti prikazan.';
$string['newuser'] = 'Novi korisnik';
$string['newusernewpasswordsubj'] = 'Novi korisnički račun';
$string['newusernewpasswordtext'] = 'Poštovani {$a->firstname}, Otvoren vam je novi korisnički račun na sajtu \'{$a->sitename}\' i dodijeljena vam je nova privremena šifra. Vaše trenutne informacije za pristup sajtu su: korisničko ime: {$a->username} lozinka: {$a->newpassword} (moraćete da promijenite lozinku kada se prvi put prijavite na sistem) Da biste počeli da koristite sajt \'{$a->sitename}\', prijavite se na {$a->link} U većini programa za e-mail poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg web pretraživača. Administrator sajta \'{$a->sitename}\', {$a->signoff}';
$string['newusers'] = 'Novi korisnici';
$string['newwindow'] = 'novi prozor';
$string['next'] = 'Sljedeći';
$string['nextsection'] = 'Sljedeća sekcija';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Ne postoje blokovi koje možete dodati ovoj stranici.';
$string['nobody'] = 'Niko';
$string['nochange'] = 'Bez promjena';
$string['nocomments'] = 'Nema komentara';
$string['nocourses'] = 'Nema kurseva';
$string['nocoursesfound'] = 'Nijedan kurs ne sadrži pojam \'{$a}';
$string['nocoursesyet'] = 'Nema kurseva u ovoj kategoriji';
$string['nodstpresets'] = 'Administrator sistema nije omogućio podršku za Daylight Savings Time.';
$string['nofilesselected'] = 'Nije izabrana nijedna datoteka za ponovno postavljanje.';
$string['nofilesyet'] = 'Unutar ovog kursa još nije postavljena nijedna datoteka';
$string['nograde'] = 'Nema ocjene';
$string['nohelpforactivityorresource'] = 'Trenutno ne postoji pomoć vezana za ovaj resurs ili aktivnost';
$string['noimagesyet'] = 'Unutar ovog kursa još nije postavljena nijedna slika';
$string['nologsfound'] = 'Zapisi o aktivnosti nisu pronađeni';
$string['nomatchingusers'] = 'Nijedan korisnik se ne poklapa sa \'{$a}';
$string['nomorecourses'] = 'Nije pronađeno više kurseva koji se uklapaju sa zadatim kriterijima';
$string['nomoreidnumber'] = 'Ne koristi se ID broj da bi se izbjegle kolizije';
$string['none'] = 'Nema';
$string['noneditingteacher'] = 'Predavač bez uređivačkih prava';
$string['noneditingteacherdescription'] = 'Predavači bez uređivačkih prava mogu da predaju na kursevima i ocjenjuju studente, ali ne mogu da mijenjaju aktivnosti.';
$string['nonstandard'] = 'Nestandardno';
$string['nopendingcourses'] = 'Nema kurseva koji čekaju na odobrenje';
$string['nopotentialadmins'] = 'Nema potencijalnih administratora';
$string['nopotentialcreators'] = 'Nema potencijalnih kreatora kursa';
$string['nopotentialstudents'] = 'Nema potencijalnih studenata';
$string['nopotentialteachers'] = 'Nema potencijalnih predavača';
$string['norecentactivity'] = 'Nema skorašnjih aktivnosti';
$string['noreplybouncemessage'] = 'Odgovorili ste na e-mail adresu sa koje se poruke samo šalju (no-reply email address). Ako ste pokušavali da odgovorite na poruku sa foruma, molimo da to učinite direktno koristeći {$a} forume. Slijedi sadržaj vaše poruke:';
$string['noreplybouncesubject'] = '{$a} - vraćena e-mail poruka.';
$string['noreplyname'] = 'Nemojte odgovarati na ovu e-mail poruku';
$string['noresetrecord'] = 'Ne postoji zapis o tom zahtjevu za resetovanjem. Molimo pošaljite novi zahtjev za resetovanjem šifre.';
$string['noresults'] = 'Nema rezultata';
$string['normal'] = 'Normalno';
$string['normalfilter'] = 'Normalna pretraga';
$string['nosite'] = 'Nije pronađen kurs na nivou sajta';
$string['nostudentsfound'] = '{$a} nije pronađen';
$string['nostudentsingroup'] = 'Još nema studenata u ovoj grupi';
$string['nostudentsyet'] = 'Nijedan student još nije upisan na ovaj kurs';
$string['nosuchemail'] = 'Nema takve e-mail adrese';
$string['notavailable'] = 'Nije dostupno';
$string['noteachersyet'] = 'Još uvijek nema predavača na ovom kursu';
$string['notenrolled'] = '{$a} nije upisan/a na ovaj kurs.';
$string['notenrolledprofile'] = 'Ovaj profil nije dostupan jer korisnik nije prijavljen za ovaj kurs.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Napomena:</strong> Mogućnost mjenjanja datuma prilikom obnavljanja ove rezervne kopije je onemogućena jer nemate potrebna ovlaštenja.';
$string['noteuserschangednonetocourse'] = 'Napomena: Kada restaurirate korisničke podatke (u aktivnostima, datotekama ili porukama) morate da restaurirate i korisnike kursa. Ovo podešavanje je promijenjeno za vas.';
$string['nothingnew'] = 'Nema novosti od Vaše posljednje posjete';
$string['nothingtodisplay'] = 'Nema ničega za prikaz';
$string['notice'] = 'Napomena';
$string['noticenewerbackup'] = 'Ova datoteka sa rezervnom kopijom je napravljena pomoću Moodle verzije {$a->backuprelease} ({$a->backupversion}) i novija je od Vašeg trenutno instaliranog sistema Moodle {$a->serverrelease} ({$a->serverversion}). Ovo bi moglo uzrokovati određene nedosljednosti zbog toga što kompatibilnost sistema sa rezervnim kopijama kreiranim pomoću ranijih verzija ne može biti garantovana.';
$string['notifications'] = 'Obavještenja';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Korisnik: {$a->info}';
$string['notifyloginfailuresmessageend'] = '{$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Ovo je popis grešaka pri pristupu sistemu na {$a} od posljednjeg obavještenja koje ste primili';
$string['notifyloginfailuressubject'] = '{$a} :: Obavještenje o greškama pri pristupu sistemu';
$string['notincluded'] = 'Nije uključeno';
$string['notingroup'] = 'Nažalost, morate biti član grupe kako biste vidjeli ovu aktivnost.';
$string['notpublic'] = 'Nije javno!';
$string['nousersfound'] = 'Nije pronađen nijedan korisnik';
$string['nousersmatching'] = 'Nije pronađen nijedan korisnik koji se podudara sa \'{$a}';
$string['nousersyet'] = 'Još nema korisnika';
$string['novalidcourses'] = 'Nema važećih kurseva za prikazivanje';
$string['now'] = 'sada';
$string['numattempts'] = '{$a} neuspješnih pristupa sistemu';
$string['numberofcourses'] = 'Broj kurseva';
$string['numberweeks'] = 'Broj sedmica/tema';
$string['numdays'] = '{$a} dan(a)';
$string['numhours'] = '{$a} h';
$string['numletters'] = '??? slovo(a)';
$string['numminutes'] = '{$a} min';
$string['nummonths'] = '{$a} mjesec(a)';
$string['numseconds'] = '{$a} s';
$string['numviews'] = '{$a} pregled(a)';
$string['numweeks'] = '{$a} sedmica(e)';
$string['numwords'] = '{$a} riječ(i)';
$string['numyears'] = '{$a} godina(e)';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Trenutna šifra';
$string['olduserdirectory'] = 'Ovo je STARI korisnički direktorij koji više nije potreban. Možete ga slobodno obrisati. Datoteke iz ovog direktorija su kopirane u NOVI korisnički direktorij.';
$string['opentoguests'] = 'Pristup gostima';
$string['optional'] = 'opcionalno';
$string['options'] = 'opcije';
$string['order'] = 'Redoslijed';
$string['originalpath'] = 'Originalna putanja';
$string['other'] = 'Ostali';
$string['outline'] = 'Kratak pregled';
$string['outlinereport'] = 'Skraćeni izvještaj';
$string['page'] = 'Stranica';
$string['pageheaderconfigablock'] = 'Konfigurisanje bloka u {$a->fullname}';
$string['pagepath'] = 'Putanja do stranice';
$string['pageshouldredirect'] = 'Ova stranica bi trebala da vas automatski preusmjeri. Ukoliko se ništa ne događa molimo Vas da za nastavak upotrijebite donji link.';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parentcoursenotfound'] = 'Nadređeni kurs nije pronađen!';
$string['parentfolder'] = 'Nadređeni direktorij';
$string['participants'] = 'Učesnici';
$string['participantslist'] = 'Popis učesnika';
$string['participationratio'] = 'Odnos učešća';
$string['participationreport'] = 'Izvještaj o učešću';
$string['password'] = 'Lozinka';
$string['passwordchanged'] = 'Lozinka je promijenjena';
$string['passwordconfirmchange'] = 'Potvrdite promjenu lozinke';
$string['passwordextlink'] = 'Sljedeći link Vam je na raspolaganju za obnavljanje Vaše izgubljene lozinke. Klik na njega će Vas izvesti iz Moodle sistema.';
$string['passwordforgotten'] = 'Zaboravljena šifra';
$string['passwordforgotteninstructions'] = 'Vaši podaci prvo moraju biti pronađeni u bazi podataka korisnika. Molimo unesite <strong>ili</strong> svoje korisničko ime ili prijavljenu e-mail adresu u odgovarajuće polje. Nema potrebe da unosite oba podatka.';
$string['passwordforgotteninstructions2'] = 'Za resetovanje Vaše šifre upišite svoje korisničko ime ili e-mail adresu. Ukoliko ti podaci postoje u bazi podataka, biće Vam poslana e-mail poruka na e-mail adresu sa uputstvom kako ponovo da dobijete pristup.';
$string['passwordnohelp'] = 'Nije na raspolaganju nikakva pomoć za pronalaženje Vaše izgubljenje šifre. Molimo kontaktirajte Vašeg Moodle administratora.';
$string['passwordrecovery'] = 'Da, treba mi pomoć za pristup sistemu';
$string['passwordsdiffer'] = 'Šifre se ne poklapaju';
$string['passwordsent'] = 'Šifra je poslana';
$string['passwordsenttext'] = '<p>E-mail poruka je poslana na Vašu e-mail adresu {$a->email}.</p> <p><b>Molimo provjerite Vaš e-mail kako biste primili novu šifru</b></p> <p>Nova šifra je automatski generisana, pa biste je možda željeli <a href="{$a->link}">promijeniti u nešto što ćete moći lakše da zapamtite</A>.</p>';
$string['passwordset'] = 'Vaša šifra je postavljena.';
$string['path'] = 'Putanja';
$string['pathnotexists'] = 'Putanja ne postoji na Vašem serveru!';
$string['pathslasherror'] = 'Putanja se ne može završavati kosom crtom!';
$string['paymentinstant'] = 'Upotrijebite dugme ispod kako biste izvršili uplatu i upisali kurs u roku od nekoliko minuta!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> na čekanju</small>)';
$string['paymentrequired'] = 'Ovaj kurs nije besplatan.';
$string['payments'] = 'Uplate';
$string['paymentsorry'] = 'Hvala vam na uplati! Nažalost vaša uplata još nije potpuno obrađena, te još niste registrovani za pristup kursu "{$a->fullname}". Pokušajte da nastavite sa pristupom kursu za nekoliko sekundi, ali ako i dalje budete imali poteškoće, molimo vas da obavijestite predavača {$a->teacher} ili administratora sajta';
$string['paymentthanks'] = 'Hvala Vam na Vašoj uplati! Sada ste upisani na kurs:<br />"{$a}"';
$string['pendingrequests'] = 'Zahtjevi na čekanju';
$string['periodending'] = 'Završetak perioda ({$a})';
$string['perpage'] = 'Po stranici';
$string['perpagea'] = 'Po stranici: {$a}';
$string['personal'] = 'Lično';
$string['personalprofile'] = 'Lični profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobilni telefon';
$string['phpinfo'] = 'PHP informacije';
$string['pictureof'] = 'Slika {$a}';
$string['pictureofuser'] = 'Slika korisnika';
$string['pleaseclose'] = 'Molimo Vas da sada zatvorite ovaj prozor.';
$string['pleasesearchmore'] = 'Nastavite pretragu';
$string['pleaseusesearch'] = 'Upotrijebite pretragu';
$string['plugin'] = 'Dodatak';
$string['plugincheck'] = 'Provjera dodataka';
$string['plugindeletefiles'] = 'Svi podaci povezani sa dodatkom: \'{$a->name}\' su izbrisani iz baze podataka. Da biste spriječili automatsku reinstalaciju dodatka, sada treba da izbrišete ovaj direktorij sa servera : {$a->directory}';
$string['pluginsetup'] = 'Podešavanje tabele dodataka';
$string['policyaccept'] = 'Razumijem i pristajem';
$string['policyagree'] = 'Da bi ste nastavili korištenje ovog sajta morate se složiti sa pravilima korištenja. Da li se slažete?';
$string['policyagreement'] = 'Saglasnost sa pravilnikom o korištenju sajta';
$string['policyagreementclick'] = 'Link ka pravilniku o korištenju sajta';
$string['popup'] = 'popup prozor';
$string['popupwindow'] = 'Otvori datoteku u novom prozoru';
$string['popupwindowname'] = 'Popup prozor';
$string['post'] = 'Poruka';
$string['posts'] = 'Poruke';
$string['potentialadmins'] = 'Potencijalni administratori';
$string['potentialcreators'] = 'Potencijalni kreatori kursa';
$string['potentialstudents'] = 'Potencijalni studenti';
$string['potentialteachers'] = 'Potencijalni predavači';
$string['preferences'] = 'Preferencije';
$string['preferredlanguage'] = 'Preferirani jezik';
$string['preferredtheme'] = 'Preferirana grafička tema';
$string['preprocessingbackupfile'] = 'Predprocesiranje datoteke rezervne kopije';
$string['prev'] = 'Prethodni';
$string['preview'] = 'Pregled';
$string['previewhtml'] = 'Pregled u HTML formatu';
$string['previeworchoose'] = 'Pregled ili izbor šeme izgleda sajta';
$string['previous'] = 'Prethodni';
$string['previouslyselectedusers'] = 'Prethodno izabrani korisnik se ne poklapa sa \'{$a}';
$string['previoussection'] = 'Prethodna sekcija';
$string['primaryadminsetup'] = 'Podešavanje administratorskog računa';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Ovaj opis korisničkog profila neće biti prikazan sve dok se korisnik ne upiše barem na jedan kurs.';
$string['publicprofile'] = 'Javni profil';
$string['publicsitefileswarning'] = 'Napomena: Datotekama koje su ovdje smještene svi mogu pristupiti.';
$string['publicsitefileswarning2'] = 'Napomena: Datotekama koje su ovdje smještene može da pristupi svako ko zna (ili pogodi) URL. Iz razloga sigurnosti, preporučuje se brisanje datoteka rezervne kopije odmah nakon završetka njihovog restauriranja.';
$string['publicsitefileswarning3'] = 'Napomena: Datotekama koje su ovdje postavljene može da pristupi svako ko zna (ili može da pogodi) URL.<br /> Iz razloga sigurnosti, datoteke rezervne kopije bi trebalo da budu čuvane samo u zato predviđenom direktoriju (backupdata).';
$string['publish'] = 'Objavi';
$string['question'] = 'Pitanje';
$string['questionsinthequestionbank'] = 'Pitanja u bazi pitanja';
$string['readinginfofrombackup'] = 'Učitavanje informacija iz rezervne kopije';
$string['readme'] = 'ReadMe';
$string['recentactivity'] = 'Nedavna aktivnost';
$string['recentactivityreport'] = 'Potpuni izvještaj o nedavnim aktivnostima...';
$string['recipientslist'] = 'Popis primalaca';
$string['recreatedcategory'] = 'Ponovno kreirana kategorija {$a}';
$string['redirect'] = 'Preusmjeri';
$string['reducesections'] = 'Smanji broj sekcija';
$string['refresh'] = 'Osvježi';
$string['refreshingevents'] = 'Osvježavanje događaja';
$string['registration'] = 'Moodle registracija';
$string['registrationcontact'] = 'Javni kontakt';
$string['registrationcontactno'] = 'Ne, ne želim kontaktnu formu na popisu sajtova';
$string['registrationcontactyes'] = 'Da, prikažite formu kako bi me drugi Moodle korisnici mogli kontaktirati';
$string['registrationemail'] = 'Obavještenja putem e-mail adrese';
$string['registrationinfo'] = '<p>Ova strana vam omogućava da registrujete svoj Moodle sajt na moodle.org. Registracija je besplatna. Glavna korist registracije je u tome što ćete biti dodati na ograničenu mailing listu za primanje važnih obavještenja, kao što su sigurnosna upozorenja i nova izdanja Moodlea.</p> <p>Standardno, vaši podaci će se čuvati kao povjerljivi, i nikada neće biti prodati ili proslijeđeni nekom drugom. Jedini razlog za prikupljanje ovih informacija jeste podrška, kao i pomoć u formiranju statističke slike o cijelokupnoj Moodle zajednici.</p> <p>Ako izaberete, možete dozvoliti da ime Vašeg sajta, država i URL adresa budu dodati na javnu listu Moodle sajtova.</p> <p>Sve nove registracije se ručno provjeravaju prije dodavanja na popis. Kad se jednom nađete na listi, možete ažurirati svoju registraciju (i svoje podatke na javnoj listi) u bilo kojem trenutku, tako što ćete ponovo poslati ovaj obrazac.</p>';
$string['registrationinfotitle'] = 'Informacije o registraciji';
$string['registrationno'] = 'Ne, ne želim da primam obavještenja putem e-maila';
$string['registrationsend'] = 'Slanje podataka za prijavu na moodle.org';
$string['registrationyes'] = 'Da, molim obavještavajte me o važnim dešavanjima';
$string['reject'] = 'Odbij';
$string['rejectdots'] = 'Odbij...';
$string['reload'] = 'Učitaj ponovo';
$string['remoteappuser'] = 'Udaljeni {$a} Korisnik';
$string['remove'] = 'Ukloni';
$string['removeadmin'] = 'Ukloni administratora';
$string['removecreator'] = 'Ukloni kreatora kursa';
$string['removestudent'] = 'Ukloni studenta';
$string['removeteacher'] = 'Ukloni predavača';
$string['rename'] = 'Preimenovanje';
$string['renamefileto'] = 'Preimenovanje <b>{$a}</b> u';
$string['report'] = 'Izvještaj';
$string['reports'] = 'Izvještaji';
$string['repositories'] = 'Repozitorij';
$string['requestcourse'] = 'Zahtijevaj kurs';
$string['requestedby'] = 'Zahtijevan od strane';
$string['requestedcourses'] = 'Zahtijevani kursevi';
$string['requestreason'] = 'Razlog za zahtijevanje kursa';
$string['required'] = 'Obavezno';
$string['requirespayment'] = 'Ovaj kurs zahtijeva plaćanje za pristup';
$string['reset'] = 'Resetiranje';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Resetiranje kursa';
$string['resetinfo'] = 'Ova stranica Vam dozvoljava da iz kursa izbrišete sve podatke o korisnicima, zadržavajući aktivnosti i druga podešavanja. Molimo budite obazrivi jer izborom stavki ispod i potvrđivanjem ove forme trajno brišete izabrane korisnike i sve podatke vezane za njih sa ovog kursa!';
$string['resetnotimplemented'] = 'Resetiranje nije izvršeno';
$string['resetrecordexpired'] = 'Link za resetovanje šifre koji ste koristili je stariji od  {$a} minuta i istekao je. Molimo podnesite novi zahtjev za resetovanjem šifre.';
$string['resetstartdate'] = 'Resetiraj datum početka';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Zadatak';
$string['resettodefaults'] = 'Vraćanje na zadane vrijednosti';
$string['resortbyfullname'] = 'Po punom imenu';
$string['resortbyidnumber'] = 'Po ID broju';
$string['resortbyshortname'] = 'Po kratkom imenu';
$string['resortcourses'] = 'Sortiraj kurseve';
$string['resortsubcategoriesbyidnumber'] = 'Sortiraj podkategorije po ID broju';
$string['resortsubcategoriesbyname'] = 'Sortiraj podkategorije po nazivu';
$string['resource'] = 'Resurs';
$string['resourcedisplayauto'] = 'Automatski';
$string['resourcedisplaydownload'] = 'Primoraj preuzimanje';
$string['resourcedisplayembed'] = 'Ugradi (Embed)';
$string['resourcedisplayframe'] = 'U okviru (frame)';
$string['resourcedisplaynew'] = 'Novi prozor';
$string['resourcedisplayopen'] = 'Otvori';
$string['resourcedisplaypopup'] = 'U pop-up prozoru';
$string['resources'] = 'Resursi';
$string['resources_help'] = 'Resursi omogućavaju dodavanje bilo koje vrste Web sadržaja na Vaš kurs.';
$string['restore'] = 'Restauriranje rezervne kopije';
$string['restorecancelled'] = 'Restauriranje je otkazano';
$string['restorecannotassignroles'] = 'Procedura obnavljanja rezervne kopije podataka mora da dodijeli uloge, a Vi nemate ovlaštenje za to';
$string['restorecannotcreateorassignroles'] = 'Procedura obnavljanja rezervne kopije podataka mora da kreira ili dodijeli uloge, a Vi nemate ovlaštenje za to';
$string['restorecannotcreateuser'] = 'Procedura obnavljanja rezervne kopije podataka mora da kreira korisnika \'{$a}\', a Vi nemate ovlaštenje za to';
$string['restorecannotoverrideperms'] = 'Procedura obnavljanja rezervne kopije podataka mora da izmjeni ovlaštenja, a Vi nemate ovlaštenje za to';
$string['restorecoursenow'] = 'Restaurirajte ovaj kurs upravo sada!';
$string['restoredaccount'] = 'Obnovljeni korisnički račun';
$string['restoredaccountinfo'] = 'Ovaj korisnički račun je uvezen sa drugog servera i lozinka je izgubljena. Kako biste zadali novu lozinku pomoću e-maila, kliknite na "Nastavi"';
$string['restorefinished'] = 'Restauriranje je uspješno završeno';
$string['restoreto'] = 'Restaurirati u';
$string['restoretositeadding'] = 'Upozorenje! Želite da restaurirate rezervnu kopiju na naslovnu stranicu sajta, tako što ćete postojećem pridodati novi sadržaj!';
$string['restoretositedeleting'] = 'Upozorenje! Želite da restaurirate rezervnu kopiju na naslovnu stranicu sajta, tako što ćete prvo obrisati postojeći sadržaj sa nje!';
$string['restoreuserconflict'] = 'Pokušaj restauriranja korisnika \'{$a}\' iz rzervene kopije podataka će prouzrokovati konflikt';
$string['restoreuserinfofailed'] = 'Proces restauriranja podataka je zaustavljen jer nemate ovlaštenja za restauriranje korisničkih podataka.';
$string['restoreusersprecheck'] = 'Provjera korisničkih podataka';
$string['restoreusersprecheckerror'] = 'Uočeni su određeni problemi prilikom provjere korisničkih podataka';
$string['restricted'] = 'Ograničeno';
$string['returningtosite'] = 'Već posjedujete korisnički račun?';
$string['returntooriginaluser'] = 'Vrati se na {$a}';
$string['revert'] = 'Vratite se nazad';
$string['role'] = 'Uloga';
$string['roleassignments'] = 'Dodjele uloga';
$string['rolemappings'] = 'Mapiranja uloga';
$string['rolerenaming'] = 'Preimenovanje uloge';
$string['rolerenaming_help'] = 'Ovo podešavanje omogućava promjenu prikazanih naziva za uloge koje se koriste na kursu. Mijenja se samo prikazani naziv uloge - ovlaštenja uloge ostaju ista. Novi nazivi uloga će se pojaviti na stranici sa učesnicima kursa i svim ostalim mjestima unutar kursa. Ukoliko je uloga kojoj je promijenjen naziv jedna od onih koju je administrator izabrao kao "menadžer kursa", novi naziv uloge će se, također, pojaviti i kao dio spiska kurseva.';
$string['roles'] = 'Uloge';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Broj novih RSS članaka';
$string['rsserror'] = 'Greška u čitanju RSS podataka';
$string['rsserrorauth'] = 'RSS link ne sadrži ispravan token za provjeru identiteta.';
$string['rsserrorguest'] = 'Ovaj RSS izvor vijesti koristi anonimni (kao gost) pristup podacima, ali gosti ovdje nemaju ovlaštenje za čitanje podataka. Posjetite izvornu lokaciju sa koje ovaj izvor vijesti dolazi (URL) kao registrovani korisnik i preuzmite odatle novi RSS link.';
$string['rsskeyshelp'] = 'Da bi se obezbijedila sigurnost i privatnost, URL adresa RSS izvora sadrži specijalni token koji identifikuje korisnika za koga je token kreiran. Ovo će spriječiti druge korisnike da preko RSS izvora pristupe onim dijelovima Moodlea kojima to ne bi smjeli. Ovaj token se automatski kreira kada prvi put pristupate dijelu Moodlea koji proizvodi RSS izvor. Ako mislite da je je Vaš token RSS izvora na neki način kompromitovan možete zatražiti novi token tako što ćete ovdje kliknuti na link \'Resetirajj\'. Molimo vas, imajte u vidu da će trenutna URL adresa RSS izvora postati nevažeća.';
$string['rsstype'] = 'RSS servis za ovu aktivnost';
$string['saveandnext'] = 'Sačuvaj i prikaži sljedeće';
$string['savechanges'] = 'Sačuvaj promjene';
$string['savechangesanddisplay'] = 'Sačuvaj i prikaži';
$string['savechangesandreturntocourse'] = 'Sačuvaj i vrati se na kurs';
$string['savecomment'] = 'Sačuvaj komentar';
$string['savedat'] = 'Sačuvano u:';
$string['savepreferences'] = 'Sačuvaj svojstva';
$string['saveto'] = 'Sačuvaj u';
$string['scale'] = 'Skala za ocjenjivanje';
$string['scale_help'] = 'Skala pruža način za evaluaciju ili ocjenjivanja postignuća unutar aktivnosti. Definirana je kao uređena lista vrijednosti, u rasponu od negativnih do pozitivnih, odvojenih zarezima. Na primjer: "Razočaravajuće, Nedovoljno dobro, Prosječno, Dobro, Vrlo dobro, Odlično!"';
$string['scales'] = 'Skale za ocjenjivanje';
$string['scalescustom'] = 'Prilagođene skale za ocjenjivanje';
$string['scalescustomcreate'] = 'Dodavanje nove skale za ocjenjivanje';
$string['scalescustomno'] = 'Prilagođene skale za ocjenjivanje još uvijek nisu kreirane';
$string['scalesstandard'] = 'Standardne skale za ocjenjivanje';
$string['scalestandard'] = 'Standardna skala';
$string['scalestandard_help'] = 'Standardna skala je dostupna na nivou cijelog sajta, za sve kurseve.';
$string['scalestip'] = 'Kako biste kreirali sopstvene, prilagođene skale za ocjenjivanje, upotrijebite link \'Skale...\' u meniju za administraciju kursa.';
$string['scalestip2'] = 'Da bi ste kreirali prilagođene skale, kliknite na link "Ocjene" u administrativnom meniju kursa, a onda odaberite "Uredi Skale".';
$string['schedule'] = 'Raspored';
$string['screenshot'] = 'Screenshot (slika) ekrana';
$string['search'] = 'Pretraga';
$string['searchagain'] = 'Potraži ponovo';
$string['searchbyemail'] = 'Pretraživanje po e-mail adresi';
$string['searchbyusername'] = 'Pretraživanje po korisničkom imenu';
$string['searchcourses'] = 'Pretraži kurseve';
$string['searchhelp'] = 'Možete tražiti više riječi odjednom.<br /><br />riječ : traženje bilo kog pojavljivanja ove riječi u tekstu (pa i u sklopu drugih riječi).<br />+riječ : traženje isključivo onog oblika riječi koji je unijet.<br />-riječ : prikazuju se samo oni rezultati u kojima nema navedene riječi.';
$string['search_help'] = 'Za osnovno pretraživanje jedne ili više riječi bilo gdje u tekstu, samo ih upišite odvojene razmacima. Mogu se pretraživati sve riječi duže od 2 znaka. Za napredno pretraživanje, kliknite na dugme za pretragu bez upisivanja pojmova u polje za pretragu, kako biste pristupili obrascu za napredno pretraživanje.';
$string['searchoptions'] = 'Opcije za pretragu';
$string['searchresults'] = 'Rezultati pretrage';
$string['sec'] = 'sek';
$string['seconds'] = 'sekunde';
$string['secondstotime172800'] = '2 dana';
$string['secondstotime259200'] = '3 dana';
$string['secondstotime345600'] = '4 dana';
$string['secondstotime432000'] = '5 dana';
$string['secondstotime518400'] = '6 dana';
$string['secondstotime604800'] = '1 sedmica';
$string['secondstotime86400'] = '1 dan';
$string['secretalreadyused'] = 'Link za potvrdu promjene lozinke je već korišten, lozinka nije bila promijenjena.';
$string['secs'] = 's';
$string['section'] = 'Sekcija';
$string['sectionname'] = 'Naziv sekcije';
$string['sections'] = 'Sekcije';
$string['sectionusedefaultname'] = 'Koristi zadani naziv sekcije';
$string['seealsostats'] = 'Pogledajte i statistiku';
$string['selctauser'] = 'Odaberi korisnika';
$string['select'] = 'Odaberite';
$string['selectacategory'] = 'Molimo odaberite kategoriju';
$string['selectacountry'] = 'Odaberite državu';
$string['selectacourse'] = 'Odaberite kurs';
$string['selectacoursesite'] = 'Odaberite kurs ili stranicu';
$string['selectagroup'] = 'Odaberite grupu';
$string['selectall'] = 'Odaberi sve';
$string['selectamodule'] = 'Molimo odaberite modul aktivnosti';
$string['selectanaction'] = 'Odaberite akciju/e';
$string['selectanoptions'] = 'Odaberite opciju/e';
$string['selectaregion'] = 'Odaberite region';
$string['selectcategorysort'] = 'Koje kategorije želite sortirati';
$string['selectcategorysortby'] = 'Odaberite kako želite sortirati kategorije';
$string['selectcoursesortby'] = 'Odaberite kako želite sortirati kurseve';
$string['selectdefault'] = 'Odaberi zadano';
$string['selectedcategories'] = 'Odabrane kategorije';
$string['selectedfile'] = 'Odabrana datoteka';
$string['selectednowmove'] = '{$a} datoteka označena za premještanje. Sada idite na mjesto gdje želite da premjestite datoteke i kliknite na \'Premjesti datoteke ovdje';
$string['selectfiles'] = 'Odaberite datoteke';
$string['selectmoduletoviewhelp'] = 'Odaberite modul kako biste vidjeli pomoć za njega';
$string['selectnos'] = 'Odaberite "Ne" za sve';
$string['selectperiod'] = 'Odaberite period';
$string['senddetails'] = 'Pošalji moje lične podatke e-mailom';
$string['separate'] = 'Razdvoji';
$string['separateandconnected'] = 'Odvojeni i povezani načini saznavanja';
$string['separateandconnectedinfo'] = 'Ova skala se zasniva na teoriji odvojenog i povezanog saznavanja. Ova teorija opisuje dva različita načina na koje možemo da učimo o stvarima koje vidimo i čujemo. <ul> <li><strong>Odvojeni način učenja</strong> - učenici ostaju objektivni što je više moguće bez uključivanja osjećanja. U diskusiji sa drugim ljudima, oni vole da brane svoje ideje i stavove, koristeći logiku kako bi pronašli nedostatke u idejama svojih oponenata.</li> <li><strong>Povezani način učenja</strong> - učenici su više osjetljivi na druge ljude. Oni imaju razvijenu sposobnost empatije i pokazuju tendenciju da slušaju i postavljaju pitanja dok ne osjete da mogu "razumjeti stvari iz ugla gledanja svojih sagovornika". Oni uče tako što pokušavaju da dijele iskustva koja vode znanju koje pronalaze kod drugih ljudi.</li></ul>';
$string['servererror'] = 'Došlo je do greške u toku komunikacije sa serverom';
$string['serverlocaltime'] = 'Lokalno vrijeme servera';
$string['setcategorytheme'] = 'Podesi grafičku temu kategorije';
$string['setpassword'] = 'Postavite šifru';
$string['setpasswordinstructions'] = 'Molimo unesite i ponovite Vašu novu šifru ispod, zatim kliknite na "Postaviti šifru". <br />Vaša nova šifra će biti spašena, a vi ćete biti prijavljeni.';
$string['settings'] = 'Podešavanja';
$string['shortname'] = 'Kratki naziv';
$string['shortnamecollisionwarning'] = '[*] = Ovaj kratki naziv već koristi neki drugi kurs, te će morati biti promijenjen po odobravanju';
$string['shortnamecourse'] = 'Skraćeni naziv kursa';
$string['shortnamecourse_help'] = 'Skraćen naziv kursa se prikazuje u navigaciji i kao dio naslova e-mail poruke koja se šalje sa sa kursa.';
$string['shortnametaken'] = 'Navedena skraćenica je već u upotrebi za neki drugi kurs ({$a})';
$string['shortnameuser'] = 'Kraće ime korisnika';
$string['shortsitename'] = 'Kratki naziv sajta (npr. jedna riječ)';
$string['show'] = 'Prikaži';
$string['showactions'] = 'Prikaži akcije';
$string['showadvancedsettings'] = 'Prikaži napredna podešavanja';
$string['showall'] = 'Prikaži sve {$a}';
$string['showallcourses'] = 'Prikaži sve kurseve';
$string['showallusers'] = 'Prikaži sve korisnike';
$string['showblockcourse'] = 'Prikaži popis kurseva koji sadrže blokove';
$string['showcategory'] = 'Prikaži {$a}';
$string['showcomments'] = 'Prikaži/sakrij komentare';
$string['showcommentsnonjs'] = 'Prikaži komentare';
$string['showdescription'] = 'Prikaži opis na stranici kursa';
$string['showdescription_help'] = 'Ako je ovo podešavanje omogućeno, gornji uvod/opis biće prikazan na stranici kursa odmah ispod linka aktivnosti/resursa.';
$string['showgrades'] = 'Prikaži ocjene studentima';
$string['showgrades_help'] = 'Mnoge aktivnosti na kursu se mogu ocijenjivati. Ovo podešavanje određuje da li student može da vidi popis svih svojih ocjena na kursu preko linka "Ocjene" u bloku za administraciju kursa.';
$string['showingacourses'] = 'Prikaz svih {$a} kurseva';
$string['showingxofycourses'] = 'Prikaz kurseva {$a->start} do {$a->end} od {$a->total} kurseva';
$string['showlistofcourses'] = 'Prikaži popis kurseva';
$string['showmodulecourse'] = 'Prikaži popis kurseva koji sadrže aktivnosti';
$string['showonly'] = 'Prikaži samo';
$string['showperpage'] = 'Prikaži {$a} po stranici';
$string['showrecent'] = 'Prikaži nedavne aktivnosti';
$string['showreports'] = 'Prikaži izvještaje o aktivnostima';
$string['showreports_help'] = 'Izvještaji o aktivnostima prikazuju aktivnost svakog učesnika na kursu. Osim popisa njihovih doprinosa, poput poruka na forumima ili predatih radova za zadatke, ovi izvještaji, također, uključuju zapise o pristupima. Ovo podešavanje određuje da li studenti mogu da vide izvještaje o svojoj aktivnosti, preko njihovih stranica sa profilom.';
$string['showsettings'] = 'Prikaži podešavanja';
$string['showtheselogs'] = 'Prikaži ove zapise o aktivnostima';
$string['showthishelpinlanguage'] = 'Prikaži ovu pomoć na jeziku: {$a}';
$string['since'] = 'Od';
$string['sincelast'] = 'od posljednjeg pristupa sistemu';
$string['site'] = 'Sajt';
$string['sitedefault'] = 'Zadano za sajt';
$string['siteerrors'] = 'Greške na sajtu';
$string['sitefiles'] = 'Datoteke sajta';
$string['sitefilesused'] = 'Datoteke sajta korištene na ovom kursu';
$string['sitehome'] = 'Naslovna strana sajta';
$string['sitelegacyfiles'] = 'Izvorne datoteke sajta';
$string['sitelogs'] = 'Zapisi o aktivnostima na sajtu';
$string['sitenews'] = 'Novosti';
$string['sitepages'] = 'Stranice sajta';
$string['sitepartlist'] = 'Nemate odgovarajuće dozvole za pregled popisa učesnika';
$string['sitepartlist0'] = 'Morate biti predavač sajta da bi Vam bilo dozvoljeno da vidite popis učesnika sajta.';
$string['sitepartlist1'] = 'Morate biti predavač da bi Vam bilo dozvoljeno da vidite popis učesnika sajta.';
$string['sites'] = 'Sajtovi';
$string['sitesection'] = 'Uključi i tematsku sekciju';
$string['sitesettings'] = 'Podešavanja sajta';
$string['siteteachers'] = 'Predavači sajta';
$string['size'] = 'Veličina';
$string['sizeb'] = 'bajta';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['skipped'] = 'Preskočeno';
$string['skiptocategorylisting'] = 'Preskočiti na listu kategorija';
$string['skiptocoursedetails'] = 'Preskočiti na detaljne informacije o kursu';
$string['skiptocourselisting'] = 'Preskočiti na listu kurseva';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Društveni forum - najnovije teme';
$string['someallowguest'] = 'Neki od kurseva mogu dozvoliti pristup gostima (anonimnim korisnicima)';
$string['someerrorswerefound'] = 'Pojedine informacije nedostaju ili su netačne. Pogledajte detalje ispod.';
$string['sort'] = 'Sortiraj';
$string['sortby'] = 'Sortiraj po';
$string['sortbyx'] = 'Sortiraj prema {$a} u uzlaznom nizu';
$string['sortbyxreverse'] = 'Sortiraj prema {$a} u silaznom nizu';
$string['sortcategoriesbyidnumber'] = 'Sortiraj kategorije prema ID broju';
$string['sortcategoriesbyname'] = 'Sortiraj kategorije po nazivu';
$string['sortcoursesbyfullname'] = 'Sortiraj kategorije po punom nazivu';
$string['sortcoursesbyidnumber'] = 'Sortiraj kurseve po ID broju';
$string['sortcoursesbyshortname'] = 'Sortiraj kurseve po kratkom nazivu';
$string['sorting'] = 'Sortiranje';
$string['sourcerole'] = 'Izvorna uloga';
$string['specifyname'] = 'Morate navesti ime.';
$string['standard'] = 'Standardno';
$string['starpending'] = '([*] = kurs čeka na odobrenje)';
$string['startdate'] = 'Datum početka kursa';
$string['startdate_help'] = 'Ovo podešavanje određuje početak prve sedmice za kurs u sedmičnom formatu. Ono također određuje najraniji datum za koji će biti dostupni zapisi o aktivnostima na kursu.';
$string['startingfrom'] = 'Počni od';
$string['startsignup'] = 'Kreiranje novog korisničkog računa';
$string['state'] = 'Država/Republika';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Grafik statistike';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Pristupi sistemu';
$string['statsmodedetailed'] = 'Detaljni (korisnički) prikaz';
$string['statsmodegeneral'] = 'Opšti prikaz';
$string['statsnodata'] = 'Nema dostupnih podataka za tu kombinaciju kursa i vremenskog perioda.';
$string['statsnodatauser'] = 'Nema dostupnih podataka za tu kombinaciju kursa, korisnika i vremenskog perioda.';
$string['statsoff'] = 'Statistika trenutno nije omogućena';
$string['statsreads'] = 'Pregledi';
$string['statsreport1'] = 'Pristupi sistemu';
$string['statsreport10'] = 'Aktivnost korisnika';
$string['statsreport11'] = 'Najaktivniji kursevi';
$string['statsreport12'] = 'Najaktivniji kursevi (vrijednosno)';
$string['statsreport13'] = 'Kursevi sa najviše učešća (upisa)';
$string['statsreport14'] = 'Kursevi sa najviše učešća (prikaza/poruka)';
$string['statsreport2'] = 'Prikaži (sve uloge)';
$string['statsreport3'] = 'Poruke (sve uloge)';
$string['statsreport4'] = 'Ukupna aktivnost (sve uloge)';
$string['statsreport5'] = 'Ukupna aktivnost (prikazi i poruke)';
$string['statsreport7'] = 'Aktivnost korisnika (prikazi i poruke)';
$string['statsreport8'] = 'Sve aktivnosti korisnika';
$string['statsreport9'] = 'Pristupi (sajtu/kursu)';
$string['statsreportactivity'] = 'Ukupna aktivnost (sve uloge)';
$string['statsreportactivitybyrole'] = 'Ukupna aktivnost (pregledi i poruke)';
$string['statsreportforuser'] = 'za';
$string['statsreportlogins'] = 'Pristupi sistemu';
$string['statsreportreads'] = 'Prikazi (sve uloge)';
$string['statsreporttype'] = 'Tip izvještaja';
$string['statsreportwrites'] = 'Poruke (sve uloge)';
$string['statsstudentactivity'] = 'Studentska aktivnost';
$string['statsstudentreads'] = 'Studentski prikazi';
$string['statsstudentwrites'] = 'Studentske poruke';
$string['statsteacheractivity'] = 'Aktivnost predavača';
$string['statsteacherreads'] = 'Prikazi predavača';
$string['statsteacherwrites'] = 'Poruke predavača';
$string['statstimeperiod'] = 'Vremenski period - trajanje:';
$string['statsuniquelogins'] = 'Jedinstvene prijave';
$string['statsuseractivity'] = 'Sve aktivnosti';
$string['statsuserlogins'] = 'Pristupi sistemu';
$string['statsuserreads'] = 'Prikazi';
$string['statsuserwrites'] = 'Poruke';
$string['statswrites'] = 'Poruke';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Sljedeći izrazi nisu definisani u {$a}';
$string['studentnotallowed'] = 'Nažalost, ne možete pristupiti ovom kursu kao \'{$a}';
$string['students'] = 'Studenti';
$string['studentsandteachers'] = 'Studenti i predavači';
$string['subcategories'] = 'Podkategorije';
$string['subcategory'] = 'Podkategorija';
$string['subcategoryof'] = 'Podkategorija od {$a}';
$string['submit'] = 'Proslijedi';
$string['success'] = 'Uspješno';
$string['summary'] = 'Rezime';
$string['summary_help'] = 'Rezime je kratаk tekst koji priprema studente za aktivnosti unutar određene teme odnosno sedmice. Tekst se prikazuje na stranici kursa ispod naziva sekcije.';
$string['summaryof'] = 'Rezime za {$a}';
$string['supplyinfo'] = 'Više detalja';
$string['suspended'] = 'Suspendovano';
$string['suspendedusers'] = 'Suspendovani korisnici';
$string['switchdevicedefault'] = 'Prelazak na standardnu grafičku temu';
$string['switchdevicerecommended'] = 'Prelazak na preporučenu grafičku temu za Vaš uređaj';
$string['switchrolereturn'] = 'Povratak na redovnu ulogu';
$string['switchroleto'] = 'Promjena uloge u...';
$string['tag'] = 'Oznaka';
$string['tagalready'] = 'Oznaka već postoji';
$string['tagmanagement'] = 'Dodaj/obriši oznake...';
$string['tags'] = 'Oznake';
$string['targetrole'] = 'Ciljna uloga';
$string['teacheronly'] = 'samo za {$a}';
$string['teacherroles'] = '{$a} uloge';
$string['teachers'] = 'Predavači';
$string['textediting'] = 'Tokom uređivanja teksta';
$string['texteditor'] = 'Koristiti standardne Web forme';
$string['textformat'] = 'Običan tekstualni format';
$string['thanks'] = 'Hvala';
$string['theme'] = 'Grafička tema';
$string['themes'] = 'Grafičke teme';
$string['themesaved'] = 'Nova grafička tema je sačuvana';
$string['therearecourses'] = 'Postoje {$a} kursevi';
$string['thereareno'] = 'Ne postoje {$a} u ovom kurs';
$string['thiscategory'] = 'Ova kategorija';
$string['thiscategorycontains'] = 'Ova kategorija sadrži';
$string['time'] = 'Vrijeme';
$string['timezone'] = 'Vremenska zona';
$string['to'] = 'Do';
$string['tocontent'] = 'Do stavke "{$a}"';
$string['tocreatenewaccount'] = 'Preskoči za kreiranje novog korisničkog računa';
$string['today'] = 'Danas';
$string['todaylogs'] = 'Današnji zapisi o aktivnostima';
$string['toeveryone'] = 'svima';
$string['toomanybounces'] = 'Sa ove e-mail adrese vratilo se previše poruka. <b>Morate</b> je promijeniti da biste nastavili.';
$string['toomanytoshow'] = 'Previše korisnika za prikaz';
$string['toomanyusersmatchsearch'] = 'Previše korisnika ({$a->count}) se poklapa sa\'{$a->search}';
$string['toomanyuserstoshow'] = 'Previše korisnika za prikaz ({$a}) pokazati';
$string['toonly'] = 'samo za {$a}';
$string['top'] = 'Vrh';
$string['topic'] = 'Tema';
$string['topichide'] = 'Skrivanje ove teme od {$a}';
$string['topicoutline'] = 'Uvodna sekcija (tematski format)';
$string['topicshow'] = 'Prikaz ove teme za {$a}';
$string['total'] = 'Ukupno';
$string['trackforums'] = 'Praćenje foruma';
$string['trackforumsno'] = 'NE: ne bilježi informacije o tome koje sam poruke prethodno pročitao/la';
$string['trackforumsyes'] = 'DA: istakni nove poruke';
$string['trysearching'] = 'Pokušajte sa pretraživanjem.';
$string['turneditingoff'] = 'Isključi uređivanje';
$string['turneditingon'] = 'Uključi uređivanje';
$string['undecided'] = 'Neodlučeno';
$string['unfinished'] = 'Nedovršeno';
$string['unknowncategory'] = 'Nepoznata kategorija';
$string['unlimited'] = 'Neograničeno';
$string['unpacking'] = 'Raspakuje se {$a}';
$string['unsafepassword'] = 'Nesigurna lozinka - probajte nešto kompleksnije';
$string['untilcomplete'] = 'Dok se ne završi';
$string['unusedaccounts'] = 'Korisnički računi koji se ne koriste {$a} dana se automatski ispisuju';
$string['unzip'] = 'Raspakuj';
$string['unzippingbackup'] = 'Raspakuje se rezervna kopija';
$string['up'] = 'Gore';
$string['update'] = 'Ažuriraj';
$string['updated'] = 'Ažurirano {$a}';
$string['updatemymoodleoff'] = 'Prestani sa uređivanjem ove stranice';
$string['updatemymoodleon'] = 'Uredi ovu stranicu';
$string['updatemyprofile'] = 'Ažuriraj profil';
$string['updatesevery'] = 'Ažuriranje na svakih {$a} sekundi';
$string['updatethis'] = 'Ažuriraj';
$string['updatethiscourse'] = 'Ažuriraj ovaj kurs';
$string['updatinga'] = 'Ažuriranje: {$a}';
$string['updatingain'] = 'Ažuriranje {$a->what} u {$a->in}';
$string['upload'] = 'Postavi';
$string['uploadafile'] = 'Postavljanje datoteke';
$string['uploadcantwrite'] = 'Neuspješno upisivanje datoteke na disk';
$string['uploadedfile'] = 'Datoteka je uspješno postavljena';
$string['uploadedfileto'] = 'Datoteka {$a->file} je postavljena u direktorij {$a->directory}';
$string['uploadedfiletoobig'] = 'Nažalost, navedena datoteka je prevelika (ograničenje iznosi {$a} bajta)';
$string['uploadextension'] = 'Postavljanje datoteke prekinuto od strane PHP  ekstenzije';
$string['uploadfailednotrecovering'] = 'Postavljanje Vaših datoteka nije uspjelo jer je uočen problem sa jednom od njih, {$a->name}.<br /> Ovdje je izvještaj o uočenim problemima:<br />{$a->problem}<br />Nema oporavka.';
$string['uploadfilelog'] = 'Izvještaj o postavljanju datoteke {$a}';
$string['uploadformlimit'] = 'Postavljena datoteka {$a} je premašila ograničenje za maksimalnu veličinu određenu obrascem';
$string['uploadlabel'] = 'Naslov:';
$string['uploadnewfile'] = 'Postavi novu datoteku';
$string['uploadnofilefound'] = 'Datoteka nije pronađena - jeste li sigurni da ste odabrali datoteku za postavljanje?';
$string['uploadnotallowed'] = 'Postavljanje nije dozvoljeno';
$string['uploadnotempdir'] = 'Nedostaje privremeni folder';
$string['uploadoldfilesdeleted'] = 'Stare datoteke u Vašoj sekciji za upload (postavljanje) su obrisane';
$string['uploadpartialfile'] = 'Postavljanje datoteke nije izvršeno u potpunosti';
$string['uploadproblem'] = 'Prilikom postavljanja datoteke \'{$a}\' dogodila se nepoznata greška (možda je navedena datoteka bila prevelika?)';
$string['uploadrenamedchars'] = 'Datoteka je preimenovana sa {$a->oldname} na {$a->newname} jer je njen naziv sadržao nedozvoljene karaktere.';
$string['uploadrenamedcollision'] = 'Datoteka je preimenovana sa {$a->oldname} na {$a->newname} jer je došlo do konflikta sa nazivom neke druge datoteke.';
$string['uploadserverlimit'] = 'Datoteka koja je postavljena je veća od maksimalne veličine dozovoljene ograničenjem ovog servera';
$string['uploadthisfile'] = 'Postavi datoteku';
$string['url'] = 'URL';
$string['used'] = 'Korišteno';
$string['usedinnplaces'] = 'Koristi se na {$a} mjesta';
$string['usemessageform'] = 'ili koristite formu ispod da pošaljete poruku izabranim studentima';
$string['user'] = 'Korisnik';
$string['userconfirmed'] = 'Potvrđen {$a}';
$string['usercurrentsettings'] = 'Podešavanja mog profila';
$string['userdata'] = 'Podaci o korisniku';
$string['userdeleted'] = 'Ovaj korisnički račun je obrisan';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'Ovdjе možete unijeti podatke o sebi koji će biti prikazani na stranici Vašeg profila i koje će moći da vide drugi korisnici.';
$string['userdetails'] = 'Detalji o korisniku';
$string['userfiles'] = 'Korisničke datoteke';
$string['userlist'] = 'Spisak korisnika';
$string['username'] = 'Korisničko ime';
$string['usernameemailmatch'] = 'Korisničko ime i e-mail adresa se ne odnose na istog korisnika';
$string['usernameexists'] = 'Navedeno korisničko ime već postoji, odaberite neko drugo';
$string['usernamelowercase'] = 'Dozvoljena su samo mala slova';
$string['usernamenotfound'] = 'Korisničko ime nije pronađeno u bazi podataka';
$string['usernameoremail'] = 'Unesite ili korisničko ime ili e-mail adresu';
$string['usernotconfirmed'] = 'Nije se moglo potvrditi {$a}';
$string['userpic'] = 'Slika korisnika';
$string['users'] = 'Korisnici';
$string['userselectorautoselectunique'] = 'Ako se samo jedan korisnik poklapa sa kriterijima pretrage, neka automatski bude odabran';
$string['userselectorpreserveselected'] = 'Zadrži izabrane korisnike, čak i ako se više ne poklapaju sa kriterijima pretrage';
$string['userselectorsearchanywhere'] = 'Pronađi traženi tekst bilo gdje u imenu korisnika';
$string['usersnew'] = 'Novi korisnici';
$string['usersnoaccesssince'] = 'Neaktivni više od';
$string['userswithfiles'] = 'Korisnici sa datotekama';
$string['useruploadtype'] = 'Tip postavljanja korisnika: {$a}';
$string['userviewingsettings'] = 'Podešavanja profila za korisnika: {$a}';
$string['userzones'] = 'Korisničke zone';
$string['usetheme'] = 'Upotrijebi ovu temu';
$string['usingexistingcourse'] = 'Koristeći postojeći kurs';
$string['valuealreadyused'] = 'Ova vrijednost je već iskorištena';
$string['version'] = 'Verzija';
$string['view'] = 'Prikaz';
$string['viewallcourses'] = 'Pregledaj sve kurseve';
$string['viewallcoursescategories'] = 'Pregledaj sve kurseve i kategorije';
$string['viewallsubcategories'] = 'Pregledaj sve podkategorije';
$string['viewfileinpopup'] = 'Pregledaj datoteku u pop-up prozoru';
$string['viewing'] = 'Pregledanje:';
$string['viewmore'] = 'Pregledaj još';
$string['viewprofile'] = 'Pregledaj profil';
$string['views'] = 'Prikazi';
$string['viewsolution'] = 'vidi rješenje';
$string['virusfound'] = 'Upozorenje za administratora! Clam AV je našao virus u datoteci koju je korisnik {$a->user} postavio u okviru kursa {$a->course}. Evo rezultata Clam skeniranja:';
$string['virusfoundlater'] = 'U datoteci koja je postavljena dana {$a->date} pod imenom {$a->filename} za kurs {$a->course} je u međuvremenu pronađen virus. Ovdje je sažeti izvještaj o tome šta se tokom vremena dešavalo sa datotekom: {$a->action} Ako je to bio predati rad, možda želite ponovo da ga predate da bi ga Vaš predavač mogao pregledati.';
$string['virusfoundlateradmin'] = 'Upozorenje za administratora! U datoteci koju je korisnik {$a->user} postavio dana {$a->date} pod imenom {$a->filename} za kurs {$a->course} je u međuvremenu pronađen virus. Ovdje je sažeti izvještaj o tome šta se tokom vremena dešavalo sa datotekom: {$a->action} Korisnik koji je učitao datoteku je takođe obaviješten o tome šta se dogodilo.';
$string['virusfoundlateradminnolog'] = 'Upozorenje za administratora! U datoteci koja je ranije postavljena pod imenom {$a->filename} je u međuvremenu pronađen virus. Moodle nije uspio da prepravi ovu datoteku u njenu prvobitnu verziju u kakvoj ju je korisnik postavio. Ovdje je sažeti izvještaj o tome šta se tokom vremena dešavalo sa datotekom: {$a->action}';
$string['virusfoundsubject'] = '{$a}: Pronađen virus!';
$string['virusfounduser'] = 'Datoteka koju ste postavili, {$a->filename}, je skenirana antivirusnim softverom i pronađeno je da je zaražena! Učitavanje Vaše datoteke NIJE uspjelo.';
$string['virusplaceholder'] = 'Datoteka koja je postavljena sadrži virus, pa je premještena ili obrisana, a korisnik je o tome obavješten.';
$string['visible'] = 'Vidljivo';
$string['visibletostudents'] = 'Vidljivo za {$a}';
$string['warning'] = 'Upozorenje';
$string['warningdeleteresource'] = 'Upozorenje: na {$a} se odnosi resurs. Da li želite da ažurirate taj resurs?';
$string['webpage'] = 'Web stranica';
$string['week'] = 'Sedmica';
$string['weekhide'] = 'Sakrij ovu sedmicu od {$a}';
$string['weeklyoutline'] = 'Uvodna sekcija (sedmični format)';
$string['weeks'] = 'sedmice';
$string['weekshow'] = 'Prikaz ove sedmice do {$a}';
$string['welcometocourse'] = 'Dobrodošli na kurs {$a}';
$string['welcometocoursetext'] = 'Dobrodošli na kurs {$a->coursename}!

Ukoliko to već niste uradili, trebalo bi da urediti stranicu svog profila, tako da možemo da saznamo nešto više o vama:

{$a->profileurl}';
$string['whatforlink'] = 'Šta želite uraditi sa linkom?';
$string['whatforpage'] = 'Šta želite uraditi sa tekstom?';
$string['whattocallzip'] = 'Kako želite da nazovete arhiviranu datoteku?';
$string['whattodo'] = 'Šta uraditi';
$string['windowclosing'] = 'Ovaj prozor bi trebalo da se automatski zatvori. Ako se to nije dogodilo molim vas da ga sada zatvorite.';
$string['withchosenfiles'] = 'Sa izabranim datotekama';
$string['withoutuserdata'] = 'bez korisničkih podataka';
$string['withselectedusers'] = 'Sa izabranim korisnicima...';
$string['withselectedusers_help'] = '* Pošalji poruku - za slanje poruke jednom ili više korisnika * Dodaj novu bilješku - za dodavanje bilješke o odabranom korisniku * Dodaj zajedničku bilješku - za dodavanje iste bilješke o više korisnika';
$string['withuserdata'] = 'sa korisničkim podacima';
$string['wordforstudent'] = 'Vaša riječ za studenta';
$string['wordforstudenteg'] = 'npr. student, učesnik, kandidat i sl.';
$string['wordforstudents'] = 'Vaša riječ za studente';
$string['wordforstudentseg'] = 'npr. studenti, učesnici, kandidati i sl.';
$string['wordforteacher'] = 'Vaša riječ za predavača';
$string['wordforteachereg'] = 'npr. predavač, profesor, moderator i sl.';
$string['wordforteachers'] = 'Vaša riječ za predavače';
$string['wordforteacherseg'] = 'npr. predavači, profesori, moderatori i sl.';
$string['writingblogsinfo'] = 'Upisivanje informacija o blogovima';
$string['writingcategoriesandquestions'] = 'Zapisivanje kategorija i pitanja';
$string['writingcoursedata'] = 'Zapisivanje podataka kursa';
$string['writingeventsinfo'] = 'Zapisivanje informacija o događajima';
$string['writinggeneralinfo'] = 'Zapisivanje općih informacija';
$string['writinggradebookinfo'] = 'Zapisivanje informacija o ocjenjivanju';
$string['writinggroupingsgroupsinfo'] = 'Zapisivanje informacija o grupisanjima-grupama';
$string['writinggroupingsinfo'] = 'Zapisivanje informacija o grupacijama';
$string['writinggroupsinfo'] = 'Zapisivanje informacija o grupama';
$string['writingheader'] = 'Zapisivanje zaglavlja';
$string['writingloginfo'] = 'Zapisivanje informacija o zapisima o aktivnostima';
$string['writingmessagesinfo'] = 'Zapisivanje informacija o porukama';
$string['writingmoduleinfo'] = 'Zapisivanje informacija o modulima';
$string['writingscalesinfo'] = 'Zapisivanje informacija o skalama ocijenjivanja';
$string['writinguserinfo'] = 'Zapisivanje informacija o korisnicima';
$string['wrongpassword'] = 'Pogrešna lozinka za ovo korisničko ime';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'godina';
$string['years'] = 'godine';
$string['yes'] = 'Da';
$string['youareabouttocreatezip'] = 'Upravo ćete započeti kreiranje zip arhive koja sadrži';
$string['youaregoingtorestorefrom'] = 'Upravo ćete započeti proces restauracije za';
$string['youneedtoenrol'] = 'Da biste izvršili ovu akciju morate se prijaviti na kurs.';
$string['yourlastlogin'] = 'Vaš posljednji pristup sistemu';
$string['yourself'] = 'sebe';
$string['yourteacher'] = 'Vaš {$a}';
$string['yourwordforx'] = 'Vaša riječ za \'{$a}';
$string['zippingbackup'] = 'Kreira se arhiva sa rezervnom kopijom';
