<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Prihvati';
$string['accept_grades'] = 'Prihvati ocjene alata';
$string['accept_grades_admin'] = 'Prihvati ocjene alata';
$string['accept_grades_admin_help'] = 'Navedite da li provajder alata može da dodaje, ažurira, čita i briše ocjene povezane sa instancama ovog tipa alata. Neki provajderi podržavaju mogućnost slanja ocjena nazad u Moodle na osnovu akcija koje su preduzete u okviru alata, stvarajući na taj način doživljaj veće integrisanosti Moodle-a i vanjskog alata.';
$string['accept_grades_help'] = 'Navedite da li provajder alata može da dodaje, ažurira, čita i briše ocjene povezane sa instancama ovog tipa alata. Neki provajderi podržavaju mogućnost slanja ocjena nazad u Moodle na osnovu akcija koje su preduzete u okviru alata, stvarajući na taj način doživljaj veće integrisanosti Moodle-a i vanjskog alata. Imajte u vidu da se ova podešavanja mogu izmijeniti u konfiguraciji alata.';
$string['action'] = 'Akcija';
$string['active'] = 'Aktivan';
$string['activity'] = 'Aktivnost';
$string['addnewapp'] = 'Omogući vanjsku aplikaciju';
$string['addserver'] = 'Dodaj novi pouzdani server';
$string['addtype'] = 'Dodaj konfiguraciju vanjskog alata';
$string['allow'] = 'Dozvoli';
$string['allowinstructorcustom'] = 'Dozvoli predavačima da dodaju prilagođene parametre';
$string['allowsetting'] = 'Dozvoli da alat unutar Moodle-a sačuva 8K podešavanja';
$string['always'] = 'Uvijek';
$string['automatic'] = 'Automatski, na osnovu inicijalne URL adrese';
$string['baseurl'] = 'Osnovna URL adresa';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'LTI aktivnosti';
$string['basiclti_base_string'] = 'LTI OAuth osnovni string';
$string['basiclti_endpoint'] = 'LTI krajnja tačka startovanja';
$string['basicltifieldset'] = 'Prilagođeni primjer skupa polja';
$string['basiclti_in_new_window'] = 'Vaša aktivnost je otvorena u novom prozoru';
$string['basicltiintro'] = 'Opis aktivnosti';
$string['basicltiname'] = 'Naziv aktivnosti';
$string['basiclti_parameters'] = 'LTI parametri startovanja';
$string['basicltisettings'] = 'Osnovna LTI podešavanja';
$string['cannot_delete'] = 'Ne možete da obrišete ovu konfiguraciju alata';
$string['cannot_edit'] = 'Ne možete da uredite ovu konfiguraciju alata';
$string['comment'] = 'Komentar';
$string['configpassword'] = 'Zadana lozinka udaljenog alata';
$string['configpreferheight'] = 'Standardna preferirana visina';
$string['configpreferwidget'] = 'Postavi dodatak za zadano pokretanje';
$string['configpreferwidth'] = 'Standardna preferirana širina';
$string['configresourceurl'] = 'Zadana URL adresa resursa';
$string['configtoolurl'] = 'Zadana URL adresa udaljenog alata';
$string['configtypes'] = 'Omogući LTI  aplikacije';
$string['courseid'] = 'ID broj kursa';
$string['coursemisconf'] = 'Kurs je pogrešno konfigurisan';
$string['course_tool_types'] = 'Tipovi alata na nivou kursa';
$string['createdon'] = 'Kreirano dana';
$string['curllibrarymissing'] = 'PHP Curl biblioteka mora da bude instalirana kako biste mogli da koristite LTI';
$string['custom'] = 'Prilagođeni parametri';
$string['custom_config'] = 'Korištenje prilagođene konfiguracije alata';
$string['custom_help'] = 'Namjenski prilagođeni parametri su podešavanja koje koristi provajder alata. Na primjer, prilagođeni parametri se mogu koristiti za prikaz određenih resursa od strane provajdera. Najsigurnije je ne mijenjati ovo polje, osim ako to ne učini sam provajder alata.';
$string['custominstr'] = 'Prilagođeni parametri';
$string['debuglaunch'] = 'Opcija za otklanjanje grešaka';
$string['debuglaunchoff'] = 'Normalno pokretanje';
$string['debuglaunchon'] = 'Pokretanje sa otklanjanjem grešaka';
$string['default'] = 'Zadano';
$string['default_launch_container'] = 'Zadani inicijalni kontejner';
$string['default_launch_container_help'] = 'Inicijalni kontejner utiče na prikaz alata prilikom njegovog pokretanja unutar kursa. Neki kontejneri pružaju veći broj mogućnosti, dok drugi obezbjeđuju veći stepen integracije sa Moodle-om. * **Zadano** - koristi inicijalni kontejner naveden u konfiguraciji alata. * **Umetnuto** - alat se prikazuje unutar postojećeg prozora Moodle-a, na način sličan većini drugih tipova aktivnosti. * **Umetnuto, bez blokova** - alat se prikazuje unutar postojećeg prozora Moodle-a, ali samo sa navigacionom trakom na vrhu stranice. * **Novi prozor** - Alat se otvara u novom prozoru, zauzimajući sav njegov rapoloživ prostor. Zavisno od web pretraživača, alat će se otvoriti u novoj kartici pretraživača ili u pop-up prozoru. Postoji mogućnost da web pretraživač neće dozvoliti otvaranje novog prozora.';
$string['delegate'] = 'Delegiraj predavaču';
$string['delete'] = 'Obriši';
$string['delete_confirmation'] = 'Da li ste sigurni da želite da obrišete ovu konfiguraciju vanjskog alata?';
$string['deletetype'] = 'Obriši konfiguraciju vanjskog alata';
$string['display_description'] = 'Prikaži opis aktivnosti prilikom njenog startovanja';
$string['display_description_help'] = 'Ako je izabrana ova opcija, opis aktivnosti (gore naveden) biće prikazan iznad sadržaja vanjskog alata. Opis se može koristiti kako bi se pružile dodatne instrukcije onima koji pokreću alat, ali nije neophodan. Opis se nikada ne prikazuje kada se vanjski alat pokreće u novom prozoru.';
$string['display_name'] = 'Prikaži naziv aktivnosti kada se pokrene';
$string['display_name_help'] = 'Ako je izabrana ova opcija, naziv aktivnosti (gore naveden) biće prikazan iznad sadržaja vanjskog alata. Moguće je da provajder alata, također, može da prikaže naslov. Ova opcija sprječava da naslov aktivnosti bude prikazan dvaput. Naslov se nikada ne prikazuje ako se inicijalni kontejner alata pokreće u novom prozoru.';
$string['domain_mismatch'] = 'Domen inicijalne URL adrese se ne poklapa sa konfiguracijom alata.';
$string['donot'] = 'Nemoj slati';
$string['donotaccept'] = 'Nemoj prihvatiti';
$string['donotallow'] = 'Nemoj dozvoliti';
$string['edittype'] = 'Uredi konfiguraciju vanjskog alata';
$string['embed'] = 'Ugradi';
$string['embed_no_blocks'] = 'Ugradi, bez blokova';
$string['enableemailnotification'] = 'Pošalji obavještenja e-mailom';
$string['enableemailnotification_help'] = 'Ako je omogućena ova opcija, studenti će e-mailom dobiti obavještenje kada bude ocijenjena njihova aktivnost u okviru vanjskog alata..';
$string['errormisconfig'] = 'Pogrešno  konfigurisan alat. Zamolite svog Moodle administratora da popravi konfiguraciju alata.';
$string['extensions'] = 'LTI prošireni servisi';
$string['external_tool_type'] = 'Tip vanjskog alata';
$string['external_tool_type_help'] = 'Osnovna namjena konfiguracije alata je uspostavljanje bezbjednog kanala komunikacije između Moodle-a i provajdera alata. Konfiguracija alata, također, pruža mogućnost da se podese kako zadane vrijednosti, tako i dodatne servise koje pruža sam alat. * ** Automatski, na osnovu inicijalne URL adrese** - ovo podešavanja treba koristiti u skoro svim slučajevima. Moodle će izabrati najprikladniju konfiguraciju alata koja se zasniva na inicijalnoj URL adresi. Bit će korišten alat koji je konfigurisan bilo od strane administratora ili unutar ovoga kursa. Kada je navedena inicijalna URL adresa, Moodle će dati povratnu informaciju o tome da li je prepoznao adresu ili ne. Ako Moodle nije prepoznao inicijalnu URL adresu, možda će biti potrebno da ručno unesete podatke o konfiguraciji alata. * **Specifičan tip alata** - ako izaberete specifičan tip alata, možete da natjerate Moodle da u komunikaciji sa provajderom vanjskog alata koristi tu konfiguraciju alata. Ukoliko se ispostavi da inicijalna URL adresa ne pripada provajderu, pojavit će se upozorenje. U nekim slučajevima, nije potrebno da se unese inicijalna URL adresa kada se obezbjeđuje specifični tip alata (ako se ne pokreće tačno određeni resurs unutar samog provajdera alata). * **Namjenski prilagođena konfiguracija** - da biste podesili prilagođenu konfiguracije alata, samo za ovu instancu, otkrijte ‘Napredne opcije’ i unesite korisnički ključ i tajni dijeljeni kôd. Ako nemate korisnički ključ i tajni dijeljeni kôd možda ćete moći da ih zatražite od provajdera alata. Ne zahtijevaju svi alati korisnički ključ i tajni dijeljeni kôd. U tom slučaju ova polja možete ostaviti prazna. ### Uređivanje tipa alata Odmah iza padajućeg menija ‘Tip vanjskog alata’ dostupne su tri ikonice: * **Dodaj** - kreirajte konfiguraciju alata na nivou kursa. Sve instance vanjskog alata na ovom kursu moći će da koriste konfiguraciju alata. * **Uredi** - izaberite tip alata na nivou kursa iz padajućeg menija, a zatim kliknite na ovu ikonicu. Mogu se uređivati detalji konfiguracije alata. * **Obriši** - uklonite izabrani tip alata na nivou kursa.';
$string['external_tool_types'] = 'Tipovi vanjskih alata';
$string['failedtoconnect'] = 'Moodle nije mogao da uspostavi komunikaciju sa"{$a}" sistemom';
$string['filter_basiclti_configlink'] = 'Konfigurišite svoje preferirane stranice i njihove lozinke';
$string['filter_basiclti_password'] = 'Lozinka je obavezna';
$string['filterconfig'] = 'LTI administracija';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Iskoristite postojeću konfiguraciju za pogrešno konfigurisanu instancu';
$string['fixnew'] = 'Nova konfiguracija';
$string['fixnewconf'] = 'Definiši novu konfiguraciju za pogrešno konfigurisanu instancu';
$string['fixold'] = 'Koristi postojeću';
$string['forced_help'] = 'Ovo podešavanje je postavljeno kao obavezno u konfiguraciji alata na nivou kursa ili stranice. Ne možete da ga mijenjate u ovom interface-u.';
$string['force_ssl'] = 'Obavezan SSL';
$string['force_ssl_help'] = 'Izborom ove opcije, svako pokretanje alata ovog provajdera će obavezno koristiti SSL protokol. Osim toga, i svi zahtjevi web servisa provajdera alata će koristiti SSL protokol. Ako se koristi ova opcija, provjerite da li ova Moodle stranica i provajder alata podržavaju SSL protokol.';
$string['global_tool_types'] = 'Globalni tipovi alata';
$string['grading'] = 'Usmjeravanje ocjena';
$string['icon_url'] = 'URL adresa ikonice';
$string['icon_url_help'] = 'Ikonica URL adrese, omogućava da se izmijeni ikonica koja se pojavljuje na popisu kurseva za ovu aktivnost. Umjesto da koristite zadanu LTI ikonicu, može se definisati ikonica koja odražava tip aktivnosti.';
$string['id'] = 'id';
$string['invalidid'] = 'LTI ID je pogrešan';
$string['launch_in_moodle'] = 'Pokreni alat unutar Moodle-a';
$string['launchinpopup'] = 'Inicijalni kontejner';
$string['launch_in_popup'] = 'Pokreni alat u pop-up prozoru';
$string['launchinpopup_help'] = 'Inicijalni kontejner utiče na prikaz alata prilikom njegovog pokretanja unutar kursa. Neki kontejneri pružaju veći broj mogućnosti, dok drugi obezbjeđuju veći stepen integracije sa Moodle-om. * **Zadano** - koristi kontejner pokretanja naveden u konfiguraciji alata. * **Umetnuto** - alat se prikazuje unutar postojećeg prozora Moodle-a, na način sličan većini drugih tipova aktivnosti. * **Umetnuto, bez blokova** - alat se prikazuje unutar postojećeg prozora Moodle-a, ali samo sa navigacionom trakom na vrhu stranice. * **Novi prozor** - Alat se otvara u novom prozoru, zauzimajući sav njegov rapoloživ prostor. Zavisno od web pretraživača, alat će se otvoriti u novoj kartici pretraživača ili u pop-up prozoru. Postoji mogućnost da web pretraživač neće dozvoliti otvaranje novog prozora.';
$string['launchoptions'] = 'Opcije za pokretanje';
$string['launch_url'] = 'Inicijalna URL adresa';
$string['launch_url_help'] = 'Inicijalna URL adresa označava web adresu vanjskog alata i može da sadrži dodatne informacije, kao što je resurs koji će biti prikazan. Ako niste sigurni šta da upišete kao inicijalnu URL adresu, molimo Vas potražite više informacije kod provajdera alata. Ako ste izabrali specifičan tip alata, možda nećete morati da upišete inicijalnu URL adresu. To će najvjerovatnije biti slučaj, ako se link alata koristi samo za ulazak na sistem provajdera, a ne za odlazak na neki određeni resurs.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Ocijeni LTI aktivnosti';
$string['lti:addinstance'] = 'Dodaj novu LTI aktivnost';
$string['lti_administration'] = 'LTI administracija';
$string['lti_errormsg'] = 'Alat je vratio sljedeću poruku o grešci: "{$a}"';
$string['lti:grade'] = 'Ocijeni LTI aktivnost';
$string['lti_launch_error'] = 'Dogodila se greška prilikom pokretanja vanjskog alata:';
$string['lti_launch_error_tool_request'] = '<p> Da biste poslali zahtjev administratoru da završi konfigurisanje alata, kliknite<a href="{$a->admin_request_url}" target="_top">ovdje</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p> Ova greška može biti rezultat nedostatka korisničkog ključa i tajnog dijeljenog kôda za provajdera alata. </p> <p> Ako imate korisnički ključ i tajni dijeljeni kôd, možete ih unijeti prilikom uređivanja instance vanjskog alata (provjerite da li su vidljive napredne opcije).<br /> Alternativno, možete na nivou kursa da kreirate konfiguraciju alata <a href="{$a->course_tool_editor}">ovdje</a>. </p>';
$string['lti:manage'] = 'Uredi LTI aktivnosti';
$string['lti:requesttooladd'] = 'Pošaljite alat administratoru da ga konfiguriše';
$string['lti_tool_request_added'] = 'Zahtjev za konfigurisanje alata je uspješno poslan. Možda ćete morati da se obratite administratoru da biste dovršili konfigurisanje.';
$string['lti_tool_request_existing'] = 'Konfiguracija alata za domen alata je već poslata.';
$string['ltiunknownserviceapicall'] = 'LTI nepoznat servis API poziva.';
$string['lti:view'] = 'Pogledaj LTI aktivnosti';
$string['main_admin'] = 'Opća pomoć';
$string['main_admin_help'] = 'Vanjski alati dozvoljavaju korisnicima Moodle-a da neprimjetno stupaju u interakciju sa resursima koji se nalaze na udaljenim stranicama. Koristeći specijalne protokole udaljeni alat će imati pristup nekim općim informacijama o korisniku koji je pokrenuo alat. Na primjer, naziv institucije, ID kursa, ID korisnika, i druge informacije, kao što su ime korisnika ili njegova e-mail adresa. Tipovi alata prikazani na ovoj stranici su podijeljeni u tri kategorije: * **Aktivni** - ove provajdere alata je administrator odobrio i konfigurisao. Oni mogu da se koriste unutar bilo kojeg kursa ove instance Moodle-a. Ako su unijeti korisnički ključ i tajni dijeljeni kôd, uspostavljena je pouzdana veza između instance Moodle-a i udaljenog alata, što obezbjeđuje siguran kanal komunikacije. * **Na čekanju** - ovi provajderi alata su uneseni, ali ih administrator još uvijek nije konfigurisao. Predavači i dalje mogu da koriste alate ovih provajdera ako imaju korisnički ključ i tajni dijeljeni kôd, ili ako oni nisu potrebni. * **Odbijeni** - ovi provajderi alata su označeni kao oni koje administrator ne namjerava da učini dostupnim svima unutar instance Moodle-a. Predavači i dalje mogu da koriste alate ovih provajdera ako imaju korisnički ključ i tajni dijeljeni kod, ili ako oni nisu potrebni.';
$string['miscellaneous'] = 'Razno';
$string['misconfiguredtools'] = 'Otkrivene su pogrešno konfigurisane instance alata';
$string['missingparameterserror'] = 'Stranica je pogrešno konfigurisana: "{$a}"';
$string['module_class_type'] = 'Tip Moodle modula';
$string['modulename'] = 'Vanjski alat (aplikacija)';
$string['modulename_help'] = 'Vanjski alati dozvoljavaju korisnicima Moodle-a da stupaju u interakciju sa resursima i aktivnostima za učenje na drugim web stranicama. Na primjer, vanjski alat može da obezbijedi pristup novom tipu aktivnosti ili obrazovnim materijalima koje nude izdavači. Kako biste podesili instancu vanjskog alata, neophodno je da provajder alata podržava LTI (Learning Tools Interoperability) standard. Ako pronađete provajdera alata koji podržava LTI standard, on treba da obezbijedi uputstvo o tome kako da se konfiguriše instanca vanjskog alata. Dodatno, biće dostupni za upotrebu i tipovi alata koje konfigurisao administrator sajta. Vanjski alati se razlikuju od resursa \'URL adresa\' na nekoliko načina: * **Kontekst** - vanjski alati imaju pristup informacijama o korisniku koji je pokrenuo alat, kao što je naziv institucije i kursa, ime korisnika i dr. * **Duboka integracija** - vanjski alati podržavaju čitanje, ažuriranje i brisanje ocjena koje su povezane sa instancom aktivnosti. Za buduća izdanja planira se veći stepen integracije. * **Sigurnost** - konfiguracije vanjskog alata kreiraju pouzdanu vezu između Moodle-a i provajdera alata, što omogućava sigurnu komunikaciju između njih.';
$string['modulenameplural'] = 'osnovni ltis';
$string['modulenamepluralformatted'] = 'LTI instance';
$string['never'] = 'Nikada';
$string['new_window'] = 'Novi prozor';
$string['noattempts'] = 'Još nije bilo pokušaja u okviru ove instance alata';
$string['no_lti_configured'] = 'Ne postoje aktivni vanjski alati koji su konfigurisani.';
$string['no_lti_pending'] = 'Nema vanjskih alata na čekanju.';
$string['no_lti_rejected'] = 'Nema odbijenih vanjskih alata.';
$string['noltis'] = 'Ne postoje LTI instance';
$string['noservers'] = 'Nisu pronađeni serveri';
$string['notypes'] = 'Trenutno ne postoje podešavanja LTI alata u Moodle-u. Kliknite gornji link za instalaciju kako biste ih dodali.';
$string['noviewusers'] = 'Nisu pronađeni korisnici koji imaju ovlaštenja da koriste ovaj alat';
$string['optionalsettings'] = 'Opciona podešavanja';
$string['organization'] = 'Informacije o organizaciji';
$string['organizationdescr'] = 'Opis organizacije';
$string['organizationid'] = 'ID organizacije';
$string['organizationid_help'] = 'Jedinstveni identifikator ove instance Moodle-a. Obično se koristi DNS naziv organizacije. Ako ovo polje ostane prazno, koristit će se naziv servera ove Moodle stranice, kao zadana vrijednost.';
$string['organizationurl'] = 'URL adresa organizacije';
$string['organizationurl_help'] = 'Osnovna URL adresa ove instance Moodle-a. Ukoliko ovo polje ostane prazno, zadana vrijednosti će se koristiti na temelju konfiguracije stranice.';
$string['pagesize'] = 'Broj pristupa alatu prikazanih po stranici';
$string['password'] = 'Tajni dijeljeni kôd';
$string['password_admin'] = 'Tajni dijeljeni kôd';
$string['password_admin_help'] = 'Tajni dijeljeni kôd može da se posmatra kao lozinka koja se koristi za provjeru identiteta prilikom pristupa alatu. Kôd treba da obezbijedi provajder alata zajedno sa korisničkim ključem. Alati koji ne traže sigurnu komunikaciju sa Moodle-om i ne pružaju dodatne servise (kao što je izvještaj o ocjenama), ne moraju da zahtijevaju tajni dijeljeni kôd.';
$string['password_help'] = 'Za prethodno konfigurisane alate, nije neophodno da se ovdje unese tajni dijeljeni kôd, pošto će on već biti obezbijeđen kao dio procesa konfiguracije. Ovo polje treba popuniti ako se kreira veza ka provajderu alata koji nije prethodno konfigurisan. Ako provajder alata treba da se koristi više puta na ovom kursu, dodavanje konfiguracije alata je dobra ideja. Tajni dijeljeni kôd može da se posmatra kao lozinka koja se koristi za provjeru identiteta prilikom pristupa alatu. Kôd treba da obezbijedi provajder alata zajedno sa korisničkim ključem. Alati koji ne traže sigurnu komunikaciju sa Moodle-om i ne pružaju dodatne servise (kao što je izvještaj o ocjenama), ne moraju da zahtijevaju tajni dijeljeni kôd.';
$string['pending'] = 'Ne čekanju';
$string['pluginadministration'] = 'LTI administracija';
$string['pluginname'] = 'LTI';
$string['preferheight'] = 'Preferirana visina';
$string['preferwidget'] = 'Preferirano pokretanje dodatka';
$string['preferwidth'] = 'Preferirana širina';
$string['press_to_submit'] = 'Pritisnite da biste pokrenuli ovu aktivnost';
$string['privacy'] = 'Privatnost';
$string['quickgrade'] = 'Dozvoli brzo ocjenjivanje';
$string['quickgrade_help'] = 'Ako je omogućena ova opcija, više alata može da se ocjenjuje na jednoj stranici. Dodajte ocjene i komentare, a zatim kliknite na dugme "Sačuvaj sve moje povratne informacije" kako biste sačuvali sve promjene na toj stranici.';
$string['redirect'] = 'Bićete preusmjereni za nekoliko sekundi. Ako se to ne dogodi pritisnite dugme.';
$string['reject'] = 'Odbij';
$string['rejected'] = 'Odbijeno';
$string['resource'] = 'Resurs';
$string['resourcekey'] = 'Korisnički ključ';
$string['resourcekey_admin'] = 'Korisnički ključ';
$string['resourcekey_admin_help'] = 'Korisnički ključ može da se posmatra kao korisničko ime koje se koristi za provjeru identiteta prilikom pristupa alatu. Provajder alata može koristiti ključ kako bi obezbijedio jedinstvenu identifikaciju Moodle stranice sa kojeg korisnici pokreću alat. Korisnički ključ mora da obezbijedi provajder alata. Način dobijanja ključa se razlikuje među provajderima. To može biti automatizovani proces ili može zahtijevati dijalog sa provajderom alata. Alati koji ne traže sigurnu komunikaciju sa Moodle-om i ne pružaju dodatne servise (kao što je izvještaj o ocjenama), ne moraju da zahtijevaju korisnički ključ.';
$string['resourcekey_help'] = 'Za prethodno konfigurisane alate, nije neophodno da se ovdje unese ključ resursa, pošto će on već biti obezbijeđen kao dio procesa konfiguracije. Ovo polje treba popuniti ako se kreira veza ka provajderu alata koji nije prethodno konfigurisan. Ako provajder alata treba da se koristi više puta na ovom kursu, dodavanje konfiguracije alata je dobra ideja. Korisnički ključ može da se posmatra kao korisničko ime koje se koristi za provjeru identiteta prilikom pristupa alatu. Provajder alata može koristiti ključ kako bi obezbijedio jedinstvenu identifikaciju Moodle stranice sa kojeg korisnici pokreću alat. Korisnički ključ mora da obezbijedi provajder alata. Način dobijanja ključa se razlikuje među provajderima. To može biti automatizirani proces ili može zahtijevati dijalog sa provajderom alata. Alati koji ne traže sigurnu komunikaciju sa Moodle-om i ne pružaju dodatne servise (kao što je izvještaj o ocjenama), ne moraju da zahtijevaju korisnički ključ.';
$string['resourceurl'] = 'URL adresa resursa';
$string['return_to_course'] = 'Klikni na <a href="{$a->link}" target="_top">ovdje</a> za povratak na kurs';
$string['saveallfeedback'] = 'Sačuvaj sve moje privatne informacije';
$string['secure_icon_url'] = 'Sigurnosna ikonica URL adrese';
$string['secure_icon_url_help'] = 'Slično ikonici URL adrese, ali se koristi ako korisnik pristupa Moodle-u putem SSL protokola. Glavna namjena ovog polja je da spriječi web pretraživač da šalje upozorenja korisniku, ako stranici pristupa putem SSL-a, a pri tome se zahtijeva prikaz nesigurne slike.';
$string['secure_launch_url'] = 'Sigurnosna incijalna URL adresa';
$string['secure_launch_url_help'] = 'Iako slična običnoj, sigurnosna inicijalna URL adresa se koristi ako je neophodan viši nivo sigurnosti. Moodle će koristiti sigurnosnu inicijalnu URL adresu ukoliko se Moodle stranici pristupa preko SSL protokola, ili ako je konfiguracija alata podešena tako da se ona uvijek pokreće putem SSL-a. Inicijalna URL adresa se može, također, podesiti kao https adresa, kako bi se vanjski alat primorao na pokretanje putem SSL protokola. U tom slučaju ovo polje može ostati prazno.';
$string['send'] = 'Pošalji';
$string['setupoptions'] = 'Opcije za podešavanje';
$string['share_email'] = 'Podijeli e-mail adresu korisnika sa tim provajderom alata';
$string['share_email_admin'] = 'Podijeli e-mail adresu korisnika sa provajderom alata';
$string['share_email_admin_help'] = 'Navedite da li e-mail adresu korisnika koji pokreće alat treba dijeliti sa provajderom. Provajder može da traži e-mail adrese korisnika koji su pokrenuli alat kako bi razlikovao korisnike sa istim imenom ili kako bi korisnicima slao e-mail poštu zavisno od akcija unutar alata.';
$string['share_email_help'] = 'Navedite da li e-mail adresu korisnika koji pokreće alat treba dijeliti sa provajderom. Provajder može da traži e-mail adrese korisnika koji su pokrenuli alat kako bi razlikovao korisnike sa istim imenom ili kako bi korisnicima slao e-mail poštu zavisno od akcija unutar alata. Imajte u vidu da se ovo podešavanje može izmijeniti u konfiguraciji alata.';
$string['share_name'] = 'Podijeli ime korisnika sa tim provajderom alata';
$string['share_name_admin'] = 'Podijeli ime korisnika sa provajderom alata';
$string['share_name_admin_help'] = 'Navedite da li treba da se dijeli puno ime korisnika, koji pokreće alat, sa provajderom alata. Provajder može da traži ime korisnika koji je pokrenuo alat, kako bi prikazao smislene informacije unutar alata.';
$string['share_name_help'] = 'Navedite da li treba da se dijeli puno ime korisnika, koji pokreće alat, sa provajderom alata. Provajder može da traži ime korisnika koji je pokrenuo alat, kako bi prikazao smislene informacije unutar alata. Imajte u vidu da se ovo podešavanje može izmijeniti u konfiguraciji alata';
$string['share_roster'] = 'Dozvoli alatu pristup spisku učesnika kursa';
$string['share_roster_admin'] = 'Alat može da pristupi spisku učesnika kursa';
$string['share_roster_admin_help'] = 'Navedite da li alat može da pristupi spisku učesnika upisanih na kurseve, u okviru kojih se ovaj tip alata koristi.';
$string['share_roster_help'] = 'Navedite da li alat može da pristupi spisku učesnika upisanih na ovaj kurs. Imajte u vidu da se ovo podešavanje može izmijeniti u konfiguraciji alata.';
$string['show_in_course'] = 'Prikaži tip alata prilikom kreiranja instance alata';
$string['show_in_course_help'] = 'Ako je izabrano, ova konfiguracija alata će se pojaviti u padajućem meniju "Tip vanjskog alata" kada predavači konfigurišu vanjski alat unutar kurseva. U većini slučajeva, ova opcija ne treba da bude izabrana. Predavači mogu da koriste ovu konfiguraciju alata, baziranu na inicijalnoj URL adresi, koja se poklapa sa osnovnom URL adresom, što je preferirani metod. Jedini slučaj, u kojem bi trebalo da se izabere ova opcija, je onaj kada je konfiguracija alata namijenjena jednokratnom prijavljivanju (Single Sign on). Na primjer, ako sva pokretanja alata vode korisnika na unutrašnju stranicu provajdera, umjesto na određeni resurs.';
$string['size'] = 'Parametri veličine';
$string['submission'] = 'Aktivnost na vanjskom alatu';
$string['submissions'] = 'Poravnanje';
$string['submissionsfor'] = 'Predaje za {$a}';
$string['toggle_debug_data'] = 'Promjena stanja podataka o otklanjanju grešaka';
$string['tool_config_not_found'] = 'Za ovu URL adresu nije pronađena konfiguracija alata.';
$string['tool_settings'] = 'Podešavanja alata';
$string['toolsetup'] = 'Konfiguracija vanjskog alata';
$string['toolurl'] = 'Osnovna URL adresa alata';
$string['toolurl_help'] = 'Osnovna URL adresa se koristi kako bi se inicijalna URL adresa uparila sa ispravnom konfiguracijom alata. Upotreba prefiksa http(s), na početku adrese, nije obavezna. Osim toga, osnovna URL adresa se koristi kao inicijalna URL adresa ako ova nije navedena u instanci vanjskog alata. <table> <thead> <tr> <td> <b>Osnovna URL adresa</b> </td> <td> <b>Poklapanja</b> </td> <tr> </thead> <tbody> <tr> <td> tool.com </td> <td> tool.com, tool.com/quizzes, tool.com/quizzes/quiz.php?id=10, www.tool.com/quizzes </td> </tr> <tr> <td> www.tool.com/quizzes </td> <td> tool.com/quizzes, tool.com/quizzes/take.php?id=10, www.tool.com/quizzes </td> </tr> <tr> <td> quiz.tool.com </td> <td> quiz.tool.com, quiz.tool.com/take.php?id=10 </td> </tr> </tbody> </table> Ako postoje dvije različite konfiguracije alata za isti domen, koristit će se najspecifičnije poklapanje.';
$string['typename'] = 'Naziv alata';
$string['typename_help'] = 'Naziv alata se koristi za identifikaciju provajdera alata unutar Moodle-a. Naziv koji se unese bit će vidljiv predavačima kada dodaju vanjske alate unutar kursa.';
$string['types'] = 'Tipovi';
$string['update'] = 'Ažuriraj';
$string['using_tool_configuration'] = 'Korištenje konfiguracije alata';
$string['validurl'] = 'Ispravna URL adresa mora početi sa http(s)://';
$string['viewsubmissions'] = 'Prikaz predatih rješenja i ekrana za ocjenjivanje';
