<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Specificirani administratorski direktorij je netačan';
$string['admindirname'] = 'Administratorski direktorij';
$string['admindirsetting'] = 'Vrlo mali broj web servera koristi /admin kao specijalni URL za pristup raznim podešavanjima (kontrolni panel i sl.). Nažalost, to dovodi do konflikta sa standardnom lokacijom za administratorske stranice u Moodleu. Ovaj problem možete riješiti tako što ćete promijeniti ime administratorskog direktorija u Vašoj instalaciji, i ovdje upisati to novo ime. Na primjer: <br /> <br /><b>moodleadmin</b><br /> <br /> Ovo podešavanje će prepraviti administratorske linkove u Moodle sistemu.';
$string['admindirsettinghead'] = 'Podešavanje administratorskog direktorija';
$string['admindirsettingsub'] = 'Vrlo mali broj web servera koristi /admin kao specijalni URL za pristup raznim podešavanjima (kontrolni panel i sl.). Nažalost, to dovodi do konflikta sa standardnom lokacijom za administratorske stranice u Moodleu. Ovaj problem možete riješiti tako što ćete promijeniti ime administratorskog direktorija u Vašoj instalaciji, i ovdje upisati to novo ime. Na primjer: <br /> <br /><b>moodleadmin</b><br /> <br /> Ovo podešavanje će prepraviti administratorske linkove u Moodle sistemu.';
$string['availablelangs'] = 'Popis dostupnih jezika';
$string['caution'] = 'Pažnja';
$string['chooselanguage'] = 'Izaberite jezik';
$string['chooselanguagehead'] = 'Izaberite jezik';
$string['chooselanguagesub'] = 'Molimo izaberite jezik koji će se koristiti tokom instalacije. Ovaj jezik će, također, biti korišten na nivou stranice kao zadani, mada to naknadno može biti promijenjeno.';
$string['cliadminpassword'] = 'Nova lozinka za administratora';
$string['cliadminusername'] = 'Korisničko ime administratora';
$string['clialreadyconfigured'] = 'Datoteka config.php već postoji. Molimo, koristite admin/cli/install_database.php ako želite da instalirate ovu stranicu.';
$string['clialreadyinstalled'] = 'Datoteka config.php već postoji. Upotrebite komandu admin/cli/upgrade.php ako želite da nadogradite ovu stranicu.';
$string['cliinstallfinished'] = 'Instaliranje je uspješno završeno';
$string['cliinstallheader'] = 'Moodle {$a} program za instaliranje iz komandne linije';
$string['climustagreelicense'] = 'U neinteraktivnom modu morate prihvatiti licencu navodeći opciju --agree-license';
$string['clitablesexist'] = 'Baza podataka već postoji. Nije moguće nastaviti instaliranje iz komandne linije.';
$string['compatibilitysettings'] = 'Provjera Vaših PHP podešavanja...';
$string['compatibilitysettingshead'] = 'Provjera Vaših PHP podešavanja...';
$string['compatibilitysettingssub'] = 'Vaš server bi trebao proći sve ove kvizove da bi Moodle na njemu uspješno funkcionisao';
$string['configfilenotwritten'] = 'Instalacioni skript nije bio u mogućnosti da automatski kreira datoteku config.php koja bi sadržavala Vaša odabrana podešavanja, vjerojatno zbog toga što nema prava na pisanje (mjenjanje sadržaja) u Vašem Moodle direktoriju. Ako to želite, možete ručno kopirati kod u datoteku config.php u osnovnom direktoriju Vaše Moodle instalacije.';
$string['configfilewritten'] = 'config.php je uspješno kreiran';
$string['configurationcomplete'] = 'Konfiguracija je kompletirana';
$string['configurationcompletehead'] = 'Konfiguracija je završena';
$string['configurationcompletesub'] = 'Moodle je pokušao da sačuva Vašu konfiguraciju u datoteci smještenoj u korijenskom direktoriju Moodle instalacije.';
$string['database'] = 'Baza podataka';
$string['databasehead'] = 'Podešavanja baze podataka';
$string['databasehost'] = 'Server baze podataka';
$string['databasename'] = 'Ime baze podataka';
$string['databasepass'] = 'Lozinka za pristup bazi podataka';
$string['databaseport'] = 'Port baze podataka';
$string['databasesocket'] = 'Unix socket';
$string['databasetypehead'] = 'Izaberite driver baze podataka';
$string['databasetypesub'] = 'Moodle podržava nekoliko tipova baza podataka. Ukoliko ne znate koji tip da koristite kontaktirajte administratora servera.';
$string['databaseuser'] = 'Korisničko ime za pristup bazi podataka';
$string['dataroot'] = 'Direktorij podataka';
$string['datarooterror'] = '\'Direktorij podataka\' koji ste naveli ne može biti pronađen ili kreiran. Unesite tačnu putanju ili kreirajte taj direktorij ručno.';
$string['datarootpermission'] = 'Ovlaštenja nad direktorijom podataka';
$string['datarootpublicerror'] = '\'Direktorij podataka\' koji ste podesili je direktno dostupan preko weba, morate koristiti drugi direktorij.';
$string['dbconnectionerror'] = 'Nemoguće je uspostaviti vezu sa bazom podataka koju ste naveli. Molimo provjerite podešavanja baze podataka.';
$string['dbcreationerror'] = 'Greška prilikom pravljenja baze podataka. Ne možete napraviti ime date baze podataka sa predviđenim podešavanjima';
$string['dbhost'] = 'Glavni server';
$string['dbpass'] = 'Lozinka';
$string['dbport'] = 'Port';
$string['dbprefix'] = 'Lista prefiksa';
$string['dbtype'] = 'Tip';
$string['directorysettings'] = '<p>Molimo potvrdite lokacije ovog Moodle instaliranja.</p> <p><b>Veb adresa:</b> Navedite punu web adresu putem koje će se pristupati Moodleu. Ako se Vašem web sajtu može pristupiti preko više URL adresa, izaberite onu koju će Vaši studenti najvjerovatnije koristiti. Nemojte u adresi navoditi krajnju kosu crtu.</p> <p><b>Moodle direktorij:</b> Navedite punu putanju do ove instalacije. Vodite računa o velikim i malim slovima.</p> <p><b>Direktorij podataka:</b> Morate odrediti mjesto na kojem će Moodle moći da sačuva postavljene datoteke. Korisnik web servera (obično \'nobody\' ili \'apache\') treba da ima mogućnost da čita podatke iz tog direktorija  kao i da UPISUJE podatke u njega, ali direktorij podataka ne smije biti dostupan direktno preko weba. Program za instaliranje će pokušati da kreira ovaj direktorij ukoliko on ne postoji.</p>';
$string['directorysettingshead'] = 'Molimo potvrdite lokacije ove Moodle instalacije';
$string['directorysettingssub'] = '<b>Web adresa:</b> Navedite punu web adresu putem koje će se pristupati Moodleu. Ako se Vašoj web stranici može pristupiti preko više URL adresa, izaberite onu koju će Vaši studenti najvjerovatnije koristiti. Nemojte u adresi navoditi krajnju kosu crtu. <br /> <br /> <b>Moodle direktorij:</b> Navedite punu putanju do ove instalacije. Vodite računa o velikim i malim slovima. <br /> <br /> <b>Direktorij podataka:</b> Morate odrediti mjesto na kojem će Moodle moći da sačuva postavljene datoteke. Korisnik web servera (obično \'nobody\' ili \'apache\') treba da ima mogućnost da čita podatke iz tog direktorija, kao i da UPISUJE podatke u njega, ali direktorij podataka ne smije biti dostupan direktno preko weba. Program za instaliranje će pokušati da kreira ovaj direktorij ukoliko on ne postoji.';
$string['dirroot'] = 'Moodle direktorij';
$string['dirrooterror'] = 'Izgleda da je podešavanje \'Moodle direktorija pogrešno - na navedenoj adresi nije moguće pronaći Moodle instalaciju. Donja vrijednost je resetirana.';
$string['download'] = 'Preuzeti';
$string['downloadlanguagebutton'] = 'Preuzmi "{$a}" jezički paket';
$string['downloadlanguagehead'] = 'Preuzmi jezički paket';
$string['downloadlanguagenotneeded'] = 'Možete nastaviti proces instaliranja korištenjem zadanog jezičkog paketa, "{$a}".';
$string['downloadlanguagesub'] = 'Sada imate mogućnost preuzimanja željenog jezičkog paketa i nastavka procesa instaliranja na tom jeziku.<br /><br />Ako niste u mogućnosti da preuzmete jezički paket, instalacioni proces će se nastaviti na engleskom jeziku. (Kada se instalacija završi, imaćete mogućnost da preuzmete i instalirate dodatne jezičke pakete.)';
$string['doyouagree'] = 'Da li se slažete? (da/ne)';
$string['environmenthead'] = 'Provjeravanje Vašeg okruženja...';
$string['environmentsub'] = 'Provjerava se da li razne komponente Vašeg sistema zadovoljavaju sistemske zahtjeve';
$string['environmentsub2'] = 'Svaka verzija Moodlea ima minimum zahtjeva po pitanju odgovarajuće PHP verzije i nekoliko obaveznih PHP ekstenzija. Puna provjera okruženja se vrši prije svakog instaliranja ili ažuriranja postojeće verzije. Ukoliko ne znate kako da instalirate novu verziju ili omogućite PHP ekstenzije kontaktirajte Vašeg server administratora.';
$string['errorsinenvironment'] = 'Provjera okruženja nije prošla!';
$string['fail'] = 'Izostati';
$string['fileuploads'] = 'Katalog za učitavanja datoteka';
$string['fileuploadserror'] = 'Ovo bi trebalo biti uključeno';
$string['fileuploadshelp'] = '<p>Izgleda da je postavljanje datoteka na Vašem serveru onemogućeno.</p> <p>Moodle još uvijek može biti instaliran, ali bez ove mogućnosti, nećete moći da postavite datoteke kursa ili nove slike za korisničke profile.</p> <p>Da biste omogućili postavljanje datoteka Vi, ili Vaš sistem administrator, ćete morati da uredite datoteku php.ini na svom sistemu i da promijenite podešavanje za <b>file_uploads</b> na \'1\'.</p>';
$string['inputdatadirectory'] = 'Direktorij podatka:';
$string['inputwebadress'] = 'Web adresa :';
$string['inputwebdirectory'] = 'Moodle direktorij:';
$string['installation'] = 'Instalacija';
$string['langdownloaderror'] = 'Nažalost, jezik "{$a}" se ne može preuzeti. Proces instaliranja biće nastavljen na engleskom jeziku.';
$string['langdownloadok'] = 'Jezik "{$a}" je uspješno instaliran. Instalacioni proces će biti nastavljen na ovom jeziku.';
$string['magicquotesruntime'] = 'Magic Quotes vrijeme izvršavanja';
$string['magicquotesruntimeerror'] = 'Ovo bi trebalo biti isključeno';
$string['magicquotesruntimehelp'] = '<p>Magic quotes vrijeme izvršavanja treba da bude isključeno kako bi Moodle ispravno funkcionirao.</p> <p>Normalno, ovo je isključeno prema zadanu vrijednosti... pogledajte podešavanje <b>magic_quotes_runtime</b> u svojoj php.ini datoteci.</p> <p>Ako nemate pristup svojoj php.ini datoteci, možda ćete moći da stavite sljedeći red u datoteku pod nazivom .htaccess, unutar Vašeg Moodle direktorija: <blocquote>php_value magic_quotes_runtime Off</blockquote> </p>';
$string['memorylimit'] = 'Ograničenje memorije';
$string['memorylimiterror'] = 'PHP ograničenje je podešeno na potpuno malo memorije ... kasnije se možete kretati unutar problema.';
$string['memorylimithelp'] = '<p>PHP ograničenje memorije za Vaš server je trenutno podešeno na {$a}.</p> <p>Ovo podešavanje može kasnije da prouzrokuje da Moodle ima problema sa memorijom, posebno ako imate mnogo aktiviranih modula i/ili mnogo korisnika.</p> <p>Preporučujemo da konfigurišete PHP sa višim ograničenjem ako je moguće, recimo 40M. Postoji nekoliko načina na koje to može da se to uradi:</p><ol> <li>Ako možete, rekompajlirajte PHP sa <i>--enable-memory-limit</i>. Ovo će omogućiti Moodle sistemu da sam postavi memorijsko ograničenje.</li> <li>Ako imate pristup svojoj php.ini datoteci, možete promijeniti vrijednost za <b>memory_limit</b> na, recimo, 40M. Ako nemate pristup toj datoteci možete pitati svog administratora da to uradi umjesto Vas.</li> <li>Na nekim PHP serverima možete da kreirate .htaccess datoteku u Moodle direktoriju koja sadrži red: <blockquote><div>php_value memory_limit 40M</div></blockquote> <p>Međutim, na nekim serverima to će spriječiti prikazivanje <b>svih</b> PHP stranica (vidjećete poruku o grešci kada budete gledali stranice), pa ćete sa tih servera morati da uklonite .htaccess datoteku.</p></li> </ol>';
$string['mssqlextensionisnotpresentinphp'] = 'PHP nije bio propisno konfigurisan sa MSSQL ekstenzijom tako da može komunicirati sa SQL* Serverom. Molimo Vas da provjerite svoju php.ini datoteku ili opet kompajlirate PHP.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP nije pravilno podešen za rad sa MySQLi ekstenzijom da bi mogao komunicirati sa MySQL. Molimo provjerite Vašu php.ini datoteku ili ponovo kompajlirajte PHP. MySQLi ekstenzija nije na raspolaganju za PHP 4.';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Sada je neophodno da konfigurišete bazu podataka u koju će Moodle pohranjivati većinu podataka.. Ova baza podataka, kao i korisničko ime i lozinka za pristup bazi, moraju biti prethodno već kreirani. Prefiks tabele je obavezan.';
$string['nativemysqli'] = 'Unaprijeđen MySQL(native/mysqli)';
$string['nativemysqlihelp'] = 'Sada je neophodno da konfigurišete bazu podatka gdje će najveći dio podataka iz Moodlea biti smješten. Baza podataka može biti kreirana ako korisnik baze ima potrebna ovlaštenja. Korisničko ime i lozinka moraju već da postoje. Prefiks tabela je opcioni.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Sada je neophodno da konfigurišete bazu podataka u koju će Moodle pohranjivati većinu podataka. Ova baza podataka, kao i korisničko ime i lozinka za pristup bazi, moraju biti prethodno već kreirani. Prefiks tabele je obavezan.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Sada je nophodno da konfigurišete bazu podatka gdje će najveći dio podataka iz Moodlea biti pohranjen. Ova baza podataka prethodno već mora biti kreirana, kao i korisničko ime i lozinka potrebni za pristup bazi. Prefiks tabele je obavezan.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Sada je neophodno da konfigurišete bazu podataka u koju će Moodle pohranjivati većinu podataka. Ova baza podataka, kao i korisničko ime i lozinka za pristup bazi, moraju biti prethodno već kreirani. Prefiks tabele je obavezan.';
$string['nativesqlsrvnodriver'] = 'Microsoft drajveri za SQL server za PHP nisu instalirani ili nisu pravilno konfigurisani.';
$string['nativesqlsrvnonwindows'] = 'Microsoft drajveri za SQL server za PHP dostupni su samo za Windows OS.';
$string['ociextensionisnotpresentinphp'] = 'PHP nije bio propisno konfigurisan sa OCI8 ekstenzijom tako da može komunicirati sa Oracle-om. Molimo Vas da provjerite svoju php.ini datoteku ili opet kompajlirate PHP.';
$string['pass'] = 'Proći';
$string['paths'] = 'Putanje';
$string['pathserrcreatedataroot'] = 'Instalaciona procedura ne može da kreira direktorij baze podataka ({$a->dataroot}).';
$string['pathshead'] = 'Potvrdi putanje';
$string['pathsrodataroot'] = 'U direktorij za podatke nije moguć upis';
$string['pathsroparentdataroot'] = 'Nije moguć upis u nadređeni direktorij ({$a->parent}). Instalacioni program ne može da kreira direktorij za podatke ({$a->dataroot}).';
$string['pathssubadmindir'] = 'Vrlo mali broj web servera koristi /admin kao specijalni URL za pristup raznim podešavanjima (kontrolni panel i sl.). Nažalost, to dovodi do konflikta sa standardnom lokacijom za administratorske stranice u Moodleu. Ovaj problem možete riješiti tako što ćete promijeniti ime administratorskog direktoriju u Vašoj instalaciji, i ovdje upisati to novo ime. Na primjer <em>moodleadmin</em>. Ovo podešavanje će prepraviti administratorske linkove u Moodle sistemu.';
$string['pathssubdataroot'] = 'Potreban Vam je prostor gdje će Moodle čuvati postavljene datoteke. Ovaj direktorij treba da bude podešen tako da se može čitati i u njega upisivati od strane korisnika web servera (obično \'nobody\' ili \'apache\'), ali istovremeno mora biti dostupan direktno preko weba. Ukoliko ovaj direktorij ne postoji Moodle će pokušati da ga kreira tokom instalacije.';
$string['pathssubdirroot'] = 'Puna putanja do direktotija za instaliranje Moodlea.';
$string['pathssubwwwroot'] = 'Puna web adresa putem koje će se pristupati Moodleu. Nije moguće pristupati Moodleu koristeći više adresa. Ako Vaša stranica ima više javnih adresa onda na svima morate da podesite permanentne redirekcije osim na ovoj. Ako je Vaša stranica dostupna sa interneta ali i iz intranet okruženja ovdje upotrijebite javnu adresu i podesite DNS tako da i intranet korisnici mogu da koriste javnu adresu. Ako je adresa netačna promijenite URL u svom web čitaču da biste ponovo pokrenuli instalaciju sa drugačijom vrijednošću.';
$string['pathsunsecuredataroot'] = 'Dataroot lokacija nije bezbjedna';
$string['pathswrongadmindir'] = 'Admin direktorij ne postoji';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP nije bio propisno konfigurisan sa PGSQL ekstenzijom tako da može komunicirati sa PostgreSQLom. Molimo Vas da provjerite svoju php.ini datoteku ili opet kompajlirate PHP.';
$string['phpextension'] = '{$a} PHP ekstenѕija';
$string['phpversion'] = 'PHP verzija';
$string['phpversionhelp'] = '<p>Moodle zahtijeva najmanje PHP verziju 4.3.0 ili 5.1.0 (5.0.x ima brojne uočene probleme).</p> <p>Trenutno koristite verziju {$a}</p> <p>Morate nadograditi PHP ili premjestiti Moodle na web server sa novijom verzijom PHP-a!</br> (U slučaju verzije 5.0.x možete, također, da se vratite na 4.4.x verziju)</p>';
$string['releasenoteslink'] = 'Za više informacija o ovoj verziji Moodlea, pogledajte napomene uz izdanje na {$a}';
$string['safemode'] = 'Sigurnosni mod';
$string['safemodeerror'] = 'Moodle može imati problema sa uključenim sigurnosnim modom rada';
$string['safemodehelp'] = '<p>Moodle može imati različite probleme ako je uključen sigurnosni mod rada. Jedan od bitnijih je taj što mu vjerovatno neće biti dozvoljeno da kreira nove datoteke.</p> <p>Sigurnosni mod rada je obično omogućen jedino na paranoidnim javnim web serverima, tako da ćete možda morati da za svoju Moodle stranicu nađete novi web server kod neke druge kompanije.</p> <p>Možete pokušati da nastavite sa instaliranjem, ako želite, ali očekujte nekoliko problema kasnije.</p>';
$string['sessionautostart'] = 'Automatski početak akcije';
$string['sessionautostarterror'] = 'Ovo bi trebalo biti isključeno';
$string['sessionautostarthelp'] = '<p>Moodle zahtijeva podršku za sesije i neće funcionisati bez nje.</p> <p>Rad sa sesijama se može omogućiti u php.ini datoteci... potražite session.auto_start parametar.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP nije pravilno podešen sa ekstenzijom SQLite. Molimo provjerite Vašu datoteku php.ini ili ponovo kompajlirajte PHP.';
$string['upgradingqtypeplugin'] = 'Nadogradnja dodatka za pitanja/tipove';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Ovu stranicu vidite zato što ste uspješno instalirali i pokrenuli <strong>{$a->packname} {$a->packversion}</strong> paket na svom serveru. Čestitamo!';
$string['welcomep30'] = 'Ovo izdanje <strong>{$a->installername}</strong> uključuje aplikacije za kreiranje okruženja u kojem će <strong>Moodle</strong> uspješno funkcionisati, konkretno:';
$string['welcomep40'] = 'Ovaj paket obuhvata i <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Korištenje svih aplikacija ovog paketa je uređeno njihovim licencama. Kompletan<strong>{$a->installername}</strong> paket je <a href="http://www.opensource.org/docs/definition_plain.html">otvorenog koda</a> i distribuira se pod <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> licencom.';
$string['welcomep60'] = 'Naredne stranice će vas provesti kroz nekoliko jednostavnih koraka tokom kojih ćete konfigurisati i podesiti <strong>Moodle</strong> na svom računaru. Možete prihvatiti zadano podešavanja ili ih, opciono, prilagoditi vlastitim potrebama.';
$string['welcomep70'] = 'Kliknite na dugme za nastavak da biste dalje podešavali <strong>Moodle</strong>.';
$string['wwwroot'] = 'Web adresa';
$string['wwwrooterror'] = 'Navedena \'Web adresa\' se čini nevalidnom - ova Moodle instalacija izgleda nije na njoj. Vrijednost navedena ispod je resetovana.';
