<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Dodaj komentar';
$string['addentry'] = 'Dodaj novi pojam';
$string['addingcomment'] = 'Dodaj komentar';
$string['alias'] = 'Ključna riječ';
$string['aliases'] = 'Ključne riječi';
$string['aliases_help'] = '<p>Svaki pojam u rječniku može imati pridruženu listu ključnih riječi.</p> <p><b>Svaku ključnu riječ unijeti u novi red</b> (ne treba razdvajati zarezima).</p> <p>Ove riječi mogu se koristiti kao alternativni načini za pozivanje na pojmove. Recimo, ako koristite filter za auto-linkovanje rječnika biće korištene ključne riječi (u istoj mjeri kao i glavni naziv pojma) kada se odlučuje koje riječi linkovati za taj pojam.</p>';
$string['allcategories'] = 'Sve kategorije';
$string['allentries'] = 'SVE';
$string['allowcomments'] = 'Dozvolite komentarisanje pojmova';
$string['allowcomments_help'] = '<p>Studentima može biti dozvoljeno da unose komentare za pojmove u rječniku.</p> <p>Možete odabrati želite li da ova opcija bude uključena ili isključena.</p> <p>Predavači uvijek mogu da dodaju komentare za pojmove u rječniku.</p>';
$string['allowduplicatedentries'] = 'Dozvoljeni su dupli pojmovi';
$string['allowduplicatedentries_help'] = '<p>Ako uključite ovu opciju, biće dozvoljeno da višestruki pojmovi imaju isto konceptualno ime.</p>';
$string['allowprintview'] = 'Dozvoliti prikaz verzije za štampu';
$string['allowprintview_help'] = '<p>Studentima može biti omogućeno da koriste prikaz verzije za štampu rječnika.</p> <p>Možete odabrati želite li da ova opcija bude uključena ili isključena.</p> <p>Predavači uvijek mogu da koriste prikaz verzije za štampu.</p>';
$string['andmorenewentries'] = 'i još {$a} novih pojmova.';
$string['answer'] = 'Odgovor';
$string['approvaldisplayformat'] = 'Format prikaza prilikom odobravanja';
$string['approvaldisplayformat_help'] = 'Prilikom odobravanja novih stavki u rječniku možda ćete htjeti da koristite drugačiji format prikaza';
$string['approve'] = 'Odobri';
$string['areaattachment'] = 'Prilozi';
$string['areaentry'] = 'Definicije';
$string['areyousuredelete'] = 'Jeste li sigurni da želite da izbrišete ovaj pojam?';
$string['areyousuredeletecomment'] = 'Jeste li sigurni da želite da izbrišete ovaj komentar?';
$string['areyousureexport'] = 'Jeste li sigurni da želite da prenesete ovaj pojam u';
$string['ascending'] = 'rastući';
$string['attachment'] = 'Prilog';
$string['attachment_help'] = '<p>Možete opciono priložiti JEDAN dokument sa svog kompjutera bilo kom pojmu u rječniku. Taj dokument se dodaje na server i čuva se sa pomenutim pojmom.</p> <p>Ovo je korisno kada želite da dijelite sliku, recimo, ili Word dokument.</p> <p>Ovaj dokument može biti bilo kog tipa, ali je strogo preporučljivo da je ime dokumenta sa standardnim sufiksima za internet od tri slova, kao što su .doc za Word dokumente, .jpg ili .png za slike, itd. Ovo će olakšati drugima da preuzmu sa mreže i vide Vaše priloge na svojim pretraživačima.</p> <p>Ako ponovo izmijenite pojam i zakačite novi dokument, ranije dodan prilog biće zamijenjen.</p> <p>Ako ponovo izmijenite pojam i prilog i ostavite ovo mjesto prazno, originalni prilog će biti vraćen.</p>';
$string['author'] = 'autor';
$string['authorview'] = 'Pregled po autorima';
$string['back'] = 'Nazad';
$string['cantinsertcat'] = 'Ne može se dodati kategorija';
$string['cantinsertrec'] = 'Ne može se dodati pojam';
$string['cantinsertrel'] = 'Ne može se dodati relacija kategorija - pojam';
$string['casesensitive'] = 'Ovaj unos je osjetljiv na velika i mala slova';
$string['casesensitive_help'] = '<p>Ova opcija određuje da li je neophodno tačno podudaranje u velikim i malim slovima prilikom automatskog linkovanja pojmova.</p> <p>Na primjer, ako je ova opcija uključena, tada se riječ "html" u poruci na forumu NEĆE linkovati na pojam "HTML" u rječniku.</p>';
$string['cat'] = 'kategorija';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categorydeleted'] = 'Kategorija je izbrisana';
$string['categoryview'] = 'Pregled po kategorijama';
$string['changeto'] = 'promjena u <b>{$a}</b>';
$string['cnfallowcomments'] = 'Definiše da li se podrazumijeva da će rječnik prihvatati komentare pojmova';
$string['cnfallowdupentries'] = 'Definiše da li se podrazumijeva da će rječnik prihvatati duple pojmove';
$string['cnfapprovalstatus'] = 'Definiše podrazumijevani status za odobravanje unosa novih pojmova poslanih od strane studenta';
$string['cnfcasesensitive'] = 'Definiše da li da novi pojam, kad je linkovan, po zadanoj vrijednosti razlikuje mala i velika slova';
$string['cnfdefaulthook'] = 'Izaberite zadani način za prikaz rječnika viđenog po prvi put';
$string['cnfdefaultmode'] = 'Izaberite zadani okvir za prikaz rječnika viđenog po prvi put.';
$string['cnffullmatch'] = 'Definiše da se pojam, ako je linkovan, apsolutno poklapa sa ciljanim tekstom';
$string['cnflinkentry'] = 'Definira da li novi pojam treba da bude automatski linkovan';
$string['cnflinkglossaries'] = 'Definira da li rječnik treba da bude automatski linkovan';
$string['cnfrelatedview'] = 'Izaberite format prikaza koji će biti korišten za automatsko linkovanje i prikaz pojmova.';
$string['cnfshowgroup'] = 'Odlučite da li grupna pauza treba da bude prikazana ili ne.';
$string['cnfsortkey'] = 'Izaberite zadani ključ za sortiranje.';
$string['cnfsortorder'] = 'Izaberite zadani redoslijed sortiranja.';
$string['cnfstudentcanpost'] = 'Definiše da li studenti po zadanim opcijama mogu ili ne mogu da unose pojmove u rječnik';
$string['comment'] = 'Komentar';
$string['commentdeleted'] = 'Komentar je izbrisan.';
$string['comments'] = 'Komentari';
$string['commentson'] = 'Komentari su uključeni';
$string['commentupdated'] = 'Komentar je ažuriran.';
$string['completionentries'] = 'Broj pojmova koje student mora da unese:';
$string['completionentriesgroup'] = 'Zahtijevaj unos pojmova';
$string['concept'] = 'Pojam';
$string['concepts'] = 'Pojmovi';
$string['configenablerssfeeds'] = 'Ovaj prekidač će omogućiti korištenje RSS servisa za sve rječnike. Ipak, moraćete ručno da uključite RSS podršku u podešavanjima za svaki rječnik posebno.';
$string['current'] = 'Trenutno sortirano <b>{$a}</b>';
$string['currentglossary'] = 'Trenutni rječnik';
$string['date'] = 'datum';
$string['dateview'] = 'Pregled po datumu';
$string['defaultapproval'] = 'Zadani status za odobrenja';
$string['defaultapproval_help'] = '<p>Ova opcija omogućava predavaču da definiše šta će biti sa novim pojmovima koje su dodali studenti. Oni mogu biti automatski dostupni svima, ili, sa druge strane, predavač mora da odobri svaki od njih.</p>';
$string['defaulthook'] = 'Zadani način';
$string['defaultmode'] = 'Zadani prikaz';
$string['defaultsortkey'] = 'Zadani ključ za sortiranje';
$string['defaultsortorder'] = 'Zadani redoslijed sortiranja';
$string['definition'] = 'Definicija';
$string['definitions'] = 'Definicije';
$string['deleteentry'] = 'Izbriši pojam';
$string['deletenotenrolled'] = 'Izbriši pojmove učesnika koji nisu upisani na kurs';
$string['deletingcomment'] = 'Brisanje komentara';
$string['deletingnoneemptycategory'] = 'Brisanjem ove kategorije, nećete izbrisati pojmove koje sadrži - oni će biti označeni kao nekategorizovani.';
$string['descending'] = 'opadajući';
$string['destination'] = 'Odredište unesenih pojmova';
$string['destination_help'] = '<p>Možete navesti gdje želite da unesete pojmove:</p> </p><ul><li><strong>Tekući rječnik:</strong> Pojmovi koje unosite biće dodani u trenutno otvoren rječnik. </li> <li><strong>Novi rječnik:</strong> Kreiraće novi rječnik baziran na informacijama pronađenim u odabranom dokumentu koji se unosi i dodaće nove pojmove u njega.</li> </ul>';
$string['disapprove'] = 'Ne odobriti';
$string['displayformat'] = 'Format prikaza';
$string['displayformatcontinuous'] = 'Produžen bez autora';
$string['displayformatdefault'] = 'Standardno, isto kao i format prikaza';
$string['displayformatdictionary'] = 'Jednostavan, u stilu rječnika';
$string['displayformatencyclopedia'] = 'Enciklopedija';
$string['displayformatentrylist'] = 'Popis pojmova';
$string['displayformatfaq'] = 'Često postavljana pitanja';
$string['displayformatfullwithauthor'] = 'Puni format sa autorom';
$string['displayformatfullwithoutauthor'] = 'Puni format bez navođenja autora';
$string['displayformat_help'] = 'Postoji 7 različitih formata za prikaz pojmova: * Jednostavan, u stilu riečnika - izgleda kao konvencionalan rječnik sa odvojenim pojmovima. Autori nisu prikazani, a prilozi se prikazuju kao linkovi * Kontinuirani bez imena autora - prikazuje pojmove jedan za drugim, koji su razdvojeni samo ikonicama za uređivanje * Puni format sa imenom autora - ovaj format je sličan izgledu foruma i prikazuje podatke o autoru, dok su prilozi prikazani kao linkovi * Puni format bez imena autora - ovaj format je, također, sličan izgledu foruma, ali ne prikazuje podatke o autoru, dok su prilozi prikazani kao linkovi * Enciklopedija - ovaj format je isti kao "Puni format sa imenom autora" osim što se priložene slike prikazuju unutar teksta (definicije pojma) * Lista pojmova - pojmovi su navedeni kao linkovi * FAQ (<i>Frequently Asked Questions</i> - često postavljana pitanja) - u ovom formatu kao pojam se prikazuje PITANJE, a definicija kao ODGOVOR.';
$string['displayformats'] = 'Formati prikaza';
$string['displayformatssetup'] = 'Prikaz podešavanja formata';
$string['duplicatecategory'] = 'Dupla kategorija';
$string['duplicateentry'] = 'Dupli pojam';
$string['editalways'] = 'Uvijek dozvoljeno uređivanje';
$string['editalways_help'] = '<p>Ova opcija Vam daje mogućnost da odlučite da li će studenti moći da uređuju svoje pojmove u bilo kom momentu.</p> <p>Možete izabrati:</p> <ul> <li><b>Da:</b> Pojmovi se uvijek mogu uređivati.</li> <li><b>Ne:</b> Pojmovi se mogu uređivati dok ne istekne vrijeme predviđeno za to.</li> </ul>';
$string['editcategories'] = 'Uredi kategorije';
$string['editentry'] = 'Uredi pojam';
$string['editingcomment'] = 'Uređivanje komentara';
$string['entbypage'] = 'Broj pojmova po stranici';
$string['entries'] = 'Pojmovi';
$string['entrieswithoutcategory'] = 'Pojmovi van kategorija';
$string['entry'] = 'Pojam';
$string['entryalreadyexist'] = 'Pojam već postoji';
$string['entryapproved'] = 'Ovaj pojam je odobren';
$string['entrydeleted'] = 'Pojam je izbrisan';
$string['entryexported'] = 'Pojam je uspješno prenesen';
$string['entryishidden'] = '(ovaj pojam je trenutno sakriven)';
$string['entryleveldefaultsettings'] = 'Zadana podešavanja na nivou pojma';
$string['entrysaved'] = 'Pojam je sačuvan';
$string['entryupdated'] = 'Pojam je ažuriran';
$string['entryusedynalink'] = 'Ovaj pojam treba da bude automatski linkovan';
$string['entryusedynalink_help'] = '<p align="center"><b>Omogući automatsko linkovanje u pojmu</b></p> <p></p> <p>Uključivanje ove opcije će omogućiti pojmu da bude automatski linkovan kad god se taj pojam ili izraz pojavi negdje u okviru istog kursa. To podrazumijeva poruke na forumima, unutrašnje resurse, sedmične preglede itd.</p> <p>Ako ne želite da određeni tekst bude linkovan (u porukama na forumima, recimo), onda treba da dodate &lt;nolink&gt; ispred i &lt;/nolink&gt; iza tog teksta.</p> <p>Da bi ova opcija mogla da se uključi mora biti omogućeno automatsko linkovanje na nivou rječnika.</p>';
$string['errcannoteditothers'] = 'Ne možete uređivati pojmove drugih korisnika.';
$string['errconceptalreadyexists'] = 'Ovaj pojam već postoji. Dupli pojmovi nisu dozvoljeni u ovom rječniku.';
$string['errdeltimeexpired'] = 'Ne možete ovo izbrisati. Vrijeme je isteklo!';
$string['erredittimeexpired'] = 'Isteklo je vrijeme za uređivanje ovog pojma.';
$string['errorparsingxml'] = 'Pojavile su se greške pri parsiranju datoteke. Provjerite validnost XML sintakse.';
$string['explainaddentry'] = 'Dodaj novi pojam trenutnom rječniku.<br />Pojam i definicija su obavezna polja.';
$string['explainall'] = 'Prikazivanje SVIH pojmova na jednoj stranici';
$string['explainalphabet'] = 'Pregled rječnika korištenjem ovog indeksa';
$string['explainexport'] = 'Datoteka je napravljena.<br />Preuzmite je i sačuvajte. Možete je uvijek kad to želite unijeti u ovaj ili drugi kurs.<p>Imajte na umu da prilozi (npr. slike) i autori nisu preneseni.</p>';
$string['explainimport'] = 'Morate da odredite datoteku za unos i da definirate kriterije za taj proces.<br />Priložite zahtjev i pregledajte rezultate.';
$string['explainspecial'] = 'Prikaži pojmove koji ne počinju slovom';
$string['exportedentry'] = 'Prenesen pojam';
$string['exportentries'] = 'Prenesi pojmove';
$string['exportentriestoxml'] = 'Prenesi pojmove u XML datoteku';
$string['exportfile'] = 'Prenesi pojmove u datoteku';
$string['exportglossary'] = 'Prenesi rječnik';
$string['exporttomainglossary'] = 'Prenesi u glavni rječnik';
$string['filetoimport'] = 'Datoteka za unos';
$string['filetoimport_help'] = '<p>Odaberite na svom kompjuteru XML datoteku koja sadrži pojmove za unos.</p>';
$string['fillfields'] = 'Pojam i definicija su obavezna polja.';
$string['filtername'] = 'Automatsko linkovanje rječnika';
$string['fullmatch'] = 'Ako se podudaraju isključivo cijele riječi';
$string['fullmatch_help'] = '<p>Ako je omogućeno automatsko linkovanje, onda će uključivanje ove opcije forsirati samo cijele riječi za linkovanje.</p> <p>Na primjer, pojam "construct" u rječniku neće napraviti link unutar riječi "constructivism".</p>';
$string['glossary:addinstance'] = 'Dodaj novi rječnik';
$string['glossary:approve'] = 'Odobri neodobrene pojmove';
$string['glossary:comment'] = 'Napiši komentar';
$string['glossary:export'] = 'Prenos pojmova';
$string['glossary:exportentry'] = 'Prenos jednog pojma';
$string['glossary:exportownentry'] = 'Prenos jednog vlastitog pojma';
$string['glossary:import'] = 'Unos pojmova';
$string['glossaryleveldefaultsettings'] = 'Zadana podešavanja na nivou rječnika';
$string['glossary:managecategories'] = 'Upravljanje kategorijama';
$string['glossary:managecomments'] = 'Upravljanje komentarima';
$string['glossary:manageentries'] = 'Upravljanje pojmovima';
$string['glossary:rate'] = 'Ocijeni pojmove';
$string['glossarytype'] = 'Vrsta rječnika';
$string['glossarytype_help'] = '<p>Sistem rječnika dozvoljava prenos pojmova iz bilo kog sporednog rječnika u glavni rječnik kursa.</p> <p>Da biste to uradili, potrebno je da definirate koji je glavni rječnik kursa.</p> <p>Primjedba: Možete imati samo jedan glavni rječnik u okviru kursa i jedino je predavačima dozvoljeno da ga nadograđuju.</p>';
$string['glossary:view'] = 'Pogledaj rječnik';
$string['glossary:viewallratings'] = 'Pogledajte sve neobrađene ocjene date od strane pojedinaca';
$string['glossary:viewanyrating'] = 'Pogledajte ukupne ocjene koje je bilo ko dobio';
$string['glossary:viewrating'] = 'Pogledajte ukupnu ocjenu koju ste dobili';
$string['glossary:write'] = 'Kreiranje novih pojmova';
$string['guestnoedit'] = 'Gostima nije dozvoljeno da uređuju rječnike';
$string['importcategories'] = 'Unesi kategorije';
$string['importedcategories'] = 'Unesene kategorije';
$string['importedentries'] = 'Uneseni pojmovi';
$string['importentries'] = 'Unesi pojmove';
$string['importentriesfromxml'] = 'Unesi pojmove iz XML datoteke';
$string['includegroupbreaks'] = 'Uključi prelaze grupa';
$string['isglobal'] = 'Da li je ovo opšti rječnik?';
$string['isglobal_help'] = '<p>Administratori mogu da odrede rječnik koji će biti osnovni.</p> <p>Ovi rječnici mogu biti dio bilo kog kursa (but particulary front page).</p> <p>Razlika između normalnog lokalnog rječnika i osnovnog rječnika je da se u osnovnom rječniku pojmovi koriste za kreiranje automatskih linkova na nivou cijele stranice (a ne samo na nivou kursa kome rječnik pripada).</p>';
$string['letter'] = 'slovo';
$string['linkcategory'] = 'Automatski linkuj ovu kategoriju';
$string['linkcategory_help'] = '<p>Možete podesiti želite li da kategorije budu automatski linkovane, ili ne.</p> <p>Primjedba: Kategorije se linkuju bazirano na podudaranju cijelih riječi sa razlikovanjem velikih i malih slova.</p>';
$string['linking'] = 'Automatsko linkovanje';
$string['mainglossary'] = 'Glavni rječnik';
$string['maxtimehaspassed'] = 'Žao nam je, maksimalno dopušteno vrijeme za uređivanje/izmjenu ovog komentara ({$a}) je isteklo!';
$string['modulename'] = 'Rječnik';
$string['modulename_help'] = 'Modul \'Rječnik\' omogućava učesnicima da kreiraju i održavaju popise pojmova i njihovih definicija, ili da sakupljaju i organizuju resurse i informacije. Predavač može da dozvoli da se uz pojmove u rječniku dodaju datoteke kao prilog. Priložene slike se prikazuju unutar definicije pojma. Pojmovi u rječniku mogu da se pretražuju ili pregledaju po abecednom redosljedu ili po kategorijama, datumu ili autoru. Uneseni pojmovi mogu biti automatski odobreni za objavljivanje, ili ih predavač mora odobriti prije nego što postanu svima vidljivi. Ako je filter za automatsko linkovanje rječnika omogućen, pojmovi će automatski biti povezani gdje god da se unutar kursa pojavljuju riječi i/ili fraze iz pojma (ili ključnih riječi kojima se pojam dodatno definira). Predavač može da dozvoli komentiranje pojmova, kao i njihovo ocjenjivanje kako od strane predavača, tako i od strane studenata (vršnjačka evaluacija). Ocjene mogu da se sabiraju kako bi se formirala finalna ocjena koja se bilježi u knjigu ocjena. Rječnici mogu da se koriste na različite načine, kao na primjer: * Kolaborativno kreirana banka ključnih termina * Prostor za upoznavanje gdje novi studenti dodaju svoja imena i lične podatke * Korisni savjeti - katalog primjera najbolje prakse o praktičnim temama * Prostor za dijeljenje korisnih video klipova, slika ili audio datoteka * Katalog činjenica koje treba zapamtiti';
$string['modulenameplural'] = 'Rječnici';
$string['newentries'] = 'Novi pojmovi u rječniku';
$string['newglossary'] = 'Novi rječnik';
$string['newglossarycreated'] = 'Novi rječnik je kreiran.';
$string['newglossaryentries'] = 'Novi pojmovi u rječniku:';
$string['nocomment'] = 'Nisu pronađeni komentari';
$string['nocomments'] = '(Nema komentara ovog pojma)';
$string['noconceptfound'] = 'Nisu pronađeni koncepti ili definicije.';
$string['noentries'] = 'Nisu pronađeni pojmovi u ovoj sekciji';
$string['noentry'] = 'Nije pronađen nijedan pojam.';
$string['nopermissiontodelcomment'] = 'Ne možete brisati komentare drugih korisnika!';
$string['nopermissiontodelinglossary'] = 'Ne možete brisati komentare u ovom rječniku!';
$string['nopermissiontoviewresult'] = 'Možete pregledati rezultate samo za vlastite unose';
$string['notapproved'] = 'Pojam još uvijek nije odobren';
$string['notcategorised'] = 'Nije kategorisano';
$string['numberofentries'] = 'Broj pojmova';
$string['onebyline'] = '(jedan po liniji)';
$string['page-mod-glossary-edit'] = 'Ulazna stranica rječnika za dodavanje/uređivanje pojmova';
$string['page-mod-glossary-view'] = 'Stranica za pregled rječnika';
$string['page-mod-glossary-x'] = 'Bilo koja stranica modula Rječnik';
$string['pluginadministration'] = 'Administracija rječnika';
$string['pluginname'] = 'Rječnik';
$string['popupformat'] = 'Pop-up format';
$string['print'] = 'Print';
$string['printerfriendly'] = 'Verzija za štampu';
$string['printviewnotallowed'] = 'Prikaz verzije za štampu nije dozvoljen';
$string['question'] = 'Pitanje';
$string['rejectedentries'] = 'Odbačeni pojmovi';
$string['rejectionrpt'] = 'Izvještaj o odbačenim pojmovima';
$string['resetglossaries'] = 'Izbriši pojmove iz';
$string['resetglossariesall'] = 'Izbriši pojmove iz svih rječnika';
$string['rssarticles'] = 'Broj novijih RSS članaka (pojmova)';
$string['rssarticles_help'] = '<p>Ova opcija Vam daje mogućnost da odaberete broj članova koji želite da uključite u RSS izvor vijesti.</p> <p>Broj između 5 i 20 je za većinu rječnika normalan. Ako rječnik često nadograđujete, povećajte ovaj broj.</p>';
$string['rsssubscriberss'] = 'Prikazati RSS podršku za \'{$a}\' koncepte';
$string['rsstype'] = 'RSS izvor za ovu aktivnost';
$string['rsstype_help'] = '<p>Ova opcija Vam dopušta da omogućite RSS izvor vijesti za tekući rječnik.</p> <p>Možete birati između dvije vrste podrški:</p> </p><ul><li><b>Sa autorom:</b> Generisani izvori vijesti će uključiti ime autora u svakom članu. </li><li><b>Bez autora:</b>Generisani izvori vijesti neće uključiti ime autora u svaki član.</li> </ul>';
$string['searchindefinition'] = 'Pretraži kompletan tekst';
$string['secondaryglossary'] = 'Sekundarni rječnik';
$string['showall'] = 'Prikaži link \'SVE';
$string['showall_help'] = '<p>Možete prilagoditi na koji način želite da omogućite da korisnik pregleda rječnik. Pregledanje i pretraživanje su uvijek dostupni, a možete da odredite i još tri opcije:</p> <p><b>PRIKAŽI SPECIJALNE</b> Omogući ili onemogući prikazivanje po specijalnim karakterima kao što su @, #, itd. </p> <p><b>PRIKAŽI ABECEDU</b> Omogući ili onemogući abecedno prikazivanje.</p> <p><b>PRIKAŽI SVE</b> Omogući ili onemogući prikazivanje svih pojmova odjednom.</p>';
$string['showalphabet'] = 'Prikaži abecedu';
$string['showalphabet_help'] = '<p>Možete prilagoditi na koji način želite da omogućite da korisnik pregleda rječnik. Pregledanje i pretraživanje su uvijek dostupni, a možete da odredite i još tri opcije:</p> <p><b>PRIKAŽI SPECIJALNE</b> Omogući ili onemogući prikazivanje po specijalnim karakterima kao što su @, #, itd. </p> <p><b>PRIKAŽI ABECEDU</b> Omogući ili onemogući abecedno prikazivanje.</p> <p><b>PRIKAŽI SVE</b> Omogući ili onemogući prikazivanje svih pojmova odjednom.</p>';
$string['showspecial'] = 'Prikaži link \'Specijalno';
$string['showspecial_help'] = '<p>Možete prilagoditi na koji način želite da omogućite da korisnik pregleda rječnik. Pregledanje i pretraživanje su uvijek dostupni, a možete da odredite i još tri opcije:</p> <p><b>PRIKAŽI SPECIJALNE</b> Omogući ili onemogući prikazivanje po specijalnim karakterima kao što su @, #, itd. </p> <p><b>PRIKAŽI ABECEDU</b> Omogući ili onemogući abecedno prikazivanje.</p> <p><b>PRIKAŽI SVE</b> Omogući ili onemogući prikazivanje svih pojmova odjednom.</p>';
$string['sortby'] = 'Sortiraj';
$string['sortbycreation'] = 'Po datumu kreiranja';
$string['sortbylastupdate'] = 'Po datumu posljednje izmjene';
$string['sortchronogically'] = 'Hronološki';
$string['special'] = 'Specijalno';
$string['standardview'] = 'Pregled po abecedi';
$string['studentcanpost'] = 'Studenti mogu dodavati pojmove';
$string['totalentries'] = 'Ukupno pojmova';
$string['usedynalink'] = 'Automatski linkuj pojmove iz rječnika';
$string['usedynalink_help'] = '<p>Uključivanje ove opcije omogućuje pojedinačnim pojmovima u tekućem rječniku da budu automatski linkovani kad god se taj pojam ili izraz pojavi negdje u okviru tog kursa. To podrazumijeva poruke na forumima, unutrašnje resurse, sedmične preglede itd.</p> <p>Obratite pažnju na to da omogućavanje linkovanja za rječnik ne uključuje automatski i linkovanje za svaki pojam - linkovanje mora biti podešeno za svaki pojam posebno.</p> <p>Ako ne želite da određeni tekst bude linkovan (u porukama na forumu, recimo) onda treba da dodate &lt;nolink&gt; ispred i &lt;/nolink&gt; iza teksta. </p> <p>Zapamtite da se i imena kategorija takođe linkuju.</p>';
$string['waitingapproval'] = 'Čeka na odobrenje';
$string['warningstudentcapost'] = '(Važi samo ako rječnik nije glavni)';
$string['withauthor'] = 'Pojmovi uz navođenje autora';
$string['withoutauthor'] = 'Pojmovi bez navođenja autora';
$string['writtenby'] = 'od';
$string['youarenottheauthor'] = 'Vi niste autor ovog komentara, pa Vam nije dozvoljeno da ga mijenjate.';
