<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Dodani su novi postovi na forumu';
$string['addanewdiscussion'] = 'Dodaj novu temu za diskusiju';
$string['addanewquestion'] = 'Dodaj novo pitanje';
$string['addanewtopic'] = 'Dodaj novu temu';
$string['advancedsearch'] = 'Napredno pretraživanje';
$string['allforums'] = 'Svi forumi';
$string['allowdiscussions'] = 'Da li {$a} može slati poruke na ovaj forum?';
$string['allowsallsubscribe'] = 'Ovaj forum dozvoljava svima da odaberu da li će se pretplatiti ili ne';
$string['allowsdiscussions'] = 'Ovaj forum dozvoljava svakoj osobi da započne jednu diskusiju.';
$string['allsubscribe'] = 'Prijavite se na sve forume';
$string['allunsubscribe'] = 'Odjavite se sa svih foruma';
$string['alreadyfirstpost'] = 'Već postoji prva poruka u diskusiji';
$string['anyfile'] = 'Bilo koja datoteka';
$string['areaattachment'] = 'Prilozi';
$string['areapost'] = 'Poruke';
$string['attachment'] = 'Prilog';
$string['attachment_help'] = 'Poruci možete da priložite jednu ili više datoteka. Ako priložite sliku, ona će biti prikazana nakon poruke.';
$string['attachmentnopost'] = 'Ne možete da prenesete priloge bez ID broja poruke';
$string['attachments'] = 'Prilozi';
$string['attachmentswordcount'] = 'Prilozi i broj riječi';
$string['blockafter'] = 'Granična vrijednost broja poruka koja dovodi do blokiranja';
$string['blockafter_help'] = 'Ovo podešavanje određuje maksimalan broj poruka koje korisnik može da postuje na forumu u datom vremenskom periodu. Ovo ograničenje ne važi za korisnike koji imaju ovlaštenja mod/forum:postwithoutthrottling.';
$string['blockperiod'] = 'Vremenski period nakon kojeg se vrši blokiranje';
$string['blockperioddisabled'] = 'Ne blokirati';
$string['blockperiod_help'] = 'Moguće je ograničiti broj poruka koje studenti mogu poslati unutar datog vremenskog perioda. Ovo ograničenje ne važi za korisnike koji imaju ovlaštenja mod/forum:postwithoutthrottling .';
$string['blogforum'] = 'Standardni forum u obliku bloga';
$string['bynameondate'] = 'napisao/la {$a->name} - {$a->date}';
$string['cannotadd'] = 'Nije moguće dodati diskusiju na ovom forumu';
$string['cannotadddiscussion'] = 'Dodavanje diskusije u okviru ovog foruma zahtijeva grupno članstvo.';
$string['cannotadddiscussionall'] = 'Nemate dozvolu da dodajete novu temu za diskusiju za sve učesnike.';
$string['cannotaddsubscriber'] = 'Nije bilo moguće dodati pretplatnika sa ID brojem {$a} na ovaj forum!';
$string['cannotaddteacherforumto'] = 'Nije bilo moguće dodati instancu izmijenjenog foruma predavača u sekciju 0 ovoga kursa';
$string['cannotcreatediscussion'] = 'Nije bilo moguće otvoriti novu diskusiju';
$string['cannotcreateinstanceforteacher'] = 'Nije bilo moguće krerati novu instancu modula za predavački forum';
$string['cannotdeletepost'] = 'Ne možete da izbrišete ovu poruku!';
$string['cannoteditposts'] = 'Ne možete da uređujete poruke drugih korisnika!';
$string['cannotfinddiscussion'] = 'Nije bilo moguće naći diskusiju na ovom forumu';
$string['cannotfindfirstpost'] = 'Nije bilo moguće naći prvu poruku na ovom forumu';
$string['cannotfindorcreateforum'] = 'Nije bilo moguće naći ili kreirati glavni forum za novosti na ovoj stranici';
$string['cannotfindparentpost'] = 'Nije bilo moguće naći nadređenu poruku za poruku {$a}';
$string['cannotmovefromsingleforum'] = 'Nije moguće premjestiti diskusiju iz foruma tipa jedna obična diskusija';
$string['cannotmovenotvisible'] = 'Forum nije vidljiv';
$string['cannotmovetonotexist'] = 'Ne možete da premjestite u taj forum jer on ne postoji!';
$string['cannotmovetonotfound'] = 'Ciljni forum nije pronađen na ovom kursu.';
$string['cannotmovetosingleforum'] = 'Nije moguće premjestiti diskusiju u forum tipa jedna obična diskusija';
$string['cannotpurgecachedrss'] = 'Nije bilo moguće očistiti RSS servise iz cached  za izvorni i/ili odredišni(e) forum(e) - provjerite Vašu datoteku za dozvole foruma';
$string['cannotremovesubscriber'] = 'Nije bilo moguće ukloniti pretplatnika sa ID brojem {$a} sa ovog foruma!';
$string['cannotreply'] = 'Ne možete da odgovorite na ovu poruku';
$string['cannotsplit'] = 'Diskusije sa ovog foruma ne mogu biti razdvojene';
$string['cannotsubscribe'] = 'Žao nam je, ali morate biti član grupe da biste se prijavili';
$string['cannottrack'] = 'Nije moguće prestati s praćenjem ovog foruma';
$string['cannotunsubscribe'] = 'Nije moguće odjaviti se sa ovog foruma';
$string['cannotupdatepost'] = 'Ne možete da ažurirate ovu poruku';
$string['cannotviewpostyet'] = 'Još uvijek ne možete da čitate pitanja drugih studenata u ovoj diskusiji jer niste poslali nijednu poruku';
$string['cannotviewusersposts'] = 'Ne postoje poruke ovog korisnika koje možete da vidite.';
$string['cleanreadtime'] = 'Vrijeme kada se stare poruke obilježavaju kao pročitane';
$string['completiondiscussions'] = 'Korisnik mora da kreira diskusiju:';
$string['completiondiscussionsgroup'] = 'Zahtijevaj diskusije';
$string['completiondiscussionshelp'] = 'neophodno je kreiranje diskusije za završetak aktivnosti';
$string['completionposts'] = 'Student mora da pošalje poruku ili odgovor:';
$string['completionpostsgroup'] = 'Obavezno slanje poruke';
$string['completionpostshelp'] = 'neophodno je slanje poruke ili odgovora za završetak aktivnosti';
$string['completionreplies'] = 'Student mora da pošalje odgovor:';
$string['completionrepliesgroup'] = 'Neophodan je odgovor na poruku';
$string['completionreplieshelp'] = 'neophodan je odgovor na poruku za završetak aktivnosti';
$string['configcleanreadtime'] = 'Vrijeme u toku dana kada se brišu stare poruke iz tabele "pročitano".';
$string['configdigestmailtime'] = 'Korisnici koji izaberu da im se poruke sa foruma šalju e-mailom u skraćenom obliku, dobijaće jednu poruku dnevno. Ovo podešavanje zadaje vrijeme u toku dana kada će navedena poruka biti poslana (prvi sljedeći kron koji se pokrene nakon zadanog vremena će ih poslati).';
$string['configdisplaymode'] = 'Zadani način prikazivanja stranice sa diskusijama ukoliko isti nije podešen.';
$string['configenablerssfeeds'] = 'Ovaj prekidač će omogućiti korištenja RSS servisa za sve forume. Ipak, potrebno je da ručno uključite RSS podršku u podešavanjima za svaki forum posebno.';
$string['configenabletimedposts'] = 'Izaberite "da" ako želite da dozvolite podešavanje perioda prikazivanja poruke prilikom otvaranja nove diskusije na forumu (Eksperimentalno, budući da još uvijek nije potpuno testirano).';
$string['configlongpost'] = 'Bilo koja poruka duža od ove vrijednosti (izražene u karakterima, ne računajući HTML oznake) smatra se predugom. Poruke prikazane na početnoj stranici, stranicama kurseva u društvenom formatu, ili korisničkim profilima se skraćuju na prirodnu dužinu koja se kreće između vrijednosti za forum_shortpost i forum_longpost .';
$string['configmanydiscussions'] = 'Maksimalan broj diskusija prikazanih na forumu po stranici';
$string['configmaxattachments'] = 'Zadani maksimalni broj priloga dozvoljen po jednoj poruci.';
$string['configmaxbytes'] = 'Zadana maksimalna veličina priloga za sve forume na stranici (zavisno od ograničenja kurseva i ostalih lokalnih podešavanja)';
$string['configoldpostdays'] = 'Broj dana nakon kojeg se sve stare poruke smatraju pročitanim.';
$string['configreplytouser'] = 'Kada se poruka sa foruma šalje e-mail porukom, hoće li ona sadržavati e-mail adresu autora poruke, tako da primaoc poruke može na nju da odgovori lično a ne preko foruma? Čak i kada je ova opcija podešena na "Da", korisnici mogu da, u okviru svog korisničkog profila, odaberu da njihova e-mail adresa bude sakrivena od ostalih korisnika.';
$string['configshortpost'] = 'Svaka poruka kraća od ove dužine (ne uključujući HTML oznake) se smatra kratkom (vidi ispod).';
$string['configtrackingtype'] = 'Zadane postavke za praćenje čitanja poruka';
$string['configtrackreadposts'] = 'Podesite na "Da" ako želite da pratite pročitane/nepročitane poruke za svakog korisnika.';
$string['configusermarksread'] = 'Ako je izabrana opcija "Da" korisnik mora ručno da obilježi poruku kao pročitanu, u suprotnom (opcija "Ne") onog trenutka kada je korisnik vidio poruku ona će biti obilježena kao pročitana.';
$string['confirmsubscribe'] = 'Da li zaista želite da se prijavite na forum \'{$a}\'?';
$string['confirmunsubscribe'] = 'Da li zaista želite da se odjavite sa foruma \'{$a}\'?';
$string['couldnotadd'] = 'Žao nam je, nije moguće dodati Vašu poruku zbog nepoznate greške';
$string['couldnotdeletereplies'] = 'Žao nam je, ova poruka se ne može izbrisati jer su drugi korisnici odgovorili na nju';
$string['couldnotupdate'] = 'Vaša poruka ne može biti ažurirana zbog nepoznate greške';
$string['delete'] = 'Izbriši';
$string['deleteddiscussion'] = 'Ova tema je izbrisana';
$string['deletedpost'] = 'Poruka je izbrisana';
$string['deletedposts'] = 'Te poruke su izbrisane';
$string['deletesure'] = 'Jeste li sigurni da želite izbrisati ovu poruku?';
$string['deletesureplural'] = 'Jeste li sigurni da želite da izbrišete ovu poruku i SVE odgovore na nju? ({$a} poruka)';
$string['digestmailheader'] = 'Ovo je Vaš dnevni skraćeni prikaz novih poruka sa {$a->sitename} foruma. Da bi promijenili postavke forumske e-mail adrese idite na {$a->userprefs}.';
$string['digestmailpost'] = 'Promijenite preference skraćenog prikaza foruma';
$string['digestmailprefs'] = 'Vaš korisnički profil';
$string['digestmailsubject'] = '{$a}: skraćen prikaz poruka sa foruma';
$string['digestmailtime'] = 'Vrijeme za slanje e-mail poruka sa skraćenim izvještajima';
$string['digestsentusers'] = 'Skraćen prikaz poruka sa foruma uspješno je poslan na e-mail adrese {$a} korisnika';
$string['disallowsubscribe'] = 'Učlanjivanje nije dozvoljeno';
$string['disallowsubscribeteacher'] = 'Učlanjivanje nije dozvoljeno (osim predavačima)';
$string['discussion'] = 'Diskusija';
$string['discussionmoved'] = 'Ova diskusija je premještena na \'{$a}\'.';
$string['discussionmovedpost'] = 'Ova diskusija je premještena <a href="{$a->discusshref}">ovdje</a> u forumu <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Naziv diskusije';
$string['discussions'] = 'Diskusije';
$string['discussionsstartedby'] = 'Diskusiju započeo/la {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusije koje je korisnik {$a} započeo u skorije vreme';
$string['discussionsstartedbyuserincourse'] = 'Diskusije koje je započeo/la {$a->fullname} na kursu {$a->coursename}';
$string['discussthistopic'] = 'Diskutujte ovu temu';
$string['displayend'] = 'Kraj prikazivanja';
$string['displayend_help'] = 'Ovo podešavanje određuje da li će poruka na forumu biti sakrivena nakon određenog datuma. Napomena: administratori uvijek mogu da vide poruke na forumu.';
$string['displaymode'] = 'Način prikazivanja';
$string['displayperiod'] = 'Period prikazivanja';
$string['displaystart'] = 'Početak prikazivanja';
$string['displaystart_help'] = 'Ovo podešavanje određuje da li će poruka na forumu biti prikazana od određenog datuma. Napomena: administratori uvijek mogu da vide poruke na forumu.';
$string['displaywordcount'] = 'Prikaži broj riječi';
$string['displaywordcount_help'] = 'Ova postavka naznačuje da li će broj riječi svake poruke biti prikazan ili ne.';
$string['eachuserforum'] = 'Svaka osoba može započeti jednu diskusiju';
$string['edit'] = 'Uredi';
$string['editedby'] = 'Uredio/la {$a->name} - izvorno objavljeno {$a->date}';
$string['editedpostupdated'] = 'Poruka koju je postovao/la {$a} je ažurirana';
$string['editing'] = 'Uređivanje';
$string['emaildigest_0'] = 'Primiti ćete jedan e-mail po forumskoj poruci.';
$string['emaildigest_1'] = 'Dnevno ćete primiti jedan e-mail sa kratkim prikazom koji sadrži kompletan sadržaj svake forumske poruke';
$string['emaildigest_2'] = 'Dnevno ćete primiti jedan e-mail sa kratkim prikazom koji sadrži temu svake forumske poruke';
$string['emaildigestcompleteshort'] = 'Kompletne poruke';
$string['emaildigestdefault'] = 'Default ({$a})';
$string['emaildigestoffshort'] = 'Bez kratkog prikaza';
$string['emaildigestsubjectsshort'] = 'Samo tema';
$string['emaildigesttype'] = 'Opcije za kratki prikaz putem e-maila';
$string['emaildigesttype_help'] = 'Tip obavještenja koji će te primiti za svaki forum. * Zadano - prati postavke kratkog prikaza pronađenog u profilu korisnika. Ako ažurirate Vaš profil, onda će ta promjena biti primijenjena i ovdje; * Bez kratkog prikaza - primiti ćete samo jedan mail po forumskoj poruci; * Kratki prikaz - kompletne poruke - primiti ćete jedan kratki prikaz putem maila na dnevnoj bazi, koji sadrži kompletan sadržaj svake forumske poruke; * Kratki prikaz - samo teme - primiti ćete jedan kratki prikaz putem e-maila na dnevnoj bazi, koji sadrži samo temu svakog forumskog posta.';
$string['emaildigestupdated'] = 'Opcija kratki prikaz e-mailom je promijenjena u \'{$a->maildigesttitle}\' za forum \'{$a->forum}\'. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Vaše zadane postavke profila za \'{$a->maildigesttitle}\' je korišteno za forum \'{$a->forum}\'. {$a->maildigestdescription}.';
$string['emptymessage'] = 'Nešto nije u redu sa Vašom porukom. Možda ste ostavili prazna polja, ili je prilog bio prevelik. Vaše promjene NISU sačuvane.';
$string['erroremptymessage'] = 'Tijelo poruke ne može biti prazno';
$string['erroremptysubject'] = 'Tema (naslov) poruke ne može biti prazna';
$string['errorenrolmentrequired'] = 'Da biste pristupili ovom sadržaju morate biti upisani na ovaj kurs';
$string['errorwhiledelete'] = 'Došlo je do greške u toku brisanja zapisa';
$string['event_assessable_uploaded'] = 'Neki sadržaj je postavljen.';
$string['everyonecanchoose'] = 'Svi mogu odabrati žele li biti učlanjeni na ovaj forum';
$string['everyonecannowchoose'] = 'Svako može sada izabrati da li će biti učlanjen na ovaj forum';
$string['everyoneisnowsubscribed'] = 'Svi su sada učlanjeni na ovaj forum';
$string['everyoneissubscribed'] = 'Svi su učlanjeni na ovaj forum';
$string['existingsubscribers'] = 'Trenutni članovi';
$string['exportdiscussion'] = 'Prenesi cijelu diskusiju';
$string['forcedreadtracking'] = 'Dozvoli prisilno (obavezno) praćenje čitanja';
$string['forcedreadtracking_desc'] = 'Dozvoli forumima da budu postavljeni na prisilno (obavezno) praćenje čitanja. Rezultirati će u smanjenim performansama za neke korisnike, specijalno na onim kursevima sa mnogo foruma i poruka. Kada je ugašeno, bilo koji forum prethodno postavljen na Forced (prisilno) će se tretirati kao izborno.';
$string['forcessubscribe'] = 'Učlanjivanje na ovaj forum je obavezno za sve.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Dodaj novi forum';
$string['forum:addnews'] = 'Dodaj vijest';
$string['forum:addquestion'] = 'Dodaj pitanje';
$string['forum:allowforcesubscribe'] = 'Dozvoli obavezno učlanjenje';
$string['forumauthorhidden'] = 'Autor (skriveno)';
$string['forumblockingalmosttoomanyposts'] = 'Približavate se maksimalnom mogućem broju poruka na ovom forumu. Objavili ste {$a->numposts} poruka u posljednjih {$a->blockperiod} a limit je {$a->blockafter} poruka.';
$string['forumbodyhidden'] = 'Ne možete vidjeti ovu poruku, vjerovatno zbog toga što još niste učestvovali u ovoj diskusiji ili zbog toga što još nije isteklo maksimalno dozvoljeno vrijeme za uređivanje.';
$string['forum:createattachment'] = 'Kreiraj priloge';
$string['forum:deleteanypost'] = 'Obriši sve poruke (u bilo koje vrijeme)';
$string['forum:deleteownpost'] = 'Obriši svoje poruke (u zadanom roku)';
$string['forum:editanypost'] = 'Uredi bilo koju poruku';
$string['forum:exportdiscussion'] = 'Prenesi kompletnu diskusiju';
$string['forum:exportownpost'] = 'Prenesi svoju poruku';
$string['forum:exportpost'] = 'Prenesi poruku';
$string['forumintro'] = 'Uvod u forum';
$string['forum:managesubscriptions'] = 'Upravljanje članstvima';
$string['forum:movediscussions'] = 'Premjesti diskusije';
$string['forumname'] = 'Naziv foruma';
$string['forumposts'] = 'Poruke na forumu';
$string['forum:postwithoutthrottling'] = 'Izuzet od ograničenja broja poruka';
$string['forum:rate'] = 'Ocijeni poruke';
$string['forum:replynews'] = 'Odgovori na vijesti';
$string['forum:replypost'] = 'Odgovori na poruke';
$string['forums'] = 'Forumi';
$string['forum:splitdiscussions'] = 'Podijeli diskusije';
$string['forum:startdiscussion'] = 'Započni nove diskusije';
$string['forumsubjecthidden'] = 'Tema (skriveno)';
$string['forumtracked'] = 'Nepročitane poruke se prate';
$string['forumtrackednot'] = 'Nepročitane poruke se ne prate';
$string['forumtype'] = 'Tip foruma';
$string['forumtype_help'] = 'Postoji 5 tipova foruma: * Jedna obična diskusija - forum u obliku samo jedne teme o kojoj svi mogu diskutovati i slati svoje odgovore * Svaki učesnik pokreće jednu diskusiju - svaki student može pokrenuti samo jednu novu temu za diskusiju, na koju svi mogu da odgovaraju * Forum pitanja i odgovora - studenti moraju prvo da pošalju svoj odgovor prije nego što vide odgovore drugih * Standarni forum u obliku bloga - otvoreni forum u kom svako u bilo kom trenutku može započeti novu diskusiju, i u kom su teme za diskusiju prikazane na jednoj stranici sa linkom "Diskutiraj o ovoj temi" * Standardni forum za opštu upotrebu - otvoreni forum u kom svako može započeti novu diskusiju u bilo kom trenutku';
$string['forum:viewallratings'] = 'Pregledaj sve neobrađene ocjene koje su dali pojedinci';
$string['forum:viewanyrating'] = 'Pregledaj sve ocjene koje je dobio bilo ko';
$string['forum:viewdiscussion'] = 'Pregled diskusija';
$string['forum:viewhiddentimedposts'] = 'Pregledaj skrivene, vremenski ograničene poruke';
$string['forum:viewqandawithoutposting'] = 'Uvijek vidi poruke na forumu Pitanja i odgovori';
$string['forum:viewrating'] = 'Pregledajte sve ocjene koje ste dobili';
$string['forum:viewsubscribers'] = 'Pregled članova';
$string['generalforum'] = 'Standardni forum za opštu upotrebu';
$string['generalforums'] = 'Opšti forumi';
$string['hiddenforumpost'] = 'Sakrivena forum poruka';
$string['inforum'] = 'u {$a}';
$string['introblog'] = 'Poruke u ovom forumu su automatski ovdje kopirane iz bloga korisnika na ovom kursu zato što ti članci bloga nisu više dostupni';
$string['intronews'] = 'Opšte novosti i najave';
$string['introsocial'] = 'Otvoreni forum za razgovor o bilo kojoj temi';
$string['introteacher'] = 'Forum rezervisan za bilješke i diskusije predavača';
$string['invalidaccess'] = 'Ovoj stranici nije ispravno pristupljeno';
$string['invaliddigestsetting'] = 'Neispravno podešene postavke kratkog prikaza putem maila';
$string['invaliddiscussionid'] = 'ID broj diskusije nije bio ispravan ili više ne postoji';
$string['invalidforcesubscribe'] = 'Neispravan način obaveznog učlanjenja';
$string['invalidforumid'] = 'ID broj foruma nije bio tačan';
$string['invalidparentpostid'] = 'ID broj nadređene poruke je neispravan';
$string['invalidpostid'] = 'Neispravan ID broj poruke - {$a}';
$string['lastpost'] = 'Posljednja poruka';
$string['learningforums'] = 'Forumi za učenje';
$string['longpost'] = 'Duga poruka';
$string['mailnow'] = 'Pošalji odmah e-mail porukom';
$string['manydiscussions'] = 'Broj diskusija po stranici';
$string['markalldread'] = 'Označi sve poruke ove diskusije kao pročitane.';
$string['markallread'] = 'Označi sve poruke na ovom forumu kao pročitane.';
$string['markread'] = 'Označi kao pročitano';
$string['markreadbutton'] = 'Označi kao<br /> pročitano';
$string['markunread'] = 'Označi kao nepročitano';
$string['markunreadbutton'] = 'Označi kao<br /> nepročitano';
$string['maxattachments'] = 'Maksimalan broj priloga';
$string['maxattachments_help'] = 'Ovo podešavanje određuje maksimalan broj datoteka koje mogu biti priložene uz poruku.';
$string['maxattachmentsize'] = 'Maksimalna veličina priloga';
$string['maxattachmentsize_help'] = 'Ovo podešavanje određuje maksimalnu veličinu datoteke koja može biti priložena uz poruku.';
$string['maxtimehaspassed'] = 'Žao nam je, maksimalno vrijeme za uređivanje ove poruke ({$a}) je isteklo!';
$string['message'] = 'Poruka';
$string['messageprovider:digests'] = 'Izvodi poruka sa foruma na koje ste učlanjeni';
$string['messageprovider:posts'] = 'Poruke sa foruma na koje ste učlanjeni';
$string['missingsearchterms'] = 'Sljedeći traženi termini se javljaju isključivo unutar HTML oznaka ove poruke:';
$string['modeflatnewestfirst'] = 'Prikaz odgovora, počevši prvo s najnovijim';
$string['modeflatoldestfirst'] = 'Prikaz odgovora, počevši prvo s najstarijim';
$string['modenested'] = 'Prikaz odgovora u ugniježđenoj formi';
$string['modethreaded'] = 'Prikaz odgovora u nizu';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Modul aktivnosti \'Forum\' omogućava učesnicima da vode asinhrone diskusije tj. da diskutuju na različite teme u dužem vremenskom periodu. Postoji nekoliko tipova foruma koji se mogu izabrati, kao što su standardni forum gdje svako može da započne novu diskusiju u bilo kom trenutku; forum gdje svaki student može da pokrene samo jednu diskusiju, ili forum Pitanje i odgovor gdje studenti moraju prvo da postave svoj odgovor prije nego što budu u mogućnosti da vide odgovore drugih studenata. Predavač može da dozvoli studentima da uz svoje poruke dostavljaju datoteke u prilogu. Priložene slike se prikazuju unutar same poruke. Učesnici mogu da se prijave (učlane) na forum kako bi redovno primali obavještenja o novim porukama. Predavač može da podesi režim prijave na opcioni, obavezni ili automatski, ili da potpuno spriječi mogućnost prijave na forum. Ako je potrebno, moguće je, također, spriječiti da studenti šalju više od određenog broja poruka, u datom vremenskom periodu; na ovaj način može se spriječiti da pojedinci dominiraju diskusijama. Poruke na forumima mogu biti ocjenjivane kako od strane predavača, tako i od strane studenata (vršnjačka evaluacija). Ocjene mogu da se sabiraju kako bi se formirala finalna ocjena koja se bilježi u knjigu ocjena. Forumi mogu da se koriste na različite načine, kao npr: * društveni prostor za međusobno upoznavanje i druženje studenata * za objavljivanje važnih obavještenja na kursu (koristeći forum "Vijesti i obavještenja" na koji su, standardno, svi studenti učlanjeni) * za diskutovanje o sadržaju odnosno temama koje kurs pokriva * za nastavak diskusije u online okruženju, o temama koje su prethodno započete u učionici * za diskusije namijenjene samo predavačima (koristeći opciju za sakrivanje foruma od studenata) - kao centar za pomoć, gdje studenti mogu da dobiju pomoć i savjet od strane predavača i iskusnijih studenata * za dodatne aktivnosti, na primjer "mozgalice" za studente o kojima oni treba da razmisle i ponude rješenja';
$string['modulenameplural'] = 'Forumi';
$string['more'] = 'još';
$string['movedmarker'] = '(Premješteno)';
$string['movethisdiscussionto'] = 'Premjesti ovu diskusiju u ...';
$string['mustprovidediscussionorpost'] = 'Morate navesti ID broj diskusije ili poruke da biste ih prenijeli';
$string['namenews'] = 'Forum vijesti i obavještenja';
$string['namenews_help'] = '<p>Forum vijesti i obavještenja je specijalni forum za najave i najnovije informacije koji se automatski kreira kada se otvara novi kurs. Kurs može imati samo jedan ovakav forum.</p> <p>Blok "Najnovije vijesti" će prikazivati najnovije diskusije sa ovog foruma (čak i ako mu promijenite ime).</p>';
$string['namesocial'] = 'Društveni forum';
$string['nameteacher'] = 'Forum predavača';
$string['newforumposts'] = 'Nove poruke na forumu';
$string['noattachments'] = 'Ova poruka nema priloga';
$string['nodiscussions'] = 'Još nema tema za diskusiju na ovom forumu';
$string['nodiscussionsstartedby'] = '{$a} nije započeo/la nijednu diskusiju';
$string['nodiscussionsstartedbyyou'] = 'Još niste započeli nijednu diksusiju';
$string['noguestpost'] = 'Žao nam je, gostima nije dozvoljeno slanje poruka.';
$string['noguesttracking'] = 'Žao nam je, gostima nije dozvoljeno da podešavaju opcije za praćenje poruka.';
$string['nomorepostscontaining'] = 'Nema više poruka koje sadrže \'{$a}';
$string['nonews'] = 'Trenutno nema novosti';
$string['noonecansubscribenow'] = 'Prijave trenutno nisu moguće';
$string['nopermissiontosubscribe'] = 'Nemate dozvolu da vidite ko se prijavio na forum';
$string['nopermissiontoview'] = 'Nemate dozvolu da vidite ovu poruku';
$string['nopostforum'] = 'Žao nam je, ali nije Vam dozvoljeno slanje poruka na ovaj forum';
$string['noposts'] = 'Nema poruka';
$string['nopostsmadebyuser'] = '{$a} nije poslao/la nijednu poruku';
$string['nopostsmadebyyou'] = 'Niste napisali nijednu poruku';
$string['noquestions'] = 'Još nema pitanja na ovom forumu';
$string['nosubscribers'] = 'Trenutno nema prijavljenih korisnika na ovom forumu';
$string['notexists'] = 'Diskusija više ne postoji';
$string['nothingnew'] = 'Ništa novo za {$a}';
$string['notingroup'] = 'Žao nam je, morate biti dio grupe da biste vidjeli ovaj forum.';
$string['notinstalled'] = 'Modul Forum nije instaliran';
$string['notpartofdiscussion'] = 'Ova poruka nije dio diskusije!';
$string['notrackforum'] = 'Ne prati nepročitane poruke';
$string['noviewdiscussionspermission'] = 'Nemate dozvolu da vidite diskusije na ovom forumu';
$string['nowallsubscribed'] = 'Prijavljeni ste na sve forume u {$a}.';
$string['nowallunsubscribed'] = 'Odjavljeni ste sa svih foruma u {$a}.';
$string['nownotsubscribed'] = '{$a->name} NEĆE biti obavještavan o novim porukama na forumu \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} više ne prati poruke na forumu \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} će biti obavještavan/a o novim porukama na forumu \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} prati poruke na forumu \'{$a->forum}\'.';
$string['numposts'] = 'Broj poruka: {$a}';
$string['olderdiscussions'] = 'Starije diskusije';
$string['oldertopics'] = 'Starije teme';
$string['oldpostdays'] = 'Broj dana nakon kojih se stare poruke smatraju pročitanim';
$string['openmode0'] = 'Nema diskusija, nema odgovora';
$string['openmode1'] = 'Nema diskusija, ali odgovori su dozvoljeni';
$string['openmode2'] = 'Diskusije i odgovori su dozvoljeni';
$string['overviewnumpostssince'] = '{$a} poruka/e od posljednje prijave na sistem';
$string['overviewnumunread'] = 'ukupno nepročitanih: {$a}';
$string['page-mod-forum-discuss'] = 'Stranica sa diskusijom modula \'Forum';
$string['page-mod-forum-view'] = 'Glavna stranica foruma';
$string['page-mod-forum-x'] = 'Bilo koja stranica foruma';
$string['parent'] = 'Prikaži nadređenu poruku';
$string['parentofthispost'] = 'Poruka nadređena ovoj poruci';
$string['pluginadministration'] = 'Administracija foruma';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Vaša poruka je uspješno dodana.</p> <p>Imate {$a} za promjenu sadržaja iste, ukoliko to želite.</p>';
$string['postaddedsuccess'] = 'Vaša poruka je uspješno dodana.';
$string['postaddedtimeleft'] = 'Imate {$a} minuta da uredite poruku ukoliko želite da napravite bilo kakve izmjene.';
$string['postbyuser'] = '{$a->post} od {$a->user}';
$string['postincontext'] = 'Pogledaj poruku u kontekstu';
$string['postmailinfo'] = 'Ovo je kopija poruke sa foruma na Web sajtu {$a}. Da biste odgovorili na poruku kliknite na ovaj link:';
$string['postmailnow'] = '<p>Ova poruka će biti odmah poslana svima koji su prijavljeni na ovaj forum.</p>';
$string['postrating1'] = 'Uglavnom odvojeno znanje';
$string['postrating2'] = 'Odvojeno i povezano';
$string['postrating3'] = 'Uglavnom povezano znanje';
$string['posts'] = 'Poruke';
$string['postsmadebyuser'] = 'Poruka koju je poslao/la {$a}';
$string['postsmadebyuserincourse'] = 'Poruka koju je poslao/la {$a->fullname} na kursu {$a->coursename}';
$string['posttoforum'] = 'Pošalji poruku na forum';
$string['postupdated'] = 'Vaša poruka je ažurirana';
$string['potentialsubscribers'] = 'Potencijalni članovi';
$string['processingdigest'] = 'Slanje izvoda putem e-maila korisniku {$a}';
$string['processingpost'] = 'Obrađuje se poruka {$a}';
$string['prune'] = 'Razdvoji';
$string['prunedpost'] = 'Od ove poruke kreirana je nova diskusija';
$string['pruneheading'] = 'Razdvoji diskusiju i premjesti ovu poruku u novu diskusiju';
$string['qandaforum'] = 'Forum pitanja i odgovora';
$string['qandanotify'] = 'Ovo je forum pitanja i odgovora. Da biste vidjeli odgovore drugih na ova pitanja, morate prvo poslati svoj odgovor';
$string['re'] = 'Odgovor:';
$string['readtherest'] = 'Pročitajte ostatak ove teme';
$string['replies'] = 'Odgovori';
$string['repliesmany'] = '{$a} odgovora do sada';
$string['repliesone'] = '{$a} odgovor do sada';
$string['reply'] = 'Odgovori';
$string['replyforum'] = 'Odgovori na forumu';
$string['replytouser'] = 'Koristi e-mail adresu u odgovoru';
$string['resetdigests'] = 'Izbrišite sve preference izvoda po korisniku';
$string['resetforums'] = 'Izbriši poruke sa';
$string['resetforumsall'] = 'Izbriši sve poruke';
$string['resetsubscriptions'] = 'Izbriši sve prijave na forum';
$string['resettrackprefs'] = 'Izbriši sva podešavanja za praćenje foruma';
$string['rssarticles'] = 'Broj nedavnih RSS članaka';
$string['rssarticles_help'] = 'Ovo podešavanje određuje broj članaka (diskusija ili poruka) koji će biti uključeni u RSS izvor vijesti. Za većinu foruma je prihvatljivo da to bude između 5 i 20 članaka.';
$string['rsssubscriberssdiscussions'] = 'RSS izvor diskusija';
$string['rsssubscriberssposts'] = 'RSS izvor poruka';
$string['rsstype'] = 'RSS izvor za ovu aktivnost';
$string['rsstype_help'] = 'Da biste uključili RSS izvor vijesti za ovu aktivnost odaberite diskusije ili poruke koje će biti uključen u ovaj izvor.';
$string['search'] = 'Pretraživanje';
$string['searchdatefrom'] = 'Poruke moraju biti novije od';
$string['searchdateto'] = 'Poruke moraju biti starije od';
$string['searchforumintro'] = 'Molimo da unesete termine pretraživanja u jedno ili više sljedećih polja:';
$string['searchforums'] = 'Pretraži forume';
$string['searchfullwords'] = 'Ove riječi treba da se pojave kao cijele riječi';
$string['searchnotwords'] = 'Ove riječi NE treba da budu uključene';
$string['searcholderposts'] = 'Pretraži starije poruke...';
$string['searchphrase'] = 'Ova konkretna fraza se mora naći u poruci';
$string['searchresults'] = 'Rezultati pretraživanja';
$string['searchsubject'] = 'Ove riječi treba da budu u temi poruke';
$string['searchuser'] = 'Ovo ime treba da odgovara imenu autora poruke';
$string['searchuserid'] = 'Moodle ID broj autora poruke';
$string['searchwhichforums'] = 'Izaberite koje forume treba pretražiti';
$string['searchwords'] = 'Ove riječi se mogu pojaviti bilo gdje u poruci';
$string['seeallposts'] = 'Pregledaj sve poruke ovog korisnika';
$string['shortpost'] = 'Kratka poruka';
$string['showsubscribers'] = 'Prikaži/promijeni popis trenutnih članova';
$string['singleforum'] = 'Jedna obična diskusija';
$string['smallmessage'] = '{$a->user} je poslao poruku na {$a->forumname}';
$string['startedby'] = 'Započeo/la';
$string['subject'] = 'Tema';
$string['subscribe'] = 'Učlanite se u ovaj forum';
$string['subscribeall'] = 'Prijavi sve korisnike na ovaj forum';
$string['subscribed'] = 'Učlanjeni';
$string['subscribeenrolledonly'] = 'Žao nam je, samo korisnici upisani na neki od kurseva imaju dozvolu da se prijave da primaju poruke sa foruma e-mail porukama.';
$string['subscribenone'] = 'Odjavi sve korisnike sa ovog foruma';
$string['subscribers'] = 'Članovi';
$string['subscribersto'] = 'Članovi na \'{$a}';
$string['subscribestart'] = 'Pošaljite mi kopije poruka sa ovog foruma putem e-maila';
$string['subscribestop'] = 'Ne želim da primam kopije poruka sa ovog foruma putem e-maila';
$string['subscription'] = 'Prijava';
$string['subscriptionandtracking'] = 'Prijava i praćenje';
$string['subscriptionauto'] = 'Automatska prijava';
$string['subscriptiondisabled'] = 'Prijava je onemogućena';
$string['subscriptionforced'] = 'Obavezna prijava';
$string['subscription_help'] = 'Kada ste prijavljeni na neki forum to znači da ćete primati kopije poruka sa foruma putem e-maila. Najčešće ćete moći da odaberete da li želite da budete prijavljeni na određeni forum. Međutim, ponekad predavač može podesiti da prijava bude obavezna. U tom slučaju svi korisnici će primati kopije poruka sa foruma putem e-maila.';
$string['subscriptionmode'] = 'Način prijave';
$string['subscriptionmode_help'] = '<p>Kada je korisnik prijavljen na forum, to znači da će primati kopije poruka sa foruma putem e-mail poruka</p> <p>Postoje 4 moguća načina za prijavu:</p> <p>Opciona prijava - korisnici mogu da odaberu da li žele da budu prijavljeni na forum ili ne</p> <p>Obavezna prijava - svi korisnici su prijavljeni i ne mogu se odjaviti</p> <p>Automatska prijava - svi korisnici su inicijalno prijavljeni ali, ukoliko žele, mogu da odaberu da se odjave u bilo kom trenutku</p> <p>Prijava onemogućena - prijava na forum nije dozvoljena</p>';
$string['subscriptionoptional'] = 'Opciona prijava';
$string['subscriptions'] = 'Prijave';
$string['thisforumisthrottled'] = 'Ovaj forum ima ograničenje u broju poruka koje možete poslati u datom vremenskom periodu - trenutno je ovo ograničenje podešeno na {$a->blockafter} poruka unutar {$a->blockperiod}';
$string['timedposts'] = 'Vremenski određeni postovi';
$string['timestartenderror'] = 'Kraj prikaza ne može biti podešen na datum raniji od početka prikaza';
$string['trackforum'] = 'Prati nepročitane poruke';
$string['tracking'] = 'Prati';
$string['trackingoff'] = 'Isključeno';
$string['trackingon'] = 'Uključeno';
$string['trackingoptional'] = 'Opciono';
$string['trackingtype'] = 'Aktivirati praćenje pročitanih/nepročitanih poruka na ovom forumu?';
$string['trackingtype_help'] = '<p>Ako je ovo podešavanje omogućeno korisnici mogu da prate pročitane/nepročitane poruke na forumu i unutar diskusija.</p> <p>Postoje tri mogućnosti</p> <ul> <li>Opciono: korisnici mogu da odaberu da li će uključiti ili isključiti praćenje pročitanih/nepročitanih poruka</li> <li>Uključeno: praćenje je uvijek uključeno</li> <li>Isključeno: praćenje je uvijek isključeno</li> </ul>';
$string['unread'] = 'Nepročitano';
$string['unreadposts'] = 'Nepročitane poruke';
$string['unreadpostsnumber'] = 'Broj nepročitanih poruka: {$a}';
$string['unreadpostsone'] = '1 nepročitana poruka';
$string['unsubscribe'] = 'Odjavite se sa ovog foruma';
$string['unsubscribeall'] = 'Odjavite se sa svih foruma';
$string['unsubscribeallconfirm'] = 'Trenutno ste prijavljeni na {$a} forum(a). Da li zaista želite da se odjavite sa svih foruma i da isključite automatsku prijavu na forume?';
$string['unsubscribealldone'] = 'Sve opcione prijave na forume su poništene. Još uvijek ćete primati obavještenja sa foruma na kojima je prijava obavezna. Da biste detaljnije podesili opcije vezane za poruke koje ćete primati odaberite opciju Poruke u podešavanjima Korisničkog rofila.';
$string['unsubscribeallempty'] = 'Niste prijavljeni ni na jedan forum. Ako ne želite više da dobijate e-mail poruke sa ovog servera odaberite opciju Poruke u podešavanjima Korisničkog profila.';
$string['unsubscribed'] = 'Odjavljeni ste sa ovog foruma';
$string['unsubscribeshort'] = 'Odjavi se';
$string['usermarksread'] = 'Ručno obilježavanje pročitanih poruka';
$string['viewalldiscussions'] = 'Pogledaj sve diskusije';
$string['warnafter'] = 'Granična vrijednost broja poruka za slanje upozorenja';
$string['warnafter_help'] = '<p>Studenti mogu biti upozoreni kada se približe maksimalnom broju poruka dozvoljenih u datom vremenskom periodu. Ovo podešavanje određuje nakon koliko poruka će biti upozoreni.</p> <p>Korisnici sa ovlaštenjem mod/forum:postwithoutthrottling su izuzeti od ovog ograničenja.</p>';
$string['warnformorepost'] = 'Upozorenje! Postoji više od jedne diskusije na ovom forumu - koristite najnoviju';
$string['yournewquestion'] = 'Vaše novo pitanje';
$string['yournewtopic'] = 'Vaša nova tema za diskusiju';
$string['yourreply'] = 'Vaš odgovor';
