<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Već ste prijavljeni kao {$a}. Potrebno je da se odjavite prije nego što se prijavite pod drugim korisničkim imenom.';
$string['authnotexisting'] = 'Dodatak za provjeru identiteta ne postoji';
$string['backupcontainexternal'] = 'Ova datoteka rezervne kopije sadrži vanjske Moodle mrežne servere koji nisu lokalno podešeni';
$string['backuptablefail'] = 'Tabele rezervne kopije nisu mogle biti uspješno podešene!';
$string['blockcannotconfig'] = 'Ovaj blok ne podržava globalnu konfiguraciju';
$string['blockcannotinistantiate'] = 'Problem prilikom kreiranja instance objekta bloka';
$string['blockcannotread'] = 'Nije bilo moguće pročitati podatke za blockid= {$a}';
$string['blockdoesnotexist'] = 'Ovaj blok ne postoji';
$string['blockdoesnotexistonpage'] = 'Ovaj blok (id={$a->instanceid}) ne postoji na ovoj stranici ({$a->url}).';
$string['blocknameconflict'] = 'Konflikt u nazivu: blok {$a->name} ima isti naslov kao i postojeći blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Funkcija "Povratni komentar" (Comment callback) je odbila ovaj komentar';
$string['cannotaddcoursemodule'] = 'Nije bilo moguće dodati novi kurs modul';
$string['cannotaddcoursemoduletosection'] = 'Nije bilo moguće dodati novi kurs modul u ovu sekciju';
$string['cannotaddmodule'] = '{$a} modul nije mogao biti dodan listu modula!';
$string['cannotaddnewmodule'] = 'Nije bilo moguće dodati novi modul {$a}';
$string['cannotaddrss'] = 'Nemate dozvolu da dodajete RSS izvore vijesti';
$string['cannotaddthisblocktype'] = 'Ne možete dodati blok {$a} na ovu stranicu.';
$string['cannotassignrole'] = 'Nije moguće dodijeliti ulogu u kursu';
$string['cannotassignrolehere'] = 'Nije Vam dozvoljeno da dodjeljujete ovu ulogu (id = {$a->roleid}) u ovom kontekstu ({$a->context})';
$string['cannotassignselfasparent'] = 'Nije moguće sebi dodijeliti nadređenu ulogu';
$string['cannotcallscript'] = 'Ne možete da pozovete ovu skriptu na taj način';
$string['cannotcallusgetselecteduser'] = 'Ne možete da pozovete user_selector::get_selected_user ukoliko je opcija multiselect uključena';
$string['cannotcreatebackupdir'] = 'Nije bilo moguće kreirati direktorij za rezervnu kopiju podataka. Administrator stranice mora da podesi pristup fajlovima.';
$string['cannotcreatecategory'] = 'Kategorija nije unesena';
$string['cannotcreatedboninstall'] = '<p>Nije moguće kreirati bazu podataka.</p> <p>Određena baza podataka ne postoji i dati korisnik nema dozvolu da kreira bazu podataka.</p> <p>Site administrator bi trebao verificirati postavke baze podataka.</p>';
$string['cannotcreategroup'] = 'Greška prilikom kreiranja grupe';
$string['cannotcreatelangbase'] = 'Greška: Nije bilo moguće kreirati osnovni direktorij jezika';
$string['cannotcreatelangdir'] = 'Nije moguće kreirati direktorij jezika';
$string['cannotcreateorfindstructs'] = 'Greška u pronalaženju ili kreiranju strukture sekcija za ovaj kurs';
$string['cannotcreatepopupwin'] = 'Nedefinisani element - nije moguće kreirati "pop-up" prozor';
$string['cannotcreatesitedir'] = 'Nije moguće kreirati direktorij stranice. Administrator stranice mora da podesi dopuštenja.';
$string['cannotcreatetempdir'] = 'Nije moguće kreirati privremeni direktorij';
$string['cannotcreateuploaddir'] = 'Nije moguće kreirati direktorij za postavljanje datoteka. Administrator stranice mora da podesi dopuštenja.';
$string['cannotcustomisefiltersblockuser'] = 'Ne možete prilagoditi podešavanja u kontekstu korisnika ili u kontekstu bloka';
$string['cannotdeletebackupids'] = 'Nije bilo moguće izbrisati broj oznake (id) prethodnih rezervnih kopija';
$string['cannotdeletecategorycourse'] = 'Nije uspjelo brisanje kursa \'{$a}';
$string['cannotdeletecategoryquestions'] = 'Nije bilo moguće izbrisati pitanja iz kategorije \'{$a}';
$string['cannotdeletecourse'] = 'Nemate dozvolu da obrišete ovaj kurs';
$string['cannotdeletecustomfield'] = 'Greška pri brisanju prilagođenog polja podataka';
$string['cannotdeletedir'] = 'Nije moguće izbrisati ({$a})';
$string['cannotdeletefile'] = 'Nije moguće izbrisati ovu datoteku';
$string['cannotdeleterole'] = 'Ne može biti izbrisano zbog {$a}';
$string['cannotdeleterolewithid'] = 'Nije moguće izbrisati ulogu sa ID {$a}';
$string['cannotdeletethisrole'] = 'Ne možete da obrišete ovu ulogu zato što je koristi sistem ili je to posljednja uloga sa administratorskim ovlaštenjima.';
$string['cannotdisableformat'] = 'Ne možete onemogućiti standardni format';
$string['cannotdownloadcomponents'] = 'Nije moguće preuzeti komponente';
$string['cannotdownloadlanguageupdatelist'] = 'Nije moguće preuzeti popis ažuriranih jezika sa download.moodle.org';
$string['cannotdownloadzipfile'] = 'Nije moguće preuzeti ZIP arhivu';
$string['cannoteditcomment'] = 'Ovaj komentar nije Vaš da bi mogli da ga uređujete!';
$string['cannoteditcommentexpired'] = 'Ne možete ovo da uređujete. Vrijeme je isteklo!';
$string['cannoteditpostorblog'] = 'Ne možete da postujete ili uređujete blogove';
$string['cannoteditsiteform'] = 'Ne možete urediti kurs sajta koristeći ovaj obrazac';
$string['cannotedityourprofile'] = 'Oprostite, ali ne možete da uređujete svoj profil';
$string['cannotexecduringupgrade'] = 'Nije moguće izvršiti za vrijeme nadogradnje';
$string['cannotfindcategory'] = 'Nije moguće pronaći zapis u bazi o kategoriji čiji je identifikator {$a}';
$string['cannotfindcomponent'] = 'Nije moguće pronaći komponentu.';
$string['cannotfindcontext'] = 'Nije moguće pronaći kontekst.';
$string['cannotfindcourse'] = 'Nije moguće pronaći kurs';
$string['cannotfinddocs'] = 'Nije moguće pronaći datoteke dokumentacije za "{$a}" jezik';
$string['cannotfindgradeitem'] = 'Nije moguće naći grade_item';
$string['cannotfindgroup'] = 'Nije moguće naći grupu';
$string['cannotfindhelp'] = 'Nije moguće pronaći datoteke pomoći za "{$a}" jezik.';
$string['cannotfindinfo'] = 'Nije moguće naći informacije za: "{$a}"';
$string['cannotfindlang'] = 'Nije moguće pronaći "{$a}" jezički paket!';
$string['cannotfindteacher'] = 'Nije moguće pronaći predavača';
$string['cannotfinduser'] = 'Nije moguće pronaći korisnika po imenu "{$a}"';
$string['cannotgeoplugin'] = 'Nije moguće uspostaviti vezu sa geoPlugin serverom na http://www.geoplugin.com. Molimo, provjerite podešavanja proksi servera ili , još bolje, instalirajte datoteku za MaxMind GeoLite City.';
$string['cannotgetblock'] = 'Nije moguće preuzeti blokove u bazi podataka';
$string['cannotgetcats'] = 'Nije moguće dobiti zapis kategorije';
$string['cannotgetdata'] = 'Nije moguće dobiti podatak';
$string['cannotgradeuser'] = 'Nije moguće ocijeniti ovog korisnika';
$string['cannothaveparentcate'] = 'Kategorija kursa ne može imati nadređenu kategoriju';
$string['cannotimport'] = 'Greška prilikom unosa';
$string['cannotimportformat'] = 'Oprostite, ali unos ovog formata još uvijek nije implementiran';
$string['cannotimportgrade'] = 'Greška u unosu ocjena';
$string['cannotinsertgrade'] = 'Nije moguće ubaciti stavku ocjene bez broja oznake (id) kursa!';
$string['cannotinsertrate'] = 'Nije bilo moguće ubaciti novo ocjenjivanje ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Nije moguć unos ID za novi zapis: {$a}';
$string['cannotmailconfirm'] = 'Greška u slanju e-mail poruke sa potvrdom o promjeni lozinke';
$string['cannotmanualctrack'] = 'Nije podržano ručno praćenje završetka ove aktivnosti';
$string['cannotmapfield'] = 'Otkrivena je kolizija prilikom mapiranja - dva polja mapiraju istu stavku ocjene {$a}';
$string['cannotmarktopic'] = 'Nije bilo moguće označiti tu temu za ovaj kurs';
$string['cannotmigratedatacomments'] = 'Nije moguće migrirati komentare modula podataka';
$string['cannotmodulename'] = 'Nije moguće dobiti naziv modula prilikom kreiranja navigacije';
$string['cannotmoduletype'] = 'Nije moguće dobiti tip modula prilikom kreiranja navigacije';
$string['cannotmovecategory'] = 'Nije moguće pomijeriti kategoriju';
$string['cannotmovecourses'] = 'Nije moguće pomijeriti kurs iz trenutne kategorije u drugu kategoriju';
$string['cannotmoverolewithid'] = 'Nije moguće premjestiti ulogu sa brojem {$a}';
$string['cannotopencsv'] = 'Nije moguće otvoritu CSV datoteku';
$string['cannotopenfile'] = 'Nije moguće otvoriti datoteku ({$a})';
$string['cannotopenforwrit'] = 'Nije moguće otvoriti za upisivanje: {$a}';
$string['cannotopentemplate'] = 'Nije moguće otvoriti datoteku šablona ({$a})';
$string['cannotopenzip'] = 'Nije moguće otvoriti zip arhivu. Vjerovatno je u pitanju greška sa zip ekstenzijom na 64-bitnom operativnom sistemu.';
$string['cannotoverridebaserole'] = 'Nije moguće mijenjati osnovne mogućnosti uloge';
$string['cannotoverriderolehere'] = 'Nije Vam dozvoljeno da mijenjate ovu ulogu (id = {$a->roleid}) u ovom kontekstu ({$a->context})';
$string['cannotreadfile'] = 'Nije moguće pročitati datoteku ({$a})';
$string['cannotreadtmpfile'] = 'Greška u čitanju privremene datoteke';
$string['cannotreaduploadfile'] = 'Nije bilo moguće pročitati postavljenu datoteku';
$string['cannotremovefrommeta'] = 'Nije bilo moguće ukloniti izabrani kurs iz ovog metakursa!';
$string['cannotresetguestpwd'] = 'Ne možete da resetujete lozinku gosta';
$string['cannotresetmail'] = 'Greška prilikom resetovanja lozinke i njenog slanja na Vašu e-mail adresu';
$string['cannotresetthisrole'] = 'Nije moguće resetovati ovu ulogu';
$string['cannotrestore'] = 'Pojavila se greška te proces restauracije ne može biti završen!';
$string['cannotrestoreadminorcreator'] = 'Morate biti kreator kursa ili administrator kako bi uradili restauraciju rezervne kopije u novi kurs';
$string['cannotrestoreadminoredit'] = 'Morate biti predavač ili administrator kako bi uradili restauraciju rezervne kopije u izabrani kurs';
$string['cannotsaveagreement'] = 'Nije bilo moguće sačuvati Vaš sporazum';
$string['cannotsaveblock'] = 'Greška prilikom pokušaja da se sačuva konfiguracija blokova';
$string['cannotsavecomment'] = 'Nije moguće sačuvati komentar';
$string['cannotsavedata'] = 'Nije moguće sačuvati podatke';
$string['cannotsavefile'] = 'Nije moguće sačuvati datoteku "{$a}"!';
$string['cannotsavemd5file'] = 'Nije moguće sačuvati md5 datoteku.';
$string['cannotsavezipfile'] = 'Nije moguće sačuvati ZIP arhivu.';
$string['cannotservefile'] = 'Nije moguće prikazati datoteku - problem u konfiguraciji servera';
$string['cannotsetparentforcatoritem'] = 'Nije moguće postaviti nadređenu kategoriju ili kurs';
$string['cannotsetpassword'] = 'Nije moguće podesiti korisničku lozinku!';
$string['cannotsetprefgrade'] = 'Nije moguće postaviti parametar aggregationview na {$a} za ovu kategoriju ocjena.';
$string['cannotsettheme'] = 'Nije moguće podesiti šemu izgleda';
$string['cannotsetupblock'] = 'Tabele blokova nije bilo moguće uspješno postaviti!';
$string['cannotsetupcapformod'] = 'Nije bilo moguće podesiti mogućnosti za {$a}';
$string['cannotsetupcapforplugin'] = 'Nije bilo moguće podesiti mogućnosti za {$a}';
$string['cannotshowhidecoursesincategory'] = 'Nije moguće prikazati/sakriti kurseve u kategoriji {$a}';
$string['cannotunassigncap'] = 'Nije moguće ukloniti zastarjelu mogućnost {$a->cap} iz uloge {$a->role}';
$string['cannotunassignrolefrom'] = 'Nije moguće ovom korisniku ukloniti broj uloge: {$}';
$string['cannotunzipfile'] = 'Nije moguće raspakovati ZIP datoteku.';
$string['cannotupdatemod'] = 'Nije bilo moguće ažurirati {$a}';
$string['cannotupdatepasswordonextauth'] = 'Ažuriranje lozinke na vanjskom sistemu za provjeru identiteta: {$a} nije uspjelo. Za više detalja pogledajte zapise na serveru.';
$string['cannotupdateprofile'] = 'Greška prilikom ažuriranja korisničkog zapisa';
$string['cannotupdaterecord'] = 'Nije moguće ažurirati zapis sa ID {$a}';
$string['cannotupdaterss'] = 'Nije moguće ažurirati RSS izvor vijesti';
$string['cannotupdatesubcourse'] = 'Nije moguće ažurirati podređeni kurs';
$string['cannotupdateusermsgpref'] = 'Nije moguće ažuriranje korisnikovih podešavanja privatnih poruka';
$string['cannotupdateuseronexauth'] = 'Ažuriranje korisničkih podataka na vanjskom sistemu za provjeru identiteta: {$a} nije uspjelo. Za više detalja pogledajte zapise na serveru.';
$string['cannotuploadfile'] = 'Greška u procesiranju postavljanja datoteke';
$string['cannotuseadmin'] = 'Morate da budete administrator da biste koristili ovu stranicu';
$string['cannotuseadminadminorteacher'] = 'Morate da budete predavač ili administrator da biste koristili ovu stranicu';
$string['cannotusepage'] = 'Samo predavači i adminstratori mogu da koriste ovu stranicu';
$string['cannotusepage2'] = 'Žao nam je, ne možete da koristite ovu stranicu';
$string['cannotviewprofile'] = 'Ne možete vidjeti profil ovog korisnika';
$string['cannotviewreport'] = 'Ne možete vidjeti ovaj izvještaj';
$string['cannotwritefile'] = 'Nije moguće upisivanje u ovu datoteku ({$a})';
$string['categoryerror'] = 'Greška kategorije';
$string['categoryidnumbertaken'] = 'ID broj je već u upotrebi za drugu kategoriju';
$string['categorynamerequired'] = 'Potreban naziv kategorije';
$string['categorytoolong'] = 'Naziv kategorije je predug';
$string['commentmisconf'] = 'Broj komentara je pogrešno konfigurisan';
$string['componentisuptodate'] = 'Komponenta je dostupna u svojoj najnovijoj verziji';
$string['confirmsesskeybad'] = 'Žao nam je, ali ključ Vaše sesije ne može biti potvrđen da bi se izvršila ova akcija. Ova sigurnosna opcija spriječava slučajno ili zlonamjerno izvršavanje važnih funkcija u Vaše ime. Molimo budite sigurni da stvarno želite da izvršite ovu funkciju.';
$string['couldnotassignrole'] = 'Došlo je do ozbiljne, ali neodređene greške prilikom pokušaja dodjele Vaše nove uloge';
$string['couldnotupdatenoexistinguser'] = 'Nije moguće ažurirati korisnika - korisnik ne postoji';
$string['countriesphpempty'] = 'Greška: Datoteka countries.php u jezičkom paketu {$a} je prazna ili nedostaje.';
$string['coursedoesnotbelongtocategory'] = 'Kurs ne pripada ovoj kategoriji';
$string['courseformatnotfound'] = 'Format kursa \'{$a}\' ne postoji ili nije prepoznat';
$string['coursegroupunknown'] = 'Odgovarajući kurs za grupu {$a} nije zadan';
$string['courseidnotfound'] = 'Broj kursa ne postoji';
$string['courseidnumbertaken'] = 'ID broj je već u upotrebi za drugi kurs';
$string['coursemisconf'] = 'Kurs je pogrešno konfigurisan';
$string['courserequestdisabled'] = 'Oprostite, ali administrator je onemogućio slanje zahtjeva za pokretanje novih kurseva';
$string['csvcolumnduplicates'] = 'Otkriveni su duplikati kolona';
$string['csvemptyfile'] = 'CSV datoteka je prazna';
$string['csvfewcolumns'] = 'Nema dovoljno kolona, molimo provjerite podešavanje za znak razdvajanja';
$string['csvinvalidcols'] = '<b>Neispravna CSV datoteka:</b> Prva linija mora da sadrži "Header Fields" a datoteka mora da bude tipa <br />"Expanded Fields/Comma Separated"<br />ili<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Neispravna CSV datoteka - svaka linija mora da ima 49 ili 70 polja';
$string['csvloaderror'] = 'Pojavila se greška u toku učitavanja CSV datoteke!';
$string['csvweirdcolumns'] = 'Neispravan format CSV datoteke - broj kolona nije svugdje isti!';
$string['dbconnectionfailed'] = '<p>Greška: Konekcija sa bazom podataka nije uspjela</p> <p>Moguće je da je baza podataka preopterećena ili da na drugi način ne funkioniše kako treba.</p> <p>Administrator stranice, također, treba da provjeri da li su svi podaci vezani za bazu podataka ispravno navedeni u config.php datoteci</p>';
$string['dbdriverproblem'] = '<p>Greška: uočen je problem sa driverom baze podataka</p> <p>Administrator stranice bi trebalo da provjeri konfiguraciju servera</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Uočen je ozbiljan problem sa sesijom baze podataka.<br /><br />Molimo, obavijestite administratora servera.';
$string['dbsessionhandlerproblem'] = 'Podešavanje sesije baze podataka nije uspjelo.<br /><br />Molimo, obavijestite administratora servera.';
$string['dbsessionmysqlpacketsize'] = 'Ozbiljna greška na sesiji je zabilježena. <br /><br />Molimo, obavijestite administratora. Ovaj problem je najverovatnije uzrokovan niskom vrijednošću u max_allowed_packet MySQL postavkama.';
$string['dbupdatefailed'] = 'Ažuriranje baze podataka nije uspjelo';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" nije moguće mijenjati. Otkrivena je zavisnost od {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = '"DDL sql execution" greška';
$string['ddlfieldalreadyexists'] = 'Polje "{$a}" već postoji';
$string['ddlfieldnotexist'] = 'Polje "{$a->fieldname}" ne postoji u tabeli "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabela "{$a}" već postoji';
$string['ddltablenotexist'] = 'Tabela "{$a}" ne postoji';
$string['ddlunknownerror'] = 'Nepoznata DDL greška';
$string['ddlxmlfileerror'] = 'Pronađene greške u datotekama XML baze podataka';
$string['ddsequenceerror'] = 'Definicija tabele "{$a}" je netačna; može postojati samo jedna auto-kolona, i ona mora biti definisana kao ključ.';
$string['destinationcmnotexit'] = 'Modul destinacije kursa ne postoji';
$string['detectedbrokenplugin'] = 'Dodatak "{$a}" je neispravan ili zastario. Žao nam je, ali nije moguće nastaviti.';
$string['dmlexceptiononinstall'] = '<p>Nastala je greška u bazi podataka: [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlreadexception'] = 'Greška prilikom čitanja iz baze podataka';
$string['dmltransactionexception'] = 'Transakciona greška baze podataka';
$string['dmlwriteexception'] = 'Greška prilikom upisivanja u bazu podataka';
$string['downgradedcore'] = 'GREŠKA!!! Kod koji koristite je STARIJI od verzije kojа je kreirala ovе bazе!';
$string['downloadedfilecheckfailed'] = 'Nije uspjela provjera preuzete datoteke';
$string['duplicatefieldname'] = 'Otkriven je duplikat naziva polja "{$a}"';
$string['duplicatenosupport'] = '\'{$a->modname}\' aktivnost nije mogla biti duplicirana jer {$a->modtype} modul ne podržava backup i vraćanje.';
$string['duplicateparaminsql'] = 'GREŠKA: dupli naziv parametra u upitu';
$string['duplicaterolename'] = 'Već postoji uloga sa ovim imenom!';
$string['duplicateroleshortname'] = 'Već postoji uloga sa ovim kratkim imenom!';
$string['duplicateusername'] = 'Duplikat korisničkog imena - zapis se preskače';
$string['emailfail'] = 'Slanje e-mail poruke nije uspjelo';
$string['error'] = 'Pojavila se greška';
$string['errorcleaningdirectory'] = 'Greška pri čišćenju direktorija "{$a}"';
$string['errorcopyingfiles'] = 'Greška pri kopiranju datoteka';
$string['errorcreatingdirectory'] = 'Greška pri kreiranju direktorija "{$a}"';
$string['errorcreatingfile'] = 'Greška pri kreiranju datoteke "{$a}"';
$string['errorcreatingrole'] = 'Greška u kreiranju uloge';
$string['errorfetchingrssfeed'] = 'Greška prilikom preuzimanja RSS izvora vijesti.';
$string['erroronline'] = 'Greška u liniji {$a}';
$string['errorparsingxml'] = 'Greška pri parsiranju XML-a: {$a->errorstring} u redu {$a->errorline}, na znaku {$a->errorchar}';
$string['errorprocessingarchive'] = 'Greška pri procesiranju arhivirane datoteke';
$string['errorreadingfile'] = 'Greška pri čitanju datoteke "{$a}"';
$string['errorsavingrequest'] = 'Kada ste pokušali da sačuvate svoj zahtjev pojavila se greška';
$string['errorsettinguserpref'] = 'Greška u podešavanju korisnikovih preferenci';
$string['errorunzippingfiles'] = 'Greška pri raspakivanju datoteka';
$string['expiredkey'] = 'Ključ je istekao';
$string['externalauthpassworderror'] = 'Lozinka za vanjsku provjeru identiteta nije prazan niz';
$string['externalfilenolocation'] = 'Eksterna datoteka nema putanju';
$string['failtoloadblocks'] = 'Jedan ili više blokova je registrovano u bazi podataka, ali nisu uspjeli da se učitaju!';
$string['fieldrequired'] = '"{$a}" je obavezno polje';
$string['fileexists'] = 'Datoteka postoji';
$string['filemismatch'] = 'Neslaganje naziva datoteke (koja nije ključna). Datoteka "{$a->current}" treba da bude {$a->file}';
$string['filenotfound'] = 'Žao nam je, ali traženi dokument nije bilo moguće pronaći';
$string['filenotreadable'] = 'Datoteka nije čitljiva';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} ne dopušta lokalnu konfiguraciju.';
$string['filternotactive'] = 'Filter {$a} trenutno nije aktivan';
$string['filternotenabled'] = 'Filter nije omogućen!';
$string['filternotinstalled'] = 'Filter {$a} trenutno nije instaliran';
$string['forumblockingtoomanyposts'] = 'Prekoračili ste ograničenje za broj poslanih poruka na ovom forumu';
$string['generalexceptionmessage'] = 'Izuzetak - {$a}';
$string['gradecantregrade'] = 'Greška je nastala tijekom izračunavanja ocjene';
$string['gradepubdisable'] = 'Objavljivanje ocjena je onemogućeno';
$string['groupalready'] = 'Korisnik već pripada grupi {$a}';
$string['groupexistforcourse'] = 'Grupa "{$a}" već postoji u ovom kursu';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grupa "{$a->name}" sa ID brojem "{$a->idnumber}" već postoji na ovom kursu';
$string['grouphasidnumber'] = 'Grupa "{$a}" ima ID broj i možda je automatski kreirana od strane eksternog sistema. Nemate ovlaštenje da uklonite ovu grupu.';
$string['groupinghasidnumber'] = 'Grupisanje "{$a}" ima ID broj i možda je automatski kreirano od strane eksternog sistema. Nemate ovlaštenje da uklonite ovo grupisanje.';
$string['groupingnotaddederror'] = 'Grupiranje "{$a}" nije dodano';
$string['groupnotaddederror'] = 'Grupa "{$a}" nije dodana';
$string['groupnotaddedtogroupingerror'] = 'Grupa "{$a->groupname}" nije dodana grupiranju "{$a->groupingname}"';
$string['groupunknown'] = 'Grupa {$a} ne pripada datom kursu';
$string['groupusernotmember'] = 'Korisnik nije član ove grupe';
$string['guestnocomment'] = 'Gostima nije dozvoljeno da postavljaju komentare';
$string['guestnoeditprofile'] = 'Gost ne može da uređuje svoj profil';
$string['guestnoeditprofileother'] = 'Ne može se uređivati profil gosta';
$string['guestnorate'] = 'Gostima nije dozvoljeno da ocjenjuju pojmove';
$string['guestsarenotallowed'] = 'Korisniku sa nalogom gosta nije dozvoljeno da ovo uradi';
$string['hackdetected'] = 'Otkriven je hakerski napad!';
$string['hashpoolproblem'] = 'Neispravan sadržaj skupa datoteke  {$a}.';
$string['headersent'] = 'Zaglavlja su već poslana';
$string['idnumbertaken'] = 'ID broj se već koristi za drugi kurs';
$string['idnumbertoolong'] = 'ID broj je predugačak';
$string['importformatnotimplement'] = 'Žao nam je, ali unos ovog formata još nije implementiran!';
$string['incorrectext'] = 'Datoteka ima neispravnu ekstenziju';
$string['installproblem'] = 'Obično nije moguće ispraviti greške koje nastanu tokom instalacije. Možda ćete morati da kreirate novu bazu podataka, ili da upotrijebite neki drugi prefiks baze podataka ako želite da ponovite instalaciju.';
$string['internalauthpassworderror'] = 'Lozinka nedostaje ili su neispravna pravila za kreiranje lozinke za internu provjeru identiteta';
$string['invalidaccess'] = 'Neispravan pristup ovoj stranici';
$string['invalidaccessparameter'] = 'Neispravan parametar pristupa';
$string['invalidaction'] = 'Neispravan parametar akcije';
$string['invalidactivityid'] = 'Neispravan ID broj aktivnosti';
$string['invalidadminsettingname'] = 'Neispravne admin postavke ({$a})';
$string['invalidargorconf'] = 'Nisu proslijeđeni ispravni argumenti ili pogrešna konfiguracija servera';
$string['invalidarguments'] = 'Nisu proslijeđeni ispravni argumenti';
$string['invalidblockinstance'] = 'Neispravna instanca bloka za: {$a}';
$string['invalidbulkenrolop'] = 'Zatražena je neispravna operacija za masovni upis.';
$string['invalidcategory'] = 'Pogrešna kategorija';
$string['invalidcategoryid'] = 'Pogrešan ID broj kategorije!';
$string['invalidcomment'] = 'Komentar je neispravan';
$string['invalidcommentarea'] = 'Neispravnо područje za komentar';
$string['invalidcommentid'] = 'Neispravan ID broj komentara';
$string['invalidcommentitemid'] = 'Neispravan itemid komentara';
$string['invalidcommentparam'] = 'Neispravni parametri komentara';
$string['invalidcomponent'] = 'Neispravan naziv komponente';
$string['invalidconfirmdata'] = 'Neispravni potvrdni podaci';
$string['invalidcontext'] = 'Neispravan kontekst';
$string['invalidcourse'] = 'Neispravan kurs';
$string['invalidcourseid'] = 'Pokušavate da koristite neispravan ID broj kursa';
$string['invalidcourselevel'] = 'Pogrešan nivo konteksta';
$string['invalidcoursemodule'] = 'Neispravan ID broj modula kursa';
$string['invalidcoursenameshort'] = 'Neispravan kratak naziv kursa';
$string['invaliddata'] = 'Proslijeđeni podaci su neispravni';
$string['invaliddatarootpermissions'] = 'Otkrivena su neispravna ovlaštenja u $CFG->dataroot direktoriju. Administrator mora da ispravi ovlaštenja.';
$string['invaliddevicetype'] = 'Neispravan tip uređaja';
$string['invalidelementid'] = 'Pogrešan ID broj elementa';
$string['invalidentry'] = 'Ovo nije ispravan unos';
$string['invalidevent'] = 'Neispravan događaj';
$string['invalidfieldname'] = '"{$a}" nije ispravno ime polja';
$string['invalidfiletype'] = '"{$a}" nije ispravan tip datoteke';
$string['invalidformatpara'] = 'Pogrešan format za parametar izbora';
$string['invalidformdata'] = 'Neispravni podaci u obrascu';
$string['invalidfunction'] = 'Neispravna funkcija';
$string['invalidgradeitemid'] = 'Neispravan ID broj stavke ocjene';
$string['invalidgroupid'] = 'Naveden je neispravan ID broj grupe';
$string['invalidipformat'] = 'Neispravan format IP adrese';
$string['invaliditemid'] = 'Neispravan ID broj stavke';
$string['invalidkey'] = 'Neispravan ključ';
$string['invalidlegacy'] = 'Neispravna definicija naslijeđene uloge za tip: {$a}';
$string['invalidmd5'] = 'Provjerena varijabla (md5 datoteka) je pogrešna - pokušajte ponovo';
$string['invalidmode'] = 'Neispravan mod ({$a})';
$string['invalidmodule'] = 'Neispravan modul';
$string['invalidmoduleid'] = 'Neispravan ID broj modula: {$a}';
$string['invalidmodulename'] = 'Neispravan naziv modula: {$a}';
$string['invalidnum'] = 'Neispravna numerička vrijednost';
$string['invalidnumkey'] = 'Polje $conditions ne može da sadrži numeričke ključeve. Molimo, popravite kod!';
$string['invalidoutcome'] = 'Neispravan ID broj ishoda';
$string['invalidpagesize'] = 'Neispravna veličina stranice';
$string['invalidpasswordpolicy'] = 'Neispravna pravila za kreiranje lozinke';
$string['invalidpaymentmethod'] = 'Neispravan način plaćanja {$a}';
$string['invalidqueryparam'] = 'GREŠKA: Pogrešan broj parametara upita. Očekivano {$a->expected}, a dobijeno {$a->actual}.';
$string['invalidratingarea'] = 'Neispravno područje za ocjenjivanje';
$string['invalidrecord'] = 'Nije moguće naći zapis podatka u tabeli baze podataka {$a}.';
$string['invalidrecordunknown'] = 'Nije moguće naći zapis podatka u bazi';
$string['invalidrequest'] = 'Neispravan zahtjev';
$string['invalidrole'] = 'Neispravna uloga';
$string['invalidroleid'] = 'Neispravan ID broj uloge';
$string['invalidscaleid'] = 'Neispravan identifikator skale';
$string['invalidsection'] = 'Zapis modula kursa sadrži neispravnu sekciju';
$string['invalidsesskey'] = 'Netačan kod sesije je proslijeđen, forma nije prihvaćena!';
$string['invalidshortname'] = 'To je neispravan kratki naziv kursa';
$string['invalidsourcefield'] = 'Polje izvora datoteke nacrta je neispravno';
$string['invalidstatedetected'] = 'Nešto je krenulo naopako: {$a}. Inače, ovo ne bi trebalo da se događa.';
$string['invalidurl'] = 'Neispravan url';
$string['invaliduser'] = 'Neispravan korisnik';
$string['invaliduserfield'] = 'Neispravno korisničko polje: {$a}';
$string['invaliduserid'] = 'Neispravan ID broj korisnika';
$string['invalidusername'] = 'Dato korisničko ime sadrži neprihvatljive karaktere';
$string['invalidxmlfile'] = '"{$a}" nije ispravna XML datoteka';
$string['iplookupfailed'] = 'Nije moguće pronaći geografske podatke o ovoj IP adresi {$a}.';
$string['iplookupprivate'] = 'Nije moguće prikazati pretragu privatne IP adrese';
$string['ipmismatch'] = 'Klijentska IP adresa se ne poklapa';
$string['listcantmovedown'] = 'Pomjeranje stavke nadole nije uspjelo, pošto je to posljednja stavka u nizu';
$string['listcantmoveleft'] = 'Pomijeranje stavke ulijevo nije uspjelo, pošto ona nema nadređenu stavku';
$string['listcantmoveright'] = 'Pomjeranje stavke udesno nije uspjelo, pošto nema stavke koja bi joj bila podređena. Pomjerite je ispod druge stavke, i onda je možete pomjeriti udesno.';
$string['listcantmoveup'] = 'Pomjeranje stavke nagore nije uspjelo, pošto je to prva stavka u nizu';
$string['listnochildren'] = 'Nema podređenih stavki';
$string['listnoitem'] = 'Stavka nije pronađena';
$string['listnopeers'] = 'Nisu pronađene srodne stavke';
$string['listupdatefail'] = 'Operacija nad bazom nije uspjela pri uređivanju hijerarhije liste';
$string['logfilenotavailable'] = 'Zapisi nisu dostupni';
$string['loginasnoenrol'] = 'Ne možete se upisivati ili ispisivati sa kursa dok traje sesija "Prijavi se kao"';
$string['loginasonecourse'] = 'Ne možete da pristupite ovom kursu.<br /> Morate prvo da završite sesiju "Prijavi se kao", prije ulaska na bilo koji drugi kurs.';
$string['maxareabytes'] = 'Ne postoji dovoljno prostora da bi se pohranio ovaj fajl';
$string['maxbytes'] = 'Ova datoteka je veća od maksimalno dozvoljene veličine';
$string['messagingdisable'] = 'Slanje poruka na ovom sajtu nije omogućeno';
$string['mimetexisnotexist'] = 'Vaš sistem nije konfigursan da bi mogao da pokrene mimeTeX. Morate da preuzmete odgovarajuću izvršnu datoteku za Vašu PHP_OS platformu sa <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, ili da pribavite C izvorni kod sa <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, da ga kompajlirate i postavite izvršnu datoteku u Vaš moodle/filter/tex/ direktorij.';
$string['mimetexnotexecutable'] = 'Prilagođeni mimetex nije moguće pokrenuti!';
$string['missingfield'] = 'Polje "{$a}" nedostaje';
$string['missingkeyinsql'] = 'Greška: nedostaje parametar "{$a}" u upitu';
$string['missing_moodle_backup_xml_file'] = 'Rezervnoj kopiji podataka nedostaje XML datoteka: {$a}';
$string['missingparam'] = 'Nedostaje neophodni parametar ({$a})';
$string['missingparameter'] = 'Nedostaje parametar';
$string['missingrequiredfield'] = 'Nedostaje neko obavezno polje';
$string['missinguseranditemid'] = 'Nedostaje userid i itemid';
$string['missingvarname'] = 'Nedostaje ime neophodne varijable';
$string['mixedtypesqlparam'] = 'GREŠKA: Izmiješani tipovi sql parametara upita!!!';
$string['mnetdisable'] = 'MNET je onemogućen';
$string['mnetlocal'] = 'Udaljeni MNET korisnik ne može da se prijavi lokalno';
$string['moduledisable'] = 'Ovaj modul ({$a}) je onemogućen za ovaj konkretan kurs';
$string['moduledoesnotexist'] = 'Ovaj modul ne postoji';
$string['moduleinstancedoesnotexist'] = 'Instanca ovog modula ne postoji';
$string['modulemissingcode'] = 'Modulu {$a} nedostaje kod potreban za izvođenje ove funkcije';
$string['movecatcontentstoroot'] = 'Premještanje sadržaja kategorije u osnovni direktorij nije dozvoljeno. Morate da premjestite sadržaje u postojeću kategoriju!';
$string['movecategorynotpossible'] = 'Ne možete da pomjerite kategoriju \'{$a}\' u odabranu kategoriju.';
$string['movecategoryownparent'] = 'Ne možete da postavite kategoriju \'{$a}\' kao nadređenu kategoriju sebi samoj.';
$string['movecategoryparentconflict'] = 'Ne možete da napravite kategoriju \'{$a}\' podkategorijom jedne vlastite podkategorije.';
$string['multiplerecordsfound'] = 'Pronađeni su višestruki zapisi, a očekivan je samo jedan zapis.';
$string['multiplerestorenotallow'] = 'Nije dozvoljeno istovremenо pokretanje više procedura restаuracije podataka!';
$string['mustbeloggedin'] = 'Morate biti prijavljeni na sistem kako bi ovo uradili';
$string['mustbeteacher'] = 'Morate biti predavač da biste vidjeli ovu stranicu';
$string['myisamproblem'] = 'Tabele u bazi podataka koriste MyISAM sistem, Preporučuje se upotreba ACID kompatibilnog sistema sa punom podrškom za transakcije, poput InnoDB.';
$string['needcopy'] = 'Prvo morate nešto da kopirate!';
$string['needcoursecategroyid'] = 'Mora biti naveden ID broj kursa ili kategorije';
$string['needphpext'] = 'Potrebno je da dodate {$a} podršku za Vašu PHP instalaciju';
$string['noadmins'] = 'Nema administratora!';
$string['noblocks'] = 'Nijedan blok nije pronađen!';
$string['nocapabilitytousethisservice'] = 'Korisnik nema potrebne mogućnosti za korištenje ovog servisa';
$string['nocategorydelete'] = 'Kategorija \'{$a}\' se ne može izbrisati!';
$string['nocontext'] = 'Žao nam je, ali taj kurs nije validan kontekst';
$string['nodata'] = 'Nema podataka';
$string['noexistingcategory'] = 'Nema kategorije';
$string['nofile'] = 'Datoteka nije navedena';
$string['nofiltersenabled'] = 'Nijedan filter nije omogućen';
$string['nofolder'] = 'Traženi direktorij ne postoji';
$string['noformdesc'] = 'Za ovu aktivnost nije pronađena formslib datoteka sa opisom obrasca.';
$string['noguest'] = 'Ovdje nema gostiju!';
$string['noinstances'] = 'Nema instanci {$a} u ovom kursu!';
$string['nologinas'] = 'Nije Vam dozvoljeno da se prijavite kao taj korisnik';
$string['nonmeaningfulcontent'] = 'Besmislen sadržaj';
$string['noparticipants'] = 'Nije pronađen ni jedan učesnik na ovom kursu';
$string['noparticipatorycms'] = 'Žao nam je, nemate module kursa sa učesnicima za koje bi se mogao kreirati izvještaj';
$string['nopermissions'] = 'Žao nam je, ali trenutno nemate dozvolu da to radite ({$a})';
$string['nopermissiontocomment'] = 'Ne možete da dodate komentar u ovaj rječnik!';
$string['nopermissiontodelentry'] = 'Ne možete da brišete unose drugih korisnika!';
$string['nopermissiontoeditcomment'] = 'Ne možete da uređujete komentare drugih korisnika!';
$string['nopermissiontohide'] = 'Nemate ovlaštenja za sakrivanje!';
$string['nopermissiontoimportact'] = 'Nemate neophodna ovlaštenja da biste unijeli aktivnosti u ovaj kurs';
$string['nopermissiontolock'] = 'Nemate ovlaštenja za zaključavanje!';
$string['nopermissiontomanagegroup'] = 'Nemate neophodna ovlaštenja da bi upravljali grupama';
$string['nopermissiontorate'] = 'Ocjenjivanje stavki nije dozvoljeno';
$string['nopermissiontoshow'] = 'Nemate ovlaštenja da vidite ovo!';
$string['nopermissiontounlock'] = 'Nemate ovlaštenja za otključavanje!';
$string['nopermissiontoupdatecalendar'] = 'Žao nam je, ali trenutno nemate ovlaštenja da ažurirate događaje u kalendaru';
$string['nopermissiontoviewgrades'] = 'Ne mogu da vide ocjene.';
$string['nopermissiontoviewletergrade'] = 'Nedostaje ovlaštenje da bi se vidjele slovne ocjene';
$string['nopermissiontoviewpage'] = 'Nije Vam dozvoljeno da gledate ovu stranicu';
$string['nosite'] = 'Nije moguće pronaći kurs najvišeg nivoa!';
$string['nositeid'] = 'Ne postoji ID broj stranice';
$string['nostatstodisplay'] = 'Žao nam je, nema raspoloživih podataka za prikaz';
$string['notallowedtoupdateprefremotely'] = 'Nemate dozvolu da udaljeno ažurirate preference ovog korisnika';
$string['notavailable'] = 'Trenutno nije na raspolaganju.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Potrebno je da budete član ove grupe kursa';
$string['notownerofkey'] = 'Niste vlasnik ovog ključa';
$string['nousers'] = 'Ne postoji takav korisnik!';
$string['onlyadmins'] = 'Samo administratori to mogu uraditi';
$string['onlyeditingteachers'] = 'Samo predavači sa uređivačkim privilegijama mogu to uraditi';
$string['onlyeditown'] = 'Možete mijenjati samo lične podatke';
$string['orderidnotfound'] = 'ID broj narudžbe {$a} nije pronađen';
$string['pagenotexist'] = 'Došlo je do neuobičajene greške (pokušan je pristup stranici koja ne postoji)';
$string['pathdoesnotstartslash'] = 'Nisu predani ispravni argumenti, putanja ne počinje sa kosom crtom (/)!';
$string['pleasereport'] = 'Ako imate vremena, molimo objasnite nam šta ste pokušavali da učinite kada je došlo do greške:';
$string['pluginrequirementsnotmet'] = 'Dodatak "{$a->pluginname}" ({$a->pluginversion}) nije mogao biti instaliran. On zahtijeva noviju verziju Moodle sistema (Vi trenutno koristite {$a->currentmoodle}, a potrebna Vam je verzija {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Greška: prefiks tabela baze podataka ne može biti prazan ({$a})</p> <p>Administrator stranice mora da riješi ovaj problem.</p>';
$string['prefixtoolong'] = '<p>Greška: prefiks tabele baze podataka je predug ({$a->dbfamily})</p> <p>Administrator sajta mora da riješi ovaj problem. Maksimalna dužina prefiksa tabela u {$a->dbfamily} je {$a->maxlength} karaktera.</p>';
$string['processingstops'] = 'Procesiranje se ovdje zaustavlja. Preostali zapisi biće ignorisani.';
$string['protected_cc_not_supported'] = 'Zaštićene kasete nisu podržane.';
$string['querystringcannotbeempty'] = 'Upitni niz (query string) ne smije biti prazan.';
$string['redirecterrordetected'] = 'Otkriveno je preusmjeravanje koje nije podržano, pa je izvršenje skripte okončano.';
$string['refoundto'] = 'Može biti refundirano na iznos od {$a}';
$string['refoundtoorigi'] = 'Refundirano na originalni iznos od: {$a}';
$string['remotedownloaderror'] = 'Preuzimanje komponente na Vaš server nije uspjelo. Provjerite podešavanja proksi servera. PHP cURL ekstenzija se preporučuje.<br /><br />Morate da preuzmete <a href="{$a->url}">{$a->url}</a> datoteku ručno, kopirate je u direktorij "{$a->dest}" na svom sereveru i tamo je raspakovati.';
$string['remotedownloadnotallowed'] = 'Nije dozvoljeno preuzimanje komponenti na Vaš server (opcija allow_url_fopen je onemogućena).<br /><br />Morate ručno preuzeti datoteku <a href="{$a->url}">{$a->url}</a>, kopirati je u "{$a->dest}" na svom serveru i tamo je raspakovati.';
$string['reportnotavailable'] = 'Ova vrsta izvještaja je jedino dostupna za stranicu kursa.';
$string['requirecorrectaccess'] = 'Neispravan url ili port.';
$string['requireloginerror'] = 'Kurs ili aktivnost nisu dostupni.';
$string['restorechecksumfailed'] = 'Dogodio se problem sa podacima za restauraciju koji su smješteni u Vašoj sesiji. Molimo provjerite Vaša ograničenja PHP memorije/veličine DB paketa. Proces resturacije je zaustavljen.';
$string['restore_path_element_missingmethod'] = 'Nedostaje metod za restauraciju {$a}. Metod mora biti definisan od strane programera.';
$string['restore_path_element_noobject'] = 'Objekat za restauraciju {$a} nije objekat.';
$string['restrictedcontextexception'] = 'Žao nam je, izvršenje eksterne funkcije krši restrikciju konteksta.';
$string['restricteduser'] = 'Žao nam je, ali vaš tekući račun "{$a}" je ograničen i ne možete uraditi ovu akciju';
$string['reverseproxyabused'] = 'Žao nam je, uključen je rezervni proksi pa se serveru ne može direktno pristupiti. <br />Kontaktirajte administratora servera.';
$string['rpcerror'] = 'Ups! Vaša MNET komunikacija nije uspjela! Ovdje je poruka o grešci koju treba proslijediti administratoru: {$a}';
$string['scheduledbackupsdisabled'] = 'Administrator servera je onemogućio kreiranje planiranih rezervnih kopija';
$string['secretalreadyused'] = 'Link za potvrdu promjene lozinke je već iskorišten. Lozinka nije promijenjena';
$string['sectionnotexist'] = 'Ova sekcija ne postoji';
$string['sendmessage'] = 'Pošalji poruku';
$string['serverconnection'] = 'Greška u povezivanju sa serverom';
$string['servicedonotexist'] = 'Usluga ne postoji';
$string['sessioncookiesdisable'] = 'Nepravilna upotreba require_key_login() - "cookies" sesije moraju biti onemogućeni!';
$string['sessiondiskfull'] = 'Particija za čuvanje sesija je puna. Prijava na sistem trenutno nije moguća.<br /><br /> Molimo, obavijestite administratora servera.';
$string['sessionerroruser'] = 'Vaša sesija je istekla. Molimo, prijavite se  ponovo na sistem.';
$string['sessionerroruser2'] = 'Došlo je do greške koja utiče na Vašu tekuću sesiju. Molimo pristupite sistemu ponovo ili ponovo pokrenite svoj web pretraživač.';
$string['sessionhandlerproblem'] = 'Upravljački sklop sesije je pogrešno podešen';
$string['sessionipnomatch'] = 'Žao nam je, ali izgleda da se Vaš IP broj promijenio od kada ste se prijavili na sistem. Ova sigurnosna opcija sprečava "crackers" da ukradu Vaš indentitet dok ste prijavljeni na ovu stranicu. Normalni korisnici ne bi trebalo da vide ovu poruku - molimo Vas da tražite pomoć od administratora stranice.';
$string['sessionipnomatch2'] = 'Žao nam je, ali izgleda da se, od trenutka kada ste se prvi put prijavili na sistem, promijenila Vaša IP adresa. Ovo sigurnosno svojstvo sprječava zlonamjerne od krađe Vašeg identiteta dok ste prijavljeni na ovoj stranici. Ovu grešku možete vidjeti ukoliko koristite bežični pristup Internetu. Molimo Vas da kontaktirate administratora stranice za dodatnu pomoć.<br /><br />Ukoliko želite da nastavite molimo Vas pritisnite na tastaturi F5 da bi osvježili ovu stranicu.';
$string['sessionwaiterr'] = 'Vrijeme je isteklo dok ste čekali zaključavanje sesije.<br /> Sačekajte da se vaši trenutni zahtjevi završe i pokušajte ponovo kasnije.';
$string['shortnametaken'] = 'Kratki naziv se već koristi za drugi kurs  ({$a})';
$string['socksnotsupported'] = 'SOCKS5 proxy nije podržan u PHP4';
$string['spellcheckernotconf'] = 'Provjera pravopisa nije konfigurisana';
$string['sslonlyaccess'] = 'Iz sigurnosnih razloga dozvoljene su samo https konekcije.';
$string['statscatchupmode'] = 'Statistika je trenutno u modu za sustizanje obrade padataka. Do sada je procesirano {$a->daysdone} dan(a), a još {$a->dayspending} dana čeka na obradu. Vratite se nešto kasnije!';
$string['statsdisable'] = 'Statistika nije omogućena';
$string['statsnodata'] = 'Nema dostupnih podataka za tu kombinaciju kursa i vremenskog perioda.';
$string['storedfilecannotcreatefile'] = 'Nije moguće kreirati lokalne direktorije skupa datoteka, molimo provjerite ovlaštenja u izvornom direktorijumu i slobodan prostor na disku.';
$string['storedfilecannotcreatefiledirs'] = 'Nije moguće kreirati lokalne direktorije skupa datoteka. Molimo provjerite ovlaštenja za korijenski direktorij (<i>dataroot</i>).';
$string['storedfilecannotread'] = 'Nije moguće pročitati datoteku - ili datoteka ne postoji ili postoje problemi sa ovlaštenjima';
$string['storedfilenotcreated'] = 'Nije moguće kreirati datoteku "{$a->contextid}/{$a->filearea}/{$a->itemid}/{$a->filepath}/{$a->filename}"';
$string['storedfileproblem'] = 'Nepoznati izuzetak u vezi sa lokalnim datotekama ({$a})';
$string['tagdisabled'] = 'Oznake su onemogućene!';
$string['tagnotfound'] = 'Navedena oznaka (tag) nije pronađena u bazi podataka';
$string['targetdatabasenotempty'] = 'Ciljna baza podataka nije prazna. Transfer je poništen iz sigurnosnih razloga';
$string['textconditionsnotallowed'] = 'Poređenja uslova za tekstualne kolоne nisu dozvoljena. Molimo da u upitu koristite sql_compare_text().';
$string['themenotinstall'] = 'Ova šema nije instalirana';
$string['TODO'] = 'TODO';
$string['tokengenerationfailed'] = 'Nije moguće generisati novi token.';
$string['transactionvoid'] = 'Transakcija se ne može poništiti, jer je već poništena.';
$string['unenrolerror'] = 'Došlo je do greške prilikom pokušaja ispisivanja te osobe';
$string['unicodeupgradeerror'] = 'Žao nam je, ali Vaša baza podataka nije u Unicode formatu, a ova vezija Moodlea ne može da je prebaci u Unicode bazu podataka. Molimo prvo uradite nadogradnju sistema do Moodle 1.7.x verzije i uradite Unicode migraciju sa administratorske stranice. Nakon što to uradite moći ćete da pređete na Moodle {$a}';
$string['unknowaction'] = 'Nepoznata akcija!';
$string['unknowcategory'] = 'Kategorija nije poznata!';
$string['unknowcontext'] = 'Ovo je nepoznati kontekst({$a}) u get_child_contexts!';
$string['unknowformat'] = 'Format nije poznat ({$a})';
$string['unknownbackupexporterror'] = 'Nepoznata greška u toku pripreme podataka za unos';
$string['unknownblockregion'] = 'Područje bloka \'{$a}\' nije prepoznato na ovoj stranici.';
$string['unknowncontext'] = 'Ovo je nepoznat kontekst';
$string['unknowncourse'] = 'Ne postoji kurs pod nazivom "{$a}"';
$string['unknowncourseidnumber'] = 'Nepoznat ID broj kursa "{$a}"';
$string['unknowncourserequest'] = 'Nepoznat zahtjev za pokretanje novog kursa';
$string['unknowncoursesection'] = 'Nepoznata sekcija na kursu "{$a}"';
$string['unknownevent'] = 'Nepoznati događaj';
$string['unknownfiletype'] = 'Greška! Nepoznati tip filtera';
$string['unknowngroup'] = 'Nepoznata grupa "{$a}"';
$string['unknownhelp'] = 'Nepoznata tema pomoći {$a}';
$string['unknownjsinrequirejs'] = 'Nije moguće naći JS biblioteku: {$a}';
$string['unknownmodulename'] = 'Nepoznati modul naziv za obrazac';
$string['unknownrole'] = 'Nepoznata uloga "{$a}"';
$string['unknownsortcolumn'] = 'Nepoznata kolumna za sortiranje {$a}';
$string['unknownuseraction'] = 'Žao nam je, ali sistem nije razumio ovu akciju korisnika';
$string['unknownuserselector'] = 'Nepoznata opcija za izbor korisnika';
$string['unknoworder'] = 'Nepoznat redoslijed';
$string['unknowparamtype'] = 'Nepoznat tip parametra: {$a}';
$string['unknowquestiontype'] = 'Nepodržani tip pitanja {$a}';
$string['unknowuploadaction'] = 'Greška: nepoznata akcija za postavljanje datoteke na server ({$a})';
$string['unspecifycourseid'] = 'Mora se navesti broj kursa, kratki naziv ili identifikacioni (id) broj';
$string['unsupportedevent'] = 'Nepodržani tip događaja';
$string['unsupportedstate'] = 'Nepodržani status završenosti';
$string['unsupportedwebserver'] = 'Oprostite, softver za Web server ({$a}) nije podržan';
$string['upgraderequires19'] = 'Greška: Nova verzija Moodlea je instalirana na server, Nažalost, ažuriranje sa prethodne verzije nije podržano.<br />Molimo Vas da prvo ažurirate Moodle na posljednju 1.9.x verziju. Na prethodnu verziju se, također, možete vratiti tako što ćete ponovo instalirati originalne datoteke.';
$string['upgraderunning'] = 'Stranica se ažurira, molimo pokušajte kasnije';
$string['urlnotdefinerss'] = 'Nije defisana URL adresa za RSS izvor vijesti';
$string['useradmineditadmin'] = 'Samo je administratorima dozvoljeno da mijenjaju druge administratorske račune';
$string['useradminodelete'] = 'Administratorski računi ne mogu biti izbrisani';
$string['userautherror'] = 'Nepoznat dodatak za provjeru identiteta';
$string['userauthunsupported'] = 'Dodatak za provjeru identiteta nije moguće ovdje primjeniti';
$string['useremailduplicate'] = 'Ponovljena adresa';
$string['usermustbemnet'] = 'Korisnici na MNET kontrolnoj listi pristupa moraju biti udaljeni MNET korisnici';
$string['usernotaddederror'] = 'Korisnik nije dodan - greška';
$string['usernotaddedregistered'] = 'Korisnik nije dodan - već je registrovan';
$string['usernotavailable'] = 'Detaljnije informacije o ovom korisniku Vam nisu dostupne';
$string['usernotdeletedadmin'] = 'Korisnik nije izbrisan - nije moguće brisati administratorske račune';
$string['usernotdeletederror'] = 'Korisnik nije izbrisan - greška';
$string['usernotdeletedmissing'] = 'Korisnik nije izbrisan - korisničko ime nije pronađeno';
$string['usernotdeletedoff'] = 'Korisnik nije izbrisan - brisanje nije dozvoljeno.';
$string['usernotincourse'] = 'Ovaj korisnik nije na ovom kursu';
$string['usernotrenamedadmin'] = 'Ne mogu se preimenovati administratorski računi.';
$string['usernotrenamedexists'] = 'Korisnik nije preimenovan - novo korisničko ime je već zauzeto';
$string['usernotrenamedmissing'] = 'Korisnik nije preimenovan - nije pronađeno staro korisničko ime';
$string['usernotrenamedoff'] = 'Korisnik nije preimenovan - preimenovanje nije dozvoljeno';
$string['usernotupdatedadmin'] = 'Ne mogu se izmijeniti administratorski računi.';
$string['usernotupdatederror'] = 'Korisnik nije ažuriran - greška';
$string['usernotupdatednotexists'] = 'Nisu izmijenjeni podaci o korisniku - ne postoje podaci.';
$string['userquotalimit'] = 'Dostigli ste memorijski limit za svoje datoteke';
$string['userselectortoomany'] = 'user_selector je dobio više od jednog izabranog korisnika, iako opcija za višestruki izbor nije uključena.';
$string['wrongcall'] = 'Ovaj skript je pozvan pogrešno';
$string['wrongcontextid'] = 'Broj konteksta je neispravan (nije ga moguće naći)';
$string['wrongdestpath'] = 'Pogrešna odredišna putanja';
$string['wrongroleid'] = 'Neispravan ID broj uloge';
$string['wrongsourcebase'] = 'Pogrešna baza izvornog URL-a';
$string['wrongusernamepassword'] = 'Pogrešno korisničko ime/lozinka';
$string['wrongzipfilename'] = 'Pogrešan naziv arhive';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Nije bilo moguće kreirati kurs - Nema ovlaštenja';
$string['wwwrootmismatch'] = 'Otkriven je neispravan pristup. Ovom serveru se jedino može pristupiti preko adrese "{$a}". Molimo Vas da obavijestite administratora servera.';
$string['wwwrootslash'] = 'U config.php datoteci neispravno je podešena linija $CFG->wwwroot. Ona na kraju ne smije da ima kosu crtu /<br />Molimo Vas da o tome obavijestite administratora.';
$string['xmldberror'] = 'XMLDB greška!';
$string['youcannotdeletecategory'] = 'Ne možete izbrisati kategoriju \'{$a}\' jer ne možete niti izbrisati sadržaje niti ih premjestiti negdje drugo.';
