<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'bs', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Imate zadataka koji zahtvaju vašu pažnju';
$string['addattempt'] = 'Dozvoli dodatni pokušaj';
$string['addnewattempt'] = 'Dodaj novi pokušaj';
$string['addnewattemptfromprevious'] = 'Dodaj novi pokušaj na osnovu predhodne predaje';
$string['addnewattemptfromprevious_help'] = 'Ova opcija će kopirati vaše predhodne predaje u novu kako bi mogli dalje raditi na njima.';
$string['addnewattempt_help'] = 'Ovo će kreirati novu praznu predaju kako bi ste radili na njoj.';
$string['addsubmission'] = 'Dodaj rad';
$string['allocatedmarker'] = 'Dodijeljen marker';
$string['allocatedmarker_help'] = 'Marker dodijeljen ovoj predaji';
$string['allowsubmissions'] = 'Dozvoli korisniku da nastavi  predaju radova na ovaj zadatak';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Detaljnije informacije o zadatku i obrazac za predaju radova biće dostupni od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Dozvoli predaju od';
$string['allowsubmissionsfromdate_help'] = 'Ako je ova opcija omogućena studenti neće moći da predaju rad prije ovog datuma. Ako je onemogućena, studenti će odmah moći da predaju rad.';
$string['allowsubmissionsfromdatesummary'] = 'Ovaj zadatak će prihvatiti predaju rada od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Dozvoli promjene predatog rada';
$string['alwaysshowdescription'] = 'Uvijek prikaži opis';
$string['alwaysshowdescription_help'] = 'Ako je ova opcija omogućena, \'Opis zadatka\' će postati vidljiv studentima tek od datuma navedenog za podešavanje "Dozvoli predaju od"';
$string['applytoteam'] = 'Primjeni sve ocjene i povratne informacije za cijelu grupu';
$string['assign:addinstance'] = 'Dodaj novi zadatak';
$string['assign:exportownsubmission'] = 'Prenos vlastitog rada';
$string['assignfeedback'] = 'Dodatak za povratne informacije';
$string['assignfeedbackpluginname'] = 'Dodatak za povratne informacije';
$string['assign:grade'] = 'Ocjenjivanje zadatka';
$string['assign:grantextension'] = 'Odobri produženje';
$string['assign:manageallocations'] = 'Upravljaj markerima dodijeljenim predajama';
$string['assign:managegrades'] = 'Pregledaj i pošalji ocjene';
$string['assignmentisdue'] = 'Krajnji rok za predaju je istekao';
$string['assignmentmail'] = '{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'

Povratne informacije su pridružene vašem radu i možete ih pogledati  na:

{$a->url}';
$string['assignmentmailhtml'] = '{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\' <br /><br /> Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">radu</a>.';
$string['assignmentmailsmall'] = '{$a->grader} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\' . Povratne informacije možete pogledati pridružene vašem radu.';
$string['assignmentname'] = 'Naziv zadatka';
$string['assignmentplugins'] = 'Dodaci za zadatak';
$string['assignmentsperpage'] = 'Zadaci po stranici';
$string['assign:releasegrades'] = 'Pošalji ocjene';
$string['assign:revealidentities'] = 'Otkrij identitete studenata';
$string['assign:reviewgrades'] = 'Pregledaj ocjene';
$string['assignsubmission'] = 'Dodatak za predaju rada';
$string['assignsubmissionpluginname'] = 'Dodatak za predaju rada';
$string['assign:submit'] = 'Predaj zadatak';
$string['assign:view'] = 'Pregledaj zadatak';
$string['attempthistory'] = 'Predhodni pokušaji';
$string['attemptnumber'] = 'Pokušaj broj';
$string['attemptreopenmethod'] = 'Ponovno otvoreni pokušaji';
$string['attemptreopenmethod_help'] = 'Određuje kako su pokušaji predaje studenata ponovno otvoreni. Opcije su: <ul><li>Nikada - Predaja studentovog rada neće se moći ponovo otvoriti. </li><li> Ručno - Samo predavač može otvoriti </li><li>Automatski - Studentova predaja je automatski otvorena sve dok student ne ostvari ocjenu definisanu u "Ocjenama" za ovaj zadatak. </li></ul';
$string['attemptreopenmethod_manual'] = 'Ručno';
$string['attemptreopenmethod_none'] = 'Nikada';
$string['attemptreopenmethod_untilpass'] = 'Automatski dok ne položi';
$string['attemptsettings'] = 'Postavke pokušaja';
$string['availability'] = 'Dostupnost';
$string['backtoassignment'] = 'Nazad na zadatak';
$string['batchoperationconfirmaddattempt'] = 'Dozvoliti još jedan pokušaj za selektovane predaje?';
$string['batchoperationconfirmgrantextension'] = 'Dozvoli produženje za sve izabrane radove?';
$string['batchoperationconfirmlock'] = 'Zaključajte sve izabrane predate radove?';
$string['batchoperationconfirmreverttodraft'] = 'Vratite izabrane radove u status nacrta?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Postavi marker za odabrane predaje?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Postavi bazu za markere za sve odabrane predaje';
$string['batchoperationconfirmunlock'] = 'Otključajte sve izabrane predate radove?';
$string['batchoperationlock'] = 'zaključajte predate radove';
$string['batchoperationreverttodraft'] = 'vratite predate radove u status nacrta';
$string['batchoperationsdescription'] = 'Sa izabranima...';
$string['batchoperationunlock'] = 'otključajte predate radove';
$string['batchsetallocatedmarker'] = 'Postavi markere za {$a} odabrane korisnik(e).';
$string['batchsetmarkingworkflowstateforusers'] = 'Postavi bazu za markere za {$a} odabrane korisnik(e).';
$string['blindmarking'] = 'Slučajno označi';
$string['blindmarking_help'] = 'Slučajno označavanje sakriva indentitet studenata označivačima. Postavke slučajnog označavanja će biti zatvorene nakon sto se prosljeđivanje ili ocjena utvrdi u zavisnosti od zadatka.';
$string['changegradewarning'] = 'Zadatak je ocjenio sve predane radove a promjena ocjene neće automatski utvrditi ocjene radova, Morate ocjeniti ponovno ocjeniti sve predane radove ukoliko želite da promjenite ocjenu.';
$string['choosegradingaction'] = 'Ocjeni';
$string['choosemarker'] = 'Izaberi...';
$string['chooseoperation'] = 'Odaberi operaciju';
$string['comment'] = 'Komentar';
$string['completionsubmit'] = 'Studenti moraju proslati radi kako bi završili ovu aktivnost';
$string['configshowrecentsubmissions'] = 'Svi mogu da vide obavještenje o predanim radovima u izvještaju o skorašnjim aktivnostima.';
$string['confirmbatchgradingoperation'] = 'Da li ste sigurni da želite da {$a->operation}  za {$a->count} studenta?';
$string['confirmsubmission'] = 'Da li ste sigurni da želite da predate svoj rad na ocjenjivanje? Više nećete moći da ga mjenjate.';
$string['conversionexception'] = 'Nije moguće konvertovati rad. Izuzetak je bio: {$a}.';
$string['couldnotconvertgrade'] = 'Nije moguće konvertovati ocjenu zadatka za korisnika {$a}.';
$string['couldnotconvertsubmission'] = 'Nije moguće konvertovati predati rad za korisnika {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nije moguće kreirati modul kursa';
$string['couldnotcreatenewassignmentinstance'] = 'Nije moguće kreirati novu instancu zadatka';
$string['couldnotfindassignmenttoupgrade'] = 'Nije moguće naći staru instancu zadatka za nadogradnju';
$string['currentattempt'] = 'Ovo je {$a} pokušaj.';
$string['currentattemptof'] = 'Ovo je {$a->attemptnumber} pokušaj ( {$a->maxattempts} dozvoljeno ).';
$string['currentgrade'] = 'Trenutna ocjena u knjizi ocjena';
$string['cutoffdate'] = 'Cut-off datum';
$string['cutoffdatefromdatevalidation'] = 'Datum \'Cut-off\' mora biti nakon dozvoljenog datuma za proslijeđivanje radova.';
$string['cutoffdate_help'] = 'Ako je omogućeno, radovi neće biti prihvaćeni koji su proslijeđeni nakon ovog datuma, bez da se omogući dodatno vrijeme.';
$string['cutoffdatevalidation'] = '\'Cut-off\' datum ne može biti postavljen prije krajnjeg roka za predaju.';
$string['defaultsettings'] = 'Osnovne postavke zadatka';
$string['defaultsettings_help'] = 'Ove postavke definišu  "osnovne" postavke za sve nove zadatke.';
$string['defaultteam'] = 'Zadana grupa';
$string['deleteallsubmissions'] = 'Obriši sva podnošenja';
$string['description'] = 'Opis';
$string['downloadall'] = 'Preuzmi sve predate radove';
$string['duedate'] = 'Datum dospjeća';
$string['duedate_help'] = 'Ovaj datum predstavlja krajnji rok za predaju zadatka. Ako je dozvoljena naknadna predaja, svi zadaci predani nakon ovog datuma biće obilježeni kao zakašnjeli. Kako bi onemogućili pradaju radova nakon određenog datuma, koristite \'Cut off\' datum';
$string['duedateno'] = 'Datum nedospjeća';
$string['duedatereached'] = 'Krajnji rok za ovaj zadatak je sada istekao';
$string['duedatevalidation'] = 'Krajnji rok mora biti nakon datuma od kojeg je dozvoljena predaja';
$string['editaction'] = 'Akcije...';
$string['editingstatus'] = 'Izmjeni status';
$string['editsubmission'] = 'Izmjeni moj rad';
$string['editsubmission_help'] = 'Napravi izmejne u predatom zadatku';
$string['enabled'] = 'Omogućeno';
$string['errornosubmissions'] = 'Nema predatih radova za preuzimanje';
$string['errorquickgradingvsadvancedgrading'] = 'Ocjene nisu sačuvane zato što ovaj zadatak trenutno koristi napredno ocjenjivanje';
$string['errorrecordmodified'] = 'Ocjene nisu sačuvane zato što je neko izmijenio jedan ili više zapisa nakon što ste učitali stranicu.';
$string['event_all_submissions_downloaded'] = 'U toku je download svih predani zadataka';
$string['event_assessable_submitted'] = 'Zadata je predan';
$string['event_extension_granted'] = 'Produženje je odobreno';
$string['event_identities_revealed'] = 'Identiteti su otkriveni';
$string['event_marker_updated'] = 'Izmjene na markeru su učinjene.';
$string['event_statement_accepted'] = 'Korisnik je prihvatio uslove predaje rada.';
$string['event_submission_duplicated'] = 'Korisnik je duplirao svoju predaju,';
$string['event_submission_graded'] = 'Predani rad je ocjenjen.';
$string['event_submission_locked'] = 'Predaja radova je zatvorena za korisnike.';
$string['event_submission_status_updated'] = 'Status predatog rada je izmjenjen.';
$string['event_submission_unlocked'] = 'Predaja rada je dozvoljena za korisnika.';
$string['event_submission_updated'] = 'Korisnik je sačuvao predaju.';
$string['event_workflow_state_updated'] = 'Status baze (za markere) je izmjenjen.';
$string['extensionduedate'] = 'Produženje zakasnjelog rada';
$string['extensionnotafterduedate'] = 'Datum produženja mora biti nakon datuma zakašnjena';
$string['extensionnotafterfromdate'] = 'Datum produženja mora biti nakon dozvoljenog datuma za salnje radova';
$string['feedback'] = 'Povratna sprega';
$string['feedbackavailablehtml'] = '{$a->username} je poslao/la povratne informacije na rad koji ste predali za zadatak \'<i>{$a->assignment}</i>\'<br /><br /> Povratne informacije možete pogledati pridružene vašem <a href="{$a->url}">predatom radu</a>.';
$string['feedbackavailablesmall'] = '{$a->username} je dao/la povratne informacije za zadatak {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} je poslao/la povratne informacije na rad koji ste predali za zadatak \'{$a->assignment}\'

Povratne informacije su pridružene vašem radu i možete ih pogledati  na:

{$a->url}';
$string['feedbackplugin'] = 'Dodatak za povratne informacije';
$string['feedbackpluginforgradebook'] = 'Dodatak za povratne informacije koji će prebacivati komentare u knjigu ocjena';
$string['feedbackpluginforgradebook_help'] = 'Samo jedan dodatak za povratne informacije zadatka može da prebaci povratne informacije u knjigu ocjena.';
$string['feedbackplugins'] = 'Dodaci za povratne informacije';
$string['feedbacksettings'] = 'Podešavanja povratnih informacija';
$string['feedbacktypes'] = 'Tipovi povratnih informacija';
$string['filesubmissions'] = 'Predaja datoteka';
$string['filter'] = 'Filter';
$string['filternone'] = 'Nema filtera';
$string['filterrequiregrading'] = 'Zahtijeva ocjenjivanje';
$string['filtersubmitted'] = 'Predano';
$string['gradeabovemaximum'] = 'Ocjena mora da bude manja od ili jednaka {$a}';
$string['gradebelowzero'] = 'Ocjena mora biti veća od ili jednaka nuli';
$string['graded'] = 'Ocijenjeno';
$string['gradedby'] = 'Ocijenio/la';
$string['gradedon'] = 'Ocijenjeno';
$string['gradeoutof'] = 'Ocjena od {$a}';
$string['gradeoutofhelp'] = 'Ocjena';
$string['gradeoutofhelp_help'] = 'Ovdje unesite ocjenu za rad studenta. Možete uključiti decimale.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} je ažurirao/la svoje rješenje zadatka <i>\'{$a->assignment}\' u {$a->timeupdated}</i><br /><br /> Rješenje je <a href="{$a->url}">dostupno na web sajtu</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} je ažurirao/la svoj rad za zadatak za zadatak {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} je ažurirao/la svoj rad za zadatak \'{$a->assignment}\' u {$a->timeupdated} Rad je dostupan na sljedećoj adresi: {$a->url}';
$string['gradestudent'] = 'Ocjeni studenta: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['grading'] = 'Ocjenjivanje';
$string['gradingmethodpreview'] = 'Kriterij ocjenjivanja';
$string['gradingoptions'] = 'Opcije';
$string['gradingstatus'] = 'Status ocjenjivanja';
$string['gradingsummary'] = 'Rezime ocjenjivanja';
$string['grantextension'] = 'Dozvoli produženje';
$string['grantextensionforusers'] = 'Dozvoli produženje za {$a} studente';
$string['groupsubmissionsettings'] = 'Postavke grupne predaje radova';
$string['hiddenuser'] = 'Učesnik';
$string['hideshow'] = 'Sakrij/Prikaži';
$string['instructionfiles'] = 'Datoteke sa instrukcijama';
$string['invalidfloatforgrade'] = 'Nije moguće razumjeti ocjenu koja je ponuđena: {$a}';
$string['invalidgradeforscale'] = 'Ocjena koja je ponuđenanije ispravna za trenutnu skalu';
$string['lastmodifiedgrade'] = 'Posljednje izmjene (ocjena)';
$string['lastmodifiedsubmission'] = 'Posljednja izmena (predati rad)';
$string['latesubmissions'] = 'Zakašnjeli radovi';
$string['latesubmissionsaccepted'] = 'Samo studenti kojima je omogućen produženi rok mogu proslijediti radove';
$string['locksubmissionforstudent'] = 'Spriječi dalju predaju radova za studenta : (id={$a->id}, ime i prezime={$a->fullname}).';
$string['locksubmissions'] = 'Zaključaj predate radove';
$string['manageassignfeedbackplugins'] = 'Upravljanje dodacima za povratne informacije';
$string['manageassignsubmissionplugins'] = 'Upravljanje dodacima za predaju radova';
$string['markerfilter'] = 'Filter markera';
$string['markingallocation'] = 'Koristi dodijeljivanje markera';
$string['markingallocation_help'] = 'Ako je omogućeno zajedno sa bazom markera, markeri mogu biti dodijeljeni specifičnom studentu.';
$string['markingworkflow'] = 'Koristi bazu markera';
$string['markingworkflowstate'] = 'Ocjenjuj stanje  baze';
$string['markingworkflowstateinmarking'] = 'U procesu ocjene';
$string['markingworkflowstateinreview'] = 'U procesu pregleda';
$string['markingworkflowstatenotmarked'] = 'Nije ocjenjeno';
$string['markingworkflowstatereadyforrelease'] = 'Spremno za objavu';
$string['markingworkflowstatereadyforreview'] = 'Ocjenjivanje završeno';
$string['markingworkflowstatereleased'] = 'Ovjavljeno';
$string['maxgrade'] = 'Najveća ocjena';
$string['messageprovider:assign_notification'] = 'Obavještenje o zadatku';
$string['modulename'] = 'Zadatak';
$string['modulename_help'] = 'Modul aktivnosti „Zadatak“ daje mogućnost nastavniku da polaznicima zadaje zadatke, prikuplja njihove radove, ocjenjuje ih, kao i da im šalje povratne informacije. Studenti, kao svoj rad, mogu da predaju različite digitalne sadržaje (datoteke), kao što su tekstualni dokumenti, računske tabele, slike, prezentacije ili audio i video klipovi. Alternativno, ili kao dodatak prethodnom, zadatak može da traži od studenata da tekst unesu direktno u tekst editor. Zadatak, također, može da se koristi kao podsjetnik studentima za „stvarni“ zadatak koji moraju da urade „offline“, van sajta, poput recimo nekog umjetničkog rada, crteža itd, a da se pri tome od njih ne zahtijeva slanje bilo kakvog digitalnog sadržaja. Prilikom pregledanja zadataka, nastavnici mogu da ostavljaju komentare, povratne informacije i postavljaju datoteke, kao što su pregledani i obilježeni studentski radovi sa komentarima, zasebni dokumenati sa komentarima ili povratne informacije u govornom tj. audio formatu. Zadaci se ocjenjuju brojčanom, ili namjenski prilagođenom, skalom za ocjenjivanje, ili, korištenjem naprednih metoda ocjenjivanja kao što su rubrike. Završne ocjene se zapisuju u knjigu ocjena.';
$string['modulenameplural'] = 'Zadaci';
$string['mysubmission'] = 'Moji predani radovi';
$string['newsubmissions'] = 'Zadaci su predani';
$string['nofiles'] = 'Nema datoteka';
$string['nograde'] = 'Nema ocjene';
$string['nolatesubmissions'] = 'Nema zakašnjelih radova koji su prihvaćeni';
$string['nomoresubmissionsaccepted'] = 'Prosljeđivanje radova se više ne prihvata';
$string['noonlinesubmissions'] = 'Ovaj zadatak ne traži od vas da predate bilo što online';
$string['nosavebutnext'] = 'Sljedeći';
$string['nosubmission'] = 'Za ovaj zadatak još ništa nije predano';
$string['nosubmissionsacceptedafter'] = 'Radovi neće biti prihvćeni nakon';
$string['notgraded'] = 'Nije ocjenjeno';
$string['notgradedyet'] = 'Još nije ocjenjeno';
$string['notifications'] = 'Obavještenja';
$string['notsubmittedyet'] = 'Još nije predano';
$string['nousersselected'] = 'Nije izabran niti jedan student';
$string['numberofdraftsubmissions'] = 'Nacrti';
$string['numberofparticipants'] = 'Učesnici';
$string['numberofsubmissionsneedgrading'] = 'Potrebno ocjeniti';
$string['numberofsubmittedassignments'] = 'Predano';
$string['numberofteams'] = 'Grupe';
$string['offline'] = 'Ne traži se online predaja rada';
$string['open'] = 'Otvoreno';
$string['outlinegrade'] = 'Ocjena: {$a}';
$string['overdue'] = '<font color="red">Krajnji rok za predaju rada je istekao prije: {$a}</font>';
$string['page-mod-assign-view'] = 'Glavna stranica modula \'Zadatak';
$string['page-mod-assign-x'] = 'Bilo koja stranica modula \'Zadatak';
$string['participant'] = 'Učesnik';
$string['pluginadministration'] = 'Administracija zadataka';
$string['pluginname'] = 'Zadatak';
$string['preventsubmissions'] = 'Spriječi korisnika da više ne predaje svoje radove za ovaj zadatak.';
$string['preventsubmissionsshort'] = 'Spriječi izmjene predanih radova';
$string['previous'] = 'Prethodni';
$string['quickgrading'] = 'Brzo ocjenjivanje';
$string['quickgradingchangessaved'] = 'Promjene ocjena su sačuvane';
$string['quickgrading_help'] = 'Brzo ocjenjivanje vam dozvoljava da dodijelite ocjene (i ishode) direktno u tabeli predanih zadataka. Brzo ocjenjivanje nije kompatibilno sa naprednim ocjenjivanjem i ne preporučuje se kada postoji više ocjenjivača.';
$string['quickgradingresult'] = 'Brzo ocjenjivanje';
$string['recordid'] = 'Identifikator';
$string['requireallteammemberssubmit'] = 'Zahtjevaj predaju rada svih članova grupe';
$string['requireallteammemberssubmit_help'] = 'Ako omogućeno, svi članovi grupe moraju kliknuti na dugme za proslijeđivanje zadatka inače se neće smatrati kao validno. Ako je onemogućeno, bilo koji član grupe da klikne na proslijeđivanje će se smatrati kao validno i odabir cijele grupe.';
$string['requiresubmissionstatement'] = 'Zahtjevaj da svi studenti prihvate uslove proslijeđivanja';
$string['requiresubmissionstatement_help'] = 'Zahtjevaj da svi studenti prihvate uslove proslijeđivanja za sve zadatke vezane za ovaj Moodle sajt. Ako ova opcija nije omogućena, onda uslovi prosljeđivanja je moguće promjeniti u postavkama svakog zadatka.';
$string['revealidentities'] = 'Otkrij identitete studenata';
$string['revealidentitiesconfirm'] = 'Da li ste sigurni da želite da otkrijete identitet studenata za ovaj zadatak? Ova operacija se ne može promjeniti. Nakon što su identiteti studenata otkriveni, ocjene će biti upisane u knjigu ocjena.';
$string['reverttodraft'] = 'Vrati rad u status nacrta';
$string['reverttodraftforstudent'] = 'Vrati rad u status nacrta za studenta: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['reverttodraftshort'] = 'Vrati rad u status nacrta';
$string['reviewed'] = 'Pregledano';
$string['saveallquickgradingchanges'] = 'Sačuvaj sve promjene brzog ocjenjivanja';
$string['savechanges'] = 'Sačuvaj promjene';
$string['savenext'] = 'Sačuvaj i prikaži sljedeći';
$string['scale'] = 'Omjer';
$string['selectlink'] = 'Odaberi...';
$string['selectuser'] = 'Odaveri {$a}';
$string['sendlatenotifications'] = 'Obavjesti ocjenjivače o radovima koji su predani sa zakašnjenjem';
$string['sendlatenotifications_help'] = 'Ako je ova opcija omogućena, ocjenjivači (obično predavači) će dobiti poruku kada god student rad preda sa zakašnjenjem. Način slanja poruke se može podesiti.';
$string['sendnotifications'] = 'Obavijesti ocjenjivače o predanim radovima';
$string['sendnotifications_help'] = 'Ako je ova opcija omogućena, ocjenjivači (obično predavači) će dobiti poruku kad god student rad preda ranije, na vrijeme i sa zakašnjenjem. Način slanja poruke se može podesiti.';
$string['sendsubmissionreceipts'] = 'Pošalji studentima potvrdu o predanom radu';
$string['sendsubmissionreceipts_help'] = 'Ovo omogućava slanje potvrde o predanom radu. Studenti će primiti obaviještenje svaki put kada uspješno predaju rad.';
$string['settings'] = 'Podešavanja zadatka';
$string['showrecentsubmissions'] = 'Prikaži skoro predane radove';
$string['submission'] = 'Predati rad';
$string['submissiondrafts'] = 'Zahtijevaj da studenti kliknu na dugme "Predaj';
$string['submissiondrafts_help'] = 'Ako je ova opcija omogućena studenti će morati da kliknu na dugme \'Predaj\' kako bi svoj rad proglasili konačnim. Ovo omogućava studentima da unutar sistema čuvaju verziju nacrta svog rada. Ako se ovo podešavanje sa "Ne" promjeni na "Da" nakon što su studenti predali svoje radove te verzije njihovih radove će biti smatrane konačnim.';
$string['submissioneditable'] = 'Studenti mogu promjeniti svoje radove';
$string['submissionempty'] = 'Nište nije predano';
$string['submissionnoteditable'] = 'Studenti ne mogu izmjeniti svoje radove';
$string['submissionnotready'] = 'Ovaj zadatak nije spreman za predaju radova:';
$string['submissionplugins'] = 'Dodaci za predaju radova';
$string['submissionreceipthtml'] = 'Predali ste svoj rad za zadatak \'<i>{$a->assignment}</i>\'<br /><br /> Možete vidjeti status svog <a href="{$a->url}">predanog rada</a>.';
$string['submissionreceipts'] = 'Pošalji potvrdu o predanom radu';
$string['submissionreceiptsmall'] = 'Predali ste svoj rad za zadatak {$a->assignment}';
$string['submissionreceipttext'] = 'Predali ste svoj rad za zadatak \'{$a->assignment}</i>\' Možete vidjeti status svog rada na sljedećoj adresi: {$a->url}';
$string['submissions'] = 'Predani radovi';
$string['submissionsclosed'] = 'Predaja radova je zatvorena';
$string['submissionsettings'] = 'Podešavanja za predaju rada';
$string['submissionslocked'] = 'Ovaj zadatak ne prihvata predaju radova';
$string['submissionslockedshort'] = 'Promjene predanih radova nisu dozvoljene';
$string['submissionsnotgraded'] = 'Neocijenjeni radovi: {$a}';
$string['submissionstatement'] = 'Uslovi predaje rada';
$string['submissionstatementacceptedlog'] = 'Uslovi predaje rada su prihvaćeni od strane korisnika {$a}';
$string['submissionstatementdefault'] = 'Ovaj rad je moje dijelo, izuzev tamo gdje sam označio/la da koristim izvore tj, rad drugih ljudi.';
$string['submissionstatement_help'] = 'Potvrda uslova predaje za rad';
$string['submissionstatus'] = 'Status predatog rada';
$string['submissionstatus_'] = 'Nema predanih radova';
$string['submissionstatus_draft'] = 'Nacrt rada (nije predano)';
$string['submissionstatusheading'] = 'Status predanog rada';
$string['submissionstatus_marked'] = 'Ocijenjeno';
$string['submissionstatus_new'] = 'Novi predani rad';
$string['submissionstatus_submitted'] = 'Predano za ocjenjivanje';
$string['submissionteam'] = 'Grupa';
$string['submitaction'] = 'Predaj';
$string['submitassignment'] = 'Predaj zadatak';
$string['submitassignment_help'] = 'Onog trenutka kada predate ovaj zadatak više nećete moći da pravite bilo kakve promjene';
$string['submitted'] = 'Predano';
$string['submittedearly'] = 'Zadatak je predan {$a} ranije';
$string['submittedlate'] = 'Zadatak je predan {$a} kasnije';
$string['submittedlateshort'] = '{$a} kasnije';
$string['teamsubmission'] = 'Studenti predaju u grupama';
$string['teamsubmissiongroupingid'] = 'Grupiranje za grupe studenata';
$string['teamsubmission_help'] = 'Ako je omogućeno, studenti će biti podjeljeni u grupe na osnovu zadanog seta grupa preloženih za  prilagođene grupe. Grupna predaja radova će biti podjeljena između članova grupe i članovi grupe će imati uvid u promjene koje međusobono izvršavaju.';
$string['teamsubmissionstatus'] = 'Status grupne predaje radova';
$string['textinstructions'] = 'Uputstva za zadatak';
$string['timemodified'] = 'Posljednje izmjene';
$string['timeremaining'] = 'Prestalo vrijeme';
$string['unlocksubmissionforstudent'] = 'Dozvoli predaju radova za studenta: (id={$a->id}, ime i prezime={$a->fullname}).';
$string['unlocksubmissions'] = 'Otključaj predane radove';
$string['updategrade'] = 'Ažuriraj ocjenu';
$string['updatetable'] = 'Sačuvaj i ažuriraj tabelu';
$string['upgradenotimplemented'] = 'Nadogradnja nije implementirana u dodatku ({$a->type} {$a->subtype})';
$string['usergrade'] = 'Ocjena studenta';
$string['userswhoneedtosubmit'] = 'Korisnici koji trebaju predat: {$a}';
$string['viewfeedback'] = 'Pogledajte povratne informacije';
$string['viewfeedbackforuser'] = 'Pogledajte povratne informacije za korisnika {$a}';
$string['viewfull'] = 'Pregledaj';
$string['viewfullgradingpage'] = 'Otvorite stranicu za ocjenjivanje u punom formatu kako biste dali povratne informacije';
$string['viewgradebook'] = 'Pogledajte knjigu ocjena';
$string['viewgrading'] = 'Pogledaj/ocjeni sve predane radove';
$string['viewgradingformforstudent'] = 'Pogledajte stranicu za ocjenjivanje za studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Pogledajte stranicu za predaju sopstvenog rada';
$string['viewownsubmissionstatus'] = 'Pogledajte stranicu statusa vlastitog rada';
$string['viewrevealidentitiesconfirm'] = 'Pogledaj stranicu za potvrdu otkrivanja identiteta studenata';
$string['viewsubmission'] = 'Pogledaj predani rad';
$string['viewsubmissionforuser'] = 'Pogledaj predani rad za korisnika: {$a}';
$string['viewsubmissiongradingtable'] = 'Pogledaj tabelu ocjena predanih zadataka.';
$string['viewsummary'] = 'Pregledaj sažetak';
