<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Podeu previsualitzar aquest qüestionari, però no podrieu contestar-lo perquè:';
$string['action'] = 'Acció';
$string['activityoverview'] = 'Teniu qüestionaris per respondre';
$string['adaptive'] = 'Mode adaptatiu';
$string['adaptive_help'] = 'Si s\'activa, es permeten múltiples respostes a una pregunta en el mateix intent de resoldre el qüestionari. Així, per exemple, si una resposta es marca com a incorrecta, es permetrà que l\'alumne faci un altre intent de respondre immediatament. De totes maneres, depenent del paràmetre «Aplica penalitzacions», en general, es restarà una penalització per cada intent equivocat.';
$string['addaquestion'] = 'Afegeix una pregunta ...';
$string['addarandomquestion'] = 'Afegeix una pregunta aleatòriament ...';
$string['addarandomquestion_help'] = 'Quan s\'afegeix una pregunta aleatòria, això dóna com a resultat una pregunta escollida a l\'atzar de la categoria que s\'insereix al qüestionari. Això vol dir que és probable que diferents estudiants rebin una selecció diferent de preguntes. A més, quan un qüestionari permet intents múltiples, aleshores és probable que cada intent incorpori una nova selecció de preguntes.';
$string['adddescriptionlabel'] = 'Afegeix una descripció/etiqueta';
$string['addingquestion'] = 'S\'està afegint una pregunta';
$string['addingquestions'] = 'Des d\'aquesta part de la pàgina podeu gestionar la vostra base de dades de preguntes. Les preguntes s\'emmagatzemen en categories per tal de mantenir-les organitzades, i es poden utilitzar en qualsevol qüestionari del vostre curs o fins i tot en altres cursos si trieu de «publicar-les». <br /><br />Després de seleccionar o crear una categoria podreu crear o editar preguntes. Podeu seleccionar qualsevol d\'aquestes preguntes per afegir-la al qüestionari a l\'altra part de la pàgina.';
$string['addmoreoverallfeedbacks'] = 'Afegeix més camps de retroacció';
$string['addnewgroupoverride'] = 'Afegeix una excepció de grup';
$string['addnewpagesafterselected'] = 'Afegeix més pàgines després de les preguntes seleccionades';
$string['addnewquestionsqbank'] = 'Afegeix preguntes a la  categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Afegeix una excepció d\'usuari';
$string['addpagehere'] = 'Afegeix una pàgina aquí';
$string['addquestion'] = 'Afegeix una pregunta';
$string['addquestions'] = 'Afegeix preguntes';
$string['addquestionstoquiz'] = 'Afegeix preguntes al qüestionari actual';
$string['addrandom'] = 'Afegeix {$a} preguntes aleatòries';
$string['addrandom1'] = '<< Afegeix';
$string['addrandom2'] = 'preguntes aleatòries';
$string['addrandomfromcategory'] = 'Afegeix preguntes aleatòries de la categoria:';
$string['addrandomquestion'] = 'Afegeix una pregunta aleatòria';
$string['addrandomquestiontoquiz'] = 'Afegeix una pregunta aleatòria al qüestionari';
$string['addselectedtoquiz'] = 'Afegeix la selecció al qüestionari';
$string['addtoquiz'] = 'Afegeix al qüestionari';
$string['affectedstudents'] = '{$a} afectats';
$string['aftereachquestion'] = 'Després d\'afegir cada pregunta';
$string['afternquestions'] = 'Després d\'afegir {$a} preguntes';
$string['age'] = 'edat';
$string['allattempts'] = 'Tots els intents';
$string['allinone'] = 'Sense límit';
$string['allowreview'] = 'Permet la revisió';
$string['alreadysubmitted'] = 'Sembla que ja heu tramès aquest intent';
$string['alternativeunits'] = 'Unitats alternatives';
$string['alwaysavailable'] = 'Disponible sempre';
$string['analysisoptions'] = 'Opcions d\'anàlisi';
$string['analysistitle'] = 'Taula d\'anàlisi d\'elements';
$string['answer'] = 'Resposta';
$string['answered'] = 'Contestades';
$string['answerhowmany'] = 'Una resposta o múltiples respostes';
$string['answers'] = 'Respostes';
$string['answersingleno'] = 'Es permeten múltiples respostes';
$string['answersingleyes'] = 'Només una resposta';
$string['answertoolong'] = 'La resposta és massa llarga després de la línia {$a} (màxim 255 caràcters)';
$string['aon'] = 'Format AON';
$string['areyousureremoveselected'] = 'Segur que voleu eliminar totes les preguntes seleccionades?';
$string['asshownoneditscreen'] = 'Tal com apareix a la pantalla d\'edició';
$string['attempt'] = 'Intent {$a}';
$string['attemptalreadyclosed'] = 'Aquest intent ja està tancat.';
$string['attemptclosed'] = 'Aquest intent encara s\'ha d\'acabar.';
$string['attemptduration'] = 'Temps emprat';
$string['attemptedon'] = 'Intentat el';
$string['attempterror'] = 'No podeu contestar aquest qüestionari en aquest moment perquè: {$a}';
$string['attemptfirst'] = 'Primer intent';
$string['attemptincomplete'] = 'Aquest intent ({$a}) encara no s\'ha completat.';
$string['attemptlast'] = 'Darrer intent';
$string['attemptnumber'] = 'Intent';
$string['attemptquiznow'] = 'Contesta el qüestionari ara';
$string['attempts'] = 'Intents';
$string['attemptsallowed'] = 'Intents permesos';
$string['attemptsdeleted'] = 'S\'han suprimit els intents del qüestionari';
$string['attemptselection'] = 'Seleccioneu quins intents voleu analitzar per usuari';
$string['attemptsexist'] = 'Ja no podeu afegir ni suprimir preguntes.';
$string['attemptsnum'] = 'Intents: {$a}';
$string['attemptsnumthisgroup'] = 'Intents: {$a->total} ({$a->group} d\'aquest grup)';
$string['attemptsnumyourgroups'] = 'Intents: {$a->total} ({$a->group} dels vostres grups)';
$string['attemptsonly'] = 'Mostra només els estudiants amb intents';
$string['attemptstate'] = 'Estat';
$string['attemptstillinprogress'] = 'Intent encara en curs';
$string['attemptsunlimited'] = 'Intents il·limitats';
$string['autosaveperiod'] = 'Període d\'autodesament';
$string['autosaveperiod_desc'] = 'Les respostes dels estudiants es poden desar automàticament cada pocs minuts durant els intents dels qüestionaris. Això implica un compromís: Desar les respostes augmenta la càrrega del servidor, però redueix la possibilitat que els estudiants perdin la feina.';
$string['back'] = 'Torna a la previsualització de la pregunta';
$string['backtocourse'] = 'Torna al curs';
$string['backtoquestionlist'] = 'Torna a la llista de preguntes';
$string['backtoquiz'] = 'Torna a l\'edició del qüestionari';
$string['basicideasofquiz'] = 'Idees bàsiques sobre la preparació de qüestionaris';
$string['bestgrade'] = 'Millor nota';
$string['bothattempts'] = 'Mostra els estudiants amb intents i sense intents';
$string['browsersecurity'] = 'Seguretat del navegador';
$string['browsersecurity_help'] = 'Si es tria «Finestra emergent amb algunes seguretats JavaScript»:

1) El qüestionari només començarà si l\'estudiant té un navegador web amb l\'opció de JavaScript activada

2) El qüestionari apareix en una finestra emergent que cobreix tota la pantalla i no té controls de navegació

3) S\'impedeix que els estudiants, en la mesura del que sigui possible, puguin utilitzar recursos com ara el de copiar i enganxar';
$string['calculated'] = 'Calculada';
$string['calculatedquestion'] = 'Pregunta calculada no permesa a la línia {$a}. S\'ignorarà aquesta pregunta.';
$string['cannotcreatepath'] = 'No es pot crear el camí ({$a})';
$string['cannoteditafterattempts'] = 'No podeu afegir ni treure preguntes perquè s\'han fet intents. ({$a})';
$string['cannotfindprevattempt'] = 'No s\'ha trobat cap intent anterior en què basar-se.';
$string['cannotfindquestionregard'] = 'No s\'han pogut obtenir preguntes per requalificar.';
$string['cannotinsert'] = 'No es pot inserir la pregunta';
$string['cannotinsertrandomquestion'] = 'No s\'ha pogut inserir una nova pregunta aleatòria.';
$string['cannotloadquestion'] = 'No es poden carregar les opcions de la pregunta';
$string['cannotloadtypeinfo'] = 'No es pot trobar informació específica sobre aquest tipus de pregunta';
$string['cannotopen'] = 'No es pot obrir el fitxer d\'exportació ({$a})';
$string['cannotrestore'] = 'No es pot restaurar la sessió';
$string['cannotreviewopen'] = 'No podeu revisar aquest intent, encara està obert.';
$string['cannotsavelayout'] = 'No es pot desar el format';
$string['cannotsavenumberofquestion'] = 'No es pot desar el nombre de preguntes per pàgina';
$string['cannotsavequestion'] = 'No es pot desar la llista de preguntes';
$string['cannotsetgrade'] = 'No es pot establir un màxim nou de qualificació per al qüestionari.';
$string['cannotsetsumgrades'] = 'No s\'ha pogut establir la suma de qualificacions';
$string['cannotstartgradesmismatch'] = 'No es pot començar un intent del qüestionari. El qüestionari està configurat per ser qualificat fora de {$a->grade}, però cap de les preguntes té una qualificació. Podeu corregir-ho a la pàgina «Edita el qüestionari».';
$string['cannotstartmissingquestion'] = 'No es pot començar un intent d\'aquest qüestionari. La definició inclou una pregunta que no existeix.';
$string['cannotstartnoquestions'] = 'No es pot començar un intent d\'aquest qüestionari. Encara no s\'ha configurat. No s\'hi han afegit preguntes.';
$string['cannotwrite'] = 'No es pot escriure al fitxer d\'exportació ({$a})';
$string['caseno'] = 'No distingeix majúscules i minúscules';
$string['casesensitive'] = 'Distingeix majúscules';
$string['caseyes'] = 'Distingeix majúscules i minúscules';
$string['categories'] = 'Categories';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'S\'ha afegit la categoria «{$a}»';
$string['categorydeleted'] = 'S\'ha suprimit la categoria «{$a}»';
$string['categorynoedit'] = 'No teniu privilegis d\'edició en la categoria «{$a}».';
$string['categoryupdated'] = 'La categoria s\'ha actualitzat amb èxit';
$string['close'] = 'Tanca finestra';
$string['closebeforeopen'] = 'No s\'ha pogut actualitzar el qüestionari. Heu especificat una data de finalització anterior a la data d\'inici';
$string['closed'] = 'Tancat';
$string['closepreview'] = 'Tanca la previsualització';
$string['closereview'] = 'Tanca la revisió';
$string['comment'] = 'Comentari';
$string['commentorgrade'] = 'Fes un comentari o canvia la qualificació';
$string['comments'] = 'Comentaris';
$string['completedon'] = 'Completat el';
$string['configadaptive'] = 'Si marqueu el Sí en aquesta opció l\'estudiant podrà intentar respondre diverses vegades una pregunta durant el mateix intent.';
$string['configattemptsallowed'] = 'Restricció del nombre d\'intents de què disposen els estudiants per resoldre el qüestionari.';
$string['configdecimaldigits'] = 'Nombre de dígits que es mostraran després del punt decimal en visualitzar les puntuacions.';
$string['configdecimalplaces'] = 'Nombre de dígits que es mostraran després del punt decimal en visualitzar les puntuacions del qüestionari.';
$string['configdecimalplacesquestion'] = 'Nombre de dígits que es mostraran després del punt decimal en visualitzar les puntuacions de cada pregunta.';
$string['configdelay1'] = 'Si establiu un retard de temps, l\'estudiant s\'haurà d\'esperar aquest temps abans d\'intentar tornar a resoldre el qüestionari després del primer intent.';
$string['configdelay1st2nd'] = 'Si establiu un retard de temps aquí, l\'estudiant no pot iniciar el seu segon intent fins que hagi passat aquest temps des del final del primer intent.';
$string['configdelay2'] = 'Si establiu un retard de temps aquí, aleshores l\'estudiant s\'ha d\'esperar aquest temps abans de poder emprendre el tercer intent o intents posteriors.';
$string['configdelaylater'] = 'Si establiu un retard de temps aquí, l\'estudiant no pot començar el tercer intent, el quart intent... fins que hagi passat aquest temps des del final de l\'intent anterior.';
$string['configeachattemptbuildsonthelast'] = 'Si es permeten intents múltiples, aleshores cada intent nou conté els resultats de l\'intent anterior.';
$string['configgrademethod'] = 'Si es permeten intents múltiples, mètode que s\'ha d\'utilitzar per calcular la qualificació final de l\'estudiant per al qüestionari.';
$string['configintro'] = 'Els valors que establiu aquí defineixen els valors per defecte que s\'utilitzen al formulari de creació de qüestionaris. També podreu determinar quins paràmetres es consideren avançats.';
$string['configmaximumgrade'] = 'La qualificació per defecte a la qual s\'escala el qüestionari.';
$string['confignavmethod'] = 'En la navegació lliure, les preguntes poden contestar-se en qualsevol ordre utilitzant la navegació. En la seqüencial, les preguntes han de contestar-se seguint una seqüència estricta.';
$string['confignewpageevery'] = 'Quan s\'afegeixin preguntes al qüestionari, els salts de pàgina s\'inseriran automàticament seguint aquest paràmetre.';
$string['configoutcomesadvanced'] = 'Si aquesta opció s\'activa, les competències en el formulari d\'edició del qüestionari esdevindran paràmetres avançats.';
$string['configpenaltyscheme'] = 'Penalització per a cada mala resposta en mode adaptatiu.';
$string['configpopup'] = 'Força que l\'intent s\'obri en una finestra emergent, i utilitza trucs de JavaScript per intentar restringir accions de copiar i enganxar, etc. durant els intents del qüestionari.';
$string['configrequirepassword'] = 'Els estudiants han d\'introduir aquesta contrasenya abans de poder començar el qüestionari.';
$string['configrequiresubnet'] = 'Els estudiants només poden intentar la resolució del qüestionari des d\'aquests ordinadors.';
$string['configreviewoptions'] = 'Aquestes opcions controlen la informació que poden veure els usuaris mentre revisen un intent del qüestionari o se\'n miren els informes.';
$string['configshowblocks'] = 'Mostra els blocs mentre es resol el qüestionari.';
$string['configshowuserpicture'] = 'Mostra la fotografia de l\'usuari mentre es resol.';
$string['configshufflequestions'] = 'Si activeu aquesta opció, l\'ordre de les preguntes del qüestionari es mesclarà aleatòriament cada vegada que un estudiant l\'intenti resoldre.';
$string['configshufflewithin'] = 'Si activeu aquesta opció, les parts que componen cada pregunta es barrejaran aleatòriament cada vegada que un estudiant comenci un intent de resoldre aquest qüestionari, sempre que aquesta opció també estigui activada en els paràmetres de la pregunta.';
$string['configtimelimit'] = 'Límit de temps per defecte en minuts. 0 significa sense límit.';
$string['configtimelimitsec'] = 'Límit de temps per defecte en minuts. 0 significa sense límit.';
$string['configurerandomquestion'] = 'Configura la pregunta';
$string['confirmclose'] = 'Una vegada enviat ja no podreu canviar les respostes d\'aquest intent.';
$string['confirmserverdelete'] = 'Esteu segur que voleu suprimir el servidor <b>{$a}</b> de la llista?';
$string['confirmstartattemptlimit'] = 'Nombre d\'intents permesos: {$a}. Esteu a punt d\'iniciar un nou intent. Voleu continuar?';
$string['confirmstartattempttimelimit'] = 'Aquest qüestionari té un límit de temps i està limitat a {$a} intent/s. Ara començareu un nou intent. Voleu continuar?';
$string['confirmstarttimelimit'] = 'Aquest qüestionari té un límit de temps. Segur que voleu començar?';
$string['connectionerror'] = 'S\'ha perdut la connexió a la xarxa. (Ha fallat l\'autodesament.)

Preneu nota de les respostes introduïdes en aquesta pàgina en els últims minuts i, després, procureu tornar a connectar-vos-hi.

Una vegada que la connexió s\'hagi restablert, les vostres respostes s\'haurien d\'haver desat, i aquest missatge desapareixerà.';
$string['connectionok'] = 'S\'ha restablert la connexió. Podeu continuar amb seguretat.';
$string['containercategorycreated'] = 'S\'ha creat aquesta categoria a fi d\'emmagatzemar totes les categories originals que s\'han mogut al nivell del lloc pels motius especificats més avall.';
$string['continueattemptquiz'] = 'Continua el darrer intent';
$string['continuepreview'] = 'Continua la darrera previsualització';
$string['copyingfrom'] = 'S\'està creant una còpia de la pregunta «{$a}»';
$string['copyingquestion'] = 'S\'està copiant una pregunta';
$string['correct'] = 'Correcta';
$string['correctanswer'] = 'Resposta correcta';
$string['correctanswerformula'] = 'Fòrmula de la resposta correcta';
$string['correctansweris'] = 'Resposta correcta: {$a}';
$string['correctanswerlength'] = 'Xifres significatives';
$string['correctanswers'] = 'Respostes correctes';
$string['correctanswershows'] = 'La resposta correcta mostra';
$string['corrresp'] = 'Resposta correcta';
$string['countdown'] = 'Compte enrere';
$string['countdownfinished'] = 'El qüestionari es tancarà aviat. Heu de trametre les respostes ja.';
$string['countdowntenminutes'] = 'El qüestionari es tancarà en 10 minuts.';
$string['coursetestmanager'] = 'Format Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Crea una categoria i afegeix-hi una pregunta aleatòria';
$string['createfirst'] = 'Primer heu de crear algunes preguntes de resposta breu';
$string['createmultiple'] = 'Afegeix al qüestionari algunes preguntes aleatòries';
$string['createnewquestion'] = 'Crea una nova pregunta';
$string['createquestionandadd'] = 'Crea una nova pregunta i afegeix-la al qüestionari.';
$string['custom'] = 'Format personalitzat';
$string['dataitemneed'] = 'Heu d\'afegir almenys un conjunt d\'elements de dades per obtenir una pregunta vàlida.';
$string['datasetdefinitions'] = 'Definicions reutilitzables del conjunt de dades per a la categoria {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Dies disponibles';
$string['decimaldigits'] = 'Xifres decimals en les qualificacions';
$string['decimalplaces'] = 'Nombre de decimals a les puntuacions';
$string['decimalplaces_help'] = 'Aquest paràmetre especifica el nombre de dígits que es mostren després del punt decimal quan es visualitzen les puntuacions. Només afecta la visualització de les puntuacions; no afecta ni les puntuacions emmagatzemades a la base de dades ni els càlculs interns, que es duen a terme amb la màxima precisió.';
$string['decimalplacesquestion'] = 'Xifres decimals en les puntuacions de les preguntes';
$string['decimalplacesquestion_help'] = 'Aquest paràmetre especifica el nombre de dígits que es mostren després del punt decimal quan es visualitzen les puntuacions de cada pregunta.';
$string['decimalpoints'] = 'Punts decimals';
$string['default'] = 'Per defecte';
$string['defaultgrade'] = 'Qualificació per defecte de la pregunta';
$string['defaultinfo'] = 'Categoria per defecte per a les preguntes.';
$string['delay1'] = 'Retard de temps entre el primer intent i el segon';
$string['delay1st2nd'] = 'Retard forçat entre el primer intent i el segon';
$string['delay1st2nd_help'] = 'Si habiliteu aquí un retard, l\'estudiant haurà d\'esperar que transcorri el període de temps especificat abans de poder intentar fer el qüestionari per segona vegada.';
$string['delay2'] = 'Retard de temps entre els intents posteriors';
$string['delaylater'] = 'Retard forçat entre els intents posteriors';
$string['delaylater_help'] = 'Si habiliteu aquí un retard, l\'estudiant haurà d\'esperar que transcorri el període de temps especificat abans de poder intentar fer el qüestionari per tercera vegada, i les vegades posteriors.';
$string['deleteattemptcheck'] = 'Esteu absolutament segur que voleu suprimir completament aquests intents?';
$string['deleteselected'] = 'Suprimeix la selecció';
$string['deletingquestionattempts'] = 'S\'estan esborrant els intents de les preguntes';
$string['description'] = 'Descripció';
$string['disabled'] = 'Desactivat';
$string['displayoptions'] = 'Opcions de visualització';
$string['donotuseautosave'] = 'No utilitzis l\'autodesament.';
$string['download'] = 'Feu clic per baixar el fitxer de categoria exportat';
$string['downloadextra'] = '(el fitxer també s\'ha emmagatzemat amb els fitxers del curs a la carpeta /backupdata/quiz)';
$string['duplicateresponse'] = 'S\'ha ignorat aquesta tramesa perquè ja vau donar anteriorment una resposta equivalent.';
$string['eachattemptbuildsonthelast'] = 'Cada intent reprèn l\'anterior';
$string['eachattemptbuildsonthelast_help'] = '<p>Si es permet de fer múltiples intents i aquest paràmetre s\'ha activat, cada nou intent contindrà els resultats de l\'intent anterior. Això permet que el qüestionari es pugui completar al llarg de diferents intents.';
$string['editcategories'] = 'Edita categories';
$string['editcategory'] = 'Edita categoria';
$string['editcatquestions'] = 'Edita preguntes de la categoria';
$string['editingquestion'] = 'S\'està editant una pregunta';
$string['editingquiz'] = 'S\'està editant el qüestionari';
$string['editingquiz_help'] = 'Quan es crea un qüestionari, els conceptes fonamentals per tenir en compte són:

* que pot tenir les preguntes en una o més pàgines;
* el banc de preguntes, que emmagatzema les còpies de totes les preguntes organitzades en categories;
* les preguntes aleatòries —cada estudiant té preguntes diferents cada vegada que intenta resoldre un qüestionari, i diferents estudiants poden tenir diferents preguntes.';
$string['editingquizx'] = 'S\'està editant el qüestionari: {$a}';
$string['editoverride'] = 'Edita l\'excepció';
$string['editqcats'] = 'Edita categories de les preguntes';
$string['editquestions'] = 'Edita preguntes';
$string['editquiz'] = 'Edita el qüestionari';
$string['editquizquestions'] = 'Edita preguntes del qüestionari';
$string['emailconfirmbody'] = '{$a->username},

Gràcies per trametre les vostres respostes al qüestionari «{$a->quizname}» del curs «{$a->coursename}» a les {$a->submissiontime}.

Aquest correu confirma que s\'han rebut de manera segura les respostes.

Podeu accedir a aquest qüestionari a l\'URL {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Gràcies per trametre les respostes a «{$a->quizname}»';
$string['emailconfirmsubject'] = 'Confirmació de la tramesa: {$a->quizname}';
$string['emailnotifybody'] = '{$a->username},

{$a->studentname} ha completat «{$a->quizname}» ({$a->quizurl}) del curs «{$a->coursename}».

Podeu revisar aquest intent a l\'URL {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completat {$a->quizname}. Vegeu {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} ha completat {$a->quizname}';
$string['emailoverduebody'] = '{$a->studentname},

Vau començar un intent de «{$a->quizname}» al curs «{$a->coursename}», però mai no el vau trametre. L\'hauríeu d\'haver tramès dia {$a->attemptduedate}.

Si encara voleu trametre aquest intent, aneu a {$a->attemptsummaryurl} i feu clic al botó de tramesa.

Heu de fer-ho abans de {$a->attemptgraceend}; si no, el vostre intent no comptarà.';
$string['emailoverduesmall'] = 'No heu tramès el vostre intent de {$a->quizname}. Aneu a {$a->attemptsummaryurl} abans de {$a->attemptgraceend} si encara voleu enviar-lo.';
$string['emailoverduesubject'] = 'Intent ara fora de termini: {$a->quizname}';
$string['empty'] = 'Buit';
$string['enabled'] = 'Activat';
$string['endtest'] = 'Acaba l\'intent...';
$string['erroraccessingreport'] = 'No podeu accedir a aquest informe';
$string['errorinquestion'] = 'Error en la pregunta';
$string['errormissingquestion'] = 'Error: el sistema no coneix la pregunta amb ID {$a}';
$string['errornotnumbers'] = 'Error: les respostes han de ser numèriques';
$string['errorunexpectedevent'] = 'Codi d\'esdeveniment inesperat {$a->event} trobat per a la pregunta {$a->questionid} durant l\'intent {$a->attemptid}.';
$string['essay'] = 'Resposta oberta';
$string['essayquestions'] = 'Preguntes';
$string['eventquizattemptabandoned'] = 'S\'ha abandonat l\'intent del qüestionari';
$string['eventquizattemptstarted'] = 'S\'ha començat l\'intent del qüestionari';
$string['eventquizattemptsubmitted'] = 'S\'ha tramès l\'intent del qüestionari';
$string['eventquizattempttimelimitexceeded'] = 'S\'ha excedit el límit de temps de l\'intent del qüestionari';
$string['everynquestions'] = 'Cada {$a} preguntes';
$string['everyquestion'] = 'Cada pregunta';
$string['everythingon'] = 'Tot activat';
$string['export'] = 'Exporta';
$string['exportcategory'] = 'exporta la categoria';
$string['exporterror'] = 'S\'ha produït un error durant el procés d\'exportació';
$string['exportingquestions'] = 'S\'estan exportant les preguntes a un fitxer';
$string['exportname'] = 'Nom del fitxer';
$string['exportquestions'] = 'Exporta preguntes a un fitxer';
$string['extraattemptrestrictions'] = 'Restriccions extres durant els intents';
$string['false'] = 'Fals';
$string['feedback'] = 'Retroacció';
$string['feedbackerrorboundaryformat'] = 'Els límits de la qualificació per a la retroacció han de ser o un percentatge o un nombre. El valor que heu introduït al límit {$a} no s\'ha reconegut.';
$string['feedbackerrorboundaryoutofrange'] = 'Els límits de la qualificació per a la retroacció han d\'estar entre el 0% i el 100%. El valor que heu introduït al límit {$a} està fora d\'aquests límits.';
$string['feedbackerrorjunkinboundary'] = 'Heu d\'omplir els camps dels límits de la qualificació per a la retroacció sense deixar buits.';
$string['feedbackerrorjunkinfeedback'] = 'Heu d\'omplir els camps de la retroacció sense deixar buits.';
$string['feedbackerrororder'] = 'Els límits de la qualificació per a la retroacció han d\'estar ordenats, el més alt primer. El valor que heu introduït al límit {$a} no segueix l\'ordre.';
$string['file'] = 'Fitxer';
$string['fileformat'] = 'Format de fitxer';
$string['fillcorrect'] = 'Emplena amb l\'opció correcta';
$string['filloutnumericalanswer'] = 'Heu de proporcionar almenys una possible resposta i un grau de tolerància. La primera resposta coincident s\'utilitzarà per determinar la puntuació i la retroacció. Si proporcioneu una retroacció sense resposta al final, aquesta es mostrarà quan la resposta de l\'estudiant no coincideixi amb cap de les que especifiqueu aquí.';
$string['filloutoneanswer'] = 'Heu d\'emplenar almenys una possible resposta. Les respostes en blanc no es tindran en compte. Podeu usar «*» com a comodí per fer-lo concordar amb qualsevol caràcter. La primera resposta concordant s\'usarà per a determinar la puntuació i la retroacció.';
$string['filloutthreequestions'] = 'Heu d\'emplenar almenys tres preguntes amb aparellaments. Podeu proporcionar respostes errònies proporcionant una resposta amb una opció en blanc. Les entrades on la pregunta i la resposta estiguin en blanc no es tindran en compte.';
$string['fillouttwochoices'] = 'Heu d\'emplenar almenys dues opcions. Les opcions en blanc no es tindran en compte.';
$string['finishattemptdots'] = 'Acaba l\'intent...';
$string['finishreview'] = 'Acaba la revisió';
$string['forceregeneration'] = 'força la regeneració';
$string['formatnotfound'] = 'No s\'ha trobat el format d\'importació/exportació {$a}';
$string['formatnotimplemented'] = 'Aquest format no s\'ha implementat correctament. Envieu un informe d\'aquest error.';
$string['formulaerror'] = 'Errors en la fórmula!';
$string['fractionsaddwrong'] = 'Les notes que heu donat no sumen 100% (sumen {$a}%).
<br />Voleu tornar enrere i corregir aquesta pregunta?';
$string['fractionsnomax'] = 'Una de les respostes ha de valer 100%, de manera que sigui
<br />possible obtenir la qualificació màxima en aquesta pregunta.<br />Voleu tornar enrere i corregir aquesta pregunta?';
$string['fromfile'] = 'del fitxer:';
$string['functiondisabledbysecuremode'] = 'Aquesta funcionalitat es troba inactiva, de moment.';
$string['generalfeedback'] = 'Retroacció general';
$string['generalfeedback_help'] = 'La retroacció general és un text que es mostra després que s\'hagi intentat una resposta. A diferència de la retroacció específica, que depèn de la resposta proporcionada, la retroacció general sempre és la mateixa.';
$string['graceperiod'] = 'Període de gràcia per a la tramesa';
$string['graceperiod_desc'] = 'Si està definit què fer quan el temps expira com a «Permet un període de gràcia per a la tramesa, però no canviïs les respostes», la quantitat predeterminada de temps extra que es permet s\'estableix en segons.';
$string['graceperiod_help'] = 'Si està definit què fer quan el temps expira com a «Permet un període de gràcia per a la tramesa, però no canviïs les respostes», s\'estableix la quantitat predeterminada de temps extra que es permet.';
$string['graceperiodmin'] = 'Últim període de gràcia per a la tramesa';
$string['graceperiodmin_desc'] = 'Hi ha un problema potencial just al final del qüestionari. D\'una banda, volem permetre que els estudiants continuïn treballant fins l\'últim segon —amb l\'ajuda del temporitzador, que automàticament tramet el qüestionari quan el temps s\'exhaureix. D\'altra banda, el servidor pot estar sobrecarregat, i pot prendre\'s un temps per acabar de processar les respostes. Per tant, acceptarem les respostes fins a aquesta quantitat de segons després que el temps expiri, perquè els estudiants no siguin sancionats per un servidor lent. No obstant això, l\'estudiant podria fer trampa i obtenir aquesta quantitat de segons per contestar el qüestionari. Heu de fer una compensació basada en la fiabilitat del rendiment del vostre servidor durant els qüestionaris.';
$string['graceperiodtoosmall'] = 'El període de gràcia ha de ser més gran que {$a}.';
$string['grade'] = 'Qualificació';
$string['gradeall'] = 'Qualifica-ho tot';
$string['gradeaverage'] = 'Qualificació mitjana';
$string['gradeboundary'] = 'Límit de qualificació';
$string['gradeessays'] = 'Qualifica les preguntes de resposta oberta';
$string['gradehighest'] = 'Qualificació més alta';
$string['grademethod'] = 'Mètode de qualificació';
$string['grademethod_help'] = 'En el cas que es permetin múltiples intents per respondre el qüestionari hi ha diferents formes per calcular la qualificació final.

* La qualificació més alta de tots els intents;
* La qualificació mitjana de tots els intents;
* La qualificació del primer intent (els següents s\'ignoren);
* La qualificació del darrer intent (els anteriors s\'ignoren).';
$string['gradesdeleted'] = 'S\'han suprimit les qualificacions del qüestionari';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Punts d\'aquesta tramesa: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Amb les penalitzacions prèvies això dóna <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Aquesta tramesa ha rebut una penalització de {$a}.';
$string['gradingdetailszeropenalty'] = 'Aquesta tramesa no ha estat penalitzada.';
$string['gradingmethod'] = 'Mètode de qualificació: {$a}';
$string['groupoverrides'] = 'Excepcions de grup';
$string['groupsnone'] = 'No hi ha grups en aquest curs';
$string['guestsno'] = 'Els visitants no poden contestar els qüestionaris ni veure\'ls';
$string['hidebreaks'] = 'Amaga els salts de pàgina';
$string['hidereordertool'] = 'Amaga l\'eina de reordenació';
$string['history'] = 'Historial de respostes:';
$string['howquestionsbehave_desc'] = 'Paràmetres per defecte del comportament de les preguntes dins un qüestionari.';
$string['imagedisplay'] = 'Imatge que es visualitzarà';
$string['import'] = 'Importa';
$string['importcategory'] = 'importa una categoria';
$string['importerror'] = 'S\'ha produït un error durant el procés d\'importació';
$string['importfilearea'] = 'Importació d\'un fitxer que ja és a l\'àrea de fitxers del curs...';
$string['importfileupload'] = 'Importació d\'un fitxer del vostre ordinador...';
$string['importfromthisfile'] = 'Importa d\'aquest fitxer';
$string['import_help'] = 'Aquesta funció us permet importar preguntes de fitxers externs.

Si el vostre fitxer té caràcters que no siguin ASCII, cal que utilitzeu la codificació UTF-8. Aneu amb compte amb fitxers generats amb aplicacions de Microsoft Word, perquè utilitzen una codificació especial que no es pot controlar correctament.

Els formats d\'importació i exportació són un recurs integrat. Es poden obtenir altres formats entre els complements de la base de dades de Moodle.';
$string['importingquestions'] = 'S\'estan important {$a} preguntes del fitxer';
$string['importmax10error'] = 'Hi ha un error en aquesta pregunta. No podeu tenir més de 10 respostes.';
$string['importmaxerror'] = 'Hi ha un error en aquesta pregunta. Teniu massa respostes.';
$string['importquestions'] = 'Importa preguntes des d\'un fitxer';
$string['inactiveoverridehelp'] = '* L\'estudiant no pertany al grup o no té el rol adequat per respondre el qüestionari.';
$string['incorrect'] = 'Incorrecta';
$string['indivresp'] = 'Respostes dels individus per a cada element';
$string['info'] = 'Informació';
$string['infoshort'] = 'i';
$string['inprogress'] = 'En curs';
$string['introduction'] = 'Descripció';
$string['invalidattemptid'] = 'No es troba l\'intent d\'aquest ID.';
$string['invalidcategory'] = 'El número ID de la categoria no és vàlid';
$string['invalidnumericanswer'] = 'Una de les respostes que heu introduït no és un nombre vàlid.';
$string['invalidnumerictolerance'] = 'Un dels graus de tolerància que heu introduït no és un nombre vàlid.';
$string['invalidoverrideid'] = 'El número ID de l\'excepció no és vàlid.';
$string['invalidquestionid'] = 'El número ID de la pregunta no és vàlid';
$string['invalidquizid'] = 'El número ID del qüestionari no és vàlid';
$string['invalidsource'] = 'La font no és vàlida';
$string['invalidsourcetype'] = 'El tipus de font no és vàlid';
$string['invalidstateid'] = 'El número ID d\'estatus no és vàlid';
$string['lastanswer'] = 'La vostra darrera resposta era:';
$string['layout'] = 'Aspecte';
$string['layoutasshown'] = 'Aspecte de la pàgina tal com es veu.';
$string['layoutasshownwithpages'] = 'Aspecte de la pàgina tal com es veu. <small>(Pàgina nova cada {$a} preguntes.)</small>';
$string['layoutshuffledandpaged'] = 'Preguntes que es barrejaran aleatòriament; {$a} preguntes per pàgina.';
$string['layoutshuffledsinglepage'] = 'Preguntes que es barrejaran aleatòriament; totes en una pàgina.';
$string['link'] = 'Enllaç';
$string['listitems'] = 'Llista d\'elements del qüestionari';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Ha fallat la càrrega de preguntes: {$a}';
$string['makecopy'] = 'Desa com una nova pregunta';
$string['managetypes'] = 'Gestiona els tipus de preguntes i els servidors';
$string['manualgrading'] = 'S\'està qualificant';
$string['mark'] = 'Tramet';
$string['markall'] = 'Tramet la pàgina';
$string['marks'] = 'Punts';
$string['marks_help'] = 'Les puntuacions numèriques per a cada pregunta i la puntuació global de l\'intent.';
$string['match'] = 'Aparellament';
$string['matchanswer'] = 'Resposta correcta';
$string['matchanswerno'] = 'Resposta correcta {$a}';
$string['max'] = 'Màx.';
$string['messageprovider:attempt_overdue'] = 'Avís quan el vostre intent del qüestionari arribi al termini de venciment';
$string['messageprovider:confirmation'] = 'Confirmació que s\'envia el qüestionari';
$string['messageprovider:submission'] = 'Notificació de la tramesa del qüestionari';
$string['min'] = 'Mín.';
$string['minutes'] = 'minuts';
$string['missingcorrectanswer'] = 'S\'ha d\'especificar la resposta correcta';
$string['missingitemtypename'] = 'Falta el nom';
$string['missingquestion'] = 'Aquesta pregunta sembla no existir ja';
$string['modulename'] = 'Qüestionari';
$string['modulename_help'] = 'El mòdul de qüestionaris permet al professorat crear qüestionaris amb preguntes de diversos tipus, com ara de selecció múltiple, cert-fals, aparellaments, resposta breu i numèriques.

El professor pot permetre múltiples intents del qüestionari, amb les preguntes barrejades o escollides a l\'atzar d\'entre un banc de preguntes. Es pot establir un límit de temps.

Cada intent es puntua automàticament, amb l\'excepció de les preguntes de tipus «assaig», i la nota es registra al llibre de qualificacions.

El professor pot decidir si es mostren als alumnes (i quan) comentaris, retroacció i les respostes correctes.

Els qüestionaris es poden utilitzar:

* Com a examens del curs.
* Com a mini-tests després de tasques de lectura, o al final d\'un tema.
* Com a examen de repàs si s\'utilitzen preguntes de qüestionaris anteriors.
* Per oferir retroacció immediata sobre les capacitats de l\'alumnat.
* Per auto-avaluació.';
$string['modulenameplural'] = 'Qüestionaris';
$string['moveselectedonpage'] = 'Mou les preguntes seleccionades a la pàgina: {$a}';
$string['multichoice'] = 'Opcions múltiples';
$string['multipleanswers'] = 'Trieu almenys una resposta';
$string['multiplier'] = 'Multiplicador';
$string['mustbesubmittedby'] = 'Aquest intent s\'ha d\'enviar abans de {$a}.';
$string['name'] = 'Títol';
$string['navmethod'] = 'Mètode de navegació';
$string['navmethod_free'] = 'Lliure';
$string['navmethod_help'] = 'Quan la navegació seqüencial està activada, un estudiant ha de progressar a través del qüestionari en ordre i no pot tornar a les pàgines anteriors ni saltar cap endavant.';
$string['navmethod_seq'] = 'Seqüencial';
$string['navnojswarning'] = 'Compte: aquests enllaços no desaran les respostes. Utilitzeu el botó Següent al peu de la pàgina.';
$string['neverallononepage'] = 'Mai, totes les preguntes en una pàgina';
$string['newattemptfail'] = 'Error: no s\'ha pogut iniciar un nou intent del qüestionari';
$string['newpage'] = 'Pàgina nova';
$string['newpageevery'] = 'Afegeix una pàgina nova automàticament';
$string['newpage_help'] = 'En qüestionaris molt llargs té sentit limitar el nombre de preguntes per pàgina i partir el qüestionari en diverses pàgines. Quan afegiu preguntes al qüestionari els salts de pàgina s\'introduiran automàticament d\'acord amb els paràmetres que hàgeu triat aquí. Tanmateix, després podreu canviar de lloc aquests salts de pàgina a mà en la pàgina d\'edició.';
$string['noanswers'] = 'No s\'ha seleccionat cap resposta';
$string['noattempts'] = 'Aquest qüestionari no ha estat contestat';
$string['noattemptsfound'] = 'No s\'han trobat intents';
$string['noattemptstoshow'] = 'No hi ha intents per mostrar';
$string['nocategory'] = 'No heu especificat una categoria o la categoria és incorrecta';
$string['noclose'] = 'No hi ha data de tancament';
$string['nocommentsyet'] = 'Encara no hi ha comentaris';
$string['noconnection'] = 'En aquest moment no hi ha connexió amb un servei web que pugui processar aquesta pregunta. Contacteu si us plau amb l\'administrador';
$string['nodataset'] = 'res: no és un comodí';
$string['nodatasubmitted'] = 'No s\'han tramès dades.';
$string['noessayquestionsfound'] = 'No s\'han trobat preguntes qualificades manualment';
$string['nogradewarning'] = 'El qüestionari no s\'ha puntuat, i no podeu escriure una retroacció general que faci diferir la puntuació.';
$string['nomoreattempts'] = 'No es permeten més intents';
$string['none'] = 'Cap';
$string['noopen'] = 'No hi ha una data d\'obertura';
$string['nooverridedata'] = 'Heu de modificar com a mínim un dels paràmetres del qüestionari.';
$string['nopossibledatasets'] = 'No hi ha conjunts de dades possibles';
$string['noquestionintext'] = 'El text de la pregunta no conté cap pregunta a dins.';
$string['noquestions'] = 'Encara no s\'han afegit preguntes';
$string['noquestionsfound'] = 'No s\'han trobat preguntes';
$string['noquestionsinquiz'] = 'No hi ha preguntes en aquest qüestionari';
$string['noquestionsnotinuse'] = 'Aquesta pregunta aleatòria no s\'utilitza, perquè la seva categoria està buida.';
$string['noquestionsonpage'] = 'Pàgina buida';
$string['noresponse'] = 'Sense resposta';
$string['noreview'] = 'No teniu permís per revisar aquest qüestionari';
$string['noreviewattempt'] = 'No teniu permís per revisar aquest intent.';
$string['noreviewshort'] = 'No permès';
$string['noreviewuntil'] = 'No teniu permís per revisar aquest qüestionari fins el {$a}';
$string['noreviewuntilshort'] = '{$a} disponible';
$string['noscript'] = 'El javascript ha d\'estar habilitat per continuar';
$string['notavailabletostudents'] = 'Nota: aquest qüestionari no està disponible actualment per als vostres estudiants';
$string['notenoughrandomquestions'] = 'No hi ha prou preguntes a la categoria {$a->category} per crear la pregunta {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'No heu definit prou subpreguntes!<br />
Voleu tornar enrere i arreglar aquesta pregunta?';
$string['notimedependentitems'] = 'A hores d\'ara els elements dependents del temps no funcionen amb el mòdul de qüestionaris. Provisionalment podeu definir un temps límit per a tot el qüestionari. Voleu triar un altre ítem diferent o malgrat tot preferiu utilitzar aquest?';
$string['notyetgraded'] = 'Encara no s\'ha avaluat';
$string['notyetviewed'] = 'Encara no s\'ha visualitzat';
$string['notyourattempt'] = 'No és el vostre intent!';
$string['noview'] = 'L\'usuari identificat no pot veure aquest qüestionari';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} ha fet {$a->attemptnum} intents';
$string['numattemptsmade'] = 'S\'han fet {$a} intents en aquest qüestionari';
$string['numberabbr'] = 'n.';
$string['numerical'] = 'Numèrica';
$string['numquestionsx'] = 'Preguntes: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Només el professorat pot exportar preguntes';
$string['onlyteachersimport'] = 'Només el professorat amb permís d\'edició pot importar preguntes';
$string['onthispage'] = 'Aquesta pàgina';
$string['open'] = 'Sense resposta';
$string['openclosedatesupdated'] = 'S\'han actualitzat les dates d\'inici i tancament del qüestionari';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Ordre i paginació';
$string['orderandpaging_help'] = 'Els números 10, 20, 30, ... a l\'altre costat de cada pregunta indiquen l\'ordre de les preguntes. Els números augmenten de 10 en 10 per permetre espai per a preguntes addicionals que es puguin inserir. Per reordenar les preguntes, canvieu els números i feu clic al botó "Reordena les preguntes".

Per afegir salts de pàgina després d\'una pregunta determinada, marqueu els quadres de selecció després de les preguntes i feu clic al botó "Afegeix pàgines després de les preguntes seleccionades".

Per distribuir les preguntes en un nombre de pàgines feu clic al botó "Repagina" i seleccioneu el nombre de preguntes per pàgina.';
$string['orderingquiz'] = 'Ordre i paginació';
$string['orderingquizx'] = 'Ordre i paginació: {$a}';
$string['outcomesadvanced'] = 'Les competències són paràmetres avançats';
$string['outof'] = '{$a->grade} d\'un màxim de {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} sobre {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Retroacció global';
$string['overallfeedback_help'] = 'Retroacció global és un text que es mostra després d\'haver acabat l\'intent d\'un qüestionari. Si s\'especifiquen límits de puntuació addicional (com a percentatge o com a número), el text que es mostri dependrà de la puntuació obtinguda.';
$string['overdue'] = 'Venciment';
$string['overduehandling'] = 'Quan el temps expiri';
$string['overduehandlingautoabandon'] = 'Els intents s\'han d\'enviar abans que el temps expiri o no comptaran';
$string['overduehandlingautosubmit'] = 'Els intents oberts s\'envien automàticament';
$string['overduehandling_desc'] = 'Què hauria de passar per defecte si un estudiant no envia el qüestionari abans que expiri el temps.';
$string['overduehandlinggraceperiod'] = 'Hi ha un període de gràcia durant el qual els intents oberts es poden enviar, però no es poden contestar més preguntes';
$string['overduehandling_help'] = 'Aquest paràmetre controla què ocorre si l\'estudiantat no envia el seu intent del qüestionari abans que el temps expiri. Si l\'estudiant està treballant activament en el qüestionari fins al moment, el temporitzador de compte enrere enviarà l\'intent per ell, però si ha tancat la sessió, aquest paràmetre controla què passa.';
$string['overduemustbesubmittedby'] = 'Aquest intent ha arribat al termini de venciment. Ja s\'hauria d\'haver enviat. Si voleu que us sigui qualificat aquest qüestionari, heu d\'enviar-lo abans de {$a}. Si no ho envieu llavors, no es comptabilitzarà cap qualificació d\'aquest intent.';
$string['override'] = 'Excepció';
$string['overridedeletegroupsure'] = 'Segur que voleu sborrar l\'excepció pel grup {$a}?';
$string['overridedeleteusersure'] = 'Segur que voleu sborrar l\'excepció per l\'usuari {$a}?';
$string['overridegroup'] = 'Estableix una excepció pel grup';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Excepcions';
$string['overrideuser'] = 'Estableix una excepció per l\'usuari';
$string['overrideusereventname'] = '{$a->quiz} - Excepció';
$string['page-mod-quiz-attempt'] = 'Pàgina de l\'intent del qüestionari';
$string['page-mod-quiz-edit'] = 'Edita la pàgina del qüestionari';
$string['page-mod-quiz-report'] = 'Qualsevol pàgina de l\'informe del qüestionari';
$string['page-mod-quiz-review'] = 'Pàgina de revisió de l\'intent del qüestionari';
$string['page-mod-quiz-summary'] = 'Pàgina de resum de l\'intent del qüestionari';
$string['page-mod-quiz-view'] = 'Pàgina d\'informació del qüestionari';
$string['page-mod-quiz-x'] = 'Qualsevol pàgina del mòdul de qüestionari';
$string['pagesize'] = 'Mida de la pàgina';
$string['parent'] = 'Mare';
$string['parentcategory'] = 'Categoria mare';
$string['parsingquestions'] = 'S\'estan analitzant les preguntes del fitxer d\'importació.';
$string['partiallycorrect'] = 'Parcialment correcte';
$string['penalty'] = 'Penalització';
$string['penaltyscheme'] = 'Aplica penalitzacions';
$string['penaltyscheme_help'] = '<p>Si un qüestionari funciona en mode adaptatiu, un estudiant pot provar de nou després d\'una resposta incorrecta. En aquest cas podeu voler imposar una penalització per cada resposta incorrecta perquè sigui restada de la puntuació final de la pregunta. La quantitat de la penalització es tria individualment per a cada pregunta quan s\'actualitza o edita la pregunta.</p>

<p>Aquest paràmetre no té efecte si el qüestionari no està funcionant en mode adaptatiu.</p>';
$string['percentcorrect'] = 'Percentatge de correctes';
$string['pleaseclose'] = 'La vostra petició ha estat processada. Podeu tancar aquesta finestra.';
$string['pluginadministration'] = 'Administració del qüestionari';
$string['pluginname'] = 'Qüestionari';
$string['popup'] = 'Mostra el qüestionari en una finestra "segura"';
$string['popupblockerwarning'] = 'Aquesta secció de la prova es fa en mode segur. Això vol dir que cal contestar el qüestionari en una finestra segura. Desactiveu el blocatge de finestres emergents.';
$string['popupnotice'] = 'Els estudiants veuran aquest qüestionari en una finestra segura';
$string['preprocesserror'] = 'S\'ha produït un error durant el preprocessament';
$string['preview'] = 'Previsualització';
$string['previewquestion'] = 'Previsualitza la pregunta';
$string['previewquiz'] = 'Previsualitza {$a}';
$string['previewquiznow'] = 'Previsualitza el qüestionari ara';
$string['previous'] = 'Estat anterior';
$string['publish'] = 'Publica';
$string['publishedit'] = 'Heu de tenir permisos en el curs per afegir o editar preguntes d\'aquesta categoria';
$string['qbrief'] = 'P. {$a}';
$string['qname'] = 'nom';
$string['qti'] = 'Format IMS QTI';
$string['qtypename'] = 'tipus, nom';
$string['question'] = 'Pregunta';
$string['questionbankcontents'] = 'Continguts del banc de preguntes';
$string['questionbankmanagement'] = 'Administració del banc de preguntes';
$string['questionbehaviour'] = 'Comportament de la pregunta';
$string['questioncats'] = 'Categories de preguntes';
$string['questiondeleted'] = 'Aquesta pregunta ha estat suprimida. Consulteu el professorat del curs.';
$string['questioninuse'] = 'La pregunta \'{$a->questionname}\' s\'està utilitzant actualment en:<br />{$a->quiznames}<br />Només se suprimirà la pregunta en la llista de categories, no en els qüestionaris que la utilitzen.';
$string['questionmissing'] = 'La pregunta d\'aquesta sessió ha desaparegut';
$string['questionname'] = 'Títol de la pregunta';
$string['questionnonav'] = '<span class="accesshide">Pregunta </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informació </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'La pregunta {$a} no s\'ha pogut carregar des de la base de dades';
$string['questionorder'] = 'Ordre de les preguntes';
$string['questionposition'] = 'Nova posició d\'ordenació de la pregunta {$a}';
$string['questions'] = 'Preguntes';
$string['questionsinclhidden'] = 'Preguntes (incloses les ocultes)';
$string['questionsinthisquiz'] = 'Preguntes d\'aquest qüestionari';
$string['questionsperpage'] = 'Preguntes per pàgina';
$string['questionsperpageselected'] = 'El nombre de preguntes per pàgina s\'ha fixat. Pewr tant, els controls de distribució per pàgines s\'han desactivat. Podeu canviar-ho a {$a}.';
$string['questionsperpagex'] = 'Preguntes per pàgina: {$a}';
$string['questiontext'] = 'Text de la pregunta';
$string['questiontextisempty'] = '[Text de la pregunta en blanc]';
$string['questiontype'] = 'Tipus de pregunta {$a}';
$string['questiontypesetupoptions'] = 'Opcions de configuració dels tipus de pregunta:';
$string['quiz:addinstance'] = 'Afegeix un qüestionari nou';
$string['quiz:attempt'] = 'Contestar qüestionaris';
$string['quizavailable'] = 'El qüestionari està disponible fins: {$a}';
$string['quizclose'] = 'Tanca el qüestionari';
$string['quizclosed'] = 'Aquest qüestionari es va tancar el {$a}';
$string['quizcloses'] = 'El qüestionari es tanca';
$string['quizcloseson'] = 'Aquest qüestionari es tancarà el {$a}';
$string['quiz:deleteattempts'] = 'Suprimeix intents del qüestionari';
$string['quiz:emailconfirmsubmission'] = 'Rep un missatge de confirmació quan hi hagi enviaments';
$string['quiz:emailnotifysubmission'] = 'Rep un missatge de notificació quan s\'hagi enviat un intent';
$string['quiz:emailwarnoverdue'] = 'Rep un missatge de notificació quan un intent arribe al termini de venciment i necessiti enviar-se.';
$string['quiz:grade'] = 'Qualifica els qüestionaris manualment';
$string['quiz:ignoretimelimits'] = 'Ignora el límit de temps dels qüestionaris';
$string['quizisclosed'] = 'El qüestionari està tancat';
$string['quizisclosedwillopen'] = 'El qüestionari es va tancar (s\'obre el {$a})';
$string['quizisopen'] = 'El qüestionari està obert';
$string['quizisopenwillclose'] = 'El qüestionari està obert (es tanca el {$a})';
$string['quiz:manage'] = 'Gestionar qüestionaris';
$string['quiz:manageoverrides'] = 'Gestiona les excepcions del qüestionari';
$string['quiznavigation'] = 'Navegació pel qüestionari';
$string['quizopen'] = 'Obre el qüestionari';
$string['quizopenclose'] = 'Dates d\'obertura i tancament';
$string['quizopenclose_help'] = 'Els estudiants només poden iniciar els seus intents després de l\'obertura i els han d\'acabar abans del tancament.';
$string['quizopened'] = 'El qüestionari està obert.';
$string['quizopenedon'] = 'Aquest qüestionari està disponible des de: {$a}';
$string['quizopens'] = 'S\'obre el qüestionari';
$string['quizopenwillclose'] = 'Aquest qüestionari està obert, es tancarà el {$a}';
$string['quizordernotrandom'] = 'Ordre sense alterar';
$string['quizorderrandom'] = '* Ordre alterat';
$string['quiz:preview'] = 'Previsualitza qüestionaris';
$string['quiz:regrade'] = 'Torna a qualificar els intents';
$string['quiz:reviewmyattempts'] = 'Revisa els intents propis';
$string['quizsettings'] = 'Paràmetres del qüestionari';
$string['quiztimer'] = 'Temporitzador del qüestionari';
$string['quiz:view'] = 'Veure informació del qüestionari';
$string['quiz:viewreports'] = 'Veure informes del qüestionari';
$string['quizwillopen'] = 'Aquest qüestionari s\'obrirà el {$a}';
$string['random'] = 'Pregunta aleatòria';
$string['randomcreate'] = 'Crea preguntes aleatòries';
$string['randomfromcategory'] = 'Pregunta aleatòria de la categoria:';
$string['randomfromexistingcategory'] = 'Pregunta aleatòria d\'una categoria existent';
$string['randomnosubcat'] = 'Preguntes només d\'aquesta categoria, no de les seves subcategories.';
$string['randomquestionusinganewcategory'] = 'Pregunta aleatòria fent servir una categoria nova.';
$string['randomwithsubcat'] = 'Pregunta d\'aquesta categoria i de les seves subcategories.';
$string['readytosend'] = 'Esteu a punt d\'enviar el qüestionari complet perquè sigui qualificat. Esteu segur que voleu continuar?';
$string['reattemptquiz'] = 'Reintenta el qüestionari';
$string['recentlyaddedquestion'] = 'Aquesta pregunta ha estat afegida recentment';
$string['recurse'] = 'Visualitza també les preguntes de les subcategories';
$string['regrade'] = 'Torna a calcular les qualificacions';
$string['regradecomplete'] = 'S\'han tornat a calcular tots els intents';
$string['regradecount'] = 'S\'han modificat {$a->changed} de {$a->attempt} qualificacions';
$string['regradedisplayexplanation'] = 'Els intents que canvien durant el còmput es visualitzen com a enllaços a la finestra de revisió de les preguntes';
$string['regradenotallowed'] = 'No teniu permís per a tornar a qualificar aquest qüestionari';
$string['regradingquestion'] = 'S\'està recalculant "{$a}".';
$string['regradingquiz'] = 'S\'està requalificant el qüestionari "{$a}"';
$string['remove'] = 'Suprimeix';
$string['removeallquizattempts'] = 'Suprimeix tots els intents del qüestionari';
$string['removeemptypage'] = 'Elimina la pàgina buida';
$string['removeselected'] = 'Elimina la selecció';
$string['rename'] = 'Canvia el nom';
$string['renderingserverconnectfailed'] = 'El servidor {$a} no ha pogut processar una petició RQP. Comproveu que l\'URL és correcte.';
$string['reorderquestions'] = 'Reordena les preguntes';
$string['reordertool'] = 'Mostra l\'eina de reordenació';
$string['repaginate'] = 'Repagina amb {$a} preguntes per pàgina';
$string['repaginatecommand'] = 'Repagina';
$string['repaginatenow'] = 'Repagina ara';
$string['replace'] = 'Reemplaça';
$string['replacementoptions'] = 'Opcions de reemplaçament';
$string['report'] = 'Informes';
$string['reportanalysis'] = 'Anàlisi d\'elements';
$string['reportattemptsfrom'] = 'Intents des de';
$string['reportattemptsthatare'] = 'Intents que són';
$string['reportdisplayoptions'] = 'Visualitza les opcions';
$string['reportfullstat'] = 'Estadístiques detallada';
$string['reportmulti_percent'] = 'Percentatges múltiples';
$string['reportmulti_q_x_student'] = 'Opcions per estudiants múltiples';
$string['reportmulti_resp'] = 'Respostes individuals';
$string['reportmustselectstate'] = 'Heu de triar almenys un estat';
$string['reportnotfound'] = 'Informe desconegut ({$a})';
$string['reportoverview'] = 'Resum';
$string['reportregrade'] = 'Recalcula les qualificacions';
$string['reportresponses'] = 'Respostes detallades';
$string['reports'] = 'Informes';
$string['reportshowonly'] = 'Mostra només intents';
$string['reportshowonlyfinished'] = 'Mostra com a molt un intent acabat per l\'usuari ({$a})';
$string['reportsimplestat'] = 'Estadístiques simple';
$string['reportusersall'] = 'tots els usuaris que han intentat el qüestionari';
$string['reportuserswith'] = 'usuaris inscrits que han intentat el qüestionari';
$string['reportuserswithorwithout'] = 'usuaris inscrits que han intentat o no el qüestionari';
$string['reportuserswithout'] = 'usuaris inscrits que no han intentat el qüestionari';
$string['reportwhattoinclude'] = 'Què incloure en l\'informe';
$string['requirepassword'] = 'Demana contrasenya';
$string['requirepassword_help'] = '<p>Aquest camp és opcional.</p>

<p>Si especifiqueu una contrasenya aquí, els participants hauran d\'introduir aquesta contrasenya abans que se\'ls permeti contestar el qüestionari.</p>';
$string['requiresubnet'] = 'Restringeix adreces';
$string['requiresubnet_help'] = 'Podeu restringir l\'accés a un qüestionari a una subxarxa concreta de la xarxa local o d\'Internet si especifiqueu una llista d\'adreces IP numèriques, completes o parcials, separada per comes.

Això és especialment útil per a un qüestionari supervisat, quan voleu estar segurs que només es pot accedir al qüestionari des d\'una certa aula.

Per exemple:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

Podeu usar tres tipus de números (però no podeu usar noms de domini de text com ara exemple.com):
* Adreces IP completes, com ara  <b>192.168.10.1</b>, corresponents a un únic ordenador (o servidor intermediari).
* Adreces parcials, com ara <b>192.168</b>, que equivalen a qualsevol ordinador l\'adreça del qual comenci per aquests números.
* Notació CIDR, com ara <b>231.54.211.0/20</b>, que permet especificar subxarxes amb més detall.';
$string['response'] = 'Resposta';
$string['responses'] = 'Respostes';
$string['results'] = 'Resultats';
$string['returnattempt'] = 'Torna a l\'intent';
$string['reuseifpossible'] = 'reutilitzar les eliminades anteriorment';
$string['reverttodefaults'] = 'Retorna als paràmetres per defecte del qüestionari';
$string['review'] = 'Revisió';
$string['reviewafter'] = 'Permet revisar després que es tanqui el qüestionari';
$string['reviewalways'] = 'Permet revisar en qualsevol moment';
$string['reviewattempt'] = 'Revisa l\'intent';
$string['reviewbefore'] = 'Permet revisar mentre el qüestionari estigui obert';
$string['reviewclosed'] = 'Després que es tanqui el qüestionari';
$string['reviewduring'] = 'Mentre es fa l\'intent';
$string['reviewimmediately'] = 'Immediatament després de cada intent';
$string['reviewnever'] = 'No permetis revisar mai';
$string['reviewofattempt'] = 'Revisió de l\'intent {$a}';
$string['reviewofpreview'] = 'Revisió de la previsualització';
$string['reviewopen'] = 'Més tard, mentre encara estigui obert el qüestionari';
$string['reviewoptions'] = 'Els estudiants poden revisar';
$string['reviewoptionsheading'] = 'Opcions de revisió';
$string['reviewoptionsheading_help'] = 'Aquestes opcions controlen quina informació pot veure l\'estudiantat quan revise un intent del qüestionari o quan veu els informes del qüestionari.

**Durant l\'intent**, només rellevant per a alguns comportaments, com ara \'interactiu amb múltiples intents\', el qual pot mostrar retroaccions durant l\'intent.

**Immediatament després de cada intent**, durant els dos minuts següents després de fer clic en el botó "Envia i acaba".

**Més tard, mentre encara estigui obert el qüestionari**, després de passar els primers dos minuts i abans de la data de tancament del qüestionari.

**Després que es tanqui el qüestionari**, després que hagi passat la data de tancament del qüestionari. Si el qüestionari no té data de tancament, no s\'arribarà mai a aquest punt.';
$string['reviewoverallfeedback'] = 'Retroacció global';
$string['reviewoverallfeedback_help'] = 'La retroacció donada al final de l\'intent, depenent de la puntuació total de l\'estudiant.';
$string['reviewresponse'] = 'Revisa la resposta';
$string['reviewresponsetoq'] = 'Revisa la resposat (pregunta {$a})';
$string['reviewthisattempt'] = 'Reviseu les vostres respostes d\'aquest intent';
$string['rqp'] = 'Pregunta remota';
$string['rqps'] = 'Preguntes remotes';
$string['sameasoverall'] = 'La mateixa que les qualificacions globals';
$string['save'] = 'Desa';
$string['saveandedit'] = 'Desa els canvis i edita les preguntes';
$string['saveattemptfailed'] = 'No s\'ha pogut desar aquest intent del qüestionari';
$string['savedfromdeletedcourse'] = 'Procedent del curs suprimit "{$a}"';
$string['savegrades'] = 'Desa les qualificacions';
$string['savemyanswers'] = 'Desa les meves respostes';
$string['savenosubmit'] = 'Desa sense enviar';
$string['saveoverrideandstay'] = 'Desa i introdueix una altra excepció';
$string['savequiz'] = 'Desa tot el qüestionari';
$string['saving'] = 'Es desa';
$string['savingnewgradeforquestion'] = 'Es desa el valor de puntació per a la pregunta d\'identificador {$a}.';
$string['savingnewmaximumgrade'] = 'Es desa la puntuació màxima nova.';
$string['score'] = 'Puntuació bruta';
$string['scores'] = 'Puntuacions';
$string['select'] = 'Selecciona';
$string['selectall'] = 'Selecciona tot';
$string['selectcategory'] = 'Selecciona una categoria';
$string['selectedattempts'] = 'Intents seleccionats';
$string['selectnone'] = 'Desselecciona tot';
$string['selectquestiontype'] = '-- Selecciona un tipus de pregunta --';
$string['serveradded'] = 'S\'ha afegit el servidor';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Informació del servidor';
$string['servers'] = 'Servidors';
$string['serverurl'] = 'URL del servidor';
$string['settingsoverrides'] = 'Excepcions als paràmetres';
$string['shortanswer'] = 'Resposta breu';
$string['show'] = 'Mostra';
$string['showall'] = 'Mostra totes les preguntes en una pàgina';
$string['showblocks'] = 'Mostra els blocs durant els intents';
$string['showblocks_help'] = 'Si es manté actiu, els blocs laterals es veuran mentre es resol el qüestionari';
$string['showbreaks'] = 'Mostra salts de pàgina';
$string['showcategorycontents'] = 'Mostra el contingut de la categoria {$a->arrow}';
$string['showcorrectanswer'] = 'Voleu incloure la resposta correcta en la retroacció?';
$string['showdetailedmarks'] = 'Mostra detalls dels punts';
$string['showeachpage'] = 'Mostra només una pàgina';
$string['showfeedback'] = 'Voleu mostrar la retroacció després de contestar?';
$string['showinsecurepopup'] = 'Utilitza una finestra emergent \'segura\' per als intents';
$string['showlargeimage'] = 'Imatge gran';
$string['shownoattempts'] = 'Mostra els estudiants sense intents';
$string['shownoattemptsonly'] = 'Mostra només els estudiants que no tinguin intents';
$string['shownoimage'] = 'Sense imatge';
$string['showreport'] = 'Mostra l\'informe';
$string['showsmallimage'] = 'Imatge menuda';
$string['showteacherattempts'] = 'Mostra els intents del professorat';
$string['showuserpicture'] = 'Mostra la fotografia d\'usuari';
$string['showuserpicture_help'] = 'Si s\'activa, el nom i la fotografia de l\'estudiant apareixen a la pantalla mentre es realitza l\'intent, i a la pantalla de revisió, cosa que fa més fàcil comprovar que l\'alumne s\'ha identificat per si mateix en un entorn d\'examen.';
$string['shuffle'] = 'Barreja';
$string['shuffleanswers'] = 'Barreja respostes';
$string['shuffledrandomly'] = 'Barreja aleatòriament';
$string['shufflequestions'] = 'Barreja preguntes';
$string['shufflequestionsselected'] = 'S\'han barrejat les preguntes, i algunes accions referides a paginació no estaran disponibles. Per canviar les opcions de barreja, {$a}.';
$string['shufflewithin'] = 'Barreja dins de les preguntes';
$string['shufflewithin_help'] = 'Si activeu aquesta opció, les parts que componen una pregunta es barrejaran aleatòriament cada vegada que un/a estudiant entri al qüestionari, sempre que l\'opció estigui habilitada també en els paràmetres de la pregunta.

La intenció és simplement fer una mica més difícil que els estudiants copiïn els uns dels altres.

Aquesta opció només s\'aplica a preguntes que tinguin  diverses parts, com ara preguntes d\'opcions múltiples o d\'aparellar.';
$string['singleanswer'] = 'Trieu una resposta.';
$string['sortage'] = 'Ordena per temps';
$string['sortalpha'] = 'Ordena per nom';
$string['sortquestionsbyx'] = 'Ordena les preguntes per {$a}';
$string['sortsubmit'] = 'Ordena les preguntes';
$string['sorttypealpha'] = 'Ordena per tipus, títol';
$string['specificapathnotonquestion'] = 'Aquest camí de fitxer no es troba a la pregunta especificada.';
$string['specificquestionnotonquiz'] = 'La pregunta especificada no es troba al qüestionari especificat';
$string['startagain'] = 'Comença de nou';
$string['startattempt'] = 'Inicia l\'intent';
$string['startedon'] = 'Començat el';
$string['startnewpreview'] = 'Comença una altra previsualització';
$string['stateabandoned'] = 'Mai enviat';
$string['statefinished'] = 'Acabat';
$string['statefinisheddetails'] = 'Enviat {$a}';
$string['stateinprogress'] = 'En progrés';
$string['statenotloaded'] = 'L\'estat de la pregunta {$a} no s\'ha carregat de la base de dades';
$string['stateoverdue'] = 'Venciment';
$string['stateoverduedetails'] = 'Ha d\'enviar-se en {$a}';
$string['status'] = 'Estat';
$string['stoponerror'] = 'Atura\'t si es produeix un error';
$string['submitallandfinish'] = 'Envia i acaba';
$string['subneterror'] = 'Aquest qüestionari ha estat blocat i només és accessible des de certes ubicacions. A hores d\'ara el vostre ordinador no és un dels que han estat autoritzats.';
$string['subnetnotice'] = 'Aquest qüestionari ha estat blocat de manera que només sigui accessible des de certes ubicacions. El vostre ordinador no es troba en una subxarxa autoritzada. Tanmateix com a professor podeu previsualitzar-lo.';
$string['subplugintype_quiz'] = 'Informe';
$string['subplugintype_quizaccess'] = 'Regla d\'accés';
$string['subplugintype_quizaccess_plural'] = 'Regles d\'accés';
$string['subplugintype_quiz_plural'] = 'Informes';
$string['substitutedby'] = 'serà reemplaçat amb';
$string['summaryofattempt'] = 'Resum de l\'intent';
$string['summaryofattempts'] = 'Resum dels vostres intents anteriors';
$string['temporaryblocked'] = 'Temporalment no us és permès de tornar a contestar aquest qüestionari.<br />Podeu tornar a contestar-lo en:';
$string['theattempt'] = 'L\'intent';
$string['theattempt_help'] = 'Si l\'estudiant pot revisar l\'intent o no.';
$string['time'] = 'Temps';
$string['timecompleted'] = 'Completat';
$string['timedelay'] = 'No us permès de tornar a contestar aquest qüestionari perquè no heu deixat passar el temps estipulat per a nous intents.';
$string['timeleft'] = 'Temps restant';
$string['timelimit'] = 'Temps màxim';
$string['timelimitexeeded'] = 'Heu esgotat el temps';
$string['timelimit_help'] = 'Si està activat, el límit de temps s\'indica a la pàgina inicial del qüestionari i en el bloc de navegació del qüestionari es mostra un temporitzador de compte enrere.';
$string['timelimitmin'] = 'Temps màxim (minuts)';
$string['timelimitsec'] = 'Límit de temps (segons)';
$string['timestr'] = '%d/%m/%y - %H:%M:%S';
$string['timesup'] = 'Temps esgotat';
$string['timetaken'] = 'Temps emprat';
$string['timing'] = 'Temporització';
$string['tofile'] = 'al fitxer';
$string['tolerance'] = 'Tolerància';
$string['toomanyrandom'] = 'Es necessiten més preguntes aleatòries de les que hi ha en aquesta categoria.';
$string['top'] = 'Dalt';
$string['totalmarksx'] = 'Nombre de puntuacions: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} preguntes a la categoria.';
$string['true'] = 'Vertader';
$string['truefalse'] = 'Vertader/Fals';
$string['type'] = 'Tipus';
$string['unfinished'] = 'obre';
$string['ungraded'] = 'No qualificat';
$string['unit'] = 'Unitat';
$string['unknowntype'] = 'Tipus de pregunta incompatible a la línia {$a}. La pregunta s\'ha ignorat';
$string['unusedcategorydeleted'] = 'S\'ha suprimit aquesta categoria perquè, després de suprimir el curs, les seves preguntes ja no eren utilitzades en cap altre curs.';
$string['updatesettings'] = 'Actualitza els paràmetres del qüestionari';
$string['updatingatttemptgrades'] = 'Actualitza les puntuacions.';
$string['updatingfinalgrades'] = 'Actualitza les puntuacions finals';
$string['updatingthegradebook'] = 'Actualitza el llibre de qualificacions.';
$string['upgradesure'] = '<div>En particular el mòdul qüestionari efectuarà canvis generalitzats en les taules de la base de dades i aquesta actualització no s\'ha provat suficientment. És molt aconsellable que feu una còpia de seguretat de la base de dades abans de continuar.</div>';
$string['upgradingquizattempts'] = 'Actualització dels intents: qüestionari {$a->done}/{$a->outof} (Identificador {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Actualitza intents molt antics:  {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Aquesta categoria s\'ha mogut al nivell del lloc perquè és una categoria publicada que encara s\'utilitza en altres cursos.';
$string['useroverrides'] = 'Excepcions d\'usuari';
$string['usersnone'] = 'Els estudiants no poden accedir a aquest qüestionari';
$string['validate'] = 'Valida';
$string['viewallanswers'] = 'Visualitza {$a} qüestionaris completats';
$string['viewallreports'] = 'Visualitza informes per a {$a} intents';
$string['viewed'] = 'Vist';
$string['warningmissingtype'] = '<b>Aquesta pregunta és d\'un tipus no istaŀlat encara en el vostre Moodle.<br />Consulteu l\'administrador/a d\'aquest Moodle.</b>';
$string['wheregrade'] = 'On és la meva qualificació?';
$string['wildcard'] = 'Comodí';
$string['windowclosing'] = 'Aquesta finestra es tancarà aviat';
$string['withsummary'] = 'amb estadístiques de resum';
$string['wronguse'] = 'No podeu usar així aquesta pàgina';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Per a contestar aquest qüestionari heu d\'estar inscrit en aquest curs';
$string['yourfinalgradeis'] = 'La vostra qualificació final en aquest qüestionari és {$a}.';
