<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   questionnaire
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acció';
$string['additionalinfo'] = 'Informació complementària';
$string['additionalinfo_help'] = 'Text que es mostra a la primera pàgina de l\'enquesta. (p. ex. instruccions, informació, etc.)';
$string['addnewquestion'] = 'Afegeix-hi {$a} preguntes';
$string['addselqtype'] = 'Afegeix-hi una pregunta del tipus seleccionat';
$string['alignment'] = 'Alineació dels botons d\'opció';
$string['alignment_help'] = 'Alineació dels botons d\'opció: vertical (per defecte) o horitzontal.';
$string['all'] = 'Tot';
$string['alreadyfilled'] = 'Ja heu respost l\'enquesta anteriorment {$a}. Gràcies.';
$string['anonymous'] = 'Anònim/a';
$string['average'] = 'Mitjana';
$string['averagerank'] = 'Rang de mitjanes';
$string['bodytext'] = 'Cos del text';
$string['boxesnbexact'] = 'exactament {$a} quadre(s).';
$string['boxesnbmax'] = 'un màxim de {$a} quadre(s).';
$string['boxesnbmin'] = 'un mínim de {$a} quadre(s).';
$string['boxesnbreq'] = 'Per a aquesta pregunta heu de marcar';
$string['by'] = 'per';
$string['checkallradiobuttons'] = 'Si us plau, marqueu <strong>{$a}</strong> botons d\'opció!';
$string['checkboxes'] = 'Quadres de selecció';
$string['checkboxes_help'] = 'Escriviu una opció de selecció per línia';
$string['closed'] = 'L\'enquesta es va tancar el dia {$a}. Gràcies.';
$string['closedate'] = 'Estableix una data de tancament';
$string['closedate_help'] = 'Podeu indicar una data de tancament de l\'enquesta. Marqueu el selector i escolliu la data i l\'hora que vulgueu. Després d\'aquella data no es podrà respondre. Si no se selecciona, mai quedarà tancada.';
$string['confalts'] = '- O - <br />Pàgina de confirmació';
$string['confirmdelallresp'] = 'Esteu segur/a de que voleu esborrar TOTES les respostes d\'aquesta enquesta?';
$string['confirmdelgroupresp'] = 'Esteu segur/a de que voleu esborrar TOTES les respostes de {$a}?';
$string['confirmdelresp'] = 'Esteu segur/a de que voleu esborrar la resposta de  {$a} ?';
$string['confpage'] = 'Text de capçalera';
$string['confpagedesc'] = 'La capçalera (en negreta) i el cos de text de la pàgina de &quot;Confirmació&quot; que es mostra quan un usuari/ària ha acabat l\'enquesta. (Si s\'ha indicat un URL, passarà per davant del text de confirmació)';
$string['confpage_help'] = 'Capçalera (en negreta) i cos de text per a la pàgina de "Confirmació" que es mostra quan un usuari/ària ha acabat l\'enquesta. (Si s\'ha indicat un URL, passarà per davant del text de confirmació). Si deixeu aquest camp buit, es presenta un missatge predefinit en haver acabat. (Gràcies per haver completat aquesta enquesta).';
$string['contentoptions'] = 'Opcions de contingut';
$string['couldnotcreatenewsurvey'] = 'No es pot crear una altra enquesta';
$string['couldnotdelresp'] = 'No es pot esborrar la resposta';
$string['createcontent'] = 'Defineix el contingut nou';
$string['createcontent_help'] = 'Trieu un botó d\'opció. "Crea" és el valor predefinit.';
$string['createnew'] = 'Crea';
$string['date'] = 'Data';
$string['dateformatting'] = 'Utilitzeu el format dia/mes/any, per exemple, per l\'11 de setembre de 1714, <strong>11/9/1714</strong>';
$string['date_help'] = 'Utilitzeu aquest tipus de pregunta si espereu que la resposta sigui una data amb el format correcte.';
$string['deleteallresponses'] = 'Esborra TOTES les respostes';
$string['deletecurrentquestion'] = 'Esborra la pregunta {$a}';
$string['deletedallgroupresp'] = 'S\'han esborrat totes les respostes del grup {$a}';
$string['deletedresp'] = 'S\'ha esborrat la resposta';
$string['deleteresp'] = 'Esborra aquesta resposta';
$string['deletingresp'] = 'Esborrant la resposta';
$string['displaymethod'] = 'Forma de presentació de la pregunta sense definir.';
$string['download'] = 'Descarrega';
$string['downloadtextformat'] = 'Descarrega en format text';
$string['downloadtextformat_help'] = 'questa característica us permet desar totes les respostes d\'una enquesta en un fitxer de text (CSV).
Aquest fitxer el podeu importar en un full de càlcul (per exemple Calc del LibreOffice, o un full de MS Excel), o amb un paquet d\'anàlisi estadística per processar les dades.';
$string['dropdown'] = 'Llista de selecció';
$string['dropdown_help'] = 'No hi ha cap diferència entre usar la llista de selecció i els botó d\'opció excepte, potser, amb llistes d\'opcions molt llargues, perquè estalvien espai.';
$string['edit'] = 'Edita';
$string['editingquestionnaire'] = 'Edita els paràmetres del qüestionari';
$string['editquestion'] = 'Edita la pregunta {$a}';
$string['email'] = 'Correu electrònic';
$string['errnewname'] = 'Aquest nom ja es fa servir; si us plau, trieu-ne un altre.';
$string['erroropening'] = 'Error d\'obertura del qüestionari.';
$string['errortable'] = 'Error de corrupció de la taula.';
$string['essaybox'] = 'Quadre d\'edició llarg';
$string['essaybox_help'] = 'Aquesta pregunta presentarà un quadre d\'edició de text amb x columnes de text (amplada) i y línies de text (línies).

Si deixeu x i y en el seu valor de 0 (o els passeu a 0), es mostrarà l\'editor HTML del Moodle amb una amplada i alçada estàndards (això si es permet en el context del curs i al perfil de l\'usuari/ària)';
$string['feedbackerrorboundaryoutofrange'] = 'Els límits de la qualificació per a la retroacció han d\'estar entre el 0% i el 100%. El valor que heu introduït al límit {$a} està fora d\'aquests límits.';
$string['field'] = 'Pregunta {$a}';
$string['fieldlength'] = 'Longitud del quadre de text';
$string['fieldlength_help'] = 'Per a les preguntes del tipus **Quadre d\'edició**, indiqueu la **Longitud del quadre d\'edició** i la **Longitud màxima del text** del text que s\'hagi de lliurar com a resposta.

Els valors predefinits són 20 caràcters per al quadre d\'edició i 25 caràcters per a la longitud màxima del text.';
$string['grade'] = 'Nota de l\'enviament';
$string['headingtext'] = 'Text de capçalera';
$string['horizontal'] = 'Horitzontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Inclou els codis de selecció';
$string['includechoicetext'] = 'Inclou el text de selecció';
$string['incorrectcourseid'] = 'L\'identificador del curs és incorrecte';
$string['incorrectmodule'] = 'L\'identificador del mòdul del curs és incorrecte';
$string['incorrectquestionnaire'] = 'L\'enquesta és incorrecta';
$string['invalidresponse'] = 'La resposta especificada és incorrecta.';
$string['invalidresponserecord'] = 'El registre de la resposta indicat és incorrecte';
$string['invalidsurveyid'] = 'L\'identificador de l\'enquesta és incorrecte.';
$string['kindofratescale'] = 'Tipus d\'escala de valoració';
$string['length'] = 'Longitud';
$string['maxdigitsallowed'] = 'Màxim nombre de dígits permès';
$string['maxdigitsallowed_help'] = 'Si utilitzeu els paràmetres de màxim nombre de dígits permès i el nombre de dígits decimals, podeu indicar la longitud i el nombre de decimals demanats.';
$string['maxforcedresponses'] = 'Nombre màxim obligatori de respostes';
$string['maxtextlength'] = 'Longitud màxima del text';
$string['minforcedresponses'] = 'Nombre mínim obligatori de respostes';
$string['minforcedresponses_help'] = 'Utilitzeu aquests paràmetres per forçar als alumnes a marcar un mínim i un màxim de quadres de selecció. Per forçar un nombre exacte de seleccions, establiu el mínim i el màxim en el mateix valor. Si només voleu un mínim o un màxim, establiu-ne el valor i deixeu l\'altre a **0**.
Si establiu el mínim i/o el màxim de quadres marcats i la resposta no s\'ajusta a aquests marges, s\'emet un missatge d\'avís. Òbviament és millor que les persones que respondran l\'enquesta coneguin per endavant les condicions de resposta.';
$string['misconfigured'] = 'El curs no està ben configurat';
$string['modulename'] = 'Questionnaire';
$string['modulename_help'] = 'El mòdul Questionnaire permet construir enquestes utilitzant diferents tipologies de preguntes, amb la finalitat de recopilar dades dels usuaris.';
$string['modulenameplural'] = 'Questionnaires';
$string['myresponses'] = 'Totes les respostes';
$string['myresponsetitle'] = 'Les vostres {$a} respostes';
$string['myresults'] = 'Els vostres resultats';
$string['name'] = 'Nom';
$string['next'] = 'Següent';
$string['nextpage'] = 'Pàgina següent';
$string['noanswer'] = 'Sense resposta';
$string['nodata'] = 'No s\'ha enviat informació';
$string['noduplicates'] = 'No hi ha opcions duplicades';
$string['nopublicsurveys'] = 'No hi ha enquestes públiques';
$string['noresponsedata'] = 'No hi ha cap resposta per a aquesta pregunta';
$string['noresponses'] = 'No hi ha cap resposta';
$string['normal'] = 'Normal';
$string['notanumber'] = '<strong>{$a}</strong> no s\'accepta com a  format de número.';
$string['notapplicable'] = 'N/D';
$string['notapplicablecolumn'] = 'Columna N/D';
$string['notavail'] = 'Aquesta enquesta encara no està disponible. Proveu-ho més tard.';
$string['noteligible'] = 'No podeu fer aquesta enquesta';
$string['notemplatesurveys'] = 'No hi ha cap plantilla d\'enquesta';
$string['notopen'] = 'Aquesta enquesta s\'obrirà el dia {$a}.';
$string['num'] = '#';
$string['numberfloat'] = 'El número que heu escrit <strong>{$a->number}</strong> s\'ha arrodonit o se li ha canviat el format amb <strong>{$a->precision}</strong> xifres decimals.';
$string['numberofdecimaldigits'] = 'Nombre de xifres decimals';
$string['numberscaleitems'] = 'Nombre d\'elements de l\'escala';
$string['numberscaleitems_help'] = 'El nombre d\'elements de l\'escala és la quantitat d\'elements que té l\'escala de valoració. Normalment s\'utilitzen de 3 a 5 elements. El valor predefinit és **5**.';
$string['numeric'] = 'Numèric';
$string['numeric_help'] = 'Utilitzeu aquest tipus de pregunta si espereu un número amb un format determinat com a resposta.';
$string['of'] = 'de';
$string['opendate'] = 'Data d\'obertura';
$string['opendate_help'] = 'Podeu indicar una data per obrir l\'enquesta. Marqueu el quadre selecció i trieu la data i l\'hora. Els usuaris no podran emplenar l\'enquesta abans de la data. Si aquesta opció no està marcada, de seguida quedara oberta per respondre-la.';
$string['option'] = 'opció {$a}';
$string['optionalname'] = 'Nom de la pregunta';
$string['optionalname_help'] = 'El nom de la pregunta només s\'utilitza en exportar els resultats a format CSV o full de càlcul. Si sabeu que no fareu mai aquesta exportació, no cal que l\'escriviu.

Si heu d\'exportar habitualment dades de les enquestes a format CSV, podeu posar el nom de dues maneres diferents.';
$string['or'] = '- O -';
$string['order_ascending'] = 'Ordre ascendent';
$string['order_default'] = 'Mostra l\'ordre predefinit';
$string['order_descending'] = 'Ordre descendent';
$string['orderresponses'] = 'Ordena les respostes';
$string['orderresponses_help'] = 'En mostrar totes les respostes podeu ordenar-les pel nombre de respostes (la columna Mitja) amb aquest 4 tipus de preguntes:

* Quadres de selecció
* Menús desplegables
* Quadres de selecció múltiple
* Preguntes de qualificació (incloent-hi les escales Likert).

Quan arribeu a la pàgina de totes les respostes, les trobareu de manera predefinida segons l\'ordre de creació. Les podreu ordenar en ordre ascendent o descendent.';
$string['osgood'] = 'Osgood';
$string['other'] = 'Altres:';
$string['otherempty'] = 'Si marqueu aquesta opció heu d\'escriure alguna cosa al quadre de text!';
$string['overviewnumresplog'] = 'respostes';
$string['overviewnumresplog1'] = 'resposta';
$string['overviewnumrespvw'] = 'respostes';
$string['overviewnumrespvw1'] = 'resposta';
$string['owner'] = 'Propietari/ària';
$string['page'] = 'Pàgina';
$string['pageof'] = 'Pàgina {$a->page} de {$a->totpages}';
$string['pluginadministration'] = 'Administració del Questionnaire';
$string['pluginname'] = 'Questionnaire';
$string['possibleanswers'] = 'Respostes possibles';
$string['posteddata'] = 'S\'ha obtingut una pàgina amb dades:';
$string['previewing'] = 'Vista prèvia de l\'enquesta';
$string['preview_label'] = 'Vista prèvia';
$string['previous'] = 'Prèvia';
$string['previouspage'] = 'Pàgina anterior';
$string['print'] = 'Imprimeix aquesta resposta';
$string['printblank'] = 'Imprimeix en blanc';
$string['printblanktooltip'] = 'Obre una finestra amb una enquesta en blanc i preparada per a la seva impressió';
$string['printtooltip'] = 'Obre una finestra amb la resposta actual preparada per a la seva impressió';
$string['private'] = 'Privat';
$string['public'] = 'Públic';
$string['qtype'] = 'Tipus';
$string['qtypedaily'] = 'una resposta diària';
$string['qtype_help'] = 'Permet triar si els usuaris poden contestar una sola vegada, una vegada al dia, una vegada a la setmana, una vegada al mes o un nombre il·limitat de vegades';
$string['qtypemonthly'] = 'una resposta al mes';
$string['qtypeonce'] = 'una sola resposta';
$string['qtypeunlimited'] = 'respostes il·limitades';
$string['qtypeweekly'] = 'una resposta a la setmana';
$string['questionnaire:addinstance'] = 'Afegeix una nova enquesta';
$string['questionnaireadministration'] = 'Administració de l\'enquesta';
$string['questionnairecloses'] = 'Tancament de l\'enquesta';
$string['questionnaire:copysurveys'] = 'Copia les plantilles i les enquestes privades';
$string['questionnaire:createpublic'] = 'Crea enquestes públiques';
$string['questionnaire:createtemplates'] = 'Crea plantilles d\'enquestes';
$string['questionnaire:deleteresponses'] = 'Esborra qualsevol resposta';
$string['questionnaire:downloadresponses'] = 'Descarrega les respostes en un fitxer CSV';
$string['questionnaire:editquestions'] = 'Crea i edita preguntes de l\'enquesta';
$string['questionnaire:manage'] = 'Crea i edita enquestes';
$string['questionnaireopens'] = 'Obertura de l\'enquesta';
$string['questionnaire:printblank'] = 'Imprimeix una enquesta en blanc';
$string['questionnaire:readallresponseanytime'] = 'Llegeix les respostes en qualsevol moment';
$string['questionnaire:readallresponses'] = 'Llegeix un resum de respostes, subjecte al període en que l\'enquesta estigui oberta';
$string['questionnaire:readownresponses'] = 'Llegeix les respostes pròpies';
$string['questionnairereport'] = 'Informe de l\'enquesta';
$string['questionnaire:submit'] = 'Completa i tramet l\'enquesta';
$string['questionnaire:view'] = 'Mostra una enquesta';
$string['questionnaire:viewsingleresponse'] = 'Visualitza les respostes individuals completes';
$string['questionnum'] = 'Pregunta #';
$string['questions'] = 'Preguntes';
$string['questiontypes'] = 'Tipus de preguntes';
$string['questiontypes_help'] = 'Vegeu la documentació del Moodle al dessota';
$string['radiobuttons'] = 'Botons d\'opció';
$string['radiobuttons_help'] = 'En aquest tipus de pregunta, l\'enquestat ha de triar una de les opcions que s\'ofereixen';
$string['rank'] = 'Interval';
$string['ratescale'] = 'Qualifica (escala 1..5)';
$string['ratescale_help'] = 'Vegeu la documentació del Moodle';
$string['realm'] = 'Tipus d\'enquesta';
$string['realm_help'] = '* **Hi ha tres tipus d\'enquestes:**
* Privades: pertanyen només al curs on es defineixen.
* Plantilles: es poden copiar i editar.
* Públiques: es poden compartir entre cursos.';
$string['redirecturl'] = 'La URL cap a on es redirecciona l\'usuari/ària després de completar l\'enquesta';
$string['remove'] = 'Esborra';
$string['required_help'] = 'Si marqueu ***Sí***, es requerirà una resposta a aquesta pregunta, és a dir, no es podrà trametre l\'enquesta fins que s\'hagi respost a aquesta pregunta';
$string['requiredparameter'] = 'S\'ha deixat en blanc algun paràmetre obligatori.';
$string['reset'] = 'Reinicia';
$string['respeligiblerepl'] = '(substituït per les excepcions dels rols)';
$string['respondent'] = 'Enquestat/enquestada';
$string['respondenteligibleall'] = 'tot';
$string['respondenteligiblestudents'] = 'només estudiants';
$string['respondenteligibleteachers'] = 'només professorat';
$string['respondents'] = 'Enquestats';
$string['respondenttype'] = 'Tipus d\'enquestat';
$string['respondenttypeanonymous'] = 'anònim';
$string['respondenttypefullname'] = 'nom complet';
$string['respondenttype_help'] = 'Podeu visualitzar els noms complets dels usuaris amb cada resposta si marqueu l\'opció "nom complet".
Podeu mantenir l\'anonimat de les respostes marcant l\'opció "anònim".';
$string['response'] = 'Resposta';
$string['responseoptions'] = 'Opcions de resposta';
$string['responses'] = 'Respostes';
$string['responseview'] = 'Els estudiants poden veure TOTES les respostes';
$string['responseview_help'] = 'Podeu especificar qui pot veure les respostes de tots els enquestats de les enquestes enviades (taules d\'estadístiques generals).';
$string['responseviewstudentsalways'] = 'Sempre';
$string['responseviewstudentsnever'] = 'Mai';
$string['responseviewstudentswhenanswered'] = 'Després de respondre l\'enquesta';
$string['responseviewstudentswhenclosed'] = 'Després de tancar l\'enquesta';
$string['restrictedtoteacher'] = 'Aquestes funcionalitats només són per al professorat editor!';
$string['resume'] = 'Desa/Recupera les respostes';
$string['resume_help'] = 'Marcar aquesta opció permet que els usuaris puguin desar les respostes d\'una enquesta abans d\'enviar-la. Poden deixar l\'enquesta a mig fer i recuperar-la en el punt que l\'havien deixat un altre dia.';
$string['resumesurvey'] = 'Recupera l\'enquesta';
$string['return'] = 'Torna';
$string['save'] = 'Desa';
$string['saveasnew'] = 'Desa com a pregunta nova';
$string['saveeditedquestion'] = 'Desa la pregunta {$a}';
$string['savesettings'] = 'Desa els paràmetres';
$string['section'] = 'Descripció';
$string['sectionbreak'] = '----- Salt de pàgina -----';
$string['sectionbreak_help'] = '----- Salt de pàgina -----';
$string['sectiontext'] = 'Etiqueta';
$string['sectiontext_help'] = 'Això no és una pregunta sinó un text (curt) que es mostrarà per introduir una sèrie de preguntes.';
$string['selecttheme'] = 'Seleccioneu un tema (css) per usar amb aquesta enquesta.';
$string['sendemail'] = 'Envia un missatge de correu electrònic';
$string['sendemail_help'] = 'Envia una còpia de cada tramesa a les adreces de correu electrònic especificades.
Podeu escriure més d\'una adreça separant-les amb comes.
Deixeu el camp en blanc si no voleu enviar còpies per correu electrònic.';
$string['settings'] = 'Paràmetres';
$string['settingssaved'] = 'Paràmetres desats';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['submitoptions'] = 'Opcions de tramesa';
$string['submitsurvey'] = 'Tramet l\'enquesta';
$string['submitted'] = 'Enviada el:';
$string['subtitle'] = 'Subtítol';
$string['subtitle_help'] = 'Subtítol d\'aquesta enquesta. Apareix a sota del títol, només a la primera pàgina.';
$string['summary'] = 'Resum';
$string['surveynotexists'] = 'Aquesta enquesta no existeix';
$string['surveyowner'] = 'Heu de ser el propietari/ària de l\'enquesta per dur a terme aquesta operació.';
$string['surveyresponse'] = 'Resposta de l\'enquesta';
$string['template'] = 'Plantilla';
$string['templatenotviewable'] = 'Les plantilles d\'enquestes no es poden visualitzar.';
$string['text'] = 'Text de la pregunta';
$string['textareacolumns'] = 'Columnes d\'àrees de text';
$string['textareacolumns_help'] = 'Aquesta pregunta mostrarà un quadre d\'edició de text simple amb **x** columnes (o una mida *width*) i **y** files.
Si manteniu x i y amb els seus valors predefinits (o si el poseu a **0**), es mostrarà l\'editor HTML amb l\'amplada i l\'alçada estàndards (sempre i quan estigui disponible en el context d\'usuari o de curs).';
$string['textarearows'] = 'Files del quadre d\'edició de text';
$string['textbox'] = 'Quadre d\'edició del text';
$string['textbox_help'] = 'Al tipus del quadre d\'edició de text, indiqueu la longitud del quadre i la longitud màxima del text que podrà escriure l\'enquestat.
Els valors predefinits són 20 caràcters d\'amplada del quadre, i 25 caràcters per a la longitud màxima del text.';
$string['textdownloadoptions'] = 'Opcions per la descàrrega de text (CSV';
$string['thank_head'] = 'Gràcies per haver completat l\'enquesta.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'aquest mes';
$string['thisweek'] = 'aquesta setmana';
$string['title'] = 'Títol';
$string['title_help'] = 'Títol de l\'enquesta, que apareixerà a la part superior de cada pàgina. Per defecte, aquest títol és el nom de l\'enquesta, però podeu editar-lo i deixar-lo com vulgueu.';
$string['today'] = 'avui';
$string['total'] = 'Total';
$string['type'] = 'Tipus de pregunta';
$string['undefinedquestiontype'] = 'Tipus de pregunta no definit!';
$string['unknown'] = 'Desconegut';
$string['unknownaction'] = 'Acció de l\'enquesta desconeguda ...';
$string['url'] = 'URL de confirmació';
$string['url_help'] = 'URL al qual s\'adreçarà un usuari/ària després de completar l\'enquesta.';
$string['usepublic'] = 'Ús públic';
$string['usetemplate'] = 'Copia l\'existent';
$string['vertical'] = 'Vertical';
$string['view'] = 'Vista';
$string['viewallresponses'] = 'Mostra totes les respostes';
$string['viewallresponses_help'] = 'Si l\'enquesta s\'estableix a **Mode de grup**: *Grups visibles*, o a *Grups separats* i l\'usuari/ària té el permís *moodle/site:accessallgroups* (en el context actual); i s\'han establert grups al curs, aleshores l\'usuari/ària podrà accedir a una llista desplegable de grups.
Aquesta llista permet que l\'usuari "filtri" les respostes per grups.
Si el paràmetre és **Mode de grup**: *Grups separats*, els usuaris que no tinguin el permís *moodle/site:accessallgroups* (habitualment estudiants o professorat no-editor) no podran veure les respostes del(s) grup(s) als quals pertanyen.';
$string['viewresponses'] = 'Totes les respostes ({$a})';
$string['viewyourresponses'] = 'Les vostres respostes - mostra {$a}';
$string['warning'] = 'Atenció, s\'ha trobat un error!';
$string['wrongdateformat'] = 'La data que introduïda: <strong>{$a}</strong> no es correspon amb el format que mostra l\'exemple.';
$string['wrongdaterange'] = 'Atenció: l\'any ha d\'estar en el rang de 1902 a 2037.';
$string['yesno'] = 'Sí/No';
$string['yesno_help'] = 'Pregunta simple de Sí o No';
