<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 's\'instal·larà ara';
$string['action'] = 'Acció';
$string['actionchoice'] = 'Què voleu fer amb el fitxer \'{$a}\'?';
$string['actions'] = 'Accions';
$string['active'] = 'Actiu';
$string['activeusers'] = 'Usuaris actius';
$string['activities'] = 'Activitats';
$string['activities_help'] = 'Les activitats, com ara fòrums, qüestionaris i wikis, permeten afegir continguts interactius al curs.';
$string['activity'] = 'Activitat';
$string['activityclipboard'] = 'S\'està movent aquesta activitat: {$a}';
$string['activityiscurrentlyhidden'] = 'Actualment aquesta activitat està oculta';
$string['activitymodule'] = 'Mòdul d\'activitat';
$string['activitymodules'] = 'Mòduls d\'activitat';
$string['activityreport'] = 'Informe d\'activitat';
$string['activityreports'] = 'Informes d\'activitat';
$string['activityselect'] = 'Seleccioneu aquesta activitat per moure-la a un altre lloc';
$string['activitysince'] = 'Activitat des de {$a}';
$string['activityweighted'] = 'Activitat per usuari';
$string['add'] = 'Afegeix';
$string['addactivity'] = 'Afegeix una activitat...';
$string['addactivitytosection'] = 'Afegeix una activitat a la secció  \'{$a}\'';
$string['addadmin'] = 'Afegeix administrador/a';
$string['addblock'] = 'Afegeix un bloc';
$string['addcomment'] = 'Afegeix un comentari...';
$string['addcountertousername'] = 'Crea usuari afegint un número al nom d\'usuari';
$string['addcreator'] = 'Afegeix creador/a de cursos';
$string['adddots'] = 'Afegeix...';
$string['added'] = 'S\'ha afegit {$a}';
$string['addedrecip'] = 'S\'ha afegit un nou {$a} destinatari';
$string['addedrecips'] = 'S\'han afegit nous {$a} destinataris';
$string['addedtogroup'] = 'S\'ha afegit al grup {$a}';
$string['addedtogroupnot'] = 'No s\'ha afegit al grup {$a}';
$string['addedtogroupnotenrolled'] = 'No s\'ha afegit al grup {$a} perquè aquesta persona no està inscrita al curs';
$string['addfilehere'] = 'Afegeix fitxer(s) aquí';
$string['addinganew'] = 'S\'està afegint un nou {$a}';
$string['addinganewto'] = 'S\'està afegint un nou {$a->what} a {$a->to}';
$string['addingdatatoexisting'] = 'S\'estan afegint dades a les existents';
$string['additionalnames'] = 'Noms addicionals';
$string['addlinkhere'] = 'Afegeix un enllaç aquí';
$string['addnewcategory'] = 'Afegeix una nova categoria';
$string['addnewcourse'] = 'Afegeix un nou curs';
$string['addnewuser'] = 'Afegeix un nou usuari';
$string['addnousersrecip'] = 'Afegeix a la llista de destinataris els usuaris que no han accedit a aquest {$a}';
$string['addpagehere'] = 'Afegeix text aquí';
$string['addresource'] = 'Afegeix un recurs...';
$string['addresourceoractivity'] = 'Afegeix una activitat o un recurs';
$string['addresourcetosection'] = 'Afegeix un recurs a la secció  \'{$a}\'';
$string['address'] = 'Adreça';
$string['addstudent'] = 'Afegeix estudiant';
$string['addsubcategory'] = 'Afegeix una subcategoria';
$string['addteacher'] = 'Afegeix professor/a';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Creeu manualment un nou compte d\'usuari';
$string['adminhelpassignadmins'] = 'Els administradors poden fer-ho tot i anar arreu en aquest lloc web';
$string['adminhelpassigncreators'] = 'Els creadors poden crear nous cursos';
$string['adminhelpassignsiteroles'] = 'Apliqueu rols definits al lloc a usuaris específics';
$string['adminhelpassignstudents'] = 'Feu clic damunt del nom d\'un curs i afegiu-hi els estudiants des del menú d\'administració';
$string['adminhelpauthentication'] = 'Podeu fer servir comptes d\'usuari interns o bé una base de dades externa';
$string['adminhelpbackup'] = 'Configureu i programeu les còpies de seguretat automàtiques';
$string['adminhelpconfiguration'] = 'Configureu l\'aparença i el funcionament del lloc';
$string['adminhelpconfigvariables'] = 'Configureu les variables que afecten el funcionament general del lloc';
$string['adminhelpcourses'] = 'Definiu cursos i categories i assigneu-los persones';
$string['adminhelpeditorsettings'] = 'Definiu els paràmetres bàsics de l\'editor HTML';
$string['adminhelpedituser'] = 'Navegueu per la llista de comptes d\'usuari i editeu-los';
$string['adminhelpenvironment'] = 'Comproveu si el vostre servidor s\'acomoda als requeriments d\'instal·lació actuals i futurs';
$string['adminhelpfailurelogs'] = 'Explora els registres d\'entrades fracassades';
$string['adminhelplanguage'] = 'Comproveu i editeu el paquet de llenguatge actual';
$string['adminhelplogs'] = 'Navegueu pels registres de tota l\'activitat d\'aquest lloc';
$string['adminhelpmanageblocks'] = 'Gestioneu els blocs instal·lats i els seus paràmetres';
$string['adminhelpmanagedatabase'] = 'Accediu directament a la base de dades (tingueu compte!)';
$string['adminhelpmanagefilters'] = 'Trieu els filtres de text i paràmetres relacionats';
$string['adminhelpmanagemodules'] = 'Gestioneu els mòduls instal·lats i els seus paràmetres';
$string['adminhelpmanageroles'] = 'Creeu i definiu rols que poden aplicar-se als usuaris';
$string['adminhelpmymoodle'] = 'Configureu els blocs "El meu moodle" dels usuaris';
$string['adminhelpreports'] = 'Informes del lloc';
$string['adminhelpsitefiles'] = 'Publiqueu fitxers generals o pengeu còpies de seguretat externes';
$string['adminhelpsitesettings'] = 'Definiu l\'aparença de la pàgina inicial del lloc';
$string['adminhelpstickyblocks'] = 'Configureu els blocs fixos de tot el lloc';
$string['adminhelpthemes'] = 'Trieu l\'aparença del lloc (colors, tipus de lletra, etc)';
$string['adminhelpuploadusers'] = 'Importeu nous comptes d\'usuari des d\'un fitxer de text';
$string['adminhelpusers'] = 'Definiu els usuaris i configureu l\'autenticació';
$string['adminhelpxmldbeditor'] = 'Interfície d\'edició dels fitxers XMLDB. Només per a desenvolupadors.';
$string['administration'] = 'Administració';
$string['administrationsite'] = 'Administració del lloc';
$string['administrator'] = 'Administrador';
$string['administratordescription'] = 'Generalment els administradors poden fer qualsevol cosa en el lloc, en tots els cursos.';
$string['administrators'] = 'Administradors';
$string['administratorsall'] = 'Tots els administradors';
$string['administratorsandteachers'] = 'Administradors i professors';
$string['advanced'] = 'Avançat';
$string['advancedfilter'] = 'Cerca avançada';
$string['advancedsettings'] = 'Paràmetres avançats';
$string['afterresource'] = 'Després del recurs «{$a}»';
$string['aftersection'] = 'Després de la secció «{$a}»';
$string['again'] = 'una altra vegada';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX i Javascript';
$string['all'] = 'Tots';
$string['allactions'] = 'Totes les accions';
$string['allactivities'] = 'Totes les activitats';
$string['allcategories'] = 'Totes les categories';
$string['allchanges'] = 'Tots els canvis';
$string['alldays'] = 'Tots els dies';
$string['allfieldsrequired'] = 'Tots els camps són necessaris';
$string['allfiles'] = 'Tots els fitxers';
$string['allgroups'] = 'Tots els grups';
$string['alllogs'] = 'Tots els registres';
$string['allmods'] = 'Tots els {$a}';
$string['allow'] = 'Permet';
$string['allowinternal'] = 'Permet també els mètodes interns';
$string['allownone'] = 'No permetis res';
$string['allownot'] = 'No permetis';
$string['allparticipants'] = 'Tots els participants';
$string['allteachers'] = 'Tots els professors';
$string['alphanumerical'] = 'Només pot contenir caràcters alfanumèrics, el guió (-) o el punt (.)';
$string['alreadyconfirmed'] = 'Ja se us ha confirmat el registre';
$string['alternatename'] = 'Nom alternatiu';
$string['always'] = 'Sempre';
$string['and'] = '{$a->one} i {$a->two}';
$string['answer'] = 'Resposta';
$string['any'] = 'Qualsevol';
$string['appearance'] = 'Aparença';
$string['approve'] = 'Aprova';
$string['areyousure'] = 'Segur que voleu tirar endavant aquesta acció?';
$string['areyousuretorestorethis'] = 'Voleu continuar?';
$string['areyousuretorestorethisinfo'] = 'Més endavant tindreu l\'opció d\'afegir aquesta còpia de seguretat a un curs existent o crear un curs completament nou.';
$string['asc'] = 'Ascendent';
$string['assessment'] = 'Avaluació';
$string['assignadmins'] = 'Assigna administradors';
$string['assigncreators'] = 'Assigna creadors de cursos';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Assigna rols de tot el lloc';
$string['authenticateduser'] = 'Usuari autenticat';
$string['authenticateduserdescription'] = 'Tots aquells usuaris que hagin entrat.';
$string['authentication'] = 'Autenticació';
$string['authenticationplugins'] = 'Connectors d\'autenticació';
$string['autosubscribe'] = 'Subscripció automàtica al fòrum';
$string['autosubscribeno'] = 'No: no em subscriguis automàticament als fòrums';
$string['autosubscribeyes'] = 'Sí: quan escrigui en un fòrum, subscriu-me a aquest fòrum';
$string['availability'] = 'Disponibilitat';
$string['availablecourses'] = 'Cursos disponibles';
$string['back'] = 'Enrere';
$string['backto'] = 'Torna a {$a}';
$string['backtocourselisting'] = 'Torna a la llista de cursos';
$string['backtopageyouwereon'] = 'Torna a la pàgina anterior';
$string['backtoparticipants'] = 'Torna a la llista de participants';
$string['backup'] = 'Còpia de seguretat';
$string['backupactivehelp'] = 'Trieu si voleu fer còpies de seguretat automàtiques o no.';
$string['backupcancelled'] = 'S\'ha cancel·lat la còpia de seguretat';
$string['backupcoursefileshelp'] = 'Si habiliteu aquesta opció els fitxers del curs s\'inclouran a les còpies de seguretat automàtiques.';
$string['backupdate'] = 'Data de la còpia de seguretat';
$string['backupdatenew'] = '{$a->TAG} és ara {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} era {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Informació sobre la còpia de seguretat';
$string['backupexecuteathelp'] = 'Trieu a quina hora s\'haurien de realitzar les còpies de seguretat automàtiques.';
$string['backupfailed'] = 'Alguns cursos no s\'han desat!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'La còpia de seguretat s\'ha completat amb èxit';
$string['backupfromthissite'] = 'La còpia es va fer en aquest lloc?';
$string['backupgradebookhistoryhelp'] = 'Si habiliteu aquesta opció, l\'historial del butlletí de qualificacions s\'inclourà en les còpies de seguretat automàtiques. Però teniu en compte que això no funcionarà si l\'historial de qualificacions està inhabilitat al servidor (disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Trieu si voleu incloure els mòduls del curs, amb o sense dades dels usuaris, a les còpies de seguretat automàtiques.';
$string['backupincludemoduleuserdatahelp'] = 'Trieu si voleu incloure dades d\'usuari dels mòduls en les còpies de seguretat automàtiques.';
$string['backupkeephelp'] = 'Quantes còpies de seguretat recents de cada curs voleu conservar? (les més velles s\'esborraran automàticament).';
$string['backuplogdetailed'] = 'Registre d\'execució detallat';
$string['backuploglaststatus'] = 'Registre de la darrera execució';
$string['backupmissinguserinfoperms'] = 'Nota: aquesta còpia de seguretat no conté dades d\'usuari. Les activitats de Taller i Exercici no s\'inclouran a la còpia, ja que aquests mòduls no són compatibles amb aquest tipus de còpia seguretat.';
$string['backupnext'] = 'Còpia de seguretat següent';
$string['backupnonisowarning'] = 'Avís: aquesta còpia de seguretat és d\'una versió de Moodle no Unicode (anterior a la 1.6). Si la còpia conté textos que no siguin ISO-8859-1, aquests textos es poden corrompre quan intenteu restaurar-los en aquesta versió Unicode de Moodle. Vegeu les <a href="http://docs.moodle.org/en/Backup_FAQ">PMF de còpies de seguretat</a> per a més informació sobre la manera de restaurar correctament aquesta còpia.';
$string['backupnotyetrun'] = 'Còpies de seguretat automatitzades pendents';
$string['backuporiginalname'] = 'Nom de la còpia de seguretat';
$string['backuproleassignments'] = 'Fes còpia de seguretat de les assignacions de rols d\'aquests rols';
$string['backupsavetohelp'] = 'Camí complet del directori on voleu desar els fitxers de còpies de seguretat<br />(deixeu en blanc per desar-los al directori per defecte del curs)';
$string['backupsitefileshelp'] = 'Si activeu aquest paràmetre, els fitxers del lloc utilitzats en cursos s\'inclouran en les còpies de seguretat automàtiques';
$string['backuptakealook'] = 'Si us plau doneu una ullada als registres de la còpia de seguretat:
{$a}';
$string['backupuserfileshelp'] = 'Trieu si voleu que els fitxers dels usuaris (p. e. la imatge del perfil) s\'incloguin a les còpies de seguretat automàtiques';
$string['backupversion'] = 'Versió de la còpia de seguretat';
$string['badges'] = 'Insígnies';
$string['block'] = 'Bloc';
$string['blockconfiga'] = 'S\'està configurant un bloc {$a}';
$string['blockconfigbad'] = 'Aquest bloc no s\'ha implementat correctament i no pot proporcionar una interfície de configuració.';
$string['blocks'] = 'Blocs';
$string['blocksaddedit'] = 'Afegeix/edita blocs';
$string['blockseditoff'] = 'Desactiva edició de blocs';
$string['blocksediton'] = 'Activa edició de blocs';
$string['blocksetup'] = 'S\'estan configurant les taules de blocs';
$string['blocksuccess'] = 'S\'han configurat correctament les taules {$a}';
$string['brief'] = 'Menys detall';
$string['bulkactions'] = 'Accions massives';
$string['bulkactionselect'] = 'Selecció de l\'acció massiva {$a}';
$string['bulkmovecoursessuccess'] = 'S\'han mogut amb èxit els cursos {$a->courses} dins de la categoria  {$a->category}';
$string['bycourseorder'] = 'Curs';
$string['byname'] = '{$a}';
$string['bypassed'] = 'S\'ha deixat de banda';
$string['cachecontrols'] = 'Controls de la memòria cau';
$string['cancel'] = 'Cancel·la';
$string['cancelled'] = 'S\'ha cancel·lat';
$string['categories'] = 'Categories de cursos';
$string['categoriesandcoures'] = 'Cursos i categories de cursos';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'S\'ha afegit la categoria \'{$a}\'';
$string['categorybulkaction'] = 'Accions massives per a les categories seleccionades';
$string['categorycontents'] = 'Subcategories i cursos';
$string['categorycurrentcontents'] = 'Continguts de: {$a}';
$string['categorydeleted'] = 'S\'ha suprimit la categoria \'{$a}\'';
$string['categoryduplicate'] = 'Ja existeix una categoria anomenada \'{$a}\'!';
$string['categorymodifiedcancel'] = 'La categoria ha estat modificada. Cancel·leu i torneu a intentar-ho.';
$string['categoryname'] = 'Nom de la categoria';
$string['categorysubcategoryof'] = '{$a->category} - subcategoria de {$a->parentcategory}';
$string['categoryupdated'] = 'S\'ha actualitzat la categoria \'{$a}\'.';
$string['changedpassword'] = 'S\'ha canviat la contrasenya';
$string['changepassword'] = 'Canvia la contrasenya';
$string['changesmadereallygoaway'] = 'Heu fet canvis. Esteu segurs que voleu navegar fóra i perdre els canvis?';
$string['changessaved'] = 'S\'han desat els canvis';
$string['check'] = 'Reviseu';
$string['checkall'] = 'Activa tot';
$string['checkingbackup'] = 'S\'està comprovant la còpia de seguretat';
$string['checkingcourse'] = 'S\'està comprovant el curs';
$string['checkingforbbexport'] = 'S\'està fent la comprovació per exportar a BlackBoard';
$string['checkinginstances'] = 'S\'estan comprovant les instàncies';
$string['checkingsections'] = 'S\'estan comprovant les seccions';
$string['checklanguage'] = 'Comprova l\'idioma';
$string['checknone'] = 'Desactiva tot';
$string['childcoursenotfound'] = 'No s\'ha trobat el curs fill';
$string['childcourses'] = 'Cursos fills';
$string['choose'] = 'Tria';
$string['choosecourse'] = 'Tria un curs';
$string['choosedots'] = 'Tria...';
$string['chooselivelogs'] = 'O observeu els registres en directe';
$string['chooselogs'] = 'Trieu quins registres voleu veure';
$string['choosereportfilter'] = 'Tria un filtre per a l\'informe';
$string['choosetheme'] = 'Tria tema';
$string['chooseuser'] = 'Tria un usuari';
$string['city'] = 'Població';
$string['clambroken'] = 'L\'administrador ha habilitat la comprovació de virus, però hi ha algun error de configuració.<br />El vostre fitxer NO s\'ha pogut penjar. S\'ha enviat un correu de notificació a l\'administrador per tal que pugui arreglar-ho.<br />Proveu a penjar el fitxer en un altre moment.';
$string['clamdeletedfile'] = 'S\'ha suprimit el fitxer';
$string['clamdeletedfilefailed'] = 'No s\'ha pogut suprimir el fitxer';
$string['clamemailsubject'] = '{$a} :: Notificació Clam AV';
$string['clamfailed'] = 'No s\'ha pogut executar Clam AV. El missatge d\'error retornat es {$a}. Heus aquí la sortida de Clam:';
$string['clamlost'] = 'Moodle ha estat configurat per executar Clam amb cada fitxer que es pengi, pero el camí de Clam AV proporcionat, {$a}, no és vàlid.';
$string['clamlostandactinglikevirus'] = 'A més a més, Moodle està configurat de manera que si Clam no es pot executar, els fitxers es tracten com si fossin virus. Això significa que els estudiants no podran penjar cap fitxer mentre no solucioneu el problema.';
$string['clammovedfile'] = 'S\'ha mogut el fitxer al directori de quarantena especificat. La nova ubicació és {$a}.';
$string['clammovedfilebasic'] = 'S\'ha mogut el fitxer a un directori de quarantena.';
$string['clamquarantinedirfailed'] = 'No es pot moure el fitxer al directori de quarantena especificat {$a}. Fins que solucioneu aquest problema els fitxers infectats seran suprimits.';
$string['clamunknownerror'] = 'Error desconegut de Clam.';
$string['cleaningtempdata'] = 'S\'estan netejant les dades temporals';
$string['clear'] = 'Suprimeix';
$string['clickhelpiconformoreinfo'] = '... continua ... Feu clic en la icona d\'ajuda per llegir l\'article complet';
$string['clickhere'] = 'Feu clic aquí...';
$string['clicktochangeinbrackets'] = '{$a} Prem per canviar';
$string['clicktohideshow'] = 'Feu clic per ampliar o reduir';
$string['closebuttontitle'] = 'Tanca';
$string['closewindow'] = 'Tanca aquesta finestra';
$string['collapse'] = 'Redueix';
$string['collapseall'] = 'Redueix tot';
$string['collapsecategory'] = 'Redueix {$a}';
$string['commentincontext'] = 'Mostra aquest comentari en context';
$string['comments'] = 'Comentaris';
$string['commentsnotenabled'] = 'La característica de comentaris no està habilitada';
$string['commentsrequirelogin'] = 'Us cal entrar amb el nom d\'usuari i contrasenya per veure els comentaris';
$string['comparelanguage'] = 'Compara i edita l\'idioma actual';
$string['complete'] = 'Complet';
$string['completereport'] = 'Informe complet';
$string['configuration'] = 'Configuració';
$string['confirm'] = 'Confirma';
$string['confirmcheckfull'] = 'Esteu absolutament segur que voleu confirmar {$a}?';
$string['confirmcoursemove'] = 'Esteu segur de voler moure aquest curs ({$a->course}) dins d\'aquesta categoria  ({$a->category})?';
$string['confirmed'] = 'S\'ha confirmat el vostre registre';
$string['confirmednot'] = 'Encara no s\'ha confirmat el vostre registre!';
$string['content'] = 'Contingut';
$string['continue'] = 'Continua';
$string['continuetocourse'] = 'Feu clic aquí per entrar al curs';
$string['convertingwikitomarkdown'] = 'S\'està convertint el wiki a Markdown';
$string['cookiesenabled'] = 'Les galetes han d\'estar habilitades en el vostre navegador';
$string['cookiesenabled_help'] = '<p>Aquest lloc utilitza dues galetes.</p>

<p>L\'essencial &eacute;s la galeta de sessi&oacute;, generalment anomenada <b>MoodleSession</b>. Heu d\'admetre aquesta galeta al vostre navegador per donar continu&iuml;tat i mantenir la connexi&oacute; al llarg de les diferents p&agrave;gines. Quan sortiu o tanqueu el navegador aquesta galeta es destrueix (al vostre ordinador i al servidor).</p>

<p>L\'altra galeta, anomenada sovint <b>MOODLEID</b>, &eacute;s purament de conveni&egrave;ncia. Simplement recorda el vostre nom d\'usuari dins del navegador. Aix&ograve; vol dir que quan torneu a aquest lloc el camp d\'usuari de la p&agrave;gina d\'entrada ja estar&agrave; emplenat amb el vostre nom. Podeu refusar aquesta galeta: en aquest cas simplement haureu d\'escriure el vostre nom d\'usuari cada vegada que entreu.</p>

<p>Nota: si compartiu l\'ordinador o esteu treballant en un punt d\'acc&eacute;s p&uacute;blic (p. e. en un aula, un cibercaf&egrave;, etc.) assegureu-vos de finalitzar la sessi&oacute; de Moodle fent clic a Sortida o tancant totes les finestres del navegador. D\'aquesta manera es destrueix la primera galeta i ning&uacute; no podr&agrave; entrar en la vostra sessi&oacute;.</p>';
$string['cookiesnotenabled'] = 'Malauradament no teniu les galetes habilitades al navegador';
$string['copy'] = 'copia';
$string['copyasnoun'] = 'còpia';
$string['copyingcoursefiles'] = 'S\'estan copiant els fitxers del curs';
$string['copyingsitefiles'] = 'S\'estan copiant els fitxers del lloc utilitzats en el curs';
$string['copyinguserfiles'] = 'S\'estan copiant els fitxers d\'usuari';
$string['copyingzipfile'] = 'S\'està copiant el fitxer zip';
$string['copyrightnotice'] = 'Copyright';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Cost';
$string['costdefault'] = 'Cost per defecte';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'País';
$string['course'] = 'Curs';
$string['courseadministration'] = 'Administració del curs';
$string['courseapprovedemail'] = 'S\'ha aprovat el curs "{$a->name}" que havíeu sol·licitat i ara en sou {$a->teacher}. Per entrar en aquest nou curs, aneu a {$a->url}';
$string['courseapprovedemail2'] = 'S\'ha aprovat el curs "{$a->name}" que havíeu sol·licitat. Per a accedir al nou curs aneu a l\'adreça {$a->url}';
$string['courseapprovedfailed'] = 'No s\'ha pogut desar el curs com a aprovat';
$string['courseapprovedsubject'] = 'S\'ha aprovat el vostre curs';
$string['courseavailable'] = 'Aquest curs està disponible per als estudiants';
$string['courseavailablenot'] = 'Aquest curs no està disponible per als estudiants';
$string['coursebackup'] = 'Còpia de seguretat del curs';
$string['coursebulkaction'] = 'Accions massives per als cursos seleccionats';
$string['coursecategories'] = 'Categories de cursos';
$string['coursecategory'] = 'Categoria del curs';
$string['coursecategorydeleted'] = 'S\'ha suprimit la categoria de cursos {$a}';
$string['coursecategory_help'] = '<p>L\'administrador de Moodle pot haver configurat diferents categories de cursos.</p>

<p>Per exemple: &quot;Ci&egrave;ncies&quot;, &quot;Humanitats&quot;, &quot;Seguretat i Salut&quot;, etc.</p>

<p>Trieu la m&eacute;s adequada per al vostre curs. Aquesta elecci&oacute; determinarà on es mostra el vostre curs dins de la llista de cursos i pot facilitar que els estudiants el trobin.</p>';
$string['coursecatmanagement'] = 'Gestió de la categoria i del curs';
$string['coursecompletion'] = 'Compleció del curs';
$string['coursecompletions'] = 'Compleció dels cursos';
$string['coursecreators'] = 'Creador/a de cursos';
$string['coursecreatorsdescription'] = 'Els creadors de cursos poden crear nous cursos.';
$string['coursedeleted'] = 'S\'ha suprimit el curs {$a}';
$string['coursedisplay'] = 'Disposició del curs';
$string['coursedisplay_help'] = 'Aquest paràmetre determina si el curs complet es mostra en una pàgina o es divideix en diverses pàgines.';
$string['coursedisplay_multi'] = 'Mostra una secció per pàgina';
$string['coursedisplay_single'] = 'Mostra totes les seccions en una pàgina';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Fitxers del curs heretats';
$string['coursefilesedit'] = 'Edita els fitxers del curs heretats';
$string['coursefileswarning'] = 'Els fitxers dels curs estan desfasats.';
$string['coursefileswarning_help'] = 'A partir de la versió de Moodle 2.0 es desaconsella utilitzar els fitxers del curs. Utilitzeu repositoris externs sempre que es pugui.';
$string['courseformatdata'] = 'Dades del format del curs';
$string['courseformatoptions'] = 'S\'estan formatant les opcions per {$a}';
$string['courseformats'] = 'Formats de curs';
$string['courseformatudpate'] = 'Actualitza el format';
$string['coursegrades'] = 'Qualificacions del curs';
$string['coursehelpcategory'] = 'Situeu el curs dins de la llista de cursos i feu més fàcil que els estudiants el trobin.';
$string['coursehelpforce'] = 'Imposa el mode de grup del curs a totes les activitats del curs.';
$string['coursehelpformat'] = 'La pàgina principal del curs es visualitzarà amb aquest format.';
$string['coursehelphiddensections'] = 'Com es mostraran als estudiants les seccions ocultes del curs.';
$string['coursehelpmaximumupload'] = 'Definiu la mida màxima dels fitxers que es poden penjar al curs, limitada per la configuració del lloc.';
$string['coursehelpnewsitemsnumber'] = 'El nombre d\'elements recents del fòrum de notícies que apareixen al bloc d\'«últimes notícies» de la pàgina principal del curs. Si s\'estableix a zero, el bloc d\'últimes notícies no es mostrarà.';
$string['coursehelpnumberweeks'] = 'Nombre de seccions del curs (només aplicable a alguns formats de curs).';
$string['coursehelpshowgrades'] = 'Habiliteu la visualització del butlletí de qualificacions. Aquest paràmetre no impedeix que les qualificacions es visualitzin dins de les activitats individuals.';
$string['coursehidden'] = 'Aquest curs no està disponible actualment per als estudiants';
$string['courseinfo'] = 'Informació del curs';
$string['courselegacyfiles'] = 'Fitxers del curs heretats';
$string['courselegacyfiles_help'] = 'L\'àrea de fitxers del curs proporciona alguna compatibilitat amb Moodle 1.9 i anteriors versions. Tots els fitxers situats en aquesta àrea són accessibles per tots els participants del curs (tant si els enllaceu com si no) i no hi ha manera de saber com seran utilitzats aquests fitxers en Moodle.

Si utilitzeu aquesta àrea per emmagatzemar fitxers de curs, us exposeu a alguns problemes de privacitat i seguretat, així com a la manca de fitxers en còpies de seguretat, importació de cursos, cada vegada que compartiu o re-utilitzeu  continguts. Per tant, es recomana que no utilitzeu aquesta àrea tret que sapigueu el que esteu fent.';
$string['courselegacyfilesofcourse'] = 'Fitxers del curs heretats: {$a}';
$string['coursemessage'] = 'Missatge als usuaris del curs';
$string['coursenotaccessible'] = 'Aquest curs no permet accés públic';
$string['courseoverview'] = 'Resum de cursos';
$string['courseoverviewfiles'] = 'Fitxers de resum del curs';
$string['courseoverviewfilesext'] = 'Extensions dels fitxers de resum del curs';
$string['courseoverviewfiles_help'] = 'Els fitxers de resum del curs, com ara imatges, es mostren en la llista dels cursos juntament amb el resum.';
$string['courseoverviewfileslimit'] = 'Límit de fitxers de resum del curs';
$string['courseoverviewgraph'] = 'Gràfica resum de cursos';
$string['courseprofiles'] = 'Perfils del curs';
$string['coursereasonforrejecting'] = 'Motius de la denegació d\'aquesta sol·licitud';
$string['coursereasonforrejectingemail'] = 'Aquest text s\'enviarà per correu a la persona sol·licitant';
$string['coursereject'] = 'Denegació d\'una sol·licitud de curs';
$string['courserejected'] = 'S\'ha denegat el curs i s\'ha tramès la notificació a la persona sol·licitant';
$string['courserejectemail'] = 'S\'ha denegat el curs que havíeu sol·licitat. Raó:

{$a}';
$string['courserejectreason'] = 'Expliqueu les raons de la denegació del curs<br />(aquest text s\'inclourà en el missatge que rebrà la persona sol·licitant)';
$string['courserejectsubject'] = 'S\'ha denegat el vostre curs';
$string['coursereport'] = 'Informe del curs';
$string['coursereports'] = 'Informes del curs';
$string['courserequest'] = 'Sol·licitud de curs';
$string['courserequestdetails'] = 'Detalls del curs que sol·liciteu';
$string['courserequestfailed'] = 'Per alguna raó no s\'ha pogut desar la vostra sol·licitud';
$string['courserequestintro'] = 'Utilitzeu aquest formulari per sol·licitar la creació d\'un curs.<br />Introduïu tota la informació que pugueu per tal que<br />els administradors entenguin bé la motivació del curs.';
$string['courserequestreason'] = 'Motivació del curs';
$string['courserequestsuccess'] = 'S\'ha desat la vostra sol·licitud de nou curs. Pròximament rebreu un correu per informar-vos si la vostra petició ha estat acceptada.';
$string['courserequestsupport'] = 'Informació complementària que voleu fer arribar a la persona que avaluarà la sol·licitud';
$string['courserestore'] = 'Restauració del curs';
$string['courses'] = 'Cursos';
$string['coursesectionsummaries'] = 'Resums de les seccions del curs';
$string['coursesettings'] = 'Paràmetres per defecte del curs';
$string['coursesmovedout'] = 'S\'han tret els cursos de: {$a}';
$string['coursespending'] = 'Cursos pendents d\'aprovació';
$string['coursestart'] = 'Inici del curs';
$string['coursesummary'] = 'Resum del curs';
$string['coursesummary_help'] = 'El resum del curs s\'inclou en la llista de cursos. Quan es cerca un curs es cerca també en els resums, a més dels noms dels cursos.';
$string['courseupdates'] = 'Actualitzacions del curs';
$string['create'] = 'Crea';
$string['createaccount'] = 'Crea el meu compte';
$string['createcategory'] = 'Crea una categoria';
$string['createfolder'] = 'Crea una carpeta en {$a}';
$string['createnew'] = 'Crea nou';
$string['createnewcategory'] = 'Crea categoria nova';
$string['createnewcourse'] = 'Crea curs nou';
$string['createnewsubcategory'] = 'Crea subcategoria nova';
$string['createsubcategoryof'] = 'Crea subcategoria de {$a}';
$string['createuser'] = 'Crea un usuari';
$string['createuserandpass'] = 'Trieu un nom d\'usuari i una contrasenya';
$string['createziparchive'] = 'Comprimeix-los en un fitxer zip';
$string['creatingblocks'] = 'S\'estan creant blocs';
$string['creatingblocksroles'] = 'S\'estan creant les assignacions i excepcions de rols al nivell de bloc';
$string['creatingblogsinfo'] = 'S\'està creant la informació dels blogs';
$string['creatingcategoriesandquestions'] = 'S\'estan creant categories i preguntes';
$string['creatingcoursemodules'] = 'S\'estan creant els mòduls del curs';
$string['creatingcourseroles'] = 'S\'estan creant les assignacions de rols al nivell de curs';
$string['creatingevents'] = 'S\'estan creant els esdeveniments';
$string['creatinggradebook'] = 'S\'estan creant les qualificacions';
$string['creatinggroupings'] = 'S\'estan creant els agrupaments';
$string['creatinggroupingsgroups'] = 'S\'estan afegint els grups als agrupaments';
$string['creatinggroups'] = 'S\'estan creant els grups';
$string['creatinglogentries'] = 'S\'estan creant les entrades de registre';
$string['creatingmessagesinfo'] = 'S\'està creant la informació dels missatges';
$string['creatingmodroles'] = 'S\'estan creant les assignacions i excepcions de rols al nivell de mòdul';
$string['creatingnewcourse'] = 'S\'està creant un curs nou';
$string['creatingrolesdefinitions'] = 'S\'estan creant les definicions de rols';
$string['creatingscales'] = 'S\'estan creant les escales';
$string['creatingsections'] = 'S\'estan creant les seccions';
$string['creatingtemporarystructures'] = 'S\'estan creant estructures temporals';
$string['creatinguserroles'] = 'S\'estan creant les assignacions i excepcions de rols al nivell d\'usuari';
$string['creatingusers'] = 'S\'estan creant els usuaris';
$string['creatingxmlfile'] = 'S\'està creant el fitxer XML';
$string['currency'] = 'Moneda';
$string['currentcourse'] = 'Curs actual';
$string['currentcourseadding'] = 'Curs actual, s\'hi estan afegint dades';
$string['currentcoursedeleting'] = 'Curs actual, primer se suprimirà';
$string['currentlanguage'] = 'Idioma actual';
$string['currentlocaltime'] = 'la vostra hora local';
$string['currentlyselectedusers'] = 'Usuaris seleccionats actualment';
$string['currentpicture'] = 'Imatge actual';
$string['currentrelease'] = 'Informació sobre l\'edició actual';
$string['currentversion'] = 'Versió actual';
$string['databasechecking'] = 'S\'està actualitzant la base de dades de Moodle de la versió {$a->oldversion} a la {$a->newversion}';
$string['databaseperformance'] = 'Rendiment de la base de dades';
$string['databasesetup'] = 'S\'està configurant la base de dades';
$string['databasesuccess'] = 'La base de dades s\'ha actualitzat amb èxit';
$string['databaseupgradebackups'] = 'La versió de les còpies de seguretat és ara {$a}';
$string['databaseupgradeblocks'] = 'La versió dels blocs és ara {$a}';
$string['databaseupgradegroups'] = 'La versió de grups és ara {$a}';
$string['databaseupgradelocal'] = 'La versió de les adaptacions locals de la base de dades és ara {$a}';
$string['databaseupgrades'] = 'S\'està actualitzant la base de dades';
$string['date'] = 'Data';
$string['datechanged'] = 'S\'ha canviat la data';
$string['datemostrecentfirst'] = 'Data - començant pel més recent';
$string['datemostrecentlast'] = 'Data - el més recent al final';
$string['day'] = 'dia';
$string['days'] = 'dies';
$string['decodinginternallinks'] = 'S\'estan descodificant els enllaços interns';
$string['default'] = 'Per defecte';
$string['defaultcoursestudent'] = 'Estudiant';
$string['defaultcoursestudentdescription'] = 'L\'estudiantat generalment té menys privilegis dins del curs.';
$string['defaultcoursestudents'] = 'Estudiants';
$string['defaultcoursesummary'] = 'Escriviu un paràgraf breu i explicatiu sobre el curs';
$string['defaultcourseteacher'] = 'Professor';
$string['defaultcourseteacherdescription'] = 'El professorat pot fer qualsevol cosa dins d\'un curs, incloent-hi canviar les activitats i qualificar l\'estudiantat';
$string['defaultcourseteachers'] = 'Professors';
$string['defaulteditor'] = 'Editor per defecte';
$string['delete'] = 'Suprimeix';
$string['deleteablock'] = 'Elimina un bloc';
$string['deleteall'] = 'Suprimeix-ho tot';
$string['deleteallcannotundo'] = 'Suprimeix tot (no es pot desfer)';
$string['deleteallcomments'] = 'Suprimeix tots els comentaris';
$string['deleteallratings'] = 'Suprimeix totes les valoracions';
$string['deletecategory'] = 'Suprimeix categoria: {$a}';
$string['deletecategorycheck'] = 'Esteu absolutament segur que voleu suprimir completament la categoria <b>\'{$a}\'</b>?<br />Els cursos que contingui aquesta categoria es traslladaran a la categoria mare, si n\'hi ha, o si no a Miscel·lània.';
$string['deletecategorycheck2'] = 'Si voleu suprimir aquesta categoria, heu de decidir què fer amb els cursos i subcategories que conté.';
$string['deletecategoryempty'] = 'Categoria buida';
$string['deletecheck'] = 'Suprimiu {$a} ?';
$string['deletecheckfiles'] = 'Esteu absolutament segur que voleu suprimir aquests fitxers?';
$string['deletecheckfull'] = 'Esteu absolutament segur que voleu suprimir completament {$a} ?';
$string['deletechecktype'] = 'Esteu segurs que voleu suprimir aquest {$a->type}?';
$string['deletechecktypename'] = 'Esteu segurs que voleu suprimir  {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Esteu a punt de suprimir aquests fitxers';
$string['deletecomment'] = 'Elimina aquest comentari';
$string['deletecompletely'] = 'Suprimeix-los completament';
$string['deletecourse'] = 'Suprimeix un curs';
$string['deletecoursecheck'] = 'Esteu absolutament segur que voleu suprimir completament aquest curs i totes les dades que conté?';
$string['deleted'] = 'S\'ha suprimit';
$string['deletedactivity'] = 'S\'ha suprimit {$a}';
$string['deletedcourse'] = 'S\'ha suprimit completament {$a}';
$string['deletednot'] = 'No s\'ha pogut suprimir {$a} !';
$string['deletelogs'] = 'Suprimeix els registres';
$string['deleteselected'] = 'Suprimeix la selecció';
$string['deleteselectedkey'] = 'Suprimeix la clau seleccionada';
$string['deletingcourse'] = 'S\'està suprimint {$a}';
$string['deletingexistingcoursedata'] = 'S\'estan suprimint les dades existents del curs';
$string['deletingolddata'] = 'S\'estan suprimint dades antigues';
$string['department'] = 'Departament';
$string['desc'] = 'Descendent';
$string['description'] = 'Descripció';
$string['deselectall'] = 'Desselecciona tot';
$string['detailedless'] = 'Menys detallat';
$string['detailedmore'] = 'Més detallat';
$string['directory'] = 'Directori';
$string['disable'] = 'Inhabilita';
$string['disabledcomments'] = 'Els comentaris estan inhabilitats';
$string['displayingfirst'] = 'Només es mostren els primers {$a->count} {$a->things}';
$string['displayingrecords'] = 'S\'estan mostrant {$a} registres';
$string['displayingusers'] = 'S\'estan visualitzant els usuaris {$a->start} a {$a->end}';
$string['displayonpage'] = 'Visualitza en la pàgina';
$string['dndcourse'] = 'Podeu arrossegar i deixar anar aquest curs per alterar la seva ordenació o moure\'l a una altra categoria.';
$string['dndenabled_inbox'] = 'Podeu arrossegar i deixar anar fitxers aquí per a afegir-los.';
$string['dndnotsupported'] = 'La pujada via «retalla i enganxa» no està suportada';
$string['dndnotsupported_help'] = 'El vostre navegador no suporta la pujada via «retalla i enganxa».<br />Aquesta funcionalitat està disponible en les versions recents de Chrome, Firefox i Safari, així com en l\'Internet Explorer v10 i posteriors.';
$string['dndnotsupported_insentence'] = '«retalla i enganxa» no està suportat';
$string['dnduploadwithoutcontent'] = 'Aquesta càrrega no té cap contingut';
$string['dndworkingfile'] = 'Arrossega i deixa anar fitxers dins de les seccions del curs per a penjar-los';
$string['dndworkingfilelink'] = 'Arrossega i deixa anar fitxers o enllaços dins de les seccions del curs per a penjar-los';
$string['dndworkingfiletext'] = 'Arrossega i deixa anar fitxers o text dins de les seccions del curs per a penjar-los';
$string['dndworkingfiletextlink'] = 'Arrossega i deixa anar fitxers, text o enllaços dins de les seccions del curs per a penjar-los';
$string['dndworkinglink'] = 'Arrossega i deixa anar enllaços dins de les seccions del curs per a penjar-los';
$string['dndworkingtext'] = 'Arrossega i deixa anar text dins de les seccions del curs per a penjar-lo';
$string['dndworkingtextlink'] = 'Arrossega i deixa anar text o enllaços dins de les seccions del curs per a penjar-los';
$string['documentation'] = 'Documentació de Moodle';
$string['dontsortcategories'] = 'No ordeneu categories';
$string['dontsortcourses'] = 'No ordeneu cursos';
$string['down'] = 'Avall';
$string['download'] = 'Baixa';
$string['downloadall'] = 'Baixa tot';
$string['downloadexcel'] = 'Baixa en format Excel';
$string['downloadfile'] = 'Baixa el fitxer';
$string['downloadods'] = 'Baixa en format ODS';
$string['downloadtext'] = 'Baixa en format text';
$string['doyouagree'] = 'Heu llegit aquestes condicions i les enteneu?';
$string['droptoupload'] = 'Arrossegueu fitxers aquí per a penjar-los';
$string['duplicate'] = 'Duplica';
$string['duplicateconfirm'] = 'Esteu segurs de voler duplicar {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Torna al curs';
$string['duplicatecontedit'] = 'Edita la copia nova';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' ha sigut duplicat amb èxit.';
$string['duplicatinga'] = 'S\'està duplicant: {$a}';
$string['edhelpaspellpath'] = 'Per a usar la verificació de l\'ortografia amb l\'editor, heu de tenir instal·lat al servidor l\'<strong>aspell 0.50</strong> o posterior i heu d\'especificar el camí d\'accés correcte al binari d\'aspell. En sistemes Unix/Linux aquest camí sol ser <strong>/usr/bin/aspell</strong>, però podria ser un altre.';
$string['edhelpbgcolor'] = 'Definiu el color de fons de l\'àrea d\'edició<br />Exemples de valors vàlids: #ffffff o white.';
$string['edhelpcleanword'] = 'Aquest paràmetre habilita o inhabilita el filtre específic per a format de Word.';
$string['edhelpenablespelling'] = 'Habiliteu o inhabiliteu la verificació de l\'ortografia. Si l\'habiliteu, cal tenir instal·lat <strong>aspell</strong> al servidor.';
$string['edhelpfontfamily'] = 'La propietat font-family és una llista de noms de famílies de fonts o noms genèrics de famílies. Els noms de famílies s\'han de separar amb comes.';
$string['edhelpfontlist'] = 'Definiu els tipus de lletra utilitzats en el menú desplegable de l\'editor.';
$string['edhelpfontsize'] = 'La mida de lletra per defecte defineix la mida d\'un tipus de lletra.<br />Per exemple són valors vàlids els següents: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Edita';
$string['edita'] = 'Edita {$a}';
$string['editcategorysettings'] = 'Edita paràmetres de la categoria';
$string['editcategorythis'] = 'Edita aquesta categoria';
$string['editcoursesettings'] = 'Edita paràmetres del curs';
$string['editfiles'] = 'Edita fitxers';
$string['editgroupprofile'] = 'Edita el perfil del grup';
$string['editinga'] = 'S\'està editant: {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Aquest valor no es pot editar!';
$string['editmyprofile'] = 'Edita el perfil';
$string['editorbgcolor'] = 'Color de fons';
$string['editorcleanonpaste'] = 'Neteja l\'HTML del Word en enganxar';
$string['editorcommonsettings'] = 'Paràmetres comuns';
$string['editordefaultfont'] = 'Lletra per defecte';
$string['editorenablespelling'] = 'Activa la verificació de l\'ortografia';
$string['editorfontlist'] = 'Llista de tipus de lletra';
$string['editorfontsize'] = 'Mida de lletra per defecte';
$string['editorresettodefaults'] = 'Restaura valors per defecte';
$string['editorsettings'] = 'Paràmetres de l\'editor';
$string['editorshortcutkeys'] = 'Dreceres de teclat de l\'editor';
$string['editsettings'] = 'Edita paràmetres';
$string['editsummary'] = 'Edita un resum';
$string['editthisactivity'] = 'Edita aquesta activitat';
$string['editthiscategory'] = 'Edita aquesta categoria';
$string['edittitle'] = 'Edita el títol';
$string['edittitleinstructions'] = 'Prem Escape per a cancel·lar i Enter quan acabis';
$string['edituser'] = 'Edita els comptes d\'usuari';
$string['email'] = 'Correu electrònic';
$string['emailactive'] = 'Correu electrònic activat';
$string['emailagain'] = 'Correu electrònic (una altra vegada)';
$string['emailalreadysent'] = 'S\'ha enviat un correu electrònic de restabliment de contrasenya. Consulteu el vostre correu electrònic.';
$string['emailcharset'] = 'Joc de caràcters del correu';
$string['emailconfirm'] = 'Confirmació del compte';
$string['emailconfirmation'] = '{$a->firstname},

S\'ha sol·licitat un nou compte en \'{$a->sitename}\' amb la vostra adreça electrònica.

Per confirmar el vostre compte, si us plau aneu a aquesta adreça web:

  {$a->link}

En la majoria de programes de correu, l\'adreça s\'hauria de presentar com un enllaç blau on podeu fer clic. Si això no funciona, copieu i enganxeu l\'adreça al camp d\'adreces
de la finestra del vostre navegador web.

Si necessiteu ajuda, si us plau contacteu amb l\'administrador del lloc,
{$a->admin},';
$string['emailconfirmationsubject'] = '{$a}: confirmació de compte';
$string['emailconfirmsent'] = '<p>S\'ha enviat un correu a la vostra adreça <b>{$a}</b></p>
<p>Conté instruccions senzilles per completar el registre.</p>
<p>Si seguiu tenint problemes, contacteu amb l\'administrador del lloc.</p>';
$string['emaildigest'] = 'Tipus de resum de correu';
$string['emaildigestcomplete'] = 'Complet (correu diari amb missatges complets)';
$string['emaildigest_help'] = 'Aquest és la configuració del resum diari que els fòrums faran servir per defecte.

 * Sense resum: rebreu un correu electrònic per cada missatge enviat a fòrums.
* Resum, missatges complets: rebreu un correu diari amb el contingut complet de cada missatge enviat a fòrums.
* Resum, només capçaleres: rebreu un correu diari amb les capçaleres de cada missatge evniat a fòrums.

També podeu triar una configuració diferent per a cada fòrum si així ho desitgeu.';
$string['emaildigestoff'] = 'Sense resum (un correu per cada missatge dels fòrums)';
$string['emaildigestsubjects'] = 'Assumptes (correu diari només amb els assumptes)';
$string['emaildisable'] = 'Aquesta adreça de correu està inhabilitada.';
$string['emaildisableclick'] = 'Feu clic aquí per inhabilitar l\'enviament de correu a aquesta adreça';
$string['emaildisplay'] = 'Mostra el correu electrònic';
$string['emaildisplaycourse'] = 'Permet només als altres membres del curs veure la meva adreça de correu';
$string['emaildisplayhidden'] = 'Adreça de correu oculta';
$string['emaildisplayno'] = 'Oculta a tothom la meva adreça de correu electrònic';
$string['emaildisplayyes'] = 'Permet que tothom vegi la meva adreça de correu';
$string['emailenable'] = 'Aquesta adreça de correu està habilitada.';
$string['emailenableclick'] = 'Feu clic aquí per tornar a habilitar l\'enviament de correu a aquesta adreça';
$string['emailexists'] = 'Aquesta adreça de correu ja està registrada.';
$string['emailformat'] = 'Format del correu';
$string['emailmustbereal'] = 'Nota: l\'adreça de correu ha de ser una adreça real';
$string['emailnotallowed'] = 'Les adreces de correu d\'aquests dominis no són permeses ({$a})';
$string['emailnotfound'] = 'No s\'ha trobat l\'adreça de correu en la base de dades';
$string['emailonlyallowed'] = 'Aquest correu no és un dels permesos ({$a})';
$string['emailpasswordchangeinfo'] = '{$a->firstname},

Algú (probablement vós) ha sol·licitat una nova contrasenya per al vostre compte en \'{$a->sitename}\'.

Si voleu canviar la contrasenya, aneu a l\'adreça web següent:

{$a->link}

En la majoria de programes de correu, la línia de dalt s\'hauria de veure com un enllaç blau on podeu fer clic. Si això no funciona, copieu l\'adreça i enganxeu-la al camp d\'adreces de la finestra del vostre nvegador web.

Si necessiteu ajuda, si us plau contacteu amb l\'administrador del lloc:

{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = '{$a->firstname},

Algú (probablement vós) ha sol·licitat una nova contrasenya per al vostre compte en \'{$a->sitename}\'.

Malauradament el vostre compte d\'aquest lloc ha estat inhabilitat i no es pot reinicialitzar. Si us plau contacteu amb l\'administrador del lloc:

{$a->admin}';
$string['emailpasswordchangeinfofail'] = '{$a->firstname},

Algú (probablement vós) ha sol·licitat una nova contrasenya per al vostre compte en \'{$a->sitename}\'.

Malauradament en aquest lloc no es poden canviar les contrasenyes. Si us plau contacteu amb l\'administrador del lloc:

{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: informació de canvi de contrasenya';
$string['emailpasswordconfirmation'] = '{$a->firstname},

Algú (probablement vós) ha demanat una nova contrasenya
per al vostre compte en \'{$a->sitename}\'.

Per a confirmar aquesta sol·licitud i rebre la nova contrasenya per correu electrònic, aneu a l\'adreça web següent:

  {$a->link}

En la majoria de programes de correu, la línia de dalt s\'hauria de veure com un enllaç blau on podeu fer clic. Si això no funciona, copieu l\'adreça i enganxeu-la al camp d\'adreces de la finestra del vostre nvegador web.

Si necessiteu ajuda, si us plau contacteu amb l\'administrador del lloc:

{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: confirmació de canvi de contrasenya';
$string['emailpasswordconfirmmaybesent'] = '<p>Si heu proporcionat un nom d\'usuari o una adreça de correu correctes, ja se us deu haver enviat un missatge per correu electrònic.</p>
<p>Aquest missatge conté instruccions molt senzilles per a confirmar i completar el canvi de contrasenya. Si seguiu tenint dificultats, contacteu si us plau amb l\'administrador del lloc.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> El compte d\'usuari que heu especificat no té cap adreça de correu electrònic registrada </p>
<p>Poseu-vos en contacte amb l\'administrador del lloc. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> L\'usuari que heu proporcionat no identifica un compte d\'usuari existent. </p>
<p> Verifiqueu la informació introduïda i torneu a provar. Si continueu tenint problemes, poseu-vos en contacte amb l\'administrador del lloc. </p>';
$string['emailpasswordconfirmsent'] = 'Se us ha enviat un correu a la vostra adreça <b>{$a}</b>.
<br />Conté instruccions molt senzilles per confirmar i completar el canvi de contrasenya.
Si seguiu tenint problemes, contacteu amb l\'administrador del lloc.';
$string['emailpasswordsent'] = 'Gràcies per confirmar el canvi de contrasenya.
<br />Se us ha enviat un correu amb la contrasenya nova a la vostra adreça: <b>{$a->email}</b>.
<br />La contrasenya nova s\'ha generat automàticament - potser voldreu <a href="{$a->link}">canviar-la</a> per una altra més fàcil de recordar.';
$string['emailresetconfirmation'] = 'Hola, {$a->firstname}.

S\'ha sol·licitat un restabliment de contrasenya per al compte de \'{$a->username}\' al lloc {$a->sitename}.

Per confirmar aquesta petició, i establir una nova contrasenya per al compte, aneu a la següent adreça d\'Internet:

 {$a->link} (Aquest enllaç és vàlid per {$a->resetminutes} minuts  des del moment en què es va sol·licitar per primera vegada aquest reajustament)

Si aquest restabliment de contrasenya no s\'ha sol·licitat per vostè, no es necessita cap acció.

Per obtenir ajuda, poseu-vos en contacte amb l\'administrador del lloc, {$a->admin}';
$string['emailresetconfirmationsubject'] = 'Sol·licitud de restabliment de contrasenya: {$a}';
$string['emailresetconfirmsent'] = 'S\'ha enviat un correu electrònic a la seva adreça en <b>{$a}.</b>
<br/> Conté instruccions senzilles per completar i confirmar el canvi de contrasenya.
Si continueu tenint problemes, poseu-vos en contacte amb l\'administrador del lloc.';
$string['emptydragdropregion'] = 'regió buida';
$string['enable'] = 'Habilita';
$string['encryptedcode'] = 'Codi xifrat';
$string['english'] = 'anglès';
$string['enrolmentmethods'] = 'Mètodes d\'Inscripció';
$string['entercourse'] = 'Feu clic per entrar en aquest curs';
$string['enteremail'] = 'Introduïu la vostra adreça de correu electrònic';
$string['enteremailaddress'] = 'Introduïu la vostra adreça de correu per anul·lar la contrasenya anterior i rebre\'n una de nova per correu electrònic.';
$string['enterusername'] = 'Introduïu el vostre nom d\'usuari';
$string['entries'] = 'Entrades';
$string['error'] = 'Error';
$string['errorcreatingactivity'] = 'No es pot crear una instància de l\'activitat \'{$a}\'';
$string['errorfiletoobig'] = 'El fitxer era més gran que el límit de {$a} bytes';
$string['errornouploadrepo'] = 'No hi ha un repositori de càrrega habilitat per a aquest lloc';
$string['errorwhenconfirming'] = 'No esteu confirmat perquè s\'ha produït un error. Si heu arribat aquí fent clic en un enllaç d\'un missatge de correu, assegureu-vos que la línia del missatge no estava partida o continuava a sota. En aquest cas probablement haureu de copiar i enganxar per reconstruir correctament l\'enllaç.';
$string['eventcontentviewed'] = 'Contingut mostrat';
$string['eventcoursecategorydeleted'] = 'Categoria suprimida';
$string['eventcoursecontentdeleted'] = 'Contingut del curs suprimit';
$string['eventcoursecreated'] = 'Curs creat';
$string['eventcoursedeleted'] = 'Curs suprimit';
$string['eventcoursemodulecreated'] = 'Mòdul de curs creat';
$string['eventcoursemoduledeleted'] = 'Mòdul de curs suprimit';
$string['eventcoursemoduleupdated'] = 'Mòdul de curs actualitzat';
$string['eventcourseresetended'] = 'Reinici del curs acabat';
$string['eventcourseresetstarted'] = 'Reinici del curs començat';
$string['eventcourserestored'] = 'Curs restaurat';
$string['eventcoursesectionupdated'] = 'Secció de curs actualitzada';
$string['eventcourseupdated'] = 'Curs actualitzat';
$string['eventusercreated'] = 'Usuari creat';
$string['eventuserdeleted'] = 'Usuari suprimit';
$string['eventuserlistviewed'] = 'Llista d\'usuaris mostrada';
$string['eventuserloggedout'] = 'Usuari desconnectat';
$string['eventuserprofileviewed'] = 'Perfil de l\'usuari mostrat';
$string['eventuserupdated'] = 'Usuari actualitzat';
$string['everybody'] = 'Tothom';
$string['executeat'] = 'Executa a';
$string['existing'] = 'Existent';
$string['existingadmins'] = 'Administradors actuals';
$string['existingcourse'] = 'Cursos actuals';
$string['existingcourseadding'] = 'Curs existent, afegir-hi dades';
$string['existingcoursedeleting'] = 'Curs existent, primer se suprimirà';
$string['existingcreators'] = 'Creadors de cursos actuals';
$string['existingstudents'] = 'Estudiants inscrits';
$string['existingteachers'] = 'Professors actuals';
$string['expand'] = 'Amplia';
$string['expandall'] = 'Amplia tot';
$string['expandcategory'] = 'Amplia {$a}';
$string['explanation'] = 'Explicació';
$string['extendenrol'] = 'Amplia la inscripció (individual)';
$string['extendperiod'] = 'Període ampliat';
$string['failedloginattempts'] = '{$a->attempts} intents d\'entrada fracassats des de la darrera vegada';
$string['failedloginattemptsall'] = '{$a->attempts} intents d\'entrada fracassats d\'un total de {$a->accounts} comptes';
$string['feedback'] = 'Retroacció';
$string['file'] = 'Fitxer';
$string['fileexists'] = 'Ja existeix un fitxer anomenat {$a}';
$string['filemissing'] = 'Falta {$a}';
$string['files'] = 'Fitxers';
$string['filesanduploads'] = 'Àrea de fitxers';
$string['filesfolders'] = 'Fitxers/carpetes';
$string['filetoolarge'] = 'és massa gran per a penjar-lo';
$string['fileuploadwithcontent'] = 'Les càrregues de fitxers no haurien d\'incloure el paràmetre de contingut';
$string['filloutallfields'] = 'Si us plau ompliu tots els camps d\'aquest formulari';
$string['filter'] = 'Filtre';
$string['findmorecourses'] = 'Busca més cursos...';
$string['first'] = 'Primer';
$string['firstaccess'] = 'Primer accés';
$string['firstname'] = 'Nom';
$string['firstnamephonetic'] = 'Nom - fonètica';
$string['firstsiteaccess'] = 'Primer accés al lloc';
$string['firsttime'] = 'És la primera vegada que veniu aquí?';
$string['folder'] = 'Carpeta';
$string['folderclosed'] = 'Carpeta tancada';
$string['folderopened'] = 'Carpeta oberta';
$string['followingoptional'] = 'Els ítems següents són opcionals';
$string['followingrequired'] = 'Els ítems següents són necessaris';
$string['for'] = 'Per';
$string['force'] = 'Imposa';
$string['forcelanguage'] = 'Imposa idioma';
$string['forceno'] = 'No imposis';
$string['forcepasswordchange'] = 'Imposa canvi de contrasenya';
$string['forcepasswordchangecheckfull'] = 'Esteu absolutament segur que voleu imposar un canvi de contrasenya a {$a}?';
$string['forcepasswordchange_help'] = 'Si activeu aquesta casella, la pròxima vegada que l\'usuari entri se li demanarà que canviï la contrasenya';
$string['forcepasswordchangenot'] = 'No s\'ha pogut imposar el canvi de contrasenya a {$a}';
$string['forcepasswordchangenotice'] = 'Heu de canviar la contrasenya abans de continuar';
$string['forcetheme'] = 'Imposa tema';
$string['forgotaccount'] = 'Heu oblidat la contrasenya?';
$string['forgotten'] = 'Heu oblidat el nom d\'usuari o la contrasenya?';
$string['forgottenduplicate'] = 'L\'adreça de correu és compartida per diversos comptes. En lloc de l\'adreça, introduïu el nom d\'usuari/ària';
$string['forgotteninvalidurl'] = 'L\'URL de canvi de contrasenya no és vàlid';
$string['format'] = 'Format';
$string['format_help'] = 'El format del curs determina la disposició de la pàgina del curs.

* Format d\'activitat única - Per mostrar una única activitat o recurs (com ara un qüestionari o paquet SCORM) a la pàgina del curs.

* Format social - Es mostra un fòrum a la pàgina del curs.

* Format per temes - La pàgina del curs s\'organitza en seccions temàtiques.

* Format setmanal - La pàgina del curs s\'organitza en seccions setmanals, amb la primera setmana començant en la data d\'inici del curs.';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format Markdown';
$string['formatplain'] = 'Format text';
$string['formattext'] = 'Autoformat Moodle';
$string['formattexttype'] = 'Formatatge';
$string['framesetinfo'] = 'Aquest document de marcs conté:';
$string['from'] = 'Des de';
$string['frontpagecategorycombo'] = 'Llista combinada';
$string['frontpagecategorynames'] = 'Mostra llista de categories';
$string['frontpagecourselist'] = 'Mostra llista de cursos';
$string['frontpagecoursesearch'] = 'Caixa de cerca del curs';
$string['frontpagedescription'] = 'Descripció per a la pàgina inicial';
$string['frontpagedescriptionhelp'] = 'Aquesta descripció es pot mostrar a la primera plana fent servir el bloc de resum del curs/lloc, o bé incloent una secció de tema a la pàgina inicial.';
$string['frontpageenrolledcourselist'] = 'Cursos inscrits';
$string['frontpageformat'] = 'Format de la pàgina inicial';
$string['frontpageformatloggedin'] = 'Format per a usuaris autenticats';
$string['frontpagenews'] = 'Mostra notícies';
$string['frontpagesettings'] = 'Paràmetres de la pàgina inicial';
$string['fulllistofcourses'] = 'Tots els cursos';
$string['fullname'] = 'Nom complet';
$string['fullnamecourse'] = 'Nom complet del curs';
$string['fullnamecourse_help'] = 'El nom complet del curs apareix al capdamunt de totes les pàgines del curs i també a la llista de cursos.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nom complet de l\'usuari';
$string['fullprofile'] = 'Perfil complet';
$string['fullsitename'] = 'Nom complet del lloc';
$string['functiondisabled'] = 'Aquesta funcioonalitat està inhabilitada';
$string['general'] = 'General';
$string['geolocation'] = 'latitud - longitud';
$string['gettheselogs'] = 'Obté aquests registres';
$string['go'] = 'Endavant';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details:
http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'Llicència GPL';
$string['grade'] = 'Qualificació';
$string['grades'] = 'Qualificacions';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> ha sigut habilitat per a aquest lloc. Si no carregueu una imatge per al perfil Moodle carregarà una imatge per al vostre perfil des de Gravatar';
$string['group'] = 'Grup';
$string['groupadd'] = 'Afegeix nou grup';
$string['groupaddusers'] = 'Afegeix la selecció al grup';
$string['groupextendenrol'] = 'Amplia la inscripció (tothom)';
$string['groupfor'] = 'per al grup';
$string['groupinfo'] = 'Informació sobre el grup seleccionat';
$string['groupinfoedit'] = 'Edita els paràmetres del grup';
$string['groupinfomembers'] = 'Informació sobre els membres seleccionats';
$string['groupinfopeople'] = 'Informació sobre les persones seleccionades';
$string['groupmembers'] = 'Membres del grup';
$string['groupmemberssee'] = 'Visualitza els membres del grup';
$string['groupmembersselected'] = 'Membres del grup seleccionat';
$string['groupmode'] = 'Mode de grup';
$string['groupmodeforce'] = 'Imposa el mode de grup';
$string['groupmy'] = 'El meu grup';
$string['groupnonmembers'] = 'Persones que no estan en un grup';
$string['groupnotamember'] = 'No sou membre d\'aquest grup';
$string['grouprandomassign'] = 'Assigna tots a grups aleatòriament';
$string['groupremove'] = 'Suprimeix el grup seleccionat';
$string['groupremovemembers'] = 'Suprimeix els membres seleccionats';
$string['groups'] = 'Grups';
$string['groupsnone'] = 'Sense grups';
$string['groupsseparate'] = 'Grups separats';
$string['groupsvisible'] = 'Grups visibles';
$string['guest'] = 'Visitant';
$string['guestdescription'] = 'Els visitants tenen privilegis mínims i generalment no poden introduir text enlloc.';
$string['guestskey'] = 'Permet visitants amb clau';
$string['guestsno'] = 'No permetis l\'entrada de visitants';
$string['guestsnotallowed'] = '\'{$a}\' no permet l\'entrada de visitants';
$string['guestsyes'] = 'Permet visitants sense clau';
$string['guestuser'] = 'Usuari convidat';
$string['guestuserinfo'] = 'Aquest usuari és un usuari especial que permet entrar a alguns cursos en mode només de lectura (read-only).';
$string['help'] = 'Ajuda';
$string['helpprefix2'] = 'Ajuda: "{$a}"';
$string['helpwiththis'] = 'Ajuda sobre això';
$string['hiddenassign'] = 'Assignació oculta';
$string['hiddenfromstudents'] = 'Ocult per a l\'estudiantat';
$string['hiddensections'] = 'Temes ocults';
$string['hiddensectionscollapsed'] = 'Els temes ocults es mostren en format reduït';
$string['hiddensections_help'] = '<p>Aquesta opció us permet decidir com veuran els estudiants les seccions ocultes del vostre curs.</p>

<p>Per defecte es mostra una petita àrea (en forma reduïda, generalment en gris) que indica on és la secció oculta, però no es poden veure les activitats o els text ocults. Això és útil particularment en el format setmanal, perquè així queda clar quines setmanes hi ha curs i quines no.</p>

<p>Si ho preferiu poden restar completament ocultes, de manera que els estudiants no sàpiguen ni tan sols que existeixen aquestes seccions.</p>';
$string['hiddensectionsinvisible'] = 'Els temes ocults són completament invisibles';
$string['hide'] = 'Oculta';
$string['hideadvancedsettings'] = 'Oculta paràmetres avançats';
$string['hidepicture'] = 'Oculta imatge';
$string['hidesection'] = 'Oculta secció {$a}';
$string['hidesettings'] = 'Oculta paràmetres';
$string['hideshowblocks'] = 'Oculta o mostra blocs';
$string['hits'] = 'Peticions';
$string['hitsoncourse'] = 'Peticions en {$a->coursename} per {$a->username}';
$string['hitsoncoursetoday'] = 'Peticions d\'avui en {$a->coursename} per {$a->username}';
$string['home'] = 'Inici';
$string['hour'] = 'hora';
$string['hours'] = 'hores';
$string['howtomakethemes'] = 'Com crear nous temes';
$string['htmleditor'] = 'Utilitza l\'editor HTML';
$string['htmleditoravailable'] = 'L\'editor HTML està disponible';
$string['htmleditordisabled'] = 'Teniu inhabilitat l\'editor HTML en el vostre perfil d\'usuari';
$string['htmleditordisabledadmin'] = 'L\'administrator ha inhabilitat l\'editor HTML en aquest lloc';
$string['htmleditordisabledbrowser'] = 'L\'editor HTML no està disponible perquè el vostre navegador web no és compatible';
$string['htmlfilesonly'] = 'Només fitxers HTML';
$string['htmlformat'] = 'Format HTML';
$string['icon'] = 'Icona';
$string['icqnumber'] = 'Número ICQ';
$string['idnumber'] = 'Número ID';
$string['idnumbercourse'] = 'Número ID del curs';
$string['idnumbercoursecategory'] = 'Número ID';
$string['idnumbercoursecategory_help'] = 'El número ID d\'un curs sols s\'usa quan se cerquen cursos contra sistemes externs, i no es mostra enlloc. Si el curs té un codi oficial poseu-lo aquí, en cas contrari deixeu-ho en blanc.';
$string['idnumbercourse_help'] = '<p>Moodle no visualitza mai el número ID del curs. Només s\'utilitza per identificar el curs contra sistemes externs. Si teniu un codi oficial del curs podeu usar-lo aquí. Si no, podeu deixar-lo en blanc.</p>';
$string['idnumbergroup'] = 'Número ID de grup';
$string['idnumbergroup_help'] = 'El número ID d\'un grup només es fa servir quan es compara el grup contra sistemes externs i no es veurà en cap lloc del lloc web. Si el grup té un nom de codi oficial es pot introduir, en cas contrari el camp es pot deixar en blanc.';
$string['idnumbergrouping'] = 'Número ID de l\'agrupament';
$string['idnumbergrouping_help'] = 'El número ID de l\'agrupament només es fa servir quan es compara l\'agrupament contra sistemes externs i no es veurà en cap lloc del lloc web. Si l\'agrupament té un nom de codi oficial  es pot introduir, en cas contrari el camp es pot deixar en blanc.';
$string['idnumbermod'] = 'Número ID';
$string['idnumbermod_help'] = 'Definir un número ID és una manera de poder identificar l\'activitat en els càlculs de qualificacions.
Si l\'activitat no s\'ha inclòs en cap càlcul de qualificacions, podeu deixar en blanc aquest camp de número ID.

El número ID també es pot definir al butlletí de qualificacions, encara que sols es pugui editar en la pàgina de configuració de l\'activitat.';
$string['idnumbertaken'] = 'Aquest número ID ja s\'està utilitzant';
$string['imagealt'] = 'Descripció de la imatge';
$string['import'] = 'Importa';
$string['importdata'] = 'Importa dades d\'un curs';
$string['importdataexported'] = 'S\'han exportat amb èxit les dades del curs origen.<br /> Continueu per importar-les al curs de destinació.';
$string['importdatafinished'] = 'S\'ha completat la importació. Aneu al vostre curs.';
$string['importdatafrom'] = 'Seleccioneu un curs per importar-ne les dades:';
$string['inactive'] = 'Inactiu';
$string['include'] = 'Inclou';
$string['includeallusers'] = 'Inclou tots els usuaris';
$string['includecoursefiles'] = 'Inclou els fitxers del curs';
$string['includecourseusers'] = 'Inclou els usuaris del curs';
$string['included'] = 'Inclòs';
$string['includelogentries'] = 'Inclou les entrades del registre';
$string['includemodules'] = 'Inclou mòduls';
$string['includemoduleuserdata'] = 'Inclou dades d\'usuari dels mòduls';
$string['includeneededusers'] = 'Inclou els usuaris necessaris';
$string['includenoneusers'] = 'No incloguis cap usuari';
$string['includeroleassignments'] = 'Inclou assignacions de rol';
$string['includesitefiles'] = 'Inclou els fitxers del lloc utilitzats en aquest curs';
$string['includeuserfiles'] = 'Inclou els fitxers dels usuaris';
$string['increasesections'] = 'Augmenta el nombre de seccions';
$string['info'] = 'Informació';
$string['institution'] = 'Institució';
$string['instudentview'] = 'en la visualització de l\'estudiantat';
$string['interests'] = 'Interessos';
$string['interestslist'] = 'Llista d\'interessos';
$string['interestslist_help'] = 'Escriviu els vostres interessos separats per comes. Els interessos es mostraran a la pàgina del vostre perfil com a etiquetes.';
$string['invalidemail'] = 'L\'adreça de correu no és vàlida';
$string['invalidlogin'] = 'Entrada incorrecta, si us plau torneu a intentar-ho';
$string['invalidusername'] = 'El nom d\'usuari sols pot contenir caràcters alfanumèrics en minúscules, guio baix (_), signe menys (-), punt (.) o el símbol arrova (@)  ';
$string['invalidusernameupload'] = 'Nom d\'usuari no vàlid';
$string['ip_address'] = 'Adreça IP';
$string['jump'] = 'Salta';
$string['jumpto'] = 'Salta a...';
$string['keep'] = 'Manté';
$string['keepsearching'] = 'Continua cercant';
$string['langltr'] = 'Escriptura d\'esquerra a dreta';
$string['langrtl'] = 'Escriptura de dreta a esquerra';
$string['language'] = 'Idioma';
$string['languagegood'] = 'Aquest paquet d\'idioma està al dia! :-)';
$string['last'] = 'Últim';
$string['lastaccess'] = 'Darrer accés';
$string['lastcourseaccess'] = 'Últim accés al curs';
$string['lastedited'] = 'Darrera edició';
$string['lastlogin'] = 'Darrera entrada';
$string['lastmodified'] = 'Darrera modificació';
$string['lastname'] = 'Cognoms';
$string['lastnamephonetic'] = 'Cognom - fonètica';
$string['lastsiteaccess'] = 'Últim accés al lloc';
$string['lastyear'] = 'L\'any passat';
$string['latestlanguagepack'] = 'Comprova el darrer paquet d\'idioma en moodle.org';
$string['layouttable'] = 'Taula de format';
$string['leavetokeep'] = 'Deixeu en blanc per tal de mantenir la contrasenya actual';
$string['legacythemeinuse'] = 'Aquest lloc web es mostra en mode compatibilitat ja que el vostre navegador molt antic.';
$string['license'] = 'Llicència';
$string['licenses'] = 'Llicències';
$string['liketologin'] = 'Voleu entrar ara amb un compte d\'usuari complet?';
$string['list'] = 'Llista';
$string['listfiles'] = 'Llista dels fitxers de {$a}';
$string['listofallpeople'] = 'Llista de tota la gent';
$string['listofcourses'] = 'Llista de cursos';
$string['loadinghelp'] = 'S\'està carregant...';
$string['local'] = 'Local';
$string['localplugins'] = 'Connectors locals';
$string['localpluginsmanage'] = 'Gestiona els connectors locals';
$string['location'] = 'Localització';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Heu entrat com {$a}';
$string['loggedinasguest'] = 'Esteu accedint com a visitant';
$string['loggedinnot'] = 'No heu entrat';
$string['login'] = 'Entrada';
$string['loginalready'] = 'Ja heu entrat';
$string['loginas'] = 'Entra com';
$string['loginaspasswordexplain'] = '<p>Heu d\'introduir la contrasenya especial «entra com a» per utilitzar aquesta característica.<br />Si no la sabeu, pregunteu a l\'administrador del servidor.</p>';
$string['login_failure_logs'] = 'Registre d\'entrades fracassades';
$string['loginguest'] = 'Entra com a visitant';
$string['loginsite'] = 'Entra en aquest lloc';
$string['loginsteps'] = 'L\'accés complet als cursos requereix que dediqueu un minut a la creació d\'un nou compte d\'usuari vàlid en aquest lloc web. Cada curs pot requerir també una «clau d\'inscripció» d\'un sol ús que no necessitareu fins més tard. Els passos que heu de seguir són els següents:
<ol>
<li>Ompliu el formulari de <a href="{$a}">Nou compte</a> amb les vostres dades.</li>
<li>Se us enviarà immediatament un correu a la vostra adreça electrònica.</li>
<li>Llegiu el correu i feu clic en l\'enllaç web inclòs.</li>
<li>Es confirmarà el vostre compte i podreu entrar-hi.</li>
<li>Llavors, seleccioneu el curs en el qual voleu participar.</li>
<li>Si se us demana una «clau d\'inscripció», utilitzeu la que us ha donat el professor. Amb això quedareu inscrit al curs.</li>
<li>En aquest moment ja tindreu accés complet al curs. En endavant només haureu d\'introduir el vostre nom d\'usuari i la contrasenya (en el formulari d\'aquesta pàgina) per tal d\'entrar-hi i tenir accés a qualsevol curs en el qual estigueu inscrit.</li>
</ol>';
$string['loginstepsnone'] = '<p>Per tal de tenir accés complet als cursos us heu de crear un compte d\'usuari.</p>
<p>Consisteix simplement a triar un nom d\'usuari i una contrasenya amb els quals us identificareu, després, en aquesta pàgina.</p>
<p>Si algú ja ha triat abans el mateix nom d\'usuari, n\'haureu de provar un altre diferent.</p>';
$string['loginto'] = 'Entra en {$a}';
$string['logout'] = 'Sortida';
$string['logoutconfirm'] = 'Segur que voleu sortir?';
$string['logs'] = 'Registres';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">més</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">més</a> ]';
$string['lookback'] = 'Període';
$string['mailadmins'] = 'Informa administradors';
$string['mailstudents'] = 'Informa estudiantat';
$string['mailteachers'] = 'Informa professorat';
$string['maincoursepage'] = 'Pàgina principal del curs';
$string['makeafolder'] = 'Crea una carpeta';
$string['makeeditable'] = 'Si feu \'{$a}\' editable pel procés del servidor web (p.e. apache), aleshores podreu editar aquest fitxer directament en aquesta pàgina';
$string['makethismyhome'] = 'Fes aquesta la meva pàgina principal';
$string['manageblocks'] = 'Blocs';
$string['managecategorythis'] = 'Gestiona aquesta categoria';
$string['managecourses'] = 'Gestiona cursos';
$string['managedatabase'] = 'Base de dades';
$string['manageeditorfiles'] = 'Gestiona fitxers utilitzats per l\'editor';
$string['managefilters'] = 'Filtres';
$string['managemodules'] = 'Mòduls';
$string['manageroles'] = 'Rols i permisos';
$string['markedthistopic'] = 'Aquest tema està marcat com a tema actual';
$string['markthistopic'] = 'Marca aquest tema com a tema actual';
$string['matchingsearchandrole'] = 'Trobats \'{$a->search}\' i {$a->role}';
$string['maxareabytesreached'] = 'El fitxer ( o la mida total dels fitxers) és més gran que l\'espai disponible que queda en aquesta àrea.';
$string['maxbytesforfile'] = 'El fitxer {$a} és més gran que la mida màxima permesa.';
$string['maxfilesize'] = 'Mida màxima per als nous fitxers: {$a}';
$string['maxfilesreached'] = 'Podeu adjuntar un màxim de {$a} fitxers a aquest element';
$string['maximumchars'] = 'Màxim de {$a} caràcters';
$string['maximumgrade'] = 'Qualificació màxima';
$string['maximumgradex'] = 'Nota màxima: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Mida màxima de càrrega';
$string['maximumupload_help'] = '<p>Aquest paràmetre defineix la mida màxima dels fitxers que poden penjar els estudiants en aquest curs (l\'administrador defineix un límit màxim vàlid per a tot el lloc).</p>

<p>És possible posar límits inferiors dins dels diversos mòdul d\'activitats.</p>';
$string['maxnumberweeks'] = 'Nombre màxim de seccions';
$string['maxnumberweeks_desc'] = 'El valor màxim en el menú desplegable del nombre de seccions (només és aplicable a certs formats de curs).';
$string['maxnumcoursesincombo'] = 'Navega per els<a href="{$a->link}">{$a->numberofcourses} cursos</a>.';
$string['maxsize'] = 'Mida màxima: {$a}';
$string['maxsizeandareasize'] = 'Mida màxima per als fitxers nous: {$a->size}, límit global: {$a->areasize}';
$string['maxsizeandattachments'] = 'Mida màxima per als nous fitxers, {$a->size}, adjunts màxims: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Mida màxima per als fitxers nous: {$a->size}, nombre màxim de fitxers adjunts: {$a->attachments}, límit global: {$a->areasize}';
$string['memberincourse'] = 'Membre del curs';
$string['messagebody'] = 'Cos del missatge';
$string['messagedselectedusers'] = 'S\'ha enviat el missatge als usuaris seleccionats i s\'ha reiniciat la llista de destinataris.';
$string['messagedselectedusersfailed'] = 'Hi ha hagut un problema en enviar el missatge als usuaris seleccionats. Alguns usuaris poden haver rebut el correu.';
$string['messageprovider:availableupdate'] = 'Notificacions d\'actualització disponibles';
$string['messageprovider:backup'] = 'Notificacions de còpia de seguretat';
$string['messageprovider:badgecreatornotice'] = 'Notificacions de creador d\'insígnies';
$string['messageprovider:badgerecipientnotice'] = 'Notificacions de recipient d\'insígnies';
$string['messageprovider:courserequestapproved'] = 'Notificació d\'aprovació de sol·licitud de creació de curs';
$string['messageprovider:courserequested'] = 'Notificació de sol·licitud de creació de curs';
$string['messageprovider:courserequestrejected'] = 'Notificació de denegació de sol·licitud de creació de curs';
$string['messageprovider:errors'] = 'Hi ha errors importants amb el lloc';
$string['messageprovider:errors_help'] = 'Errors importants que l\'administració del lloc hauria de conèixer.';
$string['messageprovider:instantmessage'] = 'Missatges personals entre usuaris';
$string['messageprovider:instantmessage_help'] = 'Aquesta secció permet configurar què passa amb els missatges directes que us envien altres usuaris del lloc.';
$string['messageprovider:notices'] = 'Avisos de problemes menors';
$string['messageprovider:notices_help'] = 'Avisos que poden ser significatius per a l\'administració del lloc.';
$string['messageselect'] = 'Selecciona aquest usuari com a destinatari del missatge';
$string['messageselectadd'] = 'Envia un missatge';
$string['middlename'] = 'Segon nom';
$string['migratinggrades'] = 'S\'estan migrant les qualificacions';
$string['min'] = 'minut';
$string['mins'] = 'minuts';
$string['minute'] = 'minut';
$string['minutes'] = 'minuts';
$string['miscellaneous'] = 'Miscel·lània';
$string['missingcategory'] = 'Heu de triar una categoria';
$string['missingcity'] = 'Falta la població';
$string['missingcountry'] = 'Falta el país';
$string['missingdescription'] = 'Falta la descripció';
$string['missingemail'] = 'Falta l\'adreça electrònica';
$string['missingfirstname'] = 'Falta el nom';
$string['missingfromdisk'] = 'Falta al disc';
$string['missingfullname'] = 'Falta el nom complet';
$string['missinglastname'] = 'Falten els cognoms';
$string['missingname'] = 'Falta el nom';
$string['missingnewpassword'] = 'Falta la nova contrasenya';
$string['missingpassword'] = 'Falta la contrasenya';
$string['missingrecaptchachallengefield'] = 'Falta el camp reCAPTCHA';
$string['missingreqreason'] = 'Falta la raó';
$string['missingshortname'] = 'Falta el nom curt';
$string['missingshortsitename'] = 'Falta el nom breu de lloc';
$string['missingsitedescription'] = 'Falta la descripció del lloc';
$string['missingsitename'] = 'Falta el nom del lloc';
$string['missingstrings'] = 'Cadenes per traduir';
$string['missingstudent'] = 'Heu de triar alguna cosa';
$string['missingsummary'] = 'Falta el resum';
$string['missingteacher'] = 'Heu de triar alguna cosa';
$string['missingurl'] = 'Falta l\'URL';
$string['missingusername'] = 'Falta el nom d\'usuari';
$string['modchooserdisable'] = 'Selector d\'activitat desactivat';
$string['modchooserenable'] = 'Selector d\'activitat activat';
$string['moddoesnotsupporttype'] = 'El mòdul {$a->modname} no és compatible amb fitxers del tipus {$a->type}';
$string['modified'] = 'Modificat';
$string['moduleintro'] = 'Descripció';
$string['modulesetup'] = 'S\'estan configurant les taules de mòduls';
$string['modulesuccess'] = 'S\'han configurat correctament les taules {$a}';
$string['modulesused'] = 'Mòduls utilitzats';
$string['month'] = 'Mes';
$string['months'] = 'Mesos';
$string['moodledocs'] = 'Documentació de Moodle';
$string['moodledocslink'] = 'Documentació de Moodle per a aquesta pàgina';
$string['moodlerelease'] = 'Alliberament de Moodle';
$string['moodleversion'] = 'Versió de Moodle';
$string['more'] = 'més';
$string['morehelp'] = 'Més ajuda';
$string['moreinformation'] = 'Més informació d\'aquest error';
$string['moreprofileinfoneeded'] = 'Doneu-nos més informació sobre vós';
$string['mostrecently'] = 'més recent';
$string['move'] = 'Mou';
$string['movecategoriessuccess'] = 'S\'han mogut amb èxit les categories {$a->count} dins de la categoria \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'S\'han mogut amb èxit les categories {$a->count} al capdamunt';
$string['movecategorycontentto'] = 'Mou a';
$string['movecategorysuccess'] = 'S\'ha mogut amb èxit la categoria \'{$a->moved}\' dins de la categoria \'{$a->to}\'';
$string['movecategoryto'] = 'Mou categoria a:';
$string['movecategorytotopsuccess'] = 'S\'ha mogut amb èxit la categoria \'{$a->moved}\' al capdamunt';
$string['movecontent'] = 'Mou  {$a}';
$string['movecontentstoanothercategory'] = 'Mou els continguts a una altra categoria';
$string['movecoursemodule'] = 'Mou el recurs';
$string['movecoursesection'] = 'Mou la secció';
$string['movecourseto'] = 'Mou curs a:';
$string['movedown'] = 'avall';
$string['movefilestohere'] = 'Mou els fitxers aquí';
$string['movefull'] = 'Mou {$a} a aquest lloc';
$string['movehere'] = 'Mou aquí';
$string['moveleft'] = 'Mou a esquerra';
$string['moveright'] = 'Mou a dreta';
$string['movesection'] = 'Mou la secció {$a}';
$string['moveselectedcategoriesto'] = 'Mou les categories seleccionades a';
$string['moveselectedcoursesto'] = 'Mou els cursos seleccionats a...';
$string['movetoanotherfolder'] = 'Mou-los a una altra carpeta';
$string['moveup'] = 'amunt';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'La nova contrasenya ha de ser diferent de l\'actual';
$string['mustconfirm'] = 'Necessiteu confirmar el vostre registre';
$string['mycourses'] = 'Els meus cursos';
$string['myfiles'] = 'Els meus fitxers privats';
$string['myfilesmanage'] = 'Gestiona els meus fitxers privats';
$string['myhome'] = 'La meva pàgina inicial';
$string['mymoodledashboard'] = 'La meva consola de Moodle';
$string['myprofile'] = 'El meu perfil';
$string['name'] = 'Nom';
$string['nameforlink'] = 'Què voleu enllaçar amb aquest hipervincle?';
$string['nameforpage'] = 'Nom';
$string['navigation'] = 'Navegació';
$string['needed'] = 'Necessari';
$string['never'] = 'Mai';
$string['neverdeletelogs'] = 'No suprimeixis mai els registres';
$string['new'] = 'Nou';
$string['newaccount'] = 'Nou compte';
$string['newcourse'] = 'Nou curs';
$string['newpassword'] = 'Nova contrasenya';
$string['newpasswordfromlost'] = '<strong>AVÍS:</strong> se us ha enviat la vostra <strong>contrasenya actual</strong> en el <strong>segon</strong> dels dos correus que rebreu com a part del procés de recuperació de la contrasenya. Assegureu-vos que heu rebut la contrasenya nova abans de continuar.';
$string['newpassword_help'] = 'Introduïu una nova contrasenya o deixeu-ho en blanc per mantenir la contrasenya actual.';
$string['newpasswordtext'] = '{$a->firstname},

S\'ha anul·lat la contrasenya del vostre compte en \'{$a->sitename}\' i se us n\'ha assignat una de nova provisionalment.

Les dades per entrar-hi ara són:
nom d\'usuari: {$a->username}
contrasenya: {$a->newpassword}

Si us plau aneu a aquesta pàgina per canvieu la vostra contrasenya:
{$a->link}

En la majoria de programes de correu, l\'adreça s\'hauria de presentar com un enllaç blau on podeu fer clic. Si això no funciona, copieu i enganxeu l\'adreça al camp d\'adreces
de la finestra del vostre navegador web.

Salutacions de l\'administrador de \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Nova imatge';
$string['newpicture_help'] = '<p>Podeu penjar al servidor una imatge que tingueu al vostre ordinador que servir&agrave; per representar-vos en diferents llocs.</p>

<p>Per aquesta ra&oacute;, tot i que podeu utilitzar la imatge que vulgueu, la millor idea &eacute;s posar un primer pla de la vostra cara.</p>

<p>La imatge ha d\'estar en format JPG o PNG (normalment el nom del fitxer ha d\'acabar en .jpg o .png).</p>

<p>Podeu obtenir aquest fitxer mitjan&ccedil;ant qualsevol dels m&egrave;todes seg&uuml;ents:</p>

<OL>

  <li>Si feu servir una c&agrave;maradigital, molt probablement les fotos es transferiran al vostre ordinador en el format correcte.</li>

  <li>Podeu escanejar una fotografia que tingueu en paper. Assegureu-vos que la deseu en format JPG o PNG. </li>

  <li>Si sou artistes, podeu fer-vos un autoretrat amb una programa de dibuix.</li>

  <li>Finalment, podeu &quot;robar&quot; imatges del web. <a target="google" href="http://images.google.com/">http://images.google.com</a> &eacute;s un magn&iacute;fic lloc on cercar imatges. Un cop en trobeu una podeu desar-la al vostre ordinador.</li>

</ol>

<p>Per penjar la imatge feu clic al bot&oacute; &quot;Navega&quot; d\'aquesta p&agrave;gina i seleccioneu la imatge al vostre disc dur.</p>

<p>NOTA: assegureu-vos que l\'arxiu no supera la mida m&agrave;xima indicada o no es podr&agrave; penjar.</p>

<p>En acabat feu clic al bot&oacute; &quot;Actualitza perfil&quot; al capdavall p&agrave;gina i la imatge es retallar&agrave; i es reduir&agrave; a una mida de 100x100 p&iacute;xels. </p>

<p>Quan torneu a visualitzar el vostre perfil &eacute;s possible que no hagi canviat la imatge. En aquest cas feu servir el comandament &quot;Actualitza&quot; o &quot;Reload&quot; del navegador.

  del vostre programa navegador.</p>';
$string['newsitem'] = 'Notícia';
$string['newsitems'] = 'Notícies';
$string['newsitemsnumber'] = 'Notícies per mostrar';
$string['newsitemsnumber_help'] = '<p>En els formats de curs &quot;setmanal&quot; i per &quot;temes&quot; apareix un f&ograve;rum especial anomenat &quot;Not&iacute;cies&quot;. &Eacute;s un bon lloc per publicar els avisos que hagin de veure tots els estudiants. Per defecte tots els estudiants estan subscrits a aquest f&ograve;rum i reben els avisos per correu electr&ograve;nic.</p>

<p>Aquest par&agrave;metre determina quants &iacute;tems apareixen a la p&agrave;gina inicial del curs, en un quadre de not&iacute;cies a la banda dreta.</p>

<p>Si poseu &quot;0 not&iacute;cies&quot; aleshores no apareixer&agrave; el quadre de not&iacute;cies.</p>';
$string['newuser'] = 'Nou usuari';
$string['newusernewpasswordsubj'] = 'Nou compte d\'usuari';
$string['newusernewpasswordtext'] = 'Hola {$a->firstname},

Se us ha creat un nou compte d\'usuari en \'{$a->sitename}\' i se us ha assignat una nova contrasenya temporal.

La vostra informació d\'entrada és ara:
usuari: {$a->username}
contrasenya: {$a->newpassword}
(en entrar-hi per primera vegada haureu de canviar aquesta contrasenya)

Per començar a utilitzar {$a->sitename}, entreu en {$a->link}

En la majoria de programes de correu aquesta adreça hauria d\'aparèixer com un enllaç blau on podeu fer clic. Si això no funciona, copieu l\'adreça i enganxeu-la en el camp d\'ubicació al capdamunt de la finestra del navegador.

Salutacions de l\'administrador de
{$a->sitename},

{$a->signoff}';
$string['newusers'] = 'Nous usuaris';
$string['newwindow'] = 'Finestra nova';
$string['next'] = 'Següent';
$string['nextsection'] = 'Secció següent';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'No hi ha blocs que pugueu afegir a aquesta pàgina.';
$string['nobody'] = 'Ningú';
$string['nochange'] = 'Sense canvis';
$string['nocomments'] = 'Sense comentaris';
$string['nocourses'] = 'No hi ha cursos';
$string['nocoursesfound'] = 'No s\'ha trobat cap curs que contingui les paraules \'{$a}\'';
$string['nocoursesyet'] = 'No hi ha cursos en aquesta categoria';
$string['nodstpresets'] = 'L\'administrador no ha habilitat l\'horari d\'estiu.';
$string['nofilesselected'] = 'No heu seleccionat cap fitxer per restaurar';
$string['nofilesyet'] = 'Encara no s\'han penjat fitxers en aquest curs';
$string['nograde'] = 'Sense qualificació';
$string['nohelpforactivityorresource'] = 'Actualment no hi ha una ajuda associada a aquest recurs o activitat';
$string['noimagesyet'] = 'Encara no s\'han penjat imatges en aquest curs';
$string['nologsfound'] = 'No s\'han trobat registres';
$string['nomatchingusers'] = 'Cap usuari concorda amb \'{$a}\'';
$string['nomorecourses'] = 'No s\'ha trobat cap altre curs que coincideixi';
$string['nomoreidnumber'] = 'No s\'està utilitzant un número d\'identificació per evitar conflictes';
$string['none'] = 'Cap';
$string['noneditingteacher'] = 'Professorat no-editor';
$string['noneditingteacherdescription'] = 'El professorat no-editor pot ensenyar dins dels cursos i qualificar l\'estudiantat, però no pot modificar les activitats.';
$string['nonstandard'] = 'No estàndard';
$string['nopendingcourses'] = 'No hi ha cursos pendents d\'aprovació';
$string['nopotentialadmins'] = 'No hi ha administradors en potència';
$string['nopotentialcreators'] = 'No hi ha creadors de cursos en potència';
$string['nopotentialstudents'] = 'No hi ha estudiants en potència';
$string['nopotentialteachers'] = 'No hi ha professors en potència';
$string['norecentactivity'] = 'No hi ha activitat recent';
$string['noreplybouncemessage'] = 'Heu contestat a una adreça de correu inadequada. Si volíeu contestar un missatge del fòrum, contesteu si us plau utilitzant els fòrums: {$a}.

Aquí teniu el contingut del vostre missatge:';
$string['noreplybouncesubject'] = '{$a} - missatge retornat';
$string['noreplyname'] = 'No contesteu a aquest missatge';
$string['noresetrecord'] = 'No hi ha constància de la sol·licitud de restabliment. Faci una sol·licitud nova de restabliment de contrasenya.';
$string['noresults'] = 'Sense resultats';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Filtre normal';
$string['nosite'] = 'No s\'ha pogut trobar el curs del nivell de lloc';
$string['nostudentsfound'] = 'No s\'ha trobat {$a}';
$string['nostudentsingroup'] = 'Encara no hi ha estudiants en aquest grup';
$string['nostudentsyet'] = 'Encara no hi ha cap estudiant inscrit en aquest curs';
$string['nosuchemail'] = 'Adreça de correu desconeguda';
$string['notavailable'] = 'No disponible';
$string['noteachersyet'] = 'Encara no hi ha cap professor en aquest curs';
$string['notenrolled'] = '{$a} no està inscrit en aquest curs.';
$string['notenrolledprofile'] = 'El perfil no està disponible perquè aquest usuari no està inscrit en aquest curs.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:</strong> La capacitat de canviar les dates quan es restaura un backpup ha estat desactivada ja que no teniu els permisos que calen';
$string['noteuserschangednonetocourse'] = '<strong>Nota:</strong> Els usuaris d\'un curs s\'han de restaurar quan es restauren les dades d\'usuaris (en activitats, fitxers o missatges). Aquest paràmetre s\'ha canviat automàticament.';
$string['nothingnew'] = 'Cap novetat des de l\'última entrada';
$string['nothingtodisplay'] = 'No hi ha res per visualitzar';
$string['notice'] = 'Avís';
$string['noticenewerbackup'] = 'Aquesta còpia de seguretat ha estat creada amb Moodle {$a->backuprelease} ({$a->backupversion}) i és més nova que la vostra instal·lació de Moodle {$a->serverrelease} ({$a->serverversion}). Això pot donar lloc a algunes inconsistències perquè no es pot garantir la compatibilitat de les còpies cap enrere.';
$string['notifications'] = 'Notificacions';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, usuari: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Podeu veure aquí aquests registres:
{$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Heus aquí una llista d\'intents d\'entrada fracassats en {$a} des de la darrera notificació';
$string['notifyloginfailuressubject'] = '{$a} :: Notificació d\'entrades fracassades';
$string['notincluded'] = 'No inclòs';
$string['notingroup'] = 'Heu de ser part d\'un grup per veure aquesta activitat.';
$string['notpublic'] = 'No és públic';
$string['nousersfound'] = 'No s\'han trobat usuaris';
$string['nousersmatching'] = 'No s\'han trobat usuaris que coincideixin amb \'{$a}\'';
$string['nousersyet'] = 'Encara no hi ha usuaris';
$string['novalidcourses'] = 'No hi ha cursos vàlids per mostrar';
$string['now'] = 'ara';
$string['numattempts'] = '{$a} intents fracassats d\'entrada';
$string['numberofcourses'] = 'Nombre de cursos';
$string['numberweeks'] = 'Nombre de temes/setmanes';
$string['numdays'] = '{$a} dies';
$string['numhours'] = '{$a} hores';
$string['numletters'] = '{$a} cartes';
$string['numminutes'] = '{$a} minuts';
$string['nummonths'] = '{$a} mesos';
$string['numseconds'] = '{$a} segons';
$string['numviews'] = '{$a} visualitzacions';
$string['numweeks'] = '{$a} setmanes';
$string['numwords'] = '{$a} paraules';
$string['numyears'] = '{$a} anys';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Contrasenya actual';
$string['olduserdirectory'] = 'Aquest és l\'ANTIC directori d\'usuaris i ja no és necessari. Podeu suprimir-lo tranquil·lament. Els fitxers que conté s\'han copiat al NOU directori d\'usuaris.';
$string['opentoguests'] = 'Accés de visitants';
$string['optional'] = 'opcional';
$string['options'] = 'opcions';
$string['order'] = 'Ordre';
$string['originalpath'] = 'Ruta original';
$string['orphanedactivitiesinsectionno'] = 'Activitats òrfenes (secció {$a})';
$string['other'] = 'Altre';
$string['outline'] = 'Esquema';
$string['outlinereport'] = 'Informe en esquema';
$string['page'] = 'Pàgina';
$string['pagea'] = 'Pàgina {$a}';
$string['pageheaderconfigablock'] = 'S\'està configurant un bloc {$a->fullname}';
$string['pagepath'] = 'Camí de la pàgina';
$string['pageshouldredirect'] = 'Sereu redirigits de forma automàtica. Si no sou redirigits utilitzeu l\'enllaç de sota. ';
$string['parentcategory'] = 'Categoria mare';
$string['parentcoursenotfound'] = 'No s\'ha trobat el curs pare';
$string['parentfolder'] = 'Nivell superior';
$string['participants'] = 'Participants';
$string['participantslist'] = 'Llista de participants';
$string['participationratio'] = 'Proporció de participació';
$string['participationreport'] = 'Informe de participació';
$string['password'] = 'Contrasenya';
$string['passwordchanged'] = 'S\'ha canviat la contrasenya';
$string['passwordconfirmchange'] = 'Confirma el canvi de la contrasenya';
$string['passwordextlink'] = 'Seguiu aquest enllaç per recuperar la vostra contrasenya. Us portarà fora de Moodle.';
$string['passwordforgotten'] = 'Heu oblidat la contrasenya';
$string['passwordforgotteninstructions'] = 'En primer lloc cal trobar les vostres dades en la base de dades d\'usuaris. Introduïu en el camp apropiat el vostre nom d\'usuari de Moodle <strong>o bé</strong> l\'adreça de correu amb què us vau registrar. No cal que ompliu els dos camps.';
$string['passwordforgotteninstructions2'] = 'Per reiniciar la vostra contrasenya, envieu el vostre nom d\'usuari o el vostre correu electrònic a sota. Si el podem trobar a la base de dades, us enviarem un correu amb instruccions per tornar a entrar.';
$string['passwordnohelp'] = 'No es pot recuperar la vostra contrasenya. Contacteu amb l\'administrador o administradora.';
$string['passwordrecovery'] = 'Sí, ajuda\'m a entrar-hi';
$string['passwordsdiffer'] = 'Les contrasenyes no coincideixen';
$string['passwordsent'] = 'S\'ha enviat la contrasenya';
$string['passwordsenttext'] = '<p>S\'ha enviat un correu a la vostra adreça electrònica {$a->email}.</p>
<p><b>Si us plau, busqueu la contrasenya nova al correu</b></p>
<p>Aquesta contrasenya nova s\'ha generat automàticament, de manera que potser voldreu <A href="{$a->link}">canviar-la per una altra més fàcil de recordar</a>.</p>';
$string['passwordset'] = 'S\'ha definit la vostra contrasenya.';
$string['path'] = 'Camí';
$string['pathnotexists'] = 'Aquest camí no existeix al servidor';
$string['pathslasherror'] = 'El camí no pot acabar amb una barra';
$string['paymentinstant'] = 'Utilitzeu el botó de baix per pagar i inscriure-us.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendent</small>)';
$string['paymentrequired'] = 'Aquest curs requereix pagament.';
$string['payments'] = 'Pagaments';
$string['paymentsorry'] = 'Gràcies per pagar. Dissortadament el pagament encara no ha estat completament processat i encara no podeu entrar al curs "{$a->fullname}". Torneu a intentar-ho d\'aquí a uns segons i si no podeu adreceu-vos al {$a->teacher} o a l\'administrador del lloc';
$string['paymentthanks'] = 'Gràcies per pagar. Ja esteu inscrit al curs:<br />"{$a}"';
$string['pendingrequests'] = 'Sol·licituds pendents';
$string['periodending'] = 'Fi del període ({$a})';
$string['perpage'] = 'per pàgina';
$string['perpagea'] = 'per pàgina: {$a}';
$string['personal'] = 'Personal';
$string['personalprofile'] = 'Perfil personal';
$string['phone'] = 'Telèfon';
$string['phone2'] = 'Telèfon mòbil';
$string['phpinfo'] = 'informació PHP';
$string['pictureof'] = 'Imatge {$a}';
$string['pictureofuser'] = 'Imatge de l\'usuari';
$string['pleaseclose'] = 'Tanqueu aquesta finestra.';
$string['pleasesearchmore'] = 'Si-us-plau cerqueu més encara';
$string['pleaseusesearch'] = 'Si-us-plau utilitzeu la cerca';
$string['plugin'] = 'Connector';
$string['plugincheck'] = 'Comprovació de connectors';
$string['plugindeletefiles'] = 'Totes les dades associades amb el connector \'{$a->name}\' has sigut esborrades de la base de dades. Per prevenir  la reinstal·lació del connector, hauríeu de suprimir el següent directori del servidor: {$a->directory}';
$string['pluginsetup'] = 'S\'estan configurant les taules de connectors';
$string['policyaccept'] = 'Entès i conforme';
$string['policyagree'] = 'Heu d\'acceptar la normativa abans d\'entrar en aquest lloc. Hi esteu d\'acord?';
$string['policyagreement'] = 'Acceptació de la normativa d\'ús del lloc';
$string['policyagreementclick'] = 'Enllaç a l\'acceptació de la normativa d\'ús del lloc';
$string['popup'] = 'emergent';
$string['popupwindow'] = 'Obre el fitxer en una altra finestra';
$string['popupwindowname'] = 'Finestra emergent';
$string['post'] = 'Enviament';
$string['posts'] = 'Enviaments';
$string['potentialadmins'] = 'Administradors en potència';
$string['potentialcreators'] = 'Creadors de cursos en potència';
$string['potentialstudents'] = 'Estudiants en potència';
$string['potentialteachers'] = 'Professors en potència';
$string['preferences'] = 'Preferències';
$string['preferredlanguage'] = 'Idioma preferit';
$string['preferredtheme'] = 'Tema preferit';
$string['preprocessingbackupfile'] = 'S\'està preprocessant el fitxer de la còpia de seguretat';
$string['prev'] = 'Anterior';
$string['preview'] = 'Previsualització';
$string['previewhtml'] = 'Previsualització format HTML';
$string['previeworchoose'] = 'Proveu o trieu un tema';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Els usuaris seleccionats prèviament no concorden amb \'{$a}\'';
$string['previoussection'] = 'Secció anterior';
$string['primaryadminsetup'] = 'Configuració del compte d\'administració';
$string['profile'] = 'Perfil';
$string['profilenotshown'] = 'Aquesta descripció del perfil no es mostrarà fins que la persona no estigui inscrita almenys en un curs.';
$string['publicprofile'] = 'Perfil públic';
$string['publicsitefileswarning'] = 'Nota: els fitxers col·locats aquí són accessibles per tothom';
$string['publicsitefileswarning2'] = 'Nota: Els fitxers posats aquí són accessibles per a tothom que conegui l\'URL (o pugui accedir-hi). Per motius de seguretat es recomana que després de fer la còpia de seguretat i la restauració suprimiu els fitxers.';
$string['publicsitefileswarning3'] = 'Nota: Els fitxers posats aquí són accessibles per a tothom que conegui l\'URL (o pugui accedir-hi). Per motius de seguretat es recomana que les còpies de seguretat s\'emmagatzemin sols a les carpetes segures  de còpia de seguretat de dades.';
$string['publish'] = 'Publica';
$string['question'] = 'Pregunta';
$string['questionsinthequestionbank'] = 'Preguntes del banc de preguntes';
$string['readinginfofrombackup'] = 'S\'està llegint la informació de la còpia de seguretat';
$string['readme'] = 'LLEGIU-ME';
$string['recentactivity'] = 'Activitat recent';
$string['recentactivityreport'] = 'Informe complet d\'activitat recent...';
$string['recipientslist'] = 'Llista de destinataris';
$string['recreatedcategory'] = 'S\'ha recreat la categoria {$a}';
$string['redirect'] = 'Redirigeix';
$string['reducesections'] = 'Disminueix el nombre de seccions';
$string['refresh'] = 'Refresca';
$string['refreshingevents'] = 'S\'estan refrescant els esdeveniments';
$string['registration'] = 'Registre de Moodle';
$string['registrationcontact'] = 'Contacte públic';
$string['registrationcontactno'] = 'No, no vull un formulari de contacte en la llista de llocs';
$string['registrationcontactyes'] = 'Sí, vull un formulari perquè em contactin altres possibles usuaris de Moodle';
$string['registrationemail'] = 'Notificacions per correu';
$string['registrationinfo'] = '<p>Aquesta pàgina us permet registrar el vostre lloc  Moodle en moodle.org.  El registre és gratuït.
El principal benefici del registre és que se us afegirà a una llista de correu de poc tràfic per rebre les notificacions més importants, com ara alertes de seguretat o l\'aparició de noves versions de Moodle.</p>
<p>Per defecte la vostra informació serà privada i mai no es vendrà o cedirà a ningú més. L\'única raó per recollir aquesta informació és per motius de suport i per ajudar a construir una imatge estadística de la comunitat Moodle com un tot.
<p>Si ho trieu així, el nom del vostre lloc, el país i l\'adreça web s\'afegiran a la llista pública de llocs Moodle.</p>
<p>Tots el registres nous són verificats manualment abans d\'afegir-se a la llista, però un cop afegits podeu modificar el vostre registre i les dades de la llista pública en el moment en què ho desitgeu tot reenviant aquest formulari.</p>';
$string['registrationinfotitle'] = 'Informació de registre';
$string['registrationno'] = 'No, no vull rebre correu electrònic';
$string['registrationsend'] = 'Envia la informació de registre a moodle.org';
$string['registrationyes'] = 'Sí, vull rebre notificacions d\'assumptes importants';
$string['reject'] = 'Denega';
$string['rejectdots'] = 'Denega...';
$string['reload'] = 'Torna a carregar';
$string['remoteappuser'] = 'Usuari remot {$a}';
$string['remove'] = 'Suprimeix';
$string['removeadmin'] = 'Suprimeix administrador';
$string['removecreator'] = 'Suprimeix creador de cursos';
$string['removestudent'] = 'Suprimeix estudiant';
$string['removeteacher'] = 'Suprimeix professor';
$string['rename'] = 'Canvia el nom';
$string['renamefileto'] = 'Canvia el nom de <b>{$a}</b> a';
$string['report'] = 'Informe';
$string['reports'] = 'Informes';
$string['repositories'] = 'Repositoris';
$string['requestcourse'] = 'Sol·licita un curs';
$string['requestedby'] = 'Sol·licitat per';
$string['requestedcourses'] = 'Cursos consultats';
$string['requestreason'] = 'Raó de la sol·licitud';
$string['required'] = 'Necessari';
$string['requirespayment'] = 'Aquest curs requereix pagament';
$string['reset'] = 'Reinicia';
$string['resetcomponent'] = 'Component';
$string['resetcourse'] = 'Reinicia curs';
$string['resetinfo'] = 'Aquesta pàgina us permet buidar un curs, tot suprimint les dades d\'usuari i conservant les activitats i altres paràmetres. Teniu en compte que en trametre aquest formulari suprimireu definitivament les dades d\'usuari d\'aquest curs que hàgiu seleccionat.';
$string['resetnotimplemented'] = 'Reinici no implementat';
$string['resetrecordexpired'] = 'L\'enllaç de restabliment de la contrasenya que ha utilitzat fa {$a} minuts ha expirat. Torni a iniciar un nou procediment de restabliment de contrasenya..';
$string['resetstartdate'] = 'Redefineix la data d\'inici';
$string['resetstatus'] = 'Estat';
$string['resettask'] = 'Tasca';
$string['resettodefaults'] = 'Reinicia a valors per defecte';
$string['resortbyfullname'] = 'per nom complet';
$string['resortbyidnumber'] = 'per nombre id';
$string['resortbyshortname'] = 'per nom curt';
$string['resortcourses'] = 'Ordena els cursos';
$string['resortsubcategoriesbyidnumber'] = 'Ordena les subcategories per nombre ID';
$string['resortsubcategoriesbyname'] = 'Ordena les subcategories per nom';
$string['resource'] = 'Recurs';
$string['resourcedisplayauto'] = 'Automàtic';
$string['resourcedisplaydownload'] = 'Imposa que es baixi';
$string['resourcedisplayembed'] = 'Incrusta';
$string['resourcedisplayframe'] = 'En un marc';
$string['resourcedisplaynew'] = 'Nova finestra';
$string['resourcedisplayopen'] = 'Obre';
$string['resourcedisplaypopup'] = 'En una finestra emergent';
$string['resources'] = 'Recursos';
$string['resources_help'] = 'Els tipus de recursos permeten que quasi qualsevol contingut web es pugui inserir al curs.';
$string['restore'] = 'Restaura';
$string['restorecancelled'] = 'S\'ha cancel·lat la restauració';
$string['restorecannotassignroles'] = 'Per fer la restauració us cal tindre assignat un altre perfil i vosaltres no en teniu permís';
$string['restorecannotcreateorassignroles'] = 'Per fer la restauració us cal crear o assignar perfils i no en teniu permís per fer això';
$string['restorecannotcreateuser'] = 'Per fer la restauració us cal crear l\'usuari \'{$a}\' des de la còpia de seguretat i no teniu permís per fer això';
$string['restorecannotoverrideperms'] = 'Per fer la restauració us cal sobreescriure permisos i no teniu el permís per fer això';
$string['restorecoursenow'] = 'Restaura aquest curs ara';
$string['restoredaccount'] = 'Compte restaurat';
$string['restoredaccountinfo'] = 'Aquest compte ha sigut importat des d\'un altre servidor i la contrasenya s\'ha perdut. Per establir una altra contrasenya per correu electrònic, si us plau premeu "Continua"';
$string['restorefinished'] = 'La restauració s\'ha completat amb èxit';
$string['restoreto'] = 'Restaura en';
$string['restoretositeadding'] = 'Atenció: Aneu a restaurar la  primera plana del lloc afegint-hi dades!';
$string['restoretositedeleting'] = 'Atenció: Aneu a restaurar la  primera plana del lloc esborrant-li dades primer!';
$string['restoreuserconflict'] = 'Intentar restaurar l\'usuari {$a}\' des de la còpia de seguretat causa conflictes';
$string['restoreuserinfofailed'] = 'El procés de restauració s\'ha aturat perquè no teniu permís per a restaurar dades d\'usuari.';
$string['restoreusersprecheck'] = 'S\'estan comprovant les dades d\'usuari';
$string['restoreusersprecheckerror'] = 'S\'han detectat alguns problemes durant la comprovació de les dades d\'usuari';
$string['restricted'] = 'Restringit';
$string['returningtosite'] = 'Esteu tornant a aquest lloc?';
$string['returntooriginaluser'] = 'Torna a {$a}';
$string['revert'] = 'Torna';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Assignacions de rols';
$string['rolemappings'] = 'Mapatge de rols';
$string['rolerenaming'] = 'Canvi de nom del rol';
$string['rolerenaming_help'] = 'Aquesta opció us permet canviar els noms amb què es visualitzen els rols en el vostre curs. Per exemple, podríeu canviar el nom del rol "Professor" a "Facilitador" o "Tutor".  Només canvia el nom: els permisos no canvien.
Els nous noms apareixen a la pàgina de participants i en qualsevol altra pàgina del curs on s\'utilitzin. Si es tracta d\'un rol seleccionat per l\'administrador com a administrador del curs, el nou nom també apareixerà a les llistes de cursos.';
$string['roles'] = 'Rols';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Nombre d\'articles RSS recents';
$string['rsserror'] = 'Error en la lectura de les dades RSS';
$string['rsserrorauth'] = 'El vostre enllaç RSS no conté un testimoni d\'autenticació vàlid.';
$string['rsserrorguest'] = 'Aquest canal utilitza accés de visitant per a accedir a les dades, però l\'usuari visitant no té permís per a llegir les dades. Aneu a la ubicació original d\'aquest canal com a un usuari vàlid i obteniu un nou URL del canal RSS.';
$string['rsskeyshelp'] = 'Per assegurar la seguretat i la privacitat, les alimentacions RSS contenen un token especial que identifica l\'usuari. Això impedeix que altres usuaris accedeixen a àrees de Moodle a les qual no haurien de tindre accés mitjançant l\'alimentació RSS.</p><p> Aquest token es crea la primera vegada que accediu a un àrea de Moodle que produeixi alimentació RSS. Si penseu que el vostre token ha estat compromès d\'alguna forma podeu demanar-ne un altre prement l\'enllaç aquí. Fixeu-vos que la vostra URL de l\'alimentació RSS serà invalidada.';
$string['rsstype'] = 'Canal RSS d\'aquesta activitat';
$string['saveandnext'] = 'Desa i mostra el següent';
$string['savechanges'] = 'Desa els canvis';
$string['savechangesanddisplay'] = 'Desa els canvis i visualitza';
$string['savechangesandreturntocourse'] = 'Desa els canvis i torna al curs';
$string['savecomment'] = 'Desa el comentari';
$string['savedat'] = 'Desat:';
$string['savepreferences'] = 'Desa les preferències';
$string['saveto'] = 'Desa en';
$string['scale'] = 'Escala';
$string['scale_help'] = '<p>Els professors poden crear noves escales personalitzades per usar-les en un curs en qualsevol activitat que es pugui qualificar.</p>

<p>El nom de l\'escala ha de ser una frase que la identifiqu&eacute;s clarament: apareixer&agrave; a les llistes de selecci&oacute; d\'escales i als botons d\'ajuda contextual.</p>

<p>L\'escala es defineix com una llista ordenada de valors, que van
  des dels negatius als positius, separats per comes. Per exemple: </p>

<blockquote><i>Decebedor, No prou bo, Correcte, Bo, Molt bo, Excel&middot;lent!
  </i></blockquote>

<p>Les escales tamb&eacute; han d\'incloure una bona descripci&oacute; del que signifiquen i com han d\'usar-se. Aquesta descripci&oacute; apareix a les p&agrave;gines d\'ajuda per a professors i estudiants.</p>

<p>Finalment, pot haver-hi una o m&eacute;s escales "est&agrave;ndard" definides per l\'administrador per a tot el lloc web. Aquestes estaran disponibles per a tots els cursos.</p>';
$string['scales'] = 'Escales';
$string['scalescustom'] = 'Escales personalitzades';
$string['scalescustomcreate'] = 'Afegeix una escala nova';
$string['scalescustomno'] = 'Encara no s\'ha creat cap escala personalitzada';
$string['scalesstandard'] = 'Escales estàndard';
$string['scalestandard'] = 'Escala estàndard';
$string['scalestandard_help'] = '<p>Una escala estàndard està disponible per a tots els cursos del lloc.</p>';
$string['scalestip'] = 'Per tal de crear escales personalitzades, utilitzeu l\'enllaç \'Escales...\' del menú d\'administració del curs.';
$string['scalestip2'] = 'Per a crear escales personalitzades, feu clic en l\'enllaç de Qualificacions del menú d\'administració del curs i després trieu Edita, Escales.';
$string['schedule'] = 'Planificació';
$string['screenshot'] = 'Instantània de pantalla';
$string['search'] = 'Cerca';
$string['searchagain'] = 'Torna a cercar';
$string['searchbyemail'] = 'Cerca per correu electrònic';
$string['searchbyusername'] = 'Cerca per nom d\'usuari';
$string['searchcourses'] = 'Cerca cursos';
$string['searchhelp'] = '<p>Podeu cercar diverses paraules de cop. i refinar la vostra cerca de la següent manera:</p>
<ul>
<li>paraula - cerca qualsevol coincidència d\'aquesta paraula al text.</li>
<li>+paraula - cerca només coincidències exactes.</li>
<li>-paraula - exclou els resultats que continguin aquesta paraula.</li>
</ul>';
$string['search_help'] = 'Per fer cerques bàsiques amb una o més paraules al text, teclegeu les paraules separades per espais en blanc. Tots els mots de més de dos caràcters seran utilitzats.

Per fer una cerca avançada, premeu el botó de cerca sense escriure res a la caixa de text per accedir al menú avançat de cerca.';
$string['searchoptions'] = 'Opcions de cerca';
$string['searchresults'] = 'Resultats de la recerca';
$string['sec'] = 'segon';
$string['seconds'] = 'segons';
$string['secondstotime172800'] = 'dos dies';
$string['secondstotime259200'] = 'tres dies';
$string['secondstotime345600'] = 'quatre dies';
$string['secondstotime432000'] = 'cinc dies';
$string['secondstotime518400'] = 'sis dies';
$string['secondstotime604800'] = 'una setmana';
$string['secondstotime86400'] = 'un dia';
$string['secretalreadyused'] = 'La contrasenya no s\'ha canviat. Aquest enllaç de confirmació del canvi de contrasenya ja havia estat usat abans.';
$string['secs'] = 'segons';
$string['section'] = 'Secció';
$string['sectionname'] = 'Nom de la secció';
$string['sections'] = 'Seccions';
$string['sectionusedefaultname'] = 'Utilitza el nom de secció per defecte';
$string['seealsostats'] = 'Vg. també: estadístiques';
$string['selctauser'] = 'Selecciona un usuari';
$string['select'] = 'Selecciona';
$string['selectacategory'] = 'Seleccioneu una categoria';
$string['selectacountry'] = 'Selecciona un país';
$string['selectacourse'] = 'Selecciona un curs';
$string['selectacoursesite'] = 'Selecciona un curs o lloc web';
$string['selectagroup'] = 'Selecciona un grup';
$string['selectall'] = 'Selecciona tot';
$string['selectamodule'] = 'Heu de seleccionar un mòdul d\'activitat';
$string['selectanaction'] = 'Selecciona una acció';
$string['selectanoptions'] = 'Seleccioneu una opció';
$string['selectaregion'] = 'Seleccioneu una regió';
$string['selectcategorysort'] = 'Quines categories voldríeu ordenar?';
$string['selectcategorysortby'] = 'Seleccioneu com voleu ordenar les categories';
$string['selectcoursesortby'] = 'Seleccioneu com voleu ordenar els cursos';
$string['selectdefault'] = 'Seleccioneu el valor per defecte';
$string['selectedcategories'] = 'Categories seleccionades';
$string['selectedfile'] = 'Fitxer seleccionat';
$string['selectednowmove'] = '{$a} fitxers seleccionats per moure\'ls. Ara aneu a la carpeta de destinació i premeu \'Mou els fitxers aquí\'';
$string['selectfiles'] = 'Fitxers seleccionats';
$string['selectmoduletoviewhelp'] = 'Seleccioneu una activitat o recurs per veure la seva ajuda.
Premeu dues vegades sobre el nom de l\'activitat o recurs per afegir-lo de forma ràpida.';
$string['selectnos'] = 'Selecciona tots els «No»';
$string['selectperiod'] = 'Seleccioneu el període';
$string['senddetails'] = 'Envia\'m les dades per correu';
$string['separate'] = 'Separat';
$string['separateandconnected'] = 'Formes de coneixement separades i connectades';
$string['separateandconnectedinfo'] = 'L\'escala basada en la teoria del coneixement separat i connectat.
La teoria descriu dues formes diferents d\'avaluar i aprendre sobre les coses que podem veure i escoltar.   <ul><li><strong>Els coneixedors separats</strong> intenten mantindre\'s objectius sense deixar-se influir pels sentiments ni les mocions. En la discussió amb altra gent els agrada defensar les seves idees utilitzant la lògica per trobar forats en l\'argumentació de l\'oponent. </li><li><strong>El coneixedors connectats</strong> són molt més sensitius que la resta de la gent. Són experts en empatia i tendeixen a escoltar i fer preguntes fins que poden "entendre el teu punt de vista". Aprenen intentant compartir experiències  amb la resta de la gent. </li></ul>';
$string['servererror'] = 'S\'ha produït un error mentre es comunicava amb el servidor';
$string['serverlocaltime'] = 'Hora del servidor local';
$string['setcategorytheme'] = 'Estableix el tema de la categoria';
$string['setpassword'] = 'Definició de la contrasenya';
$string['setpasswordinstructions'] = 'Introduïu i repetiu la nova contrasenya a continuació, feu clic a «Definició de la contrasenya». <br /> La vostra nova contrasenya es desarà, i haureu entrat.';
$string['settings'] = 'Paràmetres';
$string['shortname'] = 'Nom curt';
$string['shortnamecollisionwarning'] = '[*] = Aquest nom curt ja l\'utilitza un altre curs i caldrà canviar-lo quan s\'aprovi';
$string['shortnamecourse'] = 'Nom curt del curs';
$string['shortnamecourse_help'] = '<p>Moltes institucions tenen una forma abreujada de referir-se als cursos, amb un codi com ara BP102 o NTAE. Encara que no utilitzeu habitualment aquest tipus de codis, n\'heu de posar un aquí. S\'utilitzar&agrave; en diferents ocasions en què el nom complet no resulta adequat: per exemple en l\'assumpte d\'un correu electr&ograve;nic.</p>';
$string['shortnametaken'] = 'Aquest nom curt ja el fa servir un altre curs ({$a})';
$string['shortnameuser'] = 'Nom curt de l\'usuari';
$string['shortsitename'] = 'Nom curt del lloc (p. e. una paraula)';
$string['show'] = 'Mostra';
$string['showactions'] = 'Mostra accions';
$string['showadvancedsettings'] = 'Mostra paràmetres avançats';
$string['showall'] = 'Mostra tots {$a}';
$string['showallcourses'] = 'Mostra tots els cursos';
$string['showallusers'] = 'Mostra tots els usuaris';
$string['showblockcourse'] = 'Mostra llista de cursos que contenen el bloc';
$string['showcategory'] = 'Mostra {$a}';
$string['showcomments'] = 'Mostra/oculta comentaris';
$string['showcommentsnonjs'] = 'Mostra comentaris';
$string['showdescription'] = 'Mostra la descripció en la pàgina principal del curs';
$string['showdescription_help'] = 'Si s\'habilita la descripció de sobre es mostrarà en la pàgina del curs a sota de l\'enllaç a l\'activitat o el recurs.';
$string['showgrades'] = 'Mostra qualificacions a l\'estudiantat';
$string['showgrades_help'] = '<p>Moltes activitats poden ser qualificades.</p>

<p>Per defecte, els resultats de totes les qualificacions del curs es poden veure a la p&agrave;gina de Qualificacions, disponible des de la p&agrave;gina principal del curs. </p>

<p>Si el professor no vol fer serveir qualificacions en el seu curs, o vol ocultar les qualificacions als estudiants, pot inhabilitar la visualitzaci&oacute; de les qualificacions en els Par&agrave;metres del configuraci&oacute; del curs. Aix&ograve; no impedeix qualificar cada activitat, simplement inhabilita la la visualitzaci&oacute; dels resultats pels estudiants.</p>';
$string['showingacourses'] = 'S\'estan mostrant tots els cursos {$a}';
$string['showingxofycourses'] = 'S\'estan mostrant els cursos des de  {$a->start} fins {$a->end} de {$a->total} cursos';
$string['showlistofcourses'] = 'Mostra la llista de cursos';
$string['showmodulecourse'] = 'Mostra llista de cursos que contenen l\'activitat';
$string['showonly'] = 'Mostra només';
$string['showperpage'] = 'Mostra {$a} per pàgina';
$string['showrecent'] = 'Mostra l\'activitat recent';
$string['showreports'] = 'Mostra informes d\'activitat';
$string['showreports_help'] = '<p>Hi ha informes d\'activitat de cada participant que mostren la seva activitat dins del curs. Aquests informes inclouen tant una llista de les seves aportacions com uns registres d\'accés detallats.</p>

<p>Els professors sempre tenen accés a aquests informes per mitjà d\'un botó visible a la pàgina del perfil de cada usuari.</p>

<p>El professor pot controlar l\'accés de l\'estudiant als seus informes per mitjà d\'un paràmetre del curs. En alguns cursos, aquests informes poden ser una eina útil perquè l\'estudiant reflexioni sobre la seva implicació i la seva imatge en l\'entorn virtual, mentre que en altres cursos pot resultar innecessari.</p>

<p>Un altre motiu per a desactivar aquesta opció és que la generació de l\'informe pot carregar una mica el servidor. En classes grans per tant pot ser més eficient desactivar-lo.</p>';
$string['showsettings'] = 'Mostra paràmetres';
$string['showtheselogs'] = 'Mostra aquests registres';
$string['showthishelpinlanguage'] = 'Mostra aquesta ajuda en l\'idioma: {$a}';
$string['since'] = 'Des de';
$string['sincelast'] = 'des de la darrera entrada';
$string['site'] = 'Lloc';
$string['sitedefault'] = 'Valor per defecte del lloc';
$string['siteerrors'] = 'Errors del lloc';
$string['sitefiles'] = 'Fitxers del lloc';
$string['sitefilesused'] = 'Fitxers del lloc utilitzats en aquest curs';
$string['sitehome'] = 'Pàgina d\'inici';
$string['sitelegacyfiles'] = 'Fitxers del lloc';
$string['sitelogs'] = 'Registres del lloc';
$string['sitemessage'] = 'Usuaris de missatgeria.';
$string['sitenews'] = 'Notícies del lloc';
$string['sitepages'] = 'Pàgines del lloc';
$string['sitepartlist'] = 'No teniu els permisos necessaris per a veure la llista de participants';
$string['sitepartlist0'] = 'Per a veure la llista de participants del lloc cal ser membre del professorat del lloc.';
$string['sitepartlist1'] = 'Per a veure la llista de participants del lloc cal ser membre del professorat.';
$string['sites'] = 'Llocs';
$string['sitesection'] = 'Inclou una secció de tema';
$string['sitesettings'] = 'Paràmetres del lloc';
$string['siteteachers'] = 'Professors del lloc';
$string['size'] = 'Mida';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Omesos';
$string['skiptocategorylisting'] = 'Passa a les llistes de categories';
$string['skiptocoursedetails'] = 'Passa a la informació detallada del curs';
$string['skiptocourselisting'] = 'Passa a les llistes de cursos';
$string['skypeid'] = 'ID de l\'Skype';
$string['socialheadline'] = 'Fòrum social - darrers temes';
$string['someallowguest'] = 'Alguns cursos poden permetre l\'accés de visitants';
$string['someerrorswerefound'] = 'Falta informació o és incorrecta. Teniu els detalls més avall.';
$string['sort'] = 'Ordena';
$string['sortby'] = 'Ordena per';
$string['sortbyx'] = 'Ordena per {$a} ascendent';
$string['sortbyxreverse'] = 'Ordena per {$a} descendent';
$string['sortcategoriesbyidnumber'] = 'Ordena les categories per nombre ID';
$string['sortcategoriesbyname'] = 'Ordena les categories per nom';
$string['sortcoursesbyfullname'] = 'Ordena els cursos per nom complet';
$string['sortcoursesbyidnumber'] = 'Ordena els cursos per nombre id';
$string['sortcoursesbyshortname'] = 'Ordena els cursos per nom curt';
$string['sorting'] = 'S\'està ordenant';
$string['sourcerole'] = 'Rol origen';
$string['specifyname'] = 'Heu d\'especificar un nom.';
$string['standard'] = 'Estàndard';
$string['starpending'] = '([*] = curs pendent d\'aprovació)';
$string['startdate'] = 'Data d\'inici del curs';
$string['startdate_help'] = 'Aquest paràmetre determina el començament de la primera setmana per a un curs en format setmanal. També determina la data inicial dels registres d\'activitat del curs.';
$string['startingfrom'] = 'Comença';
$string['startsignup'] = 'Crea un compte d\'usuari nou';
$string['state'] = 'Comarca/Província';
$string['statistics'] = 'Estadístiques';
$string['statisticsgraph'] = 'Gràfica d\'estadístiques';
$string['stats'] = 'Estadístiques';
$string['statslogins'] = 'Entrades';
$string['statsmodedetailed'] = 'Visió d\'usuari detallada';
$string['statsmodegeneral'] = 'Visió general';
$string['statsnodata'] = 'No hi ha dades disponibles per a aquesta combinació de curs i període de temps';
$string['statsnodatauser'] = 'No hi ha dades disponibles per a aquesta combinació de curs, usuari i període de temps';
$string['statsoff'] = 'Les estadístiques no estan habilitades';
$string['statsreads'] = 'Visualitzacions';
$string['statsreport1'] = 'Entrades';
$string['statsreport10'] = 'Activitat d\'usuari';
$string['statsreport11'] = 'Cursos més actius';
$string['statsreport12'] = 'Cursos més actius (ponderats)';
$string['statsreport13'] = 'Cursos més participatius (inscripcions)';
$string['statsreport14'] = 'Cursos més participatius (visualitzacions/trameses)';
$string['statsreport2'] = 'Visualitzacions (tots els rols)';
$string['statsreport3'] = 'Trameses (tots els rols)';
$string['statsreport4'] = 'Tota l\'activitat (tots els rols)';
$string['statsreport5'] = 'Tota l\'activitat (visualitzacions i trameses)';
$string['statsreport7'] = 'Activitat d\'usuari (visualitzacions i trameses)';
$string['statsreport8'] = 'Tota l\'activitat d\'usuari';
$string['statsreport9'] = 'Entrades (curs del lloc)';
$string['statsreportactivity'] = 'Tota l\'activitat (tots els rols)';
$string['statsreportactivitybyrole'] = 'Tota l\'activitat (visualitzacions i enviaments)';
$string['statsreportforuser'] = 'referent a';
$string['statsreportlogins'] = 'Entrades';
$string['statsreportreads'] = 'Visualitzacions (tots els rols)';
$string['statsreporttype'] = 'Tipus d\'informe';
$string['statsreportwrites'] = 'Trameses (tots els rols)';
$string['statsstudentactivity'] = 'Activitat de l\'estudiantat';
$string['statsstudentreads'] = 'Visualitzacions de l\'estudiantat';
$string['statsstudentwrites'] = 'Trameses de l\'estudiantat';
$string['statsteacheractivity'] = 'Activitat del professorat';
$string['statsteacherreads'] = 'Visualitzacions del professorat';
$string['statsteacherwrites'] = 'Trameses del professorat';
$string['statstimeperiod'] = 'Període - fi:';
$string['statsuniquelogins'] = 'Entrades úniques';
$string['statsuseractivity'] = 'Tota l\'activitat';
$string['statsuserlogins'] = 'Entrades';
$string['statsuserreads'] = 'Visualitzacions';
$string['statsuserwrites'] = 'Trameses';
$string['statswrites'] = 'Enviaments';
$string['status'] = 'Estat';
$string['stringsnotset'] = 'Les cadenes següents no estan definides en {$a}';
$string['studentnotallowed'] = 'No podeu entrar en aquest curs com a \'{$a}\'';
$string['students'] = 'Estudiants';
$string['studentsandteachers'] = 'Estudiants i professors';
$string['subcategories'] = 'Subcategories';
$string['subcategory'] = 'Subcategoria';
$string['subcategoryof'] = 'Subcategoria de {$a}';
$string['submit'] = 'Tramet';
$string['success'] = 'Èxit';
$string['summary'] = 'Resum';
$string['summary_help'] = '<p>La idea d\'un resum del tema &eacute;s un text molt breu per preparar als estudiants per a les activitats d\'aquest tema (o setmana).</p>

<p>El resum hauria de ser molt breu de manera que la p&agrave;gina principal del curs no es faci massa llarga.</p>

<p>Si trobeu que no teniu prou amb una frase o dues, considereu l\'alternativa d\'afegir un recurs al tema (per exemple: la primera activitat podria ser una p&agrave;gina titulada <b>Sobre aquest tema</b>).</p>';
$string['summaryof'] = 'Resum de {$a}';
$string['supplyinfo'] = 'Més detalls';
$string['suspended'] = 'Suspès';
$string['suspendedusers'] = 'Usuaris suspesos';
$string['switchdevicedefault'] = 'Canvia al tema estàndard.';
$string['switchdevicerecommended'] = 'Canvia al tema recomanat per al teu dispositiu.';
$string['switchrolereturn'] = 'Torna al meu rol normal';
$string['switchroleto'] = 'Canvia rol a...';
$string['tag'] = 'Etiqueta';
$string['tagalready'] = 'Aquesta etiqueta ja existeix';
$string['tagmanagement'] = 'Afegeix/suprimeix d\'etiquetes...';
$string['tags'] = 'Etiquetes';
$string['targetrole'] = 'Rol destinació';
$string['teacheronly'] = 'només per a {$a}';
$string['teacherroles'] = '{$a} rols';
$string['teachers'] = 'Professors';
$string['textediting'] = 'Editor de text';
$string['texteditor'] = 'Utilitza formularis web normals';
$string['textformat'] = 'Només text';
$string['thanks'] = 'Gràcies';
$string['theme'] = 'Tema';
$string['themes'] = 'Temes';
$string['themesaved'] = 'S\'ha desat el nou tema';
$string['therearecourses'] = 'Hi ha {$a} cursos';
$string['thereareno'] = 'No hi ha cap {$a} en aquest curs';
$string['thiscategory'] = 'Aquesta categoria';
$string['thiscategorycontains'] = 'Aquesta categoria conté';
$string['time'] = 'Hora';
$string['timezone'] = 'Zona horària';
$string['to'] = 'A';
$string['tocontent'] = 'a l\'element "{$a}"';
$string['tocreatenewaccount'] = 'Salta-t\'ho per crear un nou compte';
$string['today'] = 'Avui';
$string['todaylogs'] = 'Registres d\'avui';
$string['toeveryone'] = 'per a tothom';
$string['toomanybounces'] = 'Aquesta adreça de correu ha produït massa rebots. L\'heu de canviar obligatòriament abans de continuar.';
$string['toomanytoshow'] = 'Hi ha massa usuaris per mostrar-los tots';
$string['toomanyusersmatchsearch'] = 'Hi ha massa usuaris ({$a->count}) que coincideixen amb la cerca \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Massa usuaris ({$a}) per mostrar';
$string['toonly'] = 'només per a {$a}';
$string['top'] = 'Capdamunt';
$string['topic'] = 'Tema';
$string['topichide'] = 'Oculta aquest tema a {$a}';
$string['topicoutline'] = 'Esquema per temes';
$string['topicshow'] = 'Mostra aquest tema a {$a}';
$string['toplevelcategory'] = 'Categoria del nivell superior';
$string['total'] = 'Total';
$string['totopofsection'] = 'A l\'inici de la secció «{$a}»';
$string['trackforums'] = 'Seguiment dels fòrums';
$string['trackforumsno'] = 'No: no facis el seguiment dels missatges que he vist';
$string['trackforumsyes'] = 'Sí: destaca\'m els missatges nous';
$string['trysearching'] = 'Podeu provar a cercar.';
$string['turneditingoff'] = 'Desactiva edició';
$string['turneditingon'] = 'Activa edició';
$string['undecided'] = 'No decidit';
$string['unfinished'] = 'Inacabat';
$string['unknowncategory'] = 'Categoria desconeguda';
$string['unknownerror'] = 'Error desconegut';
$string['unlimited'] = 'Il·limitat';
$string['unpacking'] = 'S\'està desempaquetant {$a}';
$string['unsafepassword'] = 'Aquesta contrasenya no és segura, proveu-ne una altra';
$string['untilcomplete'] = 'Fins que es completi';
$string['unusedaccounts'] = 'Als comptes no utilitzats més de {$a} dies se\'ls cancel·la automàticament la inscripció al curs.';
$string['unzip'] = 'Unzip';
$string['unzippingbackup'] = 'S\'està descomprimint la còpia de seguretat';
$string['up'] = 'Amunt';
$string['update'] = 'Actualitza';
$string['updated'] = 'S\'ha actualitzat {$a}';
$string['updatemymoodleoff'] = 'Atura l\'edició d\'aquesta pàgina';
$string['updatemymoodleon'] = 'Personalitza aquesta pàgina';
$string['updatemyprofile'] = 'Actualitza perfil';
$string['updatesevery'] = 'S\'actualitza cada {$a} segons';
$string['updatethis'] = 'Actualitza {$a}';
$string['updatethiscourse'] = 'Actualitza aquest curs';
$string['updatinga'] = 'S\'està actualitzant: {$a}';
$string['updatingain'] = 'S\'està actualitzant {$a->what} en {$a->in}';
$string['upload'] = 'Penja';
$string['uploadafile'] = 'Penja un fitxer';
$string['uploadcantwrite'] = 'S\'ha produït un error en escriure al disc';
$string['uploadedfile'] = 'El fitxer s\'ha penjat amb èxit';
$string['uploadedfileto'] = 'S\'ha penjat {$a->file} en {$a->directory}';
$string['uploadedfiletoobig'] = 'El fitxer és massa gran (el límit són {$a} bytes)';
$string['uploadextension'] = 'La càrrega del fitxer ha estat aturada per una extensió del PHP';
$string['uploadfailednotrecovering'] = 'La càrrega ha fallat perquè hi ha hagut un problema amb un dels fitxers, {$a->name}. <br />Heus aquí un registre dels problemes:<br />{$a->problem}<br />Irrecuperable.';
$string['uploadfilelog'] = 'Registre de càrrega del fitxer {$a}';
$string['uploadformlimit'] = 'El fitxer {$a} supera la mida màxima definida pel formulari';
$string['uploadlabel'] = 'Títol:';
$string['uploadlimitwithsize'] = 'Límit de càrrega del {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Carrega un fitxer';
$string['uploadnofilefound'] = 'No s\'ha trobat cap fitxer. Segur que n\'havíeu seleccionat un?';
$string['uploadnotallowed'] = 'No es permet penjar fitxers';
$string['uploadnotempdir'] = 'Falta una carpeta temporal';
$string['uploadoldfilesdeleted'] = 'S\'ha/n suprimit ell/s fitxer/s vell/s de l\'àrea de càrrega';
$string['uploadpartialfile'] = 'Només s\'ha penjat una part del fitxer';
$string['uploadproblem'] = 'S\'ha esdevingut un problema desconegut mentre es penjava el fitxer \'{$a}\' (potser era massa gran?)';
$string['uploadrenamedchars'] = 'S\'ha canviat el nom del fitxer {$a->oldname} a {$a->newname} perquè contenia caràcters no vàlids.';
$string['uploadrenamedcollision'] = 'S\'ha canviat el nom del fitxer {$a->oldname} a {$a->newname} per un conflicte amb el nom del fitxer.';
$string['uploadserverlimit'] = 'El fitxer supera la mida màxima definida al servidor';
$string['uploadthisfile'] = 'Penja aquest fitxer';
$string['url'] = 'URL';
$string['used'] = 'Utilitzat';
$string['usedinnplaces'] = 'Utilitzat en {$a} llocs';
$string['usemessageform'] = 'o feu servir el formulari més avall per enviar un missatge als estudiants seleccionats';
$string['user'] = 'Usuari';
$string['userconfirmed'] = '{$a} confirmat';
$string['usercurrentsettings'] = 'Configuració del meu perfil';
$string['userdata'] = 'Dades d\'usuari';
$string['userdeleted'] = 'S\'ha suprimit aquest compte d\'usuari';
$string['userdescription'] = 'Descripció';
$string['userdescription_help'] = 'Podeu escriure text que us descrigui en aquest quadre. Serà el que llegiran els altres usuaris si consulten el vostre perfil. ';
$string['userdetails'] = 'Més detall';
$string['userfiles'] = 'Fitxers d\'usuari';
$string['userlist'] = 'Llista d\'usuaris';
$string['username'] = 'Nom d\'usuari';
$string['usernameemailmatch'] = 'El nom d\'usuari i l\'adreça de correu no corresponen al mateix usuari';
$string['usernameexists'] = 'Aquest nom d\'usuari ja existeix, trieu-ne un altre';
$string['usernamelowercase'] = 'Només lletres minúscules';
$string['usernamenotfound'] = 'No s\'ha trobat el nom d\'usuari en la base de dades';
$string['usernameoremail'] = 'Introduïu el nom d\'usuari o l\'adreça de correu';
$string['usernotconfirmed'] = 'No s\'ha pogut confirmar {$a}';
$string['userpic'] = 'Imatge de l\'usuari';
$string['users'] = 'Usuaris';
$string['userselectorautoselectunique'] = 'Si només un usuari coincideix amb la cerca, marca\'l automàticament';
$string['userselectorpreserveselected'] = 'Mantén els usuaris seleccionats, encara que ja no concordin amb la cerca.';
$string['userselectorsearchanywhere'] = 'Prova si concorda el text de cerca arreu dels camps mostrats.';
$string['usersnew'] = 'Nous usuaris';
$string['usersnoaccesssince'] = 'Usuaris inactius més de';
$string['userswithfiles'] = 'Usuaris amb fitxers';
$string['useruploadtype'] = 'L\'usuari carrega el tipus: {$a}';
$string['userviewingsettings'] = 'Configuració del perfil per {$a}';
$string['userzones'] = 'Zones d\'usuari';
$string['usetheme'] = 'Utilitza el tema';
$string['usingexistingcourse'] = 'S\'està utilitzant un curs existent';
$string['valuealreadyused'] = 'Aquest valor ja s\'ha utilitzat.';
$string['version'] = 'Versió';
$string['view'] = 'Visualització';
$string['viewallcourses'] = 'Mostra tots els cursos';
$string['viewallcoursescategories'] = 'Mostra tots els cursos i les categories';
$string['viewallsubcategories'] = 'Mostra totes les subcategories';
$string['viewfileinpopup'] = 'Mostra el fitxer en una finestra emergent';
$string['viewing'] = 'S\'està mostrant:';
$string['viewmore'] = 'Mostra\'n més';
$string['viewprofile'] = 'Mostra el perfil';
$string['views'] = 'Visualitzacions';
$string['viewsolution'] = 'Mostra la solució';
$string['virusfound'] = 'Alerta administrador: Clam AV ha trobat un virus en un fitxer penjat per {$a->user} en el curs {$a->course}. Heus aquí la sortida de Clamscan:';
$string['virusfoundlater'] = 'S\'ha trobat un virus en un fitxer anomenat {$a->filename} que heu penjat el {$a->date} en el curs {$a->course}. Heus aquí un resum dels esdeveniments:

{$a->action}

Si això era una tasca que havíeu tramès, us caldrà tornar a enviar-la per tal que la vegi el vostre professor.';
$string['virusfoundlateradmin'] = 'Alerta administrador: s\'ha trobat un virus en un fitxer anomenat {$a->filename} que heu penjat el {$a->date} en el curs {$a->course}. Heus aquí un resum dels esdeveniments:

{$a->action}

S\'ha enviat una notificació a l\'usuari.';
$string['virusfoundlateradminnolog'] = 'Alerta administrador: s\'ha trobat un virus en un fitxer anomenat {$a->filename}. Moodle ha estat incapaç d\'esbrinar quin usuari el va penjar.

Heus aquí un resum dels esdeveniments:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: s\'ha trobat un virus';
$string['virusfounduser'] = 'El fitxer que heu penjat, {$a->filename}, ha estat escanejat i sembla que conté un virus. El fitxer NO s\'ha penjat.';
$string['virusplaceholder'] = 'Aquest fitxer contenia un virus i ha estat mogut o suprimit. S\'ha enviat una notificació a l\'usuari.';
$string['visible'] = 'Visible';
$string['visible_help'] = 'Aquest paràmetre determina si el curs apareix a la llista de cursos. Si no hi apareix, només els professors del curs i els administradors poden entrar al curs.';
$string['visibletostudents'] = 'Visible per a {$a}';
$string['warning'] = 'Advertència';
$string['warningdeleteresource'] = 'Avís: hi ha una referència a {$a} en un recurs. Voleu actualitzar aquest recurs?';
$string['webpage'] = 'Pàgina web';
$string['week'] = 'Setmana';
$string['weekhide'] = 'Oculta aquesta setmana a {$a}';
$string['weeklyoutline'] = 'Esquema per setmanes';
$string['weeks'] = 'setmanes';
$string['weekshow'] = 'Mostra aquesta setmana a {$a}';
$string['welcometocourse'] = 'Benvingut/da a {$a}';
$string['welcometocoursetext'] = 'Benvingut/da a {$a->coursename}.

Una de les primeres coses que hauríeu de fer és editar el vostre perfil de manera que tothom us pugui conèixer una mica més:

{$a->profileurl}';
$string['whatforlink'] = 'Què voleu fer amb l\'enllaç?';
$string['whatforpage'] = 'Què voleu fer amb el text?';
$string['whattocallzip'] = 'Quin nom voleu donar al fitxer zip?';
$string['whattodo'] = 'Què cal fer';
$string['windowclosing'] = 'Aquesta finestra s\'hauria d\'haver tancat automàticament. Si no ho ha fet, tanqueu-la, siu us plau.';
$string['withchosenfiles'] = 'Els fitxers seleccionats';
$string['withdisablednote'] = '{$a} (inhabilitat)';
$string['withoutuserdata'] = 'sense dades d\'usuari';
$string['withselectedusers'] = 'Amb els usuaris seleccionats...';
$string['withselectedusers_help'] = '* Envia un missatge - Per enviar un missatge a un o més participants.
* Afegeix un nota nova - Per afegir una nota a un participant seleccionat
* Afegeix una nota comuna - Per afegir la mateixa nota a més d\'un participant';
$string['withuserdata'] = 'amb dades d\'usuari';
$string['wordforstudent'] = 'La vostra paraula per a \'Estudiant\'';
$string['wordforstudenteg'] = 'p. ex. Estudiant, Participant, etc.';
$string['wordforstudents'] = 'La vostra paraula per a \'Estudiants\'';
$string['wordforstudentseg'] = 'p. ex. Estudiants, Participants, etc.';
$string['wordforteacher'] = 'La vostra paraula per a \'Professor\'';
$string['wordforteachereg'] = 'p. ex. Professor, Tutor, Facilitador, etc.';
$string['wordforteachers'] = 'La vostra paraula per a \'Professors\'';
$string['wordforteacherseg'] = 'p. ex. Professors, Tutors, Facilitadors, etc.';
$string['writingblogsinfo'] = 'S\'està escrivint la informació dels blogs';
$string['writingcategoriesandquestions'] = 'S\'estan escrivint les categories i preguntes';
$string['writingcoursedata'] = 'S\'estan escrivint les dades del curs';
$string['writingeventsinfo'] = 'S\'està escrivint la informació dels esdeveniments';
$string['writinggeneralinfo'] = 'S\'està escrivint la informació general';
$string['writinggradebookinfo'] = 'S\'està escrivint la informació de qualificacions';
$string['writinggroupingsgroupsinfo'] = 'S\'està escrivint la informació de grups i agrupaments';
$string['writinggroupingsinfo'] = 'S\'està escrivint la informació d\'agrupaments';
$string['writinggroupsinfo'] = 'S\'està escrivint la informació de grups';
$string['writingheader'] = 'S\'està escrivint la capçalera';
$string['writingloginfo'] = 'S\'està escrivint la informació dels registres';
$string['writingmessagesinfo'] = 'S\'està escrivint la informació dels missatges';
$string['writingmoduleinfo'] = 'S\'està escrivint la informació dels mòduls';
$string['writingscalesinfo'] = 'S\'està escrivint la informació de les escales';
$string['writinguserinfo'] = 'S\'està escrivint informació dels usuaris i usuàries';
$string['wrongpassword'] = 'Contrasenya incorrecta per a aquest nom d\'usuari';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'any';
$string['years'] = 'anys';
$string['yes'] = 'Sí';
$string['youareabouttocreatezip'] = 'Es crearà un fitxer zip que conté';
$string['youaregoingtorestorefrom'] = 'S\'engegarà el procés de restauració de';
$string['youneedtoenrol'] = 'Per a realitzar aquesta acció us heu d\'inscriure al curs';
$string['yourlastlogin'] = 'La vostra darrera entrada va ser';
$string['yourself'] = 'vós mateix';
$string['yourteacher'] = 'el vostre {$a}';
$string['yourwordforx'] = 'El vostre nom per \'{$a}\'';
$string['zippingbackup'] = 'S\'està comprimint la còpia de seguretat';
