<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'geogebra', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   geogebra
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityclosed'] = 'Aquesta activitat està tancada';
$string['activitynotopened'] = 'Aquesta activitat encara no està disponible';
$string['attempt'] = 'Intent';
$string['attempts'] = 'Intents';
$string['attemptsremaining'] = 'Intents restants per a aquesta activitat:';
$string['autograde'] = 'Activitat autopuntuable';
$string['availabledate'] = 'Disponible des de';
$string['average'] = 'Mitjana';
$string['choosescripttype'] = 'Escull el tipus de <i>script</i>';
$string['comment'] = 'Comentari';
$string['coursewithoutstudents'] = 'Curs sense estudiants';
$string['datestudent'] = 'Darrera modificació (tramesa)';
$string['dateteacher'] = 'Darrera modificació (qualificació)';
$string['deleteallattempts'] = 'Suprimeix tots els intents';
$string['description'] = 'Descripció';
$string['discardchanges'] = 'Torna sense desar';
$string['duedate'] = 'Fins a';
$string['duration'] = 'Durada';
$string['enableLabelDrags'] = 'Permet arrossegar les etiquetes';
$string['enableRightClick'] = 'Habilita el botó dret';
$string['errorattempt'] = 'S\'ha produït un error. No s\'ha pogut desar l\'intent.';
$string['expired'] = 'Aquesta activitat es va tancar el {$a} i, per tant, ja no està disponible';
$string['extractedfromggb'] = 'fitxers extrets de ggb';
$string['filename'] = 'Nom del fitxer';
$string['filenotfound'] = 'El fitxer indicat no existeix';
$string['filetype'] = 'Tipus';
$string['filetypeexternal'] = 'URL extern';
$string['filetype_help'] = 'Aquest paràmetre determina com s\'incorporarà l\'activitat GeoGebra al curs. Hi ha dues opcions:

* Fitxer pujat - Permet escollir un fitxer .GGB vàlid mitjançant el selector d\'arxius.
* URL extern - Permet especificar l\'URL d\'una activitat GeoGebra. Nota: L\'URL ha de començar amb http(s) o www i contenir un fitxer .GGB vàlid.';
$string['filetypelocal'] = 'Fitxer pujat';
$string['firstattempt'] = 'Primer intent';
$string['for'] = 'per';
$string['functionalityoptionsgrp'] = 'Funcionalitats';
$string['geogebra:addinstance'] = 'Afegeix una activitat GeoGebra';
$string['geogebrafile'] = 'Fitxer GeoGebra';
$string['geogebrafile_help'] = 'El fitxer .GGB que conté l\'activitat GeoGebra.';
$string['geogebra:grade'] = 'Avalua GeoGebra';
$string['geogebra:submit'] = 'Envia GeoGebra';
$string['geogebraurl'] = 'URL';
$string['geogebraurl_help'] = 'Aquest paràmetre permet especificar l\'URL de l\'activitat GeoGebra en lloc de seleccionar-la mitjançant el selector de fitxers.';
$string['geogebra:view'] = 'Visualitza GeoGebra';
$string['grade'] = 'Qualificació';
$string['gradeit'] = 'Qualificació';
$string['grademethod'] = 'Mètode de qualificació';
$string['header_geogebra'] = 'Paràmetres del GeoGebra';
$string['header_score'] = 'Paràmetres d\'avaluació del GeoGebra';
$string['height'] = 'Alçada';
$string['highestattempt'] = 'Millor intent';
$string['httpnotallowed'] = 'De moment no és possible utilitzar fitxers externs';
$string['interfaceoptionsgrp'] = 'Interfície d\'usuari';
$string['invalidgeogebrafile'] = 'S\'ha especificat un fitxer GeoGebra no vàlid. El fitxer ha de tenir l\'extensió .GGB.';
$string['invalidurl'] = 'S\'ha especificat un URL no vàlid. L\'URL ha de començar amb http(s) i ha d\'enllaçar a un fitxer .GGB vàlid.';
$string['javacodebase'] = 'Base de codi de GeoGebra';
$string['javacodebase_help'] = 'URL dels fitxers .JAR de GeoGebra';
$string['language'] = 'Idioma';
$string['lastattempt'] = 'Darrer intent';
$string['lastattemptremaining'] = 'Aquest és el teu darrer intent en aquesta activitat';
$string['lastmodifiedgrade'] = 'Darrera modificació (qualificació)';
$string['lastmodifiedsubmission'] = 'Darrera modificació (tramesa)';
$string['lowestattempt'] = 'Pitjor intent';
$string['manualgrade'] = 'Qualificació manual?';
$string['maxattempts'] = 'Nombre màxim d\'intents';
$string['modulename'] = 'GeoGebra';
$string['modulename_help'] = '<p><a href="http://www.geogebra.org" target="_blank">GeoGebra</a> és una aplicació de matemàtica dinàmica, gratuïta, lliure i multiplataforma, enfocada a tots els nivells educatius, que aglutina la geometria, l\'àlgebra, el full de càlcul, l\'estadística i l\'anàlisi, en un únic paquet integrat, molt fàcil d\'utilitzar.</p>
<p>Per aquest motiu, el <a href="http://www.gencat.cat/ensenyament/" target="_blank">Departament d\'Ensenyament de Catalunya</a>, en col·laboració amb l\'<a href="http://acgeogebra.cat/" target="_blank">Associació Catalana de GeoGebra</a> (ACG) i l\'equip de desenvolupament de GeoGebra han implementat aquest mòdul que permet la incorporació d\'aquest tipus d\'activitats a Moodle. Les seves característiques principals són:
<ul>
<li>Permet incrustar activitats GeoGebra a qualsevol curs de forma molt senzilla.</li>
<li>Facilita el seguiment ja que guarda la puntuació, data, durada i construccions de cadascun dels intents que realitza l\'alumnat.</li>
<li>L\'alumnat pot desar l\'estat de les activitats realitzades per continuar-les en un altre moment.</li>
</ul>
</p>';
$string['modulenameplural'] = 'GeoGebra';
$string['msg_noattempts'] = 'Ja heu fet aquesta activitat el nombre màxim de vegades permès';
$string['name'] = 'Nom';
$string['noattempts'] = '-';
$string['nograding'] = 'Sense qualificar';
$string['nomoreattempts'] = 'Ja heu realitzat tots els intents possibles per a aquesta activitat';
$string['notopenyet'] = 'Ho sentim, aquesta activitat no estarà disponible fins {$a}';
$string['pluginadministration'] = 'Administració de GeoGebra';
$string['pluginname'] = 'GeoGebra';
$string['previewtab'] = 'Previsualitza';
$string['redirecttocourse'] = 'L\'activitat s\'ha desat correctament. S\'està tornant a la pàgina d\'inici';
$string['report'] = 'Informe de';
$string['resultstab'] = 'Resultats';
$string['resumeattempt'] = 'Continuació d\'un intent anterior';
$string['review'] = 'Revisió de';
$string['reviewtab'] = 'Revisió';
$string['save'] = 'Desa';
$string['savechanges'] = 'Desa els canvis';
$string['savewithoutsubmitting'] = 'Desa sense entregar';
$string['settings'] = 'Paràmetres';
$string['showAlgebraInput'] = 'Mostra la barra d\'introducció';
$string['showMenuBar'] = 'Mostra la barra de menú';
$string['showResetIcon'] = 'Mostra la icona de reiniciar la construcció';
$string['showsubmit'] = 'Mostra el botó d\'entrega';
$string['showToolBar'] = 'Mostra la barra d\'eines';
$string['showToolBarHelp'] = 'Mostra l\'ajuda de la barra d\'eines';
$string['status'] = 'Estat';
$string['submitandfinish'] = 'Entrega i acaba';
$string['total'] = 'Total';
$string['unfinished'] = 'No finalitzat';
$string['ungraded'] = 'Sense qualificar';
$string['unlimitedattempts'] = 'Aquesta activitat no té límit d\'intents';
$string['urledit'] = 'Fitxer GeoGebra';
$string['urledit_help'] = 'El fitxer ".GGB" que conté l\'activitat GeoGebra.';
$string['view'] = 'Visualitza';
$string['viewattempt'] = 'Visualitza';
$string['viewattempts'] = 'Visualitza els intents';
$string['viewattempttab'] = 'Visualitza l\'intent';
$string['viewtab'] = 'Mostra';
$string['warningnojava'] = 'Aquest Applet de Java s\'ha creat utilitzant GeoGebra (www.geogebra.org) - possiblement no tingueu el Java correctament instal·lat, comproveu-ho a www.java.com';
$string['weight'] = 'Pes';
$string['width'] = 'Amplada';
