<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'ca', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adreça';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Insereix/edita àncora';
$string['advanced:backcolor_desc'] = 'Selecciona el color de fons';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Cita';
$string['advanced:blockquote_desc'] = 'Descripció de la cita';
$string['advanced:bold_desc'] = 'Negreta (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Insereix/suprimeix llista de pics';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Insereix caràcter personalitzat';
$string['advanced:cleanup_desc'] = 'Neteja el codi no correcte';
$string['advanced:clipboard_msg'] = 'Copia/Retalla/Enganxa no està disponible en Mozilla/Firefox.
Vols més informació sobre aquest tema?';
$string['advanced:code'] = 'Codi';
$string['advanced:code_desc'] = 'Edita la font HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Copia';
$string['advanced:custom1_desc'] = 'Aquí la teva descripció personalitzada';
$string['advanced:cut_desc'] = 'Retalla';
$string['advanced:dd'] = 'Descripció de la definició';
$string['advanced:div'] = 'Div';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'Quant a';
$string['advanced_dlg:about_help'] = 'Ajuda';
$string['advanced_dlg:about_license'] = 'Llicència';
$string['advanced_dlg:about_loaded'] = 'Extensions carregades';
$string['advanced_dlg:about_plugin'] = 'Extensió';
$string['advanced_dlg:about_plugins'] = 'Extensions';
$string['advanced_dlg:about_title'] = 'Quant a TinyMCE';
$string['advanced_dlg:about_version'] = 'Versió';
$string['advanced_dlg:accessibility_help'] = 'Ajuda d\'accessibilitat';
$string['advanced_dlg:accessibility_usage_title'] = 'Utilització general';
$string['advanced_dlg:anchor_invalid'] = 'Especifiqueu un nom d\'àncora vàlid.';
$string['advanced_dlg:anchor_name'] = 'Nom de l\'àncora';
$string['advanced_dlg:anchor_title'] = 'Insereix/edita àncora';
$string['advanced_dlg:charmap_title'] = 'Selecciona el caràcter personalitzat';
$string['advanced_dlg:charmap_usage'] = 'Utilitzeu les fletxes esquerra i dreta per a navegar.';
$string['advanced_dlg:code_title'] = 'Editor de Font HTML';
$string['advanced_dlg:code_wordwrap'] = 'Salt de paraula';
$string['advanced_dlg:colorpicker_color'] = 'Color:';
$string['advanced_dlg:colorpicker_name'] = 'Nom:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Amb nom';
$string['advanced_dlg:colorpicker_named_title'] = 'Colors amb nom';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Colors de la paleta';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Selector';
$string['advanced_dlg:colorpicker_picker_title'] = 'Selector de color';
$string['advanced_dlg:colorpicker_title'] = 'Selecciona un color';
$string['advanced_dlg:image_align'] = 'Alineació';
$string['advanced_dlg:image_align_baseline'] = 'Línia base';
$string['advanced_dlg:image_align_bottom'] = 'Baix';
$string['advanced_dlg:image_align_left'] = 'Esquerra';
$string['advanced_dlg:image_align_middle'] = 'Mig';
$string['advanced_dlg:image_align_right'] = 'Dreta';
$string['advanced_dlg:image_align_textbottom'] = 'A baix del text';
$string['advanced_dlg:image_align_texttop'] = 'A dalt del text';
$string['advanced_dlg:image_align_top'] = 'Dalt';
$string['advanced_dlg:image_alt'] = 'Descripció de la imatge';
$string['advanced_dlg:image_border'] = 'Vora';
$string['advanced_dlg:image_dimensions'] = 'Dimensions';
$string['advanced_dlg:image_hspace'] = 'Espaiat horitzontal';
$string['advanced_dlg:image_list'] = 'Llista d\'imatges';
$string['advanced_dlg:image_src'] = 'URL de la imatge';
$string['advanced_dlg:image_title'] = 'Insereix/edita imatge';
$string['advanced_dlg:image_vspace'] = 'Espaiat vertical';
$string['advanced_dlg:invalid_color_value'] = 'El valor de color no és vàlid';
$string['advanced_dlg:link_is_email'] = 'L\'URL que has introduït sembla una adreça de correu, vols afegir-hi el prefix mailto://?';
$string['advanced_dlg:link_is_external'] = 'L\'URL que has introduït sembla un enllaç extern, vols afegir-hi el prefix http://?';
$string['advanced_dlg:link_list'] = 'Llista d\'enllaços';
$string['advanced_dlg:link_target'] = 'Objectiu';
$string['advanced_dlg:link_target_blank'] = 'Obre l\'enllaç en una finestra nova';
$string['advanced_dlg:link_target_same'] = 'Obre l\'enllaç a la mateixa finestra';
$string['advanced_dlg:link_title'] = 'Insereix/edita enllaç';
$string['advanced_dlg:link_titlefield'] = 'Títol';
$string['advanced_dlg:link_url'] = 'URL de l\'enllaç';
$string['advanced:dt'] = 'Terme de la definició';
$string['advanced:fontdefault'] = 'Tipografia';
$string['advanced:font_size'] = 'Mida de lletra';
$string['advanced:forecolor_desc'] = 'Selecciona el color del text';
$string['advanced:h1'] = 'Capçalera 1';
$string['advanced:h2'] = 'Capçalera 2';
$string['advanced:h3'] = 'Capçalera 3';
$string['advanced:h4'] = 'Capçalera 4';
$string['advanced:h5'] = 'Capçalera 5';
$string['advanced:h6'] = 'Capçalera 6';
$string['advanced:help_desc'] = 'Ajuda';
$string['advanced:help_shortcut'] = 'Premeu ALT-F10 per a la barra d\'eines. Premeu ALT-0 per a l\'ajuda.';
$string['advanced:hr_desc'] = 'Insereix regle horitzontal';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Insereix/edita imatge';
$string['advanced:image_props_desc'] = 'Propietats de la imatge';
$string['advanced:indent_desc'] = 'Augmenta el sagnat';
$string['advanced:italic_desc'] = 'Cursiva (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centra';
$string['advanced:justifyfull_desc'] = 'Justifica';
$string['advanced:justifyleft_desc'] = 'Alinea a l\'esquerra';
$string['advanced:justifyright_desc'] = 'Alinea a la dreta';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Insereix/edita enllaç';
$string['advanced:more_colors'] = 'Més colors';
$string['advanced:newdocument'] = 'Segur que vols esborrar tot el contingut?';
$string['advanced:newdocument_desc'] = 'Nou document';
$string['advanced:numlist_desc'] = 'Llista ordenada';
$string['advanced:outdent_desc'] = 'Redueix el sagnat';
$string['advanced:paragraph'] = 'Paràgraf';
$string['advanced:paste_desc'] = 'Enganxa';
$string['advanced:path'] = 'Camí';
$string['advanced:pre'] = 'Preformatat';
$string['advanced:redo_desc'] = 'Refés (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Elimina el format';
$string['advanced:rich_text_area'] = 'Àrea de text enriquit';
$string['advanced:samp'] = 'Mostra de codi';
$string['advanced:shortcuts_desc'] = 'Ajuda d\'accessibilitat';
$string['advanced:striketrough_desc'] = 'Tatxat';
$string['advanced:style_select'] = 'Estils';
$string['advanced:sub_desc'] = 'Subíndex';
$string['advanced:sup_desc'] = 'Superíndex';
$string['advanced:toolbar'] = 'Barra d\'eines';
$string['advanced:toolbar_focus'] = 'Salta als botons d\'eines - Alt+Q, Salta a l\'editor - Alt-Z, Salta al camí de l\'element - Alt-X';
$string['advanced:underline_desc'] = 'Subratllat (Ctrl+U)';
$string['advanced:undo_desc'] = 'Desfés (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Desenllaça';
$string['advanced:visualaid_desc'] = 'Mostra/amaga guies/elements invisibles';
$string['advhr:advhr_desc'] = 'Regle horitzontal';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Sense ombra';
$string['advhr_dlg:size'] = 'Alçada';
$string['advhr_dlg:width'] = 'Amplada';
$string['advhr_dlg:widthunits'] = 'Unitats';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'Alineació';
$string['advimage_dlg:align_baseline'] = 'Línia base';
$string['advimage_dlg:align_bottom'] = 'Baix';
$string['advimage_dlg:align_left'] = 'Esquerra';
$string['advimage_dlg:align_middle'] = 'Mig';
$string['advimage_dlg:align_right'] = 'Dreta';
$string['advimage_dlg:align_textbottom'] = 'A baix del text';
$string['advimage_dlg:align_texttop'] = 'A dalt del text';
$string['advimage_dlg:align_top'] = 'Dalt';
$string['advimage_dlg:alt'] = 'Descripció de la imatge';
$string['advimage_dlg:alt_image'] = 'Imatge alternativa';
$string['advimage_dlg:border'] = 'Vora';
$string['advimage_dlg:classes'] = 'Classes';
$string['advimage_dlg:constrain_proportions'] = 'Constreny les proporcions';
$string['advimage_dlg:dialog_title'] = 'Insereix/edita imatge';
$string['advimage_dlg:dimensions'] = 'Dimensions';
$string['advimage_dlg:example_img'] = 'Aparença imatge previsualitzada';
$string['advimage_dlg:general'] = 'General';
$string['advimage_dlg:height'] = 'Alçada';
$string['advimage_dlg:hspace'] = 'Espaiat horitzontal';
$string['advimage_dlg:id'] = 'Id';
$string['advimage_dlg:image_list'] = 'Llista d\'imatges';
$string['advimage_dlg:langcode'] = 'Codi de l\'idioma';
$string['advimage_dlg:langdir'] = 'Direcció de l\'idioma';
$string['advimage_dlg:list'] = 'Llista d\'imatges';
$string['advimage_dlg:long_desc'] = 'Descripció llarga';
$string['advimage_dlg:ltr'] = 'D\'esquerra a dreta';
$string['advimage_dlg:map'] = 'Mapa d\'imatge';
$string['advimage_dlg:misc'] = 'Miscel·lània';
$string['advimage_dlg:missing_alt'] = 'Segur que vols continuar sense incloure cap Descripció d\'Imatge? Sense ella, la imatge no serà accessible a usuaris amb discapacitats, o a aquells que utilitzin un navegador de text, o els que naveguin amb les imatges desactivades.';
$string['advimage_dlg:mouseout'] = 'amb el ratolí fora';
$string['advimage_dlg:mouseover'] = 'amb el ratolí a sobre';
$string['advimage_dlg:preview'] = 'Vista prèvia';
$string['advimage_dlg:rtl'] = 'De dreta a esquerra';
$string['advimage_dlg:src'] = 'URL de la imatge';
$string['advimage_dlg:style'] = 'Estil';
$string['advimage_dlg:swap_image'] = 'Canvi d\'imatge';
$string['advimage_dlg:tab_advanced'] = 'Avançat';
$string['advimage_dlg:tab_appearance'] = 'Aparença';
$string['advimage_dlg:tab_general'] = 'General';
$string['advimage_dlg:title'] = 'Títol';
$string['advimage_dlg:vspace'] = 'Espaiat vertical';
$string['advimage_dlg:width'] = 'Amplada';
$string['advimage:image_desc'] = 'Insereix/edita imatge';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Contrasenya';
$string['advlink_dlg:advanced_props'] = 'Propietats avançades';
$string['advlink_dlg:advanced_tab'] = 'Avançat';
$string['advlink_dlg:anchor_names'] = 'Àncores';
$string['advlink_dlg:classes'] = 'Classes';
$string['advlink_dlg:encoding'] = 'Codificació de caràcters de l\'objectiu';
$string['advlink_dlg:event_props'] = 'Esdeveniments';
$string['advlink_dlg:events_tab'] = 'Esdeveniments';
$string['advlink_dlg:general_props'] = 'Propietats generals';
$string['advlink_dlg:general_tab'] = 'General';
$string['advlink_dlg:height'] = 'Alçada';
$string['advlink_dlg:id'] = 'Id';
$string['advlink_dlg:is_email'] = 'L\'URL que has introduït sembla una adreça de correu, vols afegir-hi el prefix mailto://?';
$string['advlink_dlg:is_external'] = 'L\'URL que has introduït sembla un enllaç extern, vols afegir-hi el prefix http://?';
$string['advlink_dlg:langcode'] = 'Codi de l\'idioma';
$string['advlink_dlg:langdir'] = 'Direcció de l\'idioma';
$string['advlink_dlg:link_list'] = 'Llista d\'enllaços';
$string['advlink_dlg:list'] = 'Llista d\'enllaços';
$string['advlink_dlg:ltr'] = 'D\'esquerra a dreta';
$string['advlink_dlg:mime'] = 'Tipus MIME de l\'objectiu';
$string['advlink_dlg:popup'] = 'Emergent Javascript';
$string['advlink_dlg:popup_dependent'] = 'Dependent (només Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Mostra la barra d\'ubicació';
$string['advlink_dlg:popup_menubar'] = 'Mostra la barra de menú';
$string['advlink_dlg:popup_name'] = 'Nom de la finestra';
$string['advlink_dlg:popup_opts'] = 'Opcions';
$string['advlink_dlg:popup_position'] = 'Posició (X/Y)';
$string['advlink_dlg:popup_props'] = 'Propietats de l\'emergent';
$string['advlink_dlg:popup_resizable'] = 'La finestra es pot amidar';
$string['advlink_dlg:popup_return'] = 'Insereix \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Mostra les barres de desplaçament';
$string['advlink_dlg:popup_size'] = 'Mida';
$string['advlink_dlg:popup_statusbar'] = 'Mostra la barra d\'estat';
$string['advlink_dlg:popup_tab'] = 'Emergent';
$string['advlink_dlg:popup_toolbar'] = 'Mostra les barres d\'eines';
$string['advlink_dlg:popup_url'] = 'URL de l\'emergent';
$string['advlink_dlg:rel'] = 'Relació pàgina a objectiu';
$string['advlink_dlg:rev'] = 'Relació objectiu a pàgina';
$string['advlink_dlg:rtl'] = 'De dreta a esquerra';
$string['advlink_dlg:style'] = 'Estil';
$string['advlink_dlg:tabindex'] = 'Índex de taula';
$string['advlink_dlg:target'] = 'Objectiu';
$string['advlink_dlg:target_blank'] = 'Obre en una finestra nova';
$string['advlink_dlg:target_langcode'] = 'Idioma objectiu';
$string['advlink_dlg:target_name'] = 'Nom de l\'objectiu';
$string['advlink_dlg:target_parent'] = 'Obre a la finestra /marc pare';
$string['advlink_dlg:target_same'] = 'Obre en aquesta finestra / marc';
$string['advlink_dlg:target_top'] = 'Obre en el marc superior (substitueix tots els marcs)';
$string['advlink_dlg:title'] = 'Insereix/edita enllaç';
$string['advlink_dlg:titlefield'] = 'Títol';
$string['advlink_dlg:url'] = 'URL de l\'enllaç';
$string['advlink_dlg:width'] = 'Amplada';
$string['advlink:link_desc'] = 'Insereix/edita enllaç';
$string['advlist:circle'] = 'Cercle';
$string['advlist:def'] = 'Per defecte';
$string['advlist:disc'] = 'Disc';
$string['advlist:lower_alpha'] = 'Minúscules llatines';
$string['advlist:lower_greek'] = 'Minúscules gregues';
$string['advlist:lower_roman'] = 'Minúscules romanes';
$string['advlist:square'] = 'Quadrat';
$string['advlist:types'] = 'Tipus';
$string['advlist:upper_alpha'] = 'Majúscules llatines';
$string['advlist:upper_roman'] = 'Majúscules romanes';
$string['aria:rich_text_area'] = 'Àrea de text enriquit';
$string['autosave:restore_content'] = 'Restaura el contingut auto desat.';
$string['autosave:unload_msg'] = 'Els canvis que has fet es perdran si surts d\'aquesta pàgina.';
$string['autosave:warning_message'] = 'Si restaureu el document desat, perdreu tot el contingut que teniu ara a l\'editor.

Esteu segurs de voler restaurar el contingut desat ?';
$string['availablebuttons'] = 'Botons disponibles';
$string['colors:000000'] = 'Negre';
$string['colors:000080'] = 'Blau marí';
$string['colors:0000FF'] = 'Blau';
$string['colors:003300'] = 'Verd fosc';
$string['colors:003366'] = 'Blau fosc';
$string['colors:008000'] = 'Verd';
$string['colors:008080'] = 'Xarxet blau';
$string['colors:00CCFF'] = 'Blau cel';
$string['colors:00FF00'] = 'Llima';
$string['colors:00FFFF'] = 'Aigua';
$string['colors:333300'] = 'Oliva fosc';
$string['colors:333333'] = 'Gris molt fosc';
$string['colors:333399'] = 'Morat';
$string['colors:3366FF'] = 'Blau reial';
$string['colors:339966'] = 'Verd oceà';
$string['colors:33CCCC'] = 'Turquesa';
$string['colors:666699'] = 'Gris blavós';
$string['colors:800000'] = 'Granat';
$string['colors:800080'] = 'Porpra';
$string['colors:808000'] = 'Oliva';
$string['colors:808080'] = 'Gris';
$string['colors:993300'] = 'Taronja';
$string['colors:993366'] = 'Marró';
$string['colors:999999'] = 'Gris mitjà';
$string['colors:99CC00'] = 'Verd grogós';
$string['colors:99CCFF'] = 'Blau cel lluminós';
$string['colors:C0C0C0'] = 'Plata';
$string['colors:CC99FF'] = 'Pruna';
$string['colors:CCFFCC'] = 'Verd pàl·lid';
$string['colors:CCFFFF'] = 'Cian pàl·lid';
$string['colors:FF0000'] = 'Vermell';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Taronja';
$string['colors:FF9900'] = 'Ambre';
$string['colors:FF99CC'] = 'Rosa';
$string['colors:FFCC00'] = 'Or';
$string['colors:FFCC99'] = 'Préssec';
$string['colors:FFFF00'] = 'Groc';
$string['colors:FFFF99'] = 'Groc lluminós';
$string['colors:FFFFFF'] = 'Blanc';
$string['common:apply'] = 'Aplica';
$string['common:browse'] = 'Explora';
$string['common:cancel'] = 'Cancel·la';
$string['common:class_name'] = 'Classe';
$string['common:clipboard_msg'] = 'Copia/Retalla/Enganxa no està disponible en Mozilla/Firefox. Voleu més informació sobre aquest problema?';
$string['common:clipboard_no_support'] = 'Actualment no està suportat pel teu navegador, utilitza les dreceres de teclat en lloc seu.';
$string['common:close'] = 'Tanca';
$string['common:edit_confirm'] = 'Vols utilitzar el mode visible (WYSIWYG) per a aquesta àrea de text?';
$string['common:insert'] = 'Insereix';
$string['common:invalid_data'] = 'Error: Has introduït valors incorrectes, te\'ls marquem en vermell.';
$string['common:invalid_data_min'] = '{#field} ha de ser un nombre major que {#min}';
$string['common:invalid_data_number'] = '{#field} ha de ser un nombre';
$string['common:invalid_data_size'] = '{#field} ha de ser un nombre o percentatge';
$string['common:more_colors'] = 'Més colors';
$string['common:not_set'] = '-- Sense establir --';
$string['common:popup_blocked'] = 'Ho sentim, però ens hem adonat que el teu bloquejador de finestres emergents ha desactivat una finestra que proporciona funcionalitat a l\'aplicació. Hauràs de desactivar el blocatge de finestres emergents en aquest lloc per tal d\'utilitzar plenament aquesta eina.';
$string['common:update'] = 'Actualitza';
$string['common:value'] = '(valor)';
$string['contextmenu:align'] = 'Alineació';
$string['contextmenu:center'] = 'Centrat';
$string['contextmenu:full'] = 'Justificat';
$string['contextmenu:left'] = 'Esquerra';
$string['contextmenu:right'] = 'Dreta';
$string['customconfig'] = 'Configuració personalitzada';
$string['customconfig_desc'] = 'Configuració personalitzada avançada de TinyMCE en format JSON, per exemple: {"option1" : "value2", "option2" : "value2"}. Qualsevol opció especificada aquí sobreescriu la configuració estàndard i la configuració dels connectors.';
$string['customtoolbar'] = 'Barra d\'eines de l\'editor';
$string['customtoolbar_desc'] = 'Cada línia conté un llista de botons separats per comes, utilitzeu "|"  com a separador de grup, les línies buides s\'ignoren. Mireu <a href="{$a}" target="_blank">{$a}</a> per veure una llista de botons per defecte de TinyMCE.';
$string['directionality:ltr_desc'] = 'Direcció d\'esquerra a dreta';
$string['directionality:rtl_desc'] = 'Direcció de dreta a esquerra';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Ben parit';
$string['emotions_dlg:cry'] = 'Plor';
$string['emotions_dlg:desc'] = 'Emoticones';
$string['emotions_dlg:embarassed'] = 'Vergonya';
$string['emotions_dlg:foot_in_mouth'] = 'Muts i a la gàbia';
$string['emotions_dlg:frown'] = 'Indiferent';
$string['emotions_dlg:innocent'] = 'Innocent';
$string['emotions_dlg:kiss'] = 'Petó';
$string['emotions_dlg:laughing'] = 'Rialla';
$string['emotions_dlg:money_mouth'] = 'Boca de diner';
$string['emotions_dlg:sealed'] = 'Segellada';
$string['emotions_dlg:smile'] = 'Somriure';
$string['emotions_dlg:surprised'] = 'Sorpresa';
$string['emotions_dlg:title'] = 'Insereix emoticona';
$string['emotions_dlg:tongue_out'] = 'Treu la llengua';
$string['emotions_dlg:undecided'] = 'Indecisa';
$string['emotions_dlg:usage'] = 'Utilitzeu les fletxes esquerra i dreta per a navegar.';
$string['emotions_dlg:wink'] = 'Pica l\'ullet';
$string['emotions_dlg:yell'] = 'Crit';
$string['emotions:emotions_desc'] = 'Emoticones';
$string['fontselectlist'] = 'Llista de fonts disponible';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Propietats del document';
$string['fullpage_dlg:active_color'] = 'Color actiu';
$string['fullpage_dlg:add'] = 'Afegeix element nou';
$string['fullpage_dlg:add_base'] = 'Element Base';
$string['fullpage_dlg:add_comment'] = 'Node de comentari';
$string['fullpage_dlg:add_link'] = 'Element Link';
$string['fullpage_dlg:add_meta'] = 'Element Meta';
$string['fullpage_dlg:add_script'] = 'Element Script';
$string['fullpage_dlg:add_style'] = 'Element Style';
$string['fullpage_dlg:add_title'] = 'Element Title';
$string['fullpage_dlg:advanced_props'] = 'Avançat';
$string['fullpage_dlg:advanced_tab'] = 'Avançat';
$string['fullpage_dlg:appearance_bgprops'] = 'Propietats del fons';
$string['fullpage_dlg:appearance_linkprops'] = 'Colors dels enllaços';
$string['fullpage_dlg:appearance_marginprops'] = 'Marges del cos';
$string['fullpage_dlg:appearance_style'] = 'Propietats dels estils i fulls d\'estils';
$string['fullpage_dlg:appearance_tab'] = 'Aparença';
$string['fullpage_dlg:appearance_textprops'] = 'Propietats del text';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Element Base';
$string['fullpage_dlg:bgcolor'] = 'Color de fons';
$string['fullpage_dlg:bgimage'] = 'Imatge de fons';
$string['fullpage_dlg:bottom_margin'] = 'Marge inferior';
$string['fullpage_dlg:charset'] = 'Joc de caràcters';
$string['fullpage_dlg:comment_element'] = 'Comentari';
$string['fullpage_dlg:content'] = 'Content';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Codificació de caràcters';
$string['fullpage_dlg:fontface'] = 'Tipografia';
$string['fullpage_dlg:font_face'] = 'Tipografia';
$string['fullpage_dlg:fontsize'] = 'Mida de lletra';
$string['fullpage_dlg:font_size'] = 'Mida de lletra';
$string['fullpage_dlg:general_props'] = 'General';
$string['fullpage_dlg:head_elements'] = 'Elements de capçalera';
$string['fullpage_dlg:hover_color'] = 'Color ressaltat';
$string['fullpage_dlg:href'] = 'Href';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Informació';
$string['fullpage_dlg:langcode'] = 'Codi de l\'idioma';
$string['fullpage_dlg:langdir'] = 'Direcció de l\'idioma';
$string['fullpage_dlg:langprops'] = 'Idioma i codificació';
$string['fullpage_dlg:language'] = 'Idioma';
$string['fullpage_dlg:left_margin'] = 'Marge esquerre';
$string['fullpage_dlg:link_color'] = 'Color dels enllaços';
$string['fullpage_dlg:link_element'] = 'Element Link';
$string['fullpage_dlg:ltr'] = 'D\'esquerra a dreta';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Descripció';
$string['fullpage_dlg:meta_element'] = 'Element Meta';
$string['fullpage_dlg:meta_index_follow'] = 'Indexa i segueix els enllaços';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexa i no segueixis els enllaços';
$string['fullpage_dlg:meta_keywords'] = 'Paraules clau';
$string['fullpage_dlg:meta_noindex_follow'] = 'No indexis però segueix els enllaços';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'No indexis i no segueixis els enllaços';
$string['fullpage_dlg:meta_props'] = 'Meta informació';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'General';
$string['fullpage_dlg:meta_title'] = 'Títol';
$string['fullpage_dlg:movedown'] = 'Desplaça avall l\'element seleccionat';
$string['fullpage_dlg:moveup'] = 'Desplaça amunt l\'element seleccionat';
$string['fullpage_dlg:name'] = 'Nom';
$string['fullpage_dlg:properties'] = 'Propietats';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Elimina l\'element seleccionat';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Marge dret';
$string['fullpage_dlg:rtl'] = 'De dreta a esquerra';
$string['fullpage_dlg:script_element'] = 'Element Script';
$string['fullpage_dlg:src'] = 'Src';
$string['fullpage_dlg:style'] = 'Estil';
$string['fullpage_dlg:style_element'] = 'Element Style';
$string['fullpage_dlg:stylesheet'] = 'Full d\'estils';
$string['fullpage_dlg:target'] = 'Target';
$string['fullpage_dlg:textcolor'] = 'Color';
$string['fullpage_dlg:text_color'] = 'Color del text';
$string['fullpage_dlg:title'] = 'Propietats del document';
$string['fullpage_dlg:title_element'] = 'Element Title';
$string['fullpage_dlg:top_margin'] = 'Marge superior';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Valor';
$string['fullpage_dlg:visited_color'] = 'Color visitat';
$string['fullpage_dlg:xml_pi'] = 'Declaració XML';
$string['fullscreen:desc'] = 'Mode de pantalla completa';
$string['iespell:download'] = 'No s\'ha detectat ieSpell. Vols instal·lar-lo ara?';
$string['iespell:iespell_desc'] = 'Comprovació ortogràfica';
$string['insertdatetime:date_fmt'] = '%d-%m-%Y';
$string['insertdatetime:day_long'] = 'Diumenge,Dilluns,Dimarts,Dimecres,Dijous,Divendres,Dissabte,Diumenge';
$string['insertdatetime:day_short'] = 'Dmg,Dll,Dmt,Dmc,Djs,Dvs,Dss,Dmg';
$string['insertdatetime:insertdate_desc'] = 'Insereix la data';
$string['insertdatetime:inserttime_desc'] = 'Insereix l\'hora';
$string['insertdatetime:months_long'] = 'Gener,Febrer,Març,Abril,Maig,Juny,Juliol,Agost,Setembre,Octubre,Novembre,Desembre';
$string['insertdatetime:months_short'] = 'Gen,Feb,Mar,Abr,Mai,Jun,Jul,Ago,Set,Oct,Nov,Des';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Canvia el posicionament absolut';
$string['layer:backward_desc'] = 'Desplaça endarrere';
$string['layer:content'] = 'Nova capa...';
$string['layer:forward_desc'] = 'Desplaça endavant';
$string['layer:insertlayer_desc'] = 'Insereix capa nova';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Insereix / edita mitjà encastat';
$string['media_dlg:advanced'] = 'Avançat';
$string['media_dlg:align'] = 'Alineació';
$string['media_dlg:align_bottom'] = 'Baix';
$string['media_dlg:align_bottom_left'] = 'Baix esquerra';
$string['media_dlg:align_bottom_right'] = 'Baix dreta';
$string['media_dlg:align_center'] = 'Centrat';
$string['media_dlg:align_left'] = 'Esquerra';
$string['media_dlg:align_right'] = 'Dreta';
$string['media_dlg:align_top'] = 'Dalt';
$string['media_dlg:align_top_left'] = 'Dalt esquerra';
$string['media_dlg:align_top_right'] = 'Dalt dreta';
$string['media_dlg:altsource1'] = 'Font alternativa 1';
$string['media_dlg:altsource2'] = 'Font alternativa 2';
$string['media_dlg:audio'] = 'Àudio HTML5';
$string['media_dlg:autogotourl'] = 'URL Auto goto';
$string['media_dlg:autohref'] = 'AutoHREF';
$string['media_dlg:autostart'] = 'Auto inici';
$string['media_dlg:balance'] = 'Balanç';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'URL base';
$string['media_dlg:bgcolor'] = 'Fons';
$string['media_dlg:cache'] = 'Cau';
$string['media_dlg:captioningid'] = 'Id del títol';
$string['media_dlg:center'] = 'Centrat';
$string['media_dlg:class_name'] = 'Classe';
$string['media_dlg:console'] = 'Consola';
$string['media_dlg:constrain_proportions'] = 'Constreny les proporcions';
$string['media_dlg:controller'] = 'Controlador';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'Sense correcció';
$string['media_dlg:currentmarker'] = 'Marcador actual';
$string['media_dlg:currentposition'] = 'Posició actual';
$string['media_dlg:defaultframe'] = 'Marc per defecte';
$string['media_dlg:embeddedaudio'] = 'Àudio incrustat';
$string['media_dlg:embedded_audio_options'] = 'Opcions d\'àudio incrustat';
$string['media_dlg:enabled'] = 'Activat';
$string['media_dlg:enablejavascript'] = 'Activa JavaScript';
$string['media_dlg:endtime'] = 'Hora final';
$string['media_dlg:file'] = 'Fitxer/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Opcions Flash';
$string['media_dlg:flashvars'] = 'Variables Flash';
$string['media_dlg:fullscreen'] = 'Pantalla completa';
$string['media_dlg:general'] = 'General';
$string['media_dlg:hidden'] = 'Ocult';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = 'Espaiat H';
$string['media_dlg:html5_audio_options'] = 'Opcions d\'àudio';
$string['media_dlg:html5_video_options'] = 'Opcions de vídeo HTML5';
$string['media_dlg:id'] = 'Id';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Estat de la imatge';
$string['media_dlg:invokeurls'] = 'Invoca URLs';
$string['media_dlg:kioskmode'] = 'Mode kiosk';
$string['media_dlg:list'] = 'Llista';
$string['media_dlg:liveconnect'] = 'Connexió directa SW';
$string['media_dlg:loop'] = 'Cicle';
$string['media_dlg:maintainaspect'] = 'Matingues l\'aspecte';
$string['media_dlg:menu'] = 'Mostra el menú';
$string['media_dlg:mute'] = 'Sense so';
$string['media_dlg:name'] = 'Nom';
$string['media_dlg:nojava'] = 'Sense java';
$string['media_dlg:numloop'] = 'Nº de cicles';
$string['media_dlg:play'] = 'Auto reprodueix';
$string['media_dlg:playcount'] = 'Recompte de reproduccions';
$string['media_dlg:playeveryframe'] = 'Reprodueix cada marc';
$string['media_dlg:poster'] = 'Cartell';
$string['media_dlg:prefetch'] = 'Precerca';
$string['media_dlg:preload'] = 'Precarrega';
$string['media_dlg:preload_auto'] = 'Deixem que el navegador de l\'usuari decideixi';
$string['media_dlg:preload_metadata'] = 'Precarrega les metadades de vídeo';
$string['media_dlg:preload_none'] = 'No precarregues';
$string['media_dlg:preview'] = 'Vista prèvia';
$string['media_dlg:progress'] = 'Progrés';
$string['media_dlg:qt_options'] = 'Opcions Quicktime';
$string['media_dlg:qtsrc'] = 'Font QT';
$string['media_dlg:qtsrcchokespeed'] = 'restringeix la velocitat';
$string['media_dlg:qt_stream_warn'] = 'Els recursos rtsp stream no s\'han d\'afegir al camp Font QT sota la pestanya Avançada.nhas d\'afegir també una versió no-stream al camp Font.';
$string['media_dlg:quality'] = 'Qualitat';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Ritme';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opcions Real Meedia Player';
$string['media_dlg:salign'] = 'Alíniació';
$string['media_dlg:scale'] = 'Escala';
$string['media_dlg:scriptcallbacks'] = 'Retorns a script';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Opcions Shockwave';
$string['media_dlg:shuffle'] = 'Barreja';
$string['media_dlg:size'] = 'Dimensions';
$string['media_dlg:sound'] = 'So';
$string['media_dlg:source'] = 'Font';
$string['media_dlg:starttime'] = 'Hora inicial';
$string['media_dlg:stretchtofit'] = 'Estira per encaixar';
$string['media_dlg:swstretchhalign'] = 'Estirament de l\'alineació H';
$string['media_dlg:swstretchstyle'] = 'Estil d\'estirament';
$string['media_dlg:swstretchvalign'] = 'Estirament de l\'alineació V';
$string['media_dlg:target'] = 'Objectiu';
$string['media_dlg:targetcache'] = 'Cau objectiu';
$string['media_dlg:title'] = 'Insereix / edita mitjà encastat';
$string['media_dlg:type'] = 'Tipus';
$string['media_dlg:uimode'] = 'Mode de la UI';
$string['media_dlg:video'] = 'Vídeo HTML5';
$string['media_dlg:volume'] = 'Volum';
$string['media_dlg:vspace'] = 'Espaiat V';
$string['media_dlg:windowlessvideo'] = 'Vídeo sense finestra';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'Mode de finestra';
$string['media_dlg:wmp_options'] = 'Opcions Windows Media Player';
$string['media:edit'] = 'Edita mitjà encastat';
$string['nonbreaking:nonbreaking_desc'] = 'Insereix espai no separable';
$string['pagebreak:desc'] = 'Insereix salt de pàgina.';
$string['paste_dlg:text_linebreaks'] = 'Mantingues els salts de línia';
$string['paste_dlg:text_title'] = 'Utilitza CTRL+V al teclat per enganxar el text a la finestra.';
$string['paste_dlg:word_title'] = 'Utilitza CTRL+V al teclat per enganxar el text a la finestra.';
$string['paste:paste_text_desc'] = 'Enganxa com a Text Planer';
$string['paste:paste_word_desc'] = 'Enganxa des de Word';
$string['paste:plaintext_mode'] = 'Enganxa està actualment en mode text pla. Premeu de nou per canviar enganxa al mode normal.';
$string['paste:plaintext_mode_stick'] = 'Enganxar funciona ara en mode de text net. Feu clic de nou per tornar al mode normal.';
$string['paste:selectall_desc'] = 'Selecciona-ho Tot';
$string['pluginname'] = 'Editor HTML TinyMCE';
$string['preview:preview_desc'] = 'Vista prèvia';
$string['print:print_desc'] = 'Imprimeix';
$string['save:cancel_desc'] = 'Cancel·la tots els canvis';
$string['save:save_desc'] = 'Desa';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'S\'han substituït totes les ocurrències de la cadena buscada.';
$string['searchreplace_dlg:direction'] = 'Direcció';
$string['searchreplace_dlg:down'] = 'Avall';
$string['searchreplace_dlg:findnext'] = 'Següent';
$string['searchreplace_dlg:findwhat'] = 'Cerca';
$string['searchreplace_dlg:mcase'] = 'Distingeix majúscules i minúscules';
$string['searchreplace_dlg:notfound'] = 'S\'ha completat la recerca. No s\'ha trobat la cadena buscada.';
$string['searchreplace_dlg:replace'] = 'Substitueix';
$string['searchreplace_dlg:replaceall'] = 'Substitueix tot';
$string['searchreplace_dlg:replace_title'] = 'Cerca/Substitueix';
$string['searchreplace_dlg:replacewith'] = 'Substitueix per';
$string['searchreplace_dlg:searchnext_desc'] = 'Torna a cercar';
$string['searchreplace_dlg:search_title'] = 'Cerca';
$string['searchreplace_dlg:up'] = 'Amunt';
$string['searchreplace:replace_desc'] = 'Cerca/Substitueix';
$string['searchreplace:search_desc'] = 'Cerca';
$string['settings'] = 'Configuració general';
$string['simple:bold_desc'] = 'Negreta (Ctrl+B)';
$string['simple:bullist_desc'] = 'Llista no ordenada';
$string['simple:cleanup_desc'] = 'Neteja el codi mal format';
$string['simple:italic_desc'] = 'Cursiva (Ctrl+I)';
$string['simple:numlist_desc'] = 'Llista ordenada';
$string['simple:redo_desc'] = 'Refés (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Tatxat';
$string['simple:underline_desc'] = 'Subratllat (Ctrl+U)';
$string['simple:undo_desc'] = 'Desfés (Ctrl+Z)';
$string['spellchecker:desc'] = 'Des/activa el corrector ortogràfic';
$string['spellchecker:ignore_word'] = 'Ignora';
$string['spellchecker:ignore_words'] = 'Ignora-les totes';
$string['spellchecker:langs'] = 'Idiomes';
$string['spellchecker:learn_word'] = 'Aprèn paraula';
$string['spellchecker:menu'] = 'Configuració del corrector';
$string['spellchecker:no_mpell'] = 'No s\'ha trobat cap incorrecció.';
$string['spellchecker:no_sug'] = 'No hi ha cap suggeriment';
$string['spellchecker:sug'] = 'Suggeriments';
$string['spellchecker:wait'] = 'Espera, si et plau...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Edita l\'Estil CSS';
$string['style_dlg:apply'] = 'Aplica';
$string['style_dlg:background'] = 'Fons';
$string['style_dlg:background_attachment'] = 'Adjunció';
$string['style_dlg:background_color'] = 'Color de fons';
$string['style_dlg:background_hpos'] = 'Posició horitzontal';
$string['style_dlg:background_image'] = 'Imatge de fons';
$string['style_dlg:background_repeat'] = 'Repeteix';
$string['style_dlg:background_tab'] = 'Fons';
$string['style_dlg:background_vpos'] = 'Posició vertical';
$string['style_dlg:block'] = 'Bloc';
$string['style_dlg:block_display'] = 'Mostra';
$string['style_dlg:block_letterspacing'] = 'Espaiat de lletres';
$string['style_dlg:block_tab'] = 'Bloc';
$string['style_dlg:block_text_align'] = 'Alineació del text';
$string['style_dlg:block_text_indent'] = 'Sagnat del text';
$string['style_dlg:block_vertical_alignment'] = 'Alineació vertical';
$string['style_dlg:block_whitespace'] = 'Espai en blanc';
$string['style_dlg:block_wordspacing'] = 'Espaiat de paraules';
$string['style_dlg:border'] = 'Vora';
$string['style_dlg:border_tab'] = 'Vora';
$string['style_dlg:bottom'] = 'Baix';
$string['style_dlg:box'] = 'Caixa';
$string['style_dlg:box_clear'] = 'Neteja';
$string['style_dlg:box_float'] = 'Flota';
$string['style_dlg:box_height'] = 'Alçada';
$string['style_dlg:box_tab'] = 'Caixa';
$string['style_dlg:box_width'] = 'Amplada';
$string['style_dlg:bullet_image'] = 'Imatge de pic';
$string['style_dlg:clip'] = 'Retall';
$string['style_dlg:color'] = 'Color';
$string['style_dlg:height'] = 'Alçada';
$string['style_dlg:left'] = 'Esquerra';
$string['style_dlg:list'] = 'Llista';
$string['style_dlg:list_tab'] = 'Llista';
$string['style_dlg:list_type'] = 'Tipus';
$string['style_dlg:margin'] = 'Marge';
$string['style_dlg:overflow'] = 'Sobreeiximent';
$string['style_dlg:padding'] = 'Farciment';
$string['style_dlg:placement'] = 'Col·locació';
$string['style_dlg:position'] = 'Posició';
$string['style_dlg:positioning_tab'] = 'Posicionament';
$string['style_dlg:positioning_type'] = 'Tipus';
$string['style_dlg:right'] = 'Dreta';
$string['style_dlg:same'] = 'Igual per a tots';
$string['style_dlg:style'] = 'Estil';
$string['style_dlg:text'] = 'Text';
$string['style_dlg:text_blink'] = 'intermitent';
$string['style_dlg:text_case'] = 'Caixa';
$string['style_dlg:text_color'] = 'Color';
$string['style_dlg:text_decoration'] = 'Decoració';
$string['style_dlg:text_font'] = 'Tipografia';
$string['style_dlg:text_lineheight'] = 'Alçada de la Línia';
$string['style_dlg:text_none'] = 'cap';
$string['style_dlg:text_overline'] = 'sobreratllat';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Mida';
$string['style_dlg:text_striketrough'] = 'tatxat';
$string['style_dlg:text_style'] = 'Estil';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'subratllat';
$string['style_dlg:text_variant'] = 'Variació';
$string['style_dlg:text_weight'] = 'Pes';
$string['style_dlg:title'] = 'Edita l\'Estil CSS';
$string['style_dlg:toggle_insert_span'] = 'Insereix span en la selecció';
$string['style_dlg:top'] = 'Dalt';
$string['style_dlg:visibility'] = 'Visibilitat';
$string['style_dlg:width'] = 'Amplada';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Connector';
$string['subplugintype_tinymce_plural'] = 'Connectors';
$string['table:cell'] = 'Cel·la';
$string['table:cell_desc'] = 'Propietats de la cel·la de la taula';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Columna';
$string['table:col_after_desc'] = 'Insereix columna després';
$string['table:col_before_desc'] = 'Insereix columna abans';
$string['table:copy_row_desc'] = 'Copia la fila de la taula';
$string['table:cut_row_desc'] = 'Retalla la fila de la taula';
$string['table:del'] = 'Suprimeix la taula';
$string['table:delete_col_desc'] = 'Elimina columna';
$string['table:delete_row_desc'] = 'Suprimeix fila';
$string['table:desc'] = 'Insereix una nova taula';
$string['table_dlg:advanced_props'] = 'Propietats avançades';
$string['table_dlg:advanced_tab'] = 'Avançat';
$string['table_dlg:align'] = 'Alineació';
$string['table_dlg:align_bottom'] = 'Baix';
$string['table_dlg:align_default'] = 'Per defecte';
$string['table_dlg:align_left'] = 'Esquerra';
$string['table_dlg:align_middle'] = 'Centrat';
$string['table_dlg:align_right'] = 'Dreta';
$string['table_dlg:align_top'] = 'Dalt';
$string['table_dlg:bgcolor'] = 'Color del fons';
$string['table_dlg:bgimage'] = 'Imatge de fons';
$string['table_dlg:border'] = 'Vora';
$string['table_dlg:bordercolor'] = 'Color de la vora';
$string['table_dlg:caption'] = 'Títol de la taula';
$string['table_dlg:cell_all'] = 'Actualitza totes les cel·les de la taula';
$string['table_dlg:cell_cell'] = 'Actualitza la cel·la actual';
$string['table_dlg:cell_col'] = 'Actualitza totes les cel·les de la columna';
$string['table_dlg:cell_limit'] = 'Has excedit el nombre màxim de cel·les de {$cells}.';
$string['table_dlg:cellpadding'] = 'Espai de marge';
$string['table_dlg:cell_row'] = 'Actualitza totes les cel·les de la fila';
$string['table_dlg:cellspacing'] = 'Espai de Cel.la';
$string['table_dlg:cell_title'] = 'Propietats de la cel·la de la taula';
$string['table_dlg:cell_type'] = 'Tipus de cel·la';
$string['table_dlg:colgroup'] = 'Grup de Columnes';
$string['table_dlg:col_limit'] = 'Has excedit el nombre màxim de columnes de {$cols}.';
$string['table_dlg:cols'] = 'Columnes';
$string['table_dlg:frame'] = 'Marc';
$string['table_dlg:frame_all'] = 'totes';
$string['table_dlg:frame_cols'] = 'columnes';
$string['table_dlg:frame_groups'] = 'grups';
$string['table_dlg:frame_none'] = 'cap';
$string['table_dlg:frame_rows'] = 'files';
$string['table_dlg:general_props'] = 'Propietats generals';
$string['table_dlg:general_tab'] = 'General';
$string['table_dlg:height'] = 'Alçada';
$string['table_dlg:id'] = 'Id';
$string['table_dlg:langcode'] = 'Codi de l\'idioma';
$string['table_dlg:langdir'] = 'Direcció de l\'Idioma';
$string['table_dlg:ltr'] = 'D\'esquerra a dreta';
$string['table_dlg:merge_cells_title'] = 'Refon les cel·les de la taula';
$string['table_dlg:mime'] = 'Tipus MIME de l\'objectiu';
$string['table_dlg:missing_scope'] = 'Segur que vols continuar sense especificar un abast per a les cel·les de capçalera d\'aquesta taula? Sense això, alguns usuaris/es amb discapacitats tindran dificultats per entendre el contingut o les dades mostrades a la taula.';
$string['table_dlg:row_all'] = 'Actualitza les files de la taula';
$string['table_dlg:row_even'] = 'Actualitza les files parelles de la taula';
$string['table_dlg:rowgroup'] = 'Grup de Files';
$string['table_dlg:row_limit'] = 'Has excedit el nombre màxim de files de {$rows}.';
$string['table_dlg:row_odd'] = 'Actualitza les files senars de la taula';
$string['table_dlg:row_row'] = 'Actualitza la fila actual';
$string['table_dlg:rows'] = 'Files';
$string['table_dlg:row_title'] = 'Propietats de la fila de la taula';
$string['table_dlg:rowtype'] = 'Part de la taula on és la fila';
$string['table_dlg:rtl'] = 'De dreta a esquerra';
$string['table_dlg:rules'] = 'Regles';
$string['table_dlg:rules_above'] = 'sobre';
$string['table_dlg:rules_below'] = 'sota';
$string['table_dlg:rules_border'] = 'vora';
$string['table_dlg:rules_box'] = 'caixa';
$string['table_dlg:rules_hsides'] = 'banda horitzontal';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'salta regles';
$string['table_dlg:rules_vsides'] = 'banda vertical';
$string['table_dlg:scope'] = 'Abast';
$string['table_dlg:style'] = 'Estil';
$string['table_dlg:summary'] = 'Resum';
$string['table_dlg:tbody'] = 'Cos de la Taula';
$string['table_dlg:td'] = 'Dades';
$string['table_dlg:tfoot'] = 'Peu de la Taula';
$string['table_dlg:th'] = 'Capçalera';
$string['table_dlg:thead'] = 'Capçalera de la Taula';
$string['table_dlg:title'] = 'Insereix/Modifica taula';
$string['table_dlg:valign'] = 'Alineació vertical';
$string['table_dlg:width'] = 'Amplada';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Refon les cel·les de la taula';
$string['table:paste_row_after_desc'] = 'Enganxa la fila de la taula després';
$string['table:paste_row_before_desc'] = 'Enganxa la fila de la taula abans';
$string['table:props_desc'] = 'Propietats de la taula';
$string['table:row'] = 'Fila';
$string['table:row_after_desc'] = 'Insereix fila després';
$string['table:row_before_desc'] = 'Insereix fila abans';
$string['table:row_desc'] = 'Propietats de la fila de la taula';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Parteix les cel·les refoses de la taula';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Insereix contingut predefinit de plantilla';
$string['template_dlg:cdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Diumenge,Dilluns,Dimarts,Dimecres,Dijous,Divendres,Dissabte,Diumenge';
$string['template_dlg:day_short'] = 'Dmg,Dll,Dmt,Dmc,Djs,Dvs,Dss,Dmg';
$string['template_dlg:desc'] = 'Insereix contingut predefinit de plantilla';
$string['template_dlg:desc_label'] = 'Descripció';
$string['template_dlg:label'] = 'Plantilla';
$string['template_dlg:mdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Gener,Febrer,Març,Abril,Maig,Juny,Juliol,Agost,Setembre,Octubre,Novembre,Desembre';
$string['template_dlg:months_short'] = 'Gen,Feb,Mar,Abr,Mai,Jun,Jul,Ago,Set,Oct,Nov,Des';
$string['template_dlg:preview'] = 'Vista prèvia';
$string['template_dlg:select'] = 'Selecciona una plantilla';
$string['template_dlg:title'] = 'Plantilles';
$string['template_dlg:warning'] = 'Atenció: Actualitzar una plantilla amb una de diferent pot provocar pèrdua de dades.';
$string['visualblocks:desc'] = 'Mostra/amaga elements de bloc';
$string['visualchars:desc'] = 'Caràcters de control visual des/activats.';
$string['wordcount:words'] = 'Paraules:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abreujament';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acrònim';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Insereix/Edita Atributs';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citació';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Supressió';
$string['xhtmlxtras_dlg:attribs_title'] = 'Insereix/Edita Atributs';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributs';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributs';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Esdeveniments';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Clau d\'accés';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Cita';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Classe';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Data/Hora';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Idioma';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Direcció del Text';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Estil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Índex de taula';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Títol';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'D\'esquerra a dreta';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'De dreta a esquerra';
$string['xhtmlxtras_dlg:events_tab'] = 'Esdeveniments';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributs de l\'Element';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Esdeveniments de l\'Element';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Configuració General';
$string['xhtmlxtras_dlg:general_tab'] = 'General';
$string['xhtmlxtras_dlg:insert_date'] = 'Insereix la data/hora actual';
$string['xhtmlxtras_dlg:option_ltr'] = 'D\'esquerra a dreta';
$string['xhtmlxtras_dlg:option_rtl'] = 'De dreta a esquerra';
$string['xhtmlxtras_dlg:remove'] = 'Elimina';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Element d\'Abreujament';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Element d\'Acrònim';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Element de Citació';
$string['xhtmlxtras_dlg:title_del_element'] = 'Element de Supressió';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Element d\'Inserció';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Inserció';
