<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_uploaduser', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   tool_uploaduser
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowdeletes'] = 'Povoliť vymazania';
$string['allowrenames'] = 'Povoliť premenovanie';
$string['csvdelimiter'] = 'CSV oddeľovač';
$string['defaultvalues'] = 'Východzie hodnoty';
$string['deleteerrors'] = 'Vymazať chyby';
$string['encoding'] = 'Kódovanie';
$string['errors'] = 'Chyby';
$string['nochanges'] = 'Žiadne zmeny';
$string['renameerrors'] = 'Chyby pri premenovaní';
$string['requiredtemplate'] = 'Vyžadované. Môžete tu použiť syntax pomocou šablón (%l = priezvisko, %f = krstné meno, %u = login). Viď nápoveda pre detaily a príklady.';
$string['rowpreviewnum'] = 'Náhľad riadkov';
$string['uploadpicture_baduserfield'] = 'Zadaný atribút používateľa nie je platný. Zadajte ho znova.';
$string['uploadpicture_cannotmovezip'] = 'Nie je možné presunúť zip súbor do dočasného adresára.';
$string['uploadpicture_cannotprocessdir'] = 'Nie je možné spracovať rozpakované súbory.';
$string['uploadpicture_cannotsave'] = 'Nie je možné uložiť obrázok používateľa {$a}. Skontrolujte pôvodný obrázok.';
$string['uploadpicture_cannotunzip'] = 'Nie je možné rozzipovať súbor s obrázkami.';
$string['uploadpicture_invalidfilename'] = 'Obrázok súboru {$a} má v svojom názve nevhodné znaky. Preskakuje sa.';
$string['uploadpicture_overwrite'] = 'Prepísať používateľské obrázky?';
$string['uploadpictures'] = 'Nahrať obrázky používateľov';
$string['uploadpictures_help'] = '<p>Obrázky používateľov môžu byť nahrané na server ako zip súbor obsahujúci jednotlivé obrázkové súbory. Obrázkové súbory by mali byť nazvané <i>vybrany-atribut-pouzivatela.pripona</i>. Napríklad, ak zvolený atribút používateľa je username a toto je user1234, potom meno súboru by malo byť user1234.jpg.</p>
<p>Podporované typy súborov sú gif, jpg a png.</p>
<p>Názvy súborov nie sú citlivé na veľkosť písmen.</p>';
$string['uploadpicture_userfield'] = 'Atribút používateľa použitý pre výber obrázkov.';
$string['uploadpicture_usernotfound'] = 'Používateľ s poľom \'{$a->userfield}\' a hodnotoue of \'{$a->uservalue}\' neexistuje. Preskakuje sa.';
$string['uploadpicture_userskipped'] = 'Preskakuje sa používateľ {$a} - už má obrázok.';
$string['uploadpicture_userupdated'] = 'Obrázok aktualizovaný pre používateľa {$a}.';
$string['uploadusers'] = 'Preniesť používateľov';
$string['uploadusers_help'] = '<p>Najprv treba poznamenať, že <b>obvykle nie je nutné importovať používateľov
dávkovo</b> &ndash; ak chcete obmedziť množstvo svojej administrátorskej práce, pozrite si najprv
najprv s možnosťami autentizácie, ktoré nevyžadujú manuálnu údržbu, ako je
napríklad pripojenie k už existujúcim externým databázam alebo vytváranie účtov
samotnými používateľmi. Viď stránku "Metóda overovania" v administrátorskom menu.</p>

<p>Ak naozaj chcete importovať väčšie množstvo používateľských účtov
z textového súboru, musíte ho formátovať nasledovne:</p>

<ul>
  <li>Každý riadok súboru obsahuje práve jeden záznam.</li>

  <li>Každý záznam je tvorený zoznamom údajov oddelených čiarkami.</li>

  <li>Prvý záznam súboru má zvláštnu funkciu &ndash; obsahuje zoznam názvov polí.
  Tento zoznam definuje formát zbytku súboru.

    <blockquote>
      <p><strong>Povinné polia:</strong> Tieto položky nesmú chýbať v prvom zázname
      a musia byť vyplnené u všetkých používateľov.</p>

      <p> <code class="example1">username,
      password, firstname, lastname, email</code>
      <p>

      <p><strong>Štandardné polia:</strong> Tieto polia sú voliteľné.
      Ak nie sú definované, sú hodnoty prevzaté z osobného profilu
      administrátora:</p>

      <p><code class="example1">institution,
      department, city, country, lang, auth, timezone</code></p>

      <p><strong>Voliteľné polia:</strong> Všetky tieto polia sú úplne
      voliteľné. Kurzy sú identifikované svojimi "krátkymi názvami" &ndash; ak sú
      uvedené, bude používateľ do príslušných kurzov automaticky zapísaný ako
      študent. Názvy skupín musia byť priradené k odpovedajúcim kurzom, tj.
      skupina group1 ku kurzu course1 atď.</p>

      <p><code class="example1">idnumber, icq,
      phone1, phone2, address, url, description, mailformat, maildisplay,
      htmleditor, autosubscribe, course1, course2, course3, course4, course5,
      group1, group2, group3, group4, group5, type1, type2, type3, type4,
      type5</code></p>
    </blockquote>
  </li>

  <li>Čiarky obsiahnuté vo vnútri údajov je nutné zapísať kódom &amp;#44; &ndash; skript ich
  automaticky transformuje naspäť na čiarky.</li>

  <li>Logické polia využívajú 0 pre False (nepravda) a 1 pre True
  (pravda).</li>

  <li>Typy (type) umožňujú Moodle rozlíšiť, či má používateľ v
  existujúcom kurze priradenú rolu študent alebo učiteľ (tak
  napr. type2 odpovedá kurzu course2).  1 = študent, 2 = učiteľ a 3 =
  učiteľ bez práva na úpravy. Ak ponecháte typ nezadaný, alebo ak nie
  je zadaný žiaden kurz, je používateľ nastavený na východziu hodnotu
  študent.</li>

  <li>Poznámka: Ak je používateľ už registrovaný v databáze používateľov
  Moodle, vráti skript pre daného používateľa číslo userid (databázový index) a
  automaticky zapíše používateľa ako študenta do všetkých zadaných kurzov, pričom nedôjde
  k aktualizácii iných zadaných údajov.</li>
</ul>

<p>Tu je príklad platného súboru pre import:</p>

<p><code>username, password,
firstname, lastname, email, lang, idnumber, maildisplay, course1, group1,
type1<br>
jonest, verysecret, Tom, Jones, jonest@someplace.edu, en, 3663737, 1, Intro101, Section 1, 1<br />
reznort, somesecret, Trent, Reznor, reznort@someplace.edu, en_us, 6736733, 0, Advanced202, Section 3, 3</code></p>

<h2>Aktualizácia existujúcich účtov</h2>

<p>Vo východzom nastavení Moodle predpokladá, že vytvoríte nové používateľské účty
a preskočí záznamy, kde používateľské meno odpovedá existujúcemu účtu. Ak
však nastavíte možnosť "Aktualizovať existujúce účty" na hodnotu <b>Áno</b>,
budú existujúce používateľské účty aktualizované.</p>

<p>Pri aktualizácii existujúcich účtov je možné tiež zmeniť používateľské mená.
Nastavte voľbu "Povoliť premenovanie" na hodnotu <b>Áno</b> a vložte do súboru
pole nazvané <code class="example1">oldusername</code>.</p>

<p><b>Upozornenie:</b> Chyby pri aktualizácii existujúcich účtov môžu negatívne
ovplyvniť používateľa. Pri použití týchto možností aktualizácií postupujte
opatrne.</p>';
$string['uploaduserspreview'] = 'Náhľad na nahranie používateľov';
$string['uploadusersresult'] = 'Výsledky nahrania používateľov';
$string['useraccountupdated'] = 'Aktualizovaný používateľský účet';
$string['userdeleted'] = 'Používateľ vymazaný';
$string['userrenamed'] = 'Premenovaný používateľský účet';
$string['userscreated'] = 'Novovytvorené používateľské účty';
$string['usersdeleted'] = 'Používatelia vymazaní';
$string['usersrenamed'] = 'Premenované používateľské účty';
$string['usersskipped'] = 'Používatelia preskočení';
$string['usersupdated'] = 'Aktualizované používateľské účty';
$string['usersweakpassword'] = 'Používatelia s prelomiteľným heslom';
$string['uubulk'] = 'Vybrať pre hromadné operácie';
$string['uubulkall'] = 'Všetci používatelia';
$string['uubulknew'] = 'Noví používatelia';
$string['uubulkupdated'] = 'Aktualizovaní používatelia';
$string['uucsvline'] = 'CSV riadok';
$string['uulegacy1role'] = '(Pôvodný študent) typN=1';
$string['uulegacy2role'] = '(Pôvodný učiteľ) typN=2';
$string['uulegacy3role'] = '(Pôvodný učiteľ bez práv úprav) typN=3';
$string['uunoemailduplicates'] = 'Zabrániť v duplicitám v mailových adresách';
$string['uuoptype'] = 'Typ nahrania';
$string['uuoptype_addinc'] = 'Pridať všetkých, pripojiť číslice k menám používateľov v prípade potreby';
$string['uuoptype_addnew'] = 'Pridať iba nových a preskočiť existujúcich používateľov';
$string['uuoptype_addupdate'] = 'Pridať nových a aktualizovať existujúcich používateľov';
$string['uuoptype_update'] = 'Iba aktualizovať existujúcich používateľov';
$string['uupasswordnew'] = 'Heslo pre nového používateľa';
$string['uupasswordold'] = 'Heslo existujúceho používateľa';
$string['uuupdateall'] = 'Prepísať so súborom a východzími nastaveniami';
$string['uuupdatefromfile'] = 'Prepísať so súborom';
$string['uuupdatemissing'] = 'Doplniť chýbajúce zo súboru a východzích nastavení';
$string['uuupdatetype'] = 'Podrobnosti o existujúcich používateľoch';
