<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   scorm
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Aktivácia';
$string['activityloading'] = 'Budete automaticky presmerovaní do aktivity za';
$string['activitypleasewait'] = 'Aktivita je nahrávaná, čakajte prosím ...';
$string['advanced'] = 'Parametre';
$string['allowtypeexternal'] = 'Povoliť externý typ balenia';
$string['allowtypelocalsync'] = 'Povoliť prevzatý typ súboru';
$string['areacontent'] = 'Súbor obsahu';
$string['areapackage'] = 'Súboru balíka';
$string['asset'] = 'Objekt';
$string['assetlaunched'] = 'Objekt - Prezrené';
$string['attempt'] = 'Pokus';
$string['attempt1'] = '1 pokus';
$string['attempts'] = 'Pokusy';
$string['attemptsx'] = '{$a} pokusov';
$string['attr_error'] = 'Nesprávna hodnota atribútu ({$a->attr}) v tagu {$a->tag}.';
$string['autocontinue'] = 'Automatické pokračovanie';
$string['autocontinuedesc'] = 'Táto predvoľba je pre východzie nastavenie: automatické pokračovanie pokračovanie aktivity';
$string['autocontinue_help'] = '<p>Ak je táto voľba nastavená, spustí sa automaticky ďalší dostupný
vzdelávací objekt, keď aktuálny vzdelávací objekt vyvolá metódu &quot;ukončiť
komunikáciu&quot;.</p>

<p>Ak je Automatické pokračovanie vypnuté, musí používateľ pre
pokračovanie použiť tlačidlo &quot;Pokračovať&quot;.</p>';
$string['averageattempt'] = 'Priemer zo všetkých pokusov';
$string['badmanifest'] = 'Chyby v manifeste: viď záznamy o chybách';
$string['browse'] = 'Prechádzať';
$string['browsed'] = 'Prechádzané';
$string['browsemode'] = 'Režim prehliadania';
$string['browserepository'] = 'Prehliadať úložisko';
$string['cannotfindsco'] = 'Nepodarilo sa nájť SCO';
$string['chooseapacket'] = 'Vybrať alebo aktualizovať balík SCORM';
$string['completed'] = 'Dokončené';
$string['confirmloosetracks'] = 'Upozornenie: Balík sa zdá byť zmenený. Ak sa zmenila štruktúra balíka, je možné, že sledovanie používateľov môže byť stratené počas procesu nahrávania.';
$string['contents'] = 'Obsah';
$string['coursepacket'] = 'Balík kurzu';
$string['coursestruct'] = 'Štruktúra kurzu';
$string['currentwindow'] = 'Aktuálne okno';
$string['datadir'] = 'Chyba v systéme súborov: Nedá sa vytvoriť adresár s údajmi kurzu';
$string['deleteallattempts'] = 'Vymazať všetky SCORM pokusy';
$string['deleteattemptcheck'] = 'Ste si absolútne istí, že chcete kompletne odstrániť tieto pokusy?';
$string['details'] = 'Detaily prechodu';
$string['directories'] = 'Ukazovať lištu s odkazmi';
$string['display'] = 'Zobraziť';
$string['displayattemptstatus'] = 'Zobraziť stav pokusu';
$string['displayattemptstatus_help'] = 'Ak je povolené, skóre a hodnotenie pokusov sa zobrazení na SCORM stránke.';
$string['displaycoursestructure'] = 'Zobrazenie štruktúry kurzu na vstupnej stránke';
$string['displaycoursestructure_help'] = 'Ak je povolené, obsah sa zobrazí na SCORM stránke.';
$string['displaydesc'] = 'Táto predvoľba je pre východzie nastavenie: zobraziť alebo nezobraziť balík pre aktivitu';
$string['domxml'] = 'Externá knižnica DOMXML';
$string['duedate'] = 'Dátum splatnosti';
$string['element'] = 'Prvok';
$string['enter'] = 'Vstúpiť';
$string['entercourse'] = 'Vstúpiť do kurzu';
$string['errorlogs'] = 'Záznamy o chybách';
$string['everyday'] = 'Každý deň';
$string['everytime'] = 'Vždy pri použití';
$string['exceededmaxattempts'] = 'Dosiahli ste maximálny počet pokusov.';
$string['exit'] = 'Opustiť kurz';
$string['exitactivity'] = 'Ukončiť aktivitu';
$string['expired'] = 'Ospravedlňujeme sa, táto činnosť bola uzavretá {$a} a už nie je k dispozícii';
$string['external'] = 'Aktualizovať časovanie externých balíčkov';
$string['failed'] = 'Zlyhalo';
$string['finishscorm'] = 'Ak ste dokončili prehliadanie tohto zdroja, {$a}';
$string['finishscormlinkname'] = 'kliknite sem pre návrat do hlavnej stránky kurzu';
$string['firstaccess'] = 'Prvý prístup';
$string['firstattempt'] = 'Prvý pokus';
$string['forcecompleted'] = 'Vynútiť dokončenie';
$string['forcecompleteddesc'] = 'Táto preferencie nastaví predvolené hodnoty pre vynútenie dokončenia nastavení';
$string['forcenewattempt'] = 'Vynútiť nový pokus';
$string['forcenewattempt_help'] = 'Ak je zapnuté, každé otvorenie SCORM balíka je chápané ako nový pokus.';
$string['found'] = 'Manifest bol nájdený';
$string['frameheight'] = 'Táto hodnota nastaví východziu hodnotu výšky rámca alebo okna';
$string['framewidth'] = 'Táto hodnota nastaví východziu hodnotu šírky rámca alebo okna';
$string['fullscreen'] = '‌Zobraziť na celú obrazovku';
$string['general'] = 'Všeobecné údaje';
$string['gradeaverage'] = 'Priemerný počet bodov';
$string['gradeforattempt'] = 'Známka pre pokus';
$string['gradehighest'] = 'Najvyšší počet bodov';
$string['grademethod'] = 'Metóda hodnotenia';
$string['grademethoddesc'] = 'Táto predvoľba je pre východzie nastavenie metódy známkovania pre túto aktivitu';
$string['grademethod_help'] = '<p>Výsledky činnosti v rámci balíku SCORM/AICC, zahrnuté do známok kurzu
možno klasifikovať v niekoľkých módoch:</p>

<ul>
  <li><b>Vzdelávacie objekty</b><br />
  Tento režim udáva počet dokončených/úspešne ukončených učebných objektov.
  Maximálna hodnota je daná počtom učebných objektov v balíku.</li>

  <li><b>Najvyšší počet bodov</b><br />
  Pre výpočet známky sa za každý úspešne dokončený učebný objekt použije
  najvyšší dosiahnutý počet bodov.</li>

  <li><b>Priemerný počet bodov</b><br />
  Ak vyberiete tento režim, Moodle vypočíta zo všetkých získaných bodov
  ich priemer.</li>

  <li><b>Celkový počet bodov</b><br />
  V tomto režime sa všetky body sčítajú.</li>
</ul>';
$string['gradereported'] = 'Správa hodnotenia';
$string['gradescoes'] = 'Vzdelávacie objekty';
$string['gradesum'] = 'Súčet bodov';
$string['height'] = 'Výška';
$string['hidden'] = 'Skryť';
$string['hidebrowse'] = 'Zakázať režim náhľadu';
$string['hidebrowsedesc'] = 'Táto predvoľba je pre východzie nastavenie povolenia alebo zakázania režimu náhľadu';
$string['hidebrowse_help'] = '<p>Ak nastavíte túto voľbu, neobjaví sa tlačidlo Náhľad na stránke SCORM/AICC aktivity.</p>

<p>V normálnom móde si študent môže zvoliť, či si chce aktivitu prehliadnuť alebo vypracovať.</p>

<p>Keď je vzdelávací objekt prejdený v prehliadacom móde, je označený ikonou <img src="<?php echo $CFG->wwwroot.\'/mod/scorm/pix/browsed.gif\' ?>" alt="<?php print_string(\'browsed\',\'scorm\') ?>" title="<?php print_string(\'browsed\',\'scorm\') ?>" />.</p>';
$string['hideexit'] = 'Skryť odkaz na opustenie';
$string['hidereview'] = 'Skryť tlačidlo prehliadnuť';
$string['hidetoc'] = 'Zobraziť navigačnú štruktúru kurzu';
$string['hidetocdesc'] = 'Táto predvoľba je pre východzie nastavenie zobrazenia alebo skrytia štruktúry (obsahu) kurzu';
$string['hidetoc_help'] = 'Toto nastavenie určuje, ako je SCORMa obsah zobrazý v prehrávači';
$string['highestattempt'] = 'Najlepší pokus';
$string['identifier'] = 'Identifikátor otázky';
$string['incomplete'] = 'Nedokončené';
$string['info'] = 'info';
$string['interactions'] = 'Interakcie';
$string['invalidactivity'] = 'Aktivita SCORM nie je správna';
$string['last'] = 'Posledný prístup dňa';
$string['lastaccess'] = 'Posledný prístup';
$string['lastattempt'] = 'Posledný pokus';
$string['lastattemptlock'] = 'Uzamknúť po poslednom pokuse';
$string['lastattemptlock_help'] = 'Ak je zapnuté, študent nemôže otvoriť SCORM balík po maximálnom počte pokusov.';
$string['location'] = 'Ukazovať adresný riadok';
$string['max'] = 'Max. bod. zisk';
$string['maximumattempts'] = 'Počet pokusov';
$string['maximumattemptsdesc'] = 'Táto predvoľba je pre východzie nastavenie maximálneho počtu pokusov pre aktivitu.';
$string['maximumattempts_help'] = '<p>Táto funkcia definuje počet pokusov povolených používateľom.
<br />Používa sa iba pre balíky štandardov SCORM1.2 a AICC.
SCORM2004 má vlastnú definíciu maximálneho počtu pokusov.</p>';
$string['maximumgradedesc'] = 'Táto predvoľba je pre východzie nastavenie maximálnej známky pre aktivitu';
$string['menubar'] = 'Ukazovať lištu s hlavnou ponukou';
$string['min'] = 'Min. bod. zisk';
$string['missing_attribute'] = 'Chýba atribút {$a->attr} v tagu {$a->tag}';
$string['missingparam'] = 'Požadovaný údaj chýba alebo je nesprávny';
$string['missing_tag'] = 'Chýba tag {$a->tag}';
$string['mode'] = 'Režim';
$string['modulename'] = 'SCORM/AICC';
$string['modulenameplural'] = 'SCORMy/AICC';
$string['navigation'] = 'Navigácia';
$string['newattempt'] = 'Začať nový pokus';
$string['next'] = 'Pokračovať';
$string['noactivity'] = 'Nič k zobrazeniu';
$string['noattemptsallowed'] = 'Počet povolených pokusov';
$string['noattemptsmade'] = 'Počet pokusov, ktoré ste vykonali';
$string['no_attributes'] = 'Tag {$a->tag} musí mať atribúty';
$string['no_children'] = 'Tag {$a->tag} musí mať potomkov';
$string['nolimit'] = 'Neobmedzený počet pokusov';
$string['nomanifest'] = 'Manifest nebol nájdený';
$string['noprerequisites'] = 'Žiaľ, zatiaľ nespĺňate požadované predpoklady pre prístup k tomuto učebnému objektu.';
$string['noreports'] = 'Žiadna správa na zobrazenie';
$string['normal'] = 'Normálny';
$string['noscriptnoscorm'] = 'Váš prehliadač nepodporuje javascript, alebo bola podpora javascriptu vo vašom prehliadači zakázaná. Tento SCORM balík nemusí správne prehrávať alebo ukladať informácie.';
$string['notattempted'] = 'Bez pokusov';
$string['not_corr_type'] = 'Nesúlad typov v tagu {$a->tag}';
$string['notopenyet'] = 'Prepáčte, táto aktivita nie je dostupná do {$a}';
$string['objectives'] = 'Ciele';
$string['optallstudents'] = 'Všetci užívatelia';
$string['optattemptsonly'] = 'Používatelia len s možnosťou pokusov';
$string['options'] = 'Voľby';
$string['optnoattemptsonly'] = 'Používatelia len bez možnosti pokusov';
$string['organization'] = 'Organizácia';
$string['organizations'] = 'Organizácie';
$string['othersettings'] = 'Ďalšie nastavenia';
$string['package'] = 'Súbor s balíkom';
$string['packagedir'] = 'Chyba v systéme súborov: Nedá sa vytvoriť adresár s balíkom';
$string['packagefile'] = 'Nebol určený súbor s balíkom SCORM/AICC.';
$string['package_help'] = '<p>Balík SCORM/AICC je súbor s príponou <b>zip</b> (alebo pif), ktorý obsahuje
platné súbory AICC alebo SCORM.</p>

<p>Balík <b>SCORM</b> musí v hlavnom adresári zip súboru obsahovať súbor s
názvom <b>imsmanifest.xml</b>, ktorý definuje štruktúru kurzu SCORM, umiestnenie
študijných materiálov a mnoho ďalších vlastností.</p>

<p>Balík <b>AICC</b> je definovaný viacerými súbormi (štyrmi až siedmimi) s určenými
príponami. Význam jednotlivých prípon:</p>

<ul>
  <li>CRS &ndash; Course Description file (Súbor opisu kurzu &ndash; povinný)</li>

  <li>AU &ndash; Assignable Unit file (Súbor s opisom jednotiek kurzu &ndash;
  povinný)</li>

  <li>DES &ndash; Descriptor file (Súbor s opisom blokov kurzu &ndash; povinný)</li>

  <li>CST &ndash; Course Structure file (Súbor so štruktúrovanými údajmi kurzu &ndash;
  povinný)</li>

  <li>ORE &ndash; Objective Relationship file (Súbor s opisom cieľov jednotiek a blokov
  &ndash; voliteľný)</li>

  <li>PRE &ndash; Prerequisites file (Súbor s opisom predpokladov &ndash; voliteľný)</li>

  <li>CMP &ndash; Completition Requirements file (Súbor podmienok ukončenia kurzu &ndash;
  voliteľný)</li>
</ul>';
$string['packageurl'] = 'URL adresa';
$string['pagesize'] = 'Veľkosť stránky';
$string['passed'] = 'Splnený';
$string['php5'] = 'PHP 5 (DOMXML natívna knižnica)';
$string['pluginadministration'] = 'Správa SCORM';
$string['pluginname'] = 'SCORM balík';
$string['popup'] = 'Nové okno';
$string['popupmenu'] = 'Rozbaľovacia ponuka';
$string['popupopen'] = 'Otvoriť balík v novom okne';
$string['popupsblocked'] = 'Vyzerá to tak, že vyskakovacie okná sú vo vašom prehliadači zakázané. Skontrolujte nastavenia prehliadača predtým, ako sa pokúsite  znova.';
$string['position_error'] = 'Tag {$a->tag} nemôže byť potomkom tagu {$a->parent}';
$string['preferencespage'] = 'Preferencie len pre túto stránku';
$string['preferencesuser'] = 'Preferencie pre túto správu';
$string['prev'] = 'Predchádzajúci';
$string['raw'] = 'Hrubé skóre';
$string['regular'] = 'Regulárny manifest';
$string['report'] = 'Správa';
$string['reportcountallattempts'] = '{$a->nbattempts} pokusov pre {$a->nbusers} užívateľov, zo {$a->nbresults} výsledkov';
$string['reportcountattempts'] = '{$a->nbresults} výsledkov ({$a->nbusers} užívateľov)';
$string['result'] = 'Výsledok';
$string['results'] = 'Výsledky';
$string['review'] = 'Opakovaný náhľad';
$string['reviewmode'] = 'Režim opakovaného náhľadu';
$string['scoes'] = 'Vzdelávacie objekty';
$string['score'] = 'Skóre';
$string['scormclose'] = 'Do';
$string['scormcourse'] = 'Kurz SCORM';
$string['scorm:deleteresponses'] = 'Vymazať pokusy SCORM';
$string['scormloggingoff'] = 'Logovacie API je vypnuté';
$string['scormloggingon'] = 'Logovacie API je zapnuté';
$string['scormopen'] = 'Otvorené';
$string['scormresponsedeleted'] = 'Vymazané používateľské pokusy';
$string['scorm:savetrack'] = 'Uložiť postup činnosti';
$string['scorm:skipview'] = 'Preskočiť prehľad';
$string['scormtype'] = 'Typ';
$string['scorm:viewreport'] = 'Prezerať výsledky';
$string['scorm:viewscores'] = 'Prezerať hodnotenie';
$string['scrollbars'] = 'Povoliť zvislý posuvník';
$string['selectall'] = 'Vybrať všetko';
$string['selectnone'] = 'Zrušiť výber všetkých';
$string['show'] = 'Zobraziť';
$string['sided'] = 'Na ľavej strane';
$string['skipview'] = 'Študenti preskočia stránku s obsahom';
$string['skipviewdesc'] = 'Táto predvoľba je pre východzie nastavenie času, kedy treba preskočiť obsah stránky';
$string['skipview_help'] = '<p>Ak sa jedná o balík s jediným vzdelávacím objektom, môžete zvoliť preskočenie stránky s obsahom v prípade, keď účastníci kliknú na SCORM aktivitu v hlavnej stránke kurzu.</p>

<p>Môžete si zvoliť:</p>

   <ul>
       <li><strong>Nikdy</strong> nepreskočiť úvodnú stránku</li>
       <li><strong>Prvý prístup</strong> preskočiť úvodnú stránku iba prvý raz</li>
       <li><strong>Vždy</strong> preskočiť úvodnú stránku</li>
   </ul>';
$string['slashargs'] = 'UPOZORNENIE: slash (lomítkové) argumenty nie sú na tomto portáli povolené a objekty nemusia fungovať tak, ako očakávate.';
$string['stagesize'] = 'Veľkosť okna/rámca';
$string['stagesize_help'] = '<p>Tieto dve nastavenia definujú výšku a šírku okna/rámca vzdelávacieho objektu.</p>';
$string['started'] = 'Začaté dňa';
$string['status'] = 'Stav';
$string['statusbar'] = 'Ukazovať stavový riadok';
$string['student_response'] = 'Odpoveď';
$string['suspended'] = 'Pozastavené';
$string['syntax'] = 'Chyba v syntaxi';
$string['tag_error'] = 'Neznámy tag ({$a->tag}) v tomto obsahu: {$a->value}';
$string['time'] = 'Čas';
$string['title'] = 'Názov';
$string['toc'] = 'TOC';
$string['toolbar'] = 'Ukazovať lištu s ovládacími tlačidlami';
$string['too_many_attributes'] = 'Tag {$a->tag} má príliš mnoho atribútov';
$string['too_many_children'] = 'Tag {$a->tag} má príliš mnoho potomkov';
$string['totaltime'] = 'Čas';
$string['trackingloose'] = 'UPOZORNENIE: Údaje o priechode týmto SCORM balíkom budú stratené!';
$string['type'] = 'Typ';
$string['typeexternal'] = 'Externý SCORM manifest';
$string['typelocal'] = 'Vložený balíček';
$string['typelocalsync'] = 'Stiahnutý balíček';
$string['unziperror'] = 'Počas rozbaľovania balíka sa vyskytla chyba';
$string['updatefreq'] = 'Frekvencia auto-obnovovania';
$string['updatefreqdesc'] = 'Táto predvoľba je pre východzie nastavenie automatickej aktualizácie aktivity';
$string['validateascorm'] = 'Overiť SCORM balík';
$string['validation'] = 'Výsledok overovania';
$string['validationtype'] = 'Táto vlastnosť nastavuje knižnicu DOMXML, ktorá bude použitá pri overovaní manifestu SCORM. Ak neviete, čo zvoliť, nechajte tu vybratú voľbu.';
$string['value'] = 'Hodnota';
$string['versionwarning'] = 'Verzia manifestu je staršia ako 1.3, upozornenie na tagu {$a->tag}';
$string['viewallreports'] = 'Zobraziť správy pre {$a} pokusov';
$string['viewalluserreports'] = 'Prezerať správy pre {$a} používateľov';
$string['whatgrade'] = 'Známkovanie pokusov';
$string['whatgradedesc'] = 'Táto predvoľba je pre východzie nastavenie hodnotenia pokusov';
$string['whatgrade_help'] = '<p>Ak povolíte účastníkom viacero pokusov, môžete si vybrať, ako sa použijú ich výsledky v hodnotení.</p>';
$string['width'] = 'Šírka';
$string['window'] = 'Okno';
