<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Pridať novú rolu';
$string['addrole'] = 'Pridať novú rolu';
$string['advancedoverride'] = 'Pokročilé prepísanie roly';
$string['allow'] = 'Povoliť';
$string['allowassign'] = 'Povoliť priradenia rol';
$string['allowed'] = 'Povolené';
$string['allowoverride'] = 'Povoliť prepísanie rol';
$string['allowroletoassign'] = 'Povoliť používateľom z rolou {$a->fromrole} priradiť rolu {$a->targetrole}';
$string['allowroletooverride'] = 'Povoliť používateľom z rolou {$a->fromrole} prepísať rolu {$a->targetrole}';
$string['allowroletoswitch'] = 'Povoliť používateľom z rolou {$a->fromrole} sa prepnúť do roly {$a->targetrole}';
$string['allowswitch'] = 'Povoliť prepnutie rol';
$string['allsiteusers'] = 'Všetci používatelia na portáli';
$string['archetype'] = 'Originál roly';
$string['archetypecoursecreator'] = 'ORIGINÁL: Tvorca kurzov';
$string['archetypeeditingteacher'] = 'ORIGINÁL: Učiteľ s právom úprav';
$string['archetypefrontpage'] = 'ORIGINÁL: Prihlásený používateľ';
$string['archetypeguest'] = 'ORIGINÁL: Hosť';
$string['archetype_help'] = 'Originál roly určuje oprávnenia, ktoré budú nastavené, ak je rola vrátená do pôvodného stavu. Tiež určuje nové oprávnenia v role, keď je portál aktualizovaný.';
$string['archetypemanager'] = 'ORIGINÁL: Manažér';
$string['archetypestudent'] = 'ORIGINÁL: Študent';
$string['archetypeteacher'] = 'ORIGINÁL: Učiteľ bez práv úprav';
$string['archetypeuser'] = 'ORIGINÁL: Prihlásený používateľ';
$string['assignanotherrole'] = 'Priradiť inú rolu';
$string['assignedroles'] = 'Priradené roly';
$string['assignerror'] = 'Chyba pri priradení roly {$a->role} používateľovi {$a->user}.';
$string['assignglobalroles'] = 'Priradiť systémové roly';
$string['assignmentcontext'] = 'Kontext priradenia';
$string['assignmentoptions'] = 'Možnosti priradenia';
$string['assignrole'] = 'Priradiť rolu';
$string['assignrolenameincontext'] = 'Priradiť rolu \'{$a->role}\' v kontexte {$a->context}';
$string['assignroles'] = 'Priradiť roly';
$string['assignroles_help'] = '<p>
Ak pridelíte používateľovi v určitom kontexte určitú
rolu, prideľujete mu oprávnenia obsiahnuté v tejto
role pre aktuálny kontext a všetky podradené
kontexty.
</p>

<p>
Kontexty:
</p>
<ol>
<li>Portál (celá inštalácia)</li>
<li>Úvodná stránka (kurz portálu)</li>
<li>Kategórie kurzov</li>
<li>Podkategórie kurzov</li>
<li>Kurzy</li>
<li>Bloky a aktivity</li>
</ol>

<p>
Ak teda napr. pridelíte rolu Študent používateľovi v kurze, bude mať
túto rolu pre daný kurz, ale tiež pre všetky bloky a činnosti vo
vnútri kurzu.  Skutočné oprávnenia používateľa pritom môžu závisieť ešte
na ďalších rolách a použitých nastaveniach.
</p>

<p>
Viď tiež
<a href="help.php?file=roles.html">Roly</a>,
<a href="help.php?file=contexts.html">Kontexty</a>,
<a href="help.php?file=permissions.html">Oprávnenia</a> a
<a href="help.php?file=overrides.html">Prepísať roly</a>.
</p>';
$string['assignrolesin'] = 'Priradiť roly v {$a}';
$string['assignrolesrelativetothisuser'] = 'Priradiť roly relatívne k tomuto používateľovi';
$string['backtoallroles'] = 'Návrat k zoznamu všetkých rol';
$string['backup:anonymise'] = 'Odstrániť osobné údaje používateľov pri zálohovaní';
$string['backup:backupactivity'] = 'Zálohovať aktivity';
$string['backup:backupcourse'] = 'Zálohovať kurzy';
$string['backup:backupsection'] = 'Zálohovať sekcie';
$string['backup:backuptargethub'] = 'Zálohovanie pre hub';
$string['backup:backuptargetimport'] = 'Zálohovanie pre import';
$string['backup:configure'] = 'Konfigurovať možnosti zálohovania';
$string['backup:downloadfile'] = 'Stiahnuť súbory z priečinku záloh';
$string['backup:userinfo'] = 'Zálohovať používateľské údaje';
$string['block:edit'] = 'Upraviť nastavenia bloku';
$string['block:view'] = 'Vidieť blok';
$string['blog:associatecourse'] = 'Priradiť položky blogov ku kurzom';
$string['blog:associatemodule'] = 'Priradiť položky blogov k aktivitám';
$string['blog:create'] = 'Vytvoriť nové položky blogu';
$string['blog:manageentries'] = 'Upravovať a spravovať položky';
$string['blog:manageexternal'] = 'Upraviť a spravovať externé blogy';
$string['blog:manageofficialtags'] = 'Spravovať oficiálne tagy';
$string['blog:managepersonaltags'] = 'Spravovať osobné tagy';
$string['blog:search'] = 'Vyhľadávať v položkách blogov';
$string['blog:view'] = 'Prezerať položky blogu';
$string['blog:viewdrafts'] = 'Prezerať pracovné verzie blogov';
$string['calendar:manageentries'] = 'Spravovať ľubovoľné položky kalendára';
$string['calendar:managegroupentries'] = 'Spravovať skupinové položky kalendára';
$string['calendar:manageownentries'] = 'Spravovať svoje položky kalendára';
$string['capabilities'] = 'Schopnosti';
$string['capability'] = 'Schopnosť';
$string['category:create'] = 'Vytvoriť kategórie';
$string['category:delete'] = 'Vymazať kategórie';
$string['category:manage'] = 'Spravovať kategórie';
$string['category:update'] = 'Aktualizovať kategórie';
$string['category:viewhiddencategories'] = 'Vidieť skryté kategórie';
$string['category:visibility'] = 'Prezerať skryté kategórie';
$string['checkglobalpermissions'] = 'Skontrolovať oprávnenia systému';
$string['checkpermissions'] = 'Skontrolovať oprávnenia';
$string['checkpermissionsin'] = 'Skontrolovať oprávnenia v {$a}';
$string['checksystempermissionsfor'] = 'Skontrolovať oprávnenia pre {$a->fullname}';
$string['checkuserspermissionshere'] = 'Skontrolovať oprávnenia pre {$a->fullname}, ktoré má v tomto kontexte: {$a->contextlevel}';
$string['chooseroletoassign'] = 'Prosím vyberte rolu na priradenie';
$string['cohort:assign'] = 'Pridať a odstrániť členov globálnej skupiny';
$string['cohort:manage'] = 'Vytvoriť, vymazať a presúvať členov globálnej skupiny';
$string['cohort:view'] = 'Prezerať globálne skupiny na portáli';
$string['comment:delete'] = 'Vymazať poznámky';
$string['comment:post'] = 'Publikovať poznámky';
$string['comment:view'] = 'Čítať poznámky';
$string['community:add'] = 'Používať komunitný blok pre vyhľadávanie hub serverov a ich kurzov';
$string['community:download'] = 'Stiahnuť kurz z komunitného bloku';
$string['confirmaddadmin'] = 'Naozaj chcete pridať používateľa <strong>{$a}</strong> ako nového administrátora portálu?';
$string['confirmdeladmin'] = 'Naozaj chcete ostrániť používateľa <strong>{$a}</strong> zo zoznamu administrátorov portálu?';
$string['confirmroleprevent'] = 'Naozaj chcete	odstrániť rolu <strong>{$a->role}</strong> zo zoznamu povolených rol so schopnosťou {$a->cap} v kontexte {$a->context}?';
$string['confirmroleunprohibit'] = 'Naozaj chcete odstrániť rolu <strong>{$a->role}</strong> zo zoznamu zakázaných rol so schopnosťou {$a->cap} v kontexte {$a->context}?';
$string['confirmunassign'] = 'Naozaj chcete odstrániť túto rolu pre daného používateľa?';
$string['confirmunassignno'] = 'Zrušiť';
$string['confirmunassigntitle'] = 'Potvrdiť zmenu roly';
$string['confirmunassignyes'] = 'Odstrániť';
$string['context'] = 'Kontext';
$string['course:activityvisibility'] = 'Skryť/zobraziť aktivity';
$string['course:bulkmessaging'] = 'Poslať správu viacerým účastníkom';
$string['course:changecategory'] = 'Zmeniť kategóriu kurzu';
$string['course:changefullname'] = 'Zmeniť celé meno kurzu';
$string['course:changeidnumber'] = 'Zmeniť identifikátor kurzu';
$string['course:changeshortname'] = 'Zmeniť skrátené meno kurzu';
$string['course:changesummary'] = 'Zmeniť sumár kurzu';
$string['course:create'] = 'Vytvoriť kurzy';
$string['course:delete'] = 'Vymazať kurzy';
$string['course:enrolconfig'] = 'Konfigurovať spôsoby zápisu v kurzoch';
$string['course:enrolreview'] = 'Preskúmať zápisy do kurzov';
$string['course:manageactivities'] = 'Spravovať aktivity';
$string['course:managefiles'] = 'Spravovať súbory';
$string['course:managegrades'] = 'Spravovať známky';
$string['course:managegroups'] = 'Spravovať skupiny';
$string['course:managescales'] = 'Spravovať stupnice';
$string['course:markcomplete'] = 'Manuálne označovať absolvovanie kurzu';
$string['course:publish'] = 'Publikovať kurz na hube';
$string['course:request'] = 'Žiadať nové kurzy';
$string['course:reset'] = 'Resetovať kurz';
$string['course:sectionvisibility'] = 'Riadiť viditeľnosť sekcií';
$string['course:setcurrentsection'] = 'Nastaviť súčasnú sekciu';
$string['course:update'] = 'Aktualizovať nastavenia kurzu';
$string['course:useremail'] = 'Povoliť/zakázať mailové adresy';
$string['course:view'] = 'Prezerať kurzy bez účasti v nich';
$string['course:viewcoursegrades'] = 'Prezerať známky';
$string['course:viewhiddenactivities'] = 'Prezerať skryté aktivity';
$string['course:viewhiddencourses'] = 'Prezerať skryté kurzy';
$string['course:viewhiddensections'] = 'Prezerať skryté sekcie';
$string['course:viewhiddenuserfields'] = 'Prezerať skryté užívateľské polia';
$string['course:viewparticipants'] = 'Prezerať účastníkov kurzov';
$string['course:viewscales'] = 'Prezerať stupnice';
$string['course:visibility'] = 'Skryť/ukázať kurzy';
$string['createrolebycopying'] = 'Vytvoriť novú rolu kopírovaním {$a}';
$string['createthisrole'] = 'Vytvoriť túto rolu';
$string['currentcontext'] = 'Súčasný kontext';
$string['currentrole'] = 'Súčasná rola';
$string['defaultrole'] = 'Štandardná rola';
$string['defaultx'] = 'Východzí: {$a}';
$string['defineroles'] = 'Definovať roly';
$string['deletecourseoverrides'] = 'Vymazať všetky prestavenia rol v kurze';
$string['deletelocalroles'] = 'Vymazať všetky lokálne priradenia rol';
$string['deleterolesure'] = 'Naozaj chcete vymazať rolu "{$a->name} ({$a->shortname})"?</p><p>V súčasnosti je táto rola priradená {$a->count} používateľom.';
$string['deletexrole'] = 'Vymazať {$a} rolu';
$string['duplicaterole'] = 'Duplikovať rolu';
$string['duplicaterolesure'] = 'Naozaj chcete duplikovať rolu "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Upravovanie roly \'{$a}\' ';
$string['editrole'] = 'Upraviť rolu';
$string['editxrole'] = 'Upraviť rolu {$a} ';
$string['errorbadrolename'] = 'Nesprávny názov roly';
$string['errorbadroleshortname'] = 'Nesprávny krátky názov roly';
$string['errorexistsrolename'] = 'Názov roly už existuje';
$string['errorexistsroleshortname'] = 'Názov roly už existuje';
$string['existingadmins'] = 'Súčasní administrátori portálu';
$string['existingusers'] = '{$a} existujúcich používateľov';
$string['explanation'] = 'Vysvetlenie';
$string['extusers'] = 'Existujúci používatelia';
$string['extusersmatching'] = 'Existujúci používatelia zhodujúci sa \'{$a}\'';
$string['filter:manage'] = 'Spravovať nastavenia lokálnych filtrov';
$string['frontpageuser'] = 'Prihlásený používateľ na titulnej stránke';
$string['frontpageuserdescription'] = 'Všetci prihlásení používatelia v kurze na titulnej stránke';
$string['globalrole'] = 'Systémová rola';
$string['globalroleswarning'] = 'Upozornenie! Všetky roly, ktoré pridelíte na tejto stránke, budú platné všade včítane titulnej stránky a všetkých kurzov.';
$string['gotoassignroles'] = 'Ísť na Priradiť roly pre tento kontext {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Ísť na Priradiť systémové roly';
$string['grade:edit'] = 'Upraviť známky';
$string['grade:export'] = 'Exportovať známky';
$string['grade:hide'] = 'Skryť/odkryť známky alebo položky';
$string['grade:import'] = 'Importovať známky';
$string['grade:lock'] = 'Zamknúť známky alebo položky';
$string['grade:manage'] = 'Spravovať položky známok';
$string['grade:manageletters'] = 'Spravovať písmená známok';
$string['grade:manageoutcomes'] = 'Spravovať ciele hodnotenia';
$string['grade:managesharedforms'] = 'Správa šablón pokročilého hodnotenia';
$string['grade:override'] = 'Prepísať známky';
$string['grade:sharegradingforms'] = 'Zdieľanie pokročilého hodnotenia ako šablóny';
$string['grade:unlock'] = 'Odomknúť známky alebo položky';
$string['grade:view'] = 'Vidieť vlastné známky';
$string['grade:viewall'] = 'Vidieť známky ostatných používateľov';
$string['grade:viewhidden'] = 'Vidieť skryté známky pre vlastníka';
$string['hidden'] = 'Skrytý';
$string['inactiveformorethan'] = 'neaktívny pre viac ako {$a->timeperiod}';
$string['ingroup'] = 'v skupine "{$a->group}"';
$string['inherit'] = 'Zdediť';
$string['legacy:admin'] = 'PÔVODNÁ ROLA: Administrátor';
$string['legacy:coursecreator'] = 'PÔVODNÁ ROLA: Tvorca kurzov';
$string['legacy:editingteacher'] = 'PÔVODNÁ ROLA: Učiteľ';
$string['legacy:guest'] = 'PÔVODNÁ ROLA: Hosť';
$string['legacy:student'] = 'PÔVODNÁ ROLA: Študent';
$string['legacy:teacher'] = 'PÔVODNÁ ROLA: Učiteľ (bez úprav)';
$string['legacytype'] = 'typ pôvodnej roly';
$string['legacy:user'] = 'PÔVODNÁ ROLA: Overený používateľ';
$string['listallroles'] = 'Zobraziť všetky roly';
$string['localroles'] = 'Lokálne priradené roly';
$string['manageadmins'] = 'Spravovať administrátorov portálu';
$string['manager'] = 'Manažér';
$string['managerdescription'] = 'Manažéri majú prístup do kurzov, môžu ich upravovať, ale vo všeobecnosti sa ich nezúčastňujú.';
$string['manageroles'] = 'Spravovať roly';
$string['maybeassignedin'] = 'Typy kontextov, kde môže byť táto rola priradená';
$string['morethan'] = 'Viac ako {$a}';
$string['multipleroles'] = 'Viacnásobné roly';
$string['my:configsyspages'] = 'Konfigurovať systémové šablóny pre stránky Môj Moodle';
$string['my:manageblocks'] = 'Administrovať bloky stránky Môj Moodle';
$string['neededroles'] = 'Roly s oprávnením';
$string['nocapabilitiesincontext'] = 'V tomto kontexte nie sú dostupné žiadne schopnosti';
$string['noneinthisx'] = 'Nič v tomto {$a}';
$string['noneinthisxmatching'] = 'Žiadni používatelia sa nezhodujú s \'{$a->search}\' v kontexte {$a->contexttype}';
$string['noroleassignments'] = 'Tento používateľ nemá žiadne priradenia rol nikde na portáli.';
$string['noroles'] = 'Žiadne roly';
$string['notabletoassignroleshere'] = 'Na tomto mieste nemáte oprávnenie priradiť žiadne roly';
$string['notabletooverrideroleshere'] = 'Na tomto mieste nemáte oprávnenie prepísať žiadne oprávnenia';
$string['notes:manage'] = 'Spravovať poznámky';
$string['notes:view'] = 'Vidieť poznámky';
$string['notset'] = 'Nenastavené';
$string['overrideanotherrole'] = 'Prepísať inú rolu';
$string['overridecontext'] = 'Prestaviť kontext';
$string['overridepermissions'] = 'Prestaviť oprávnenia';
$string['overridepermissionsforrole'] = 'Prestaviť oprávnenia pre rolu \'{$a->role}\' v kontexte {$a->context}';
$string['overridepermissions_help'] = '<p> Prepísanie rol slúži k&nbsp;jemnému vyladeniu rol
    v&nbsp;danom kontexte tak, aby odpovedali vašim požiadavkám.
</p>

<p> Príklad: Používatelia s&nbsp;rolou Študent môžu vo vašom
    kurze začínať nové diskusie v&nbsp;diskusných fórach,
    v&nbsp;jednom konkrétnom fóre by ste im však chceli túto
    možnosť odobrať. Potom stačí u daného fóra prepísať oprávnenie,
    tj. v&nbsp;role Študent u oprávnenia "Začínať novú diskusiu"
    nastaviť oprávnenie na hodnotu Zabrániť.
</p>

<p> Prepísanie možno tiež použiť k&nbsp;"otvoreniu" vybraných
    oblastí vašich stránok či kurzov, t.j. k prideleniu
    zvláštnych oprávnení tam, kde to dáva zmysel. Napríklad
    ak chcete dát študentom možnosť hodnotiť vypracovanie
    niektorého zadania.
</p>

<p> Používateľské rozhranie je podobné ako pre definovanie
    rol, s&nbsp;tou výnimkou, že niekedy sú zobrazené
    iba aktuálne použiteľné schopnosti. U nektorých oprávnení
    je ďalej zvýraznením naznačené, aké oprávnenia sa pre
    danou rolu použijú BEZ prepísania (tj. ak
    by ste oprávnenie nastavili na hodnotu NENASTAVENÉ).
</p>

<p>
Pozri tiež
<a href="help.php?file=roles.html">Roly</a>,
<a href="help.php?file=contexts.html">Kontexty</a>,
<a href="help.php?file=assignroles.html">Prideľovanie rol</a> a
<a href="help.php?file=permissions.html">Oprávnenia</a>.
</p>';
$string['overridepermissionsin'] = 'Prestaviť oprávnenia v {$a}';
$string['overrideroles'] = 'Prepísať roly';
$string['overriderolesin'] = 'Prepísať roly v {$a}';
$string['overrides'] = 'Prepísať';
$string['permission'] = 'Oprávenie';
$string['permission_help'] = '<p>
Oprávnenia sú nastavenia, ktorými možno riadiť prideľovanie dopredu
definovaných schopností.
</p>

<p>
Jednou z týchto schopností je napr. "Začínať novú diskusiu" (vo fórach).
</p>

<p>
V rámci každej roly môžete pre danú schopnosť vybrať jednu zo štyroch nasledujúcich hodnôt oprávnení:
<dl>
<dt>ZDEDIŤ</dt>
<dd>Obvykle ide o východzie nastavenie. Je to nastavenie neutrálne a
    znamená "použi oprávnenia, ktoré používateľ už má". Ak je niekomu
    pridelená rola (napr. v&nbsp;kurze) a pre niektorú z&nbsp;jej
    schopností je použité toto nastavenie, budú pri tejto schopnosti
    použité oprávnenia, ktoré boli používateľovi pridelené
    v&nbsp;nadradených kontextoch (napr. v&nbsp;kategóriách kurzov
    alebo na úrovni systému). Ak nie je používateľovi povolené
    schopnosť používať v&nbsp;žiadnom nadradenom kontexte, nebude
    príslušnou schopnosťou disponovať.
    </dd>

<dt>POVOLIŤ</dt>
<dd>Výberom tejto hodnoty priznávate danú schopnosť všetkým používateľom,
    ktorým je priradená rola obsahujúca toto nastavenie. Oprávnenie
    platí v&nbsp;kontexte, v&nbsp;ktorom bola rola priradená a ďalej
    vo všetkých "nižších" kontextoch. Ak ide napr. o rolu študenta
    priradenou v kurze, budú študenti môcť "začínať novú diskusiu"
    v&nbsp;ľubovoľnom fóre daného kurzu s&nbsp;výnimkou tých, u
    ktorých boli oprávnenia pre túto schopnosť prepísané na hodnotu
    Zabrániť alebo Zakázať.</dd>

<dt>ZABRÁNIŤ</dt>
<dd>Touto voľbou odoberáte používateľovi danú schopnosť, a to aj v prípade,
    že ju mal vo vyššom kontexte povolenú.</dd>

<dt>ZAKÁZAŤ</dt>
<dd>Toto nastavenie nie je treba často, niekedy je však výhodné odobrať
    niektorej roli oprávnenia s&nbsp;tým, že ich v&nbsp;žiadnom nižšom kontexte
    nebude možné prepísať. Dobrým príkladom je situácia, keď chce
    administrátor konkrétnemu používateľovi celkom odobrať možnosť začať novú
    diskusiu na celom portáli. Môže v&nbsp;takom prípade vytvoriť rolu,
    v&nbsp;ktorej bude u schopnosti "Začínať novú diskusiu" nastavená hodnota
    "Zakázať" a takúto rolu prideliť vybranému používateľovi v&nbsp;najvyššom
    kontexte stránok (systému).</dd>

</dl>
</p>


<p> Oprávnenia nastavené v "nižšom" kontexte majú obvykle prednosť
    pred oprávneniami preberanými z "vyšších" kontextov (platí pre
    prepísanie rol a pre priradenie rol). Výnimkou je hodnota
    ZAKÁZAŤ, ktorú nemožno v nižších kontextoch prepísať.
</p>

<p> Ak sú používateľovi v&nbsp;rovnakom kontexte pridelené dve roly,
    v&nbsp;ktorých je u rovnakej schopnosti nastavené jedenkrát POVOLIŤ a
    druhýkrát ZAKÁZAŤ, ktoré oprávnenie sa použije? V&nbsp;takomto prípade
    sa Moodle pokúsi v&nbsp;kontextovom strome nájsť "rozhodcu".
</p>

<p> Príklad: Študent má v kurze dve roly. Jedna mu umožňuje začínať
    nové diskusie, druhá nie. V tomto prípade Moodle preverí, či
    sa v&nbsp;kontexte kategórií kurzov alebo v&nbsp;kontexte portálu
    nachádzajú iné nastavenia oprávnení, ktoré by nám pomohli konflikt
    rozhodnúť. Ak sa žiadne také oprávnenia nenájdu, použije sa
    oprávnenie ZABRÁNIŤ (konfliktné nastavenia sa vzájomne vyrušia a
    výsledkom je neprítomnosť oprávnenia).
</p>


<p> Účet hosťa vo všeobecnosti nemôže vkladať a meniť obsah (napr. vo fórach,
    v&nbsp;kalendári, v&nbsp;blogu) a to aj v&nbsp;prípade, že mu je
    táto schopnosť pridelená.
</p>

<p>
Viď tiež
<a href="help.php?file=roles.html">Roly</a>,
<a href="help.php?file=contexts.html">Kontexty</a>,
<a href="help.php?file=assignroles.html">Priradiť roly</a> a
<a href="help.php?file=overrides.html">Prepísať roly</a>.
</p>';
$string['permissions'] = 'Oprávnenia';
$string['permissionsforuser'] = 'Oprávnenia pre používateľa {$a}';
$string['permissionsincontext'] = 'Oprávnenia v {$a}';
$string['portfolio:export'] = 'Exportovať do portfólií';
$string['potentialusers'] = '{$a} potenciálnych používateľov';
$string['potusers'] = 'Potenciálni používatelia';
$string['potusersmatching'] = 'Potenciálni používatelia zhodujúci sa s \'{$a}\'';
$string['prevent'] = 'Zabrániť';
$string['prohibit'] = 'Zakázať';
$string['prohibitedroles'] = 'Zakázaný';
$string['question:add'] = 'Pridať nové otázky';
$string['question:config'] = 'Konfigurovať typy otázok';
$string['question:editall'] = 'Upraviť všetky otázky';
$string['question:editmine'] = 'Upraviť vlastné otázky';
$string['question:flag'] = 'Označiť otázky počas pokusu';
$string['question:managecategory'] = 'Upravovať kategórie otázok';
$string['question:moveall'] = 'Presunúť všetky otázky';
$string['question:movemine'] = 'Presunúť vlastné otázky';
$string['question:useall'] = 'Použiť všetky otázky';
$string['question:usemine'] = 'Použiť vlastné otázky';
$string['question:viewall'] = 'Prezrieť všetky otázky';
$string['question:viewmine'] = 'Prezrieť vlastné otázky';
$string['rating:rate'] = 'Pridať hodnotenia položkám';
$string['rating:view'] = 'Zobraziť celkové hodnotenie, ktoré ste dostali';
$string['rating:viewall'] = 'Vidieť všetky hodnotenia vložené jednotlivcami';
$string['rating:viewany'] = 'Vidieť celkové hodnotenia, ktoré každý dostal';
$string['resetrole'] = 'Resetovať na východzie hodnoty';
$string['restore:configure'] = 'Konfigurovať možnosti obnovy';
$string['restore:createuser'] = 'Vytvoriť používateľov pri obnove kurzu';
$string['restore:restoreactivity'] = 'Obnoviť aktivity';
$string['restore:restorecourse'] = 'Obnoviť kurzy';
$string['restore:restoresection'] = 'Obnoviť sekcie';
$string['restore:restoretargethub'] = 'Obnoviť zo súborov označených ako hub';
$string['restore:restoretargetimport'] = 'Obnoviť zo súborov označených ako import';
$string['restore:rolldates'] = 'Povolenie zmeniť dátumy aktivít pri obnove kurzu';
$string['restore:uploadfile'] = 'Nahrať súbory z priestoru záloh';
$string['restore:userinfo'] = 'Obnoviť používateľské údaje';
$string['restore:viewautomatedfilearea'] = 'Obnoviť kurzy z automatických záloh';
$string['risks'] = 'Riziká';
$string['roleallowheader'] = 'Povoliť rolu:';
$string['roleallowinfo'] = 'Vybrať rolu na pridanie do zoznamu povolených rol v kontexte {$a->context}, schopnosť {$a->cap}:';
$string['role:assign'] = 'Priradiť roly používateľom';
$string['roleassignments'] = 'Priradenia rol';
$string['roledefinitions'] = 'Definície rol';
$string['rolefullname'] = 'Meno';
$string['role:manage'] = 'Vytvoriť a spravovať roly';
$string['role:override'] = 'Prepísať oprávnenia pre ostatných';
$string['roleprohibitheader'] = 'Zabrániť rolu';
$string['roleprohibitinfo'] = 'Vybrať rolu na pridanie do zoznamu zabránených rol v kontexte {$a->context}, schopnosť {$a->cap}:';
$string['role:review'] = 'Skontrolovať oprávnenia pre ostatných';
$string['roles'] = 'Roly';
$string['role:safeoverride'] = 'Prepísať bezpečné oprávnenia pre ostatných';
$string['roleselect'] = 'Vybrať rolu';
$string['roles_help'] = '<p>
Rola je súbor oprávnení, ktorý je definovaný pre celý portál
a ktorý možno v&nbsp;konkrétnych kontextoch prideľovať konkrétnym používateľom.
</p>

<p>
Môžete mať napr. rolu nazvanú "Učiteľ ", ktorá je nastavená tak, aby
umožňovala učiteľom vykonávať niektoré akcie (a iné zasa nie). Akonáhle
je táto rola vytvorená, môžete ju niekomu prideliť v&nbsp;kurze – tým
dotyčného používateľa definujete pre daný kurz "Učiteľom". Rovnakú rolu
môžete vybranému používateľovi prideliť v&nbsp;určitej kategórii kurzov – tym
z&nbsp;neho vytvoríte "Učiteľa" všetkých kurzov obsiahnutých v&nbsp;danej kategórii;
alebo môžete túto rolu používateľovi prideliť iba v&nbsp;jednom diskusnom fóre
– tým mu poskytnete oprávnenia "Učiteľa" iba pre toto fórum.
</p>

<p>
Rola musí mať <strong>meno</strong>. Ak potrebujete rolu pomenovať vo viacerých
jazykoch, môžete použiť viacjazyčnú syntax Moodle: <pre>
  &lt;span lang="en_utf8"&gt;Teacher&lt;/span&gt;
  &lt;span lang="sk_utf8"&gt;Učiteľ&lt;/span&gt;
  </pre>Ak túto možnosť využijete, je nutné mať súčasne v&nbsp;nastavení
inštalácie aktivovanú voľbu "Použiť filtre na všetky reťazce [filterall]".
</p>

<p>
<strong>Krátky názov</strong> role je nutný k&nbsp;tomu, aby sa na vašu rolu mohli
odkazovať iné časti Moodle (napr. pri hromadnom vkladaní používateľov
z&nbsp;textového súboru alebo pri nastavení zápisu do kurzov prostredníctvom
zásuvných modulov).
</p>

<p>
<strong>Popis</strong> slúži k definícii role vašimi vlastnými slovami tak, aby
ostatní používatelia mali predstavu, k&nbsp;čomu je rola určená.
</p>

<p>
Viď tiež
<a href="help.php?file=contexts.html">Kontexty</a>,
<a href="help.php?file=permissions.html">Oprávnenia</a>,
<a href="help.php?file=assignroles.html">Priradiť roly</a> a
<a href="help.php?file=overrides.html">Prepísať roly</a>.
</p>';
$string['roleshortname'] = 'Skrátené meno';
$string['role:switchroles'] = 'Prepnúť na iné roly';
$string['roletoassign'] = 'Rola na priradenie';
$string['roletooverride'] = 'Rola na prepísanie';
$string['safeoverridenotice'] = 'Poznámka: schopnosti so zvýšeným rizikom sú zamknuté, pretože máte iba oprávnenie na zmenu bezpečných schopností.';
$string['selectanotheruser'] = 'Vybrať iného používateľa';
$string['selectauser'] = 'Vybrať používateľa';
$string['selectrole'] = 'Vybrať rolu';
$string['showallroles'] = 'Ukázať všetky roly';
$string['showthisuserspermissions'] = 'Ukázať oprávnenia pre tohto používateľa';
$string['site:accessallgroups'] = 'Prístup k všetkým skupinám';
$string['siteadministrators'] = 'Administrátori portálu';
$string['site:approvecourse'] = 'Odsúhlasiť vytvorenie kurzu';
$string['site:backup'] = 'Zálohovať kurzy';
$string['site:config'] = 'Zmeniť konfiguráciu portálu';
$string['site:doanything'] = 'Povoliť robiť všetko';
$string['site:doclinks'] = 'Ukázať odkazy k dokumentom mimo portálu';
$string['site:import'] = 'Importovať iné kurzy do kurzu';
$string['site:manageblocks'] = 'Spravovať bloky na stránke';
$string['site:mnetloginfromremote'] = 'Prihlásiť sa zo vzdialeného Moodle';
$string['site:mnetlogintoremote'] = 'Roamovať do vzdialeného Moodle';
$string['site:readallmessages'] = 'Čítať všetky správy na portáli';
$string['site:restore'] = 'Obnovovať kurzy';
$string['site:sendmessage'] = 'Posielať správy ľubovoľnému používateľovi';
$string['site:trustcontent'] = 'Dôverovať vloženému obsahu';
$string['site:uploadusers'] = 'Nahrať nových používateľov zo súboru';
$string['site:viewfullnames'] = 'Vždy vidieť plné mená používateľov';
$string['site:viewparticipants'] = 'Prezerať účastníkov';
$string['site:viewreports'] = 'Prezerať správy';
$string['tag:create'] = 'Vytvoriť nové tagy';
$string['tag:edit'] = 'Upraviť existujúce tagy';
$string['tag:editblocks'] = 'Upraviť bloky v stránkach tagov';
$string['tag:manage'] = 'Spravovať všetky tagy';
$string['thisusersroles'] = 'Priradenia rol tohto používateľa';
$string['unassignarole'] = 'Odobrať rolu {$a}';
$string['unassignconfirm'] = 'Naozaj chcete používateľovi "{$a->user}" odobrať rolu "{$a->role}" ?';
$string['unassignerror'] = 'Chyba pri odoberaní roly {$a->role} u používateľa {$a->user}.';
$string['user:changeownpassword'] = 'Zmeniť vlastné heslo';
$string['user:create'] = 'Vytvárať používateľov';
$string['user:delete'] = 'Vymazať používateľov';
$string['user:editmessageprofile'] = 'Upraviť profil správ používateľa';
$string['user:editownmessageprofile'] = 'Upraviť svoj profil správ používateľa';
$string['user:editownprofile'] = 'Upraviť vlastný používateľský profil';
$string['user:editprofile'] = 'Upraviť používateľký profil';
$string['user:loginas'] = 'Prihlásiť sa ako iní používatelia';
$string['user:manageblocks'] = 'Spravovať bloky na používateľskom profile iných používateľom';
$string['user:manageownblocks'] = 'Spravovať bloky na vlastnom používateľskom verejnom profile';
$string['user:manageownfiles'] = 'Spravovať súbory vo vlastných súkromných adresároch';
$string['user:managesyspages'] = 'Konfigurovať zobrazenie východzej stránky pre verejné profily používateľov';
$string['user:readuserblogs'] = 'Vidieť blogy používateľa';
$string['user:readuserposts'] = 'Vidieť diskusné príspevky používateľa';
$string['usersfrom'] = 'Používatelia z {$a}';
$string['usersfrommatching'] = 'Používatelia z {$a->contextname} vyhovujúci vyhľadávaniu  \'{$a->search}\'';
$string['usersinthisx'] = 'Používatelia v tomto {$a}';
$string['usersinthisxmatching'] = 'Používatelia z tohto kontextu {$a->contextname} vyhovujúci vyhľadávaniu  \'{$a->search}\'';
$string['userswithrole'] = 'Všetci používatelia s rolou';
$string['userswiththisrole'] = 'Používatelia s rolou';
$string['user:update'] = 'Aktualizovať používateľské profily';
$string['user:viewalldetails'] = 'Prezerať plnú informáciu o používateľovi';
$string['user:viewdetails'] = 'Prezerať používateľské profily';
$string['user:viewhiddendetails'] = 'Prezerať skryté detaily o používateľoch';
$string['user:viewuseractivitiesreport'] = 'Vidieť správy o aktivitách používateľa';
$string['user:viewusergrades'] = 'Prezerať známky používateľa';
$string['useshowadvancedtochange'] = 'Použiť \'Zobraziť pokročilé\' na zmenu';
$string['viewingdefinitionofrolex'] = 'Zobraziť definíciu roly \'{$a}\'';
$string['viewrole'] = 'Prezerať detaily roly';
$string['webservice:createtoken'] = 'Vytvoriť token web služby';
$string['whydoesuserhavecap'] = 'Prečo má {$a->fullname} schopnosť {$a->capability} v kontexte {$a->context}?';
$string['whydoesusernothavecap'] = 'Prečo nemá {$a->fullname} schopnosť {$a->capability} v kontexte {$a->context}?';
$string['xroleassignments'] = 'Priradenia rol používateľa {$a}';
$string['xuserswiththerole'] = 'Používatelia s rolou "{$a->role}"';
