<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Tento test si môžete pozrieť, ale v prípade reálneho spustenia testu by ste boli blokovaní, pretože:';
$string['action'] = 'Akcia';
$string['activityoverview'] = 'Máte jeden alebo viac nových testov (kliknite sem pre ich zobrazenie)';
$string['adaptive'] = 'Adaptívny režim';
$string['addaquestion'] = 'Pridať otázku ...';
$string['addarandomquestion'] = 'Pridať náhodnú otázku ...';
$string['addarandomquestion_help'] = 'Ak pridáte náhodnú otázku, vyberie sa z danej kategórie náhodne jedna otázka a vloží sa do testu. To znamená, že rozdielni študenti pravdepodobne dostanú rozdielne otázky. Ak test umožňuje viaceré pokusy, potom v každom z nich dostanú iný výber otázok.';
$string['adddescriptionlabel'] = 'Pridať opis/nadpis';
$string['addingquestion'] = 'Pridávanie otázky';
$string['addingquestions'] = 'V tejto časti stránky si vediete databázu vašich otázok. Aby bolo otázky možné udržať usporiadané a aby mohli byť použité v ľubovoľnom teste vo Vašom kurze, alebo dokonca aj inými kurzami, ak sa rozhodnete publikovať ich, sú uložené v kategóriách.<br /><br />
Keď vyberiete alebo vytvoríte kategóriu otázok, budete môcť tvoriť alebo meniť otázky. Môžete vybrať ktorúkoľvek z týchto otázok a pridať ju do Vášho testu na ostatných častiach tejto stránky.';
$string['addmoreoverallfeedbacks'] = 'Pridať ešte {N} polí so spätnou väzbou';
$string['addnewgroupoverride'] = 'Pridať prestavenie skupiny';
$string['addnewpagesafterselected'] = 'Pridať nové strany po vybraných otázkach';
$string['addnewquestionsqbank'] = 'Pridať otázky do kategórie {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Pridať prestavenie používateľa';
$string['addpagehere'] = 'Pridať sem stranu';
$string['addquestion'] = 'Pridať otázku';
$string['addquestions'] = 'Pridať otázky';
$string['addquestionstoquiz'] = 'Pridať otázky do testu';
$string['addrandom'] = 'Pridať {$a} náhodných otázok';
$string['addrandom1'] = 'Pridať';
$string['addrandom2'] = 'náhodné otázky';
$string['addrandomfromcategory'] = 'Pridať náhodné otázky z kategórie:';
$string['addrandomquestion'] = 'Pridať náhodnú otázku';
$string['addrandomquestiontoquiz'] = 'Pridať náhodnú otázku do testu {$a}';
$string['addselectedtoquiz'] = 'Vybrané pridať do testu';
$string['addtoquiz'] = 'Pridať do testu';
$string['affectedstudents'] = 'Ovplyvnený {$a}';
$string['aftereachquestion'] = 'Po pridaní každej otázky';
$string['afternquestions'] = 'Po pridaní {$a} otázok';
$string['age'] = 'vek';
$string['allattempts'] = 'Všetky pokusy';
$string['allinone'] = 'Neobmedzený';
$string['allowreview'] = 'Povoliť prehľad';
$string['alreadysubmitted'] = 'Je pravdepodobné že už ste sa pokúsili urobiť tento test';
$string['alternativeunits'] = 'Alternatívne jednotky';
$string['alwaysavailable'] = 'Vždy dostupné';
$string['analysisoptions'] = 'Možnosti analýzy';
$string['analysistitle'] = 'Tabuľka analýzy položiek';
$string['answer'] = 'Odpoveď';
$string['answered'] = 'Odpovedané';
$string['answerhowmany'] = 'Jedna, alebo viacero odpovedí?';
$string['answers'] = 'Riešenia';
$string['answersingleno'] = 'Povolené viacero odpovedí';
$string['answersingleyes'] = 'Iba jedna odpoveď';
$string['answertoolong'] = 'Odpoveď je veľmi dlhá po riadku {$a} (max. 255 znakov)';
$string['aon'] = 'Formát AON';
$string['areyousureremoveselected'] = 'Naozaj chcete vymazať všetky označené otázky?';
$string['asshownoneditscreen'] = 'Ako zobrazené na upravovacej stránke';
$string['attempt'] = 'Pokus {$a}';
$string['attemptalreadyclosed'] = 'Tento pokus už bol ukončený';
$string['attemptclosed'] = 'Pokus ešte nebol ukončený';
$string['attemptduration'] = 'Použitý čas';
$string['attemptedon'] = 'Test sa pokúsil robiť používateľ dňa';
$string['attempterror'] = 'Nemôžete sa teraz pokúsiť vypracovať tento test, pretože: {$a}';
$string['attemptfirst'] = 'Prvý pokus';
$string['attemptincomplete'] = 'Pokus používateľa {$a} nie je ešte ukončený';
$string['attemptlast'] = 'Posledný pokus';
$string['attemptnumber'] = 'Pokus';
$string['attemptquiznow'] = 'Pokúsiť sa urobiť test teraz';
$string['attempts'] = 'Pokusy';
$string['attemptsallowed'] = 'Povolený počet pokusov';
$string['attemptsdeleted'] = 'Vymazané pokusy';
$string['attemptselection'] = 'Vyberte, ktoré pokusy sa majú analyzovať u používateľa:';
$string['attemptsexist'] = 'Tento test sa už používatelia pokúsili urobiť';
$string['attemptsnum'] = 'Pokusy: {$a}';
$string['attemptsnumthisgroup'] = 'Pokusy: {$a->total} ({$a->group} z tejto skupiny)';
$string['attemptsnumyourgroups'] = 'Pokusy: {$a->total} ({$a->group} z vašich skupín)';
$string['attemptsonly'] = 'Ukázať iba študentov s pokusmi';
$string['attemptstate'] = 'Stav';
$string['attemptstillinprogress'] = 'Pokus stále prebieha';
$string['attemptsunlimited'] = 'Neobmedzené pokusy';
$string['autosaveperiod'] = 'Interval automatického ukladania';
$string['back'] = 'Späť na náhľad otázky';
$string['backtocourse'] = 'Späť do kurzu';
$string['backtoquestionlist'] = 'Späť k zoznamu úloh';
$string['backtoquiz'] = 'Späť na zapisovanie testu';
$string['basicideasofquiz'] = 'Základné myšlienky pre tvorbu testov';
$string['bestgrade'] = 'Najlepšia známka';
$string['bothattempts'] = 'Ukázať všetkých študentov';
$string['browsersecurity'] = 'Bezpečnosť prehliadača';
$string['calculated'] = 'Výpočtová';
$string['calculatedquestion'] = 'Otázka na výpočet nie je podporovaná na riadku {$a}. Táto otázka bude ignorovaná.';
$string['cannotcreatepath'] = 'Cestu nie je možné vytvoriť ({$a})';
$string['cannoteditafterattempts'] = 'Nemôžete pridať alebo odobrať otázky, pretože už test už bol niekým vypracovaný. ({$a})';
$string['cannotfindprevattempt'] = 'Nie je možné nájsť predchádzajúc pokus, na ktorom by sa dalo stavať.';
$string['cannotfindquestionregard'] = 'Nepodarilo sa získať otázky pre preznámkovanie!';
$string['cannotinsert'] = 'Nie je možné vložiť otázku';
$string['cannotinsertrandomquestion'] = 'Nebolo možné vložiť novú náhodnú otázku!';
$string['cannotloadquestion'] = 'Nebolo možné nahrať možnosti otázky';
$string['cannotloadtypeinfo'] = 'Nie je možné nahrať špecifické informácie daného typu otázky';
$string['cannotopen'] = 'Nie je možné otvoriť exportovaný súbor ({$a})';
$string['cannotrestore'] = 'Nebolo možné obnoviť sedenia otázok';
$string['cannotreviewopen'] = 'Nemôžete si prezerať tento pokus, ešte stále je otvorený';
$string['cannotsavelayout'] = 'Nepodarilo sa uložiť usporiadanie';
$string['cannotsavenumberofquestion'] = 'Nebolo možné uložiť počet otázok na strane';
$string['cannotsavequestion'] = 'Nie je možné uložiť zoznam otázok';
$string['cannotsetgrade'] = 'Nebolo možné nastaviť novú maximálnu známku za test';
$string['cannotsetsumgrades'] = 'Nepodarilo sa nastaviť celkové hodnotenie';
$string['cannotstartmissingquestion'] = 'Nie je možné spustiť pokus v teste. Definícia testu obsahuje úlohu, ktorá neexistuje.';
$string['cannotstartnoquestions'] = 'Nie je možné spustiť pokus v teste. Test ešte nebol nastavený a neobsahuje žiadne otázky.';
$string['cannotwrite'] = 'Nie je možné zapisovať do súboru pre export ({$a})';
$string['caseno'] = 'Nie, používanie veľkých a malých písmen nie je dôležité';
$string['casesensitive'] = 'Citlivosť na rozlišovanie veľkých a malých písmen';
$string['caseyes'] = 'Áno, veľké a malé písmená musia sedieť';
$string['categories'] = 'Kategórie';
$string['category'] = 'Kategória';
$string['categoryadded'] = 'Kategória \'{$a}\' bola pridaná';
$string['categorydeleted'] = 'Kategória \'{$a}\' bola odstránená';
$string['categorynoedit'] = 'Nemáte právo na úpravu kategórie \'{$a}\'';
$string['categoryupdated'] = 'Táto kategória bola úspešne aktualizovaná';
$string['close'] = 'Zavrieť okno';
$string['closebeforeopen'] = 'Aktualizácia testu nebola možná. Zvolili ste dátum ukončenia pred dátumom začatia.';
$string['closed'] = 'Uzavretý';
$string['closepreview'] = 'Zavrieť náhľad';
$string['closereview'] = 'Ukončiť revíziu';
$string['comment'] = 'Komentár';
$string['commentorgrade'] = 'Vložte komentár, alebo prepíšte body';
$string['comments'] = 'Komentáre';
$string['completedon'] = 'Ukončené dňa';
$string['configadaptive'] = 'Ak v tejto voľbe zvolíte Áno, potom bude môcť študent odpovedať na jednu otázku počas jedného testu aj viackrát.';
$string['configattemptsallowed'] = 'Obmedzenie na počet pokusov, koľkokrát môžu študenti absolvovať test.';
$string['configdecimaldigits'] = 'Počet desatinných číslic, ktorý má byť zobrazený pri hodnoteniach.';
$string['configdecimalplaces'] = 'Počet desatinných číslic, ktorý má byť zobrazený pri hodnoteniach testu.';
$string['configdecimalplacesquestion'] = 'Počet desatinných číslic, ktorý má byť zobrazený pri hodnoteniach jednotlivých otázok.';
$string['configdelay1'] = 'Ak nastavíte časové oneskorenie, potom bude študent po prvom pokuse musieť čakať tento čas.';
$string['configdelay1st2nd'] = 'Ak nastavíte časové oneskorenie, potom bude študent po ukončení prvého pokusu musieť čakať tento čas do začiatku druhého pokusu.';
$string['configdelay2'] = 'Ak nastavíte časové oneskorenie, potom bude študent pred tretím alebo neskorším pokusom musieť čakať tento čas.';
$string['configdelaylater'] = 'Ak nastavíte časové oneskorenie, potom bude študent nebude môcť spustiť svoj tretí, štvrtý, .. pokus, kým neuplynie tento čas od konca predošlého pokusu.';
$string['configeachattemptbuildsonthelast'] = 'Ak sú povolené viaceré pokusy, potom každý nasledujúci obsahuje výsledky predchádzajúceho pokusu.';
$string['configgrademethod'] = 'Ak sú povolené viaceré pokusy, je treba určiť spôsob, akým sa bude počítať výsledná známka študenta v tomto teste.';
$string['configintro'] = 'Hodnoty, ktoré tu nastavíte, definujú východzie hodnotu, ktoré sú potom používané vo formulári nového testu. Tiež môžete určiť, ktoré nastavenia sú chápané ako pokročilé.';
$string['configmaximumgrade'] = 'Východzia maximálna známka z testu.';
$string['configpenaltyscheme'] = 'Penalizácia odčítaná za každú nesprávnu odpoveď v prípade adaptívneho režimu.';
$string['configrequirepassword'] = 'Študenti musia zadať toto heslo predtým, ako sa môžu pokúsiť vykonať test.';
$string['configrequiresubnet'] = 'Študenti môžu vykonať test iba z týchto počítačov.';
$string['configshowblocks'] = 'Zobraziť bloky počas pokusu o test.';
$string['configshowuserpicture'] = 'Zobraziť obrázok používateľa na obrazovke počas pokusov.';
$string['configtimelimit'] = 'Východzí časový limit pre testy v minútach. 0 znamená bez obmedzenia.';
$string['configtimelimitsec'] = 'Východzí časový limit pre testy v sekundách. 0 znamená bez obmedzenia.';
$string['configurerandomquestion'] = 'Konfigurovať otázku';
$string['confirmclose'] = 'Práve sa chystáte ukončiť tento pokus. Ak ho teraz ukončíte, už nebudete mať možnosť zmeniť svoje odpovede.';
$string['confirmserverdelete'] = 'Naozaj chcete odstrániť server <b>{$a}</b> zo zoznamu?';
$string['confirmstartattemptlimit'] = 'Počet pokusov v tomto teste je obmedzený na {$a}. Práve chcete začať nový pokus. Chcete pokračovať?';
$string['confirmstartattempttimelimit'] = 'Tento test má nastavený časový limit a počet pokusov je obmedzený na {$a}. Práve chcete začať nový pokus. Chcete pokračovať?';
$string['confirmstarttimelimit'] = 'Tento test má nastavený časový limit. Naozaj chcete začať?';
$string['containercategorycreated'] = 'Táto kategória bola vytvorená na uchovanie všetkých pôvodných kategórií presunutých do úrovne stránky z dôvodov uvedených dolu.';
$string['continueattemptquiz'] = 'Pokračovať v poslednom pokuse';
$string['continuepreview'] = 'Pokračovať v poslednom prehľade';
$string['copyingfrom'] = 'Vytvára sa kópia otázky \'{$a}\'';
$string['copyingquestion'] = 'Kopíruje sa otázka';
$string['correct'] = 'Správny';
$string['correctanswer'] = 'Správna odpoveď';
$string['correctanswerformula'] = 'Vzorec správnej odpovede';
$string['correctansweris'] = 'Správna odpoveď: {$a}';
$string['correctanswerlength'] = 'Platné číslice';
$string['correctanswers'] = 'Správne odpovede';
$string['correctanswershows'] = 'U správnych odpovedí sa zobrazujú';
$string['corrresp'] = 'Správna odpoveď';
$string['countdown'] = 'Odpočítavanie';
$string['countdownfinished'] = 'Test sa uzatvára, teraz môžete zasielať svoje odpovede.';
$string['countdowntenminutes'] = 'Test sa uzavrie o 10 minút.';
$string['coursetestmanager'] = 'Formát Course Test  Manager';
$string['createcategoryandaddrandomquestion'] = 'Vytvoriť kategóriu a pridať náhodnú otázku';
$string['createfirst'] = 'Najprv musíte vytvoriť otázky s krátkou odpoveďou.';
$string['createmultiple'] = 'Vytvoriť viacero náhodných otázok do testu';
$string['createnewquestion'] = 'Vytvoriť novú otázku';
$string['createquestionandadd'] = 'Vytvoriť novú náhodnú otázku a vložiť ju do testu.';
$string['custom'] = 'Používateľský formát';
$string['dataitemneed'] = 'Pre vytvorenie platnej úlohy musíte vložiť najmenej jednu dátovú sadu.';
$string['datasetdefinitions'] = 'Znovu použiteľné definície nastavenia dát pre kategóriu {$a}';
$string['datasetnumber'] = 'Číslo';
$string['daysavailable'] = 'Dostupné dni, počas ktorých je možné urobiť test';
$string['decimaldigits'] = 'Desatinné čísla v známkach';
$string['decimalplaces'] = 'Desatinné miesta v známkach';
$string['decimalplaces_help'] = 'Použitím tohto nastavenia môžete zvoliť počet desatinných miest, ktoré sa zobrazia v bodovom skóre alebo známkach študentov. Toto nastavenie ovplyvňuje iba zobrazenie známok. Nemá vplyv na vnútorné výpočty a zaokrúhľovanie známok.';
$string['decimalplacesquestion'] = 'Desatinné miesta v hodnotení otázok';
$string['decimalplacesquestion_help'] = 'Toto nastavenie určuje počet číslic po desatinnej bodke pri zobrazení bodov pre jednotlivé otázky.';
$string['decimalpoints'] = 'Desatinné body';
$string['default'] = 'Východiskové nastavenie';
$string['defaultgrade'] = 'Prednastavená hodnota známky';
$string['defaultinfo'] = 'Nastavená kategória pre otázky.';
$string['delay1'] = 'Časové oneskorenie medzi prvým a druhým pokusom';
$string['delay1st2nd'] = 'Vynútiť časový odstup medzi 1. a 2. pokusom';
$string['delay1st2nd_help'] = 'Ak nastavíte časové oneskorenie, tak študent musí počkať predtým, než sa bude môcť pokúsiť o druhé splnenie testu.';
$string['delay2'] = 'Časové oneskorenie medzi ďalšími pokusmi';
$string['delaylater'] = 'Vynútiť časový odstup medzi ďalšími pokusmi';
$string['delaylater_help'] = 'Ak tu nastavíte časové oneskorenie, tak študent musí počkať
  pred tým, než sa bude môcť pokúsiť o tretie alebo ďalšie
  splnenie testu.';
$string['deleteattemptcheck'] = 'Naozaj chcete úplne vymazať všetky pokusy o urobenie testu?';
$string['deleteselected'] = 'Odstrániť vybraté';
$string['deletingquestionattempts'] = 'Vymazávanie pokusov otázky';
$string['description'] = 'Opis';
$string['disabled'] = 'Nepovolené';
$string['displayoptions'] = 'Nastavenia zobrazenia';
$string['donotuseautosave'] = 'Nepoužívať automatické ukladanie';
$string['download'] = 'Kliknite pre nahratie súboru s exportovanou kategóriou';
$string['downloadextra'] = '(súbory sú tiež uložené v súboroch kurzu v adresári /quiz)';
$string['duplicateresponse'] = 'Váš odoslaný test na vyhodnotenie bol ignorovaný, pretože ste už predtým zaslali rovnaké odpovede.';
$string['eachattemptbuildsonthelast'] = 'Každý pokus je postavený na minulom';
$string['eachattemptbuildsonthelast_help'] = '<p>Ak je povolené viac pokusov a toto nastavenie je nastavené
na <b>Áno</b>, potom každý nový pokus zahŕňa výsledok predchádzajúceho
pokusu. Toto umožňuje, aby bol test dokončený na viacero pokusov.</p>

<p>Ak chcete, aby bol študentovi pri každom pokuse ukázaný test bez
   odpovedí, zvoľte v nastaveniach <b>Nie</b> pre toto nastavenie.</p>';
$string['editcategories'] = 'Upraviť kategórie';
$string['editcategory'] = 'Upraviť kategóriu';
$string['editcatquestions'] = 'Upraviť kategórie otázok';
$string['editingquestion'] = 'Zapisovanie otázky';
$string['editingquiz'] = 'Zapisovanie testu';
$string['editingquizx'] = 'Úprava testu: {$a}';
$string['editoverride'] = 'Upraviť prestavenie';
$string['editqcats'] = 'Upraviť kategórie úloh';
$string['editquestions'] = 'Upraviť otázky';
$string['editquiz'] = 'Upraviť test';
$string['editquizquestions'] = 'Upraviť kategórie testov';
$string['emailconfirmbody'] = 'Dobrý deň {$a->username},

Ďakujeme za odoslanie odpovedí v teste
\'{$a->quizname}\'
v kurze \'{$a->coursename}\'
dňa {$a->submissiontime}.

Tento mail potvrdzuje, že Vaše odpovede boli zaznamenané v poriadku.

Test je dostupný na stránke {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Ďakujeme za odovzdanie odpovedí na test \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potvrdenie odoslania testu: {$a->quizname}';
$string['emailnotifybody'] = 'Dobrý deň {$a->username},

Študent {$a->studentname} odovzdal test
\'{$a->quizname}\' ({$a->quizurl})
v kurze \'{$a->coursename}\'.

Tieto výsledky sú dostupné na stránke {$a->quizreviewurl}.';
$string['emailnotifysmall'] = 'Študent {$a->studentname} ukončil test {$a->quizname}. Viac na {$a->quizreviewurl}';
$string['emailnotifysubject'] = 'Študent {$a->studentname} odovzdal test
{$a->quizname}';
$string['emailoverduesmall'] = 'Neodoslali ste pokus v teste {$a->quizname}. Ak ho chcete odoslať, prejdite na {$a->attemptsummaryurl} pred {$a->attemptgraceend}.';
$string['emailoverduesubject'] = 'Pokus je po časovom limite: {$a->quizname}';
$string['empty'] = 'Prázdny';
$string['enabled'] = 'Povolené';
$string['endtest'] = 'Ukončiť pokus ...';
$string['erroraccessingreport'] = 'Nemôžete sa dostať k tejto správe';
$string['errorinquestion'] = 'Chyba v otázke';
$string['errormissingquestion'] = 'Chyba: V systéme chýba otázka s id {$a}';
$string['errornotnumbers'] = 'Chyba - odpoveď musí byť číselného typu';
$string['errorunexpectedevent'] = 'Neočakávaná udalosť kód {$a->event} nájdená pre otázku {$a->questionid} v pokuse {$a->attemptid}.';
$string['essay'] = 'Esej';
$string['essayquestions'] = 'Zadanie';
$string['everynquestions'] = 'Každých {$a} otázok';
$string['everyquestion'] = 'Každá otázka';
$string['everythingon'] = 'Všetko';
$string['export'] = 'Export';
$string['exportcategory'] = 'exportovať kategóriu';
$string['exporterror'] = 'V priebehu exportu sa objavila chyba';
$string['exportingquestions'] = 'Otázky sa exportujú do súboru';
$string['exportname'] = 'Názov súboru';
$string['exportquestions'] = 'Exportovať otázky do súboru';
$string['extraattemptrestrictions'] = 'Extra obmedzenia na pokusy';
$string['false'] = 'Nie';
$string['feedback'] = 'Spätná väzba';
$string['feedbackerrorboundaryformat'] = 'Hranice hodnotenia musia byť alebo percentá alebo čísla. Hodnota, ktorú ste zadali (poloha {$a}) nie je správna.';
$string['feedbackerrorboundaryoutofrange'] = 'Hranice hodnotenia musia byť medzi 0% a 100%. Hodnota, ktorú ste zadali (poloha {$a}) je mimo rozsahu.';
$string['feedbackerrorjunkinboundary'] = 'Musíte zadať hranice hodnotenia tak, aby medzi nimi neboli medzery.';
$string['feedbackerrorjunkinfeedback'] = 'Musíte zadať spätné väzby tak, aby medzi nimi neboli medzery.';
$string['feedbackerrororder'] = 'Hranice hodnotenia musia byť zadávané v klesajúcom poradí. Hodnota, ktorú ste zadali (poloha {$a}) nie je v poradí.';
$string['file'] = 'Súbor';
$string['fileformat'] = 'Formát súboru';
$string['fillcorrect'] = 'Vyplňte správne';
$string['filloutnumericalanswer'] = 'Definujete aspoň jednu možnú odpoveď a toleranciu. Prvá zhodná odpoveď bude použitá na výpočet známky a spätnej väzby. Ak zadáte spätnú väzbu bez odpovede na úplný koniec, táto bude ukázaná v prípade, že študent zadal odpoveď, ktorá sa nezhoduje so zadanými.';
$string['filloutoneanswer'] = 'Musíte vyplniť aspoň jednu možnú odpoveď. Nevyplnené odpovede nebudú použité. Môžete použiť \'*\' ako divoký znak pre zhodu s ľubovoľnými znakmi. Prvá zhodná odpoveď bude použitá na určenie známky a spätnej väzby.';
$string['filloutthreequestions'] = 'Musíte vyplniť aspoň tri otázky. Nevyplnené otázky nebudú použité.';
$string['fillouttwochoices'] = 'Musíte uviesť aspoň dve možnosti. Nevyplnené možnosti nebudú použité.';
$string['finishattemptdots'] = 'Ukončiť pokus...';
$string['finishreview'] = 'Ukončiť prehľad';
$string['forceregeneration'] = 'obnova nastavení';
$string['formatnotfound'] = 'Nie je možné nájsť formát pre export/import: {$a}';
$string['formatnotimplemented'] = 'Tento formát nie je korektne implementovaný. Prosím, nahláste túto chybu vývojárom Moodle.';
$string['formulaerror'] = 'Chyby vo vzorci!';
$string['fractionsaddwrong'] = 'Kladné známky, ktoré ste uviedli nemajú súčet 100%

<br />ale ich súčet je {$a}%

<br />Chcete ísť späť a opraviť túto otázku?';
$string['fractionsnomax'] = 'Jedna z odpovedí musí byť 100%, aby bolo

<br />možné získať plný počet za túto otázku.

<br />Chcete ísť späť a opraviť túto otázku?';
$string['fromfile'] = 'zo súboru:';
$string['functiondisabledbysecuremode'] = 'Táto funkcia je v súčastnosti zablokovaná';
$string['generalfeedback'] = 'Všeobecná spätná väzba';
$string['generalfeedback_help'] = 'Celková spätná väzba je text, ktorý sa zobrazí študentovi po ukončení testu. Oproti spätnej väzbe, ktorá závisí na type otázky a na odpovedi študenta, text celkovej spätnej väzby je zobrazený všetkým študentom.';
$string['graceperiod'] = 'Termín pre odovzdanie';
$string['graceperiodmin'] = 'Posledný termín na odovzdanie';
$string['graceperiodtoosmall'] = 'Časový termín musí byť viac ako {$a}.';
$string['grade'] = 'Známka';
$string['gradeall'] = 'Oznámkovať všetko';
$string['gradeaverage'] = 'Priemerná známka';
$string['gradeboundary'] = 'Hranica hodnotenia';
$string['gradeessays'] = 'Oznámkovať eseje';
$string['gradehighest'] = 'Najvyššia známka';
$string['grademethod'] = 'Metóda známkovania';
$string['grademethod_help'] = '<p>Ak je povolené zodpovedanie otázok na viac pokusov, potom je aj
hodnotenie týchto odpovedí odstupňované. Toto má vplyv na výsledné
hodnotenie študenta.</p>

<h2>Najvyššia známka</h2>

<p>Toto hodnotenie odpovedá najvyššiemu stupňu v každom pokuse.</p>

<h2>Priemerná známka</h2>

<p>Je to priemerné hodnotenie zo všetkých pokusov.</p>

<h2>Prvý pokus</h2>

<p>Záverečné hodnotenie je vykonané na základe hodnotenia prvých
pokusov odpovedí (ostatné sú ignorované).</p>

<h2>Posledný pokus</h2>

<p>Celkové hodnotenie je vykonané na len základe posledne odoslaného
testu.</p>';
$string['gradesdeleted'] = 'Vymazané hodnotenia testu';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Známky za odoslaný test:
{$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'S predošlými trestnými bodmi je výsledok
<strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Za odoslanie odpovede vám bolo pridelených {$a} trestných bodov.';
$string['gradingdetailszeropenalty'] = 'Za odoslaný test Vám nebol pridelený žiaden trestný bod.';
$string['gradingmethod'] = 'Metóda hodnotenia: {$a}';
$string['groupoverrides'] = 'Skupinové prestavenia';
$string['groupsnone'] = 'V tomto kurze nie sú žiadne skupiny';
$string['guestsno'] = 'Prepáčte, hostia  si nemôžu prezerať alebo skúšať testy';
$string['hidebreaks'] = 'Skryť zlomy strany';
$string['hidereordertool'] = 'Skryť nástroj pre zmenu poradia';
$string['history'] = 'História odpovedí:';
$string['howquestionsbehave_desc'] = 'Východzie správanie otázok v teste.';
$string['imagedisplay'] = 'Obrázok  na znázornenie';
$string['import'] = 'Import';
$string['importcategory'] = 'importovať kategóriu';
$string['importerror'] = 'V priebehu importu sa objavila chyba';
$string['importfilearea'] = 'Importovať zo súboru v kurze';
$string['importfileupload'] = 'Importovať zo súboru na vašom počítači';
$string['importfromthisfile'] = 'Importovať z tohto súboru';
$string['importingquestions'] = 'Importujem {$a} úloh zo súboru';
$string['importmax10error'] = 'Chybná definícia úlohy: úloha nesmie obsahovať viac ako desať odpovedí.';
$string['importmaxerror'] = 'Chybná definícia úlohy: príliš mnoho odpovedí.';
$string['importquestions'] = 'Import otázok zo súboru';
$string['inactiveoverridehelp'] = '* Študent nie je v správnej skupine alebo nemá správnu rolu pre absolvovanie testu';
$string['incorrect'] = 'Nesprávny';
$string['indivresp'] = 'Odpovede jednotlivých používateľov na každú otázku';
$string['info'] = 'Informácia';
$string['infoshort'] = 'i';
$string['inprogress'] = 'Prebieha';
$string['introduction'] = 'Úvod';
$string['invalidattemptid'] = 'Pokus s týmto ID neexistuje';
$string['invalidcategory'] = 'ID kategórie je nesprávne';
$string['invalidnumericanswer'] = 'Jedna z odpovedí, ktorú ste zadali, nebola číslo.';
$string['invalidnumerictolerance'] = 'Jedna z tolerancií, ktorú ste zadali, nebola číslo.';
$string['invalidoverrideid'] = 'Neplatný identifikátor prestavenia';
$string['invalidquestionid'] = 'Nesprávny identifikátor otázky';
$string['invalidquizid'] = 'Nesprávny identifikátor testu';
$string['invalidsource'] = 'Tento zdroj nie je akceptovaný ako platný.';
$string['invalidsourcetype'] = 'Neplatný typ zdroja.';
$string['invalidstateid'] = 'Neplatné ID stavu';
$string['lastanswer'] = 'Vaša posledná odpoveď bola';
$string['layout'] = 'Usporiadanie';
$string['layoutasshown'] = 'Usporiadanie na strane ako zobrazené.';
$string['layoutasshownwithpages'] = 'Usporiadanie na strane ako zobrazené.<small>(Automatická nová strana každých {$a} otázok.)</small>';
$string['layoutshuffledandpaged'] = 'Náhodne zamiešané otázky, počet otázok na jednej strane: {$a}.';
$string['layoutshuffledsinglepage'] = 'Náhodne zamiešané otázky, všetky na jednej strane.';
$string['link'] = 'Odkaz';
$string['listitems'] = 'Zoznam otázok testu';
$string['literal'] = 'Písmeno';
$string['loadingquestionsfailed'] = 'Nepodarilo sa nahrať otázky: {$a}';
$string['makecopy'] = 'Ulož ako novú otázku';
$string['managetypes'] = 'Spravovať typy otázok a serverov';
$string['manualgrading'] = 'Známkovanie';
$string['mark'] = 'Odoslať';
$string['markall'] = 'Odoslať stránku';
$string['marks'] = 'Známky';
$string['marks_help'] = 'Známka za každú otázku a celkové skóre pokusu.';
$string['match'] = 'Zodpovedajúca';
$string['matchanswer'] = 'Zodpovedajúca odpoveď';
$string['matchanswerno'] = 'Zodpovedajúca odpoveď {$a}';
$string['max'] = 'Maximálny';
$string['messageprovider:attempt_overdue'] = 'Upozornenie na časový termín pre odovzdanie testu';
$string['messageprovider:confirmation'] = 'Potvrdenie odoslania testu';
$string['messageprovider:submission'] = 'Oznámenie o vypracovaní testu';
$string['min'] = 'Minimálny';
$string['minutes'] = 'Minúty';
$string['missingcorrectanswer'] = 'Musíte označiť  správnu odpoveď';
$string['missingitemtypename'] = 'Chýba názov';
$string['missingquestion'] = 'Zdá sa, že táto otázka už neexistuje';
$string['modulename'] = 'Test';
$string['modulenameplural'] = 'Testy';
$string['moveselectedonpage'] = 'Presunúť vybrané otázky na stranu: {$a}';
$string['multichoice'] = 'Viaceré možnosti';
$string['multipleanswers'] = 'Vyberte aspoň jednu odpoveď.';
$string['multiplier'] = 'Násobiteľ';
$string['mustbesubmittedby'] = 'Tento pokus musí byť odoslaný najneskôr: {$a}.';
$string['name'] = 'Meno';
$string['navmethod'] = 'Spôsob navigácie';
$string['navmethod_free'] = 'Voľná';
$string['navmethod_seq'] = 'Sekvenčná';
$string['navnojswarning'] = 'Upozornenie: tieto odkazy neuložia Vaše odpovede. Použite tlačidlo Ďalší na spodku strany.';
$string['neverallononepage'] = 'Nikdy, všetky otázky na jednej strane';
$string['newattemptfail'] = 'Chyba: Nebolo možné začať nový pokus v tomto teste';
$string['newpage'] = 'Nová strana';
$string['newpageevery'] = 'Automaticky začať novú stranu';
$string['newpage_help'] = 'V prípade dlhšieho testu je lepšie ho rozložiť na viacej stránok, tak že sa obmedzí počet otázok na stránku. Ak pridávate otázky do testu, rozdelenie stránky bude automaticky vložené podľa nastavenia stránky. Tieto rozdelenia stránky je možné neskôr posúvať ručne a to
na stránke pre úpravu textu.';
$string['noanswers'] = 'Neboli vybraté žiadne odpovede!';
$string['noattempts'] = 'Nikto sa nepokúsil urobiť tento test';
$string['noattemptsfound'] = 'Neboli nájdené žiadne pokusy';
$string['noattemptstoshow'] = 'Nie sú žiadne pokusy na zobrazenie';
$string['nocategory'] = 'Nebola určená kategória, alebo bola určená nesprávne.';
$string['noclose'] = 'Neexistuje dátum uzavretia';
$string['nocommentsyet'] = 'Zatiaľ bez komentára';
$string['noconnection'] = 'Momentálne nie je k dispozícii žiadne pripojenie k službe na webe, ktoré by dokázalo spracovať a vyhodnotiť túto otázku. Prosím, kontaktujte svojho administrátora.';
$string['nodataset'] = 'nič - nie je to divoká karta';
$string['nodatasubmitted'] = 'Neboli vložené žiadne údaje.';
$string['noessayquestionsfound'] = 'Neboli nájdené žiadne ručne známkované otázky.';
$string['nogradewarning'] = 'Tento test nie je hodnotený, takže nie je možné nastaviť celkovú spätnú väzbu, ktorá sa líši hodnotením.';
$string['nomoreattempts'] = 'Nie je povolené viac pokusov';
$string['none'] = 'Žiadne';
$string['noopen'] = 'Neexistuje dátum otvorenia';
$string['nooverridedata'] = 'Musíte prestaviť aspoň jedno z nastavení testu.';
$string['nopossibledatasets'] = 'Nie je možné nastavovať dáta';
$string['noquestionintext'] = 'Otázka v teste neobsahuje žiadne možnosti výberu odpovedí';
$string['noquestions'] = 'Zatiaľ neboli pridané otázky';
$string['noquestionsfound'] = 'Žiadna odpoveď';
$string['noquestionsinquiz'] = 'V tomto teste nie sú žiadne otázky.';
$string['noquestionsnotinuse'] = 'Táto náhodná otázka sa nepoužije, pretože jej kategória je prázdna.';
$string['noquestionsonpage'] = 'Prázdna strana';
$string['noresponse'] = 'Žiadna odpoveď';
$string['noreview'] = 'Nemáte oprávnenie prehliadať tento test';
$string['noreviewattempt'] = 'Nemôžete zmeniť tento pokus';
$string['noreviewshort'] = 'Nemáte oprávnenie';
$string['noreviewuntil'] = 'Nemáte oprávnenie prehliadať tento test do {$a}';
$string['noreviewuntilshort'] = 'Dostupné {$a}';
$string['noscript'] = 'Musíte mať nainštalovanú podporu JavaScriptu, aby ste mohli pokračovať ďalej!';
$string['notavailabletostudents'] = 'Poznámka: Tento test nie je momentálne prístupný pre študentov.';
$string['notenoughrandomquestions'] = 'V tejto kategórii {$a->category} nie je dosť úloh na vytvorenie úlohy {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nebolo definovaných dosť podotázok (možností).<br />
Chcete sa vrátiť a opraviť túto otázku?';
$string['notimedependentitems'] = 'Položky, ktoré sú časovo obmedzené, nie sú podporované v tomto testovom module. Môžete si nastaviť časový limit pre celý kurz. Chcete si vybrať inú položku (alebo chcete pracovať s touto položkou)?';
$string['notyetgraded'] = 'Doteraz nehodnotené';
$string['notyetviewed'] = 'Doteraz neprezrené';
$string['notyourattempt'] = 'Toto nie je Váš pokus!';
$string['noview'] = 'Prihlásený používateľ nemôže prezerať tento test';
$string['numattempts'] = '{$a->studentstring}: {$a->studentnum}, pokusov: {$a->attemptnum}';
$string['numattemptsmade'] = 'V tomto teste je {$a} pokusov';
$string['numberabbr'] = '#';
$string['numerical'] = 'Rozsahová';
$string['numquestionsx'] = 'Otázky: {$a}';
$string['onlyteachersexport'] = 'Iba učitelia môžu exportovať úlohy.';
$string['onlyteachersimport'] = 'Iba učitelia s právom upravovať obsah kurzu môžu importovať úlohy.';
$string['onthispage'] = 'Táto stránka';
$string['open'] = 'Nezodpovedané';
$string['openclosedatesupdated'] = 'Dátumy otvorenia a uzatvorenia testu sú aktualizované';
$string['optional'] = 'voliteľný';
$string['orderandpaging'] = 'Poradie a stránkovanie';
$string['orderingquiz'] = 'Poradie a stránkovanie';
$string['orderingquizx'] = 'Triedenie a stránkovanie: {$a}';
$string['outcomesadvanced'] = 'Ciele sú pokročilé nastavenia';
$string['outof'] = 'z maximálneho počtu bodov';
$string['outofpercent'] = '{$a->grade} z možných {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Celková spätná väzba';
$string['overallfeedback_help'] = '<p>Celková spätná väzba je text, ktorý sa zobrazí študentovi po ukončení pokusu testu. Text, ktorý je ukázaný, môže závisieť na známke, ktorú študent dostane.</p>

<p>Napríklad, ak vložíte:</p>

<p>Hranica hodnotenia: 100%<br />
Spätná väzba: Výborne<br />
Hranica hodnotenia: 40%<br />
Spätná väzba: Prosím preštudujte si znova prácu z tohto týždňa.<br />
...<br />
Hranica hodnotenia: 0%</p>

<p>Potom študenti, ktorí získali medzi 100% a 40% uvidia správu "Výborne", a študenti, ktorí získali medzi 39.99% and 0% uvidia druhú správu. Bodový zisk definuje rozsahy známok a každá spätná väzba je zobrazená podľa skóre v príslušnom rozsahu.</p>

<p>Bodový zisk môže byť špecifikovaný buď percentom, napríklad "31.41%", alebo ako číslo, napríklad "7". Ak váš test je do 10 bodov, bodový zisk 7 znamená 7/10 alebo viac.</p>';
$string['overdue'] = 'Oneskorený';
$string['overduehandling'] = 'Keď vyprší čas';
$string['overduehandlingautoabandon'] = 'Pokusy musia byť odoslané pred vypršaním času, inak nebudú uznané.';
$string['overduehandlingautosubmit'] = 'Otvorené pokusy sú odoslané automaticky';
$string['overduehandling_desc'] = 'Čo by sa malo stať vo východzom nastavení, ak študent neodovzdá test pred vypršaním času.';
$string['overduehandlinggraceperiod'] = 'Existuje určitý časový interval, keď môžu byť odoslané otvorené pokusy, ale nie je možné odpovedať na ďalšie otázky';
$string['override'] = 'Prestavenie';
$string['overridedeletegroupsure'] = 'Naozaj chcete vymazať prestavenie pre skupinu {$a}?';
$string['overridedeleteusersure'] = 'Naozaj chcete vymazať prestavenie pre používateľa {$a}?';
$string['overridegroup'] = 'Prestaviť skupinu';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Prestavenia';
$string['overrideuser'] = 'Prestaviť používateľa';
$string['overrideusereventname'] = '{$a->quiz} - prestavenie';
$string['page-mod-quiz-edit'] = 'Stránka pre úpravu testu';
$string['page-mod-quiz-x'] = 'Ľubovoľná stránka modulu test';
$string['pagesize'] = 'Stránkovať po';
$string['parent'] = 'Rodičovský';
$string['parentcategory'] = 'Nadradená kategória';
$string['parsingquestions'] = 'Čítam otázky zo súboru importu.';
$string['partiallycorrect'] = 'Čiastočne správny';
$string['penalty'] = 'Penalizácia';
$string['penaltyscheme'] = 'Použiť trestné body';
$string['penaltyscheme_help'] = '<p>Ak test prebieha v adaptívnom režime, študent má povolené po nesprávnej odpovedi skúsiť znova odpovedať. V tomto prípade môžete požadovať trestné body za každú nesprávnu odpoveď, ktoré budú odčítané z výslednej známky za danú úlohu. Výška trestných bodov je vyberaná individuálne pre každú úlohu pri nastavení alebo úprave tejto úlohy.</p>

<p>Toto nastavenie nemá vplyv, ak nie je v teste povolený adaptívny režim.</p>';
$string['percentcorrect'] = 'Správne percentá';
$string['pleaseclose'] = 'Vaša požiadavka bola spracovaná. Teraz už môžete zavrieť toto okno.';
$string['pluginadministration'] = 'Administrácia testu';
$string['pluginname'] = 'Test';
$string['popup'] = 'Zobraziť test v "bezpečnom" okne';
$string['popupblockerwarning'] = 'Táto časť testu je v bezpečnom móde, takže potrebujete urobiť test v bezpečnom okne. Prosím vypnite blokovanie vyskakovacích okien. Ďakujeme.';
$string['popupnotice'] = 'Študenti budú vidieť test v "bezpečnom" okne';
$string['preprocesserror'] = 'Počas predspracovania sa vyskytla chyba!';
$string['preview'] = 'Náhľad';
$string['previewquestion'] = 'Náhľad otázky';
$string['previewquiz'] = 'Náhľad testu';
$string['previewquiznow'] = 'Náhľad testu teraz';
$string['previous'] = 'Predchádzajúci stav';
$string['publish'] = 'Publikovať';
$string['publishedit'] = 'Musíte mať povolenie na tvorbu kurzu, aby ste mohli pridávať alebo upravovať otázky v tejto kategórii.';
$string['qbrief'] = 'Úloha. {$a}';
$string['qname'] = 'názov';
$string['qti'] = 'Formát IMS QTI';
$string['qtypename'] = 'typ, názov';
$string['question'] = 'Otázka';
$string['questionbankcontents'] = 'Obsah banky otázok';
$string['questionbankmanagement'] = 'Správa banky otázok';
$string['questionbehaviour'] = 'Správanie otázky';
$string['questioncats'] = 'Kategórie otázok';
$string['questiondeleted'] = 'Tato úloha bola odstránená. Prosím, kontaktujte vášho vyučujúceho';
$string['questioninuse'] = 'Otázka \'{$a->questionname}\' je práve používaná:<br  />{$a->quiznames}<br />Otázky nebudú vymazané z týchto testov ale iba zo zoznamu kategórií.';
$string['questionmissing'] = 'Otázka pre toto sedenie chýba';
$string['questionname'] = 'Názov otázky';
$string['questionnonav'] = '<span class="accesshide">Úloha </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informácia </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Otázka {$a} nebola nahraná z databázy';
$string['questionorder'] = 'Poradie otázok';
$string['questionposition'] = 'Nové poradie otázky {$a} v teste';
$string['questions'] = 'Otázky';
$string['questionsinclhidden'] = 'Úlohy (včítane skrytých)';
$string['questionsinthisquiz'] = 'Otázky v tomto teste';
$string['questionsperpage'] = 'Maximálny počet otázok na stranu';
$string['questionsperpagex'] = 'Počet otázok na stranu: {$a}';
$string['questiontext'] = 'Text otázky';
$string['questiontextisempty'] = '[Prázdny test otázky]';
$string['questiontype'] = 'Otázka typu  {$a}';
$string['questiontypesetupoptions'] = 'Možnosti nastavenia pre typy otázok:';
$string['quiz:addinstance'] = 'Pridať nový test';
$string['quiz:attempt'] = 'Byť testovaný';
$string['quizavailable'] = 'Test je dostupný do: {$a}';
$string['quizclose'] = 'Zatvoriť test';
$string['quizclosed'] = 'Tento test bol zatvorený {$a}';
$string['quizcloses'] = 'Test je uzatvorený';
$string['quizcloseson'] = 'Tento test bude uzavrený dňa {$a}';
$string['quiz:deleteattempts'] = 'Vymazať všetky pokusy testov';
$string['quiz:emailconfirmsubmission'] = 'Dostať potvrdzovací mail po odovzdaní';
$string['quiz:emailnotifysubmission'] = 'Dostať mailovú správu, keď je uskutočnený pokus';
$string['quiz:emailwarnoverdue'] = 'Dostávať upozornenie na blížiaci sa koniec odovzdávania testu.';
$string['quiz:grade'] = 'Ohodnotiť testy manuálne';
$string['quiz:ignoretimelimits'] = 'Ignorovať časový limit v testoch';
$string['quizisclosed'] = 'Tento test je uzavretý';
$string['quizisclosedwillopen'] = 'Test je uzavretý (otvorený {$a})';
$string['quizisopen'] = 'Tento test je otvorený';
$string['quizisopenwillclose'] = 'Test sa otvára (zatvára {$a})';
$string['quiz:manage'] = 'Spravovať testy';
$string['quiz:manageoverrides'] = 'Spravovať prestavenia kurzu';
$string['quiznavigation'] = 'Navigácia v teste';
$string['quizopen'] = 'Otvoriť test';
$string['quizopenclose'] = 'Dátum sprístupnenia a uzavrenia';
$string['quizopenclose_help'] = 'Študenti môžu začať svoj pokus po dátume sprístupnenia a musia odovzdať test pred dátumom uzavrenia.';
$string['quizopened'] = 'Tento test je otvorený';
$string['quizopenedon'] = 'Tento test bol otvorený dňa {$a}';
$string['quizopens'] = 'Test sa otvára';
$string['quizopenwillclose'] = 'Tento test je otvorený, bude uzavretý dňa {$a} o';
$string['quizordernotrandom'] = 'Poradie testu nie je zamiešané';
$string['quizorderrandom'] = '* Poradie testu je zamiešané';
$string['quiz:preview'] = 'Náhľad testov';
$string['quiz:regrade'] = 'Preznámkovať pokusy testu';
$string['quiz:reviewmyattempts'] = 'Prehľad vlastných pokusov';
$string['quizsettings'] = 'Nastavenia testu';
$string['quiztimer'] = 'Časomiera testu';
$string['quiz:view'] = 'Prezerať informáciu o teste';
$string['quiz:viewreports'] = 'Prezerať správy o teste';
$string['quizwillopen'] = 'Tento test bude otvorený dňa {$a}';
$string['random'] = 'Náhodná otázka';
$string['randomcreate'] = 'Vytvoriť náhodné otázky';
$string['randomfromcategory'] = 'Náhodná otázka z kategórie:';
$string['randomfromexistingcategory'] = 'Náhodná otázka z existujúcej kategórie';
$string['randomnosubcat'] = 'Otázky pochádzajúce iba z tejto kategórie, nie jej podkategórií.';
$string['randomquestionusinganewcategory'] = 'Náhodná otázka z novej kategórie';
$string['randomwithsubcat'] = 'Otázky pochádzajúce z tejto kategórie a jej podkategórií.';
$string['readytosend'] = 'Pripravujete sa na posielanie celého vášho testu na ohodnotenie. Naozaj chcete pokračovať?';
$string['reattemptquiz'] = 'Znovu sa pokúsiť urobiť test';
$string['recentlyaddedquestion'] = 'Nedávno pridaná otázka!';
$string['recurse'] = 'Zobraziť tiež otázky z podkategórií';
$string['regrade'] = 'Preznámkovať všetky pokusy';
$string['regradecomplete'] = 'Všetky pokusy boli preznámkované';
$string['regradecount'] = '{$a->changed} z {$a->attempt} boli zmenené známky';
$string['regradedisplayexplanation'] = 'Pokusy, ktoré budú zmenené počas opätovného známkovania, sa budú zobrazovať ako odkazy na okno s prehľadom jednotlivých testových otázok.';
$string['regradenotallowed'] = 'Nemáte oprávnenie prehodnotiť tento test';
$string['regradingquestion'] = 'Opätované známkovanie otázky  "{$a}".';
$string['regradingquiz'] = 'Opätované známkovanie testu  "{$a}"';
$string['remove'] = 'Odstrániť';
$string['removeallquizattempts'] = 'Odstrániť všetky pokusy testov';
$string['removeemptypage'] = 'Odstrániť prázdnu stranu';
$string['removeselected'] = 'Odstrániť vybrané';
$string['rename'] = 'Premenovať';
$string['renderingserverconnectfailed'] = 'Server {$a} nedokázal spracovať RQP požiadavku. Skontrolujte, či je URL adresa zadaná správne.';
$string['reorderquestions'] = 'Zmeniť poradie otázok';
$string['reordertool'] = 'Zobrazovať pomôcku pre zmenu poradia';
$string['repaginate'] = 'Znovu zadefinovať počet otázok na stránke: {$a}';
$string['repaginatecommand'] = 'Prestránkovať';
$string['repaginatenow'] = 'Prestránkovať teraz';
$string['replace'] = 'Nahradiť';
$string['replacementoptions'] = 'Možnosti nahradzovania';
$string['report'] = 'Zápisy';
$string['reportanalysis'] = 'Analýza položky';
$string['reportattemptsfrom'] = 'Pokusy od';
$string['reportattemptsthatare'] = 'Pokusy, ktoré sú';
$string['reportdisplayoptions'] = 'Možnosti zobrazenia';
$string['reportfullstat'] = 'Detailná štatistika';
$string['reportmulti_percent'] = 'Viacpercentuálna hodnota';
$string['reportmulti_q_x_student'] = 'Možnosť výberu viacerými študentmi';
$string['reportmulti_resp'] = 'Odpovede individuálnych používateľov';
$string['reportmustselectstate'] = 'Musíte vybrať najmenej jeden stav';
$string['reportnotfound'] = 'Správa je neznáma pre ({$a})';
$string['reportoverview'] = 'Celkový prehľad';
$string['reportregrade'] = 'Preznámkovať pokusy';
$string['reportresponses'] = 'Odpovede podrobne';
$string['reports'] = 'Správy';
$string['reportshowonly'] = 'Zobraziť iba pokusy';
$string['reportsimplestat'] = 'Jednoduchá štatistika';
$string['reportusersall'] = 'všetci používatelia, ktorí majú pokus v teste';
$string['reportuserswith'] = 'zapísaní používatelia, ktorí majú pokus v teste';
$string['reportuserswithorwithout'] = 'zapísaní používatelia';
$string['reportuserswithout'] = 'zapísaní používatelia bez pokusu v teste';
$string['reportwhattoinclude'] = 'Čo treba zahrnúť do správy';
$string['requirepassword'] = 'Vyžaduje sa heslo';
$string['requirepassword_help'] = '<p>Toto pole je voliteľné.</p>

<p>Ak tu špecifikujete heslo, budú ho študenti musieť zadať pred každým pokusom o vykonanie testu.</p>';
$string['requiresubnet'] = 'Vyžaduje sa adresa siete';
$string['requiresubnet_help'] = '<p>Toto pole je voliteľné.</p>

<p>Špecifikovaním zoznamu úplných alebo neúplných IP adries oddelených čiarkou môžete obmedziť prístup k testu pre konkrétne podsiete v rámci siete LAN alebo Internetu.</p>

<p>Toto je obzvlášť užitočné pre zabezpečené testy, pri ktorých chcete mať istotu, že k testu budú mať prístup iba študenti v danej miestnosti.</p>

<p>Napríklad: <b>192.168. , 231.54.211.0/20, 231.3.56.211, 231.3.56.10-20</b></p>

<p>Môžete použiť štyri typy čísiel (nemôžete použiť textové mená domén ako example.com):</p>

<ol>
<li>Úplné IP adresy, ako <b>192.168.10.1</b>, ktoré zodpovedajú jednému počítaču (alebo proxy serveru).</li>
<li>Neúplné adresy, ako <b>192.168</b>, ktoré zodpovedajú všetkým umiestneniam, ktoré začínajú na tieto čísla.</li>
<li>CIDR zápis, ako <b>231.54.211.0/20</b>, ktorý Vám povoľuje podrobnejšie špecifikovať určenie podsietí.</li>
<li>Rozsah IP adries <b>231.3.56.10-20</b>. Rozsah sa vzťahuje na poslednú časť adresy, to znamená na celú IP adresu od 231.3.56.10 do 231.3.56.20.</li>
</ol>

<p>Medzery sú ignorované.</p>';
$string['response'] = 'Odpoveď';
$string['responses'] = 'Odpovede';
$string['results'] = 'Výsledky';
$string['returnattempt'] = 'Návrat k pokusu';
$string['reuseifpossible'] = 'znovu použiť predtým odstránené';
$string['reverttodefaults'] = 'Vrátiť sa k východzím nastaveniam testu';
$string['review'] = 'Prehľad';
$string['reviewafter'] = 'Povoliť prehľad aj po uzatvorení testu';
$string['reviewalways'] = 'Povoliť prehľad kedykoľvek';
$string['reviewattempt'] = 'Prezrieť pokus';
$string['reviewbefore'] = 'Povoliť prehľad pokým je test otvorený';
$string['reviewclosed'] = 'Po tom, ako sa uzatvorí test';
$string['reviewduring'] = 'Počas pokusu';
$string['reviewimmediately'] = 'Hneď po pokuse';
$string['reviewnever'] = 'Nikdy nepovoliť prehľad';
$string['reviewofattempt'] = 'Revízia pokusu {$a}';
$string['reviewofpreview'] = 'Prehľad náhľadu';
$string['reviewopen'] = 'Neskôr, keď je test stále otvorený';
$string['reviewoptions'] = 'Študenti majú možnosť revízie';
$string['reviewoptionsheading'] = 'Možnosti prehľadu';
$string['reviewoptionsheading_help'] = 'Tieto voľby určujú, ktoré informácie môžu používatelia vidieť pri kontrole testu a výkazov testu. "Hneď po pokuse" znamená to do dvoch minút potom, ako používateľ odoslal svoj pokus o vykonanie testu. "Neskôr, keď je test stále otvorený" tým je myslený čas po predošlom a až do uzavretia testu pre používateľov. "Po tom, ako sa uzatvorí test" - tým sa chápe čas po uzavretí testu. Ak test nemá čas ukončenia, tento stav sa nikdy nedosiahne.';
$string['reviewoverallfeedback'] = 'Celková spätná väzba';
$string['reviewresponse'] = 'Zhodnotiť odpoveď';
$string['reviewresponsetoq'] = 'Zhodnotiť odpoveď (otázka {$a})';
$string['reviewthisattempt'] = 'Prezrieť svoje odpovede v tomto pokuse';
$string['rqp'] = 'Vzdialená otázka';
$string['rqps'] = 'Vzdialené otázky';
$string['sameasoverall'] = 'Rovnako ako v známkach';
$string['save'] = 'Uložiť';
$string['saveandedit'] = 'Uložiť odpovede a upraviť otázky';
$string['saveattemptfailed'] = 'Nepodarilo sa uložiť aktuálny pokus testu';
$string['savedfromdeletedcourse'] = 'Uložené z vymazaného kurzu "{$a}"';
$string['savegrades'] = 'Uložiť známky';
$string['savemyanswers'] = 'Uložiť moje odpovede';
$string['savenosubmit'] = 'Uložiť bez odoslania';
$string['saveoverrideandstay'] = 'Uložiť a zadať ďalšie prestavenie';
$string['savequiz'] = 'Uložiť tento celý test';
$string['saving'] = 'Ukladanie';
$string['savingnewgradeforquestion'] = 'Ukladanie nového hodnotenia úlohy id {$a}.';
$string['savingnewmaximumgrade'] = 'Ukladanie nového maxima hodnotenia.';
$string['score'] = 'Hrubé skóre';
$string['scores'] = 'Skóre';
$string['select'] = 'Vybrať';
$string['selectall'] = 'Vybrať všetko';
$string['selectcategory'] = 'Vybrať kategóriu';
$string['selectedattempts'] = 'Vybrať pokusy...';
$string['selectnone'] = 'Odznačiť všetky';
$string['selectquestiontype'] = '-- Výber typu otázky --';
$string['serveradded'] = 'Pridaný server';
$string['serveridentifier'] = 'Identifikátor';
$string['serverinfo'] = 'Informácie o serveri';
$string['servers'] = 'Servery';
$string['serverurl'] = 'URL servera';
$string['settingsoverrides'] = 'Nastavenia prestavení';
$string['shortanswer'] = 'Krátka odpoveď';
$string['show'] = 'Ukázať';
$string['showall'] = 'Znázorniť všetky otázky na stránke';
$string['showblocks'] = 'Zobraziť bloky počas vypracovania testu';
$string['showblocks_help'] = 'Ak je voľba nastavená, budú počas vypracovania testu zobrazené normálne bloky';
$string['showbreaks'] = 'Znázorniť zlomy na stránke';
$string['showcategorycontents'] = 'Ukázať obsah kategórie {$a->arrow}';
$string['showcorrectanswer'] = 'V spätnej väzbe zobraziť správne odpovede?';
$string['showdetailedmarks'] = 'Znázorniť detaily známok';
$string['showeachpage'] = 'Ukázať vždy iba jednu stránku';
$string['showfeedback'] = 'Po zodpovedaní ukážte spätnú väzbu?';
$string['showinsecurepopup'] = 'Používať \'bezpečné\' vyskakovanie okno pre vypracovanie testu';
$string['shownoattempts'] = 'Ukázať študentov bez pokusov';
$string['shownoattemptsonly'] = 'Zobrazovať iba študentov, ktorí sa o test nepokúsili';
$string['showreport'] = 'Zobraziť správu';
$string['showteacherattempts'] = 'Ukázať pokusy učiteľov';
$string['showuserpicture'] = 'Ukázať obrázok používateľa';
$string['shuffle'] = 'Zamiešať';
$string['shuffleanswers'] = 'Zamiešať odpovede';
$string['shuffledrandomly'] = 'Náhodne poprehadzovať';
$string['shufflequestions'] = 'Zamiešať otázky';
$string['shufflequestionsselected'] = 'Bolo nastavené náhodné poradie otázok. Preto ne sú dostupné niektoré voľby. Zmena náhodnosti: {$a}.';
$string['shufflewithin'] = 'Zamiešať v rámci úloh';
$string['shufflewithin_help'] = '<p>Ak zapnete túto voľbu, potom jednotlivé časti úloh budú náhodne
zamiešané pri každom pokuse študenta, ak to umožňuje nastavenie
konkrétnej úlohy.</p>

<p>Zámer je v tom, aby študenti nemohli tak ľahko opisovať jeden od
druhého.</p>

<p>Nastavenie je iba pre úlohy, ktoré majú možnosť výberu, ako úlohy z
výberom odpovedí a priradzovacie úlohy. Pre úlohy s výberom odpovedí
platí, že poradie odpovedí bude zamiešané, iba ak je táto možnosť je
nastavená na &quot;Áno&quot;. Pre priradzovacie úlohy budú odpovede
vždy zamiešané a toto nastavenie určuje, či má byť zamiešané aj poradie
otázka - odpoveď.</p>

<p>Táto voľba nie je spojená s použitím náhodne vybratých otázok.</p>';
$string['singleanswer'] = 'Vyberte jednu odpoveď';
$string['sortage'] = 'Triediť podľa dátumu';
$string['sortalpha'] = 'Triediť abecedne podľa názvu';
$string['sortquestionsbyx'] = 'Triediť otázky podľa: {$a}';
$string['sortsubmit'] = 'Triediť úlohy';
$string['sorttypealpha'] = 'Triediť abecedne podľa typu';
$string['specificapathnotonquestion'] = 'Zadaná cesta k súboru nie je v určenej otázke';
$string['specificquestionnotonquiz'] = 'Daná otázka nie je v určenom teste';
$string['startagain'] = 'Začať znovu';
$string['startattempt'] = 'Zahájenie pokusu';
$string['startedon'] = 'Test bol začatý';
$string['startnewpreview'] = 'Začať nový náhľad';
$string['stateabandoned'] = 'Nikdy neodoslané';
$string['statefinished'] = 'Ukončené';
$string['statefinisheddetails'] = 'Odoslané {$a}';
$string['stateinprogress'] = 'Prebieha';
$string['statenotloaded'] = 'Stav otázky: {$a} nebol nahraný z databázy.';
$string['stateoverdue'] = 'Prekročený časový limit';
$string['stateoverduedetails'] = 'Musí byť odoslané {$a}';
$string['status'] = 'Stav';
$string['stoponerror'] = 'Zastaviť na chybe';
$string['submitallandfinish'] = 'Odoslať všetko a ukončiť';
$string['subneterror'] = 'Prepáčte, ale tento kurz bol uzamknutý a je možné do neho vstúpiť iba z určitých lokalít. Váš počítač je jeden z tých, ktoré nemajú povolenie vstupu do testu.';
$string['subnetnotice'] = 'Tento test bol uzamknutý a je prístupný iba z niektorých miest. Váš počítač bohužiaľ medzi ne nepatrí. Ako učiteľ máte možnosť prehliadnuť si čokoľvek.';
$string['subplugintype_quiz'] = 'Zostava';
$string['subplugintype_quizaccess'] = 'Prístupové pravidlo';
$string['subplugintype_quizaccess_plural'] = 'Prístupové pravidlá';
$string['subplugintype_quiz_plural'] = 'Zostavy';
$string['substitutedby'] = 'bude nahradené';
$string['summaryofattempt'] = 'Sumár pokusu';
$string['summaryofattempts'] = 'Sumár vašich predošlých pokusov';
$string['temporaryblocked'] = 'Dočasne vám nie je dovolené pokúsiť sa o ďalšie zvládnutie testu.<br />Ďalší pokus budete môcť absolvovať:';
$string['theattempt'] = 'Tento pokus';
$string['theattempt_help'] = 'Či si študent môže vôbec pozrieť svoj pokus.';
$string['time'] = 'Čas';
$string['timecompleted'] = 'Čas vypršal';
$string['timedelay'] = 'Nie je vám dovolené absolvovať tento test, pretože vám doposiaľ neuplynulo nastavené oneskorenie medzi dvomi testami.';
$string['timeleft'] = 'Čas zostávajúci do ukončenia testu';
$string['timelimit'] = 'Časový limit';
$string['timelimitexeeded'] = 'Prepáčte, ale čas už vypršal!';
$string['timelimit_help'] = '<p>V základnom nastavení testy nemajú časový limit, študenti majú na
splnenie testu toľko času, koľko potrebujú.</p>

<p>Ak určíte časový limit, prebehne niekoľko operácií, ktoré zaistia,
že testy budú splnené v tomto čase:</p>

<ul>
  <li>Je nutné, aby prehliadač podporoval Javascript. Iba tak budú
  stopky fungovať správne.</li>
  <li>Stopky s odpočítavaním času sú zobrazené v pohyblivom okne.</li>
  <li>Po vypršaní časového limitu je test automaticky odoslaný s
  odpoveďami, ktoré boli doteraz vyplnené.</li>
  <li>Ak sa študentovi podarí podvádzať a stráviť nad testom o
  minimálne 60 sekún viac ako je limit, test je automaticky ohodnotený
  známkou nula.</li>
</ul>';
$string['timelimitmin'] = 'Časový limit testu (v minútach)';
$string['timelimitsec'] = 'Časový limit (v sekundách)';
$string['timestr'] = '%H:%M:%S dňa %d/%m/%y';
$string['timesup'] = 'Čas vypršal!';
$string['timetaken'] = 'Strávený čas';
$string['timing'] = 'Časovanie';
$string['tofile'] = 'do súboru';
$string['tolerance'] = 'Tolerancia';
$string['toomanyrandom'] = 'Požadovaný počet náhodných otázok je väčší, než je obsiahnuté v tejto kategórii! ({$a})';
$string['top'] = 'Vrch';
$string['totalmarksx'] = 'Súčet hodnotení: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Celkom {$a} otázok v kategórii.';
$string['true'] = 'Áno';
$string['truefalse'] = 'Áno/Nie';
$string['type'] = 'Typ';
$string['unfinished'] = 'otvorený';
$string['ungraded'] = 'Neznámkovaný';
$string['unit'] = 'Jednotka';
$string['unknowntype'] = 'Typ otázky nie je podporovaný na riadku {$a}. Otázka bude ignorovaná';
$string['unusedcategorydeleted'] = 'Táto kategória bola vymazaná, pretože po vymazaní kurzu sa otázky použité v tejto kategórii už viac nepoužili na serveri.';
$string['updatesettings'] = 'Aktualizovať nastavenie testu';
$string['updatingatttemptgrades'] = 'Aktualizujú sa hodnotenia pokusov.';
$string['updatingfinalgrades'] = 'Aktualizácia výsledného hodnotenia.';
$string['updatingthegradebook'] = 'Aktualizácia výkazu známok.';
$string['upgradesure'] = '<div>Tento test čaká rozsiahla zmena databázových tabuliek a táto aktualizácia ešte nebola dostatočne otestovaná. Odporúčame Vám, aby ste si zálohovali databázové tabuľky predtým, ako budete pokračovať.</div>';
$string['upgradingquizattempts'] = 'Aktualizujú sa pokusy testov : test {$a->done}/{$a->outof} (Test id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Aktualizujú sa veľmi staré pokusy testov: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Táto kategória bola presunutá do úrovne stránky, pretože po vymazaní kurzu sa otázky v použité v tejto kategórii používali aj v ostatných testoch na serveri.';
$string['useroverrides'] = 'Používateľské prestavenia';
$string['usersnone'] = 'K tomuto testu nemajú prístup žiadni študenti';
$string['validate'] = 'Overiť';
$string['viewallanswers'] = 'Zobraziť {$a} celých testov';
$string['viewallreports'] = 'Prezrieť zápisy {$a} pokusov';
$string['viewed'] = 'Prezrené';
$string['warningmissingtype'] = '<p><b>Tento typ úloh nie je na vašom serveri nainštalovaný.<br />Prosím, upozornite vášho správcu Moodle.</b></p>';
$string['wheregrade'] = 'Kde je moja známka?';
$string['wildcard'] = 'Divoká karta';
$string['windowclosing'] = 'Toto okno sa čoskoro zavrie';
$string['withsummary'] = 'so súhrnnou štatistikou';
$string['wronguse'] = 'Nemôžete používať túto stránku len tak';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Tento test môžete začať až potom, keď sa zapíšete do tohto kurzu.';
$string['yourfinalgradeis'] = 'Vaša konečná známka za tento test je {$a}.';
