<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcia';
$string['addanotherhint'] = 'Pridať ďalšiu pomôcku';
$string['addcategory'] = 'Pridať kategóriu';
$string['addmorechoiceblanks'] = 'Prázdne miesta pre viac možností';
$string['adminreport'] = 'Správa o možných problémoch v databáze Vašich otázok';
$string['answer'] = 'Odpoveď';
$string['answersaved'] = 'Odpoveď bola uložená';
$string['attemptfinished'] = 'Pokus bol uložený';
$string['availableq'] = 'Dostupný?';
$string['behaviour'] = 'Správanie';
$string['behaviourbeingused'] = 'využívané správanie: {$a}';
$string['broken'] = 'Toto je "mŕtvy odkaz", ukazuje na neexistujúci súbor.';
$string['byandon'] = 'používateľom <em>{$a->user}</em> dňa <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Nie je možné kopírovať súbor zálohy';
$string['cannotcreate'] = 'Nie je možné vytvoriť nový záznam v tabuľke pokusov ';
$string['cannotcreatepath'] = 'Nie je možné vytvoriť cestu {$a}';
$string['cannotdeletecate'] = 'Nemôžete vymazať túto kategóriu, pretože je to východzia kategória pre tento obsah.';
$string['cannotdeleteqtypeinuse'] = 'Nemôžete vymazať chýbajúci typ otázky \'{$a}\'. V banke otázok sú uložené otázky tohto typu.';
$string['cannotdeleteqtypeneeded'] = 'Nemôžete vymazať chýbajúci typ otázky \'{$a}\'. Existujú iné typy otázok, ktoré na ňom závisia.';
$string['cannotenable'] = 'Typ otázky {$a} nie je možné priamo vytvoriť ';
$string['cannotfindcate'] = 'Nepodarilo sa nájsť záznam v kategórii';
$string['cannotfindquestionfile'] = 'Nepodarilo sa nájsť dátový súbor otázky vo formáte ZIP';
$string['cannotgetdsfordependent'] = 'Nepodarilo sa získať vybraný dataset pre otázku od neho závisiacu (otázka {$a->id}, dataset: {$a->item})';
$string['cannotgetdsforquestion'] = 'Nepodarilo sa získať vybraný dataset pre výpočtovú otázku  (otázka: {$a})';
$string['cannothidequestion'] = 'Nebolo možné skryť otázku';
$string['cannotimportformat'] = 'Prepáčte, ale importovanie tohto formátu nebolo ešte implementované.';
$string['cannotinsertquestion'] = 'Nie je možné vložiť novú otázku';
$string['cannotinsertquestioncatecontext'] = 'Nepodarilo sa vložiť novú kategóriu otázok {$a->cat} nesprávny identifikátor kontextu {$a->ctx}';
$string['cannotloadquestion'] = 'Nepodarilo sa nahrať otázku';
$string['cannotmovequestion'] = 'Nemôžete použiť tento skript pre presun otázok, ktoré majú asociované súbory z rozličných oblastí.';
$string['cannotopenforwriting'] = 'Nie je možné otvoriť {$a} pre zápis';
$string['cannotpreview'] = 'Nemôžete prezrieť tieto otázky';
$string['cannotread'] = 'Nie je možné načítať súbor pre import (alebo je súbor prázdny)';
$string['cannotretrieveqcat'] = 'Nepodarilo sa získať kategóriu otázky';
$string['cannotunhidequestion'] = 'Nepodarilo sa odkryť otázku';
$string['cannotunzip'] = 'Nie je možné rozbaliť súbor.';
$string['cannotwriteto'] = 'Nie je možné exportovať otázky do {$a}';
$string['category'] = 'Kategória';
$string['categorycurrent'] = 'Aktuálna kategória';
$string['categorycurrentuse'] = 'Použiť túto kategóriu';
$string['categorydoesnotexist'] = 'Táto kategória neexistuje';
$string['categoryinfo'] = 'Informácie o kategórii';
$string['categorymove'] = 'Kategória \'{$a->name}\' obsahuje {$a->count} otázok.  vyberte si prosím inú kategóriu, do ktorej ich prenesiete.';
$string['categorymoveto'] = 'Uložiť v kategórii';
$string['categorynamecantbeblank'] = 'Názov kategórie nemôže byť prázdny';
$string['changeoptions'] = 'Zmeniť voľby';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategória "{$a->name}"</a> v kurze "{$a->coursename}" zmení svoj status zdieľania z <strong>{$a->changefrom} na {$a->changeto}</strong>.';
$string['check'] = 'Skontrolovať';
$string['chooseqtypetoadd'] = 'Vyberte si typ otázky, ktorú chcete pridať';
$string['clearwrongparts'] = 'Vymazať nesprávne odpovede';
$string['clicktoflag'] = 'Kliknite na označenie tejto otázky';
$string['clicktounflag'] = 'Kliknite na odznačenie tejto otázky';
$string['closepreview'] = 'Zatvoriť náhľad';
$string['combinedfeedback'] = 'Kombinovaná spätná väzba';
$string['comment'] = 'Komentár';
$string['commented'] = 'Komentované: {$a}';
$string['commentormark'] = 'Komentujte alebo prepíšte známku';
$string['comments'] = 'Komentáre';
$string['commentx'] = 'Komentár: {$a}';
$string['complete'] = 'Ukončené';
$string['contexterror'] = 'Sem by ste sa nemali dostať. Iba ak presúvate kategóriu do iného kontextu.';
$string['copy'] = 'Kopírovať z {$a} a zmeniť odkazy';
$string['correct'] = 'Správny';
$string['correctfeedback'] = 'Pre ľubovoľnú správnu odpoveď';
$string['created'] = 'Vytvorené';
$string['createdby'] = 'Vytvorená ';
$string['createdmodifiedheader'] = 'Vytvorené / naposledy uložené';
$string['createnewquestion'] = 'Vytvoriť novú otázku';
$string['cwrqpfs'] = 'Náhodné otázky z otázok v podkategóriách';
$string['cwrqpfsinfo'] = '<p>Počas aktualizácie Moodle na verziu 1.9 budú rozdelené kategórie otázok do rozdielnych kontextov. U niektorých kategórií sa zmení ich status zdieľania. To sa stane v zriedkavom prípade, že jedna alebo viacero \'náhodných\' otázok v teste je tvorená z podkategórií, v ktorých sú niektoré zdieľané a niektoré nezdieľané (ako je to v prípade Vášho portálu). </p>

<p>Nasledovné kategórie otázok, z ktorých boli vybrané \'náhodné\' otázky, budú mať zmenený status zdieľania na rovnaký, ako má kategória s \'náhodnou\' otázkou pri aktualizácii na 1.9. Otázky, ktoré sa nachádzajú v týchto kategóriách, budú aj ďalej správne fungovať v existujúcich testoch, až kým ich z nich neodstránite.</p>';
$string['cwrqpfsnoprob'] = 'Žiadne kategórie otázok neodpovedajú problému \'náhodné otázky z podkategórií\'.';
$string['decimalplacesingrades'] = 'Desatinné miesta v známkach';
$string['defaultfor'] = 'Východzí pre {$a}';
$string['defaultinfofor'] = 'Východzia kategória pre otázky zdieľané v kontexte \'{$a}\'.';
$string['defaultmark'] = 'Východzia hodnota známky';
$string['deletecoursecategorywithquestions'] = 'V banke otázok sú otázky asociované s touto kategóriou. Ak budete pokračovať, budú vymazané. Ak potrebujete, najprv ich presuňte použitím rozhrania pre otázky.';
$string['deletequestioncheck'] = 'Naozaj chcete vymazať \'{$a}\'?';
$string['deletequestionscheck'] = 'Naozaj chcete vymazať nasledovné otázky?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Vymazávanie správania otázky \'{$a}\'';
$string['deletingqtype'] = 'Vymazávam \'{$a}\' typ otázky...';
$string['disabled'] = 'Nepovolené';
$string['disterror'] = 'Distribúcia {$a} spôsobila problémy';
$string['donothing'] = 'Nekopírujte alebo nepresúvajte súbory ani nemeňte odkazy.';
$string['editcategories'] = 'Upraviť kategórie';
$string['editcategories_help'] = '<p>Kategórie slúžia na rozdelenie otázok do určitých oblastí, čo je obyčajne výhodnejšie, ako ich mať všetky v jednom dlhom zozname.</p>

<p>Kategórie môžu byť vytvorené alebo vymazané podľa potreby. Ale:</p>
<ul><li> V každom kontexte musí existovať minimálne jedna kategória, Takže nie je možné vymazať poslednú kategóriu v kontexte.</li>
<li>Pri pokuse o vymazanie kategórie, ktorá obsahuje otázky, budete požiadaní o názov kategórie, do ktorej budú presunuté.</li></ul>

<p>Môžete usporiadať kategórie hierarchicky, aby boli jednoduchšie spravovateľné. Úprava kategórií je dostupná v záložke \'Kategórie\' v banke otázok.</p>

   <ul><li>Na hlavnej stránke kategórií v záložke \'Kategórie\' v banke otázok:
   <ul><li>šípky hore a dole zmenia poradie, v ktorom sú príbuzné kategórie zoradené. </li>
   <li>Šipky hore a dole tiež umožňujú presúvať kategórie v rámci kontextov. </li>
   <li>Šípky vľavo a vpravo menia nadradenú kategóriu.</li></ul></li>
   <li>Pravdepodobne rýchlejší spôsob presúvania kategórií je kliknutie na ikonu úprav kategórie a potom vybrať novú nadradenú kategóriu. </li></ul>

<p>Viď tiež:</p>
<ul>
  <li><a href="help.php?module=question&amp;file=categorycontexts.html">Kontexty kategórií</a></li>
  <li><a href="help.php?module=question&amp;file=permissions.html">Oprávnenia otázok</a></li>
  <li><a href="http://docs.moodle.org/en/Question_categories">Moodle Docs ku kategóriam otázok</a></li>
</ul>';
$string['editcategory'] = 'Upraviť kategóriu';
$string['editingcategory'] = 'Úprava kategórie';
$string['editingquestion'] = 'Úprava otázky';
$string['editquestion'] = 'Upraviť otázku';
$string['editquestions'] = 'Upraviť otázky';
$string['editthiscategory'] = 'Upraviť túto kategóriu';
$string['emptyxml'] = 'Neznáma chyba- prázdny súbor imsmanifest.xml';
$string['enabled'] = 'Povolené';
$string['erroraccessingcontext'] = 'Prístup k kontextu nie je povolený';
$string['errordeletingquestionsfromcategory'] = 'Chyba pri vymazávaní otázok z kategórie {$a}.';
$string['errorduringpost'] = 'Chyba nastala po spracovaní ';
$string['errorduringpre'] = 'Chyba nastala pred spracovaním ';
$string['errorduringproc'] = 'Chyba nastala počas spracovania';
$string['errorduringregrade'] = 'Nepodarilo sa preznámkovať otázku {$a->qid}, zmena na stav {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Chyba pri kopírovaní súboru {$a}.';
$string['errorfilecannotbemoved'] = 'Chyba pri presúvaní súboru {$a}.';
$string['errorfileschanged'] = 'Chyba: súbory odkazované z otázok boli zmenené potom, čo bol zobrazený tento formulár.';
$string['errormanualgradeoutofrange'] = 'Bodová známka {$a->grade} neleží medzi 0 a {$a->maxgrade} u otázky "{$a->name}". Získané skóre ani komentár neboli uložené.';
$string['errormovingquestions'] = 'Chyba pri presúvaní otázok s identifikátormi {$a}.';
$string['errorpostprocess'] = 'Chyba nastala po spracovaní ';
$string['errorpreprocess'] = 'Chyba nastala pred spracovaním ';
$string['errorprocess'] = 'Chyba nastala počas spracovania';
$string['errorprocessingresponses'] = 'Vyskytla sa chyba pri spracovaní Vašich odoziev.';
$string['errorsavingcomment'] = 'Chyba pri ukladaní komentára u otázky {$a->name} do databázy.';
$string['errorupdatingattempt'] = 'Chyba pri aktualizácii pokusu id {$a->id} v databáze.';
$string['exportcategory'] = 'Exportovať kategóriu';
$string['exportcategory_help'] = '<p align="center"><b>Exportovať kategóriu</b></p>

<p><b>Kategória:</b> na výber kategórie, z ktorej budú vyberané exportné otázky, sa používa rozbaľovací zoznam.</p>

<p>Niektoré importné formáty (GIFT a XML formát) povoľujú, aby bola kategória zahrnutá v zapísanom súbore, umožňujúce pri importe obnoviť kategórie alebo definovať, do ktorej kategórie sa majú otázky importovať. Aby sa to uskutočnilo musí byť zaškrtnuté pole <b>do súboru</b>.</p>';
$string['exporterror'] = 'Vyskytla sa chyba počas exportu';
$string['exportfilename'] = 'test';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportquestions'] = 'Exportovať otázky do súboru';
$string['exportquestions_help'] = 'Táto funkcia Vám umožňuje export celej kategórie (a všetky jej podkategórie) otázok do  súboru. Upozornenie: u väčšiny formátov súborov sa pri exporte úloh niektoré informácie stratia. ';
$string['feedback'] = 'Spätná väzba';
$string['filecantmovefrom'] = 'Súbory otázok nemôžu byť presunuté, pretože nemáte oprávnenie odstrániť súbory zo zdrojového umiestnenia.';
$string['filecantmoveto'] = 'Súbory otázok nemôžu byť presunuté alebo skopírované, pretože nemáte oprávnenie pridať súbory do cieľového umiestnenia.';
$string['fileformat'] = 'Formát súboru';
$string['filesareacourse'] = 'miesto pre súbory kurzu';
$string['filesareasite'] = 'miesto pre súbory portálu';
$string['filestomove'] = 'Presunúť / kopírovať súbory do {$a}?';
$string['fillincorrect'] = 'Vyplniť správne odpovede';
$string['flagged'] = 'Označené';
$string['flagthisquestion'] = 'Označiť túto otázku';
$string['formquestionnotinids'] = 'Formulár obsahoval otázku, ktorá nemá správny identifikátor';
$string['fractionsnomax'] = 'Jedna alebo viac odpovedí má mať bodovanie 100%, aby bolo možné dosiahnuť plné bodovanie za túto otázku!';
$string['generalfeedback'] = 'Všeobecná spätná väzba';
$string['getcategoryfromfile'] = 'Získať kategóriu zo súboru';
$string['getcontextfromfile'] = 'Získať kontext zo súboru';
$string['hidden'] = 'Skrytý';
$string['hintn'] = 'Pomôcka {#}';
$string['hinttext'] = 'Text pomôcky';
$string['howquestionsbehave'] = 'Ako sa otázky správajú';
$string['ignorebroken'] = 'Ignorovať chybné odkazy';
$string['importcategory'] = 'Importovať kategóriu';
$string['importcategory_help'] = '<p><b>Kategória:</b> na výber kategórie, do ktorej budú importované otázky, je použitý rozbaľovací zoznam.</p>

<p>Niektoré import formáty (GIFT a XML formát) povoľujú špecifikovanie kategórie vo vnútri importovaného súboru. Na to musí byť zaškrtnuté pole <b>zo súboru</b>. Ak nie je, otázky budú pridelené do vybranej kategórie bez ohľadu na inštrukcie v súbore.</p>

<p>Neexistujúce kategórie špecifikované v importovanom súbore budú vytvorené.</p>';
$string['importerror'] = 'Pri spracovaní importu sa vyskytla chyba';
$string['importerrorquestion'] = 'Chyba pri importe otázky';
$string['importfromcoursefiles'] = '... alebo vyberte pre import súbor kurzu';
$string['importfromupload'] = 'Vyberte súbor na nahranie ...';
$string['importingquestions'] = 'Importuje sa {$a} otázok zo súboru';
$string['importquestions'] = 'Importovať otázky zo súboru';
$string['importquestions_help'] = 'Táto funkcia umožňuje import otázok v rozličných formátoch pomocou textového súboru. Tento musí byť v kódovaní UTF-8.';
$string['impossiblechar'] = 'Nesprávny znak {$a} bol zistený ako zátvorka';
$string['includesubcategories'] = 'Zobraziť tiež otázky z podkategórií';
$string['incorrect'] = 'Nesprávny';
$string['information'] = 'Informácia';
$string['invalidanswer'] = 'Nekompletná odpoveď';
$string['invalidarg'] = 'Neboli dodané správne argumenty alebo je nesprávna konfigurácia servera';
$string['invalidcategoryidforparent'] = 'Nesprávny identifikátor kategórie pre nadradenú kategóriu!';
$string['invalidcategoryidtomove'] = 'Nesprávny identifikátor kategórie pre presun!';
$string['invalidconfirm'] = 'Potvrdzujúci reťazec bol nesprávny';
$string['invalidcontextinhasanyquestions'] = 'Nesprávny kontext zaslaný do question_context_has_any_questions.';
$string['invalidpenalty'] = 'Neplatná penalizácia';
$string['invalidwizardpage'] = 'Bola zadaná nesprávna alebo žiadna stránka so sprievodcom.';
$string['lastmodifiedby'] = 'Naposledy upravené';
$string['linkedfiledoesntexist'] = 'Odkazovaný súbor {$a} neexistuje';
$string['makechildof'] = 'Vytvoriť potomka z \'{$a}\'';
$string['makecopy'] = 'Vytvoriť kópiu';
$string['maketoplevelitem'] = 'Presunúť do najvyššej úrovne';
$string['manualgradeoutofrange'] = 'Hodnotenie je mimo povoleného rozsahu';
$string['manuallygraded'] = 'Manuálne hodnotenie {$a->mark} s komentárom: {$a->comment}';
$string['mark'] = 'Hodnotenie';
$string['markedoutof'] = 'Max. hodnotenie';
$string['markedoutofmax'] = 'Max. hodnotenie {$a}';
$string['markoutofmax'] = 'Známka {$a->mark} z {$a->max}';
$string['marks'] = 'Hodnotenia';
$string['matchgrades'] = 'Súhlas známok';
$string['matchgradeserror'] = 'Ak hodnotenie nie je uvedené, nahlásiť chybu';
$string['matchgrades_help'] = 'Importované známky sa musia zhodovať s jednou nasledovných: 100, 90, 80, 75, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (aj záporné hodnoty).

Ak nie, sú dve možnosti:

* Ak známka nie je v zozname, bude hlásená chyba -
Ak otázka zahŕňa známky, ktoré nie sú v zozname, zobrazí sa hlásenie chyby a otázka nebude importovaná
* Ak nie je v zozname, použi najbližšiu hodnotu - Ak sa zistí, že známka sa nezhoduje s hodnotami v zozname, známka je zmenená na najbližšiu hodnotu v zozname.';
$string['matchgradesnearest'] = 'Ak hodnotenie nie je uvedené, použiť najbližšiu';
$string['missingcourseorcmid'] = 'Je potrebné poskytnúť courseid alebo cmid do funkcie print_question.';
$string['missingcourseorcmidtolink'] = 'Je potrebné poskytnúť courseid alebo cmid do funkcie get_question_edit_link.';
$string['missingimportantcode'] = 'Tomuto typu otázky chýba dôležitý kód: {$a}.';
$string['modified'] = 'Naposledy uložené';
$string['move'] = 'Presunúť z {$a} a zmeniť odkazy.';
$string['movecategory'] = 'Presunúť kategóriu';
$string['movedquestionsandcategories'] = 'Presunuté otázky a kategórie otázok z {$a->oldplace} do {$a->newplace}.';
$string['movelinksonly'] = 'Zmeňte iba miesto, kam odkaz ukazuje, nepresúvajte ani nekopírujte súbory.';
$string['moveq'] = 'Presunúť otázky';
$string['moveqtoanothercontext'] = 'Presunúť otázku do iného kontextu.';
$string['moveto'] = 'Presunúť do >>';
$string['movingcategory'] = 'Presunutie kategórie';
$string['movingcategoryandfiles'] = 'Naozaj chcete presunúť kategóriu {$a->name} a všetky podriadené kategórie do kontextu "{$a->contextto}"?<br /> Bolo zistených  {$a->urlcount} súborov odkazovaných z otázok v {$a->fromareaname}, chceli by ste ich skopírovať alebo presunúť do {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Naozaj chcete presunúť kategóriu "{$a->name}" a všetky podriadené kategórie do kontextu "{$a->contextto}"?';
$string['movingquestions'] = 'Presúvanie otázok a súborov';
$string['movingquestionsandfiles'] = 'Naozaj chcete presunúť otázky  {$a->questions} do kontextu <strong>"{$a->tocontext}"</strong>?<br /> Bolo zistených  <strong>{$a->urlcount} súborov</strong> odkazovaných z otázok v {$a->fromareaname}, chceli by ste ich skopírovať alebo presunúť do {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Naozaj chcete presunúť otázky  {$a->questions} do kontextu <strong>"{$a->tocontext}"</strong>?<br /> Nie sú <strong>žiadne</strong> súbory odkazované z otázok v {$a->fromareaname}.';
$string['needtochoosecat'] = 'Potrebujete vybrať kategóriu, do ktorej presuniete otázku. Alebo stlačte \'zrušiť\'.';
$string['nocate'] = 'Žiadna takáto kategória {$a}!';
$string['nopermissionadd'] = 'Nemáte oprávnenia pridávať otázky';
$string['nopermissionmove'] = 'Nemáte oprávnenia odtiaľto presúvať otázky. Musíte otázku uložiť v tejto kategórii alebo ako novú otázku.';
$string['noprobs'] = 'Vo Vašej databáze otázok neboli zistené žiadne problémy.';
$string['noquestionsinfile'] = 'Importovaný súbor neobsahuje žiadne úlohy.';
$string['notanswered'] = 'Nezodpovedané';
$string['notenoughdatatoeditaquestion'] = 'Nebol špecifikovaný ani ID otázky, ani ID kategórie ani typ otázky.';
$string['notenoughdatatomovequestions'] = 'Potrebujete zadať ID otázok, ktoré chcete presunúť.';
$string['notflagged'] = 'Neoznačená';
$string['notgraded'] = 'Nehodnotené';
$string['notshown'] = 'Nezobraziť';
$string['notyetanswered'] = 'Ešte nezodpovedané';
$string['novirtualquestiontype'] = 'Pre otázku typu {$a} neexistuje virtuálna kategória';
$string['numquestions'] = 'Počet otázok';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} hidden)';
$string['options'] = 'Voľby';
$string['parentcategory'] = 'Nadradená kategória';
$string['parentcategory_help'] = '<h2>Nadradená kategória</h2>

<p>Kategória, v ktorej je umiestnená aktuálna kategória. \'Vrch\' znamená, že táto kategória nie je podradenou v žiadnej inej kategórii.</p>

<p>Normálne uvidíte viaceré kontexty kategórií tučným písmom. Každý kontext obsahuje vlastnú hierarchiu kategórií. Ak kontexty nevidíte, tak nemáte na to oprávnenie. </p>

<p>Ak v kontexte existuje iba jedna kategória, nebudete schopní ju presunúť - v každom kontexte musí byť minimálne jedna. </p>

<p>Viď tiež:</p>
<ul>
  <li><a href="help.php?module=question&amp;file=categories.html">Kategórie otázok</a></li>
  <li><a href="help.php?module=question&amp;file=categorycontexts.html">Kontexty kategórií</a></li>
  <li><a href="help.php?module=question&amp;file=permissions.html">Oprávnenia k otázkam</a></li>
</ul>';
$string['parenthesisinproperclose'] = 'Zátvorka pred ** nie je správne uzavretá v {$a}**';
$string['parenthesisinproperstart'] = 'Zátvorka pred ** nie je správne otvorená v {$a}**';
$string['partiallycorrect'] = 'Čiastočne správny';
$string['partiallycorrectfeedback'] = 'Pre ľubovoľnú čiastočne správnu odpoveď';
$string['penaltyfactor'] = 'Trestný faktor';
$string['penaltyfactor_help'] = '<p>Môžete špecifikovať, aká veľká časť dosiahnutého skóre by mala byť odčítaná za každú nesprávnu odpoveď. Táto možnosť je relevantná, ak je v teste povolený adaptívny režim, takže študenti majú povolené na danú úlohu odpovedať opakovane. Trestný faktor by malo byť číslo medzi 0 a 1. Trestný faktor 1 znamená, že študent musí odpovedať správne pri prvom pokuse, aby za otázku dostal vôbec nejaké body. Trestný faktor 0 znamená, že študent môže skúsiť odpovedať koľkokrát chce a vždy dostane plný počet bodov.</p>';
$string['penaltyforeachincorrecttry'] = 'Penalizácia pre každý nesprávny pokus';
$string['permissionedit'] = 'Upraviť túto otázku';
$string['permissionmove'] = 'Presunúť túto otázku';
$string['permissionsaveasnew'] = 'Uložiť ako novú otázku';
$string['permissionto'] = 'Máte oprávnenie na:';
$string['published'] = 'zdieľaná';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Otázka "{$a->name}" ({$a->qtype})</a> je zaradená v tejto kategórii otázok. Zároveň je tiež použitá v <a href="{$a->qurl}"> teste "{$a->quizname}"</a> v kurze "{$a->coursename}".';
$string['questionbank'] = 'Banka otázok';
$string['questionbehaviouradminsetting'] = 'Nastavenia správania otázok';
$string['questionbehavioursorder'] = 'Poradie správania otázok';
$string['questioncategory'] = 'Kategória otázok';
$string['questioncatsfor'] = 'Kategórie otázok pre \'{$a}\'';
$string['questiondoesnotexist'] = 'Táto otázka neexistuje';
$string['questionname'] = 'Názov otázky';
$string['questionno'] = 'Otázka {$a}';
$string['questions'] = 'Otázky';
$string['questionsaveerror'] = 'Nastala chyba počas ukladania otázky - ({$a})';
$string['questionsmovedto'] = 'Otázky, ktoré sú stále používané, boli presunuté do "{$a}" v nadradenej kategórii.';
$string['questionsrescuedfrom'] = 'Otázky uložené z kontextu {$a}.';
$string['questionsrescuedfrominfo'] = 'Tieto otázky (niektoré z nich môžu byť skryté) boli uložené, keď bol vymazaný kontext {$a}, pretože sú využívané v testoch alebo iných aktivitách.';
$string['questiontext'] = 'Text otázky';
$string['questiontype'] = 'Typ otázky';
$string['questionuse'] = 'Použiť otázku v tejto aktivite';
$string['questionx'] = 'Otázka {$a}';
$string['requiresgrading'] = 'Vyžaduje hodnotenie';
$string['responsehistory'] = 'História odpovedí';
$string['restart'] = 'Začať znova';
$string['restartwiththeseoptions'] = 'Začať znova s týmito voľbami';
$string['rightanswer'] = 'Správna odpoveď';
$string['saved'] = 'Uložené: {$a}';
$string['saveflags'] = 'Uložiť stav označenia';
$string['selectacategory'] = 'Zvoľte kategóriu:';
$string['selectaqtypefordescription'] = 'Zvoľte typ otázky pre zobrazenie jej opisu';
$string['selectcategoryabove'] = 'Vybrať kategóriu z uvedených';
$string['selectquestionsforbulk'] = 'Zvoľte otázky pre hromadné akcie';
$string['settingsformultipletries'] = 'Nastavenia pre viaceré pokusy';
$string['shareincontext'] = 'Zdieľať kontext pre {$a}';
$string['showhidden'] = 'Zobraziť aj staré otázky';
$string['showmarkandmax'] = 'Zobraziť známku a maximum';
$string['showmaxmarkonly'] = 'Zobraziť iba známku';
$string['shown'] = 'Zobraziť';
$string['shownumpartscorrect'] = 'Zobraziť počet správnych odpovedí';
$string['shownumpartscorrectwhenfinished'] = 'Zobraziť počet správnych odpovedí';
$string['showquestiontext'] = 'Zobraziť text otázky v zozname otázok';
$string['specificfeedback'] = 'Špecifická spätná väzba';
$string['state'] = 'Stav';
$string['stoponerror'] = 'Zastaviť proces kôli chybe';
$string['stoponerror_help'] = 'Toto nastavenie určuje, či import zastaví na chybe, takže sa neimportujú žiadne otázky, alebo či sa chybné otázky budú ignorovať a správne budú naimportované.';
$string['submit'] = 'Odoslať';
$string['submitandfinish'] = 'Odoslať a ukončiť';
$string['submitted'] = 'Odoslať: {$a}';
$string['tofilecategory'] = 'Zapísať kategóriu do súboru';
$string['tofilecontext'] = 'Zapísať kontext do súboru';
$string['uninstallqtype'] = 'Odinštalovať tento typ otázok';
$string['unknown'] = 'Neznámy';
$string['unknownquestion'] = 'Neznáma otázka: {$a}.';
$string['unknownquestioncatregory'] = 'Neznáma kategória otázok: {$a}.';
$string['unknownquestiontype'] = 'Neznámy typ otázky: {$a}.';
$string['unknowntolerance'] = 'Neznámy typ presnosti {$a}';
$string['unpublished'] = 'nezdieľaná';
$string['upgradeproblemcategoryloop'] = 'Pri aktualizácii kategórií otázok sa vyskytol problém. V systéme kategórií je uzavretá slučka. Identifikátory kategórií, ktorých sa tento problém dotýka, sú {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nepodarilo sa aktualizovať kategóriu otázok {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Pri aktualizácii kategórií otázok sa vyskytol problém. Kategória {$a->id} sa odkazuje na nadradenú kategóriu {$a->parent}, ktorá neexistuje. Nadradená kategória bola zmenená.';
$string['whethercorrect'] = 'Či je správna';
$string['withselected'] = 'S vybranými';
$string['wrongprefix'] = 'Nesprávne formátovaný prefix názvu {$a}';
$string['xoutofmax'] = '{$a->mark} z {$a->max}';
$string['youmustselectaqtype'] = 'Musíte zvoliť typ otázky';
$string['yourfileshoulddownload'] = 'Váš vyexportovaný súbor sa začne čoskoro sťahovať. Ak nie, prosím <a href="{$a}">kliknite sem</a>.';
