<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Adresár pre správu (admin) nie je určený správne';
$string['admindirname'] = 'Adresár pre správu (admin)';
$string['admindirsetting'] = 'Niektorí poskytovatelia web priestoru používajú adresár /admin pre prístup ku kontrolnému panelu, prípadne ku podobným funkciám. To bohužiaľ nie je v súlade so štandardným umiestnením adresáru pre správu v Moodle. Tento konflikt je možné vyriešiť premenovaním adresáru pre správu vo Vašej inštalácii. Vložte sem nový názov, napr.<br /><br />
<b>moodleadmin</b><br /><br />
Tým sa opravia odkazy na správu Moodle.';
$string['admindirsettinghead'] = 'Nastavovanie adresáre \'admin\'...';
$string['admindirsettingsub'] = 'Na niektorých serveroch je URL adresa /admin vyhradená pre špeciálne účely (napr. pre ovládací panel). Na takých serveroch môže dojsť ku kolízii so štandardným umiestením stránok pre správu Moodle. Ak máte tento problém, premenujte adresár \'admin\' vo vašej inštalácii Moodle a do tohto poľa zadajte jeho nový názov. Príklad: <br /> <br /><b>moodleadmin</b><br /> <br />
Všetky generované odkazy na stránky správy Moodle budú používať tento nový názov.';
$string['availablelangs'] = 'Dostupné jazykové balíčky';
$string['caution'] = 'Varovanie';
$string['chooselanguage'] = 'Vyberte jazyk';
$string['chooselanguagehead'] = 'Vyberte jazyk';
$string['chooselanguagesub'] = 'Zvoľte si jazyk pre inštaláciu. Tento jazyk bude tiež použitý ako východzí jazyk portálu, ale môže byť neskôr zmenený.';
$string['cliadminpassword'] = 'Nové heslo administrátora';
$string['cliadminusername'] = 'Login administrátora';
$string['clialreadyinstalled'] = 'Súbor config.php už existuje. Použite admin/cli/upgrade.php ak chcete aktualizovať váš portál.';
$string['cliinstallfinished'] = 'Inštalácia úspešne ukončená';
$string['cliinstallheader'] = 'Mooodle {$a} inštalačný program z príkazového riadku';
$string['climustagreelicense'] = 'V neinteraktívnom móde musíte súhlasiť s licenciou pomocou voľby --agree-license.';
$string['clitablesexist'] = 'Databázové tabuľky už existujú, cli inštalácia nemôže pokračovať.';
$string['compatibilitysettings'] = 'Kontrola nastavenia vášho PHP...';
$string['compatibilitysettingshead'] = 'Kontrola nastavenia vášho PHP...';
$string['compatibilitysettingssub'] = 'Pre správny beh Moodle by váš server mal vyhovieť vo všetkých nasledujúcich testoch.';
$string['configfilenotwritten'] = 'Inštalačný skript nebol schopný automaticky vytvoriť config.php súbor, obsahujúci Vaše zvolené nastavenia, pravdepodobne preto, že adresár Moodle nie je zapisovateľný. Môžete ručne skopírovať nasledovný kód do súboru s názvom config.php v rámci  koreňového adresára Moodle.';
$string['configfilewritten'] = 'súbor config.php bol úspešne vytvorený';
$string['configurationcomplete'] = 'Konfigurácia ukončená';
$string['configurationcompletehead'] = 'Konfigurácia ukončená';
$string['configurationcompletesub'] = 'Moodle sa pokúsil uložiť súbor s konfiguráciou do koreňového adresára inštalácie Moodle.';
$string['database'] = 'Databáza';
$string['databasehead'] = 'Nastavenia databázy';
$string['databasehost'] = 'Databázový server';
$string['databasename'] = 'Názov databázy';
$string['databasepass'] = 'Heslo pre databázu';
$string['databasesocket'] = 'Unixový socket';
$string['databasetypehead'] = 'Vyberte driver pre databázu';
$string['databasetypesub'] = 'Moodle podporuje viaceré typy databázových serverov. Kontaktujte administrátora SQL servera, ak neviete, ktorý z nich použiť.';
$string['databaseuser'] = 'Databázový používateľ';
$string['dataroot'] = 'Adresár pre údaje';
$string['datarooterror'] = '\'Adresár pre údaje\', ktorý ste zadali, nemôže byť nájdený alebo vytvorený. Upravte buď cestu alebo vytvorte ten adresár ručne.';
$string['datarootpublicerror'] = 'Adresár \'data\', ktorý ste zvolili, je priamo dostupný z webu. Musíte zvoliť iný adresár.';
$string['dbconnectionerror'] = 'Nemohli sme sa pripojiť k vami zadanej databáze. Prosím skontrolujte nastavenia Vašej databázy.';
$string['dbcreationerror'] = 'Chyba pri vytváraní databázy. Ale bolo možné vytvoriť databázu so zadaným menom a jej nastaveniami';
$string['dbhost'] = 'Hosťovský server';
$string['dbpass'] = 'Heslo';
$string['dbprefix'] = 'Predpona tabuliek';
$string['dbtype'] = 'Typ';
$string['directorysettings'] = '<p>Prosím, potvrďte umiestnenie inštalácie Moodle.</p>

<p><b>Web adresa:</b> Špecifikujte celú web adresu, kde bude Moodle umiestnený. Ak sa na túto adresu pristupuje z viacerých url adries, potom vyberte tú, ktorú budú používať Vaši študenti. Na konci nepoužívajte lomítko.</p>

<p><b>Adresár Moodle:</b> Špecifikujte celú cestu k adresáru a tejto inštalácii. Ubezpečte sa, že ste korektne použili veľké a malé písmená.</p>

<p><b>Adresár pre údaje:</b> Potrebujete miesto, kde Moodle bude ukladať prenášané súbory. Tento adresár by mal byť používateľovi webového servera prístupný aj na čítanie, aj na ZAPISOVANIE (zvyčajne \'nobody\' alebo \'apache\'), ale nemalo by sa dať k nemu pristupovať priamo z webu. Inštalátor bude skúšať ho vytvoriť, ak neexistuje.</p>';
$string['directorysettingshead'] = 'Potvrďte prosím adresy tejto inštalácie Moodle.';
$string['directorysettingssub'] = '<b>Webová adresa</b>:
zadajte celú webovú adresu, na ktorej bude Moodle dostupný. Ak sú vaše stránky dostupné na viacerých URL, vyberte z nich tú, ktorú budú vaši študenti používať najčastejšie. Na konci adresy nepíšte lomítko.
<br />
<br />
<b>Adresár Moodle</b>:
zadajte celú cestu k adresáru s touto inštaláciou. Uistite sa, že sú v nej správne uvedené malé/VEĽKÉ písmená.
<br />
<br />
<b>Dátový adresár</b>:
potrebujete diskový priestor, kam bude Moodle ukladať nahrané (uploadované) súbory. K tomuto adresári musí mať proces webového serveru právo na čítanie A ZÁPIS (webový server býva spustený pod užívateľom \'nobody\' alebo \'apache\' alebo podobne). Tento adresár by ale zároveň nemal byť dostupný priamo cez webové rozhranie (môže obsahovať neverejné údaje). Inštalátor bude skúšať ho vytvoriť, ak neexistuje.';
$string['dirroot'] = 'Adresár Moodle';
$string['dirrooterror'] = 'Nastavenia v \'Adresári Moodle\' sú nesprávne - nie je možné nájsť inštaláciu Moodle. Hodnota nižšie bola vynulovaná.';
$string['download'] = 'Stiahnuť';
$string['downloadlanguagebutton'] = 'Stiahnuť jazykový balíček "{$a}"';
$string['downloadlanguagehead'] = 'Stiahnuť jazykový balíček';
$string['downloadlanguagenotneeded'] = 'V inštalácii je možné pokračovať v jazyku "{$a}".';
$string['downloadlanguagesub'] = 'Teraz máte možnosť si stiahnuť si niektorý z jazykových balíčkov Moodle a pokračovať v tomto jazyku.<br /><br />Ak si práve nemôžete alebo nechcete stiahnuť jazykový balíček, bude inštalačný proces pokračovať v angličtine. Jazykové balíčky si budete môcť stiahnuť aj neskôr po ukončení inštalácie.';
$string['doyouagree'] = 'Súhlasíte ? (áno/nie)';
$string['environmenthead'] = 'Kontrola programového prostredia...';
$string['environmentsub'] = 'Teraz sa preveruje, či vybrané komponenty vášho systému splňujú požiadavky inštalácie.';
$string['errorsinenvironment'] = 'Kontrola programového prostredia zlyhala!';
$string['fail'] = 'Neúspešné';
$string['fileuploads'] = 'prenesené súbory';
$string['fileuploadserror'] = 'Toto by malo byť zapnuté';
$string['fileuploadshelp'] = '<p>Zdá sa, že na Vašom serveri nie je aktivovaný prenos súborov.</p>

<p>Moodle môže byť aj napriek tomu nainštalovaný, ale bez tejto možnosti, nebudete schopní preniesť súbory kurzu, alebo obrázky v nových používateľských profiloch.</p>

<p>Na aktivovanie prenosu súborov, Vy (alebo Váš systémový administrátor) budete musieť upraviť main php.ini súbor v systéme a zmeniť nastavenie pre <b>file_uploads</b> na \'1\'.</p>';
$string['inputdatadirectory'] = 'Dátový adresár :';
$string['inputwebadress'] = 'Webová adresa :';
$string['inputwebdirectory'] = 'Moodle adresár :';
$string['installation'] = 'Inštalácia';
$string['langdownloaderror'] = 'Bohužiaľ, jazyk "{$a}" sa nepodarilo nainštalovať. Inštalácia bude pokračovať v angličtine.';
$string['langdownloadok'] = 'Podarilo so úspešne nainštalovať jazykový balíček "{$a}". Inštalácia bude pokračovať v tomto jazyku.';
$string['magicquotesruntime'] = 'Magic Quotes Run Time';
$string['magicquotesruntimeerror'] = 'Toto by malo byť vypnuté';
$string['magicquotesruntimehelp'] = '<p>Magic quotes runtime by malo byť vypnuté, aby Moodle fungoval tak, ako má.</p>

<p>Zvyčajne je voľba štandardne vypnutá ... pozri nastavenia <b>magic_quotes_runtime</b> vo Vašom php.ini súbore.</p>

<p>Ak nemáte prístup k súboru php.ini, mali by ste nasledovný riadok do súboru s názvom .htaccess v rámci adresára Moodle: </p>
<blockquote><div>php_value magic_quotes_runtime Off</div></blockquote>
';
$string['memorylimit'] = 'Limit pamäte';
$string['memorylimiterror'] = 'PHP limit pamäte je nastavený na minimum...S týmto môžete mať neskôr problémy.';
$string['memorylimithelp'] = '<p>PHP limit pamäte pre Váš server je momentálne nastavený na {$a}.</p>

<p>Toto môže neskôr spôsobiť problémy v Moodle, najmä ak máte veľa modulov a/alebo veľa používateľov.</p>

<p>Odporúčame Vám, aby ste nastavili PHP s vyšším limitom pamäte, ak je to možné, napr. 40M. Na to existuje veľa spôsobov, ktoré môžete vyskúšať:</p>
<ol>
<li>Ak je to možné, znovu vytvorte PHP s <i>--enable-memory-limit</i>. Toto umožní Moodle samonastavenie limitu pamäte.</li>
<li>Ak máte prístup k Vášmu php.ini súboru, môžete zmeniť <b>memory_limit</b> nastavenie, napr. na 40M. Ak nemáte prístup k súboru, môžete sa na to spýtať Vášho administrátora.</li>
Na niektorých PHP serveroch, si môžete vytvoriť súbor .htaccess v Adresári Moodle, ktorý bude obsahovať tento riadok: <p><blockquote><div>php_value memory_limit 40M</div></blockquote></p>
<p>Avšak, na niektorých serveroch bude toto brániť <b>všetkým</b> PHP stránkam v práci (budete vidieť chyby, keď sa pozriete na stránky), takže budete musieť odstrániť súbor .htaccess.</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované s MSSQL rozšírením, a tak nemôže komunikovať s SQL*Server. Prosím, skontrolujte si Váš php.ini súbor alebo znovu vytvorte PHP.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované s rozšírením MySQLi, aby mohlo komunikovať s MySQL. Skontrolujte svoj súbor php.ini alebo prekompilujte PHP. Rozšírenie MySQLi  nie je dostupné pre PHP 4.';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Teraz je potrebné nakonfigurovať databázu, kam bude Moodle ukladať dáta. Táto databáza už musí byť vytvorená spolu s užívateľským menom a heslom pre prístup do databázy. Predpona tabuliek je povinná.';
$string['nativemysqli'] = 'Vylepšená MySQL (natívne / mysqli)';
$string['nativemysqlihelp'] = 'Teraz je potrebné nakonfigurovať databázu, kam bude Moodle ukladať dáta. Databáza môže byť vytvorená iba ak uvedený užívateľ má oprávnenie vytvárať nové databázy.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Teraz je potrebné nakonfigurovať databázu, kam bude Moodle ukladať dáta. Databáza, spolu s menom a heslom musí byť už vytvorená. Predpona tabuliek je povynná.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Teraz je potrebné nakonfigurovať databázu, kam bude Moodle ukladať dáta. Databáza, spolu s menom a heslom musí byť už vytvorená. Predpona tabuliek je povynná.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Teraz je potrebné nakonfigurovať databázu, kam bude Moodle ukladať dáta. Databáza, spolu s menom a heslom musí byť už vytvorená. Predpona tabuliek je povynná.';
$string['ociextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované s OCI8 rozšírením, a tak nemôže komunikovať s Oracle. Prosím, skontrolujte si Váš php.ini súbor alebo znovu vytvorte PHP.';
$string['pass'] = 'Prejsť';
$string['paths'] = 'Cesty';
$string['pathserrcreatedataroot'] = 'Inštalátor nemôže vytvoriť dátový adresár ({$a->dataroot}). ';
$string['pathshead'] = 'Vytvoriť cesty';
$string['pathsrodataroot'] = 'Kmeňový adresár nie je zapisovateľný';
$string['pathsroparentdataroot'] = 'Nadriadený adresár ({$a->parent}) nie je zapisovateľný. Inštalátor nemôže vytvoriť dátový adresár ({$a->dataroot}). ';
$string['pathssubdataroot'] = 'Potrebujete adresár, kam Moodle bude ukladať nahrané súbory. Adresár by mal povoliť čítanie a zapisovanie údajov používateľom web serveru, ale nesmie byť prístupný priamo cez web rozhranie. Pokiaľ ešte neexistuje, inštalácia sa pokúsi o jeho vytvorenie. ';
$string['pathssubdirroot'] = 'Plná cesta adresára moodle inštalácie';
$string['pathsunsecuredataroot'] = 'Umiestnenie dátového adresára nie je bezpečné';
$string['pathswrongadmindir'] = 'Administrátorský adresár neexistuje';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované s PGSQL rozšírením, a tak nemôže komunikovať s PostgreSQL. Prosím, skontrolujte si Váš php.ini súbor alebo znovu vytvorte PHP.';
$string['phpextension'] = 'Rozšírenie PHP {$a}';
$string['phpversion'] = 'Verzia PHP';
$string['phpversionhelp'] = '<p>Moodle si vyžaduje verziu PHP aspoň  4.3.0 alebo 5.1.0 (5.0.x obsahuje veľa známych chýb).</p>
<p>Vy máte momentálne nainštalovanú túto verziu {$a}.</p>
<p>Musíte aktualizovať PHP alebo sa presunúť na hostiteľský počítač s novšou verziou PHP!<br />(V prípade 5.0.X môžete tiež prejsť na verziu 4.4.x)</p>';
$string['releasenoteslink'] = 'Pre viac informácií o tejto verzii Moodle viď poznámky k vydaniu tu: {$a}';
$string['safemode'] = 'Bezpečný mód';
$string['safemodeerror'] = 'Moodle môže mať problémy, ak je zapnutý bezpečný mód';
$string['safemodehelp'] = '<p>Moodle môže mať viacero problémov, ak je zapnutý bezpečný mód, pravdepodobne nedovolí vytvárať nové súbory.</p>

<p>Bezpečný mód je zvyčajne povolený verejnými poskytovateľmi webového priestoru, takže by ste si mali nájsť nového poskytovateľa webového priestoru pre stránku Moodle.</p>';
$string['sessionautostart'] = 'Autoštart sekcie';
$string['sessionautostarterror'] = 'Toto by malo byť vypnuté';
$string['sessionautostarthelp'] = '<p>Moodle vyžaduje podporu sekcií a nebude bez nich fungovať.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP nebolo správne nakonfigurované pre rozšírenie PHP. Prosím skontrolujte váš súbor php.ini alebo rekompilujte PHP.';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Podarilo so vám úspešne nainštalovať a spustiť balíček <strong>{$a->packname} {$a->packversion}</strong>. Gratulujeme!';
$string['welcomep30'] = '<strong>{$a->installername}</strong> obsahuje aplikáciu k vytvoreniu prostredia, v ktorom bude prevádzkovaný váš <strong>Moodle</strong>. Menovite sa jedná o:';
$string['welcomep40'] = 'Balíček tiež obsahuje <strong>Moodle vo verzii {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Použitie všetkých aplikácií v tomto balíčku je viazané ich príslušnými licenciami. Kompletný balíček <strong>{$a->installername}</strong> je software s <a href="http://www.opensource.org/docs/definition_plain.html"> otvoreným kódom (open source)</a> a je šírený pod licenciou <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'Nasledujúce stránky vás povedú v nekoľkých jednoduchých krokoch nastavením <strong>Moodle</strong> na vašom počítači. Môžete prijať východzie nastavenie, alebo si ich upraviť podľa svojich potrieb.';
$string['welcomep70'] = 'Stlačením nižšie uvedeného tlačidla "Ďalší" pokračujte v nastavení vašej inštalácie Moodle.';
$string['wwwroot'] = 'Web adresa';
$string['wwwrooterror'] = 'Táto web adresa pravdepodobne nie je platná - táto inštalácia Moodle tu pravdepodobne nie je.';
