<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivity';
$string['addcategory'] = 'Pridať kategóriu';
$string['addcategoryerror'] = 'Nepodarilo sa pridať kategóriu';
$string['addexceptionerror'] = 'Pri pridávaní výnimky pre userid:gradeitem sa vyskytla chyba';
$string['addfeedback'] = 'Pridať komentár';
$string['addgradeletter'] = 'Pridať slovnú známku';
$string['addidnumbers'] = 'Pridať identifikátory';
$string['additem'] = 'Pridať položku hodnotenia';
$string['addoutcome'] = 'Pridať očakávaný cieľ';
$string['addoutcomeitem'] = 'Pridať hodnotený cieľ';
$string['addscale'] = 'Pridať stupnicu';
$string['aggregateextracreditmean'] = 'Priemer známok (s extra bodmi)';
$string['aggregatemax'] = 'Najvyššia známka';
$string['aggregatemean'] = 'Priemer známok';
$string['aggregatemedian'] = 'Medián známok';
$string['aggregatemin'] = 'Najnižšia známka';
$string['aggregatemode'] = 'Početnosť známok';
$string['aggregateonlygraded'] = 'Súhrnná známka iba z neprázdnych známok';
$string['aggregateonlygraded_help'] = '<p>Neexistujúce známky sú alebo chápané ako minimálne alebo nie sú zahrnuté v súhrne.</p>';
$string['aggregateoutcomes'] = 'Zahrnúť ciele do súhrnnej známky';
$string['aggregateoutcomes_help'] = '<p>Zahrnutie cieľov do súhrnnej známky nemusí viesť k žiadanému výsledku. Preto je možnosť ich zahrnúť alebo nie.</p>';
$string['aggregatesonly'] = 'Iba súhrnné známky';
$string['aggregatesubcats'] = 'Súhrnná známka zahŕňa podkategórie';
$string['aggregatesubcats_help'] = '<p>Výpočet súhrnnej známky obvykle je obvykle spracovaný iba v priamych potomkoch. Je ju tiež možno vypočítať na základe vybraných známok vo všetkých podkategóriách s výnimkou iných súhrnných známok.</p>';
$string['aggregatesum'] = 'Súčet známok';
$string['aggregateweightedmean'] = 'Vážený priemer známok';
$string['aggregateweightedmean2'] = 'Jednoduchý vážený priemer známok';
$string['aggregation'] = 'Súhrnná známka';
$string['aggregationcoef'] = 'Násobiaci koeficient';
$string['aggregationcoefextra'] = 'Extra body';
$string['aggregationcoefextra_help'] = '<h2>Súčet známok</h2>
<p>Ak sa používa výpočet známky stratégiou "Súčet známok", potom položka známkovania môže byť určená ako body naviac vo svojej kategórii. Znamená to, že jej maximálna hodnota nebude pripočítaná k maximu celej kategórie, ale hodnota známky áno. Uvažujme nasledovný príklad:</p>

<ul>
    <li>Položka 1 je hodnotená 0-100</li>
    <li>Položka 2 je hodnotená 0-75</li>
    <li>Položka 1 má "Kredit naviac", Položka 2 nie.</li>
    <li>Obe položky patria do Kategórie 1, ktorá využíva výpočet "Súčet známok"</li>
    <li>Celková známka v Kategórii 1 je 0-75</li>
    <li>Uvažujme, že študent získa 20 z Položky 1 a 70 z Položky  2</li>
    <li>Jeho celková známka v Kategórii 1 bude 75/75 (20+70 = 90, ale Položka 1 sú extra body, takže celková známka je na maxime)</li>
</ul>
<h2>Priemer známok (s extra bodmi)</h2>
<p>Hodnota väčšia ako 0 je počas výpočtu celkovej známky u položiek v tejto kategórii chápaná ako Extra kredit. Zadané číslo vynásobí známku a výsledok bude použitý do sčítania všetkých známok. Avšak, samotná položka nebude počítaná v delení.  Uvažujme nasledovný príklad:</p>

<ul>
    <li>Položka 1 je hodnotená 0-100 a "Kredit naviac" je  2</li>
    <li>Položka 2 je hodnotená 0-100 a "Kredit naviac" je 0.0000</li>
    <li>Položka 3 je hodnotená 0-100 a "Kredit naviac" je 0.0000</li>
    <li>Všetky 3 položky patria do kategórie 1, ktorá má výpočtovú stratégiu "Priemer známok (s extra bodmi)"</li>
    <li>Uvažujme, že študent získa 20 na Položke 1, 40 na Položke 2 a 70 na Položke 3</li>
    <li>Jeho celková známka v Kategórii 1 bude 95/100, pretože 20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefextrasum'] = 'Extra body';
$string['aggregationcoefextrasum_help'] = '<p>Ak sa použije výpočtová stratégia "Súčet známok", každá položka známkovania v danej kategórii môže byť nastavená ako extra body. To znamená, že maximum zo známky nebude pripočítané k celkovej maximálnej hodnote kategórie, ale hodnota známky bude pripočítaná k ostatným hodnotám. Uvažujme nasledovný príklad:</p>

<ul>
    <li>Položka 1 s hodnotou 0-100</li>
    <li>Položka 2 s hodnotou 0-75</li>
    <li>Položka 1 má aktivovanú funkcionalitu "Extra body", položka 2 nemá.</li>
    <li>Obe položky patria do Kategórie 1, ktorá má nastavenú výpočtovú stratégiu "Súčet známok" pre výpočet celkovej známky</li>
    <li>Celková hodnota v kategórii 1 bude 0-75</li>
    <li>Študent dostane hodnotenie 20 na Položke 1 a 70 na Položke 2</li>
    <li>Celkové hodnotenie v Kategórii 1 bude 75/75 (20+70 = 90, ale Položka 1 je naviac, a preto je celková známka na maxime)</li>
</ul>';
$string['aggregationcoefextraweight'] = 'Váha pre extra body';
$string['aggregationcoefextraweight_help'] = '<p>Hodnota väčšia ako 0 je počas výpočtu celkovej známky u položiek v tejto kategórii chápaná ako Extra kredit. Zadané číslo vynásobí známku a výsledok bude použitý do sčítania všetkých známok. Avšak, samotná položka nebude počítaná v delení.  Uvažujme nasledovný príklad:</p>

<ul>
    <li>Položka 1 je hodnotená 0-100 a "Kredit naviac" je  2</li>
    <li>Položka 2 je hodnotená 0-100 a "Kredit naviac" je 0.0000</li>
    <li>Položka 3 je hodnotená 0-100 a "Kredit naviac" je 0.0000</li>
    <li>Všetky 3 položky patria do kategórie 1, ktorá má výpočtovú stratégiu "Priemer známok (s extra bodmi)"</li>
    <li>Uvažujme, že študent získa 20 na Položke 1, 40 na Položke 2 a 70 na Položke 3</li>
    <li>Jeho celková známka v Kategórii 1 bude 95/100, pretože 20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefweight'] = 'Váha položky';
$string['aggregationcoefweight_help'] = '<p>Percentuálny podiel všetkých hodnotení tejto kategórie vzhľadom k ostatným kategóriám.</p>';
$string['aggregation_help'] = '<p>Toto menu dovoľuje vybrať stratégiu výpočtu súhrnnej známky v danej kategórii. Rozličné možnosti sú vysvetlené nižšie.</p>

<p>
Interne sa každá položka známok najprv konvertuje na číslo medzi
0 a 1 (určia sa jej percentá vzhľadom k maximálnej dostupnej
známke). Potom sa na všetky známky v kategórii aplikuje stratégia
výpočtu súhrnnej známky. V poslednej etape sa určí známka kategórie
vzhľadom na nastavené <em>minimum</em> a <em>maximum</em>).</p>

<p><strong>Dôležité</strong>: Prázdna známka je chýbajúcou položkou výkazu a môžeme to chápať rozlične. Napríklad, je to účastník, ktorý ešte neodovzdal zadanie, zadanie, ktoré ešte nebolo učiteľom hodnotené, alebo hodnotenie, ktoré bolo manuálne vymazané administrátorom výkazu. Takže treba interpretovať prázdne známky opatrne.</p>

<dl id="grade-aggregation-help">
    <dt>Priemer známok</dt>
    <dd>Jednoduchý súčet všetkých normovaných známok vydelený ich počtom.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, maximum kategórie 100:<br />
                     <code>(0.7 + 0.25 + 1.0)/3 = 0.65 --> 65/100</code></dd>

    <dt>Vážený priemer známok</dt>
        <dd>Pre každú položku známok definujeme jej váhu, ktorou ovplyvňuje (násobí) výslednú známku. Priemer sa počíta až na základe takto modifikovanej hodnoty.</dd>
        <dd class="example">A1 70/100 váha 10, A2 20/80 váha 5, A3
                         10/10 váha 3, maximum kategórie 100:<br /><code>(0.7*10 + 0.25*5 + 1.0*3)/18 = 0.625 --> 62.5/100</code></dd>

    <dt>Jednoduchý vážený priemer známok</dt>
        <dd>Na rozdiel od stratégie <em>Vážený priemer známok</em> je váha vypočítaná ako rozdiel medzi <em>Maximálna známka</em> - <em>Minimálna známka</em> pre každú položku. 100 bodové zadanie má váhu 100, 10 bodové zadanie váhu 10.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, maximum kategórie 100:<br />
                         <code>(0.7*100 + 0.25*80 + 1.0*10)/190 = 0.526 --> 52.6/100</code></dd>

    <dt>Priemer známok (s extra bodmi)</dt>
        <dd>Toto je výpočet potrebný len pre kurzy aktualizované z predošlých verzií Moodle, normálne sa nepoužíva.</dd>

    <dt>Medián známok</dt>
        <dd> Medián na rozdiel od priemeru vyjadruje, ktorá
  známka je v strede usporiadaného zoznamu známok. Ak je známok párny
  počet, potom je to priemer dvoch stredných. Je menej citlivý na
  známky na okraji stupnice, ktoré sú často nepresné.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, maximum kategórie 100:<br />
                         <code>median(0.7 ; 0.25 ; 1.0) = 0.7 --> 70/100</code></dd>

    <dt>Najnižšia známka</dt>
        <dd>Výsledkom je najnižšia známka po normalizácii. Obyčajne sa používa so stratégiou <em>Súhrnná známka iba z neprázdnych známok</em>.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, maximum kategórie 100:<br />
                         <code>min(0.7 ; 0.25 ; 1.0) = 0.25 --> 25/100</code></dd>

    <dt>Najvyššia známka</dt>
        <dd>Výsledkom je najvyššia známka po normalizácii.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, maximum kategórie 100:<br />
                         <code>max(0.7 ; 0.25 ; 1.0) = 1.0 --> 100/100</code></dd>

    <dt>Početnosť známok</dt>
        <dd>Súhrnná známka bude tá, ktorá sa vyskytuje najčastejšie. Tento spôsob využívame najmä pri nečíselných známkach. Na rozdiel od priemeru je menej citlivá na známky na okraji stupnice, ktoré sú často nepresné. Nemá zmysel, keď sú všetky známky rozličné, alebo keď má viacero známok rovnaký počet výskytov - iba posledná z nich  by bola použitá.</dd>
        <dd class="example">A1 70/100, A2 35/50, A3 20/80, A4 10/10, A5 7/10 maximum kategórie 100:<br />
                         <code>mode(0.7 ; 0.7 ; 0.25 ; 1.0 ; 0.7) = 0.7 --> 70/100</code></dd>

    <dt>Súčet známok</dt>
        <dd>Súčet všetkých známok. Toto je jediný typ výpočtu, ktorý neráta vnútorne s percentami a nenormalizuje.  <em>Maximálna známka</em> je daná súčtom maxím všetkých položiek.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10:<br />
                         <code>70 + 20 + 10 = 100/190</code></dd>
</dl>';
$string['aggregationposition'] = 'Umiestnenie súhrnnej známky';
$string['aggregationposition_help'] = '<p>Určuje pozíciu stĺpca súhrnnej známky v známkovom výkaze vzhľadom na známky, z ktorých je vypočítavaný súhrn. </p>';
$string['aggregationsvisible'] = 'Dostupné súhrnné známky';
$string['aggregationsvisiblehelp'] = 'Vyznačte všetky typy súhrnných známok, ktoré majú byť dostupné. Používajte klávesu CTRL na výber viacerých položiek.';
$string['allgrades'] = 'Všetky známky podľa kategórie';
$string['allstudents'] = 'Všetci študenti';
$string['allusers'] = 'Všetci používatelia';
$string['autosort'] = 'Automatické triedenie';
$string['availableidnumbers'] = 'Dostupné identifikátory';
$string['average'] = 'Priemer';
$string['averagesdecimalpoints'] = 'Počet desatinných miest v stĺpcových priemeroch';
$string['averagesdecimalpoints_help'] = '<p>Určuje počet desatinných miest v stĺpcových priemeroch. Ak je zvolené Zdediť, použije sa rovnaké zobrazenie ako pre každý stĺpec. </p>';
$string['averagesdisplaytype'] = 'Typ zobrazenia stĺpcových priemerov';
$string['averagesdisplaytype_help'] = '<p>Určuje spôsob zobrazenia priemerov stĺpcov. Ak je zvolené Zdediť, použije sa rovnaké zobrazenie ako pre každý stĺpec. </p>';
$string['backupwithoutgradebook'] = 'Záloha neobsahuje konfiguráciu známok';
$string['badgrade'] = 'Dodaná známka je neplatná';
$string['badlyformattedscale'] = 'Zadajte zoznam oddelený čiarkami (je potrebné zadať minimálne dve položky)';
$string['baduser'] = 'Dodaný používateľ je neplatný';
$string['bonuspoints'] = 'Body naviac (bonus)';
$string['bulkcheckboxes'] = 'Hromadné checkboxy';
$string['calculatedgrade'] = 'Vypočítaná známka';
$string['calculation'] = 'Výpočet';
$string['calculationadd'] = 'Pridať výpočet';
$string['calculationedit'] = 'Upraviť výpočet';
$string['calculation_help'] = 'Výpočet známky je vzorec. Musí začínať rovnítkom a môže využívať štandardné matematické operácie ako max, min, sum. Ak je potrebné, môžu byť do známky vybrané individuálne položky známok na základe svojho identifikátora v dvojitých hranatých zátvorkách.';
$string['calculationsaved'] = 'Výpočet uložený';
$string['calculationview'] = 'Prezrieť výpočet';
$string['cannotaccessgroup'] = 'Ľutujem, známky vybranej skupiny nie sú dostupné.';
$string['categories'] = 'Kategórie';
$string['categoriesanditems'] = 'Kategórie a položky';
$string['categoriesedit'] = 'Upraviť kategórie a položky';
$string['category'] = 'Kategória';
$string['categoryedit'] = 'Upraviť kategóriu';
$string['categoryname'] = 'Názov kategórie';
$string['categorytotal'] = 'Kategória spolu';
$string['categorytotalfull'] = '{$a->category} spolu';
$string['categorytotalname'] = 'Názov celkového súčtu kategórie';
$string['changedefaults'] = 'Zmeniť predvoľby';
$string['changereportdefaults'] = 'Zmeniť predvoľby výkazu';
$string['chooseaction'] = 'Vyberte činnosť ...';
$string['choosecategory'] = 'Vyberte si kategóriu';
$string['combo'] = 'Záložky a rozbaľovací zoznam';
$string['compact'] = 'Kompaktný';
$string['contract'] = 'Zbaliť kategóriu';
$string['controls'] = 'Nastavenia';
$string['courseavg'] = 'Priemer kurzu';
$string['coursegradecategory'] = 'Kategória známok kurzu';
$string['coursegradedisplaytype'] = 'Typ zobrazovania známok kurzu';
$string['coursegradedisplayupdated'] = 'Typ zobrazovania známok kurzu bol aktualizovaný.';
$string['coursegradesettings'] = 'Nastavenia známok kurzu';
$string['coursename'] = 'Názov kurzu';
$string['coursescales'] = 'Stupnice kurzu';
$string['coursesettings'] = 'Nastavenia kurzu';
$string['coursesettingsexplanation'] = 'Nastavenia kurzu, ktoré určujú výzor známkového výkazy účastníkom kurzu.';
$string['coursetotal'] = 'Súčet kurzu';
$string['createcategory'] = 'Vytvoriť kategóriu';
$string['createcategoryerror'] = 'Nebolo možné vytvoriť novú kategóriu';
$string['creatinggradebooksettings'] = 'Vytvára sa nastavenie klasifikácie';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Typ výpočtu sumárnej známky v nadradenej kategórii';
$string['curveto'] = 'Prepočítať na';
$string['decimalpoints'] = 'Celkové desatinné miesta';
$string['decimalpoints_help'] = '<p>Určuje počet desatinných miest zobrazovaných v každej známke. Nastavenie nemá vplyv na výpočty známok, ktoré sú s presnosťou na 5 desatinných miest.</p>';
$string['default'] = 'Predvolené';
$string['defaultprev'] = 'Predvolené ({$a})';
$string['deletecategory'] = 'Vymazať kategóriu';
$string['disablegradehistory'] = 'Vypnúť históriu známok';
$string['disablegradehistory_help'] = 'Zakázať históriu sledovania zmien v tabuľkách súvisiacich so známkovaním. Toto môže zrýchliť server a zmenšiť potrebné miesto v databáze.';
$string['displaylettergrade'] = 'Zobraziť slovné známky';
$string['displaypercent'] = 'Zobraziť percentá';
$string['displaypoints'] = 'Zobraziť body';
$string['displayweighted'] = 'Zobraziť vážené známky';
$string['dropdown'] = 'Rozbaľovací zoznam';
$string['droplow'] = 'Ignorovať najnižšie';
$string['droplow_help'] = '<p>Ak je táto voľba nastavená, nebude sa pri výpočte uvažovať X najnižších hodnotení, kde X je zvolená hodnota tejto voľby.</p>';
$string['dropped'] = 'Ignorované';
$string['dropxlowest'] = 'Ignorovať X najhorších';
$string['dropxlowestwarning'] = 'Poznámka: Ak použijete ignorovať X najhorších, systém známkovania si bude myslieť, že všetky položky v kategórii budú mať tú istú bodovú hodnotu. Ak sa bodové hodnoty odlišujú, výsledky budú nepredvídateľné.';
$string['duplicatescale'] = 'Duplikovať stupnicu';
$string['edit'] = 'Upraviť';
$string['editcalculation'] = 'Upraviť výpočet';
$string['editcalculationverbose'] = 'Upraviť výpočet pre {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Upraviť komentár';
$string['editgrade'] = 'Upraviť známku';
$string['editgradeletters'] = 'Upraviť slovné známky';
$string['editoutcome'] = 'Upraviť cieľ';
$string['editoutcomes'] = 'Upraviť ciele';
$string['editscale'] = 'Upraviť stupnicu';
$string['edittree'] = 'Kategórie a položky';
$string['editverbose'] = 'Upraviť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Povoliť AJAX';
$string['enableajax_help'] = 'Pridať funkcionalitu AJAX pri práci so známkami - zjednodušenie a zrýchlenie základných operácií. Závisí od zapnutia Javascriptu v prehliadači používateľa.';
$string['enableoutcomes'] = 'Povoliť ciele';
$string['enableoutcomes_help'] = 'Podpora pre Ciele (tiež známe ako Kompetencie, Kritériá) znamená, že môžeme hodnotiť aktivity pomocou jednej alebo viacerých stupníc spojených s definovanými cieľmi. Povolenie cieľov umožňuje podporu takéhoto hodnotenia na celom portáli.';
$string['encoding'] = 'Kódovanie';
$string['errorcalculationnoequal'] = 'Vzorec musí začať značkou rovná sa (=1+2)';
$string['errorcalculationunknown'] = 'Chybný vzorec';
$string['errorgradevaluenonnumeric'] = 'Nenumerická hodnota známky:';
$string['errornocalculationallowed'] = 'Pre túto položku nie sú povolené výpočty';
$string['errornocategorisedid'] = 'Nebolo možné získať nekategorizovaný identifikátor';
$string['errornocourse'] = 'Nebolo možné získať informácie o kurze';
$string['errorreprintheadersnonnumeric'] = 'Hodnota nenumerického typu pre opakujúcu sa hlavičku';
$string['errorsavegrade'] = 'Ľutujeme, nebolo možné uložiť známku.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Chyba pri aktualizácii nastavenia "Výpočty iba na neprázdnych známkach" v kategórii s ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Chyba pri aktualizácii nastavenia "Zahrnúť ciele vo výpočtoch" v kategórii s ID {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Chyba pri aktualizácii nastavenia "Výpočty aj v podkategóriách" vkategórii s ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Chyba pri aktualizácii typu výpočtu v kategórii s ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Chyba pri aktualizácii výpočtového koeficienta (váha alebo extra body) v položke hodnotenia s ID {$a->id}';
$string['excluded'] = 'Vyňatá';
$string['excluded_help'] = '<p>Ak je toto nastavenie zapnuté, táto známka nebude uvažovaná pri žiadnych výpočtoch v nadradených položkách a kategóriách.</p>';
$string['expand'] = 'Rozbaliť kategóriu';
$string['export'] = 'Export';
$string['exportalloutcomes'] = 'Exportovať všetky ciele';
$string['exportfeedback'] = 'Zahrnúť komentáre v exporte';
$string['exportplugins'] = 'Zásuvné moduly pre export';
$string['exportsettings'] = 'Nastavenia exportu';
$string['exportto'] = 'Exportovať do';
$string['extracreditwarning'] = 'Poznámka: Nastavenie všetkých položiek pre kategóriu na kredit naviac efektívne odstráni všetky tieto položky z výpočtu známok. Tu nebude teda žiaden celkový počet bodov';
$string['feedback'] = 'Komentár';
$string['feedbackadd'] = 'Pridať komentár';
$string['feedbackedit'] = 'Upraviť komentár';
$string['feedback_help'] = '<p>Poznámky, ktoré ku známke pridáva učiteľ. Môžu byť obsiahle, zosobnené jednotlivým študentom, alebo jednoduché.</p>';
$string['feedbacksaved'] = 'Komentár uložený';
$string['feedbackview'] = 'Prezrieť komentár';
$string['finalgrade'] = 'Výsledná známka';
$string['finalgrade_help'] = '<p>Výsledná známka po aplikovaní všetkých výpočtov.</p>';
$string['fixedstudents'] = 'Ukotviť zoznam študentov';
$string['fixedstudents_help'] = 'Povoliť horizontálne rolovanie známok bez toho, aby zmizol údaj o mene študenta - toto pole je zamknuté.';
$string['forceoff'] = 'Vnútiť: vypnuté';
$string['forceon'] = 'Vnútiť: zapnuté';
$string['forelementtypes'] = 'pre vybrané {$a}';
$string['forstudents'] = 'Pre študentov';
$string['full'] = 'Úplný';
$string['fullmode'] = 'Úplný režim';
$string['fullview'] = 'Úplný režim';
$string['generalsettings'] = 'Všeobecné nastavenia';
$string['grade'] = 'Známka';
$string['gradeadministration'] = 'Administratíva známok';
$string['gradebook'] = 'Klasifikácia';
$string['gradebookhiddenerror'] = 'Systém klasifikácie je momentálne nastavený tak, že pred študentmi je všetko skryté.';
$string['gradebookhistories'] = 'História známok';
$string['gradeboundary'] = 'Rozsah slovnej známky';
$string['gradeboundary_help'] = '<p>Ide o percentuálne rozmedzie hodnotenia, v ktorom bude hodnoteniu priradená slovná známka (ak sa používa spôsob zobrazovania výsledkov v slovných známkach)</p>';
$string['gradecategories'] = 'Kategórie známok';
$string['gradecategory'] = 'Kategória známok';
$string['gradecategoryonmodform'] = 'Kategória známok';
$string['gradecategorysettings'] = 'Nastavenie kategorizácie známok';
$string['gradedisplay'] = 'Zobrazenie známok';
$string['gradedisplaytype'] = 'Typ zobrazenia známok';
$string['gradedisplaytype_help'] = '<p>Určuje, ako zobraziť známky vo výkazoch známok a používateľa. Na výber sú reálne hodnoty, percentá (vzhľadom na definovanú minimálnu a maximálnu hodnotu), alebo slovné známky.</p>';
$string['gradedon'] = 'Hodnotené: {$a}';
$string['gradeexport'] = 'Export známok';
$string['gradeexportdecimalpoints'] = 'Počet desatinných miest pri exporte známok';
$string['gradeexportdecimalpoints_desc'] = 'Počet desatinných miest v zobrazení pre export. Počas exportu môže byť zmenené.';
$string['gradeexportdisplaytype'] = 'Typ zobrazenia  pri exporte známok';
$string['gradeexportdisplaytype_desc'] = 'Známky môžu byť zobrazené ako skutočné hodnoty, percentá (vzhľadom na minimálne a maximálne body) alebo ako slovné známky. Počas exportu môže byť zmenené.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}$a->feedback';
$string['gradehelp'] = 'Nápoveda pre známkovanie';
$string['gradehistorylifetime'] = 'Životnosť histórie známok';
$string['gradehistorylifetime_help'] = 'Toto určuje časový interval, počas ktorého sa ukladajú informácie o zmenách v tabuľkách súvisiacich zo známkovaním. Doporučuje sa nastaviť čo najdlhší. Znížte, iba ak sú problémy s výkonnosťou servera či veľkosťou databázy.';
$string['gradeimport'] = 'Import známok';
$string['gradeitem'] = 'Položka známkovania';
$string['gradeitemaddusers'] = 'Vyňať zo známkovania';
$string['gradeitemadvanced'] = 'Pokročilé voľby položky známkovania';
$string['gradeitemadvanced_help'] = 'Vyberte všetky položky, ktoré majú byť zobrazené pri úprave položiek známok ako pokročilé nastavenia.';
$string['gradeitemislocked'] = 'Táto aktivita je vo výkaze uzamknutá. Zmeny, ktoré budú vykonané v tejto aktivite, nebudú skopírované do výkazu známok, kým nebude odomknutý.';
$string['gradeitemlocked'] = 'Známkovanie zamknuté';
$string['gradeitemmembersselected'] = 'Vyňatie zo známkovania';
$string['gradeitemnonmembers'] = 'Zahrnutie do známkovania';
$string['gradeitemremovemembers'] = 'Zahrnúť do známkovania';
$string['gradeitems'] = 'Položky známkovania';
$string['gradeitemsettings'] = 'Nastavenia položky známkovania';
$string['gradeitemsinc'] = 'Zahrnuté položky známkovania';
$string['gradeletter'] = 'Slovná známka';
$string['gradeletter_help'] = '<p>Môže sa použiť písmeno alebo iný symbol, ktorý reprezentuje rozsah hodnotenia.</p>';
$string['gradeletternote'] = 'Ak chcete vymazať slovnú známku, jednoducho vymažte ktorúkoľvek z <br />troch textových oblastí pre ten výpis a kliknite na tlačidlo odoslať.';
$string['gradeletters'] = 'Slovné známky';
$string['gradelocked'] = 'Známka je zamknutá';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najvyššia známka';
$string['grademax_help'] = '<p>Ak je typ známky hodnota, potom možno nastaviť jej maximum. Najvyššia známka pre položku hodnotenia založenú na aktivite je nastaviteľný na jej aktualizačnej stránke.</p>';
$string['grademin'] = 'Minimálna možná známka';
$string['grademin_help'] = '<p>Ak je typ známky hodnota, potom možno nastaviť jej minimum.</p>';
$string['gradeoutcomeitem'] = 'Položka hodnotenia - cieľ';
$string['gradeoutcomes'] = 'Ciele';
$string['gradeoutcomescourses'] = 'Ciele kurzu';
$string['gradepass'] = 'Potrebná známka';
$string['gradepass_help'] = 'Toto nastavenie určuje minimálnu potrebnú hodnotu známky, ktorú musia účastníci kurzu získať. Táto hodnota je používaná pri plnení aktivít a absolvovaní kurzu, kde úspešné známky sú vysvietené zelenou a neúspešné červenou.';
$string['gradepreferences'] = 'Preferencie hodnotenia';
$string['gradepreferenceshelp'] = 'Nápoveda pre preferencie v známkovaní';
$string['gradepublishing'] = 'Povoliť zverejnenie';
$string['gradepublishing_help'] = 'Povolenie zverejnenia v exportoch a importoch: Exportované známky sú dostupné cez URL bez toho, aby sa bolo nutné prihlásiť do Moodle. Známky môžu byť importované navštívením takej URL (čo znamená, že Moodle môže importovať známky exportované iným portálom). Implicitne môžu túto vlastnosť používať iba administrátori. Ak povolíte túto schopnosť aj pre iné roly, poučte ich používateľov (nebezpečenstvo zdieľania záložiek, akcelerátorov sťahovania, IP obmedzenia a podobne).';
$string['gradereport'] = 'Správa o známkach';
$string['graderreport'] = 'Známkový výkaz';
$string['grades'] = 'Známky';
$string['gradesforuser'] = 'Známky pre používateľa {$a->user}';
$string['gradesonly'] = 'Iba známky';
$string['gradessettings'] = 'Nastavenia známok';
$string['gradetype'] = 'Typ známky';
$string['gradetype_help'] = '<p>Určuje typ známky: žiaden (bez hodnotenia), hodnota (povoľuje nastavenia maximálnej a minimálnej známky), stupnica (povoľuje nastavenia stupníc) alebo text (iba komentáre). Iba typy hodnota a stupnica môžu byť ďalej využívané vo výpočtoch. Typ známky pre položku hodnotenia založenú na aktivite je nastaviteľný na jej aktualizačnej stránke.</p>';
$string['gradeview'] = 'Prezrieť známku';
$string['gradeweighthelp'] = 'Nápoveda pre vážené známkovanie';
$string['groupavg'] = 'Priemer skupiny';
$string['hidden'] = 'Skrytá';
$string['hiddenasdate'] = 'Ukázať dátum odovzdania pre skryté známky';
$string['hiddenasdate_help'] = 'Ak používateľ nemôže vidieť skryté známky, zobraz dátum odovzdania miesto \'-\'.';
$string['hidden_help'] = 'Ak je nastavené, známky budú pred študentmi skryté. Niekedy je vyhovujúce nastaviť "skryť až do", kedy sa známky ukážu až po určitom dátume.';
$string['hiddenuntil'] = 'Skryť do';
$string['hiddenuntildate'] = 'Skryté do: {$a}';
$string['hideadvanced'] = 'Skryť rozšírené voľby';
$string['hideaverages'] = 'Skryť priemery';
$string['hidecalculations'] = 'Skryť výpočty';
$string['hidecategory'] = 'Skryté';
$string['hideeyecons'] = 'Skryť ikony viditeľnosti';
$string['hidefeedback'] = 'Skryť komentár';
$string['hideforcedsettings'] = 'Skryť vnútené nastavenia';
$string['hideforcedsettings_help'] = 'Nezobrazovať predstavené položky v užívateľskom rozhraní známok.';
$string['hidegroups'] = 'Skryť skupiny';
$string['hidelocks'] = 'Skryť zámky';
$string['hidenooutcomes'] = 'Zobraziť ciele';
$string['hidequickfeedback'] = 'Skryť rýchly komentár';
$string['hideranges'] = 'Skryť rozsahy';
$string['hidetotalifhiddenitems'] = 'Skryť súhrnné známky, ak obsahujú skryté položky';
$string['hidetotalifhiddenitems_help'] = '<p>Toto nastavenie určuje, či sumárne známky, ktoré obsahujú skryté položky známok, sú zobrazené študentom alebo sú nahradené pomlčkou (-). Ak sú zobrazené, sumárne známky môžu byť vypočítavané s alebo bez skrytých položiek.</p>
<p>Ak sú skryté položky nezahrnuté, sumárna známka bude pre študenta rozdielna, pretože učiteľ vidí aj skryté známky. </p>
<p>Ak sú skryté známky zahrnuté, študenti môžu byť schopní skrytú položku dopočítať.</p>';
$string['hidetotalshowexhiddenitems'] = 'Zobraziť súhrnné známky nezahrňujúc skryté položky';
$string['hidetotalshowinchiddenitems'] = 'Zobraziť súhrnné známky zahrňujúc skryté položky';
$string['hideverbose'] = 'Skryť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Triediť podľa známok vzostupne';
$string['highgradedescending'] = 'Triediť podľa známok zostupne';
$string['highgradeletter'] = 'Do';
$string['identifier'] = 'Identifikovať účastníka podľa';
$string['idnumbers'] = 'Identifikátory';
$string['import'] = 'Import';
$string['importcsv'] = 'Import CSV';
$string['importcustom'] = 'Importovať ako ciele iba pre tento kurz';
$string['importerror'] = 'Vyskytla sa chyba, skript nebol zavolaný so správnymi parametrami';
$string['importfailed'] = 'Importovanie zlyhalo';
$string['importfeedback'] = 'Importovať komentáre';
$string['importfile'] = 'Importovať súbor';
$string['importfilemissing'] = 'Nebol prijatý súbor. Vráťte sa naspäť a nahrajte správny súbor';
$string['importfrom'] = 'Importovať z';
$string['importoutcomenofile'] = 'Importovaný súbor je prázdny alebo nesprávny. Skontrolujte, že je v správnom formáte. Problém bol zistený na riadku {$a}. Možno nemá rovnaký počet stĺpcov ako prvý riadok (hlavička súboru) alebo chýba hlavička súboru. Skúste exportovať súbor ako príklad správnej hlavičky.';
$string['importoutcomes'] = 'Importovať ciele';
$string['importoutcomes_help'] = 'Ciele môžu byť importované pomocou csv súboru s formátom totožným s csv súborom z exportu.';
$string['importoutcomesuccess'] = 'Importovaný cieľ "{$a->name}" s identifikátorom #{$a->id}';
$string['importplugins'] = 'Zásuvné moduly pre import';
$string['importpreview'] = 'Náhľad importu';
$string['importsettings'] = 'Nastavenia importu';
$string['importskippednomanagescale'] = 'Nemáte oprávnenie pridať novú stupnicu, takže cieľ "{$a}" preskočený (vyžaduje vytvorenie novej stupnice).';
$string['importskippedoutcome'] = 'Cieľ s krátkym menom "{$a}" už v tomto kontexte existuje, a preto bol v tomto importovanom súbore preskočený.';
$string['importstandard'] = 'Importovať ako štandardné ciele';
$string['importsuccess'] = 'Import prebehol úspešne';
$string['importxml'] = 'Importovať XML';
$string['includescalesinaggregation'] = 'Zahrnúť stupnice vo výpočtoch súhrnnej známky';
$string['includescalesinaggregation_help'] = 'Môžete zmeniť, či majú byť stupnice zahrnuté ako hodnoty vo všetkých súhrnných známkach vo všetkých klasifikáciách vo všetkých kurzoch. UPOZORNENIE: zmena tohto nastavenia spôsobí prepočítanie všetkých výpočtových známok.';
$string['incorrectcourseid'] = 'ID kurzu bolo nesprávne';
$string['incorrectcustomscale'] = '(Neplatná vlastná stupnica - zvoľte inú)';
$string['incorrectminmax'] = 'Minimum musí byť menšie ako maximum';
$string['inherit'] = 'Zdediť';
$string['intersectioninfo'] = 'Študent/známka';
$string['item'] = 'Položka';
$string['iteminfo'] = 'Informácia o položke';
$string['iteminfo_help'] = '<p>Miesto pre vloženie informácie o tejto položke. Text sem vložený sa nebude zobrazovať nikde inde.</p>';
$string['itemname'] = 'Názov položky';
$string['itemnamehelp'] = 'Názov položky zaslaný modulom.';
$string['items'] = 'Položky';
$string['itemsedit'] = 'Upraviť položku hodnotenia';
$string['keephigh'] = 'Ponechať najvyššie';
$string['keephigh_help'] = 'Ak sa táto položka nastaví, bude ponechaných iba X najvyšších známok (X je zvolená hodnota)';
$string['keymanager'] = 'Správa kľúčov';
$string['lessthanmin'] = 'Známka vložená pre {$a->itemname} pre {$a->username} je nižšia ako povolené minimum.';
$string['letter'] = 'Slovná známka';
$string['lettergrade'] = 'Slovná známka';
$string['lettergradenonnumber'] = 'Nenumerická hodnota v Od a/alebo Do';
$string['letterpercentage'] = 'Slovná známka (percentuálna hodnota)';
$string['letterreal'] = 'Slovná známka (skutočná hodnota)';
$string['letters'] = 'Slovné známky';
$string['linkedactivity'] = 'Odkazovaná aktivita';
$string['linkedactivity_help'] = '<p>Špecifikuje voliteľnú aktivitu, s ktorou je spojený cieľ predmetu. Spojené aktivity sa používajú na meranie výkonu študenta s nehodnotenými kritériami aktivít.</p>';
$string['linktoactivity'] = 'Odkaz na aktivitu: {$a->name}';
$string['lock'] = 'Zamknúť';
$string['locked'] = 'Zamknutá';
$string['locked_help'] = 'Ak je nastavené, známky už nebudú môcť byť automaticky aktualizované príslušnou aktivitou.';
$string['locktime'] = 'Zamknúť po';
$string['locktimedate'] = 'Zamknuté po: {$a}';
$string['lockverbose'] = 'Zamknúť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Najhorší';
$string['lowgradeletter'] = 'Od';
$string['manualitem'] = 'Manuálna položka';
$string['mapfrom'] = 'Namapovať z';
$string['mappings'] = 'Mapovania položiek hodnotenia';
$string['mapto'] = 'Namapovať na';
$string['max'] = 'Najlepší';
$string['maxgrade'] = 'Najlepšia možná známka';
$string['meanall'] = 'Všetky známky';
$string['meangraded'] = 'Neprázdne známky';
$string['meanselection'] = 'Známky vybrané pre stĺpcové priemery';
$string['meanselection_help'] = 'Zvoliť, či sa bunky bez známky majú zahrnúť do výpočtov priemeru každého stĺpca.';
$string['median'] = 'Prostredná hodnota (medián)';
$string['min'] = 'Najhorší';
$string['missingscale'] = 'Stupnica musí byť vybraná';
$string['mode'] = 'Režim (mód)';
$string['morethanmax'] = 'Známka vložená pre {$a->itemname} pre {$a->username} je vyššia ako povolené maximum.';
$string['moveselectedto'] = 'Presunúť vybrané položky do';
$string['movingelement'] = 'Presúvanie {$a}';
$string['multfactor'] = 'Násobiaci koeficient';
$string['multfactor_help'] = '<p>Koeficient, ktorým sú vynásobené všetky položky hodnotenia tento položky, pričom maximálnou hodnotou bode maximum známky.</p>';
$string['mypreferences'] = 'Moje preferencie';
$string['myreportpreferences'] = 'Moje preferencie výkazu';
$string['navmethod'] = 'Metóda navigácie';
$string['neverdeletehistory'] = 'Nikdy nevymazať históriu';
$string['newcategory'] = 'Nová kategória';
$string['newitem'] = 'Nová položka hodnotenia';
$string['newoutcomeitem'] = 'Nový hodnotený cieľ';
$string['no'] = 'Nie';
$string['nocategories'] = 'Kategórie známkovania nemohli byť pridané alebo nájdené pre tento kurz';
$string['nocategoryname'] = 'Nebolo zadané meno kategórie';
$string['nocategoryview'] = 'Žiadna kategória na prezretie podľa';
$string['nocourses'] = 'Nie sú zatiaľ žiadne kurzy';
$string['noforce'] = 'Nevnútiť';
$string['nogradeletters'] = 'Nenastavené slovné známky';
$string['nogradesreturned'] = 'Žiadne známky vrátené';
$string['noidnumber'] = 'Žiaden identifikátor';
$string['nolettergrade'] = 'Žiadne slovné známky pre';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Prijatá hodnota nečíselného typu pre';
$string['nonunlockableverbose'] = 'Táto známka nemôže byť odomknutá, kým nebude odomknutá položka {$a->itemname}';
$string['nonweightedpct'] = 'nevážené %';
$string['nooutcome'] = 'Neexistuje cieľ';
$string['nooutcomes'] = 'Položky cieľov musia byť viazané k cieľom kurzu. V tomto kurze však nie sú definované žiadne ciele. Chceli by ste nejaký cieľ pridať?';
$string['nopublish'] = 'Nepublikovať';
$string['norolesdefined'] = 'Nie sú definované roly v menu Administratíva > Známky > Všeobecné nastavenia > Roly pre známky';
$string['noscales'] = 'Ciele musia byť viazané na stupnice v kurze alebo na portáli. Žiadne však neexistujú- Chceli by ste nejakú stupnicu pridať?';
$string['noselectedcategories'] = 'neboli vybrané kategórie';
$string['noselecteditems'] = 'neboli vybrané položky';
$string['notteachererror'] = 'Prístup k týmto údajom majú iba učitelia';
$string['nousersloaded'] = 'Nie sú nahraní žiadni používatelia';
$string['numberofgrades'] = 'Počet známok';
$string['onascaleof'] = 'na stupnici od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operácie';
$string['options'] = 'Voľby';
$string['outcome'] = 'Cieľ';
$string['outcomeassigntocourse'] = 'Pridať k kurzu ďalší cieľ';
$string['outcomecategory'] = 'Vytvoriť ciele v kategórii';
$string['outcomecategorynew'] = 'Nová kategória';
$string['outcomeconfirmdelete'] = 'Naozaj chcete vymazať cieľ "{$a}"?';
$string['outcomecreate'] = 'Pridať nový cieľ';
$string['outcomedelete'] = 'Vymazať cieľ';
$string['outcomefullname'] = 'Celý názov';
$string['outcome_help'] = 'Určuje cieľ, ktorý bude táto položka známkovania reprezentovať vo výkaze. Dostupné sú iba ciele v tomto kurze a globálne ciele na portáli.';
$string['outcomeitem'] = 'Hodnotený cieľ';
$string['outcomeitemsedit'] = 'Upraviť cieľ';
$string['outcomereport'] = 'Výkaz cieľov';
$string['outcomes'] = 'Ciele';
$string['outcomescourse'] = 'Ciele použité v kurze';
$string['outcomescoursecustom'] = 'Používateľské ciele (neodstraňovať)';
$string['outcomescoursenotused'] = 'Nepoužité štandardné ciele';
$string['outcomescourseused'] = 'Použité štandardné ciele (neodstrániť)';
$string['outcomescustom'] = 'Používateľské ciele';
$string['outcomeshortname'] = 'Skrátené meno';
$string['outcomesstandard'] = 'Štandardné ciele';
$string['outcomesstandardavailable'] = 'Dostupné štandardné ciele';
$string['outcomestandard'] = 'Štandardný cieľ';
$string['outcomestandard_help'] = 'Štandardný cieľ je dostupný pre všetky kurzy.';
$string['overallaverage'] = 'Celkový priemer';
$string['overridden'] = 'Prestavená';
$string['overridden_help'] = '<p>Ak je položka prestavená, nie je možné ju v budúcnosti automaticky nastavovať, ale iba manuálne. Najčastejšie túto voľbu zapína samotný modul známok. Tento formulár umožňuje jeho manuálne prestavenie.</p>';
$string['overriddennotice'] = 'Výsledná známka z tejto aktivity bola manuálne zmenená.';
$string['overridesitedefaultgradedisplaytype'] = 'Prestavenie východzích nastavení portálu';
$string['overridesitedefaultgradedisplaytype_help'] = '<p>Zvolením tejto voľby sa umožní prepísať prednastavenie celého portálu pre zobrazovanie hodnotenia vo výkaze známok.  Táto voľba aktivuje formulár prvkov, ktorý umožní určenie slovných známok a ich rozsah.</p>';
$string['parentcategory'] = 'Rodičovská kategória';
$string['pctoftotalgrade'] = '% z celkovej známky';
$string['percent'] = 'Percento';
$string['percentage'] = 'Percentuálna hodnota';
$string['percentageletter'] = 'Percentuálna hodnota (slovná známka)';
$string['percentagereal'] = 'Percentuálna hodnota (skutočná hodnota)';
$string['percentascending'] = 'Triediť podľa percent vzostupne';
$string['percentdescending'] = 'Triediť podľa percent zostupne';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Posun';
$string['plusfactor_help'] = '<p>Číslo, ktoré bude pripočítané k každej známke tejto položky známkovania potom, čo bol aplikovaný Násobiaci koeficient.</p>';
$string['points'] = 'body';
$string['pointsascending'] = 'Triediť podľa bodov vzostupne';
$string['pointsdescending'] = 'Triediť podľa bodov zostupne';
$string['positionfirst'] = 'Prvý';
$string['positionlast'] = 'Posledný';
$string['preferences'] = 'Preferencie';
$string['prefgeneral'] = 'Všeobecné';
$string['prefletters'] = 'Slovné známky a ich rozsahy';
$string['prefrows'] = 'Špeciálne riadky';
$string['prefshow'] = 'Zobraziť/skryť prepínače';
$string['previewrows'] = 'Náhľad riadkov';
$string['profilereport'] = 'Používateľský výkaz';
$string['profilereport_help'] = 'Typ známkového výkazu použitého na profilovej stránke používateľa';
$string['publishing'] = 'Publikovanie';
$string['quickfeedback'] = 'Rýchly komentár';
$string['quickgrading'] = 'Rýchle hodnotenie';
$string['quickgrading_help'] = '<p>Rýchle hodnotenie pridáva vstupné textové pole v každej hodnotenej položke známkového výkazu. Takto sa jednoduchšie zadáva viacero hodnotení naraz. Po ich zadaní kliknite na tlačidlo Aktualizovať a všetky zadané hodnotenia budú uložené naraz.</p>';
$string['range'] = 'Rozsah';
$string['rangedecimals'] = 'Desatinné miesta v rozsahoch';
$string['rangesdecimalpoints'] = 'Desatinné miesta v rozsahoch';
$string['rangesdecimalpoints_help'] = '<p>Určuje počet desatinných miest v každom rozsahu. Toto nastavenie môže byť zmenené pri každej položke známok. </p>';
$string['rangesdisplaytype'] = 'Typ zobrazenia rozsahu';
$string['rangesdisplaytype_help'] = '<p>Určuje spôsob zobrazenia rozsahov stĺpcov. Ak je zvolené Zdediť, použije sa rovnaké zobrazenie ako pre každý stĺpec. </p>';
$string['rank'] = 'Poradie';
$string['rawpct'] = 'Hrubé  %';
$string['real'] = 'Skutočná hodnota';
$string['realletter'] = 'Skutočná hodnota (slovná známka)';
$string['realpercentage'] = 'Skutočná hodnota (percentuálna hodnota)';
$string['regradeanyway'] = 'Preznámkovať v každom prípade';
$string['removeallcoursegrades'] = 'Vymazať všetky známky';
$string['removeallcourseitems'] = 'Vymazať všetky položky a kategórie';
$string['report'] = 'Výkaz';
$string['reportdefault'] = 'Štandardný pre výkaz ({$a})';
$string['reportplugins'] = 'Zásuvné moduly výkazov';
$string['reportsettings'] = 'Nastavenia výkazov';
$string['reprintheaders'] = 'Opakovať hlavičky';
$string['respectingcurrentdata'] = 'ponechanie súčasnej konfigurácie nezmenenej';
$string['rowpreviewnum'] = 'Náhľad riadkov';
$string['savechanges'] = 'Uložiť zmeny';
$string['savepreferences'] = 'Uložiť preferencie';
$string['scaleconfirmdelete'] = 'Naozaj chcete vymazať stupnicu "{$a}"?';
$string['scaledpct'] = 'Škálované %';
$string['seeallcoursegrades'] = 'Vidieť všetky známky v kurze';
$string['selectalloroneuser'] = 'Vybrať všetkých alebo jedného používateľa';
$string['selectauser'] = 'Vybrať používateľa';
$string['selectdestination'] = 'Vybrať cieľ pre {$a}';
$string['separator'] = 'Oddeľovač';
$string['sepcomma'] = 'Čiarka';
$string['septab'] = 'Tabulátor';
$string['setcategories'] = 'Nastaviť kategórie';
$string['setcategorieserror'] = 'Predtým, ako dáte kategóriám určitú váhu, musíte najprv nastaviť kategórie pre Váš kurz.';
$string['setgradeletters'] = 'Nastaviť slovné známky';
$string['setpreferences'] = 'Nastaviť preferencie';
$string['setting'] = 'Nastavenie';
$string['settings'] = 'Nastavenia';
$string['setweights'] = 'Nastaviť váhy';
$string['showactivityicons'] = 'Zobraziť ikony aktivít';
$string['showactivityicons_help'] = '<p>Či zobraziť ikony aktivít spolu s ich názvami.</p>';
$string['showallhidden'] = 'Zobraziť skryté';
$string['showallstudents'] = 'Zobraziť všetkých študentov';
$string['showaverage'] = 'Zobraziť priemer';
$string['showaverages'] = 'Zobraziť priemery stĺpcov';
$string['showaverages_help'] = 'Zobraziť priemery pre každý stĺpec.';
$string['showcalculations'] = 'Zobraziť výpočty';
$string['showcalculations_help'] = 'Zobraziť ikonu kalkulačky vedľa každej hodnotenej položky a kategórie, tooltipy pre vypočítavané položky a vizuálny indikátor, že stĺpec je vypočítavaný.';
$string['showeyecons'] = 'Zobraziť ikony viditeľnosti';
$string['showeyecons_help'] = 'Zobraziť ikonu "ukázať/schovať" pri každej známke (určenie viditeľnosti pre daného používateľa).';
$string['showfeedback'] = 'Zobraziť komentár';
$string['showgrade'] = 'Zobraziť známky';
$string['showgrade_help'] = 'Zobraziť stĺpec známok?';
$string['showgroups'] = 'Zobraziť skupiny';
$string['showhiddenitems'] = 'Zobraziť skryté položky';
$string['showhiddenitems_help'] = 'Určuje, ako sú zobrazené skryté známky. Môžu byť úplne skryté, alebo je vidno aspoň ich názvy.

* Zobraziť skryté - názvy skrytých položiek sú zobrazené, ale samotné známky nie
* Iba skryté do - Do určitého dátumu sú známky úplne skryté a potom úplne zobrazené
* Nezobraziť - Nie je vidno ani známky, ani názvy.';
$string['showhiddenuntilonly'] = 'Skryté iba do';
$string['showlettergrade'] = 'Zobraziť slovné známky';
$string['showlocks'] = 'Zobraziť zámky';
$string['showlocks_help'] = 'Zobraziť ikonu zamknúť/odomknúť pri každej známke.';
$string['shownohidden'] = 'Nezobraziť';
$string['shownooutcomes'] = 'Skryť ciele';
$string['shownumberofgrades'] = 'Zobraziť počet známok v známkach';
$string['shownumberofgrades_help'] = 'Zobraziť počet známok použitých pri výpočte priemeru v zátvorkách, napríklad  45 (34).';
$string['showpercentage'] = 'Zobraziť percentá';
$string['showpercentage_help'] = 'Zobraziť percentuálnu hodnotu každej položky známkovania.';
$string['showquickfeedback'] = 'Zobraziť rýchly komentár';
$string['showquickfeedback_help'] = 'Rýchly komentár pridáva formulár do každej bunky hodnotenia v známkovom výkaze. Pomocou neho možno upravovať komentár pre viacero známok naraz. Po ukončení úprav je potrebné kliknúť na tlačidlo Aktualizovať, aby sa všetky zmeny uložili.';
$string['showrange'] = 'Zobraziť rozsahy';
$string['showranges'] = 'Zobraziť rozsahy';
$string['showranges_help'] = 'Zobraziť rozsah bodov pre každý stĺpec v novom riadku.';
$string['showrank'] = 'Zobraziť poradie';
$string['showrank_help'] = 'Zobraziť pozíciu účastníka vzhľadom k celému kurzu pre každú položku známkovania?';
$string['showuserimage'] = 'Zobraziť fotografie účastníkov';
$string['showuserimage_help'] = 'Zobraziť obrázok používateľa spolu s menom v známkovom výkaze.';
$string['showverbose'] = 'Zobraziť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Zobraziť váhy';
$string['simpleview'] = 'Zjednodušený režim';
$string['sitewide'] = 'Pre celý portál';
$string['sort'] = 'triediť';
$string['sortasc'] = 'Triediť vzostupne';
$string['sortbyfirstname'] = 'Triediť podľa mena';
$string['sortbylastname'] = 'Triediť podľa priezviska';
$string['sortdesc'] = 'Triediť zostupne';
$string['standarddeviation'] = 'Štandardná odchýlka';
$string['stats'] = 'Štatistika';
$string['statslink'] = 'Štatistiky';
$string['student'] = 'Študent';
$string['studentsperpage'] = 'Počet študentov na stránku';
$string['studentsperpage_help'] = 'Počet študentov na strane v známkovom výkaze.';
$string['subcategory'] = 'Normálna kategória';
$string['submissions'] = 'Odovzdané zadania';
$string['submittedon'] = 'Odovzdaných: {$a}';
$string['switchtofullview'] = 'Prepnúť do plného režimu';
$string['switchtosimpleview'] = 'Prepnúť do zjednodušeného režimu';
$string['tabs'] = 'Záložky';
$string['topcategory'] = 'Superkategória';
$string['total'] = 'Celkom';
$string['totalweight100'] = 'Celková váha sa rovná 100';
$string['totalweightnot100'] = 'Celková váha nie je rovná 100';
$string['turnfeedbackoff'] = 'Vypnúť komentáre';
$string['turnfeedbackon'] = 'Zapnúť komentáre';
$string['typenone'] = 'Žiaden';
$string['typescale'] = 'Stupnica';
$string['typescale_help'] = '<p>Stupnica môže byť vybraná ak je zvolená položka tohto typu. Typ stupnice pre položku hodnotenia založenú na aktivite je nastaviteľný na jej aktualizačnej stránke.</p>';
$string['typetext'] = 'Text';
$string['typevalue'] = 'Hodnota';
$string['uncategorised'] = 'Nezaradené';
$string['unchangedgrade'] = 'Známka je nezmenená';
$string['unenrolledusersinimport'] = 'Tento import zahrnul nasledovné známky používateľov, ktorí nie sú účastníkmi tohto kurzu: {$a}';
$string['unlimitedgrades'] = 'Neobmedzené známky';
$string['unlimitedgrades_help'] = 'Východzie nastavenie zámok je ohraničené minimálnou a maximálnou hodnotou položky známky. Ak povolíte toto nastavenie, bude možné zadávať vo výkaze známok aj známky  na viac ako 100%. Doporučuje sa, aby ste toto nastavenie zapli mimo plnej premávky servera, pretože všetky známky budú prepočítavané a spôsobia významnú záťaž na serveri.';
$string['unlock'] = 'Odomknúť';
$string['unlockverbose'] = 'Odomknúť {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Nepoužité';
$string['updatedgradesonly'] = 'Exportovať iba nové alebo aktualizované známky';
$string['uploadgrades'] = 'Nahrať známky';
$string['useadvanced'] = 'Použiť rozšírené voľby';
$string['usedcourses'] = 'Používané kurzy';
$string['usedgradeitem'] = 'Používané položky hodnotenia';
$string['usenooutcome'] = 'Nepoužívať žiaden cieľ';
$string['usenoscale'] = 'Nepoužívať žiadnu stupnicu';
$string['usepercent'] = 'Použiť percentá';
$string['user'] = 'Používateľ';
$string['usergrade'] = 'Používateľ {$a->fullname} ({$a->useridnumber}) na položke {$a->gradeidnumber}';
$string['userpreferences'] = 'Používateľské preferencie';
$string['useweighted'] = 'Použiť vážené';
$string['verbosescales'] = 'Doslovné stupnice';
$string['viewbygroup'] = 'Skupina';
$string['viewgrades'] = 'Prezrieť známky';
$string['warningexcludedsum'] = 'Upozornenie: vyradzovanie známok nie je možné kombinovať so spôsobom výpočtu výslednej známky ako súčtu dielčich známok';
$string['weight'] = 'váha';
$string['weightcourse'] = 'Použiť vážené známky v kurze';
$string['weightedascending'] = 'Triediť podľa váženého percenta vzostupne';
$string['weighteddescending'] = 'Triediť podľa váženého percenta zostupne';
$string['weightedpct'] = 'vážené %';
$string['weightedpctcontribution'] = 'vážené % príspevku';
$string['weightorextracredit'] = 'Váha alebo extra body';
$string['weights'] = 'Váhy';
$string['weightsedit'] = 'Upraviť váhy a extra body';
$string['weightuc'] = 'Váha';
$string['writinggradebookinfo'] = 'Zapisujem nastavenia písomnej klasifikácie';
$string['xml'] = 'XML';
$string['yes'] = 'Áno';
$string['yourgrade'] = 'Vaša známka';
