<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Pridať komentár';
$string['addentry'] = 'Pridať novú položku';
$string['addingcomment'] = 'Pridať komentár';
$string['alias'] = 'Kľúčové slovo';
$string['aliases'] = 'Kľúčové slovo(á)';
$string['aliases_help'] = '<p>Ku každému heslu v slovníku možno pripojiť zoznam kľúčových slov
(aliasov).</p>

<p><b>Každé kľúčové slovo napíšte na nový riadok</b> (neoddeľujte ich
čiarkou).</p>

<p>Slová a frázy nastavené ako kľúčové slová možno použiť ako alternatívny
spôsob odkazovania na heslo. Ak napríklad používate filter pre automatické
prepojovanie, bude pri určovaní slov, ktorá majú byť prepojené s týmto heslom,
použité nielen hlavné heslo položky (pojem), ale aj všetky kľúčové slová.</p>';
$string['allcategories'] = 'Všetky kategórie';
$string['allentries'] = 'VŠETKO';
$string['allowcomments'] = 'Povoliť komentár k položkám';
$string['allowcomments_help'] = '<p>Ak je nastavené, všetci používatelia s oprávnením vytvárať poznámky budú schopní pridávať komentáre k heslám v slovníku.</p>';
$string['allowduplicatedentries'] = 'Povoliť duplicitné položky';
$string['allowduplicatedentries_help'] = '<p>Ak túto voľbu zapnete, v slovníku bude možno vytvoriť viac hesiel s
rovnakým pojmom (heslovým slovom).</p>';
$string['allowprintview'] = 'Povoliť náhľad tlače';
$string['allowprintview_help'] = '<p>Študentom možno povoliť zobrazenie slovníku vo formáte vhodnom pre tlač.</p>

<p>Môžete vybrať, či bude táto funkcia povolená alebo zakázaná.</p>

<p>Učitelia môžu náhľad tlače používať vždy.</p>';
$string['andmorenewentries'] = 'a {$a} ďalšie nové položky.';
$string['answer'] = 'Odpoveď';
$string['approve'] = 'Schváliť';
$string['areaattachment'] = 'Prílohy';
$string['areaentry'] = 'Definície';
$string['areyousuredelete'] = 'Ste si naozaj istý, že chcete odstrániť túto položku?';
$string['areyousuredeletecomment'] = 'Ste si naozaj istý, že chcete odstrániť tento komentár?';
$string['areyousureexport'] = 'Ste si naozaj istý, že chcete exportovať túto položku do';
$string['ascending'] = '(vzostupne)';
$string['attachment'] = 'Príloha';
$string['attachment_help'] = '<p>Ku každému heslu slovníku môžete priložiť JEDEN súbor zo svojho počítača.
Tento súbor je nahraný na server a uložený s vašou položkou.</p>

<p>Môžete takto napríklad zdieľať obrázok či dokument vo Worde.</p>

<p>Prikladať možno súbory v ľubovoľnom formáte, doporučuje sa však im nechať
štandardné trojpísmenové prípony, ako je napr .doc pre dokument v
Worde, .jpg alebo .png pre obrázok atď. Uľahčí to stiahnutie a prehliadanie v
internetových prehliadačoch.</p>

<p>Ak opäť upravujete položku a priložíte nový súbor,
pôvodný bude nahradený novým.</p>

<p>Ak opäť upravujete položku a nový súbor nepriložíte,
ostane pôvodná príloha zachovaná.</p>';
$string['author'] = 'autor';
$string['authorview'] = 'Prechádzať podľa autora';
$string['back'] = 'Späť';
$string['cantinsertcat'] = 'Nemožno vložiť kategóriu';
$string['cantinsertrec'] = 'Nemožno vložiť záznam';
$string['cantinsertrel'] = 'Nemožno vložiť prepojenie kategória-položka';
$string['casesensitive'] = 'Táto položka rozlišuje používanie veľkých a malých písmen';
$string['casesensitive_help'] = '<p>Toto nastavenie určuje, či sa budú pri vytváraní automatických odkazov na danú
položku rozlišované veľké a malé písmená.</p>

<p>Ak je táto voľba aktivovaná, potom napr. zo slova "html" v príspevku do fóra
NEBUDE vytvorený odkaz k slovníkovému heslu "HTML".</p>';
$string['cat'] = 'kategória';
$string['categories'] = 'Kategórie';
$string['category'] = 'Kategória';
$string['categorydeleted'] = 'Kategória bola odstránená';
$string['categoryview'] = 'Prechádzať podľa kategórie';
$string['changeto'] = 'zmeniť na {$a}';
$string['cnfallowcomments'] = 'Určte, či bude implicitne povolené pridávanie komentárov k položkám';
$string['cnfallowdupentries'] = 'Určte, či budú implicitne povolené duplicitné položky';
$string['cnfapprovalstatus'] = 'Určte implicitný stav schvaľovania položiek vložených študentmi';
$string['cnfcasesensitive'] = 'Určte, či sa bude u prepájaných položiek implicitne zohľadňovať používanie veľkých a malých písmen';
$string['cnfdefaulthook'] = 'Vyberte východiskový výber pre prvé zobrazenie slovníku';
$string['cnfdefaultmode'] = 'Vyberte východiskový rámec pre prvé zobrazenie slovníku.';
$string['cnffullmatch'] = 'Určte, či má u automatického prepájania implicitne odpovedať celá položka cieľovému textu';
$string['cnflinkentry'] = 'Určte, či má byť položka implicitne automaticky prepájaná';
$string['cnflinkglossaries'] = 'Určte, či má byť slovník implicitne automaticky prepojený';
$string['cnfrelatedview'] = 'Vyberte spôsob zobrazovania automatického prepájania a prehliadania položiek (záznamov) slovníku.';
$string['cnfshowgroup'] = 'Určte, či majú byť zobrazované oddeľovače skupín alebo nie.';
$string['cnfsortkey'] = 'Vyber východiskový kľúč pre triedenie';
$string['cnfsortorder'] = 'Vybrať východiskový postup pri triedení';
$string['cnfstudentcanpost'] = 'Určte, či môžu študenti implicitne pridávať nové položky do slovníka alebo nie';
$string['comment'] = 'Komentár';
$string['commentdeleted'] = 'Komentár bol odstránený.';
$string['comments'] = 'Komentáre';
$string['commentson'] = 'Komentár k';
$string['commentupdated'] = 'Komentár bol aktualizovaný.';
$string['completionentries'] = 'Študenti musia vytvoriť položky';
$string['completionentriesgroup'] = 'Vyžadovať položky';
$string['concept'] = 'Pojem';
$string['concepts'] = 'Pojmy';
$string['configenablerssfeeds'] = 'Týmto povolíte funkciu RSS kanálov pre všetky slovníky. Budete však musieť ešte manuálne zapnúť túto funkciu v nastaveniach jednotlivých slovníkov.';
$string['current'] = 'Súčasné triedenie {$a}';
$string['currentglossary'] = 'Aktuálny slovník';
$string['date'] = 'dátum';
$string['dateview'] = 'Prechádzať podľa dátumu';
$string['defaultapproval'] = 'Implicitný stav schvaľovania';
$string['defaultapproval_help'] = '<p>Toto nastavenie umožňuje učiteľovi určiť, čo sa stane s novými položkami, ktoré do
slovníku pridajú študenti. Tieto môžu byť alebo automaticky sprístupnené všetkým
účastníkom kurzu, alebo musí učiteľ každú z nich najprv schváliť.</p>';
$string['defaulthook'] = 'Štandardné zobrazenie';
$string['defaultmode'] = 'Štandardný mód';
$string['defaultsortkey'] = 'Štandardný kľúč triedenia';
$string['defaultsortorder'] = 'Štandardný spôsob triedenia';
$string['definition'] = 'Definícia';
$string['definitions'] = 'Definície';
$string['deleteentry'] = 'Odstrániť položku';
$string['deletenotenrolled'] = 'Vymazať položky vložené používateľmi, ktorí nie sú zapísaní do kurzu';
$string['deletingcomment'] = 'Komentár sa odstraňuje';
$string['deletingnoneemptycategory'] = 'Odstránením tejto kategórie neodstránite položky, ktoré obsahuje - tieto budú označené ako nezaradené.';
$string['descending'] = '(zostupne)';
$string['destination'] = 'Cieľ';
$string['destination_help'] = '<p>Môžete upresniť, kam chcete položky importovať:</p>

<ul>
  <li><strong>Aktuálny slovník:</strong> importované položky sa doplnia do
  aktuálneho slovníku.</li>

  <li><strong>Nový slovník:</strong> na základe informácií z vybraného
  importovaného súboru sa vytvorí nový slovník a nové položky sa vložia do
  neho.</li>
</ul>';
$string['displayformat'] = 'Spôsob  zobrazenia';
$string['displayformatcontinuous'] = 'Súvislý bez autora';
$string['displayformatdictionary'] = 'Jednoduchý slovníkový štýl';
$string['displayformatencyclopedia'] = 'Encyklopedický';
$string['displayformatentrylist'] = 'Zoznam položiek';
$string['displayformatfaq'] = 'Často kladené otázky';
$string['displayformatfullwithauthor'] = 'Úplný vrátane autora';
$string['displayformatfullwithoutauthor'] = 'Úplný bez autora';
$string['displayformat_help'] = 'Existuje 7 zobrazovacích spôsobov slovníka:

* Jednoduchý slovníkový štýl - nezobrazujú sa autori položiek a prílohy sú uvedené v tvare odkazov.
* Súvislý bez autora - položky sú zobrazené súvisle jedna za druhou, oddelené sú iba ikonami úprav.
* Úplný vrátane autora - zobrazenie je podobné ako vo fórach, zobrazuje sa údaj o autorovi položky. Prílohy sú uvedené v tvare odkazov.
* Úplný bez autora - zobrazenie je podobné ako vo fórach, informácie o autorovi sa nezobrazujú. Prílohy sú uvedené v tvare odkazov.
* Encyklopedický - Rovnaký spôsob zobrazenia ako "Úplný vrátane autora", ale ak tvorí prílohu obrázok, zobrazí sa priamo v texte hesla.
* Zoznam položiek - pojmy sú uvedené ako odkazy
* Často kladené otázky (FAQ) - formát vhodný pre zobrazení zoznamov často kladených otázok. Automaticky vkladá pred položku (ktorou je v tomto prípade otázka) a pred text položky (obsahujúcej odpoveď) slovo OTÁZKA, respektíve ODPOVEĎ.
';
$string['displayformats'] = 'Spôsoby zobrazení';
$string['displayformatssetup'] = 'Nastavenie spôsobu zobrazenia';
$string['duplicatecategory'] = 'Duplicitné kategórie';
$string['duplicateentry'] = 'Duplicitná položka';
$string['editalways'] = 'Vždy upraviť';
$string['editalways_help'] = '<p>Táto voľba určuje, či môžu študenti upravovať svoje vložené položky bez
časového obmedzenia.</p>

<p>Na výber sú dve možnosti:</p>

<ul>
  <li><b>Áno</b>: študenti môžu položky upravovať vždy.</li>

  <li><b>Nie</b>: študenti môžu položky upravovať iba v čase určenom pre
  úpravy.</li>
</ul>';
$string['editcategories'] = 'Upraviť kategórie';
$string['editentry'] = 'Upraviť položku';
$string['editingcomment'] = 'Komentár sa upravuje';
$string['entbypage'] = 'Počet položiek na stránke';
$string['entries'] = 'Položky';
$string['entrieswithoutcategory'] = 'Položky bez kategórie';
$string['entry'] = 'Položka';
$string['entryalreadyexist'] = 'Položka už existuje';
$string['entryapproved'] = 'Položka bola schválená';
$string['entrydeleted'] = 'Položka bola odstránená';
$string['entryexported'] = 'Položka bola úspešne exportovaná';
$string['entryishidden'] = '(táto položka je momentálne skrytá)';
$string['entryleveldefaultsettings'] = 'Východiskové nastavenia pre položky';
$string['entrysaved'] = 'Položka bola uložená';
$string['entryupdated'] = 'Položka bola aktualizovaná';
$string['entryusedynalink'] = 'Táto položka by mala byť automaticky prepojená';
$string['entryusedynalink_help'] = '<p>Zapnutím tejto voľby umožníte automatické vytváranie odkazov na slovníkové
heslá vždy, keď sa heslové slovo alebo fráza objaví v niektorej časti kurzu &ndash; v
príspevkoch do fóra, v študijných materiáloch, v týždenných zhrnutiach, v
poznámkach atď.</p>

<p>Ak v nektorom texte (napríklad v príspevku do fóra) automatické odkazy
vytvárať nechcete, označte ho párovými značkami &lt;nolink&gt; a
&lt;/nolink&gt;.</p>

<p>Túto funkciu možno zapnúť, iba ak je možnosť automatického
vytvárania odkazov povolená na úrovni slovníku.</p>';
$string['errcannoteditothers'] = 'Nemôžete upravovať položky iných používateľov';
$string['errconceptalreadyexists'] = 'Tento pojem už v slovníku existuje. Duplicitné položky tu sú zakázané.';
$string['errdeltimeexpired'] = 'Čas vypršal. Už to nie je možné vymazať.';
$string['erredittimeexpired'] = 'Čas pre úpravu tejto položky už uplynul.';
$string['errorparsingxml'] = 'Vyskytla sa chyba pri analýze súboru. Uistite sa, že má platnú XML syntax.';
$string['explainaddentry'] = 'Pridať novú položku do aktuálneho slovníka.<br />
Pojem a jeho definícia sú povinné polia.';
$string['explainall'] = 'Zobraziť VŠETKY položky na jednej stránke';
$string['explainalphabet'] = 'Prechádzať slovník s použitím tohto registra';
$string['explainexport'] = 'Bol vytvorený nový súbor.<br />
Stiahnite si ho a bezpečne si ho uložte. Neskôr ho môžete kedykoľvek importovať do tohto alebo iného kurzu.';
$string['explainimport'] = 'Musíte určiť súbor, ktorý sa má importovať a definovať kritéria importu.
<p>Vložte znovu Vašu požiadavku a skontrolujte si výsledky importu.</p>';
$string['explainspecial'] = 'Ukazuje položky, ktoré nezačínajú písmenom';
$string['exportedentry'] = 'Exportované položky';
$string['exportentries'] = 'Exportovať položky';
$string['exportentriestoxml'] = 'Exportovať položky do XML súboru';
$string['exportfile'] = 'Exportovať položky do súboru';
$string['exportglossary'] = 'Exportovať slovník';
$string['exporttomainglossary'] = 'Exportovať do hlavného slovníka';
$string['filetoimport'] = 'Importovať zo súboru';
$string['filetoimport_help'] = '<p>Vyberte na svojom počítači súbor XML, ktorý obsahuje heslá k importovaniu.</p>';
$string['fillfields'] = 'Pojem a definícia sú povinné polia.';
$string['filtername'] = 'Automatické prepojenie slovníku';
$string['fullmatch'] = 'Vyhľadať iba celé slová';
$string['fullmatch_help'] = '<p>Ak je aktivované automatické vytváranie odkazov, potom týmto nastavením
povolíte vytváranie odkazov iba v celých slovách.</p>

<p>Napríklad slovníkové heslo "pole" nevytvorí odkaz v slove
"Napoleon".</p>';
$string['glossary:approve'] = 'Schvaľovať neschválené položky';
$string['glossary:comment'] = 'Vytvárať komentáre';
$string['glossary:export'] = 'Exportovať položky';
$string['glossary:exportentry'] = 'Exportovať jednu položku slovníka';
$string['glossary:exportownentry'] = 'Exportovať vašu jednu položku';
$string['glossary:import'] = 'Importovať položky';
$string['glossaryleveldefaultsettings'] = 'Východiskové nastavenie pre slovník';
$string['glossary:managecategories'] = 'Spravovať kategórie';
$string['glossary:managecomments'] = 'Spravovať komentáre';
$string['glossary:manageentries'] = 'Spravovať položky';
$string['glossary:rate'] = 'Hodnotiť položky';
$string['glossarytype'] = 'Typ slovníku';
$string['glossarytype_help'] = '<p>Modul Slovník umožňuje prenášať položky hesiel z ktoréhokoľvek vedľajšieho slovníku
do hlavného slovníku kurzu.</p>

<p>K tomu je nutné definovať, ktorý slovník je hlavný.</p>

<p>Poznámka: V každom kurze môže byť ako hlavný označený iba jeden slovník a
aktualizovať ho môžu iba učitelia.</p>';
$string['glossary:view'] = 'Zobrazovať položky';
$string['glossary:viewallratings'] = 'Prezrieť všetky hodnotenia zadané účastníkmi';
$string['glossary:viewanyrating'] = 'Zobraziť súhrn hodnotení pre všetkých';
$string['glossary:viewrating'] = 'Zobrazovať vaše hodnotenie';
$string['glossary:write'] = 'Vytvárať nové položky';
$string['guestnoedit'] = 'Hostia nemajú oprávnenie na úpravy záznamov v slovníkoch';
$string['importcategories'] = 'Importovať kategórie';
$string['importedcategories'] = 'Importované kategórie';
$string['importedentries'] = 'Importované položky';
$string['importentries'] = 'Importovať položky';
$string['importentriesfromxml'] = 'Import položiek z XML súboru';
$string['includegroupbreaks'] = 'Zahrnúť predely medzi skupinami';
$string['isglobal'] = 'Je tento slovník globálny?';
$string['isglobal_help'] = '<p>Administrátori môžu jeden slovník v kurze označiť ako globálny.</p>

<p>Tento slovník môže byť súčasťou ľubovoľného kurzu (ale najmä hlavnej
stránky Moodle).</p>

<p>Oproti bežnému lokálnemu slovníku sú automatické
odkazy na heslá globálneho slovníku vytvárané vo všetkých kurzoch (a nielen
iba v tom, v ktorom je slovník vytvorený).</p>';
$string['letter'] = 'list';
$string['linkcategory'] = 'Automaticky prepájať túto kategóriu';
$string['linkcategory_help'] = '<p>Môžete upresniť, či chcete, aby sa automaticky vytvárali odkazy aj pre
názvy kategórií.</p>

<p>Poznámka: Odkazy na kategórie sú vytvárané na základe porovnávania celých
slov s ohľadom na rozlíšenie veľkých a malých písmen.</p>';
$string['linking'] = 'Automatické prepojovanie';
$string['mainglossary'] = 'Hlavný slovník';
$string['maxtimehaspassed'] = 'Ľutujeme, ale čas určený na úpravu tohto komentára ({$a}) už vypršal!';
$string['modulename'] = 'Slovník';
$string['modulename_help'] = 'Aktivita Slovník umožňuje účastníkom kurzu vytvoriť a udržiavať zoznam definícií podobný slovníku. Jednotlivé položky môžu byť automaticky prepojené so slovníkom kdekoľvek v materiáloch kurzu.';
$string['modulenameplural'] = 'Slovníky';
$string['newentries'] = 'Nové položky slovníku';
$string['newglossary'] = 'Nový slovník';
$string['newglossarycreated'] = 'Bol vytvorený nový slovník.';
$string['newglossaryentries'] = 'Nové položky slovníku:';
$string['nocomment'] = 'Bez komentára';
$string['nocomments'] = '(K tejto položke nebol nájdený žiaden komentár)';
$string['noconceptfound'] = 'Nebol nájdený žiaden pojem ani definícia.';
$string['noentries'] = 'V tejto sekcii neboli nájdené žiadne položky';
$string['noentry'] = 'Bez položiek';
$string['nopermissiontodelcomment'] = 'Nemôžete vymazať komentáre iných účastníkov!';
$string['nopermissiontodelinglossary'] = 'Nemôžete pridať komentáre v tomto slovníku!';
$string['nopermissiontoviewresult'] = 'Môžete si prezerať výsledky len svojich záznamov';
$string['notapproved'] = 'Položka slovníka zatiaľ nebola schválená';
$string['notcategorised'] = 'Nezaradené';
$string['numberofentries'] = 'Počet položiek';
$string['onebyline'] = '(jedna na jednom riadku)';
$string['page-mod-glossary-edit'] = 'Stránka pre pridanie/úpravu položky v slovníku';
$string['page-mod-glossary-view'] = 'Stránka so zobrazením slovníku';
$string['page-mod-glossary-x'] = 'Ľubovoľná stránka modulu slovník';
$string['pluginadministration'] = 'Správa slovníka';
$string['pluginname'] = 'Slovník';
$string['popupformat'] = 'Popup formát';
$string['printerfriendly'] = 'Verzia vhodná k tlači';
$string['printviewnotallowed'] = 'Náhľad tlače nie je povolený';
$string['question'] = 'Otázka';
$string['rejectedentries'] = 'Zamietnuté položky';
$string['rejectionrpt'] = 'Správa o zamietnutí';
$string['resetglossaries'] = 'Vymazať položky z';
$string['resetglossariesall'] = 'Vymazať položky zo všetkých slovníkov';
$string['rssarticles'] = 'Počet posledných RSS čLánkov';
$string['rssarticles_help'] = '<p>Táto voľba umožňuje nastaviť počet článkov, ktoré majú byť zahrnuté v RSS
kanáli.</p>

<p>Pre väčšinu slovníkov je vhodný počet medzi 5 a 20 článkami. Ak je slovník
často aktualizovaný, môžete počet článkov zvýšiť.</p>';
$string['rsssubscriberss'] = 'Zobraziť RSS kanál pre \'{$a}\' pojmy';
$string['rsstype'] = 'RSS kanál pre túto aktivitu';
$string['rsstype_help'] = '<p>Táto voľba umožňuje aktivovať RSS kanál pre aktuálny slovník.</p>

<p>Môžete zvoliť jeden z dvoch typov RSS kanálov:</p>

<ul>
  <li><b>Pojmy s autorom</b>: všetky články vytvárané pre tento kanál budú
  obsahovať meno autora.</li>

  <li><b>Pojmy bez autora</b>: články vytvárané pre tento kanál nebudú obsahovať
  meno autora.</li>
</ul>';
$string['searchindefinition'] = 'Plnotextové vyhľadávanie';
$string['secondaryglossary'] = 'Vedľajší slovník';
$string['showall'] = 'Zobraziť  \'VŠETKY\' prepojenia';
$string['showall_help'] = '<p>Používatelia môžu slovníkom prechádzať viacerými spôsobmi, ktoré sa dajú nastaviť nasledovnými voľbami:</p>

<p><b>Zobraziť prepojenie &quot;špeciálnych&quot; znakov</b>: umožní prechádzanie slovníku podľa
špeciálnych znakov, ako sú @, # atď.</p>

<p><b>Zobraziť abecedu</b>: umožní prechádzanie slovníku podľa jednotlivých
písmen abecedy.</p>

<p><b>Zobraziť &quot;VŠETKY&quot; prepojenia</b>: umožní prechádzanie všetkých položiek na jedenkrát.</p>';
$string['showalphabet'] = 'Zobraziť abecedu';
$string['showalphabet_help'] = '<p>Používatelia môžu slovníkom prechádzať viacerými spôsobmi, ktoré sa dajú nastaviť nasledovnými voľbami:</p>

<p><b>Zobraziť prepojenie &quot;špeciálnych&quot; znakov</b>: umožní prechádzanie slovníku podľa
špeciálnych znakov, ako sú @, # atď.</p>

<p><b>Zobraziť abecedu</b>: umožní prechádzanie slovníku podľa jednotlivých
písmen abecedy.</p>

<p><b>Zobraziť &quot;VŠETKY&quot; prepojenia</b>: umožní prechádzanie všetkých položiek na jedenkrát.</p>';
$string['showspecial'] = 'Zobraziť prepojenie \'Špeciálnych\'  znakov';
$string['showspecial_help'] = '<p>Používatelia môžu slovníkom prechádzať viacerými spôsobmi, ktoré sa dajú nastaviť nasledovnými voľbami:</p>

<p><b>Zobraziť prepojenie &quot;špeciálnych&quot; znakov</b>: umožní prechádzanie slovníku podľa
špeciálnych znakov, ako sú @, # atď.</p>

<p><b>Zobraziť abecedu</b>: umožní prechádzanie slovníku podľa jednotlivých
písmen abecedy.</p>

<p><b>Zobraziť &quot;VŠETKY&quot; prepojenia</b>: umožní prechádzanie všetkých položiek na jedenkrát.</p>';
$string['sortby'] = 'Triediť podľa';
$string['sortbycreation'] = 'Podľa dátumu vytvorenia';
$string['sortbylastupdate'] = 'Podľa dátumu poslednej aktualizácie';
$string['sortchronogically'] = 'Triediť chronologicky';
$string['special'] = 'Špeciálny';
$string['standardview'] = 'Prechádzať podľa abecedy';
$string['studentcanpost'] = 'Študenti môžu pridávať položky';
$string['totalentries'] = 'Celkový počet položiek';
$string['usedynalink'] = 'Automaticky prepájať položky slovníku';
$string['usedynalink_help'] = '<p>Zapnutím tejto voľby umožníte automatické vytváranie odkazov na slovníkové
položky vždy, keď sa heslové slovo alebo fráza objaví v niektorej časti kurzu &ndash; v
príspevkoch do fóra, v študijných zdrojoch, v týždňových denných sumároch, atď.</p>

<p>Poznámka: Aktivácia tejto voľby v nastavení slovníku neaktivuje automatické
vytváranie odkazov pre každé heslo &ndash; príslušnú voľbu je nutné aktivovať aj pri každej položke individuálne.</p>

<p>Ak v nektorom texte (napríklad v príspevku do fóra alebo v otázkach v teste) automatické odkazy vytvárať nechcete, označte ho párovými značkami &lt;nolink&gt; a
&lt;/nolink&gt;.</p>

<p>Odkazy sa vytvárajú aj pre názvy kategórií.</p>';
$string['waitingapproval'] = 'Čaká na schválenie';
$string['warningstudentcapost'] = '(Platí len vtedy, ak toto nie je hlavný slovník)';
$string['withauthor'] = 'Pojmy s autorom';
$string['withoutauthor'] = 'Pojmy bez autora';
$string['writtenby'] = 'autor';
$string['youarenottheauthor'] = 'Prepáčte, ale tento komentár nemôžete upravovať, pretože nie ste jeho autorom.';
