<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addanewdiscussion'] = 'Pridať novú diskusnú tému';
$string['addanewquestion'] = 'Pridať novú otázku';
$string['addanewtopic'] = 'Pridať novú tému';
$string['advancedsearch'] = 'Rozšírené vyhľadávanie';
$string['allforums'] = 'Všetky fóra';
$string['allowdiscussions'] = 'Môže {$a} prispievať do tohto fóra?';
$string['allowsallsubscribe'] = 'V tomto fóre si môže každý zvoliť, či bude odoberať príspevky alebo nie.';
$string['allowsdiscussions'] = 'Toto fórum povoľuje každému začať jednu diskusnú tému.';
$string['allsubscribe'] = 'Odoberať príspevky e-mailom zo všetkých fór';
$string['allunsubscribe'] = 'Zrušiť odoberanie príspevkov e-mailom zo všetkých fór';
$string['alreadyfirstpost'] = 'Toto je už prvý príspevok v tomto fóre';
$string['anyfile'] = 'Akýkoľvek súbor';
$string['areaattachment'] = 'Prílohy';
$string['attachment'] = 'Príloha';
$string['attachment_help'] = 'Máte možnosť pridať jeden alebo viacero súborov do príspevku fóra. Ak pridáte obrázok, zobrazí sa priamo v príspevku.';
$string['attachmentnopost'] = 'Nemôžete exportovať prílohy bez ID čísla';
$string['attachments'] = 'Prílohy';
$string['attachmentswordcount'] = 'Prílohy a počet slov';
$string['blockafter'] = 'Blokovať po dosiahnutí počtu príspevkov';
$string['blockafter_help'] = 'Toto nastavenie určuje maximálny počet príspevkov, ktoré môže používateľ vložiť počas určeného časového intervalu. Nevzťahuje sa na používateľov so schopnosťou mod/forum:postwithoutthrottling.';
$string['blockperiod'] = 'Blokačné obdobie';
$string['blockperioddisabled'] = 'Neblokovať';
$string['blockperiod_help'] = 'Je možné zablokovať študentov predtým, aby vkladali viac ako maximálny počet príspevkov počas určeného časového intervalu. Nevzťahuje sa na používateľov so schopnosťou mod/forum:postwithoutthrottling.';
$string['blogforum'] = 'Fórum sa zobrazuje v štandardnom formáte blogu';
$string['bynameondate'] = 'autor {$a->name} - {$a->date}';
$string['cannotadd'] = 'Nie je možné pridať diskusiu do tohto fóra';
$string['cannotadddiscussion'] = 'Aby ste mohli pridávať diskusie do tohto fóra, musíte byť členmi skupiny.';
$string['cannotadddiscussionall'] = 'Nemáte oprávnenia pridať novú tému diskusie pre všetkých účastníkov.';
$string['cannotaddsubscriber'] = 'Nie je možné pridať do fóra účastníkov s ID číslom {$a}!';
$string['cannotaddteacherforumto'] = 'Nebolo možné vložiť skonvertované učiteľské fórum do nultej sekcie v kurze.';
$string['cannotcreatediscussion'] = 'Nie je možné pridať novú diskusiu';
$string['cannotcreateinstanceforteacher'] = 'Nebolo možné vytvoriť nové učiteľské fórum.';
$string['cannotdeletepost'] = 'Nemôžete vymazať tento príspevok!';
$string['cannoteditposts'] = 'Nemáte oprávnenie upraviť príspevky iných účastníkov!';
$string['cannotfinddiscussion'] = 'Diskusia nebola nájdená v tomto fóre';
$string['cannotfindfirstpost'] = 'V tomto fóre nebol nájdený prvý príspevok';
$string['cannotfindorcreateforum'] = 'Nebolo možné nájsť alebo vytvoriť hlavné diskusné fórum pre portál.';
$string['cannotfindparentpost'] = 'Nebolo možné nájsť nadradený príspevok pre príspevok {$a}';
$string['cannotmovefromsingleforum'] = 'Nie je možné presunúť diskusiu z typu jednoduché diskusné fórum';
$string['cannotmovenotvisible'] = 'Fórum nie je viditeľné';
$string['cannotmovetonotexist'] = 'Nemôžete sa presunúť na toto fórum, pretože neexistuje.';
$string['cannotmovetonotfound'] = 'Cieľové fórum nebolo v tomto kurze nájdené.';
$string['cannotpurgecachedrss'] = 'Nepodarilo sa vyčistiť uložené RSS zdroje pre zdrojové a/alebo cieľové diskusné fóra - skontrolujte súbor permissionsforums.';
$string['cannotremovesubscriber'] = 'Z  tohto fóra nie je možné odstrániť používateľa s ID číslom {$a}';
$string['cannotreply'] = 'Nemôžete odpovedať na tento príspevok';
$string['cannotsplit'] = 'Diskusia z tohto fóra nemôže byť rozdelená ';
$string['cannotsubscribe'] = 'Prepáčte, ak sa chcete prihlásiť, musíte byť členom skupiny.';
$string['cannottrack'] = 'Nie je možné zastaviť sledovanie tohto fóra';
$string['cannotunsubscribe'] = 'Nie je možné vás odhlásiť z tohto fóra';
$string['cannotupdatepost'] = 'Nemôžete aktualizovať tento príspevok';
$string['cannotviewpostyet'] = 'Nemôžete si prezrieť otázky iných študentov, pretože ste ešte nevložili svoj príspevok.';
$string['cannotviewusersposts'] = 'Nemáte prístup k príspevkom tohto používateľa';
$string['cleanreadtime'] = 'Čas kedy označiť staré príspevky ako prečítané.';
$string['completiondiscussions'] = 'Počet diskusii, ktoré študent musí pridať:';
$string['completiondiscussionsgroup'] = 'Vyžadujú sa diskusie ';
$string['completiondiscussionshelp'] = 'Pre ukončenie sa vyžadujú diskusie ';
$string['completionposts'] = 'Počet odpovedí alebo diskusii, ktoré študent musí pridať:';
$string['completionpostsgroup'] = 'Vyžadujú sa príspevky';
$string['completionpostshelp'] = 'Pre ukončenie sa vyžadujú sa diskusie alebo odpovede';
$string['completionreplies'] = 'Počet odpovedí, ktoré študent musí pridať:';
$string['completionrepliesgroup'] = 'Vyžadujú sa odpovede';
$string['completionreplieshelp'] = 'Pre ukončenie sa vyžadujú odpovede';
$string['configcleanreadtime'] = 'Hodina, kedy sa budú staré príspevky odstraňovať z tabuľky prečítaných príspevkov.';
$string['configdigestmailtime'] = 'Ľuďom, ktorí sa rozhodnú pre zasielanie emailov v štruktúrovanej forme, bude každý deň prichádzať email stručne informujúci o najnovších udalostiach v kurze. Toto nastavenie určuje tú časť dňa, kedy bude tento email zasielaný používateľom (odošle ho nasledujúci cron po ukončení tejto hodiny).';
$string['configdisplaymode'] = 'Predvolený režim zobrazenia diskusie, ak nebol nastavený inak.';
$string['configenablerssfeeds'] = 'Týmto povolíte funkciu RSS kanálov pre všetky diskusné fóra. Budete ešte musieť zapnúť RSS kanály v nastaveniach jednotlivých fór.';
$string['configenabletimedposts'] = 'Nastavte \'áno\' ak chcete povoliť zobrazenie rozsahu času, kedy sa dá vkladať príspevok do fóra.';
$string['configlongpost'] = 'Každý vložený príspevok nad túto veľkosť (HTML kód sa nepočíta) je považovaný za dlhý.';
$string['configmanydiscussions'] = 'Maximálny počet diskusií vo fóre zobrazených na jednej stránke';
$string['configmaxattachments'] = 'Predvolené maximum počtu príloh pre každý príspevok';
$string['configmaxbytes'] = 'Východzia maximálna veľkosť prílohy vo všetkých fórach na týchto stránkach (môže byť upravená nastaveniami kurzu a ďalšími lokálnymi premennými)';
$string['configoldpostdays'] = 'Počet dní, po ktorých sa staré príspevky považujú za prečítané.';
$string['configreplytouser'] = 'Ak je príspevok odosielaný odberateľom, má email v položke Od: obsahovať adresu autora príspevku? Príjemca tak môže odpovedať priamo autorovi emailom a nie cez diskusné fórum. Aj keď je tu zvolená hodnota \'Áno\', používatelia si môžu vo svojich profiloch nastaviť skrývanie svojej emailovej adresy.';
$string['configshortpost'] = 'Každý vložený príspevok pod túto veľkosť (v znakoch, HTML kód sa nepočíta) je považovaný za krátky (pozri nižšie).';
$string['configtrackreadposts'] = 'Nastavte na \'Áno\', ak chcete označiť príspevky ako prečítané/neprečítané pre každého používateľa.';
$string['configusermarksread'] = 'Ak je nastavenie \'Áno\', používateľ musí ručne označiť príspevok ako prečítaný. Ak \'Nie\', príspevok bude automaticky označený ako prečítaný, ak bude prezretý.';
$string['confirmsubscribe'] = 'Naozaj chcete odoberať príspevky z fóra \'{$a}\' mailom?';
$string['confirmunsubscribe'] = 'Naozaj chcete zrušiť odoberanie príspevkov z fóra \'{$a}\' mailom?';
$string['couldnotadd'] = 'Kvôli neznámej chybe nie je možné pridať Váš príspevok';
$string['couldnotdeletereplies'] = 'Prepáčte, tento príspevok nemôže byť odstránený, pretože ľudia naň už reagovali';
$string['couldnotupdate'] = 'Kvôli neznámej chybe nie je možné aktualizovať Váš príspevok';
$string['delete'] = 'Odstrániť';
$string['deleteddiscussion'] = 'Diskusná téma bola odstránená';
$string['deletedpost'] = 'Príspevok bol odstránený';
$string['deletedposts'] = 'Tieto príspevky boli odstránené';
$string['deletesure'] = 'Naozaj chcete odstrániť tento príspevok?';
$string['deletesureplural'] = 'Naozaj chcete odstrániť tento príspevok a všetky odpovede naň? ({$a} príspevkov )';
$string['digestmailheader'] = 'Toto je Váš denný súhrn nových príspevkov v diskusiách na stránkach {$a->sitename}. Ak chcete zmeniť nastavenia týchto odberov, choďte na {$a->userprefs}.';
$string['digestmailprefs'] = 'váš používateľský profil';
$string['digestmailsubject'] = '{$a}: súhrn nových príspevkov';
$string['digestmailtime'] = 'Hodina odosielania súhrnných emailov';
$string['digestsentusers'] = 'Súhrnné emaily nových príspevkov úspešne zaslané {$a} používateľom.';
$string['disallowsubscribe'] = 'Odoberanie e-mailom nie je povolené.';
$string['disallowsubscribeteacher'] = 'Odoberanie e-mailom nie je povolené (s výnimkou učiteľov).';
$string['discussion'] = 'Diskusia';
$string['discussionmoved'] = 'Táto diskusia sa presunula do \'{$a}\'.';
$string['discussionmovedpost'] = 'Táto diskusia bola presunutá <a href="{$a->discusshref}">sem</a> do fóra <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Názov diskusie';
$string['discussions'] = 'Diskusie';
$string['discussionsstartedby'] = 'Diskusiu začal(a) {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusiu naposledy začal(a) {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskusie zahájené používateľom {$a->fullname} v kurze {$a->coursename}';
$string['discussthistopic'] = 'Diskutovať na túto tému';
$string['displayend'] = 'Koniec';
$string['displayend_help'] = '<p>Môžete si zvoliť, či sa váš príspevok bude zobrazovať od určitého dátumu,
alebo do určitého dátumu, alebo bude zobrazený iba určitý čas.</p>

<p>Odškrtnutím poľa "Deaktivovať" aktivujete dátum pre začiatok a/alebo koniec
zobrazenia.</p>

<p>Poznámka: používatelia, ktorí majú práva administrátora, uvidia príspevky v ľubovoľnom čase bez ohraničení.</p>';
$string['displaymode'] = 'Mód zobrazenia';
$string['displayperiod'] = 'Čas zobrazovania príspevku';
$string['displaystart'] = 'Začiatok';
$string['displaystart_help'] = '<p>Môžete si zvoliť, či sa váš príspevok bude zobrazovať od určitého dátumu,
alebo do určitého dátumu, alebo bude zobrazený iba určitý čas.</p>

<p>Odškrtnutím poľa "Deaktivovať" aktivujete dátum pre začiatok a/alebo koniec
zobrazenia.</p>

<p>Poznámka: používatelia, ktorí majú práva administrátora, uvidia príspevky v ľubovoľnom čase bez ohraničení.</p>';
$string['displaywordcount'] = 'Zobrazovať počet slov';
$string['eachuserforum'] = 'Každý môže začať len jednu tému diskusie';
$string['edit'] = 'Upraviť';
$string['editedby'] = 'Upravené: {$a->name} - {$a->date}';
$string['editing'] = 'Úprava';
$string['emptymessage'] = 'Vo Vašom príspevku sa vyskytla chyba. Možno ste  nevyplnili niektoré povinné údaje, alebo bola Vaša príloha príliš veľká. Vaše zmeny NEBOLI uložené.';
$string['erroremptymessage'] = 'Diskusný príspevok ktorý chcete pridať, nemôže byť prázdny.';
$string['erroremptysubject'] = 'Predmet príspevku nemôže byť prázdny.';
$string['errorenrolmentrequired'] = 'Pre prístup k danému obsahu musíte byť v tomto kurze prihlásení';
$string['errorwhiledelete'] = 'Vyskytla sa chyba počas vymazávania záznamu.';
$string['everyonecanchoose'] = 'Ktokoľvek si môže vybrať odoberanie príspevkov emailom';
$string['everyonecannowchoose'] = 'Odoberanie príspevkov emailom je voliteľné';
$string['everyoneisnowsubscribed'] = 'Teraz každý odoberá nové príspevky emailom';
$string['everyoneissubscribed'] = 'Každý odoberá nové príspevky emailom';
$string['existingsubscribers'] = 'Existujúci odberatelia';
$string['exportdiscussion'] = 'Exportovať celú diskusiu';
$string['forcessubscribe'] = 'Toto fórum vnucuje odber príspevkov';
$string['forum'] = 'Fórum';
$string['forum:addnews'] = 'Pridať novinky';
$string['forum:addquestion'] = 'Pridať otázku';
$string['forumauthorhidden'] = 'Autor (nezverejnený)';
$string['forumblockingalmosttoomanyposts'] = 'Blížite sa k maximu počtu vložených príspevkov. Za posledných {$a->blockperiod} ste do fóra vložili {$a->numposts} príspevkov, limit je {$a->blockafter}.';
$string['forumbodyhidden'] = 'Tento príspevok si nemôžete prezrieť - asi ste do diskusie ešte nevložili žiadny príspevok alebo ešte neuplynul čas pre úpravu príspevku.';
$string['forum:createattachment'] = 'Vytvoriť prílohy';
$string['forum:deleteanypost'] = 'Vymazať (kedykoľvek) ľubovoľný príspevok';
$string['forum:deleteownpost'] = 'Vymazať vlastné príspevky (v rámci časového limitu)';
$string['forum:editanypost'] = 'Upraviť ľubovoľný príspevok';
$string['forum:exportdiscussion'] = 'Exportovať celú diskusiu';
$string['forum:exportownpost'] = 'Exportovať vlastné príspevky';
$string['forum:exportpost'] = 'Exportovať príspevky';
$string['forumintro'] = 'Úvod do diskusného fóra';
$string['forum:managesubscriptions'] = 'Administrovať odoberanie príspevkov';
$string['forum:movediscussions'] = 'Presúvať diskusie';
$string['forumname'] = 'Názov fóra';
$string['forumposts'] = 'Príspevky vo fórach';
$string['forum:postwithoutthrottling'] = 'Oslobodenie od maximálneho počtu príspevkov';
$string['forum:rate'] = 'Hodnotiť príspevky';
$string['forum:replynews'] = 'Odpovedať na novinky';
$string['forum:replypost'] = 'Odpovedať na príspevky';
$string['forums'] = 'Fóra';
$string['forum:splitdiscussions'] = 'Rozdeľovať diskusiu';
$string['forum:startdiscussion'] = 'Začínať novú diskusiu';
$string['forumsubjecthidden'] = 'Predmet  (nezverejnený)';
$string['forumtracked'] = 'Neprečítané prípsevky sú sledované';
$string['forumtrackednot'] = 'Neprečítané príspevky nie sú sledované';
$string['forumtype'] = 'Typ fóra';
$string['forumtype_help'] = 'Existuje 5 rôznych typov fór:

* Jediná jednoduchá diskusia - je to len jedna téma, každý na ňu môže odpovedať
* Každý môže poslať len jeden príspevok do diskusie  -   každý študent môže začal diskusiu a každý môže odpovedať.
* Otázka a odpoveď - študenti musia najprv vložiť svoj názor a až potom môžu vidieť ostatné odpovede
* Štandardné fórum zobrazené v blogovom formáte - jedná sa o otvorené fórum, kde hocikto a hocikedy môže začať novú tému. Diskusné príspevky sú znázornené na jednej strane s odkazmi "Diskutovať túto tému"
* Štandardné fórum na všeobecné použitie - jedná sa o otvorené fórum, kde hocikto a hocikedy môže začať novú tému.';
$string['forum:viewallratings'] = 'Zobraziť všetky hodnotenia zadané jednotlivcami';
$string['forum:viewanyrating'] = 'Vidieť všetky hodnotenia';
$string['forum:viewdiscussion'] = 'Vidieť diskusie';
$string['forum:viewhiddentimedposts'] = 'Vidieť časovo obmedzené príspevky';
$string['forum:viewqandawithoutposting'] = 'Vždy vidieť otázky (Q) a odpovede (A)';
$string['forum:viewrating'] = 'Vidieť vaše hodnotenia';
$string['forum:viewsubscribers'] = 'Vidieť odberateľov';
$string['generalforum'] = 'Štandardné fórum pre bežné použitie';
$string['generalforums'] = 'Bežné fóra';
$string['inforum'] = 'v {$a}';
$string['introblog'] = 'Príspevky v tomto fóre boli sem skopírované automaticky z blogov používateľov v tomto kurze, pretože položky blogov už nie sú ďalej podporované.';
$string['intronews'] = 'Všeobecné správy a oznamy';
$string['introsocial'] = 'Otvorené fórum pre rozhovory na ľubovoľnú tému';
$string['introteacher'] = 'Uzavreté fórum vyhradené len pre diskusiu učiteľov';
$string['invalidaccess'] = 'Táto stránka nebola otvorená správne';
$string['invaliddiscussionid'] = 'Nesprávne alebo neexistujúce ID číslo diskusie';
$string['invalidforcesubscribe'] = 'Neplatný mód povinného odoberania fór';
$string['invalidforumid'] = 'Nesprávne ID číslo fóra';
$string['invalidparentpostid'] = 'Nadradený identifikátor príspevku bol nesprávny';
$string['invalidpostid'] = 'Neplatný identifikátor príspevku - {$a}';
$string['lastpost'] = 'Posledný príspevok';
$string['learningforums'] = 'Vzdelávacie fóra';
$string['longpost'] = 'Dlhý príspevok';
$string['mailnow'] = 'Odoslať okamžite e-mailom';
$string['manydiscussions'] = 'Počet diskusií na stranu';
$string['markalldread'] = 'Označiť všetky príspevky v tejto diskusii ako prečítané.';
$string['markallread'] = 'Označiť  všetky príspevky v tomto fóre ako prečítané.';
$string['markread'] = 'Označiť ako prečítané';
$string['markreadbutton'] = 'Označiť ako<br />prečítané';
$string['markunread'] = 'Označiť ako neprečítané';
$string['markunreadbutton'] = 'Označiť ako<br />neprečítané';
$string['maxattachments'] = 'Maximálny počet príloh';
$string['maxattachments_help'] = 'Toto nastavenie určuje maximálny počet príloh pre každý príspevok fóra';
$string['maxattachmentsize'] = 'Maximálna veľkosť prílohy';
$string['maxattachmentsize_help'] = '<p>Pri zakladaní fóra môžete určiť, aká bude maximálna veľkosť prílohy,
ktorú možno pripojiť k jednotlivým príspevkom.</p>

<p>Niekedy sa zdanlivo podarí priložiť súbor, ktorý je väčší, než je stanovené
maximum. Tento súbor však nebude uložený na server; používateľ o tom bude
informovaný chybovým hlásením.</p>';
$string['maxtimehaspassed'] = 'Prepáčte, ale povolený čas na úpravu tohto príspevku ({$a})vypršal!';
$string['message'] = 'Správa';
$string['messageprovider:digests'] = 'Odoberanie zhrnutia z fóra';
$string['messageprovider:posts'] = 'Odoberanie príspevkov z fóra';
$string['missingsearchterms'] = 'Nasledujúce vyhľadávané výrazy sa v tejto správe vyskytujú iba v značkách jazyka HTML:';
$string['modeflatnewestfirst'] = 'Znázorniť odpovede za sebou (prvá správa je najnovšia)';
$string['modeflatoldestfirst'] = 'Znázorniť odpovede za sebou (prvá správa je najstaršia)';
$string['modenested'] = 'Znázorniť hierarchiu odpovedí (vrátane textu)';
$string['modethreaded'] = 'Znázorniť hierarchiu odpovedí (iba osnovu)';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = '<p><img alt="" src=
"<?php echo $CFG->wwwroot?>/mod/fórum/icon.gif">&nbsp;<b>Fóra</b></p>

<div class="indent">
  Táto činnosť môže byť tou najdôležitejšou &ndash; práve tu totiž najčastejšie prebieha
  diskusia medzi účastníkmi kurzu. Fóra môžu byť usporiadané niekoľkými rôznymi
  spôsobmi a môžu zahŕňať hodnotenia príspevkov ostatnými účastníkmi kurzu či
  učiteľmi. Príspevky možno prehliadať v niekoľkých formátoch a možno k nim
  pripojiť prílohu. Účastníci kurzu majú možnosť prihlásiť sa k odberu
  príspevkov, kópia každého vloženého príspevku im v tomto prípade bude posielaná
  e-mailom. Učiteľ má možnosť vnútiť odoberanie príspevkov všetkým účastníkom.
</div>';
$string['modulenameplural'] = 'Fóra';
$string['more'] = 'viac';
$string['movedmarker'] = '(Presunuté)';
$string['movethisdiscussionto'] = 'Presunúť túto diskusiu do ...';
$string['mustprovidediscussionorpost'] = 'Pre export musíte zadať alebo identifikátor diskusie alebo príspevku';
$string['namenews'] = 'Fórum noviniek';
$string['namenews_help'] = '<p>Fórum Noviniek je špeciálne fórum, určené pre vkladanie všeobecných oznámení.
   Fórum sa vytvára automaticky pre každý kurz a aj pre titulnú stránku inštalácie.
   Každý kurz môže obsahovať iba jedno fórum noviniek.</p>

<p>Najnovšie diskusie vložené do fóra noviniek sa zobrazujú v&nbsp;bloku
   &quot;najnovšie správy&quot; (aj keď fórum premenujete). Ak ste fórum
   Novinky odstránili, vytvorí sa automaticky znova, ak v&nbsp;kurze použijete
   blok &quot;Najnovšie správy&quot;.</p>';
$string['namesocial'] = 'Spoločenské fórum';
$string['nameteacher'] = 'Učiteľské fórum';
$string['newforumposts'] = 'Nové príspevky do fóra';
$string['noattachments'] = 'Tento príspevok neobsahuje žiadne prílohy';
$string['nodiscussions'] = 'V tomto fóre ešte nie sú žiadne diskusné témy';
$string['nodiscussionsstartedby'] = 'Používateľ {$a} ešte nezačal žiadne diskusie';
$string['nodiscussionsstartedbyyou'] = 'Nezačali ste ešte žiadne diskusie';
$string['noguestpost'] = 'Prepáčte, ale hostia nemôžu prispievať do fóra.';
$string['noguesttracking'] = 'Prepáčte, ale hostia si nemôžu nastaviť označovanie neprečítaných príspevkov.';
$string['nomorepostscontaining'] = 'Neboli nájdené žiadne ďalšie príspevky obsahujúce \'{$a}\'';
$string['nonews'] = 'Žiadne novinky neboli publikované';
$string['noonecansubscribenow'] = 'Odoberanie je v súčasnosti zakázané';
$string['nopermissiontosubscribe'] = 'Nemáte oprávnenie vidieť zoznam prispievateľov do fóra';
$string['nopermissiontoview'] = 'Nemáte oprávnenie vidieť tento príspevok';
$string['nopostforum'] = 'V tomto fóre nemôžete prispievať';
$string['noposts'] = 'Bez príspevkov';
$string['nopostsmadebyuser'] = 'Používateľ {$a} nevložil žiadny príspevok';
$string['nopostsmadebyyou'] = 'Nevložili ste žiadny príspevok';
$string['noquestions'] = 'Do tohto fóra zatiaľ nebola vložená žiadna otázka.';
$string['nosubscribers'] = 'V tomto fóre zatiaľ nikto neodoberá nové príspevky emailom';
$string['notexists'] = 'Diskusia už neexistuje';
$string['nothingnew'] = 'Žiadne nové správy';
$string['notingroup'] = 'Prepáčte, ale na prehliadanie tohto fóra musíte byť členom skupiny.';
$string['notinstalled'] = 'Fórum nie je nainštalované';
$string['notpartofdiscussion'] = 'Tento príspevok nie je súčasťou diskusie!';
$string['notrackforum'] = 'Neoznačovať neprečítané správy';
$string['noviewdiscussionspermission'] = 'Nemáte oprávnenie prezerať diskusie v tomto fóre';
$string['nowallsubscribed'] = 'Odoberanie príspevkov zo všetkých fór v kurze \'{$a}\' je zapnuté.';
$string['nowallunsubscribed'] = 'Odoberanie príspevkov zo všetkých fór v kurze \'{$a}\' je vypnuté.';
$string['nownotsubscribed'] = '{$a->name} NEBUDE dostávať kópie príspevkov z  \'{$a->forum}\' emailom.';
$string['nownottracking'] = '{$a->name} nemá zapnutú voľbu: Označovať neprečítané príspevky v  \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} BUDE dostávať kópie príspevkov z  \'{$a->forum}\' emailom.';
$string['nowtracking'] = '{$a->name} má zapnutú voľbu: Označovať neprečítané príspevky v  \'{$a->forum}\'.';
$string['numposts'] = '{$a} príspevkov';
$string['olderdiscussions'] = 'Staršie diskusie';
$string['oldertopics'] = 'Staršie témy';
$string['oldpostdays'] = 'Prečítané po dňoch';
$string['openmode0'] = 'Ani nové témy diskusie, ani reakcie na ne nie sú povolené';
$string['openmode1'] = 'Bez tém diskusie, ale reakcie sú povolené';
$string['openmode2'] = 'Aj nové témy diskusie, aj reakcie sú povolené';
$string['overviewnumpostssince'] = 'príspevkov od posledného prihlásenia';
$string['overviewnumunread'] = 'celkom neprečítaných';
$string['page-mod-forum-discuss'] = 'Stránka diskusného vlánka';
$string['page-mod-forum-view'] = 'Hlavná stránka modulu fórum';
$string['page-mod-forum-x'] = 'Ľubovoľná stránka modulu fórum';
$string['parent'] = 'Ukázať predošlý príspevok';
$string['parentofthispost'] = 'Predchodca tohto príspevku';
$string['pluginadministration'] = 'Správa fóra';
$string['pluginname'] = 'Fórum';
$string['postadded'] = '<p>Váš príspevok bol úspešne pridaný.</p><p>Máte {$a} na úpravu, ak chcete urobiť nejaké zmeny.</p>';
$string['postaddedsuccess'] = 'Váš diskusný príspevok bol úspešne pridaný.';
$string['postaddedtimeleft'] = 'Máte {$a} k úprave ak chcete urobiť zmeny.';
$string['postincontext'] = 'Ukázať tento príspevok v kontexte';
$string['postmailinfo'] = 'Toto je kópia správy publikovanej na {$a} stránke.

Ak chcete pridať Vašu reakciu na túto správu, kliknite na tento odkaz:';
$string['postmailnow'] = '<p>Tento príspevok bude hneď po vložení poslaný e-mailom všetkým, ktorí majú zapnuté odoberanie príspevkov z tohto fóra.</p>';
$string['postrating1'] = 'Vykazuje najmä individuálne poznávanie';
$string['postrating2'] = 'Rovnako individuálne aj vzťahové';
$string['postrating3'] = 'Vykazuje najmä vzťahové poznávanie';
$string['posts'] = 'Príspevky';
$string['postsmadebyuser'] = 'Príspevky používateľa {$a}';
$string['postsmadebyuserincourse'] = 'Príspevky používateľa {$a->fullname} v kurze {$a->coursename}';
$string['posttoforum'] = 'Poslať do fóra';
$string['postupdated'] = 'Váš príspevok bol aktualizovaný';
$string['potentialsubscribers'] = 'Potenciálni odberatelia príspevkov';
$string['processingdigest'] = 'Spracováva sa súhrnný email pre používateľa {$a}';
$string['processingpost'] = 'Spracovávanie príspevku {$a}';
$string['prune'] = 'Oddeliť';
$string['prunedpost'] = 'Z príspevku bola vytvorená nová diskusia';
$string['pruneheading'] = 'Oddeliť a presunúť tento príspevok do novej diskusie';
$string['qandaforum'] = 'Otázky a odpovede';
$string['qandanotify'] = 'Toto je fórum typu \'otázky a odpovede\'. Ak si chcete prezrieť ostatné odpovede na vložené otázky, musíte najskôr vložiť svoju odpoveď.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Čítať zostatok tejto témy';
$string['replies'] = 'Odpovede';
$string['repliesmany'] = '{$a} odpovedí zatiaľ';
$string['repliesone'] = '{$a} odpoveď zatiaľ';
$string['reply'] = 'Odpovedať';
$string['replyforum'] = 'Odpovedať do fóra';
$string['replytouser'] = 'Použiť mailovú adresu v odpovedi';
$string['resetforums'] = 'Odstrániť všetky príspevky z tohto typu fór.';
$string['resetforumsall'] = 'Vymazať všetky príspevky';
$string['resetsubscriptions'] = 'Odstrániť odoberateľov fóra';
$string['resettrackprefs'] = 'Vymazať všetky preferencie sledovania fóra.';
$string['rssarticles'] = 'Počet súčasných RSS článkov';
$string['rssarticles_help'] = '<p>Táto voľba umožňuje nastaviť počet článkov, ktoré majú byť zahrnuté v RSS
kanále.</p>

<p>Pre väčšinu fór je vhodný počet medzi 5 a 20 článkami. Ak je fórum veľmi
frekventované, môžete počet zvýšiť.</p>';
$string['rsssubscriberssdiscussions'] = 'Zobraziť RSS kanál diskusií';
$string['rsssubscriberssposts'] = 'RSS kanál príspevkov';
$string['rsstype'] = 'RSS kanál pre túto aktivitu';
$string['rsstype_help'] = 'Pre zapnutie RSS kanálu pre túto aktivitu vyberte alebo diskusie ako príspevky, ktoré majú byť zahrnuté v kanále.';
$string['search'] = 'Hľadať';
$string['searchdatefrom'] = 'Príspevky musia byť novšie ako';
$string['searchdateto'] = 'Príspevky musia byť staršie ako';
$string['searchforumintro'] = 'Prosím vložte vyhľadávané termíny do jedného alebo viacerých polí:';
$string['searchforums'] = 'Hľadať vo fórach';
$string['searchfullwords'] = 'Tieto slová by sa mali vyskytovať ako celé slová';
$string['searchnotwords'] = 'Tieto slová by v príspevku NEMALI byť';
$string['searcholderposts'] = 'Prehľadávať staršie príspevky ...';
$string['searchphrase'] = 'Presne táto fráza sa musí vyskytovať v príspevku';
$string['searchresults'] = 'Výsledky hľadania';
$string['searchsubject'] = 'Tieto slová by mali byť v predmete príspevku';
$string['searchuser'] = 'Toto meno by sa malo zhodovať s menom autora';
$string['searchuserid'] = 'Moodle ID autora';
$string['searchwhichforums'] = 'Vyber si fóra, ktoré sa majú  prehľadávať';
$string['searchwords'] = 'Tieto slová sa môžu vyskytnúť hocikde v príspevku';
$string['seeallposts'] = 'Zobraziť všetky príspevky od tohto používateľa';
$string['shortpost'] = 'Krátky príspevok';
$string['showsubscribers'] = 'Zobraziť/Upraviť  odberateľov príspevkov';
$string['singleforum'] = 'Jednoduchá diskusia';
$string['smallmessage'] = '{$a->user} diskutoval vo fóre {$a->forumname}';
$string['startedby'] = 'Diskusiu začal(a)';
$string['subject'] = 'Predmet';
$string['subscribe'] = 'Odoberať nové príspevky emailom';
$string['subscribeall'] = 'Nastaviť všetkým odoberanie príspevkov z tohto fóra';
$string['subscribed'] = 'Príspevky odoberané emailom';
$string['subscribeenrolledonly'] = 'Ľutujeme, ale odoberať príspevky mailom z tohto fóra môžu iba účastníci tohto kurzu.';
$string['subscribenone'] = 'Zrušiť všetkým odoberanie príspevkov z tohto fóra';
$string['subscribers'] = 'Odberatelia';
$string['subscribersto'] = 'Odberatelia - \'{$a}\'';
$string['subscribestart'] = 'Poslať mi emailom kópie príspevkov v tomto fóre';
$string['subscribestop'] = 'Nechcem dostávať emailom kópie príspevkov v tomto fóre';
$string['subscription'] = 'Odoberanie príspevkov';
$string['subscriptionauto'] = 'Počiatočné odoberanie';
$string['subscriptiondisabled'] = 'Odoberanie nie je umožnené';
$string['subscriptionforced'] = 'Povinné odoberanie';
$string['subscription_help'] = '<p>Ak sa niekto prihlási do fóra, znamená to že mu cez e-mail budú
posielané kópie všetkých príspevkov v tomto fóre. (príspevky sú
posielané približne po <?php echo $CFG->maxeditingtime/60 ?> minútach
ako tieto boli napísané). </p>

<p>Obyčajne si účastníci môžu vybrať, či chcú byť zapísaní do
jednotlivého fóra alebo nie.</p>

<p>V prípade, že učiteľ trvá na prihlásení sa účastníkov do
 konkrétneho fóra, v takom prípade je výber pre účastníkov znemožnený
 a každý v triede dostane kópiu e-mailu.
 </p>

<p>Toto je hlavne užitočné v prípade Nových fór a vo fórach na
začiatku kurzu (predtým ako všetci účastníci už pracovali v danom
kurze a teda sa sami môžu zapísať do fóra).  </p>';
$string['subscriptionmode'] = 'Mód odoberania';
$string['subscriptionmode_help'] = 'Ak je niekto prihlásený k odoberaniu príspevkov z určitého fóra, bude mu e-mailom poslaná kópia každého príspevku vloženého do tohto fóra.

Existujú 4 možné spôsoby:

* Voliteľné odoberanie - každý si obvykle môže zvoliť, či chce alebo nechce odoberať príspevky
* Vnútené odoberanie - každý bude prihlásený k odoberaniu automaticky a nemôže sa odhlásiť
* Automatické odoberanie - každý je na začiatku prihlásený a môže sa kedykoľvek odhlásiť
* Zakázané odoberanie - odoberanie príspevkov je zakázané';
$string['subscriptionoptional'] = 'Voliteľné odoberanie';
$string['subscriptions'] = 'Odoberanie príspevkov';
$string['thisforumisthrottled'] = 'Do tohto fóra môžete v určenom časovom období vložiť iba obmedzený počet príspevkov. Súčasné nastavenie je {$a->blockafter} príspevkov za {$a->blockperiod}.';
$string['timedposts'] = 'Časovo ohraničené príspevky';
$string['timestartenderror'] = 'Dátum pre koniec zobrazovania príspevku nemôže predchádzať dátum pre začiatok zobrazovania.';
$string['trackforum'] = 'Označovať neprečítané príspevky';
$string['tracking'] = 'Označovanie';
$string['trackingoff'] = 'Vypnuté';
$string['trackingon'] = 'Zapnuté';
$string['trackingoptional'] = 'Voliteľné';
$string['trackingtype'] = 'Majú sa v tomto fóre označovať neprečítané príspevky?';
$string['trackingtype_help'] = 'Ak je povolené, účastníci môžu sledovať prečítané a neprečítané príspevky vo fórach
a diskusiách.

Sú tri možnosti:

* Voliteľné: študenti si môžu označovanie vypínať a zapínať podľa vlastného uváženia.
* Zapnuté: označovanie je trvalo zapnuté
* Vypnuté: označovanie je trvalo vypnuté';
$string['unread'] = 'Neprečítaných';
$string['unreadposts'] = 'Neprečítaných príspevkov';
$string['unreadpostsnumber'] = '{$a} neprečítaných príspevkov';
$string['unreadpostsone'] = '1 neprečítaný príspevok';
$string['unsubscribe'] = 'Odhlásiť ma z odoberania príspevkov z tohto fóra';
$string['unsubscribeall'] = 'Odhlásiť ma z odoberania príspevkov zo všetkých fór';
$string['unsubscribeallconfirm'] = 'Odoberáte príspevky z {$a} fór. Naozaj sa chcete odhlásiť z odoberania príspevkov v nich a zrušiť automatické prihlasovanie do nich?';
$string['unsubscribealldone'] = 'Odoberanie príspevkov zo všetkých diskusných fór bolo zrušené. Je možné, že Vám budú stále zasielané príspevky z fór s núteným zápisom. Ak nechcete prijímať maily z tohto servera, zablokujte Vašu mailovú adresu vo svojom používateľskom profile.';
$string['unsubscribeallempty'] = 'Ľutujem, ale nie ste prihlásení do žiadneho diskusného fóra. Ak nechcete prijímať maily z tohto servera, zablokujte Vašu mailovú adresu vo svojom používateľskom profile.';
$string['unsubscribed'] = 'Odhlásený z odoberania príspevkov';
$string['unsubscribeshort'] = 'Odhlásiť z odoberania príspevkov';
$string['usermarksread'] = 'Manuálne označovanie prečítaných správ';
$string['viewalldiscussions'] = 'Zobraziť všetky diskusie';
$string['warnafter'] = 'Upozorniť po prekročení počtu príspevkov';
$string['warnafter_help'] = 'Je možné upozorniť študentov predtým, ako vložia maximálny počet príspevkov počas určeného časového intervalu. Toto nastavenie určuje, po koľkých príspevkoch sú upozornení. Nevzťahuje sa na používateľov so schopnosťou mod/forum:postwithoutthrottling.';
$string['yournewquestion'] = 'Nová otázka';
$string['yournewtopic'] = 'Vaša nová diskusná téma';
$string['yourreply'] = 'Vaša odpoveď';
