<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Dostupné autentifikačné zásuvné moduly';
$string['alternatelogin'] = 'Pokiaľ sem vložíte nejaké URL, bude použité ako prihlasovacia stránka k tomuto systému. Táto Vaša stránka by mala obsahovať formulár s vlastnosťou \'action\' nastavenou na <strong>\'{$a}\'</strong>, ktorá vracia pole <strong>username</strong> a <strong>password</strong>.<br />Dbajte na to, aby ste vložili platné URL! V opačnom prípade by ste mohli komukoľvek vrátane seba zamedziť prístup k týmto stránkam.<br />Ak chcete používať štandardnú prihlasovaciu stránku, nechajte toto pole prázdne.';
$string['alternateloginurl'] = 'Alternatívne URL pre prihlásenie';
$string['auth_changepasswordhelp'] = 'Pokyny k zmene hesla';
$string['auth_changepasswordhelp_expl'] = 'Zobraziť pokyny k zmene {$a} hesla. Tento text sa alebo a) zobrazí súčasne s <strong>URL pre zmenu hesla</strong> alebo s internou stránkou Moodle pre zmenu hesla, alebo sa b) zobrazí namiesto <strong>URL pre zmenu hesla</strong> alebo interná stránka Moodle pre zmenu hesla.';
$string['auth_changepasswordurl'] = 'URL pre zmenu hesla';
$string['auth_changepasswordurl_expl'] = 'Zadajte URL, kam majú byť presmerovaní používatelia požadujúci zmenu svojho {$a} hesla. U voľby <strong>Použi štandardnú stránku \'Zmena hesla\'</strong> vyššie vyberte <strong>Nie</strong>.';
$string['auth_changingemailaddress'] = 'Vyžiadali ste si zmenu emailovej adresy z  {$a->oldemail} na {$a->newemail}. Z bezpečnostných dôvodov Vám bude poslaný email na novú adresu pre potvrdenie, že táto patrí Vám. Vaša emailová adresa bude aktualizovaná, keď kliknete na URL odkaz v zaslanej správe.';
$string['auth_common_settings'] = 'Bežné nastavenia';
$string['auth_data_mapping'] = 'Mapovanie údajov';
$string['authenticationoptions'] = 'Možnosti overovania';
$string['auth_fieldlock'] = 'Zamknúť hodnotu';
$string['auth_fieldlock_expl'] = '<p><b>Zamknúť hodnotu:</b>Ak je voľba aktivovaná, bude zabraňovať priamemu upravovaniu políčok používateľmi a administrátormi Moodle. Použite túto voľbu, ak spravujete údaje v externom overovacom systéme.</p>';
$string['auth_fieldlocks'] = 'Zamknúť políčka používateľov';
$string['auth_fieldlocks_help'] = '<p>Môžete zamknúť údaje v políčkach používateľov. Toto je užitočné najmä na tých stránkach, kde sú údaje používateľov spravované administrátormi ručne, prostredníctvom upravovania ich záznamov alebo ich prenesenia cez voľbu \'Preniesť používateľov\'. Ak zamknete políčka, ktoré sú vyžadované Moodle, uistite sa, že pri vytváraní používateľských účtov poskytnete všetky potrebné údaje. V opačnom prípade budú účty nepoužiteľné.</p><p>Odporúčame zvážiť možnosť nastavenia režimu zamykania na \'Odomknuté, ak prázdne\', aby ste sa vyhli tomuto problému.</p>';
$string['authinstructions'] = 'Tu môžete uviesť pokyny pre používateľov, aby vedeli, aké používateľské meno a heslo majú používať. Text, ktorý tu vložíte sa objaví na prihlasovacej stránke. Ak to tu neuvediete, nebudú zobrazené žiadne pokyny.';
$string['auth_invalidnewemailkey'] = 'Chyba: ak sa snažíte potvrdiť zmenu emailovej adresy, zrejme ste urobili chybu pri kopírovaní URL odkazu, ktorý Vám bol poslaný emailom. Prosím skopírujte adresu správne a skúste znova.';
$string['auth_multiplehosts'] = 'Tu môžu byť špecifikovaní viacerí hostitelia ALEBO ich adresy (napr. host1.com;host2.com;host3.com alebo napr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_outofnewemailupdateattempts'] = 'Prekročili ste povolený počet pokusov o zmenu svojej emailovej adresy. Vaša požiadavka na zmenu bola zrušená.';
$string['auth_passwordisexpired'] = 'Platnosť Vášho hesla vypršala. Chcete si zmeniť Vaše heslo teraz?';
$string['auth_passwordwillexpire'] = 'Platnosť Vášho hesla vyprší o {$a} dní. Chcete si zmeniť Vaše heslo teraz?';
$string['auth_remove_delete'] = 'Úplne vymazať interné';
$string['auth_remove_keep'] = 'Uchovať interné';
$string['auth_remove_suspend'] = 'Suspendovať interné';
$string['auth_remove_user'] = 'Spresnite, čo treba robiť s interným používateľom v priebehu hromadnej synchronizácie, keď používateľ bol vymazaný z externej databázy. Automaticky sú obnovení iba suspendovaní používatelia, ktorý sa znovu objavia v externej databáze.';
$string['auth_remove_user_key'] = 'Odstránený externý používateľ';
$string['auth_sync_script'] = 'Synchronizačný skript Cron';
$string['auth_updatelocal'] = 'Aktualizovať miestne údaje';
$string['auth_updatelocal_expl'] = '<p><b>Aktualizovať miestne údaje:</b> Ak je táto voľba aktívna, pole bude aktualizované (z externého overovacieho zdroja) zakaždým, keď sa používateľ prihlási, alebo pri synchronizácii používateľov. Polia určené na miestnu aktualizáciu by mali byť uzamknuté.</p>';
$string['auth_updateremote'] = 'Aktualizovať externé údaje';
$string['auth_updateremote_expl'] = '<p><b>Aktualizovať externé údaje:</b> Ak je táto voľba aktívna, externý overovací zdroj bude aktualizovaný zakaždým, keď dôjde k aktualizácii profilu používateľa. Polia určené na miestnu aktualizáciu by nemali byť uzamknuté, aby sa mohli upravovať.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Poznámka:</b> Aktualizácia externých LDAP údajov si vyžaduje nastavenie binddn a bindpw spoluužívateľom s právom úpravy všetkých záznamov o používateľoch. Momentálne systém nepodporuje vlastnosti s viacerými hodnotami a pri aktualizácii sa preto odstránia nadbytočné hodnoty.</p>';
$string['auth_user_create'] = 'Umožniť vytváranie používateľov';
$string['auth_user_creation'] = 'Noví (anonymní) používatelia môžu vytvárať používateľské kontá v externom zdroji a overovať ich cez email. Ak to umožníte, nezabudnite tiež konfigurovať špecifické voľby pre vytváranie používateľských účtov v danom externom zdroji.';
$string['auth_usernameexists'] = 'Zvolené používateľské meno už existuje. Prosím, vyberte si iné.';
$string['auto_add_remote_users'] = 'Pridať vzdialených používateľov automaticky';
$string['changepassword'] = 'URL na zmenu hesla';
$string['changepasswordhelp'] = 'Tu môžete uviesť URL, na ktorom si Vaši používatelia môžu obnoviť alebo zmeniť používateľské meno/heslo, ak ho zabudli. Pre používateľov to bude zobrazené ako tlačidlo na prihlasovacej stránke ich používateľskej stránky. Ak to tu neuvediete, tlačidlo sa nezobrazí.';
$string['chooseauthmethod'] = 'Vyberte si spôsob overovania používateľov:';
$string['chooseauthmethod_help'] = '<p>Táto ponuka umožňuje zmeniť spôsob overovania u konkrétneho
používateľa.</p>

<p>Tiež berte do úvahy, že to do veľkej miery závisí na metódach
overovania, ktoré ste pre Váš portál nastavili a na nastavení, ktoré
tento portál používa.</p>

<p>Nesprávna zmena môže danému používateľovi znemožniť prihlásenie
alebo celkom odstrániť jeho účet. Spôsob overovania preto meňte iba
vtedy, ak viete, čo robíte.</p>';
$string['createpasswordifneeded'] = 'Vytvoriť heslo, ak je to treba';
$string['emailchangecancel'] = 'Zrušiť zmenu emailu';
$string['emailchangepending'] = 'Zmena mailu bude aktívna potom, ako kliknete na odkaz v maili poslanom na {$a->preference_newemail}.';
$string['emailnowexists'] = 'Nová emailová adresa, na ktorú ste si požiadali zmeniť svoje konto, už je používaná niekým iným. Vaša požiadavka na zmenu bola preto zrušená. Môžete požiadavku opakovať s odlišnou emailovou adresou.';
$string['emailupdate'] = 'Aktualizácia emailovej adresy';
$string['emailupdatemessage'] = 'Dobrý deň {$a->fullname},

Vyžiadali ste si zmenu Vašej emailovej adresy vo Vašom konte na portáli {$a->site}. Prosím kliknite na nasledovný odkaz vo vašom prehliadači na potvrdenie tejto zmeny.

{$a->url}';
$string['emailupdatesuccess'] = 'Emailová adresa používateľa <em>{$a->fullname}</em> bola úspešne aktualizovaná na <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potvrdenie emailovej aktualizácie na portáli {$a->site}';
$string['enterthenumbersyouhear'] = 'Zadajte čísla, ktoré počujete';
$string['enterthewordsabove'] = 'Zadajte vyššie uvedené slová';
$string['errormaxconsecutiveidentchars'] = 'Heslá môžu mať maximálne {$a} rovnakých znakov idúcich za sebou.';
$string['errorminpassworddigits'] = 'Heslá musia mať minimálne {$a} číslic.';
$string['errorminpasswordlength'] = 'Heslá musia byť minimálne {$a} znakov dlhé.';
$string['errorminpasswordlower'] = 'Heslá musia mať minimálne {$a} malých písmen.';
$string['errorminpasswordnonalphanum'] = 'Heslá musia mať minimálne {$a} nealfanumerických znakov.';
$string['errorminpasswordupper'] = 'Heslá musia mať minimálne {$a} veľkých písmen.';
$string['errorpasswordupdate'] = 'Chyba pri zmene hesla, heslo nebolo zmenené';
$string['forcechangepassword'] = 'Vyžadovať zmenu hesla';
$string['forcechangepasswordfirst_help'] = 'Vyžadovať od používateľov zmenu hesla pri ich prvom prihlásení do Moodle.';
$string['forcechangepassword_help'] = 'Vyžadovať od používateľov zmenu hesla pri ich ďalšom prihlásení do Moodle.';
$string['forgottenpassword'] = 'Ak sem vložíte URL, bude použitá ako stránka pre získanie zabudnutých hesiel tohto portálu. Sú tým mienené systémy, kde sú heslá spracovávané mimo Moodle. Nechajte prázdne na použitie východzieho systému správy zabudnutých hesiel.';
$string['forgottenpasswordurl'] = 'URL pre zabudnuté heslo';
$string['getanaudiocaptcha'] = 'Získať audio CAPTCHA';
$string['getanimagecaptcha'] = 'Získať obrazové CAPTCHA';
$string['getanothercaptcha'] = 'Získať iné CAPTCHA';
$string['guestloginbutton'] = 'Prihlasovacie tlačidlo pre hosťa';
$string['incorrectpleasetryagain'] = 'Nesprávne. Skúste znova.';
$string['infilefield'] = 'Pole je v súbore vyžadované';
$string['informminpassworddigits'] = 'minimálne {$a} číslic';
$string['informminpasswordlength'] = 'minimálne {$a} znakov';
$string['informminpasswordlower'] = 'minimálne {$a} malých písmen';
$string['informminpasswordnonalphanum'] = 'minimálne {$a} znakov (nie číslic alebo písmen)';
$string['informminpasswordupper'] = 'minimálne {$a} veľkých písmen';
$string['informpasswordpolicy'] = 'Heslo musí mať {$a}';
$string['instructions'] = 'Inštrukcie';
$string['internal'] = 'Interný';
$string['locked'] = 'Zamknutý/Zamknuté';
$string['md5'] = 'MD5 hash';
$string['nopasswordchange'] = 'Heslo nemôže byť zmenené';
$string['nopasswordchangeforced'] = 'Nemôžete pokračovať bez zmeny hesla, ale stránka pre jeho zmenenie nie je k dispozícii. Kontaktujte prosím svojho Moodle administrátora.';
$string['noprofileedit'] = 'Profil nemôže byť upravovaný';
$string['ntlmsso_attempting'] = 'Pokus o Single Sign On pomocou NTLM...';
$string['ntlmsso_failed'] = 'Auto-login sa nepodaril, skúste normálne prihlasovanie.';
$string['ntlmsso_isdisabled'] = 'NTLM SSO je zakázané.';
$string['passwordhandling'] = 'Zaobchádzanie s poľom hesla';
$string['plaintext'] = 'Čistý text';
$string['pluginnotenabled'] = 'Autentifikačný zásuvný modul \'{$a}\' nie je povolený.';
$string['pluginnotinstalled'] = 'Autentifikačný zásuvný modul  \'{$a}\' nie je nainštalovaný.';
$string['potentialidps'] = 'Prihlásiť sa pomocou Vášho účtu na:';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = '<h2>Opis</h2>
<p>CAPTCHA program na zistenie, či ten, kto ho používa, je človek alebo počítač. Je využívaná na veľkom množstve web stránok, aby zabránili zneužívaniu od "botov," alebo automatizovaných programov, ktoré sú najmä používané za účelom spamovania. Počítačové programy nevedia prečítať nedokonalo zobrazený text a tak boti sa nedostanú na stránky chránené mechanizmom CAPTCHA.</p>

<h2>Pokyny</h2>
<p>Zadajte prosím slová, ktoré sa zobrazia v rámčeku v danom poradí a oddelené medzerou. Takto zabránite automatizovaným programom od zneužitia tejto služby.</p>

<p>Ak si nie ste istí, aké sú to slová, alebo zadajte Váš najlepší odhad, alebo kliknite na odkaz "Získať iné CAPTCHA". </p>

<p>Používatelia so zníženými zrakovými schopnosťami môžu kliknúť na odkaz "Získať audio CAPTCHA" a vypočujú si číslice, ktoré treba zadať namiesto obrázkovej výzvy.</p>';
$string['selfregistration'] = 'Používatelia sa registrujú sami';
$string['selfregistration_help'] = 'Pokiaľ tu vyberiete nejakú autentizačnú metódu (typicky registrácia na základe e-mailu), tak umožníte sa registrovať potenciálnym používateľom. Toto môže viesť k útokom spammerov formou hromadného zakladania fiktívnych účtov, ktoré sú následne používané k publikovaniu nevhodného obsahu vo fórach, blogoch, používateľských profiloch, atď. K zabráneniu týmto rizikám, skúste zakázať túto autentizačnú metódu alebo ju obmedzte nastavením <em>Povolené e-mailové domény</em>';
$string['sha1'] = 'SHA - 1 hash';
$string['showguestlogin'] = 'Môžete skryť alebo zobraziť prihlasovacie tlačidlo pre hosťa na prihlasovacej stránke.';
$string['stdchangepassword'] = 'Použiť štandardnú stránku pre zmenu hesla';
$string['stdchangepassword_expl'] = 'Ak Váš externý overovací systém povoľuje zmeny hesla v prostredí Moodle, prepnite túto voľbu na "Áno". Toto nastavenie potlačí funkciu "URL na zmenu hesla".';
$string['stdchangepassword_explldap'] = 'Poznámka: Ak používate vzdialený LDAP server, odporúčame Vám komunikovať cez šifrované SSL spojenie (ldaps://).';
$string['suspended'] = 'Pozastavený účet';
$string['suspended_help'] = 'Používatelia s pozastaveným účtom sa nemôžu prihlásiť alebo používať webové služby. Všetky odchádzajúce správy sú odstránené.';
$string['unlocked'] = 'Odomknutý/Odomknuté';
$string['unlockedifempty'] = 'Odomknuté, ak prázdne';
$string['update_never'] = 'Nikdy';
$string['update_oncreate'] = 'Pri vytváraní';
$string['update_onlogin'] = 'Pri každom prihlásení';
$string['update_onupdate'] = 'Pri aktualizácii';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() nepodporuje vybraný typ používateľa: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() (... ešte ...) nepodporuje vybraný typ používateľa.';
