<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Máte jedno alebo viac nových zadaní (kliknite sem pre zobrazenie).';
$string['addsubmission'] = 'Odovzdať zadanie';
$string['allowdeleting'] = 'Povoliť vymazanie';
$string['allowdeleting_help'] = 'Ak je táto voľba aktivovaná, môžu študenti (do času, kým je
ich zadanie ohodnotené) odstraňovať svoje odovzdané súbory.';
$string['allowmaxfiles'] = 'Maximálny počet nahrávaných súborov';
$string['allowmaxfiles_help'] = 'Maximálny počet súborov, ktoré môže každý účastník kurzu v rámci daného zadania odovzdať. Tento údaj sa študentom nikde nezobrazuje, je preto odporúčané, aby bol spomenutý v opise zadania.';
$string['allownotes'] = 'Povoliť poznámky';
$string['allownotes_help'] = 'Ak je táto voľba aktivovaná, môžu študenti zapísať do textového poľa
poznámky k zadaniu, podobne ako pri zadaní typu online text.';
$string['allowresubmit'] = 'Povoliť opätovné odovzdanie zadania';
$string['allowresubmit_help'] = 'Ak zapnete toto nastavenie, potom bude študentom umožnené opätovné predloženie zadania aj po ich ohodnotení (na vaše opätovné oznámkovanie).  ';
$string['alreadygraded'] = 'Vaše zadanie už bolo ohodnotené a opakované odovzdanie nie je povolené.';
$string['assignment:addinstance'] = 'Pridať nové zadanie';
$string['assignmentdetails'] = 'Podrobnosti zadania';
$string['assignment:exportownsubmission'] = 'Exportovať vlastné odovzdané zadanie';
$string['assignment:exportsubmission'] = 'Exportovať odovzdané zadanie';
$string['assignment:grade'] = 'Ohodnotiť zadanie';
$string['assignmentmail'] = '{$a->teacher} poslal komentár na Vami vypracované zadanie \'{$a->assignment}\'

Nájdete ho pripojený k Vášmu vypracovanému zadaniu:

{$a->url}';
$string['assignmentmailhtml'] = '{$a->teacher} poslal komentár na Vami vypracované zadanie \'<i>{$a->assignment}</i>\'<br /><br />

Nájdete ho pripojený k Vášmu <a href="{$a->url}">vypracovanému zadaniu</a>.';
$string['assignmentmailsmall'] = '{$a->teacher} komentoval vaše riešenie zadania "{$a->assignment}". Viac podrobností sa nachádza na stránke s vašim riešením.';
$string['assignmentname'] = 'Názov zadania';
$string['assignmentsubmission'] = 'Odovzdané zadania';
$string['assignment:submit'] = 'Odoslať zadanie';
$string['assignmenttype'] = 'Typ zadania';
$string['assignment:view'] = 'Prezrieť zadanie';
$string['availabledate'] = 'Dostupné od';
$string['cannotdeletefiles'] = 'Vyskytla sa chyba a súbory nemohli byť vymazané.';
$string['cannotviewassignment'] = 'Nemôžete prezerať toto zadanie';
$string['comment'] = 'Komentár';
$string['commentinline'] = 'Vložený komentár';
$string['commentinline_help'] = 'Ak zaškrtnete toto políčko, bude odovzdaný text počas hodnotenia
skopírovaný do poľa pre komentár hodnotenia – zjednoduší sa tak zápis poznámok do textu (napr. s použitím inej farby písma) alebo priama úprava pôvodného textu.';
$string['configitemstocount'] = 'Jednotky, v ktorých bude udávaný rozsah odovzdaných prác u zadaní typu \'online text\'.';
$string['configmaxbytes'] = 'Maximálna veľkosť zadania pre všetky vypracované zadania na stránke (s ohľadom na obmedzenia kurzu a ostatné miestne nastavenia)';
$string['configshowrecentsubmissions'] = 'Zobrazovať každému informáciu o odovzdaných zadaniach v bloku prehľadu nedávnej činnosti.';
$string['confirmdeletefile'] = 'Naozaj si želáte vymazať tento súbor?<br /><strong>{$a}</strong>';
$string['coursemisconf'] = 'Kurz nie je správne nastavený';
$string['currentgrade'] = 'Súčasné hodnotenie vo výkaze známok';
$string['deleteallsubmissions'] = 'Odstrániť všetky odovzdané riešenia zadaní';
$string['deletefilefailed'] = 'Vymazávanie súboru zlyhalo';
$string['description'] = 'Opis';
$string['downloadall'] = 'Stiahnuť všetky odovzdané zadania ako zip.';
$string['draft'] = 'Pracovná verzia';
$string['due'] = 'Uzávierka zadania';
$string['duedate'] = 'Dátum, do ktorého treba zaslať vypracované zadanie';
$string['duedateno'] = 'Bez uzávierky zasielania vypracovaných zadaní';
$string['early'] = '{$a} včas';
$string['editmysubmission'] = 'Upraviť moje vypracované zadanie';
$string['editthesefiles'] = 'Upraviť tieto súbory';
$string['editthisfile'] = 'Aktualizovať tento súbor';
$string['emailstudents'] = 'Email študentom';
$string['emailteachermail'] = '{$a->username} aktualizoval vypracované zadanie pre \'{$a->assignment}\' dňa {$a->timeupdated}

Je dostupné tu:

{$a->url}';
$string['emailteachermailhtml'] = '{$a->username} aktualizoval vypracované zadanie pre <i>\'{$a->assignment}\' dňa {$a->timeupdated}</i><br /><br /> Je <a href="{$a->url}">dostupné na web portáli</a>.';
$string['emailteachers'] = 'Posielať učiteľom oznámenia o zaslaní vypracovaného zadania študentmi na emailovú adresu';
$string['emailteachers_help'] = 'Ak zaškrtnete toto políčko, budú sa učiteľom odosielať krátke
e-mailové upozornenia vždy, keď študenti odovzdajú nové zadanie alebo
keď už odovzdané zadanie aktualizujú.

Upozornenia sa budú odosielať iba tým učiteľom, ktorí môžu dané zadanie hodnotiť.  Ak sú napríklad v kurze vytvorené oddelené skupiny,
nebudú sa učiteľom, ktorí majú pridelenú jednu konkrétnu skupinu,
odosielať upozornenia o študentoch z iných skupín.';
$string['emptysubmission'] = 'Ešte ste nič neposlali';
$string['enablenotification'] = 'Zasielať oznamovanie mailom';
$string['enablenotification_help'] = 'Ak toto zapnete, študenti budú dostávať mail o svojich hodnoteniach a poznámkach k nim.';
$string['errornosubmissions'] = 'Nie sú žiadne odovzdané zadania na stiahnutie';
$string['existingfiledeleted'] = 'Existujúci súbor bol vymazaný: {$a}';
$string['failedupdatefeedback'] = 'Nepodarilo sa aktualizovať komentár na vypracované zadanie pre používateľa {$a}';
$string['feedback'] = 'Komentár';
$string['feedbackfromteacher'] = 'Komentár od {$a}';
$string['feedbackupdated'] = 'Komentár na vypracované zadania bol aktualizovaný pre {$a} ľudí';
$string['finalize'] = 'Žiadne ďalšie odovzdané zadania';
$string['finalizeerror'] = 'Vyskytla sa chyba a zadanie nemôže byť odovzdané.';
$string['graded'] = 'Hodnotené';
$string['guestnosubmit'] = 'Ľutujem, ale hostia nemôžu odovzdávať zadania. Prosím, prihláste/zaregistrujte sa a potom odovzdajte svoje zadanie.';
$string['guestnoupload'] = 'Ľutujem, ale hostia nemôžu nahrávať súbory';
$string['helpoffline'] = '<p>Túto voľbu je vhodné použiť, ak vypracovávate zadanie mimo prostredia Moodle. Môže to byť kdekoľvek na webe alebo systémom tvárou-v-tvár.</p><p>Študenti si môžu prezrieť opis zadania, ale nemôžu preniesť žiadne súbory ani čokoľvek iné. Systém známkovania funguje normálne a študenti budú oboznámení so svojimi známkami.</p>';
$string['helponline'] = '<p>Tento typ zadania vyžaduje od študentov, aby si upravili text využitím štandardných nástrojov na to určených. Učitelia ich môžu známkovať hneď (online) a môžu k tomu dokonca pridávať rôzne komentáre, alebo zmeny.</p>
 <p>(Ak máte skúsenosti so staršími verziami Moodle, tento typ zadania má rovnaké možnosti a funkcie ako mal modul Písomná práca.)</p>';
$string['helpupload'] = '<p>Tento typ zadania dovoľuje každému účastníkovi nahrať jeden alebo viacero súborov ľubovoľného typu.
Môžu to byť textové dokumenty, obrázky, spakované web stránky, alebo hocičo, čo ich požiadate vložiť.</p>
   <p>Tiež to dovolí učiteľovi vložiť jeden alebo viacero súborov ako odpoveď. Tieto súbory môžu byť tiež nahrané dopredu a môžu byť použité na to, aby každý študent malo rozdielnu verziu súboru, s ktorým bude pracovať. </p>
<p>Účastníci môžu tiež vkladať poznámky opisujúce vložené súbory, postup na riešení zadania, alebo ľubovoľnú inú informáciu.</p>
<p>Tento typ zadania musí byť manuálne ukončený študentom. Učiteľ môže kedykoľvek sledovať aktuálny status, nedokončené zadania sú označené ako Pracovná verzia. Učiteľ môže vrátiť každé odovzdané zadanie do stavu pracovnej verzie.</p>';
$string['helpuploadsingle'] = '<p>Tento typ zadania povoľuje každému účastníkovi preniesť si jeden súbor akéhokoľvek typu.</p> <p>Toto môže byť dokument textového editoru Word, obrázok, zozipovaná web stránka alebo čokoľvek iné, čo nariadite študentom, aby Vám odoslali.</p>';
$string['hideintro'] = 'Skryť opis zadania pred začiatočným dátumom';
$string['hideintro_help'] = 'Ak je táto voľba aktivovaná, nezobrazuje sa pred dátumom sprístupnenia zadania jeho opis ale iba názov.';
$string['invalidassignment'] = 'Nesprávne zadanie';
$string['invalidfileandsubmissionid'] = 'Chýba súbor alebo identifikátor odovzdaného zadania';
$string['invalidid'] = 'ID zadania bol nesprávny';
$string['invalidsubmissionid'] = 'Neplatný identifikátor odovzdaného zadania';
$string['invalidtype'] = 'Nesprávny typ zadania';
$string['invaliduserid'] = 'Neplatné ID používateľa';
$string['itemstocount'] = 'Počet';
$string['lastgrade'] = 'Posledná známka';
$string['late'] = '{$a} neskoro';
$string['maximumgrade'] = 'Maximálna známka';
$string['maximumsize'] = 'Maximálna veľkosť';
$string['maxpublishstate'] = 'Maximálna viditeľnosť pre položku blogu pred dňom platnosti';
$string['messageprovider:assignment_updates'] = 'Upozornenia o zadaniach (2.2)';
$string['modulename'] = 'Zadanie (2.2)';
$string['modulename_help'] = 'Zadania umožňujú učiteľovi zadávať úlohy alebo online alebo offline, ktoré budú potom hodnotené.';
$string['modulenameplural'] = 'Zadania';
$string['newsubmissions'] = 'Odovzdané zadania';
$string['noassignments'] = 'Ešte nie sú žiadne zadania';
$string['noattempts'] = 'Ešte nikto sa nepokúsil vypracovať toto zadanie';
$string['noblogs'] = 'Nie sú žiadne blogy, ktoré by bolo možné publikovať.';
$string['nofiles'] = 'Neboli vložené žiadne súbory';
$string['nofilesyet'] = 'Ešte neboli vložené žiadne súbory';
$string['nomoresubmissions'] = 'Ďalšie odovzdávania zadaní nie sú povolené.';
$string['norequiregrading'] = 'Nie sú žiadne zadania, ktoré by si vyžadovali hodnotenie';
$string['nosubmisson'] = 'Na hodnotenie neboli vložené žiadne zadania';
$string['notavailableyet'] = 'Ľutujeme, toto zadanie ešte nie je dostupné.<br />Bude zobrazené až po dátume danom nižšie.';
$string['notes'] = 'Poznámky';
$string['notesempty'] = 'Žiaden záznam';
$string['notesupdateerror'] = 'Chyba pri nahrávaní poznámok';
$string['notgradedyet'] = 'Ešte neoznámkované';
$string['notsubmittedyet'] = 'Ešte neodovzdané';
$string['onceassignmentsent'] = 'Ak bude zadanie poslané na hodnotenie, už sa nebude dať súbor vymazať alebo pripojiť nový. Chcete pokračovať?';
$string['operation'] = 'Operácia';
$string['optionalsettings'] = 'Voliteľné nastavenia';
$string['overwritewarning'] = 'Upozornenie: Opätovné odovzdanie zadania NAHRADÍ Vašu predchádzajúcu verziu (pôvodné zadanie bude odstránené)';
$string['page-mod-assignment-submissions'] = 'Stránka s riešením zadania';
$string['page-mod-assignment-view'] = 'Hlavná stránka modulu zadanie';
$string['page-mod-assignment-x'] = 'Ľubovoľná stránka modulu zadanie';
$string['pagesize'] = 'Počet hodnotení na strane';
$string['pluginadministration'] = 'Administrácia zadaní';
$string['pluginname'] = 'Zadanie (2.2)';
$string['popupinnewwindow'] = 'Otvoriť vo vyskakovacom okne';
$string['preventlate'] = 'Predchádzať neskorým odovzdávaniam zadaní';
$string['quickgrade'] = 'Dovoliť rýchle hodnotenie';
$string['quickgrade_help'] = 'Funkcia rýchleho hodnotenia umožňuje rýchlo ohodnotiť viac odovzdaných zadaní na
jednej stránke. Stačí iba zmeniť známky a komentáre a klepnutím na tlačidlo Uložiť v dolnej časti stránky uložiť naraz všetky zmeny na danej stránke.';
$string['requiregrading'] = 'Vyžadovať hodnotenie';
$string['responsefiles'] = 'Súbory odpovede';
$string['reviewed'] = 'Kontrolované';
$string['saveallfeedback'] = 'Uložiť všetky moje komentáre';
$string['selectblog'] = 'Vybrať, ktorý blog chcete odoslať.';
$string['sendformarking'] = 'Poslať na hodnotenie';
$string['showrecentsubmissions'] = 'Zobrazovať nedávno odovzdané zadania';
$string['submission'] = 'Odovzdané zadanie';
$string['submissiondraft'] = 'Pracovná verzia zadania';
$string['submissionfeedback'] = 'Komentár na odovzdanú úlohu';
$string['submissions'] = 'Odovzdané zadania';
$string['submissionsaved'] = 'Vaše zmeny boli uložené';
$string['submissionsnotgraded'] = '{$a} nehodnotených zadaní';
$string['submitassignment'] = 'Odovzdajte Vaše zadanie prostredníctvom tohto formulára';
$string['submitedformarking'] = 'Zadanie už bolo odovzdané na hodnotenie a nemôže byť zmenené';
$string['submitformarking'] = 'Poslať zadanie na hodnotenie';
$string['submitted'] = 'Zadanie bolo odovzdané';
$string['submittedfiles'] = 'Odoslané súbory';
$string['subplugintype_assignment'] = 'Typ zadania';
$string['subplugintype_assignment_plural'] = 'Typy zadaní';
$string['trackdrafts'] = 'Povoliť tlačidlo "Odoslať k hodnoteniu"';
$string['trackdrafts_help'] = 'Tlačidlo "Poslať na hodnotenie" umožní študentovi oznámiť učiteľovi, že ukončil prácu na zadaní. Hodnotitelia môžu zadanie alebo ohodnotiť, alebo mu opäť zmeniť stav na "Pracovnú verziu" (ak je napríklad potrebné zadanie doplniť či prepracovať).';
$string['typeblog'] = 'Príspevok blogu';
$string['typeoffline'] = 'Činnosť offline';
$string['typeonline'] = 'Online text';
$string['typeupload'] = 'Pokročilé prenášanie súborov';
$string['typeuploadsingle'] = 'Preniesť jeden súbor';
$string['unfinalize'] = 'Zmeniť na pracovnú verziu';
$string['unfinalizeerror'] = 'Vyskytla sa chyba a odovzdané zadanie nemôže byť vrátené do stavu Zaslané';
$string['unfinalize_help'] = 'Návrat k návrhu študentovi umožňuje vykonať ďalšie aktualizácie ich priradenie';
$string['upgradenotification'] = 'Táto aktivita je starším typom zadania';
$string['uploadafile'] = 'Nahrať súbor';
$string['uploadbadname'] = 'Tento názov súboru obsahoval zvláštne znaky a nemohol byť prenesený';
$string['uploadedfiles'] = 'prenesené súbory';
$string['uploaderror'] = 'Počas ukladania súboru na server sa vyskytla chyba';
$string['uploadfailnoupdate'] = 'Súbor bol prenesený v poriadku, ale systém nedokázal aktualizovať Vaše odovzdané zadanie!';
$string['uploadfiles'] = 'Nahrať súbory';
$string['uploadfiletoobig'] = 'Prepáčte, ale tento súbor je priveľký (limit je {$a} bytov)';
$string['uploadnofilefound'] = 'Súbor nebol nájdený. Určite ste vybrali súbor na prenesenie?';
$string['uploadnotregistered'] = '\'{$a}\' bol prenesený v poriadku, ale hodnotenie sa nepodarilo zaregistrovať!';
$string['uploadsuccess'] = '\'{$a}\' bol prenesený úspešne';
$string['usermisconf'] = 'Používateľ je nesprávne nakonfigurovaný';
$string['usernosubmit'] = 'Ospravedlňujeme sa, nie ste oprávnení podať úlohu.';
$string['viewassignmentupgradetool'] = 'Zobraziť nástroje aktualizácie zadania';
$string['viewfeedback'] = 'Zobraziť hodnotenie odovzdaného zadania a komentáre k nemu';
$string['viewmysubmission'] = 'Prezrieť moje odovzdané zadanie';
$string['viewsubmissions'] = 'Zobraziť {$a} odovzdaných zadaní';
$string['yoursubmission'] = 'Vaše zadanie';
