<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sk', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Prístup zamietnutý';
$string['accounts'] = 'Účty';
$string['additionalhtml'] = 'Prídavné HTML';
$string['additionalhtmlfooter'] = 'Predtým, ako je ukončené BODY';
$string['additionalhtmlfooter_desc'] = 'Tento obsah bude pridaný ku každej stránke predtým, ako bude uzavrený tag BODY.';
$string['additionalhtmlhead'] = 'Vrámci HEAD';
$string['additionalhtmlhead_desc'] = 'Tento obsah bude pridaný ku každej stránke predtým, ako bude uzavrený tag HEAD.';
$string['additionalhtml_heading'] = 'Prídavný HTML kód pridaný ku každej stránke.';
$string['additionalhtmltopofbody'] = 'Keď je otvorený tag BODY';
$string['additionalhtmltopofbody_desc'] = 'Tento obsah bude pridaný ku každej stránke hneď potom, ako bol otvorený tag body.';
$string['admincategory'] = 'Kategória: {$a}';
$string['adminseesall'] = 'Správcovia vidia všetko';
$string['adminseesallevents'] = 'Administrátori môžu prezerať všetky udalosti';
$string['adminseesownevents'] = 'Administrátori sú ako obyčajní používatelia';
$string['advancedfeatures'] = 'Pokročilé nastavenia';
$string['allcountrycodes'] = 'Kódy všetkých krajín';
$string['allowbeforeblock'] = 'Povolený zoznam bude spracovaný ako prvý';
$string['allowblockstodock'] = 'Povoliť blokom využívať dok.';
$string['allowcategorythemes'] = 'Povoliť zmenu tém v kategóriách';
$string['allowcoursethemes'] = 'Povoliť zmenu tém v kurzoch';
$string['allowediplist'] = 'Zoznam povolených IP adries';
$string['allowemailaddresses'] = 'Povolené emailové domény';
$string['allowframembedding'] = 'Povoliť vkladanie do rámca';
$string['allowguestmymoodle'] = 'Povoliť hosťom prístup na Môj Moodle';
$string['allowobjectembed'] = 'Povoliť tagy EMBED a OBJECT';
$string['allowthemechangeonurl'] = 'Povoliť zmenu témy v URL';
$string['allowuserblockhiding'] = 'Povoliť používateľom skrývať bloky';
$string['allowuserswitchrolestheycantassign'] = 'Povoliť používateľom bez schopnosti priradiť roly prepínať medzi rolami';
$string['allowuserthemes'] = 'Povoliť používateľom zmenu témy';
$string['antivirus'] = 'Antivírus';
$string['appearance'] = 'Vzhľad';
$string['aspellpath'] = 'Cesta k programu aspell';
$string['authentication'] = 'Overovanie používateľov';
$string['authpreventaccountcreation'] = 'Zabrániť vytváraniu nových účtov pri overovaní používateľov';
$string['authsettings'] = 'Spravovať autentifikáciu';
$string['autolang'] = 'Automatická detekcia jazyka';
$string['autologinguests'] = 'Automaticky prihlasovať hostí';
$string['availablelicenses'] = 'Dostupné licencie';
$string['availableto'] = 'Dostupné';
$string['backgroundcolour'] = 'Priehľadná farba';
$string['backups'] = 'Zálohy';
$string['backup_shortname'] = 'Používať názov kurzu v názve súbory zálohy';
$string['backup_shortnamehelp'] = 'Použiť názov kurzu v názve súbory zálohy';
$string['badwordsconfig'] = 'Zadajte zoznam zakázaných slov, jednotlivé slová oddeľujte čiarkou.';
$string['badwordsdefault'] = 'Ak je zoznam prázdny, použije sa východzí zoznam uvedený v jazykovom balíčku.';
$string['badwordslist'] = 'Zoznam zakázaných slov';
$string['blockediplist'] = 'Zoznam blokovaných IP adries';
$string['blockinstances'] = 'Výskyty';
$string['blockmultiple'] = 'Viacnásobný';
$string['blockprotect'] = 'Chrániť pred vymazaním';
$string['blocksettings'] = 'Spravovať bloky';
$string['blockunprotect'] = 'Nechrániť';
$string['bloglevel'] = 'Viditeľnosť Blogu';
$string['bookmarkadded'] = 'Záložka pridaná';
$string['bookmarkalreadyexists'] = 'Tato stránka už obsahuje vašu záložku';
$string['bookmarkdeleted'] = 'Záložka odstránená';
$string['bookmarkthispage'] = 'pridať záložku';
$string['cacheapplication'] = 'Aplikačná cache';
$string['cachejs'] = 'Cache Javascript';
$string['cacherequest'] = 'Požiadavková cache';
$string['cachesession'] = 'Relačná cache';
$string['cachesettings'] = 'Nastavenie cache';
$string['cachetext'] = 'Doba existencie textovej vyrovnávacej pamäte';
$string['caching'] = 'Vyrovnávacie pamäte';
$string['calendarexportsalt'] = 'Salt (náhodný reťazec) pre export kalendára';
$string['calendarsettings'] = 'Kalendár';
$string['calendar_weekend'] = 'Dni víkendu';
$string['cannotdeletemodfilter'] = '	
Nemôžete odinštalovať filter \'{$a->filter}\', pretože je časťou modulu \'{$a->module}\'.';
$string['cannotuninstall'] = 'Nie je možné odinštalovať {$a}.';
$string['cfgwwwrootslashwarning'] = 'V súbore config.php ste nesprávne definovali $CFG->wwwroot. Na jeho konci je znak \'/\'. Ak ho nevymažete, môže dôjsť k neobvyklým chybám, ako napr <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'V súbore config.php ste nesprávne definovali $CFG->wwwroot. Nesúhlasí s URL, ktorú používate na prístup k tejto stránke. Ak ho neupravíte, môže dôjsť k neobvyklým chybám, ako napr <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'zmeniť';
$string['checkboxno'] = 'Nie';
$string['checkboxyes'] = 'Áno';
$string['choosefiletoedit'] = 'Vyberte súbor k úprave';
$string['clamfailureonupload'] = 'Pri chybe antivíru clam';
$string['cleanup'] = 'Vyčistenie';
$string['clianswerno'] = 'N';
$string['cliansweryes'] = 'A';
$string['cliincorrectvalueerror'] = 'Chyba, nesprávna hodnota "{$a->value}" for "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nesprávna hodnota, prosím skúste znova';
$string['clistatusdisabled'] = 'Stav: Nepovolený';
$string['clistatusenabled'] = 'Stav: Povolený';
$string['clitypevalue'] = 'Vložte hodnotu';
$string['clitypevaluedefault'] = 'Vložte hodnotu a stlačte klávesu Enter pre použitie nastavenej hodnoty ({$a})';
$string['cliunknowoption'] = 'Nerozoznané voľby: {$a}
Prosím, použite možnosť --help.';
$string['cliupgradefinished'] = 'Aktualizácia z príkazového riadku bola ukončená úspešne.';
$string['cliupgradenoneed'] = 'Pre túto verziu {$a} nie je potrebná aktualizácia. Aj tak fajn, že ste sem klikli!';
$string['cliyesnoprompt'] = 'Zvolte A (Áno) alebo N (Nie)';
$string['commentsperpage'] = 'Počet komentárov na stranu';
$string['commonfiltersettings'] = 'Spoločné nastavenia filtrov';
$string['commonsettings'] = 'Spoločné nastavenia';
$string['componentinstalled'] = 'Nainštalovaný komponent';
$string['computedfromlogs'] = 'Vypočítané logy od {$a}.';
$string['confeditorhidebuttons'] = 'Vyberte tlačidlá, ktoré majú byť v HTML editore skryté.';
$string['configallowassign'] = 'Povoliť rolám na ľavej strane priradiť roly v jednotlivých stĺpcoch.';
$string['configallowblockstodock'] = 'Ak je toto povolené a vybraná téma to podporuje, používatelia si môžu vybrať presúvať bloky do špeciálneho doku.';
$string['configallowcategorythemes'] = 'Ak povolíte toto nastavenie, témy môžu byť nastavené na úrovni kategórie kurzov. Ovplyvní to všetky podradené kategórie a kurzy, ak tieto nemajú nastavenú vlastnú tému. UPOZORNENIE: Povolenie nastavenia môže znížiť výkonnosť na serveri.';
$string['configallowcoursethemes'] = 'Keď zapnete túto voľbu, bude možné nastaviť pre kurz vlastnú tému. Téma kurzu má najvyššiu prioritu, zobrazí sa aj v prípade, keď bude nastavenie témy hlavnej stránky, používateľa či aktuálneho sedenia odlišné.';
$string['configallowemailaddresses'] = 'Ak chcete obmedziť všetky nové emailové adresy na určité domény, uveďte ich tu, oddelené medzerami. Všetky ostatné domény budú odmietnuté. Na pridanie poddomén pridajte doménu začínajúcu bodkou, napr. <strong>vasaskola.sk .stuba.sk</strong>';
$string['configallowobjectembed'] = 'Ako štandardne nastavené bezpečnostné opatrenie, normálni používatelia nemôžu do textov vkladať multimediálne prvky (napr. Flash) prostredníctvom EMBED a OBJECT tagov v ich HTML (hoci sa to dá bezpečne urobiť použitím filtra multimediálnych pluginov). Ak si želáte, aby boli tieto tagy povolené pre používateľov, potom zapnite túto voľbu.';
$string['configallowoverride'] = 'Povoliť rolám na ľavej strane prepísať roly v jednotlivých stĺpcoch.';
$string['configallowoverride2'] = 'Zvoľte rolu(y), ktoré môžu byť prepísané rolou v ľavom stĺpci. <br />Poznámka: tieto nastavenia sa týkajú iba používateľov, ktorí majú nastavené buď oprávnenie moodle/role:override alebo moodle/role:safeoverride.';
$string['configallowthemechangeonurl'] = 'Ak je povolené, téma môže byť zmenená pridaním theme={nazovtemy} k ľubovoľnému Moodle URL.';
$string['configallowuserblockhiding'] = 'Chcete povoliť používateľom skrytie/zobrazenie postranných blokov na všetkých týchto stránkach? Táto vlastnosť používa Javascript a Cookies pre uloženie aktuálneho stavu pre každý blok a ovplyvní iba používateľov pohľad.';
$string['configallowuserswitchrolestheycantassign'] = 'Vo východzom nastavení je schopnosť moodle/role:assign potrebná na to, aby sa mohli používatelia prepnúť medzi rolami. Ak je toto nastavenie aktívne, tlačidlo "Prepnúť rolu na..." zobrazuje všetky roly určené nastavením tabuľky "Povoliť priradenia rol" v administrátorskom menu.
Je potom doporučené, aby táto tabuľka neobsahovala možnosť prepnúť sa do roly, ktorá je nadradená súčasnej.';
$string['configallowuserthemes'] = 'Keď zapnete túto voľbu, používateľ si bude môcť nastaviť vlastné témy. Témy používateľa majú vyššiu prioritu, zobrazia sa aj v prípade, keď bude nastavenie témy hlavnej stránky iné (toto neplatí pre témy kurzu).';
$string['configallusersaresitestudents'] = 'Mali by byť všetci používatelia považovaní za študentov vzhľadom k aktivitám, ktoré sú im dostupné  na hlavnej stránke systému? Ak je Vaša odpoveď \'Áno\', potom každý autorizovaný používateľ sa môže týchto aktivít zúčastniť ako študent. Ak je Vaša odpoveď \'Nie\', potom len tí používatelia, ktorí sú už účastníkmi aspoň jedného kurzu, sa môžu zúčastniť týchto aktivít. Ako učitelia týchto aktivít môžu vystupovať len administrátori a špeciálne na to vymenovaní učitelia.';
$string['configauthenticationplugins'] = 'Zvoľte spôsoby overovania používateľov a poradia, v akom budú použité. Ak sa používatelia registrujú sami, bude použitý spôsob uvedený v poli "Registrácia používateľov" nižšie (väčšinou sa používa overenie na základe emailu).';
$string['configautolang'] = 'Detekcia východzieho jazyka z nastavenia web prehliadača. Ak nie je povolené, použije sa východzie nastavenie na portáli.';
$string['configautologinguests'] = 'Mali by byť návštevníci automaticky prihlasovaní ako hostia, ak vstúpia do kurzov s hosťovským prístupom?';
$string['configbloglevel'] = 'Touto voľbou nastavujete úroveň prístupu k blogom na vašich stránkach. Nastavenie sa týka ČITATEĽOV, nie autorov či typov blogov. Ak blogy nechcete používať, môžete ich vypnúť úplne.';
$string['configcachetext'] = 'Toto nastavenie môže zrýchliť prevádzku systému predovšetkým pre tie stránky, ktoré sú obsahovo rozsiahlejšie alebo používajú textové filtre. Kópie textov sa tu budú uchovávať v pôvodnej forme počas vopred stanoveného časového rozpätia. Ak sa tu nastavia nízke hodnoty parametrov, môže to spomaliť všetky činnosti, ale ak sa tu nastavia pomerne vysoké hodnoty parametrov, bude obnova textov (napr. pri pridaní nových odkazov) trvať veľmi dlho.';
$string['configcalendarexportsalt'] = 'Tento náhodný text sa používa na zvýšenie bezpečnosti autentifikácie pri exporte kalendárov. Upozorňujeme, že všetky súčasné exporty budú neplatné, ak text zmeníte.';
$string['configclamactlikevirus'] = 'Považovať súbory za napadnuté vírusom';
$string['configclamdonothing'] = 'Považovať súbory za normálne';
$string['configclamfailureonupload'] = 'Ak ste nastavili clam, aby skenoval prenášané súbory, ale nie je správne nastavený alebo z neznámych dôvodov nereaguje tak, ako má, ako sa má systém správať? Ak si vyberiete \'Považovať súbory za napadnuté vírusom\', budú súbory presunuté do karanténnej oblasti alebo vymazané. Ak si vyberiete \'Považovať súbory za normálne\', budú súbory presunuté na to miesto, ktoré si Vy určíte bez problémov. Samozrejme, administrátori budú upozornení, ak clam nebude fungovať. Ak si vyberiete \'Považovať súbory za napadnuté vírusom\' a z neznámych dôvodov clam nebude reagovať správne (väčšinou je nesprávne nastavená cesta ku clam), všetky prenášané súbory budú presunuté do zadanej karanténnej oblasti alebo vymazané. Buďte opatrní pri tomto nastavení.';
$string['configconvertformat'] = 'Ak sú dostupné programy <i>latex</i>, <i>dvips</i> a <i>convert</i> potom sa obrázky vytvoria pre špecifikovaný formát. Ak nie, bude použitý mimeTeX a vytvorí obrázky GIF.';
$string['configcookiehttponly'] = 'Povoľuje novú vlastnosť PHP 5.2.0 - web prehliadače dostanú pokyn posielať cookie so skutočnými http požiadavkami, cookie ale nebudú dostupné skriptovacím jazykom. Nie všetky prehliadače to ale podporujú a nemusí to byť úplne kompatibilné so súčasným kódom. Zabraňuje to niektorým XSS napadnutiam.';
$string['configcookiesecure'] = 'Ak server prijíma iba https spojenia, doporučuje sa povoliť posielanie bezpečných cookie. Ak povolíte, ubezpečte sa, že server neakceptuje http:// alebo zabezpečte trvalé presmerovanie na https:// adresu. Ak adresa <em>wwwroot</em> nezačína na https://, je toto nastavenie automaticky vypnuté.';
$string['configcountry'] = 'Ak si tu vyberiete krajinu, tak bude táto krajina nastavená aj pre nové používateľské kontá. Ak chcete, aby si používatelia sami vybrali krajinu, nenastavujte ju tu.';
$string['configcourserequestnotify'] = 'Zadajte login používateľa, ktorý bude upozornený pri žiadosti o nový kurz';
$string['configcourserequestnotify2'] = 'Používatelia, ktorí budú upozornení pri žiadosti o vytvorenie kurzu. V tomto zozname sa nachádzajú iba používatelia, ktorí môžu odsúhlasiť žiadosti o vytvorenie nového kurzu.';
$string['configcoursesperpage'] = 'Počet kurzov na stránke pri zobrazovaní zoznamu kurzov.';
$string['configcronclionly'] = 'Ak je toto nastavené, môže byť skript cron.php spustený iba z príkazového riadku a nie cez webové rozhranie. Týmto sa zároveň ignoruje nastavenie hesla k cronu uvedené nižšie.';
$string['configcronremotepassword'] = 'Ak použijete toto nastavenie, bude pre volanie skriptu cron.php cez webové rozhranie nutné použiť heslo predávané ako parameter podľa vzoru: <pre>http://moodle.nasaskola.sk/admin/cron.php?password=sezamotvorsa</pre> Ak necháte pole prázdne, bude možné volať skript cron.php aj bez hesla.';
$string['configcurlcache'] = 'Životnosť cURL vyrovnávacej pamäti v sekundách.';
$string['configdbsessions'] = 'Ak povolíte túto voľbu, toto nastavenie bude používať databázu na uchovanie informácií o aktuálnych sedeniach (sessions). Toto je výhodné použiť najmä pri obsahovo rozsiahlejších stránkach založených na zoskupení serverov. Pre väčšinu stránok by táto voľba mala zostať neaktívna, aby sa namiesto databázy používal disk servera. Prosím berte na vedomie, že ak teraz zmeníte toto nastavenie, všetci používatelia (vrátane Vás) budú zo systému odhlásení.';
$string['configdebug'] = 'Ak zapnete túto voľbu, PHP zvýši oznamovanie chýb tak, že bude uvádzaných viac varovaní. Toto je užitočné len pre vývojových pracovníkov.';
$string['configdebugdisplay'] = 'Ak je zapnuté, zobrazujú sa chybové hlásenia ako súčasť HTML stránky. To je síce praktické, ale všeobecne môžu chybové hlásenia nabúravať XHTML, JavaScript, cookies a HTTP hlavičky. Pri vypnutí budú chybové hlásenia ukladané v protokole webového serveru. Nastavenie PHP premennej error_log v súbore php.ini ovplyvňuje, aké informácie sú protokolované.';
$string['configdebugpageinfo'] = 'Povoľte, ak chcete, aby informácia o stránke bola zobrazená v jej päte.';
$string['configdebugsmtp'] = 'Povoliť podrobnejšiu diagnostiku v priebehu odosielania správ na SMTP server.';
$string['configdefaulthomepage'] = 'Toto nastavuje domovskú stránku pre prihlásených používateľov';
$string['configdefaultrequestcategory'] = 'Požadované kurzy budú automaticky umiestené v tejto kategórii.';
$string['configdefaultrequestedcategory'] = 'Do akej kategórie zaradiť požadované kurzy, ak sú schválené?';
$string['configdefaultuserroleid'] = 'Prihlásení používatelia získajú na úrovni celého serveru všetky oprávnenia vyplývajúce z uvedenej roly. Tieto oprávnenia budú PRIDANÉ k ostatným oprávneniam získaných z ďalších rol. Pomocou tohto nastavenia zabezpečujete minimálne oprávnenia pre každého prihláseného používateľa, aby mohol robiť niečo zmysluplné (napr. čítať verejné diskusie, zobrazovať študijné materiály a pod.). Východzie nastavenie je rola Hosťa.';
$string['configdeleteincompleteusers'] = 'Kontá používateľov, ktorých vytvorenie nebolo korektne ukončené, budú po tomto časovom úseku vymazané.';
$string['configdeleteunconfirmed'] = 'Ak používate emailovú autorizáciu, toto je časové rozpätie, počas ktorého bude odpoveď akceptovaná používateľmi. Po tomto období budú staré nepoužívané kontá vymazané.';
$string['configdenyemailaddresses'] = 'Ak chcete zakázať emailové adresy z určitých domén, uveďte ich tu, oddelené medzerami. Všetky ostatné domény budú akceptované. Na pridanie poddomén pridajte doménu začínajúcu bodkou, napr. <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Deaktivovať schopnosť používateľov zmeniť obrázky v profilových stránkach.';
$string['configdisplayloginfailures'] = 'Toto zobrazí vybraným používateľom informácie o predchádzajúcich neúspešných pokusoch o prihlásenie.';
$string['configdocroot'] = 'Cesta k dokumentácii Moodle. Upravte toto nastavenie, ak si prajete mať vlastnú online dokumentáciu. Uistite sa, že vaša dokumentácia zachováva rovnaký formát ako http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Pri povolení tohto nastavenia bude Moodle otvárať stránky dokumentácie (Moodle Docs) v novom okne.';
$string['configeditordictionary'] = 'Táto hodnota je použitá, ak nemá aspell k dispozícii slovník pre jazyk používateľa.';
$string['configeditorfontlist'] = 'Zoznam fontov, ktoré budú zobrazované v ponuke HTML editoru.';
$string['configemailchangeconfirmation'] = 'Vyžadovať následné emailové potvrdenie, ak si používatelia zmenia svoju mailovú adresu.';
$string['configenableajax'] = 'Týmto povoľujete technológiu AJAX na úrovni celého serveru. je potrebná pre niektoré funkcie ako napríklad pre nahrávanie obsahu pomocou ťahania myšou (drag and drop)';
$string['configenableblogs'] = 'Či majú mať používatelia k dispozícii svoj vlastný blog';
$string['configenablecalendarexport'] = 'Umožniť exportovanie alebo odoberanie kalendárov.';
$string['configenablecomments'] = 'Povoliť komentáre';
$string['configenablecourserequests'] = 'Povoliť užívateľom žiadať o založenie kurzu?';
$string['configenablerssfeeds'] = 'Tento prepínač umožní RSS kanály z iných stránok. Aby ste videli všetky aktuálne zmeny, musíte aktivovať RSS kanály aj v jednotlivých moduloch - choďte do Nastavení Moodle v Konfigurácii administrátora.';
$string['configenablerssfeedsdisabled'] = 'Voľba nie je dostupná, pretože RSS kanály sú deaktivované na celej Stránke. Ak ich chcete aktivovať, choďte do Nastavení premenných v Konfigurácii administrátora.';
$string['configenablerssfeedsdisabled2'] = 'RSS feedy sú deaktivované na serverovej úrovni. Musíte ich najprv povoliť v časti Server/RSS.';
$string['configenablesafebrowserintegration'] = 'Pridanie voľby \'Vyžadovať Safe Exam Browser\' do poľa zoznamu \'Bezpečnosť prehliadača\' vo formulári nastavenia testov. Pre viac informácií viď http://www.safeexambrowser.org/.';
$string['configenablestats'] = 'Pri voľbe \'Áno\' spracuje cron protokoly o činnosti užívateľov a vytvorí z nich grafy a štatistiky pre jednotlivé kurzy i celý server. Toto spracovanie môže istý čas trvať, v závislosti na návštevnosti vášho servera.';
$string['configenabletrusttext'] = 'Moodle štandardne filtruje akýkoľvek text zadaný používateľmi a snaží sa odstrániť potenciálne bezpečnostné riziká, medzi ktoré patria aj skripty, média, a pod. Pomocou funkcie "Dôveryhodný obsah" môžete vybraným používateľom poskytnúť privilégium používať aj tieto pokročilé prvky bez ďalších zásahov. Najprv je treba povoliť toto nastavenie a potom prideliť oprávnenie Dôveryhodný obsah (Trusted Content) vybraným roliam. Text, ktorý bol vytvorený alebo nahraný používateľom s takouto rolou, je potom označený ako dôveryhodný a nie je pred zobrazením filtrovaný.';
$string['configerrorlevel'] = 'Vyberte si množstvo PHP varovaní, ktoré chcete mať zobrazované. Normal je zvyčajne najlepšia možnosť.';
$string['configextendedusernamechars'] = 'Ak povolíte toto nastavenie, študenti môžu vo svojich používateľských menách používať akékoľvek znaky (to však neovplyvní ich skutočné mená). Štandardné nastavenie je vypnuté a obmedzuje používané znaky v menách len na číslice, malé písmená, podtrhovník (_), rozdeľovník (-), bodka a zavináč.';
$string['configextramemorylimit'] = 'Niektoré skripty ako vyhľadávanie, zálohovanie a obnova zo zálohy, alebo cron, vyžadujú viac pamäte. Nastavte vyššie hodnoty pre veľké portály.';
$string['configfilterall'] = 'Filtrovať všetky reťazce, vrátane hlavičiek, titulov, navigačnej lišty a podobne. Toto je najviac užitočné pri používaní viacjazyčného filtra, inak spôsobuje iba mierne zvýšenú záťaž pri generovaní stránok.';
$string['configfiltermatchoneperpage'] = 'Filtre, ktoré automaticky prepájajú obsah kurzov, vytvoria odkaz iba u prvej nájdenej zhody na celej stránke. Ostatné výskyty sú ignorované.';
$string['configfiltermatchonepertext'] = 'Filtre, ktoré automaticky prepájajú obsah kurzov, vytvoria odkaz iba u prvej nájdenej zhody v každom úseku textu (napr. študijný materiál, blok apod.). Ostatné výskyty sú ignorované. Toto nastavenie sa neuplatní, ak je premenná \'Jedna zhoda na stránku\' nastavená na \'Áno\'.';
$string['configfilteruploadedfiles'] = 'Aktivovaním tejto voľby bude Moodle spracovávať všetky načítané HTML a textové súbory s filtrami predtým, ako sa zobrazia.';
$string['configforcelogin'] = 'Normálne môže byť hlavná stránka s uvedeným zoznamom kurzov (nie s konkrétnymi kurzmi) prezeraná používateľmi bez toho, aby sa predtým prihlásili. Ak chcete, aby sa používatelia prihlásili predtým, ako čokoľvek urobia na stránke, potom by ste mali aktivovať toto nastavenie.';
$string['configforceloginforprofiles'] = 'Aktivovaním tohto nastavenia sa každý reálny používateľ (nie hosť) bude musieť najskôr prihlásiť, ak si chce prezerať profily používateľov. Ak deaktivujete túto voľbu, niektorí používatelia (spameri) budú zneužívať profil na umiestňovanie nevhodného obsahu v svojich profiloch, ktoré sú viditeľné z celého sveta.';
$string['configfrontpage'] = 'Položky vybrané vyššie budú zobrazené na titulnej stránke serveru.';
$string['configfrontpagecourselimit'] = 'Maximálny počet kurzov';
$string['configfrontpageloggedin'] = 'Prihláseným používateľom budú na titulnej stránke serveru zobrazené položky vybrané vyššie.';
$string['configfullnamedisplay'] = 'Toto definuje, ako sa zobrazujú mená, ak sú uvedené v plnom rozsahu. Pre väčšinu jednojazyčných stránok je najlepšie nastavenie toto: \'Meno a Priezvisko\', ale môžete napríklad aj skryť všetky priezviská alebo to nechať na samotný jazykový balík, nech sa rozhodne (niektoré jazyky majú špecifické zvyklosti).';
$string['configgeoipfile'] = 'Umiestnenie GeoIP City binárneho dátového súboru. Tento nie je časťou Moodle distribúcie a musí byť získaný oddelene z <a href="http://www.maxmind.com/">MaxMind</a>. Môžete si alebo kúpiť komerčnú verziu alebo použiť voľnú verziu. <br />Stiahnite súbor <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> a rozbaľte ho do adresára "{$a}" na vašom serveri.';
$string['configgetremoteaddrconf'] = 'Ak je Váš server za reverzným proxy, môžete použiť toto nastavenie pre určenie HTTP hlavičiek, ktoré môžu byť chápané ako obsahujúce dôveryhodné vzdialené IP adresy. Hlavičky sú čítané v danom poradí a použije sa prvá, ktorá je dostupná.';
$string['configgradebookroles'] = 'Ktorých používateľov zobrazovať v klasifikačnom výpise. Používatelia potrebujú aspoň jednu z týchto rol v danom kurze, aby boli zobrazení v jeho opise.';
$string['configgradeexport'] = 'Vyberte, ktoré exportné formáty v známkach sú vaše primárne metódy pre export. Vybrané zásuvné moduly nastavia a budú používať pole "naposledy exportované" pre každú známku. Napríklad toto môže spôsobiť, že exportované záznamy budú identifikované ako "nové" alebo "aktualizované". Ak si nie ste istí, nechajte prázdne.';
$string['confighiddenuserfields'] = 'Ktoré polia v profiloch používateľov majú byť skryté pred inými používateľmi, než sú vyučujúci a administrátori. Zvyšuje to súkromie študentov. Pre označenie viac položiek podržte klávesu CTRL.';
$string['configidnumber'] = 'Špecifické nastavenia či (a)Používatelia nebudú požiadaní o zadanie ID čísla vôbec, (b)Používatelia budú požiadaní o zadanie ID čísla, ale nemusia ho vyplniť, (c)Používatelia budú požiadaní o zadanie ID čísla a musia ho vyplniť. Ak bude zadané ID číslo používateľa, bude zobrazované v profile.';
$string['configintro'] = 'Na tejto stránke môžete špecifikovať rôzne konfiguračné premenné, ktoré pomôžu Moodle správne spolupracovať s Vašim serverom. Veľmi sa tým nezaťažujte - východiskové nastavenia zvyčajne pracujú správne a vždy sa môžete k tejto stránke vrátiť a tieto nastavenia zmeniť.';
$string['configintroadmin'] = 'Na tejto stránke by ste mali konfigurovať Vaše hlavné administrátorské konto. Administrátor má plnú kontrolu nad celou stránkou. Dbajte na to, aby mal bezpečné používateľské meno, heslo a tiež platnú emailovú adresu. Neskôr môžete vytvoriť viac administrátorských účtov.';
$string['configintrosite'] = 'Táto stránka Vám umožňuje konfigurovať hlavnú stránku a meno tejto stránky. Neskôr to môžete kedykoľvek zmeniť cez odkaz \'Nastavenia stránky\' na domovskej stránke.';
$string['configiplookup'] = 'Keď kliknete na IP adresu (napr. 34.12.222.93) napr. v logoch, zobrazí sa Vám mapa s odhadom, kde sa tá IP adresa nachádza. K tomu sú určené rozličné zásuvné moduly, z ktorých sa dá vybrať, pričom každý z nich má určité výhody a nedostatky.';
$string['configkeeptagnamecase'] = 'Vyberte, ak chcete, aby si názvy tagov zachovali veľkosť písmen tak, ako ich vložili používatelia, ktorí ich vytvorili.';
$string['configlang'] = 'Vyberte si východzí jazyk pre celý portál. Používatelia môžu neskôr toto nastavenie zmeniť cez jazykové menu alebo v nastavení svojho používateľského profilu.';
$string['configlanglist'] = 'Nechajte túto voľbu prázdnu, ak chcete, aby si používatelia mohli vybrať ľubovoľný jazyk z tejto verzie Moodle. Tento zoznam môžete skrátiť, ak uvediete zoznam jazykov, oddelených čiarkou, napr. sk,cz,en,es_es,fr,it.';
$string['configlangmenu'] = 'Vyberte si, či chcete zobraziť menu pre voľbu jazyka na www stránkach Moodle (domovská stránka, autorizačná stránka a podobne). To neovplyvní používateľove možnosti nastavenia preferovaného jazyka vo svojom vlastnom profile.';
$string['configlatinexcelexport'] = 'Zvoľte kódovanie pre exporty Excelu';
$string['configlocale'] = 'Vyberte si miestne jazykové nastavenie portálu - toto ovplyvní formát a jazyk údajov. Tieto miestne údaje musíte mať nainštalované vo Vašom operačnom systéme (napríklad en_US alebo es_ES). Ak neviete, čo si vybrať, nechajte toto prázdne.';
$string['configloginhttps'] = 'Aktivovanie tejto voľby bude znamenať, že Moodle bude používať bezpečné https spojenie len pri autorizačnej stránke (pri prihlasovaní do systému) uvedením bezpečného prihlasovacieho mena. Následne sa vráti k normálnemu http protokolu URL pre všeobecnú rýchlosť. UPOZORNENIE: Toto nastavenie VYŽADUJE, aby https protokol bol aktivovaný na web serveri - ak nie je, MOHLI BY STE ZAMKNÚŤ VAŠU STRÁNKU.';
$string['configloglifetime'] = 'Táto voľba špecifikuje dĺžku časového intervalu, počas ktorého si chcete uchovať záznamy o používateľských aktivitách. Záznamy, ktoré sú staršie, sa automaticky vymažú. Je dobré uchovávať si záznamy tak dlho, ako je to možné, ale ak máte veľmi zaneprázdnený server a máte problémy s jeho rýchlosťou, potom si vyberte kratší čas pre uchovávanie záznamov. Hodnoty nižšie ako 30 nie sú doporučené, pretože štatistiky nemusia fungovať správne.';
$string['configlookahead'] = 'Počet dní do budúcnosti';
$string['configmaxbytes'] = 'Táto voľba špecifikuje maximálnu veľkosť prenášaných súborov na celom portáli. Toto nastavenie je obmedzené PHP nastavením upload_max_filesize a nastavením Apache LimitRequestBody. Nastavenie maxbytes ohraničuje rozsah veľkostí, z ktorých si môžete vybrať v každej úrovni kurzu alebo modulu. Ak je vybraná voľba \'Server Limit\', bude použitá maximálna hodnota daná serverom.';
$string['configmaxconsecutiveidentchars'] = 'Heslá nesmú mať mať viac ako tento počet sa sebou idúcich rovnakých znakov. Použite 0 na vypnutie tejto kontroly.';
$string['configmaxeditingtime'] = 'Toto určuje čas, ktorý majú ľudia na upravovanie príspevkov do fóra, spätnej väzby pre písomné práce, atď. Zvyčajne je to 30 minút.';
$string['configmaxevents'] = 'Počet udalostí';
$string['configmessaging'] = 'Má byť aktivovaný systém posielania správ medzi používateľmi stránky?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Upozornenia o prečítaní môžu byť vymazané, čím sa ušetrí miesto na disku. Ako dlho po prečítaní upozornenia môže byť toto vymazané?';
$string['configminpassworddigits'] = 'Heslá musia mať minimálne toľkoto číslic.';
$string['configminpasswordlength'] = 'Heslá musia byť minimálne toľkoto znakov dlhé.';
$string['configminpasswordlower'] = 'Heslá musia mať minimálne toľkoto malých písmen.';
$string['configminpasswordnonalphanum'] = 'Heslá musia mať minimálne toľkoto nealfanumerických znakov.';
$string['configminpasswordupper'] = 'Heslá musia mať minimálne toľkoto veľkých písmen.';
$string['configmycoursesperpage'] = 'Maximálny počet kurzov, ktoré sa zobrazia v zozname kurzov používateľa';
$string['configmymoodleredirect'] = 'Používať stránku /my (Môj Moodle) namiesto bežnej úvodnej stránky po prihlásení užívateľov (okrem administrátorov)?';
$string['configmypagelocked'] = 'Toto nastavenie zabraňuje upravovanie východzej stránky ne-administrátormi.';
$string['confignavcourselimit'] = 'Obmedzuje počet kurzov zobrazených používateľovi, keď nie je prihlásený alebo keď nie je zapísaný v žiadnom kurze.';
$string['confignavshowallcourses'] = 'Nastavenie tejto voľby zabezpečuje, že všetky kurzy na portáli sú zobrazené vždy v navigácii.';
$string['confignavshowcategories'] = 'Zobraziť kategórie kurzov v navigačnej lište a v navigačných blokoch. Toto nenastane pre kurzy, v ktorých je používateľ v súčasnosti zapísaný, budú aj naďalej uvedené v svojich predmetoch bez uvedenia kategórií.';
$string['confignotifyloginfailures'] = 'Ak sa uchovávajú záznamy o neúspešných pokusoch o prihlásenie do systému, môžu byť tieto odoslané emailom. Kto by si mal prezerať tieto oznámenia?';
$string['confignotifyloginthreshold'] = 'Ak sú aktívne oznámenia o neúspešných pokusoch o prihlásenie do systému, koľko takýchto prihlásení od jedného používateľa alebo jednej IP adresy sa má zobrazovať v oznámeniach?';
$string['confignotloggedinroleid'] = 'Neprihlásení návštevníci vašich stránok budú považovaní za používateľov, ktorým je na globálnej úrovni celého serveru priradená táto rola. Väčšinou je ti vhodné mať nastavenú rolu Hosť, ale možno si budete chcieť vytvoriť vlastnú rolu s väčšími či menšími právami. Veci ako pridávanie príspevkov a pod. stále vyžadujú platné prihlásenie.';
$string['configopentogoogle'] = 'Ak aktivujete toto nastavenie, potom Google bude mať oprávnenie vstupu do Vašej stránky ako Hosť. Naviac, ľudia prichádzajúci na Vašu stránku z prostredia vyhľadávača Google, budú automaticky prihlasovaní ako Hostia. Berte prosím na vedomie, že takýto prístup môže byť realizovaný len u tých kurzov, ktoré povoľujú vstup hostí.';
$string['configoverride'] = 'Definované v config.php';
$string['configpasswordpolicy'] = 'Ak toto zapnete, Moodle bude kontrolovať heslá v súlade so zvolenou bezpečnostnou politikou. Nastavenia nižšie ju definujú (budú ignorované, ak toto nenastavíte).';
$string['configpathtoclam'] = 'Cesta do Clam AV. Pravdepodobne niečo ako usr/bin/clamscan alebo /usr/bin/clamdscan. Túto cestu potrebujete, aby Clam AV fungoval správne.';
$string['configpathtodu'] = 'Cesta k programu du (disk usage). Pravdepodobne niečo ako /usr/bin/du. Zadaním tejto cesty sa urýchli generovanie stránok, ktoré zobrazujú obsah adresára s mnohými súbormi.';
$string['configperfdebug'] = 'Vypisovanie údajov o výkone vášho servera v zápätí štandardnej témy stránok.';
$string['configprofileroles'] = 'Zoznam rol, ktoré sú viditeľné na používateľských profiloch a zozname účastníkov.';
$string['configprofilesforenrolledusersonly'] = 'Z dôvodu zabránenia zneužitia spamermi sú skryté profily používateľov, ktorí ešte nie sú zapísaní do žiadneho kurzu. Noví používatelia sa musia najprv zapísať do nejakého kurzu a až potom si môžu zmeniť informácie vo svojom profile.';
$string['configprotectusernames'] = 'Štandardne forget_password.php nevypisuje žiadnu nápovedu, ktorá by dovolila uhádnuť užívateľské mená či adresy.';
$string['configproxybypass'] = 'Čiarkami oddelený zoznam (čiastočných) hostiteľov, alebo IP, ktorá by maia obísť proxy (napr. 192,168 .. Mydomain.com)';
$string['configproxyhost'] = 'Ak tento <b>server</b> potrebuje používať server proxy (napríklad bránu firewall) pri prístupe na Internet, tak tu uveďte hostiteľské meno a port. V opačnom prípade to nechajte prázdne.';
$string['configproxypassword'] = 'Heslo potrebné na prístup k internetu cez proxy (ak ho je treba). Ak nie je žiadne, nezadajte nič (je potrebné PHP rozšírenie cURL).';
$string['configproxyport'] = 'Ak sa váš server potrebuje pripájať pomocou proxy, uveďte tu proxy port.';
$string['configproxytype'] = 'Typ web proxy (PHP5 a rozšírenie cURL sú potrebné pre podporu SOCKS5).';
$string['configproxyuser'] = 'Login potrebný na prístup k internetu cez proxy (ak ho je treba). Ak nie je žiadne, nezadajte nič (je potrebné PHP rozšírenie cURL).';
$string['configquarantinedir'] = 'Ak chcete, aby Clam AV presunul napadnuté súbory do karanténneho adresára, napíšte ho sem. Musí byť ale zobraziteľný web serverom. Ak túto voľbu nevyplníte, alebo ak zadáte adresár, ktorý neexistuje alebo sa nedá zobraziť, budú napadnuté súbory vymazané. Nepridávajte koncové lomítko.';
$string['configrecaptchaprivatekey'] = 'Reťazec, ktorý sa používa pri komunikácii vášho Moodle servera a recaptcha.net servera. Získate ho pri návšteve webu http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Reťazec, ktorý sa používa pri zobrazení reCAPTCHA elementu pri vytváraní konta. Je generovaný serverom http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Povoliť výber kategórie pri požiadavke na vytvorenie kurzu.';
$string['configrequestedstudentname'] = 'Slovo označujúce jedného študenta v požadovaných kurzoch';
$string['configrequestedstudentsname'] = 'Slovo označujúce viacerých študentov v požadovaných kurzoch';
$string['configrequestedteachername'] = 'Slovo označujúce jedného učiteľa v požadovaných kurzoch';
$string['configrequestedteachersname'] = 'Slovo označujúce viacerých učiteľov v požadovaných kurzoch';
$string['configrequiremodintro'] = 'Vypnite túto voľbu, ak nechcete prinútiť používateľov na zadanie opisu každej činnosti.';
$string['configrunclamavonupload'] = 'Používanie antivíru clam pre kontrolu všetkých nahrávaných súborov.';
$string['configrunclamonupload'] = 'Spustiť Clam AV pri prenášaní súboru? K tomu budete potrebovať nastaviť správnu cestu v pathtoclam. (Clam AV je voľne šíriteľný vírusový skener, ktorý si môžete stiahnuť na http://www.clamav.net/)';
$string['configsectioninterface'] = 'Rozhranie';
$string['configsectionmail'] = 'Pošta';
$string['configsectionmaintenance'] = 'Údržba';
$string['configsectionmisc'] = 'Rôzne';
$string['configsectionoperatingsystem'] = 'Operačný systém';
$string['configsectionpermissions'] = 'Práva';
$string['configsectionrequestedcourse'] = 'Žiadosti o založenie kurzov';
$string['configsectionsecurity'] = 'Bezpečnosť';
$string['configsectionstats'] = 'Štatistiky';
$string['configsectionuser'] = 'Používateľ';
$string['configsecureforms'] = 'Moodle môže použiť dodatočné bezpečnostné opatrenia pri akceptovaní vstupov z web formulárov. Ak to umožníte, potom sa bude overovať premenná HTTP_REFERER, ktorú pošle prehliadač a porovná sa s aktuálnou adresou formulára. Toto môže spôsobiť (vo veľmi zriedkavých prípadoch) problémy, napr. ak je používateľ používa firewall, ktorý je konfigurovaný tak, že odstráni premennú HTTP_REFERER. Vtedy sa môže stať, že formulár Vám \'zmrzne\'. Ak sa na to používatelia sťažujú, môžete deaktivovať toto nastavenie. V tomto prípade sa však vystavujete väčším útokom zvonku (brute force password attacks).Ak si nie ste istý, nechajte túto voľbu nastavenú na \'Áno\'.';
$string['configsessioncookie'] = 'Toto nastavenie upravuje meno cookie používaného v Moodle sedeniach (sessions). Táto možnosť je voliteľná a užitočná v tom prípade, ak je spustená viac ako jedna kópia Moodle v rámci tej istej www stránky (aby ste sa vyhli popleteniu cookies).';
$string['configsessioncookiedomain'] = 'Toto nastavenie umožňuje nastaviť zmenu domény, z ktorej sú dostupné Moodle cookies. Je to výhodné pre zmeny v  Moodle (napríklad autentifikačné alebo zapisovacie zásuvné moduly), ktoré potrebujú zdieľať informáciu o Moodle session s inými web aplikáciami na inej poddoméne. <strong>UPOZORNENIE: je doporučované ponechať toto nastavenie vo východzom stave (prázdne) - nesprávne nastavenie zabráni všetkým sa prihlásiť na portál.</strong>';
$string['configsessioncookiepath'] = 'Podadresár vašich webových stránok, kam prehliadače odosielajú súbory cookie vašej inštalácie Moodle. Pravdepodobne vám bude vyhovovať východzie nastavenie \'/\' .';
$string['configsessiontimeout'] = 'Ak sú ľudia pripojení na túto stránku dlho nečinní (bez "prechádzania" stránok), sú automaticky odpojení (ich sedenie je ukončené). Táto premenná určuje, aký dlhý by mal byť ten časový interval nečinnosti.';
$string['configshowcommentscount'] = 'Zobraziť počet komentárov. Bude to stáť jeden SQL dotaz naviac pri zobrazení odkazu na komentáre.';
$string['configshowsiteparticipantslist'] = 'Všetci títo portáloví študenti a učitelia budú v zozname účastníkov portálu. Komu by malo byť povolené prezeranie tohto zoznamu?';
$string['configsitedefaultlicense'] = 'Východisková licencia portálu';
$string['configsitedefaultlicensehelp'] = 'Východisková licencia pre publikovanie obsahu na portáli.';
$string['configsitemaxcategorydepth'] = 'Maximálna hĺbka kategórií';
$string['configsitemaxcategorydepthhelp'] = 'Určenie maximálnej zobraziteľnej hĺbky podriadených kategórií';
$string['configslasharguments'] = 'Súbory (obrázky atď.) sú prenášané prostredníctvom skriptu používajúceho značku \'lomítko\'. Táto metóda umožňuje, aby boli súbory ľahšie zachytené na webových prehliadačoch, proxy serveroch atď. Bohužiaľ, niektoré PHP servery  túto metódu nepodporujú. Ak máte problémy pri zobrazovaní stiahnutých súborov alebo obrázkov (napr. obrázky používateľa), deaktivujte toto nastavenie.';
$string['configsmartpix'] = 'Ak je zapnuté, vyhľadávajú sa ikony pomocou PHP skriptu najprv v danej téme, potom vo všetkých nadradených témach a nakoniec v adresári /pix. Tým odpadá nutnosť kópií obrázkov vo všetkých témach, ale mierne sa zvyšuje záťaž.';
$string['configstartwday'] = 'Začiatok týždňa';
$string['configstatsfirstrun'] = 'Ako ďaleko do minulosti sa majú spracovať štatistiky <b>pri prvom spustení</b> tejto naplánovanej úlohy. Toto prvé spracovanie môže trvať dlho a je dosť náročné na systémové zdroje serveru. Ak je teda na vašich stránkach veľká prevádzka a máte okrem toho Moodle nainštalovaný na zdieľanom hostingovom serveri, nedoporučujeme nastavovať príliš veľkú hodnotu. Pre účely tohto nastavenia sa jedným mesiacom chápe 28 dní. V generovaných grafoch a štatistikách odpovedá jeden mesiac jednému kalendárnemu mesiacu.';
$string['configstatsmaxruntime'] = 'Spracovanie štatistík môže byť značne náročné. Využite preto toto a nasledujúce pole a nastavte, kedy bude táto úloha spustená a ako dlho pobeží.';
$string['configstatsmaxruntime2'] = 'Spracovanie štatistík môže byť značne náročné. Maximálny počet spracovaných dní na jedno spustenie úlohy cronu je 31.';
$string['configstatsmaxruntime3'] = 'Určenie maximálneho časového intervalu pre spracovanie štatistík pre jeden deň. Treba vziať do úvahy, že spracovanie štatistík výrazne zaťažuje server. Nižšie možno definovať maximálny počet dní, ktoré budú spracovávané v jednej úlohe cron.';
$string['configstatsruntimedays'] = 'Určenie maximálneho počtu dní spracovaných pri spustení štatistík. Ak sú štatistiky aktuálne, bude spracovaný iba posledný deň. Nastavenie tejto premennej závisí od vyťaženia servera. Znížte, ak treba skrátiť dĺžku trvania úlohy cron.';
$string['configstatsruntimestart'] = 'Kedy sa má <b>spustiť</b> úloha spracúvajúca štatistiky? Ak na tomto serveri existuje viacero inštancií Moodle, potom zvoľte rozličné časy.';
$string['configstatsuserthreshold'] = 'Pri vyhodnocovaní kurzov budú ignorované tie, v ktorých je zapísaných menej používateľov než uvedená nenulová hodnota.';
$string['configstripalltitletags'] = 'Vypnite toto nastavenie pre povolenie HTML tagov v názvoch aktivít a zdrojov.';
$string['configsupportemail'] = 'Táto mailová adresa bude publikovaná používateľom tohto portálu ako mail na zodpovednú osobu na poskytovanie pomoci (napríklad noví užívatelia pri vytváraní konta). Ak nič nezadáte, žiadna adresa nebude poskytnutá.';
$string['configsupportname'] = 'Meno osoby alebo úradu, ktorý bude poskytovať pomoc pomocou mailovej adresy alebo webovej stránky.';
$string['configsupportpage'] = 'Táto webová adresa bude publikovaná používateľom tohto portálu ako kontakt na zodpovednú osobu na poskytovanie pomoci (napríklad noví užívatelia pri vytváraní konta). Ak nič nezadáte, žiaden odkaz nebude poskytnutý.';
$string['configthemelist'] = 'Pokiaľ ponecháte toto pole prázdne, povolíte použitie ktorejkoľvek platnej témy. Pokiaľ chcete skrátiť výber tém, môžete tu určiť zoznam mien tém oddelených čiarkou. Napríklad: standard,orangewhite. Nepoužívajte medzery.';
$string['configtimezone'] = 'Tu môžete nastaviť východzie časové pásmo. Toto je len VÝCHODZIE časové pásmo pre zobrazovanie dátumov - každý používateľ toto môže zmeniť nastavením svojho preferovaného zobrazovania dátumu v profile používateľa. \'Čas servera\' na Moodle bude implicitne nastavený podľa operačného systému servera ale \'Čas servera\' v profile používateľa bude nastavený podľa nastavenia časového pásma.';
$string['configuseblogassociations'] = 'Majú byť používatelia schopní si organizovať svoj blog priradením príspevkov s kurzmi a ich modulmi?';
$string['configuserquota'] = 'Maximálny počet bajtov, ktoré môže používateľ ukladať do svojho súborového priestoru. {$a->bytes} bajtov == {$a->displaysize}';
$string['configusetags'] = 'Má byť funkcionalita tagov zapnutá na portáli?';
$string['configvariables'] = 'Všeobecné premenné';
$string['configverifychangedemail'] = 'Povoliť kontrolu zmeneného mailu pomocou nastavení povolených a zakázaných domén. Ak je toto nastavenie nepovolené, kontrola domén je vykonávaná iba pri vytváraní používateľov.';
$string['configvisiblecourses'] = 'Zobrazovať kurzy v skrytých kategóriách normálne';
$string['configwarning'] = 'Postupujte veľmi opatrne pri zmenách týchto nastavení - nesprávne hodnoty môžu spôsobiť problémy.';
$string['confirmation'] = 'Potvrdenie';
$string['confirmdeletecomments'] = 'Práve sa chystáte vymazať komentáre, ste si istý?';
$string['confirmed'] = 'Potvrdené';
$string['convertformat'] = 'Výstupný formát programu <i>convert</i>';
$string['cookiehttponly'] = 'Iba http cookies';
$string['cookiesecure'] = 'Iba bezpečné cookies';
$string['country'] = 'Východzia krajina';
$string['coursecontact'] = 'Vedúci kurzov';
$string['coursecontact_desc'] = 'Ktorých používateľov zobrazovať pri opise kurzu. Používatelia potrebujú aspoň jednu z týchto rol v danom kurze, aby boli zobrazení pri jeho opise.';
$string['courselistshortnames'] = 'Zobrazovať krátke názvy kurzov';
$string['courselistshortnames_desc'] = 'V zozname kurzov sa zobrazia aj krátke názvy.';
$string['coursemgmt'] = 'Pridať/upravovať kurzy';
$string['courseoverview'] = 'Prehľad kurzov';
$string['courserequestnotify'] = 'Upozornenie o žiadosti o kurz';
$string['courserequestnotifyemail'] = 'Používateľ {$a->user} požiadal o nový kurz na {$a->link}';
$string['courserequests'] = 'Požadované kurzy';
$string['courserequestspending'] = 'Nevybavené žiadosti o kurz';
$string['courses'] = 'Kurzy';
$string['coursesperpage'] = 'Počet kurzov na stránke';
$string['creatornewroleid'] = 'Rola tvorcov v nových kurzoch';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Spustenie cronu iba z príkazového riadku';
$string['cronerrorclionly'] = 'Ľutujem. Prístup na túto stránku z webového rozhrania bol správcom zakázaný.';
$string['cronerrorpassword'] = 'Ľutujem. Pre prístup na túto stránku musíte použiť platné heslo.';
$string['cronremotepassword'] = 'Heslo pre spustenia cronu';
$string['cronwarning'] = '<a href="cron.php" title="cron.php">Skript pre údržbu cron.php?</a> nebol spustený najmenej 24 hodín.';
$string['ctyperecommended'] = 'Pre zlepšenie výkonu na portáli (najmä pre nie latinkové jazyky) je doporučené nainštalovať voliteľnú knižnicu ctype.';
$string['ctyperequired'] = 'Voliteľná knižnica ctype je vyžadovaná v Moodle na zlepšenie výkonu na portáli a podporu kompatibility viacerých jazykov.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrecommended'] = 'Pre beh sieťových funkcionalít ("Moodle Networking") je treba nainštalovať voliteľnú knižnicu Curl.';
$string['curlrequired'] = 'PHP rozšírenie CURL je teraz vyžadované Moodle, aby bola umožnená komunikácia úložísk Moodle.';
$string['curltimeoutkbitrate'] = 'Najnižšia predpokladaná rýchlosť stahovanie cez cURL (kb/s)';
$string['currenttheme'] = 'Aktuálna téma';
$string['customcheck'] = 'Ostatné kontroly';
$string['custommenu'] = 'Vlastné menu';
$string['custommenuitems'] = 'Položky vlastného menu';
$string['datarootsecurityerror'] = '<p><strong>BEZPEČNOSTNÉ UPOZORNENIE!</strong></p><p>Váš dátový adresár je na nesprávnom mieste a dostupný z webu. To znamená, že všetky vaše súkromné súbory sú prístupné každému na svete a niektoré z nich môžu byť zneužité crackermi na získanie neoprávneného administratívneho prístupu k vášmu portálu !</p>
<p><em>Musíte</em> presunúť  dátový adresár ({$a}) na nové miesto, ktoré sa nenachádza vo verejnom web adresári a aktualizovať nastavenie <code>$CFG->dataroot</code> vo vašom súbore config.php.</p>';
$string['datarootsecuritywarning'] = 'Vaša inštalácia Moodle nemusí byť bezpečná. Prosím zabezpečte, aby váš dátový adresár ({$a}) nebol priamo dostupný z webu';
$string['dbmigrate'] = 'Migrácia databázy Moodle';
$string['dbmigrateconnecerror'] = 'K zvolenej databáze sa nepodarilo pripojiť.';
$string['dbmigrateencodingerror'] = 'Zvolená databáza používa kódovanie {$a} miesto požadovaného UNICODE/UTF8.<br />Vyberte prosím inú databázu.';
$string['dbmigratepostgres'] = 'Používate zrejme databázový server PostgreSQL. Pre pokračovanie migrácie musíte ručne vytvoriť novú databázu s kódovaním \'UNICODE\' (PostgreSQL 7), alebo \'UTF8\' (PostgreSQL 8), do ktorej budú prevedené údaje z existujúcej databázy. Zadajte údaje pre pripojenie k tejto novej databáze:';
$string['dbmigratewarning'] = 'Pred spustením tohto procesu bezpodmienečne urobte zálohu súčasnej databázy Moodle! Ak neviete, ako to urobiť, obráťte sa na administrátora vášho serveru. Stránky Moodle budú po zahájení migrácie prepnuté do režimu údržby.';
$string['dbmigratewarning2'] = '<b>Upozornenie: Hodláte spustiť proces migrácie databázy. Uistite sa prosím, že máte k dispozícii zálohu celej vašej súčasnej databázy Moodle.</b>\'';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Prebehla migrácia tejto databázy na novú databázu UTF8. Upravte súbor config.php a zadajte v ňom údaje pre používanie novej databázy. Pôvodnú databázu už nepoužívajte.</font>';
$string['dbmigrationdupfailed'] = 'Duplikácia databázy sa nepodarila a vrátila následujúcu chybu:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Informácie o session ukladať v databáze';
$string['debug'] = 'Ladiace informácie';
$string['debugall'] = 'ALL: Zobrazovať všetky zmysluplné ladiace informácie z PHP';
$string['debugdeveloper'] = 'DEVELOPER: zobrazovať extra informácie pre vývojárov Moodle';
$string['debugdisplay'] = 'Zobrazenie ladiacich informácií';
$string['debugging'] = 'Ladenie';
$string['debugminimal'] = 'MINIMAL: Zobrazovať iba kritické chyby';
$string['debugnone'] = 'NONE: Nezobrazovať žiadne správy ani varovania';
$string['debugnormal'] = 'NORMAL: Zobrazovať chyby, varovania a upozornenia';
$string['debugpageinfo'] = 'Zobraziť informácie o stránke';
$string['debugsmtp'] = 'Ladenie odosielania mailov';
$string['debugstringids'] = 'Zobraziť pôvod jazykových reťazcov';
$string['debugvalidators'] = 'Zobraziť validačné odkazy';
$string['defaultcity'] = 'Predvolené mesto';
$string['defaultcity_help'] = 'Zadané mesto bude predvolené pri vytváraní nových používateľských účtov.';
$string['defaulthomepage'] = 'Predvolená stránka pre užívateľov';
$string['defaultrequestcategory'] = 'Východzia kategória pre požadované kurzy';
$string['defaultsettinginfo'] = 'Východzí: {$a}';
$string['defaultuserroleid'] = 'Východzia rola pre všetkých používateľov';
$string['deleteincompleteusers'] = 'Odstrániť nekompletne vytvorených používateľov po';
$string['deleteunconfirmed'] = 'Odstrániť nepotvrdené účty po';
$string['deleteuser'] = 'Odstrániť používateľov';
$string['density'] = 'Hustota';
$string['denyemailaddresses'] = 'Zakázané emailové domény';
$string['development'] = 'Vývoj';
$string['devicedetectregex'] = 'Regulárne výrazy pre detekciu zariadenia';
$string['devicedetectregexexpression'] = 'Regulárny výraz';
$string['devicedetectregexvalue'] = 'Návratová hodnota';
$string['devicetype'] = 'Typ zariadenia';
$string['disableuserimages'] = 'Zrušiť obrázky v používateľských profiloch';
$string['displayerrorswarning'] = 'Zapnutie PHP nastavenia <em>display_errors</em> nie je doporučované na produkčných portáloch, pretože niektoré chybové správy môžu ukázať citlivé informácie o Vašom serveri.';
$string['displayloginfailures'] = 'Komu zobrazovať neúspešné prihlásenia:';
$string['dndallowtextandlinks'] = 'Pre nahranie potiahnite myšou text/odkaz';
$string['docroot'] = 'Umiestnenie dokumentácie';
$string['doctonewwindow'] = 'Otvárať v novom okne';
$string['download'] = 'Stiahnuť';
$string['edithelpdocs'] = 'Upraviť dokumentáciu nápovedy';
$string['editingnoncorelangfile'] = 'Pokúšate sa o zmenu prekladu neštandardného zásuvného modulu. Jeho preklad možno uložiť iba v adresári _local. Môžete ho potom presunúť do lang adresára modulu a (alebo) ho poslať vývojárovi tohto rozšírenia.';
$string['editlang'] = '<b>Upraviť</b>';
$string['editorbackgroundcolor'] = 'Farba pozadia';
$string['editordictionary'] = 'Slovník editora';
$string['editorfontfamily'] = 'Rodina fontov';
$string['editorfontlist'] = 'Zoznam fontov';
$string['editorfontsize'] = 'Veľkosť fontu';
$string['editorhidebuttons'] = 'Skryté tlačidlá';
$string['editorkillword'] = 'Čistenie formátu z MS Word';
$string['editorspelling'] = 'Pravopis editora';
$string['editorspellinghelp'] = 'Povoliť alebo zakázať kontrolu pravopisu. Ak je povolené, musí byť na serveri nainštalovaný <strong>aspell</strong>.';
$string['editstrings'] = 'Upraviť textové reťazce';
$string['emailchangeconfirmation'] = 'Potvrdenie zmeny emailu';
$string['emoticonalt'] = 'Alternatívny text';
$string['emoticoncomponent'] = 'Obrazový komponent';
$string['emoticonimagename'] = 'Názov obrázku';
$string['emoticons'] = 'Emotikony (smajlíky)';
$string['emoticonsreset'] = 'Reset nastavenia emotikonov na predvolené hodnoty';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Prázdny';
$string['enableajax'] = 'Povoliť AJAX';
$string['enableblogs'] = 'Povoliť blogy';
$string['enablecalendarexport'] = 'Povoliť export kalendárov';
$string['enablecomments'] = 'Zobrazovať komentáre';
$string['enablecourserequests'] = 'Povoliť žiadanie kurzov';
$string['enablecssoptimiser'] = 'Povoliť optimalizáciu CSS';
$string['enabledevicedetection'] = 'Povoliť detekciu zariadení';
$string['enablegravatar'] = 'Povoliť Gravatar';
$string['enablegroupmembersonly'] = 'Povoliť iba členov skupiny';
$string['enablemobilewebservice'] = 'Povoliť webové služby pre mobilné zariadenia';
$string['enablerecordcache'] = 'Povoliť Record Cache';
$string['enablerssfeeds'] = 'Povoliť RSS zdroje';
$string['enablesafebrowserintegration'] = 'Povoliť integráciu s programom Safe Exam Browser';
$string['enablestats'] = 'Povoliť štatistiky';
$string['enabletrusttext'] = 'Povoliť Dôveryhodný obsah';
$string['enablewebservices'] = 'Povoliť webové služby';
$string['enablewsdocumentation'] = 'Dokumentácia pre web servis';
$string['enrolinstancedefaults'] = 'Predvolené nastavenia zápisov do kurzu';
$string['enrolinstancedefaults_desc'] = 'Východzie nastavenia zápisu do kurzov v nových kurzoch.';
$string['enrolmultipleusers'] = 'Prihlásiť používateľa';
$string['environment'] = 'Programové prostredie';
$string['environmenterrortodo'] = 'Pre pokračovanie v inštalácii tejto verzie Moodle je nutné najprv vyriešiť problémy v programovom prostredí (chyby) serveru uvedené vyššie!';
$string['environmenterrorupgrade'] = 'Upozornenie: predtým, kým budete pokračovať v aktualizácii na túto verziu Moodle, vyriešte prosím všetky problémy s prostredím, uvedené vyššie. Ak by ste spustili aktualizáciu pred vyriešením týchto problémov, mohlo by to viesť k problémom, prípadne až k strate údajov. Naozaj chcete pokračovať?';
$string['environmentmustfixsetting'] = 'PHP nastavenia musia byť upravené';
$string['environmentok'] = 'Prostredie Vášho servera spĺňa všetky minimálne požiadavky.';
$string['environmentrecommendcustomcheck'] = 'ak tento test nebude úspešne vykonaný, indikuje to prítomnosť problému';
$string['environmentrecommendinstall'] = 'doporučený komponent';
$string['environmentrecommendversion'] = 'doporučená je verzia {$a->needed}, teraz používate verziu {$a->current}';
$string['environmentrequirecustomcheck'] = 'tento test musí byť úspešne splnený';
$string['environmentrequireinstall'] = 'vyžadovaný komponent';
$string['environmentrequireversion'] = 'vyžadovaná je verzia {$a->needed}, teraz používate verziu {$a->current}';
$string['environmentsettingok'] = 'Zistené boli odporúčané nadstavenia ';
$string['environmentshouldfixsetting'] = 'PHP nastavenia by mali upravené';
$string['environmentxmlerror'] = 'Chyba pri zisťovaní údajov o programovom prostredí ({$a->error_code})';
$string['errordeletingconfig'] = 'Vyskytla sa chyba pri vymazaní konfiguračných záznamov zásuvného modulu \'{$a}\'.';
$string['errorsetting'] = 'Nie je možné uložiť nastavenie:';
$string['errorwithsettings'] = 'Niektoré nastavenia neboli zmenené kvôli chybe:';
$string['everyonewhocan'] = 'Každý s oprávnením \'{$a}\'';
$string['exceptions'] = 'Výnimka';
$string['experimental'] = 'Experimentálne';
$string['experimentalsettings'] = 'Experimentálne nastavenia';
$string['extendedusernamechars'] = 'Povoliť neštandardné znaky v používateľských menách';
$string['extramemorylimit'] = 'Extra PHP limit pamäte';
$string['filecreated'] = 'Vytvorený nový súbor';
$string['filestoredin'] = 'Ukladať súbor do adresára:';
$string['filestoredinhelp'] = 'Kde budú ukladané súbory';
$string['filterall'] = 'Filtrovať všetky reťazce';
$string['filtermatchoneperpage'] = 'Jedna zhoda na stránku';
$string['filtermatchonepertext'] = 'Jedna zhoda na úsek textu';
$string['filters'] = 'Filtre';
$string['filtersettings'] = 'Nastavenia filtra';
$string['filtersettingsgeneral'] = 'Všeobecné nastavenia filtra';
$string['filteruploadedfiles'] = 'Filtrovať prenášané súbory';
$string['forcelogin'] = 'Vnútiť prihlásenie';
$string['forceloginforprofileimage'] = 'Vnútiť prihlásenie pre prezeranie užívateľských obrázkov';
$string['forceloginforprofiles'] = 'Vnútiť prihlásenie pre zobrazovanie profilov';
$string['forcetimezone'] = 'Vnútiť východzie časové pásmo';
$string['frontpage'] = 'Titulná stránka';
$string['frontpagebackup'] = 'Záloha titulnej stránky';
$string['frontpagedefaultrole'] = 'Východzia rola na titulnej stránke';
$string['frontpagefilters'] = 'Filtre titulnej stránky';
$string['frontpageloggedin'] = 'Položky na titulnej stránke po prihlásení';
$string['frontpageoverrides'] = 'Prepísanie prístupov titulnej stránky';
$string['frontpagequestions'] = 'Otázky na titulnej stránke';
$string['frontpagerestore'] = 'Obnova titulnej stránky';
$string['frontpageroles'] = 'Rola na titulnej stránke';
$string['frontpagesettings'] = 'Nastavenie titulnej stránky';
$string['fullnamedisplay'] = 'Formát celého mena';
$string['gdrecommended'] = 'Rozšírenie GD sa používa na konverziu obrázkov. Ak chýba, niektoré črty nebudú fungovať, napríklad obrázky používateľských profilov.';
$string['generalsettings'] = 'Všeobecné nastavenia';
$string['geoipfile'] = 'GeoIP City dátový súbor';
$string['getremoteaddrconf'] = 'Zdroj logovanej IPadresy';
$string['globalswarning'] = '<p><strong>Bezpečnostné upozornenie</strong>: pre správne fungovanie Moodle je nutné upraviť nastavenie PHP <br />na vašom serveri.<p/><p><em>Musíte</em> nastaviť <code>register_globals=off</code>. <p>Nastavenie skontrolujte v súbore <code>php.ini</code>, v konfiguračnom súbore Apache/IIS, alebo v súbore <code>.htaccess</code>.</p>';
$string['gotofirst'] = 'Prvý chýbajúci reťazec';
$string['gradebook'] = 'Klasifikácia';
$string['gradebookroles'] = 'Klasifikovaní používatelia';
$string['gradeexport'] = 'Primárne metódy exportu známok';
$string['groupenrolmentkeypolicy'] = 'Politika prihlasovacieho kľúča pre skupiny';
$string['guestroleid'] = 'Rola hosťa';
$string['helpadminseesall'] = 'Môžu si administrátori prezerať všetky udalosti kalendára, alebo len tie, ktoré sa ich týkajú?';
$string['helpforcetimezone'] = 'Môžete povoliť používateľom, aby si individuálne zvolili ich vlastné časové pásmo, alebo nastaviť jedno časové pásmo pre každého.';
$string['helpsitemaintenance'] = 'Pre aktualizácie a ďalšiu údržbu';
$string['helpstartofweek'] = 'Ktorým dňom v týždni by sa mal začínať týždeň v kalendári?';
$string['helpupcominglookahead'] = 'Koľko dní dopredu sa má štandardne zobrazovať v kalendári pri prezeraní nadchádzajúcich udalostí?';
$string['helpupcomingmaxevents'] = 'Koľko nadchádzajúcich udalostí (maximum) sa má štandardne zobrazovať používateľom?';
$string['helpweekenddays'] = 'Ktoré dni v týždni sú považované za "víkend", t.j. sú označené inou farbou?';
$string['hiddenuserfields'] = 'Skryť používateľské polia';
$string['hidefromall'] = 'Skryť všetkým používateľom';
$string['hidefromnone'] = 'Neskryť pred nikým';
$string['hidefromstudents'] = 'Skryť študentom';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Nastavenie HTML editora';
$string['htmlsettings'] = 'HTML nastavenia';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Zabezpečenie HTTP';
$string['iconvrecommended'] = 'Inštalácia voliteľnej knižnice ICONV je vysoko doporučovaná, pretože zvyšuje výkon stránok, najmä ak používate mäkčeňové jazyky - napr. slovenčinu.';
$string['iconvrequired'] = 'Je vyžadované rozšírenie ICONV.';
$string['ignore'] = 'Ignorovať';
$string['includemoduleuserdata'] = 'Zahrnúť používateľské údaje modulu';
$string['incompatibleblocks'] = 'Nekompatibilné bloky';
$string['installhijacked'] = 'Prepáčte, ale inštalácia musí byť dokončená z rovnakej IP adresy.';
$string['installsessionerror'] = 'Nie je možné inicializovať PHP sedenie. Skontrolujte, či Váš prehliadač akceptuje cookies.';
$string['intlrecommended'] = 'Rozšírenie intl je používané na zlepšenie podpory internacionalizácie, ako napr. triedenia na základe locale.';
$string['invalidsection'] = 'Neplatná sekcia';
$string['invaliduserchangeme'] = 'Užívateľské meno \'changeme\' je rezervované -- nie je možné ho použiť pre vytvorenie účtu.';
$string['ipblocked'] = 'Stránka nie je momentálne dostupná.';
$string['ipblocker'] = 'IP blokovač';
$string['ipblockersyntax'] = 'Dajte každú položku na jeden riadok. Platné položky sú buď plné IP adresy (napríklad <b>192.168.10.1</b>), ktorá zodpovedá jednému hostiteľovi, alebo čiastočnú adresu (napr. <b>192.168.</b>), ktorá zodpovedá akejkoľvek adrese počnúc tými číslami, alebo CIDR zápis (napr. <b>231.54.211.0/20</b>), alebo rozsah IP adries (napríklad <b>231.3.56.10-20</b>), kde rozsah sa vzťahuje na poslednú časť adresy. Textové doménové mená (ako \'example.com\') nie sú podporované. Prázdne riadky sú ignorované.';
$string['iplookup'] = 'Hľadať IP adresu pomocou';
$string['iplookupinfo'] = 'V štandardnej inštalácii Moodle využíva slobodný server NetGeo (internetová geografická databáza) pre vyhľadávanie IP adresy. Táto databáza však už nie je naďalej udržiavaná a môže vrátiť <em>úplne nesprávne</em> údaje.
Doporučuje sa inštalovať lokálnu verziu GeoLite City databázy od firmy MaxMind. <br />
Umiestnenie IP adresy je zobrazené na jednoduchej mape alebo pomocou aplikácie GoogleMaps. Pre interaktívne mapy je ale treba existujúce konto na Google a Google Maps API kľúč (získateľný iba za registráciu).';
$string['iplookupmaxmindnote'] = 'Tento produkt zahŕňa údaje GeoLite vytvorené firmou MaxMind, dostupné na <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Zachovávať veľkosť písmen v tagoch';
$string['lang'] = 'Východzí jazyk';
$string['langcache'] = 'Zoznam jazykov vo vyrovnávacej pamäti';
$string['langlist'] = 'Ktoré jazyky zobrazovať v ponuke';
$string['langmenu'] = 'Zobrazovať ponuku jazykov';
$string['langpackwillbeupdated'] = 'Moodle sa pokúsi počas aktualizácie nahrať aj najnovšiu verziu zvoleného jazykového balíčka. ';
$string['langstringcache'] = 'Kešovať všetky jazykové reťazce';
$string['languagesettings'] = 'Jazykové nastavenia';
$string['latexpreamble'] = 'Preambula LaTeX';
$string['latexsettings'] = 'Nastavenie rendereru LaTeX';
$string['latinexcelexport'] = 'Kódovanie Excelu';
$string['legacyfilesinnewcourses'] = 'Zastaralé súbory kurzov v nových kurzoch';
$string['licensesettings'] = 'Nastavenie licencie';
$string['loading'] = 'Nahrávanie...';
$string['localetext'] = 'Premenná locale';
$string['localstringcustomization'] = 'Úprava lokálnych reťazcov';
$string['location'] = 'Umiestnenie';
$string['locationsettings'] = 'Nastavenie umiestnenia';
$string['locked'] = 'zamknuté';
$string['log'] = 'Protokoly';
$string['logguests'] = 'Logovať prístup hostí';
$string['loginhttps'] = 'Pri prihlásení používať HTTPS';
$string['loginpageautofocus'] = 'Automaticky umiestniť kurzor do prihlasovacieho formulára';
$string['loginpasswordautocomplete'] = 'Zabrániť automatickému vypĺňaniu hesla v prihlasovacom formulári';
$string['loglifetime'] = 'Udržovať protokoly po dobu';
$string['longtimewarning'] = '<b>Prosím pozor, tento proces môže trvať dlho.</b>';
$string['maintenancemode'] = 'V režime údržby';
$string['maintfileopenerror'] = 'Chyba pri otváraní súborov údržby!';
$string['maintinprogress'] = 'Prebieha údržba serveru...';
$string['managelang'] = '<b>Správa</b>';
$string['managelicenses'] = 'Spravovať licencie';
$string['manageqbehaviours'] = 'Spravovať správanie otázok';
$string['manageqtypes'] = 'Správa typov otázok';
$string['maturity100'] = 'Beta';
$string['maturity200'] = 'Stabilná verzia';
$string['maturity50'] = 'Alfa';
$string['maturitycoreinfo'] = 'Váš portál momentálne beží na nestabilnej "{$a}" vývojovej verzii.';
$string['maxbytes'] = 'Maximálna veľkosť nahrávaných súborov';
$string['maxconsecutiveidentchars'] = 'Nasledujúce rovnaké znaky';
$string['maxeditingtime'] = 'Časový limit pre úpravu vložených príspevkov';
$string['mbstringrecommended'] = 'Inštalácia voliteľnej knižnice MBSTRING je vysoko doporučovaná, pretože zvyšuje výkon stránok, najmä ak používate mäkčeňové jazyky - napr. slovenčinu.';
$string['mediapluginavi'] = 'Aktivovať filter .avi';
$string['mediapluginflv'] = 'Aktivovať filter.flv';
$string['mediapluginimg'] = 'Podporiť auto-vkladanie odkazovaných obrázkov';
$string['mediapluginmov'] = 'Aktivovať filte .mov';
$string['mediapluginmp3'] = 'Aktivovať filter .mp3';
$string['mediapluginmpg'] = 'Aktivovať filter .mpg';
$string['mediapluginogg'] = 'Povoliť .ogg filter';
$string['mediapluginogv'] = 'Povoliť .ogv filter';
$string['mediapluginram'] = 'Aktivovať filter .ram';
$string['mediapluginrm'] = 'Aktivovať filter .rm';
$string['mediapluginrpm'] = 'Aktivovať filter .rpm';
$string['mediapluginswf'] = 'Aktivovať filter .swf';
$string['mediapluginswfnote'] = 'Východzie bezpečnostné nastavenie nedovoľuje normálnym užívateľom vkladať priamo do HTML textu súbory swf.';
$string['mediapluginwmv'] = 'Aktivovať filter .wmw';
$string['mediapluginyoutube'] = 'Povoliť filter odkazov na YouTube';
$string['messaging'] = 'Povoliť systém zasielania správ';
$string['messagingdeletereadnotificationsdelay'] = 'Vymazať upozornenia o prečítaní';
$string['messaginghidereadnotifications'] = 'Skryť upozornenia o prečítaní';
$string['minpassworddigits'] = 'Číslice';
$string['minpasswordlength'] = 'Dĺžka hesla';
$string['minpasswordlower'] = 'Malé písmená';
$string['minpasswordnonalphanum'] = 'Nealfanumerické znaky';
$string['minpasswordupper'] = 'Veľké písmená';
$string['misc'] = 'Rôzne';
$string['mnetrestore_extusers'] = '<strong>Poznámka:</strong> Táto záloha obsahuje vzdialených používateľov siete Moodle Network. Vzdialené účty budú v priebehu tohto procesu obnovené.';
$string['mnetrestore_extusers_admin'] = '<strong>Upozornenie:</strong> Tento súbor zálohy je zrejme z iného Moodle servera a obsahuje informácie o kontách vzdialených používateľov. Proces obnovy zo zálohy sa pokúsi o ich správne priradenie. Tým, ktorí nebudú správne identifikovaní, budú vytvorené kontá s vnútornou autentifikáciou (a nie mnet autentifikáciou). Zápis z obnovy v súbore restore.log bude obsahovať podrobné informácie.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Poznámka:</strong> Táto záloha evidentne pochádza z odlišnej inštalácie Moodle a obsahuje vzdialené používateľské účty. Obnova týchto účtov sa nemusí podariť, táto operácia nie je podporovaná. Ak ste si istí, že záloha pochádza z tejto inštalácie, alebo môžete zaistiť, že sú správne nastavené všetky hostiteľské počítače v sieti Moodle Network, môžete sa aj napriek tomu pokúsiť o obnovu.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Upozornenie:</strong> Tento súbor zálohy je zrejme z iného Moodle servera a obsahuje informácie o kontách vzdialených používateľov. Na jeho obnovenie nemáte oprávnenie. Môžete alebo informovať administrátora alebo vykonať obnovu bez informácií o používateľoch (moduly, súbory,...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Vzdialený Moodle Network používateľ {$a->username} (zo servera {$a->mnethosturl}) bol prepnutý na lokálne autentifikovaného používateľa ({$a->auth}).';
$string['modeditdefaults'] = 'Východzie hodnoty pre nastavenia aktivít';
$string['modsettings'] = 'Spravovať aktivity';
$string['modulesecurity'] = 'Zabezpečenie modulov';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Vnútiť starú syntax viacjazyčného obsahu pomocí tagu <lang>';
$string['mustenablestats'] = 'Na týchto stránkach nie sú štatistiky povolené';
$string['mycoursesperpage'] = 'Maximálny počet kurzov';
$string['mydashboard'] = 'Predvolená systémová plocha';
$string['mymoodle'] = 'Môj Moodle';
$string['mymoodleredirect'] = 'Vnútiť používateľom použitie stránky Môj Moodle';
$string['mypage'] = 'Moja východzia stránka ';
$string['mypagelocked'] = 'Uzamknúť východziu stránku';
$string['myprofile'] = 'Východzia stránka profilu';
$string['mysql416bypassed'] = 'Ak ale vo vašej inštalácii Moodle používate IBA jazyky založené na latinke (iso-8859-1), môžete aj ďalej používať súčasne nainštalovanú verziu MySQL 4.1.12 (alebo vyššiu).';
$string['mysql416required'] = 'Minimálnou verziou potrebnou pre Moodle 1.6 -- a pre neskorší bezpečný prevod všetkých údajov do UTF-8 -- je MySQL 4.1.16.';
$string['navadduserpostslinks'] = 'Pridať odkazy na príspevky používateľa';
$string['navcourselimit'] = 'Limit kurzu';
$string['navshowallcourses'] = 'Zobraziť všetky kurzy';
$string['navshowcategories'] = 'Zobrazoť kategórie kurzov';
$string['neverdeleteruns'] = 'Nikdy neodstraňovať dokončené udalosti';
$string['nobookmarksforuser'] = 'Nemáte žiadne záložky';
$string['nodatabase'] = 'Žiadna databáza';
$string['nomissingstrings'] = 'Žiadne chýbajúce reťazce';
$string['nonewsettings'] = 'V priebehu upgrade nebolo pridané žiadne nové nastavenie';
$string['nonexistentbookmark'] = 'Požadovaná záložka neexistuje';
$string['noresults'] = 'Bez výsledkov';
$string['noroles'] = 'Žiadne role';
$string['notifications'] = 'Upozornenie';
$string['notifyloginfailures'] = 'Posielať neúspešné prihlásenia emailom';
$string['notifyloginthreshold'] = 'Prah pre upozornenie emailom';
$string['notloggedinroleid'] = 'Rola návštevníkov';
$string['numberofmissingstrings'] = 'Počet chýbajúcich reťazcov: {$a}';
$string['numberofstrings'] = 'Celkový počet reťazcov: {$a->strings}<br />Chýbajúce: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'Pre beh sieťových funkcionalít ("Moodle Networking") je treba nainštalovať voliteľnú knižnicu OpenSSL.';
$string['opentogoogle'] = 'Povoliť prehľadávanie Googlom';
$string['optionalmaintenancemessage'] = 'Voliteľná správa pre používateľa počas údržby';
$string['order1'] = 'Prvý';
$string['order2'] = 'Druhý';
$string['order3'] = 'Tretí';
$string['order4'] = 'Štvrtý';
$string['passwordpolicy'] = 'Zásady pre tvorbu hesiel';
$string['pathconvert'] = 'Cesta k binárnemu súboru <i>convert</i>';
$string['pathdvips'] = 'Cesta k binárnemu súboru <i>dvips</i>';
$string['pathlatex'] = 'Cesta k binárnemu súboru <i>latex</i>';
$string['pathtoclam'] = 'Cesta k clam';
$string['pathtodot'] = 'Cesta k programu dot';
$string['pathtodot_help'] = 'Cesta k programu dot. Pravdepodobne niečo ako /usr/bin/dot. Aby ste mohli vytvárať grafiku z DOT súborov, musíte mať nainštalovaný program dot a tu povedať, kde sa nachádza. Poznamenávame, že sa zatiaľ používa iba pre profiláciu (Vývoj -> Profilácia) zabudovanú do Moodle';
$string['pathtodu'] = 'Cesta k du';
$string['pathtopgdump'] = 'Cesta k pg_dump';
$string['pathtopgdumpdesc'] = 'Tento údaj je nutné zadať iba v prípade, že prevádzkujete viac než jednu verziu pg_dump (napr. ak je na serveri inštalovaná viac než jedna verzia postgresql).';
$string['pathtopgdumpinvalid'] = 'Neplatná cesta k pg_dump -- buď je zadaná chybná cesta, alebo nie je možné odkazovaný súbor spustiť.';
$string['pathtopsql'] = 'Cesta k psql';
$string['pathtopsqldesc'] = 'Tento údaj je nutné zadať iba v prípade, že prevádzkujete viac než jednu verziu psgl (napr. ak je na serveri inštalovaná viac než jedna verzia postgresql).';
$string['pathtopsqlinvalid'] = 'Neplatná cesta k psgl -- buď je zadaná chybná cesta, alebo nie je možné odkazovaný súbor spustiť.';
$string['perfdebug'] = 'Informácia o výkonnosti';
$string['performance'] = 'Výkonnosť';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Parametre PostgreSQL version/cluster pre operácie z príkazového riadku. Ak prevádzkujete iba jednu verziu PostgreSQL, alebo ak si nie ste istý, nechajte pole prázdne.';
$string['php50restricted'] = 'V PHP 5.0.x bolo nájdených množstvo chýb; prejdite buď na vyššiu verziu 5.1.x, alebo na nižšiu verziu 4.3.x či 4.4.x.';
$string['php533warning'] = 'Odporúčaná verzia je PHP 5.3.3 a vyššia';
$string['phpfloatproblem'] = 'Bol zistený neočakávaný problém so spracovaním desatinných čísel - {$a}';
$string['pleaserefreshregistration'] = 'Váš portál bol registrovaný na moodle.org. Prosím urobte tak znova, ak sa od poslednej aktualizácie udiali významné zmeny.';
$string['pleaseregister'] = 'Prosím, zaregistrujte si Vašu stránku, aby ste odstránili toto tlačidlo';
$string['plugin'] = 'Modul';
$string['plugins'] = 'Moduly';
$string['pluginschecktodo'] = 'Musite vyriešiť všetky závislosti modulov pred nainštalovaním tejto verzie Moodle!';
$string['pluginsoverview'] = 'Prehľad modulov';
$string['pluginsoverviewsee'] = 'Ďalšie informácie nájdete v <a href="{$a->url}">prehľade zásuvných modulov</a>.';
$string['profilecategory'] = 'Kategórie';
$string['profilecategoryname'] = 'Názov kategórie (musí byť jedinečný)';
$string['profilecategorynamenotunique'] = 'Tento názov kategórie je už používaný';
$string['profilecommonsettings'] = 'Spoločné nastavenia';
$string['profileconfirmcategorydeletion'] = 'Bolo nájdené {$a} polí, ktoré budú presunuté do vyššej kategórie (alebo nižšej, ak sa jedná o najvyššiu kategóriu).<br />Stále si prajete túto kategóriu odstrániť?';
$string['profileconfirmfielddeletion'] = 'Bolo nájdené {$a} záznamov, ktoré používajú toto pole. Informácia uložená v poli bude nenávratne stratená. Stále si prajete pole odstrániť?';
$string['profilecreatecategory'] = 'Vytvoriť novú kategóriu profilov';
$string['profilecreatefield'] = 'Vytvoriť nové pole profilu:';
$string['profilecreatenewcategory'] = 'Vytváram novú kategóriu';
$string['profilecreatenewfield'] = 'Vytváram nové pole "{$a}"';
$string['profiledefaultcategory'] = 'Ďalšie pole';
$string['profiledefaultchecked'] = 'Vybrané vo východzom nastavení';
$string['profiledefaultdata'] = 'Východzia hodnota';
$string['profiledeletecategory'] = 'Odstraňujem kategóriu';
$string['profiledeletefield'] = 'Odstraňujem pole';
$string['profiledescription'] = 'Opis poľa';
$string['profiledscript'] = 'Tento skript bol profilovaný';
$string['profiledscriptview'] = 'Zobraziť informácie o profilovaní tohto skriptu';
$string['profileeditcategory'] = 'Úprava kategórie: {$a}';
$string['profileeditfield'] = 'Úprava poľa profilu: {$a}';
$string['profilefield'] = 'Pole profilu';
$string['profilefieldcolumns'] = 'Stĺpce';
$string['profilefieldispassword'] = 'Je toto pole pre heslo?';
$string['profilefieldlink'] = 'Odkaz';
$string['profilefieldlink_help'] = 'Pre transformáciu testu na odkaz, vložte URL obsahujúce $$, kde $$ bude nahradené textom. Napríklad na transformáciu Twitter ID na odkaz, vložte http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Cieľ odkazu';
$string['profilefieldmaxlength'] = 'Maximálna dĺžka';
$string['profilefieldrows'] = 'Riadky';
$string['profilefields'] = 'Používateľské pole profilu';
$string['profilefieldsize'] = 'Veľkosť zobrazenia';
$string['profileforceunique'] = 'Majú byť údaje jedinečné?';
$string['profileinvaliddata'] = 'Neplatná hodnota';
$string['profilelocked'] = 'Je pole zamknuté?';
$string['profilemenudefaultnotinoptions'] = 'Východzia hodnota nie je jedna z ponúkaných možností';
$string['profilemenunooptions'] = 'Neboli dodané žiadne možnosti';
$string['profilemenuoptions'] = 'Možnosti (každá na jeden riadek)';
$string['profilemenutoofewoptions'] = 'je treba vložiť aspoň dve možnosti';
$string['profilename'] = 'Názov';
$string['profilenofieldsdefined'] = 'Neboli definované žiadne polia';
$string['profilerequired'] = 'Je vyplnenie poľa povinné?';
$string['profileroles'] = 'Viditeľné roly profilu';
$string['profilesforenrolledusersonly'] = 'Profily iba pre učastníkov kurzu';
$string['profileshortname'] = 'Krátky názov (jedinečný)';
$string['profileshortnamenotunique'] = 'Tento krátky názov je už používaný';
$string['profilesignup'] = 'Zobraziť stránku pre vytváranie konta?';
$string['profilespecificsettings'] = 'Špecifické nastavenia';
$string['profilevisible'] = 'Kto môže vidieť obsah poľa?';
$string['profilevisibleall'] = 'Verejné pole - viditeľné pre všetkých';
$string['profilevisible_help'] = '<p>Každému používateľskému poľu možno priradiť tri úrovne viditeľnosti:
   skryté, súkromné a verejné. Skryté pole je typicky vytvorené správcom,
   ktorý jeho pomocou udržuje o používateľoch neverejné informácie.
   Súkromné pole je určené pre citlivé údaje, verejné polia možno použiť
   pre ukladanie informácií ľubovoľného typu.</p>';
$string['profilevisiblenone'] = 'Skryté pole - neviditeľné';
$string['profilevisibleprivate'] = 'Súkromné pole - viditeľné iba pre daného používateľa';
$string['profiling'] = 'Profilovanie';
$string['profilingallowall'] = 'Súvislé profilovanie';
$string['profilingallowme'] = 'Selektívne profilovanie';
$string['profilingautofrec'] = 'Automatické profilovanie';
$string['profilingenabled'] = 'Povoliť profilovanie';
$string['profilingexcluded'] = 'Výlučiť z profilovania';
$string['protectusernames'] = 'Chrániť používateľské mená';
$string['proxyhost'] = 'Proxy server';
$string['proxypassword'] = 'Proxy heslo';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Typ proxy';
$string['proxyuser'] = 'Proxy používateľ';
$string['purgecaches'] = 'Vyčistiť všetky vyrovnávacie pamäte';
$string['purgecachesfinished'] = 'Všetky vyrovnávacie pamäte boli vymazané.';
$string['qtyperqpwillberemoved'] = 'Počas aktualizácie budú odobrané otázky typu RQP. Nemali ste žiadne také, takže by ste nemali zbadať žiadne problémy.';
$string['qtyperqpwillberemovedanyway'] = 'Počas aktualizácie budú odobrané otázky typu RQP. Vo vašej databáze sa otázky takéhoto typu nachádzajú a nebudú fungovať ak nepreinštalujete program z http://moodle.org/mod/data/view.php?d=13&amp;rid=797 predtým, ako budete pokračovať v aktualizácii.';
$string['quarantinedir'] = 'Adresár karantény';
$string['question'] = 'Otázka';
$string['questionbehaviours'] = 'Správanie otázok';
$string['questioncwqpfscheck'] = 'Jedna alebo viacero \'náhodných\' otázok v teste je zostavená z otázok pochádzajúcich aj zo zdieľaných aj z nezdieľaných kategórií. Viac o <a href="{$a->reporturl}">tomto probléme</a>, prípadne aj v <a href="{$a->docsurl}">Moodle dokumentácii</a>.';
$string['questioncwqpfsok'] = 'Výborne. Vo vašich testoch neboli nájdené žiadne \'náhodné\' otázky zostavené z otázok pochádzajúcich aj zo zdieľaných aj z nezdieľaných kategórií.';
$string['questiontype'] = 'Typ otázky';
$string['questiontypes'] = 'Typy otázok';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privátny kľúč';
$string['recaptchapublickey'] = 'ReCAPTCHA verejný kľúč';
$string['registerwithmoodleorg'] = 'Registrovať na Moodle.org';
$string['registration'] = 'Registrácia';
$string['releasenoteslink'] = 'Informácie o tejto verzii Moodle nájdete v <a target="_blank" href="{$a}">Poznámkach k verzii</a>';
$string['rememberusername'] = 'Zapamätať meno používateľa';
$string['requiredentrieschanged'] = '<strong>DÔLEŽITÉ - PROSÍM ČÍTAJTE<br/>(Toto upozornenie je zobrazované iba počas tejto aktualizácie)</strong><br/>Vzhľadom k oprave chyby sa zmenilo správanie aktivity databáza, konkrétne nastavení \'Required entries\' a \'Required entries before viewing settings\'. Viac informácií sa dozviete na <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">fóre o databázovom module</a>. Očakávané správanie týchto nastavení je vysvetlené aj na <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.
<br/><br/>Táto zmena ovplyvní nasledovné databázy vo vašom systéme: (Tento zoznam si uložte a po aktualizácii skontrolujte, či sú nastavené tak, ako učitelia očakávajú.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Vyžadovať opis aktivity';
$string['requires'] = 'Vyžaduje';
$string['reverseproxy'] = 'Reverzné proxy';
$string['riskconfig'] = 'Používatelia môžu meniť nastavenia a chovanie stránok (serveru)';
$string['riskconfigshort'] = 'Riziko zásahu do konfigurácie';
$string['riskdataloss'] = 'Používatelia by mohli zničiť veľké množstvá obsahu alebo informácií';
$string['riskdatalossshort'] = 'Hrozba straty informácii';
$string['riskmanagetrust'] = 'Používatelia môžu meniť úroveň dôveryhodnosti iných používateľov';
$string['riskmanagetrustshort'] = 'Správa dôveryhodnosti';
$string['riskpersonal'] = 'Používatelia môžu získať prístup k súkromným informáciám iných používateľov';
$string['riskpersonalshort'] = 'Riziko zásahu do súkromia';
$string['riskspam'] = 'Používatelia môžu zasielať nevyžiadanú poštu (spam) ďalším používateľom';
$string['riskspamshort'] = 'Riziko spamu';
$string['riskxss'] = 'Používatelia môžu pridávať súbory či texty umožňujúce Cross-Site Scripting (XSS).';
$string['riskxssshort'] = 'Riziko XSS';
$string['roleswithexceptions'] = '{$a->roles}, s {$a->exceptions}';
$string['rssglobaldisabled'] = 'Nepovolené na úrovni servera';
$string['runclamavonupload'] = 'Použiť clam AV pre nahrávané súbory';
$string['save'] = 'Uložiť';
$string['savechanges'] = 'Uložiť zmeny';
$string['search'] = 'Hľadaj';
$string['searchinsettings'] = 'Hľadaj v nastaveniach';
$string['searchresults'] = 'Výsledky hľadania';
$string['sectionerror'] = 'Chyba v sekcii!';
$string['secureforms'] = 'Použiť pridané zabezpečenie formulára';
$string['security'] = 'Zabezpečenie';
$string['server'] = 'Server';
$string['serverchecks'] = 'Kontroly servera';
$string['serverlimit'] = 'Limit servera';
$string['sessioncookie'] = 'Predpona názvu cookie';
$string['sessioncookiedomain'] = 'Doména cookie';
$string['sessioncookiepath'] = 'Cesta platnosti cookie';
$string['sessionhandling'] = 'Správa sedenia (sessions)';
$string['sessiontimeout'] = 'Časový limit';
$string['settingfileuploads'] = 'Nahrávanie súborov je požadované pre normálnu prevádzku, prosím aktivujte ho v konfigurácii PHP.';
$string['settingmemorylimit'] = 'Bolo zistené nedostatočné množstvo pamäte, prosím nastavte vyšší limit pamäte v nastaveniach PHP.';
$string['showcommentscount'] = 'Zobraziť počet komentárov';
$string['showdetails'] = 'Zobraziť detaily';
$string['simplexmlrequired'] = 'PHP rozšírenie SimpleXML je vyžadované pre Moodle';
$string['sitemaintenance'] = 'Táto stránka sa nachádza v režime údržby a momentálne nie je prístupná';
$string['sitemaintenancemode'] = 'Režim údržby';
$string['sitemaintenanceoff'] = 'Režim údržby bol deaktivovaný a táto stránka bude ďalej bežať normálne';
$string['sitemaintenanceon'] = 'Vaša stránka je momentálne v režime údržby (prihlásiť sa a používať stránku môžu iba administrátori).';
$string['sitemaintenancewarning'] = 'Vaša stránka je momentálne v režime údržby (prihlásiť sa a používať stránku môžu iba administrátori). Pre návrat k normálnej prevádzke stránky <a href="maintenance.php">deaktivujte režim údržby</a>.';
$string['sitepolicies'] = 'Pravidlá prevádzky stránok';
$string['sitepolicy'] = 'URL k pravidlám prevádzky stránok';
$string['sitepolicyguest'] = 'URL pre politiku portálu pre hostí';
$string['sitepolicy_help'] = 'Ak máte definované pravidlá, ktoré všetci používatelia musia vidieť a s nimi súhlasiť pred používaním tejto stránky, potom sem vložte danú URL adresu; v opačnom prípade túto voľbu nevypĺňajte. URL adresa môže byť nastavená v ktoromkoľvek mieste - jedno z najvhodnejších miest by bol súbor v súboroch stránky, napr. http://yoursite/file.php/1/policy.html';
$string['sitesectionhelp'] = 'Ak je vybrané, zobrazuje sa na hlavnej stránke portálu tématická sekcia.';
$string['slasharguments'] = 'Predávanie argumentov za lomítkom';
$string['smartpix'] = 'Vylepšené vyhľadávanie ikon';
$string['soaprecommended'] = 'Inštalácia nepovinného rozšírenia soap je vhodná pre web služby a niektoré rozšírenia.';
$string['spellengine'] = 'Nástroj pre speller';
$string['splrequired'] = 'SPL rozšírenie PHP je v Moodle vyžadované.';
$string['stats'] = 'Štatistiky';
$string['statsfirstrun'] = 'Maximálny interval spracovania';
$string['statsmaxruntime'] = 'Maximálny čas spracovania';
$string['statsruntimedays'] = 'Počet spracovaných dní';
$string['statsruntimestart'] = 'Spúšťať o';
$string['statsuserthreshold'] = 'Používateľský prah';
$string['stickyblocks'] = 'Povinné bloky';
$string['stickyblockscourseview'] = 'Stránka kurzu';
$string['stickyblocksduplicatenotice'] = 'Ak sa vybraný blok na zvolenej stránke už vyskytuje, bude sa na nej zobrazovať dvakrát.<br />Povinný blok nebude možné upravovať, duplicitný (nepovinný) blok áno.';
$string['stickyblocksmymoodle'] = 'Môj Moodle';
$string['stickyblockspagetype'] = 'Typ stránky';
$string['stripalltitletags'] = 'Odstrániť HTML tagy zo všetkých názvov aktivít';
$string['supportemail'] = 'Emailová podpora';
$string['supportname'] = 'Meno podpory';
$string['supportpage'] = 'Stránka podpory';
$string['switchlang'] = 'Prepnúť umiestnenie jazyka';
$string['systempaths'] = 'Cesty k súborom';
$string['tablenosave'] = 'Zmeny v tabuľke uvedenej vyššie sú automaticky uložené.';
$string['tablesnosave'] = 'Zmeny v tabuľkách uvedených vyššie sú automaticky uložené.';
$string['tabselectedtofront'] = 'Mal by byť označený tag v aktuálnom riadku v tabuľkách s tabulátorom umiestnený vpredu?';
$string['tabselectedtofronttext'] = 'Priniesť vybranú kartu do popredia';
$string['themelist'] = 'Zoznam tém';
$string['themeresetcaches'] = 'Vyčistiť vyrovnávaciu pamäť témy';
$string['themeselector'] = 'Voľba témy';
$string['themesettings'] = 'Nastavenie témy';
$string['therewereerrors'] = 'Vo Vašich údajoch boli nájdené chyby';
$string['timezone'] = 'Východzie časové pásmo';
$string['timezoneforced'] = 'Toto je nastavené administrátorom stránky';
$string['timezoneisforcedto'] = 'Nastaviť rovnaké použitie pre všetkých používateľov';
$string['timezonenotforced'] = 'Používateľ si môže vybrať vlastnú časovú zónu';
$string['tokenizerrecommended'] = 'Inštalácia voliteľného rozšírenia PHP Tokenizer je doporučovaná - zlepšuje možnosti Moodle Networking.';
$string['unattendedoperation'] = 'Bez obsluhy';
$string['unbookmarkthispage'] = 'Odstrániť záložku k tejto stránke';
$string['unicoderecommended'] = 'Doporučujeme ukladanie údajov v kódovaní Unicode (UTF-8). Nové inštalácie by mali byť založené nad databázou s východzím kódovaním Unicode. Ak prechádzate z nižších verzií, mali by ste premigrovať na UTF-8 (viď stránku Administratíva).';
$string['unicoderequired'] = 'Je nutné ukladanie údajov v kódovaní Unicode (UTF-8). Nové inštalácie musia byť založené nad databázou s východzím kódovaním Unicode. Ak prechádzate z nižších verzií, mali by ste premigrovať na UTF-8 (viď stránku Administratíva).';
$string['uninstallplugin'] = 'Odinštalovať';
$string['unsupported'] = 'Nepodporované';
$string['updateaccounts'] = 'Aktualizovať existujúce účty';
$string['updateautocheck'] = 'Automaticky kontrolovať dostupné aktualizácie';
$string['updateautocheck_desc'] = 'Ak je povolené, budú sa automaticky kontrolovať dostupné aktualizácie kódu Moodle a všetkých ďalších zástupných modulov. Administrátori portálu sú upozorňovaní na nové aktualizácie.';
$string['updateavailable'] = 'Je dostupná novšia verzia Moodle!';
$string['updateavailabledetailslink'] = 'Viac informácií na {$a->url}';
$string['updateavailableforplugin'] = 'Pre niektoré z Vašich zásuvných modulov sú dostupné novšie verzie.';
$string['updateavailablenot'] = 'Váš Moodle je aktuálny';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verzia {$a}';
$string['updatecomponent'] = 'Aktualizovať komponentu';
$string['updatenotificationfooter'] = 'Na vašom Moodle portáli {$a->siteurl} je nastavená automatická kontrola dostupných aktualizácií. Túto správu dostávate ako správca uvedeného portálu. Automatickú kontrolu dostupných aktualizácií môžete vypnúť v časti "Administratíva portálu" bloku Nastavenia. Spôsob doručenia tejto správy si môžete upraviť v časti "Nastavenie môjho profilu > Správy" bloku Nastavenia.';
$string['updatenotifications'] = 'Dostupné aktualizácie';
$string['updatenotificationsubject'] = '[{$a->siteurl}] Dostupné aktualizácie pre Moodle';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 obsahuje viacero bezpečnostných záplat vzťahujúcich sa k používateľským heslám a zálohám kurzov tak, aby chránili používateľské údaje na vašom portáli. Z toho dôvodu boli zmenené niektoré nastavenia a oprávnenia.<br />
Viď <a href="http://docs.moodle.org/en/Moodle_1.9.7_release_notes" target="_blank">poznámky k vydaniu Moodle 1.9.7</a> pre viac detailov.</p>';
$string['upgrade197noticesubject'] = 'Bezpečnostné oznámenia k aktualizácii Moodle 1.9.7';
$string['upgrade197salt'] = 'Z dôvodu zníženia rizika ukradnutia hesiel je výrazne doporučované nastaviť solenie (salt) hesiel. <br />Viď <a href="{$a}" target="_blank">dokumentáciu k solenie hesiel</a> s podrobnými informáciami.';
$string['upgradeerror'] = 'Neznáma chyba pri aktualizácii zásuvného modulu {$a->plugin} na verziu {$a->version}. Nie je možné pokračovať.';
$string['upgradeforumread'] = 'Novou vlastnosťou pridanou do Moodle 1.5 je sledovanie čítaných/nečítaných príspevkov do fór.<br />Pre použitie tejto funkcie je potrebné <a href="{$a}">aktualizovať tabuľky</a>.';
$string['upgradeforumreadinfo'] = 'Novou vlastnosťou pridanou do Moodle 1.5 je sledovanie čítaných/nečítaných príspevkov do fór. Pre použitie tejto funkcie je potrebné aktualizovať tabuľky všetkými informáciami pre sledovanie existujúcich príspevkov. Toto môže trvať podľa veľkosti Vašej stránky až niekoľko hodín a môže to veľmi zaťažiť Váš databázový server. Napriek tomu bude Vaša stránka stále funkčná a používatelia nebudú zasiahnutí. Ak tento proces raz začnete, musíte ho aj dokončiť  (nechajte otvorené okno v prehliadači). Napriek tomu, pokiaľ tento proces zastavíte zatvorením okna, nemusíte sa báť, môžete ho naštartovať znovu.<br /><br />Chcete naštartovať aktualizáciu teraz?';
$string['upgradelogs'] = 'Vaše staré záznamy musia byť aktualizované, aby bol systém plne funkčný.<a href="{$a}">Viac informácií</a>';
$string['upgradelogsinfo'] = 'Nedávno boli prevedené nejaké zmeny týkajúce sa spôsobu, akým sú záznamy uchovávané. Aby ste si mohli prezerať všetky Vaše staré záznamy, musíte ich aktualizovať. Toto môže trvať dosť dlho (napr. niekoľko hodín - to záleží od Vašej stránky) a môže to dosť zaťažiť samotný databázový server u obsiahlejších stránok. Ak tento proces raz začnete, musíte ho aj dokončiť (nechajte otvorené okno v prehliadači). Neobávajte sa, Vaša stránka bude pre ostatných používateľov fungovať bez problémov, pokým Vy budete aktualizovať záznamy. <br /><br />Chcete aktualizovať Vaše záznamy teraz?';
$string['upgradesettings'] = 'Nové nastavenia';
$string['upgradesettingsintro'] = 'V priebehu posledného upgrade pribudli nasledujúce nové nastavenia. Vykonajte nutné úpravy oproti východzím hodnotám a stlačte tlačidlo &quot;Uložiť zmeny&quot; na konci tejto stránky.';
$string['upgradestart'] = 'Aktualizovať databázu Moodle teraz';
$string['upgradesure'] = '<p>Vaše súbory v Moodle boli zmenené a Vy sa práve chystáte povýšiť Váš server na túto verziu:</p><p><b>{$a}</b></p><p>Ak to teraz začnete, už sa nemôžete vrátiť späť.</p><p>Naozaj chcete povýšiť tento server na túto verziu?</p>';
$string['upgradetimedout'] = 'Aktualizácia trvala príliš dlho a bola zastavená. Reštartujte ju.';
$string['upgradingdata'] = 'Údaje sa aktualizujú';
$string['upgradinglogs'] = 'Záznamy sa aktualizujú';
$string['upgradingversion'] = 'Aktualizácia na novú verziu';
$string['upwards'] = 'a vyššie';
$string['useblogassociations'] = 'Povoliť prepojenia';
$string['useexternalyui'] = 'Použiť online YUI knižnice';
$string['user'] = 'Používateľ';
$string['userbulk'] = 'Hromadné operácie s používateľmi';
$string['userlist'] = 'Prechádzať zoznam používateľov';
$string['userpolicies'] = 'Zásady správy používateľov';
$string['userpreference'] = 'Preferencie používateľa';
$string['userquota'] = 'Používateľská kvóta';
$string['users'] = 'Používatelia';
$string['usetags'] = 'Zapnúť funkcionalitu tagov';
$string['validateerror'] = 'Táto hodnota nie je validná:';
$string['verifychangedemail'] = 'Obmedziť domény pri zmene mailu';
$string['warningcurrentsetting'] = 'Nesprávna súčasná hodnota: {$a}';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Vyplňte nasledujúce nastavenia, ak váš Moodle server nemôže priamo pristupovať na Internet. Internetový prístup je potrebný pre sťahovanie informácií o prostredí, jazykové balíčky, RSS údaje, časové pásma a podobne. <br /><em>Doporučuje sa PHP rozšírenie cURL.</em>';
$string['xmlrpcrecommended'] = 'Pre hub komunikáciu je treba nainštalovať voliteľnú knižnicu xlmrpc. Je tiež vhodná pre web služby a Moodle siete.';
$string['yuicomboloading'] = 'Nahráva sa Yui combo';
$string['ziprequired'] = 'Moodle v súčasnosti vyžaduje PHP zásuvný modul ZIP. Knižnice info-ZIP alebo PclZip už nie sú používané.';
