<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'zh_tw', branch 'MOODLE_26_STABLE'
 *
 * @package   data
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['add'] = '新增條目';
$string['addcomment'] = '新增評論';
$string['addentries'] = '新增條目';
$string['addtemplate'] = '新增樣板';
$string['advancedsearch'] = '進階搜尋';
$string['allowcomments'] = '允許加註';
$string['alttext'] = '替代文字';
$string['approve'] = '核准';
$string['approved'] = '已批准的';
$string['areacontent'] = '欄位';
$string['ascending'] = '升冪';
$string['asearchtemplate'] = '進階搜尋的樣板';
$string['atmaxentry'] = '您輸入的條目量已經超過允許的上限！';
$string['authorfirstname'] = '作者的名字';
$string['authorlastname'] = '作者的姓氏';
$string['autogenallforms'] = '產生所有預設樣板';
$string['autolinkurl'] = '自動連結網址';
$string['availablefromdate'] = '開始時間';
$string['availabletags'] = '可用的標籤';
$string['availabletags_help'] = '標籤是樣板裡的佔位符號，它將會被資料和其他項目所取代，比如像編輯圖示，當條目被編輯和檢視時。

欄位的格式是[[fieldname]]，而其他標籤的格式是##sometag##。

目前的樣板只可以使用出現在"可用的標籤"清單上的標籤，其餘無效。';
$string['availabletodate'] = '終止時間';
$string['blank'] = '空白';
$string['buttons'] = '按鈕';
$string['bynameondate'] = '填寫者:{$a->name} - {$a->date}';
$string['cancel'] = '取消';
$string['cannotaccesspresentsother'] = '你不能從其他用戶取用預設';
$string['cannotadd'] = '無法添加條目';
$string['cannotdeletepreset'] = '無法刪除預設目錄';
$string['cannotoverwritepreset'] = '不能覆寫預設目錄';
$string['cannotunziptopreset'] = '不能解壓縮到這預設目錄';
$string['checkbox'] = '核選方塊';
$string['chooseexportfields'] = '選擇您想要匯出的欄位：';
$string['chooseexportformat'] = '選擇您想要匯出的格式：';
$string['chooseorupload'] = '選擇檔案';
$string['columns'] = '欄位';
$string['comment'] = '評論';
$string['commentdeleted'] = '評論刪除了';
$string['commentempty'] = '評論是空白的';
$string['comments'] = '評論';
$string['commentsaved'] = '評論儲存了';
$string['commentsn'] = '{$a}個評論';
$string['commentsoff'] = '評論功能沒有被取用';
$string['configenablerssfeeds'] = '這個開關可以啟用所有資料庫的 RSS 資料匯送，但您仍需要在每一個資料庫中以手動方式啟用它。';
$string['confirmdeletefield'] = '您確定要刪除這個欄位？';
$string['confirmdeleterecord'] = '您確定要刪除這一條目？';
$string['confirmdeleterecords'] = '你確定要刪除這些條目？';
$string['csstemplate'] = 'CSS 樣板';
$string['csvfailed'] = '無法從這CSV檔讀取原始資料';
$string['csvfile'] = 'CSV 檔案';
$string['csvimport'] = '匯入 CSV 檔案';
$string['csvimport_help'] = '資料庫條目可以用純文字格式的檔案匯入。

檔案的第一行是一系列的欄位名稱，以逗點隔開。第二行以後就是實際的資料，每一行一筆紀錄(條目)。';
$string['csvwithselecteddelimiter'] = '<acronym title="Comma Separated Values">CSV</acronym> 文字採用的分隔符號：';
$string['data:addinstance'] = '添加一個新資料庫';
$string['data:approve'] = '核准或取消核准條目';
$string['data:comment'] = '撰寫評論';
$string['data:exportallentries'] = '匯出所有資料庫條目';
$string['data:exportentry'] = '匯出一資料庫條目';
$string['data:exportownentry'] = '匯出自己的資料庫條目';
$string['data:exportuserinfo'] = '匯出用戶資訊';
$string['data:managecomments'] = '管理評論';
$string['data:manageentries'] = '管理條目';
$string['data:managetemplates'] = '管理樣板';
$string['data:manageuserpresets'] = '管理所有樣板預設值';
$string['data:rate'] = '評比條目';
$string['data:readentry'] = '讀取條目';
$string['data:viewallratings'] = '檢視所有個人做的原始評比';
$string['data:viewalluserpresets'] = '從所有使用者檢視預設值';
$string['data:viewanyrating'] = '檢視任何人收到的全部評比';
$string['data:viewentry'] = '檢視條目';
$string['data:viewrating'] = '檢視你得到的全部評比';
$string['data:writeentry'] = '撰寫條目';
$string['date'] = '日期';
$string['dateentered'] = '輸入的日期';
$string['defaultfielddelimiter'] = '（預設是逗點字元）';
$string['defaultfieldenclosure'] = '（預設為無）';
$string['defaultsortfield'] = '預設排序欄位';
$string['delcheck'] = '大批刪除勾選方格';
$string['delete'] = '刪除';
$string['deleteallentries'] = '刪除所有條目';
$string['deletecomment'] = '您確定要刪除這個評論';
$string['deleted'] = '已刪除';
$string['deletefield'] = '刪除現有欄位';
$string['deletenotenrolled'] = '刪除未選課者的條目';
$string['deletewarning'] = '您確定要刪除這個預設值？';
$string['descending'] = '降冪';
$string['directorynotapreset'] = '{$a->directory} 不是預設：缺少檔案： {$a->missing_files}';
$string['disapprove'] = '取消核准';
$string['download'] = '下載';
$string['edit'] = '編輯';
$string['editcomment'] = '編輯評論';
$string['editentry'] = '編輯條目';
$string['editordisable'] = '停用編輯器';
$string['editorenable'] = '啟用編輯器';
$string['emptyadd'] = '新增樣板為空白，從預設格式產生...';
$string['emptyaddform'] = '您沒有填入任何欄位！';
$string['entries'] = '條目';
$string['entrieslefttoadd'] = '在您瀏覽其他參與者條目前，您必須增加{$a->entriesleft}更多條目。';
$string['entrieslefttoaddtoview'] = '您必須新增{$a->entriesleft}個以上條目，才能夠看到其他參與者的條目。';
$string['entry'] = '條目';
$string['entrysaved'] = '您的條目已經儲存了';
$string['errormustbeteacher'] = '只有教師身份可以使用這個頁面！';
$string['errorpresetexists'] = '已經有一預設使用這選出的名字';
$string['example'] = '資料庫模組範例';
$string['excel'] = 'Excel';
$string['expired'] = '抱歉，這活動已經在 {$a}關閉，已經無法使用。';
$string['export'] = '匯出';
$string['exportaszip'] = '匯出成zip壓縮格式';
$string['exportaszip_help'] = '這匯出成壓縮檔的功能，允許您儲存樣版和欄位成一個預設壓縮檔，以便下載。然後這壓縮檔可能匯入到另一課程中使用。';
$string['exportedtozip'] = '匯出成暫存的zip壓縮檔...';
$string['exportentries'] = '匯出條目';
$string['exportownentries'] = '只匯出你自己的條目？ ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = '刪除預設值時發生錯誤！';
$string['fieldadded'] = '欄位新增了';
$string['fieldallowautolink'] = '允許自動連結';
$string['fielddeleted'] = '欄位刪除了';
$string['fielddelimiter'] = '欄位分隔字元';
$string['fielddescription'] = '欄位說明';
$string['fieldenclosure'] = '欄位附件';
$string['fieldheight'] = '高度';
$string['fieldheightlistview'] = '列表高度';
$string['fieldheightsingleview'] = '單筆檢視的高度';
$string['fieldids'] = '欄位編號';
$string['fieldmappings'] = '欄位對應';
$string['fieldmappings_help'] = '這一選單讓你從現有的資料庫中保留資料。要保留在一欄位裡的資料，你必須將它對應到這一資料將會出現新欄位上。任何欄位也都可以留空白，這樣將沒有資料拷貝過去。任何舊欄位沒有對應到新欄位上，這欄位將會失去，且資料也會被移除。

你只可以將相同類型的欄位相對應，因此每一下拉選單會有不同的欄位在裡面。還有，必須小心，不可以將一個舊欄位對應到多個新欄位上。';
$string['fieldname'] = '欄位名稱';
$string['fieldnotmatched'] = '這資料庫不認識在你的檔案裡的下列欄位： {$a}';
$string['fieldoptions'] = '選項（每行一個）';
$string['fields'] = '欄位';
$string['fieldupdated'] = '欄位更新了';
$string['fieldwidth'] = '寬度';
$string['fieldwidthlistview'] = '列表寬度';
$string['fieldwidthsingleview'] = '單筆檢視的寬度';
$string['file'] = '檔案';
$string['fileencoding'] = '編碼';
$string['filesnotgenerated'] = '並非所有檔案都是產生的： {$a}';
$string['filtername'] = '資料庫自動連結';
$string['footer'] = '頁尾';
$string['forcelinkname'] = '強制為連結取名';
$string['foundnorecords'] = '沒有找到記錄 (<a href="<b>{$a->reseturl}</b>">重設篩選器</a>)';
$string['foundrecords'] = '找到記錄資料： <b>{$a->num}</b>/<b>{$a->max}</b> (<a href="<b>{$a->reseturl}</b>">重設篩選器</a>)';
$string['fromfile'] = '從 zip 壓縮檔案匯入';
$string['fromfile_help'] = '這從壓縮檔匯入的功能，讓你能瀏覽並上傳一個樣板和欄位的預設壓縮檔。';
$string['generateerror'] = '不是所有的檔案被產生!';
$string['header'] = '頁首';
$string['headeraddtemplate'] = '定義編輯條目的介面';
$string['headerasearchtemplate'] = '訂定進階搜尋的介面';
$string['headercsstemplate'] = '定義其他樣板的本地端 CSS 風格';
$string['headerjstemplate'] = '為其他樣板自訂 Javascript';
$string['headerlisttemplate'] = '定義多筆條目的瀏覽介面';
$string['headerrsstemplate'] = '定義在RSS匯送的條目顯示方式';
$string['headersingletemplate'] = '定義單一條目的瀏覽介面';
$string['importentries'] = '匯入條目';
$string['importsuccess'] = '成功套用預設值。';
$string['includeapproval'] = '包含批准狀態';
$string['includetime'] = '包含增加時間、修改時間';
$string['includeuserdetails'] = '包含使用者詳情';
$string['insufficiententries'] = '需要有更多的條目才能檢視這個資料庫';
$string['intro'] = '簡介';
$string['invalidaccess'] = '這一頁面沒有被正確地存取';
$string['invalidfieldid'] = '欄位編號不正確';
$string['invalidfieldname'] = '請選擇另一個欄位名稱';
$string['invalidfieldtype'] = '欄位類型不正確';
$string['invalidid'] = '不正確的資料編號';
$string['invalidpreset'] = '{$a}不是預設樣版';
$string['invalidrecord'] = '不正確的紀錄';
$string['invalidurl'] = '輸入的網址無效';
$string['jstemplate'] = 'Javascript樣板';
$string['latitude'] = '緯度';
$string['latlong'] = '緯度/經度';
$string['latlongdownloadallhint'] = '把所有的資料連結下載為KML文件';
$string['latlongkmllabelling'] = '怎樣在KML文件中標出內容（Google Earth）';
$string['latlonglinkservicesdisplayed'] = '連結外部服務來顯示';
$string['latlongotherfields'] = '其他欄位';
$string['list'] = '檢視清單';
$string['listtemplate'] = '列出樣板';
$string['longitude'] = '經度';
$string['mapexistingfield'] = '對應到{$a}';
$string['mapnewfield'] = '建立一新欄位';
$string['mappingwarning'] = '所有沒對應新欄位的舊欄位將會遺失，其中的資料也會移除。';
$string['maxentries'] = '條目數的上限';
$string['maxentries_help'] = '最大條目數是指學生在這一活動所允許提交的最高數量。';
$string['maxsize'] = '條目大小的上限';
$string['menu'] = '選單';
$string['menuchoose'] = '選擇...';
$string['missingdata'] = '資料編號或物件必須提供欄位群';
$string['missingfield'] = '錯誤：當你定義欄位群時，你必須指明欄位和/或資料。';
$string['modulename'] = '資料庫';
$string['modulename_help'] = '資料庫活動模組能讓參與者建立、維護和搜尋一大堆的條目(紀錄)。這些條目的建構是由教師以一些欄位來定義。欄位類型包括：核選方塊欄位、單選按鈕欄位、下拉選單欄位、文字區域、網址欄位、圖片欄位、上傳檔案欄位。

當參與者在列表、檢視、或編輯資料庫條目時，訊息的視覺版面設計是可以由資料庫樣版來控制。資料庫活動可以透過預設樣板讓不同的課程彼此共用，且教師可以匯入和匯出資料庫條目。

如果資料庫自動鏈結過濾器被啟用，在資料庫的任何條目將會自動鏈結，如果這些字或片語出現在課程的任何部分。

教師可以對條目作評論。條目也可以被澆濕或學生評比(同儕評量)。評比結果可以彙整形成最後分數，被記錄到成績簿上。

資料庫活動可以用於：

*全班合作性的以共同格式蒐集網站鏈結、書籍、參考文獻、CD等。
*用來展示學生的攝影作品、海報、網站或詩詞，讓同儕彼此評論、和觀摩。';
$string['modulenameplural'] = '資料庫';
$string['more'] = '更多';
$string['moreurl'] = '更多網址';
$string['movezipfailed'] = '無法搬移 zip 檔';
$string['multientry'] = '重複的條目';
$string['multimenu'] = '選單（多選）';
$string['multipletags'] = '找到多個標籤！樣板未儲存';
$string['namecheckbox'] = '核選方塊欄位';
$string['namedate'] = '日期欄位';
$string['namefile'] = '檔案欄位';
$string['namelatlong'] = '緯度/經度欄位';
$string['namemenu'] = '選單欄位';
$string['namemultimenu'] = '多重選單欄位';
$string['namenumber'] = '數字欄位';
$string['namepicture'] = '圖片欄位';
$string['nameradiobutton'] = '單選欄位';
$string['nametext'] = '文字欄位';
$string['nametextarea'] = '多行文字欄位';
$string['nameurl'] = '網址欄位';
$string['newentry'] = '新條目';
$string['newfield'] = '建立新欄位';
$string['newfield_help'] = '欄位是資料庫中用來輸入與存放資料的位置。在資料課活動中的每一個條目可以有多種類型的多個欄位，比如，日期欄位，它讓用戶可以從一下拉選單中選擇年、月、日的數字。而圖片欄位，它允許用戶上傳一圖像檔。勾選盒欄位，它允許用戶勾選一或二個選項。

每一欄位必須有獨一無二的名稱，但欄位書名是可有可無的。';
$string['noaccess'] = '您沒有存取這個頁面的權限';
$string['nodefinedfields'] = '新預設值沒有定義欄位！';
$string['nofieldcontent'] = '找不到欄位內容';
$string['nofieldindatabase'] = '目前這個資料庫沒有定義任何欄位。';
$string['nolisttemplate'] = '樣板列表尚未定義';
$string['nomatch'] = '找不到符合的條目！';
$string['nomaximum'] = '沒有上限';
$string['norecords'] = '資料庫中沒有條目';
$string['nosingletemplate'] = '尚未定義單一樣版';
$string['notapproved'] = '條目還未被核准';
$string['notinjectivemap'] = '不是一個可插入的地圖';
$string['notopenyet'] = '抱歉，這一活動要等到{$a}才開始';
$string['number'] = '數量';
$string['numberrssarticles'] = '在RSS彙集中的文章篇數';
$string['numnotapproved'] = '等待中';
$string['numrecords'] = '{$a}筆條目';
$string['ods'] = '<acronym title="OpenDocument Spreadsheet">ODS</acronym> (OpenOffice)';
$string['optionaldescription'] = '簡述（選）';
$string['optionalfilename'] = '檔名（選）';
$string['other'] = '其他';
$string['overrwritedesc'] = '覆蓋這預設，若它已經存在';
$string['overwrite'] = '覆蓋';
$string['overwritesettings'] = '覆蓋現在的設定';
$string['page-mod-data-x'] = '任何資料庫活動模組頁面';
$string['pagesize'] = '每頁顯示的條目數';
$string['participants'] = '參與者';
$string['picture'] = '圖片';
$string['pleaseaddsome'] = '請在下面建立一些欄位或是<a href="{$a}">選擇一個預先定義的集合</a>，再開始。';
$string['pluginadministration'] = '資料庫活動管理';
$string['pluginname'] = '資料庫';
$string['portfolionotfile'] = '匯出到學習歷程檔案，而不是一個檔案(只限 CSV和leap2a格式)';
$string['presetinfo'] = '若儲存為預設值將會發佈這個樣板。這樣其他用戶就可以在他們的資料庫中使用它。';
$string['presets'] = '預設值';
$string['radiobutton'] = '單選按鈕';
$string['recordapproved'] = '條目已核准';
$string['recorddeleted'] = '條目已刪除';
$string['recorddisapproved'] = '不可進入';
$string['recordsnotsaved'] = '沒有資料儲存，請檢查上傳檔案的格式。';
$string['recordssaved'] = '資料儲存了';
$string['requireapproval'] = '需要經過審核';
$string['requireapproval_help'] = '如果啟用，條目需要由教師核准之後，才可以讓每個人看到';
$string['requiredentries'] = '完成這活動所需要輸入的條目數';
$string['requiredentries_help'] = '每一學生需要提交的條目數，達到之後該活動才算完成。';
$string['requiredentriestoview'] = '在檢視之前所需要輸入的條目數';
$string['requiredentriestoview_help'] = '每一學生需要提交該數量的條目之後，才可以看到其他學生的條目。

注意：若要先寫條目才可檢閱他人條目，那資料庫的自動鏈結應該關閉。這是因為資料庫自動連結過濾器無法確認用戶是否有提交足夠數量的條目。';
$string['resetsettings'] = '重設欄位';
$string['resettemplate'] = '重設樣板';
$string['resizingimages'] = '調整縮圖大小...';
$string['rows'] = '列';
$string['rssglobaldisabled'] = '停用，檢視網站設定變數。';
$string['rsstemplate'] = 'RSS樣板';
$string['rsstitletemplate'] = 'RSS標題樣板';
$string['save'] = '儲存';
$string['saveandadd'] = '儲存後新增';
$string['saveandview'] = '儲存後檢視';
$string['saveaspreset'] = '儲存為預設值';
$string['saveaspreset_help'] = '這儲存為預設樣板的功能，可以將樣板和欄位出版成唯一預設樣板，讓網站上的其他人可以使用。(你可以隨時從預設樣板的清單上刪除它)';
$string['savesettings'] = '儲存設定';
$string['savesuccess'] = '儲存成功，您的預設值現在開始可以在網站使用。';
$string['savetemplate'] = '儲存樣板';
$string['search'] = '搜尋';
$string['selectedrequired'] = '所有必要的選擇';
$string['showall'] = '顯示所有條目';
$string['single'] = '檢視單筆';
$string['singletemplate'] = '單一樣版';
$string['subplugintype_datafield'] = '資料庫欄位類型';
$string['subplugintype_datafield_plural'] = '資料庫欄位類型';
$string['subplugintype_datapreset'] = '預設樣板';
$string['subplugintype_datapreset_plural'] = '預設值';
$string['teachersandstudents'] = '{$a->teachers} 與 {$a->students}';
$string['templates'] = '樣板';
$string['templatesaved'] = '樣板儲存了';
$string['text'] = '文字';
$string['textarea'] = '多行文字';
$string['timeadded'] = '新增的時間';
$string['timemodified'] = '修改的時間';
$string['todatabase'] = '到此資料庫。';
$string['type'] = '欄位類型';
$string['undefinedprocessactionmethod'] = '在 Data_Preset 沒有定義動作方法來處理動作 "{$a}"。';
$string['unsupportedexport'] = '(<b>{$a->fieldtype}</b>) 無法匯出。';
$string['updatefield'] = '更新現有欄位';
$string['uploadfile'] = '上傳檔案';
$string['uploadrecords'] = '從一檔案上傳條目';
$string['uploadrecords_help'] = '條目可以經由文字檔上傳。檔案格式必須如下：

*第一筆紀錄包含一系列的欄位名稱，定義了其後的資料格式。
*在第一行之後，每一行代表一筆紀錄(條目)
*每一筆紀錄包含一系列資料，以逗點(或其他分隔符號)隔開，每樣資料都對應第一行的欄位名稱。';
$string['url'] = '網址';
$string['usedate'] = '包含在搜尋中';
$string['usestandard'] = '使用一個預設值';
$string['usestandard_help'] = '要使用一個可用於整個網站的預設樣板，請從這一清單選擇它。(若你曾使用"儲存為預設樣板"的功能來添加預設樣板到這清單上，那你可以選擇是否刪除它)';
$string['viewfromdate'] = '從何時可閱讀';
$string['viewtodate'] = '可閱讀到何時';
$string['wrongdataid'] = '提供的資料編號有誤';
