<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'advmindmap', language 'zh_tw', branch 'MOODLE_26_STABLE'
 *
 * @package   advmindmap
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advmindmap'] = '進階心智圖。';
$string['advmindmap:addinstance'] = '增加一個進階心智圖實例。';
$string['advmindmap:givecomment'] = '給予意見。';
$string['advmindmapintro'] = '進階心智圖介紹。';
$string['advmindmapname'] = '進階心智圖名稱。';
$string['advmindmap:submit'] = '提交。';
$string['advmindmap:view'] = '檢視。';
$string['advmindmap:viewother'] = '檢視他人。';
$string['class'] = '班級。';
$string['classno'] = '班級數目。';
$string['copylink'] = '(按 Ctrl+C 來複製)';
$string['coursemisconf'] = '課程配置錯誤。';
$string['detail'] = '進階心智圖。';
$string['detail_help'] = '<div class="indent">
<p>心智圖是用來代表字眼、想法、任務、或代表其它連結到中心關鍵字、中心想法的項目的一種圖表。.</p>
<table class="advmindmap_help_table">
<tbody>
    <tr>
        <th width="40%">Function</th>
        <th width="60%">Command</th>
    </tr>
    <tr>
        <td>增加節點</td>
        <td>-任意處按二下滑鼠<br />- 點選綠色 "+" 圖示<br />- 按"Insert" key  鍵來增加一個子節點(childnode)</td>
    </tr>
    <tr>
        <td>刪除註記</td>
        <td>- 按 "Ctrl" 鍵並按住節點<br />- 點選紅色 "-"  圖示<br />- 按"Delete" 鍵</td>
    </tr>
    <tr>
        <td>取消/重做</td>
        <td>- 按"Ctrl"+"Z" 鍵或 "Ctrl"+"Y" 鍵<br />-  點選向前或向後的箭頭圖示<br /></td>
    </tr>
    <tr>
        <td>移動節點</td>
        <td>按住節點並拖動</td>
    </tr>
    <tr>
        <td rowspan="1">儲存心智圖</td>
        <td rowspan="1">點選左上角 "disk-like" 圖示</td>
    </tr>
</tbody>
</table>
<p>(心智圖模組最早由 <a href="http://ekpenso.com">的ekpenso.com所開發</a>. 其後由<a href="http://www.cite.hku.hk">的CITE修改</a>.)</p>
</div>';
$string['editable'] = '可編輯。';
$string['editingbyuser'] = '團體心智圖此刻/當時正由<span style="font-weight:bold;">{$a}</span>編輯，因此是鎖住的。';
$string['errorcannotunlockadvmindmap'] = '心智圖不能解開，事例不正確。';
$string['errorcannotviewgroupmindmap'] = '你不被許可看別個團體的心智圖。';
$string['errorcannotviewusermindmap'] = '你不被許可看其它使用者的心智圖。';
$string['errorincorrectcmid'] = '課程模組ID不正確。';
$string['errorinvalidadvmindmap'] = '進階心智圖事例不正確。';
$string['errorinvalidauthor'] = '心智圖作者不是有效的使用者。';
$string['errornostudentincourse'] = '此課程並無學生。';
$string['errornotingroup'] = '此為一群組心智圖，但是你並未參加任一群組，或者你未有許可去檢視其他群組之心智圖。';
$string['errornouseringroup'] = '此群體並無使用者。';
$string['groupmembers'] = '群組組員。';
$string['groupname'] = '群組名稱。';
$string['instances'] = '進階心智圖實例';
$string['invalidid'] = '進階心智圖 ID 不正確';
$string['largeconvas'] = '放大編輯區';
$string['lastupdated'] = '最新更新：';
$string['lockedbyyou'] = '此群組心智圖已為你鎖定。您可按此';
$string['modulename'] = '進階心智圖';
$string['modulenameplural'] = '進階心智圖';
$string['notavailable'] = '仍無法使用';
$string['numdummygroups'] = '虛擬群組之數量';
$string['pluginadministration'] = '進階心智圖管理';
$string['pluginname'] = '進階心智圖';
$string['print'] = '列印';
$string['smallconvas'] = '縮小編輯區';
$string['uneditable'] = '心智圖已可編輯';
$string['uniquelink'] = '連結至心智圖';
$string['unlockbutton'] = '打開鎖定並回到課程';
$string['unlockconfirm'] = '你確定您要打開心智圖鎖定並回到課程(所有未儲存之變動都將消失)?';
$string['unlocktime'] = '預計解除鎖定之時間(如果沒有其他使用者再更新的話)';
$string['viewing'] = '(檢視)';
$string['viewingauthor'] = '檢視{$a}之心智圖';
$string['viewown'] = '檢視你自己的心智圖';
