<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'ru', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Элементы курса';
$string['addcategory'] = 'Добавить категорию';
$string['addcategoryerror'] = 'Не удалось добавить категорию';
$string['addexceptionerror'] = 'Произошла ошибка при добавлении исключения для  userid:gradeitem';
$string['addfeedback'] = 'Добавить отзыв';
$string['addgradeletter'] = 'Добавить букву оценки';
$string['addidnumbers'] = 'Добавить ID';
$string['additem'] = 'Добавить элемент оценивания';
$string['addoutcome'] = 'Добавить показатель';
$string['addoutcomeitem'] = 'Добавить оценку за показатель';
$string['addscale'] = 'Добавить шкалу';
$string['aggregateextracreditmean'] = 'Среднее оценок (с учетом доп. баллов)';
$string['aggregatemax'] = 'Лучшая оценка';
$string['aggregatemean'] = 'Среднее оценок';
$string['aggregatemedian'] = 'Медиана оценок';
$string['aggregatemin'] = 'Худшая оценка';
$string['aggregatemode'] = 'Мода оценок';
$string['aggregateonlygraded'] = 'Учитывать только непустые оценки';
$string['aggregateonlygraded_help'] = 'Пустая оценка, это оценка, которая отсутствует в журнале оценок. Это может произойти, например, из-за того, что задание еще не было оценено или студент еще не приступал к тесту и т.п.

Этот параметр определят, нужно ли учитывать пустые оценки при расчете итоговой. В том случае, если пустые оценки учитываются, вместо пустого значения используется наименьшее возможное значение - так, например, для задания, оцениваемого от 0 до 100 будет выбрано значение 0.';
$string['aggregateoutcomes'] = 'Включать оценки за показатели в итоговую оценку';
$string['aggregateoutcomes_help'] = 'Если параметр включен, оценки по отдельным показателям включаются в расчет итоговой оценки. Это может привести к непредсказуемому результату в категории.';
$string['aggregatesonly'] = 'Только итоги';
$string['aggregatesubcats'] = 'Учитывать оценки из подкатегорий при расчете итоговой';
$string['aggregatesubcats_help'] = 'Этот параметр определяет, используются ли оценки из подкатегорий при расчете итога.';
$string['aggregatesum'] = 'Сумма оценок';
$string['aggregateweightedmean'] = 'Среднее взвешенное оценок';
$string['aggregateweightedmean2'] = 'Простое среднее взвешенное оценок';
$string['aggregation'] = 'Итоговая оценка';
$string['aggregationcoef'] = 'Коэффициент';
$string['aggregationcoefextra'] = 'Дополнительный балл / вес';
$string['aggregationcoefextra_help'] = 'Если итоговая оценка рассчитывается как «Сумма оценок» или как «Простое среднее взвешенное оценок», и установлена отметка в поле «Дополнительный балл / вес», то максимальная оценка за оцениваемый элемент не добавляется к максимальной оценке за категорию, что позволяет получить максимальную оценку (или оценку больше максимальной, если это разрешено администратором сайта) в категории, не получая максимальный балл за каждый из элементов этой категории.

Если итоговая оценка рассчитывается как «Среднее оценок (с учетом доп. баллов)» и значение параметра «Дополнительный балл / вес» больше нуля, то оценка выступает в роли дополнительного балла при расчете итога. «Дополнительный балл / вес» - это множитель на который оценка будет умножаться перед тем как сложить все оценки при вычислении среднего.';
$string['aggregationcoefextrasum'] = 'Дополнительный балл';
$string['aggregationcoefextrasum_help'] = 'Если установлена отметка в поле «Дополнительный балл», то максимальная оценка за оцениваемый элемент не добавляется к максимальной оценке за категорию, что позволяет получить максимальную оценку (или оценку больше максимальной, если это разрешено администратором сайта) в категории, не получая максимальный балл за каждый из элементов этой категории.';
$string['aggregationcoefextraweight'] = 'Вес дополнительного балла';
$string['aggregationcoefextraweight_help'] = 'Если значение параметра «Вес дополнительного балла» больше нуля, то оценка выступает в роли дополнительного балла при расчете итога. «Вес дополнительного балла» - это множитель на который оценка будет умножаться перед тем как сложить все оценки при вычислении среднего.';
$string['aggregationcoefweight'] = 'Вес элемента';
$string['aggregationcoefweight_help'] = 'Вес элемента используется для расчета итога по категории, чтобы указать важность одних элементов в категории по сравнению с другими.';
$string['aggregation_help'] = 'Этот параметр определяет, каким образом рассчитывается итоговая оценка. Возможны варианты:

* Среднее значение - Сумма всех оценок делится на их количество
* Медиана - Выбирается значение, находящееся в середине упорядоченного по возрастанию списка оценок.
* Худшая оценка
* Лучшая оценка
* Мода оценок - Оценка, которая встречается наиболее часто
* Сумма оценок - Сумма значений оценок без учета оценок, выставленных по шкалам.';
$string['aggregationposition'] = 'Расположение итогового столбца';
$string['aggregationposition_help'] = 'Этот параметр определяет расположение в журнале оценок столбцов с итоговыми оценками за категории и за весь курс.';
$string['aggregationsvisible'] = 'Доступные способы расчета итоговой оценки';
$string['aggregationsvisiblehelp'] = 'Выберите все способы расчета итоговой оценки, которые должын быть доступны. Для выбора нескольких элементов нажмите и удерживайте клавишу Ctrl.';
$string['allgrades'] = 'Все оценки по всем категориям';
$string['allstudents'] = 'Все студенты';
$string['allusers'] = 'Все пользователи';
$string['autosort'] = 'Авто-сортировка';
$string['availableidnumbers'] = 'Доступные идентификаторы';
$string['average'] = 'Средняя оценка';
$string['averagesdecimalpoints'] = 'Знаков после запятой в средних значениях';
$string['averagesdecimalpoints_help'] = 'Этот параметр определяет количество десятичных знаков, отображаемых в каждом столбце «Среднее». Если выбрано значение «Наследовать», то будет использоваться значение, установленное для родительской категории';
$string['averagesdisplaytype'] = 'Формат представления средних значений';
$string['averagesdisplaytype_help'] = 'Этот параметр определяет, будет ли среднее отображается в виде числовых оценок, процентов или букв. Если выбрано значение «Наследовать», то будет использоваться значение, установленное для родительской категории.';
$string['backupwithoutgradebook'] = 'Резервная копия не содержит конфигурации журнала оценок';
$string['badgrade'] = 'Указана некорректная оценка';
$string['badlyformattedscale'] = 'Пожалуйста, введите список значений через запятую (требуется указать по меньшей мере два значения).';
$string['baduser'] = 'Указан некорректный пользователь';
$string['bonuspoints'] = 'Премиальные<br />баллы';
$string['bulkcheckboxes'] = 'Флажки для групповых операций';
$string['calculatedgrade'] = 'Вычисляемая оценка';
$string['calculation'] = 'Вычисление';
$string['calculationadd'] = 'Добавить вычисление';
$string['calculationedit'] = 'Редактировать вычисление';
$string['calculation_help'] = 'Вычисление оценки с использованием формулы для определения оценок. Формула должна начинаться со знака равенства (=); могут использоваться общие математические операторы, такие как максимум, минимум и сумма. При желании в расчет могут быть включены другие элементы оценки, при этом их ID номера вводятся в двойных квадратных скобках.';
$string['calculationsaved'] = 'Вычисления сохранены';
$string['calculationview'] = 'Просмотреть вычисления';
$string['cannotaccessgroup'] = 'К сожалению, нет доступа к оценкам выбранной группы.';
$string['categories'] = 'Категории';
$string['categoriesanditems'] = 'Категории и элементы';
$string['categoriesedit'] = 'Редактировать категории и элементы';
$string['category'] = 'Категория';
$string['categoryedit'] = 'Редактировать категорию';
$string['categoryname'] = 'Название категории';
$string['categorytotal'] = 'Итог категории';
$string['categorytotalfull'] = 'Итого в категории «{$a->category}»';
$string['categorytotalname'] = 'Название итога категории';
$string['changedefaults'] = 'Изменить настройки по умолчанию';
$string['changereportdefaults'] = 'Изменить значения по умолчанию для отчета';
$string['chooseaction'] = 'Выберите действие...';
$string['choosecategory'] = 'Выберите категорию';
$string['combo'] = 'Вкладки и выпадающее меню';
$string['compact'] = 'Сжатый';
$string['componentcontrolsvisibility'] = 'Скрыт этот оцениваемый элемент или нет - задается в настройках активного элемента.';
$string['contract'] = 'Категория соглашения';
$string['controls'] = 'Управляющие элементы';
$string['courseavg'] = 'Среднее курса';
$string['coursegradecategory'] = 'Категория оценок курса';
$string['coursegradedisplaytype'] = 'Формат представления оценок курса';
$string['coursegradedisplayupdated'] = 'Формат представления оценок курса был обновлен';
$string['coursegradesettings'] = 'Настройки оценок курса';
$string['coursename'] = 'Название курса';
$string['coursescales'] = 'Шкалы курса';
$string['coursesettings'] = 'Настройки курса';
$string['coursesettingsexplanation'] = 'Параметры настройки оценок курса определяют, как журнал оценок будет выглядеть для всех участников курса.';
$string['coursetotal'] = 'Итоговая оценка за курс';
$string['createcategory'] = 'Создать категорию';
$string['createcategoryerror'] = 'Не удалось создать новую категорию';
$string['creatinggradebooksettings'] = 'Создание настроек Журнала оценок';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Текущий способ расчета итоговой оценки в родительской категории';
$string['curveto'] = 'Привести к';
$string['decimalpoints'] = 'Знаков после запятой';
$string['decimalpoints_help'] = 'Этот параметр определяет количество десятичных знаков при отображении каждой оценки. Это не влияет на вычисление оценок, которые рассчитываются с точностью до 5 десятичных знаков.';
$string['default'] = 'По умолчанию';
$string['defaultprev'] = 'По умолчанию ({$a})';
$string['deletecategory'] = 'Удалить категорию';
$string['disablegradehistory'] = 'Отключить историю оценок';
$string['disablegradehistory_help'] = 'Отключить отслеживание и фиксацию изменений в таблицах, связанных с оценками. Это может немного ускорить сервер  и сэкономить место в базе данных.';
$string['displaylettergrade'] = 'Показать буквенные оценки';
$string['displaypercent'] = 'Показать проценты';
$string['displaypoints'] = 'Показать баллы';
$string['displayweighted'] = 'Показать вес оценок';
$string['dropdown'] = 'Выпадающее меню';
$string['droplow'] = 'Не учитывать худших оценок';
$string['droplow_help'] = 'Этот параметр позволяет не учитывать указанное число самых низких оценок при расчете итоговой оценки.';
$string['dropped'] = 'не учитывается';
$string['dropxlowest'] = 'Не учитывать X<br />худших оценок';
$string['dropxlowestwarning'] = 'Примечание: если вы используете функцию «Не учитывать X худших оценок», то подразумевается, что все элементы в данной категории оцениваются одним и тем же числом баллов каждый. Если баллы отличаются, результат может стать непредсказуемым.';
$string['duplicatescale'] = 'Дублировать шкалу';
$string['edit'] = 'Редактировать';
$string['editcalculation'] = 'Редактировать формулу';
$string['editcalculationverbose'] = 'Редактировать расчет для {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Редактировать отзыв';
$string['editgrade'] = 'Редактировать оценку';
$string['editgradeletters'] = 'Редактировать буквенные оценки';
$string['editoutcome'] = 'Редактировать показатель';
$string['editoutcomes'] = 'Редактировать показатели';
$string['editscale'] = 'Редактировать шкалу';
$string['edittree'] = 'Категории и элементы';
$string['editverbose'] = 'Редактировать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Включить AJAX';
$string['enableajax_help'] = 'Добавляет в журнал оценок AJAX-функциональность, что позволяет упростить и ускорить многие операции. Для работы также необходимо, чтобы в браузере пользователя был включен Javascript.';
$string['enableoutcomes'] = 'Включить показатели';
$string['enableoutcomes_help'] = 'Использование показателей (также известных как компетенции, цели, стандарты и критерии) позволяет оценивать одни и те же элементы по различным показателям (используя одну и ту же или несколько разных шкал). Включение показателей позволяет использовать такой подход к оцениванию в масштабах всего сайта.';
$string['encoding'] = 'Кодировка';
$string['errorcalculationbroken'] = 'Вероятна циклическая ссылка или неверная формула расчета';
$string['errorcalculationnoequal'] = 'Формула должна начинаться со знака «равно» (=1+2)';
$string['errorcalculationunknown'] = 'Некорректная формула';
$string['errorgradevaluenonnumeric'] = 'Получены нечисловые значения минимальной или максимальной оценки для';
$string['errornocalculationallowed'] = 'Для этого элемента не разрешено вычисление оценки';
$string['errornocategorisedid'] = 'Не удалось получить ID «Вне категорий»!';
$string['errornocourse'] = 'Не удалось получить информацию о курсе';
$string['errorreprintheadersnonnumeric'] = 'Получено нечисловое значение для повтора заголовков';
$string['errorsavegrade'] = 'К сожалению,оценку сохранить невозможно.';
$string['errorsettinggrade'] = 'Ошибка сохранения оценки «{$a->itemname}» для пользователя с ID {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Ошибка при обновлении параметра «Учитывать только непустые оценки» для категории с ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Ошибка при обновлении параметра «Включать показатели в итог» для категории с ID {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Ошибка при обновлении параметра «Учитывать оценки из подкатегорий при расчете итоговой» категории с ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Ошибка обновления способа расчета итоговой оценки для категории с ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Ошибка обновления итогового коэффициента (вес или дополнительный балл) элемента оценивания с ID {$a->id}';
$string['excluded'] = 'НЕ оцени-<br />вается';
$string['excluded_help'] = 'Если отмечено, оценка не будет использоваться при расчете итоговых оценок';
$string['expand'] = 'Расширить категорию';
$string['export'] = 'Экспорт';
$string['exportalloutcomes'] = 'Экспортировать все показатели';
$string['exportfeedback'] = 'Включить отзыв в экспорт';
$string['exportonlyactive'] = 'Исключить приостановленных пользователей';
$string['exportonlyactive_help'] = 'Включить в экспорт только реально обучающихся студентов, исключив приостановленных.';
$string['exportplugins'] = 'Плагины экспорта';
$string['exportsettings'] = 'Настройки экспорта';
$string['exportto'] = 'Экспорт в';
$string['extracreditvalue'] = 'Дополнительный балл для {$a}';
$string['extracreditwarning'] = 'Примечание: установка всех элементов категории в качестве дополнительных баллов исключит их из подсчета оценки. Следовательно, в этом случае вообще не будет итоговой оценки.';
$string['feedback'] = 'Отзыв';
$string['feedbackadd'] = 'Добавить отзыв';
$string['feedbackedit'] = 'Редактировать отзыв';
$string['feedbackforgradeitems'] = 'Отзыв для {$a}';
$string['feedback_help'] = 'Это поле позволяет добавить какие-либо комментарии к оценке.';
$string['feedbacks'] = 'Отзывы';
$string['feedbacksaved'] = 'Отзыв сохранен';
$string['feedbackview'] = 'Просмотр отзыва';
$string['finalgrade'] = 'Итоговая оценка';
$string['finalgrade_help'] = 'Если отмечено поле «Переопределить», то оценка может быть добавлена или изменена.';
$string['fixedstudents'] = 'Закрепить столбец студентов';
$string['fixedstudents_help'] = 'Позволяет прокручивать оценки по горизонтали, не теряя при этом из виду столбец студентов, закрепив его.';
$string['forceoff'] = 'Принудительно: Выкл';
$string['forceon'] = 'Принудительно: Вкл';
$string['forelementtypes'] = 'для выбранных {$a}';
$string['forstudents'] = 'Для студентов';
$string['full'] = 'Полный';
$string['fullmode'] = 'Полный вид';
$string['fullview'] = 'Полный вид';
$string['generalsettings'] = 'Общие настройки';
$string['grade'] = 'Оценка';
$string['gradeadministration'] = 'Управление оценками';
$string['gradeanalysis'] = 'Анализ оценок';
$string['gradebook'] = 'Журнал оценок';
$string['gradebookhiddenerror'] = 'В настоящее время все элементы журнала оценок скрыты от студентов';
$string['gradebookhistories'] = 'История оценок';
$string['gradeboundary'] = 'Граница буквенной оценки';
$string['gradeboundary_help'] = 'Этот параметр определяет минимальный процент, при достижении которого будет назначена указанная буквенная оценка.';
$string['gradecategories'] = 'Категории оценок';
$string['gradecategory'] = 'Категория оценки';
$string['gradecategoryonmodform'] = 'Категория оценки';
$string['gradecategoryonmodform_help'] = 'Этот параметр определяет категорию в журнале оценок, в которой  размещаются оценки этого активного элемента.';
$string['gradecategorysettings'] = 'Настройки категорий оценок';
$string['gradedisplay'] = 'Представление оценки';
$string['gradedisplaytype'] = 'Формат представления оценки';
$string['gradedisplaytype_help'] = 'Этот параметр определяет, как оценки отображаются в Журнале оценок и отчетах.

* Значение - фактические оценки
* Процент
* Буква - для представления диапазонов оценок используются буквы или слова';
$string['gradedon'] = 'Оценено: {$a}';
$string['gradeexport'] = 'Экспорт оценок';
$string['gradeexportcustomprofilefields'] = 'Настраиваемые поля профиля в экспортируемой оценке';
$string['gradeexportcustomprofilefields_desc'] = 'Включить эти настраиваемые поля профиля в экспортируемую оценку (разделитель - запятая).';
$string['gradeexportdecimalpoints'] = 'Количество цифр после запятой при экспорте';
$string['gradeexportdecimalpoints_desc'] = 'Количество десятичных цифр, отображаемых при экспорте. Может быть переопределено настройками экспорта.';
$string['gradeexportdisplaytype'] = 'Тип отображения оценок при экспорте';
$string['gradeexportdisplaytype_desc'] = 'Оценки при экспорте могут быть выведены как реальные оценки, в процентах (по отношению к минимальной и максимальной оценке) или как буквы (A, B, C и т.д..). Этот параметр может быть переопределен при экспорте.';
$string['gradeexportuserprofilefields'] = 'Поля профиля пользователя в экспортируемой оценке';
$string['gradeexportuserprofilefields_desc'] = 'Включить эти поля профиля пользователя в экспортируемую оценку (разделитель - запятая).';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Справка по Оценкам';
$string['gradehistorylifetime'] = 'Время жизни истории оценок';
$string['gradehistorylifetime_help'] = 'Этот параметр отвечает за срок хранения истории изменений в таблицах, связанных с оценками. Рекомендуется устанавливать его как можно большим. Если у Вас возникают проблемы с производительностью или ограничено место в базе данных, попробуйте установить меньшее значение.';
$string['gradeimport'] = 'Импорт оценок';
$string['gradeimportfailed'] = 'Ошибка импорта оценок. Подробности:';
$string['gradeitem'] = 'Элемент оценивания';
$string['gradeitemaddusers'] = 'НЕ оценивать';
$string['gradeitemadvanced'] = 'Расширенные параметры элемента оценивания';
$string['gradeitemadvanced_help'] = 'Выделите все элементы, которые должны отображены как расширенные при редактировании элементов оценивания.';
$string['gradeitemislocked'] = 'Этот элемент курса заблокирован в журнале оценок. Изменения, сделанные в оценках этого элемента курса, не будут скопированы в журнал оценок, пока элемент не будет разблокирован.';
$string['gradeitemlocked'] = 'Оценивание заблокировано';
$string['gradeitemmembersselected'] = 'НЕ оцениваются';
$string['gradeitemnonmembers'] = 'Оцениваются';
$string['gradeitemremovemembers'] = 'Оценивать';
$string['gradeitems'] = 'Элементы оценивания';
$string['gradeitemsettings'] = 'Настройки оценок элементов';
$string['gradeitemsinc'] = 'Включаемые оценки';
$string['gradeletter'] = 'Буквенная оценка';
$string['gradeletter_help'] = 'Буквенная оценка: буквы - A, B, C, ... или слова - например, Отлично, Хорошо, Удовлетворительно, ..., используемые для представления диапазонов оценок.';
$string['gradeletternote'] = 'Чтобы удалить буквенную оценку, просто очистите любое из <br />трех текстовых полей данной оценки и нажмите кнопку «Сохранить изменения».';
$string['gradeletters'] = 'Буквенные оценки';
$string['gradelocked'] = 'Оценка заблокирована';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Максимальная оценка';
$string['grademax_help'] = 'Этот параметр определяет максимальную оценку при использовании формата оценки «Значение». Для оценок, связанных с элементами курса, максимальная оценка устанавливается на странице настройки элемента курса.';
$string['grademin'] = 'Минимальная оценка';
$string['grademin_help'] = 'Этот параметр определяет минимальную оценку при использовании формата оценки Значение.';
$string['gradeoutcomeitem'] = 'Оценка элемента показателя';
$string['gradeoutcomes'] = 'Показатели';
$string['gradeoutcomescourses'] = 'Показатели курса';
$string['gradepass'] = 'Проходной балл';
$string['gradepass_help'] = 'Этот параметр определяет минимальную оценку, необходимую для сдачи. Это значение учитывается при отслеживании выполнения элементов или курса;  оценки выше проходного балла выделяются в журнале зеленым цветом, а ниже проходного балла - красным.';
$string['gradepreferences'] = 'Настройки оценок';
$string['gradepreferenceshelp'] = 'Справка по настройками Журнала оценок';
$string['gradepublishing'] = 'Разрешить публикацию';
$string['gradepublishing_help'] = 'Разрешить публикацию в экспорте и импорте: Можно разрешить доступ к файлу с экспортируемыми оценками по URL, без необходимости входить на сайт Moodle. Можно импортировать оценки, получив доступ к такому URL (это означает, что Ваш сайт Moodle может импортировать оценки, опубликованные на другом сайте). По умолчанию, только администраторы могут использовать эту возможность. Пожалуйста, обучите пользователей, прежде чем давать необходимые права другим ролям (расскажите им, что нельзя разглашать полученную ссылку, не следует использовать скачку в несколько потоков, нужно устанавливать ограничение по IP-адресу и т.п.).';
$string['gradereport'] = 'Отчет об оценках';
$string['graderreport'] = 'Отчет по оценкам';
$string['grades'] = 'Оценки';
$string['gradesforuser'] = 'Оценки для пользователя «{$a->user}»';
$string['gradesonly'] = 'Только оценки';
$string['gradessettings'] = 'Настройки оценок';
$string['gradetype'] = 'Тип оценки';
$string['gradetype_help'] = 'Существуют 4 типа оценок:

* Не оценивается - Оценка не выставляется
* Значение - числовое значение с максимумом и минимумом.
* Шкала - Один элемент из списка
* Текст - Только текстовый отзыв

Для расчета итоговой оценки могут использоваться только оценки типа «Значение» и «Шкала». Для оценок, связанных с элементами курса, тип устанавливается на странице настройки элемента курса.';
$string['gradeview'] = 'Посмотреть оценку';
$string['gradewasmodifiedduringediting'] = 'Оценка, выставленная за {$a->itemname} для {$a->username} была проигнорирована, потому что она была совсем недавно обновлена кем-то другим.';
$string['gradeweighthelp'] = 'Справка по весу оценок';
$string['groupavg'] = 'Среднее по группе';
$string['hidden'] = 'Скрыть';
$string['hiddenasdate'] = 'Показывать дату представления вместо скрытых оценок';
$string['hiddenasdate_help'] = 'Если пользователь не может видеть скрытые оценки, то выводить дату их представления вместо « - ».';
$string['hidden_help'] = 'Если установлена отметка, то оценки скрыты от студентов. По желанию может быть установлена дата «Скрыть до», чтобы представить оценки уже после завершения оценивания.';
$string['hiddenuntil'] = 'Скрыть до';
$string['hiddenuntildate'] = 'Скрыть до: {$a}';
$string['hideadvanced'] = 'Скрыть дополнительные настройки';
$string['hideaverages'] = 'Скрыть средние значения';
$string['hidecalculations'] = 'Скрыть вычисления';
$string['hidecategory'] = 'Скрытая<br />кат.';
$string['hideeyecons'] = 'Скрыть иконки «Отображать/скрыть»';
$string['hidefeedback'] = 'Скрыть отзыв';
$string['hideforcedsettings'] = 'Скрыть принудительные настройки';
$string['hideforcedsettings_help'] = 'Не показывать принудительные (заблокированные на уровне сайта) настройки оценивания в пользовательском интерфейсе.';
$string['hidegroups'] = 'Скрыть группы';
$string['hidelocks'] = 'Скрыть блокировки';
$string['hidenooutcomes'] = 'Отобразить показатели';
$string['hidequickfeedback'] = 'Скрыть быстрый отзыв';
$string['hideranges'] = 'Скрыть диапазоны';
$string['hidetotalifhiddenitems'] = 'Скрывать итоги, если они зависят от скрытых элементов';
$string['hidetotalifhiddenitems_help'] = 'Этот параметр определяет, будут ли итоги, зависящие от скрытых оценок, отображаться студентам или будут заменяться дефисом (-). Если будут отображаться, то итоговая оценка может быть рассчитана либо с учетом, либо без учета скрытых элементов.

Если скрытые элементы будут исключены из расчета итоговой оценки, то оценка, отображаемая преподавателю в журнале, будет отличаться от отображаемой студенту, так как преподаватель всегда видит итоги, рассчитываемые из всех элементов, скрытых или не скрытых. Если скрытые элементы включаются в расчет, то студенты, возможно, смогут вычислить значения скрытых элементов.';
$string['hidetotalshowexhiddenitems'] = 'Выводить итоги без учета скрытых элементов';
$string['hidetotalshowinchiddenitems'] = 'Выводить итоги с учетом скрытых элементов';
$string['hideverbose'] = 'Скрыть {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Сортировать по возрастанию наибольшей оценки';
$string['highgradedescending'] = 'Сортировать по убыванию наибольшей оценки';
$string['highgradeletter'] = 'Максимум';
$string['identifier'] = 'Определение пользователя';
$string['idnumbers'] = 'Идентификаторы';
$string['ignore'] = 'Игнорировать';
$string['import'] = 'Импорт';
$string['importcsv'] = 'Импорт CSV';
$string['importcustom'] = 'Импортировать как локальные показатели (только для этого курса)';
$string['importerror'] = 'Произошла ошибка, этот скрипт был вызван с некорректными параметрами.';
$string['importfailed'] = 'Импорт не удался. Данные не были импортированы.';
$string['importfeedback'] = 'Импортировать отзывы';
$string['importfile'] = 'Импортировать файл';
$string['importfilemissing'] = 'Файл не был получен, вернитесь назад к форме и убедитесь, что загружаете правильный файл.';
$string['importfrom'] = 'Импорт из';
$string['importoutcomenofile'] = 'Загруженный файл пуст или поврежден. Пожалуйста, проверьте, что это корректный файл. В строке {$a} была обнаружена проблема; она вызвана данными в строке, в которой число столбцов отличается от числа в первой строке (строке заголовка) или в файле вовсе отсутствуют ожидаемые заголовки. В качестве примера корректного файла можно взять экспортированный файл.';
$string['importoutcomes'] = 'Импортировать показатели';
$string['importoutcomes_help'] = 'Показатели можно импортировать из CSV-файла. Формат этого файла такой же, как и при экспорте показателей.';
$string['importoutcomesuccess'] = 'Импортирован показатель «{$a->name}» с ID #{$a->id}';
$string['importplugins'] = 'Плагины импорта';
$string['importpreview'] = 'Предварительный просмотр импорта';
$string['importsettings'] = 'Настройки импорта';
$string['importskippednomanagescale'] = 'Показатель «{$a}» был пропущен, так как для этого требуется создание новой шкалы, а у Вас нет на это прав.';
$string['importskippedoutcome'] = 'Показатель с кратким названием «{$a}» уже существует в этом контексте, поэтому показатель из импортируемого файла был пропущен.';
$string['importstandard'] = 'Импортировать как стандартные показатели';
$string['importsuccess'] = 'Оценки импортированы';
$string['importxml'] = 'Импортировать XML';
$string['includescalesinaggregation'] = 'Включать оценки по шкале в итоговую оценку';
$string['includescalesinaggregation_help'] = 'Вы можете выбрать, включать ли оценки по шкале (в виде чисел) во все итоговые оценки во всех журналах оценок во всех курсах. ВНИМАНИЕ: изменение этого параметра приведет к пересчету всех итоговых оценок.';
$string['incorrectcourseid'] = 'Неверный идентификатор курса';
$string['incorrectcustomscale'] = '(Некорректная локальная шкала; пожалуйста, измените.)';
$string['incorrectminmax'] = 'Минимум должен быть меньше максимума.';
$string['inherit'] = 'Наследовать';
$string['intersectioninfo'] = 'Студент/Оценка';
$string['item'] = 'Элемент';
$string['iteminfo'] = 'Информация';
$string['iteminfo_help'] = 'Место для ввода информации об элементе оценивания. Эта информация больше нигде не отображается.';
$string['itemname'] = 'Название';
$string['itemnamehelp'] = 'Название элемента, установленное модулем.';
$string['items'] = 'Элементы';
$string['itemsedit'] = 'Редактировать элемент оценивания';
$string['keephigh'] = 'Учитывать лучших оценок';
$string['keephigh_help'] = 'Если параметр установлен, то при вычисления итоговой оценки будет учитываться только указанное число лучших оценок';
$string['keymanager'] = 'Управление ключами';
$string['lessthanmin'] = 'Оценка, введенная за элемент «{$a->itemname}» для пользователя «{$a->username}», меньше допустимого минимума';
$string['letter'] = 'Буква';
$string['lettergrade'] = 'Буквенная оценка';
$string['lettergradenonnumber'] = 'Минимальная и/или максимальная оценки нечисловые  для';
$string['letterpercentage'] = 'Буква (процент)';
$string['letterreal'] = 'Буква (значение)';
$string['letters'] = 'Буквы';
$string['linkedactivity'] = 'Связанный элемент курса';
$string['linkedactivity_help'] = 'Этот параметр определяет элемент курса, с которым будет связана оценка за показателю. Это может использоваться для измерения достижений студента с помощью критериев, не связанных с оценкой за элемент курса.';
$string['linktoactivity'] = 'Ссылка на элемент курса «{$a->name}»';
$string['lock'] = 'Блокировка';
$string['locked'] = 'Заблокировано';
$string['locked_help'] = 'Если установлена отметка, то оценки не будут автоматически обновляться из связанного элемента курса.';
$string['locktime'] = 'Заблокировать после';
$string['locktimedate'] = 'Заблокировано после: {$a}';
$string['lockverbose'] = 'Заблокировать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Минимальная';
$string['lowgradeletter'] = 'Минимум';
$string['manualitem'] = 'Заполняемый вручную элемент';
$string['mapfrom'] = 'Взять значение из';
$string['mappings'] = 'Сопоставление данных с элементами оценивания';
$string['mapto'] = 'сопоставить со значением поля';
$string['max'] = 'Наибольшая оценка';
$string['maxgrade'] = 'Максимальная оценка';
$string['meanall'] = 'Все оценки';
$string['meangraded'] = 'Непустые оценки';
$string['meanselection'] = 'Оценки, используемые для подсчета средних';
$string['meanselection_help'] = 'Этот параметр определяет, будет ли пустая ячейка без оценки включена в расчет среднего значения оценки для всех категорий или элементов оценивания.';
$string['median'] = 'Медиана';
$string['min'] = 'Наименьшая оценка';
$string['missingscale'] = 'Необходимо выбрать шкалу';
$string['mode'] = 'Мода';
$string['morethanmax'] = 'Оценка, введенная за элемент «{$a->itemname}» для пользователя «{$a->username}» больше, чем допустимый максимум.';
$string['moveselectedto'] = 'Переместить выбранные элементы в';
$string['movingelement'] = 'Перемещение «{$a}»';
$string['multfactor'] = 'Коэффициент';
$string['multfactor_help'] = 'Коэффициент, на который будут умножены все оценки этого оцениваемого элемента до достижения максимального значения оценки. Например, если коэффициент равен 2, а максимальная оценка 100, то все оценки менее 50 умножаются на 2, а все оценки от 50 и выше изменяются на 100.';
$string['multfactorvalue'] = 'Множитель для {$a}';
$string['mypreferences'] = 'Мои настройки';
$string['myreportpreferences'] = 'Мои настройки отчета';
$string['navmethod'] = 'Метод навигации';
$string['neverdeletehistory'] = 'Никогда не удалять историю';
$string['newcategory'] = 'Новая категория';
$string['newitem'] = 'Новый элемент оценивания';
$string['newoutcomeitem'] = 'Новый элемент показателя';
$string['no'] = 'Нет';
$string['nocategories'] = 'Не удалось добавить или найти категории для данного курса';
$string['nocategoryname'] = 'Не задано название категории.';
$string['nocategoryview'] = 'Нет категорий для отображения';
$string['nocourses'] = 'Пока еще нет ни одного курса';
$string['noforce'] = 'Не устанавливать принудительно';
$string['nogradeletters'] = 'Буквенные оценки не заданы';
$string['nogradesreturned'] = 'Нет оценок';
$string['noidnumber'] = 'Нет идентификатора';
$string['nolettergrade'] = 'Нет буквенных оценок для';
$string['nomode'] = 'Н/О';
$string['nonnumericweight'] = 'Получено нечисловое значение для';
$string['nonunlockableverbose'] = 'Оценка не может быть разблокирована, пока не будет разблокирован элемент «{$a->itemname}»';
$string['nonweightedpct'] = 'невзвешенный %';
$string['nooutcome'] = 'Нет показателя';
$string['nooutcomes'] = 'Оценка за показатель должна быть привязана к одному из показателей курса, но в курсе не определено ни одного показателя. Вы хотите добавить показатель?';
$string['nopublish'] = 'Не публиковать';
$string['norolesdefined'] = 'Нет ролей, определенных в Администрирование > Оценки> Общие настройки> Оцениваемые роли';
$string['noscales'] = 'Показатели должны быть привязаны к шкале курса или к глобальной шкале, но ни одной не существует. Вы хотите добавить шкалу?';
$string['noselectedcategories'] = 'не выбрано ни одной категории.';
$string['noselecteditems'] = 'не выбран ни один элемент.';
$string['notteachererror'] = 'Для использования этой функции Вы должны быть преподавателем.';
$string['nousersloaded'] = 'Не загружено ни одного пользователя';
$string['numberofgrades'] = 'Количество оценок';
$string['onascaleof'] = 'по шкале от {$a->grademin} до {$a->grademax}';
$string['operations'] = 'Операции';
$string['options'] = 'Параметры';
$string['others'] = 'Другие';
$string['outcome'] = 'Показатель';
$string['outcomeassigntocourse'] = 'Назначить другой показатель для этого курса';
$string['outcomecategory'] = 'Создать показатели в категории';
$string['outcomecategorynew'] = 'Новая категория';
$string['outcomeconfirmdelete'] = 'Вы уверены, что хотите удалить показатель «{$a}»?';
$string['outcomecreate'] = 'Добавить новый показатель';
$string['outcomedelete'] = 'Удалить показатель';
$string['outcomefullname'] = 'Полное название';
$string['outcome_help'] = 'Этот параметр определяет, результат по какому из показателей будет представлен в журнале оценок для этого элемента оценивания.';
$string['outcomeitem'] = 'Элемент показателя';
$string['outcomeitemsedit'] = 'Редактировать элемент показателя';
$string['outcomereport'] = 'Отчет по показателям';
$string['outcomes'] = 'Показатели';
$string['outcomescourse'] = 'Показатели, используемые в курсе';
$string['outcomescoursecustom'] = 'Локальные используемые (нельзя удалить)';
$string['outcomescoursenotused'] = 'Стандартные неиспользуемые';
$string['outcomescourseused'] = 'Стандартные используемые (нельзя удалить)';
$string['outcomescustom'] = 'Локальные показатели';
$string['outcomeshortname'] = 'Краткое название';
$string['outcomesstandard'] = 'Стандартные показатели';
$string['outcomesstandardavailable'] = 'Доступные стандартные показатели';
$string['outcomestandard'] = 'Стандартный показатель';
$string['outcomestandard_help'] = 'Стандартный показатель доступен на всём сайте, во всех курсах.';
$string['overallaverage'] = 'Общее среднее';
$string['overridden'] = 'Переопределена';
$string['overridden_help'] = 'Если установлена отметка, то оценка больше не может быть изменена связанным элементом курса.

Когда оценка редактируется в журнале оценок, поле «Переопределена» отмечается автоматически. Однако эта отметка может быть снята, чтобы позволить изменять оценку из соответствующего элемента курса.';
$string['overriddennotice'] = 'Ваша итоговая оценка за этот элемента курса была скорректирована вручную.';
$string['overridesitedefaultgradedisplaytype'] = 'Разрешить переопределять настройки сайта по умолчанию';
$string['overridesitedefaultgradedisplaytype_help'] = 'Если установлена отметка, то помимо установленных на сайте, в курсе можно задавать собственные границы для буквенных оценок.';
$string['parentcategory'] = 'Родительская категория';
$string['pctoftotalgrade'] = '% итоговой<br />оценки';
$string['percent'] = 'Проценты';
$string['percentage'] = 'Проценты';
$string['percentageletter'] = 'Процент (буква)';
$string['percentagereal'] = 'Процент (значение)';
$string['percentascending'] = 'Сортировать по возрастанию процентов';
$string['percentdescending'] = 'Сортировать по убыванию процентов';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Прибавка';
$string['plusfactor_help'] = 'Число, которое будет добавлено к каждой оценке этого элемента после умножения на коэффициент.';
$string['plusfactorvalue'] = 'Недопустимое значение для {$a}';
$string['points'] = 'Баллы<br />';
$string['pointsascending'] = 'Сортировать по возрастанию баллов';
$string['pointsdescending'] = 'Сортировать по убыванию баллов';
$string['positionfirst'] = 'В начале';
$string['positionlast'] = 'В конце';
$string['preferences'] = 'Настройки';
$string['prefgeneral'] = 'Основные';
$string['prefletters'] = 'Буквы и границы оценок';
$string['prefrows'] = 'Специальные столбцы';
$string['prefshow'] = 'Показать/спрятать переключатели';
$string['previewrows'] = 'Строк предпросмотра';
$string['profilereport'] = 'Отчет по профилю пользователя';
$string['profilereport_help'] = 'Отчет об оценках, используемый на странице профиля';
$string['publishing'] = 'Публикация';
$string['quickfeedback'] = 'Быстрый отзыв';
$string['quickgrading'] = 'Режим быстрой оценки';
$string['quickgrading_help'] = 'Если включен режим быстрой оценки, то при редактировании для каждой оценки отображается поле ввода, что позволяет одновременно редактировать несколько оценок. Изменения сохраняются при нажатии кнопки «Обновить».

Имейте в виду, что когда оценка редактируется в журнале оценок, то устанавливается флаг «Переопределена», это означает, что оценка больше не может быть изменена связанным элементом курса.';
$string['range'] = 'Диапазон';
$string['rangedecimals'] = 'Десятичных знаков для диапазона';
$string['rangedecimals_help'] = 'Количество десятичных знаков при отображении диапазона.';
$string['rangesdecimalpoints'] = 'Отображать десятичных знаков для диапазонов';
$string['rangesdecimalpoints_help'] = 'Этот параметр определяет количество десятичных знаков при отображении каждого диапазона. Также возможно использовать параметры, установленные для родительской категории или элемента (наследование).';
$string['rangesdisplaytype'] = 'Формат представления диапазона';
$string['rangesdisplaytype_help'] = 'Этот параметр определяет, будет ли диапазон отображаться в виде числовых оценок, процентов или букв. Также можно у использовать (унаследовать) значение, установленное для родительской категории или элемента.';
$string['rank'] = 'Место';
$string['rawpct'] = '% выпол-<br />нения';
$string['real'] = 'Значение';
$string['realletter'] = 'Значение (буква)';
$string['realpercentage'] = 'Значение (процент)';
$string['recovergradesdefault'] = 'По умолчанию восстанавливать оценки';
$string['recovergradesdefault_help'] = 'По умолчанию восстанавливать старые оценки при повторной записи пользователя на курс';
$string['regradeanyway'] = 'Переоценить в любом случае';
$string['removeallcoursegrades'] = 'Удалить все оценки';
$string['removeallcourseitems'] = 'Удалить все элементы и категории';
$string['report'] = 'Отчет';
$string['reportdefault'] = 'По умолчанию ({$a})';
$string['reportplugins'] = 'Плагины отчетов';
$string['reportsettings'] = 'Настройки отчетов';
$string['reprintheaders'] = 'Повтор заголовков';
$string['respectingcurrentdata'] = 'не изменять текущую конфигурацию';
$string['rowpreviewnum'] = 'Строк предпросмотра';
$string['savechanges'] = 'Сохранить изменения';
$string['savepreferences'] = 'Сохранить настройки';
$string['scaleconfirmdelete'] = 'Вы уверены, что хотите удалить шкалу «{$a}»?';
$string['scaledpct'] = 'Масштабируемый %';
$string['seeallcoursegrades'] = 'Просмотреть все оценки курса';
$string['select'] = 'Выберите {$a}';
$string['selectalloroneuser'] = 'Выберите одного или всех пользователей';
$string['selectauser'] = 'Выберите пользователя';
$string['selectdestination'] = 'Выбрать назначение для «{$a}»';
$string['separator'] = 'Разделитель';
$string['sepcolon'] = 'Двоеточие';
$string['sepcomma'] = 'Запятая';
$string['sepsemicolon'] = 'Точка с запятой';
$string['septab'] = 'Табуляция';
$string['setcategories'] = 'Задать категории';
$string['setcategorieserror'] = 'Вы должны сначала установить категории для своего курса, а потом уже задать им вес.';
$string['setgradeletters'] = 'Задать буквенные оценки';
$string['setpreferences'] = 'Настройки';
$string['setting'] = 'Установка';
$string['settings'] = 'Настройки';
$string['setweights'] = 'Задать веса';
$string['showactivityicons'] = 'Показывать значки элементов курса';
$string['showactivityicons_help'] = 'Если параметр включен, то значки рядом с названиями элементов курса отображаются соответствующие значки.';
$string['showallhidden'] = 'Отображать скрытые';
$string['showallstudents'] = 'Отобразить всех студентов';
$string['showanalysisicon'] = 'Отображать значок анализа оценок';
$string['showanalysisicon_desc'] = 'Показывать ли по умолчанию значок анализа оценки. Если модуль элемента курса позволяет это, то ссылка значка анализа оценки будет вести на страницу с более подробной информацией о полученной оценке.';
$string['showanalysisicon_help'] = 'Если модуль элемента курса позволяет это, то ссылка значка анализа оценки будет вести на страницу с более подробной информацией о полученной оценке.';
$string['showaverage'] = 'Отображать среднее';
$string['showaverage_help'] = 'Показывать столбец среднего значения? Студенты могут предположить оценки других студентов, если среднее значение рассчитывается исходя из небольшого количества оценок. Для повышения производительности среднее вычисляется приблизительно, если оно зависит от скрытых элементов.';
$string['showaverages'] = 'Отображать столбцы средних значений';
$string['showaverages_help'] = 'Если параметр включен, журнал оценок будет содержать дополнительные строки со средними значениями для каждой категории и элемента.';
$string['showcalculations'] = 'Отображать вычисления';
$string['showcalculations_help'] = 'Если параметр включен, то при редактировании у каждого элемента и категории отображается значок калькулятора со всплывающей подсказками и  являющийся индикатором того, что оценка является вычисляемой.';
$string['showeyecons'] = 'Отображать значки «показать/скрыть»';
$string['showeyecons_help'] = 'Если параметр включен, то при редактировании у каждой оценки отображается значок «показать/скрыть» для управления ее отображением для студента.';
$string['showfeedback'] = 'Отображать отзыв';
$string['showfeedback_help'] = 'Показать столбец отзыва?';
$string['showgrade'] = 'Выводить оценки';
$string['showgrade_help'] = 'Показать столбец оценок?';
$string['showgroups'] = 'Показать группы';
$string['showhiddenitems'] = 'Показ скрытых элементов';
$string['showhiddenitems_help'] = 'Скрывать ли и названия, и оценки для скрытых элементов, или же скрывать только оценки, а названия отображать.

* Отображать скрытые - названия скрытых элементов отображаются, но оценки студентов скрыты.
* Только скрытые до - элементы с установленной датой «Скрыть до» будут полностью скрыты до установленной даты, после чего весь элемент будет отображаться.
* Не отображать - скрытые элементы будут полностью скрыты.';
$string['showhiddenuntilonly'] = 'Только скрытое до';
$string['showlettergrade'] = 'Отображать буквенные оценки';
$string['showlettergrade_help'] = 'Показывать столбец буквенных оценок?';
$string['showlocks'] = 'Отображать блокировки';
$string['showlocks_help'] = 'Если включено, то при редактировании у каждой оценки отображается значок «заблокировано/разблокировано» для управления - может ли оценка автоматически обновляться соответствующим элементом.';
$string['shownohidden'] = 'Не отображать';
$string['shownooutcomes'] = 'Скрыть показатели';
$string['shownumberofgrades'] = 'Показать количество оценок в средних';
$string['shownumberofgrades_help'] = 'Если включено, то количество оценок, используемых для расчета среднего значения отображается в скобках после каждого среднего.';
$string['showonlyactiveenrol'] = 'Показывать только активных учащихся';
$string['showonlyactiveenrol_help'] = 'Этот параметр определяет, будут ли видны в журнале оценок только активные зачисленные пользователи. При включенном параметре приостановленные пользователи не будут отображаться в журнале оценок.';
$string['showpercentage'] = 'Выводить проценты';
$string['showpercentage_help'] = 'Выводить процентное значение оценки за каждый элемент?';
$string['showquickfeedback'] = 'Отображать быстрый отзыв';
$string['showquickfeedback_help'] = 'Если разрешено, то при редактировании к каждой оценке добавляется поле с пунктирной границей для ввода текста отзыва, что позволяет одновременно редактировать отзывы для нескольких оценок. Изменения сохраняются при нажатии кнопки «Обновить».

Учтите, что когда отзыв редактируется в журнале оценок, то для оценки устанавливается флаг «Переопределена», это означает, что оценка больше не может быть изменена связанным элементом курса.';
$string['showrange'] = 'Отображать диапазон';
$string['showrange_help'] = 'Показывать столбец диапазона?';
$string['showranges'] = 'Отображать диапазоны';
$string['showranges_help'] = 'Если параметр включен, то журнал оценок будет содержать дополнительные строки с диапазоном значений для всех категорий и элементов.';
$string['showrank'] = 'Отображать рейтинг';
$string['showrank_help'] = 'Показывать для каждого элемента положение студента по отношению к сокурсникам?';
$string['showuserimage'] = 'Выводить изображения пользователей';
$string['showuserimage_help'] = 'Показывать ли в журнале оценок изображение пользователя рядом с его именем.';
$string['showverbose'] = 'Показать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Отображать вес каждой оценки';
$string['showweight_help'] = 'Показывать столбец «Вес оценки»?';
$string['simpleview'] = 'Простой вид';
$string['sitewide'] = 'По всему сайту';
$string['sort'] = 'сортировка';
$string['sortasc'] = 'Сортировать по возрастанию';
$string['sortbyfirstname'] = 'Сортировать по имени';
$string['sortbylastname'] = 'Сортировать по фамилии';
$string['sortdesc'] = 'Сортировать по убыванию';
$string['standarddeviation'] = 'Стандартное отклонение';
$string['stats'] = 'Статистика';
$string['statslink'] = 'Стат.';
$string['student'] = 'Студент';
$string['studentsperpage'] = 'Студентов на странице';
$string['studentsperpage_help'] = 'Этот параметр определяет количество студентов,  отображаемых на одной странице в журнале оценок.';
$string['studentsperpagereduced'] = 'Снизьте максимальное количество студентов на страницу с {$a->originalstudentsperpage} до {$a->studentsperpage}. Рассмотрите возможность увеличения настройки PHP max_input_vars до {$a->maxinputvars}.';
$string['subcategory'] = 'Нормальная категория';
$string['submissions'] = 'Представления';
$string['submittedon'] = 'Представлено: {$a}';
$string['switchtofullview'] = 'Переключиться к полному виду';
$string['switchtosimpleview'] = 'Переключиться к простому виду';
$string['tabs'] = 'Вкладки';
$string['topcategory'] = 'Верхняя категория';
$string['total'] = 'Итого';
$string['totalweight100'] = 'Общий вес равен 100';
$string['totalweightnot100'] = 'Общий вес не равен 100';
$string['turnfeedbackoff'] = 'Выключить отзыв';
$string['turnfeedbackon'] = 'Включить отзыв';
$string['typenone'] = 'Не оценивается';
$string['typescale'] = 'Шкала';
$string['typescale_help'] = 'Этот параметр определяет шкалу, которая будет использоваться в случае, если параметр «Тип оценки» установлен в значение «Шкала». Шкала для оценок, связанных с элементами курса устанавливается на странице настройки элемента курса.';
$string['typetext'] = 'Текст';
$string['typevalue'] = 'Значение';
$string['uncategorised'] = 'Без категории';
$string['unchangedgrade'] = 'Оценка не изменена';
$string['unenrolledusersinimport'] = 'Этот импорт включает следующие оценки для пользователей, не записанных в настоящее время на этот курс: {$a}';
$string['unlimitedgrades'] = 'Неограниченные оценки';
$string['unlimitedgrades_help'] = 'По умолчанию оценки ограничены максимальным и минимальным значениями оценок элементов. Включение этого параметра снимает это ограничение, и позволяет непосредственно в журнал оценок ввести оценку более 100%. Рекомендуется, чтобы этот параметр переключался в непиковое время, так как все оценки будут пересчитаны, что может привести к высокой нагрузке на сервер.';
$string['unlock'] = 'Разблокировать';
$string['unlockverbose'] = 'Разблокировать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Не используется';
$string['updatedgradesonly'] = 'Экспортировать только новые или обновленные оценки';
$string['uploadgrades'] = 'Загрузить шкалы';
$string['useadvanced'] = 'Использовать дополнительные возможности';
$string['usedcourses'] = 'Используемые курсы';
$string['usedgradeitem'] = 'Используемый элемент оценивания';
$string['usenooutcome'] = 'Не использовать показатели';
$string['usenoscale'] = 'Не использовать шкалу';
$string['usepercent'] = 'Использовать проценты';
$string['user'] = 'Пользователь';
$string['userenrolmentsuspended'] = 'Действие зачисления пользователя на курс заблокировано';
$string['usergrade'] = 'Пользователь «{$a->fullname}» ({$a->useridnumber}), элемент {$a->gradeidnumber}';
$string['userid'] = 'ID пользователя';
$string['usermappingerror'] = 'Ошибка соответствия пользователя: Не удалось найти пользователя с полем {$a->field}, имеющим значение «{$a->value}».';
$string['usermappingerrorcurrentgroup'] = 'Пользователь не является участником текущей группы.';
$string['usermappingerrorusernotfound'] = 'Ошибка соответствия пользователя: Не удалось найти пользователя.';
$string['userpreferences'] = 'Мои настройки';
$string['useweighted'] = 'Использовать веса';
$string['verbosescales'] = 'Подробные шкалы';
$string['viewbygroup'] = 'Группа';
$string['viewgrades'] = 'Просмотр оценок';
$string['warningexcludedsum'] = 'Внимание: исключение оценок из расчета итоговой оценки не совместимо с итоговой оценкой типа «Сумма оценок».';
$string['weight'] = 'вес';
$string['weightcourse'] = 'Использовать взвешенные оценки для курса';
$string['weightedascending'] = 'Сортировать по возрастанию взвешенной суммы';
$string['weighteddescending'] = 'Сортировать по убыванию взвешенной суммы';
$string['weightedpct'] = 'взвешенный %';
$string['weightedpctcontribution'] = 'Взвешенный вклад';
$string['weightorextracredit'] = 'Вес или дополнительный балл';
$string['weights'] = 'Весовые коэффициенты';
$string['weightsedit'] = 'Редактировать весовые коэффициенты и дополнительные баллы';
$string['weightuc'] = 'Вес';
$string['writinggradebookinfo'] = 'Запись настроек Журнала оценок';
$string['xml'] = 'XML';
$string['yes'] = 'Да';
$string['yourgrade'] = 'Ваша оценка';
