<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ru', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Отказано в доступе';
$string['accounts'] = 'Учетные записи';
$string['addcategory'] = 'Добавить категорию';
$string['additionalhtml'] = 'Дополнительный HTML';
$string['additionalhtml_desc'] = 'Эти параметры позволяют указать HTML-код, который необходимо добавить на каждую страницу. Вы можете задать HTML-код, который будет добавлен на странице в тег HEAD, сразу после открывающего тега BODY или непосредственно перед закрывающим тегом BODY.<br />Это позволяет очень легко расположить пользовательские колонтитулы на каждой странице или добавить поддержку сервиса, например Google Analytics и не зависит от выбранной Вами темы.';
$string['additionalhtmlfooter'] = 'Перед закрывающим тегом BODY';
$string['additionalhtmlfooter_desc'] = 'Это содержимое будет добавлено на каждую страницу непосредственно перед закрывающим тегом BODY.';
$string['additionalhtmlhead'] = 'В тег HEAD';
$string['additionalhtmlhead_desc'] = 'Это содержимое будет добавлено в конец тега HEAD для каждой страницы.';
$string['additionalhtml_heading'] = 'Дополнительный HTML-код, добавляемый на каждую страницу.';
$string['additionalhtmltopofbody'] = 'После открывающего тега BODY';
$string['additionalhtmltopofbody_desc'] = 'Это содержимое будет добавлено на каждую страницу сразу после открывающего тега BODY.';
$string['admincategory'] = 'Категория: {$a}';
$string['adminseesall'] = 'Администраторы видят всё';
$string['adminseesallevents'] = 'Администраторы видят все события';
$string['adminseesownevents'] = 'Администратор видит события как простые пользователи';
$string['advancedfeatures'] = 'Расширенные возможности';
$string['allcountrycodes'] = 'Коды доступных стран';
$string['allowbeforeblock'] = 'Начать со списка разрешенных адресов';
$string['allowbeforeblockdesc'] = 'По умолчанию сначала проверяется список заблокированных адресов. Если эта опция включена, адреса будут сначала проверяться по списку разрешенных IP-адресов.';
$string['allowblockstodock'] = 'Разрешить перемещение блоков в док';
$string['allowcategorythemes'] = 'Разрешить темы для категорий';
$string['allowcoursethemes'] = 'Разрешить темы для курсов';
$string['allowediplist'] = 'Список разрешенных IP-адресов';
$string['allowemailaddresses'] = 'Разрешенные почтовые домены';
$string['allowframembedding'] = 'Разрешить внедрение в фрейм';
$string['allowframembedding_help'] = 'Разрешить отображение этого сайта внутри фреймов на других сайтах. По соображениям безопасности включение этого параметра не рекомендуется.';
$string['allowguestmymoodle'] = 'Разрешить гостевой доступ к странице  Мой Moodle';
$string['allowobjectembed'] = 'Разрешить теги EMBED и OBJECT';
$string['allowthemechangeonurl'] = 'Разрешить смену темы в строке адреса';
$string['allowuserblockhiding'] = 'Разрешить пользователям скрывать блоки';
$string['allowuserswitchrolestheycantassign'] = 'Разрешить пользователям без права назначения ролей переключать роли';
$string['allowuserthemes'] = 'Разрешить пользовательские темы';
$string['antivirus'] = 'Антивирус';
$string['appearance'] = 'Внешний вид';
$string['aspellpath'] = 'Путь к aspell';
$string['authentication'] = 'Аутентификация';
$string['authpreventaccountcreation'] = 'Предотвратить создание учетной записи при аутентификации';
$string['authpreventaccountcreation_help'] = 'Во время аутентификации пользователя автоматически создается учетная запись, если таковой еще не существует. Если для аутентификации используется внешняя база данных, такая как LDAP, но Вы хотите ограничить доступ к сайту только пользователям с существующей учетной записью, то следует включить этот параметр. В этом случае новые учетные записи должны быть созданы вручную или через функцию загрузки пользователей. Обратите внимание, что этот параметр не относится к аутентификации MNet.';
$string['authsettings'] = 'Настройки аутентификации';
$string['autolang'] = 'Автоопределение языка';
$string['autologinguests'] = 'Автоматический вход гостем';
$string['availablelicenses'] = 'Доступные лицензии';
$string['availableto'] = 'Доступно для';
$string['backgroundcolour'] = 'Цвет фона (для эффекта прозрачности)';
$string['backups'] = 'Резервные копии';
$string['backup_shortname'] = 'Использовать название курса в имени файла резервной копии';
$string['backup_shortnamehelp'] = 'Использовать название курса в имени файла резервной копии.';
$string['badwordsconfig'] = 'Введите список нецензурных слов через запятую';
$string['badwordsdefault'] = 'Если данный список пуст, то будет использован стандартный список из языкового пакета.';
$string['badwordslist'] = 'Список нецензурных слов';
$string['blockediplist'] = 'Список заблокированных IP-адресов';
$string['blockeditingmenu'] = 'Меню редактирования блока';
$string['blockeditingmenu_desc'] = 'Если параметр включен, то в режиме редактирования значки редактирования блока будут показаны в  выпадающем меню. Это уменьшает содержимое на экране, скрывая значки, пока они не понадобятся.';
$string['blockinstances'] = 'Экземпляров';
$string['blockmultiple'] = 'Многократный';
$string['blockprotect'] = 'Защитить экземпляры';
$string['blockprotect_help'] = 'Если Вы блокируете конкретный тип блока, то никто не сможет добавить или удалить его. (Конечно, можно разблокировать его снова, если нужно отредактировать).

В первую очередь это используется для защиты блоков навигации и настроек, которые очень трудно вернуть обратно при случайном удалении.';
$string['blocksettings'] = 'Управление блоками';
$string['blockunprotect'] = 'Снять защиту';
$string['bloglevel'] = 'Просмотр блогов';
$string['bookmarkadded'] = 'Закладка добавлена.';
$string['bookmarkalreadyexists'] = 'Вы уже добавили эту страницу в закладки.';
$string['bookmarkdeleted'] = 'Закладка удалена.';
$string['bookmarkthispage'] = 'Добавить в избранное';
$string['cacheapplication'] = 'Кэш приложения';
$string['cacheapplicationhelp'] = 'Закэшированные элементы являются общими для всех пользователей и обновляются через заданный интервал времени.';
$string['cachejs'] = 'Кэшировать Javascript';
$string['cachejs_help'] = 'Кэширование Javascript и сжатие значительно повышают скорость загрузки страниц. Настоятельно рекомендуется для рабочих сайтов. Разработчикам, вероятно, стоит отключить эту функцию.';
$string['cacherequest'] = 'Кэш запросов';
$string['cacherequesthelp'] = 'Кэш каждого отдельного пользователя, истекающий после завершения запроса. Предназначен для замены областей, использующих статические данные.';
$string['cachesession'] = 'Кэш сессий';
$string['cachesessionhelp'] = 'Кэш каждого отдельного пользователя на время действия сессии. Предназначен для снижения нагрузки при управлении сессиями.';
$string['cachesettings'] = 'Настройки кэширования';
$string['cachetext'] = 'Время существования текстового кэша';
$string['caching'] = 'Кэширование';
$string['calendarexportsalt'] = 'Зашумление для экспорта календаря';
$string['calendarsettings'] = 'Календарь';
$string['calendartype'] = 'Тип календаря';
$string['calendartype_desc'] = 'Выберите для всего сайта тип календаря по умолчанию. Этот параметр может быть изменен в настройках курса или пользователями в своем личном профиле.';
$string['calendar_weekend'] = 'Выходные';
$string['cannotdeletemodfilter'] = 'Вы не можете удалить «{$a->filter}», так как он является частью модуля «{$a->module}».';
$string['cannotuninstall'] = 'Невозможно удалить {$a}.';
$string['cfgwwwrootslashwarning'] = 'Вы неправильно определили параметр $CFG->wwwroot в файле config.php. Вы указали в конце символ «/». Пожалуйста, удалите его, иначе будут возникать странные ошибки, наподобие <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Вы неправильно определили параметр $CFG->wwwroot в файле config.php. Его значение не соответствует ссылке, которой Вы сейчас пользуетесь для доступа к этой странице. Исправьте это, иначе у Вас будут возникать странные ошибки, наподобие <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'изменить';
$string['checkboxno'] = 'Нет';
$string['checkboxyes'] = 'Да';
$string['choosefiletoedit'] = 'Выберите файл для редактирования';
$string['clamfailureonupload'] = 'При ошибке clam AV';
$string['cleanup'] = 'Очистка';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Ошибка, некорректное значение «{$a->value}» для «{$a->option}»';
$string['cliincorrectvalueretry'] = 'Некорректное значение, пожалуйста, попробуйте заново';
$string['clistatusdisabled'] = 'Состояние: режим технического обслуживания выключен';
$string['clistatusenabled'] = 'Состояние: режим технического обслуживания включен';
$string['clistatusenabledlater'] = 'Состояние: режим технического обслуживания будет включен в {$a}';
$string['clitypevalue'] = 'введите значение';
$string['clitypevaluedefault'] = 'введите значение, нажмите Enter для использования значения по умолчанию ({$a})';
$string['cliunknowoption'] = 'Нераспознанные параметры:
  {$a}
Пожалуйста, воспользуйтесь параметром --help';
$string['cliupgradefinished'] = 'Обновление из командной строки успешно завершено.';
$string['cliupgradenoneed'] = 'Для установленной версии {$a} обновление не требуется. В любом случае, спасибо!';
$string['cliyesnoprompt'] = 'Введите y (обозначает Да) или n (обозначает Нет)';
$string['commentsperpage'] = 'Количество комментариев на странице';
$string['commonfiltersettings'] = 'Общие настройки фильтров';
$string['commonsettings'] = 'Общие настройки';
$string['componentinstalled'] = 'Компонент установлен';
$string['computedfromlogs'] = 'Вычислять из журнала событий, начиная с {$a}.';
$string['condifmodeditdefaults'] = 'Значения по умолчанию используются в форме параметров при создании новых активных элементов или ресурсов.';
$string['confeditorhidebuttons'] = 'Выберите кнопки, которые будут скрыты в HTML-редакторе.';
$string['configallcountrycodes'] = 'Этот список доступных стран будет отображаться в различных местах, например, в профиле пользователя. Если параметр пуст (по умолчанию), то будет использоваться список из файла countries.php стандартного английского языкового пакета. Это список из ISO 3166-1. В противном случае Вы можете указать список разделенных запятыми кодов, например: «RU,UK,FR». Если Вы добавляете сюда новые нестандартные коды, то необходимо добавить их в файлы countries.php английского и своего языкового пакета.';
$string['configallowassign'] = 'Вы можете разрешить пользователю с ролью из первого столбца назначать другим пользователям роли из остальных столбцов';
$string['configallowblockstodock'] = 'Если параметр включен и режим поддерживается выбранной темой, то пользователь может перемещать блоки в специальный док.';
$string['configallowcategorythemes'] = 'Если Вы включите этот параметр, то можно будет устанавливать темы на уровне категорий курсов. Это затронет все дочерние категории и курсы, если у них не установлены свои собственные темы. ПРЕДУПРЕЖДЕНИЕ: Включение тем для категорий может снизить производительность.';
$string['configallowcoursethemes'] = 'Если Вы включите этот параметр, то появится возможность устанавливать курсам их собственные темы. Тема курса преобладает над остальными темами (темами сайта, пользователя или сессии).';
$string['configallowemailaddresses'] = 'Если Вы хотите ограничить все новые адреса электронной почты определенными доменами, перечислите их, разделяя пробелами. Все остальные домены будут запрещены. Чтобы разрешить все дочерние домены, начните название с точки (.), например <strong>ourcollege.edu.ru .gov.ru</strong> (будет разрешена почта с домена ourcollege.edu.ru и всех доменов, заканчивающихся на .gov.ru)';
$string['configallowguestmymoodle'] = 'Открывает гостевой доступ к странице Мой Moodle. Если отключено, то гость перенаправляется на главную страницу сайта.';
$string['configallowobjectembed'] = 'В качестве стандартной меры безопасности, обычным пользователям не разрешается встраивать в свои HTML-страницы мультимедиа (например Flash), используя теги EMBED и OBJECT (хотя это может благополучно сделано при использовании фильтра mediaplugins). Если Вы хотите разрешить использовать эти теги, то включите эту опцию.';
$string['configallowoverride'] = 'Вы можете разрешить людям с ролями в левом столбце переопределять роли из некоторых столбцов';
$string['configallowoverride2'] = 'Выберите, какие роли могут быть замещены каждой ролью в левом столбце. <br/> Примечание: эти параметры относятся только к пользователям, у которых есть право moodle/role:override или moodle/role:safeoverride.';
$string['configallowswitch'] = 'Выберите, к каким ролям пользователь может переключиться, в зависимости от ролей, которые ему назначены. В дополнение к записям в этой таблице, пользователь также должен иметь право переключения ролей (moodle/role:switchroles).<br />Заметьте, что можно переключаться только к тем ролям, у которых есть право просмотра курса (moodle/course:view) и которые не имеют права делать всё (moodle/site:doanything), поэтому некоторые столбцы в этой таблице не доступны.';
$string['configallowthemechangeonurl'] = 'Если параметр включен, то тема может быть изменена путем добавления одного из вариантов:<br />?theme=themename в любой адрес Moodle  (например: mymoodlesite.com/?theme=afterburner ) или <br />&theme=themename в любой внутренний адрес Moodle (например: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Вы хотите позволить пользователям скрывать/отображать блоки на всем сайте? Эта особенности используется Javascript и cookies, для сохранения состояние каждого свернутого блока и затрагивает только собственное представление пользователя.';
$string['configallowuserswitchrolestheycantassign'] = 'По умолчанию пользователям требуется возможность «moodle/role:assign» для переключения к ролям. Включение этого параметра отменяет это требование, в результате чего доступные роли в выпадающем меню «Переключиться к роли...» определяются только параметрами таблицы «Назначить разрешения ролей».
Рекомендуется, чтобы настройки таблицы «Назначить разрешения ролей» не позволяли пользователям перейти к роли с более широкими возможностями, чем у их имеющейся роли.';
$string['configallowuserthemes'] = 'Включение этого параметра разрешит пользователям устанавливать собственные темы. Пользовательские темы преобладают над темой сайта (но не над темой курса).';
$string['configallusersaresitestudents'] = 'Должны ли ВСЕ пользователи рассматриваться как студенты для элементов курса на главной странице сайта? Если Вы ответите «Да», то любому пользователю, подтвердившему учетную запись, будет разрешено участвовать в качестве студента в этих элементах. Если Вы ответите «Нет», то только пользователи, являющиеся участниками по меньшей мере одного курса смогут стать участниками этих элементов главной страницы. Только администраторы и специально назначенные преподаватели могут быть преподавателями для элементов курса главной страницы.';
$string['configauthenticationplugins'] = 'Выберите плагины аутентификации, которые Вы хотите использовать и упорядочите их в соответствие с очередностью проверки.';
$string['configautolang'] = 'Определять язык интерфейса из настроек браузера. Если параметр выключен, то используется язык по умолчанию для сайта.';
$string['configautologinguests'] = 'Должны ли посетители автоматически заходить в курс под учетной записью гостя, если гостевой доступ для курса разрешен?';
$string['configbloglevel'] = 'Этот параметр позволяет ограничить уровень доступности блогов на этом сайте. Обратите внимание, что он определяет права на ПРОСМОТР, а не на публикацию или использование разных типов записей. Также можно полностью отключить блоги.';
$string['configcachetext'] = 'Для больших сайтов или сайтов, которые используют текстовые фильтры эти настройки могут реально увеличить скорость работы. Копии текстов будут храниться в процессе обработки форм на указанное здесь время. Установка слишком маленького времени, конечно, может привести к замедлению работы, но установка слишком большого времени также может привести к трудностям, связанным с обновлениями (например, с новыми ссылками). Выбирайте разумно!';
$string['configcalendarcustomexport'] = 'Разрешить экспортировать пользовательские настройки диапазона дат календаря';
$string['configcalendarexportsalt'] = 'Этот случайный текст применяется для того, чтобы улучшить безопасность «authentication tokens», используемых для экспорта календарей. Заметьте, что все текущие «authentication tokens» станут неработоспособными, если Вы измените эту последовательность.';
$string['configclamactlikevirus'] = 'Обрабатывать файлы как вирусы';
$string['configclamdonothing'] = 'Обрабатывать файлы как нормальные';
$string['configclamfailureonupload'] = 'Что делать в том случае, если Вы некорректно сконфигурировали Clam для сканирования файлов, загружаемых на сервер, или запуск невозможен по неизвестной причине? При выборе «Обрабатывать файлы как вирусы» они будут перемещены в карантинную область, или будут удалены. При выборе «Обрабатывать файлы как нормальные» файлы будут перемещены в папку назначения. В любом случае администраторы будут предупреждены, что Clam потерпел неудачу. Если Вы выбираете «Обрабатывать файлы как вирусы» и по некоторой причине Clam не может запуститься (например, введен неверный путь к Clam), ВСЕ загруженные файлы будут перемещены в указанную карантинную область, или будут удалены. Будьте осторожны с этим параметром.';
$string['configconvertformat'] = 'Если доступны <i>latex</i>, <i>dvips</i> и <i>convert</i>, то изображения создаются в указанном формате. Если их нет, то будет использоваться mimeTeX, который создает GIF-изображения.';
$string['configcookiehttponly'] = 'Этот параметр отвечает за новую функцию PHP 5.2.0 - браузеры получают команду отправлять cookies только при настоящих http-запросах, cookies не должны быть доступны для JavaScript. Это работает не во всех браузерах и, возможно, не полностью совместимо с текущим кодом системы. Однако это позволяет предотвратить некоторые виды XSS-атак.';
$string['configcookiesecure'] = 'Если сервер принимает только https-соединения, то рекомендуется включить установку поля «Secure» в cookies. Если параметр включен, то, пожалуйста, убедитесь, что веб-сервер не отвечает на запросы с http:// или установлено постоянное перенаправление на адрес с https://. Если адрес <em>wwwroot</em> не начинается с https://, то параметр автоматически отключается.';
$string['configcountry'] = 'Если Вы укажете здесь страну, то эта страна будет выбрана по умолчанию для новых учетных записей. Чтобы заставить пользователя выбирать страну, оставьте поле пустым.';
$string['configcourseoverviewfilesext'] = 'Список допустимых расширений для файлов описания курса (перечислить через запятую).';
$string['configcourseoverviewfileslimit'] = 'Максимальное количество файлов, которые могут быть прикреплены к описанию курса.';
$string['configcourserequestnotify'] = 'Введите логин пользователя, оповещаемого о запросах на создание новых курсов.';
$string['configcourserequestnotify2'] = 'Пользователи, которые будут уведомлены при запросе на создание курса. Здесь перечислены только те пользователи, которые могут одобрить запрос на создание курса.';
$string['configcoursesperpage'] = 'Введите количество курсов, отображаемых на одной странице в списке курсов.';
$string['configcourseswithsummarieslimit'] = 'Если количество курсов в списке не превышает указанное, то будут отображаться описания курсов. При большем количестве курсов будет использоваться более простой формат списка без описаний.';
$string['configcronclionly'] = 'Если этот параметр установлен, то cron может быть запущен только из командной строки, а не через веб-интерфейс. Этот параметр отменяет использование указанного ниже пароля для cron.';
$string['configcronremotepassword'] = 'Установка этого параметра означает, что запускать cron через веб-интерфейс можно только указав в URL пароль следующим образом: <pre>http://site.example.com/admin/cron.php?password=пароль</pre> Если это поле оставить  пустым, пароль не потребуется.';
$string['configcurlcache'] = 'Время жизни кэша cURL, в секундах.';
$string['configcustommenuitems'] = 'Здесь Вы можете настроить пользовательское меню, отображаемое в темах. Каждая строка меню состоит из текста, гиперссылки (не обязательно) и всплывающей подсказки (не обязательно), разделенных вертикальной чертой. Вы можете задать уровни структуры с помощью дефисов. Например:
<pre>
Сообщество Moodle|https://moodle.org
-Бесплатная поддержка Moodle|https://moodle.org/support
-Разработка Moodle|https://moodle.org/development
--Документация Moodle|http://docs.moodle.org|Moodle Docs
--Документация немецкого Moodle |http://docs.moodle.org/de|Документация на немецком языке|de
Moodle.com|http://moodle.com/
</pre>';
$string['configdbsessions'] = 'Если параметр включен, то для сохранения информации о текущих сессиях будет использоваться база данных. Внимание! Изменение этого свойства немедленно приведет к выходу из системы всех пользователей (включая и Вас). Если Вы используете MySQL, то, пожалуйста, убедитесь, что значение параметра «max_allowed_packet» в my.cnf (или my.ini) не меньше 4M. Другие механизмы хранения информации о сессиях могут быть настроены непосредственно в файле config.php, информацию можно найти в файле config-dist.php. Этот параметр исчезнет, если Вы настроите механизм хранения информации о сессиях в файле config.php.';
$string['configdebug'] = 'Если Вы включите эту опцию, сообщения об ошибках и предупреждениях PHP будут выводиться на экран чаще.<br />(Полезно только для разработчиков).';
$string['configdebugdisplay'] = 'Если выбрано «Да», то сообщения об ошибках будут отображаться на странице HTML. Это полезно, но обычно портит XHTML, JS, cookies и заголовки HTTP. Если выбрано «Нет» - ошибки будут регистрироваться в файлах «error_log» сервера, что может улучшить процесс отладки. Параметр PHP «error_log» указывает, где именно они будут фиксироваться.';
$string['configdebugpageinfo'] = 'Включите этот параметр, чтобы в нижнем колонтитуле отображалась информация о странице.';
$string['configdebugsmtp'] = 'Разрешить вывод отладочной информации во время отправки почтовых сообщений на SMTP-сервер.';
$string['configdebugvalidators'] = 'Включите эту настройку, если хотите, чтобы в колонтитуле были ссылки на внешние серверы-валидаторы. Возможно, для этого Вам потребуется создать нового пользователя с именем пользователя <em>w3cvalidator</em> и разрешить ему гостевой доступ. Такие изменения могут повлечь несанкционированный доступ к серверу, не включайте на рабочих сайтах!';
$string['configdefaulthomepage'] = 'Этот параметр определяет стартовую страницу для пользователей, вошедших в систему';
$string['configdefaultrequestcategory'] = 'Курсы, созданные по запросу, будут автоматически помещаться в эту категорию.';
$string['configdefaultrequestedcategory'] = 'Категория по умолчанию, в которую будут помещены курсы, созданные по запросу.';
$string['configdefaultuserroleid'] = 'Все вошедшие в систему пользователи получат указанную роль в ДОПОЛНЕНИЕ ко всем другим ролям, которые у них есть. По-умолчанию это роль «Аутентифицированный пользователь». Обратите внимание, что это не будет противоречить другим ролям (если в ролях не используются запреты), это только гарантирует, что все пользователи получат возможности, которые не присваиваются на уровне курсов (создавать записи в блогах, управлять собственным календарем, и т.д.).';
$string['configdeleteincompleteusers'] = 'По истечении этого времени старые, не полностью настроенные учетные записи будут удалены.';
$string['configdeleteunconfirmed'] = 'Если у Вас используется самостоятельная регистрация по электронной почте, то пользователь сможет подтвердить свою учетную запись в течение указанного периода. По окончании этого периода все неподтвержденные учетные записи будут автоматически удалены.';
$string['configdenyemailaddresses'] = 'Чтобы запретить почтовые адреса с определенных доменов, перечислите их здесь через пробел. Все другие домены будут разрешены. Чтобы запретить все дочерние домены, начните название домена с точки (.), например, <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Запретить пользователям изменять изображения в своих профилях.';
$string['configdisplayloginfailures'] = 'Указанные пользователи будут видеть информацию о неудачных попытках входа в систему.';
$string['configdndallowtextandlinks'] = 'Включение или отключение возможности перетаскивать текст и ссылки на страницу курса, наряду с перетаскиванием файлов. Обратите внимание, что перетаскивание текста в Firefox или между разными браузерами ненадежно и может привести к незагрузке данных или повреждению загружаемого текста.';
$string['configdocroot'] = 'Определяет путь к контекстно-зависимой документации Moodle «Документация Moodle для этой страницы», расположенной в нижнем колонтитуле каждой страницы. Если поле оставлено пустым, то ссылки отображаться не будут.';
$string['configdoctonewwindow'] = 'Если Вы включите этот параметр, то ссылки на документацию Moodle будут открываться в новом окне.';
$string['configeditordictionary'] = 'Это значение будет использоваться, если в aspell нет словаря для языка пользователя.';
$string['configeditorfontlist'] = 'Выберите шрифты, которые должны отображаться в выпадающем списке редактора.';
$string['configemailchangeconfirmation'] = 'Требовать подтверждения электронной почты при смене пользователем адреса электронной почты в профиле.';
$string['configenableajax'] = 'Этот параметр определяет использование AJAX  на всем сайте. AJAX необходим для некоторых функций, таких как перетаскивание.';
$string['configenableblogs'] = 'Позволяет всем пользователям сайта иметь на нем собственный блог.';
$string['configenablecalendarexport'] = 'Разрешить экспорт календарей и подписку на календари.';
$string['configenablecomments'] = 'Разрешить комментарии';
$string['configenablecourserequests'] = 'Разрешить любому пользователю отправлять запросы на создание собственных курсов.';
$string['configenabledevicedetection'] = 'Позволяет определять мобильные телефоны, смартфоны, планшеты или устройства по умолчанию (настольные ПК, ноутбуки и т.д.) для применения тем и других особенностей.';
$string['configenablegroupmembersonly'] = 'Если этот параметр включен, то доступ к элементам курса может быть разрешен только членам групп. Это может привести к увеличению нагрузки на сервер. Кроме того, категории в журнале оценок должны быть настроены определенным образом, чтобы скрыть элементы курса от участников - не членов группы.';
$string['configenablemobilewebservice'] = 'Разрешить мобильную веб-службу для  приложения Moodle или других приложений, требующих эту службу. См. дополнительную информацию - {$a}.';
$string['configenablerssfeeds'] = 'При включенном параметре на всем сайте для различных элементов (блоги, форумы, базы данных, глоссарии) могут быть созданы RSS-ленты. Обратите внимание, что RSS-ленты также потребуется включить в настройках конкретных элементов кусров.';
$string['configenablerssfeedsdisabled'] = 'Это не поддерживается, потому что RSS-ленты отключены на всем сайте. Чтобы сделать их доступными, необходимо в режиме Управления изменить настройки.';
$string['configenablerssfeedsdisabled2'] = 'RSS-ленты отключены на уровне сервера. Вам нужно включить их в «Администрирование - Расширенные возможности»';
$string['configenablesafebrowserintegration'] = 'Этот параметр служит для добавления варианта «Требуется Safe Exam Browser» к полю «Безопасность браузера» в форме настройки параметров теста. Дополнительная информация на http://www.safeexambrowser.org/ .';
$string['configenablestats'] = 'При включении этого параметра, служба cron в Moodle будет обрабатывать журнал системных событий и собирать некоторую статистику. В зависимости от нагрузки на Ваш сайт, для этого может потребоваться определенное время. Если Вы включите этот режим, то сможете посмотреть некоторые интересные графики и статистику по каждому из Ваших курсов, а также по всему сайту.';
$string['configenabletrusttext'] = 'По умолчанию система Moodle всегда тщательно очищает загружаемые пользователями тексты от любых потенциально-опасных скриптов и внедренных объектов. Включение доверенного содержимого дает возможность тем пользователям, которым Вы доверяете, защитить эти дополнительные функции своего содержимого от вмешательства. Для этого необходимо включить эту настройку, а затем разрешить возможность «Доверять содержимому» для соответствующей роли пользователя. Тексты, созданные и загруженные такими пользователями будут помечены как доверенные и не будут очищаться в процессе вывода.';
$string['configenablewebservices'] = 'Веб-службы позволяют другим системам подключаться к Moodle и выполнять некоторые операции. Для повышения уровня безопасности эту функцию не следует включать, если Вы ей не пользуетесь.';
$string['configenablewsdocumentation'] = 'Включить автоматическую генерацию документации для веб-служб. Пользователь может получить доступ к документации на странице «Ключи безопасности» {$a}. Там отображается документация только для включенных протоколов.';
$string['configerrorlevel'] = 'Выберите значимость отображаемых PHP предупреждений. Обычно лучше выбрать «Нормальный».';
$string['configexportlookahead'] = 'Сколько наступающих дней включать в экспорт';
$string['configexportlookback'] = 'Сколько прошедших дней включать в экспорт';
$string['configextendedusernamechars'] = 'Включите этот параметр, чтобы студенты могли использовать любые символы в своих логинах (обратите внимание, это не относится к их настоящим именам). По умолчанию этот режим отключен, что позволяет использовать в логинах только цифры, буквы в нижнем регистре, знак подчеркивания (_), дефис (-), точку (.) и символ @.';
$string['configextramemorylimit'] = 'Некоторые скрипты, такие как поиск, резервное копирование/восстановление или cron требуют большего количества памяти. Чем больше размер сайта, тем большее значение следует устанавливать.';
$string['configfilterall'] = 'Фильтрация всех строк, включая заголовки, названия, панель навигации и т.д. Это большей частью полезно при использовании фильтра многоязыкового содержимого, иначе просто возникнет дополнительная нагрузка на Ваш сайт без какой либо выгоды.';
$string['configfiltermatchoneperpage'] = 'Фильтры автосвязывания будут создавать на странице только по одной ссылке в месте первого совпадения с образцом текста. Все остальные совпадения будут пропущены.';
$string['configfiltermatchonepertext'] = 'Фильтры автосвязывания будут создавать в каждом текстовом элементе страницы (например, ресурсе или блоке) только по одной ссылке в месте первого совпадения с образцом текста. Все остальные совпадения будут пропущены. Этот параметр игнорируется, если <i>включен</i> параметр «Фильтр работает до первого совпадения на странице».';
$string['configfilteruploadedfiles'] = 'Обрабатывать ли фильтрами перед выводом на экран - все загруженные HTML и текстовые файлы, только загруженные HTML-файлы или вообще ничего не обрабатывать.';
$string['configforcelogin'] = 'Обычно главная страница сайта и список курсов (но не сами курсы) доступны до входа пользователя в систему. Если Вы хотите заставить пользователей входить в систему, прежде чем совершить ЛЮБОЕ действие, включите этот параметр.';
$string['configforceloginforprofiles'] = 'При включении этого параметра, пользователи должны будут зайти под реальной учетной записью (а не гостем), чтобы просмотреть профиль любого пользователя. Если отключить этот параметр, то может оказаться, что некоторые пользователи публикуют в своих, доступных всему миру, профилях рекламу (спам) или другое нежелательное содержимое.';
$string['configfrontpage'] = 'Выбранные выше элементы будут отображаться на главной странице сайта.';
$string['configfrontpagecourselimit'] = 'Максимальное количество курсов';
$string['configfrontpagecourselimithelp'] = 'Максимальное количество курсов, отображаемых в списке курсов на главной странице сайта.';
$string['configfrontpageloggedin'] = 'Выбранные выше элементы будут отображаться на главной странице сайта после входа пользователя в систему.';
$string['configfullnamedisplay'] = 'Этот параметр определяет как будет выглядеть полное имя пользователя. При выборе значения по умолчанию «language», формат полного имени пользователя будет определяться значением строки «fullnamedisplay» текущего языкового пакета. В разных языках есть разные соглашения о формате полного имени.

Для большинства сайтов на одном языке лучше всего подойдет значение «firstname lastname» (Имя Фамилия), но можно, например, вообще скрыть фамилии. Подстановки, которые можно использовать в этом поле: firstname - имя, lastname - фамилия, middlename - отчество, alternatename - альтернативное имя, firstnamephonetic - фонетическая запись имени, lastnamephonetic - фонетическая запись фамилии.';
$string['configgeoipfile'] = 'Расположение двоичного файла данных GeoIP City. Этот файл не распространяется вместе с Moodle и должен быть получен отдельно, от <a href="http://www.maxmind.com/"> MaxMind</a>. Вы можете купить коммерческую версию или использовать бесплатную.<br /> Просто скачайте файл <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz">http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> и распакуйте его в каталог «{$a}» своего сервера.';
$string['configgetremoteaddrconf'] = 'Если Ваш сервер находится за реверсивным прокси-сервером, этот параметр указывает, какой именно из заголовков HTTP содержит IP-адрес удаленного компьютера. Заголовки просматриваются в указанном порядке, используется первый доступный.';
$string['configgradebookroles'] = 'Этот параметр позволяет Вам выбрать тех, кто будет отображаться в журнале оценок. В журнале будут отображаться пользователи, которым назначена хотя бы одна из этих ролей.';
$string['configgradeexport'] = 'Выберите основные форматы экспорта оценок из журнала. Указанные плагины будут использовать и изменять поле «last exported» каждой оценки. В результате этого при экспорте некоторые оценки могут быть отмечены как новые, а некоторые как обновленные. Если Вы не знаете, о чём идет речь, то ничего не отмечайте.';
$string['confighiddenuserfields'] = 'Выберите, какие поля профиля пользователя должны быть доступны только учителям и администраторам. Это позволит сделать информации о студентах более конфиденциальной. Для выбора нескольких полей удерживайте клавишу CTRL.';
$string['configidnumber'] = 'Этот параметр определяет варианты: (a)- Не просить пользователей вводить ID-номер; (b)- Пользователя просят ввести ID, но он может оставить это поле пустым; (c)- Пользователя просят ввести ID и он должен его ввести. Если ID указан, то он отображается в профиле пользователя.';
$string['configintro'] = 'На этой странице можно настроить большое число параметров конфигурации, чтобы Ваша система Moodle работала должным образом. Не беспокойтесь, настройки по умолчанию подходят в большинстве случаев. Вы всегда сможете вернуться на эту страницу позже и изменить эти параметры.';
$string['configintroadmin'] = 'На этой странице Вам необходимо настроить учетную запись основного администратора, имеющего полный контроль над сайтом. Убедитесь, что Вы указали безопасный логин и пароль, а также корректный адрес электронной почты. Позже Вы сможете добавить других администраторов.';
$string['configintrosite'] = 'На этой странице Вы можете настроить внешний вид главной страницы и указать название Вашего сайта. Вы всегда сможете вернуться на эту страницу через меню «Администрирование».';
$string['configiplookup'] = 'Когда Вы нажимаете на IP-адрес (типа 34.12.222.93), например, в отчетах - Вам показывают карту с предположением того места, где этот IP расположен. Есть другие аналогичные программы, у всех свои достоинства и недостатки.';
$string['configkeeptagnamecase'] = 'Поставьте отметку, если Вы хотите, чтобы регистр символов сохранялся в тегах в том виде, в как они был введены создавшим их пользователем.';
$string['configlang'] = 'Выберите язык по умолчанию для всего сайта. Пользователи могут переопределить это значение с помощью меню выбора языка или соответствующего параметра в профиле.';
$string['configlanglist'] = 'Если оставить поле пустым, то пользователь сможет выбирать себе любой язык, из загруженных на Ваш сайт. Можно сократить этот список, перечислив через запятую коды нужных языков, например, так: «ru,uk,en».';
$string['configlangmenu'] = 'Выберите, нужно ли отображать меню выбора языка на главной странице, странице входа в систему и т.п. Этот параметр не влияет на возможность выбора предпочитаемого языка в профиле пользователя.';
$string['configlangstringcache'] = 'При кэшировании все строки языкового пакета буду компилироваться в файлы в каталоге данных. Если Вы занимаетесь переводом Moodle или правите исходный код системы, то можете отключить эту настройку. В остальных случаях параметр лучше оставить включенным для повышения производительности.';
$string['configlatinexcelexport'] = 'Выберите кодировку для экспорта в Excel.';
$string['configlocale'] = 'Выберите локаль (набор региональных параметров) для всего сайта - это значение будет преобладать над настройками языка и форматом дат из языковых пакетов (кроме названий дней недели в календаре). Данные соответствующей локали должны быть установлены в операционной системе (например, en_US.UTF-8 или es_ES.UTF-8 в Linux). В большинстве случаев это поле следует оставить пустым.';
$string['configloginhttps'] = 'При включении этого параметра, система Moodle будет использовать безопасное https-соединение только для страницы входа в систему (для защиты пароля от перехвата), а после этого вернется к обычному http-соединению для большей производительности. ПРЕДУПРЕЖДЕНИЕ: для этого параметра ТРЕБУЕТСЯ, чтобы на Вашем веб-сервере был включен https-протокол, иначе ВЫ ЗАБЛОКИРУЕТЕ СЕБЕ ВХОД В СИСТЕМУ.';
$string['configloglifetime'] = 'Этот параметр определяет срок хранения записей о действиях пользователей в системном журнале. Более старые записи будут автоматически удаляться. Лучше всего, на всякий случай, сохранять записи как можно дольше. Но если у Вас очень загруженный сервер и есть проблемы с производительностью, можно уменьшить время хранения записей в системном журнале. Не рекомендуется устанавливать значения меньше 30, так как в этом случае может неправильно работать статистика.';
$string['configlookahead'] = 'Интервал отображения предстоящих событий';
$string['configmaxbytes'] = 'Этот параметр ограничивает максимальный размер файлов, загружаемых на этот сервер. Этот параметр ограничен следующими настройками: в PHP - post_max_size и upload_max_filesize, в Apache - LimitRequestBody. В свою очередь, максимальный размер загружаемых файлов может быть ограничен на уровне курса или на уровне модуля. В случае, если будет выбрано значение «Ограничение сервера», то будет использоваться разрешенный сервером максимум.';
$string['configmaxconsecutiveidentchars'] = 'В пароле не должно встречаться больше этого числа последовательных одинаковых символов. Чтобы отключить такую проверку, введите 0.';
$string['configmaxeditingtime'] = 'Этот параметр определяет время, в течение которого пользователь может изменить свои сообщения на форуме, записи в глоссарии и т.п. Обычно используется значение 30 мин.';
$string['configmaxevents'] = 'Число предстоящих событий';
$string['configmaxusersperpage'] = 'Максимальное число пользователей, которые отображаются при выборе пользователем курса, группы, глобальной группы, веб-службы и т.д.';
$string['configmessaging'] = 'Включить систему обмена сообщениями между пользователями на сайте?';
$string['configmessagingallowemailoverride'] = 'Разрешить пользователям получать сообщения по электронной почте на адрес, отличный от адреса электронной почты в их профиле';
$string['configmessagingdeletereadnotificationsdelay'] = 'Можно удалять прочитанные уведомления для экономии места. Через какое время после получения уведомления, оно может быть удалено?';
$string['configmessaginghidereadnotifications'] = 'При просмотре истории сообщений скрывать прочитанные уведомления о событиях (например, о новых сообщения на форуме)';
$string['configminpassworddigits'] = 'В пароле должно быть как минимум столько цифр.';
$string['configminpasswordlength'] = 'Пароль должен состоять по меньшей мере из такого числа символов.';
$string['configminpasswordlower'] = 'В пароле должно быть как минимум столько букв в нижнем регистре.';
$string['configminpasswordnonalphanum'] = 'В пароле должно встречаться как минимум столько символов, не являющихся буквами и цифрами.';
$string['configminpasswordupper'] = 'В пароле должно быть как минимум столько букв в верхнем регистре.';
$string['configmobilecssurl'] = 'CSS файл для изменения внешнего вида сайта для мобильных устройств.';
$string['configmodchooserdefault'] = 'Следует ли по умолчанию выводить диалоговое окно для выбора типа добавляемого элемента курса или ресурса?';
$string['configmycoursesperpage'] = 'Максимальное количество курсов, отображаемое для любого пользователя в списке Мои курсы.';
$string['configmymoodleredirect'] = 'Этот параметр принудительно перенаправляет в Мой Moodle пользователей, не являющихся администраторами, и заменяет верхний уровень сайта на Мой Moodle.';
$string['configmypagelocked'] = 'Этот параметр по умолчанию предотвращает редактирование страницы всеми, кроме администраторов';
$string['confignavcourselimit'] = 'Этот параметр ограничивает количество курсов, отображаемое не вошедшему в систему или не записанному ни на один курс пользователю.';
$string['confignavshowallcourses'] = 'Этот параметр определяет, должны ли пользователи, записанные на какие-то курсы, видеть в блоке навигации кроме элемента «Мои курсы» (список тех курсов, на которые пользователь записан) еще и элемент «Курсы» (полный список курсов).';
$string['confignavshowcategories'] = 'Отображать категории курсов в блоках и панели навигации. Этот параметр не относится к курсам, на которые пользователь записан, эти курсы будут перечислены в пункте «Мои курсы» без разделения на категории.';
$string['confignotifyloginfailures'] = 'При фиксировании неудачных попыток входа в систему есть возможность рассылать уведомления по электронной почте. Кто должен получать такие уведомления?';
$string['confignotifyloginthreshold'] = 'После какого числа неудачных попыток входа в систему одного пользователя или с одного IP-адреса требуется отправка уведомления? (В том случае, если включены уведомления о неудачных попытках входах в систему)';
$string['confignotloggedinroleid'] = 'Будет считаться, что всем не вошедшим в систему пользователям назначена эта роль в контексте всего сайта. В большинстве случаев подходит роль Гостя, но Вы можете создать роли с большим или меньшим числом прав. Для таких действий, как создание сообщений на форуме, всё-равно требуется, чтобы пользователь вошел в систему.';
$string['configopentogoogle'] = 'Если Вы включите этот параметр, то поисковая машина Google сможет входить на Ваш сайт под учетной записью гостя. Кроме того, люди, переходящие на этот сайт со страницы поиска Google, автоматически войдут в систему под гостевой учетной записью. Заметьте, что такой простой доступ возможен только к тем курсам, которые позволяют гостевой доступ.';
$string['configoverride'] = 'Значение определено в файле config.php';
$string['configpasswordpolicy'] = 'Включение этого параметра заставит систему Moodle проверять пароли пользователей на соответствие политике сложности паролей. Политика паролей определяется указанными ниже параметрами (они будут проигнорированы, если этот параметр не отмечен).';
$string['configpasswordresettime'] = 'Этот параметр задает время, в течение которого необходимо подтвердить запрос на сброс пароля. Обычно используется 30 минут.';
$string['configpathtoclam'] = 'Путь к исполняемому файлу ClamAV. Обычно это /usr/bin/clamscan или /usr/bin/clamdscan. Это необходимо для запуска ClamAV.';
$string['configpathtodu'] = 'Путь к утилите du. Обычно это /usr/bin/du. При использовании этой утилиты страницы, отображающие содержимое папок будут работать значительно быстрее, особенно для папок с большим числом файлов.';
$string['configperfdebug'] = 'При включении этого параметра в нижнем колонтитуле стандартной темы будет выводиться информация о производительности.';
$string['configprofileroles'] = 'Список ролей, которые отображаются в профилях пользователей и на странице участников курса.';
$string['configprofilesforenrolledusersonly'] = 'Для предотвращения злоупотребления спамерами описания профилей пользователей, которые еще не записаны ни на один курс, скрыты. Новые пользователи должны записаться хотя бы на один курс, прежде чем смогут заполнить в профиле поле «Описание».';
$string['configprotectusernames'] = 'По умолчанию на странице восстановления пароля forgot_password.php не выводится никаких подсказок, которые позволили бы угадать чей-то логин или адрес электронной почты.';
$string['configproxybypass'] = 'Список имен узлов сети и IP-адресов (или их частей) для доступа к которым не нужен прокси-сервер (например, «192.168., .mydomain.com»)';
$string['configproxyhost'] = 'Если этот <b>сервер</b> подключается к Интернету через прокси-сервер, то укажите здесь прокси-сервер и порт. В противном случае оставьте поле пустым.';
$string['configproxypassword'] = 'Если для доступа в Интернет через прокси-сервер необходим пароль, укажите его здесь, иначе оставьте поле пустым (требуется расширение PHP cURL).';
$string['configproxyport'] = 'Если этот сервер подключается к интернету через прокси, то укажите здесь его порт прокси-сервера.';
$string['configproxytype'] = 'Тип веб-прокси (для поддержки SOCKS5 требуется PHP5 и расширение cURL).';
$string['configproxyuser'] = 'Если для доступа в Интернет через прокси-сервер необходимо указать логин пользователя, то укажите его здесь, иначе оставьте поле пустым (требуется расширение PHP cURL).';
$string['configquarantinedir'] = 'Если Вы хотите, чтобы ClamAV перемещал зараженные файлы в карантинную папку, то введите ее здесь. Эта папка должна быть доступна на запись веб-серверу. Если оставить поле пустым, указать несуществующую или не доступную для записи папку, то зараженные файлы будут удаляться. Не указывайте косую черту в конце имени папки.';
$string['configrecaptchaprivatekey'] = 'Строка символов, используемых для общения Вашего сервера Moodle с сервером recaptcha. Можно получить для этого сайта, посетив http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Строка символов, ипользуемых для отображения элемента reCAPTCHA в форме самостоятельной регистрации. Генерируется на http://www.google.com/recaptcha';
$string['configrequestcategoryselection'] = 'Разрешить выбор категории при запросе курса.';
$string['configrequestedstudentname'] = 'Слово для студента, используемое в запрашиваемых курсах.';
$string['configrequestedstudentsname'] = 'Слово для студентов, используемое в запрашиваемых курсах.';
$string['configrequestedteachername'] = 'Слово для преподавателя, используемое в запрашиваемых курсах.';
$string['configrequestedteachersname'] = 'Слово для преподавателей, используемое в запрашиваемых курсах.';
$string['configrequiremodintro'] = 'Отключите этот параметр, если Вы не хотите заставлять пользователей вводить описание каждого элемента курса.';
$string['configrunclamavonupload'] = 'Если включить тот параметр, то ClamAV будет использоваться для просмотра всех загружаемых в систему файлов.';
$string['configrunclamonupload'] = 'Запускать ClamAV при загрузке файлов на сервер? Вам нужно ввести корректный путь к ClamAV. (Clam AV - свободный антивирусный сканер, который Вы можете получить с http://www.clamav.net/)';
$string['configsectioninterface'] = 'Интерфейс';
$string['configsectionmail'] = 'Почта';
$string['configsectionmaintenance'] = 'Обслуживание';
$string['configsectionmisc'] = 'Разное';
$string['configsectionoperatingsystem'] = 'Операционная система';
$string['configsectionpermissions'] = 'Права';
$string['configsectionrequestedcourse'] = 'Запросы курса';
$string['configsectionsecurity'] = 'Безопасность';
$string['configsectionstats'] = 'Статистика';
$string['configsectionuser'] = 'Пользователь';
$string['configsecureforms'] = 'Система может использовать дополнительный уровень безопасности при получении данных из web через формы. Если опция включена, то переменная браузера HTTP_REFERER сверяется c текущим адресом формы. В очень немногих случаях это может вызвать проблемы, например, если пользователь использует систему сетевой защиты (например, Zonealarm) сконфигурированную таким образом, чтобы отделять HTTP_REFERER от трафика сети. Симптом - «прилипание» к форме. Если Ваши пользователи имеют проблемы при входе в систему, возможно, следует отключить этот параметр, хотя это может сделатьь ваш сайт более открытым для подбора пароля перебором. Если Вы сомневаетесь, то оставьте параметр включенным.';
$string['configsessioncookie'] = 'Этот параметр позволяет изменить имя cookie, используемого в Moodle для работы с сессиями. Это необязательный параметр, он нужен только, чтобы не возникало путаницы, когда на одном сайте используется несколько копий Moodle.';
$string['configsessioncookiedomain'] = 'Этот параметр позволяет изменить домен из которого принимаются cookies Moodle. Это необходимо при совместном использовании системой Moodle и веб-приложением из другого субдомена информации о сессиях (при использовании некоторых плагинов аутентификации и записи на курсы). <strong> ВНИМАНИЕ: настоятельно не рекомендуется менять значение по умолчанию (пустое) - установка неправильного значения заблокирует все возможности для входа на сайт.</strong>';
$string['configsessioncookiepath'] = 'Если Вам необходимо изменить путь, по которому браузеры будут посылать cookies для Moodle, то укажите здесь соответствующий каталог Вашего сайта. В остальных случаях лучше оставить путь по умолчанию - «/».';
$string['configsessiontimeout'] = 'Если пользователь зашел на сайт и ничего не делает в течении длительного времени (не загружает страницы), то он автоматически выходит из системы (сессия заканчивается). Эта переменная задает время, через которое это должно произойти.';
$string['configshowcommentscount'] = 'Показывать количество комментариев, для этого требуется дополнительный запрос при отображении ссылки на комментарии.';
$string['configshowicalsource'] = 'Показать источник информации для событий импорта календаря';
$string['configshowsiteparticipantslist'] = 'Все эти студенты и преподаватели сайта будут внесены в список участников сайта. Кому будет разрешено видеть этот список участников сайта?';
$string['configsitedefaultlicense'] = 'Лицензия по умолчанию';
$string['configsitedefaultlicensehelp'] = 'Лицензию по умолчанию при публикации материалов на этом сайте';
$string['configsitemaxcategorydepth'] = 'Максимум вложенных категорий';
$string['configsitemaxcategorydepthhelp'] = 'Задает максимальное количество развернутых вложенных категорий при отображении категорий или комбинированного списка.
Категории более низких уровней отображаются в виде ссылок и пользователь может развернуть их, используя AJAX.';
$string['configslasharguments'] = 'Доступ к фалам в системе (изображения, загруженные пользователями файлы и т.д.) осуществляется через скрипт, использующий так называемые «slash arguments». Этот подход существенно упрощает кэширование в браузерах, прокси-серверах и.т.п. К сожалению, этот метод не работает на некоторых PHP-серверах, поэтому, если у Вас возникают проблемы с просмотром загруженных файлов или картинок (например, фотографий пользователей) - отключите этот параметр.';
$string['configsmartpix'] = 'Если включено, то изображения передаются через сценарий PHP, который ищет текущую тему, затем все родительские темы, и потом в папке Moodle/pix. Это уменьшает потребность дублировать файлы изображений в пределах тем, но несколько сказывается на производительности.';
$string['configstartwday'] = 'Начало недели';
$string['configstatsfirstrun'] = 'Этим параметром определяется, записи системного журнала за какой срок будут обработаны при <b>в первом</b> запуске cron для подсчета статистики. Если у Вас нагруженный сервер и используется совместный хостинг, возможно не стоит устанавливать слишком большое значение, поскольку работа cron может быть продолжительной и использовать много ресурсов. (Обратите внимание, что для этого параметра 1 месяц = 28 дней. В генерируемых графиках и отчетах 1 месяц = 1 календарный месяц).';
$string['configstatsmaxruntime'] = 'Обработка статистики может быть весьма интенсивной. Используйте комбинацию этого и следующего полей, чтобы определить, когда запускать процесс и на какую продолжительность времени.';
$string['configstatsmaxruntime2'] = 'Обработка статистики довольно требовательна к ресурсам; задайте максимальное разрешенное время для сбора дневной статистики. Максимальное количество дней, обрабатываемых при одном запуске cron, равно 31.';
$string['configstatsmaxruntime3'] = 'Укажите ограничение времени подсчета статистики за один день, принимая во внимание, что расчет статистики может сильно нагружать сервер. Максимальное число дней, обрабатываемых за один запуск cron, может быть указано ниже.';
$string['configstatsruntimedays'] = 'Укажите ограничения числа дней, обрабатываемых при каждом запуске подсчета статистики. Когда статистика за все дни будет актуальной, будет обрабатываться по одному дню за раз. Поэтому установите это значение в зависимости от нагрузки на Ваш сервер. Уменьшите это значение, если необходимо сократить время работы процессов cron.';
$string['configstatsruntimestart'] = 'В какое время служба cron должна <b>начинать</b> обработку статистики? Если на одном сервере используется несколько сайтов Moodle, укажите для них разные значения.';
$string['configstatsuserthreshold'] = 'Этот параметр определяет минимальное число записанных на курс пользователей необходимое, чтобы курс был учтен при подсчете статистики.';
$string['configstrictformsrequired'] = 'При включенном параметре пользователи не смогут в обязательные поля форм вводить пробел или разрыв строки.';
$string['configstripalltitletags'] = 'Отключите этот параметр, чтобы разрешить использовать HTML-теги в названиях ресурсов и элементов курса.';
$string['configsupportemail'] = 'Чтобы пользователи сайта знали, куда обратиться с вопросами общего характера (например, при возникновении трудностей во время самостоятельной регистрации), укажите здесь <b>адрес электронной почты</b>. Если оставить это поле пустым, пользователям не будет доступна столь полезная информация.';
$string['configsupportname'] = 'Это имя лица, предоставляющего помощь по общим вопросам по электронной почте или через веб-сайт.';
$string['configsupportpage'] = 'Чтобы пользователи сайта знали, куда обратиться с вопросами общего характера (например, при возникновении трудностей во время самостоятельной регистрации), укажите здесь <b>адрес сайта</b>. Если оставить это поле пустым, пользователям не будет доступна никакая ссылка.';
$string['configthemedesignermode'] = 'Обычно для повышения производительности все изображения и таблицы стилей темы кэшируются в браузерах и на сервере в течение очень длительного времени. Если Вы занимаетесь дизайном тем или правкой исходного кода, то, вероятно, следует включить этот режим, чтобы не использовать версии из кэша. Предупреждение: от этого Ваш сайт станет работать медленнее для всех пользователей! Вместо этого можно вручную очистить кэш на странице «Выбор темы».';
$string['configthemelist'] = 'Чтобы разрешить использовать любую допустимую тему, оставьте это поле пустым. Если Вы хотите сократить список доступных тем, перечислите их здесь через запятую (Не используйте пробелы!).
Например, «standard,orangewhite».';
$string['configtimezone'] = 'Здесь можно установить часовой пояс по умолчанию. Этот часовой пояс будет использоваться ПО УМОЛЧАНИЮ при отображении дат и времени, каждый пользователь сможет переопределить этот значение в своем профиле. При выборе здесь значения «Время сервера» будет использовано значение, взятое из операционной системы сервера. При выборе в профиле пользователя значения «Время сервера» будет использовано значение, указанное здесь. Запуск скриптом cron задач по расписанию будет производиться по времени указанного здесь часового пояса.';
$string['configuseblogassociations'] = 'Нужна ли пользователям возможность связывать записи блога с курсами и элементами курсов?';
$string['configuseexternalyui'] = 'Вместо локальных версий использовать онлайн-версии файлов, доступные на серверах Yahoo. ВНИМАНИЕ: Для этого требуется подключение к интернету, иначе на Вашем сайте не будет работать AJAX. Этот параметр не совместим с сайтами, доступными по протоколу https.';
$string['configuserquota'] = 'Ограничение (в байтах) размера области для хранения личных файлов пользователя. {$a->bytes} байт - это {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'При включении этого параметра вместо строки «Страницы сайта» в навигации будет использоваться краткое название сайта';
$string['configusetags'] = 'Разрешить использование тегов (ключевых слов в блогах) на всем сайте?';
$string['configvariables'] = 'Настройка переменных';
$string['configverifychangedemail'] = 'Включить проверку по списку разрешенных и запрещенных доменов при изменении пользователем адреса электронной почты. Если отключить этот параметр, адреса будут проверяться только при создании новых учетных записей.';
$string['configvisiblecourses'] = 'Показывать курсы в скрытых категориях.';
$string['configwarning'] = 'Будьте осторожны, изменяя эти параметры, -неверные значения могут вызывать ряд проблем.';
$string['configyuicomboloading'] = 'Эта параметр отвечает оптимизацию загрузки файлов библиотеки YUI. Для повышения производительности этот параметр стоит включить на рабочих сайтах.';
$string['confirmation'] = 'Подтверждение';
$string['confirmdeletecomments'] = 'Вы уверены в том, что собираетесь удалить комментарии?';
$string['confirmed'] = 'Подтверждено';
$string['convertformat'] = 'Выходной формат утилиты <i>convert</i>';
$string['cookiehttponly'] = 'Устанавливать поле «HttpOnly»';
$string['cookiesecure'] = 'Устанавливать поле «Secure»';
$string['country'] = 'Страна по умолчанию';
$string['coursecontact'] = 'Контакты курса';
$string['coursecontact_desc'] = 'Этот параметр позволяет Вам выбрать тех, кто будет отображаться в описании курса. В описании курса будут отображаться пользователи, которым назначена хотя бы одна из этих ролей.';
$string['courselistshortnames'] = 'Отображать краткие названия курсов';
$string['courselistshortnames_desc'] = 'При включенном параметре в списке курсов краткие названия курсов будут отображаться в дополнение к их полным названиям. При необходимости, расширенные имена курсов могут быть настроены редактированием строки «courseextendednamedisplay» с помощью функции настройки языка.';
$string['coursemgmt'] = 'Управление курсами и категориями';
$string['courseoverview'] = 'Сводка по курсам';
$string['courserequestnotify'] = 'Уведомление о запросе на создание курса';
$string['courserequestnotifyemail'] = 'Пользователь {$a->user} запросил(а) создание нового курса - {$a->link}';
$string['courserequests'] = 'Запросы на создание курсов';
$string['courserequestspending'] = 'Ожидающие рассмотрения запросы на создание курсов';
$string['courses'] = 'Курсы';
$string['coursesperpage'] = 'Курсов на странице';
$string['courseswithsummarieslimit'] = 'Максимальное количество курсов с описанием';
$string['creatornewroleid'] = 'Роль создателя в новом курсе';
$string['creatornewroleid_help'] = 'Если у пользователя, создавшего курс, еще нет права на управление новым курсом, то он получит эту роль в рамках курса.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'Запуск cron только из командной строки';
$string['cronerrorclionly'] = 'Извините, доступ к этой странице через интернет заблокирован администратором.';
$string['cronerrorpassword'] = 'Извините, Вы указали неверный пароль для доступа к этой странице';
$string['cron_help'] = 'Выполнение скрипта обслуживания cron.php позволяет некоторым модулям Moodle выполнять задания по расписанию, например, рассылку копий новых сообщений форума. Запуск скрипта необходимо выполнять регулярно, например, каждые 5 минут.';
$string['cron_link'] = 'admin/cron';
$string['cronremotepassword'] = 'Пароль cron для удаленного доступа';
$string['cronwarning'] = '<a href="cron.php">Скрипт обслуживания cron.php</a> не запускался уже более 24 часов.';
$string['ctyperecommended'] = 'Установка расширения PHP ctype рекомендуется для повышения производительности сайта, в частности если используемые на сайте языки содержат не только латинские символы.';
$string['ctyperequired'] = 'Расширение PHP ctype теперь является обязательным для Moodle, оно позволяет повысить производительность сайта и обеспечить многоязыковую совместимость.';
$string['curlcache'] = 'Время жизни кэша cURL';
$string['curlrecommended'] = 'Рекомендуется установка дополнительной библиотеки cURL для включения функционала Moodle Networking.';
$string['curlrequired'] = 'Расширение PHP cURL необходимо системе Moodle для взаимодействия с внешними хранилищами.';
$string['curltimeoutkbitrate'] = 'Скорость передачи данных при вычислении cURL необходимого времени (в килобитах в секунду)';
$string['curltimeoutkbitrate_help'] = 'Этот параметр используется для расчета соответствующих пауз во время длительных cURL-запросов. Как часть этого расчета выполняется запрос HTTP HEAD для определения размера контента. Значение 0 отключает выполнение этого запроса.';
$string['currenttheme'] = 'Текущая тема';
$string['customcheck'] = 'Другие проверки';
$string['custommenu'] = 'Персональное меню';
$string['custommenuitems'] = 'Элементы персонального меню';
$string['datarootsecurityerror'] = '<p><strong>ВНИМАНИЕ! ОПАСНОСТЬ!</strong></p><p>Ваш каталог dataroot находится в неправильном месте и доступен через интернет. Это означает, что все личные файлы доступны для всего мира и некоторые из них могут быть использованы хакерами для получения несанкционированного административного доступа к сайту!</p>
<p>Вы <em>должны</em> переместить каталог dataroot ({$a}) в новое место, не доступное через интернет и соответствующим образом обновить значение параметра <code>$CFG->dataroot</code> в файле config.php.</p>';
$string['datarootsecuritywarning'] = 'Конфигурация Вашего сайта, возможно, не безопасна. Пожалуйста, убедитесь, что к каталогу dataroot ({$a}) нет прямого доступа через интернет.';
$string['dbmigrate'] = 'Перенос базы данных Moodle';
$string['dbmigrateconnecerror'] = 'Невозможно подключиться к выбранной базе данных.';
$string['dbmigrateencodingerror'] = 'Указанная база данных имеет кодировку {$a}, а требуется UNICODE/UTF8.<br />Пожалуйста, укажите другую.';
$string['dbmigratepostgres'] = 'Кажется, Вы используете PostgreSQL в качестве сервера баз данных. Чтобы продолжить процесс миграции необходимо вручную создать новую базу данных в кодировке «UNICODE» (PostgreSQL 7) или «UTF8» (PostgreSQL 8) для хранения данных миграции. Для продолжения введите ниже настройки подключения к новой базе данных:';
$string['dbmigratewarning'] = 'Пожалуйста, убедитесь, что Вы сделали резервную копию базы данных Moodle перед началом этой процедуры. Если Вы не уверены, как это сделать, то обратитесь к своему системному администратору. Ваш сайт перейдет в режим обслуживания после завершения процесса миграции.';
$string['dbmigratewarning2'] = '<b>Предупреждение: Вы начинаете процесс миграции базы данных. Пожалуйста, убедитесь, что Вы сделали резервную копию всей базы данных Moodle.</b>';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Эта устаревшая база данных переносится в новую базу данных UTF8. Измените config.php и используйте новую базу данных для этого Moodle.</font>';
$string['dbmigrationdupfailed'] = 'Дублирование базы данных не удалось с вероятной ошибкой:<font color="#ff0000"><pre>{$a}</pre></font>';
$string['dbsessions'] = 'Хранить сессии в базе данных';
$string['debug'] = 'Отладочные сообщения';
$string['debugall'] = 'ВСЕ: выводить все сообщения отладчика PHP';
$string['debugdeveloper'] = 'РАЗРАБОТЧИК: дополнительные сообщения отладчика Moodle для разработчиков';
$string['debugdisplay'] = 'Отображать отладочные сообщения';
$string['debugging'] = 'Отладка';
$string['debugminimal'] = 'МИНИМУМ: выводить только неустранимые ошибки';
$string['debugnone'] = 'НЕТ: не выводить никаких ошибок и предупреждений';
$string['debugnormal'] = 'СТАНДАРТНО: выводить ошибки, предупреждения и примечания';
$string['debugpageinfo'] = 'Показать информацию о странице';
$string['debugsmtp'] = 'Отладка отправки электронной почты';
$string['debugstringids'] = 'Выводить источник строк перевода';
$string['debugstringids_desc'] = 'Этот режим создан для облегчения работы переводчиков. Если включить этот режим и добавить strings=1 к списку параметров запрашиваемой страницы, то при выводе каждой строки рядом с ней будет отображаться языковой файл и идентификатор строки.';
$string['debugvalidators'] = 'Показать ссылки на валидатор';
$string['defaultcity'] = 'Город по умолчанию';
$string['defaultcity_help'] = 'Указанный здесь город будет указан по умолчанию при создании новых учетных записей пользователей.';
$string['defaultformatnotset'] = 'Ошибка в формате курса по умолчанию. Проверьте настройки сайта.';
$string['defaulthomepage'] = 'Стартовая страница по умолчанию для пользователей.';
$string['defaultrequestcategory'] = 'Категория по умолчанию для запрашиваемых курсов';
$string['defaultsettinginfo'] = 'Значение по умолчанию: {$a}';
$string['defaultuserroleid'] = 'Роль по умолчанию для всех пользователей';
$string['deleteincompleteusers'] = 'Удалять пользователей, не завершивших регистрацию через';
$string['deleteunconfirmed'] = 'Удалять неподтвержденных пользователей после';
$string['deleteuser'] = 'Удалить пользователя';
$string['density'] = 'Плотность';
$string['denyemailaddresses'] = 'Запрещенные почтовые домены';
$string['development'] = 'Разработка';
$string['devicedetectregex'] = 'Регулярные выражения для определения типов устройств';
$string['devicedetectregex_desc'] = '<p>Moodle может автоматически определять тип устройства - «по умолчанию» (настольные ПК, ноутбуки и т.д.), «мобильные» (телефоны и небольшие ручные устройства), «планшеты» (iPad, Android) и «устаревшие» (пользователи с Internet Explorer 6). Для разных типов устройств можно использовать различные темы оформления. Этот параметр разрешает использование регулярных выражений для определения дополнительных типов устройств (они будут иметь приоритет над типом «по умолчанию»).</p>
<p>Например, можно ввести регулярное выражение «/(MIDP-1.0|Maemo|Windows CE)/» для определения некоторых часто используемых телефонов, добавив возвращаемое значение «featurephone». При этом в поле выбора темы добавится пункт «featurephone», что позволит Вам выбрать тему, которая будет использоваться на этих устройствах. Другие телефоны будут по-прежнему использовать тему, выбранную для типа устройств «мобильные».</p>';
$string['devicedetectregexexpression'] = 'Регулярное выражение';
$string['devicedetectregexvalue'] = 'Возвращаемое значение';
$string['devicetype'] = 'Тип устройства';
$string['disableuserimages'] = 'Отключить изображения в профилях пользователей';
$string['displayerrorswarning'] = 'Включение настройки PHP <em>display_errors</em> не рекомендуется на рабочих сайтах, потому что в некоторых сообщениях может оказаться закрытая информация о Вашем сервере.';
$string['displayloginfailures'] = 'Уведомлять об ошибках входа';
$string['dndallowtextandlinks'] = 'Перетаскивание загружаемого текста / ссылок';
$string['docroot'] = 'Адрес документации Moodle';
$string['doctonewwindow'] = 'Открыть в новом окне';
$string['download'] = 'Скачать';
$string['edithelpdocs'] = 'Править файлы справки';
$string['editingnoncorelangfile'] = 'Вы пытаетесь изменить перевод дополнительного модуля/плагина. Вы можете сохранить свой перевод сторонних модулей только в папке _local. Вы можете переместить файл с переводом в языковую директорию модуля и/или послать его тому, кто поддерживает этот дополнительный модуль.';
$string['editlang'] = '<b>Редактировать</b>';
$string['editorbackgroundcolor'] = 'Цвет фона';
$string['editordictionary'] = 'Словарь редактора';
$string['editorfontfamily'] = 'Семейство шрифтов';
$string['editorfontlist'] = 'Список шрифтов';
$string['editorfontsize'] = 'Размер шрифта';
$string['editorhidebuttons'] = 'Скрытые кнопки';
$string['editorkillword'] = 'Фильтр формата Word';
$string['editorspelling'] = 'Проверка правописания';
$string['editorspellinghelp'] = 'Включить или нет проверку правописания. Если включено, то <strong>aspell</strong> должен быть установлен на сервере.';
$string['editstrings'] = 'Редактирование слов и фраз';
$string['emailchangeconfirmation'] = 'Подтверждение изменения электронной почты';
$string['emoticonalt'] = 'Альтернативный текст';
$string['emoticoncomponent'] = 'Компонент изображения смайлика';
$string['emoticonimagename'] = 'Имя изображения';
$string['emoticons'] = 'Смайлики';
$string['emoticons_desc'] = 'Эта форма определяет смайлики, используемые на вашем сайте. Чтобы удалить строку из таблицы, сохраните форму с пустым значением в любом из обязательных полей. Для регистрации новых смайликов, заполните поля в последней пустой строке. Для сброса всех полей в значения по умолчанию, перейдите по ссылке выше.

* Текст (обязательно) - этот текст будет заменен изображением смайлика. Он должен быть не менее двух символов.
* Имя изображения (обязательно) - имя файла изображения смайлика без расширения, относительно компонента папки pix.
* Компонет изображения (обязательно) - компонент, обеспечивающий значок.
* Альтернативный текст (не обязательно) - идентификатор строки и компонент альтернативного текста смайлика.';
$string['emoticonsreset'] = 'Сбросить настройки смайликов к значениям по умолчанию';
$string['emoticontext'] = 'Текст';
$string['emptysettingvalue'] = 'Не заполнено';
$string['enableajax'] = 'Включить AJAX';
$string['enableblogs'] = 'Разрешить блоги';
$string['enablecalendarexport'] = 'Разрешить экспорт календарей';
$string['enablecomments'] = 'Включить комментарии';
$string['enablecourserequests'] = 'Разрешить запросы на создание курса';
$string['enablecssoptimiser'] = 'Включить оптимизатор CSS';
$string['enablecssoptimiser_desc'] = 'При включении этого параметра CSS будут проходить оптимизацию перед кэшированием. В процессе оптимизации CSS удаляются повторяющиеся правила и стили, а также лишние пробелы и форматирование. Обратите внимание, что включение этого параметра одновременно с параметром «Режим дизайнера темы» существенно понижает производительность, но может помочь дизайнерам тем создавать оптимизированные CSS.';
$string['enabled'] = 'Включено';
$string['enabledevicedetection'] = 'Включить определение типа устройства';
$string['enablegravatar'] = 'Включить поддержку Gravatar';
$string['enablegravatar_help'] = 'При включении этого параметра Moodle будет пытаться использовать изображение пользователя с сервера Gravatar, если пользователь не загрузил свое изображение.';
$string['enablegroupmembersonly'] = 'Включить параметр «Только для членов группы»';
$string['enablemobilewebservice'] = 'Включить веб-службы для мобильных устройств';
$string['enablerecordcache'] = 'Включить кэш записей';
$string['enablerssfeeds'] = 'Включить RSS-ленты';
$string['enablesafebrowserintegration'] = 'Включить интеграцию с Safe Exam Browser';
$string['enablestats'] = 'Включить статистику';
$string['enabletgzbackups'] = 'Включить новый формат резервного копирования';
$string['enabletgzbackups_desc'] = 'При включенном параметре резервные копии будут создаваться в новом формате сжатия файлов - .mbz  (внутренне сохраняемый как файл .tar.gz). Это снимает ограничение размера резервной копии в 4 Гб и может повысить производительность. Восстановление поддерживает оба формата и пользователи не должны заметить разницы.';
$string['enabletgzbackups_nozlib'] = 'Расширение PHP «zlib» недоступно. Новый формат резервного копирования зависит от этого расширения и будет отключен, пока zlib не будет установлен и включен.';
$string['enabletrusttext'] = 'Включить возможность «Доверять содержимому».';
$string['enablewebservices'] = 'Включить веб-службы';
$string['enablewsdocumentation'] = 'Документация веб-служб';
$string['enrolinstancedefaults'] = 'Параметры записи на курс по умолчанию';
$string['enrolinstancedefaults_desc'] = 'Настройки записи на курс по умолчанию для новых курсов.';
$string['enrolmultipleusers'] = 'Записать пользователей';
$string['environment'] = 'Среда (версии ПО)';
$string['environmenterrortodo'] = 'Вам следует устранить указанные выше проблемы (ошибки), прежде чем начать установку этой версии Moodle!';
$string['environmenterrorupgrade'] = 'Предупреждение: Вам следует устранить все указанные выше проблемы (ошибки) перед обновлением версии Moodle! Обновление без учета этих требований может вызвать такие проблемы, как потеря данных. Вы уверены, что хотите продолжить обновление?';
$string['environmentmustfixsetting'] = 'Необходимо изменить параметр PHP.';
$string['environmentok'] = 'Конфигурация сервера отвечает всем минимальным требованиям.';
$string['environmentrecommendcustomcheck'] = 'непрохождение данного теста указывает на возможную проблему';
$string['environmentrecommendinstall'] = 'рекомендуется установить и включить для наилучшей производительности';
$string['environmentrecommendversion'] = 'рекомендуемая версия {$a->needed}, у Вас используется версия {$a->current}';
$string['environmentrequirecustomcheck'] = 'этот тест должен быть пройден';
$string['environmentrequireinstall'] = 'необходимо установить и включить';
$string['environmentrequireversion'] = 'требуется версия {$a->needed}, у Вас используется версия {$a->current}';
$string['environmentsettingok'] = 'обнаружены рекомендуемые настройки ';
$string['environmentshouldfixsetting'] = 'следует изменить параметр PHP.';
$string['environmentxmlerror'] = 'Ошибка чтения данных о системе ({$a->error_code})';
$string['errordeletingconfig'] = 'Произошла ошибка при удалении записей конфигурации плагина «{$a}».';
$string['errorsetting'] = 'Невозможно сохранить настройку:';
$string['errorwithsettings'] = 'Некоторые настройки не были изменены из-за ошибки.';
$string['everyonewhocan'] = 'Все, кто может {$a}';
$string['exceptions'] = 'исключения';
$string['execpathnotallowed'] = 'Настройка исполняемых путей отключена в config.php';
$string['experimental'] = 'Экспериментальные возможности';
$string['experimentalsettings'] = 'Экспериментальные настройки';
$string['extendedusernamechars'] = 'Разрешить в логинах дополнительные символы';
$string['extramemorylimit'] = 'Предел дополнительный памяти PHP';
$string['fatalmagicquotesruntime'] = '<p>Обнаружены серьезные ошибки конфигурации, пожалуйста, сообщите администратору сервера.</p><p>Для нормальной работы Moodle требуется, чтобы администратор изменил настройки PHP.</p><p>Параметр <code> magic_quotes_runtime</code> должен быть установлено в <code>off</code>.</p><p>Этот параметр устанавливается в файле <code>php.ini</code>, в конфигурации Apache/IIS <br /> или в файле <code>.htaccess</code> на сервере.</p>';
$string['fatalsessionautostart'] = '<p>Обнаружены серьезные ошибки конфигурации, пожалуйста, сообщите администратору сервера.</p><p>Для нормальной работы Moodle требуется, чтобы администратор изменил настройки PHP.</p><p><code> session.auto_start</code> должно быть установлено в <code>off</code>.</p><p>Этот параметр управляется редактированием <code>php.ini</code>, конфигурации Apache/IIS <br /> или файла <code>.htaccess</code> на сервере.</p>';
$string['filecreated'] = 'Создан новый файл';
$string['filestoredin'] = 'Сохранить файл в папку:';
$string['filestoredinhelp'] = 'Где будет сохранен файл';
$string['filterall'] = 'Фильтровать все строки';
$string['filtermatchoneperpage'] = 'Фильтр работает до первого совпадения на странице';
$string['filtermatchonepertext'] = 'Фильтр работает до первого совпадения в каждом тексте';
$string['filters'] = 'Фильтры';
$string['filtersettings'] = 'Управление фильтрами';
$string['filtersettingsgeneral'] = 'Основные настройки фильтра';
$string['filteruploadedfiles'] = 'Фильтрация загружаемых файлов';
$string['forcelogin'] = 'Принуждать пользователей входить в систему';
$string['forceloginforprofileimage'] = 'Необходимо войти в систему для просмотра изображений других пользователей';
$string['forceloginforprofileimage_help'] = 'При включенном параметре пользователи должны будут зайти в систему, чтобы просматривать изображения других пользователей. Это также приведет к тому, что во всех рассылаемых по электронной почте уведомлениях вместо изображения пользователя будет использоваться изображение по умолчанию.';
$string['forceloginforprofiles'] = 'Необходимо войти в систему для просмотра профилей';
$string['forcetimezone'] = 'Принудительный часовой пояс';
$string['formatuninstallwithcourses'] = 'Формат «{$a->format}» используется в {$a->count} курсах(е). Их формат будет изменен на «{$a->defaultformat}» (формат по умолчанию для этого сайта). Некоторые специфичные для этого формата данные могут быть безвозвратно утеряны. Продолжить?';
$string['frontpage'] = 'Главная страница';
$string['frontpagebackup'] = 'Резервная копия главной страницы';
$string['frontpagedefaultrole'] = 'Роль по умолчанию для главной страницы';
$string['frontpagefilters'] = 'Фильтры главной страницы';
$string['frontpageloggedin'] = 'Элементы главной страницы после входа';
$string['frontpageoverrides'] = 'Переопределения разрешений для главной страницы';
$string['frontpagequestions'] = 'Вопросы главной страницы';
$string['frontpagerestore'] = 'Восстановление главной страницы';
$string['frontpageroles'] = 'Роли главной страницы';
$string['frontpagesettings'] = 'Настройки главной страницы';
$string['fullnamedisplay'] = 'Формат полного имени';
$string['fullnamedisplayprivate'] = 'Формат полного имени - личное';
$string['gdrecommended'] = 'Расширение GD используется для преобразования изображений. Без данного расширения будут не доступны некоторые функции (например, изображения в профиле пользователя).';
$string['gdrequired'] = 'Расширение GD требуется Moodle для преобразования изображений.';
$string['generalsettings'] = 'Основные настройки
';
$string['geoipfile'] = 'Файл данных городов GeoIP';
$string['getremoteaddrconf'] = 'Источник IP-адреса';
$string['globalswarning'] = '<p><strong>Предупреждение системы безопасности!</strong></p><p>Для корректной работы Moodle требуется, чтобы Вы<br />внесли определенные изменения в текущие надстройки PHP.<p/><p><em>Необходимо</em> установить <code>register_globals=off</code>.<p>Этот параметр устанавливается в файле <code>php.ini</code>,<br />конфигурации Apache/IIS или в файле <code>.htaccess</code>.</p>';
$string['googlemapkey3'] = 'Ключ Google Maps API v3';
$string['googlemapkey3_help'] = 'Вам необходимо ввести специальный ключ, чтобы использовать Google Maps для визуализации положения IP-адреса. Вы можете бесплатно получить этот ключ по адресу <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Перейти к первой пропущенной строке';
$string['gradebook'] = 'Журнал оценок';
$string['gradebookroles'] = 'Оцениваемые роли';
$string['gradeexport'] = 'Основные форматы экспорта оценок';
$string['gravatardefaulturl'] = 'URL-адрес изображения по умолчанию для сервиса Gravatar';
$string['gravatardefaulturl_help'] = 'Сервис Gravatar требует указания изображения по умолчанию, которая отображается, если не удалось найти аватар для данного пользователя. Нужно указать полный URL-адрес к картинке. Если оставить это поле пустым, то Moodle попробует автоматически подобрать наиболее подходящее изображение для данной страницы.  Также отметим, что Gravatar имеет ряд кодов, которые могут быть использованы для <a href="https://en.gravatar.com/site/implement/images/#default-image">создания изображения по умолчанию</a>.';
$string['groupenrolmentkeypolicy'] = 'Применять политику для кодовых слов';
$string['groupenrolmentkeypolicy_desc'] = 'При включении этого параметра Moodle будет проверять кодовые слова для записи в группу на соответствие действующей политике паролей.';
$string['guestroleid'] = 'Роль для гостя';
$string['guestroleid_help'] = 'Эта роль автоматически присваивается пользователю-гостю. Она также временно назначается не записанным на курс пользователям, которые входят в курс как гости.';
$string['helpadminseesall'] = 'Должны ли администраторы видеть все события календаря или только те, которые касаются их самих?';
$string['helpcalendarcustomexport'] = 'Разрешить экспортировать пользовательские настройки  диапазона дат при экспорте календаря. Предварительно должен быть разрешен экспорт календаря.';
$string['helpexportlookahead'] = 'События скольких предстоящих дней можно внести в пользовательские настройки при экспорте календаря?';
$string['helpexportlookback'] = 'События скольких прошедших дней можно внести в пользовательские настройки при экспорте календаря?';
$string['helpforcetimezone'] = 'Вы можете разрешить пользователям выбирать часовой пояс индивидуально или принудительно установить всем часовой пояс по умолчанию.';
$string['helpshowicalsource'] = 'При включенном параметре для импортируемых событий календаря будут показаны название подписки и ссылка.';
$string['helpsitemaintenance'] = 'Для обновления и других работ по обслуживанию системы';
$string['helpstartofweek'] = 'С какого дня начинается неделя в календаре?';
$string['helpupcominglookahead'] = 'На сколько дней вперед, по умолчанию, нужно выводить предстоящие события?';
$string['helpupcomingmaxevents'] = 'Какое максимальное число предстоящих событий, по умолчанию, следует показывать пользователям?';
$string['helpweekenddays'] = 'Какие дни недели считаются выходными и отображаются другим цветом?';
$string['hiddenuserfields'] = 'Скрыть поля пользователя';
$string['hidefromall'] = 'Скрыть от всех пользователей';
$string['hidefromnone'] = 'Ни от кого не скрывать';
$string['hidefromstudents'] = 'Скрыть от студентов';
$string['htmleditor'] = 'редактор HTML';
$string['htmleditorsettings'] = 'Настройки редактора HTML';
$string['htmlsettings'] = 'Настройки HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Безопасность HTTP';
$string['hubs'] = 'Регистрация в каталогах';
$string['iconvrecommended'] = 'Установка библиотеки ICONV рекомендуется для повышения производительности сайта, особенно если на сайте используются нелатинские символы.';
$string['iconvrequired'] = 'Установка расширения ICONV обязательна.';
$string['ignore'] = 'Игнорировать';
$string['includemoduleuserdata'] = 'Включать данные пользователей';
$string['incompatibleblocks'] = 'Несовместимые блоки';
$string['installhijacked'] = 'Извините, но установка должна быть завершена с первоначального IP-адреса.';
$string['installsessionerror'] = 'Не удается инициализировать сессию PHP; пожалуйста, убедитесь, что Ваш браузер принимает cookies.';
$string['intlrecommended'] = 'Расширение Intl используется для улучшения интернациональной поддержки, такой как сортировка с учетом региональных особенностей.';
$string['invalidsection'] = 'Некорректный раздел.';
$string['invaliduserchangeme'] = 'Логин «changeme» зарезервирован - его нельзя использовать для создания учетной записи.';
$string['ipblocked'] = 'В настоящее время этот сайт не доступен.';
$string['ipblocker'] = 'Блокировка IP-адресов';
$string['ipblockersyntax'] = 'Разместите каждую запись на отдельной сроке. Допустимые значения: полный IP-адрес (например, <b>192.168.10.1</b>), соответствующий одному узлу; неполный адрес (например, <b>192.168.</b>), соответствующий любому адресу, начинающемуся с этих чисел; CIDR-обозначения (например, <b>231.54.211.0/20</b>); диапазон IP-адресов (например: <b>231.3.56.10-20</b>), где диапазон относится к последней части адреса. Текстовые доменные имена (например, «example.com») не поддерживаются. Пустые строки игнорируются.';
$string['iplookup'] = 'Местонахождение IP-адреса';
$string['iplookupgeoplugin'] = 'В настоящее время для поиска географической информации  используется служба <a href="http://www.geoplugin.com">geoPlugin</a>. Для получения более точных результатов рекомендуется установить локальную копию базы данных MaxMind GeoLite.';
$string['iplookupinfo'] = 'По умолчанию для просмотра информации о местонахождении IP-адресов Moodle использует бесплатный сервер NetGeo (The Internet Geographic Database). К сожалению, эта база данных больше не поддерживается и может выдавать <em>совершенно неверные</em> данные. Рекомендуется установить локальную копию бесплатной базы данных GeoLite City компании MaxMind.<br />
Местонахождение IP-адреса показывается на простой карте или с использованием Google Maps. Обратите внимание, чтобы начать использовать интерактивные карты, Вам потребуется создать учетную запись Google и отправить запрос на бесплатный ключ API Google Maps.';
$string['iplookupmaxmindnote'] = 'В этой программе используется база данных GeoLite компании MaxMind, доступная по адресу: <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['keeptagnamecase'] = 'Сохранять регистр тегов';
$string['lang'] = 'Язык по умолчанию';
$string['langcache'] = 'Кэшировать список языков';
$string['langcache_desc'] = 'Кэшировать список языков. В случае, если параметр включен, список доступных языков интерфейса системы будет кэшироваться. Кэш будет автоматически обновляться при установке и удалении языковых пакетов через страницу импорта языковых пакетов. Если Вы устанавливаете языковой пакет вручную, вам потребуется использовать функцию «Очистить все кэши».';
$string['langlist'] = 'Языки в меню языков';
$string['langmenu'] = 'Отображать меню языков';
$string['langpackwillbeupdated'] = 'ПРИМЕЧАНИЕ: при обновлении Moodle попытается загрузить обновления языковых пакетов.';
$string['langstringcache'] = 'Кэшировать все строки языкового пакета';
$string['languagesettings'] = 'Языковые настройки';
$string['latexpreamble'] = 'Преамбула LaTeX';
$string['latexsettings'] = 'Настройки визуализатора LaTeX';
$string['latinexcelexport'] = 'Кодировка Excel';
$string['legacyfilesaddallowed'] = 'Разрешить добавление к устаревшим файлам курса';
$string['legacyfilesaddallowed_help'] = 'Если в курсе есть устаревшие файлы курса, разрешить новым файлам и папкам быть добавленными к ним.';
$string['legacyfilesinnewcourses'] = 'Устаревшее хранилище файлов в новых курсах';
$string['legacyfilesinnewcourses_help'] = 'По умолчанию устаревшее хранилище файлов курса сохранено только в тех курсах, которые были обновлены из прошлой версии Moodle. Обратите внимание, что резервное копирование/восстановление некоторых элементов курса не совместимо с этим параметром.';
$string['licensesettings'] = 'Параметры лицензии';
$string['linkadmincategories'] = 'Категории администрирования в виде ссылок';
$string['linkadmincategories_help'] = 'При включенном параметре категории администрирования будут отображаться в навигации в виде ссылок, ведущих на страницы управления соответствующими категориями настроек.';
$string['loading'] = 'Загрузка';
$string['localetext'] = 'Локаль сайта';
$string['localstringcustomization'] = 'Локальное переопределение строк';
$string['location'] = 'Местонахождение';
$string['locationsettings'] = 'Настройки местонахождения';
$string['locked'] = 'Заблокировано';
$string['lockoutduration'] = 'Продолжительность блокировки учетной записи';
$string['lockoutduration_desc'] = 'Заблокированная учетная запись после этого срока автоматически разблокируется.';
$string['lockoutemailbody'] = 'Ваша учетная запись с логином «{$a->username}» на сайте «{$a->sitename}» была заблокирована после нескольких неудачных попыток входа.

Чтобы разблокировать учетную запись перейдите по следующему адресу:

{$a->link}

В большинстве почтовых программ это должно выглядеть в виде голубой ссылки, на которую Вы можете просто нажать. Если это не сработает, то скопируйте и вставьте адрес в адресную строку в верхней части окна браузера.

Если Вам нужна помощь, пожалуйста, свяжитесь с администратором сайта,
{$a->admin}';
$string['lockoutemailsubject'] = 'Ваша учетная запись на {$a} была заблокирована';
$string['lockouterrorunlock'] = 'Представлена неверная информация для разблокировки учетной записи.';
$string['lockoutthreshold'] = 'Порог блокировки учетной записи';
$string['lockoutthreshold_desc'] = 'Укажите количество неудачных попыток входа в систему, при котором учетная запись блокируется. Эта функция поможет избегать атак «Отказ в обслуживании».';
$string['lockoutwindow'] = 'Продолжительность блокировки';
$string['lockoutwindow_desc'] = 'Время наблюдения за порогом блокировки. Если больше нет неудачных попыток, то счетчик порога сбрасывается после этого времени.';
$string['log'] = 'Отчеты';
$string['logguests'] = 'Протоколировать действия гостей';
$string['logguests_help'] = 'Этот параметр отвечает за протоколирование действий учетной записи гостя и пользователей, не вошедших в систему. Это может потребоваться на сильно нагруженных сайтах для повышения производительности. Однако для рабочих сайтов всё-таки рекомендуется оставить этот параметр включенным.';
$string['loginhttps'] = 'Использовать HTTPS для входа в систему';
$string['loginpageautofocus'] = 'Автофокус формы страницы входа';
$string['loginpageautofocus_help'] = 'Включение этого параметра делает страницу входа более удобной. Но автоматический выбор полей может ввести в заблуждение слепых и слабовидящих пользователей, использующих программы для чтения с экрана.';
$string['loginpasswordautocomplete'] = 'Отключить автозаполнение пароля при входе в систему';
$string['loginpasswordautocomplete_help'] = 'При отключении этого параметра пользователи смогут сохранять пароли в браузере. Включение этого параметра приведет к тому, что сайт не будет соответствовать стандарту XHTML strict';
$string['loglifetime'] = 'Сохранять отчеты в течение';
$string['longtimewarning'] = '<b> Учтите, что этот процесс может занять много времени. </b>';
$string['maintenancemode'] = 'В режиме обслуживания';
$string['maintenancemodeisscheduled'] = 'Через {$a} минут сайт переходит в режим обслуживания';
$string['maintfileopenerror'] = 'Ошибка открытия обслуживаемых файлов';
$string['maintinprogress'] = 'Процесс обслуживания...';
$string['manageformats'] = 'Управление форматами курсов';
$string['manageformatsgotosettings'] = 'Формат по умолчанию может быть изменен в {$a}';
$string['managelang'] = 'Управление';
$string['managelicenses'] = 'Управление лицензиями';
$string['manageqbehaviours'] = 'Управление поведением вопросов';
$string['manageqtypes'] = 'Управление типами вопросов';
$string['maturity100'] = 'Бета-версия';
$string['maturity150'] = 'Релиз-кандидат';
$string['maturity200'] = 'Стабильная версия';
$string['maturity50'] = 'Альфа-версия';
$string['maturityallowunstable'] = 'Подсказка: Вы можете запустить этот скрипт в тестовом варианте';
$string['maturitycoreinfo'] = 'Сейчас Ваш сайт работает на нестабильном коде стадии разработки «{$a}».';
$string['maturitycorewarning'] = 'Версия Moodle, которую Вы собираетесь установить или обновить, содержит нестабильный код, находящийся в стадии разработки «{$a}», и не подходит для большинства рабочих сайтов. Если это не то, чего Вы хотели, то Вы должны убедиться, что обновляете Moodle из ветви STABLE. Более подробная информация содержится в документации Moodle.';
$string['maxbytes'] = 'Максимальный размер загружаемого файла';
$string['maxconsecutiveidentchars'] = 'Последовательных одинаковых символов';
$string['maxeditingtime'] = 'Максимальное время редактирования сообщения';
$string['maxusersperpage'] = 'Максимальное количество пользователей на странице';
$string['mbstringrecommended'] = 'Установка дополнительной библиотеки MBSTRING настоятельно рекомендуется для повышения производительности сайта, особенно если на сайте используются языки с нелатинскими символами.';
$string['mediapluginavi'] = 'Включить фильтр .avi';
$string['mediapluginflv'] = 'Включить фильтр .flv';
$string['mediapluginimg'] = 'Включить автоматическую замену ссылок на рисунки на сами рисунки';
$string['mediapluginmov'] = 'Включить фильтр .mov';
$string['mediapluginmp3'] = 'Включить фильтр .mp3';
$string['mediapluginmpg'] = 'Включить фильтр .mpg';
$string['mediapluginogg'] = 'Включить фильтр .ogg';
$string['mediapluginogv'] = 'Включить фильтр .ogv';
$string['mediapluginram'] = 'Включить фильтр .ram';
$string['mediapluginrm'] = 'Включить фильтр .rm';
$string['mediapluginrpm'] = 'Включить фильтр .rpm';
$string['mediapluginswf'] = 'Включить фильтр .swf';
$string['mediapluginswfnote'] = 'В качестве мера безопасности по умолчанию обычным пользователям не разрешается внедрять файлы формата swf.';
$string['mediapluginwmv'] = 'Включить фильтр .wmv';
$string['mediapluginyoutube'] = 'Включить фильтр ссылок на YouTube';
$string['messaging'] = 'Включить систему обмена сообщениями';
$string['messagingallowemailoverride'] = 'Разрешить переопределение адреса для уведомлений';
$string['messagingdeletereadnotificationsdelay'] = 'Удалять прочитанные уведомления через';
$string['messaginghidereadnotifications'] = 'Скрывать прочитанные уведомления';
$string['minpassworddigits'] = 'Цифр';
$string['minpasswordlength'] = 'Длина пароля';
$string['minpasswordlower'] = 'Букв в нижнем регистре';
$string['minpasswordnonalphanum'] = 'Не буквенно-цифровых символов';
$string['minpasswordupper'] = 'Букв в верхнем регистре';
$string['misc'] = 'Разное';
$string['mnetrestore_extusers'] = '<strong>Примечание:</strong> Этот файл резервной копии содержит учетные записи внешних пользователей из Moodle Network, которые также будут восстановлены.';
$string['mnetrestore_extusers_admin'] = '<strong> Примечание: </strong> Этот файл резервной копии, вероятно, создан в другой установке Moodle и содержит учетные записи внешних пользователей из Moodle Network. Процесс восстановления попытается найти подходящие серверы Moodle Network для всех таких пользователей. Если это не удастся, пользователи будут автоматически переключены на внутреннюю аутентификацию (вместо mnet). Информация об этом будет в журнале восстановления.';
$string['mnetrestore_extusers_mismatch'] = '<strong> Примечание: </strong> Этот файл резервной копии, вероятно, создан в другой установке Moodle и содержит учетные записи внешних пользователей из Moodle Network, которые, возможно, не удастся восстановить. Эта операция не поддерживается. Если Вы уверены, что резервная копия была создано на этой установке Moodle или Вы убедились, что все указаны настройки для всех необходимых серверов Moodle Network, то Вы можете попробовать осуществить восстановление.';
$string['mnetrestore_extusers_noadmin'] = '<strong> Примечание: </strong> Этот файл резервной копии, вероятно, создан в другой установке Moodle и содержит учетные записи внешних пользователей из Moodle Network. Вам запрещено выполнять такой вид восстановления. Свяжитесь с администратором сайта или восстановите этот курс без какой-либо информации о пользователях (модули, файлы...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Внешиний пользователь «{$a->username}» из Moodle Network (пришел с {$a->mnethosturl}) переключен на внутреннюю аутентификацию «{$a->auth}».';
$string['mobile'] = 'Мобильные устройства';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'По умолчанию включить окно выбора типа нового элемента курса';
$string['modeditdefaults'] = 'Значения настроек элемента курса по умолчанию';
$string['modeditingmenu'] = 'Меню редактирования активного элемента';
$string['modeditingmenu_desc'] = 'Если параметр включен, то в режиме редактирования значки редактирования активных элементов будут показаны в  выпадающем меню. Это уменьшает содержимое на экране, скрывая значки, пока они не понадобятся.';
$string['modsettings'] = 'Управление элементами курса';
$string['modulesecurity'] = 'Безопасность модулей';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Принудительно использовать старый синтаксис фильтра многоязыкового содержимого: &lt;span&gt; без class=«multilang» и &lt;lang&gt;';
$string['mustenablestats'] = 'На сайте не включен сбор статистики.';
$string['mycoursesperpage'] = 'Количество курсов';
$string['mydashboard'] = 'Системная панель по умолчанию';
$string['mymoodle'] = 'Мой Moodle';
$string['mymoodleredirect'] = 'Пользователям принудительно использовать «Мой Moodle»';
$string['mypage'] = 'Настройки по умолчанию страницы «Мой Moodle»';
$string['mypagelocked'] = 'Заблокировать страницу по умолчанию';
$string['myprofile'] = 'Страница профиля по умолчанию';
$string['mysql416bypassed'] = 'Тем не менее, если Ваш сайт использует ТОЛЬКО языки в кодировке iso-8859-1 (latin), Вы можете продолжить использовать установленный сейчас MySQL 4.1.12 (или выше).';
$string['mysql416required'] = 'MySQL 4.1.16 - минимальная версия, необходимая Moodle 1.6 для того, чтобы гарантировать, что в будущем все данные могут быть преобразованы в UTF-8.';
$string['navadduserpostslinks'] = 'Добавлять ссылки для просмотра сообщений пользователя';
$string['navadduserpostslinks_help'] = 'При включении этого параметра в блоке навигации к каждому пользователю будут добавлены две ссылки для просмотра списка созданных пользователем обсуждений и списка всех сообщений на форумах по всему сайту или в конкретных курсах.';
$string['navcourselimit'] = 'Предельное количество курсов';
$string['navigationupgrade'] = 'В данном обновлении введены два новых блока навигации, которые заменят следующие блоки: «Управление», «Курсы», «Элементы курса» и «Участники курса». Если в этих блоках Вы наделяли пользователей определенными правами, то удостоверьтесь, всё ли работает так, как Вам необходимо.';
$string['navshowallcourses'] = 'Отображать все курсы';
$string['navshowcategories'] = 'Отображать категории курсов';
$string['navshowfrontpagemods'] = 'Отображать в навигации элементы главной страницы';
$string['navshowfrontpagemods_help'] = 'При включенном параметре элементы главной страницы будут отображаться в навигации на страницах сайта.';
$string['navshowfullcoursenames'] = 'Отображать полные названия курсов';
$string['navshowfullcoursenames_help'] = 'При включении этого параметра при отображении курсов в блоке «Навигация» вместо кратких названий курсов будут отображаться полные названия.';
$string['navshowmycoursecategories'] = 'Показывать «Мои курсы» с категориями';
$string['navshowmycoursecategories_help'] = 'При включении этого параметра, курсы в разделе «Мои курсы» будут отображаться с разделением на категории.';
$string['navsortmycoursessort'] = 'Отсортировать мои курсы';
$string['navsortmycoursessort_help'] = 'Параметр определяет порядок отображения курсов в списке «Мои курсы». Сортировка может быть в порядке, определенном в меню Настройки > Администрирование > Курсы > Управление курсами и категориями или в алфавитном порядке по названиям курсов.';
$string['neverdeleteruns'] = 'Никогда не останавливать';
$string['nobookmarksforuser'] = 'У Вас нет закладок';
$string['nodatabase'] = 'Нет базы данных';
$string['nohttpsformobilewarning'] = 'Рекомендуется включить HTTPS с действующим сертификатом. Приложение Moodle всегда будет в первую очередь пытаться использовать защищенное соединение.';
$string['nomissingstrings'] = 'Нет пропущенных строк';
$string['nonewsettings'] = 'После этого обновления не появилось новых параметров настройки';
$string['nonexistentbookmark'] = 'Запрошенная закладка не существует';
$string['noresults'] = 'Ничего не найдено';
$string['noroles'] = 'Нет ролей';
$string['notifications'] = 'Уведомления';
$string['notifyloginfailures'] = 'Уведомлять по электронной почте о неудачных попытках входа';
$string['notifyloginthreshold'] = 'Порог для уведомления по электронной почте';
$string['notloggedinroleid'] = 'Роль для посетителей';
$string['numberofmissingstrings'] = 'Количество пропущенных строк: {$a}';
$string['numberofstrings'] = 'Общее число строк: {$a->strings}<br />Не заполнено: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'Кэширование байт-кода улучшает производительность и уменьшает требования к памяти. Расширение OPcache языка PHP рекомендуется к установке и полностью поддерживается.';
$string['opensslrecommended'] = 'Настоятельно рекомендуется установка дополнительной библиотеки OpenSSL - от нее зависит функционирование Moodle Networking.';
$string['opentogoogle'] = 'Открыть для Google';
$string['optionalmaintenancemessage'] = 'Сообщение о техническом обслуживании (необязательно)';
$string['order1'] = 'Первый';
$string['order2'] = 'Второй';
$string['order3'] = 'Третий';
$string['order4'] = 'Четвертый';
$string['passwordpolicy'] = 'Политика паролей';
$string['passwordresettime'] = 'Максимальное время подтверждения запроса восстановления пароля';
$string['pathconvert'] = 'Путь к исполняемому файлу <i>convert</i>';
$string['pathdvips'] = 'Путь к исполняемому файлу <i>dvips</i>';
$string['pathlatex'] = 'Путь к исполняемому файлу <i>latex</i>';
$string['pathtoclam'] = 'Путь к clam AV';
$string['pathtodot'] = 'Путь к dot';
$string['pathtodot_help'] = 'Путь к dot. Обычно /usr/bin/dot. Для возможности создавать графики с использованием файлов DOT, необходимо установить исполняемый файл и указать его здесь. Отметим, что на данный момент, это используется только с профилированием (Разработка->Профилирование), встроенным в Moodle.';
$string['pathtodu'] = 'Путь к du';
$string['pathtopgdump'] = 'Путь к pg_dump';
$string['pathtopgdumpdesc'] = 'Этот параметр необходимо указывать только в том случае, если в системе установлено более одного файла pg_dump (например, если у Вас установлено несколько версий postgresql).';
$string['pathtopgdumpinvalid'] = 'Или путь к pg_dump неверный, или файл не исполняемый';
$string['pathtopsql'] = 'Путь к psql';
$string['pathtopsqldesc'] = 'Этот параметр необходимо указывать только в том случае, если в системе установлено более одного файла psql (например, если у Вас установлено несколько версий postgresql).';
$string['pathtopsqlinvalid'] = 'Или путь к psql неверный, или файл не исполняемый';
$string['pcreunicodewarning'] = 'Настоятельно рекомендуется использовать расширение PHP PCRE, совместимое с символами Unicode.';
$string['perfdebug'] = 'Информация о производительности';
$string['performance'] = 'Производительность';
$string['pgcluster'] = 'Кластер PostgreSQL';
$string['pgclusterdescription'] = 'Параметры версии/кластера PostgreSQL для операций в командной строке. Если в системе только один PostgreSQL или Вы не уверены в том, что нужно указывать, оставьте это поле пустым.';
$string['php50restricted'] = 'В PHP 5.0.x обнаружено определенное число проблем, обновитесь до версии 5.1.x или вернитесь к версиям 4.3.x или 4.4.x';
$string['php533warning'] = 'Рекомендуется PHP 5.3.3 и выше';
$string['phpfloatproblem'] = 'Обнаружена проблема с обработкой PHP чисел с плавающей запятой  - {$a}';
$string['pleaserefreshregistration'] = 'Ваш сайт зарегистрирован на moodle.org, пожалуйста не забудьте обновить информацию, если после последнего обновления ({$a}) произошли существенные изменения.';
$string['pleaseregister'] = 'Чтобы убрать эту кнопку, пожалуйста, зарегистрируйте ваш сайт.';
$string['plugin'] = 'Плагин';
$string['plugins'] = 'Плагины';
$string['pluginscheck'] = 'Плагин проверки зависимостей';
$string['pluginscheckfailed'] = 'Не удалось проверить зависимости для {$a->pluginslist}';
$string['pluginschecktodo'] = 'Вам необходимо удовлетворить зависимости для всех плагинов, прежде чем продолжить установку этой версии Moodle!';
$string['pluginsoverview'] = 'Обзор плагинов';
$string['pluginsoverviewsee'] = 'Подробности можно найти на странице <a href="{$a->url}">обзора плагинов</a>';
$string['profilecategory'] = 'Категория';
$string['profilecategoryname'] = 'Название категории (должно быть уникальным)';
$string['profilecategorynamenotunique'] = 'Такое название категории уже используется';
$string['profilecommonsettings'] = 'Общие настройки';
$string['profileconfirmcategorydeletion'] = 'Полей в этой категории: {$a}<br />Все они будут перемещены в вышестоящую категорию (или в нижестоящую, если находятся в высшей категории).<br />Вы все же хотите удалить эту категорию?';
$string['profileconfirmfielddeletion'] = 'Пользовательских записей в этом поле: {$a}.<br />Все они будут удалены.<br />Вы все же хотите удалить это поле?';
$string['profilecreatecategory'] = 'Создать новую категорию профиля';
$string['profilecreatefield'] = 'Создать новое поле профиля:';
$string['profilecreatenewcategory'] = 'Создание новой категории';
$string['profilecreatenewfield'] = 'Создание нового поля профиля типа «{$a}»';
$string['profiledefaultcategory'] = 'Другие поля';
$string['profiledefaultchecked'] = 'Отмечено по умолчанию';
$string['profiledefaultdata'] = 'Значение по умолчанию';
$string['profiledeletecategory'] = 'Удаление категории';
$string['profiledeletefield'] = 'Удаление поля «{$a}»';
$string['profiledescription'] = 'Описание поля';
$string['profiledscript'] = 'Этот скрипт был профилирован';
$string['profiledscriptview'] = 'Просмотр данных профилирования для этого скрипта';
$string['profileeditcategory'] = 'Редактирование категории: {$a}';
$string['profileeditfield'] = 'Редактирование поля профиля: {$a}';
$string['profilefield'] = 'Поле профиля';
$string['profilefieldcolumns'] = 'Столбцов';
$string['profilefieldispassword'] = 'Это поле пароля?';
$string['profilefieldlink'] = 'Ссылка';
$string['profilefieldlink_help'] = 'Для преобразования текста в ссылку введите URL, содержащий $$, где $$ будут заменены на текст. Например, для преобразования Twitter ID в ссылку, введите http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Открывать ссылку';
$string['profilefieldmaxlength'] = 'Максимальная длина';
$string['profilefieldrows'] = 'Строк';
$string['profilefields'] = 'Поля профиля пользователя';
$string['profilefieldsize'] = 'Отображаемый размер';
$string['profileforceunique'] = 'Значения должны быть уникальными?';
$string['profileinvaliddata'] = 'Некорректное значение';
$string['profilelocked'] = 'Это поле заблокировано?';
$string['profilemenudefaultnotinoptions'] = 'Значение по умолчанию не совпадает ни с одним из вариантов';
$string['profilemenunooptions'] = 'Нет вариантов для выбора';
$string['profilemenuoptions'] = 'Варианты выбора (каждый с новой строки)';
$string['profilemenutoofewoptions'] = 'Вы должны указать как минимум 2 варианта';
$string['profilename'] = 'Название';
$string['profilenofieldsdefined'] = 'Поля не определены';
$string['profilerequired'] = 'Это обязательное поле?';
$string['profileroles'] = 'Видимые роли профиля';
$string['profilesforenrolledusersonly'] = 'Профили только у записанных на курс пользователей';
$string['profileshortname'] = 'Краткое название (должно быть уникальным)';
$string['profileshortnamenotunique'] = 'Это краткое название уже используется';
$string['profilesignup'] = 'Показывать на странице входа?';
$string['profilespecificsettings'] = 'Особые параметры';
$string['profilevisible'] = 'Кто видит это поле?';
$string['profilevisibleall'] = 'Видно всем';
$string['profilevisible_help'] = '* «Не видно» - для конфиденциальных пользовательских данных, доступных только администраторам.
* «Видно пользователю» - для личных данных, доступных только пользователю и администраторам.
* «Видно всем» - для открытых данных.';
$string['profilevisiblenone'] = 'Не видно';
$string['profilevisibleprivate'] = 'Видно пользователю';
$string['profiling'] = 'Профилирование';
$string['profilingallowall'] = 'Непрерывное профилирование';
$string['profilingallowall_help'] = 'При включении этого параметра Вы затем, в любой момент, сможете использовать параметр PROFILEALL в любом месте (PGS), чтобы включить профилирование для всех выполняемых скриптов во время сессии Moodle. Аналогично, Вы сможете использовать параметр PROFILEALLSTOP, чтобы остановить его.';
$string['profilingallowme'] = 'Выборочное профилирование';
$string['profilingallowme_help'] = 'При включении этого параметра Вы затем, выборочно, сможете использовать параметр PROFILEME в любом месте (PGS) и произойдет профилирование этого скрипта. Аналогично, Вы сможете использовать параметр DONTPROFILEME для предотвращения профилирования.';
$string['profilingautofrec'] = 'Автоматическое профилирование';
$string['profilingautofrec_help'] = 'При настройке этого параметра некоторый запрос  (случайный, на основе указанной частоты - 1 из N) будет выбран и автоматически профилирован с сохранением результата для дальнейшего анализа. Обратите внимание, что этот способ наблюдения профилирования можно включить/выключить. Установив параметр в 0, Вы отключите автоматическое профилирование.';
$string['profilingenabled'] = 'Включить профилирование';
$string['profilingenabled_help'] = 'При включении этого параметра  профилирование будет доступно на этом сайте и Вы сможете определить его поведение, настроив следующие параметры.';
$string['profilingexcluded'] = 'Не профилировать эти';
$string['profilingexcluded_help'] = 'Список путей (относительно папки wwwroot, через запятую), которые не будут профилироваться, из тех, что определены настройками как «Профилировать эти».';
$string['profilingimportprefix'] = 'Префикс импортированного профилирования';
$string['profilingimportprefix_desc'] = 'Для более легкого обнаружения все импортированные профилирования будут работать с указанным здесь префиксом.';
$string['profilingincluded'] = 'Профилировать эти';
$string['profilingincluded_help'] = 'Список путей (относительно папки wwwroot, через запятую), которые будут автоматически профилироваться. Примеры: /index.php, /course/view.php. Также допускаются подстановки * в любом месте. Примеры: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Хранить результаты профилирования';
$string['profilinglifetime_help'] = 'Укажите какое время Вы хотите хранить информацию о прошедших запусках профилирования. Старые результаты будут периодически удаляться. Это не относится к результатам профилирования, помеченным как «reference run»';
$string['protectusernames'] = 'Защищать логины';
$string['proxybypass'] = 'Не использовать прокси для';
$string['proxyhost'] = 'Прокси-сервер';
$string['proxypassword'] = 'Пароль прокси';
$string['proxyport'] = 'Порт прокси';
$string['proxytype'] = 'Тип прокси';
$string['proxyuser'] = 'Имя пользователя прокси-сервера';
$string['purgecaches'] = 'Очистить все кэши';
$string['purgecachesconfirm'] = 'Moodle может кэшировать темы, JavaScript, строки языковых пакетов, обработанный фильтрами текст, RSS-ленты и многие другие составляющие обрабатываемых данных. Очистка кэшированных данных вынудит браузеры заново их загрузить, и Вы точно увидите актуальные значения, заново сгенерированные системой. Очистка кэша абсолютна безопасна, но после этого, возможно, сайт первое время будет работать медленней, так как потребуется заново генерировать часть информации и кэшировать ее.';
$string['purgecachesfinished'] = 'Все кэши были очищены.';
$string['qtyperqpwillberemoved'] = 'Во время обновления тип вопроса RQP будет удален. У Вас не используется этот тип вопроса, поэтому не должно возникнуть никаких проблем.';
$string['qtyperqpwillberemovedanyway'] = 'Во время обновления тип вопроса RQP будет удален. У Вас есть несколько вопросов RQP в базе данных, и они перестанут работать, если перед продолжением обновления Вы не добавите в сстему соответствующий модуль. Его можно скачать по ссылке http://moodle.org/mod/data/view.php?d=13&amp;rid=797.';
$string['quarantinedir'] = 'Папка карантина';
$string['question'] = 'Вопрос';
$string['questionbehaviours'] = 'Поведение вопроса';
$string['questioncwqpfscheck'] = 'Один или несколько вопросов типа «случайный» в тестах настроены на выбора вопросов одновременно из общих и из не общих категорий. Более подробная информация <a href="{$a->reporturl}">здесь</a>; смотрите также <a href="{$a->docsurl}">Документацию Moodle</a>.';
$string['questioncwqpfsok'] = 'Хорошо. В ваших тестах нет вопросов типа «случайный», настроенных на выбор вопросов одновременно из общих и из не общих категорий.';
$string['questiontype'] = 'Тип вопроса';
$string['questiontypes'] = 'Типы вопросов';
$string['quizattemptsupgradedmessage'] = 'В Moodle 2.1 было серьезное обновление работы вопросов. Обновление части базы данных было отложено на будущее. Перед обновлением до Moodle 2.7 вышеуказанное обновление должно быть завершено.';
$string['recaptchaprivatekey'] = 'Закрытый ключ ReCAPTCHA';
$string['recaptchapublickey'] = 'Открытый ключ ReCAPTCHA';
$string['register'] = 'Зарегистрировать этот сайт';
$string['registermoodleorg'] = 'При регистрации своего сайта на {$a}';
$string['registermoodleorgli1'] = 'Вы будете получать по почте рассылку важных уведомлений о предупреждениях системы безопасности и информацию о новых версиях Moodle;';
$string['registermoodleorgli2'] = 'статистика использования Вашаго сайта будет добавлена в {$a} мирового сообщества Moodle;';
$string['registermoodleorgli3'] = 'этот сайт также будет зарегистрирован в каталоге {$a}, что позволит пользователям с правами публикации курсов (по умолчанию - только управляющим) опубликовывать свои курсы в этом каталоге.';
$string['registerwithmoodleorg'] = 'Регистрация сайта на Moodle.org';
$string['registration'] = 'Регистрация';
$string['registration_help'] = 'Рекомендуется зарегистрироваться в Moodle.org и получать по электронной почте предупреждения о безопасности, внести свой вклад в развитие Moodle и <a href="http://moodle.org/stats">статистики использования Moodle</a>, или иметь возможность делиться курсами с Открытым сообществом <a href="http://moodle.net/">Moodle.net</a>.';
$string['registrationwarning'] = 'Ваш сайт еще не зарегистрирован.';
$string['releasenoteslink'] = 'Информацию об этой версии Moodle можно посмотреть онлайн в <a target="_blank" href="{$a}">Release Notes</a>';
$string['rememberusername'] = 'Запомнить логин';
$string['rememberusername_desc'] = 'Включите этот параметр, если при входе в систему нужно сохранять логин пользователя с помощью постоянных cookie. Использование постоянных cookie без разрешения может расцениваться как угроза конфиденциальности.';
$string['reportsmanage'] = 'Управление отчетами';
$string['requestcategoryselection'] = 'Разрешить выбор категории';
$string['requiredentrieschanged'] = '<strong>ВАЖНО - ПРОЧТИТЕ <br/> (Это предупреждающее сообщение будет отображено только при этом обновлении)</strong><br/> После исправления ошибки будет меняться поведение активного элемента База данных, использующей параметры «Требуется записей» и «Требуется записей до разрешения просмотра». Более подробное описание изменений можно прочитать <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank"> на форуме модуль База данных</a>. Ожидаемое поведение этих параметров можно также прочитать в <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Документации Moodle</a>.
<br/> <br/> Это изменение влияет на следующие базы данных в вашей системе: (Пожалуйста, сохраните сейчас этот список и после обновления убедитесь, что эти элементы по-прежнему работают правильно.) <br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Обязательное описание элементов курса';
$string['requires'] = 'Необходимо';
$string['restorernewroleid'] = 'Роль для пользователя, восстановившего курс';
$string['restorernewroleid_help'] = 'Если у пользователя нет права на управление восстановленным им из резервной копии курсом, этому пользователю будет назначена эта роль. Выберите вариант «Пусто», если Вы не хотите, чтобы пользователи, которые восстанавливают курсы, обязательно могли управлять этими курсами.';
$string['reverseproxy'] = 'Реверсивный прокси-сервер';
$string['riskconfig'] = 'Пользователи могут изменить конфигурацию и поведение сайта';
$string['riskconfigshort'] = 'Риск, связанный с конфигурацией';
$string['riskdataloss'] = 'Пользователи могут уничтожить большое количество содержимого или информации';
$string['riskdatalossshort'] = 'Риск потери данных';
$string['riskmanagetrust'] = 'Пользователи могут изменить настройки доверия других пользователей';
$string['riskmanagetrustshort'] = 'Управление доверием';
$string['riskpersonal'] = 'Пользователи могут получить доступ к личной информации других пользователей';
$string['riskpersonalshort'] = 'Угроза конфиденциальности';
$string['riskspam'] = 'Пользователи могут рассылать спам пользователям сайта или другим людям';
$string['riskspamshort'] = 'Риск спама';
$string['riskxss'] = 'Пользователи могут добавить файлы и тексты, содержащие Сross Site Sсriрting (XSS)';
$string['riskxssshort'] = 'Риск XSS';
$string['roleswithexceptions'] = '{$a->roles}, с {$a->exceptions}';
$string['rssglobaldisabled'] = 'Отключено на уровне сайта';
$string['runclamavonupload'] = 'Использовать clam AV для проверки загружаемых файлов';
$string['save'] = 'Сохранить';
$string['savechanges'] = 'Сохранить изменения';
$string['search'] = 'Поиск';
$string['searchinsettings'] = 'Поиск в настройках';
$string['searchresults'] = 'Результаты поиска';
$string['sectionerror'] = 'Ошибка раздела!';
$string['secureforms'] = 'Использовать расширенную безопасность форм';
$string['security'] = 'Безопасность';
$string['selectdevice'] = 'Выберите устройство';
$string['selecttheme'] = 'Выбрать тему для устройства - {$a}';
$string['server'] = 'Сервер';
$string['serverchecks'] = 'Проверка настроек сервера';
$string['serverlimit'] = 'Ограничение сервера';
$string['sessionautostartwarning'] = '<p>Обнаружены серьезные ошибки конфигурации, пожалуйста, сообщите администратору сервера.</p><p>Для нормальной работы Moodle требуется, чтобы администратор изменил настройки PHP.</p><p>Параметр <code>session.auto_start</code> должен быть установлено в <code>off</code>.</p><p>Этот параметр управляется редактированием <code>php.ini</code>, конфигурации Apache/IIS <br /> или файла <code>.htaccess</code> на сервере.</p>';
$string['sessioncookie'] = 'Префикс для cookie';
$string['sessioncookiedomain'] = 'Домен cookie';
$string['sessioncookiepath'] = 'Путь для cookie';
$string['sessionhandling'] = 'Обработка сессии';
$string['sessiontimeout'] = 'Таймаут сессии';
$string['settingfileuploads'] = 'Для нормальной работы требуется возможноть загрузки файлов на сервер, включите ее в настройках PHP.';
$string['settingmemorylimit'] = 'Обнаружен недостаток памяти, установите более высокие ограничения памяти в настройках PHP.';
$string['settingsafemode'] = 'Moodle не полностью совместима с режимом «safe mode» в PHP, попросите администратора сервера отключить его. Запуск Moodle в режиме «safe mode» не поддерживается, при этом могут возникнуть самые разнообразные проблемы...';
$string['showcommentscount'] = 'Отображать число комментариев';
$string['showdetails'] = 'Показать подробности';
$string['showuseridentity'] = 'Отображать персональные данные';
$string['showuseridentity_desc'] = 'При выборе или поиске пользователей, а также при выводе списков пользователей, кроме полного имени можно включить отображение этих полей. Эти поля будут отображаться только пользователям, у которых есть право moodle/site:viewuseridentity, по умолчанию это управляющие и учителя. (Этот параметр может пригодиться, если Вы указываете поля, которые являются обязательными в вашем учреждении).';
$string['simplexmlrequired'] = 'Расширение SimpleXML PHP теперь является обязательным для Moodle.';
$string['sitemaintenance'] = 'Извините, сайт находится в режиме технического обслуживания и сейчас недоступен';
$string['sitemaintenancemode'] = 'Режим технического обслуживания';
$string['sitemaintenanceoff'] = 'Режим технического обслуживания отключен и сайт снова работает в нормальном режиме.';
$string['sitemaintenanceon'] = 'Сейчас Ваш сайт находится в режиме технического обслуживания (войти могут только администраторы).';
$string['sitemaintenanceoncli'] = 'Ваш сайт сейчас находится в режиме технического обслуживания через интерфейс командной строки, доступ через веб-интерфейс запрещен.';
$string['sitemaintenancewarning'] = 'Ваш сайт в настоящее время в режиме технического обслуживания (войти могут только администраторы). Для возврата сайта в нормальный режим работы <a href="maintenance.php"> отключите режим обслуживания </a>.';
$string['sitemaintenancewarning2'] = 'Ваш сайт сейчас находится в режиме технического обслуживания (вход только для администраторов). Для возврата сайта в нормальный режим работы <a href="{$a}">отключите режим обслуживания</a>.';
$string['sitepolicies'] = 'Политика безопасности сайта';
$string['sitepolicy'] = 'Ссылка на пользовательское соглашение';
$string['sitepolicyguest'] = 'Ссылка на пользовательское соглашение для гостя';
$string['sitepolicyguest_help'] = 'Если у вас есть пользовательское соглашение, которое все гости должны прочитать и принять перед использованием этого сайта, то укажите здесь соответствующий адрес, иначе оставьте это поле пустым. Этот параметр может содержать любые общедоступные адреса в Интернете. Примечание: доступ для не вошедших в систему пользователей может быть закрыт параметром «Принуждать пользователей войти в систему».';
$string['sitepolicy_help'] = 'Если у вас есть пользовательское соглашение, которое все зарегистрированные пользователи должны прочитать и принять перед использованием этого сайта, то укажите здесь соответствующий адрес, иначе оставьте это поле пустым. Этот параметр может содержать любые общедоступные адреса в Интернете.';
$string['sitesectionhelp'] = 'Если параметр включен, то на главной странице сайта будет отображаться раздел описания.';
$string['slasharguments'] = 'Использовать «slash arguments»';
$string['smartpix'] = 'Быстрый поиск изображений';
$string['soaprecommended'] = 'Установка расширения SOAP необходима для функционирования веб-служб и некоторых дополнительных модулей.';
$string['sort_fullname'] = 'Полное название';
$string['sort_idnumber'] = 'ID номер';
$string['sort_shortname'] = 'Краткое название';
$string['sort_sortorder'] = 'Порядок сортировки';
$string['spellengine'] = 'Инструмент проверки правописания';
$string['spelllanguagelist'] = 'Список языков для проверки правописания';
$string['splrequired'] = 'Расширение PHP SPL теперь является обязательным для Moodle.';
$string['stats'] = 'Статистика';
$string['statsfirstrun'] = 'Максимальный интервал обработки';
$string['statsmaxruntime'] = 'Максимальное время работы';
$string['statsmoodleorg'] = 'статистику';
$string['statsruntimedays'] = 'Обрабатывать дней';
$string['statsruntimestart'] = 'Запускать в';
$string['statsuserthreshold'] = 'Порог числа пользователей';
$string['stickyblocks'] = 'Закрепленные блоки';
$string['stickyblockscourseview'] = 'Страница курса';
$string['stickyblocksduplicatenotice'] = 'Если Вы добавляете любой блок и он уже существует на странице, он будет продублирован.<br />Первоначальный (закрепленный) блок будет недоступен для редактирования, а дубликат можно будет редактировать.';
$string['stickyblocksmymoodle'] = 'Мой Moodle';
$string['stickyblockspagetype'] = 'Конфигурирование типа страницы';
$string['strictformsrequired'] = 'Строгая проверка обязательных полей';
$string['stripalltitletags'] = 'Удалять HTML-теги из названий всех элементов';
$string['supportcontact'] = 'Контакты службы поддержки';
$string['supportemail'] = 'Электронная почта техподдержки';
$string['supportname'] = 'Имя техподдержки';
$string['supportpage'] = 'Страница техподдержки';
$string['suspenduser'] = 'Заблокировать учетную запись пользователя';
$string['switchlang'] = 'Переключить каталог языка';
$string['systempaths'] = 'Системные пути';
$string['tablenosave'] = 'Изменения в вышеприведенной таблице сохраняются автоматически.';
$string['tablesnosave'] = 'Изменения в вышеприведенных таблицах сохраняются автоматически.';
$string['tabselectedtofront'] = 'В таблицах с вкладками строка с текущей выбранной вкладки должна быть вынесена на передний план';
$string['tabselectedtofronttext'] = 'Перенести строку выбранной вкладки на передний план';
$string['testsiteupgradewarning'] = 'Вы используете тестовый сайт {$a}, обновите его с помощью интерфейса командной строки';
$string['themedesignermode'] = 'Режим дизайнера темы';
$string['themelist'] = 'Список тем';
$string['themenoselected'] = 'Тема не выбрана';
$string['themeresetcaches'] = 'Очистить кэш тем';
$string['themeselect'] = 'Выбрать тему';
$string['themeselector'] = 'Выбор темы';
$string['themesettings'] = 'Настройки тем';
$string['therewereerrors'] = 'В Ваших данных были ошибки';
$string['thirdpartylibrary'] = 'Библиотека';
$string['thirdpartylibrarylocation'] = 'Расположение';
$string['thirdpartylibs'] = 'Сторонние библиотеки';
$string['timezone'] = 'Часовой пояс по умолчанию';
$string['timezoneforced'] = 'Значение установлено администратором сайта';
$string['timezoneisforcedto'] = 'Принудительно установить всем пользователям';
$string['timezonenotforced'] = 'Пользователи могут выбирать свои собственные часовые пояса';
$string['tokenizerrecommended'] = 'Установка расширения PHP Tokinizer рекомендуется для улучшения функционала Moodle Networking.';
$string['tools'] = 'Инструменты администрирования';
$string['toolsmanage'] = 'Управление инструментами администрирования';
$string['unattendedoperation'] = 'Автоматически продолжать без моего участия';
$string['unbookmarkthispage'] = 'Удалить закладку для этой страницы';
$string['unicoderecommended'] = 'Рекомендуется хранить все Ваши данные в Unicode (UTF-8). Новые установки должны производиться в базу данных с кодировкой по умолчанию Unicode. При обновлении, необходимо выполнить процесс преобразования в UTF-8 (см. страницу Администрирование).';
$string['unicoderequired'] = 'Требуется хранить все данные в кодировке Unicode (UTF-8). Новые установки должны производиться в базу данных с кодировкой по умолчанию Unicode. При обновлении, необходимо выполнить процесс преобразования в UTF-8 (см. страницу Администрирование).';
$string['uninstallplugin'] = 'Удалить';
$string['unlockaccount'] = 'Разблокировать учетную запись';
$string['unsettheme'] = 'Отключить тему';
$string['unsupported'] = 'Не поддерживается';
$string['unsuspenduser'] = 'Активировать учетную запись пользователя';
$string['updateaccounts'] = 'Обновить существующие учетные записи';
$string['updateautocheck'] = 'Автоматически проверять наличие обновлений';
$string['updateautocheck_desc'] = 'При включении этого параметра Ваш сайт будет автоматически проверять наличие обновлений системы Moodle и всех дополнительных модулей. При наличии обновления администраторам сайта будет разослано соответствующее уведомление.';
$string['updateautodeploy'] = 'Разрешить установку обновлений';
$string['updateautodeploy_desc'] = 'При включении этого параметра появляется возможность обновления Moodle прямо со страницы «Администрирование». При этом процесс веб-сервера должен иметь доступ на запись в папки установки Moodle. Эта возможность потенциально небезопасна.';
$string['updateavailable'] = 'Доступна более новая версия Moodle!';
$string['updateavailabledetailslink'] = 'Подробнее см. на {$a->url}';
$string['updateavailableforplugin'] = 'Доступны более новые версии некоторых из ваших плагинов!';
$string['updateavailableinstall'] = 'Установить это обновление';
$string['updateavailable_moreinfo'] = 'Подробнее ...';
$string['updateavailablenot'] = 'У Вас установлена самая последняя версия Moodle!';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Версия {$a}';
$string['updatecomponent'] = 'Обновить компонент';
$string['updateminmaturity'] = 'Требуемая стадия разработки';
$string['updateminmaturity_desc'] = 'Уведомлять только о тех обновлениях, стадия разработки которых не ниже указанной. Уведомления об обновлениях для тех плагинов, у которых не указана стадия разработки, выводятся всегда независимо от этого параметра.';
$string['updatenotificationfooter'] = 'Ваш сайт Moodle {$a->siteurl} настроен на автоматическую проверку обновлений. Вы получили это сообщение, потому что являетесь администратором сайта. Вы можете отключить автоматическую проверку обновлений (Администрирование - Сервер - Уведомления об обновлениях) и настроить способ доставки этого сообщения (Настройки моего профиля - Обмен сообщениями).';
$string['updatenotifications'] = 'Уведомления об обновлениях';
$string['updatenotificationsubject'] = 'Доступны обновления Moodle ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Уведомлять о новых сборках';
$string['updatenotifybuilds_desc'] = 'При включении этого параметра уведомления будут рассылаться при выходе каждой новой сборки (build) Moodle. Сборки содержат постоянные улучшения текущей версии Moodle и обычно выходят каждую неделю. Если отключить этот параметр, то Вы будете уведомлены только при выходе следующей версии Moodle. Этот параметр не влияет на проверку версий плагинов.';
$string['upgrade197notice'] = '<p>Moodle 1.9.7 содержит ряд исправлений безопасности для паролей и резервного копирования для защиты пользовательских данных на Вашем сайте. В результате некоторые из Ваших настроек и разрешений, связанных с резервными копиями может быть изменен. <br />
Подробнее смотрите на <a href="http://docs.moodle.org/dev/Moodle_1.9.7_release_notes" target="_blank">Moodle 1.9.7 release notes.</a></p>';
$string['upgrade197noticesubject'] = 'Сообщения обновления безопасности Moodle 1.9.7';
$string['upgrade197salt'] = 'Чтобы уменьшить риск кражи пароля, Вам настоятельно рекомендуется установить зашумление пароля. <br />Подробности см. на <a href="{$a}" target="_blank">password salting documentation</a>.';
$string['upgradeerror'] = 'Неизвестная ошибка при обновлении модуля «{$a->plugin}» к версии {$a->version}; продолжение не возможно.';
$string['upgradeforumread'] = 'Новая функция была добавлена в Moodle 1.5 для отслеживания прочитанных/непрочитанных сообщений. <br /> Для использования этой функции необходимо <a href="{$a}"> обновить таблицы</a>.';
$string['upgradeforumreadinfo'] = 'Новая особенность была добавлена в Moodle 1.5, чтобы отслеживать прочитанную/непрочитанную почту форума. Чтобы использовать эту функцию, Вам нужно обновить свои таблицы со всей отслеживаемой информацией для существующей почты. В зависимости от размера Вашего сайта это может длиться длительное время (часы) и может быть весьма накладным для Вашей базы данных, так что это лучше делать в период небольшой активности пользователей. Тем не менее, Ваш сайт будет функционировать на протяжении этого обновления. Если Вы запускаете этот процесс, то должны позволить ему завершиться (удерживайте окно своего браузера открытым). Тем не менее, если Вы останавливаете процесс, закрывая окно, не беспокойтесь - Вы можете стартовать снова.<br /><br />Вы хотите сейчас запустить процесс обновления?';
$string['upgradelogs'] = 'Для более полной функциональности Вашу старую системную информацию (logs) необходимо обновить. <a href="{$a}">Больше информации</a>';
$string['upgradelogsinfo'] = 'С системной информацией (logs) и ее записью могут происходить некоторые изменения. Для того, чтобы можно было просматривать все старые logs на основе per-activity basis, Ваши старые logs должны периодически обновляться. Это зависит от Вашего сайта и может занимать много времени (даже несколько часов), и Вы можете даже превысить допустимые пределы в БД для очень больших сайтов. Однако Вы должны запускать такой процесс  обновления системной информации и не прерывать его (не закрывать окна браузера) до полного окончания. Не волнуйтесь: во время такой работы сайт для других пользователей будет работать в обычном режиме. Вы хотите провести обновление системной информации (logs) прямо сейчас?';
$string['upgradepluginsfirst'] = 'Рекомендуется сначала установить все доступные обновления';
$string['upgradepluginsinfo'] = 'Обновление плагинов';
$string['upgradepluginsinfo_help'] = 'Есть доступные обновления для некоторых плагинов. Вы должны установить их все перед обновлением базы данных Moodle. Если сайт не поддерживает автоматическое развертывание обновлений, то Вы должны вручную загрузить и установить новые версии плагина на своем сервере.';
$string['upgradesettings'] = 'Новые настройки';
$string['upgradesettingsintro'] = 'Параметры, указанные ниже, появились при последнем обновлении Moodle. Исправьте значения по умолчанию на необходимые Вам и нажмите «Сохранить изменения» внизу страницы.';
$string['upgradestalefiles'] = 'Обнаружено смешение версий Moodle, продолжение обновления невозможно.';
$string['upgradestalefilesinfo'] = 'Процесс обновления Moodle был приостановлен, потому что в каталоге Moodle были обнаружены скрипты, по меньшей мере, двух основных версий Moodle. В дальнейшем это может вызвать большие проблемы, поэтому для продолжения необходимо убедиться, что каталог Moodle содержит файлы только одной версии Moodle.

Рекомендуемый способ очистки каталога Moodle выглядит следующим образом:

* переименовать текущую директорию Moodle на «moodle_old»
* создать новую директорию Moodle, содержащую только файлы из репозитория GIT
* переместить исходный файл config.php и любые нестандартные плагины из каталога «moodle_old» в новый каталог Moodle.

После очистки каталога Moodle обновите страницу, чтобы возобновить процесс обновления Moodle.

Часто причиной этого предупреждения является распаковка стандартного пакета Moodle в предыдущую версию Moodle. Хотя это нормально для небольших модернизаций, она не рекомендуется для крупных обновлений Moodle.

Это предупреждение может быть вызвано и неполной проверкой или обновления из репозитория GIT, в этом случае Вы можете просто ждать завершения операции, или, возможно, отменить команду и повторить операцию.

Вы можете найти более подробную информацию по обновлению в документации <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Обновить Moodle';
$string['upgradesure'] = '<p>Файлы Moodle изменены, можно приступить к автоматическому обновлению сервера до следующей версии:</p>
<p><strong>{$a}</strong>.</p>
<p>Если Вы сделаете это, то не сможете вернуться назад. Учтите, что этот процесс может занимать много времени.</p>
<p>Вы уверены, что хотите обновить сервер до этой версии?</p>';
$string['upgradetimedout'] = 'Обновление прервано; пожалуйста, перезапустите обновление.';
$string['upgradingdata'] = 'Обновление данных';
$string['upgradinglogs'] = 'Обновление отчетов (logs)';
$string['upgradingversion'] = 'Обновление до новой версии';
$string['upwards'] = 'самая новая';
$string['useblogassociations'] = 'Включить ассоциации';
$string['useexternalyui'] = 'Использовать онлайн версии библиотеки YUI';
$string['user'] = 'Пользователь';
$string['userbulk'] = 'Действия над несколькими пользователями';
$string['userlist'] = 'Список пользователей';
$string['userpolicies'] = 'Политики пользователя';
$string['userpreference'] = 'Настройки пользователя';
$string['userquota'] = 'Квота пользователя';
$string['users'] = 'Пользователи';
$string['usesitenameforsitepages'] = 'Использовать название сайта вместо «Страницы сайта»';
$string['usetags'] = 'Включить теги';
$string['validateerror'] = 'Это значение не допустимо:';
$string['verifychangedemail'] = 'Учитывать ограничения доменов при смене почты';
$string['warningcurrentsetting'] = 'Недопустимое текущее значение: {$a}';
$string['warningiconvbuggy'] = 'Ваша версия библиотеки Iconv не поддерживает модификатор //IGNORE. Вы должны установить расширение mbstring, которое может быть использовано для очистки строк, содержащих символы не UTF-8.';
$string['webproxy'] = 'Веб-прокси';
$string['webproxyinfo'] = 'Заполните следующие параметры, если Ваш сервер Moodle не может соединяться с Интернетом напрямую. Доступ в Интернет требуется для загрузки данных о назначении ролей, языковых пакетов, часовых поясов и т.д.. <br /><em>Крайне рекомендуется расширение PHP cURL.</em>';
$string['xmlrpcrecommended'] = 'Расширение XMLRPC необходимо для связи с общественными каталогами и полезно для веб-служб и Moodle networking';
$string['yuicomboloading'] = 'Комбинированная загрузка YUI';
$string['ziprequired'] = 'Расширение PHP Zip теперь является обязательным для Moodle. Исполняемые файлы info-ZIP и библиотека PclZip больше не используются.';
$string['zlibenabled'] = 'Включить zlib';
