<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'pt', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Primeiro Alerta';
$string['alert2'] = 'Segundo Alerta';
$string['alert3'] = 'Terceiro Alerta';
$string['alert_general'] = 'Anúncio';
$string['alert_info'] = 'Informações';
$string['alertsdesc'] = 'Será apresentado na página principal do Moodle um alerta (ou vários) em três estilos diferentes. Por favor, lembre-se de desativar esta opção quando deixar de ser necessária.';
$string['alertsheading'] = 'Alertas ao Utilizador';
$string['alertsheadingsub'] = 'Mostrar mensagens importantes aos utilizadores na página principal';
$string['alerttext'] = 'Texto de Alerta';
$string['alerttextdesc'] = 'Qual é o texto que deseja exibir no seu alerta';
$string['alerttitle'] = 'Título';
$string['alerttitledesc'] = 'Título principal / cabeçalho para o alerta';
$string['alerttype'] = 'Nível';
$string['alerttypedesc'] = 'Defina o nível/tipo adequado para o alerta para melhor informar os utilizadores';
$string['alert_warning'] = 'Aviso';
$string['allclasses'] = 'Todas as Classes';
$string['allcourses'] = 'Todas as Disciplinas';
$string['allmodules'] = 'Todos os Módulos';
$string['allunits'] = 'Todas as Unidades';
$string['alternativecolors'] = 'Cores Alternativas {$a}';
$string['alternativethemecolor'] = 'Cores Alternativas do Tema {$a}';
$string['alternativethemecolordesc'] = 'Escolha as cores alternativas para o seu Tema para as {$a}. Ao ativar esta opção as cores que escolher vão sobrepor-se às cores do Tema.';
$string['alternativethemecolorname'] = 'Designação do Conjunto de Cores Alternativas {$a}';
$string['alternativethemecolornamedesc'] = 'Forneça um nome para este conjunto de cores alternativas';
$string['alternativethemecolors'] = 'Cores Alternativas do Tema';
$string['alternativethemecolorsdesc'] = 'Define as cores alternativas que o utilizador pode selecionar.';
$string['alternativethemehovercolor'] = 'Cor Alternativa do Tema (estado Hover) {$a}';
$string['alternativethemehovercolordesc'] = 'Escolha as cores alternativas para o seu Tema (estado Hover) {$a}. Ao ativar esta opção as cores que escolher vão sobrepor-se às cores do Tema.';
$string['alternativethemename'] = 'Nome para o Esquema de Cores';
$string['alternativethemenamedesc'] = 'Forneça um nome para este conjunto de cores alternativas';
$string['alwaysdisplay'] = 'Mostrar sempre';
$string['analyticsdesc'] = 'Aqui pode ativar o Google Analytics para o seu Moodle. Terá que criar uma conta gratuita no site do Google Analytics (<a href="http://analytics.google.com" target="_blank">http://analytics.google.com</a>)';
$string['analyticsheadingsub'] = 'Poderosas ferramentas de análise do Google';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Indique um URL da sua aplicação para dispositivos móveis na Google Play Store. Se não possuir uma, talvez queira considerar a hipótese de endereçar  para a versão gratuita da aplicação Moodle Mobile. (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['backtotop'] = 'Voltar ao topo';
$string['bootstrapcdn'] = 'FontAwesome da CDN';
$string['bootstrapcdndesc'] = 'Ao ativar esta opção, carregará o tipo de letra FontAwesome (Bootstrap CDN). Ative esta função se os ícones deste tipo de letra não estiverem a ser corretamente apresentados.';
$string['breadcrumbsimple'] = 'Simples';
$string['breadcrumbstyle'] = 'Estilo dos caminhos Breadcrumb';
$string['breadcrumbstyled'] = 'Fantasia';
$string['breadcrumbstyledesc'] = 'Altere aqui o estilo dos caminhos Breadcrumb';
$string['breadcrumbthin'] = 'Fino';
$string['categoryiconcategory'] = 'Ícone para a categoria: {$a->category}.';
$string['categoryicondesc'] = 'Se ativado, permitirá definir ícones para cada categoria de curso.';
$string['categoryiconheading'] = 'Ícones da Categoria';
$string['categoryiconheadingsub'] = 'Use ícones para representar suas categorias';
$string['categoryiconinfo'] = 'Configurar Ícones da Categoria';
$string['categoryiconinfodesc'] = 'Insira o nome do ícone que pretende usar. Consulte a Lista <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a>. Insira apenas o texto que se segue após: "fa-".';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class=img-polaroid src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Acerca do Tema: Essential</h3>
<p>Essential é um tema modificado do Moodle bootstrap baseado do tema base/original Moodle.</p>
<h3>Percursores</h3>
<p>Tema baseado num tema Bootstrap, criado para o Moodle 2.5, com o aucílio de:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Créditos do Tema</h3>
<p>Autor Original: Julian Ridden<br>
Desenvolvido em Julho de 2014 por:<br>
Gareth J. Barnard<br>
David Bezemer<br>
</p>
</div></div>';
$string['colordesc'] = 'Aqui poderá encontrar várias definições para alterar muitas das cores usadas neste tema.';
$string['colorheading'] = 'Definições de cor';
$string['colorheadingsub'] = 'Defina as cores usadas no tema';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Informações de contato';
$string['contactinfodesc'] = 'Insira as suas informações de contato';
$string['copyright'] = 'Direitos de autor';
$string['copyrightdesc'] = 'Nome de sua organização.';
$string['customcss'] = 'CSS Personalizado';
$string['customcssdesc'] = 'As regras de CSS que adicionar aqui serão refletidas em todas as páginas, tornando mais fácil a personalização deste tema.';
$string['defaultcategoryicon'] = 'Categoria Padrão dos Ícones';
$string['defaultcategoryicondesc'] = 'Definir um ícone de categoria padrão';
$string['defaultcolors'] = 'Cores Padrão';
$string['displayafterlogin'] = 'Mostrar apenas após da autenticação (login)';
$string['displaybeforelogin'] = 'Mostrar apenas antes da autenticação (login)';
$string['displaymycourses'] = 'Mostrar cursos com inscrições';
$string['displaymycoursesdesc'] = 'Mostrar aos utilizadores, no Menu Personalizado,  os cursos com inscrições';
$string['dontdisplay'] = 'Nunca Mostrar';
$string['enablealert'] = 'Ativar Alerta';
$string['enablealertdesc'] = 'Ativar ou desativar alertas';
$string['enablealternativethemecolors'] = 'Ativar Cores Alternativas para o Tema';
$string['enablealternativethemecolorsdesc'] = 'Se ativado, o utilizador poderá escolher cores alternativas para o tema {$a}.';
$string['enablecategoryicon'] = 'Ativar Ícones da Categoria';
$string['enablecategoryicondesc'] = 'Se ativado, poderá selecionar ícones da categoria depois de clicar em "Guardar alterações".';
$string['enablecustomcategoryicon'] = 'Ativar Ícones da Categoria Personalizados';
$string['enablecustomcategoryicondesc'] = 'Se ativado, verá em cada categoria com uma opção personalizável. Por favor, guarde após ativar ou desativar esta opção.';
$string['facebook'] = 'Endereço URL do Facebook';
$string['facebookdesc'] = 'URL do Facebook. Exemplo: https://www.facebook.com/mycollege';
$string['fixedwidthnarrow'] = 'Largura Fixa - Estreito';
$string['fixedwidthwide'] = 'Largura Fixa - Largo';
$string['flickr'] = 'Endereço URL do Flickr';
$string['flickrdesc'] = 'Insira o endereço URL do Flickr. Exemplo: http://www.flickr.com/photos/mycollege';
$string['fontselect'] = 'Selector do Tipo de Letra';
$string['fontselectdesc'] = 'Escolha a partir da lista de combinações de tipos de letra disponíveis. Se necessário, poderá desativar os tipos de letra do Google.';
$string['footercolor'] = 'Cor de Fundo do Rodapé';
$string['footercolordesc'] = 'Defina a cor de fundo da caixa de rodapé.';
$string['footercolors'] = 'Cores do Rodapé';
$string['footercolorsdesc'] = 'Alterar as cores no rodapé das páginas';
$string['footerheadingcolor'] = 'Cor do Cabeçalho do Rodapé';
$string['footerheadingcolordesc'] = 'Definir a cor para os títulos do bloco no rodapé.';
$string['footerhovercolor'] = 'Cor (estado Hover) das Hiperligações (links) no Rodapé';
$string['footerhovercolordesc'] = 'Defina a cor das hiperligações (estado Hover) no Rodapé.';
$string['footersepcolor'] = 'Cor do Separador no Rodapé';
$string['footersepcolordesc'] = 'Separadores são linhas usadas para separar conteúdo. Defina a cor dessas linhas aqui.';
$string['footertextcolor'] = 'Cor do Texto no Rodapé';
$string['footertextcolordesc'] = 'Defina a cor do texto no rodapé.';
$string['footerurlcolor'] = 'Cor das Hiperligações no Rodapé';
$string['footerurlcolordesc'] = 'Defina a cor das hiperligações no Rodapé.';
$string['footnote'] = 'Nota de Rodapé';
$string['footnotedesc'] = 'O que colocar nesta área será apresentado no Rodapé do Moodle.';
$string['frontcontentarea'] = 'Conteúdo da Página Principal';
$string['frontcontentareadesc'] = 'Tudo o que inserir nesta caixa será exibido em toda a largura da página, entre o Slideshow e as áreas de Marketing';
$string['frontcontentdesc'] = 'Adicione uma área personalizada de conteúdo entre o Slideshow e as caixas de Marketing onde poderá inserir conteúdo personalizado';
$string['frontcontentheading'] = 'Configurações da Página Principal';
$string['frontpageblocksdesc'] = 'Aqui poderá definir se pretende o alinhamento dos blocos à esquerda ou à direita na Página Principal';
$string['frontpagemiddleblocks'] = 'Ativar Blocos Intermédios na Página Principal';
$string['frontpagemiddleblocksdesc'] = 'Se ativado, apresentará 3 novos locais para blocos por baixo da área de Marketing';
$string['genericsettings'] = 'Configurações Gerais';
$string['googleplus'] = 'Endereço URL do Google+';
$string['googleplusdesc'] = 'Insira o Endereço URL do perfil do Google+. Exemplo: https://plus.google.com/+mycollege';
$string['hideonphone'] = 'Esconder Slideshow nos Telemóveis';
$string['hideonphonedesc'] = 'Aqui poderá desativar a apresentação do Slideshow nos Telemóveis.';
$string['hideontablet'] = 'Esconder Slideshow nos Tablets';
$string['hideontabletdesc'] = 'Aqui poderá desativar a apresentação do Slideshow nos Tablets.';
$string['instagram'] = 'Endereço URL Instagram';
$string['instagramdesc'] = 'Insira o endereço URL da sua pánina do Instagram. Exemplo: http://instagram.com/mycollege.';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Fornecer um endereço URL da sua aplicação móvel na App Store. Se não possuir uma, talvez queira considerar a hipótese de endereçar  para a versão gratuita da aplicação Moodle Mobile. (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'Ícones no ecrã principal do iOS';
$string['iosicondesc'] = 'Este tema providencia ícones padrão para iOS e Android. Contudo, se pretender, poderá carregar ícones personalizados.';
$string['ipadicon'] = 'Ícones para iPad (não Retina)';
$string['ipadicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 72 x 72px';
$string['ipadretinaicon'] = 'Ícones para iPad (Retina)';
$string['ipadretinaicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 144 x 144px';
$string['iphoneicon'] = 'Ícones iPhone/iPod Touch (não Retina)';
$string['iphoneicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 57 x 57px';
$string['iphoneretinaicon'] = 'Ícones iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 144 x 144px';
$string['layout'] = 'Use um layout de curso padrão';
$string['layoutdesc'] = 'Este tema foi concebido para colocar de lado ambos os blocos das colunas. Se preferir o layout padrão do Moodle deve marcar esta esta opção.';
$string['left'] = 'Esquerda';
$string['linkedin'] = 'Endereço URL do LinkedIn';
$string['linkedindesc'] = 'Insira o endereço URL da sua página do LinkedIn. Exemplo: https://www.linkedin.com/company/mycollege.';
$string['logo'] = 'Logótipo';
$string['logodesc'] = 'Por favor, carregue o seu logótipo personalizado aqui para que apareça no cabeçalho.<br> Carregando o seu logótipo personalizado ele substituirá o logótipo padrão.';
$string['marketing1'] = 'Área de Marketing 01';
$string['marketing2'] = 'Área de Marketing 02';
$string['marketing3'] = 'Área de Marketing 03';
$string['marketingbuttontext'] = 'Texto de Hiperligação (link)';
$string['marketingbuttontextdesc'] = 'Texto para Rótulo do Botão';
$string['marketingbuttonurl'] = 'Endereço URL';
$string['marketingbuttonurldesc'] = 'Endereço URL do Botão';
$string['marketingcontent'] = 'Conteúdo';
$string['marketingcontentdesc'] = 'Texto (curto) para apresentar na caixa de Marketing.';
$string['marketingdesc'] = 'Este Tema disponibiliza 3 áreas de "Marketing" ou "Publicidade" imediatamente abaixo do Slideshow. Estas áreas permitem apresentar informação relevante aos utilizadores.';
$string['marketingheading'] = 'Áreas de Marketing';
$string['marketingheadingsub'] = 'Três locais na Página Principal para adicionar informação e hiperligações (linnks)';
$string['marketingheight'] = 'Altura (px) das Imagens (Marketing)';
$string['marketingicon'] = 'Ícone';
$string['marketingimage'] = 'Imagem';
$string['marketingimagedesc'] = 'Esta opção permite apresentar uma imagem por cima do texto na área de Marketing';
$string['marketinginfodesc'] = 'Configure a sua área de Marketing';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a apresentar na área de Marketing';
$string['marketingurltarget'] = 'Hiperligação (link) de destino';
$string['marketingurltargetdesc'] = 'Escolha a forma como a hiperligação deve ser aberta';
$string['marketingurltargetnew'] = 'Nova Página';
$string['marketingurltargetparent'] = 'Frame';
$string['marketingurltargetself'] = 'Página Atual';
$string['mobileappsdesc'] = 'Possui alguma aplicação Web na App Store ou Google Play Store? Indique aqui a hiperligação (link)';
$string['mobileappsheading'] = 'Aplicações Móveis';
$string['mobileappsheadingsub'] = 'Hiperligação (link) para a sua Aplicação';
$string['myclasses'] = 'As Minhas Turmas';
$string['mycourses'] = 'Os Meus Cursos';
$string['mycoursesinfo'] = 'Listagem de Alunos inscritos dinamicamente';
$string['mycoursesinfodesc'] = 'Apresentar uma listagem dinâmica de alunos inscritos';
$string['mycoursetitle'] = 'Designação';
$string['mymodules'] = 'Os Meus Módulos';
$string['myunits'] = 'As Minhas Unidades';
$string['nextsection'] = 'Próxima Secção';
$string['nobreadcrumb'] = 'Esconder';
$string['noenrolments'] = 'Não tem nenhuma inscrição';
$string['noslidetitle'] = 'Slide sem título {$a->slide}';
$string['numberofslides'] = 'Número de slides';
$string['numberofslides_desc'] = 'Número de slides na barra';
$string['oldnavbar'] = 'Utilizar a posição da Barra de Navegação antiga';
$string['oldnavbardesc'] = 'Ativar esta opção para utilizar a posição da Barra de Navegação antiga';
$string['pagebackground'] = 'Imagem do Fundo da Página';
$string['pagebackgrounddesc'] = 'Carregue uma imagem para utilizar como fundo. A imagem carregada será repetida como padrão em todas as páginas. Se não carregar uma imagem será usada uma imagem padrão do tema.';
$string['pagewidth'] = 'Definir Largura da Página';
$string['pagewidthdesc'] = 'Escolha a partir da listagem uma das larguras disponíveis.';
$string['perfinfo'] = 'Informação de Performance do Moodle';
$string['perfinfodesc'] = 'Muitos sites não precisam da informação de performance totalmente detalhada. Quando ativada esta opção é apresentado um formulário com o sumário das informações básicas.';
$string['perf_max'] = 'Detalhado';
$string['perf_min'] = 'Básico';
$string['pinterest'] = 'Endereço URL do Pinterest';
$string['pinterestdesc'] = 'Insira o Endereço URL do Pinterest. Exemplo: http://pinterest.com/mycollege/mypinboard';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Secção Anterior';
$string['profilebarcustomtitle'] = 'Bloco da Barra de Perfil: Título Personalizado';
$string['profilebarcustomtitledesc'] = 'Título para o Bloco da Barra de Perfil';
$string['readmore'] = 'Ler Mais';
$string['region-footer-left'] = 'Rodapé (Esquerda)';
$string['region-footer-middle'] = 'Rodapé (Centro)';
$string['region-footer-right'] = 'Rodapé (Direita)';
$string['region-hidden-dock'] = 'Esconder dos Utilizadores';
$string['region-home-left'] = 'Página Principal (Esquerda)';
$string['region-home-middle'] = 'Página Principal (Centro)';
$string['region-home-right'] = 'Página Principal (Direita)';
$string['region-side-post'] = 'Direita';
$string['region-side-pre'] = 'Esquerda';
$string['right'] = 'Direita';
$string['siteicon'] = 'Ícone do Site';
$string['skype'] = 'Conta Skype';
$string['skypedesc'] = 'Insira o nome de utilizador da sua conta Skype. Exemplo: my.college';
$string['slidebuttoncolor'] = 'Cor do botão do Slide';
$string['slidebuttoncolordesc'] = 'Introduza a cor que pretende para o botão na barra de slides.';
$string['slidebuttonhovercolor'] = 'Cor do botão do Slide';
$string['slidebuttonhovercolordesc'] = 'Introduza a cor que pretende para o botão na barra de slides.';
$string['slidecaption'] = 'Legenda para o Slide';
$string['slidecaptiondesc'] = 'Introduza um texto curto para ser apresentado com o Slide';
$string['slidecolor'] = 'Cor do Texto no Slide';
$string['slidecolordesc'] = 'Introduza a cor que pretende para o texto na barra de slides.';
$string['slideimage'] = 'Imagem para o Slide';
$string['slideimagedesc'] = 'Para melhores resultados, a imagem que escolher deverá ter um fundo transparente.';
$string['slideinterval'] = 'Tempo de Intervalo entre Slides';
$string['slideintervaldesc'] = 'Tempo de Intervalo entre Slides em milissegundos.';
$string['slideno'] = 'Slide {$a->slide}';
$string['slidenodesc'] = 'Configuração do Slide {$a->slide}.';
$string['slideshowdesc'] = 'Esta opção cria um Slideshow dinâmico podendo conter até 16 slides para promover informação importante do seu site. O show é responsive sendo a altura da imagem configurada de acordo com o tamanho do écrã. A altura recomendada é 300 px. A largura é definida a 100%, pelo que a altura real será menor se a largura for superior ao écrã. Para écrãs pequenos a altura é reduzida dinamicamente sem ser necessário fornecer imagens diferentes. Para uma largura de referência < 767px = altura 165px, largura entre 768px e 979px = altura 225px e largura > 980px = altura 300px. Se não for selecionada imagem para um slide, então a imagem default_slide na pasta pix será usada.';
$string['slideshowheading'] = 'Slideshow da Página Principal';
$string['slideshowheadingsub'] = 'Slideshow Dinâmico para a Página Principal';
$string['slidetitle'] = 'Título do Slide';
$string['slidetitledesc'] = 'Introduza um Título sugestivo para o Slide';
$string['slideurl'] = 'Hiperligação (link) do Slide';
$string['slideurldesc'] = 'Insira um endereço de destino para a Hiperligação (link) da imagem do slide';
$string['slideurltarget'] = 'Hiperligação (link)';
$string['slideurltargetdesc'] = 'Escolha como a Hiperligação (link) deve abrir';
$string['slideurltargetnew'] = 'Nova Página';
$string['slideurltargetparent'] = 'Frame';
$string['slideurltargetself'] = 'Página Atual';
$string['socialdesc'] = 'Forneça hiperligações (links) diretos para as redes sociais que melhor promovam a sua marca. Estas ligações vão aparecer em todos os cabeçalhos das páginas.';
$string['socialheading'] = 'Redes Sociais';
$string['socialheadingsub'] = 'Envolva os seus utilizadores através das Redes Sociais';
$string['socialnetworks'] = 'Redes Sociais';
$string['themecolor'] = 'Cor do Tema';
$string['themecolordesc'] = 'Introduza a Cor que pretende para o Tema. Esta opção vai alterar alguns componentes para refletir a cor escolhida em todo o site Moodle';
$string['themecolors'] = 'Cores do Tema';
$string['themehovercolor'] = 'Cor do Tema (estado: Hover)';
$string['themehovercolordesc'] = 'Introduza uma Cor (para links, menus, etc) a ser aplicada no estado Hover.';
$string['themeurlcolor'] = 'Cor da Hiperligação (link)';
$string['themeurlcolordesc'] = 'Defina a cor que pretende atribuir às hiperligações textuais.';
$string['togglemarketing'] = 'Apresentação das Áreas de Marketing';
$string['togglemarketingdesc'] = 'Escolha se pretende esconder ou mostrar as 3 áreas de Marketing.';
$string['toggleslideshow'] = 'Apresentação do Slideshow';
$string['toggleslideshowdesc'] = 'Escolha se pretende esconder ou mostrar o Slideshow.';
$string['twitter'] = 'Endereço URL do Twitter';
$string['twitterdesc'] = 'Insira o Endereço URL do Twitter. Exemplo: https://www.twitter.com/mycollege';
$string['usecategoryicon'] = 'Ativar Ícones nas Categorias';
$string['usecategoryicondesc'] = 'Utilizar Ícones personalizados nas Categorias';
$string['variablewidth'] = 'Largura Variável';
$string['visibleadminonly'] = 'Os Blocos movidos para esta área serão apenas visíveis pelos Administradores';
$string['vk'] = 'Endereço URL VKontakte';
$string['vkdesc'] = 'Insira o Endereço URL do Vkontakte.';
$string['website'] = 'Endereço URL do Website';
$string['websitedesc'] = 'Introduza o endereço URL do seu site. Exemplo: http://www.uplearning.nl';
$string['youtube'] = 'Endereço URL do YouTube';
$string['youtubedesc'] = 'Insira o Endereço URL do YouTube. Exemplo: https://www.youtube.com/user/mycollege';
