<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'pt', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Pode pré-visualizar o teste, mas se fosse uma tentativa real seria impedido porque:';
$string['action'] = 'Ação';
$string['activityoverview'] = 'Atenção aos seus Testes! Clique aqui para mais informações.';
$string['adaptive'] = 'Modo adaptável';
$string['adaptive_help'] = 'Se selecionar \'Sim\', o aluno poderá responder várias vezes à mesma pergunta, durante a mesma tentativa de resolução do teste. Por exemplo, se a primeira resposta for incorreta, o aluno poderá, de imediato, responder novamente até acertar. Porém, se a configuração "Aplicar penalizações" estiver ativa será aplicada uma penalização na nota da pergunta por cada tentativa errada.';
$string['addaquestion'] = 'Criar pergunta';
$string['addarandomquestion'] = 'Criar pergunta aleatória';
$string['addarandomquestion_help'] = 'Quando adiciona uma pergunta aleatória, esta será selecionada aleatoriamente entre as perguntas de uma determinada categoria. Isto significa que os diferentes alunos obterão uma diferente seleção de perguntas e, quando o teste permite múltiplas tentativas, cada tentativa conterá uma diferente seleção de perguntas.';
$string['adddescriptionlabel'] = 'Adicionar descrição/legenda';
$string['addingquestion'] = 'Adicionar uma pergunta';
$string['addingquestions'] = '<p>Este lado da página permite gerir a sua base de dados de perguntas. As perguntas são guardadas em categorias de forma a organizar as mesmas e podem ser usadas em qualquer teste desta disciplina, ou mesmo noutras disciplinas, caso opte por as publicar.</p>
<p>Após selecionar ou criar uma categoria, pode criar ou editar perguntas que poderá depois adicionar ao teste, no outro lado desta página.</p>';
$string['addmoreoverallfeedbacks'] = 'Adicionar mais {no} campos de feedback';
$string['addnewgroupoverride'] = 'Adicionar exceção para grupo';
$string['addnewpagesafterselected'] = 'Iniciar página após perguntas selecionadas';
$string['addnewquestionsqbank'] = 'Adicionar perguntas à categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Adicionar exceção para utilizador';
$string['addpagehere'] = 'Inserir página';
$string['addquestion'] = 'Adicionar pergunta';
$string['addquestions'] = 'Adicionar perguntas';
$string['addquestionstoquiz'] = 'Adicionar perguntas ao teste atual';
$string['addrandom'] = 'Adicionar {$a} perguntas aleatórias';
$string['addrandom1'] = '<< Adicionar';
$string['addrandom2'] = 'perguntas aleatórias';
$string['addrandomfromcategory'] = 'Adicionar perguntas aleatórias da categoria:';
$string['addrandomquestion'] = 'Adicionar pergunta aleatória';
$string['addrandomquestiontoquiz'] = 'Adicionar uma pergunta aleatória ao teste {$a}';
$string['addselectedtoquiz'] = 'Adicionar perguntas selecionadas ao teste';
$string['addtoquiz'] = 'Adicionar ao teste';
$string['affectedstudents'] = '{$a} afetados';
$string['aftereachquestion'] = 'Após adicionar cada pergunta';
$string['afternquestions'] = 'Após adicionar {$a} perguntas';
$string['age'] = 'idade';
$string['allattempts'] = 'Todas as tentativas';
$string['allinone'] = 'Ilimitado';
$string['allowreview'] = 'Permitir revisão';
$string['alreadysubmitted'] = 'É provável que já tenha submetido esta tentativa';
$string['alternativeunits'] = 'Unidades alternativas';
$string['alwaysavailable'] = 'Sempre disponível';
$string['analysisoptions'] = 'Opções de análise';
$string['analysistitle'] = 'Análise por item';
$string['answer'] = 'Resposta';
$string['answered'] = 'Respondido';
$string['answerhowmany'] = 'Uma ou mais respostas?';
$string['answers'] = 'Respostas corretas';
$string['answersingleno'] = 'São permitidas múltiplas respostas';
$string['answersingleyes'] = 'Só é permitida uma resposta';
$string['answertoolong'] = 'Resposta demasiado extensa a partir da linha {$a} (máximo 255 car.)';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = 'Tem a certeza que deseja apagar todas as perguntas selecionadas?';
$string['asshownoneditscreen'] = 'Como exibida ao editar o teste';
$string['attempt'] = 'Tentativa {$a}';
$string['attemptalreadyclosed'] = 'Esta tentativa já foi concluída.';
$string['attemptclosed'] = 'Esta tentativa ainda não foi concluída';
$string['attemptduration'] = 'Tempo usado';
$string['attemptedon'] = 'Tentativa em';
$string['attempterror'] = 'Não possui permissão para realizar o teste porque : {$a}';
$string['attemptfirst'] = 'Primeira tentativa';
$string['attemptincomplete'] = 'Essa tentativa (feita por {$a}) ainda não foi concluída';
$string['attemptlast'] = 'Última tentativa';
$string['attemptnumber'] = 'Tentativa';
$string['attemptquiznow'] = 'Responder ao teste agora';
$string['attempts'] = 'Tentativas';
$string['attemptsallowed'] = 'Tentativas permitidas';
$string['attemptsdeleted'] = 'Tentativas apagadas';
$string['attemptselection'] = 'Selecione quais as tentativas a analisar por utilizador';
$string['attemptsexist'] = 'Já não é possível adicionar ou remover perguntas.';
$string['attemptsnum'] = 'Tentativas: {$a}';
$string['attemptsnumthisgroup'] = 'Tentativas: {$a->total} ({$a->group} deste grupo)';
$string['attemptsnumyourgroups'] = 'Tentativas: {$a->total} ({$a->group} dos seus grupos)';
$string['attemptsonly'] = 'Mostrar apenas os alunos com tentativas';
$string['attemptstate'] = 'Estado';
$string['attemptstillinprogress'] = 'Tentativa ainda em progresso';
$string['attemptsunlimited'] = 'Tentativas ilimitadas';
$string['autosaveperiod'] = 'Intervalo de tempo entre cada gravação automática';
$string['autosaveperiod_desc'] = 'As respostas dos alunos podem ser guardadas automaticamente, em intervalos de alguns minutos, durante as tentativas de realização do teste. Esta funcionalidade aumenta a carga do servidor mas, em contrapartida, reduz a possibilidade de que os alunos percam o seu trabalho.';
$string['back'] = 'Voltar à pré-visualização da pergunta';
$string['backtocourse'] = 'Voltar à disciplina';
$string['backtoquestionlist'] = 'Voltar à lista de perguntas';
$string['backtoquiz'] = 'Voltar à edição do teste';
$string['basicideasofquiz'] = 'Ajuda';
$string['bestgrade'] = 'Melhor nota';
$string['bothattempts'] = 'Mostrar todos os alunos';
$string['browsersecurity'] = 'Segurança do Navegador';
$string['browsersecurity_help'] = 'Se escolher a opção "Ecrã inteiro em janela pop-up e segurança JavaScript",

* O teste apenas começa se o aluno tiver um browser que suporte JavaScript
* O teste surge num ecrã inteiro numa janela pop-up que sobrepõe todas as outras janelas, não havendo possibilidade de aceder a outros controlos de navegação
* Os alunos são impedidos de utilizar opções como copiar e colar';
$string['calculated'] = 'Calculada';
$string['calculatedquestion'] = 'A pergunta calculada não é suportada na alínea {$a}. A pergunta será ignorada.';
$string['cannotcreatepath'] = 'O caminho não pode ser criado ({$a})';
$string['cannoteditafterattempts'] = 'Não pode adicionar nem remover perguntas porque já houve tentativas de resolução do teste.';
$string['cannotfindprevattempt'] = 'Não foi possível encontrar a tentativa anterior para servir de base.';
$string['cannotfindquestionregard'] = 'Não foi possível obter perguntas para reavaliar!';
$string['cannotinsert'] = 'Não é possível adicionar a pergunta';
$string['cannotinsertrandomquestion'] = 'Não foi possível adicionar uma nova pergunta aleatória!';
$string['cannotloadquestion'] = 'Não foi possível carregar as opções da pergunta';
$string['cannotloadtypeinfo'] = 'Não é possível carregar as informações específicas da pergunta';
$string['cannotopen'] = 'Não é possível abrir o ficheiro exportado ({$a})';
$string['cannotrestore'] = 'Não foi possível restaurar as sessões das perguntas';
$string['cannotreviewopen'] = 'Não pode rever esta tentativa pois ainda está em curso.';
$string['cannotsavelayout'] = 'Não foi possível guardar a aparência';
$string['cannotsavenumberofquestion'] = 'Não foi possível guardar o número de perguntas por página';
$string['cannotsavequestion'] = 'Não é possível guardar a lista de perguntas';
$string['cannotsetgrade'] = 'Não foi possível definir uma nova nota máxima para o teste';
$string['cannotsetsumgrades'] = 'Não foi possível definir somatórios das notas';
$string['cannotstartgradesmismatch'] = 'Não é possível iniciar uma tentativa de resolução do teste. Está configurado para uma nota de {$a->grade}, mas nenhuma das perguntas tem uma nota associada. Pode alterar isto na página de edição do teste.';
$string['cannotstartmissingquestion'] = 'Não é possível iniciar uma tentativa. As definições do teste incluem uma pergunta que não existe.';
$string['cannotstartnoquestions'] = 'Não é possível iniciar uma tentativa de resolução do teste. O teste ainda não foi configurado nem foram adicionadas perguntas';
$string['cannotwrite'] = 'Não é possível escrever no ficheiro de exportação ({$a})';
$string['caseno'] = 'Não. Ignorar maiúsculas/minúsculas';
$string['casesensitive'] = 'Respeitar maiúsculas/minúsculas';
$string['caseyes'] = 'Sim. Respeitar maiúsculas/minúsculas';
$string['categories'] = 'Categorias';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'A categoria {$a} foi adicionada';
$string['categorydeleted'] = 'A categoria {$a} foi apagada';
$string['categorynoedit'] = 'Não tem permissões de edição na categoria {$a}';
$string['categoryupdated'] = 'A categoria foi atualizada com sucesso';
$string['close'] = 'Fechar janela';
$string['closebeforeopen'] = 'Não foi possível atualizar o teste. Definiu uma data de fecho anterior à data de abertura.';
$string['closed'] = 'Fechado';
$string['closepreview'] = 'Fechar pré-visualização';
$string['closereview'] = 'Fechar revisão';
$string['comment'] = 'Comentário';
$string['commentorgrade'] = 'Introduzir comentário ou ajustar a nota';
$string['comments'] = 'Comentários';
$string['completedon'] = 'Completo em';
$string['configadaptive'] = 'Se selecionar \'Sim\', os alunos podem responder várias vezes à mesma pergunta na mesma tentativa de resolução do teste.';
$string['configattemptsallowed'] = 'Restrição no número de tentativas de resolução do teste que os alunos podem fazer.';
$string['configdecimaldigits'] = 'Número de casas decimais apresentadas na nota.';
$string['configdecimalplaces'] = 'Número de casas decimais apresentadas na nota do teste.';
$string['configdecimalplacesquestion'] = 'Número de casas decimais apresentadas na nota das perguntas individuais.';
$string['configdelay1'] = 'Se definir um tempo de espera, o aluno terá de esperar para realizar uma nova tentativa do teste depois de ter concluído a primeira tentativa.';
$string['configdelay1st2nd'] = 'Se definir um tempo de espera, o aluno terá de esperar esse tempo para poder realizar uma nova tentativa do teste depois de ter concluído a primeira tentativa.';
$string['configdelay2'] = 'Se definir um tempo de espera, o aluno terá de esperar para realizar uma nova tentativa do teste depois de ter concluído a segunda ou posterior tentativa.';
$string['configdelaylater'] = 'Se definir um tempo de espera, o aluno terá de esperar esse tempo para poder realizar uma nova tentativa do teste depois de ter concluído a segunda tentativa ou posterior.';
$string['configeachattemptbuildsonthelast'] = 'Se o teste tiver múltiplas tentativas, cada nova tentativa conterá os resultados da anterior.';
$string['configgrademethod'] = 'Nos testes com múltiplas tentativas, qual o método de cálculo da nota final do aluno no teste.';
$string['configintro'] = 'As configurações seguintes serão usadas por predefinição sempre que criar um novo teste. Poderá também definir quais as configurações do teste que serão consideradas avançadas.';
$string['configmaximumgrade'] = 'Nota máxima predefinida do teste.';
$string['confignavmethod'] = 'Na navegação livre, as perguntas podem ser respondidas sem qualquer ordem usando a navegação. Em Sequencial,as perguntas devem ser respondidas em sequência estrita.';
$string['confignewpageevery'] = 'Ao adicionar perguntas ao teste, são inseridas quebras de página de acordo com a opção que escolher aqui.';
$string['configoutcomesadvanced'] = 'Se esta opção estiver ativa, então as competências na edição do teste são consideradas opções avançadas.';
$string['configpenaltyscheme'] = 'Aplicar penalização da pergunta a cada resposta errada, quando o teste está configurado em modo adaptável.';
$string['configpopup'] = 'Forçar o teste a abrir numa janela de pop-up e usar o Javascript para restringir a possibilidade de copiar e colar, etc. durante as tentativas de resolução';
$string['configrequirepassword'] = 'Os alunos devem introduzir uma senha para aceder ao teste.';
$string['configrequiresubnet'] = 'Os alunos só podem aceder aos testes a partir destes computadores.';
$string['configreviewoptions'] = 'Estas opções definem que informação será exibida aos utilizadores quando estes fazem a revisão do teste ou consultam os relatórios do teste.';
$string['configshowblocks'] = 'Mostrar blocos durante a resolução do teste.';
$string['configshowuserpicture'] = 'Mostrar a fotografia do utilizador durante a resolução do teste.';
$string['configshufflequestions'] = 'Se ativar esta opção, a ordem das perguntas do teste será definida aleatoriamente em cada tentativa que o aluno fizer para responder ao teste.';
$string['configshufflewithin'] = 'Se ativar esta opção, a ordem dos itens que integram cada pergunta individual será definida aleatoriamente em cada tentativa que o aluno fizer para responder ao teste, desde que esta opção também esteja ativa na configuração da pergunta.';
$string['configtimelimit'] = 'Tempo máximo para realização do teste (em minutos). 0 (zero) significa sem tempo limite.';
$string['configtimelimitsec'] = 'Tempo máximo para realização do teste (em segundos). 0 (zero) significa sem tempo limite.';
$string['configurerandomquestion'] = 'Configurar pergunta';
$string['confirmclose'] = 'Está prestes a concluir esta tentativa. Uma vez concluída, não poderá alterar as suas respostas.';
$string['confirmserverdelete'] = 'Tem a certeza que deseja apagar o servidor<b>{$a}</b> da lista?';
$string['confirmstartattemptlimit'] = 'Este teste permite um máximo de {$a} tentativa(s). Está prestes a começar uma nova tentativa. Deseja continuar?';
$string['confirmstartattempttimelimit'] = 'Este teste tem tempo limite e o número máximo de tentativas de resolução é {$a}. Está prestes a começar uma nova tentativa. Deseja continuar?';
$string['confirmstarttimelimit'] = 'Este teste tem tempo limite. Tem a certeza que deseja responder ao teste?';
$string['connectionerror'] = 'Ligação à rede perdida (gravação automática falhou).

Anote quaisquer respostas inseridas nesta página nos últimos minutos e tente ligar novamente à rede.

Quando a ligação for restabelecida, as suas respostas devem ser guardadas e esta mensagem irá desaparecer.';
$string['connectionok'] = 'Conexão de rede restaurada. Pode continuar com segurança.';
$string['containercategorycreated'] = 'Esta categoria foi criada para guardar todas as categorias movidas para o nível do site, devido às seguintes razões.';
$string['continueattemptquiz'] = 'Continuar a última tentativa';
$string['continuepreview'] = 'Continuar a última pré-visualização';
$string['copyingfrom'] = 'Criar uma cópia da pergunta {$a}';
$string['copyingquestion'] = 'A copiar a pergunta';
$string['correct'] = 'Correto';
$string['correctanswer'] = 'Resposta correta';
$string['correctanswerformula'] = 'Fórmula da resposta correta';
$string['correctansweris'] = 'Resposta correta: {$a}';
$string['correctanswerlength'] = 'Algarismos significativos';
$string['correctanswers'] = 'Respostas corretas';
$string['correctanswershows'] = 'A resposta correta é exibida';
$string['corrresp'] = 'Resposta correta';
$string['countdown'] = 'Contagem decrescente';
$string['countdownfinished'] = 'O teste está prestes a terminar. Deve submeter imediatamente as suas respostas.';
$string['countdowntenminutes'] = 'O teste vai fechar dentro de 10 minutos.';
$string['coursetestmanager'] = 'Formato Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Criar categoria e adicionar pergunta aleatória';
$string['createfirst'] = 'Primeiro deve criar perguntas de resposta curta.';
$string['createmultiple'] = 'Adicionar várias perguntas aleatórias ao teste';
$string['createnewquestion'] = 'Criar nova pergunta';
$string['createquestionandadd'] = 'Criar nova pergunta e adicionar ao teste';
$string['custom'] = 'Formato personalizado';
$string['dataitemneed'] = 'Necessita de adicionar pelo menos um conjunto de dados para a pergunta ser válida';
$string['datasetdefinitions'] = 'Definições do conjunto de dados reutilizável para a categoria {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Disponibilidade (em dias)';
$string['decimaldigits'] = 'Casas decimais na nota do teste';
$string['decimalplaces'] = 'Casas decimais na nota do teste';
$string['decimalplaces_help'] = 'Esta configuração estabelece o número de casas decimais com que as notas do teste são exibidas. Isto afeta apenas a visualização das notas e não a forma como são armazenadas nem como são feitos os cálculos, os quais são realizados com precisão total.';
$string['decimalplacesquestion'] = 'Casas decimais nas notas das perguntas';
$string['decimalplacesquestion_help'] = 'Esta configuração estabelece o número de casas decimais com que as notas das perguntas individuais são exibidas.';
$string['decimalpoints'] = 'Casas decimais';
$string['default'] = 'Predefinido';
$string['defaultgrade'] = 'Nota predefinida da pergunta';
$string['defaultinfo'] = 'A categoria predefinida para as perguntas.';
$string['delay1'] = 'Intervalo de tempo entre a primeira e a segunda tentativas';
$string['delay1st2nd'] = 'Tempo de espera entre a primeira e segunda tentativa';
$string['delay1st2nd_help'] = 'Se ativar esta opção, o aluno deve aguardar o tempo especificado antes de tentar resolver o teste pela segunda vez.';
$string['delay2'] = 'Tempo de espera entre tentativas posteriores';
$string['delaylater'] = 'Tempo de espera entre tentativas posteriores';
$string['delaylater_help'] = 'Se ativar esta opção, o aluno deve aguardar o tempo especificado antes de tentar resolver o teste pela terceira vez e seguintes.';
$string['deleteattemptcheck'] = 'Tem a certeza absoluta que deseja apagar estas tentativas?';
$string['deleteselected'] = 'Apagar as selecionadas';
$string['deletingquestionattempts'] = 'A apagar tentativas de resolução da pergunta';
$string['description'] = 'Descrição';
$string['disabled'] = 'Desativado';
$string['displayoptions'] = 'Opções de visualização';
$string['donotuseautosave'] = 'Não usar a gravação automática';
$string['download'] = 'Clique para descarregar o ficheiro de categorias exportado';
$string['downloadextra'] = '(o ficheiro é igualmente guardado, na área de ficheiros da disciplina, na pasta /backupdata/quiz folder)';
$string['duplicateresponse'] = 'Esta submissão foi ignorada pois já havia dado uma resposta equivalente.';
$string['eachattemptbuildsonthelast'] = 'Cada tentativa contém resultados da anterior';
$string['eachattemptbuildsonthelast_help'] = 'Se forem permitidas múltiplas tentativas e ativar esta opção, cada nova tentativa de resolução irá conter os resultados da tentativa anterior. Esta opção permite que as respostas ao teste sejam aperfeiçoadas em várias tentativas.';
$string['editcategories'] = 'Editar categorias';
$string['editcategory'] = 'Editar categoria';
$string['editcatquestions'] = 'Editar perguntas da categoria';
$string['editingquestion'] = 'A editar uma pergunta';
$string['editingquiz'] = 'Editar teste';
$string['editingquiz_help'] = 'Quando cria um teste, os principais conceitos são:

* O teste, que contém perguntas em uma ou mais páginas
* A base de dados de perguntas, que guarda cópias de todas as perguntas, organizadas em categorias
* As perguntas aleatórias, que permitem que os testes dos alunos sejam diferentes a cada nova tentativa de resolução';
$string['editingquiz_link'] = 'mod/testes/editar';
$string['editingquizx'] = 'Editar teste: {$a}';
$string['editoverride'] = 'Editar exceção';
$string['editqcats'] = 'Editar categorias';
$string['editquestions'] = 'Editar perguntas';
$string['editquiz'] = 'Editar teste';
$string['editquizquestions'] = 'Editar perguntas do teste';
$string['emailconfirmbody'] = 'Caro {$a->username},

Obrigado por ter respondido ao teste
{$a->quizname} na disciplina {$a->coursename}
em {$a->submissiontime}.

Este e-mail confirma que recebemos as suas respostas.

Para consultar o teste clique em {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Obrigado por submeter as suas respostas no teste {$a->quizname}';
$string['emailconfirmsubject'] = 'Confirmação de submissão do teste: {$a->quizname}';
$string['emailnotifybody'] = 'Caro {$a->username},

{$a->studentname} completou o teste {$a->quizname} ({$a->quizurl}) na disciplina {$a->coursename}

Pode rever esta tentativa em {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} completou {$a->quizname}. Ver {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} completou o teste {$a->quizname}';
$string['emailoverduebody'] = 'Caro(a) {$a->studentname},

Iniciou uma tentativa no teste \'{$a->quizname}\'
na disciplina \'{$a->coursename}\', mas não a submeteu. Deve fazê-lo até ao final de {$a->attemptduedate}.

Se desejar submeter a sua tentativa agora, vá até {$a->attemptsummaryurl} e clique no botão de submeter.
Tem de o fazer antes do fim de {$a->attemptgraceend}
ou a sua tentativa não será avaliada.';
$string['emailoverduesmall'] = 'Não submeteu a sua tentativa de resolução do teste {$a->quizname}.Vá até {$a->attemptsummaryurl} antes de {$a->attemptgraceend} se desejar submetê-la para avaliação.';
$string['emailoverduesubject'] = 'Tentativa expirada: {$a->quizname}';
$string['empty'] = 'Vazio';
$string['enabled'] = 'Ativado';
$string['endtest'] = 'Terminar tentativa';
$string['erroraccessingreport'] = 'Não pode consultar este relatório';
$string['errorinquestion'] = 'Erro na pergunta';
$string['errormissingquestion'] = 'Erro: A pergunta com id {$a} está em falta no sistema.';
$string['errornotnumbers'] = 'Erro - as respostas têm de ser numéricas';
$string['errorunexpectedevent'] = 'Foi encontrado um código de evento inesperado {$a->event} para a pergunta {$a->questionid} na tentativa {$a->attemptid}.';
$string['essay'] = 'Desenvolvimento';
$string['essayquestions'] = 'Perguntas';
$string['eventquizattemptabandoned'] = 'Tentativa de teste abandonada';
$string['eventquizattemptstarted'] = 'Tentativa de teste iniciada';
$string['eventquizattemptsubmitted'] = 'Tentativa de teste submetida';
$string['eventquizattempttimelimitexceeded'] = 'Tempo limite excedido da tentativa de teste';
$string['everynquestions'] = 'A cada {$a} perguntas';
$string['everyquestion'] = 'A cada nova pergunta inserida';
$string['everythingon'] = 'Tudo em';
$string['export'] = 'Exportar';
$string['exportcategory'] = 'exportar categoria';
$string['exporterror'] = 'Ocorreu um erro durante o processo de exportação';
$string['exportingquestions'] = 'As perguntas estão a ser exportadas para um ficheiro';
$string['exportname'] = 'Nome do ficheiro';
$string['exportquestions'] = 'Exportar perguntas para um ficheiro';
$string['extraattemptrestrictions'] = 'Outras restrições na realização do teste';
$string['false'] = 'Falso';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'O valor do limite de avaliação para o Feedback deve ser uma percentagem ou um número. O valor que introduziu no limite  {$a} não foi reconhecido.';
$string['feedbackerrorboundaryoutofrange'] = 'O valor do limite de avaliação para o Feedback deve estar entre 0% e 100%. O valor que introduziu no limite {$a} encontra-se fora desse intervalo.';
$string['feedbackerrorjunkinboundary'] = 'Deve preencher os limites de avaliação sem deixar intervalos em branco.';
$string['feedbackerrorjunkinfeedback'] = 'Deve preencher os campos de Feedback sem deixar intervalos em branco.';
$string['feedbackerrororder'] = 'Os limites de avaliação devem ser introduzido por ordem decrescente. O valor que introduziu no limite de avaliação $a não respeita a ordem.';
$string['file'] = 'Ficheiro';
$string['fileformat'] = 'Formato de ficheiro';
$string['fillcorrect'] = 'Preencher com o correto';
$string['filloutnumericalanswer'] = 'Indique pelo menos uma resposta possível e a sua margem de erro. A primeira resposta possível que coincidir com a do aluno será usada para determinar a nota e o feedback. Se escrever algum feedback sem resposta no último campo, este será apresentado às respostas que não se enquadrem em nenhuma das anteriores.';
$string['filloutoneanswer'] = 'Deve preencher pelo menos uma resposta possível. As respostas em branco não serão consideradas.* pode ser usado como um carácter universal para representar qualquer sequência de caracteres. A primeira resposta possível que coincidir com a do aluno será usada para determinar a nota e o feedback.';
$string['filloutthreequestions'] = 'Deve preencher pelo menos três perguntas com respostas correspondentes. Pode acrescentar respostas extra erradas, introduzindo a resposta e deixando a pergunta em branco. As perguntas em que tanto a pergunta como a resposta se encontrem em branco serão ignoradas.';
$string['fillouttwochoices'] = 'Deve preencher pelo menos duas opções. Opções em branco serão ignoradas.';
$string['finishattemptdots'] = 'Terminar tentativa';
$string['finishreview'] = 'Terminar revisão';
$string['forceregeneration'] = 'forçar regeneração';
$string['formatnotfound'] = 'não foi encontrado o formato {$a} de importação/exportação';
$string['formatnotimplemented'] = 'Este formato não foi implementado corretamente, por favor reporte este erro.';
$string['formulaerror'] = 'Fórmula com erros!';
$string['fractionsaddwrong'] = 'As notas positivas que selecionou não somam 100%.<br />A soma é de {$a}%<br /> Deseja voltar atrás e corrigir esta pergunta?';
$string['fractionsnomax'] = 'Uma das respostas deve ter a nota de 100% para que seja <br /> possível obter a nota máxima nesta pergunta.
<br /> Deseja voltar atrás e corrigir esta pergunta?';
$string['fromfile'] = 'do ficheiro:';
$string['functiondisabledbysecuremode'] = 'Essa funcionalidade está de momento desativada';
$string['generalfeedback'] = 'Feedback geral';
$string['generalfeedback_help'] = 'O feedback geral consiste num texto que é exibido quando é submetida uma resposta. Ao contrário do feedback específico, que depende da resposta do aluno, o feedback geral é sempre o mesmo.';
$string['graceperiod'] = 'Tempo extra';
$string['graceperiod_desc'] = 'Tempo extra predefinido, em segundos, se a opção \'Quando o tempo termina\' estiver configurada como \'É permitido um tempo extra para submeter, mas sem alterar respostas\'.';
$string['graceperiod_help'] = 'Tempo extra permitido se a opção \'Quando o tempo termina\' estiver configurada como \'É permitido um tempo extra para submeter, mas sem alterar respostas\'.';
$string['graceperiodmin'] = 'Tempo extra para processamento';
$string['graceperiodmin_desc'] = 'Existe um problema potencial quando o limite de tempo é atingido e o teste termina. Pretende-se que os alunos aproveitem o tempo limite até ao último segundo - com a ajuda do cronómetro que submete automaticamente o teste quando o tempo se esgota. Porém, o servidor pode ficar sobrecarregado naquele momento e levar algum tempo a processar as respostas submetidas. Por esta razão, esta configuração permite que sejam aceites as submissões durante o número de segundos aqui definido, após o tempo terminar. Deste modo os alunos são penalizados pela lentidão do servidor. No entanto, o aluno pode fazer batota e usufruir deste tempo extra para continuar a responder ao teste. Tem que tomar esta decisão com base na confiança que tem no desempenho do seu servidor durante a realização dos testes.';
$string['graceperiodtoosmall'] = 'O tempo extra deve ser superior a {$a}.';
$string['grade'] = 'Nota';
$string['gradeall'] = 'Avaliar tudo';
$string['gradeaverage'] = 'Nota média';
$string['gradeboundary'] = 'Limite de avaliação';
$string['gradeessays'] = 'Avaliar perguntas de desenvolvimento';
$string['gradehighest'] = 'Nota mais alta';
$string['grademethod'] = 'Método de avaliação';
$string['grademethod_help'] = 'Quando o teste é configurado com múltiplas tentativas, o cálculo da nota final é realizado segundo um dos seguintes métodos:

* Nota mais alta de todas as tentativas
* Nota média de todas as tentativas
* Primeira tentativa (Todas as outras tentativas são ignoradas)
* Última tentativa (Todas as outras tentativas são ignoradas)';
$string['gradesdeleted'] = 'As notas do teste foram apagadas';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Notas para esta submissão: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Com as penalizações anteriores fica com <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Esta submissão foi penalizada com {$a}.';
$string['gradingdetailszeropenalty'] = 'Não sofreu penalizações com esta submissão.';
$string['gradingmethod'] = 'Método de avaliação: {$a}';
$string['groupoverrides'] = 'Exceções para grupos';
$string['groupsnone'] = 'Não existem grupos nesta disciplina';
$string['guestsno'] = 'Os visitantes não podem ver nem responder a testes';
$string['hidebreaks'] = 'Ocultar quebras de páginas';
$string['hidereordertool'] = 'Ocultar a ferramenta de reordenação';
$string['history'] = 'Histórico de respostas:';
$string['howquestionsbehave_desc'] = 'Configuração predefinida para o comportamento das perguntas num teste.';
$string['imagedisplay'] = 'Imagem a exibir';
$string['import'] = 'Importar';
$string['importcategory'] = 'importar categoria';
$string['importerror'] = 'Ocorreu um erro durante o processo de importação';
$string['importfilearea'] = 'Importar de ficheiro já existente nos ficheiros da disciplina...';
$string['importfileupload'] = 'Importar de ficheiro a carregar...';
$string['importfromthisfile'] = 'Importar deste ficheiro';
$string['import_help'] = 'Esta função permite importar perguntas a partir de ficheiros de texto externos.

Se o seu ficheiro contêm caracteres não-ascii, deve usar a codificação UTF-8. Tenha especial atenção aos ficheiros criados com o Microsoft Office, pois geralmente usam codificações especiais que não serão interpretados corretamente.

Os formatos de importação e exportação são módulos. Outros formatos opcionais podem estar disponíveis na base de dados de módulos.';
$string['importingquestions'] = 'A importar {$a} perguntas do ficheiro';
$string['import_link'] = 'pergunta/importar';
$string['importmax10error'] = 'Existe um erro na pergunta. Não pode ter mais do que dez respostas.';
$string['importmaxerror'] = 'Existe um erro na pergunta. Contém demasiadas respostas.';
$string['importquestions'] = 'Importar perguntas de um ficheiro';
$string['inactiveoverridehelp'] = '* O aluno não se encontra no grupo ou papel correto para realizar este teste';
$string['incorrect'] = 'Incorreto';
$string['indivresp'] = 'Respostas a cada item';
$string['info'] = 'Informação';
$string['infoshort'] = 'i';
$string['inprogress'] = 'Em progresso';
$string['introduction'] = 'Descrição';
$string['invalidattemptid'] = 'Não existe nenhuma tentativa com esse id';
$string['invalidcategory'] = 'O id da categoria não é válido';
$string['invalidnumericanswer'] = 'Uma das respostas introduzidas não é um número válido.';
$string['invalidnumerictolerance'] = 'Uma das margens introduzidas não é um número válido.';
$string['invalidoverrideid'] = 'O id da exceção não é válido';
$string['invalidquestionid'] = 'O id da pergunta não é válido';
$string['invalidquizid'] = 'O id do teste não é válido';
$string['invalidsource'] = 'A origem não é aceite como válida.';
$string['invalidsourcetype'] = 'O tipo de origem não é válido';
$string['invalidstateid'] = 'O id do estado não é válido';
$string['lastanswer'] = 'A sua última resposta foi';
$string['layout'] = 'Aparência';
$string['layoutasshown'] = 'Pré-visualização da aparência';
$string['layoutasshownwithpages'] = 'Pré-visualização da aparência. <small>(Uma nova página é inserida automaticamente a cada {$a} perguntas inseridas.)</small>';
$string['layoutshuffledandpaged'] = 'Perguntas baralhadas aleatoriamente com {$a} perguntas exibidas por página';
$string['layoutshuffledsinglepage'] = 'Perguntas baralhadas aleatoriamente, apenas com uma pergunta exibida por página';
$string['link'] = 'Link';
$string['listitems'] = 'Listagem de itens no teste';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Não foi possível carregar as perguntas: {$a}';
$string['makecopy'] = 'Gravar como nova pergunta';
$string['managetypes'] = 'Gerir tipos de perguntas e servidores';
$string['manualgrading'] = 'A avaliar';
$string['mark'] = 'Submeter';
$string['markall'] = 'Submeter página';
$string['marks'] = 'Nota';
$string['marks_help'] = 'A nota obtida em cada pergunta e a nota global da tentativa.';
$string['match'] = 'Correspondência';
$string['matchanswer'] = 'Resposta correspondente';
$string['matchanswerno'] = 'Resposta correspondente {$a}';
$string['max'] = 'Máx.';
$string['messageprovider:attempt_overdue'] = 'Avisos sobre tentativas de teste a atingir a data limite';
$string['messageprovider:confirmation'] = 'Confirmação das suas submissões nos testes';
$string['messageprovider:submission'] = 'Notificações das submissões do teste';
$string['min'] = 'Mín.';
$string['minutes'] = 'Minutos';
$string['missingcorrectanswer'] = 'Deve definir a resposta correta';
$string['missingitemtypename'] = 'O nome está em falta';
$string['missingquestion'] = 'Esta pergunta já não existe';
$string['modulename'] = 'Teste';
$string['modulename_help'] = 'A atividade Teste permite aos professores criarem testes com diversos tipos de perguntas, tais como escolha múltipla, verdadeiro/falso, correspondência, de resposta curta e calculadas.

O professor pode configurar o teste com várias tentativas, por forma a ser realizado várias vezes e com perguntas aleatórias. Também pode configurar um limite de tempo para a sua realização.

Cada tentativa é automaticamente avaliada e registada no relatório de avaliação da disciplina. O professor pode escolher se quer dar feedback e/ou mostrar as respostas corretas ao aluno durante a tentativa, apenas após terminar a tentativa ou após o teste fechar.

O professor pode escolher entre uma variedade de comportamentos de perguntas, incluindo o modo adaptável (dando ajudas antes do aluno responder de novo) e feedback imediato baseado no grau de certeza (onde o aluno indica qual o seu grau de certeza naquela resposta).

Os testes podem ser utilizados:

* Como mini-testes de compreensão de um tema;
* Como treino para um exame com perguntas de exames de anos anteriores;
* Para dar feedback sobre o desempenho do aluno;
* Para autoavaliação.';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Testes';
$string['moveselectedonpage'] = 'Mover as perguntas selecionadas para a página: {$a}';
$string['multichoice'] = 'Escolha múltipla';
$string['multipleanswers'] = 'Escolha pelo menos uma resposta';
$string['multiplier'] = 'Multiplicador';
$string['mustbesubmittedby'] = 'Esta tentativa deve ser submetida por {$a}.';
$string['name'] = 'Nome';
$string['navmethod'] = 'Método de navegação';
$string['navmethod_free'] = 'Livre';
$string['navmethod_help'] = 'Quando a navegação sequencial está ativa o aluno segue pelo teste, sem possibilidade de retornar às páginas anteriores, nem saltar nenhuma.';
$string['navmethod_seq'] = 'Sequencial';
$string['navnojswarning'] = 'Aviso: estes links não guardarão as suas respostas. Use o botão Seguinte no final da página.';
$string['neverallononepage'] = 'Nunca, todas as perguntas numa só página';
$string['newattemptfail'] = 'Erro: Não foi possível começar uma nova tentativa de resolução do teste';
$string['newpage'] = 'Inserir nova página';
$string['newpageevery'] = 'Inserir nova página automaticamente';
$string['newpage_help'] = 'Para testes com muitas perguntas, pode separar o teste em várias páginas configurando um número máximo de perguntas a exibir por página. Quando adiciona as perguntas as quebras de página são inseridas automaticamente de acordo com esta configuração. Estas quebras poderão depois ser movidas manualmente na página de edição do teste.';
$string['noanswers'] = 'Não foi selecionada nenhuma resposta!';
$string['noattempts'] = 'Ainda não houve tentativas de resolução deste teste';
$string['noattemptsfound'] = 'Não foram encontradas tentativas.';
$string['noattemptstoshow'] = 'Não há tentativas para mostrar';
$string['nocategory'] = 'Incorreto ou não foi especificada uma categoria';
$string['noclose'] = 'Sem data de fim';
$string['nocommentsyet'] = 'Ainda não há comentários.';
$string['noconnection'] = 'Atualmente não existe conexão ao Web service que pode processar esta pergunta. Por favor contacte o administrador';
$string['nodataset'] = 'nada - não é uma variável';
$string['nodatasubmitted'] = 'Não foi submetido nada.';
$string['noessayquestionsfound'] = 'Não foram encontradas perguntas avaliadas manualmente';
$string['nogradewarning'] = 'Este teste não tem avaliação, logo não é possível configurar o feedback global consoante a nota obtida.';
$string['nomoreattempts'] = 'Não são permitidas mais tentativas';
$string['none'] = 'Nenhuma';
$string['noopen'] = 'Sem data de abertura';
$string['nooverridedata'] = 'Deve inserir uma exceção em pelo menos uma opção de configuração do teste';
$string['nopossibledatasets'] = 'Não há conjuntos de dados possíveis';
$string['noquestionintext'] = 'O texto da pergunta não contém nenhuma pergunta incorporada';
$string['noquestions'] = 'Ainda não foi adicionada nenhuma pergunta';
$string['noquestionsfound'] = 'Não foi encontrada nenhuma pergunta';
$string['noquestionsinquiz'] = 'Não existem perguntas neste teste';
$string['noquestionsnotinuse'] = 'A pergunta aleatória não está em uso, pois a sua categoria se encontra vazia.';
$string['noquestionsonpage'] = 'Página em branco';
$string['noresponse'] = 'Sem resposta';
$string['noreview'] = 'Não pode rever este teste';
$string['noreviewattempt'] = 'Não pode rever esta tentativa';
$string['noreviewshort'] = 'Não é permitido';
$string['noreviewuntil'] = 'Não pode rever este teste até {$a}';
$string['noreviewuntilshort'] = 'Disponível {$a}';
$string['noscript'] = 'O Javascript tem de estar ativo para poder continuar!';
$string['notavailabletostudents'] = 'Nota: Este teste não está atualmente disponível para os alunos';
$string['notenoughrandomquestions'] = 'Não existem perguntas suficientes na categoria {$a->category} para criar a pergunta {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Não foram definidas subperguntas suficientes!<br />Quer voltar atrás e corrigir a pergunta?';
$string['notimedependentitems'] = 'O módulo de testes atualmente não suporta itens dependentes do tempo. Uma alternativa consiste em definir um tempo limite para todo o teste. Quer selecionar outro item (ou usar o item atual de qualquer forma)?';
$string['notyetgraded'] = 'Por avaliar';
$string['notyetviewed'] = 'Não visto';
$string['notyourattempt'] = 'Não é a sua tentativa!';
$string['noview'] = 'O utilizador autenticado não tem permissões para ver o teste';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} realizou {$a->attemptnum} tentativas';
$string['numattemptsmade'] = '$a tentativas de resolução deste teste';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numérica';
$string['numquestionsx'] = 'Perguntas: {$a}';
$string['oneminute'] = '1 minuto';
$string['onlyteachersexport'] = 'Apenas os professores podem exportar perguntas';
$string['onlyteachersimport'] = 'Apenas os professores com permissões de edição podem importar perguntas';
$string['onthispage'] = 'Nesta página';
$string['open'] = 'Não respondeu';
$string['openclosedatesupdated'] = 'Foram atualizadas as datas de abertura e fecho do teste';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Ordem e paginação';
$string['orderandpaging_help'] = 'Os números 10, 20, 30, ... em cada pergunta indicam a sua ordem. Ao apresentar intervalos de 10 é possível inserir perguntas no meio. Para  reordenar as perguntas, altere a numeração e clique no botão "Reordenar perguntas".

Para adicionar quebras de páginas após uma pergunta, selecione as perguntas e clique no botão "Iniciar página após perguntas selecionadas".

Para organizar as perguntas num diferente número de páginas, clique no botão de Repaginação e insira o número que perguntas por página que deseja.';
$string['orderingquiz'] = 'Ordenar e Paginar';
$string['orderingquizx'] = 'Ordem e paginação: {$a}';
$string['outcomesadvanced'] = 'As competências são opções avançadas';
$string['outof'] = '{$a->grade} num máximo de {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} num máximo de {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback global';
$string['overallfeedback_help'] = 'Feedback global é o texto que surge após o aluno concluir a tentativa de resolução do teste. Ao especificar limites (como percentagem ou número), este poderá depender da nota obtida.';
$string['overdue'] = 'Fora de prazo';
$string['overduehandling'] = 'Quando o tempo termina';
$string['overduehandlingautoabandon'] = 'As tentativas devem ser submetidas antes do tempo terminar, ou não serão consideradas';
$string['overduehandlingautosubmit'] = 'As tentativas em aberto são submetidas automaticamente';
$string['overduehandling_desc'] = 'O que deve acontecer por predefinição se o aluno não submeter a tentativa antes do tempo terminar.';
$string['overduehandlinggraceperiod'] = 'É permitido um tempo extra para submeter, mas sem alterar respostas';
$string['overduehandling_help'] = 'Esta opção determina o que acontece se o aluno não submeter a sua tentativa antes do tempo terminar. Se o aluno estiver a responder ao teste naquele momento, então o cronómetro submeterá automaticamente o teste, mas se o aluno não estiver ativo ou autenticado, então esta configuração determina o que acontece.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduemustbesubmittedby'] = 'Esta tentativa excedeu o tempo limite. Já deveria ter submetido a mesma. Se pretende que esta tentativa seja avaliada, deve submetê-la até às {$a}. Se não a submeter até lá, não irá obter nota na mesma.';
$string['override'] = 'Ajustar';
$string['overridedeletegroupsure'] = 'Tem a certeza que quer apagar a exceção para o grupo {$a}?';
$string['overridedeleteusersure'] = 'Tem a certeza que quer apagar a exceção para o utilizador {$a}?';
$string['overridegroup'] = 'Exceção para grupo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Exceções';
$string['overrideuser'] = 'Exceção para utilizador';
$string['overrideusereventname'] = '{$a->quiz} - Exceção';
$string['page-mod-quiz-attempt'] = 'Página de tentativa de Teste';
$string['page-mod-quiz-edit'] = 'Editar página do teste';
$string['page-mod-quiz-report'] = 'Qualquer página de relatório de Teste';
$string['page-mod-quiz-review'] = 'Rever página de tentativa de Teste';
$string['page-mod-quiz-summary'] = 'Página de sumário da tentativa de Teste';
$string['page-mod-quiz-view'] = 'Página de informação do Teste';
$string['page-mod-quiz-x'] = 'Qualquer página do teste';
$string['pagesize'] = 'Número de tentativas por página';
$string['parent'] = 'Ascendente';
$string['parentcategory'] = 'Categoria ascendente';
$string['parsingquestions'] = 'A ler perguntas do ficheiro importado.';
$string['partiallycorrect'] = 'Parcialmente correto';
$string['penalty'] = 'Penalização';
$string['penaltyscheme'] = 'Aplicar penalizações';
$string['penaltyscheme_help'] = 'Se selecionar \'Sim\', a penalização é subtraída à nota final da pergunta, por cada tentativa errada. O valor da penalização é definido nas configurações da pergunta. Esta configuração só é aplicável em testes em modo adaptável.';
$string['percentcorrect'] = 'Percentagem correta';
$string['pleaseclose'] = 'O seu pedido foi processado. Pode fechar a janela';
$string['pluginadministration'] = 'Administração do teste';
$string['pluginname'] = 'Teste';
$string['popup'] = 'Mostrar o teste em janela &quot;segura&quot;';
$string['popupblockerwarning'] = 'Esta secção do teste está em modo seguro. Isto significa que é necessário abrir o teste numa janela segura. Por favor desligue o bloqueador de janelas pop-up.';
$string['popupnotice'] = 'Os alunos resolverão este teste numa janela segura';
$string['preprocesserror'] = 'Ocorreu um erro durante o pré-processamento!';
$string['preview'] = 'Pré-visualizar';
$string['previewquestion'] = 'Pré-visualizar pergunta';
$string['previewquiz'] = 'Pré-visualizar {$a}';
$string['previewquiznow'] = 'Pré-visualizar teste';
$string['previous'] = 'Estado anterior';
$string['publish'] = 'Publicar';
$string['publishedit'] = 'Deve possuir permissões de edição na disciplina correspondente para adicionar ou editar perguntas nesta categoria';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'nome';
$string['qti'] = 'Formato IMS QTI';
$string['qtypename'] = 'tipo, nome';
$string['question'] = 'Pergunta';
$string['questionbankcontents'] = 'Base de dados de perguntas';
$string['questionbankmanagement'] = 'Gestão da base de dados de perguntas';
$string['questionbehaviour'] = 'Comportamento das perguntas';
$string['questioncats'] = 'Categorias de perguntas';
$string['questiondeleted'] = 'Esta pergunta foi apagada. Por favor contacte o professor da disciplina';
$string['questioninuse'] = 'A pergunta {$a->questionname} está atualmente a ser utilizada em: <br />{$a->quiznames}<br />A pergunta não será apagada desses testes mas apenas da categoria.';
$string['questionmissing'] = 'Falta a pergunta para esta sessão';
$string['questionname'] = 'Nome da pergunta';
$string['questionnonav'] = '<span class="accesshide">Pergunta </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informação </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pergunta {$a} não foi carregada da base de dados';
$string['questionorder'] = 'Ordem das perguntas';
$string['questionposition'] = 'Nova posição de ordem para a pergunta {$a}';
$string['questions'] = 'Perguntas';
$string['questionsinclhidden'] = 'Perguntas (incluindo ocultas)';
$string['questionsinthisquiz'] = 'Perguntas neste teste';
$string['questionsperpage'] = 'Perguntas por página';
$string['questionsperpageselected'] = 'O número de perguntas por página foi configurado para a paginação ser fixa. Como tal, os controlos de paginação foram desativados. Pode alterar esta configuração em {$a}.';
$string['questionsperpagex'] = 'Perguntas por página: {$a}';
$string['questiontext'] = 'Texto da pergunta';
$string['questiontextisempty'] = '[Texto da pergunta vazio]';
$string['questiontype'] = 'Tipo de pergunta {$a}';
$string['questiontypesetupoptions'] = 'Opções de configuração para tipos de perguntas:';
$string['quiz:addinstance'] = 'Adicionar novo teste';
$string['quiz:attempt'] = 'Responder a testes';
$string['quizavailable'] = 'O teste está disponível até: {$a}';
$string['quizclose'] = 'Fechar o teste em';
$string['quizclosed'] = 'O teste fechou em {$a}';
$string['quizcloses'] = 'Teste fecha';
$string['quizcloseson'] = 'Este teste fecha em {$a}';
$string['quiz:deleteattempts'] = 'Apagar tentativas';
$string['quiz:emailconfirmsubmission'] = 'Receber e-mail de confirmação quando submete';
$string['quiz:emailnotifysubmission'] = 'Receber e-mail de confirmação das submissões';
$string['quiz:emailwarnoverdue'] = 'Obter uma notificação quando o tempo expirou e a tentativa necessita de ser submetida.';
$string['quiz:grade'] = 'Avaliar testes manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorar tempo limite dos testes';
$string['quizisclosed'] = 'Este teste está fechado';
$string['quizisclosedwillopen'] = 'Teste fechado (abre em {$a})';
$string['quizisopen'] = 'Este teste está aberto';
$string['quizisopenwillclose'] = 'Teste abre (fecha {$a})';
$string['quiz:manage'] = 'Gerir testes';
$string['quiz:manageoverrides'] = 'Gerir exceções do teste';
$string['quiznavigation'] = 'Navegação do teste';
$string['quizopen'] = 'Abrir o teste em';
$string['quizopenclose'] = 'Datas de abertura e fecho';
$string['quizopenclose_help'] = 'Os alunos só podem iniciar a(s) sua(s) tentativa(s) após a data de abertura e devem completá-las até à hora de fechar.';
$string['quizopened'] = 'Este teste está aberto.';
$string['quizopenedon'] = 'Este teste abriu em {$a}';
$string['quizopens'] = 'O teste abre';
$string['quizopenwillclose'] = 'O teste está aberto, irá fechar em {$a} às';
$string['quizordernotrandom'] = 'A ordem das perguntas não está baralhada';
$string['quizorderrandom'] = '* A ordem das perguntas está baralhada';
$string['quiz:preview'] = 'Pré-visualizar testes';
$string['quiz:regrade'] = 'Reclassificar tentativas';
$string['quiz:reviewmyattempts'] = 'Rever as próprias tentativas';
$string['quizsettings'] = 'Configurações do teste';
$string['quiztimer'] = 'Cronómetro';
$string['quiz:view'] = 'Ver informações do teste';
$string['quiz:viewreports'] = 'Ver relatórios do teste';
$string['quizwillopen'] = 'Este teste irá abrir {$a}';
$string['random'] = 'Pergunta aleatória';
$string['randomcreate'] = 'Criar perguntas aleatórias';
$string['randomfromcategory'] = 'Pergunta aleatória da categoria:';
$string['randomfromexistingcategory'] = 'Pergunta aleatória de uma categoria existente';
$string['randomnosubcat'] = 'Perguntas apenas desta categoria apenas e não das suas subcategorias';
$string['randomquestionusinganewcategory'] = 'Pergunta aleatória de uma nova categoria';
$string['randomwithsubcat'] = 'Perguntas desta categoria e suas subcategorias';
$string['readytosend'] = 'Está prestes a submeter o teste para a avaliação. Tem a certeza que deseja continuar?';
$string['reattemptquiz'] = 'Iniciar uma nova tentativa de resolução do teste';
$string['recentlyaddedquestion'] = 'Pergunta recentemente adicionada!';
$string['recurse'] = 'Incluir também perguntas das subcategorias';
$string['regrade'] = 'Reclassificar todas as tentativas';
$string['regradecomplete'] = 'Todas as tentativas foram reclassificadas';
$string['regradecount'] = '{$a->changed} em {$a->attempt} notas foram alteradas';
$string['regradedisplayexplanation'] = 'Tentativas alteradas durante a reclassificação são exibidas com links para a janela de revisão da pergunta';
$string['regradenotallowed'] = 'Não possui permissão para reclassificar este teste';
$string['regradingquestion'] = 'A reclassificar "{$a}".';
$string['regradingquiz'] = 'A reclassificar teste "{$a}"';
$string['remove'] = 'Apagar';
$string['removeallquizattempts'] = 'Apagar todas as tentativas do teste';
$string['removeemptypage'] = 'Apagar página vazia';
$string['removeselected'] = 'Apagar selecionadas';
$string['rename'] = 'Renomear';
$string['renderingserverconnectfailed'] = 'O servidor {$a} falhou ao processar um pedido RQP. Verifique se o URL se encontra correto.';
$string['reorderquestions'] = 'Reordenar perguntas';
$string['reordertool'] = 'Mostrar a ferramenta de reordenação';
$string['repaginate'] = 'Repaginar com {$a} perguntas por página';
$string['repaginatecommand'] = 'Repaginar';
$string['repaginatenow'] = 'Repaginar agora';
$string['replace'] = 'Substituir';
$string['replacementoptions'] = 'Opções de substituição';
$string['report'] = 'Relatórios';
$string['reportanalysis'] = 'Análise de itens';
$string['reportattemptsfrom'] = 'Tentativas de';
$string['reportattemptsthatare'] = 'Tentativas que estão';
$string['reportdisplayoptions'] = 'Opções de exibição';
$string['reportfullstat'] = 'Estatísticas detalhadas';
$string['reportmulti_percent'] = 'Percentagens múltiplas';
$string['reportmulti_q_x_student'] = 'Multi-escolhas dos alunos';
$string['reportmulti_resp'] = 'Respostas individuais';
$string['reportmustselectstate'] = 'Deve selecionar pelo menos um estado.';
$string['reportnotfound'] = 'Relatório desconhecido ({$a})';
$string['reportoverview'] = 'Perspetiva global';
$string['reportregrade'] = 'Reclassificar tentativas';
$string['reportresponses'] = 'Respostas detalhadas';
$string['reports'] = 'Relatórios';
$string['reportshowonly'] = 'Mostrar apenas:';
$string['reportshowonlyfinished'] = 'Uma tentativa terminada por utilizador ({$a})';
$string['reportsimplestat'] = 'Estatísticas simples';
$string['reportusersall'] = 'todos os alunos que responderam ao teste';
$string['reportuserswith'] = 'utilizadores inscritos que responderam ao teste';
$string['reportuserswithorwithout'] = 'utilizadores inscritos que responderam ou não ao teste';
$string['reportuserswithout'] = 'utilizadores inscritos que não responderam ao teste';
$string['reportwhattoinclude'] = 'O que incluir no relatório';
$string['requirepassword'] = 'Senha para entrar no teste';
$string['requirepassword_help'] = 'Se for definida uma senha, o aluno necessita de a introduzir para conseguir responder ao teste.';
$string['requiresubnet'] = 'Endereços de rede autorizados';
$string['requiresubnet_help'] = 'O acesso ao teste pode ser restrito para subnets particulares na LAN ou por endereços de IP que devem ser inseridos separados por vírgulas. Isto pode ser útil para controlar que apenas as pessoas num determinado local têm acesso ao teste.';
$string['response'] = 'Resposta';
$string['responses'] = 'Respostas';
$string['results'] = 'Resultados';
$string['returnattempt'] = 'Voltar à tentativa';
$string['reuseifpossible'] = 'reutilizar o que foi apagado previamente';
$string['reverttodefaults'] = 'Reverter para predefinições do teste';
$string['review'] = 'Rever';
$string['reviewafter'] = 'Permitir revisão depois de o teste fechar';
$string['reviewalways'] = 'Permitir a revisão sempre';
$string['reviewattempt'] = 'Rever tentativa';
$string['reviewbefore'] = 'Permitir a revisão enquanto o teste está aberto';
$string['reviewclosed'] = 'Após o teste fechar';
$string['reviewduring'] = 'Durante a tentativa';
$string['reviewimmediately'] = 'Imediatamente a seguir à tentativa';
$string['reviewnever'] = 'Nunca permitir a revisão';
$string['reviewofattempt'] = 'Revisão da tentativa {$a}';
$string['reviewofpreview'] = 'Revisão da pré-visualização';
$string['reviewopen'] = 'Mais tarde, com o teste ainda aberto';
$string['reviewoptions'] = 'Os alunos podem rever o teste';
$string['reviewoptionsheading'] = 'Informação exibida na revisão do teste';
$string['reviewoptionsheading_help'] = 'Estas opções definem a informação que os alunos podem ver ao rever uma tentativa ou ao consultar os relatórios do teste.

**Durante a tentativa** é relevante apenas para alguns tipos de comportamentos de perguntas, como o \'interativo com múltiplas tentativas\', que podem exibir feedback durante a tentativa.

**Imediatamente a seguir à tentativa** aplicável ao período de dois minutos após o aluno submeter a realização do teste e, como tal, ao relatório de revisão do teste que surge imediatamente a seguir.

**Mais tarde, enquanto o teste estiver aberto** aplicável desde o período anterior até à data de fecho do teste.

**Depois do teste fechar** aplicável após a data de fecho do teste. Se o teste não tiver uma data de fecho definida, este estado nunca é aplicado.';
$string['reviewoverallfeedback'] = 'Feedback global';
$string['reviewoverallfeedback_help'] = 'Feedback global dado ao aluno no final da tentativa em função da nota total obtida.';
$string['reviewresponse'] = 'Rever respostas';
$string['reviewresponsetoq'] = 'Rever respostas (pergunta {$a})';
$string['reviewthisattempt'] = 'Reveja as suas respostas para esta tentativa';
$string['rqp'] = 'Pergunta remota';
$string['rqps'] = 'Perguntas remotas';
$string['sameasoverall'] = 'O mesmo da nota do teste';
$string['save'] = 'Guardar';
$string['saveandedit'] = 'Guardar alterações e editar perguntas';
$string['saveattemptfailed'] = 'Ocorreu um erro ao guardar a tentativa de realização do teste';
$string['savedfromdeletedcourse'] = 'Guardado da disciplina apagada "{$a}"';
$string['savegrades'] = 'Guardar notas';
$string['savemyanswers'] = 'Guardar as minhas respostas';
$string['savenosubmit'] = 'Guardar, sem submeter';
$string['saveoverrideandstay'] = 'Guardar e adicionar outra exceção';
$string['savequiz'] = 'Guardar todo o teste';
$string['saving'] = 'A guardar';
$string['savingnewgradeforquestion'] = 'A guardar nova nota para a pergunta id {$a}.';
$string['savingnewmaximumgrade'] = 'A guardar nova nota máxima.';
$string['score'] = 'Nota bruta';
$string['scores'] = 'Avaliações';
$string['select'] = 'Selecionar';
$string['selectall'] = 'Selecionar tudo';
$string['selectcategory'] = 'Selecionar categoria';
$string['selectedattempts'] = 'Tentativas selecionadas...';
$string['selectnone'] = 'Desselecionar todas';
$string['selectquestiontype'] = '-- Selecionar tipo de pergunta --';
$string['serveradded'] = 'Servidor adicionado';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Informação do servidor';
$string['servers'] = 'Servidores';
$string['serverurl'] = 'URL do servidor';
$string['settingsoverrides'] = 'Exceções das configurações';
$string['shortanswer'] = 'Resposta curta';
$string['show'] = 'Mostrar';
$string['showall'] = 'Mostrar todas as perguntas numa página';
$string['showblocks'] = 'Mostrar blocos durante a realização do teste';
$string['showblocks_help'] = 'Se selecionar \'Sim\', os blocos serão mostrados durante a realização do teste';
$string['showbreaks'] = 'Mostrar quebras de página';
$string['showcategorycontents'] = 'Mostrar conteúdo da categoria {$a->arrow}';
$string['showcorrectanswer'] = 'No feedback, mostrar respostas corretas?';
$string['showdetailedmarks'] = 'Mostrar detalhe da nota';
$string['showeachpage'] = 'Mostrar uma página de cada vez';
$string['showfeedback'] = 'Após responder, mostrar feedback?';
$string['showinsecurepopup'] = 'Usar uma janela pop-up segura para realizar o teste';
$string['showlargeimage'] = 'Imagem grande';
$string['shownoattempts'] = 'Mostrar alunos sem tentativas';
$string['shownoattemptsonly'] = 'Mostrar apenas alunos sem tentativas';
$string['shownoimage'] = 'Nenhuma imagem';
$string['showreport'] = 'Mostrar relatório';
$string['showsmallimage'] = 'Imagem pequena';
$string['showteacherattempts'] = 'Mostrar tentativas de professores';
$string['showuserpicture'] = 'Mostrar fotografia do utilizador';
$string['showuserpicture_help'] = 'Se selecionar \'Sim\', o nome dos alunos e a sua fotografia serão exibidos durante a resolução do teste. Assim, torna-se mais fácil verificar se o aluno que está autenticado é o que está a fazer o exame num ambiente vigiado.';
$string['shuffle'] = 'Baralhar';
$string['shuffleanswers'] = 'Baralhar opções de resposta';
$string['shuffledrandomly'] = 'Baralhadas aleatoriamente';
$string['shufflequestions'] = 'Baralhar perguntas';
$string['shufflequestionsselected'] = 'A opção de baralhar perguntas está ativa, logo algumas ações relativas às páginas não se encontram disponíveis. Para alterar as configurações das perguntas baralhadas,clique em {$a}.';
$string['shufflewithin'] = 'Baralhar dentro das perguntas';
$string['shufflewithin_help'] = 'Se selecionar \'Sim\', as opções de resposta serão baralhadas aleatoriamente cada vez que o aluno realiza uma tentativa do teste. Esta configuração só se aplica a perguntas com várias opções como as de resposta múltipla ou correspondência.';
$string['singleanswer'] = 'Escolha uma resposta…';
$string['sortage'] = 'Ordenar por idade';
$string['sortalpha'] = 'Ordenar por nome';
$string['sortquestionsbyx'] = 'Ordenar perguntas por: {$a}';
$string['sortsubmit'] = 'Ordenar perguntas';
$string['sorttypealpha'] = 'Ordenar por tipo, nome';
$string['specificapathnotonquestion'] = 'O caminho do arquivo especificado não está na pergunta especificada';
$string['specificquestionnotonquiz'] = 'A pergunta não se encontra no teste indicado';
$string['startagain'] = 'Reiniciar';
$string['startattempt'] = 'Iniciar tentativa';
$string['startedon'] = 'Iniciado em';
$string['startnewpreview'] = 'Iniciar nova pré-visualização';
$string['stateabandoned'] = 'Nunca submetidas';
$string['statefinished'] = 'Terminada';
$string['statefinisheddetails'] = 'Submetido {$a}';
$string['stateinprogress'] = 'Em progresso';
$string['statenotloaded'] = 'O estado para a pergunta {$a} não foi carregado da base de dados';
$string['stateoverdue'] = 'Expiradas';
$string['stateoverduedetails'] = 'Deve ser submetido por {$a}';
$string['status'] = 'Estado';
$string['stoponerror'] = 'Parar em caso de erro';
$string['submitallandfinish'] = 'Submeter tudo e terminar';
$string['subneterror'] = 'O acesso a este teste está limitado a alguns locais. Atualmente, o seu computador não se encontra num dos locais autorizados a aceder ao teste.';
$string['subnetnotice'] = 'O acesso a este teste está limitado a alguns locais. O seu computador não se encontra em nenhuma subnet permitida. No entanto, pode, na qualidade de professor, pré-visualizar o teste.';
$string['subplugintype_quiz'] = 'Relatório';
$string['subplugintype_quizaccess'] = 'Regra de acesso';
$string['subplugintype_quizaccess_plural'] = 'Regras de acesso';
$string['subplugintype_quiz_plural'] = 'Relatórios';
$string['substitutedby'] = 'será substituído por';
$string['summaryofattempt'] = 'Síntese da tentativa';
$string['summaryofattempts'] = 'Síntese das tentativas anteriores';
$string['temporaryblocked'] = 'Está temporariamente impedido de tentar resolver o teste novamente.<br /> Poderá voltar a tentar em:';
$string['theattempt'] = 'Resposta submetida';
$string['theattempt_help'] = 'A resposta submetida pelo aluno.';
$string['time'] = 'Tempo';
$string['timecompleted'] = 'Estado';
$string['timedelay'] = 'Não pode responder ao teste porque ainda não passou o tempo de espera exigido antes de realizar nova tentativa de resolução.';
$string['timeleft'] = 'Tempo restante';
$string['timelimit'] = 'Limite de tempo';
$string['timelimitexeeded'] = 'Lamentamos mas terminou o limite de tempo previsto para realizar o teste!';
$string['timelimit_help'] = 'Se ativar esta opção, o limite de tempo é anunciado na página inicial do teste e um cronómetro que conta o tempo restante é exibido no bloco de navegação do teste.';
$string['timelimitmin'] = 'Limite de tempo (minutos)';
$string['timelimitsec'] = 'Limite de tempo (segundos)';
$string['timestr'] = '%H:%M:%S em %d/%m/%y';
$string['timesup'] = 'O tempo terminou!';
$string['timetaken'] = 'Tempo gasto';
$string['timing'] = 'Tempo';
$string['tofile'] = 'para o ficheiro';
$string['tolerance'] = 'Margem de erro';
$string['toomanyrandom'] = 'O número de perguntas aleatórias exigidas é maior do que as disponíveis na categoria!';
$string['top'] = 'Top';
$string['totalmarksx'] = 'Total de pontos: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} perguntas nesta categoria';
$string['true'] = 'Verdadeiro';
$string['truefalse'] = 'Verdadeiro/Falso';
$string['type'] = 'Tipo';
$string['unfinished'] = 'aberto';
$string['ungraded'] = 'Sem classificação';
$string['unit'] = 'Unidade';
$string['unknowntype'] = 'O tipo de pergunta não suportada na linha {$a}. A pergunta será ignorada.';
$string['unusedcategorydeleted'] = 'Esta categoria foi apagada pois após apagar a disciplina, as perguntas deixaram de ser utilizadas.';
$string['updatesettings'] = 'Atualizar configurações do teste';
$string['updatingatttemptgrades'] = 'A atualizar as notas das tentativas.';
$string['updatingfinalgrades'] = 'A atualizar notas finais';
$string['updatingthegradebook'] = 'A atualizar a pauta';
$string['upgradesure'] = '<div>O módulo de testes, em particular, produzirá alterações significativas nas tabelas de testes. Uma vez que esta atualização ainda não foi suficientemente testada, é altamente recomendável que faça uma cópia de segurança das suas tabelas da base de dados antes de continuar.</div>';
$string['upgradingquizattempts'] = 'A atualizar tentativas: teste {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'A atualizar tentativas antigas: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Esta categoria foi preservada e movida para o nível do site pois é uma categoria pública ainda em uso noutras disciplinas.';
$string['useroverrides'] = 'Exceções para utilizadores';
$string['usersnone'] = 'Nenhum aluno tem acesso a este teste';
$string['validate'] = 'Validar';
$string['viewallanswers'] = 'Ver {$a} tentativas de resolução do teste';
$string['viewallreports'] = 'Ver relatórios para {$a} tentativas';
$string['viewed'] = 'Visto';
$string['warningmissingtype'] = '<b>Esta pergunta é de um tipo que ainda não se encontra instalado no seu Moodle.<br />Por favor, alerte o administrador da plataforma.</b>';
$string['wheregrade'] = 'Onde consulto a minha nota?';
$string['wildcard'] = 'Variável';
$string['windowclosing'] = 'Esta janela será fechada em breve';
$string['withsummary'] = 'com síntese das Estatísticas';
$string['wronguse'] = 'Não pode utilizar esta página dessa forma';
$string['xhtml'] = 'formato XHTML';
$string['youneedtoenrol'] = 'Necessita de se inscrever na disciplina para poder resolver o teste.';
$string['yourfinalgradeis'] = 'A sua nota final do teste é {$a}.';
