<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'pt', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Existem novas mensagens no fórum';
$string['addanewdiscussion'] = 'Criar um novo tópico';
$string['addanewquestion'] = 'Criar uma nova pergunta';
$string['addanewtopic'] = 'Criar um novo tópico';
$string['advancedsearch'] = 'Pesquisa avançada';
$string['allforums'] = 'Todos os fóruns';
$string['allowdiscussions'] = '{$a} pode criar novos tópicos?';
$string['allowsallsubscribe'] = 'Este fórum permite a todos optar por subscrever ou não';
$string['allowsdiscussions'] = 'Este fórum permite que cada participante crie um tópico de discussão.';
$string['allsubscribe'] = 'Subscrever todos os fóruns';
$string['allunsubscribe'] = 'Cancelar a subscrição de todos os fóruns';
$string['alreadyfirstpost'] = 'Este já é o primeiro tópico da discussão';
$string['anyfile'] = 'Qualquer ficheiro';
$string['areaattachment'] = 'Anexos';
$string['areapost'] = 'Mensagens';
$string['attachment'] = 'Anexo';
$string['attachment_help'] = 'Poderá anexar um ou mais ficheiros a uma mensagem do fórum. Se anexar uma imagem, está será exibida após a mensagem.';
$string['attachmentnopost'] = 'Não pode exportar anexos sem um id da mensagem';
$string['attachments'] = 'Anexos';
$string['attachmentswordcount'] = 'Anexos e contagem de palavras';
$string['blockafter'] = 'Número máximo de mensagens permitidas';
$string['blockafter_help'] = 'Especifica o número máximo de mensagens que cada utilizador pode submeter num determinado período de tempo. Utilizadores com a capacidade mod/forum:postwithoutthrottling estão isentos destes limites.';
$string['blockperiod'] = 'Período de tempo';
$string['blockperioddisabled'] = 'Não bloquear';
$string['blockperiod_help'] = 'Os alunos podem ser impedidos de submeter mais de um determinado número de mensagens no período de tempo aqui especificado. Os utilizadores com a capacidade mod/forum:postwithoutthrottling estão isentos destes limites.';
$string['blogforum'] = 'Fórum standard em formato blogue';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['cannotadd'] = 'Não foi possível adicionar o tópico a este fórum';
$string['cannotadddiscussion'] = 'Criar novos tópicos neste fórum requer adesão a grupo.';
$string['cannotadddiscussionall'] = 'Não tem permissão para criar um novo tópico disponível para todos os participantes';
$string['cannotaddsubscriber'] = 'Não foi possível subscrever o utilizador com o id {$a} a este fórum.';
$string['cannotaddteacherforumto'] = 'Não foi possível criar o fórum de professores convertido na secção 0 da disciplina.';
$string['cannotcreatediscussion'] = 'Não foi possível criar o novo tópico de discussão';
$string['cannotcreateinstanceforteacher'] = 'Não foi possível criar a instância do novo módulo da disciplina para o fórum de professores';
$string['cannotdeletepost'] = 'Não pode apagar esta mensagem';
$string['cannoteditposts'] = 'Não pode editar mensagens de outros utilizadores';
$string['cannotfinddiscussion'] = 'Não foi possível localizar o tópico neste fórum';
$string['cannotfindfirstpost'] = 'Não foi possível localizar o primeiro tópico deste fórum';
$string['cannotfindorcreateforum'] = 'Não foi possível localizar ou criar um fórum noticias';
$string['cannotfindparentpost'] = 'Não foi possível localizar o tópico da mensagem  {$a}';
$string['cannotmovefromsingleforum'] = 'Não é possível mover tópicos de um fórum de um único tópico de discussão';
$string['cannotmovenotvisible'] = 'O fórum não está visível';
$string['cannotmovetonotexist'] = 'Não é possível mover para esse fórum pois não existe';
$string['cannotmovetonotfound'] = 'O Fórum de destino não foi localizado nesta disciplina.';
$string['cannotmovetosingleforum'] = 'Não é possível mover a discussão para um fórum de um único tópico de discussão';
$string['cannotpurgecachedrss'] = 'Não foi possível apagar a cache RSS para os fóruns original e/ou de destino - reveja as suas permissões nos fóruns';
$string['cannotremovesubscriber'] = 'Não foi possível cancelar a subscrição do utilizador com id {$a}';
$string['cannotreply'] = 'Não pode responder a esta mensagem';
$string['cannotsplit'] = 'Os tópicos neste fórum não podem ser divididos';
$string['cannotsubscribe'] = 'Necessita de estar inscrito num grupo para subscrever o fórum';
$string['cannottrack'] = 'Não foi possível parar de assinalar as mensagens não lidas neste fórum';
$string['cannotunsubscribe'] = 'Não foi possível cancelar a sua subscrição';
$string['cannotupdatepost'] = 'Não pode atualizar esta mensagem';
$string['cannotviewpostyet'] = 'Não pode ver as respostas a esta pergunta porque ainda não respondeu á mesma.';
$string['cannotviewusersposts'] = 'Não existem mensagens deste participante que possa visualizar.';
$string['cleanreadtime'] = 'Hora para marcar mensagens antigas como lidas';
$string['completiondiscussions'] = 'Número de tópicos que o aluno deve criar';
$string['completiondiscussionsgroup'] = 'Nº de tópicos';
$string['completiondiscussionshelp'] = 'requer a criação de determinado número de tópicos para completar a atividade';
$string['completionposts'] = 'Número de tópicos ou respostas que o aluno deve criar';
$string['completionpostsgroup'] = 'Nº de mensagens';
$string['completionpostshelp'] = 'número de tópicos ou respostas requeridos para completar a atividade';
$string['completionreplies'] = 'Número de respostas a tópicos que o aluno deve submeter';
$string['completionrepliesgroup'] = 'Nº de respostas';
$string['completionreplieshelp'] = 'número de respostas requerido para completar a atividade';
$string['configcleanreadtime'] = 'Hora do dia em que as mensagens antigas serão apagadas da tabela de \'não lidas\'.';
$string['configdigestmailtime'] = 'Aos utilizadores que optarem por receber resumos do fórum por e-mail será enviado um resumo por dia. Esta configuração define a hora do dia em que o e-mail será enviado (a mensagem será enviada quando correr o cron após esta hora definida).';
$string['configdisplaymode'] = 'Modo predefinido de apresentação dos tópicos.';
$string['configenablerssfeeds'] = 'Esta opção permite a criação de listas  RSS a partir de qualquer fórum. É ainda necessário configurar cada fórum para que sejam geradas as listas correspondentes.';
$string['configenabletimedposts'] = 'Selecione \'Sim\' para permitir fixar períodos de visualização nas mensagens afixadas no fórum (isto está em fase experimental e ainda a ser testado)';
$string['configlongpost'] = 'Qualquer mensagem acima deste tamanho (em nº de caracteres, sem incluir HTML) será considerada longa. Mensagens exibidas na página inicial do site, páginas com formato social, ou perfis de utilizadores são truncadas para um tamanho entre os valores definidos em forum_shortpost e forum_longpost.';
$string['configmanydiscussions'] = 'Número máximo de tópicos exibidos por página no fórum';
$string['configmaxattachments'] = 'Número máximo predefinido para o número de anexos permitidos por mensagem.';
$string['configmaxbytes'] = 'Tamanho máximo predefinido para todos os anexos de uma mensagem do fórum (sujeito a outros limites impostos na configuração da disciplina e do servidor)';
$string['configoldpostdays'] = 'Número de dias para uma mensagem ser considerada como lida.';
$string['configreplytouser'] = 'Quando um tópico de fórum é enviado por e-mail, deverá conter o endereço de e-mail do autor para que os destinatários possam responder diretamente em vez de usarem o fórum? Se selecionar \'Sim\', os utilizadores poderão, a partir do seu perfil, optar por manter o seu endereço de e-mail provado.';
$string['configshortpost'] = 'Qualquer mensagem abaixo deste tamanho (número de caracteres, sem incluir HTML) será considerada curta.';
$string['configtrackingtype'] = 'Configuração predefinida para "Assinalar mensagens".';
$string['configtrackreadposts'] = 'Selecione \'sim\' para permitir assinalar mensagens não lidas para cada utilizador.';
$string['configusermarksread'] = 'Se selecionar \'Sim\', o utilizador deverá marcar manualmente as mensagens como lidas. Se selecionar \'Não\', as mensagens serão marcadas como lidas após a sua visualização.';
$string['confirmsubscribe'] = 'Tem a certeza que deseja subscrever o fórum \'{$a}\'?';
$string['confirmunsubscribe'] = 'Tem a certeza que deseja cancelar a subscrição do fórum \'{$a}\'?';
$string['couldnotadd'] = 'Não foi possível inserir a mensagem que submeteu devido a um erro desconhecido';
$string['couldnotdeletereplies'] = 'Lamentamos mas não é possível apagar pois já existem respostas.';
$string['couldnotupdate'] = 'Não foi possível atualizar a mensagem devido a um erro desconhecido';
$string['delete'] = 'Apagar';
$string['deleteddiscussion'] = 'O tópico foi apagado';
$string['deletedpost'] = 'A mensagem foi apagada';
$string['deletedposts'] = 'Estas mensagens foram apagadas';
$string['deletesure'] = 'Tem a certeza que deseja apagar esta mensagem?';
$string['deletesureplural'] = 'Tem a certeza que quer apagar esta mensagem e todas as suas respostas? (número de respostas: {$a})';
$string['digestmailheader'] = 'Este é o seu sumário diário de novas mensagens nos fóruns de {$a->sitename}. Pode alterar as suas preferências de e-mail em {$a->userprefs}.';
$string['digestmailpost'] = 'Altere as suas preferências de Sumários de fóruns';
$string['digestmailprefs'] = 'o seu perfil de utilizador';
$string['digestmailsubject'] = '{$a}: sumário do fórum';
$string['digestmailtime'] = 'Hora para enviar e-mails com sumários do fórum';
$string['digestsentusers'] = 'Sumários de fóruns enviados com sucesso para {$a} utilizadores.';
$string['disallowsubscribe'] = 'Não é possível subscrever';
$string['disallowsubscribeteacher'] = 'Não é possível subscrever (excepto professores)';
$string['discussion'] = 'Tópico';
$string['discussionmoved'] = 'Este tópico foi transferido para \'{$a}\'.';
$string['discussionmovedpost'] = 'Este tópico foi transferido para <a href="{$a->discusshref}">aqui</a> no fórum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Designação da discussão';
$string['discussions'] = 'Tópicos';
$string['discussionsstartedby'] = 'Tópicos iniciados por {$a}';
$string['discussionsstartedbyrecent'] = 'Tópicos iniciados recentemente por {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discussões iniciadas por {$a->fullname} em {$a->coursename}';
$string['discussthistopic'] = 'Discutir este tópico';
$string['displayend'] = 'Visível até';
$string['displayend_help'] = 'Esta configuração permite esconder um tópico a partir de uma determinada data. Os administradores podem sempre visualizar estes tópicos.';
$string['displaymode'] = 'Modo de visualização';
$string['displayperiod'] = 'Período de visualização';
$string['displaystart'] = 'Visível a partir de';
$string['displaystart_help'] = 'Esta configuração permite mostrar um tópico apenas a partir de uma determinada data. Os administradores podem sempre visualizar estes tópicos.';
$string['displaywordcount'] = 'Exibir contagem de palavras';
$string['displaywordcount_help'] = 'Esta configuração especifica se a contagem de palavras de cada tópico deve ser exibida ou não.';
$string['eachuserforum'] = 'Cada participante cria um tópico';
$string['edit'] = 'Editar';
$string['editedby'] = 'Editado por {$a->name} em {$a->date}';
$string['editedpostupdated'] = '{$a} mensagens foram atualizada(s)';
$string['editing'] = 'A editar';
$string['emaildigest_0'] = 'Receberá um e-mail por tópico de fórum.';
$string['emaildigest_1'] = 'Receberá um e-mail por dia com o sumário dos conteúdos completos de cada tópico do fórum.';
$string['emaildigest_2'] = 'Receberá um e-mail por dia com o sumário dos assuntos de cada tópico do fórum.';
$string['emaildigestcompleteshort'] = 'Completo';
$string['emaildigestdefault'] = 'Predefinido ({$a})';
$string['emaildigestoffshort'] = 'Sem sumário';
$string['emaildigestsubjectsshort'] = 'Assuntos';
$string['emaildigesttype'] = 'Opções de Sumários de fóruns';
$string['emaildigesttype_help'] = 'Tipos de sumários que vai receber diariamente para cada fórum:

*Predefinido: de acordo com a configuração de sumário de fóruns do seu perfil de utilizador. Se atualizar o seu perfil, essa alteração também se vai refletir aqui;

*Sem sumário: irá receber um e-mail por cada mensagem publicada no fórum;

*Completo: irá receber um e-mail diário com o conteúdo completo de cada mensagem publicada no fórum;

*Assuntos - irá receber um e-mail diário com os assuntos de cada mensagem publicada no fórum.';
$string['emaildigestupdated'] = 'A opção de e-mail com sumários de fóruns foi alterada para \'{$a->maildigesttitle}\' para o fórum \'{$a->forum}\'. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'A sua configuração predefinida de perfil para \'{$a->maildigesttitle}\' foi usada para o fórum \'{$a->forum}\'. {$a->maildigestdescription}.';
$string['emptymessage'] = 'Foi encontrado um erro na sua mensagem. Ou estava em branco ou continha um anexo demasiado grande. As suas alterações não foram gravadas.';
$string['erroremptymessage'] = 'O texto da mensagem não pode estar em branco';
$string['erroremptysubject'] = 'A assunto da mensagem não pode estar em branco';
$string['errorenrolmentrequired'] = 'Tem de estar inscrito nesta disciplina para aceder a este conteúdo';
$string['errorwhiledelete'] = 'Ocorreu um erro ao apagar';
$string['event_assessable_uploaded'] = 'Foi publicado algum conteúdo.';
$string['everyonecanchoose'] = 'Todos podem optar por subscrever';
$string['everyonecannowchoose'] = 'Todos podem optar por subscrever, a partir deste momento';
$string['everyoneisnowsubscribed'] = 'Todos estão agora subscritos';
$string['everyoneissubscribed'] = 'Todos têm subscrição ativa neste fórum';
$string['existingsubscribers'] = 'Subscrições ativas';
$string['exportdiscussion'] = 'Exportar toda a discussão';
$string['forcedreadtracking'] = 'Permitir forçar "Assinalar mensagens"';
$string['forcedreadtracking_desc'] = 'Esta opção permite que os fóruns sejam configurados para forçar a funcionalidade de Monitorização de fóruns. Isto irá resultar num desempenho reduzido para alguns utilizadores, particularmente em disciplinas com muitos fóruns/tópicos. Quando desativada, quaisquer fóruns previamente definidos para forçar a monitorização são tratados como opcionais.';
$string['forcessubscribe'] = 'Este fórum é de subscrição obrigatória';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Adicionar novo fórum';
$string['forum:addnews'] = 'Adicionar notícia';
$string['forum:addquestion'] = 'Adicionar pergunta';
$string['forum:allowforcesubscribe'] = 'Permitir forçar a subscrição';
$string['forumauthorhidden'] = 'Autor (oculto)';
$string['forumblockingalmosttoomanyposts'] = 'Esta a aproximar-se do número máximo de mensagens submetidas. Enviou {$a->numposts} mensagens no período de {$a->blockperiod} e o limite é de {$a->blockafter} mensagens.';
$string['forumbodyhidden'] = 'Não pode visualizar esta mensagem, provavelmente porque ainda não submeteu uma mensagem no tópico de discussão, o tempo máximo de edição ainda não terminou, a discussão ainda não iniciou ou já terminou.';
$string['forum:createattachment'] = 'Criar anexos';
$string['forum:deleteanypost'] = 'Apagar qualquer mensagem (em qualquer altura)';
$string['forum:deleteownpost'] = 'Apagar as suas próprias mensagens (dentro do prazo)';
$string['forum:editanypost'] = 'Editar qualquer mensagem';
$string['forum:exportdiscussion'] = 'Exportar toda a discussão';
$string['forum:exportownpost'] = 'Exportar mensagem do próprio';
$string['forum:exportpost'] = 'Exportar mensagem';
$string['forumintro'] = 'Descrição';
$string['forum:managesubscriptions'] = 'Gerir subscrições';
$string['forum:movediscussions'] = 'Mover tópicos';
$string['forumname'] = 'Nome do fórum';
$string['forumposts'] = 'Mensagens no fórum';
$string['forum:postwithoutthrottling'] = 'Isento do bloqueio por ultrapassar limite de mensagens submetidas';
$string['forum:rate'] = 'Avaliar mensagens';
$string['forum:replynews'] = 'Responder a notícias';
$string['forum:replypost'] = 'Responder a mensagens';
$string['forums'] = 'Fóruns';
$string['forum:splitdiscussions'] = 'Separar tópicos';
$string['forum:startdiscussion'] = 'Criar novos tópicos de discussão';
$string['forumsubjecthidden'] = 'Assunto (oculto)';
$string['forumtracked'] = 'As mensagens não lidas estão a ser assinaladas';
$string['forumtrackednot'] = 'As mensagens não lidas não estão a ser assinaladas';
$string['forumtype'] = 'Tipo de fórum';
$string['forumtype_help'] = 'Existem 5 tipos de fóruns:

* Um único tópico de discussão - Discussão com um só tópico ao qual todos podem responder (não pode ser usado com grupos separados)
* Cada participante cria um tópico - Cada aluno pode colocar apenas um tópico de discussão ao qual todos podem responder
* Fórum de perguntas e respostas - Os alunos devem responder primeiro à pergunta antes de poder visualizar as respostas dos colegas
* Fórum standard em formato blogue - Fórum aberto no qual todos os participantes podem criar novos tópicos e em que cada tópico de discussão é exibido numa página com o link "Discutir este tópico".
* Fórum standard para utilização geral - Fórum aberto no qual todos os participantes podem criar novos tópicos.';
$string['forum:viewallratings'] = 'Ver as avaliações atribuídas por cada participante';
$string['forum:viewanyrating'] = 'Ver a avaliação global de cada participante';
$string['forum:viewdiscussion'] = 'Ver tópicos de discussão';
$string['forum:viewhiddentimedposts'] = 'Ver mensagens fora do período de visualização';
$string['forum:viewqandawithoutposting'] = 'Ver sempre mensagens perguntas-resposta';
$string['forum:viewrating'] = 'Ver a avaliação global que recebeu';
$string['forum:viewsubscribers'] = 'Ver lista de subscritores';
$string['generalforum'] = 'Fórum standard para utilização geral';
$string['generalforums'] = 'Fóruns gerais';
$string['hiddenforumpost'] = 'Tópico do fórum oculto';
$string['inforum'] = 'em {$a}';
$string['introblog'] = 'As mensagens neste fórum foram copiadas automaticamente de blogues de utilizadores desta disciplina e já não se encontram disponíveis';
$string['intronews'] = 'Notícias gerais e avisos';
$string['introsocial'] = 'Um fórum aberto para conversar sobre qualquer assunto';
$string['introteacher'] = 'Um fórum reservado aos professores';
$string['invalidaccess'] = 'Esta página não foi acedida corretamente';
$string['invaliddigestsetting'] = 'Foi fornecida uma configuração inválida para a opção de e-mail com sumários';
$string['invaliddiscussionid'] = 'O ID do tópico estava incorreto ou já não existe';
$string['invalidforcesubscribe'] = 'Modo de subscrição obrigatória inválido';
$string['invalidforumid'] = 'O Id do fórum estava incorreto';
$string['invalidparentpostid'] = 'ID da mensagem ascendente é inválido';
$string['invalidpostid'] = 'ID da mensagem inválido - {$a}';
$string['lastpost'] = 'Última mensagem';
$string['learningforums'] = 'Fóruns de aprendizagem';
$string['longpost'] = 'Mensagem longa';
$string['mailnow'] = 'Enviar e-mail já';
$string['manydiscussions'] = 'Tópicos por página';
$string['markalldread'] = 'Marcar como lidas todas as mensagens deste tópico.';
$string['markallread'] = 'Marcar como lidas todas as mensagens deste fórum.';
$string['markread'] = 'Marcar como lido';
$string['markreadbutton'] = 'Marcar<br />lido';
$string['markunread'] = 'Marcar como não lida';
$string['markunreadbutton'] = 'Marcar<br /> não lido';
$string['maxattachments'] = 'Número máximo de anexos';
$string['maxattachments_help'] = 'Número máximo de ficheiros que pode ser anexado a uma mensagem do fórum.';
$string['maxattachmentsize'] = 'Tamanho máximo dos anexos';
$string['maxattachmentsize_help'] = 'Esta configuração determina o tamanho máximo de cada ficheiro que pode ser anexo às mensagens do fórum.';
$string['maxtimehaspassed'] = 'Lamentamos mas ultrapassou o tempo máximo ({$a}) para editar esta mensagem!';
$string['message'] = 'Mensagem';
$string['messageprovider:digests'] = 'Fóruns com subscrição ativa';
$string['messageprovider:posts'] = 'Resumos de fóruns com subscrição ativa';
$string['missingsearchterms'] = 'Os termos de pesquisa que se seguem só foram encontrados no código HTML desta mensagem:';
$string['modeflatnewestfirst'] = 'Mostrar respostas por ordem, a começar pela mais recente';
$string['modeflatoldestfirst'] = 'Mostrar respostas por ordem, a começar pela mais antiga';
$string['modenested'] = 'Mostrar respostas em lista encadeada';
$string['modethreaded'] = 'Mostrar respostas em lista contraída';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'A atividade Fórum permite aos participantes ter discussões em modo assíncrono.

Existem vários tipos de fórum, como o fórum standard onde qualquer participante pode começar uma nova discussão, o fórum onde cada aluno pode colocar apenas um tópico de discussão ou o fórum de pergunta-resposta no qual os alunos devem primeiro responder a um tópico (pergunta) para conseguirem ver as respostas dos colegas. O professor pode optar por permitir que sejam anexados ficheiros às mensagens, cujo conteúdo, quando são imagens, é exibido na própria mensagem.

Os participantes podem subscrever um fórum de forma a receber notificações sempre que são submetidas novas mensagens no mesmo. O professor pode configurar a subscrição para o modo opcional, obrigatória ou opcional (ativa ao inicio) ou desativá-la. Se necessário, os alunos podem ser impedidos de inserir mais do que um determinado número de mensagens num determinado período de tempo, no sentido de impedir que alguns alunos dominem as discussões.

As mensagens podem ser avaliadas por professores ou alunos (avaliação pelos pares). As avaliações são convertidas para uma nota final que é registada no relatório de avaliação da disciplina.

Os fóruns podem ser utilizados com várias finalidades, tais como:

* Espaço introdutório para possibilitar que os alunos se conheçam;
* Local para divulgar informação relativa à disciplina (usando o fórum notícias, que tem subscrição obrigatória);
* Um meio de ajuda, onde professores e alunos podem dar conselhos;
* Um método informal de partilha de documentos entre alunos;
* Para continuar a discussão de um assunto iniciado presencialmente na sala de aula;
* Um local de discussão entre professores (usando um fórum oculto);
* Para as atividades de estudos de caso, onde os alunos refletem e partilham opiniões sobre a sua solução;
* Um espaço social de partilha de ideias.';
$string['modulename_link'] = 'fórum';
$string['modulenameplural'] = 'Fóruns';
$string['more'] = 'mais';
$string['movedmarker'] = '(Movido)';
$string['movethisdiscussionto'] = 'Mover este tópico de discussão para...';
$string['mustprovidediscussionorpost'] = 'Precisa de fornecer o ID de discussão ou id da mensagem para exportar';
$string['namenews'] = 'Fórum Notícias';
$string['namenews_help'] = 'O fórum de notícias é um fórum especial, criado automaticamente aquando da criação de uma disciplina. Uma disciplina apenas pode conter um fórum noticias e apenas os professores e administradores podem colocar tópicos nesses fóruns. O bloco "Noticias recentes" mostra os últimos tópicos adicionados.';
$string['namesocial'] = 'Fórum social';
$string['nameteacher'] = 'Fórum de professores';
$string['newforumposts'] = 'Novas mensagens no fórum';
$string['noattachments'] = 'Esta mensagem não tem anexos';
$string['nodiscussions'] = 'Ainda não há tópicos de discussão neste fórum';
$string['nodiscussionsstartedby'] = 'Nenhum tópico iniciado por este utilizador';
$string['nodiscussionsstartedbyyou'] = 'Ainda não começou nenhuma discussão';
$string['noguestpost'] = 'Lamentamos mas como visitante não pode submeter mensagens neste fórum';
$string['noguesttracking'] = 'Lamentamos mas como visitante não pode definir opções de registo de mensagens lidas.';
$string['nomorepostscontaining'] = 'Não foram encontradas mais mensagens contendo \'{$a}';
$string['nonews'] = 'Ainda não foram publicadas notícias';
$string['noonecansubscribenow'] = 'A partir de agora, não há subscrições ativas';
$string['nopermissiontosubscribe'] = 'Não tem permissão para ver os subscritores do fórum';
$string['nopermissiontoview'] = 'Não tem permissões para ver esta mensagem';
$string['nopostforum'] = 'Lamentamos, mas não tem permissão para submeter mensagens neste fórum';
$string['noposts'] = 'Nenhuma mensagem';
$string['nopostsmadebyuser'] = '{$a} não inseriu mensagens';
$string['nopostsmadebyyou'] = 'Ainda não publicou nenhuma mensagem';
$string['noquestions'] = 'Ainda não há perguntas neste fórum.';
$string['nosubscribers'] = 'Ainda não há subscritores neste fórum';
$string['notexists'] = 'O tópico já não existe';
$string['nothingnew'] = 'Nenhuma novidade em {$a}';
$string['notingroup'] = 'Lamentamos mas tem que pertencer a algum grupo para poder visualizar este fórum.';
$string['notinstalled'] = 'O módulo fórum não se encontra instalado';
$string['notpartofdiscussion'] = 'Esta mensagem não faz parte de um tópico de discussão!';
$string['notrackforum'] = 'Não assinalar mensagens não lidas.';
$string['noviewdiscussionspermission'] = 'Não tem as permissões necessárias para ver os tópicos deste fórum.';
$string['nowallsubscribed'] = 'Efetuada a subscrição em todos os fóruns de {$a}.';
$string['nowallunsubscribed'] = 'Cancelada a subscrição em todos os fóruns de {$a}.';
$string['nownotsubscribed'] = '{$a->name} NÃO receberá cópias do fórum \'{$a->forum}\' por e-mail.';
$string['nownottracking'] = 'Já não serão assinaladas as mensagens não lidas por {$a->name} em \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} receberá cópias do fórum \'{$a->forum}\' por e-mail.';
$string['nowtracking'] = 'As mensagens não lidas por {$a->name} em \'{$a->forum}\' serão agora assinaladas.';
$string['numposts'] = '{$a} mensagens';
$string['olderdiscussions'] = 'Tópicos de discussão mais antigos';
$string['oldertopics'] = 'Tópicos mais antigos';
$string['oldpostdays'] = 'Mensagem considerada lida após nº de dias';
$string['openmode0'] = 'Não permite criar tópicos nem responder';
$string['openmode1'] = 'Não permite criar tópicos, mas permite responder';
$string['openmode2'] = 'Permite criar tópicos e responder';
$string['overviewnumpostssince'] = '{$a} mensagens novas desde a última vez que entrou';
$string['overviewnumunread'] = '{$a} mensagens não lidas';
$string['page-mod-forum-discuss'] = 'Página de discussão do fórum';
$string['page-mod-forum-view'] = 'Página principal do fórum';
$string['page-mod-forum-x'] = 'Qualquer página do fórum';
$string['parent'] = 'Mostrar mensagem ascendente';
$string['parentofthispost'] = 'Ascendente desta mensagem';
$string['pluginadministration'] = 'Administração do fórum';
$string['pluginname'] = 'Fórum';
$string['postadded'] = '<p>A sua mensagem foi inserida com sucesso.</p><p>Tem {$a} para a editar se desejar fazer alterações.</p>';
$string['postaddedsuccess'] = 'A sua mensagem foi submetida com sucesso.';
$string['postaddedtimeleft'] = 'Tem {$a} para editar se desejar fazer alterações.';
$string['postbyuser'] = '{$a->post} por {$a->user}';
$string['postincontext'] = 'Ver mensagem no seu contexto';
$string['postmailinfo'] = 'Esta é uma cópia de uma mensagem enviada para {$a}.
Para submeter uma resposta, clique em:';
$string['postmailnow'] = '<p>Esta mensagem será enviada imediatamente a todos os subscritores do fórum.</p>';
$string['postrating1'] = 'Contribui principalmente para a aprendizagem INDIVIDUAL';
$string['postrating2'] = 'Aprendizagem Individual e Coletiva por igual';
$string['postrating3'] = 'Contribui principalmente para a aprendizagem COLETIVA';
$string['posts'] = 'Mensagens';
$string['postsmadebyuser'] = 'Mensagens colocadas por {$a}';
$string['postsmadebyuserincourse'] = 'Mensagens colocadas por {$a->fullname} em {$a->coursename}';
$string['posttoforum'] = 'Submeter tópico';
$string['postupdated'] = 'A sua mensagem foi atualizada';
$string['potentialsubscribers'] = 'Potenciais subscritores';
$string['processingdigest'] = 'A processar sumários para o utilizador {$a}';
$string['processingpost'] = 'A processar a mensagem {$a}';
$string['prune'] = 'Separar';
$string['prunedpost'] = 'Foi criado um novo tópico, a partir desta mensagem';
$string['pruneheading'] = 'Separar esta mensagem e as suas respostas para um novo tópico deste fórum';
$string['qandaforum'] = 'Fórum de pergunta-resposta';
$string['qandanotify'] = 'Este é um fórum de pergunta-resposta. Para poder ver as respostas às questões, deverá enviar primeiro a sua própria resposta.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Ler o resto deste tópico';
$string['replies'] = 'Respostas';
$string['repliesmany'] = '{$a} respostas, por enquanto';
$string['repliesone'] = '{$a} resposta, por enquanto';
$string['reply'] = 'Responder';
$string['replyforum'] = 'Responder para o fórum';
$string['replytouser'] = 'Usar e-mail na resposta';
$string['resetdigests'] = 'Eliminar todas as preferências dos utilizadores para os "Sumários de fóruns"';
$string['resetforums'] = 'Apagar todas as mensagens de';
$string['resetforumsall'] = 'Apagar todas as mensagens';
$string['resetsubscriptions'] = 'Cancelar todas as subscrições ao fórum';
$string['resettrackprefs'] = 'Apagar todas as preferências de assinalar mensagens não lidas';
$string['rssarticles'] = 'Numero de artigos recentes no RSS';
$string['rssarticles_help'] = 'Esta opção permite-lhe selecionar o número de artigos a incluir na listagem RSS.O número mais adequado deverá ser entre 5 a 20.';
$string['rsssubscriberssdiscussions'] = 'Lista RSS de tópicos de discussão';
$string['rsssubscriberssposts'] = 'Lista RSS de tópicos de mensagens';
$string['rsstype'] = 'Lista RSS para esta atividade';
$string['rsstype_help'] = 'Para ativar o RSS para esta atividade, selecione ou discussões ou mensagens para serem incluídas na lista RSS.';
$string['search'] = 'Procurar';
$string['searchdatefrom'] = 'Mensagens posteriores a';
$string['searchdateto'] = 'Mensagens anteriores a';
$string['searchforumintro'] = 'Por favor insira os termos da pesquisa num ou mais dos campos seguintes:';
$string['searchforums'] = 'Procurar nos fóruns';
$string['searchfullwords'] = 'Palavras devem aparecer inteiras';
$string['searchnotwords'] = 'Palavras que não devem estar na mensagem';
$string['searcholderposts'] = 'Procurar mensagens antigas...';
$string['searchphrase'] = 'Frase exata que deve estar na mensagem';
$string['searchresults'] = 'Resultados da procura';
$string['searchsubject'] = 'Palavras que devem estar no assunto';
$string['searchuser'] = 'O autor deverá incluir este nome';
$string['searchuserid'] = 'O código Moodle de identificação do autor';
$string['searchwhichforums'] = 'Escolha os fóruns a pesquisar';
$string['searchwords'] = 'Palavras que podem aparecer em qualquer parte da mensagem';
$string['seeallposts'] = 'Ver todas as mensagens deste utilizador';
$string['shortpost'] = 'Mensagem curta';
$string['showsubscribers'] = 'Mostrar/editar subscritores atuais';
$string['singleforum'] = 'Um único tópico de discussão';
$string['smallmessage'] = '{$a->user}  submeteu mensagem no  {$a->forumname}';
$string['startedby'] = 'Iniciado por';
$string['subject'] = 'Assunto';
$string['subscribe'] = 'Subscrever este fórum';
$string['subscribeall'] = 'Subscrever todos a este fórum';
$string['subscribed'] = 'Com subscrição ativa';
$string['subscribeenrolledonly'] = 'Lamentamos mas apenas os utilizadores autenticados podem se inscrever para receber mensagens do fórum por e-mail.';
$string['subscribenone'] = 'Cancelar a subscrição de todos neste fórum';
$string['subscribers'] = 'Subscritores';
$string['subscribersto'] = 'Subscritores de \'{$a}';
$string['subscribestart'] = 'Envie-me notificações de novos tópicos neste fórum';
$string['subscribestop'] = 'Não quero receber notificações de novos tópicos neste fórum';
$string['subscription'] = 'Subscrição';
$string['subscriptionandtracking'] = 'Subscrever e assinalar mensagens';
$string['subscriptionauto'] = 'Subscrição opcional (ativa no início)';
$string['subscriptiondisabled'] = 'Subscrição desativada';
$string['subscriptionforced'] = 'Subscrição obrigatória';
$string['subscription_help'] = 'Subscrever um fórum significa que receberá notificações por e-mail dos novos tópicos publicados no fórum. Normalmente, pode optar por subscrever, ou não, um fórum. No entanto, em alguns fóruns a subscrição é obrigatória para que todos recebam as notificações.';
$string['subscriptionmode'] = 'Modo de subscrição';
$string['subscriptionmode_help'] = 'Quando um participante se encontra com a subscrição ativa num fórum, significa que irá receber notificações dos tópicos desse fórum. Existem 4 opções de subscrição:

* Subscrição opcional - Os participantes podem escolher se desejam ativar a subscrição;
* Subscrição obrigatória - Todos ficam com a subscrição ativa e não podem cancelar;
* Subscrição automática (ativa no início)- Todos estão com a subscrição ativa no início mas podem cancelá-la a qualquer momento;
* Subscrição desativada - Não é permitido subscrever o fórum.

Nota: Quaisquer alterações ao modo de subscrição só afetarão os utilizadores que se inscreverem futuramente na disciplina, e não os utilizadores existentes.';
$string['subscriptionoptional'] = 'Subscrição opcional';
$string['subscriptions'] = 'Subscrições';
$string['thisforumisthrottled'] = 'Este fórum possui um limite ao número de mensagens que pode submeter num determinado período de tempo. Está atualmente configurado para {$a->blockafter} mensagem(s) em {$a->blockperiod}';
$string['timedposts'] = 'Mensagens com período de visualização';
$string['timestartenderror'] = 'A data de fim não pode ser anterior à data de inicio';
$string['trackforum'] = 'Assinalar mensagens não lidas';
$string['tracking'] = 'Assinalar';
$string['trackingoff'] = 'Não';
$string['trackingon'] = 'forçado';
$string['trackingoptional'] = 'Opcional';
$string['trackingtype'] = 'Assinalar mensagens';
$string['trackingtype_help'] = 'Se ativar esta opção, os participantes podem assinalar e marcar como lidas/não lidas os tópicos do fórum bem como nas discussões. Existem três opções:

* Opcional - Os participantes podem optar por ligar ou desligar a sinalização de mensagens através de uma hiperligação no bloco de administração. O modo de subscrição do fórum também deve ser ativado nas configurações de perfil do utilizador.
* Obrigatória - As mensagens são sempre assinaladas.
* Desativada - As mensagens nunca são assinaladas.';
$string['unread'] = 'Não lidas';
$string['unreadposts'] = 'Mensagens não lidas';
$string['unreadpostsnumber'] = '{$a} mensagens não lidas';
$string['unreadpostsone'] = '1 mensagem não lida';
$string['unsubscribe'] = 'Cancelar subscrição deste fórum';
$string['unsubscribeall'] = 'Cancelar subscrição de todos os fóruns';
$string['unsubscribeallconfirm'] = 'Tem subscrição ativa em {$a} fóruns. Tem a certeza que deseja cancelar a subscrição de todos os fóruns e desativar a auto-subscrição?';
$string['unsubscribealldone'] = 'Todas as suas subscrições foram canceladas, irá continuar a receber e-mails dos fóruns de subscrição obrigatória. Se não desejar receber esses e-mails desative o seu e-mail no seu perfil.';
$string['unsubscribeallempty'] = 'Não tem subscrição ativa em nenhum fórum. Se não desejar receber nenhum e-mail desative o seu e-mail no seu perfil.';
$string['unsubscribed'] = 'Subscrição cancelada';
$string['unsubscribeshort'] = 'Cancelar subscrição';
$string['usermarksread'] = 'Marcar manualmente as mensagens lidas';
$string['viewalldiscussions'] = 'Ver todos os tópicos';
$string['warnafter'] = 'Número de mensagens que gera aviso';
$string['warnafter_help'] = 'Os alunos podem ser avisados que se aproximam do limite máximo de mensagens permitidas num determinado período de tempo. Especifique aqui depois de quantos tópicos submetidos será o aluno avisado. Utilizadores com a capacidade mod/forum:postwithoutthrottling encontram-se isentos destes limites.';
$string['warnformorepost'] = 'Atenção! Há mais do que uma discussão neste fórum - está em uso a mais recente';
$string['yournewquestion'] = 'A sua nova questão';
$string['yournewtopic'] = 'O seu novo tópico de discussão';
$string['yourreply'] = 'A sua resposta';
