<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'it', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Controllo accesso';
$string['actionaftercorrectanswer'] = 'Azione dopo una risposta corretta';
$string['actionaftercorrectanswer_help'] = 'Dopo aver risposto correttamente ad una domanda, sono disponibili 3 opzioni per la pagina successiva:

* Normale - segui il flusso della lezione
* Visualizza una pagina non vista - Le pagine vengono visualizzate casualmente evitando di visualizzare due volte la stessa pagina.
* Visualizza una pagina dove non è stata data una risposta - Le pagine vengono visualizzate casualmente e le pagine dove non è stata data una risposta vengono visualizzate di nuovo';
$string['actions'] = 'Azioni';
$string['activitylink'] = 'Collegamento ad una attività';
$string['activitylink_help'] = 'Per fornire un collegamento ad un\'altra attività del corso quando si raggiunge la fine della lezione, seleziona il collegamento con il menu a discesa.';
$string['activitylinkname'] = 'Vai a {$a}';
$string['activityoverview'] = 'Ci sono lezioni che devi svolgere';
$string['addabranchtable'] = 'Aggiungi pagina con contenuto';
$string['addanendofbranch'] = 'Aggiungi fine diramazione';
$string['addanewpage'] = 'Aggiungi nuova pagina';
$string['addaquestionpage'] = 'Aggiungi pagina con domanda';
$string['addaquestionpagehere'] = 'Aggiungi qui una pagina con domanda';
$string['addbranchtable'] = 'Aggiungi pagina con contenuto';
$string['addcluster'] = 'Aggiungi gruppo';
$string['addedabranchtable'] = 'La pagina con contenuto è stata aggiunta';
$string['addedanendofbranch'] = 'La fine diramazione è stata aggiunta';
$string['addedaquestionpage'] = 'La pagina con domanda è stata aggiunta';
$string['addedcluster'] = 'Il gruppo è stato aggiunto';
$string['addedendofcluster'] = 'La fine gruppo è stata aggiunta';
$string['addendofcluster'] = 'Aggiungi fine gruppo';
$string['addpage'] = 'Aggiungi pagina';
$string['anchortitle'] = 'Inizio del contenuto principale';
$string['and'] = 'e';
$string['answer'] = 'Risposta';
$string['answeredcorrectly'] = 'risposto correttamente.';
$string['answersfornumerical'] = 'Le risposte alle domande numeriche devono essere costituite da coppie di valori minimi e massimi.';
$string['arrangebuttonshorizontally'] = 'Posizionare orizzontalmente i pulsanti del contenuto?';
$string['attempt'] = 'Tentativo: {$a}';
$string['attempts'] = 'Tentativi';
$string['attemptsdeleted'] = 'I tentativi sono stati eliminati';
$string['attemptsremaining'] = 'Ti rimangono {$a} tentativo/i';
$string['available'] = 'Disponibile dal';
$string['averagescore'] = 'Punteggio medio';
$string['averagetime'] = 'Tempo medio';
$string['branch'] = 'Contenuto';
$string['branchtable'] = 'Contenuto';
$string['cancel'] = 'Annulla';
$string['cannotfindanswer'] = 'Errore: non è stato possibile trovare la risposta';
$string['cannotfindattempt'] = 'Errore: non è stato possibile trovare il tentativo';
$string['cannotfindessay'] = 'Errore:  non è stato possibile trovare il testo libero';
$string['cannotfindfirstgrade'] = 'Errore:  non è stato possibile trovare le valutazioni';
$string['cannotfindfirstpage'] = 'Non è stato possibile trovare la prima pagina';
$string['cannotfindgrade'] = 'Errore: Non è stato possibile trovare le valutazioni';
$string['cannotfindnewestgrade'] = 'Errore: Non è stato possibile trovare la valutazione più recente';
$string['cannotfindnextpage'] = 'Backup lezione: non è stato possibile trovare la pagina successiva!';
$string['cannotfindpagerecord'] = 'Aggiungi fine diramazione: non è stato trovato il record della pagina';
$string['cannotfindpages'] = 'Non è stato possibile trovare pagine della lezione';
$string['cannotfindpagetitle'] = 'Conferma eliminazione: il titolo pagina non è stato trovato';
$string['cannotfindpreattempt'] = 'Non è stato possibile trovare il tentativo precedente!';
$string['cannotfindrecords'] = 'Errore: non è stato possibile trovare i record della lezione';
$string['cannotfindtimer'] = 'Errore: non è stato possibile trovare i record della tabella lesson_timer';
$string['cannotfinduser'] = 'Errore: non è stato possibile trovare utenti';
$string['canretake'] = '{$a} può riprovare';
$string['casesensitive'] = 'Utilizza regular expression';
$string['casesensitive_help'] = 'Spunta la casella per usare le regular expression per analizzare le risposte';
$string['checkbranchtable'] = 'Controlla pagina con contenuto';
$string['checkedthisone'] = 'Scelto.';
$string['checknavigation'] = 'Controlla navigazione';
$string['checkquestion'] = 'Controlla domanda';
$string['classstats'] = 'Statistiche della classe';
$string['clicktodownload'] = 'Clicca sul link che segue per scaricare il file.';
$string['clicktopost'] = 'Clicca qui per inserire il tuo voto nell\'elenco dei voti migliori.';
$string['cluster'] = 'Gruppo';
$string['clusterjump'] = 'Domanda non visualizzata di un gruppo ';
$string['clustertitle'] = 'Gruppo';
$string['collapsed'] = 'Formato compatto';
$string['comments'] = 'I tuoi commenti';
$string['completed'] = 'Completata';
$string['completederror'] = 'Completa la lezione';
$string['completethefollowingconditions'] = 'Devi soddisfare le seguenti condizioni nella lezione <b>{$a}</b> prima di poter procedere.';
$string['conditionsfordependency'] = 'Condizione(i) di dipendenza';
$string['configactionaftercorrectanswer'] = 'L\'azione da eseguire per default dopo una risposta corretta';
$string['configmaxanswers'] = 'Default per il numero max. di risposte per pagina';
$string['configmaxhighscores'] = 'Numero di voti migliori da visualizzare';
$string['configmediaclose'] = 'Visualizza il pulsante chudi nella finestra finestra popup contenente un collegamento a file multimediale';
$string['configmediaheight'] = 'Imposta l\'altezza della finestra popup contenete un collegamento a file multimediale';
$string['configmediawidth'] = 'Imposta la larghezza della finestra popup contenete un collegamento a file multimediale';
$string['configslideshowbgcolor'] = 'Se lo slideshow è abilitato, imposta il colore dello sfondo';
$string['configslideshowheight'] = 'Se lo slideshow è abilitato, imposta l\'altezza';
$string['configslideshowwidth'] = 'Se lo slideshow è abilitato, imposta la larghezza';
$string['confirmdelete'] = 'Elimina pagina';
$string['confirmdeletionofthispage'] = 'Confermi l\'eliminazione di questa pagina';
$string['congratulations'] = 'Congratulazioni - hai raggiunto la fine della lezione';
$string['continue'] = 'Continua';
$string['continuetoanswer'] = 'Continua a cambiare le risposte.';
$string['continuetonextpage'] = 'Vai alla prossima pagina.';
$string['correctanswerjump'] = 'In caso di risposta corretta, salta a';
$string['correctanswerscore'] = 'Punteggio per risposta corretta';
$string['correctresponse'] = 'Replica a risposta corretta';
$string['createaquestionpage'] = 'Crea una pagina con domanda';
$string['credit'] = 'Credito';
$string['customscoring'] = 'Punteggio personalizzato';
$string['customscoring_help'] = 'Consente l\'assegnazione di un punteggio numerico a ciascuna risposta (positivo o negativo).';
$string['deadline'] = 'Fino al';
$string['defaultessayresponse'] = 'Il testo libero sarà valutato dal docente.';
$string['deleteallattempts'] = 'Elimina tutti i tentativi della lezione';
$string['deletedefaults'] = 'Eliminata {$a} di default per lezione';
$string['deletedpage'] = 'Pagina eliminata';
$string['deleting'] = 'Eliminazione';
$string['deletingpage'] = 'Eliminazione pagina: {$a}';
$string['dependencyon'] = 'Dipendente da';
$string['dependencyon_help'] = 'Rende la lezione dipendente dai risultati ottenuti dallo studente in un\'altra lezione presente nello stesso corso. E\' possibile usare qualsiasi combinazione di
Tempo impiegato, Completamento o voto.';
$string['description'] = 'Descrizione';
$string['detailedstats'] = 'Statistiche dettagliate';
$string['didnotanswerquestion'] = 'Non è stata data risposta a questa domanda.';
$string['didnotreceivecredit'] = 'Credito non ricevuto';
$string['displaydefaultfeedback'] = 'Usa il feedback di default';
$string['displaydefaultfeedback_help'] = 'Consente l\'utilizzo delle risposte di  default "Risposta corretta" o "Risposta sbagliata" quando non sono impostate risposte specifiche.';
$string['displayhighscores'] = 'Visualizza i voti migliori';
$string['displayinleftmenu'] = 'Visualizzare nel menu di sinistra?';
$string['displayleftif'] = 'Valutazione minima per visualizzare il menu';
$string['displayleftif_help'] = 'L\'impostazione determina il punteggio minimo che lo studente deve raggiungere prima di poter visualizzare il menu a sinistra. In pratica lo studente dovrà svolgere la lezione, ottenere un punteggio e solo in seguito potrà visualizzare il menu a sinistra per rivedere la lezione.';
$string['displayleftmenu'] = 'Visualizza menu a sinistra';
$string['displayleftmenu_help'] = 'Consente la visualizzazione di un elenco di pagine.';
$string['displayofgrade'] = 'Visualizzazione voti (solo per studenti)';
$string['displayreview'] = 'Consente di riprovare la risposta ad una domanda';
$string['displayreview_help'] = 'Se la una risposta è errata verrà visualizzato un pulsante, consentendo allo studente di riprovare senza ricevere valutazione oppure di proseguire nella lezione.';
$string['displayscorewithessays'] = '<p>Hai ottenuto {$a->score} su {$a->tempmaxgrade} per le domande valutate automaticamente.</p>
<p>Le tue {$a->essayquestions} domande a testo libero saranno valutate successivamente e il voto sarà aggiunto<br />al tuo punteggio finale.</p>
<p>La tua valutazione senza le domande a testo libero è {$a->score} su {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Il tuo punteggio è {$a->score} (su {$a->grade}).';
$string['edit'] = 'Modifica';
$string['editingquestionpage'] = 'Modifica pagina con domanda {$a}';
$string['editlessonsettings'] = 'Modifica impostazioni lezione';
$string['editpage'] = 'Modifica contenuto  pagina';
$string['editpagecontent'] = 'Modifica contenuto pagina';
$string['email'] = 'Email';
$string['emailallgradedessays'] = 'Invia per email a TUTTI i testi liberi valutati';
$string['emailgradedessays'] = 'Invia per email i testi liberi  valutati';
$string['emailsuccess'] = 'Invio per email effettuato con successo';
$string['emptypassword'] = 'La password deve essere inserita';
$string['endofbranch'] = 'Fine diramazione';
$string['endofcluster'] = 'Fine gruppo';
$string['endofclustertitle'] = 'Fine gruppo';
$string['endoflesson'] = 'Fine della lezione';
$string['enteredthis'] = 'immesso.';
$string['entername'] = 'Immetti uno pseudonimo per l\'elenco dei voti migliori';
$string['enterpassword'] = 'Inserisci la password:';
$string['eolstudentoutoftime'] = 'Attenzione: Il tempo disponibile per svolgere questa lezione è terminato. L\'ultima risposta può non essere stata considerata se data dopo lo scadere del tempo.';
$string['eolstudentoutoftimenoanswers'] = 'Non hai risposto a nessuna domanda. Per questa lezione hai ottenuto 0 punti.';
$string['essay'] = 'Testo libero';
$string['essayemailmessage'] = '<p>Domanda a testo libero:<blockquote>{$a->question}</blockquote></p><p>La tua replica:<blockquote><em>{$a->response}</em></blockquote></p><p>Commenti {$a->teacher}:<blockquote><em>{$a->comment}</em></blockquote></p><p>Hai ottenuto {$a->earned} su {$a->outof} per questa domanda a testo libero.</p><p>La tua valutazione per la lezione è stata modificata in {$a->newgrade}%#37.</p>';
$string['essayemailmessage2'] = '<p>Domanda a testo libero:<blockquote>{$a->question}</blockquote></p><p>La tua replica:<blockquote><em>{$a->response}</em></blockquote></p><p>Commenti valutatore:<blockquote><em>{$a->comment}</em></blockquote></p><p>Hai ottenuto {$a->earned} su {$a->outof} per questa domanda a testo libero.</p><p>La tua valutazione per la lezione è stata modificata in {$a->newgrade}%#37.</p>';
$string['essayemailsubject'] = 'La tua valutazione per la domanda {$a}';
$string['essays'] = 'Testi liberi';
$string['essayscore'] = 'Punteggio testo libero';
$string['fileformat'] = 'Formato file';
$string['finish'] = 'Termina';
$string['firstanswershould'] = 'La prima risposta dovrebbe portare alla pagina relativa alla risposta "Corretta"';
$string['firstwrong'] = 'Sfortunatamente non puoi ottenere punti per questa domanda, perché la tua risposta non è corretta. Vuoi continuare a provare per il solo piacere di imparare (ma non per migliorare il tuo punteggio)?';
$string['flowcontrol'] = 'Controllo del flusso';
$string['full'] = 'Formato esteso';
$string['general'] = 'Generale';
$string['gotoendoflesson'] = 'Vai alla fine della lezione';
$string['grade'] = 'Punteggio';
$string['gradebetterthan'] = 'Voto maggiore di (%)';
$string['gradebetterthanerror'] = 'Raggiungi un punteggio migliore di {$a} percento';
$string['gradeessay'] = 'Valuta le domande a testo libero ({$a->notgradedcount} non valutate e {$a->notsentcount} non inviate)';
$string['gradeis'] = 'Il voto è {$a}';
$string['gradeoptions'] = 'Opzioni per la valutazione';
$string['handlingofretakes'] = 'Valutazione delle ripetizioni';
$string['handlingofretakes_help'] = 'Se è consentito ripetere la lezione, è possibile impostare il calcolo della valutazione: voto medio dei tentativi o voto migliore.';
$string['havenotgradedyet'] = 'Non sono state ancora valutate.';
$string['here'] = 'in questa posizione';
$string['highscore'] = 'Voto migliore';
$string['highscores'] = 'Voti migliori';
$string['hightime'] = 'Tempo migliore';
$string['importcount'] = 'Importazione di {$a} domande';
$string['importquestions'] = 'Importa domande';
$string['importquestions_help'] = 'Abilita l\'importazione di domande redatte in diversi formati tramite file di testo.';
$string['insertedpage'] = 'Pagina aggiunta';
$string['invalidfile'] = 'File non valido';
$string['invalidid'] = 'Non è stato passato l\'ID modulo o l\'ID lezione';
$string['invalidlessonid'] = 'ID lezione non valido';
$string['invalidpageid'] = 'ID pagina non valido';
$string['jump'] = 'Salta a..';
$string['jumps'] = 'Salti';
$string['jumps_help'] = 'Ciascuna risposta (per le  domande) o ciascuna descrizione (per le pagine con contenuto) hanno un salto corrispondente. Il salto può essere relativo (ad esempio, questa pagina o la pagina successiva) oppure assoluto verso una qualsiasi pagina della lezione.';
$string['jumpsto'] = 'Salti a <em>{$a}</em>';
$string['leftduringtimed'] = 'Hai abbandonato il tentativo durante una lezione a tempo.<br />Clicca su Continua per ricominciare la lezione.';
$string['leftduringtimednoretake'] = 'Hai abbandonato il tentativo durante una lezione a tempo e <br />non puoi riprovare o continuare la lezione.';
$string['leftduringtimedsession'] = 'Hai abbandonato una lezione a tempo.';
$string['lesson:addinstance'] = 'Aggiungere lezioni';
$string['lessonattempted'] = 'Lezione tentata';
$string['lessonclosed'] = 'Questa lezione è stata chiusa il {$a}.';
$string['lessoncloses'] = 'La lezione viene chiusa';
$string['lessoncloseson'] = 'La lezione viene chiusa il';
$string['lesson:edit'] = 'Modificare lezioni';
$string['lessonformating'] = 'Formato della lezione';
$string['lesson:manage'] = 'Gestire lezioni';
$string['lessonmenu'] = 'Menu della lezione';
$string['lessonnotready'] = 'Questa lezione non è ancora pronta. Contatta il tuo {$a}.';
$string['lessonnotready2'] = 'Questa lezione non è pronta.';
$string['lessonopen'] = 'Questa lezione sarà disponibile dal {$a}.';
$string['lessonopens'] = 'La lezione è disponibile';
$string['lessonpagelinkingbroken'] = 'La prima pagina non è stata trovata. Probabilmente i collegamenti tra le pagine sono rotti. Contatta un amministratore del sistema.';
$string['lessonstats'] = 'Statistiche della lezione';
$string['linkedmedia'] = 'Media linkati';
$string['loginfail'] = 'Login fallito, prova ancora...';
$string['lowscore'] = 'Voti peggiori';
$string['lowtime'] = 'Tempi peggiori';
$string['manualgrading'] = 'Valuta i testi liberi';
$string['matchesanswer'] = 'Corrispondenze con la risposta';
$string['matching'] = 'Corrispondenza';
$string['matchingpair'] = 'Coppia corrispondenza {$a}';
$string['maxgrade'] = 'Voto massimo';
$string['maxgrade_help'] = 'L\'impostazione determina il voto massima che può essere ottenuta nella lezione. Se il valore è impostato a 0, la lezione non apparirà nelle valutazioni.';
$string['maxhighscores'] = 'Numero di voti migliori da visualizzare';
$string['maximumnumberofanswersbranches'] = 'Numero massimo di risposte';
$string['maximumnumberofanswersbranches_help'] = 'Specifica il numero max. di risposte utilizzabili nella lezione. Se la lezione usa solamente domande del tipo Vero/Falso questo valore può essere impostato a 2. E\' possibile cambiare l\'impostazione in qualsiasi momento in quanto influisce solo la vista docente, senza alterare i dati.';
$string['maximumnumberofattempts'] = 'Numero massimo di tentativi';
$string['maximumnumberofattempts_help'] = 'Il massimo numero di tentativi concesso per rispondere a ciascuna domanda. Rispondendo correttamente in modo ripetuto, al termine dei tentativi consentiti verrà visualizzata la pagina successiva della lezione.';
$string['maximumnumberofattemptsreached'] = 'E\' stato raggiunto il massimo numero di tentativi - Passaggio alla pagina successiva';
$string['maxtime'] = 'Tempo massimo (minuti)';
$string['maxtimewarning'] = 'Hai {$a} minuto(i) per terminare la lezione.';
$string['mediaclose'] = 'Visualizza il pulsante chiudi:';
$string['mediafile'] = 'Pop-up file';
$string['mediafile_help'] = 'E\' possibile includere una finestra pop-up all\'inizio della lezione. Per farlo devi specificare il file da visualizzare. Se lo desideri il link per aprire la finestra può apparire in tutte le pagine della lezione.';
$string['mediafilepopup'] = 'Clicca qui per visualizzare';
$string['mediaheight'] = 'Altezza finestra popup';
$string['mediawidth'] = 'Larghezza finestra popup';
$string['messageprovider:graded_essay'] = 'Notifiche valutazione di testi liberi';
$string['minimumnumberofquestions'] = 'Numero minimo di domande';
$string['minimumnumberofquestions_help'] = 'Imposta il numero minimo di domande da utilizzare per calcolare il punteggio. Se la lezione contiene una o più pagine di contenuto, il numero minimo di domande dovrebbe essere impostato a zero.

Impostandolo ad un valore più alto, ad esempio 20,  è opportuno aggiungere il seguente testo nella pagina di apertura della lezione: "in questa lezione si richiede di rispondere ad almeno 20 domande. E\' possibile rispondere ad un numero maggiore di domande, tuttavia se si risponde a meno di 20 domande il voto sarà comunque calcolato come se si avesse risposto a 20 domande. ';
$string['missingname'] = 'Inserisci uno pseudonimo';
$string['modattempts'] = 'Possibilità  di revisione';
$string['modattempts_help'] = 'Consentirà allo studente di navigare all\'interno della lezione ripartendo dall\'inizio.';
$string['modattemptsnoteacher'] = 'La revisione funziona solo per gli studenti.';
$string['modulename'] = 'Lezione';
$string['modulename_help'] = 'Il modulo di attività lezione consente al docenti di distribuire contenuti o esercitazioni in modo interessante e flessibile. E\' possibile usare la lezione per creare pagine da fruire sequenzialmente o con diversi percorsi ed opzioni.

E\' possibile includere nelle pagine domande di vario tipo come domande a scelta multipla, a risposta breve ed a  corrispondenza. In base alla risposta data, lo studente può proseguire la lezione, essere riportato alla pagina precedente oppure diretto verso un percorso composto da altre pagine.

Se lo si desidera, è possibile valutare l\'attività ed il punteggio ottenuto sarà memorizzato nel registro del valutatore.

E\' possibile usare le lezioni per:

* auto apprendimento su un dato argomento
* giochi di ruolo e esercizi di decision making
* soddisfare differenti stili di apprendimento; ad esempio, uno studente può scegliere di visualizzare una pagina contenente un video al posto di un pagina di testo
* revisioni differenziate, con diverse serie di domande di revisione basate sulle risposte date alle domande iniziali.';
$string['modulenameplural'] = 'Lezioni';
$string['move'] = 'Sposta pagina';
$string['movedpage'] = 'Pagina spostata';
$string['movepagehere'] = 'Sposta la pagina qui';
$string['moving'] = 'Spostamento pagina: {$a}';
$string['multianswer'] = 'Risposta multipla';
$string['multianswer_help'] = 'Spunta la casella se ci sono più risposte corrette';
$string['multichoice'] = 'Scelta multipla';
$string['multipleanswer'] = 'Risposta multipla';
$string['nameapproved'] = 'Nome approvato';
$string['namereject'] = 'Spiacente, il tuo nome è stato rifiutato dal filtro.<br />Prova con un altro nome.';
$string['new'] = 'nuovo';
$string['nextpage'] = 'Pagina successiva';
$string['noanswer'] = 'Non è stata data risposta ad una o più domande. Torna indietro e dai una risposta.';
$string['noattemptrecordsfound'] = 'Non è stato trovato nessun tentativo: nessun voto è stato dato';
$string['nobranchtablefound'] = 'Non è stata trovata nessuna pagina con contenuto';
$string['nocommentyet'] = 'Ancora nessun commento.';
$string['nocoursemods'] = 'Non è stata trovata nessuna attività';
$string['nocredit'] = 'Nessun credito';
$string['nodeadline'] = 'Nessuna scadenza';
$string['noessayquestionsfound'] = 'Nessuna domanda a testo libero trovata in questa lezione.';
$string['nohighscores'] = 'Nessun punteggio migliore';
$string['nolessonattempts'] = 'Non è stato effettuato nessun tentativo su questa lezione.';
$string['nooneansweredcorrectly'] = 'Nessuno ha risposto correttamente.';
$string['nooneansweredthisquestion'] = 'Nessuno ha risposto a questa domanda.';
$string['noonecheckedthis'] = 'Non è stato scelto da nessuno.';
$string['nooneenteredthis'] = 'Non è stato inserito da nessuno.';
$string['noonehasanswered'] = 'Nessuno ha ancora risposto a una domanda a testo libero.';
$string['noretake'] = 'Non sei autorizzato a  riprovare la lezione.';
$string['normal'] = 'Normale - segui il flusso della lezione';
$string['notcompleted'] = 'Non completato';
$string['notdefined'] = 'Non definito';
$string['nothighscore'] = 'Non hai creato l\'elenco dei {$a} voti migliori.';
$string['notitle'] = 'Senza titolo';
$string['numberofcorrectanswers'] = 'Numero di risposte corrette: {$a}';
$string['numberofcorrectmatches'] = 'Numero di corrispondenze corrette: {$a}';
$string['numberofpagestoshow'] = 'Numero di pagine da visualizzare';
$string['numberofpagestoshow_help'] = 'L\'impostazione determina il numero di pagine visualizzate nella  lezione. L\'impostazione è valida solo per le pagine visualizzate in sequenza casuale (ossia quando "Azione dopo una risposta" corretta è impostato a "Visualizza una pagina che non è stata vista" oppure "Visualizza una pagina dove non è stata data una risposta"). Se il valore è 0, saranno visualizzate tutte le pagine.';
$string['numberofpagesviewed'] = 'Numero di domande risposte: {$a}';
$string['numberofpagesviewednotice'] = 'Numero di domande risposte: {$a->nquestions}; (Ne devi rispondere almeno: {$a->minquestions})';
$string['numerical'] = 'Numerica';
$string['ongoing'] = 'Visualizza il punteggio ottenuto durante lo svolgimento';
$string['ongoingcustom'] = 'Finora hai ottenuto {$a->score} punti su {$a->currenthigh}.';
$string['ongoing_help'] = 'Su ciascuna pagina sarà visualizzato il punteggio ottenuto dallo studente rispetto al punteggio totale.';
$string['ongoingnormal'] = 'Hai risposto correttamente a {$a->correct} domande su {$a->viewed} tentativi.';
$string['onpostperpage'] = 'Solo un inserimento per ciascun voto';
$string['options'] = 'Opzioni';
$string['or'] = 'OR';
$string['ordered'] = 'Ordinato';
$string['other'] = 'Altro';
$string['outof'] = 'su {$a}';
$string['overview'] = 'Riepilogo';
$string['overview_help'] = 'Una lezione è composta da un insieme di pagine con domande e, opzionalmente,  pagine di diramazione. Una pagina con domanda contiene del contenuto e propone una domanda. Ad ogni possibile risposta è associato un salto verso altre pagine. Il salto può essere relativo, ad esempio la stessa pagina o la pagina seguente, oppure assoluto, ossia una qualsiasi delle pagine che compongono una lezione. Una pagina con diramazione è una pagina che contiene una serie di collegamenti ad altre pagine della lezione, come ad esempio un sommario.';
$string['page'] = 'Pagina: {$a}';
$string['pagecontents'] = 'Contenuto della pagina';
$string['page-mod-lesson-edit'] = 'Modifica pagina della lezione';
$string['page-mod-lesson-view'] = 'Visualizzazione o anteprima della pagina della lezione';
$string['page-mod-lesson-x'] = 'Qualsiasi pagina con modulo lezione';
$string['pages'] = 'Pagine';
$string['pagetitle'] = 'Titolo della pagina';
$string['password'] = 'Password';
$string['passwordprotectedlesson'] = '{$a} è una lezione protetta da password.';
$string['pleasecheckoneanswer'] = 'Scegli una risposta';
$string['pleasecheckoneormoreanswers'] = 'Scegli una o più risposte';
$string['pleaseenteryouranswerinthebox'] = 'Inserisci la risposta nel riquadro';
$string['pleasematchtheabovepairs'] = 'Abbina le coppie';
$string['pluginadministration'] = 'Gestione Lezione';
$string['pluginname'] = 'Lezione';
$string['pointsearned'] = 'Punti ottenuti';
$string['postprocesserror'] = 'Si è verificato un errore durante la post-elaborazione!';
$string['postsuccess'] = 'Inviato con successo';
$string['practice'] = 'Lezione di prova';
$string['practice_help'] = 'Una lezione di prova non compare nel registro valutatore.';
$string['preprocesserror'] = 'Si è verificato un errore durante la pre-elaborazione!';
$string['prerequisitelesson'] = 'Lezione prerequisito';
$string['preview'] = 'Anteprima';
$string['previewlesson'] = 'Anteprima di {$a}';
$string['previouspage'] = 'Pagina precedente';
$string['processerror'] = 'Si è verificato un errore durante l\'elaborazione!';
$string['progressbar'] = 'Barra di avanzamento';
$string['progressbar_help'] = 'Consente di visualizzare una barra con la percentuale di completamento.';
$string['progressbarteacherwarning'] = 'Non visualizzare la barra di avanzamento per {$a}';
$string['progressbarteacherwarning2'] = 'Non vedrai la barra di avanzamento in quanto puoi modificare il contenuto della lezione';
$string['progresscompleted'] = 'Hai completato il {$a}% della lezione';
$string['qtype'] = 'Tipo di pagina';
$string['question'] = 'Domanda';
$string['questionoption'] = 'Domanda';
$string['questiontype'] = 'Tipo di domanda';
$string['randombranch'] = 'Pagina casuale con contenuto';
$string['randompageinbranch'] = 'Domanda casuale all\'interno di una pagina di contenuto';
$string['rank'] = 'Classifica';
$string['rawgrade'] = 'Voto grezzo';
$string['receivedcredit'] = 'Credito ottenuto';
$string['redisplaypage'] = 'Rivisualizza pagina';
$string['report'] = 'Risultati';
$string['reports'] = 'Risultati';
$string['response'] = 'Replica';
$string['retakesallowed'] = 'Possibilità di riprovare la lezione';
$string['retakesallowed_help'] = 'Consente agli studenti di svolgere la lezione più di una volta.';
$string['returnto'] = 'Torna a {$a}';
$string['returntocourse'] = 'Ritorna al corso';
$string['review'] = 'Revisione';
$string['reviewlesson'] = 'Rivedi la lezione';
$string['reviewquestionback'] = 'Si, voglio provare ancora';
$string['reviewquestioncontinue'] = 'No, voglio andare alla prossima domanda';
$string['sanitycheckfailed'] = 'Controllo di correttezza fallito: Questo tentativo è stato eliminato';
$string['savechanges'] = 'Salva modifiche';
$string['savechangesandeol'] = 'Salva tutte le modifiche e vai alla fine della lezione.';
$string['savepage'] = 'Salva pagina';
$string['score'] = 'Punteggio';
$string['score_help'] = 'Il punteggio è utilizzato solo se è abilitato il punteggio personalizzato. Ciascuna domanda potrà quindi avere un punteggio numerico positivo o negativo.';
$string['scores'] = 'Punteggi';
$string['secondpluswrong'] = 'Non proprio. Vuoi riprovare?';
$string['selectaqtype'] = 'Scegli il tipo di domanda';
$string['shortanswer'] = 'Risposta breve';
$string['showanunansweredpage'] = 'Visualizza una pagina dove non è stata data una risposta';
$string['showanunseenpage'] = 'Visualizza una pagina che non è stata vista';
$string['singleanswer'] = 'Risposta singola';
$string['skip'] = 'Salta navigazione';
$string['slideshow'] = 'Slideshow';
$string['slideshowbgcolor'] = 'Colore di sfondo slideshow';
$string['slideshowheight'] = 'Altezza slideshow';
$string['slideshow_help'] = 'Consente la visualizzazione della la lezione come uno slideshow di altezza e larghezza fissi.';
$string['slideshowwidth'] = 'Larghezza slideshow';
$string['startlesson'] = 'Inizio lezione';
$string['studentattemptlesson'] = 'Tentativo numero {$a->attempt} di {$a->lastname}, {$a->firstname}';
$string['studentname'] = 'Nome {$a}';
$string['studentoneminwarning'] = 'Attenzione: hai un minuto o meno per terminare la lezione.';
$string['studentresponse'] = 'Risposta di {$a}';
$string['submit'] = 'Invia';
$string['submitname'] = 'Inserisci il nome';
$string['teacherjumpwarning'] = 'In questa lezione stai utilizzando un salto a {$a->cluster} o un salto a {$a->unseen}.  Sarà invece utilizzato il salto alla Pagina seguente. Per verificare i salti devi collegarti con il ruolo di studente.';
$string['teacherongoingwarning'] = 'Durante lo svolgimento della lezione il punteggio ottenuto viene visualizzato solo agli studenti. Esegui il Login come studente per verificare tale punteggio';
$string['teachertimerwarning'] = 'Il timer funziona solamente per gli studenti. Prova il timer facendo il login come studente.';
$string['thatsthecorrectanswer'] = 'Risposta corretta';
$string['thatsthewronganswer'] = 'Risposta sbagliata';
$string['thefollowingpagesjumptothispage'] = 'La seguenti pagine saltano a questa pagina';
$string['thispage'] = 'Questa pagina';
$string['timeisup'] = 'Il tempo è esaurito';
$string['timeremaining'] = 'Tempo rimanente';
$string['timespenterror'] = 'Ha trascorso almeno {$a} minuti nella lezione';
$string['timespentminutes'] = 'Tempo trascorso (minuti)';
$string['timetaken'] = 'Tempo impiegato';
$string['topscorestitle'] = 'I {$a} voti migliori';
$string['truefalse'] = 'Vero/Falso';
$string['unabledtosavefile'] = 'Non è stato possibile salvare il file caricato';
$string['unknownqtypesnotimported'] = 'non sono state importate {$a} domande perché di tipo non supportato ';
$string['unseenpageinbranch'] = 'Domanda non vista in una pagina con contenuto';
$string['unsupportedqtype'] = 'Tipo di domanda non supportata ({$a})!';
$string['updatedpage'] = 'Pagina aggiornata';
$string['updatefailed'] = 'Aggiornamento fallito';
$string['usemaximum'] = 'Voto migliore';
$string['usemean'] = 'Voto medio';
$string['usepassword'] = 'Accesso con password';
$string['usepassword_help'] = 'Per accedere alla lezione sarà necessario conoscere la password.';
$string['viewgrades'] = 'Visualizza risultati';
$string['viewhighscores'] = 'Visualizza elenco voti migliori';
$string['viewreports'] = 'Visualizza i {$a->attempts} tentativi completati da {$a->student}';
$string['viewreports2'] = 'Visualizza {$a} tentativi completati';
$string['welldone'] = 'Ben fatto!';
$string['whatdofirst'] = 'Cosa vuoi fare prima?';
$string['wronganswerjump'] = 'Per risposta errata salta a';
$string['wronganswerscore'] = 'Punteggio per risposta errata';
$string['wrongresponse'] = 'Replica a risposta errata';
$string['xattempts'] = '{$a} tentativi';
$string['youhaveseen'] = 'Hai già  visto più di una pagina di questa lezione. <br />Vuoi iniziare dall\'ultima pagina visitata?';
$string['youmadehighscore'] = 'Sei sull\'elenco dei {$a} voti migliori.';
$string['youranswer'] = 'La tua risposta';
$string['yourcurrentgradeis'] = 'Punteggio ottenuto: {$a}';
$string['yourcurrentgradeisoutof'] = 'Punteggio ottentuo: {$a->grade} su {$a->total}';
$string['youshouldview'] = 'Devi rispondere ad almeno: {$a}';
