<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'eu', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Jarduerak';
$string['addcategory'] = 'Gehitu kategoria';
$string['addcategoryerror'] = 'Ezin izan da kategoria gehitu.';
$string['addexceptionerror'] = 'Errore bat gertatu da userid:gradeitem-i salbuespena gehitzean';
$string['addfeedback'] = 'Gehitu feedbacka';
$string['addgradeletter'] = 'Gehitu kalifikazio-letra';
$string['addidnumbers'] = 'Gehitu ID zenbakiak';
$string['additem'] = 'Gehitu kalifikazio-elementua';
$string['addoutcome'] = 'Gehitu helburua';
$string['addoutcomeitem'] = 'Gehitu helburu-elementua';
$string['addscale'] = 'Gehitu eskala';
$string['aggregateextracreditmean'] = 'Kalifikazioen batez bestekoa (aparteko kredituekin)';
$string['aggregatemax'] = 'Kalifikazio altuena';
$string['aggregatemean'] = 'Kalifikazioen batez bestekoa';
$string['aggregatemedian'] = 'Kalifikazioen mediana';
$string['aggregatemin'] = 'Kalifikazio baxuena';
$string['aggregatemode'] = 'Kalifikazioen moda';
$string['aggregateonlygraded'] = 'Hutsik ez dauden kalifikazioak bakarrik gehitu';
$string['aggregateonlygraded_help'] = 'Kalifikazio hutsa kalifikazio-liburuan ez dagoen kalifikazioa da. Oraindik kalifikatu ez den zeregina izan daiteke edo saiakerarik izan ez duen galdetegia, adibidez.

Ezarpen honek adierazten du kalifikazio hutsak agregazioan sartzen ez diren ala gutxieneko kalifikaziotzat hartzen diren, adibidez 0 0tik 100era kalifikatzen den zeregin batean.';
$string['aggregateoutcomes'] = 'Helburuak agregazioan sartu';
$string['aggregateoutcomes_help'] = 'Gaituta, helburuak agregazioan sartzen dira. Honen ondorioz, kategoriako guztirakoa espero ez zena izan daiteke.';
$string['aggregatesonly'] = 'Agregatutakoak baino ez';
$string['aggregatesubcats'] = 'Agregazioan azpikategoriak sartu';
$string['aggregatesubcats_help'] = 'Agregazioa zuzenean azpian daudenekin bakarrik egiten da, baina azpikategoria guztietan kalifikazioak batzea ere posible da batutako beste kalifikazioak alde batera utzita.';
$string['aggregatesum'] = 'Kalifikazioen batura';
$string['aggregateweightedmean'] = 'Kalifikazioen batez besteko ponderatua';
$string['aggregateweightedmean2'] = 'Kalifikazioen batez besteko ponderatu sinplea';
$string['aggregation'] = 'Agregazioa';
$string['aggregationcoef'] = 'Agregazio-koefizientea';
$string['aggregationcoefextra'] = 'Aparteko kreditua';
$string['aggregationcoefextra_help'] = 'Agregazioa kalifikazioen batura edo batez besteko ponderatu sinplea bada eta aparteko kredituen laukitxoa markatuta badago, kalifikazio-elementuaren gehienezko kalifikazioa ez zaio batuko kategoriaren  gehienezko kalifikazioari, eta beraz ezin izango da lortu gehienezko kalifikazioa (edo gehienezko kalifikaziotik gora, guneko kudeatzaileak gaitu badu) kategorian ez badu gehienezko kalifikazioa elementu guztietan.

Agregazioa kalifikazioen batez bestekoa (aparteko kredituekin) bada eta aparteko kredituak zerotik gorako balorea ezarrita badu, aparteko kreditu horrekin biderkatuko da kalifikazioa, media kalkulatu ondorengo guztirakoari gehitu aurretik.';
$string['aggregationcoefextra_link'] = 'kalifikazioa/agregazioa';
$string['aggregationcoefextrasum'] = 'Aparteko kreditua';
$string['aggregationcoefextrasum_help'] = 'Aparteko kredituen laukitxoa markatuta badago, kalifikazio-elementuaren gehienezko kalifikazioa ez zaio batuko kategoriaren  gehienezko kalifikazioari, eta beraz ezin izango da lortu gehienezko kalifikazioa (edo gehienezko kalifikaziotik gora, guneko kudeatzaileak gaitu badu) kategorian ez badu gehienezko kalifikazioa elementu guztietan.';
$string['aggregationcoefextraweight'] = 'Aparteko kredituen pisua';
$string['aggregationcoefextraweight_help'] = '<p>0tik gorako balore batek kalifikazio-elementu honen kalifikazioa Aparteko kreditu gisa erabiliko du agregazioan zehar. Zenbaki horrekin biderkatuko da kalifikazioaren balorea kalifikazio guztien batuketari gaineratu aurretik, baina elementua ez da kontuan hartiko zatiketan. Adibidez:</p>

<ul>
    <li>1. elementua 0tik 100era bitartean kalifikatzen da eta bere "Aparteko kreditua"ren balorea 2 ezarri da</li>
    <li>2. elementua 0tik 100era bitartean kalifikazten da eta bere "Aparteko kreditua"ren balorea 0.0000-tik ezkerretara dago</li>
    <li>3. elementua 0tik 100era bitartean kalifikazten da eta bere "Aparteko kreditua"ren balorea 0.0000-tik ezkerretara dago</li>
    <li>3 elementuak daude 1. Kategorian eta agregazio-estrategia "Kalifikazioen media (aparteko kredituekin)" da</li>
    <li>Ikasle batez 20ko kalifikazioa du 1. elementuan, 40koa 2. elementuan eta 70ekoa 3. elementuan</li>
    <li>Ikasleak 1. Kategorian izango duen guztirakoa 95/100 izango da horrela lortuta: 20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefweight'] = 'Elementuaren pisua';
$string['aggregationcoefweight_help'] = 'Elementuaren pisua kategoriaren agregazioan erabiltzen da kategoria bereko beste kalifikazio-elementuekin alderatuta elementu horrek duen garrantzia nabarmentzeko.';
$string['aggregationcoefweight_link'] = 'kalifikazioa/agregazioa';
$string['aggregation_help'] = 'Agregazioak zehazten du kategoria bateko kalifikazioak nola lotzen diren, adibidez

* Kalifikazioen media - Kalifikazio guztien batuketa zati kalifikazio-kopurua.
* Kalifikazioen mediana - Tarteko kalifikazioa kalifikazioak tamainaren arabera sailkatzen direnean
* Kalifikazio baxuena
* Kalifikazio altuena
* Kalifikazioen moda - Sarrien agertzen den kalifikazioa
* Kalifikazioen batuketa - Kalifikazio balore guztien batuketa, eskala bidezko kalifikazioak alde batera utzita';
$string['aggregation_link'] = 'kalifikazioa/agregazioa';
$string['aggregationposition'] = 'Agregazioaren kokapena';
$string['aggregationposition_help'] = 'Ezarpen honek adierazten du kategoria eta ikastaroan guztirako zutabeak kalifikazio-liburuaren txostenaren hasieran edo bukaeran agertuko diren.';
$string['aggregationsvisible'] = 'Eskura dauden agregazio-motak';
$string['aggregationsvisiblehelp'] = 'Aukeratu erabilgarri egongo diren agregazio-motak. Erabili Ctrl tekla bat batino gehiago aukeratzeko.';
$string['allgrades'] = 'Kalifikazio guztiak kategoriaka';
$string['allstudents'] = 'Ikasle guztiak';
$string['allusers'] = 'Erabiltzaile guztiak';
$string['autosort'] = 'Automatikoki ordenatu';
$string['availableidnumbers'] = 'Eskura dauden ID zenbakiak';
$string['average'] = 'Batez bestekoa';
$string['averagesdecimalpoints'] = 'Hamartarrak batez bestekoetan';
$string['averagesdecimalpoints_help'] = 'Ezarpen honek bataz bestekoen zutabe bakoitzean erakutsiko diren hamartarren kopurua zehazten du. Heredatu aukeratuta, zutabe bakoitzerako aukeratutako erakusteko modua erabiliko da.';
$string['averagesdisplaytype'] = 'Batez bestekoak erakusteko modua';
$string['averagesdisplaytype_help'] = 'Ezarpen honek zehazten du batez bestekoa (media) kalifikazio errealetan, ehunekotan edo letretan erakutsiko den ala kategoria edo kalifikazio-elementua erakusteko era erabiliko den (heredatua).';
$string['backupwithoutgradebook'] = 'Segurtasun-kopiak ez ditu kalifikazio-liburuaren ezarpenak';
$string['badgrade'] = 'Emandako kalifikazioak ez du balio';
$string['badlyformattedscale'] = 'Mesedez, idatzi komaz bereizitako balore-zerrenda (gutxienez bi balore behar dira).';
$string['baduser'] = 'Emandako erabiltzaileak ez du balio';
$string['bonuspoints'] = 'Bonifikazio-puntuak';
$string['bulkcheckboxes'] = 'Egiaztapen masiboetarako laukitxoak';
$string['calculatedgrade'] = 'Kalkulatutako kalifikazioa';
$string['calculation'] = 'Kalkulua';
$string['calculationadd'] = 'Gehitu kalkulua';
$string['calculationedit'] = 'Editatu kalkulua';
$string['calculation_help'] = 'Kalifikazioen kalkulua kalifikazioak ezartzeko erabiltzen den formula bat da. Formulak berdin (=) sinboloarekin hasi behar du eta matematika-eragiketa ohikoak erabiltzen ditu, besteak beste max, min and sum. Nahi izanez gero, beste kalifikazio-elementu batzuk sar daitezke kalkuluan horien ID zenbakiak bi kortxeteren artean idatzita.';
$string['calculation_link'] = 'kalifikazioa/kalkulua';
$string['calculationsaved'] = 'Kalkulua gordeta';
$string['calculationview'] = 'Ikusi kalkulua';
$string['cannotaccessgroup'] = 'Ezin dira eskuratu aukeratutako taldearen kalifikazioa, barkatu.';
$string['categories'] = 'Kategoriak';
$string['categoriesanditems'] = 'Kategoriak eta elementuak';
$string['categoriesedit'] = 'Kategoria eta elementuak editatu';
$string['category'] = 'Kategoria';
$string['categoryedit'] = 'Editatu kategoria';
$string['categoryname'] = 'Kategoriaren izena';
$string['categorytotal'] = 'Kategorian guztira';
$string['categorytotalfull'] = '{$a->category} guztira';
$string['categorytotalname'] = 'Kategorian guztira-rako izena';
$string['changedefaults'] = 'Berezko baloreak aldatu';
$string['changereportdefaults'] = 'Txostenaren berezko baloreak aldatu';
$string['chooseaction'] = 'Aukera ezazu ekintza bat...';
$string['choosecategory'] = 'Aukera ezazu kategoria';
$string['combo'] = 'Tabuladoreak eta zabaltzen den menua';
$string['compact'] = 'Konpaktatu';
$string['componentcontrolsvisibility'] = 'Kalifikazio-elementu hau ezkutuan dagoen jardueraren ezarpenetatik kontrolatzen da.';
$string['contract'] = 'Uzkurtu kategoria';
$string['controls'] = 'Kontrolak';
$string['courseavg'] = 'Ikastaroaren batez bestekoa';
$string['coursegradecategory'] = 'Ikastaroaren kalifikazio-kategoria';
$string['coursegradedisplaytype'] = 'Ikastaroaren kalifikazioak erakusteko modua';
$string['coursegradedisplayupdated'] = 'Ikastaroaren kalifikazioak erakusteko modua eguneratu da.';
$string['coursegradesettings'] = 'Ikastaroaren kalifikazioen ezarpenak';
$string['coursename'] = 'Ikastaroaren izena';
$string['coursescales'] = 'Ikastaroaren eskalak';
$string['coursesettings'] = 'Ikastaroaren ezarpenak';
$string['coursesettingsexplanation'] = 'Ikastaroen ezarpenetan zehazten da kalifikazio-liburua nola agertuko zaien partaide guztiei ikastaroan.';
$string['coursetotal'] = 'Ikastaroan guztira';
$string['createcategory'] = 'Kategoria sortu';
$string['createcategoryerror'] = 'Ezin da kategoria berririk sortu';
$string['creatinggradebooksettings'] = 'Kalifikazio-liburuaren ezarpenak sortzen';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Oraingo goragoko agregazioa';
$string['curveto'] = 'Hona borobildu';
$string['decimalpoints'] = 'Puntu hamartar orokorrak';
$string['decimalpoints_help'] = 'Honek zehazten du kalifikazio bakoitzean zenbat hamarren erakutsiko den. Ez du eraginik kalifikazioen kalkuluetan 5 hamarrenen zehaztasunez egina baitago.';
$string['default'] = 'Berezkoa';
$string['defaultprev'] = 'Berezko balorea ({$a})';
$string['deletecategory'] = 'Ezabatu kategoria';
$string['disablegradehistory'] = 'Kalifikazioen historia desgaitu';
$string['disablegradehistory_help'] = 'Lotutako kalifikazio-tauletan aldaketa-bilaketaren historiala desgaitu. Honek zertxobait arindu dezake zerbitzariaren funtzionamendua eta datu-basearen lekua mantendu';
$string['displaylettergrade'] = 'Notak letren bidez erakutsi';
$string['displaypercent'] = 'Erakutsi portzentajeak';
$string['displaypoints'] = 'Erakutsi puntuak';
$string['displayweighted'] = 'Erakutsi kalifikazio ponderatuak';
$string['dropdown'] = 'Zabaltzen den menua';
$string['droplow'] = 'Baxuena baztertu';
$string['droplowestvalue'] = 'Ezarri kalifikazio-balore txikiena baztertzeko aukera';
$string['droplow_help'] = '<p>Hau aukeratuta X kalifikazio baxuenak baztertu egingo dira, X aukera honetarako balorea delarik.</p>';
$string['dropped'] = 'Baztertuta';
$string['dropxlowest'] = 'Baztertu X baino baxuagoak';
$string['dropxlowestwarning'] = 'Oharra: \'X baino baxuagorik kontuan ez hartu\' erabiltzen baduzu, kalifikazioak kategoriako item guztiak gehienezko puntuazio berez balioesten direla suposatzen du. Aipatutako baloreak ezberdinak badira, emaitzak edonolakoak izango dira.';
$string['duplicatescale'] = 'Bikoiztu eskala';
$string['edit'] = 'Editatu';
$string['editcalculation'] = 'Editatu kalkulua';
$string['editcalculationverbose'] = 'Kalkulua editatu honentzat: {$a->category} {$a->itemmodule} {$a->itemname} ';
$string['editfeedback'] = 'Editatu feedbacka';
$string['editgrade'] = 'Editatu kalifikazioa';
$string['editgradeletters'] = 'Editatu kalifikazio-letrak';
$string['editoutcome'] = 'Editatu helburua';
$string['editoutcomes'] = 'Editatu helburuak';
$string['editscale'] = 'Editatu eskala';
$string['edittree'] = 'Kategoriak eta elementuak';
$string['editverbose'] = 'Editatu: {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Gaitu AJAX';
$string['enableajax_help'] = 'Kalifikatzailearen txostenari AJAX funtzionalitate geruza bat gehitzen dio, ohiko eragiketak arinduz. Erabiltzailearen nabigatzaileak Javascript-a aktibatuta izan behar du.';
$string['enableoutcomes'] = 'Helburuak gaitu ';
$string['enableoutcomes_help'] = 'Helburuetarako (Gaitasunak, Estandarrak, Irizpideak...) osagarria. Helburuekin lotutako eskala bat edo gehiago erabilita kalifikatuko dugula esan nahi du. Helburuak aktibatuta gune osoan kalifika daiteke era berezi honetan.';
$string['encoding'] = 'Kodifikazioa';
$string['errorcalculationnoequal'] = 'Formulak berdin sinboloarekin hasi behar du (=1+2)';
$string['errorcalculationunknown'] = 'Formula baliogabea';
$string['errorgradevaluenonnumeric'] = 'Kalifikazio altu edo baxurako balore ez zenbakiduna jaso da';
$string['errornocalculationallowed'] = 'Kalkuluak ez daude baimenduta elementu honetarako';
$string['errornocategorisedid'] = 'Ez da kategorizatu gabeko id-rik lortu.';
$string['errornocourse'] = 'Ez da ikastaroaren informaziorik lortu';
$string['errorreprintheadersnonnumeric'] = 'Birrinprimaketa-goialdeetarako balore ez zenbakiduna jaso da';
$string['errorsavegrade'] = 'Ezin da kalifikazioa gorde, barkatu.';
$string['errorsettinggrade'] = 'Errorea "{$a->itemname}" -(r)en kalifikazioa gordetzean {$a->userid} erabiltzailearentzat';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Errorea {$a->id} ID kategoria-kalifikazioaren "Hutsik dauden kalifikazioak baino ez agregatu" ezarpena eguneratzean.';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Errorea {$a->id} ID kategoria-kalifikazioaren "Helburuak agregazioan sartu" ezarpena eguneratzean.';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Errorea {$a->id} ID kategoria-kalifikazioaren "Sartu azpikategoriak agregazioan" ezarpena eguneratzean.Sa';
$string['errorupdatinggradecategoryaggregation'] = 'Errorea {$a->id} IDdun kalifikazio-kategoriaren agregazio-mota eguneratzean';
$string['errorupdatinggradeitemaggregationcoef'] = 'Errorea {$a->id} IDdun kalifikazio-elementuaren agregazio-koefizientea eguneratzean (pisua edo aparteko kreditua)';
$string['excluded'] = 'Baztertutakoak';
$string['excluded_help'] = 'Markatuta, kalifikazioa ez da inongo agregaziotan sartuko.';
$string['expand'] = 'Zabaldu kategoria';
$string['export'] = 'Esportatu';
$string['exportalloutcomes'] = 'Helburu guztiak esportatu';
$string['exportfeedback'] = 'Feedbacka ere sartu esportatzean';
$string['exportplugins'] = 'Esportatu pluginak';
$string['exportsettings'] = 'Esportatu ezarpenak';
$string['exportto'] = 'Esportatu hona:';
$string['extracreditvalue'] = 'Aparteko kreditu-balorea {$a}rako';
$string['extracreditwarning'] = 'Oharra: Kategoriko elementu guztiak krediturik gabe uzten badira, notaren kalkuluan ez dira kontuan hartuko eta, ondorioz, puntuazio orokorrik ez da izango';
$string['feedback'] = 'Feedbacka';
$string['feedbackadd'] = 'Gehitu feedbacka';
$string['feedbackedit'] = 'Editatu feedbacka';
$string['feedbackforgradeitems'] = '{$a}-(r)entzako feedbacka';
$string['feedback_help'] = 'Laukitxo honek aukera ematen du gahitutako kalifikazioari buruzko oharrak idazteko.';
$string['feedbacks'] = 'Feedbackak';
$string['feedbacksaved'] = 'Feedbacka gordeta';
$string['feedbackview'] = 'Ikusi feedbacka';
$string['finalgrade'] = 'Amaierako kalifikazioa';
$string['finalgrade_help'] = '<p>Kalkulu guztiak egin ondoren lortutako bukaerako kalifikazioa (cache-an).</p>';
$string['fixedstudents'] = 'Ikasleen zutabe finkoa';
$string['fixedstudents_help'] = 'Ikasleen zutabea kalifikatzailearen txostenean finkatzen du, kalifikazioak horizontalean lerratuz.';
$string['forceoff'] = 'Behartu: Off';
$string['forceon'] = 'Behartu: On';
$string['forelementtypes'] = 'aukeratutako {$a}-(r)entzat';
$string['forstudents'] = 'Ikasleentzat';
$string['full'] = 'Osoa';
$string['fullmode'] = 'Ikusi osoa';
$string['fullview'] = 'Ikusi osoa';
$string['generalsettings'] = 'Ezarpen orokorrak';
$string['grade'] = 'Kalifikazioa';
$string['gradeadministration'] = 'Kalifikazioen kudeaketa';
$string['gradeanalysis'] = 'Kalifikazio-analisia';
$string['gradebook'] = 'Kalifikazio-liburua';
$string['gradebookhiddenerror'] = 'Kalifikazio-liburua konfiguratuta dago ikasleei ezer ez erakusteko.';
$string['gradebookhistories'] = 'Kalifikazioen historiak';
$string['gradeboundary'] = 'Kalifikazio-letren muga';
$string['gradeboundary_help'] = 'Ezarpen honek adierazten du zein ehunekotik aurrera emango den kalifikazioa letra bidez.';
$string['gradecategories'] = 'Kalifikazio-kategoriak';
$string['gradecategory'] = 'Kalifikazio-kategoria';
$string['gradecategoryonmodform'] = 'Kalifikazio-kategoria';
$string['gradecategoryonmodform_help'] = 'Ezarpen honek zehazten du jarduera honen kalifikazioa zein kategoriatan ezarriko den kalifikazio-liburuan.';
$string['gradecategorysettings'] = 'Kalifikazio-kategorien ezarpenak';
$string['gradedisplay'] = 'Kalifikazioa erakutsi';
$string['gradedisplaytype'] = 'Kalifikazioa erakusteko modua';
$string['gradedisplaytype_help'] = 'Ezarpen honek adierazten du nola erakusten diren kalifikazioak kalifikatzaile eta erabiltzailearen txostenetan.

* Benetakoa- Oraingo kalifikazioak
* Ehunekoa
* Letrak - Letrak edo hitza erabiltzen dira kalifikazio-tarteak adierazteko';
$string['gradedon'] = 'Kalifikatuta: {$a}';
$string['gradeexport'] = 'Kalifikazioak esportatu';
$string['gradeexportcustomprofilefields'] = 'Profilaren eremu pertsonalizatuak kalifikazioen esportazioan';
$string['gradeexportcustomprofilefields_desc'] = 'Sartu profilaren eremu pertsonalizatu hauek kalifikazioen esportazioan, komaz banatuta';
$string['gradeexportdecimalpoints'] = 'Puntu hamartarrak kalifikazio-esportazioan';
$string['gradeexportdecimalpoints_desc'] = 'Esportazioarako erakutsi beharreko hamarren kopurua. Esportazioan zehar alde batera utz daiteke.';
$string['gradeexportdisplaytype'] = 'Kalifikazio-esportazioa erakusteko modua';
$string['gradeexportdisplaytype_desc'] = 'Kalifikazioak kalifikazio erreal gisa, ehunekotan (gehienezko eta gutxienezkoen arabera) edo letratan (A,B,C...) eman daitezke esportaziorako. Esportazioan zehar alde batera utzi daiteke hau.';
$string['gradeexportuserprofilefields'] = 'Erabiltzailearen profilaren eremuak kalifikazioen esportazioan';
$string['gradeexportuserprofilefields_desc'] = 'Sartu erabiltzailearen profilaren eremuak kalifikazioen esportazioan, komaz banatuta.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Kalifikazioei buruzko laguntza';
$string['gradehistorylifetime'] = 'Kalifikazio-historiaren iraupena';
$string['gradehistorylifetime_help'] = 'Lotutako kalifikazio-tauletan izandako aldaketen historiala zenbat denboraz mantendu nahi duzun zehazten du. Ahal beste mantentzea gomendatzen da. Funtzionamendu-arazoak edo datu-basean espazio txikia baduzu, saiatu balore txikiagoa ipintzen.';
$string['gradeimport'] = 'Kalifikazioa inportatu';
$string['gradeimportfailed'] = 'Errorea gertatu da kalifikazioen inportazioan. Xehetasun gehiago:';
$string['gradeitem'] = 'Kalifikazio-elementua';
$string['gradeitemaddusers'] = 'Kalifikaziotik kanpo utzi';
$string['gradeitemadvanced'] = 'Kalifikazio-elementuen aukera aurreratuak';
$string['gradeitemadvanced_help'] = 'Aukera itzazu kalifikazio-elementuak editatzean aurreratu gisa erakutsi behar diren elementuak.';
$string['gradeitemislocked'] = 'Kalifikazio hau blokeatuta dago kalifikazio-liburuan. Jarduera honen kalifikazioetan egindako aldaketak ez dira kopiatuko kalifikazio-liburuan desblokeatu arte.';
$string['gradeitemlocked'] = 'Kalifikazioa blokeatu da';
$string['gradeitemmembersselected'] = 'Kalifikaziotik kanpo daudenak';
$string['gradeitemnonmembers'] = 'Kalifikazioan daudenak';
$string['gradeitemremovemembers'] = 'Kalifikazioan sartu';
$string['gradeitems'] = 'Kalifikazio-elementuak';
$string['gradeitemsettings'] = 'Kalifikazio-elementuen ezarpenak';
$string['gradeitemsinc'] = 'Sartu beharreko kalifikazio-elementuak';
$string['gradeletter'] = 'Kalifikazio-letra';
$string['gradeletter_help'] = 'Kalifikazio-letrak kalifikazio-tarteak adierazteko erabiltzen diren letrak, A, B, C,... edo hitzak dira, adibidez, Ezin hobea, Ikaragarria, Nahikoa,...';
$string['gradeletternote'] = 'Kalifikazio-letra bat ezabatzeko, bakarrik letra horren<br /> hiru testu-eremuetako bat hustu eta aldaketa gorde.';
$string['gradeletters'] = 'Kalifikazio-letrak';
$string['gradelocked'] = 'Kalifikazioa blokeatuta dago';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Gehienezko kalifikazioa';
$string['grademax_help'] = 'Ezarpen honek zehazten du gehinezko kalifikazioa balorea denean kalifikazio-mota. Jarduera batean oinarritutako kalifikazio-elementu baterako gehienezko kalifikazioa jardueraren orriaren ezarpenetan adierazten da.';
$string['grademin'] = 'Gutxieneko kalifikazioa';
$string['grademin_help'] = 'Ezarpen honek zehazten du gutxienezko kalifikazioa balorea denean kalifikazio-mota. ';
$string['gradeoutcomeitem'] = 'Kalifikaziorako helburu-elementuak';
$string['gradeoutcomes'] = 'Helburuak';
$string['gradeoutcomescourses'] = 'Ikastaroaren helburuak';
$string['gradepass'] = 'Gainditzeko kalifikazioa';
$string['gradepass_help'] = 'Ezarpen honek zehazten du gainditzeko gutxienezko kalifikazioa. balorea jarduera eta ikastaro-osaketan erabiltzen da, eta baita kalifikazio-liburuan, zeinetan gainditzeko kalifikazioak berdez markatzen diren eta gainditzen ez dutenak gorriz.';
$string['gradepreferences'] = 'Kalifikazioen hobespenak';
$string['gradepreferenceshelp'] = 'Kalifikazio-hobespenei buruzko laguntza';
$string['gradepublishing'] = 'Argitaratzea gaitu';
$string['gradepublishing_help'] = 'Esportazio eta inportazioetan argitaratzea gaitu: esportatutako kalifikazioak URL batera joanda lor daitezke, Moodle gune batean gorde beharrik izan gabe. Kalifikazioak URL horretara joanda inporta daitezke (horrek ez du esan nahi Moodle gune batek beste batek argitaratutako kalifikazioak inporta ditzakeenik). Berez, kudeatzaileak bakarrik erabil dezake funtzio hau; mesedez, erakutsi erabiltzaileei beste rol batzuei hau egiteko gaitasunak eman aurretik.';
$string['gradereport'] = 'Kalifikazio-txostena';
$string['graderreport'] = 'Kalifikatzailearen txostena';
$string['grades'] = 'Kalifikazioak';
$string['gradesforuser'] = '{$a->user} erabiltzailearen kalifikazioak';
$string['gradesonly'] = 'Kalifikazioak baino ez';
$string['gradessettings'] = 'kalifikazioen ezarpenak';
$string['gradetype'] = 'Kalifikazio-mota';
$string['gradetype_help'] = '4 kalifikazio mota daude:

* Bat ere ez - Ezin da kalifikatu
* Balorea - Zenbakizko balore bat, gehieneko eta gutxienekoarekin
* Eskala - Zerrenda bateko elementu bat
* Testua - Feecback-a bakarrik

Balorea eta eskala motako kalifikazioak bakarrik agrega daitezke. Jarduera baten kalifikaziorako kalifikazio-mota jardueraren ezerpenek orrian aukeratzen da.';
$string['gradeview'] = 'Ikusi kalifikazioa';
$string['gradeweighthelp'] = 'Kalifikazioen pisuari buruzko laguntza';
$string['groupavg'] = 'Taldearen batez bestekoa';
$string['hidden'] = 'Ezkutuan';
$string['hiddenasdate'] = 'Ezkutuko kalifikazioetan bidalketa-data erakutsi';
$string['hiddenasdate_help'] = 'Erabiltzaileak ezin baditu ezkutuko kalifikazioak erakutsi bidalketa data \'-\'-en ordez.';
$string['hidden_help'] = 'Markatuta, ezkutatu egingo zaizkie kalifikazioak ikasleei. Nahi izanez gero noiz arte ezkutatu ezar daiteke, kalifikazioa osatuta dagoenean kalifikazioak erakusteko.';
$string['hiddenuntil'] = 'Noiz arte ezkutuan';
$string['hiddenuntildate'] = 'Noiz arte ezkutuan: {$a}';
$string['hideadvanced'] = 'Ezaugarri aurreratuak ezkutatu';
$string['hideaverages'] = 'Batez bestekoak ezkutatu';
$string['hidecalculations'] = 'Kalkuluak ezkutatu';
$string['hidecategory'] = 'Ezkutuan';
$string['hideeyecons'] = 'Ikonoak ezkutatu/erakutsi/ezkutatu';
$string['hidefeedback'] = 'Ezkutatu feedbacka';
$string['hideforcedsettings'] = 'Behartutako ezarpenak ezkutatu';
$string['hideforcedsettings_help'] = 'UI kalifikatzean, ez erakutsi behartutako ezarpenak';
$string['hidegroups'] = 'Ezkutatu taldeak';
$string['hidelocks'] = 'Blokeoak ezkutatu';
$string['hidenooutcomes'] = 'Helburuak erakutsi';
$string['hidequickfeedback'] = 'Feedback azkarra ezkutatu';
$string['hideranges'] = 'Ibiltartea ezkutatu';
$string['hidetotalifhiddenitems'] = 'Ezkutatu guztirakoak ezkutuko elementuak baldin badituzte.';
$string['hidetotalshowexhiddenitems'] = 'Erakutsi guztirakoak ezkutuko elementuak baztertuta';
$string['hidetotalshowinchiddenitems'] = 'Erakutsi guztirakoak ezkutuko elementuak barne';
$string['hideverbose'] = 'Ezkutatu {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Kalifikazioak gorantz ordenatu';
$string['highgradedescending'] = 'Kalifikazioak beherantz ordenatu';
$string['highgradeletter'] = 'Altuak';
$string['identifier'] = 'Erabiltzailea honela identifikatu';
$string['idnumbers'] = 'ID zenbakiak';
$string['ignore'] = 'Baztertu';
$string['import'] = 'Inportatu';
$string['importcsv'] = 'inportatu CSV';
$string['importcustom'] = 'Inportatu pertsonalizatutako helburu bezala (ikastaro honetan baino ez)';
$string['importfailed'] = 'Inportatzeak kale egin du';
$string['importfeedback'] = 'Inportatu feedbacka';
$string['importfile'] = 'Inportatu fitxategia';
$string['importfilemissing'] = 'Ez da fitxategirik jaso; jo atzera formulariora eta ziurtatu balio duen fitxategia igo duzula.';
$string['importfrom'] = 'Inportatu hemendik:';
$string['importoutcomes'] = 'Inportatu helburuak';
$string['importoutcomesuccess'] = 'Inportatutako helburua ({$a->name}) #{$a->id} ID-arekin';
$string['importplugins'] = 'inportatu pluginak';
$string['importpreview'] = 'Inportatu aurrebista';
$string['importsettings'] = 'Inportatu ezarpenak';
$string['importskippednomanagescale'] = 'Ez duzu eskala berria gehitzeko baimenik, beraz {$a} helburua alde batera utziko da eskala berria sortzea eskatzen baitu.';
$string['importskippedoutcome'] = '{$a} izen laburreko helburua badago dagoeneko testuinguru honetan, inportatutako fitxategiko bat alde batera utziko da, beraz.';
$string['importstandard'] = 'Inportatu helburu estandar bezala';
$string['importsuccess'] = 'Kalifikazioak ondo inportatu dira';
$string['importxml'] = 'Inportatu XML';
$string['includescalesinaggregation'] = 'Eskalak ere agregazioan sartu';
$string['includescalesinaggregation_help'] = 'Ikastaro guztietan kalifikazio-liburu guztietan agregatutako kalifikazio guztietan eskalak zenbaki gisa sartuko diren erabaki ahal duzu. KONTUZ: ezarpen hau aldatzen baduzu kalifikazio guztiak berriz kalkulatuko dira.';
$string['incorrectcourseid'] = 'Ikastaroaren IDa okerra da';
$string['incorrectcustomscale'] = '(Eskala pertsonalizatu ezegokia, mesedez aldatu.)';
$string['incorrectminmax'] = 'Gutxienenekoak gehienekoak baino txikiagoa izan behar du.';
$string['inherit'] = 'Heredatu';
$string['intersectioninfo'] = 'Ikaslea/Kalifikazioaren informazioa';
$string['item'] = 'Elementua';
$string['iteminfo'] = 'Elementuaren informazioa';
$string['iteminfo_help'] = 'Elementuari buruzko informazioa sartzeko eremua. Bertan sartutako testua ez da beste inon agertuko.';
$string['itemname'] = 'Elementuaren izena';
$string['itemnamehelp'] = 'Elementu honen izena, moduluak emandakoa';
$string['items'] = 'Elementuak';
$string['itemsedit'] = 'Editatu kalifikazio-elementua';
$string['keephigh'] = 'Mantendu altuena';
$string['keephigh_help'] = '<p>Ezarriz gero, X kalifikazio altuenak bakarrik gordeko dira, eta X izango da aukera honetarako ezarritako balorea.</p>';
$string['keymanager'] = 'Giltzen kudeatzailea';
$string['lessthanmin'] = '{$a->itemname}-n {$a->username}-ri emandako kalifikazioa baimendutako txikiena baino baxuagoa da';
$string['letter'] = 'Letra';
$string['lettergrade'] = 'Letren bidezko kalifikazioa';
$string['lettergradenonnumber'] = 'Kalifikazio baxu edo/eta altu ez zenbakidunak';
$string['letterpercentage'] = 'Letra (portzentajea)';
$string['letterreal'] = 'Letra (erreala)';
$string['letters'] = 'Letrak';
$string['linkedactivity'] = 'Estekatutako jarduera';
$string['linktoactivity'] = 'Esteka {$a->name} jarduerara';
$string['lock'] = 'Blokeatu';
$string['locked'] = 'Blokeatuta';
$string['locktime'] = 'Blokeatu honen ondoren';
$string['locktimedate'] = 'Blokeatu honen ondoren: {$a}';
$string['lockverbose'] = 'Blokeatu {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Baxuena';
$string['lowgradeletter'] = 'Baxua';
$string['manualitem'] = 'Eskuzko elementua';
$string['mapfrom'] = 'Mapa hemendik';
$string['mappings'] = 'Kalifikazio-elementuen mapeoa';
$string['mapto'] = 'Mapa hona';
$string['max'] = 'Altuena';
$string['maxgrade'] = 'Gehien. Kal.';
$string['meanall'] = 'Kalifikazio guztiak';
$string['meangraded'] = 'Hutsik ez dauden kalifikazioak';
$string['meanselection'] = 'Batez bestekoen zutaberako aukeratutako kalifikazioak';
$string['meanselection_help'] = 'Aukeratu kalifikaziorik gabeko gelaxkak zutabe bakoitzaren batez bestekoa kalkulatzeko erabiliko diren ala ez.';
$string['median'] = 'Ertaina';
$string['min'] = 'Baxuena';
$string['missingscale'] = 'Eskala aukeratu beha da';
$string['mode'] = 'Modua';
$string['morethanmax'] = '{$a->itemname}-n {$a->username}-ri emandako kalifikazioa baimendutako gehienezkoa baino handiagoa da';
$string['moveselectedto'] = 'Aukeratutako elementuak hona mugitu:';
$string['movingelement'] = '{$a} mugitzen';
$string['multfactor'] = 'Biderkatzailea';
$string['multfactor_help'] = 'Kalifikazio-elementu honen kalifikazio guztiak zein faktorerekin biderkatuko diren, beti ere kalifikazio maximoa gainditu gabe. Adibidez, biderkatzailea 2 bada eta kalifikazio maximoa 100, 50etik beherako balioak bikoiztuko dira eta hortik gorakoak 100 baliora aldatuko dira.';
$string['multfactorvalue'] = 'Biderkatzailearen balorea {$a}rako';
$string['mypreferences'] = 'Nire hobespenak';
$string['myreportpreferences'] = 'Nire txostenaren hobespenak';
$string['navmethod'] = 'Nabigazio-metodoa';
$string['neverdeletehistory'] = 'Ez ezabatu historiala inoiz';
$string['newcategory'] = 'Kategoria berria';
$string['newitem'] = 'Kalifikazio-elementu berria';
$string['newoutcomeitem'] = 'Helburu-elementu berria';
$string['no'] = 'Ez';
$string['nocategories'] = 'Ikasgai honetako kalifikazio-kategoriak ez dira erantsi edo aurkitu';
$string['nocategoryname'] = 'Kategoriak ez du izenik';
$string['nocategoryview'] = 'Ikusteko kategoriarik ez';
$string['nocourses'] = 'Oraindik ez dago ikastarorik';
$string['noforce'] = 'Ez behartu';
$string['nogradeletters'] = 'Kalifikazio-letrak ez dira ezarri';
$string['nogradesreturned'] = 'Ez da kalifikaziorik itzuli';
$string['noidnumber'] = 'ID zenbakirik ez';
$string['nolettergrade'] = 'Ikusteko kalifikaziorik ez';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Zenbakidun balorea jaso da';
$string['nonunlockableverbose'] = 'Kalifikazio hau ezin da desblokeatu {$a->itemname} desblokeatu arte.';
$string['nonweightedpct'] = '% ez neurtua';
$string['nooutcome'] = 'Helbururik ez';
$string['nooutcomes'] = 'Helburu-elementuak ikastaroko helburu batekin lotuta egon behar du, baina ikastaro honetan ez dago helbururik. Gehitu nahi al duzu bat?';
$string['nopublish'] = 'Ez argitaratu';
$string['norolesdefined'] = 'Definitu gabeko rolak hemen: Kudeaketa > Kalifikazioak > Ezarpen orokorrak > Kalifikatutako rolak';
$string['noscales'] = 'Helburuak ikastaroko eskala edo eskala global batekin egon behar du lotuta, baina ez dago bat ere. Gehitu nahi al duzu bat?';
$string['noselectedcategories'] = 'ez da kategoriarik aukeratu.';
$string['noselecteditems'] = 'ez da elementurik aukeratu.';
$string['notteachererror'] = 'Irakasleek soilik erabil dezakete aukera hau.';
$string['nousersloaded'] = 'Ez da erabiltzailerik aurkitu';
$string['numberofgrades'] = 'Kalifikazio-kopurua';
$string['onascaleof'] = '{$a->grademin} -tik {$a->grademax} -ra bitarteko eskalan';
$string['operations'] = 'Eragiketak';
$string['options'] = 'Aukerak';
$string['others'] = 'Beste batzuk';
$string['outcome'] = 'Helburua';
$string['outcomeassigntocourse'] = 'Esleitu beste helburu bat ikastaro honetan';
$string['outcomecategory'] = 'Helburuak kategorian sortu';
$string['outcomecategorynew'] = 'Kategoria berria';
$string['outcomeconfirmdelete'] = 'Ziur al zaude "{$a}" helburua ezabatu nahi duzula?';
$string['outcomecreate'] = 'Beste helburu bat gehitu';
$string['outcomedelete'] = 'Ezabatu helburua';
$string['outcomefullname'] = 'Izen osoa';
$string['outcome_help'] = 'Ezarpen honek zehazten du kalifikazio-elementua zein helbururekin lotuta agertuko den kalifikazio-liburuan.';
$string['outcomeitem'] = 'Helburuaren elementua';
$string['outcomeitemsedit'] = 'Helburuaren elementua editatu';
$string['outcomereport'] = 'Helburuen txostena';
$string['outcomes'] = 'Helburuak';
$string['outcomescourse'] = 'Ikastaroan erabilitako helburuak';
$string['outcomescoursecustom'] = 'Erabilitako pertsonalizatua (ez kendu)';
$string['outcomescoursenotused'] = 'Erabili gabeko estandarra';
$string['outcomescourseused'] = 'Erabilitako estandarra (ez kendu)';
$string['outcomescustom'] = 'Helburuak pertsonalizatu';
$string['outcomeshortname'] = 'Izen laburra';
$string['outcomesstandard'] = 'Helburu estandarrak';
$string['outcomesstandardavailable'] = 'Eskura dauden helburu estandarrak';
$string['outcomestandard'] = 'Helburu estandarra';
$string['outcomestandard_help'] = 'Gune osoan, ikastaro guztietan, dago eskuragarri edozein Helburu estandar.';
$string['overallaverage'] = 'Batez besteko orokorra';
$string['overridden'] = 'Baliogabetuak';
$string['overriddennotice'] = 'Jarduera honetako zure azken kalifikazioa eskuz egokitu da.';
$string['overridesitedefaultgradedisplaytype'] = 'Ez hartu kontuan gunearen berezko baloreak';
$string['parentcategory'] = 'Goragoko kategoria';
$string['pctoftotalgrade'] = '% kalifikazio orokorretik';
$string['percent'] = 'Portzentajea';
$string['percentage'] = 'Portzentajea';
$string['percentageletter'] = 'Portzentajea (letra)';
$string['percentagereal'] = 'Portzentajea (erreala)';
$string['percentascending'] = 'Portzentajeak gorantz sailkatu';
$string['percentdescending'] = 'Portzentajeak beherantz ordenatu';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Konpentsatu';
$string['plusfactor_help'] = 'Konpentsazioa kalifikazio-elementu honen kalifikazio guztiei gehituko zaien zenbakia da, biderkatzailea aplikatu ondoren.';
$string['points'] = 'puntuak';
$string['pointsascending'] = 'Puntuak gorantz sailkatu';
$string['pointsdescending'] = 'Puntuak beherantz ordenatu';
$string['positionfirst'] = 'Lehena';
$string['positionlast'] = 'Azkena';
$string['preferences'] = 'Hobespenak';
$string['prefgeneral'] = 'Orokorra';
$string['prefletters'] = 'Kalifikazio-letrak eta mugak';
$string['prefrows'] = 'Zutabe bereziak';
$string['prefshow'] = 'Erakutsi/ezkutatu kontrolak';
$string['previewrows'] = 'Zutabeak aurreikusi';
$string['profilereport'] = 'Erabiltzaile-profilaren txostena';
$string['profilereport_help'] = 'Erabiltzailearen profil-orrian erabilitako kalifikazio-txostena.';
$string['publishing'] = 'Argitaratzen';
$string['quickfeedback'] = 'Feedback azkarra';
$string['quickgrading'] = 'Kalifikazio azkarra';
$string['quickgrading_help'] = '<p>Honekin kalifikatzailearen txostenean kalifikazio bakoitzerako editatzeko moduko laukitxoa agertuko da eta bertan aldatu ahal izango duzu azkar asko hainbat ikasleren kalifikazioa.</p>';
$string['range'] = 'Ibiltartea';
$string['rangedecimals'] = 'Ibiltarteen puntu hamartarrak';
$string['rangedecimals_help'] = 'Erakutsiko diren puntu hamartarren kopurua ibiltarteetarako';
$string['rangesdecimalpoints'] = 'Hamartarrak erakutsi ibiltarteetan';
$string['rangesdecimalpoints_help'] = 'Kalifikazio zutabe baten gainean erakutsi beharreko hamartarren kopurua. Elementua kalifikatuta anula daiteke ezarpen hau.';
$string['rangesdisplaytype'] = 'Ibiltartea erakusteko modua';
$string['rank'] = 'Sailkapena';
$string['rawpct'] = '% gordina';
$string['real'] = 'Erreala';
$string['realletter'] = 'Erreala (letra)';
$string['realpercentage'] = 'Erreala (portzentajea)';
$string['regradeanyway'] = 'Kalifikatu berriz hala ere';
$string['removeallcoursegrades'] = 'Kalifikazio guztiak ezabatu';
$string['removeallcourseitems'] = 'Elementu eta kategoria guztiak ezabatu';
$string['report'] = 'Txostena';
$string['reportdefault'] = 'Berezko ezarpena ({$a})';
$string['reportplugins'] = 'Txostenetarako plugin-ak';
$string['reportsettings'] = 'Txostenaren ezarpenak';
$string['reprintheaders'] = 'Goialdeak berriz inprimatu';
$string['respectingcurrentdata'] = 'Egungo ezarpenak ez dira aldatu';
$string['rowpreviewnum'] = 'Zutabeak aurreikusi';
$string['savechanges'] = 'Aldaketak gorde';
$string['savepreferences'] = 'Hobespenak gorde';
$string['scaleconfirmdelete'] = 'Ziur al zaude "{$a}" eskala ezabatu nahi duzula?';
$string['scaledpct'] = 'Eskalatua %';
$string['seeallcoursegrades'] = 'Ikusi ikastaroaren kalifikazio guztiak';
$string['select'] = 'Aukeratu {$a}';
$string['selectalloroneuser'] = 'Aukeratu erabiltzaile bat edo guztiak';
$string['selectauser'] = 'Aukeratu erabiltzaile bat';
$string['selectdestination'] = 'Aukeratu helbidea honentzat: {$a}';
$string['separator'] = 'Bereizlea';
$string['sepcomma'] = 'Koma';
$string['septab'] = 'Tabuladorea';
$string['setcategories'] = 'Ezarri kategoriak';
$string['setcategorieserror'] = 'Neurketak esleitu aurretik ikastaroko kategoriak ezarri behar dituzu.';
$string['setgradeletters'] = 'Letraz kalifikatu';
$string['setpreferences'] = 'Hobespenak';
$string['setting'] = 'Ezarpena';
$string['settings'] = 'Ezarpenak';
$string['setweights'] = 'Ezarri pisuak';
$string['showactivityicons'] = 'Jarduera-ikonoak erakutsi';
$string['showactivityicons_help'] = 'Gaituta, jardueren izenaren ondoan jardueren ikonoak erakutsiko dira.';
$string['showallhidden'] = 'Erakutsi ezkutukoak';
$string['showallstudents'] = 'Ikasle guztiak erakutsi';
$string['showanalysisicon'] = 'Erakutsi kalifikazio-analisiaren ikonoa';
$string['showaverage'] = 'Erakutsi batez bestekoa';
$string['showaverages'] = 'Batez bestekoak erakutsi';
$string['showaverages_help'] = 'Gaituta, kalifikatzailearen txostenean kategoria eta elementu bakoitzerako  batez bestekoa erakusten dituen beste lerro bat erakusten du.';
$string['showcalculations'] = 'Kalkuluak erakutsi';
$string['showcalculations_help'] = 'Kalifikazio-elementu edo kategoria bakoitzaren ondoan ikonoak, kalkulatutako elementuen gainean tresnak eta zutabe bat kalkulatua delako adierazlea erakutsi ala ez.';
$string['showeyecons'] = 'Erakutsi ikonoak erakutsi/ezkutatu';
$string['showeyecons_help'] = 'Kalifikazio bakoitzaren ondoan erakutsi/ezkutatu ikonoa erakutsi ala ez (erabiltzaileak ikus dezakeen kontrolatzeko).';
$string['showfeedback'] = 'Erakutsi feedbacka';
$string['showfeedback_help'] = 'Feedbackaren zutabea erakutsi?';
$string['showgrade'] = 'Erakutsi kalifikazioak';
$string['showgrade_help'] = 'Kalifikazioen zutabea erakutsi?';
$string['showgroups'] = 'Taldeak erakutsi';
$string['showhiddenitems'] = 'Erakutsi ezkutuko elementuak';
$string['showhiddenuntilonly'] = 'Noiz arte ezkutuan bakarrik';
$string['showlettergrade'] = 'Erakutsi kalifikazio-letrak';
$string['showlettergrade_help'] = 'Kalifikazio-letren zutabea erakutsi?';
$string['showlocks'] = 'Blokeoak erakutsi';
$string['showlocks_help'] = '<p>Kalifikazio bakoitzaren ondoan blokeatu/desblokeatu ikonoa erakutsi ala ez.</p>';
$string['shownohidden'] = 'Ez erakutsi';
$string['shownooutcomes'] = 'Helburuak ezkutatu';
$string['shownumberofgrades'] = 'Erakutsi kalifikazio-kopurua batez bestekoetan';
$string['shownumberofgrades_help'] = '<p>Media bakoitzaren atzean parentesi artean media kalkulatzeko erabili den kalifikazio-kopurua erakutsi ala ez, adibidez 45 (34).</p>';
$string['showpercentage'] = 'Erakutsi portzentajea';
$string['showpercentage_help'] = 'Erakutsi ehunekoaren balorea kalifikazio-elementu bakoitzerako?';
$string['showquickfeedback'] = 'Erakutsi feedback azkarra';
$string['showrange'] = 'Erakutsi ibilarteak';
$string['showrange_help'] = 'Ibilarteen zutabea erakutsi?';
$string['showranges'] = 'Ibiltarteak erakutsi';
$string['showranges_help'] = 'Gaituz gero, kalifikatzailearen txostenean kategoria eta elementu bakoitzerako kalifikazio-mailak erakusten dituen beste lerro bat erakusten du.';
$string['showrank'] = 'Erakutsi sailkapena';
$string['showrank_help'] = 'Erakutsi ikaslearen kokapena klaseko gainontzekoen aldean kalifikazio-elementu bakoitzean?';
$string['showuserimage'] = 'Erabiltzaile-profilaren irudiak erakutsi';
$string['showuserimage_help'] = 'Kalfikatzailearen txostenean izenaren ondoren erabiltzailearen profilaren irudia erakutsi ala ez';
$string['showverbose'] = 'Erakutsi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Erakutsi ponderazioak';
$string['showweight_help'] = 'Kalifikazio ponderatuen zutabea erakutsi?';
$string['simpleview'] = 'Ikuspegi sinplea';
$string['sitewide'] = 'Gune osoa';
$string['sort'] = 'ordenatu';
$string['sortasc'] = 'Behetik gora sailkatu';
$string['sortbyfirstname'] = 'Ordenatu izenaren arabera';
$string['sortbylastname'] = 'Deituraren arabera ordenatu';
$string['sortdesc'] = 'Goitik behera ordenatu';
$string['standarddeviation'] = 'Desbiderapen estandarra';
$string['stats'] = 'Estatistikak';
$string['statslink'] = 'Estatistikak';
$string['student'] = 'Ikaslea';
$string['studentsperpage'] = 'Ikasleak orriko';
$string['studentsperpage_help'] = 'Orriko erakutsi beharreko ikasle-kopurua kalifikatzailearen txostenean';
$string['subcategory'] = 'Ohiko kategoria';
$string['submissions'] = 'Bidalketak';
$string['submittedon'] = 'Bidalita: {$a}';
$string['switchtofullview'] = 'Aldatu ikuspegi osora';
$string['switchtosimpleview'] = 'Aldatu ikuspegi sinplera';
$string['tabs'] = 'Tabuladoreak';
$string['topcategory'] = 'Kategoria gorena';
$string['total'] = 'Guztira';
$string['totalweight100'] = 'Pisu osoa 100ekoa da';
$string['totalweightnot100'] = 'Pisu osoa ez da 100ekoa';
$string['turnfeedbackoff'] = 'Feedbacka desgaitu';
$string['turnfeedbackon'] = 'Feedbacka gaitu';
$string['typenone'] = 'Bat ere ez';
$string['typescale'] = 'Eskala';
$string['typescale_help'] = '<p>Eskala bidezko kalifikazioa erabiltzen denean, eskala bat aukera daiteke. Jarduera batean oinarritutako kalifikazio-elementu baterako eskala jarduera eguneratzeko orrian aukeratzen da.</p>';
$string['typetext'] = 'Testua';
$string['typevalue'] = 'Balorea';
$string['uncategorised'] = 'Kategorizatu gabea';
$string['unchangedgrade'] = 'Kalifikazioa ez da aldatu';
$string['unlimitedgrades'] = 'Mugarik gabeko kalifikazioak';
$string['unlock'] = 'Desblokeatu';
$string['unlockverbose'] = 'Desblokeatu {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Erabili gabea';
$string['updatedgradesonly'] = 'Kalifikazio berriak edo eguneratutakoak baino ez esportatu';
$string['uploadgrades'] = 'Kalifikazioak igo';
$string['useadvanced'] = 'Funtzio aurreratuak erabili';
$string['usedcourses'] = 'Erabilitako ikastaroak';
$string['usedgradeitem'] = 'Erabilitako kalifikazio-elementua';
$string['usenooutcome'] = 'Ez erabili helburua';
$string['usenoscale'] = 'Ez erabili eskala';
$string['usepercent'] = 'Portzentajea erabili';
$string['user'] = 'Erabiltzailea';
$string['usergrade'] = 'Erabiltzailea {$a->fullname} ({$a->useridnumber}) elementu honetan {$a->gradeidnumber}';
$string['userid'] = 'Erabiltzailearen IDa';
$string['userpreferences'] = 'Erabiltzailearen hobespenak';
$string['useweighted'] = 'Erabili ponderatua';
$string['verbosescales'] = 'Ahozko eskalak';
$string['viewbygroup'] = 'Taldea';
$string['viewgrades'] = 'Ikusi kalifikazioak';
$string['weight'] = 'Pisua';
$string['weightcourse'] = 'Ponderatu gabeko kalifikazioak erabili ikastarorako';
$string['weightedascending'] = 'Neurtutako portzentajearen arabera gorantz sailkatu';
$string['weighteddescending'] = 'Neurtutako portzentajearen arabera beherantz sailkatu';
$string['weightedpct'] = '% neurtua';
$string['weightedpctcontribution'] = 'ekarpen % neurtua';
$string['weightorextracredit'] = 'Pisua edo aparteko kreditua';
$string['weights'] = 'Pisuak';
$string['weightsedit'] = 'Editatu pisua eta aparteko kreditua';
$string['weightuc'] = 'Pisua';
$string['writinggradebookinfo'] = 'Kalifikazio-liburuaren ezarpenak idazten';
$string['xml'] = 'XML';
$string['yes'] = 'Bai';
$string['yourgrade'] = 'Zure kalifikazioa';
