<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'নতুন রোল যোগ';
$string['addrole'] = 'নতুন রোল যোগ';
$string['advancedoverride'] = 'উচ্চ পর্যায়ের রোল উপেক্ষা';
$string['allow'] = 'অনুমোদন';
$string['allowassign'] = 'রোল বরাদ্দের অনুমোদন';
$string['allowed'] = 'অনুমোদিত';
$string['allowoverride'] = 'রোল উপেক্ষা করা অনুমোদিত';
$string['allowroletoassign'] = '{$a->targetrole} রোল বরাদ্দ করার জন্য {$a->fromrole} রোল ব্যবহারকারী অনুমোদন';
$string['allowroletooverride'] = '{$a->targetrole} রোল বরাদ্দ করার জন্য {$a->fromrole} রোলসহ ব্যবহারকারী অনুমোদন';
$string['allowroletoswitch'] = '{$a->targetrole} রোল পরিবর্তন করে যাওয়ার জন্য সকল ব্যবহারকারীকে {$a->fromrole}রোলসহ অনুমোদন';
$string['allowswitch'] = 'রোল পরিবর্তন অনুমোদন';
$string['allsiteusers'] = 'সব সাইট ব্যবহারকারী';
$string['archetype'] = 'রোল আর্কটাইপ';
$string['archetypecoursecreator'] = 'ARCHETYPE: কোর্স নির্মাতা';
$string['archetypeeditingteacher'] = 'ARCHETYPE: শিক্ষক (সম্পাদনা)';
$string['archetypefrontpage'] = 'ARCHETYPE:সামনের পৃষ্ঠার প্রমানীকৃত ব্যবহারকারী';
$string['archetypeguest'] = 'ARCHETYPE: অতিথি';
$string['archetypemanager'] = 'ARCHETYPE: ব্যবস্থাপক';
$string['archetypestudent'] = 'ARCHETYPE: শিক্ষার্থী';
$string['archetypeteacher'] = 'ARCHETYPE: শিক্ষক (সম্পাদনযোগ্য নয়)';
$string['archetypeuser'] = 'ARCHETYPE: প্রমানীকৃত ব্যবহারকারী';
$string['assignanotherrole'] = 'অন্য রোল এসাইন';
$string['assignedroles'] = 'এসাইনকৃত রোল';
$string['assignerror'] = '{$a->user} ব্যবহারকারীকে {$a->role} এসাইন করার সময় ত্রুটি।';
$string['assignglobalroles'] = 'সিস্টেম রোল এসাইন';
$string['assignmentcontext'] = 'এসাইনমেন্ট কনটেক্সট';
$string['assignmentoptions'] = 'এসাইনমেন্ট অপশন';
$string['assignrole'] = 'রোল এসাইন';
$string['assignrolenameincontext'] = '{$a->context} এ \'{$a->role}\' এসাইন';
$string['assignroles'] = 'রোল এসাইন';
$string['assignroles_help'] = 'কনটেক্সট এ ব্যবহারকারীকে রোল এসাইন করে, আপনি বর্তমান কনটেক্সট এবং সব নিম্ন কনটেক্সট এর জন্য ঐ রোলে বিদ্যমান সব অনুমতি দিয়ে দিচ্ছেন। উদাহরণস্বরূপ, কোনো শিক্ষককে যদি ছাত্রের রোল এসাইন করা হয় তবে এ কোর্সের সব কার্যকলাপ ও ব্লকের জন্যও তার এই ছাত্রের রোলই থাকবে।';
$string['assignrolesin'] = '{$a} এ রোল এসাইন';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesrelativetothisuser'] = 'এ ব্যবহারকারী সম্পর্কিত রোল এসাইন';
$string['backtoallroles'] = 'সব রোলের তালিকায় ফেরত';
$string['backup:anonymise'] = 'ব্যাকআপে নামহীন ব্যবহারকারী ডাটা';
$string['backup:backupactivity'] = 'ব্যাকআপ কার্যকলাপ';
$string['backup:backupcourse'] = 'ব্যাকআপ কোর্স';
$string['backup:backupsection'] = 'ব্যাকআপ বিভাগ';
$string['backup:backuptargethub'] = 'কেন্দ্রের জন্য ব্যাকআপ';
$string['backup:backuptargetimport'] = 'ইম্পোর্ট এর ব্যাকআপ';
$string['backup:configure'] = 'ব্যাকআপ অপশন কনফিগার';
$string['backup:downloadfile'] = 'ব্যাকআপ এরিয়া থেকে ফাইল ডাউনলোড';
$string['backup:userinfo'] = 'ব্যবহারকারী ডাটা ব্যাকআপ';
$string['block:edit'] = 'ব্লক এর সেটিং সম্পাদনা';
$string['block:view'] = 'ব্লক প্রদর্শন';
$string['blog:associatecourse'] = 'কোর্সের সাথে সম্পর্কিত ব্লগ এন্ট্রি';
$string['blog:associatemodule'] = 'কার্যকালপের মডিউলের সাথে সম্পর্কিত ব্লগ এন্ট্রি';
$string['blog:create'] = 'নতুন ব্লগ এন্ট্রি তৈরি';
$string['blog:manageentries'] = 'এন্ট্রি সম্পাদনা এবং ব্যবস্থাপনা';
$string['blog:manageexternal'] = 'বাহ্যিক ব্লগ সম্পাদনা এবং ব্যবস্থাপনা';
$string['blog:manageofficialtags'] = 'অফিসিয়াল ট্যাগ ব্যবস্থাপনা';
$string['blog:managepersonaltags'] = 'ব্যক্তিগত ট্যাগ ব্যবস্থাপনা';
$string['blog:search'] = 'ব্লগ এন্ট্রি অনুসন্ধান';
$string['blog:view'] = 'ব্লগ এন্ট্রি প্রদর্শন';
$string['blog:viewdrafts'] = 'ড্রাফ্ট ব্লগ এন্ট্রি প্রদর্শন';
$string['calendar:manageentries'] = 'ক্যালেন্ডার এন্ট্রি ব্যবস্থাপনা';
$string['calendar:managegroupentries'] = 'গ্রুপ ক্যালেন্ডার এন্ট্রি ব্যবস্থাপনা';
$string['calendar:manageownentries'] = 'নিজ ক্যালেন্ডার এন্ট্রি ব্যবস্থাপনা';
$string['capabilities'] = 'কার্যক্ষমতা';
$string['capability'] = 'কার্যক্ষমতা';
$string['category:create'] = 'বিভাগ তৈরি';
$string['category:delete'] = 'বিভাগ অপসারণ';
$string['category:manage'] = 'বিভাগ ব্যবস্থাপনা';
$string['category:update'] = 'বিভাগ হালনাগাদ';
$string['category:viewhiddencategories'] = 'আড়াল করা বিভাগ দেখুন';
$string['category:visibility'] = 'আড়াল করা বিভাগ দেখুন';
$string['checkglobalpermissions'] = 'সিস্টেমের অনুমতি পরীক্ষা';
$string['checkpermissions'] = 'অনুমতি পরীক্ষা';
$string['checkpermissionsin'] = '{$a} এ অনুমতি পরীক্ষা';
$string['checksystempermissionsfor'] = '{$a->fullname} এর জন্য সিস্টেমের অনুমতি পরীক্ষা';
$string['checkuserspermissionshere'] = '{$a->contextlevel} এ {$a->fullname} এর জন্য অনুমতি পরীক্ষা';
$string['chooseroletoassign'] = 'অনুগ্রহ করে এসাইন করার জন্য রোল নির্বাচন';
$string['cohort:assign'] = 'দলের সদস্য যোগ বা অপসারণ';
$string['cohort:manage'] = 'দল তৈরি, অপসারণ এবং স্থানান্তর';
$string['cohort:view'] = 'সাইট-ওয়াইড দল প্রদর্শন';
$string['comment:delete'] = 'মন্তব্য অপসারণ';
$string['comment:post'] = 'মন্তব্য প্রদান';
$string['comment:view'] = 'মন্তব্য পড়া';
$string['community:add'] = 'হাব অনুসন্ধান করতে এবং কোর্স খুঁজতে কমিউনিটি ব্লক ব্যবহার';
$string['community:download'] = 'কমিউনিটি ব্লক থেেকে কোর্স ডাউনলোড';
$string['confirmaddadmin'] = 'আপনি কি সত্যিই নতুন সাইট প্রশাসক হিসাবে ব্যবহারকারী <strong>{$a}</strong> যোগ করতে চান?';
$string['confirmdeladmin'] = 'সাইট প্রশাসকের তালিকা থেকে ব্যবহারকারী <strong>{$a}</strong> কে অপসারণ করতে চান?';
$string['confirmroleprevent'] = 'আপনি কি সত্যিই {$a->context} এ {$a->cap} কার্যক্ষমতার জন্য <strong>{$a->role}</strong> থেকে অনুমোদিত রোলের তালিকা অপসারণ করতে চান?';
$string['confirmroleunprohibit'] = 'আপনি কি সত্যিই {$a->context} এ {$a->cap} কার্যক্ষমতার জন্য <strong>{$a->role}</strong> থেকে অননুমোদিত রোলের তালিকা অপসারণ করতে চান?';
$string['confirmunassign'] = 'আপনি কি ব্যবহারকারী হতে এ রোল অপসারণ করতে চাওয়ার ব্যাপারে নিশ্চিত?';
$string['confirmunassignno'] = 'বাতিল';
$string['confirmunassigntitle'] = 'রোল পরিবর্তন নিশ্চিত';
$string['confirmunassignyes'] = 'অপসারণ';
$string['context'] = 'কনটেক্সট';
$string['course:activityvisibility'] = 'কার্যকলাপ আড়াল/প্রদর্শন';
$string['course:bulkmessaging'] = 'বহুসংখ্যক মানুষের কাছে বার্তা প্রেরণ';
$string['course:changecategory'] = 'কোর্সের বিভাগ পরিবর্তন';
$string['course:changefullname'] = 'কোর্সের সম্পূর্ণ নাম পরিবর্তন';
$string['course:changeidnumber'] = 'কোর্সের আইডি নাম্বার পরিবর্তন';
$string['course:changeshortname'] = 'কোর্সের সংক্ষিপ্ত নাম পরিবর্তন';
$string['course:changesummary'] = 'কোর্সের সারসংক্ষেপ পরিবর্তন';
$string['course:create'] = 'কোর্স তৈরি';
$string['course:delete'] = 'কোর্স অপসারণ';
$string['course:enrolconfig'] = 'কোর্সের সন্নিবিষ্ট নমুনা কনফিগার';
$string['course:enrolreview'] = 'কোর্সের তালিকাভুক্ত বিষয় রিভিউ';
$string['course:manageactivities'] = 'কার্যকলাপ ব্যবস্থাপনা';
$string['course:managefiles'] = 'ফাইল ব্যবস্থাপনা';
$string['course:managegrades'] = 'গ্রেড ব্যবস্থাপনা';
$string['course:managegroups'] = 'গ্রুপ ব্যবস্থাপনা';
$string['course:managescales'] = 'আকার পরিবর্তন ব্যবস্থাপনা';
$string['course:markcomplete'] = 'কোর্স সমাপ্ত করার পর সমাপ্তকারী হিসাবে ব্যবহারকারীকে চিহ্নিত';
$string['course:publish'] = 'কেন্দ্রে কোর্স প্রকাশনা';
$string['course:request'] = 'নতুন কোর্সের জন্য অনুরোধ';
$string['course:reset'] = 'কোর্স পুনঃনির্ধারণ';
$string['course:sectionvisibility'] = 'বিভাগের দৃশ্যমানতা কন্ট্রোল';
$string['course:setcurrentsection'] = 'বর্তমান অংশ নির্ধারণ';
$string['course:update'] = 'কোর্সের সেটিং হালনাগাদ';
$string['course:useremail'] = 'ইমেইল ঠিকানা সক্রিয়/নিষ্ক্রিয়';
$string['course:view'] = 'অংশগ্রহন করা ছাড়াই কোর্স প্রদর্শন';
$string['course:viewcoursegrades'] = 'কোর্সের গ্রেড প্রদর্শন';
$string['course:viewhiddenactivities'] = 'আড়ালকৃত কার্যকলাপ প্রদর্শন';
$string['course:viewhiddencourses'] = 'আড়ালকৃত কোর্স প্রদর্শন';
$string['course:viewhiddensections'] = 'আড়ালকৃত বিভাগ প্রদর্শন';
$string['course:viewhiddenuserfields'] = 'ব্যবহারকারীর আড়ালকৃত ক্ষেত্র প্রদর্শন';
$string['course:viewparticipants'] = 'অংশগ্রহনকারী প্রদর্শন';
$string['course:viewscales'] = 'আকার পরিবর্তন প্রদর্শন';
$string['course:visibility'] = 'কোর্স আড়াল/প্রদর্শন';
$string['createrolebycopying'] = '{$a} অনুলিপি করে নতুন রোল তৈরি';
$string['createthisrole'] = 'এ রোল তৈরি';
$string['currentcontext'] = 'বর্তমান কনটেক্সট';
$string['currentrole'] = 'বর্তমান রোল';
$string['defaultrole'] = 'পূর্বনির্ধারিত রোল';
$string['defaultx'] = 'পূর্বনির্ধারিত: {$a}';
$string['defineroles'] = 'রোল নির্ধারণ';
$string['deletecourseoverrides'] = 'কোর্সের সব উপেক্ষা মুছে ফেলুন';
$string['deletelocalroles'] = 'সব স্থানীয় রোল এসাইনমেন্ট মুছে ফেলুন';
$string['deleterolesure'] = 'আপনি কি নিশ্চিত যে রোল "{$a->name} ({$a->shortname})" মুছে পলতে চান?</p><p> বর্তমানে এ রোল {$a->count} ব্যবহারকারীকে এসাইন করা আছে।';
$string['deletexrole'] = 'রোল {$a} মুছে ফেলুন';
$string['duplicaterole'] = 'নকল রোল';
$string['duplicaterolesure'] = 'আপনি কি নিশ্চত যে আপনি রোল "{$a->name} ({$a->shortname})" নকল করতে চান?</p>';
$string['editingrolex'] = 'রোল \'{$a}\' সম্পাদনা';
$string['editrole'] = 'রোল সম্পাদনা';
$string['editxrole'] = 'রোল {$a} সম্পাদনা';
$string['errorbadrolename'] = 'ভুল রোল নাম';
$string['errorbadroleshortname'] = 'রোলের ভুল ডাকন নাম';
$string['errorexistsrolename'] = 'রোলের নাম ইতোমধ্যে আছে';
$string['errorexistsroleshortname'] = 'রোলের নাম ইতোমধ্যে আছে';
$string['existingadmins'] = 'বর্তমান সাইট প্রসাশক';
$string['existingusers'] = '{$a} বিদ্যমান ব্যবহারকারী';
$string['explanation'] = 'ব্যাখ্যা';
$string['extusers'] = 'বিদ্যমান ব্যবহাকারী';
$string['extusersmatching'] = 'বিদ্যমান ব্যবহারকারীর মিল \'{$a}';
$string['filter:manage'] = 'স্থানীয় ফিল্টার সেটিং ব্যবস্থাপনা';
$string['frontpageuser'] = 'প্রথম পাতায় প্রমানীকৃত ব্যবহারকারী';
$string['frontpageuserdescription'] = 'কোর্সের প্রথম পাতায় সব লগ ইন করা ব্যবহাকারী।';
$string['globalrole'] = 'সিস্টেম রোল';
$string['globalroleswarning'] = 'সতর্কীকরণ! এ পৃষ্ঠা থেকে এসাইন করা যে কোনো রোল এসাইন করা ব্যবহারকারীর জন্য প্রথম পৃষ্ঠা এবং সব কোর্সসহ সম্পূর্ণ সিস্টেমে প্রয়োগ হবে।';
$string['gotoassignroles'] = '{$a->contextlevel} এর জন্য রোল এসাইন এ যান';
$string['gotoassignsystemroles'] = 'সিস্টেম রোল এসাইনে যান';
$string['grade:edit'] = 'গ্রেড সম্পাদনা';
$string['grade:export'] = 'গ্রেড এক্সপোর্ট';
$string['grade:hide'] = 'গ্রেড বা আইটেম আড়াল/আড়াল না করা';
$string['grade:import'] = 'গ্রেড ইম্পোর্ট';
$string['grade:lock'] = 'গ্রেড বা আইটেম লক';
$string['grade:manage'] = 'গ্রেড আইটেম ব্যবস্থাপনা';
$string['grade:manageletters'] = 'লেটার গ্রেড ব্যবস্থাপনা';
$string['grade:manageoutcomes'] = 'গ্রেড ফলাফল ব্যবস্থাপনা';
$string['grade:override'] = 'গ্রেড উপেক্ষা';
$string['grade:unlock'] = 'গ্রেড বা আইটেম আনলক';
$string['grade:view'] = 'নিজের গ্রেড প্রদর্শন';
$string['grade:viewall'] = 'অন্য ব্যবহারকারীর গ্রেড প্রদর্শন';
$string['grade:viewhidden'] = 'নিজের আড়ালকৃত গ্রেড প্রদর্শন';
$string['hidden'] = 'আড়ালকৃত';
$string['highlightedcellsshowdefault'] = 'এ ধরণের রোলের জন্য পূর্বনির্ধারিত অনুমোদন নিচের টেবিলে হাইলাইটকৃত সেলে প্রদর্শন, \'উপরের উত্তরাধিকারসূত্রের রোলেট ধরণ\' এর উপর ভিত্তি করে।';
$string['highlightedcellsshowinherit'] = 'নিচের টেবিলের হাইলাইটকৃত সেল যে অনুমতি (যদি থাকে) নেয়া হবে তা প্রদর্শন। এ ক্ষমতার বাহিরে  যার অনুমোদন আপনি সত্যিই পরিবর্তন করতে চান, আপনি উচিত ইনহেরিট নির্ধারণ করার জন্য অন্য সবকিছু বাদ দেয়া।';
$string['inactiveformorethan'] = '{$a->timeperiod} এর বেশি সময় ধরে নিস্ক্রিয়';
$string['ingroup'] = '"{$a->group}" গ্রুপে';
$string['inherit'] = 'ইনহেরিট';
$string['legacy:admin'] = 'LEGACY ROLE: প্রশাসক';
$string['legacy:coursecreator'] = 'LEGACY ROLE: কোর্স নির্মাতা';
$string['legacy:editingteacher'] = 'LEGACY ROLE: শিক্ষক (সম্পাদনা করা হচ্ছে)';
$string['legacy:guest'] = 'LEGACY ROLE: অতিথি';
$string['legacy:student'] = 'LEGACY ROLE: শিক্ষার্থী';
$string['legacy:teacher'] = 'LEGACY ROLE: শিক্ষক (সম্পাদনা ছাড়া)';
$string['legacytype'] = 'লিগাসি ধরণের রোল';
$string['legacy:user'] = 'LEGACY ROLE: প্রমানীকৃত ব্যবহারকারী';
$string['listallroles'] = 'সব রোলের তালিকা';
$string['localroles'] = 'স্থানীয়ভাবে এসাইনকৃত রোল';
$string['manageadmins'] = 'সাইট ব্যবস্থাপনা প্রসাশক';
$string['manager'] = 'ব্যবস্থাপক';
$string['managerdescription'] = 'ব্যবস্থাপক কোর্সে প্রবেশ করে তা পরিবর্তন করতে পারে, তারা সাধারনত কোর্সে অংশগ্রহন করে না।';
$string['manageroles'] = 'রোল ব্যবস্থাপনা';
$string['maybeassignedin'] = 'কনটেক্সটের ধরণ যেখানে এ রোল এসাইন করা যেতে পারে';
$string['morethan'] = '{$a} এর বেশি';
$string['multipleroles'] = 'বিবিধ রোল';
$string['my:configsyspages'] = 'মুডলের পৃষ্ঠার জন্য সিস্টেম টেম্পলেট কনফিগার';
$string['my:manageblocks'] = 'myMoodle পৃষ্ঠা ব্লক ব্যবস্থাপনা';
$string['neededroles'] = 'অনুমোদনসহ রোল';
$string['nocapabilitiesincontext'] = 'এ কনটেক্সেটে কোবো ক্ষমতা নেই';
$string['noneinthisx'] = '{$a} এর কোনোটিই না';
$string['noneinthisxmatching'] = '{$a->contexttype} এ কোনো ব্যবহারকারী মিলেনি \'{$a->search}';
$string['noroleassignments'] = 'এ ব্যবহারকারীর এ সাইটের কোথাও কোনো রোল এসাইনমেন্ট নাই।';
$string['noroles'] = 'কোনো রোল নয়';
$string['notabletoassignroleshere'] = 'আপনি এখানে কোনো রোল এসাইন করতে পারেন না';
$string['notabletooverrideroleshere'] = 'আপনি এখানে কোনো রোলে অনুমোদন উপেক্ষা করতে পারেন না';
$string['notes:manage'] = 'নোট ব্যবস্থাপনা';
$string['notes:view'] = 'নোট প্রদর্শন';
$string['notset'] = 'নির্ধারিত নয়';
$string['overrideanotherrole'] = 'আরেকটি রোল উপেক্ষা';
$string['overridecontext'] = 'কনটেক্সট উপেক্ষা';
$string['overridepermissions'] = 'অনুমোদন উপেক্ষা';
$string['overridepermissionsforrole'] = '{$a->context} এ রোল \'{$a->role}\' এর জন্য অনুমোদন উপেক্ষা';
$string['overridepermissions_help'] = 'অনুমোদন উপেক্ষা করা কোনো একটি সুনির্দিষ্ট কনটেক্সটে নির্বাচিত ক্ষমতা কার্যকর হবে কিনা তা সক্রিয় করে।';
$string['overridepermissionsin'] = '{$a} এ অনুমোদন উপেক্ষা';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overrideroles'] = 'রোল উপেক্ষা';
$string['overriderolesin'] = '{$a} এ রোল উপেক্ষা';
$string['overrides'] = 'উপেক্ষা';
$string['overridesbycontext'] = 'উপেক্ষা (কনটেক্সটে)';
$string['permission'] = 'অনুমতি';
$string['permission_help'] = 'অনুমোদন হল ক্ষমতার সেটিং। চারটি অপশন আছে:

* নির্ধারিত নয়
* অনুমোদন - ক্ষমতার জন্য অনুমোদিত
* প্রতিরোধ - ক্ষমতার জন্য অনুমোদন অপসারন, এমনকি উচ্চতর কনটেক্সেটে অনুমোদিত
* নিষেধ - অনুমতি সম্পূর্ণভাবে নিষিদ্ধ এবং যেকোনো নিম্নতর (আরও সুনির্দিষ্ট) কনটেক্সটে এটা উপেক্ষা করা যায় না।';
$string['permissions'] = 'অনুমোদন';
$string['permissionsforuser'] = '{$a} ব্যবহারকারীর জন্য অনুমোদন';
$string['permissionsincontext'] = '{$a} এ অনুমোদন';
$string['portfolio:export'] = 'পোর্টফলিওতে এক্সপোর্ট';
$string['potentialusers'] = '{$a} শক্তিশালী ব্যবহাকারী';
$string['potusers'] = 'শক্তিশালী ব্যবহাকারী';
$string['potusersmatching'] = 'শক্তিশালী ব্যবহাকারীর মিল \'{$a}';
$string['prevent'] = 'প্রতিরোধ';
$string['prohibit'] = 'নিষেধ';
$string['prohibitedroles'] = 'নিষিদ্ধ';
$string['question:add'] = 'নতুন প্রশ্ন যোগ';
$string['question:config'] = 'প্রশ্নের ধরণ কনফিগার';
$string['question:editall'] = 'সব প্রশ্ন সম্পাদনা';
$string['question:editmine'] = 'আপনার নিজের সব প্রশ্ন সম্পাদনা';
$string['question:flag'] = 'প্রশ্নে অংশগ্রহন করার সময় তা ফ্ল্যাগ করা হয়';
$string['question:managecategory'] = 'প্রশ্নের বিভাগ সম্পাদনা';
$string['question:moveall'] = 'সব প্রশ্ন স্থানান্তর';
$string['question:movemine'] = 'আপনার নিজের প্রশ্ন স্থানান্তর';
$string['question:useall'] = 'সব প্রশ্ন ব্যবহার';
$string['question:usemine'] = 'আপনার নিজের প্রশ্ন ব্যবহার';
$string['question:viewall'] = 'সব প্রশ্ন প্রদর্শন';
$string['question:viewmine'] = 'আপনার নিজের প্রশ্ন প্রদর্শন';
$string['rating:rate'] = 'আইটেমে রেটিং যোগ';
$string['rating:view'] = 'আপনি সর্বমোট যত রেটিং পেয়েছেন তা প্রদর্শন';
$string['rating:viewall'] = 'আলাদাভাবে প্রাপ্ত সব অসংশোধিত রেটিং প্রদর্শন';
$string['rating:viewany'] = 'যে কারও গৃহীত সর্বমোট রেটিং প্রদর্শন';
$string['resetrole'] = 'পূর্বনির্ধারিত এ পুনঃনির্ধারণ';
$string['restore:configure'] = 'পুনরুদ্ধার অপশন কনফিগার';
$string['restore:createuser'] = 'পুনরুদ্ধারে ব্যবহাকারী তৈরি';
$string['restore:restoreactivity'] = 'কার্যকলাপ পুনরুদ্ধার';
$string['restore:restorecourse'] = 'কোর্স পুনরুদ্ধার';
$string['restore:restoresection'] = 'বিভাগ পুনরুদ্ধার';
$string['restore:restoretargethub'] = 'হাব হিসাবে টার্গেট করা ফাইল পুনরুদ্ধার';
$string['restore:restoretargetimport'] = 'ইম্পোর্ট হিসাবে টার্গেট করা ফাইল পুনরুদ্ধার';
$string['restore:rolldates'] = 'পুনরুদ্ধারের সময় কার্যকলাপের কনফিগারেশনের তারিখ সাজানোর জন্য অনুমোদন';
$string['restore:uploadfile'] = 'ব্যাকআপ এরিয়ায় ফাইল আপলোড';
$string['restore:userinfo'] = 'ব্যবহারকারী ডাটা পুনরুদ্ধার';
$string['risks'] = 'ঝুঁকি';
$string['roleallowheader'] = 'রোল অনুমোদন:';
$string['roleallowinfo'] = 'কনটেক্সট {$a->context} এ অনুমোদিত রোলের তালিকায় একটি রোল যোগ করার জন্য নির্বাচন, ক্ষমতা {$a->cap}:';
$string['role:assign'] = 'ব্যবহারকারীর জন্য রোল এসাইন';
$string['roleassignments'] = 'রোল এসাইনমেন্ট';
$string['roledefinitions'] = 'রোল বর্ণনা';
$string['role:manage'] = 'রোল তৈরি এবং ব্যবস্থাপনা';
$string['role:override'] = 'অন্যের জন্য অনুমোদন উপেক্ষা';
$string['roleprohibitheader'] = 'রোল নিষেধ';
$string['roleprohibitinfo'] = 'কনটেক্সট {$a->context} এ নিষিদ্ধ রোলের তালিকায় একটি রোল যোগ করার জন্য নির্বাচন, ক্ষমতা {$a->cap}:';
$string['role:review'] = 'অন্যের জন্য অনুমোদন রিভিউ';
$string['roles'] = 'রোল';
$string['role:safeoverride'] = 'অন্যের জন্য নিরাপদ অনুমোদন উপক্ষা';
$string['roleselect'] = 'রোল নির্বাচন';
$string['roles_help'] = 'রোল হল অনুমোদনের সমষ্টি যা সিস্টেমে নির্ধারণ করে যে আপনি সুনির্দিষ্ট কনটেক্সটে সুনির্দিষ্ট ব্যবহারকারী এসাইন করতে পারবেন কিনা।';
$string['roles_link'] = 'রোল';
$string['role:switchroles'] = 'পরিবরতন করে অন্য রোলে';
$string['roletoassign'] = 'যে রোল এসাইন করা হবে';
$string['roletooverride'] = 'যে রোল উপেক্ষা করা হবে';
$string['safeoverridenotice'] = 'মনে রাখুন: উচ্চতর ঝুঁকি সম্পন্ন ক্ষমতা লক করা থাকে কারণ আপনি কেবল নিরাপদ ক্ষমতাগুলো উপেক্ষা করতে অনুমোদিত।';
$string['selectanotheruser'] = 'অন্য ব্যবহারকারী নির্বাচন';
$string['selectauser'] = 'ব্যবহারকারী নির্বাচন';
$string['selectrole'] = 'রোল নির্বাচন';
$string['showallroles'] = 'সব রোল নির্বাচন';
$string['showthisuserspermissions'] = 'এ ব্যবহারকারীর অনুমোদন প্রদর্শন';
$string['site:accessallgroups'] = 'সব গ্রুপে প্রবেশ';
$string['siteadministrators'] = 'সাইট প্রসাশক';
$string['site:approvecourse'] = 'কোর্স তৈরি অনুমোদন';
$string['site:backup'] = 'ব্যাকআপ কোর্স';
$string['site:config'] = 'সাইট কনফিগারেশন পরিবর্তন';
$string['site:doanything'] = 'যে কোনো কিছু করতে অনুমোদিত';
$string['site:doclinks'] = 'অফসাইট ডকে লিঙ্ক প্রদর্শন';
$string['site:import'] = 'অন্যান্য ব্যবহারকারীকে কোর্সে ইম্পোর্ট';
$string['site:manageblocks'] = 'পৃষ্ঠায় ব্লক ব্যবস্থাপনা';
$string['site:mnetloginfromremote'] = 'রিমোট মুডল থেকে লগইন';
$string['site:mnetlogintoremote'] = 'রিমোট মুডলে রোম';
$string['site:readallmessages'] = 'এ সাইটের সব বার্তা পড়ুন';
$string['site:restore'] = 'কোর্স পুনরুদ্ধার';
$string['site:sendmessage'] = 'যে কোনো ব্যবহারকারীকে বার্তা প্রেরণ';
$string['site:trustcontent'] = 'জমা করা কনটেন্টে বিশ্বাস';
$string['site:uploadusers'] = 'ফাইল থেকে নতুন ব্যবহারকারী আপলোড';
$string['site:viewfullnames'] = 'সবসময় ব্যবহারকারীর সম্পূর্ণ নাম দেখুন';
$string['site:viewparticipants'] = 'অলশগ্রহনকারী প্রদর্শন';
$string['site:viewreports'] = 'রিপোর্ট প্রদর্শন';
$string['tag:create'] = 'নতুন ট্যাগ তৈরি';
$string['tag:edit'] = 'বিদ্যমান ট্যাগ সম্পাদনা';
$string['tag:editblocks'] = 'ট্যাগ পৃষ্ঠায় ব্লক সম্পাদনা';
$string['tag:manage'] = 'সব ট্যাগ ব্যবস্থাপনা';
$string['thisusersroles'] = 'এ ব্যবহারকারীর রোল এসাইনমেন্ট';
$string['unassignarole'] = 'রোল {$a} আনএসাইন';
$string['unassignconfirm'] = 'আপনি কি সত্যিই "{$a->user}" ব্যবহারকারী থেকে "{$a->role}" আনএসাইন করতে চান?';
$string['unassignerror'] = '"{$a->user}" ব্যবহারকারী থেকে "{$a->role}" আনএসাইন করার সময় ত্রুটি।';
$string['user:changeownpassword'] = 'নিজের পাসওয়ার্ড পরিবর্তন';
$string['user:create'] = 'ব্যবহারকারী তৈরি';
$string['user:delete'] = 'ব্যবহারকারী অপসারণ';
$string['user:editmessageprofile'] = 'ব্যবহারকারীর বার্তা প্রোফাইল সম্পাদনা';
$string['user:editownmessageprofile'] = 'ব্যবহারকারীর নিজের বার্তা প্রোফাইল সম্পাদনা';
$string['user:editownprofile'] = 'ব্যবহারকারীর নিজের প্রোফাইল সম্পাদনা';
$string['user:editprofile'] = 'ব্যবহারকারীর প্রোফাইল সম্পাদনা';
$string['user:loginas'] = 'অন্যান্য ব্যবহাকরী হিসাবে লগইন';
$string['user:manageblocks'] = 'অন্যান্য ব্যবহারকারীর প্রোফাইলে ব্লক ব্যবস্থাপনা';
$string['user:manageownblocks'] = 'নিজের পাবলিক ব্যবহারকারী প্রোফাইলে ব্লক ব্যবস্থাপনা';
$string['user:manageownfiles'] = 'নিজের একান্ত ফাইল এরিয়ায় ফাইল ব্যবস্থাপনা';
$string['user:managesyspages'] = 'পাবলিক ব্যবহারকারী প্রোফাইলে পৃষ্ঠার পূর্বনির্ধারিত বহির্বিন্যাস কনফিগার';
$string['user:readuserblogs'] = 'সব ব্যবহারকারীর ব্লগ দেখুন';
$string['user:readuserposts'] = 'সব ব্যবহারকারীর পোস্ট দেখুন';
$string['usersfrom'] = '{$a} এর ব্যবহারকারী';
$string['usersfrommatching'] = '\'{$a->search}\' এর সাথে মিলযুক্ত {$a->contextname} এর ব্যবহারকারী';
$string['usersinthisx'] = '{$a} এ ব্যবহারকারী';
$string['usersinthisxmatching'] = '\'{$a->search}\' এর সাথে মিলযুক্ত {$a->contexttype} এর ব্যবহারকারী';
$string['userswithrole'] = 'রোলসহ সব ব্যবহারকারী';
$string['userswiththisrole'] = 'রোলসহ ব্যবহারকারী';
$string['user:update'] = 'ব্যবহারকারী প্রোফাইল হালনাগাদ';
$string['user:viewalldetails'] = 'ব্যবহারকারীর সম্পূর্ণ তথ্য প্রদর্শন';
$string['user:viewdetails'] = 'ব্যবহারকারীর প্রোফাইল প্রদর্শন';
$string['user:viewhiddendetails'] = 'ব্যবহারকারীর আড়ালকৃত বিস্তারিত তথ্য প্রদর্শন';
$string['user:viewuseractivitiesreport'] = 'ব্যবহারকারীর কার্যকলাপের রিপোর্ট দেখুন';
$string['user:viewusergrades'] = 'ব্যবহারকারীর গ্রেড প্রদর্শন';
$string['useshowadvancedtochange'] = 'পরিবর্তন করার জন্য \'উচ্চ পর্যায়ের প্রদর্শন\' ব্যবহার';
$string['viewingdefinitionofrolex'] = 'রোল \'{$a}\' এর অর্থ প্রদর্শন';
$string['viewrole'] = 'রোলের বিস্তারিত তথ্য প্রদর্শন';
$string['webservice:createtoken'] = 'ওয়েব সার্ভিস টোকেন তৈরি';
$string['whydoesuserhavecap'] = 'কনটেক্সট {$a->context} এ ক্ষমতা {$a->capability} এর কেন {$a->fullname} আছে?';
$string['whydoesusernothavecap'] = 'কনটেক্সট {$a->context} এ ক্ষমতা {$a->capability} এর কেন {$a->fullname} নেই?';
$string['xroleassignments'] = '{$a}\' এর রোল এসাইনমেন্ট';
$string['xuserswiththerole'] = 'রোল "{$a->role}" সহ ব্যবহারকারী';
