<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'আপনি এ কুইজের প্রাকদর্শন করতে পারেন, কিন্তু  এটা যদি একটি প্রকৃত প্রচেষ্টা হয় তবে আপনাকে ব্লক করা হতে পারে কারণ:';
$string['action'] = 'করণীয়';
$string['adaptive'] = 'অ্যাডাপটিভ মোড';
$string['adaptive_help'] = 'যদি সক্রিয় করা থাকে তবে কুইজে একই চেষ্টায় একাধিক উত্তর দেয়া অনুমোদিত রয়েছে। সুতরাং, উদাহরণস্বরূপ যদি কোনো উত্তর ভুল হয় তবে, শিক্ষার্থীরা সাথে সাথেই পুনরায় চেষ্টা করতে পারবে। উপরন্তু, "প্যানাল্টি প্রয়োগ" সেটিং এর উপর নির্ভর করে প্রত্যেক ভুল উত্তরের জন্য প্যানাল্টি হিসাবে কিছু নম্বর কাঁটা হবে।';
$string['addaquestion'] = 'প্রশ্ন যোগ ...';
$string['addarandomquestion'] = 'এলোমেলো প্রশ্ন যোগ ...';
$string['addarandomquestion_help'] = 'যখন এলোমেলো প্রশ্ন যোগ করা হয়, সেটা কুইজে সন্নিবিষ্ট বিভাগ থেকে এলোমেলো নির্বাচিত প্রশ্ন হয়ে যায়। এ থেকে বুঝা যায়, প্রশ্ন নির্বাচনের ক্ষেত্রে বিিভন্ন শিক্ষার্থী বিভিন্ন প্রশ্ন নির্বাচন করে এবং কুইজে যখন বহুনির্বাচনী চেষ্টা করা যায় তখন প্রতিটি প্রশ্ন নির্বাচনের ক্ষেত্রে নতুনত্ব থাকে।';
$string['adddescriptionlabel'] = 'বর্ণনা/লেবেল যোগ';
$string['addingquestion'] = 'প্রশ্ন যোগ';
$string['addingquestions'] = 'পৃষ্ঠার এই পাশে আপনি প্রশ্নের ডাটাবেস ব্যবস্থাপনা করেন। আপনি যাতে সুন্দর করে সাজাতে পারেন তার জন্য প্রশ্নগুলোকে বিভিন্ন বিভাগে সাজানো হয় এবং কোর্সের যেকোনো কুইজে ব্যবহার করতে পারেন এবং এমনকি যদি প্রকাশ করর জন্য নির্বাচিত হয় তবে অন্যান্য কোর্সেও ব্যবহার করা যেতে পারে। <br /><br /> আপনি যখন প্রশ্নের বিভাগ নির্বাচন বা তৈরি করবেন তখন আপনি প্রশ্ন তৈরি বা সম্পাদনা করতে পারবেন। আপনি পৃষ্ঠার পাশে যেকোনো একটি প্রশ্ন নির্বাচন করে কুইজে যোগ করতে পারেন।';
$string['addmoreoverallfeedbacks'] = '{no} আরও মন্তব্যের ক্ষেত্র যোগ';
$string['addnewgroupoverride'] = 'গ্রুপ উপেক্ষা করা যোগ';
$string['addnewpagesafterselected'] = 'নির্বাচিত প্রশ্নের পরে নতুন পৃষ্ঠা যোগ';
$string['addnewquestionsqbank'] = 'বিভাগ {$a->catname}: {$a->link} এ প্রশ্ন যোগ';
$string['addnewuseroverride'] = 'ব্যবহারকারী উপেক্ষা করা যোগ';
$string['addpagehere'] = 'এখানে পৃষ্ঠা যোগ';
$string['addquestion'] = 'প্রশ্ন যোগ';
$string['addquestions'] = 'প্রশ্ন যোগ';
$string['addquestionstoquiz'] = 'বর্তমান কুইজে প্রশ্ন যোগ';
$string['addrandom'] = '{$a} এলোমেলো প্রশ্ন যোগ';
$string['addrandom1'] = '<< যোগ';
$string['addrandom2'] = 'এলোমেলো প্রশ্ন';
$string['addrandomfromcategory'] = 'বিভাগ থেকে এলোমেলো প্রশ্ন যোগ:';
$string['addrandomquestion'] = 'এলোমেলো প্রশ্ন যোগ';
$string['addrandomquestiontoquiz'] = 'কুইজে {$a} এলোমেলো প্রশ্ন যোগ';
$string['addselectedtoquiz'] = 'কুইজে নির্বাচিতগুলো যোগ';
$string['addtoquiz'] = 'কুইজে যোগ';
$string['affectedstudents'] = 'প্রভাবিত {$a}';
$string['aftereachquestion'] = 'প্রত্যেক প্রশ্ন যোগ করার পর';
$string['afternquestions'] = '{$a} প্রশ্ন যোগ করার পর';
$string['age'] = 'বয়স';
$string['allattempts'] = 'সকল প্রচেষ্টা';
$string['allinone'] = 'অসীম';
$string['allowreview'] = 'রিভিউ অনুমোদন';
$string['alreadysubmitted'] = 'আপনি ইতোমধ্যে প্রচেষ্টা করছেন বলো মনে হচ্ছে';
$string['alternativeunits'] = 'বিকল্প একক';
$string['alwaysavailable'] = 'সর্বদা বিদ্যমান';
$string['analysisoptions'] = 'বিশ্লেষণ অপশন';
$string['analysistitle'] = 'আইটেম বিশ্লেষণ সারণি';
$string['answer'] = 'উত্তর';
$string['answered'] = 'উত্তর দেয়া হয়েছে';
$string['answerhowmany'] = 'এক বা একাধিক উত্তর?';
$string['answers'] = 'উত্তর';
$string['answersingleno'] = 'বিবিধ উত্তর অনুমোদিত';
$string['answersingleyes'] = 'কেবলমাত্র একটি উত্তর';
$string['answertoolong'] = 'লাইন {$a} (২৫৫ char. max) এর পরে বেশি লম্বা উত্তর';
$string['aon'] = 'AON বিন্যাস';
$string['areyousureremoveselected'] = 'আপনি নিশ্চিত যে আপনি সকল নির্বাচিত প্রশ্ন অপসারন করতে চান?';
$string['asshownoneditscreen'] = 'সম্পাদনা পর্দায় যেভাবে প্রদর্শিত';
$string['attempt'] = 'প্রচেষ্টা {$a}';
$string['attemptalreadyclosed'] = 'এ প্রচেষ্টা ইতোমধ্যে শেষ।';
$string['attemptclosed'] = 'প্রচেষ্টা এখনও বন্ধ হয়নি';
$string['attemptduration'] = 'গৃহীত সময়';
$string['attemptedon'] = 'প্রচেষ্টা';
$string['attempterror'] = 'আপনার এখন এসময় এই প্রচেষ্টা নেয়া অনুমোদিত নয়, কারণ: {$a}';
$string['attemptfirst'] = 'প্রথম প্রচেষ্টা';
$string['attemptincomplete'] = 'ঐ প্রচেষ্টা  ({$a}দ্বারা) এখনও সম্পন্ন হয়নি';
$string['attemptlast'] = 'সর্বশেষ প্রচেষ্টা';
$string['attemptnumber'] = 'প্রচেষ্টা';
$string['attemptquiznow'] = 'এখন কুইজে অংশ নিন';
$string['attempts'] = 'প্রচেষ্টা';
$string['attemptsallowed'] = 'অনুমোদিত প্রচেষ্টা';
$string['attemptsdeleted'] = 'যতবার কুইজ নেয়া হয়েছিল তা অপসারন';
$string['attemptselection'] = 'কোন প্রচেষ্টাগুলো বিশ্লেষন করা হবে তা নির্বাচন:';
$string['attemptsexist'] = 'আপনি আর কোনো প্রশ্ন যোগ বা অপসারন করতে পারবেন না।';
$string['attemptsnum'] = 'প্রচেষ্টা: {$a}';
$string['attemptsnumthisgroup'] = 'প্রচেষ্টা: {$a->সর্বমোট} ({$a->গ্রুপ}গ্রুপ হতে )';
$string['attemptsnumyourgroups'] = 'প্রচেষ্টা: {$a->সর্বমোট} ({$a->গ্রুপ} আপনার গ্রুপ হতে)';
$string['attemptsonly'] = 'কেবলমাত্র যারা অংশগ্রহন করেছে তাদেরকে প্রদর্শন';
$string['attemptsunlimited'] = 'অসীম প্রচেষ্টা';
$string['back'] = 'প্রশ্নের প্রাকদর্শনে ফেরত';
$string['backtoquestionlist'] = 'প্রশ্নের তালিকায় ফেরত';
$string['backtoquiz'] = 'কুইজ সম্পাদনায় ফেরত';
$string['basicideasofquiz'] = 'কুইজ- তৈরির মূল ধারণা';
$string['bestgrade'] = 'সর্বোচ্চ গ্রেড';
$string['bothattempts'] = 'অংশ করেছে এবং করেনি এমন সকল শিক্ষার্থীকে প্রদর্শন';
$string['browsersecurity'] = 'ব্রাউজার নিরাপত্তা';
$string['browsersecurity_help'] = 'যদি "JavaScript সম্পর্কিত নিরাপত্তাসহ পর্দাজুড়ে প্রদর্শন পপআপ" নির্বাচিত হয়,

* তবে শিক্ষার্থীদের কুইজ তখনই শুরু হবে যখন তাদের কাছে JavaScript- স্বক্রিয় ওয়েব-ব্রাউজার থাকবে
* কুইজ পর্দাজুড়ে প্রদর্শনীয় পপআপ উইন্ডোতে আসে যা অন্যান্য উইন্ডোকে ঢেকে ফেলে এবং কোনো ন্যাভিগেশন কন্ট্রোল থাকে না
* অনুলিপি করা এবং প্রতিলেপন করার সুবিধা নেয়া থেকে যতদূর সম্ভব শিক্ষার্থীদের প্রতিরোধ করা হয়েছে।';
$string['calculated'] = 'গণনাকৃত';
$string['calculatedquestion'] = '{$a} লাইনে গণনাকৃত প্রশ্ন সমর্থন করে না। প্রশ্নগুলো উপেক্ষা করা হবে।';
$string['cannotcreatepath'] = 'পাথ তৈরি করা যায়নি ({$a})';
$string['cannoteditafterattempts'] = 'যেহেতু এ কুইজ একবার নেয়া হয়ে গিয়েছে সুতরাং আপনি প্রশ্নগুলো আর যোগ বা অপসারণ করতে পারবেন না।  ({$a})';
$string['cannotfindprevattempt'] = 'পূর্ববর্তী প্রচেষ্টা বিল্ড অন করার জন্য খুঁজে পাওয়া যায়নি।';
$string['cannotfindquestionregard'] = 'প্রশ্নে পুনরায় গ্রেড দিতে ব্যর্থ!';
$string['cannotinsert'] = 'প্রশ্ন সন্নিবেশ করতে পারেনা';
$string['cannotinsertrandomquestion'] = 'নতুন এলোমেলো প্রশ্ন সন্নিবেশ করতে পারেনা!';
$string['cannotloadquestion'] = 'প্রশ্ন অপশন লোড করতে ব্যর্থ';
$string['cannotloadtypeinfo'] = 'প্রশ্নধরণের জন্য নির্ধারিত প্রশ্নের তথ্য লোড করা যাচ্ছেনা';
$string['cannotopen'] = 'এক্সপোর্ট ফাইল খুলতে পারেনা ({$a})';
$string['cannotrestore'] = 'প্রশ্নের সেশন পুনরুদ্ধার করতে পারেনা';
$string['cannotreviewopen'] = 'আপনি এ প্রচেষ্টা রিভিউ করতে পারবেন না, এটা এখনও খোলা।';
$string['cannotsavelayout'] = 'বহির্বিন্যাস সংরক্ষণ করতে পারেনা';
$string['cannotsavenumberofquestion'] = 'প্রতি পৃষ্ঠায় প্রশ্নের সংখ্যা সংরক্ষণ করতে পারে না';
$string['cannotsavequestion'] = 'প্রশ্নের তালিকা সংরক্ষণ করতে পারেনা';
$string['cannotsetgrade'] = 'কুইজের জন্য নতুন সর্বোচ্চ গ্রেড নির্ধারণ করতে পারেনা';
$string['cannotsetsumgrades'] = 'সামগ্রেড নির্ধারণ করতে ব্যর্থ';
$string['cannotwrite'] = 'এক্সপোর্ট ফাইলে লিখতে পারেনা ({$a})';
$string['caseno'] = 'না, ঘটনাটি গুরুত্বপূর্ন নয়';
$string['casesensitive'] = 'ঘটনার সংবেদনশীলতা';
$string['caseyes'] = 'হ্যাঁ, ঘটনাটি মিলতে হবে';
$string['categories'] = 'বিভাগ';
$string['category'] = 'বিভাগ';
$string['categoryadded'] = 'বিভাগ';
$string['categorydeleted'] = 'বিভাগটি \'{$a}\' অপসারন করা হয়েছে';
$string['categorynoedit'] = 'এ বিভাগে \'{$a}\' আপনার সম্পাদনা করার বিশেষাধিকার নাই।';
$string['categoryupdated'] = 'বিভাগ সফলভাবে গ্রহন করা হয়েছে';
$string['close'] = 'উইন্ডো নির্বাচন';
$string['closebeforeopen'] = 'কুইজ হালনাগাদ করতে পারেনি। আপনি খোলা তারিখের পূর্বেই একটি বন্ধ করার তারিখ নির্ধারণ করে দিয়েছেন।';
$string['closed'] = 'বন্ধ';
$string['closepreview'] = 'প্রাকদর্শন বন্ধ';
$string['closereview'] = 'বিভিউ বন্ধ';
$string['comment'] = 'মন্তব্য';
$string['commentorgrade'] = 'গ্রেড উপেক্ষা অথবা মন্তব্য করা';
$string['comments'] = 'মন্তব্য';
$string['completedon'] = 'সম্পন্ন';
$string['configadaptive'] = 'আপনি যদি এ অপশনের জন্য হ্যাঁ নির্বাচন করেন তবে কুইজে শিক্ষার্থীরা একটি প্রশ্নের উত্তরে একই চেষ্টায় বিবিধ উত্তর দেয়ার অনুমতি পাবে।';
$string['configattemptsallowed'] = 'কুইজে কতবার চেষ্টা করা যাবে তার সংখ্যার উপর বাধা আরোপ।';
$string['configdecimaldigits'] = 'গ্রেড প্রদর্শনের সময় দশমিকের পর কত ঘর প্রদর্শিত হবে তার সংখ্যা।';
$string['configdecimalplaces'] = 'কুইজের গ্রেড প্রদর্শনের সময় দশমিকের পর কত ঘর প্রদর্শিত হবে তার সংখ্যা।';
$string['configdecimalplacesquestion'] = 'প্রত্যেক স্বতন্ত্র প্রশ্নের জন্য গ্রেড প্রদর্শনের সময় দশমিকের পর কত ঘর প্রদর্শিত হবে তার সংখ্যা।';
$string['configdelay1'] = 'আপনি যদি সময়ের বিলম্ব নির্ধারণ করে থাকেন তবে, শিক্ষার্থীরা একবার চেষ্টা করার পর পরেরবার চেষ্টা করতে হলে একটু সময় অপেক্ষা করতে হবে।';
$string['configdelay1st2nd'] = 'আপনি যদি সময়ের বিলম্ব নির্ধারণ করে থাকেন তবে, শিক্ষার্থীরা একবার চেষ্টা করার পর এই সময়টা পার হওয়া না পর্যন্ত পরেরবার চেষ্টা করতে পারবে না।';
$string['configdelay2'] = 'আপনি যদি সময়ের বিলম্ব নির্ধারণ করে থাকেন তবে, শিক্ষার্থীরা তৃতীয়বার বা পরের আর যতবার চেষ্টা করবে তার জন্য কিছু সময় অপেক্ষা করতে হবে।';
$string['configdelaylater'] = 'আপনি যদি সময়ের বিলম্ব নির্ধারণ করে থাকেন তবে, শিক্ষার্থীরা তৃতীয়বার, চতুর্থবার বা পরের বার চেষ্টা করতে পারবে না যতক্ষন না পর্যন্ত শেষবার চেষ্টা করার পর ঐ নির্দিষ্ট কিছু সময় অতিবাহিত হয়।';
$string['configeachattemptbuildsonthelast'] = 'যদি একাধিক চেষ্টা অনুমোদিত হয় তবে প্রতিটি নতুন চেষ্টা পূর্ববর্তী চেষ্টার ফলস্বরূপ হবে।';
$string['configgrademethod'] = 'যখন একাধিক চেষ্টা অনুমোদিত হয়, তখন শিক্ষার্থীদের  কুইজের ফাইনাল গ্রেডের জন্য কোন প্রক্রিয়া অবলম্বন করা হবে।';
$string['configintro'] = 'এখানকার মানগুলো কুইজ তৈরি করার সময় সেটিং এর ফর্মে ব্যবহার করার পূর্বনির্ধারিত মান বুঝায়। কুইজ সেটিং এ অগ্রিম যা আছে তাও আপনি কনফিগার করে নিতে পারেন।';
$string['configmaximumgrade'] = 'কুইজ গ্রেড কত থেকে কত এর মধ্যে হবে তা পূর্বনির্ধারিত গ্রেড।';
$string['confignewpageevery'] = 'আপনি যে সেটিং নির্বাচন করেছেন তার জন্য কুইজে প্রশ্ন যোগ করার সময় স্বয়ংক্রিয়ভাবে পৃষ্ঠা ব্রেক সন্নিবিষ্ট হয়ে যাবে।';
$string['configpenaltyscheme'] = 'অ্যাডাপটিভ মোডে প্রত্যেক ভুল উত্তরের জন্য প্যানাল্টি হিসাবে মান কাঁটা যাবে।';
$string['configpopup'] = 'পপআপ উইন্ডোতে চেষ্টাটি খোলার জন্য জোর দিন এবং কুইজে অংশগ্রহন করার সময় অনুলিপি ও প্রতিলিপি ইত্যাদি সীমিত করার জন্য  JavaScript কৌশল ব্যবহার।';
$string['configrequirepassword'] = 'কুইজে অংশ গ্রহন করার পূর্বে শিক্ষার্থীদেরকে অবশ্যই পাসওয়ার্ড দিতে হবে।';
$string['configrequiresubnet'] = 'শিক্ষার্থীরা কেবল এসব কম্পিউটার থেকে কুইজে অংশগ্রহন করতে পারবে।';
$string['configreviewoptions'] = 'একজন ব্যবহারকারী কুইজ রিভিউ বা কুইজ রিপোর্ট দেখার সময় কি কি তথ্য দেখতে পাবে তা এই অপশন নিয়ন্ত্রন করে।';
$string['configshowblocks'] = 'কুইজে অংশগ্রহন করার সময় ব্লক প্রদর্শন।';
$string['configshowuserpicture'] = 'কুইজে অংশগ্রহন করার সময় ব্যবহারকারীর ছবি পর্দায় প্রদর্শন।';
$string['configshufflequestions'] = 'আপনি যদি এ অপশন সক্রিয় করেন তবে, কোনো শিক্ষার্থী যখন কুইজে অংশগ্রহন করবে তখন প্রত্যেকবার প্রত্যেকবার প্রশ্নের ক্রম এলোমেলোভাবে সজ্জিত হবে।';
$string['configshufflewithin'] = 'এ অপশন সক্রিয় করা হলে, কোনো ছাত্র প্রত্যেকবার কুইজে অংশগ্রহন করার সময় যে যে অংশ নিয়ে প্রশ্ন তৈরি করা হয় সবগুলো এলোমেলোভাবে সাজানো হবে, এ অপশনটি প্রশ্নের সেটিং এর সাথেও সক্রিয় করা আছে।';
$string['configtimelimit'] = 'কুইজের জন্য মিনিটে পূর্বনির্ধারিত সময় সীমা। 0 মানে কোন সময় সীমা নেই।';
$string['configtimelimitsec'] = 'কুইজের জন্য  সেকেন্ডে পূর্বনির্ধারিত সময় সীমা। 0 মানে কোন সময় সীমা নেই।';
$string['configurerandomquestion'] = 'প্রশ্ন কনফিগার';
$string['confirmclose'] = 'আপনি এই প্রচেষ্টাটি বন্ধ করতে যাচ্ছেন। একবার এই প্রচেষ্টাটি বন্ধ করলে আপনি আর উত্তরটি পরিবর্তন করতে পারবেন না।';
$string['confirmserverdelete'] = 'আপনি কি তালিকা থেকে <b> {$a}</b> সার্ভার অপসারণ করার ব্যাপারে নিশ্চিত?';
$string['confirmstartattemptlimit'] = 'অনুমোদিত প্রচেষ্টার সংখ্যা:  {$a}। আপনি একটি নতুন প্রচেষ্টা শুরু করতে যাচ্ছেন। আপনি কি অগ্রসর হতে ইচ্ছুক?';
$string['confirmstartattempttimelimit'] = 'এই কুইজটির সময়সীমা আছে এবং {$a} সংখ্যকবার অংশগ্রহণ করা যাবে। আপনি একটি নতুন প্রচেষ্টা শুরু করতে যাচ্ছেন। আপনি কি অগ্রসর হতে ইচ্ছুক?';
$string['confirmstarttimelimit'] = 'এই কুইজটির সময়সীমা আছে। আপনি কি শুরু করার ব্যাপারে নিশ্চিত?';
$string['containercategorycreated'] = 'যে সকল মূল বিভাগ সাইট সংস্করনে সরে গিয়েছে তা সংরক্ষণের জন্য এই বিভাগটি তৈরি করা হয়েছে এবং সরে যাওয়ার কারনটি নিচে উল্লেখ করা হয়েছে।';
$string['continueattemptquiz'] = 'শেষ চেষ্টা চালিয়ে যান';
$string['continuepreview'] = 'শেষ প্রাকদর্শন চালিয়ে যান';
$string['copyingfrom'] = '\'{$a}\' প্রশ্নের অনুলিপি তৈরি';
$string['copyingquestion'] = 'প্রশ্নের অনুলিপি করা হচ্ছে';
$string['correct'] = 'সঠিক';
$string['correctanswer'] = 'সঠিক উত্তর';
$string['correctanswerformula'] = 'সঠিক উত্তরের সূত্র';
$string['correctansweris'] = 'সঠিক উত্তর: {$a}';
$string['correctanswerlength'] = 'নির্দিস্ট আকার';
$string['correctanswers'] = 'সঠিক উত্তর';
$string['correctanswershows'] = 'সঠিক উত্তর প্রদর্শন';
$string['corrresp'] = 'সঠিক জবাব';
$string['countdown'] = 'কাউন্টডাউন';
$string['countdownfinished'] = 'কুইজের সময় শেষ হয়ে যাচ্ছে, আপনার উচিৎ এখন  উত্তর জমা দেয়া।';
$string['countdowntenminutes'] = 'আর দশ মিনিটের মধ্যে কুইজের সময় শেষ হয়ে যাবে।';
$string['coursetestmanager'] = 'কোর্স পরীক্ষা ব্যবস্থাপক বিন্যাস';
$string['createfirst'] = 'আপনাকে প্রথমে কিছু ছোট প্রশ্নোত্তর তৈরি করতে হবে।';
$string['createmultiple'] = 'কুইজে কিছু এলোমেলো প্রশ্ন যোগ';
$string['createnewquestion'] = 'নতুন প্রশ্ন তৈরি';
$string['createquestionandadd'] = 'নতুন প্রশ্ন তৈরি করে তা কুইজে যোগ।';
$string['custom'] = 'স্বনির্ধারিত বিন্যাস';
$string['dataitemneed'] = 'একটি কার্যকর প্রশ্ন পেতে হলে আপনাকে অন্তত এক সেট ডাটা আইটেম যোগ করতে হবে';
$string['datasetdefinitions'] = 'বিভাগ {$a} এর জন্য পুনরায় ব্যবহারযোগ্য ডাটাসেটের বর্ণনা';
$string['datasetnumber'] = 'সংখ্যা';
$string['daysavailable'] = 'বিদ্যমান দিনের সংখ্যা';
$string['decimaldigits'] = 'গ্রেডে দশমিকযুক্ত সংখ্যা';
$string['decimalplaces'] = 'গ্রেডে দশমিকের স্থান';
$string['decimalplacesquestion'] = 'প্রশ্নের গ্রেডে দশমিকের স্থান';
$string['decimalplacesquestion_help'] = 'প্রত্যেক প্রশ্নের জন্য যখন স্বতন্ত্রভাবে গ্রেড প্রদর্শিত হয় তখন এ সেটিং এর সাহায্যে দশমিকের পর কত অংক থাকবে তা নির্ধারিত হয়।';
$string['decimalpoints'] = 'দশমিক বিন্দু';
$string['default'] = 'পূর্বনির্ধারিত (if adj)';
$string['defaultgrade'] = 'পূর্বনির্ধারিত প্রশ্নের গ্রেড';
$string['defaultinfo'] = 'প্রশ্নের জন্য পূর্বনির্ধারিত বিভাগ';
$string['delay1'] = 'প্রথম ও দ্বিতীয় চেষ্টার মধ্যবর্তী সময়ের বিলম্ব';
$string['delay1st2nd'] = 'প্রথম ও দ্বিতীয় চেষ্টার মধ্যবর্তী সময়ের জোরপূর্বক বিলম্ব';
$string['delay1st2nd_help'] = 'যদি সক্রিয় করা হয় তবে, শিক্ষার্থীকে দ্বিতীয়বার কুইজে অংশ গ্রহন করতে পারার পূর্বে একটি নির্দিষ্ট সময় পর্যন্ত অপেক্ষা করতে হবে।';
$string['delay2'] = 'পরবর্তী অংশগ্রহনের সময়ের মধ্যে মধ্যবর্তী সময়ের বিলম্ব';
$string['delaylater'] = 'পরবর্তী অংশগ্রহনের সময়ের মধ্যে জোরপূর্বক করা মধ্যবর্তী সময়ের বিলম্ব';
$string['delaylater_help'] = 'যদি সক্রিয় থাকে, শিক্ষার্থীকে অবশ্যই উল্লেখিত সময় অতিক্রান্ত হওয়া পর্যন্ত তৃতীয় এবং পরবর্তী কুইজে অংশগ্রহণের জন্য অপেক্ষা করতে হবে।';
$string['deleteattemptcheck'] = 'আপনি কি এই প্রচেষ্টাটি সম্পূর্নরূপে অপসারন করে দেওয়ার ব্যাপারে নিশ্চিত?';
$string['deleteselected'] = 'অপসারণ করা নির্বাচিত';
$string['deletingquestionattempts'] = 'যেসকল প্রশ্ন চেষ্টা করা হয়েছে সেগুলো অপসারন';
$string['description'] = 'বর্ণনা';
$string['disabled'] = 'নিস্ক্রিয়';
$string['displayoptions'] = 'অপশন প্রদর্শন';
$string['download'] = 'এক্সপোর্টকৃত বিভাগীয় ফাইল ডাউনলোড করতে ক্লিক';
$string['downloadextra'] = '(/backupdata/quiz folder এ কোর্স ফাইলে ফাইল জমা করা থাকে)';
$string['duplicateresponse'] = 'আপনার জমাকৃত উত্তর উপেক্ষা করা হয়েছে কারন আপনি একই ধরণের উত্তর আগেও দিয়েছেন।';
$string['eachattemptbuildsonthelast'] = 'প্রত্যেকটি প্রচেষ্টা শেষে তৈরি হবে';
$string['eachattemptbuildsonthelast_help'] = 'একাধিকবার অংশগ্রহণের অনুমোদন এবং এই সেটিংটি যদি সক্রিয় থাকে, প্রত্যেকটি নতুন কুইজের অংশগ্রহণ পূর্ববর্তী অংশগ্রহণের ফলাফল ধারন করে। এটি অনুমোদন করে কয়েকটি অংশগ্রহনের পর একটি কুইজ সম্পূর্ন হবে।';
$string['editcategories'] = 'বিভাগ সম্পাদনা';
$string['editcategory'] = 'বিভাগ সম্পাদনা';
$string['editcatquestions'] = 'বিভাগীয় প্রশ্ন সম্পাদনা';
$string['editingquestion'] = 'প্রশ্ন সম্পাদনা';
$string['editingquiz'] = 'কুইজ সম্পাদনা';
$string['editingquiz_help'] = 'কোনো কুইজ তৈরি করার সময় মূল ব্যাপার হল:

* প্রশ্ন, যেসব এক বা একাধিক পৃষ্ঠায় হয়
* প্রশ্ন ব্যাংক, যেখানে বিভিন্ন বিভাগে প্রশ্নের সব অনুলিপি সজ্জিত থাকে
* এলোমেলো প্রশ্ন - প্রত্যেকবার অংশগ্রহনের সময় ছাত্র নতুন প্রশ্ন পায় এবং বিভিন্ন ছাত্র বিভিন্ন প্রশ্ন পেতে পারে';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editoverride'] = 'অগ্রাহ্য করা সম্পাদনা';
$string['editqcats'] = 'প্রশ্নের বিভাগ সম্পাদনা';
$string['editquestions'] = 'প্রশ্ন সম্পাদনা';
$string['editquiz'] = 'কুইজ সম্পাদনা';
$string['editquizquestions'] = 'কুইজ প্রশ্ন সম্পাদনা';
$string['emailconfirmbody'] = 'প্রিয় {$a->ব্যবহারকারির নাম},

 আপনাকে ধন্যবাদ
 {$a->জমা দেওয়ার সময়}এ
কোর্সে \'{$a->কোর্সের নাম}\'
\'{$a->কুইজের নাম}\'  উত্তর জমা দেওয়ার জন্য।

এই মেইলটি অনুমোদন করে যে আপনার উত্তর গ্রহণ করা হয়েছে।

{$a->quizurl} কুইজে অংশগ্রহন করতে পারবেন।';
$string['empty'] = 'ফাঁকা';
$string['enabled'] = 'সক্রিয়';
$string['endtest'] = 'সমাপ্তি পরীক্ষা ...';
$string['erroraccessingreport'] = 'আপনি এ রিপোর্ট পড়তে পারবেন না';
$string['errorinquestion'] = 'প্রশ্নে ত্রুটি';
$string['errormissingquestion'] = 'ত্রুটি: সিস্টেমে আইডি {$a} এর প্রশ্ন অনুপস্থিত';
$string['errornotnumbers'] = 'ত্রুটি - উত্তর অবশ্যই সংখ্যাসূচক হতে হবে';
$string['errorunexpectedevent'] = '{$a->attemptid}চেষ্টার {$a->questionid} প্রশ্নে অপ্রত্যাশিত ইভেন্ট কোড {$a->event}।';
$string['essay'] = 'রচনামূলক';
$string['essayquestions'] = 'প্রশ্ন';
$string['everynquestions'] = 'প্রত্যেক {$a} প্রশ্ন';
$string['everyquestion'] = 'প্রত্যেক প্রশ্ন';
$string['everythingon'] = 'সবকিছু';
$string['export'] = 'এক্সপোর্ট';
$string['exportcategory'] = 'এক্সপোর্টের বিভাগ';
$string['exporterror'] = 'এক্সপোর্ট প্রক্রিয়াকরণের সময় ত্রুটি';
$string['exportingquestions'] = 'ফাইলে প্রশ্ন এক্সপোর্ট করা হচ্ছে';
$string['exportname'] = 'ফাইলের নাম';
$string['exportquestions'] = 'ফাইলে প্রশ্ন এক্সপোর্ট';
$string['extraattemptrestrictions'] = 'অংশগ্রহনের উপর অতিরিক্ত নিষেধাজ্ঞা';
$string['false'] = 'মিথ্যা';
$string['feedback'] = 'মন্তব্য';
$string['feedbackerrorboundaryformat'] = 'গ্রেডের সীমা নিয়ে মন্তব্য অবশ্যই শতকরা হার বা সংখ্যায় হতে হবে। যে মানটি আপনি সীমায় {$a} দিয়েছেন তা বোঝা যায় না।';
$string['feedbackerrorboundaryoutofrange'] = 'গ্রেডের সীমা নিয়ে মন্তব্য অবশ্যই ০% থেকে ১০০% এর মধ্যে হতে হবে। যে মানটি {$a} দিয়েছেন তা সীমার বাইরে।';
$string['feedbackerrorjunkinboundary'] = 'গ্রেডের সীমা নিয়ে মন্তব্য প্রয়োগের বক্সটি আপনাকে অবশ্যই কোন ফাঁকা ছাড়া পূরন করতে হবে।';
$string['feedbackerrorjunkinfeedback'] = 'মন্তব্য প্রয়োগের বক্সটি আপনাকে অবশ্যই কোন ফাঁকা ছাড়া পূরন করতে হবে।';
$string['feedbackerrororder'] = 'গ্রেডের সীমা নিয়ে মন্তব্য ক্রম অনুসারে দিতে হবে, সর্বোচ্চটি প্রথমে হবে। যে মানটি {$a} দেয়া হয়েছে তা ক্রমের বাইরে।';
$string['file'] = 'ফাইল';
$string['fileformat'] = 'ফাইলের বিন্যাস';
$string['fillcorrect'] = 'সঠিক উত্তর দিয়ে পূরন';
$string['filloutnumericalanswer'] = 'অন্তত একটি সম্ভাব্য উত্তর এবং সহনশীলতা আপনি প্রদান করেছেন। প্রথম অন্তরমিলযুক্ত উত্তরটি স্কোর নির্ধারনের এবং মন্তব্যের জন্য ব্যবহৃত হবে। একেবারে শেষে যদি কোন উত্তর নেই এমন মন্তব্য করা হয়, তাহলে যেসকল শিক্ষার্থীদের উত্তর অন্য কোন উত্তরের সাথে মিলে নাই তারা দেখতে পাবে।';
$string['filloutoneanswer'] = 'অন্তত একটি সম্ভাব্য উত্তর প্রদান করতে হবে। যে উত্তরটি ফাঁকা থাকে তা ব্যবহৃত হবেনা।  কোন চরিত্রের সাথে মেলানোর জন্য \'*\' এটি ওয়াইল্ডকার্ড এর মত ব্যবহার করা যায়। প্রথম অন্তরমিলযুক্ত উত্তরটি স্কোর নির্ধারনের এবং মন্তব্যের জন্য ব্যবহৃত হবে।';
$string['filloutthreequestions'] = 'অন্তরমিলযুক্ত উত্তরের জন্য কমপক্ষে তিনটি প্রশ্ন প্রদান করতে হবে। ফাঁকা প্রশ্নের জন্য অতিরিক্ত ভুল উত্তর দেওয়া যাবে। প্রশ্ন এবং উত্তর উভয়ই ফাঁকা থাকলে অন্তর্ভুক্তি উপেক্ষা করা হবে।';
$string['fillouttwochoices'] = 'কমপক্ষে দুইটি পছন্দ পূরন করতে হবে। পছন্দ ফাঁকা থাকলে ব্যবহৃত হবেনা।';
$string['finishattemptdots'] = 'অংশগ্রহণ সম্পন্ন...';
$string['finishreview'] = 'রিভিউ সমাপ্ত';
$string['forceregeneration'] = 'জোরপূর্বক পুনরায় তৈরি';
$string['formatnotfound'] = 'ইম্পোর্ট/ এক্সপোর্ট বিন্যাস {$a} খুঁজে পাওয়া যায়নি';
$string['formatnotimplemented'] = 'এই বিন্যাসটি সঠিকভাবে বাস্তবায়ন করা হয়নি, অনুগ্রহ করে একটি বাগ রিপোর্ট দিন';
$string['formulaerror'] = 'সূত্র ত্রুটি';
$string['fractionsaddwrong'] = 'আপনি যে ধনাত্মক গ্রেড নির্বাচন করেছেন তা ১০০% বেশি যোগ করে না<br />তার বদলে তা {$a}% পর্যন্ত যোগ করে<br />আপনি কি পূর্ববর্তী ধাপে ফেরত গিয়ে প্রশ্নটি আবার নির্ধরাণ করতে চান?';
$string['fractionsnomax'] = 'অন্তত একটি উত্তরকে অবশ্যই ১০০% হতে হবে, তাহলে <br />এই প্রশ্নের জন্য পুরো গ্রেড পাওয়া সম্ভব।<br /> আপনি কি পূর্বে ফিরে আবার প্রশ্নটি নির্ধারন করতে চাচ্ছেন?';
$string['fromfile'] = 'ফাইল থেকে:';
$string['functiondisabledbysecuremode'] = 'এই কাজটি বর্তমানে নিস্ক্রিয়';
$string['generalfeedback'] = 'সাধারণ মন্তব্য';
$string['generalfeedback_help'] = 'একটি প্রশ্নে অংশগ্রহনের পরে সাধারন মন্তব্য লিখাটি প্রদর্শিত হবে। একটি সুনির্দিষ্ট প্রশ্নের মন্তব্য, উত্তরের উপর নির্ভর করে, একই সাধারন মন্তব্য সবসময় প্রদর্শিত হয়।';
$string['grade'] = 'গ্রেড';
$string['gradeall'] = 'সকল গ্রেড';
$string['gradeaverage'] = 'গড় গ্রেড';
$string['gradeboundary'] = 'গ্রেড সীমা';
$string['gradeessays'] = 'রচনামূলকে গ্রেড';
$string['gradehighest'] = 'সর্বোচ্চ গ্রেড';
$string['grademethod'] = 'গ্রেডিং পদ্ধতি';
$string['grademethod_help'] = 'যখন একাধিকবার অংশগ্রহণের অনুমোদন থাকে, বর্ণিত পদ্ধতিটি  চূড়ান্ত কুইজের গ্রেডের জন্য পাওয়া যায়:

* সব অংশগ্রহণের জন্য সর্বোচ্চ গ্রেড
* সব অংশগ্রহণের জন্য গড় (গড়) গ্রেড
* প্রথম অংশগ্রহণ (অন্য অংশগ্রহণ উপেক্ষা করা হয়েছে)
*শেষ অংশগ্রহণ (অন্য অংশগ্রহণ উপেক্ষা করা হয়েছে)';
$string['gradesdeleted'] = 'কুইজ গ্রেড অপসারন';
$string['gradesofar'] = '{$a->পদ্ধতি}: {$a->প্রাপ্তগ্রেড} / {$a->কুইজগ্রেড}।';
$string['gradingdetails'] = 'জমা দেয়ার জন্য নাম্বার: {$a->raw}/{$a->max}।';
$string['gradingdetailsadjustment'] = 'পূর্ববর্তী প্যানাল্টিসহ দেয় <strong>{$a->cur}/{$a->max}</strong>।';
$string['gradingdetailspenalty'] = 'এ জমা প্যানাল্টি হিসাবে {$a} পায়।';
$string['gradingdetailszeropenalty'] = 'আপনি এ জমার জন্য কোনো প্যানাল্টি পাবেন না।';
$string['gradingmethod'] = 'গ্রেডিং পদ্ধতি: {$a}';
$string['groupoverrides'] = 'গ্রুপ উপেক্ষা করে';
$string['groupsnone'] = 'কোর্সে কোনো গ্রুপ নেই';
$string['guestsno'] = 'দুঃখিত, অতিথি কোনো কুইজ দেখতে পারেনা বা অংশগ্রহন করতে পারেনা';
$string['hidebreaks'] = 'পৃষ্ঠা ব্রেক আড়াল';
$string['hidereordertool'] = 'পুনঃক্রম করার টুল আড়াল';
$string['history'] = 'জবাবের ইতিহাস:';
$string['imagedisplay'] = 'প্রদর্শনীয় চিত্র';
$string['import'] = 'ইম্পোর্ট';
$string['importcategory'] = 'ইম্পোর্ট বিভাগ';
$string['importerror'] = 'ইম্পোর্ট প্রক্রিয়াধীন করার সময় ত্রুটি';
$string['importfilearea'] = 'কোর্স ফাইলে ইতোমধ্যে আছে এমন ফাইল থেকে ইম্পোর্ট...';
$string['importfileupload'] = 'ফাইল আপলোড থেকে  ইম্পোর্ট...';
$string['importfromthisfile'] = 'এ ফাইল থেকে ইম্পোর্ট';
$string['import_help'] = 'এ ফাংশন বাহ্যিক টেক্সট ফাইল থেকে প্রশ্ন ইম্পোর্ট করার অনুমোদন দেয়।

যদি আপনার ফাইলে ascii নয় এমন অক্ষর থাকে তবে সেখানে অবশ্যই UTF-8 এনকোডিং ব্যবহার করতে হবে। মাইক্রোসফ্ট অফিস অ্যাপ্লিকেশন দ্বারা তৈরিকৃত ফাইল এর ব্যাপারে বিশেষভাবে সচেতন হতে হবে, কারণ এখানে সাধারনত বিশেষ কিছু এনকোডিং ব্যবহৃত হয় যা সঠিকভাবে নিয়ন্ত্রন করা হবে না।

ইম্পোর্ট এবং এক্সপোর্ট বিন্যাস প্লাগ করার মত রিসোর্স। অন্যান্য ঐচ্ছিক বিন্যাস মডিউল এবং প্লাগইন ডাটাবেসে বিদ্যমান থাকতে পারে।';
$string['importingquestions'] = 'ফাইল থেকে {$a} প্রশ্ন ইম্পোর্ট';
$string['import_link'] = 'প্রশ্ন/ইম্পোর্ট';
$string['importmax10error'] = 'প্রশ্নে একটি ত্রুটি আছে। আপনার কাছে দশটির বেশি উত্তর থাকার কথা না';
$string['importmaxerror'] = 'প্রশ্নে একটি ত্রুটি আছে। অনেকগুলো উত্তর রয়েছে।';
$string['importquestions'] = 'ফাইল থেকে প্রশ্ন ইম্পোর্ট';
$string['inactiveoverridehelp'] = '*শিক্ষার্থীর কুইজে অংশগ্রহণের জন্য সঠিক গ্রুপ এবং ভূমিকা নেই';
$string['incorrect'] = 'ভুল';
$string['indivresp'] = 'প্রত্যেক আইটেমের স্বতন্ত্র জবাব';
$string['info'] = 'তথ্য';
$string['infoshort'] = 'i';
$string['invalidattemptid'] = 'এমন কোনো অংশগ্রহনকারী আইডি নেই';
$string['invalidcategory'] = 'বিভাগীয় আইডি অকার্যকর';
$string['invalidnumericanswer'] = 'আপনার দেয়া একটি উত্তর কার্যকরী সংখ্যা ছিল না।';
$string['invalidnumerictolerance'] = 'আপনার দেয়া একটি টলারেন্স কার্যকরী সংখ্যা ছিল না।';
$string['invalidoverrideid'] = 'অকার্যকর উপেক্ষনীয় আইডি';
$string['invalidquestionid'] = 'অকার্যকর প্রশ্ন আইডি';
$string['invalidquizid'] = 'অকার্যকর কুইজ আইডি';
$string['invalidsource'] = 'উৎসটি যেমন কার্যকর ছিল সেভাবে গৃহীত হয়নি';
$string['invalidsourcetype'] = 'অকার্যকর উৎসের ধরণ';
$string['invalidstateid'] = 'অকার্যকর অবস্থান আইডি';
$string['lastanswer'] = 'আপনার শেষ উত্তর ছিল';
$string['layout'] = 'বহির্বিন্যাস';
$string['layoutasshown'] = 'পৃষ্ঠার বহির্বিন্যাস, যেমন প্রদর্শিত।';
$string['layoutasshownwithpages'] = 'পৃষ্ঠার বহির্বিন্যাস, যেমন প্রদর্শিত। <small>(প্রত্যেক প্রশ্নে {$a} স্বয়ংক্রিয় নতুন পৃষ্ঠা।)</small>';
$string['layoutshuffledandpaged'] = 'প্রত্যেক পৃষ্ঠার জন্য {$a} প্রশ্ন এলোমেলোভাবে সাজানো হবে।';
$string['layoutshuffledsinglepage'] = 'প্রত্যেক পৃষ্ঠায় প্রতিটি {$a} প্রশ্ন এলোমেলোভাবে সাজানো হবে।';
$string['link'] = 'লিঙ্ক';
$string['listitems'] = 'কুইজে আইটেমের তালিকা';
$string['literal'] = 'মৌখিক';
$string['loadingquestionsfailed'] = 'প্রশ্ন লোড করতে ব্যর্থ: {$a}';
$string['makecopy'] = 'নতুন প্রশ্ন হিসাবে সংরক্ষণ';
$string['managetypes'] = 'প্রশ্নের ধরণ এবং সার্ভার ব্যবস্থাপনা';
$string['manualgrading'] = 'গ্রেডিং';
$string['mark'] = 'জমা';
$string['markall'] = 'জমার পৃষ্ঠা';
$string['marks'] = 'নাম্বার';
$string['match'] = 'মিল';
$string['matchanswer'] = 'মেলে এমন উত্তর';
$string['matchanswerno'] = 'মেলে এমন উত্তর {$a}';
$string['max'] = 'সর্বোচ্চ';
$string['min'] = 'সর্বনিম্ন';
$string['minutes'] = 'মিনিট';
$string['missingcorrectanswer'] = 'সঠিক উত্তর সুনির্ধারণ করা উচিৎ';
$string['missingitemtypename'] = 'অনুপস্থিত নাম';
$string['modulename'] = 'কুইজ';
$string['modulenameplural'] = 'কুইজ';
$string['moveselectedonpage'] = 'নির্বাচিত প্রশ্ন পৃষ্ঠায় স্থানান্তর করেন: {$a}';
$string['multichoice'] = 'বহুনির্বাচনী প্রশ্ন';
$string['multipleanswers'] = 'অন্তত একটি উত্তর নির্বাচন।';
$string['multiplier'] = 'গুনিতক';
$string['name'] = 'নাম';
$string['navnojswarning'] = 'সতর্কীকরণ: এসব লিংকে আপনার উত্তর সংরক্ষিত হবে না। পৃষ্ঠার নিচে পরবর্তী বোতাম ব্যবহার।';
$string['neverallononepage'] = 'কখনো নয়, এ পৃষ্ঠার সকল প্রশ্ন';
$string['newattemptfail'] = 'ত্রুটি: কুইজে নতুন কোনো চেষ্টা শুরু করতে পারে না';
$string['newpage'] = 'নতুন পৃষ্ঠা';
$string['newpageevery'] = 'স্বয়ংক্রিয়ভাবে নতুন পৃষ্ঠা শুরু';
$string['newpage_help'] = 'দীর্ঘতর কুইজের জন্য কতিপয় পৃষ্ঠায় প্রতি পৃষ্ঠায় প্রশ্নের সংখ্যা সীমাবদ্ধ করে কুইজটিকে প্রসারিত করলে অর্থবহ হবে। যখন কুইজে প্রশ্ন যোগ করা হয়, পেজ ব্রেক স্বয়ংক্রিয়ভাবে সেটিং অনুযায়ী সন্নিবিষ্ট হয়। উপরন্তু পেজ ব্রেক নিজ হাতে সম্পাদনের পৃষ্ঠায় স্থানান্তর করা যাবে।';
$string['noanswers'] = 'কোনো উত্তর নির্বাচিত হয়নি!';
$string['noattempts'] = 'এ কুইজে কেউ এখনও অংশগ্রহন করেনি';
$string['noattemptstoshow'] = 'প্রদর্শন করার মত কোনো চেষ্টা নেই';
$string['nocategory'] = 'ভুল বা কোনো বিভাগ নির্ধারণ করা নেই';
$string['noclose'] = 'বন্ধ করার কোনো তারিখ নেই';
$string['nocommentsyet'] = 'এখন পর্যন্ত কোনো মন্তব্য করা হয়নি।';
$string['noconnection'] = 'এ প্রশ্ন প্রক্রিয়াকরণ করতে পারে ওয়েব সার্ভিস এর এমন কোনো সংযোগ নেই। অনুগ্রহ করে আপনার প্রশাসকের সাথে যোগাযোগ';
$string['nodataset'] = 'কিছু না - এটা কোনো ওয়াইল্ড কার্ড না';
$string['nodatasubmitted'] = 'কোনো ডাটা জমা করা হয়নি।';
$string['noessayquestionsfound'] = 'নিজ হাতে গ্রেডকৃত প্রশ্ন খুঁজে পাওয়া যায়নি';
$string['nogradewarning'] = 'কুইজে গ্রেড দেয়া হয়নি, সুতরাং আপনি কোনো সার্বিক মন্তব্য নির্ধারণ করতে পারেন না যা গ্রেড অনুসারে পার্থক্য করে।';
$string['nomoreattempts'] = 'আর চেষ্টা করা যাবে না';
$string['none'] = 'কোনটি না';
$string['noopen'] = 'খোলার কোনো তারিখ নাই';
$string['nooverridedata'] = 'আপনাকে অন্তত একটি কুইজ সেটিং উপেক্ষা করতে হবে।';
$string['nopossibledatasets'] = 'কোনো সম্ভাব্য ডাটাসেট নেই';
$string['noquestionintext'] = 'প্রশ্নের টেক্সট এ কোনো সন্নিবিষ্ট প্রশ্ন নেই';
$string['noquestions'] = 'এখন পর্যন্ত কোনো প্রশ্ন যোগ করা হয়নি';
$string['noquestionsfound'] = 'কোনো প্রশ্ন পাওয়া যায়নি';
$string['noquestionsinquiz'] = 'কুইজে কোনো প্রশ্ন নেই।';
$string['noquestionsnotinuse'] = 'এলোমেলো প্রশ্ন ব্যবহৃত হচ্ছে না, যতক্ষন পর্যন্ত না বিভাগটি ফাঁকা আছে।';
$string['noquestionsonpage'] = 'ফাঁকা পৃষ্ঠা';
$string['noresponse'] = 'জবাব নেই';
$string['noreview'] = 'এ কুইজ রিভিউ করার অনুমতি আপনার নেই';
$string['noreviewshort'] = 'অনুমোদিত নয়';
$string['noreviewuntil'] = '{$a} পর্যন্ত এ কুইজ রিভিউ করার অনুমোদন আপনার নেই';
$string['noreviewuntilshort'] = 'বিদ্যমান {$a}';
$string['noscript'] = 'JavaScript চালিয়ে যাওয়ার জন্য সক্রিয় করতে হবে!';
$string['notavailabletostudents'] = 'মনে রাখবেন: এ কুইজ বর্তমানে আপনার শিক্ষার্থীদের জন্য বিদ্যমান নেই';
$string['notenoughsubquestions'] = 'পর্যাপ্ত সংখ্যক উপ-প্রশ্ন নির্ধারণ করা নাই!<br />আপনি কি ফেরত গিয়ে আবার প্রশ্ন সুনির্দিষ্ট করতে চান?';
$string['notimedependentitems'] = 'যেসব আইটেম সময় নির্ভর তা বর্তমানে কুইজ মডিউল দ্বারা সমর্থিত নয়। সম্পূর্ন কুইজের সময় সীমা নির্ধারন। আপনি কি অন্য আইটেম নির্বাচন করার ব্যাপারে নিশ্চিত ( অথবা বর্তমান আইটেম )?';
$string['notyourattempt'] = 'এটা আপনার চেষ্টা নয়!';
$string['noview'] = 'লগইনকৃত ব্যবহারকারীর এ কুইজ দেখার অনুমোদন নাই';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring}, {$a->attemptnum} চেষ্টা করছে';
$string['numattemptsmade'] = 'এ কুইজে {$a} সংখ্যকবার অংশগ্রহন করা হয়েছে';
$string['numberabbr'] = '#';
$string['numerical'] = 'সংখ্যাবাচক';
$string['numquestionsx'] = 'প্রশ্ন: {$a}';
$string['onlyteachersexport'] = 'কেবলমাত্র শিক্ষকরাই প্রশ্ন এক্সপোর্ট করতে পারে';
$string['onlyteachersimport'] = 'কেবলমাত্র শিক্ষকরাই সম্পাদনা করার অধিকার নিয়ে প্রশ্ন এক্সপোর্ট করতে পারে';
$string['open'] = 'উত্তর দেয়া হয়নি';
$string['openclosedatesupdated'] = 'কুইজ শুরু ও শেষ হওয়ার তারিখ হালনাগাদ';
$string['optional'] = 'ঐচ্ছিক';
$string['orderandpaging'] = 'ক্রম এবং পৃষ্ঠায়ন';
$string['orderingquiz'] = 'ক্রম এবং পৃষ্ঠায়ন';
$string['outof'] = 'সর্বোচ্চ {$a->সর্বোচ্চগ্রেড} এর মধ্যে {$a->গ্রেড}';
$string['outofpercent'] = '{$a->সর্বোচ্চগ্রেড} এর মধ্যে {$a->গ্রেড} ({$a->শতকরা}%)';
$string['outofshort'] = '{$a->গ্রেড}/{$a->সর্বোচ্চগ্রেড}';
$string['overallfeedback'] = 'সার্বিক মতামত';
$string['overallfeedback_help'] = 'একটি কুইজে অংশগ্রহণের পর সর্বোপরি মন্তব্যটি প্রদর্শিত হবে। অতিরিক্ত গ্রেডের সীমা উল্লেখ (সংখ্যা অথবা শতকরা হিসেবে), অর্জিত গ্রেডের উপর প্রদর্শিত মন্তব্যটি নির্ভর করে।';
$string['overdue'] = 'পাওনা পরিশোধের সময়োত্তীর্ণ';
$string['override'] = 'উপেক্ষা';
$string['overridedeletegroupsure'] = 'আপনি কি নিশ্চিত যে আপনি গ্রুপ {$a} উপেক্ষা করা অপসারন করতে চান?';
$string['overridedeleteusersure'] = 'আপনি কি নিশ্চিত যে আপনি ব্যবহারকারী {$a} উপেক্ষা করা অপসারন করতে চান?';
$string['overridegroup'] = 'গ্রুপ উপেক্ষা';
$string['overridegroupeventname'] = '{$a->কুইজ} - {$a->গ্রুপ}';
$string['overrides'] = 'উপেক্ষা';
$string['overrideuser'] = 'ব্যবহারকারী উপেক্ষা';
$string['overrideusereventname'] = '{$a->কুইজ} - উপেক্ষা';
$string['parent'] = 'প্যারেন্ট';
$string['parentcategory'] = 'প্যারেন্ট বিভাগ';
$string['parsingquestions'] = 'ফাইল ইম্পোর্ট থেকে প্রশ্ন পাঠানো।';
$string['partiallycorrect'] = 'আংশিকভাবে সঠিক';
$string['penalty'] = 'প্যানাল্টি';
$string['penaltyscheme'] = 'প্যানাল্টি প্রয়োগ';
$string['penaltyscheme_help'] = 'যদি সক্রিয় করা থাকে, ভুল জবাবে চুড়ান্ত নম্বর দেয়ার সময় শাস্তিস্বরূপ নম্বর কাটা হবে। নম্বর কাটার পরিমান প্রশ্নের সেটিং এ নির্দিষ্ট করা থাকে। কেবলমাত্র এডাপটিভ মোড সক্রিয় করা থাকলে এ সেটিং প্রয়োগযোগ্য হবে।';
$string['percentcorrect'] = 'শতকরা সঠিক';
$string['pleaseclose'] = 'আপনার অনুরোধ পাঠানো হয়েছে। আপনি এখন উইন্ডো বন্ধ করতে পারেন';
$string['pluginadministration'] = 'কুইজ প্রশাসন';
$string['pluginname'] = 'কুইজ';
$string['popup'] = '&quot;secure&quot;উইন্ডোতে কুইজ প্রদর্শন';
$string['popupblockerwarning'] = 'পরীক্ষার এ অংশ মোডে সুরক্ষিত, তার মানে হচ্ছে সুরক্ষিত উইন্ডোতে গিয়ে এ কুইজে অংশগ্রহন করা যাবে। অনুগ্রহ করে আপনার পপআপ ব্লকার বন্ধ করে দিন। ধন্যবাদ।';
$string['popupnotice'] = 'নিরাপদ উইন্ডোতে শিক্ষার্থীরা কুইজ দেখবে';
$string['preprocesserror'] = 'প্রাক-প্রক্রিয়াকরণের সময় ত্রুটি!';
$string['preview'] = 'প্রাকদর্শন';
$string['previewquestion'] = 'প্রশ্নের প্রাকদর্শন';
$string['previewquiz'] = 'প্রাকদর্শন {$a}';
$string['previewquiznow'] = 'এখন কুইজের প্রাকদর্শন';
$string['previous'] = 'পূর্ববর্তী অবস্থা';
$string['publish'] = 'প্রকাশ';
$string['publishedit'] = 'প্রকাশনা কোর্সের বিভাগে প্রশ্ন যোগ বা সম্পাদনা করার জন্য আপনার অনুমোদন থাকতে হবে';
$string['qname'] = 'নাম';
$string['qti'] = 'IMS QTI বিন্যাস';
$string['qtypename'] = 'ধরণ, নাম';
$string['question'] = 'প্রশ্ন';
$string['questionbankcontents'] = 'প্রশ্ন ব্যাংকের উপকরণ';
$string['questionbankmanagement'] = 'প্রশ্ন ব্যাংক ব্যনস্থাপনা';
$string['questionbehaviour'] = 'প্রশ্নের আচরণবিধি';
$string['questioncats'] = 'প্রশ্নের বিভাগ';
$string['questiondeleted'] = 'প্রশ্ন অপসারন করা হয়েছে। অনুগ্রহ করে আপনার শিক্ষকের সাথে যোগাযোগ';
$string['questioninuse'] = '\'{$a->questionname}\' প্রশ্নটি বর্তমানে ব্যবহৃত হচ্ছে: <br />{$a->quiznames}<br />প্রশ্ন এ কুইজ থেকে অপসারিত না হয়ে শুধুমাত্র বিভাগীয় তালিকা থেকে অপসারিত হবে।';
$string['questionmissing'] = 'এ সেশনের জন্য প্রশ্ন অনুপস্থিত';
$string['questionname'] = 'প্রশ্নের নাম';
$string['questionnotloaded'] = 'ডাটাবেস থেকে প্রশ্ন {$a} লোড করা হয়নি';
$string['questionorder'] = 'প্রশ্নের ক্রম';
$string['questions'] = 'প্রশ্ন';
$string['questionsinclhidden'] = 'প্রশ্ন (আড়ালকৃত সহ)';
$string['questionsinthisquiz'] = 'কুইজের প্রশ্ন';
$string['questionsperpage'] = 'প্রতি পৃষ্ঠায় প্রশ্ন';
$string['questionsperpageselected'] = 'প্রতি পৃষ্ঠায় প্রশ্ন নির্ধারণ করা হয়ে যাওয়ার ফলে বর্তমানে পৃষ্ঠায়নও নির্দিষ্ট। ফলস্বরূপ, পৃষ্ঠা নিয়ন্ত্রন নিস্ক্রিয় আছে। আপনি {$a} এটা পরিবর্তন করতে পারেন।';
$string['questionsperpagex'] = 'প্রতি পৃষ্ঠায় প্রশ্ন: {$a}';
$string['questiontext'] = 'প্রশ্ন টেক্সট';
$string['questiontextisempty'] = '[ফাঁকা প্রশ্ন টেক্সট]';
$string['questiontype'] = 'প্রশ্নের ধরণ {$a}';
$string['questiontypesetupoptions'] = 'প্রশ্নের ধরণের জন্য অপশন সেটআপ:';
$string['quiz:attempt'] = 'কুইজে অংশগ্রহন';
$string['quizavailable'] = 'যে পর্যন্ত কুইজ বিদ্যমান থাকবে: {$a}';
$string['quizclose'] = 'কুইজ বন্ধ';
$string['quizclosed'] = '{$a} এ কুইজ বন্ধ';
$string['quizcloses'] = 'কুইজ বন্ধ';
$string['quizcloseson'] = 'কুইজ {$a} এ বন্ধ হবে';
$string['quiz:deleteattempts'] = 'কুইজে অংশগ্রহন করা অপসারন';
$string['quiz:emailconfirmsubmission'] = 'জমা দেয়ার সময় ইমেইল এর মাধ্যমে নিশ্চিত হয়ে নিন';
$string['quiz:emailnotifysubmission'] = 'জমা দেয়ার পর ইমেইল ঘোষণা দেখুন';
$string['quiz:grade'] = 'নিজ হাতে কুইজে গ্রেড প্রদান';
$string['quiz:ignoretimelimits'] = 'কুইজের সময়সীমা উপেক্ষা';
$string['quizisclosed'] = 'কুইজ বন্ধ';
$string['quizisopen'] = 'কুইজ চালু';
$string['quizisopenwillclose'] = 'কুইজ চালু (বন্ধ {$a})';
$string['quiz:manage'] = 'কুইজ ব্যবস্থাপনা';
$string['quiz:manageoverrides'] = 'কুইজ উপেক্ষা ব্যবস্থাপনা';
$string['quiznavigation'] = 'কুইজ ন্যাভিগেশন';
$string['quizopen'] = 'কুইজ শুরু';
$string['quizopened'] = 'কুইজ শুরু';
$string['quizopenedon'] = 'কুইজ {$a} এ শুরু';
$string['quizopens'] = 'কুইজ শুরু';
$string['quizopenwillclose'] = 'কুইজ শুরু হয়েছে, বন্ধ {$a} হবে';
$string['quizordernotrandom'] = 'এলোমেলো করা হয়নি এমন কুইজের ক্রম';
$string['quizorderrandom'] = '* কুইজের ক্রম এলোমেলো';
$string['quiz:preview'] = 'কুইজ প্রাকদর্শন';
$string['quiz:regrade'] = 'কুইজের অংশগ্রহনের উপর পুনরায় গ্রেড';
$string['quiz:reviewmyattempts'] = 'আপনার নিজের চেষ্টা রিভিউ';
$string['quizsettings'] = 'কুইজ সেটিং';
$string['quiz:view'] = 'কুইজ তথ্য প্রদর্শন';
$string['quiz:viewreports'] = 'কুইজ রিপোর্ট প্রদর্শন';
$string['quizwillopen'] = 'কুইজ শুরু হবে {$a}';
$string['random'] = 'এলোমেলো প্রশ্ন';
$string['randomcreate'] = 'এলোমেলো প্রশ্ন তৈরি';
$string['randomfromcategory'] = 'বিভাগ হতে এলোমেলো প্রশ্ন';
$string['randomnosubcat'] = 'কেবলমাত্র এ বিভাগ থেকে প্রশ্ন, উপবিভাগ থেকে নয়।';
$string['randomwithsubcat'] = 'বিভাগ এবল উপবিভাগ থেকে প্রশ্ন';
$string['readytosend'] = 'আপনি আপনার সম্পূর্ণ কুইজ গ্রেড দেয়ার জন্য পাঠাচ্ছিলেন। আপনি কি চালিয়ে যাওয়ার ব্যাপারে নিশ্চিত?';
$string['reattemptquiz'] = 'কুইজে পুনরায় অংশগ্রহন';
$string['recentlyaddedquestion'] = 'সাম্প্রতিকভাবে যোগ করা প্রশ্ন!';
$string['recurse'] = 'উপবিভাগ থেকেও প্রশ্ন প্রদর্শন';
$string['regrade'] = 'সকল চেষ্টায় পুনরায় গ্রেড প্রদান';
$string['regradecomplete'] = 'সকল চেষ্টায় পুনরায় গ্রেড দেয়া হয়েছে';
$string['regradecount'] = '{$a->attempt} এর মধ্যে {$a->changed} গ্রেড পরিবর্তিত';
$string['regradedisplayexplanation'] = 'পুনরায় গ্রেড প্রদানের সময় যেসকল চেষ্টা পরিবর্তিত হয়েছে সেগুলো প্রশ্নের রিভিউ উইন্ডোতে হাইপারলিংক হিসাবে প্রদর্শিত';
$string['regradenotallowed'] = 'কুইজ পুনরায় গ্রেড দেয়ার অনুমতি আপনার নেই';
$string['regradingquestion'] = 'পুনরায় গ্রেডিং "{$a}"।';
$string['regradingquiz'] = 'কুইজে পুনরায় গ্রেডিং "{$a}"';
$string['remove'] = 'অপসারণ';
$string['removeallquizattempts'] = 'সকল কুইজের অংশগ্রহন অপসারন';
$string['removeemptypage'] = 'ফাঁকা পৃষ্ঠা অপসারন';
$string['removeselected'] = 'নির্বাচিতকে অপসারণ';
$string['rename'] = 'পুনরায় নামকরণ';
$string['renderingserverconnectfailed'] = 'সার্ভার {$a} RQP অনুরোধ প্রক্রিয়াকরণ করতে ব্যর্থ। URL সঠিক আছে কিনা তা পরীক্ষা।';
$string['reorderquestions'] = 'প্রশ্ন পুনর্বিন্যাস';
$string['reordertool'] = 'পুনর্বিন্যাস টুল প্রদর্শন';
$string['repaginate'] = 'প্রতি পৃষ্ঠার প্রশ্ন {$a} নিয়া পৃষ্ঠা পুনঃসংখ্যায়ন';
$string['repaginatecommand'] = 'পৃষ্ঠা পুনঃসংখ্যায়ন';
$string['repaginatenow'] = 'এখন পৃষ্ঠা পুনঃসংখ্যায়ন';
$string['replace'] = 'প্রতিস্থাপন';
$string['replacementoptions'] = 'প্রতিস্থাপন অপশন';
$string['report'] = 'রিপোর্ট';
$string['reportanalysis'] = 'আইটেম বিশ্লেষণ';
$string['reportfullstat'] = 'বিস্তারিত পরিসংখ্যান';
$string['reportmulti_percent'] = 'বিবিধ-শতকরা';
$string['reportmulti_q_x_student'] = 'বিবিধ-শিক্ষার্থীর পছন্দ';
$string['reportmulti_resp'] = 'স্বতন্ত্র জবাব';
$string['reportnotfound'] = 'অজানা রিপোর্ট ({$a})';
$string['reportoverview'] = 'সারসংক্ষেপ';
$string['reportregrade'] = 'চেষ্টায় পুনরায় গ্রেড প্রদান';
$string['reportresponses'] = 'বিস্তারিত জবাব';
$string['reports'] = 'রিপোর্ট';
$string['reportsimplestat'] = 'সহজ পরিসংখ্যান';
$string['requirepassword'] = 'পাসওয়ার্ড আবশ্যক';
$string['requirepassword_help'] = 'পাসওয়ার্ড সুনির্দিষ্ট করা থাকলে, কুইজে অংশগ্রহন করার সময় শিক্ষার্থীকে অবশ্যই পাসওয়ার্ড দিয়ে অংশগ্রহন করতে হবে।';
$string['requiresubnet'] = 'নেটওয়ার্ক ঠিকানা আবশ্যক';
$string['requiresubnet_help'] = 'LAN বা ইন্টারনেট এর নির্দিষ্ট কিছু সাবনেটে আংশিক বা সম্পূর্ণ IP অ্যাড্রেসের কমা দ্বারা পৃথক করা তালিকা দ্বারা কুইজে অংশগ্রহন সীমাবদ্ধ করা থাকতে পারে। এগুলো পরীক্ষিত (সংরক্ষিত) প্রশ্নের ক্ষেত্রে নির্দিষ্ট কিছু এলাকার মানুষ যাতে এ কুইজে অংশগ্রহন করতে পারে তার জন্য কার্যকরী।';
$string['response'] = 'জবাব';
$string['responses'] = 'জবাব';
$string['results'] = 'ফলাফল';
$string['reuseifpossible'] = 'পূর্ববর্তীতে অপসারন করা হয়েছিল তা পুনরায় ব্যবহার';
$string['reverttodefaults'] = 'কুইজ ডিফল্টে প্রর্ত্যাবর্তন';
$string['review'] = 'রিভিউ';
$string['reviewafter'] = 'কুইজ শেষ হওয়ার পর রিভিউ করার অনুমোদন';
$string['reviewalways'] = 'যে কোনো সময় রিভিউ করার অনুমোদন';
$string['reviewbefore'] = 'কুইজ চলাকালীন সময় রিভিউ করার অনুমোদন';
$string['reviewclosed'] = 'কুইজ শেষ হবার পর';
$string['reviewimmediately'] = 'অংশগ্রহনের পর সাথে সাথে';
$string['reviewnever'] = 'রিভিউ এর অনুমোদন কখনোই নয়';
$string['reviewofattempt'] = 'চেষ্টার রিভিউ {$a}';
$string['reviewofpreview'] = 'প্রাকদর্শন এর রিভিউ';
$string['reviewopen'] = 'পরবর্তিতে, যখন কুইজ চালু থাকে';
$string['reviewoptions'] = 'শিক্ষার্থীও রিভিউ করতে পারে';
$string['reviewoptionsheading'] = 'রিভিউ অপশন';
$string['reviewresponse'] = 'জবাব রিভিউ';
$string['reviewresponsetoq'] = 'জবাব রিভিউ (প্রশ্ন {$a})';
$string['reviewthisattempt'] = 'এ অংশগ্রহনে আপনার জবাবগুলো রিভিউ';
$string['rqp'] = 'রিমোট প্রশ্ন';
$string['rqps'] = 'রিমোট প্রশ্ন';
$string['sameasoverall'] = 'সার্বিক গ্রেডের জন্য একই';
$string['save'] = 'সংরক্ষণ';
$string['saveandedit'] = 'পরিবর্তন সংরক্ষণ এবং প্রশ্ন সম্পাদনা';
$string['saveattemptfailed'] = 'বর্তমান কুইজে অংশগ্রহন সংরক্ষণ করতে ব্যর্থ।';
$string['savedfromdeletedcourse'] = 'অপসারন করা হয়েছে এমন কোর্স থেকে সংরক্ষণ "{$a}"';
$string['savegrades'] = 'গ্রেড সংরক্ষণ';
$string['savemyanswers'] = 'আমার উত্তর সংরক্ষণ';
$string['savenosubmit'] = 'জমা না দিয়েই সংরক্ষণ';
$string['saveoverrideandstay'] = 'সংরক্ষণ করে আরেকটি উপেক্ষা দিন';
$string['savequiz'] = 'এ সম্পূর্ণ কুইজটা সংরক্ষণ';
$string['score'] = 'অসংশোধিত স্কোর';
$string['scores'] = 'স্কোর';
$string['select'] = 'নির্বাচন';
$string['selectall'] = 'সব নির্বাচন';
$string['selectcategory'] = 'বিভাগ নির্বাচন';
$string['selectedattempts'] = 'নির্বাচিত চেষ্টা...';
$string['selectnone'] = 'সব অনির্বাচন';
$string['selectquestiontype'] = '-- প্রশ্নের ধরণ নির্বাচন --';
$string['serveradded'] = 'সংযুক্ত সার্ভার';
$string['serveridentifier'] = 'শনাক্তকারী';
$string['serverinfo'] = 'সার্ভার তথ্য';
$string['servers'] = 'সার্ভার';
$string['serverurl'] = 'সার্ভারের URL';
$string['settingsoverrides'] = 'সেটিং উপেক্ষা';
$string['shortanswer'] = 'ছোট উত্তর';
$string['show'] = 'প্রদর্শন';
$string['showall'] = 'সব প্রশ্ন এক পৃষ্ঠায় প্রদর্শন';
$string['showblocks'] = 'কুইজে অংশগ্রহনের সময় ব্লক প্রদর্শন';
$string['showblocks_help'] = 'যদি হ্যাঁ নির্ধারণ করা হয় তবে কুইজে অংশগ্রহনের সময় সাধারণ ব্লক প্রদর্শিত হবে';
$string['showbreaks'] = 'পৃষ্ঠা ব্রেক প্রদর্শন';
$string['showcategorycontents'] = 'বিভাগীয় উপকরণ প্রদর্শন {$a->তীর}';
$string['showcorrectanswer'] = 'মন্তব্যে কি সঠিক উত্তর প্রদর্শিত?';
$string['showdetailedmarks'] = 'মানের বিস্তারিত তথ্য প্রদর্শন';
$string['showeachpage'] = 'একই সময়ে একটি পৃষ্ঠা প্রদর্শন';
$string['showfeedback'] = 'উত্তর দেয়ার পর কি মন্তব্য প্রদর্শন করে?';
$string['showinsecurepopup'] = 'অংশগ্রহনের জন্য \'নিরাপদ\' পপআপ উইন্ডো ব্যবহার';
$string['shownoattempts'] = 'যে শিক্ষার্থী অংশগ্রহন করেনি তাদেরকে প্রদর্শন';
$string['shownoattemptsonly'] = 'কেবলমাত্র যেসকল শিক্ষার্থী অংশগ্রহন করেনি তাদেরকে প্রদর্শন';
$string['showteacherattempts'] = 'শিক্ষকদের অংশগ্রহন প্রদর্শন';
$string['showuserpicture'] = 'ব্যবহারকারীর ছবি প্রদর্শন';
$string['showuserpicture_help'] = 'যদি সক্রিয় করা থাকে তবে অংশগ্রহনের সময় পর্দায় শিক্ষার্থীর নাম ও ছবি প্রদর্শন এবং';
$string['shuffle'] = 'এলোমেলো';
$string['shuffleanswers'] = 'উত্তর এলোমেলো';
$string['shuffledrandomly'] = 'এলোমেলোভাবে সাজানো';
$string['shufflequestions'] = 'প্রশ্ন এলোমেলো';
$string['shufflequestionsselected'] = 'প্রশ্ন এলোমেলো করা নির্ধারিত হয়েছে, সুতরাং পৃষ্ঠা সম্পর্কিত কিছু কাজ পাওয়া যায়নি। এলোমেলো করার অপশন পরিবর্তন করতে, {$a}।';
$string['shufflewithin'] = 'প্রশ্নের মধ্যে এলোমেলো';
$string['shufflewithin_help'] = 'যদি সক্রিয় করা হয়, কোনো ছাত্র যতবার কোনো প্রশ্নে অংশগ্রহন করবে ততবার যে যে অংশ নিয়ে প্রশ্ন তৈরি হয় সেসব নিজেদের মধ্যে এলোমেলো হয়ে সজ্জিত হবে, প্রশ্নের সেটিং এ এ অপশন সক্রিয় করা থাকে। যেসব প্রশ্নে একাধিক অংশ রয়েছে, যেমন: বহুনির্বাচনী প্রশ্ন বা ম্যাচিং প্রশ্ন আছে তাদের জন্য এ সেটিং প্রয়োগযোগ্য।';
$string['singleanswer'] = 'উত্তর নির্বাচন';
$string['sortage'] = 'বয়সানুসারে সাজানো';
$string['sortalpha'] = 'নামানুসারে সাজানো';
$string['sortquestionsbyx'] = 'প্রশ্ন সাজানো: {$a}';
$string['sortsubmit'] = 'প্রশ্ন সাজানো';
$string['sorttypealpha'] = 'ধরণানুসারে সাজানো, নাম';
$string['specificapathnotonquestion'] = 'নির্দষ্ট প্রশ্নে নির্দিষ্ট ফাইলের পাথ নাই';
$string['specificquestionnotonquiz'] = 'নির্দষ্ট কুইজে নির্দিষ্ট প্রশ্ন নাই';
$string['startagain'] = 'পুনরায় আরম্ভ';
$string['startedon'] = 'শুরু';
$string['statenotloaded'] = 'প্রশ্ন {$a} এর অবস্থান ডাটাবেস থেকে লোড কার হয়নি';
$string['status'] = 'অবস্থা';
$string['stoponerror'] = 'ত্রুটি হলে থামুন';
$string['submitallandfinish'] = 'সব জমা এবং সমাপ্ত';
$string['subneterror'] = 'দুঃখিত, কুইজ এমনভাবে বন্ধ করে দেয়া হয়েছে যাতে কেবল নির্দিষ্ট কিছু জায়গা এটা থেকে অভিগম্য হবে। বর্তমানে আপনার কম্পিউটার কুইজটি ব্যবহার করার অনুমতিপ্রাপ্ত নয়।';
$string['subnetnotice'] = 'কুইজ এমনভাবে বন্ধ করে দেয়া হয়েছে যাতে কেবল নির্দিষ্ট কিছু জায়গা এটা থেকে অভিগম্য হবে। বর্তমানে আপনার কম্পিউটার সাবনেট হিসাবে অনুমতিপ্রাপ্ত নয়। শিক্ষক হিসাবে আপনি যেকোনোভাবে প্রাকদর্শন করার জন্য অনুমতিপ্রাপ্ত।';
$string['substitutedby'] = 'প্রতিস্থাপিত হবে';
$string['summaryofattempt'] = 'চেষ্টার সারাংশ';
$string['summaryofattempts'] = 'পূর্ববর্তী চারটি চেষ্টার সারাংশ';
$string['temporaryblocked'] = 'কুইজ পুনরায় অংশগ্রহন করতে আপনি অস্থায়ীভাবে অনুমতিপ্রাপ্ত নন।<br /> আপনি আবার অংশগ্রহন করতে পারবেন:';
$string['time'] = 'সময়';
$string['timecompleted'] = 'সম্পন্ন';
$string['timedelay'] = 'আপনি এ কুইজে অংশ নিতে পারবেন না কারণ আরেকটি কুইজে অংশগ্রহন করার আগে যে সময় অপেক্ষা করতে হয় তা আপনি করেন নি';
$string['timeleft'] = 'অবশিষ্ট সময়';
$string['timelimit'] = 'সময় সীমা';
$string['timelimitexeeded'] = 'দুঃখিত! কুইজের সময়সীমা শেষ!';
$string['timelimitmin'] = 'সময় সীমা (মিনিট)';
$string['timelimitsec'] = 'সময় সীমা (সেকেন্ড)';
$string['timestr'] = '%d/%m/%y এর %H:%M:%S';
$string['timesup'] = 'সময় শেষ';
$string['timetaken'] = 'গৃহীত সময়';
$string['tofile'] = 'ফাইলে';
$string['tolerance'] = 'টলারেন্স';
$string['toomanyrandom'] = 'বিভাগে যা আছে তার চেয়ে বেশিসংখ্যক এলোমেলো প্রশ্ন থাকা আবশ্যক!';
$string['top'] = 'শীর্ষ';
$string['totalquestionsinrandomqcategory'] = 'বিভাগে সর্বমোট {$a} প্রশ্ন';
$string['true'] = 'সত্য';
$string['truefalse'] = 'সত্য/মিথ্যা';
$string['type'] = 'ধরণ';
$string['unfinished'] = 'খোলা';
$string['ungraded'] = 'গ্রেডকৃত নয়';
$string['unit'] = 'একক';
$string['unknowntype'] = '{$a} লাইনে প্রশ্নের ধরণ সমর্থিত নয়। প্রশ্ন উপেক্ষা করা হবে';
$string['unusedcategorydeleted'] = 'বিভাগটি অপসারন করা হয়েছে কারণ, কোর্স অপসারন করার পর প্রশ্নটি আর ব্যবহৃত হয়নি।';
$string['updatesettings'] = 'কুইজ সেটিং হালনাগাদ';
$string['upgradesure'] = '<div>আলাদাভাবে কুইজ মডিউল কুইজ টেবিলে একটি সাংঘাতিক পরিবর্তন আনবে এবং এ আপগ্রেড এখনও যথার্থভাবে পরীক্ষা করা হয়নি। প্রক্রিয়াটি চালানের আগে আপনাকে অবশ্যই ডাটাবেস টেবিলের ব্যাকআপ রেখে দিতে হবে।</div>';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'এ বিভাগ সংরক্ষন করা হয়েছে এবং সাইট লেবেলে স্থানান্তর করা হয়েছে কারণ অন্যান্য কোর্সে এখন পর্যন্ত ব্যবহৃত এটা একটি প্রকাশিত বিভাগ।';
$string['useroverrides'] = 'ব্যবহারকারী উপেক্ষা';
$string['usersnone'] = 'কোনো শিক্ষার্থীর এ কুইজে প্রবেশাধিকার নাই';
$string['validate'] = 'বৈধতা যাচাই';
$string['viewallanswers'] = '{$a} কুইজে অংশগ্রহন প্রদর্শন';
$string['viewallreports'] = '{$a} অংশগ্রহনের জন্য রিপোর্ট প্রদর্শন';
$string['warningmissingtype'] = '<b>এ প্রশ্নের ধরন এখনও মুডলে ইনস্টল করা হয়নি।<br />অনুগ্রহ করে মুডল ব্যবস্তাপককে সতর্ক করে দিন।</b>';
$string['wheregrade'] = 'আমার গ্রেড কোথায়?';
$string['wildcard'] = 'ওয়াইল্ড কার্ড';
$string['windowclosing'] = 'উইন্ডো খুব দ্রুত বন্ধ হয়ে যাবে।';
$string['withsummary'] = 'পরিসংখ্যানের সারাংশসহ';
$string['wronguse'] = 'আপনি এ পৃষ্ঠা এভাবে ব্যবহার করতে পারেন না';
$string['xhtml'] = 'XHTML বিন্যাস';
$string['youneedtoenrol'] = 'এ কুইজে অংশগ্রহন করার পূর্বে কোর্সটি তলিকাভুক্ত করে নিতে হবে';
$string['yourfinalgradeis'] = 'কুইজের সর্বশেষ গ্রেড {$a}।';
