<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'প্রবেশাধিকার কন্ট্রোল';
$string['actionaftercorrectanswer'] = 'সঠিক উত্তরের পর করনীয়';
$string['actionaftercorrectanswer_help'] = 'সঠিক উত্তর দেয়ার পর, নিচের পৃষ্ঠার জন্য তিনটি অপশন রয়েছে:

* সাধারন - পাঠ পাথ অনুসরন করে
* একটি অদেখা পৃষ্ঠা প্রদর্শন - কোনো পৃষ্ঠা দ্বিতীয়বার প্রদর্শন না করে ক্রমহীনভাবে পৃষ্ঠাগুলো প্রদর্শন
* উত্তর দেয়া হয়নি এমন পৃষ্ঠা প্রদর্শন - ক্রমহীনভাবে পৃষ্ঠাগুলো প্রদর্শন করা হয়েছে, যে যে পৃষ্ঠায় প্রশ্নের উত্তর দেয়া হয়নি সেগুলো পুনরায় প্রদর্শন করা হয়েছে।';
$string['actions'] = 'কাজ';
$string['activitylink_help'] = 'পাঠের শেষে কোর্সের অন্য একটি কার্যকরন সম্পর্কিত লিংকের দেয়ার জন্য ড্রপডাউন তালিকা থেকে কার্যকরনটি নির্বাচন।';
$string['activitylinkname'] = '{$a} এ যান';
$string['addabranchtable'] = 'একটি ব্রাঞ্চ টেবিল যোগ';
$string['addanendofbranch'] = 'ব্রাঞ্চে সমাপ্তি যোগ';
$string['addanewpage'] = 'নতুন পৃষ্ঠা যোগ';
$string['addaquestionpage'] = 'প্রশ্নের একটি পৃষ্ঠা যোগ';
$string['addaquestionpagehere'] = 'এখানে একটি প্রশ্নের পৃষ্ঠা যোগ';
$string['addbranchtable'] = 'একটি ব্রাঞ্চ টেবিল যোগ';
$string['addcluster'] = 'একটি গ্রুপ যোগ';
$string['addedabranchtable'] = 'ব্রাঞ্চ টেবিল যোগ';
$string['addedanendofbranch'] = 'ব্রাঞ্চে সমাপ্তি যোগ';
$string['addedaquestionpage'] = 'এখানে একটি প্রশ্নের পৃষ্ঠা যোগ করা হয়েছে';
$string['addedcluster'] = 'একটি গ্রুপ যোগ করা হয়েছে';
$string['addedendofcluster'] = 'গ্রুপে সমাপ্তি যোগ হয়েছে';
$string['addendofcluster'] = 'গ্রুপে সমাপ্তি যোগ';
$string['addpage'] = 'পৃষ্টা যোগ';
$string['anchortitle'] = 'প্রধান কন্টেন্ট শুরু';
$string['and'] = 'এবং';
$string['answer'] = 'উত্তর';
$string['answeredcorrectly'] = 'সঠিক উত্তর দেয়া হয়েছে।';
$string['answersfornumerical'] = 'সংখ্যাবাচক প্রশ্নের উত্তর অবশ্যই সর্বোচ্চ ও সর্বনিম্ন মানের মিলিত জোড় হতে হবে';
$string['arrangebuttonshorizontally'] = 'ব্রাঞ্চ বোতাম অনুভূমিকভাবে সাজানো আছে কি?';
$string['attempt'] = 'প্রচেষ্টা: {$a}';
$string['attempts'] = 'প্রচেষ্টা';
$string['attemptsdeleted'] = 'অপসারিত প্রচেষ্টা';
$string['attemptsremaining'] = 'আপনার আর {$a} সংখ্যক প্রচেষ্টা অবশিষ্ট আছে';
$string['available'] = 'বিদ্যমান';
$string['averagescore'] = 'গড় স্কোর';
$string['averagetime'] = 'গড় সময়';
$string['branch'] = 'ব্রাঞ্চ';
$string['branchtable'] = 'ব্রাঞ্চ টেবিল';
$string['cancel'] = 'বাতিল';
$string['cannotfindanswer'] = 'ত্রুটি: উত্তর পাওয়া যাচ্ছে';
$string['cannotfindattempt'] = 'ত্রুটি: প্রচেষ্টা খুঁজে পাওয়া যাচ্ছেনা';
$string['cannotfindessay'] = 'ত্রুটি: বর্ণনা খুঁজে পাওয়া যাচ্ছে না';
$string['cannotfindfirstgrade'] = 'ত্রুটি: গ্রেড খুঁজে পাওয়া যাচ্ছে না';
$string['cannotfindfirstpage'] = 'প্রথম পৃষ্ঠা খুঁজে পাওয়া যাচ্ছে না';
$string['cannotfindgrade'] = 'ত্রুটি: গ্রেড খুঁজে পাওয়া যাচ্ছে না';
$string['cannotfindnewestgrade'] = 'ত্রুটি: নতুন গ্রেড খুঁজে পাওয়া যাচ্ছে না';
$string['cannotfindnextpage'] = 'পাঠ ব্যাকআপ: পরবর্তী পৃষ্ঠা পাওয়া যায়নি!';
$string['cannotfindpagerecord'] = 'ব্রাঞ্চে সমাপ্তি যোগ: পৃষ্ঠা রেকর্ড পাওয়া যায়নি';
$string['cannotfindpages'] = 'পাঠ পৃষ্ঠা পাওয়া যায়নি';
$string['cannotfindpagetitle'] = 'নিশ্চিতভাবে অপসারণ: পৃষ্ঠা শিরোনাম পাওয়া যায়নি';
$string['cannotfindpreattempt'] = 'পূর্ববর্তী প্রচেষ্টার রেকর্ড পাওয়া যায়নি!';
$string['cannotfindrecords'] = 'ত্রুটি: পাঠ রেকর্ড পাওয়া যায়নি';
$string['cannotfindtimer'] = 'ত্রুটি: lesson_timer রেকর্ড খুঁজে পাওয়া যায়নি';
$string['cannotfinduser'] = 'ত্রুটি: ব্যবহারকারী খুঁজে পাওয়া যায়নি';
$string['canretake'] = '{$a} পুনরায় করা যেতে পারে';
$string['casesensitive'] = 'স্বাভাবিক মতামত ব্যবহার';
$string['casesensitive_help'] = 'কি ধরনের সাড়া পাওয়া গেছে তা পরীক্ষা করে সাধারন মতামত দেয়ার জন্য চেকবক্সে টিক দিন।';
$string['checkbranchtable'] = 'ব্রাঞ্চ টেবিল পরীক্ষা';
$string['checkedthisone'] = 'এটা পরীক্ষিত';
$string['checknavigation'] = 'ন্যাভিগেশন পরীক্ষা';
$string['checkquestion'] = 'প্রশ্ন পরীক্ষা';
$string['classstats'] = 'ক্লাস পরিসংখ্যান';
$string['clicktodownload'] = 'ফাইলটি পরীক্ষা করার জন্য নিচের লিংকটিতে ক্লিক।';
$string['clicktopost'] = 'উচ্চ স্কোরের তালিকায় আপনার গ্রেড প্রকাশ করার জন্য এখানে ক্লিক।';
$string['cluster'] = 'গ্রপ';
$string['clusterjump'] = 'গ্রুপের মধ্যে অদেখা প্রশ্ন';
$string['clustertitle'] = 'গ্রুপ';
$string['collapsed'] = 'ভেঙে পড়েছিল';
$string['comments'] = 'আপনার মন্তব্য';
$string['completed'] = 'সম্পন্ন';
$string['completederror'] = 'পাঠ সম্পন্ন';
$string['completethefollowingconditions'] = 'সামনে অগ্রসর হওয়ার পূর্বে অবশ্যই <b>{$a}</b> পাঠের নিম্নোক্ত শর্তগুলো পালন করতে হবে।';
$string['conditionsfordependency'] = 'ডিপন্ডেনসির জন্য নিম্নোক্ত শর্ত';
$string['configactionaftercorrectanswer'] = 'একটি সঠিক উত্তরের পর পূর্বনির্ধারিত করনীয়';
$string['configmaxanswers'] = 'প্রতি পৃষ্ঠায় উত্তর/ব্রাঞ্চের জন্য পূর্বনির্ধারিত সর্বোচ্চ নাম্বার';
$string['configmaxhighscores'] = 'প্রদর্শিত সর্বোচ্চ স্কোরের নাম্বার';
$string['configmediaclose'] = 'সংযুক্ত মিডিয়া ফাইলের জন্য তৈরি করা পপআপের অংশ হিসাবে বন্ধ করার বোতাম প্রদর্শিত হয়';
$string['configmediaheight'] = 'সংযুক্ত মিডিয়া ফাইলের জন্য প্রদর্শিত পপআপের উচ্চতা নির্দিষ্ট করে';
$string['configmediawidth'] = 'সংযুক্ত মিডিয়া ফাইলের জন্য প্রদর্শিত পপআপের প্রস্থ নির্দিষ্ট করে';
$string['configslideshowbgcolor'] = 'স্লাইডশো এর পটভূমির রং, যদি তা সক্রিয় করা থাকে';
$string['configslideshowheight'] = 'স্লাইডশো এর পটভূমির উচ্চতা, যদি তা সক্রিয় করা থাকে';
$string['configslideshowwidth'] = 'স্লাইডশো এর পটভূমির প্রস্থ, যদি তা সক্রিয় করা থাকে';
$string['confirmdelete'] = 'পৃষ্ঠা অপসারণ';
$string['confirmdeletionofthispage'] = 'পৃষ্ঠার অপসারণ নিশ্চিতকরণ';
$string['congratulations'] = 'অভিনন্দন - পাঠ শেষ';
$string['continue'] = 'চালিয়ে যান';
$string['continuetoanswer'] = 'উত্তর পরিবর্তন করতে থাকেন।';
$string['correctanswerjump'] = 'সঠিক উত্তরের অবস্থান পরিবর্তন';
$string['correctanswerscore'] = 'সঠিক উত্তরের স্কোর';
$string['correctresponse'] = 'সঠিক সাড়া';
$string['credit'] = 'আমানত';
$string['customscoring'] = 'স্বনির্ধারিত স্কোর';
$string['customscoring_help'] = 'যদি সক্রিয় করা থাকে, তবে প্রত্যেক উত্তরে সংখ্যাবাচক পয়েন্ট মান থাকতে পারে (ধনাত্মক বা ঋনাত্মক)';
$string['deadline'] = 'ডেডলাইন';
$string['deleteallattempts'] = 'সকল পাঠ প্রচেষ্টা অপসারন';
$string['deletedefaults'] = 'পূর্বনির্ধারিত {$a} x পাঠ অপসারন করা হয়েছে';
$string['deletedpage'] = 'পৃষ্ঠা অপসারন করা হয়েছে';
$string['deleting'] = 'অপসারন করা হচ্ছে';
$string['deletingpage'] = 'পৃষ্ঠা অপসারন করা হচ্ছে: {$a}';
$string['dependencyon'] = 'নির্ভরশীল';
$string['dependencyon_help'] = 'একই কোর্স অন্যান্য পাঠে ছাত্র কেমন করেছে তার উপর নির্ভর করে এই পাঠ নিতে পারার ব্যাপারটি এই সেটিং নির্ধারণ করে। অতিবাহিত সময়, সম্পন্ন করা আছে কিনা অথবা "এর চেয়ে ভাল গ্রেড" ইত্যাদির সমন্বয় ব্যবহার করা যেতে পারে।';
$string['description'] = 'বর্ণনা';
$string['detailedstats'] = 'বিস্তৃত পরিসংখ্যান';
$string['didnotanswerquestion'] = 'এই প্রশ্নের উত্তর দিবেন না।';
$string['didnotreceivecredit'] = 'আমানত গ্রহন করবেন না';
$string['displaydefaultfeedback_help'] = 'যখন কার্যকর থাকে তখন কোনো প্রশ্নের পক্ষে সাড়া না পাওয়া গেলে, "এটা সঠিক উত্তর" বা "এটা ভুল উত্তর" এই পূর্বনির্ধারিত সাড়া প্রদর্শন করা হবে।';
$string['displayhighscores'] = 'উচ্চ স্কোর প্রদর্শন';
$string['displayinleftmenu'] = 'বাম মেনুতে প্রদর্শন';
$string['displayleftif_help'] = 'বাম মেনু দেখতে কেনো ছাত্রকে কোনো নির্দিষ্ট গ্রেড পেতে হবে কিনা তা এই সেটিং এর সাহায্যে নির্ধারণ করা যায়। এর ফলে ছাত্ররা প্রথমবারেরই পুরো পাঠ পড়ে ফেলতে কিছুটা বাধ্য হয়, পরে কাংঙ্ক্ষিত গ্রেড নিয়ে তারা বাম মেনু দেখতে পারে।';
$string['displayleftmenu'] = 'বাম মেনু প্রদর্শন';
$string['displayleftmenu_help'] = 'সক্রিয় করা হলে পৃষ্ঠার তালিকা (ব্রাঞ্চ টেবিল) প্রদর্শ করে';
$string['displayofgrade'] = 'গ্রেড প্রদর্শন (শুধুমাত্র ছাত্রদের জন্য)';
$string['displayreview'] = 'একটি প্রশ্ন আবার চেষ্টা করার সুযোগ দেয়';
$string['displayreview_help'] = 'যদি কার্যকর থাকে তবে ছাত্ররা একবার ভুল উত্তর দেয়ার পর আবার সঠিক উত্তর দেয়ার অপশন পায় কিন্তু তার জন্য কোনো ক্রেডিট পাবে না, অথবা পাঠ চালিয়েও যেতে পারে।';
$string['displayscorewithessays'] = 'স্বয়ংক্রিভাবে গ্রেডকৃত প্রশ্নের জন্য {$a->tempmaxgrade} এর মধ্যে {$a->score} পেয়েছেন। আপনার {$a->রচনামূলকপ্রশ্ন} নমুনা প্রশ্নের জন্যও গ্রেড দেয়া হবে এবং পরবর্তী তারিখে আপনার ফাইনাল স্কোর এর সাথে যোগ<br />করে দেয়া হবে।<br /><br /> নমুনা প্রশ্ন ছাড়া {$a->grade} এর মধ্যে আপনার বর্তমান গ্রেড {$a->score}';
$string['displayscorewithoutessays'] = 'আপনার স্কোর {$a->score}({$a->grade}এর মধ্যে)';
$string['edit'] = 'সম্পাদনা';
$string['editingquestionpage'] = 'প্রশ্নের পৃষ্ঠা {$a} সম্পাদনা করা হচ্ছে';
$string['editlessonsettings'] = 'পাঠ সেটিং সম্পাদনা করা হচ্ছে';
$string['editpage'] = 'পৃষ্ঠার বিষয়বস্তু সম্পাদনা করা হচ্ছে';
$string['editpagecontent'] = 'পৃষ্ঠার বিষয়বস্তু সম্পাদনা করা হচ্ছে';
$string['email'] = 'ইমেইল';
$string['emailallgradedessays'] = 'সকল গ্রেড দেয়া বর্ণনা ইমেইল';
$string['emailgradedessays'] = 'গ্রেড দেয়া বর্ণনা ইমেইল';
$string['emailsuccess'] = 'ইমেইল সফলভাবে প্রেরণ করা হয়েছে';
$string['endofbranch'] = 'ব্রাঞ্চের সমাপ্তি';
$string['endofcluster'] = 'গ্রুপের সমাপ্তি';
$string['endofclustertitle'] = 'গ্রুপের সমাপ্তি';
$string['endoflesson'] = 'পাঠের সমাপ্তি';
$string['enteredthis'] = 'এটা দেয়া হয়েছে';
$string['entername'] = 'উচ্চ স্কোরের তালিকার একটি ডাকনাম দিন';
$string['enterpassword'] = 'অনুগ্রহ করে পাসওয়ার্ড দিন';
$string['eolstudentoutoftime'] = 'দৃষ্টি আকর্ষণ: এই পাঠের জন্য আপনার সময় শেষ। যদি সময় শেষ হওয়ার পর আপনি শেষ উত্তরটি দিয়ে থাকেন তবে সেটা গণনা করা নাও হতে পারে।';
$string['eolstudentoutoftimenoanswers'] = 'আপনি কোনো প্রশ্নের উত্তর দেননি। এই পাঠে আপনি ০ পেয়েছেন।';
$string['essay'] = 'বর্ণনা';
$string['essayemailmessage'] = '<p>নমুনা প্রম্পট:<blockquote>{$a->question}</blockquote></p><p>আপনার উত্তর:<blockquote><em>{$a->response}</em></blockquote></p><p>{$a->teacher}\'s comments:<blockquote><em>{$a->comment}</em></blockquote></p><p>আপনি নমুনা প্রশ্নের জন্য {$a->outof} এর মধ্যে {$a->earned} পেয়েছেন</p><p>পাঠের জন্য আপনার পরিবর্তিত গ্রেড {$a->newgrade}&#37;.</p>';
$string['essayemailmessage2'] = '<p>নতুন প্রম্পট:<blockquote>{$a->question}</blockquote></p><p>আপনার উত্তর:<blockquote><em>{$a->response}</em></blockquote></p><p>গ্রেডারের মন্তব্য<blockquote><em>{$a->comment}</em></blockquote></p><p>আপনি নমুনা প্রশ্নের জন্য {$a->outof} এর মধ্যে {$a->earned} পেয়েছেন।</p><p>পাঠের জন্য আপনার গ্রেড পরিবর্তন করে {$a->newgrade}&#37; করা হয়েছে।</p>';
$string['essayemailsubject'] = '{$a} প্রশ্নের জন্য আপনার গ্রেড';
$string['essays'] = 'বর্ণনা';
$string['essayscore'] = 'স্কোর বর্ণনা';
$string['fileformat'] = 'ফাইল ফরম্যাট';
$string['firstanswershould'] = 'প্রথম উত্তরটি "সঠিক" পৃষ্ঠায় চলে যাওয়া উচিত';
$string['firstwrong'] = 'দূর্ভাগ্যবশত এই পয়েন্টটি পাবেন না, কারণ আপনার উত্তরটি সঠিক ছিল না। আপনি কি শেখার আনন্দ বোঝার জন্য অনুমান করে সঠিক উত্তর দিতে চান (কিন্তুু কোনো ক্রেডিট পয়েন্ট পাবেন না)?';
$string['flowcontrol'] = 'ধারা কন্ট্রোল';
$string['full'] = 'প্রসারিত';
$string['general'] = 'সাধারণ';
$string['grade'] = 'গ্রেড';
$string['gradebetterthan'] = '(&#37;) এর চেয়ে ভাল গ্রেড';
$string['gradebetterthanerror'] = 'শতকরা {$a}  এর চেয়ে ভাল গ্রেড অর্জন';
$string['gradeessay'] = 'নমুনা প্রশ্নের গ্রেড দিন ({$a->notgradedcount}গ্রেড দেয়া হয়নি এবং {$a->notsentcount} প্রেরণ করা হয়নি)';
$string['gradeis'] = '{$a} গ্রেড';
$string['gradeoptions'] = 'গ্রেড অপশন';
$string['handlingofretakes'] = 'পুনরায় চেষ্টা পরিচালনা';
$string['handlingofretakes_help'] = 'পুনারায় চেষ্টা করা যদি অনুমদিত হয়, তবে পাঠের জন্য দেয়া গ্রেড সবগুলো চেষ্টার গড় মান হবপ নাকি সর্বোচ্চ মান হবে তা এই সেটিং এর সাহায্যে নির্ধারণ করা যায়।';
$string['havenotgradedyet'] = 'এখনও গ্রেড দেয়া হয়নি।';
$string['here'] = 'এখানে';
$string['highscore'] = 'উচ্চ স্কোর';
$string['highscores'] = 'উচ্চ স্কোর';
$string['hightime'] = 'উপযুক্ত সময়';
$string['importcount'] = '{$a} প্রশ্ন ইম্পোর্ট করা হচ্ছে';
$string['importquestions'] = 'প্রশ্ন ইম্পোর্ট করা হচ্ছে';
$string['importquestions_help'] = 'এই বৈশিষ্ট্য প্রশ্নকে বিভিন্ন বিন্যাসে নিয়ে টেক্সট ফাইল হিসাবে ইম্পোর্ট করতে পারে।';
$string['insertedpage'] = 'সন্নিবিষ্ট পৃষ্ঠা';
$string['invalidfile'] = 'অকার্যকর ফাইল';
$string['invalidid'] = 'কোনো কোর্স মুডল আইডি বা পাঠ আইডি পাশ হয়নি';
$string['invalidlessonid'] = 'পাঠ আইডি ভুল';
$string['invalidpageid'] = 'অকার্যকর পৃষ্ঠা আইডি';
$string['jump'] = 'অবস্থান পরিবর্তন';
$string['jumps'] = 'অবস্থান পরিবর্তন';
$string['jumps_help'] = 'প্রতিটি উত্তর (প্রশ্নের জন্য) বা বর্ণনা (ব্রাঞ্চ পৃষ্ঠার জন্য) একটি অবস্থান পরিবর্তনের পরিমাণ থাকে। এই পরিমান আপেক্ষিক, যেমন এই পৃষ্ঠা বা পরের পৃষ্ঠা অথবা পাঠের আলাদা যেকোনো পৃষ্ঠাকে নির্দেশ করে।';
$string['jumpsto'] = '<em>{$a}</em> এ যান';
$string['leftduringtimed'] = 'সময়নানুসারে পাঠ চলার সময় আপনি বের হয়ে গিয়েছিলেন।<br />অনুগ্রহ করে পুনরায় পাঠ শুরু করার জন্য ক্লিক।';
$string['leftduringtimednoretake'] = 'সময়নানুসারে পাঠ চলার সময় আপনি বের হয়ে গিয়েছিলেন এবং আপনি আর <br />পুনরায় পাঠ শুরু করতে বা চালিয়ে যেতে পারবেন না।';
$string['lessonattempted'] = 'পাঠ শুরু করার চেষ্টা করা হয়েছিল';
$string['lessonclosed'] = '{$a} এ পাঠ শেষ হয়ে যায়।';
$string['lessoncloses'] = 'পাঠ বন্ধ করে দেয়া হয়েছে';
$string['lessoncloseson'] = '{$a} এ পাঠ বন্ধ হয়';
$string['lesson:edit'] = 'পাঠ কার্যক্রম সম্পাদনা';
$string['lessonformating'] = 'পাঠ বিন্যাস করা হচ্ছে';
$string['lesson:manage'] = 'পাঠ কার্যক্রম ব্যবস্থাপনা করা হচ্ছে';
$string['lessonmenu'] = 'পাঠ মেনু';
$string['lessonnotready'] = 'এই পাঠটি শুরু করার সময় হয়নি। অনুগ্রহ করে আপনার {$a} তে যোগাযোগ।';
$string['lessonnotready2'] = 'এই পাঠটি শুরু করার সময় হয়নি।';
$string['lessonopen'] = '{$a} এ পাঠ চালু হবে।';
$string['lessonopens'] = 'পাঠ চালু আছে';
$string['lessonpagelinkingbroken'] = 'প্রথম পৃষ্ঠা পাওয়া যায়নি। পাঠ পৃষ্ঠার সাথে যে যোগাযোগ নষ্ট হয়ে যাবে। অনুগ্রহ করে প্রশাসনের সাথে যোগাযোগ।';
$string['lessonstats'] = 'পাঠ পরিসংখ্যান';
$string['linkedmedia'] = 'সংযুক্ত মিডিয়া';
$string['loginfail'] = 'লগইন ব্যর্থ হয়েছে, অনুগ্রহ করে পরে চেষ্টা...';
$string['lowscore'] = 'নিম্ন স্কোর';
$string['lowtime'] = 'অনুপযুক্ত সময়';
$string['manualgrading'] = 'গ্রেড বর্ণনা';
$string['matchesanswer'] = 'উত্তরের সাথে মিল';
$string['matching'] = 'তুলনীয়';
$string['matchingpair'] = 'তুলনীয় জোড় {$a}';
$string['maxgrade'] = 'সর্বোচ্চ গ্রেড';
$string['maxgrade_help'] = 'পাঠের জন্য সর্বোচ্চ গ্রেড এই সেটিং নির্ধারণ করে। গ্রেড যদি ০ নির্ধারিত হয় তবে তা গ্রেড পৃষ্ঠায় পাতায় আসবে না।';
$string['maxhighscores'] = 'উচ্চ স্কোরের নাম্বার প্রদর্শন করা আছে';
$string['maximumnumberofanswersbranches'] = 'উত্তর/ব্রাঞ্চ এর সর্বোচ্চ নাম্বার';
$string['maximumnumberofanswersbranches_help'] = 'এই সেটিং উত্তর/ব্রাঞ্চ এর সর্বোচ্চ সংখ্যা যা পাঠে ব্যবহার করা যাবে তা নির্ধারণ করে। যদি প্রশ্নগুলো কেবল সত্য/মিথ্যা হয়ে থাকে তবে একে ২ এ নির্ধারণ করা যায়। যেকোনো সময় সেটিং পরিবর্তন করা যাবে, কারণ তথ্য নয় শিক্ষক কি দেখছেন তাই প্রভাব করবে।';
$string['maximumnumberofattempts'] = 'কতবার চেষ্টা করা হয়েছিল তার সংখ্যা';
$string['maximumnumberofattempts_help'] = 'এ সেটিং এর সাহায্যে একটি প্রশ্নের জন্য আপনি সর্বোচ্চ কতবার চেষ্টা করতে পারবেন তা নির্ধারণ করা যায়। বার বার ভুল উত্তর দিতে থাকলে, যখন সর্বোচ্চ সংখ্যকবার ভুল উত্তর দেয়া হয়ে যাবে তখন পরবর্তী পৃষ্ঠা প্রদর্শিত হবে।';
$string['maximumnumberofattemptsreached'] = 'সর্বোচ্চ সংখ্যক চেষ্টা করা হয়ে গিয়েছে - পরের পৃষ্ঠঅয় যান';
$string['maxtime'] = 'সময় সীমা (মিনিট)';
$string['maxtimewarning'] = 'পাঠ শেষ করতে আপনার আর {$a} মিনিট সময় আছে।';
$string['mediaclose'] = '"বন্ধ করা" বোতাম প্রদর্শন:';
$string['mediafile_help'] = 'পাঠের শুরুতেই উইন্ডোতে পপ-আপ সংযুক্ত করার ক্ষেত্রে প্রদর্শনের জন্য যথাযথ ফাইল নির্বাচন। যদি প্রয়োজন হয় তবে পপ-আপ পুনরায় খোলার জন্য প্রতি পাঠ পৃষ্ঠায় একটি লিংক সংযুক্ত করা থাকে।';
$string['mediafilepopup'] = 'দেখার জন্য এখানে ক্লিক';
$string['mediaheight'] = 'উইন্ডোর উচ্চতা পপআপ';
$string['mediawidth'] = 'উইন্ডোর প্রস্থ পপআপ';
$string['minimumnumberofquestions'] = 'প্রশ্নের সর্বনিম্ন সংখ্যা';
$string['minimumnumberofquestions_help'] = 'এই সেটিং এর সাহায্যে গ্রেডের হিসাব করতে নূন্যতম কতগুলো প্রশ্ন ব্যবহার করা হবে তা নির্দিষ্ট করা হয়। পাঠে যদি এক বা একাধিক ব্রাঞ্চ টেবিল থাকে  তবে প্রশ্নের নূন্যতম সংখ্যা  শূন্যতে নির্ধারণ করতে হবে।

যদি নূন্যতম প্রশ্নের সংখ্যা ২০  নির্ধারণ করা হয় তবে, নিম্নোক্ত টেক্সটটি প্রথম পৃষ্ঠাতেই যোগ করে দেয়ার পরামর্শ দেয়া হচ্ছে: " এই পাঠে আপনি নূন্যতম ২০ টি প্রশ্নের উত্তর দিবেন বলে আশা করা হচ্ছে। আপনি ইচ্ছা করলে আরও বেশি সংখ্যক প্রশ্নের উত্তরও দিতে পারেন। তদুপুরি, আপনি যদি ২০ টির কম প্রশ্নেরও উত্তর দেন তবুও ২০টি প্রশ্নের হিসাবেই আপনার গ্রেড গণনা করা হবে।';
$string['missingname'] = 'ডাকনাম দিন';
$string['modattempts'] = 'শিক্ষার্থীদের বিভিউ করার অনুমোদন দিন';
$string['modattempts_help'] = 'যদি সক্রিয় করা থাকে তবে ছাত্ররা শুরু থেকে পাঠ ন্যাভিগেশন করতে পারে।';
$string['modattemptsnoteacher'] = 'ছাত্ররা শুধু ছাত্রদের কাজ রিভিউ করতে পারে।';
$string['modulename'] = 'পাঠ';
$string['modulenameplural'] = 'পাঠ';
$string['move'] = 'পৃষ্ঠা সরানো';
$string['movedpage'] = 'পৃষ্ঠা সরানো';
$string['movepagehere'] = 'পৃষ্ঠা এখানে সরান';
$string['moving'] = 'পৃষ্ঠা সরানো হচ্ছে: {$a}';
$string['multianswer'] = 'একাধিক উত্তর';
$string['multianswer_help'] = 'যে যে উত্তর দেয়া হয়েছে সেখানে যদি একাধিক সঠিক হয় তবে চেকবক্সে টিক দিন।';
$string['multichoice'] = 'একাধিক পছন্দ';
$string['multipleanswer'] = 'একাধিক উত্তর';
$string['nameapproved'] = 'নাম প্রমানিত';
$string['namereject'] = 'দুঃখিত ফিল্টারের করে আপনার নামটি বাদ দেয়া হয়েছে।<br /> অনুগ্রহ করে অন্য নাম দিয়ে চেষ্টা।';
$string['new'] = 'নতুন';
$string['nextpage'] = 'পরবর্তী পৃষ্ঠা';
$string['noattemptrecordsfound'] = 'কোনো ধরনপর চেষ্টার রেকর্ড পাওয়া যায়নি: কোনো গ্রেড দেয়া হয় নেই';
$string['nobranchtablefound'] = 'কোনো ব্রাঞ্চ টেবিল পাওয়া যায়নি';
$string['nocommentyet'] = 'এখন পর্যন্ত কোনো মন্তব্য নেই।';
$string['nocoursemods'] = 'কোনো কার্যক্রম পাওয়া যায়নি';
$string['nocredit'] = 'ক্রেডিট নেই';
$string['nodeadline'] = 'ডেডলাইন নেই';
$string['noessayquestionsfound'] = 'পাঠে কোনো প্রশ্নের বর্ণনা পাওয়া যায়নি।';
$string['nohighscores'] = 'কোনো উচ্চ স্কোর নেই';
$string['nolessonattempts'] = 'এই পাঠে কোনো প্রচেষ্টা চালানো হয়নি।';
$string['nooneansweredcorrectly'] = 'কেউই সঠিক উত্তর দেয়নি।';
$string['nooneansweredthisquestion'] = 'কেউই এই প্রশ্নের উত্তর দেয়নি।';
$string['noonecheckedthis'] = 'কেউ এটা পরীক্ষা করেনি।';
$string['nooneenteredthis'] = 'কেউ এতে প্রবেশ করেনি।';
$string['noonehasanswered'] = 'কোনো পরীক্ষামুলক প্রশ্নের উত্তর এখনও দেয়া হয়নি।';
$string['noretake'] = 'এই পাঠ পুনারায় নেয়ার অনুমতি আপনাকে দেয়া হয়নি।';
$string['normal'] = 'সাধারণ - পাঠের পাথ অনুসরণ';
$string['notcompleted'] = 'সম্পন্ন নয়';
$string['notdefined'] = 'নির্ধারিত নয়';
$string['nothighscore'] = 'আপনি উচ্চ স্কোরের তালিকায় শীর্ষ {$a} স্থান নিতে পারেননি।';
$string['notitle'] = 'শিরোনামহীন';
$string['numberofcorrectanswers'] = 'সঠিক উত্তরের সংখ্যা: {$a}';
$string['numberofcorrectmatches'] = 'সঠিক মিলের সংখ্যা: {$a}';
$string['numberofpagestoshow'] = 'প্রদর্শনীয় পাতার সংখ্যা';
$string['numberofpagestoshow_help'] = 'পাঠ প্রদর্শনীয় পৃষ্ঠার সংখ্যা এই সেটিং এর সাহায্যে নির্দিষ্ট করা যায়। যেসকল পাঠে পৃষ্ঠা এলোমেলোভাবে থাকে সেখানে প্রযোজ্য ("অদেখা পৃষ্টা প্রদর্শন" বা "উত্তর দেয়া হয়নি এমন পৃষ্ঠা প্রদর্শন" এ "সঠিক উত্তর দেয়ার পর করনীয়" নির্ধারণ করা থাকে)। যদি শূন্য নির্ধারণ করা থাকে তবে সবগুলো পৃষ্ঠাই প্রদর্শিত হবে।';
$string['numberofpagesviewed'] = 'উত্তর দেয়া হয়েছে এমন প্রশ্নের সংখ্যা: {$a}';
$string['numberofpagesviewednotice'] = 'উত্তর দেয়া প্রশ্নের সংখ্যা: {$a->nquestions}; (কমপক্ষে {$a->minquestions}প্রশ্নের উত্তর দিতে হবে )';
$string['numerical'] = 'সংখ্যাবাচক';
$string['ongoing'] = 'চলমান স্কোর প্রদর্শন';
$string['ongoingcustom'] = 'আপনি এ পর্যন্ত {$a->currenthigh} পয়েন্টের মধ্যে {$a->score} পয়েন্ট অর্জন করেছেন।';
$string['ongoing_help'] = 'যদি এটা কার্যকর হয়, তবে ছাত্ররা এপর্যন্ত সর্বমোট কত নাম্বারের মধ্যে বর্তমানে কত পেয়েছে তা প্রতি পৃষ্ঠায় প্রদর্শিত হবে।';
$string['ongoingnormal'] = 'আপনি {$a->viewed} এর মধ্যে {$a->correct} উত্তর সঠিক দিয়েছেন।';
$string['onpostperpage'] = 'প্রতি গ্রেডের জন্য একবার করে প্রকাশ করা হবে';
$string['options'] = 'অপশন';
$string['or'] = 'অথবা';
$string['ordered'] = 'ক্রমানুসারে';
$string['other'] = 'অন্যান্য';
$string['outof'] = '{$a} এর মধ্যে';
$string['overview'] = 'সারসংক্ষেপ';
$string['overview_help'] = 'কিছু সংখ্যক পৃষ্ঠা ও ঐচ্ছিক ব্রাঞ্চ টেবিল নিয়েই একট পাঠ তৈরি হয়। একটি পাঠে সাধারনত কিছু বিষয়বস্তু থাকে এবং একটি প্রশ্ন দিয়ে শেষ হয়। প্রশ্নের সাথে উত্তরের সমন্বয়কেই বলা হয় অবস্থান পরিবর্তন। অবস্থান পরিবর্তন আপেক্ষিক হতে পারে, যেমন পাঠের এই পৃষ্ঠা বা পরবর্তী পৃষ্ঠা বা যেকোনো একটি নির্দিষ্ট পৃষ্ঠা হতে পারে। ব্রাঞ্চ টেবিল হল এমন একটি পৃষ্ঠা যেখানে পাঠের অন্যান্য পৃষ্ঠার লিংকের সেট থাকে, যেমন, সূচীপত্র।';
$string['page'] = 'পৃষ্ঠা: {$a}';
$string['pagecontents'] = 'পৃষ্ঠার বিষয়বস্তু';
$string['pages'] = 'পৃষ্ঠা';
$string['pagetitle'] = 'পৃষ্ঠা শিরোনাম';
$string['password'] = 'পাসওয়ার্ড';
$string['passwordprotectedlesson'] = '{$a} পাসাওয়ার্ড দ্বারা সংরক্ষিত একটি পাঠ।';
$string['pleasecheckoneanswer'] = 'অনুগ্রহ করে একটি উত্তর পরীক্ষা করে দেখুন';
$string['pleasecheckoneormoreanswers'] = 'অনুগ্রহ করে এক বা একাধিক উত্তর পরীক্ষা করে দেখুন';
$string['pleaseenteryouranswerinthebox'] = 'অনুগ্রহ করে এ বাক্সে আপনার উত্তর দিন';
$string['pleasematchtheabovepairs'] = 'অনুগ্রহ করে উপরের জোড় দুটি মিলান';
$string['pluginadministration'] = 'পাঠ সম্পর্কিত প্রশাসন';
$string['pluginname'] = 'পাঠ';
$string['pointsearned'] = 'প্রাপ্ত নাম্বার';
$string['postprocesserror'] = 'পোষ্ট প্রক্রিয়করণের সময় ত্রুটি হয়েছে';
$string['postsuccess'] = 'সফলভাবে প্রকাশ করা হয়েছে';
$string['practice'] = 'পাঠ অনুশীলন';
$string['practice_help'] = 'গ্রোডবুকে অনুশীলনের জন্য কোনো পাঠ থাকে না।';
$string['preprocesserror'] = 'পূর্ব প্রক্রিয়াকরনের সময় ত্রুটি হয়েছে';
$string['preview'] = 'প্রাকদর্শন';
$string['previewlesson'] = 'প্রাকদর্শন {$a}';
$string['previouspage'] = 'পূর্ববর্তী পৃষ্ঠা';
$string['processerror'] = 'প্রক্রিয়াকরণের সময় ত্রুটি হয়েছে!';
$string['progressbar'] = 'অগ্রগতি বার';
$string['progressbar_help'] = 'যদি কার্যকর থাকে তবে, পাঠের নিচে একটি বার থাকবে যেখানে কতখানি সম্পন্ন হয়েছে তার তুলনামুলক হার থাকবে।';
$string['progressbarteacherwarning'] = '{$a} এর জন্য কোনো অগ্রগতি বার প্রদর্শন করা হয়নি';
$string['progressbarteacherwarning2'] = 'যেহেতু আপনি পাঠ সম্পাদনা করতে পারেন তাই আপনি অগ্রগতি বার দেখবেন না';
$string['qtype'] = 'পৃষ্ঠার ধরণ';
$string['question'] = 'প্রশ্ন';
$string['questionoption'] = 'প্রশ্ন';
$string['questiontype'] = 'প্রশ্নের ধরণ';
$string['randombranch'] = 'এলোমেলো ব্রাঞ্চ পৃষ্ঠা';
$string['randompageinbranch'] = 'ব্রাঞ্চের মধ্যে এলোমেলো প্রশ্ন';
$string['rank'] = 'স্তর';
$string['rawgrade'] = 'মূল গ্রেড';
$string['receivedcredit'] = 'গৃহীত ক্রেডিট';
$string['redisplaypage'] = 'পৃষ্ঠা পুনরায় প্রদর্শন';
$string['report'] = 'রিপোর্ট';
$string['reports'] = 'রিপোর্ট';
$string['response'] = 'সাড়া';
$string['retakesallowed'] = 'পুনরায় চেষ্টা করতে পারবেন';
$string['retakesallowed_help'] = 'যদি কার্যকর হয় তবে আপনি একই পাঠের জন্য আবার চেষ্টা করতে পারবেন।...';
$string['returnto'] = '{$a} এ ফেরত যান';
$string['returntocourse'] = 'কোর্সে ফিরে যান';
$string['review'] = 'রিভিউ';
$string['reviewlesson'] = 'পাঠ রিভিউ';
$string['reviewquestionback'] = 'হ্যাঁ, আমি আবার চেষ্টা করবো';
$string['reviewquestioncontinue'] = 'না, আমি পরবর্তী প্রশ্নে যেতে চাই';
$string['sanitycheckfailed'] = 'স্যানিটি পরীক্ষা ব্যর্থ: এ চেষ্টা অপসারন করে ফেলা হয়েছে';
$string['savechanges'] = 'পরিবর্তন সংরক্ষণ';
$string['savechangesandeol'] = 'সকাল পরিবর্তন সংরক্ষন করে পাঠের শেষে দেখুন।';
$string['savepage'] = 'পৃষ্ঠা সংরক্ষণ';
$string['score'] = 'স্কোর';
$string['scores'] = 'স্কোর';
$string['secondpluswrong'] = 'পর্যাপ্ত নয়। আপনি কি পুনরায় চেষ্টা করতে চান?';
$string['selectaqtype'] = 'প্রশ্নের একটি ধরন নির্বাচন';
$string['shortanswer'] = 'ছোট উত্তর';
$string['showanunansweredpage'] = 'উত্তর দেয়া হয়নি এমন পৃষ্ঠা প্রদর্শন';
$string['showanunseenpage'] = 'দেকা হয়নি এমন একটি পৃষ্ঠা প্রদর্শন';
$string['singleanswer'] = 'একক উত্তর';
$string['skip'] = 'ন্যাভিগেশন বাদ দিয়ে যান';
$string['slideshow'] = 'স্লাইডশো';
$string['slideshowbgcolor'] = 'স্লাইডশোয়ের পটভূমির রং';
$string['slideshowheight'] = 'স্লাইডশো এর উচ্চতা';
$string['slideshow_help'] = 'যদি কার্যকর হয় তবে স্লাইডশো আকারে পাঠ প্রদর্শিত হবে যার নির্দিষ্ট প্রস্থ ও উচ্চতা থাকবে।';
$string['slideshowwidth'] = 'স্লাইডশো এর প্রস্থ';
$string['startlesson'] = 'প্রারম্ভিক পাঠ';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname}এর প্রচেষ্টার সংখ্যা {$a->attempt}';
$string['studentname'] = '{$a} নাম';
$string['studentoneminwarning'] = 'সতর্কীকরণ: পাঠটি শেষ করার জন্য আপনার কাছে এক মিনিট বা তার চেয়ে কম সময় আছে।...';
$string['studentresponse'] = '{$a} সাড়া';
$string['submitname'] = 'নাম জমা দিন';
$string['teacherjumpwarning'] = 'পাঠে {$a->cluster} বা {$a->unseen} অবস্থান পরিবর্তন ব্যবহার করা হয়েছে। এর পরিবর্তে অবস্থান পরিবর্তন করে পরবর্তী পৃষ্ঠায় যেতে হবে। এই পরিবর্তনগুলো পরীক্ষা করার জন্য ছাত্র হিসাবে লগইন।';
$string['teacherongoingwarning'] = 'চলতি স্কোর কেবলমাত্র ছাত্রদের জন্য প্রদর্শন করা হয়েছে। চলতি স্কোর  পরীক্ষা করে দেখার জন্য ছাত্র হিসাবে লগইন';
$string['teachertimerwarning'] = 'শুধু ছাত্রদের জন্য টাইমার কাজ করে। টাইমার পরীক্ষা করে দেখার জন্য ছাত্র হিসাবে লগইন';
$string['thatsthecorrectanswer'] = 'এটাই সঠিক উত্তর';
$string['thatsthewronganswer'] = 'এটা ভুল উত্তর';
$string['thefollowingpagesjumptothispage'] = 'নিচের পৃষ্ঠাগুলো অবস্থান পরিবর্তন করে এই পৃষ্ঠায় চলে আসে';
$string['thispage'] = 'এই পৃষ্ঠা';
$string['timeremaining'] = 'অবশিষ্ট সময়';
$string['timespenterror'] = 'এই পাঠ কমপক্ষে {$a} মিনিট সময় ব্যায়';
$string['timespentminutes'] = 'অতিবাহিত সময় (মিনিট)';
$string['timetaken'] = 'গৃহীত সময়';
$string['topscorestitle'] = 'শীর্ষ স্কোর {$a}';
$string['truefalse'] = 'সত্য/মিথ্যা';
$string['unabledtosavefile'] = 'আপনার আপলোড করা ফাইল সংরক্ষণ করা যাচ্ছে না';
$string['unknownqtypesnotimported'] = 'যেসকল প্রশ্ন অসমর্থিত প্রশ্নের ধরনের মধ্যে পড়ে সেগুলো {$a} ইম্পোর্ট করা হয়নি';
$string['unseenpageinbranch'] = 'ব্রাঞ্চের মধ্যে অদেখা প্রশ্ন';
$string['unsupportedqtype'] = 'অসমর্থিত প্রশ্নের ধরণ  ({$a})!';
$string['updatedpage'] = 'পৃষ্ঠা আপডেট';
$string['updatefailed'] = 'আপডেট ব্যর্থ';
$string['usemaximum'] = 'সর্বোচ্চ ব্যবহার';
$string['usemean'] = 'গড় ব্যবহার';
$string['usepassword'] = 'পাসওয়ার্ড দ্বারা সংরক্ষিত পাঠ';
$string['usepassword_help'] = 'যদি কার্যকর থাকে তবে পাঠ ব্যবহার করতে পাসওয়ার্ড লাগবে।';
$string['viewgrades'] = 'গ্রেড প্রদর্শন';
$string['viewhighscores'] = 'উচ্চ স্কোরের তালিকা প্রদর্শন';
$string['viewreports'] = '{$a->attempts} সমপন্ন করা {$a->student} প্রচেষ্টা প্রদর্শন';
$string['viewreports2'] = 'সম্পন্ন প্রচেষ্টাগুলো প্রদর্শন {$a}';
$string['welldone'] = 'ভালো হয়েছে!';
$string['whatdofirst'] = 'আপনি প্রথমে কি করতে চান?';
$string['wronganswerjump'] = 'ভুল উত্তরের অবস্থান পরিবর্তন';
$string['wronganswerscore'] = 'ভুল উত্তরের স্কোর';
$string['wrongresponse'] = 'ভুল উত্তর';
$string['xattempts'] = '{$a} প্রচেষ্টা';
$string['youhaveseen'] = 'আপনি ইতিমধ্যে এই পাঠের একাধিক পৃষ্ঠা দেখে ফেলেছেন।<br />আপনি শেষ যে পৃষ্ঠাটি দেখেছেন সেখান থেকে শুরু করতে চান?';
$string['youmadehighscore'] = 'আপনি উচ্চ স্কোরের তালিকায় শীর্ষস্থান অর্জন করেছেন{$a}।';
$string['youranswer'] = 'আপনার উত্তর';
$string['yourcurrentgradeis'] = 'আপনার বর্তমান গ্রেড {$a}';
$string['yourcurrentgradeisoutof'] = '{$a->total} এর মধ্যে আপনার বর্তমান গ্রেড {$a->grade}';
$string['youshouldview'] = 'আপনাকে কমপক্ষে {$a} টি উত্তর দিতে হবে';
