<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'নির্দিষ্ট করা অ্যাডমিন ডিরেক্টরিটি ভুল';
$string['admindirname'] = 'অ্যাডমিন ডিরেক্টরিটি';
$string['admindirsetting'] = 'অল্পসংখ্যক ওয়েবহোস্টিই
    কন্ট্রোল প্যানেল বা এরকম কিছুতে প্রবেশ করার জন্য URL হিসাবে /admin ব্যবহার করে। দূর্ভাগ্যবশত, মুডল অ্যাডমিন পৃষ্ঠার স্ট্যান্ডার্ড লোকেশনের সাথে এটা ঝামেলা করে। আপনি ইন্সটলেশনের সময় অ্যাডমিন ডিরেক্টরির নাম
    পরিবর্তন করে ও সেই জায়গায়
    নতুন নাম বসিয়ে এ সমস্যার সমাধান করতে পারেন। উদাহরণস্বরূপ, <br /> <br /><b>moodleadmin</b><br /> <br />
    এর সাহায্যে মুডল অ্যাডমিন লিংকগুলো ঠিক করা যায়।';
$string['admindirsettinghead'] = 'অ্যাডমিন ডিরেক্টরিটি সেট করা হচ্ছে ...';
$string['admindirsettingsub'] = 'অল্পসংখ্যক ওয়েবহোস্টিই
    কন্ট্রোল প্যানেল বা এরকম কিছুতে প্রবেশ করার জন্য URL হিসাবে /admin ব্যবহার করে। দূর্ভাগ্যবশত, মুডল অ্যাডমিন পৃষ্ঠার স্ট্যান্ডার্ড লোকেশনের সাথে এটা ঝামেলা করে। আপনি ইন্সটলেশনের সময় অ্যাডমিন ডিরেক্টরির নাম
    পরিবর্তন করে ও সেই জায়গায়
    নতুন নাম বসিয়ে এ সমস্যার সমাধান করতে পারেন। উদাহরণস্বরূপ, <br /> <br /><b>moodleadmin</b><br /> <br />
    এর সাহায্যে মুডল অ্যাডমিন লিংকগুলো ঠিক করা যায়।';
$string['availablelangs'] = 'যে সমস্ত ভাষা ব্যাবহার করতে পারেন';
$string['caution'] = 'সতর্কীকরণ';
$string['chooselanguage'] = 'একটি ভাষা নির্বাচন';
$string['chooselanguagehead'] = 'একটি ভাষা নির্বাচন';
$string['chooselanguagesub'] = 'ইনস্টলেশনের জন্য একটি ভাষা নির্বাচন। এই ভাষাই সাইটের জন্য নির্ধারিত ভাষা হিসাবে ব্যবহৃত হবে এবং এটা পরে যেকোনো সময় পরিবর্তন করা হতে পারে।';
$string['cliadminpassword'] = 'অ্যাডমিন ব্যবহারকারীর নতুন পাসওয়ার্ড';
$string['cliadminusername'] = 'অ্যাডমিন অ্যাকাউন্ট ব্যবহারকারীর নাম';
$string['cliinstallfinished'] = 'ইনস্টলেশন সফলভাবে সম্পন্ন হয়েছে।';
$string['cliinstallheader'] = 'মুডল {$a} কমান্ড লাইন ইনস্টলেশন প্রোগ্রাম';
$string['climustagreelicense'] = 'নিস্ক্রিয় মোডে আপনাকে অবশ্যই specifying --agree-license অপশনের সাহায্যে লাইসেন্স করতে সম্মত হতে হবে';
$string['clitablesexist'] = 'ইতিমধ্যেই ডাটাবেস টেবিল বিদ্যমান রয়েছে, cli ইনস্টলেশন চালানো যাচ্ছে না।';
$string['compatibilitysettings'] = 'আপনার PHP সেটিং পরীক্ষা করা হচ্ছে ...';
$string['compatibilitysettingshead'] = 'আপনার PHP সেটিং পরীক্ষা করা হচ্ছে ...';
$string['compatibilitysettingssub'] = 'যথাযথভাবে মুডল চালানোর জন্য আপনার সার্ভারে সবগুলো পরীক্ষা চালাতে হবে';
$string['configfilenotwritten'] = 'মুডল রুট ডিরেক্টরির মধ্যে config.php ফাইলে নিম্নেক্ত কোডটি কপি করতে পারেন।';
$string['configfilewritten'] = 'config.php সফলভাবে তৈরি করা হয়েছে';
$string['configurationcomplete'] = 'কনফিগারেশন সম্পন্ন';
$string['configurationcompletehead'] = 'কনফিগারেশন সম্পন্ন হয়েছে';
$string['configurationcompletesub'] = 'মুডল, মুডল ইনস্টলেশনের রুটে আপনার কনফিগারেশন একটি ফাইলে সংরক্ষণ করার জন্য চেষ্টা চালায়।';
$string['database'] = 'ডাটাবেস';
$string['databasehead'] = 'ডাটাবেস সেটিংস';
$string['databasehost'] = 'ডাটাবেস হোস্ট';
$string['databasename'] = 'ডাটাবেস নাম';
$string['databasepass'] = 'ডাটাবেস পাসওয়ার্ড';
$string['databasesocket'] = 'ইউনিক্স সকেট';
$string['databasetypehead'] = 'ডাটাবেস ড্রাইভার নির্বাচন';
$string['databasetypesub'] = 'মুডল বিভিন্ন ধরণের ডাটাবেস সার্ভার সমর্থন করে। কোন ধরনের সার্ভার ব্যবহার করতে হবে তা বুঝতে না পারলে সার্ভার ব্যবস্থাপকের সাথে যোগাযোগ।';
$string['databaseuser'] = 'ডাটাবেস ব্যবহারকারী';
$string['dataroot'] = 'ডাটাবেস ডিরেক্টরি';
$string['datarooterror'] = 'আপনি যে \'ডাটা ডিরেক্টরি\' নির্দিষ্ট করে দিয়েছেন তা খুঁজে পাওয়া যায়নি বা তৈরিও করা যায়নি। হয় পাথ সংশোধন অথবা নিজহাতে ডিরেক্টরি তৈরি।';
$string['datarootpublicerror'] = 'আপনি যে ডাটা ডিরেক্টরি নির্দিষ্ট করেছেন তা ওয়েব এর সাহায্যে সরাসরি ব্যবহার করা যায়, সেকারণে ভিন্ন একটি ডিরেক্টরি ব্যবহার।';
$string['dbconnectionerror'] = 'নির্দিষ্ট করা ডাটাবেসের সাথে সংযোগ পাচ্ছেন না। অনুগ্রহ করে ডাটাবেস সেটিংস পরীক্ষা করে নিন।';
$string['dbcreationerror'] = 'ডাটাবেস তৈরিতে ত্রুটি রয়েছে। সেটিংস এর সাথে দিয়ে দেয়া ডাটাবেস নামটি তৈরি করা যাচ্ছে না';
$string['dbhost'] = 'হোস্ট সার্ভার';
$string['dbpass'] = 'পাসওয়ার্ড';
$string['dbprefix'] = 'টেবিল প্রেফিক্স';
$string['dbtype'] = 'ধরণ';
$string['directorysettings'] = '<p>মুডল ইনস্টলেশনের স্থান নির্দিষ্ট।</p>

<p><b>ওয়েব ঠিকানা:</b>
মুডলে প্রবেশ করা জন্য সম্পূর্ন ওয়েব ঠিকানা নির্দিষ্ট করে দিন।
যদি ওয়েবসাইটিতে প্রবেশ করার জন্য একাধিক URL থাকে তবে ছাত্রদের ব্যবহারের জন্য
সবচেয়ে সাধারন URL টি নির্বাচন। ট্রেইলিং স্ল্যাশ
যোগ কারা যাবে</p>

<p><b>মুডল ডিরেক্টরি:</b>
ইনস্টলেশনে সম্পূর্ণ পাথ নির্দিষ্ট করে দিন
 উপরের/নিচের অবস্থা ঠিক আছে কিনা তা অবশ্যই নিশ্চিত হয়ে নিতে হবে</p>

<p><b>ডাটা ডিরেক্টরি:</b>
মুডলের আপলোড করা ফাইল রাখার জন্য স্থান দরকার।  ওয়েব সার্ভার ব্যবহারকারী
যাতে অবশ্যই এই ডিরেক্টরি পড়তে ও লিখতে পারে
(সাধরনত \'কেউই না\' অথবা \'আপচি\'), কিন্তু ওয়েবের সাহায্যে যাতে সরাসরি এটা ব্যবহার করা না যায়। পাওয়া না গেলে ইনস্টলার এটা নিজেই তৈরি করে নিবে।</p>';
$string['directorysettingshead'] = 'এই মুডল ইনস্টলেশনের স্থান নিশ্চিত';
$string['directorysettingssub'] = '<b>ওয়েব ঠিকানা:</b>
মুডলে পর্বেশ করার সম্পূর্ন ওয়েব ঠিকানা নির্দিষ্ট করে দিন।
Iওয়েবে ব্যবহার করার জন্য যদি একাধিক URLথাকে তবে ছাত্রদের জন্য সবচেয়ে সাধারনটি নির্বাচন। কোনো ট্টেইলিং স্ল্যাশ যোগ করবেন না।
<br />
<br />
<b>মুডল ডিরেক্টরি:</b>
ইনস্টলেশনের জন্য সম্পূর্ন ডিরেক্টরি পাথ নির্দিষ্ট করে দিন
উপর/ নিচের ব্যাপারগুলো ঠিক আছে কিনা তা নিশ্চিত হয়ে নিন।
<br />
<br />
<b>ডাটা ডিরেক্টরি:</b>
 মুডলের আপলোড করা ফাইল রাখার জন্য স্থান নির্দিষ্ট প্রয়োজন। ওয়েব
ব্যবহারকারীরা যাতে অবশ্যই ডিরেক্টরিটি পড়তে ও লিখতে পারে
(সাধারনত \'কেউই না\' বা \'আপাচি\'), কিন্তু এটা যাতে
সরাসরি ওয়েবের সাহায্যে ব্যবহার করা না যায়। পাওয়া না গেলে ইনস্টলার নিজেই এটা তৈরি করে নেয়াী চেষ্টা করবে।';
$string['dirroot'] = 'মুডল ডিরেক্টরি';
$string['dirrooterror'] = '\'মুডল ডিরেক্টরি\' সেটিংটি ভুল হতে পারে - এখানে আমরা মুডল ইনস্টলেশন খুৃঁজে পাচ্ছিনা। নিচের মান পুনঃনির্ধারণ করা হয়েছে।';
$string['download'] = 'ডাউনলোড';
$string['downloadlanguagebutton'] = '&quot;{$a}&quot; ল্যাঙ্গুইজ প্যাক ডাউনলোড';
$string['downloadlanguagehead'] = 'ল্যাঙ্গুয়েজ প্যাক ডাউনলোড';
$string['downloadlanguagenotneeded'] = 'পূর্বনির্ধারিত ল্যাঙ্গুইজ প্যাক "{$a}" ব্যবহার করে ইনস্টলেশন প্রক্রিয়া চালিয়ে যেতে পারেন।';
$string['downloadlanguagesub'] = 'এখন আপনার ল্যাঙ্গুইজ প্যাক ডাউনলোড করে এই ভাষাতেই ইনস্টলেশন প্রক্রিয়া চালানোর অপশন রয়েছে।<br /><br />আপনি যদি এই ল্যাঙ্গুইজ প্যাক ডাউনলোড করতে না পারেন তবে ইনস্টলেশন প্রক্রিয়া ইংরেজী ভাষাতেই চলবে। (একবার ইনস্টলেশন সম্পন্ন হয়ে গেলে আপনি পরবর্তীতে অতিরিক্ত ল্যাঙ্গুইয়েজ প্যাক ডাউনলোড করে ইনস্টল করার সুযোগ পাবেন।)';
$string['doyouagree'] = 'আপনি কি রাজি ? (হ্যাঁ/না):';
$string['environmenthead'] = 'এনভায়রনমেন্ট পরীক্ষা করা হচ্ছে ...';
$string['environmentsub'] = 'সিস্টেমের বিভিন্ন ধরণের কম্পোনেন্ট আপনার সিস্টেমের প্রয়োজনীয়তা পূর্ণ করে কিনা তা আমরা পরীক্ষা করে দেখছি';
$string['environmentsub2'] = 'প্রত্যেক মুডল রিলিজের  PHP সংস্করণের কিছু নূন্যতম শর্ত এবং কিছু অত্যাবশ্যক PHP এক্সটেনশন রয়েছে।
ইনস্টল ও আপগ্রেডের পূর্বেই সম্পূর্ন এনভায়রনমেন্ট পরীক্ষা করা হয়েছে। নতুন সংস্করনটা ইনস্টল করতে বা PHP এক্সটেনশন সক্রিয় করতে না পারলে অনুগ্রহ করে সার্ভার প্রশাসন এর সাথে যোগাযোগ।';
$string['errorsinenvironment'] = 'এনভায়রনমেন্ট পরীক্ষা ব্যর্থ!';
$string['fail'] = 'ব্যর্থ';
$string['fileuploads'] = 'ফাইল আপলোড';
$string['fileuploadserror'] = 'এটা চালু করা উচিত';
$string['fileuploadshelp'] = '<p>সার্ভারে ফাইল আপলোড নিস্ক্রিয় করা আছে</p>

<p>তারপরও মুডল ইনস্টল করা যাবে কিন্তু এটা ছাড়া আপনি কোর্স ফাইল বা ব্যবহারকারীর প্রোফাইল চিত্র
    আপলোড করা যাবে না।</p>

<p>ফাইল আপলোডিং সক্রিয় করতে আপনাকে (অথবা আপনার সিস্টেম এডমিনিস্ট্রটরকে) আপনার সিস্টেমের প্রধান php.ini ফাইল সম্পাদনা করতে হবে বা
   <b>file_uploads</b> সেটিং পরিবর্তন করে \'1\'।</p>';
$string['inputdatadirectory'] = 'ডাটা ডিরেক্টরি :';
$string['inputwebadress'] = 'ওয়েব ঠিকানা :';
$string['inputwebdirectory'] = 'মুডল ডিরেক্টরি :';
$string['installation'] = 'ইনস্টলেশন';
$string['langdownloaderror'] = 'দূর্ভাগ্যবশত "{$a}" ভাষা  ডাউনলোড করা যাচ্ছে না। ইনস্টলেশন প্রক্রিয়া ইংরেজী ভাষাতেই চলবে।';
$string['langdownloadok'] = '"{$a}" ভাষা সফলভাবে ইনস্টল করা হয়েছে। ইনস্টলেশন প্রক্রিয়া এ ভাষাতেই চলবে।';
$string['magicquotesruntime'] = 'ম্যাজিক কোয়েটস রান টাইম';
$string['magicquotesruntimeerror'] = 'এটা বন্ধ করা উচিত';
$string['magicquotesruntimehelp'] = '<p>মুডলের কাজ ঠিকভাবে চালানোর জন্য ম্যাজিক কোয়েটস রান টাইম বন্ধ করে দেয়া উচিত</p>

<p>সাধারনত পূর্বনির্ধারিতভাবে এটা বন্ধ থাকে ... <b><b>magic_quotes_runtime</b></b> সেটিংটি আপনার php.ini ফাইলে দেখুন।</p>

<p>আপনি যদি php.ini ফাইলে প্রবেশ করতে না পারেন তবে মুডল ডিরেক্টরির
   .htaccess ফাইলে নিম্নোক্ত লাইনটি বসিয়ে দিন:</p>
   <blockquote><div>php_value magic_quotes_runtime Off</div></blockquote>';
$string['memorylimit'] = 'মেমরির সীমা';
$string['memorylimiterror'] = 'PHP এর নির্ধারণ করা মেমরির সীমা খুব কম ... আপনি পরবর্তীতে সমস্যায় পড়তে পারেন।';
$string['memorylimithelp'] = '<p>আপনার সার্ভারের PHP মেমরি সীমা বর্তমানে {$a} এ নির্ধারণ করা হয়েছে।</p>

<p>ফলে মুডলে পরবর্তীতে মেমরি সংক্রান্ত সমস্যা দেখা দিতে পারে, বিশেষ করে অনেকগুলো মুডল সক্রিয় করা থাকলে/বেশিসংখ্যক ব্যবহারকারী থাকলে। </p>

<p>এজন্য আমরা সুপারিশ করি উচ্চসীমার, যেমন ৪০M মেমরি সহ PHP কমপাইল করতে।
   এটা করার অনেকগুলো উপায় রয়েছে:</p>
<ol>
<li>আপনি যদি <i>--enable-memory-limit</i> দ্বারা PHP কমপাইল করতে পারেন তবে।
    ফলে মুডল নিজে মেমরি সীমা নির্ধারণ করে নিবে।</li>
<li>আপনি php.ini ফাইল ব্যবহার করতে পারলে <b>memory_limit</b>
     পরিবর্তন করে ৪০M এর মত করা যেত। আপনি যদি নিজে ব্যবহার করতে না পারেন তবে আপনার অ্যাডমিনিস্ট্রেশন আপনার জন্য এ কাজ করে দিবে।</li>
<li>কিছু PHP সার্ভারে মুডল ডিরেক্টরিতে:
    <blockquote><div>php_value memory_limit 40M</div></blockquote>
  লাইনটিসহ .htaccess ফাইল তৈরি করে নিতে পারেন
    <p>কিছু সার্ভারে <b>সকল</b> PHP পৃষ্ঠা কাজ নাও করতে পারে
    (পৃষ্ঠায় আপনার কিছু ত্রুটি চোখে পড়বে) সুতরাং আপনাকে .htaccess ফাইল অপসারন করতে হবে।</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'MSSQL এক্সটেনশনের সাথে PHP যথাযথভাবে কনফিগার করা হয়নি, তাই এটা SQL*সার্ভারের সাথে যোগাযোগ করতে পারে। অনুগ্রহ করে php.ini ফাইল পরীক্ষা করে দেখুন বা PHP পুনরায় কমপাইল।';
$string['mysqliextensionisnotpresentinphp'] = 'MSSQLi এক্সটেনশনের সাথে PHP যথাযথভাবে কনফিগার করা হয়নি, তাই এটা MySQL সাথে যোগাযোগ করতে পারে। অনুগ্রহ করে php.ini ফাইল পরীক্ষা করে দেখুন বা PHP পুনরায় কমপাইল।  PHP 4 এর জন্য MySQLi এক্সটেনশন পাওয়া যায় না।';
$string['nativemssql'] = 'SQL*সার্ভার মুক্তTDS (স্থানীয়/mssql)';
$string['nativemssqlhelp'] = 'যে ডাটাবেসে বেশিরভাগ মুডল সংরক্ষণ করা হবে, তা কনফিগার করা উচিত।
 ডাটাবেস, এর নাম এবং পাসওয়ার্ড ইতিমধ্যেই তৈরি করা হয়েছে। টেবিল প্রেফিক্স অত্যাবশ্যক।';
$string['nativemysqli'] = 'উন্নত MySQL (স্থানীয়/mysqli)';
$string['nativemysqlihelp'] = 'যে ডাটাবেসে বেশিরভাগ মুডল সংরক্ষণ করা হবে, তা কনফিগার করা উচিত।
 যদি ডাটাবেস ব্যবহারকারীর প্রয়োজনীয় অনুমোদন, ব্যবহারকারীরনাম এবং পাসওয়ার্ড ইতিমধ্যেই থেকে থাকে তবে ডাটাবেসটি তৈরি করা যেতে পারে। টেবিল প্রেফিক্স ঐচ্ছিক।';
$string['nativeoci'] = 'ওরাকল (স্থানীয়/oci)';
$string['nativeocihelp'] = 'যে ডাটাবেসে বেশিরভাগ মুডল সংরক্ষণ করা হবে, তা কনফিগার করা উচিত।
 ডাটাবেস, এর নাম এবং পাসওয়ার্ড ইতিমধ্যেই তৈরি করা হয়েছে। টেবিল প্রেফিক্স অত্যাবশ্যক।';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'যে ডাটাবেসে বেশিরভাগ মুডল সংরক্ষণ করা হবে, তা কনফিগার করা উচিত।
 ডাটাবেস, এর নাম এবং পাসওয়ার্ড ইতিমধ্যেই তৈরি করা হয়েছে। টেবিল প্রেফিক্স অত্যাবশ্যক।';
$string['nativesqlsrv'] = 'SQL*সার্ভার মাইক্রোসফ্ট (স্থানীয়/sqlsrv)';
$string['nativesqlsrvhelp'] = 'যে ডাটাবেসে বেশিরভাগ মুডল সংরক্ষণ করা হবে, তা কনফিগার করা উচিত।
 ডাটাবেস, এর নাম এবং পাসওয়ার্ড ইতিমধ্যেই তৈরি করা হয়েছে। টেবিল প্রেফিক্স অত্যাবশ্যক।';
$string['ociextensionisnotpresentinphp'] = 'OCI8 এক্সটেনশনের সাথে PHP যথাযথভাবে কনফিগার করা হয়নি, তাই ওরাকল সাথে যোগাযোগ করতে পারে। অনুগ্রহ করে php.ini ফাইল পরীক্ষা করে দেখুন বা PHP পুনরায় কমপাইল।';
$string['pass'] = 'অতিক্রম করা';
$string['paths'] = 'পাথ';
$string['pathserrcreatedataroot'] = 'ইনস্টলারের সাহায্যে ডাটা ডিরেক্টরি ({$a->dataroot}) তৈরি করা যায় না';
$string['pathshead'] = 'পাথ নিশ্চিত';
$string['pathsrodataroot'] = 'ডাটারুট ডিরেক্টরি লেখার মত নয়।';
$string['pathsroparentdataroot'] = 'প্যারেন্ট ডিরেক্টরি ({$a->parent}) লেখার যোগ্য নয়। ইনস্টলারের সাহায্যে ডাটা ডিরেক্টরি ({$a->dataroot}) তৈরি করা যায় না।';
$string['pathssubadmindir'] = 'খুব কম সংখ্যক ওয়েবহোস্ট কন্ট্রোল প্যানেল বা এই ধরনের কিছু ব্যবহার করতে /admin কে বিশেষ URL হিসাবে ব্যবহার করে। দূর্ভাগ্যবশত এর সাথে মুডল এডমিন পৃষ্টার স্ট্যান্ডার্ড স্থান নিয়ে ঝামেলা হয়। ইনস্টলেশনে অ্যাডমিন ডিরেক্টরির
নাম পরিবর্তন করে নতুন নাম দিয়ে এ সমস্যার সমাধান করতে পারেন। যেমন: <em>moodleadmin</em>। এর ফলে মডুলে অ্যাডমিনে লিঙ্কগুলো নির্ধারণ করে দিবে।';
$string['pathssubdataroot'] = 'মুডলের ফাইল সংরক্ষণের জন্য জায়গা প্রয়োজন। ওয়েব সার্ভার ব্যবহারকারী
(সাধরনত কেউই না বা apache) যাতে অবশ্যই এই ডিরেক্টরি পড়তে ও লিখতে পারে, কিন্তু যাতে ওয়েবের সাহায্যে এটা সরাসরি ব্যবহার করা না যায়। ডিরেক্টরি না থাকলে, ইনস্টলার এটা তৈরি করে নেয়ার চেষ্টা করবে।';
$string['pathssubdirroot'] = 'মুডল ইন্সটলেশনের সম্পূর্ন ডিরেক্টরি পাথ।';
$string['pathssubwwwroot'] = 'মুডল ব্যবহার করার সম্পূর্ন ওয়েব ঠিকানা।
একাধিক ঠিকানা ব্যবহার করে মুডল ব্যবহার করা সম্ভব নয়।
আপনার সাইটের যদি একাধিক পাবলিক ঠিকানা থাকে তবে এই ঠিকানাটা ছাড়া বাকি সবগুলো ঠিকানার জন্য আপনাকে অবশ্যই স্থায়ী রিডিরেক্ট নির্ধারণ করতে হবে।';
$string['pathsunsecuredataroot'] = 'ডাটারুট এর স্থান নিরাপদ নয়';
$string['pathswrongadmindir'] = 'অ্যাডমিন ডিরেক্টরি নাই';
$string['pgsqlextensionisnotpresentinphp'] = 'PGSQL এক্সটেনশনের সাথে PHP যথাযথভাবে কনফিগার করা হয়নি, তাই PostgreSQL এর সাথে যোগাযোগ করতে পারে। অনুগ্রহ করে php.ini ফাইল পরীক্ষা করে দেখুন বা PHP পুনরায় কমপাইল।';
$string['phpextension'] = '{$a} PHP এক্সটেনশন';
$string['phpversion'] = 'PHP সংস্করণ';
$string['phpversionhelp'] = '<p>মুডলের জন্য PHP এর কমপক্ষে 4.3.0 or 5.1.0সংস্করণ প্রয়োজন (5.0.x এ অবগত সমস্যার সংখ্যাগতমান দেয়া থাকে)।</p>
<p>আপনি বর্তমানে {$a} সংস্করণটি চালাচ্ছেন</p>
<p>PHP সংস্করন অবশ্যই আপগ্রেড করতে হবে বা PHP এর নতুন সংস্করনসহ হোস্ট ব্যবহার করতে হবে!<br />
(5.0.x এর ক্ষেত্রে আপনি 4.4.x সংস্করনেও ডাউনগ্রেড করতে পারেন)</p>';
$string['releasenoteslink'] = 'মুডল এই সংস্করণ সম্পর্কিত তথ্যের জন্য অনুগ্রহ করে {$a} রিলিজ নোট দেখুন';
$string['safemode'] = 'নিরাপদ মোড';
$string['safemodeerror'] = 'নিরাপদ মোড চালু থাকলে মুডলে সমস্যা হতে পারে';
$string['safemodehelp'] = '<p>নিরাপদ মোড চালু থাকলে মুডলে বিভিন্ন ধরনের সমস্যা হতে পারে,
   নতুন ফাইল তৈরি করতে নাও দিতে পারে।</p>

<p>সাধারণত কিছু অস্বাভাবিক পাবলিক ওয়েব হোস্ট নিরাপদ মোড চালু করে দেয়, মুডল সাইটের জন্য আপনাকে শুধু
   নতুন একটা ওয়েব হোস্টিং কোম্পানী খুঁজতে হবে।</p>

<p>আপনি আপনার ইচ্ছামত ইনস্টল করতে পারেন তবে পরবর্তীতে সমস্যা দেখা দিতে পারে।</p>';
$string['sessionautostart'] = 'স্বয়ংক্রিয় সেশন চালু';
$string['sessionautostarterror'] = 'এটা বন্ধ করা উচিত';
$string['sessionautostarthelp'] = '<p>মুডলের জন্য সেশন সমর্থন প্রয়োজন, এ সমর্থন ছাড়া মডিউল কাজ করবে না।</p>

<p>সেশন php.ini ফাইলে সক্রিয় করা যায় ... session.auto_start parameter এর খোঁজ।</p>';
$string['sqliteextensionisnotpresentinphp'] = 'SQLite এক্সটেনশনের সাথে PHP যথাযথভাবে কনফিগার করা হয়নি। অনুগ্রহ করে php.ini ফাইল পরীক্ষা করে দেখুন বা PHP পুনরায় কমপাইল।';
$string['upgradingqtypeplugin'] = 'প্রশ্ন/ধরন প্লাগইন আপগ্রেড করা হচ্ছে';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'আপনি সফলভাবে
     আপনার কম্পিউটারে <strong>{$a->packname} {$a->packversion}</strong> প্যাকেজ ইনস্টল করে চালু করেছেন বলেই এই পৃষ্ঠাটি দেখতে পাচ্ছেন। অভিনন্দন!';
$string['welcomep30'] = 'অ্যাপ্লিকেশনসহ <strong>{$a->installername}</strong> রিলিজের ফলে একটি এনভায়রনমেন্ট তৈরি করা হয় যেখানে <strong>মুডল</strong> কাজ করবে, যেমন:';
$string['welcomep40'] = 'প্যাকেজে <strong>মুডল {$a->moodlerelease} ({$a->moodleversion})</strong> ও থাকে।';
$string['welcomep50'] = 'এই প্যাকেজের সকল অ্যাপ্লিকেশন তাদের মূল্যবান
    লাইসেন্স অনুসরন করে। সম্পূর্ন <strong>{$a->installername}</strong> প্যাকেজ <a href="http://www.opensource.org/docs/definition_plain.html">ওপেন সোর্স</a> এবং <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> লাইসেন্সের আওতায়
    বন্টিত।';
$string['welcomep60'] = 'নিম্নোক্ত পৃষ্ঠায় আপনার কম্পিউটারে <strong>মুডল</strong>
     কনফিগার করে নির্ধারন করার জন্য কিছু সহজ উপায় দেয়া আছে। আপনি পূর্বনির্ধারিত
    সেটিং গ্রহন করতে পারেন অথবা ঐচ্ছিকভাবে তাদেরকে আপনার প্রয়োজনানুসারে সংশোধন করে নিতে পারেন।';
$string['welcomep70'] = '<strong>মুডল</strong> সেট আপের সাহায্যে অগ্রসর হওয়ার জন্য "পরবর্তী" বোতামে ক্লিক।';
$string['wwwroot'] = 'ওয়েব ঠিকানা';
$string['wwwrooterror'] = '\'ওয়েব ঠিকানা\' কার্যকর আছে বলে মনে হচ্ছে - এখানে মুডল ইনস্টলেশন অনুপস্থিত। নিচের মানটি পুনরায় সেট করা হয়েছে।';
