<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'অ্যাক্টিভিটিজ';
$string['addcategory'] = 'শ্রেণী যোগ';
$string['addcategoryerror'] = 'শ্রেণী যোগ করা যায়নি।';
$string['addexceptionerror'] = 'userid:gradeitem এর জন্য এক্সেপশন যোগ করার সময় ত্রুটি হয়েছে';
$string['addfeedback'] = 'মন্তব্য যোগ';
$string['addgradeletter'] = 'গ্রেডের অক্ষর যোগ';
$string['addidnumbers'] = 'আইডি নাম্বার যোগ করা';
$string['additem'] = 'গ্রেড আইটেম যোগ';
$string['addoutcome'] = 'আউটকাম যোগ';
$string['addoutcomeitem'] = 'আউটকাম আইটেম যোগ';
$string['addscale'] = 'স্কেল যোগ';
$string['aggregateextracreditmean'] = 'গ্রেডের গড় (অতিরিক্ত ক্রেডিটসহ)';
$string['aggregatemax'] = 'সর্বোচ্চ গ্রেড';
$string['aggregatemean'] = 'গ্রেডের গড়';
$string['aggregatemedian'] = 'গ্রেডের মধ্যমা';
$string['aggregatemin'] = 'সর্বনিম্ন গ্রেড';
$string['aggregatemode'] = 'গ্রেডের মোড';
$string['aggregateonlygraded'] = 'খালি নয় এমন গ্রেডের এগ্রিগেট';
$string['aggregateonlygraded_help'] = 'ফাঁকা গ্রেড একটি গ্রেড যা কিনা গ্রেডবুকে অনুপস্থিত। এটি জমা দেওয়া যে অ্যাসাইন্টমেন্টটি এখনো গ্রেডকৃত হয়নি অথবা যে কুইজ এখনো চেষ্টা করা হয়নি ইত্যাদি থেকে হতে পারে।

ফাঁকা গ্রেডটি সমষ্টিকরণে যুক্ত অথবা যৎসামান্য গ্রেড হিসেবে গণনা করা হবে কি হবেনা তা সেটিংটি নির্ধারন করে, উদাহরণ স্বরূপ ০ থেকে ১০০ এর মধ্যে গ্রেডকৃত অ্যাসাইন্টমেন্টের জন্য ০।';
$string['aggregateoutcomes'] = 'এগ্রিগেশনে আউটকাম অন্তর্ভুক্ত';
$string['aggregateoutcomes_help'] = 'সক্রিয় করা হলে, আউটকাম এগ্রিগেশনে অন্তর্ভূক্ত হবে। এটি অপ্রত্যাশিত ক্যাটেগরি টোটালে দেখাতে পারে।';
$string['aggregatesonly'] = 'শুধু এগ্রিগেশন';
$string['aggregatesubcats'] = 'সাবক্যাটেগরিসহ এগ্রিগেট';
$string['aggregatesubcats_help'] = 'এই সেটিংটি নির্দেশ করে কোথায় সাবক্যাটেগরিসহ এগ্রিগেট হবে।';
$string['aggregatesum'] = 'গ্রেড সমষ্টি';
$string['aggregateweightedmean'] = 'গ্রেডের ওয়েটেড গড়';
$string['aggregateweightedmean2'] = 'সাধারণ গ্রেডের ওয়েটেড গড়';
$string['aggregation'] = 'এগ্রিগেশন';
$string['aggregationcoef'] = 'এগ্রিগেশন সহগ';
$string['aggregationcoefextra'] = 'অতিরিক্ত ক্রেডিট';
$string['aggregationcoefextra_help'] = 'যদি গ্রেডের যোগফল অথবা সহজ ওয়েটকৃত গড় পুঞ্জীকরণ হয় এবং অতিরিক্ত ক্রেডিট চেকবক্স টিক দেওয়া থাকে, গ্রেড আইটেমের সর্বোচ্চ গ্রেড বিভাগের সর্বোচ্চ গ্রেডের সাথে যোগ করা হবেনা, সব গ্রেড আইটেমে সর্বোচ্চ গ্রেড না পেয়েও বিভাগে সর্বোচ্চ গ্রেড অর্জন করা সম্ভব হবে (অথবা সর্বোচ্চ গ্রেডেরও বেশি হবে যদি সাইট প্রশাসক দ্বারা সক্রিয় থাকে )।

যদি গ্রেডের গড় (অতিরিক্ত ক্রেডিট সহ) পুঞ্জীকরণ হয় এবং অতিরিক্ত ক্রেডিট শূণ্য থেকে বড় মানের নির্ধারণ করা হয়, তাহলে অতিরিক্ত ক্রেডিট একটি গুণনীয়ক যা দ্বারা গড় গণনা করার পরে এবং সর্বমোটে যোগ করার আগে গ্রেড গুন করা হয়।';
$string['aggregationcoefextra_link'] = 'গ্রেড/এগ্রিগেশন';
$string['aggregationcoefextrasum'] = 'অতিরিক্ত ক্রেডিট';
$string['aggregationcoefextrasum_help'] = 'যদি গ্রেডের যোগফল অথবা সহজ ওয়েটকৃত গড় পুঞ্জীকরণ হয় এবং অতিরিক্ত ক্রেডিট চেকবক্স টিক দেওয়া থাকে, গ্রেড আইটেমের সর্বোচ্চ গ্রেড বিভাগের সর্বোচ্চ গ্রেডের সাথে যোগ করা হবেনা, সব গ্রেড আইটেমে সর্বোচ্চ গ্রেড না পেয়েও বিভাগে সর্বোচ্চ গ্রেড অর্জন করা সম্ভব হবে (অথবা সর্বোচ্চ গ্রেডেরও বেশি হবে যদি সাইট প্রশাসক দ্বারা সক্রিয় থাকে )।';
$string['aggregationcoefextrasum_link'] = 'গ্রেড/এগ্রিগেশন';
$string['aggregationcoefextraweight'] = 'অতিরিক্ত ক্রেডিট ওয়েট';
$string['aggregationcoefextraweight_help'] = 'যদি অতিরিক্ত ক্রেডিটের ওয়েট শূণ্য থেকে বড় মানের নির্ধারণ করা হয়, তাহলে পুঞ্জীকরণের সময় গ্রেডটি অতিরিক্ত ক্রেডিট হিসেবে কাজ করবে। গড় গণনা করার জন্য সংখ্যাটি একটি গুণনীয়ক যা দ্বারা সর্বমোটে যোগ করার আগে গ্রেড গুন করা হয়।';
$string['aggregationcoefextraweight_link'] = 'গ্রেড/এগ্রিগেশন';
$string['aggregationcoefweight'] = 'আইটেম ওয়েট';
$string['aggregationcoefweight_help'] = 'বিভাগ এগ্রিগেশনে একই বিভাগের অন্য গ্রেড আইটেমের তুলনায় এ আইটেমের প্রভাব ফেলার জন্য  ব্যবহৃত আইটেম ওয়েট।';
$string['aggregationcoefweight_link'] = 'গ্রেড/এগ্রিগেশন';
$string['aggregation_help'] = 'বিভাগে কিভাবে গ্রেড একত্রিত থাকবে তা পুঞ্জীকরণটি নির্ধারন করে, যেমন

* গ্রেডের গড় - গ্রেডের সর্বমোট নাম্বার দ্বারা সব গ্রেডের যোগফল ভাগ।
*গ্রেডের মধ্যমা - আকারের ক্রমানুসারে যখন গ্রেডকে সাজানো হবে তখন মধ্যবর্তী গ্রেড
*সর্বনিম্ন গ্রেড
* সর্বোচ্চ গ্রেড
* গ্রেডের মোড - যে গ্রেডটি সবচেয়ে বেশি নিয়মিত ঘটে
* গ্রেডের যোগফল - সব গ্রেডের মানের যোগফল, স্কেল গ্রেড উপেক্ষিত রেখে।';
$string['aggregation_link'] = 'গ্রেড/এগ্রিগেশন';
$string['aggregationposition'] = 'এগ্রিগেশনের অবস্থান';
$string['aggregationposition_help'] = 'এ সেটিং নির্ধারন করে যে গ্রেডবুক রিপোর্টে বিভাগ এবং কোর্সের সর্বমোট কলাম প্রথমে না শেষে প্রদর্শিত হবে।';
$string['aggregationsvisible'] = 'বিদ্যমান এগ্রিগেশন টাইপ';
$string['aggregationsvisiblehelp'] = 'যত ধরণের এগ্রিগেশন আছে তা সব নির্বাচন। বিবিধ আইটেম নির্বাচন করার জন্য  Ctrl কী ধরে রাখুন।';
$string['allgrades'] = 'ক্যাটেগরির সব গ্রেড';
$string['allstudents'] = 'সব শিক্ষার্থী';
$string['allusers'] = 'সব ব্যবহারকারী';
$string['autosort'] = 'স্বয়ংক্রিয়-ক্রমানুসারে সাজান';
$string['availableidnumbers'] = 'বিদ্যমান আইডি নাম্বার';
$string['average'] = 'গড়';
$string['averagesdecimalpoints'] = 'কলাম গড়ে দশমিক';
$string['averagesdecimalpoints_help'] = 'এ সেটিং নির্ধারণ করে যে প্রত্যেক গড় মানের জন্য দশমিকের পরের সংখ্যা অথবা  বিভাগ বা গ্রেড আইটেমের জন্য দশমিকের পরের ঘরের সংখ্যার সেটিং ব্যবহৃত হবে কিনা (ইনহেরিট)';
$string['averagesdisplaytype'] = 'কলামের গড়ের প্রদর্শন ধরণ';
$string['averagesdisplaytype_help'] = 'এ সেটিং নির্ধারন করে যে গড় (গড়) মান প্রকৃত মান, শতকরা বা লেটার হিসাবে প্রদর্শিত হবে অথবা বিভাগ বা গ্রেড আইটেমের প্রদর্শনের ধরণ ব্যবহৃত হবে (ইনহেরিট)।';
$string['backupwithoutgradebook'] = 'ব্যাকআপ গ্রেডবুক কনফিগারেশন থাকে না';
$string['badgrade'] = 'প্রদানকৃত গ্রেড অকার্যকর';
$string['badlyformattedscale'] = 'অনুগ্রহ করে কমা দিয়ে পৃথক করা মানের তালিকা দিন (অন্তত দুটি মান আবশ্যক)।';
$string['baduser'] = 'প্রদানকৃত ব্যবহারকারী অকার্যকর';
$string['bonuspoints'] = 'বোনাস পয়েন্ট';
$string['bulkcheckboxes'] = 'বাল্ক চেকবাক্স';
$string['calculatedgrade'] = 'গণনা করা গ্রেড';
$string['calculation'] = 'গণনা';
$string['calculationadd'] = 'গণনা যোগ';
$string['calculationedit'] = 'গণনা সম্পাদনা';
$string['calculation_help'] = 'গ্রেড গণনা গ্রেড নির্ধারনের জন্য একটি ফর্মূলা। ফর্মূলাটি সমান (=) চিহ্ন দিয়ে শুরু করতে হবে এবং সাধারন গাণিতিক অপারেটর ব্যবহার করতে পারে, যেমন সর্বোচ্চ, সর্বনিম্ন এবং যোগফল। যদি কাম্য হয়, তাহলে আইডি নাম্বার ডবল বর্গাকার বন্ধনীতে টাইপ করে অন্যান্য গ্রেড আইটেম গণনায় অন্তর্ভুক্ত করা যাবে।';
$string['calculation_link'] = 'গ্রেড/গণনা';
$string['calculationsaved'] = 'গণনা সংরক্ষন';
$string['calculationview'] = 'গণনা প্রদর্শন';
$string['cannotaccessgroup'] = 'নির্বাচিত গ্রুপের গ্রড দেখা যাচ্ছে না, দুঃখিত।';
$string['categories'] = 'শ্রেনী';
$string['categoriesanditems'] = 'শ্রেনী এবং আইটেম';
$string['categoriesedit'] = 'শ্রেনী এবং আইটেম সম্পাদনা';
$string['category'] = 'শ্রেণী';
$string['categoryedit'] = 'শ্রেনী সম্পাদনা';
$string['categoryname'] = 'শ্রেণী নাম';
$string['categorytotal'] = 'মোট শ্রেণী';
$string['categorytotalfull'] = '{$a->category} মোট';
$string['categorytotalname'] = 'ক্যাটেগরির মোট নাম';
$string['changedefaults'] = 'ডিফল্ট পরিবর্তন';
$string['changereportdefaults'] = 'রিপোর্ট ডিফল্ট পরিবর্তন';
$string['chooseaction'] = 'একটি বেছে নিন ...';
$string['choosecategory'] = 'ক্যাটেগরি নির্বাচন';
$string['combo'] = 'ট্যাব এবং নিম্ন প্রসারন মেনু';
$string['compact'] = 'কমপ্যাক্ট';
$string['contract'] = 'চুক্তির ক্যাটেগরি';
$string['controls'] = 'কন্ট্রোল';
$string['courseavg'] = 'কোর্সের গড়';
$string['coursegradecategory'] = 'কোর্স গ্রেডের ক্যাটেগরি';
$string['coursegradedisplaytype'] = 'কোর্সের গ্রেড প্রদর্শনের ধরণ';
$string['coursegradedisplayupdated'] = 'কোর্সের গ্রেড প্রদর্শনের ধরণ আপডেট করা হয়েছে।';
$string['coursegradesettings'] = 'কোর্সের গ্রেড সেটিং';
$string['coursename'] = 'কোর্সের নাম';
$string['coursescales'] = 'কোর্সের স্কেল';
$string['coursesettings'] = 'কোর্সের সেটিং';
$string['coursesettingsexplanation'] = 'এই কোসের সবার গ্রেডবুক কেমন দেখাবে তা কোর্সের সেটিং নির্দেশ করে।';
$string['coursetotal'] = 'মোট কোর্স';
$string['createcategory'] = 'ক্যাটেগরি তৈরি';
$string['createcategoryerror'] = 'নতুন ক্যাটেগরি তৈরি করতে পারেনি';
$string['creatinggradebooksettings'] = 'গ্রেডবুক সেটিং তৈরি';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'বর্তমান প্যারেন্ট এগ্রিগেশন';
$string['curveto'] = 'কার্ভ হবে';
$string['decimalpoints'] = 'সামগ্রিক দশমিক পয়েন্ট';
$string['decimalpoints_help'] = 'এ সেটিং নির্ধারন করে প্রত্যেক গ্রেডে';
$string['default'] = 'ডিফল্ট';
$string['defaultprev'] = 'ডিফল্ট ({$a})';
$string['deletecategory'] = 'ক্যাটেগরি মুছে ফেলা';
$string['disablegradehistory'] = 'গ্রেড ইতিহাস নিষ্ক্রিয়';
$string['disablegradehistory_help'] = 'গ্রেড সম্পর্কিত টেবিলে পরিবর্তন খুঁজে বের করার ইতিহাস নিষ্ক্রিয়। এটা সার্ভারকে একটু  দ্রুত গতিসম্পন্ন করবে এবং ডাটাবেসে জায়গা জমা রাখবে।';
$string['displaylettergrade'] = 'গ্রেড অক্ষর প্রদর্শন';
$string['displaypercent'] = 'শতকরা হার প্রদর্শন';
$string['displaypoints'] = 'পয়েন্ট প্রদর্শন';
$string['displayweighted'] = 'ওয়েটেড গ্রেড প্রদর্শন';
$string['dropdown'] = 'নিম্ন প্রসারন মেনু';
$string['droplow'] = 'সর্বনিম্ন ড্রপ করা';
$string['droplow_help'] = 'এ সেটিং দ্বারা এগ্রিগেশনে সর্বনিম্ন গ্রেড কার্যকর করতে সুনির্দিষ্ট নাম্বার সক্রিয় করে।';
$string['dropped'] = 'ড্রপকৃত';
$string['dropxlowest'] = 'সর্বনিম্ন X ড্রপ করা';
$string['dropxlowestwarning'] = 'মনে রাখুন: আপনি যদি ড্রপ x সর্বনিম্ন গ্রেডিং ধরেন তবে এ বিভাগের সব আইটেমের মান একই হবে। যদি পয়েন্ট মান ভিন্ন হয় তবে ফলাফল দূর্বোধ্য হয়ে যাবে';
$string['duplicatescale'] = 'অনুরূপ স্কেল';
$string['edit'] = 'সম্পাদনা';
$string['editcalculation'] = 'গণনা সম্পাদনা';
$string['editcalculationverbose'] = 'গণনা সম্পাদনা {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'মন্তব্য সম্পাদনা';
$string['editgrade'] = 'গ্রেড সম্পাদনা';
$string['editgradeletters'] = 'গ্রেডের অক্ষর সম্পাদনা';
$string['editoutcome'] = 'আউটকাম সম্পাদনা';
$string['editoutcomes'] = 'আউটকাম সম্পাদনা';
$string['editscale'] = 'স্কেল সম্পাদনা';
$string['edittree'] = 'ক্যাটেগরি এবং আইটেম';
$string['editverbose'] = 'সম্পাদনা {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'AJAX সক্রিয়';
$string['enableajax_help'] = 'বড় রিপোর্টে, সাধারণ অপারেশন সহজ ও দ্রুতগতি সম্পন্ন করতে AJAX ফাংশনালিটির একটি ধাপ যোগ। জাভাস্ক্রিপ্ট ব্যবহারকারীর ব্রাউজারের অন্য কোনো ধাপে পরিবর্তন করার উপর নির্ভর করে।';
$string['enableoutcomes'] = 'আউটকাম সক্রিয়';
$string['enableoutcomes_help'] = 'আউটকামের সমর্থন (চুক্তি, লক্ষ্য, আদর্শ বা বৈশিষ্ট্য হিসাবেও পরিচিত) বলতে বুঝায় যে কোনো কিছুতে গ্রেড দেয়ার সময় এক বা একাধিক স্কেল ব্যবহার করি যা আউটকাম স্টেটমেন্টের সাথে সংযুক্ত। আউটকাম সক্রিয় করার ফলে সাইটে বিশেষ গ্রেডিং করা সম্ভব হয়।';
$string['encoding'] = 'এনকোডিং';
$string['errorcalculationnoequal'] = 'ফর্মূলা সমান চিহ্ন দিয়ে শুরু হওয়া উচিত (=1+2)';
$string['errorcalculationunknown'] = 'অকার্যকর সূত্র';
$string['errorgradevaluenonnumeric'] = 'নিম্ন ও উচ্চ গ্রেডের জন্য সংখ্যাবাচক নয় এমন কিছু গৃহিত';
$string['errornocalculationallowed'] = 'এ আইটেমের জন্য গণনা অনুমোদিত নয়';
$string['errornocategorisedid'] = 'বিভাগকৃত নয় এমন আইডি পাওয়া যায়না!';
$string['errornocourse'] = 'কোর্সের তথ্য পাওয়া যায়নি';
$string['errorreprintheadersnonnumeric'] = 'শিরোনাম-পুনঃমুদ্রণ করার জন্য সংখ্যাবাচক নয় এমন কিছু গ্রহন';
$string['errorsavegrade'] = 'গ্রেড সংরক্ষণ করা যায় না, দুঃখিত।';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'গ্রেড বিভাগের আইডি {$a->id} এর "শুধুমাত্র যে গ্রেড ফাঁকা নয় তা সমষ্টিগত করা" সেটিং হালনাগাদ করার সময় ত্রুটি';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'গ্রেড বিভাগের আইডি {$a->id} এর "সমষ্টিগততে প্রাপ্ত ফলাফল সহ" সেটিং হালনাগাদ করার সময় ত্রুটি';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'গ্রেড বিভাগের আইডি {$a->id} এর "উপদল সহ সমষ্টিকরণ" সেটিং হালনাগাদ করার সময় ত্রুটি';
$string['errorupdatinggradecategoryaggregation'] = 'গ্রেড বিভাগের আইডি {$a->id} এর সমষ্টিকরণের ধরণ হালনাগাদ করার সময় ত্রুটি';
$string['errorupdatinggradeitemaggregationcoef'] = 'গ্রেড আইটেমের আইডি {$a->id} এর সমষ্টিকরণের সহগ (ওয়েট অথবা অতিরিক্ত ক্রেডিট) হালনাগাদ করার সময় ত্রুটি';
$string['excluded'] = 'বহিঃস্থ';
$string['excluded_help'] = 'যদি চিহ্নিত করা থাকে তবে, গ্রেড কোনো এগ্রিগেশনে যোগ করা হবে না।';
$string['expand'] = 'ক্যাটেগরি প্রসারণ';
$string['export'] = 'এক্সপোর্ট';
$string['exportalloutcomes'] = 'সব আউটকাম এক্সপোর্ট';
$string['exportfeedback'] = 'এক্সপোর্টে মন্তব্য যুক্ত করা';
$string['exportplugins'] = 'প্লাগইন এক্সপোর্ট';
$string['exportsettings'] = 'এক্সপোর্ট সেটিংসমূহ';
$string['exportto'] = 'এক্সপোর্ট করা হবে';
$string['extracreditwarning'] = 'মনে রাখুন: অতিরিক্ত ক্রেডিট হিসাবে সব আইটেম নির্ধারণ করা হলে গ্রেড গণনা থেকে তা কার্যকর অর্থে অপসারণ করা হবে। কারণ কোনো সর্বমোট পয়েন্ট থাকবে না';
$string['feedback'] = 'মন্তব্য';
$string['feedbackadd'] = 'মন্তব্য যোগ';
$string['feedbackedit'] = 'মন্তব্য সম্পাদনা';
$string['feedback_help'] = 'গ্রেড সম্পর্কে যেকোনো মন্তব্য যোগ করা এ বক্স সক্রিয় করে।';
$string['feedbacksaved'] = 'মন্তব্য সংরক্ষিত';
$string['feedbackview'] = 'মন্তব্য প্রদর্শন';
$string['finalgrade'] = 'চুড়ান্ত গ্রেড';
$string['finalgrade_help'] = 'যদি উপেক্ষা করার চেকবক্স চিহ্নিত করা হয় তবে, গ্রেড যোগ বা সংশোধন করা যায়।';
$string['fixedstudents'] = 'স্ট্যাটিক শিক্ষার্থী কলাম';
$string['fixedstudents_help'] = 'শিক্ষার্থীর কলাম অদেখা না করেই গ্রেড অনুভূমিকভাবে স্ক্রল করা অনুমোদন করে, একে স্ট্যাটিক হিসাবে তৈরি করে।';
$string['forceoff'] = 'ফোর্স: বন্ধ';
$string['forceon'] = 'ফোর্স: চালু';
$string['forelementtypes'] = 'নির্বাচিতের জন্য {$a}';
$string['forstudents'] = 'শিক্ষার্থীর জন্য';
$string['full'] = 'সম্পূর্ন';
$string['fullmode'] = 'সম্পূর্ণ প্রদর্শন';
$string['fullview'] = 'সম্পূর্ণ প্রদর্শন';
$string['generalsettings'] = 'সাধারণ সেটিং';
$string['grade'] = 'গ্রেড';
$string['gradeadministration'] = 'গ্রেড প্রশাসন';
$string['gradebook'] = 'গ্রেডবুক';
$string['gradebookhiddenerror'] = 'শিক্ষার্থীদের কাছ থেকে সব আড়াল করার মত করে বর্তমানে গ্রেডবুক নির্ধরন করা হয়েছে।';
$string['gradebookhistories'] = 'গ্রেড ইতিহাস';
$string['gradeboundary'] = 'গ্রেডের অক্ষরের সীমা';
$string['gradeboundary_help'] = 'এ সেটিং সর্বনিম্ন শতকরা হার নির্ধারণ করে যার উপরের গ্রেড গ্রেড লেটার হিসাবে এসাইন করা হবে।';
$string['gradecategories'] = 'গ্রেডের ক্যাটেগরি';
$string['gradecategory'] = 'গ্রেডের ক্যাটেগরি';
$string['gradecategoryonmodform'] = 'গ্রেডের ক্যাটেগরি';
$string['gradecategorysettings'] = 'গ্রেডের ক্যাটেগরি সেটিং';
$string['gradedisplay'] = 'গ্রেড প্রদর্শন';
$string['gradedisplaytype'] = 'গ্রেড প্রদর্শন ধরণ';
$string['gradedisplaytype_help'] = 'এ সেটিং নির্ধারণ করে যে গ্রেডার এবং ব্যবহারকারীর রিপোর্টে গ্রেড কিভাবে প্রদর্শিত হয়।

* প্রকৃত - মূল গ্রেড
* শতকরা
* লেটার - লেটার বা শব্দ যা দ্বারা গ্রেডের একটি সীমা বুঝানো হয়';
$string['gradedon'] = 'গ্রেডকৃত: {$a}';
$string['gradeexport'] = 'গ্রেড এক্সপোর্ট';
$string['gradeexportdecimalpoints'] = 'গ্রেড এক্সপোর্ট দশমিক পয়েন্ট';
$string['gradeexportdecimalpoints_desc'] = 'এক্সপোর্টের প্রদর্শনের জন্য দশমিকের পয়েন্টের সংখ্যা। এটা এক্সপোর্ট করার সময় উপেক্ষা করা হয়।';
$string['gradeexportdisplaytype'] = 'গ্রেড এক্সপোর্ট প্রদর্শন ধরণ';
$string['gradeexportdisplaytype_desc'] = 'এক্সপোর্ট করার সময় প্রকৃত গ্রেড, শতকরা (সর্বনিম্ন এবং সর্বোচ্চ গ্রেডের রেফারেন্স হিসাবে) অথবা অক্ষর (A, B, C ইত্যাদি..) হিসাবে গ্রেড প্রদর্শন করা যায়। এটা এক্সপোর্ট করার সময় উপেক্ষা করা যায়।';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}$a->feedback';
$string['gradehelp'] = 'গ্রেড সহায়তা';
$string['gradehistorylifetime'] = 'গ্রেডের ইতিহাসের লাইফটাইম';
$string['gradehistorylifetime_help'] = 'এটা নির্ধারণ করে যে গ্রেড সম্পর্কিত টেবিলে কত সময়ের পরিবর্তনের ইতিহাস রাখবে। যতক্ষন সম্ভব ততক্ষন এটা রেখে দেয়ার জন্য সুপারিশ করা হয়েছে। আপনি যদি কাজ করতে কোনো সমস্যা অনুভব করেন বা যদি ডাটাবেসে সীমিত জায়গা থাকে তবে, নিম্নতর মান নির্ধারন করার চেষ্টা করুন।';
$string['gradeimport'] = 'গ্রেড ইম্পোর্ট';
$string['gradeitem'] = 'গ্রেড আইটেম';
$string['gradeitemaddusers'] = 'গ্রেডিং হতে এক্সক্লুড করা';
$string['gradeitemadvanced'] = 'উচ্চ পর্যায়ের গ্রেড আইটেম অপশন';
$string['gradeitemadvanced_help'] = 'গ্রেড আইটেম সম্পাদনা করার সময় উচ্চ পর্যায় হিসাবে প্রদর্শন জন্য সব এলিমেন্ট নির্বাচন।';
$string['gradeitemislocked'] = 'এ অ্যাক্টিভিটি গ্রেডবুকে লক করা। এটা আনলক না করা পর্যন্ত এ অ্যাক্টিভিটিতে কোনো গ্রেডের পরিবর্তন অনুলিপি করা হবে না।';
$string['gradeitemlocked'] = 'গ্রেডিং লককরা';
$string['gradeitemmembersselected'] = 'গ্রেডিং হতে এক্সক্লুড করা';
$string['gradeitemnonmembers'] = 'গ্রেডে অন্তর্ভুক্ত';
$string['gradeitemremovemembers'] = 'গ্রেডে অন্তর্ভুক্ত';
$string['gradeitems'] = 'গ্রেড আইটেম';
$string['gradeitemsettings'] = 'গ্রেড আইটেম সেটিং';
$string['gradeitemsinc'] = 'গ্রেডে অন্তর্ভুক্ত হবে এমন আইটেম';
$string['gradeletter'] = 'গ্রেডের অক্ষর';
$string['gradeletter_help'] = 'গ্রেড লেটার হল অক্ষর যেমন, A, B, C, ..., অথবা শব্দ যেমন, ডিসটিংশন, মেরিট, পাস, ..., যা গ্রেডের সীমা বুঝাতে ব্যবহৃত হয়।';
$string['gradeletternote'] = 'কোনো গ্রেড লেটার অপসারণ করতে কেবল ঐ লেটারের যেকোনো<br /> তিনটি টেক্সট এরিয়া ফাঁকা করতে হয় এবং জমা দেয়ায় ক্লিক।';
$string['gradeletters'] = 'গ্রেডের অক্ষর';
$string['gradelocked'] = 'গ্রেড আবদ্ধ';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'সর্বোচ্চ গ্রেড';
$string['grademax_help'] = 'গ্রেডের মানের ধরণ ব্যবহার করার সময় সর্বোচ্চ গ্রেড এ সেটিং নির্ধরন করে। অ্যাক্টিভিটি ভিত্তিক গ্রেড আইটেমের জন্য সর্বোচ্চ গ্রেড অ্যাক্টিভিটি সেটিং পৃষ্ঠায় নির্ধারণ করা হয়।';
$string['grademin'] = 'সর্বনিম্ন গ্রেড';
$string['grademin_help'] = 'গ্রেডের মানের ধরণ ব্যবহার করার সময় এ সেটিং সর্বনিম্ন গ্রেড নির্ধারণ করে।';
$string['gradeoutcomeitem'] = 'গ্রেড আউটকাম আইটেম';
$string['gradeoutcomes'] = 'আউটকাম';
$string['gradeoutcomescourses'] = 'কোর্স আউটকাম';
$string['gradepass'] = 'পাসের গ্রেড';
$string['gradepass_help'] = 'পাস করার জন্য আবশ্যক সর্বনিম্ন গ্রেড এ সেটিং নির্ধারন করে। এ মান অ্যাক্টিভিটি এবং কোর্স সম্পন্ন করার জন্য ব্যবহৃত হয়, এবং গ্রেডবুকে যেখানে পাসকৃত গ্রেড সবুজ রং এ এবং ফেইল করা গ্রেড লাল রং এ হাইলাইটকৃত থাকে।';
$string['gradepreferences'] = 'গ্রেডের পছন্দ';
$string['gradepreferenceshelp'] = 'গ্রেড পছন্দের সহায়তা';
$string['gradepublishing'] = 'প্রকাশ সক্রিয়';
$string['gradepublishing_help'] = 'এক্সপোর্ট এবং ইম্পোর্টে প্রকাশ করা সক্রিয়: এক্সপোর্টকৃত গ্রেড প্রবেশ করতে মুডল সাইটে লগঅন না করে URL দিয়ে প্রবেশ করা যায়। এমন একটি URL (যা থেকে বোঝা যায় যে, মুডল সাইট অন্য সাইটে প্রকাশিত গ্রেড ইম্পোর্ট করতে পারে) প্রবেশ করে গ্রেড ইম্পোর্ট করা যায়। পূর্বনির্ধারিতভাবে, কেবল প্রসাশক এ বৈশিষ্ট্য ব্যবহার করতে পারে, অনুগ্রহ করে অন্যান্য রোলে (বুকমার্ক শেয়ার করা, এক্সিলেটর ডাউনলোড, IP বিধিনিষেধ এর সমস্যা ইত্যাদি) ক্ষমতা যোগ করার আগে ব্যবহারকারীকে শিক্ষিত করে নিতে হবে।';
$string['gradereport'] = 'গ্রেড রিপোর্ট';
$string['graderreport'] = 'গ্রেডার রিপোর্ট';
$string['grades'] = 'গ্রেড';
$string['gradesforuser'] = 'গ্রেড {$a->user}';
$string['gradesonly'] = 'শুধু গ্রেড';
$string['gradessettings'] = 'গ্রেড সেটিং';
$string['gradetype'] = 'গ্রেডের ধরণ';
$string['gradetype_help'] = '৪ ধরণের গ্রেড আছে:

* কোনটি না - কোনো গ্রেডিং সম্ভন নয়
* মান - সর্বোচ্চ এবং সর্বনিম্ন এর একটি সংখ্যাবাচক মান
* স্কেল - আইটেম হল একটি তালিকা
* টেক্সট - শুধু মন্তব্য

কেবল মান এবং স্কেল গ্রেড এগ্রিগেট করা যেতে পারে। অ্যাক্টিভিটি ভিত্তিক গ্রেড আইটেম অ্যাক্টিভিটি সেটিং পৃষ্ঠায় নির্ধারণ।';
$string['gradeview'] = 'গ্রেড প্রদর্শন';
$string['gradeweighthelp'] = 'গ্রেড ওয়েট সহায়তা';
$string['groupavg'] = 'গ্রুপের গড়';
$string['hidden'] = 'লুকানো';
$string['hiddenasdate'] = 'আড়ালকৃত গ্রেডের জমাকৃত তারিখ প্রদর্শন';
$string['hiddenasdate_help'] = 'যদি ব্যবহাকারী আড়ালকৃত গ্রেড না দেখে তবে তার পরিবর্তে জমা দেয়ার তারিখ প্রদর্শন \'-\'।';
$string['hidden_help'] = 'যদি চিহ্নিত করা থাকে তবে, শিক্ষার্থীর কাছ থেকে গ্রেড আড়াল করা হয়। যদি আশান্বিত তারিখ নির্ধারণ করা আড়াল করা থাকে, তবে গ্রেডিং সম্পন্ন হওয়ার পর গ্রেড প্রচার করা হয়।';
$string['hiddenuntil'] = 'যতক্ষন আড়ালে';
$string['hiddenuntildate'] = 'যতক্ষন আড়ালে: {$a}';
$string['hideadvanced'] = 'উচ্চ পর্যায়ের আড়াল করা বৈশিষ্ট্য';
$string['hideaverages'] = 'গড় আড়াল করা';
$string['hidecalculations'] = 'গণনা আড়াল করা';
$string['hidecategory'] = 'লুকানো';
$string['hideeyecons'] = 'আড়াল করা প্রদর্শন/আড়াল করা আইকন';
$string['hidefeedback'] = 'মন্তব্য আড়াল করা';
$string['hideforcedsettings'] = 'ফোর্সকরা সেটিং আড়াল করা';
$string['hideforcedsettings_help'] = 'গ্রেডিং UI এ ফোর্স সেটিং প্রদর্শন করে না।';
$string['hidegroups'] = 'গ্রুপ আড়াল করা';
$string['hidelocks'] = 'লক আড়াল করা';
$string['hidenooutcomes'] = 'আউটকাম প্রদর্শন';
$string['hidequickfeedback'] = 'কুইকফিডব্যাক আড়াল করা';
$string['hideranges'] = 'পরিসীমা আড়াল করা';
$string['hidetotalifhiddenitems'] = 'যদি আড়াল করা আইটেম থাকে তবে সর্বমোট মান আড়াল করে';
$string['hidetotalifhiddenitems_help'] = 'এ সেটিং নির্ধারন করে যে শিক্ষার্থীদের কাছ থেকে আড়াল করা গ্রেড আইটেম প্রদর্শন করা হবে নাকি হাইফেন (-) দিয়ে প্রতিস্থাপন করা হবে। যদি প্রদর্শন করা হয় তবে, আড়াল করা গ্রেড সহ বা বাদ দিয়ে সর্বমোট মান হিসাব করা হতে পারে।

যদি আড়াল করা আইটেম বাদ দেয়া হয় তবে, গ্রেডার রিপোর্টে শিক্ষকের দেখা গ্রেড থেকে সর্বমোট গ্রেড আলাদা হবে, কারণ শিক্ষক সবসময় আড়াল করা এবং আড়াল করা না এমন সব আইটেমের গ্রেড গণনা করে। যদি আড়াল করা আইটেম গণনা করা হয় তবে, শিক্ষার্থী আড়াল করা আইটেমও গণনা করতে পারে।';
$string['hidetotalshowexhiddenitems'] = 'আড়াল করা আইটেম বাদ দিয়ে সর্বমোট প্রদর্শন';
$string['hidetotalshowinchiddenitems'] = 'আড়াল করা আইটেম সহ সর্বমোট প্রদর্শন';
$string['hideverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} আড়াল';
$string['highgradeascending'] = 'উচ্চ আরোহী গ্রেড অনুসারে সাজান';
$string['highgradedescending'] = 'অবরোহী গ্রেড অনুসারে সাজান';
$string['highgradeletter'] = 'বেশি';
$string['identifier'] = 'ব্যবহারকারীকে সনাক্ত করা হবে';
$string['idnumbers'] = 'আইডি নাম্বার';
$string['import'] = 'ইম্পোর্ট';
$string['importcsv'] = 'CSV ইম্পোর্ট';
$string['importcustom'] = 'স্বনির্ধারিত আউটকাম হিসাবে ইম্পোর্ট (কেবল এ কোর্স)';
$string['importerror'] = 'ত্রুটি হয়েছে, সঠিক প্যারামিটারসহ এ স্ক্রিপ্ট কল করা হয়নি';
$string['importfailed'] = 'ইম্পোর্ট ব্যর্থ';
$string['importfeedback'] = 'মন্তব্য ইম্পোর্ট';
$string['importfile'] = 'ফাইল ইম্পোর্ট';
$string['importfilemissing'] = 'কোনো ফাইল গৃহীত হয়নি, ফর্মে ফেরত যান এবং একটি কার্যকর ফাইল আপলোড করার ব্যাপার নিশ্চিত হোন।';
$string['importfrom'] = 'ইম্পোর্ট করা হবে';
$string['importoutcomenofile'] = 'আপলোডকৃত ফাইলটি ফাঁকা অথবা বিকৃত। অনুগ্রহ করে ফাইলটিকে কার্যকর ফাইল হিসেবে প্রমান করুন। সমস্যাটি এই {$a} লাইনে সনাক্ত করা হয়েছে; প্রথম লাইনের (শীর্ষচরণ লাইন) মত অনেক কলাম ডাটা লাইনে না থাকলে অথবা যদি ইম্পোর্টকৃত ফাইলে প্রত্যাশিত শীর্ষচরণ অনুপস্থিত থাকে তাহলে এটি দ্বারা ট্রিগারকৃত হয়। কার্যকর শীর্ষচরণযুক্ত ফাইলের উদাহরণ দেখতে এক্সপোর্টকৃত ফাইল দেখুন।';
$string['importoutcomes'] = 'ইম্পোর্ট আউটকাম';
$string['importoutcomes_help'] = 'এক্সপোর্ট আউটকাম csv ফাইলের মত একই বিন্যাসে csv ফাইলের মাধ্যমে আউটকাম ইম্পোর্ট করা যায়।';
$string['importoutcomes_link'] = 'গ্রেড/আউটকাম';
$string['importoutcomesuccess'] = 'ইম্পোর্টকৃত আউটকাম "{$a->name}" with ID #{$a->id}';
$string['importplugins'] = 'ইম্পোর্ট প্লাগইন';
$string['importpreview'] = 'ইম্পোর্ট প্রাকদর্শন';
$string['importsettings'] = 'সেটিংস ইম্পোর্ট';
$string['importskippednomanagescale'] = 'নতুন স্কেল করার অনুমোদন আপনার নেই, সুতরাং আউটকাম "{$a}" বাদ দিয়ে যাওয়া হয়েছে কারণ এর জন্য নতুন স্কেল তৈরি করতে হয়';
$string['importskippedoutcome'] = 'এ কনটেক্সটে "{$a}" ডাকনামের একটি আউটকাম ইতোমধ্যে বিদ্যমান, ইম্পোর্টকৃত ফাইলের একটি বাদ দেয়া হয়েছে।';
$string['importstandard'] = 'আদর্শ আউটকাম হিসাবে ইম্পোর্ট';
$string['importsuccess'] = 'গ্রেড ইম্পোর্ট সফলতা';
$string['importxml'] = 'ইম্পোর্ট XML';
$string['includescalesinaggregation'] = 'এগ্রিগেশনে স্কেল যোগ';
$string['includescalesinaggregation_help'] = 'সব কোর্সের সব গ্রেডবুকের মধ্যে সব সমষ্টিগত গ্রেডে নাম্বার হিসেবে স্কেল অন্তর্ভুক্ত হবে কিনা তা আপনি পরিবর্তন করতে পারেন। সতর্কীকরণ: সেটিং পরিবর্তন করলে সব সমষ্টিগত গ্রেড অবশ্যই পুনরায় গণনা করা হবে।';
$string['incorrectcourseid'] = 'কোর্স আইডি সঠিক নয়';
$string['incorrectcustomscale'] = '(স্বনির্ধারিত ভুল স্কেল, অনুগ্রহ করে পরিবর্তন।)';
$string['incorrectminmax'] = 'সর্বোচ্চ এর চেয়ে সর্বনিম্ন কম হতে হবে';
$string['inherit'] = 'ইনহেরিট';
$string['intersectioninfo'] = 'শিক্ষার্থী/গ্রেড তথ্য';
$string['item'] = 'আইটেম';
$string['iteminfo'] = 'আইটেমের তথ্য';
$string['iteminfo_help'] = 'এ সেটিং এর সাহায্যে আইটেম সম্পর্কিত তথ্য দেয়ার স্থান পাওয়া যায়। তথ্য আর কোথাও প্রদর্শিত হয়নি।';
$string['itemname'] = 'আইটেমের নাম';
$string['itemnamehelp'] = 'মডিউলে দিয়ে দেয়া আইটেমের নাম।';
$string['items'] = 'আইটেম';
$string['itemsedit'] = 'গ্রেড আইটেম সম্পাদনা';
$string['keephigh'] = 'সবোর্চ্চ ধরে রাখা';
$string['keephigh_help'] = 'যদি নির্ধারণ করা হয় তবে, এ অপশন কেবল সর্বোচ্চ গ্রেড X রাখবে, কারণ এ অপশনের জন্য X এর মান নির্বাচিত।';
$string['keymanager'] = 'কী ম্যানেজার';
$string['lessthanmin'] = '{$a->username} এর {$a->itemname} জন্য দেয়া গ্রেড অনুমোদিত সর্বনিম্ন মানের চেয়ে কম';
$string['letter'] = 'অক্ষর';
$string['lettergrade'] = 'গ্রেডের অক্ষর';
$string['lettergradenonnumber'] = 'যার জন্য নিম্ন এবং/অথবা উচ্চ গ্রেড সংখ্যাবাচক নয়';
$string['letterpercentage'] = 'অক্ষর (শতকরা হার)';
$string['letterreal'] = 'অক্ষর (আসল)';
$string['letters'] = 'অক্ষর';
$string['linkedactivity'] = 'সংযুক্ত অ্যাক্টিভিটি';
$string['linkedactivity_help'] = 'এ সেটিং একটি অ্যাক্টিভিটি এর সাথে আউটকাম আইটেম লিঙ্ক করা থাকে। যে বৈশিষ্ট্য হিসাবে শিক্ষার্থী কার্যকারিতা মাপা যাপা যাবে এবং অ্যাক্টিভিটি গ্রেড ব্যবহার করা যায় না সেটা এ সেটিং দিয়ে করা যায়।';
$string['linktoactivity'] = 'অ্যাক্টিভিটিতে {$a->name} লিংক';
$string['lock'] = 'আবদ্ধ';
$string['locked'] = 'আবদ্ধ';
$string['locked_help'] = 'যদি চিহ্নিত করা থাকে তবে সম্পর্কিত কোনো অ্যাক্টিভিটি দিয়ে গ্রেড স্বয়ংক্রিয়ভাবে য়ার হালনাগাদ করা যায় না।';
$string['locktime'] = 'লক করা';
$string['locktimedate'] = 'লক করা: {$a}';
$string['lockverbose'] = 'লক {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'সর্বনিম্ন';
$string['lowgradeletter'] = 'নিম্ন';
$string['manualitem'] = 'স্বনির্ধারিত আইটেম';
$string['mapfrom'] = 'যেখান থেকে ম্যাপ করা হবে';
$string['mappings'] = 'গ্রেড আইটেম ম্যাপিং';
$string['mapto'] = 'যেখানে ম্যাপ করা হবে';
$string['max'] = 'সর্বোচ্চ';
$string['maxgrade'] = 'সর্বোচ্চ গ্রেড';
$string['meanall'] = 'সব গ্রেড';
$string['meangraded'] = 'খালি গ্রেড নেই';
$string['meanselection'] = 'কলাম গড়ের জন্য নির্বাচিত গ্রেড';
$string['meanselection_help'] = 'প্রত্যেক বিভাগ বা গ্রেড আইটেমের জন্য গড় (গড়) গণনা করার সময় যে কলামে কোনো গ্রেড নাই সেটাও হিসাব করা হবে কিনা তা এ সেটিং নির্ধারণ করে।';
$string['median'] = 'মধ্যমা';
$string['min'] = 'সর্বনিম্ন';
$string['missingscale'] = 'স্কেল অবশ্যই নির্বাচন করা হবে';
$string['mode'] = 'মোড';
$string['morethanmax'] = '{$a->username} এর জন্য দেয়া গ্রেড নাম {$a->itemname} অনুমোদিত সর্বোচ্চ মানের চেয়ে বেশি';
$string['moveselectedto'] = 'যেখানে নির্বাচিত আইটেম সরানো হবে';
$string['movingelement'] = 'সরানো হচ্ছে {$a}';
$string['multfactor'] = 'গুনিতক';
$string['multfactor_help'] = 'গুণকরাশি একটি গুণনীয়ক যা এই গ্রেড আইটেমের সর্বোচ্চ গ্রেডের সর্বোচ্চ মানের সাথে সব গ্রেড গুন করে। উদাহরণ স্বরূপ, যদি গুণকরাশি ২ হয় এবং সর্বোচ্চ গ্রেড ১০০ হয়, তাহলে ৫০ এর নীচে সব গ্রেড ২ দিয়ে গুন করা হবে, এবং ৫০ এর উপরে সব গ্রেড ১০০ তে পরিবর্তিত হবে।';
$string['mypreferences'] = 'আমার পছন্দসমূহ';
$string['myreportpreferences'] = 'আমার রিপোর্ট পছন্দসমূহ';
$string['navmethod'] = 'ন্যাভিগেশন মেথড';
$string['neverdeletehistory'] = 'ইতিহাস কখনো মোছা হবে না';
$string['newcategory'] = 'নতুন শ্রেণী';
$string['newitem'] = 'নতুন গ্রেড আইটেম';
$string['newoutcomeitem'] = 'নতুন আউটকাম আইটেম';
$string['no'] = 'না';
$string['nocategories'] = 'এ কোর্সের জন্য গ্রেডের বিভাগ যোগ করা বা খুঁজে পাওয়া যায়নি';
$string['nocategoryname'] = 'কোনো ক্যাটেগরি নাম দেয়া ছিল না।';
$string['nocategoryview'] = 'দেখার জন্য কোন ক্যাটাগরি নেই';
$string['nocourses'] = 'কোন কোর্স নেই';
$string['noforce'] = 'ফোর্স করা হবে না';
$string['nogradeletters'] = 'গ্রেডের অক্ষর সেট করা নেই';
$string['nogradesreturned'] = 'গ্রেড পাওয়া যায়নি';
$string['noidnumber'] = 'আইডি নাম্বার নেই';
$string['nolettergrade'] = 'গ্রেডের কেন অক্ষর নেই';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'সংখ্যাসূচক নয় এমন মান গ্রহন করেছে';
$string['nonunlockableverbose'] = 'গ্রেড আনলক করা যায়নি যতক্ষন পর্যন্ত না {$a->itemname} আনলক করা হয়েছে।';
$string['nonweightedpct'] = 'non-weighted %';
$string['nooutcome'] = 'আউটকাম নেই';
$string['nooutcomes'] = 'আউটকাম লিঙ্ক কোর্স আউটকাম আইটেমের সাথে লিঙ্ক করা উচিত, কিন্তু এ কোর্সের জন্য কোনো আউটকাম নেই। আপনি কি একটি যোগ করতে চান?';
$string['nopublish'] = 'প্রকাশ করা হবে না';
$string['norolesdefined'] = 'প্রশাসন > গ্রেড > সাধারণ সেটিং > গ্রেডকৃত রোল এ কোনো রোল নির্ধারণ করা নেই';
$string['noscales'] = 'আউটকাম একটি কোর্স স্কেল বা গ্লোবাল স্কেলে লিঙ্ককৃত থাকা উচিত, কিন্তু কিছু নেই। আপনি কি একটি যোগ করতে চান?';
$string['noselectedcategories'] = 'কোনো ক্যাটেগরি নির্বাচিত হয়নি।';
$string['noselecteditems'] = 'কোন আইটেম নির্বাচন করা হয়নি।';
$string['notteachererror'] = 'এ বৈশিষ্ট্য ব্যবহার করতে হলে আপনাকে শিক্ষক হতে হবে।';
$string['nousersloaded'] = 'কোন ব্যবহার করা হয়নি';
$string['numberofgrades'] = 'গ্রেডের নাম্বার';
$string['onascaleof'] = 'এর স্কেলে {$a->grademin} to {$a->grademax}';
$string['operations'] = 'অপারেশন';
$string['options'] = 'অপশন';
$string['outcome'] = 'আউটকাম';
$string['outcomeassigntocourse'] = 'এ কোর্সে অন্য আউটকাম এসাইন';
$string['outcomecategory'] = 'ক্যাটেগরিতে আউটকাম তৈরি';
$string['outcomecategorynew'] = 'নতুন ক্যাটেগরি';
$string['outcomeconfirmdelete'] = 'আপনি কি নিশ্চিত যে আউটকাম "{$a}" অপসারণ করতে চান?';
$string['outcomecreate'] = 'নতুন আউটককাম যোগ';
$string['outcomedelete'] = 'আউটকাম মুছে ফেলা';
$string['outcome_help'] = 'এ সেটইং আউটকাম নির্ধারণ করে যা গ্রেডবুকে এ গ্রেড আইটেম বুঝাবে।';
$string['outcomeitem'] = 'আউটকাম আইটেম';
$string['outcomeitemsedit'] = 'আউটকাম আইটেম সম্পাদনা';
$string['outcomereport'] = 'আউটকাম রিপোর্ট';
$string['outcomes'] = 'আউটকাম';
$string['outcomescourse'] = 'কোর্সে ব্যবহৃত আউটকাম';
$string['outcomescoursecustom'] = 'স্বনির্ধারিত ব্যবহার (অপসারণ হবে না)';
$string['outcomescoursenotused'] = 'আদর্শ ব্যবহার করা হয়নি';
$string['outcomescourseused'] = 'আদর্শ ব্যবহার (অপসারণ হবে না)';
$string['outcomescustom'] = 'স্বনির্ধারিত আউটকাম';
$string['outcomesstandard'] = 'আদর্শ আউটকাম';
$string['outcomesstandardavailable'] = 'বিদ্যমান আদর্শ আউটকাম';
$string['outcomestandard'] = 'আদর্শ আউটকাম';
$string['outcomestandard_help'] = 'সাইট-ওয়াইডে আদর্শ আউটকাম বিদ্যমান, সব কোর্সের জন্য।';
$string['overallaverage'] = 'সামগ্রিক গড়';
$string['overridden'] = 'উপরিলিখন';
$string['overridden_help'] = 'যদি চিহ্ন দেওয়া থাকে, সম্পর্কিত অ্যাক্টিভিটিতে গ্রেড আর পরিবর্তিত হবেনা।

গ্রেডার প্রতিবেদনে যখন একটি গ্রেড সম্পাদিত হয়, তখন অগ্রাহ্যকৃত চেকবক্স স্বয়ংক্রিভাবে চিহ্ন দেওয়া হবে। যদিও চিহ্নিত না করলে সম্পর্কিত অ্যাক্টিভিটির মাধ্যমে গ্রেড পরিবর্তিত হওয়া অনুমোদন করে।';
$string['overriddennotice'] = 'এ অ্যাক্টিভিটির জন্য আপনার চুড়ান্ত গ্রেড নিজ হাতে মানানসই করা হয়েছিল।';
$string['overridesitedefaultgradedisplaytype'] = 'উপেক্ষা করা সাইট ডিফল্ট';
$string['overridesitedefaultgradedisplaytype_help'] = 'যদি চিহ্নিত করা থাকে, কোর্সের জন্য সাইটের পূর্বনির্ধারিত কিছু ব্যবহার না করে গ্রেড লেটার এবং বাউন্ডারি নির্ধারণ করা যেতে পারে।';
$string['parentcategory'] = 'প্যারেন্ট ক্যাটেগরি';
$string['pctoftotalgrade'] = 'মোট গ্রেডের %';
$string['percent'] = 'শতকরা';
$string['percentage'] = 'শতকরা হার';
$string['percentageletter'] = 'শতকরা হার (অক্ষর)';
$string['percentagereal'] = 'শতকরা হার (আসল)';
$string['percentascending'] = 'শতকরা আরোহী হিসেবে সাজানো';
$string['percentdescending'] = 'শতকরা অবরোহী হিসেবে সাজানো';
$string['percentshort'] = '%';
$string['plusfactor'] = 'অফসেট';
$string['plusfactor_help'] = 'অফসেট একটি সংখ্যা যা গুনকরাশি যোগ করার পর এ গ্রেড আইটেমের প্রত্যেক গ্রেডে যোগ করা হয়।';
$string['points'] = 'পয়েন্ট';
$string['pointsascending'] = 'শতকরা আরোহী হিসেবে সাজানো';
$string['pointsdescending'] = 'শতকরা অবরোহী হিসেবে সাজানো';
$string['positionfirst'] = 'প্রথম';
$string['positionlast'] = 'শেষ';
$string['preferences'] = 'পছন্দসমূহ';
$string['prefgeneral'] = 'সাধারণ';
$string['prefletters'] = 'গ্রেডের অক্ষর এবং সীমা';
$string['prefrows'] = 'বিশেষ সারি';
$string['prefshow'] = 'টোগল প্রদর্শন করা/আড়াল করা';
$string['previewrows'] = 'প্রাকদর্শন সারি';
$string['profilereport'] = 'ব্যবহারকারী প্রোফাইল রপোর্ট';
$string['profilereport_help'] = 'ব্যবহারকারী প্রোফাইল পৃষ্ঠায় গ্রেড রিপোর্ট ব্যবহার।';
$string['publishing'] = 'প্রকাশ';
$string['quickfeedback'] = 'কুইক ফিডব্যাক';
$string['quickgrading'] = 'কুইক গ্রেডিং';
$string['quickgrading_help'] = 'যদি সক্রিয় থাকে, যখন সম্পাদনা চালু করা থাকে, তখন প্রত্যেক গ্রেডের জন্য একটি টেক্সট ইনপুট বাক্স প্রকাশিত হয়, যা অনেক গ্রেড একই সময় সম্পাদনের অনুমতি দেয়। যখন হালনাগাদ বোতাম ক্লিক করা থাকে তখন পরিবর্তন সংরক্ষিত থাকবে এবং হাইলাইটকৃত হবে।

মনে রাখবেন গ্রেডার প্রতিবেদনে যখন গ্রেড সম্পাদিত হবে, তখন অগ্রাহ্যকৃত ফ্ল্যাগ নির্ধারিত হবে, এতে করে সম্পর্কিত অ্যাক্টিভিটি থেকে কোন গ্রেড আর পরিবর্তন করা যাবেনা।';
$string['range'] = 'সীমা';
$string['rangesdecimalpoints'] = 'সীমায় দশমিক প্রদর্শন';
$string['rangesdecimalpoints_help'] = 'এ সেটিং নির্ধারন করে প্রত্যেক সীমার জন্য প্রদর্শিত দশমিক পয়েন্টের সংখ্যা অথবা এ বিভাগ বা গ্রেড আইটেমে সার্বিক দশমিক পয়েন্ট ব্যবহৃত হবে কিনা (ইনহেরিট)।';
$string['rangesdisplaytype'] = 'সীমা প্রদর্শন ধরণ';
$string['rangesdisplaytype_help'] = 'এ সেটিং নির্ধরন করে যে  সীমা প্রকৃত গ্রেড হিসাবে, শতকরা হার, লেটার হিসাবে প্রর্দর্শিত হবে কিনা অথবা বিভাগ বা গ্রেড আইটেমের ধরণ হিসাবে ব্যবহৃত কিনা (ইনহেরিট)।';
$string['rank'] = 'র্‍যাংক';
$string['rawpct'] = 'অশোধিত %';
$string['real'] = 'আসল';
$string['realletter'] = 'আসল (অক্ষর)';
$string['realpercentage'] = 'আসল (শতকরা হার)';
$string['regradeanyway'] = 'রিগ্রেড করা হবে';
$string['removeallcoursegrades'] = 'সব গ্রেড মুছে ফেলা';
$string['removeallcourseitems'] = 'সব আইটেম এবং ক্যাটেগরি মুছে ফেলা';
$string['report'] = 'রিপোর্ট';
$string['reportdefault'] = 'ডিফল্ট রিপোর্ট ({$a})';
$string['reportplugins'] = 'রিপোর্ট প্লাগইন';
$string['reportsettings'] = 'রিপোর্ট সেটিং';
$string['reprintheaders'] = 'শীর্ষচরণ পুনরায় মুদ্রণ';
$string['respectingcurrentdata'] = 'বর্তমান কনফিগারেশন অপরিবর্তিত রাখা হয়';
$string['rowpreviewnum'] = 'সারি প্রাকদর্শন';
$string['savechanges'] = 'পরিবর্তন সংরক্ষন';
$string['savepreferences'] = 'পছন্দসমূহ সংরক্ষণ';
$string['scaleconfirmdelete'] = 'আপনি কি সত্যিই স্কেল "{$a}" অপসারণ করার ব্যাপারে নিশ্চিত?';
$string['scaledpct'] = 'আকার পরিবর্তিত %';
$string['seeallcoursegrades'] = 'সব কোর্সের গ্রেড দেখা';
$string['selectalloroneuser'] = 'সব বা একজন ব্যবহারকারী নির্বাচন';
$string['selectauser'] = 'ব্যবহারকারী নির্বাচন';
$string['selectdestination'] = 'গন্তব্য নির্বাচন {$a}';
$string['separator'] = 'বিভাজক';
$string['sepcomma'] = 'কমা';
$string['septab'] = 'ট্যাব';
$string['setcategories'] = 'ক্যাটেগরি সেট করা';
$string['setcategorieserror'] = 'কোর্সে ওয়েট দেয়ার আগে প্রথমে কোর্সে বিভাগ নির্ধরণ করে নিতে হবে।';
$string['setgradeletters'] = 'গ্রেডের অক্ষর সেট করা';
$string['setpreferences'] = 'পছন্দসমূহ নির্ধারণ';
$string['setting'] = 'সেটিং';
$string['settings'] = 'সেটিং';
$string['setweights'] = 'ওয়েট সেট করা';
$string['showactivityicons'] = 'অ্যাক্টিভিটি আইকন প্রদর্শন';
$string['showactivityicons_help'] = 'যদি সক্রিয় করা হয় তবে, অ্যাক্টিভিটি নামের পাশে অ্যাক্টিভিটির আইকন প্রদর্শিত হয়।';
$string['showallhidden'] = 'আড়ালে প্রদর্শন';
$string['showallstudents'] = 'সব শিক্ষার্থী প্রদর্শন';
$string['showaverages'] = 'কলাম গড় প্রদর্শন';
$string['showaverages_help'] = 'যদি সক্রিয় করা থাকে, গ্রেডার রিপোর্টে প্রত্যেক বিভাগ এবং গ্রেড আইটেমের গড় (গড়) মান প্রদর্শনের জন্য একটি অতিরিক্ত সারি থাকবে।';
$string['showcalculations'] = 'গণনা প্রদর্শন';
$string['showcalculations_help'] = 'যদি সক্রিয় করা হয়, যখন সম্পাদনা চালু করা হয়, প্রত্যেক গ্রেড আইটেম এবং বিভাগের জন্য ক্যালকুলেটর আইকন, গণানকৃত আইটেমের টুল টিপ এবং ভিজুয়াল সূচক যেখানে কলাম গণনা করা হয় প্রদর্শিত হয়।';
$string['showeyecons'] = 'প্রদর্শন করা/আড়াল করা আইকন';
$string['showeyecons_help'] = 'যদি সক্রিয় করা থাকে তবে, যখন সম্পাদনা চালু বা বন্ধ করা হয় তবে, শিক্ষার্থীর কাছে এর দৃশ্যমানতা নিয়ন্ত্রন করার জন্য একটি প্রদর্শন/আড়াল করার আইকন প্রদর্শন করা হয়।';
$string['showfeedback'] = 'মন্তব্য প্রদর্শন';
$string['showgroups'] = 'গ্রুপ প্রদর্শন';
$string['showhiddenitems'] = 'লুকানো আইটেম প্রদর্শন';
$string['showhiddenitems_help'] = 'শিক্ষার্থীদের কাছে আড়ালকৃত গ্রেড আইটেম সম্পূর্ণ আড়ালে থাকবে অথবা আড়ালকৃত গ্রেড আইটেমের নাম দৃশ্যমান থাকবে।

* আড়ালকৃত প্রদর্শন - আড়ালকৃত গ্রেড আইটেমের নাম প্রদর্শিত হবে কিন্তু শিক্ষার্থীদের গ্রেড আড়ালে থাকবে।
* শুধুমাত্র ততক্ষণ আড়াল - "ততক্ষণ আড়াল"সহ তারিখ নির্ধারণ করলে গ্রেড আইটেম নির্ধারিত তারিখ পর্যন্ত সম্পূর্ণ আড়াল থাকবে, এই তারিখের পর সব আইটেম প্রদর্শিত হবে
* প্রদর্শিত হবেনা - আড়ালকৃত গ্রেড আইটেম সম্পূর্ণ আড়াল';
$string['showhiddenuntilonly'] = 'ততক্ষণ আড়ালে থাকবে';
$string['showlocks'] = 'লক প্রদর্শন';
$string['showlocks_help'] = 'যদি সক্রিয় করা তাকে তবে, সম্পাদনা চালু থাকলে, প্রত্যেক গ্রেডে সম্পর্কিত অ্যাক্টিভিটি দ্বারা স্বয়ংক্রিয়ভাবে হালনাগাদ করা হবে কিনা তা লক/আনলক আইকন প্রদর্শন করে নিয়ন্ত্রন করা যায়।';
$string['shownohidden'] = 'দেখানো হবে';
$string['shownooutcomes'] = 'আউটকাম আড়াল করা';
$string['shownumberofgrades'] = 'গড় হিসাবে গ্রেড নাম্বার প্রদর্শন';
$string['shownumberofgrades_help'] = 'যদি সক্রিয় করা থাকে তবে, প্রত্যেক গড়ের জন্য গড় (গড়) মান গণনা করার সময় ব্যবহৃত গ্রেড নাম্বার বন্ধনীর ভেতর প্রদর্শিত হয়।';
$string['showpercentage'] = 'শতকরা হার প্রদর্শন';
$string['showpercentage_help'] = 'প্রত্যেক গ্রেড আইটেমের শতকরা হারের মান প্রদর্শন করা হবে কিনা তা এ সেটিং নির্ধারন করে।';
$string['showquickfeedback'] = 'কুইক মন্তব্য প্রদর্শন';
$string['showquickfeedback_help'] = 'যদি সক্রিয় করা থাকে তবে, সম্পাদনা চালু থাকলে, প্রত্যেক গ্রেডের জন্য ডটেড সীমানাসহ মন্তব্য টেক্সট ইনপুট বাক্স আসে, যা একই সময়ে অনেকগুলো গ্রেডের জন্য মন্তব্য সম্পাদনা করা অনুমোদন করে। হালনাগাদ করার বোতাম ক্লিক করলে পরিবর্তন সংরক্ষন এবং হাইলাইটকৃত হয়।

মনে রাখুন যে, গ্রেডার রিপোর্টে যখন মন্তব্য সম্পাদনা করা হয়, উপেক্ষা করার ফ্ল্যাগ নির্ধারণ করা হয়, যা থেকে বুঝায় যে, সম্পর্কিড অ্যাক্টিভিটির মধ্যেও আর মন্তব্য পরিবর্তন করা যাবে না।';
$string['showranges'] = 'সীমা প্রদর্শন';
$string['showranges_help'] = 'যদি সক্রিয় করা থাকে তবে, গ্রেডার রিপোর্টে একটি অতিরিক্ত সারি থাকবে যেখানে প্রত্যেক বিভাগ এবং গ্রেড আইটেমের জন্য সীমা প্রদর্শিত হবে।';
$string['showrank'] = 'স্তর প্রদর্শন';
$string['showrank_help'] = 'এ সেটিং নির্ধারণ করে যে প্রত্যেক গ্রেড আইটেমের জন্য ক্লাসের অন্যান্য শিক্ষার্থীর তুলনায় শিক্ষার্থীর অবস্থান কোথায়।';
$string['showuserimage'] = 'ব্যবহারকারী প্রোফাইল ছবি প্রদর্শন';
$string['showuserimage_help'] = 'গ্রেডার রিপোর্টে ব্যবহারকারীর নামের পাশে প্রোফাইল চিত্র প্রদর্শন করা হবে কিনা।';
$string['showverbose'] = 'প্রদর্শন {$a->category} {$a->itemmodule} {$a->itemname}';
$string['simpleview'] = 'সহজ প্রদর্শন';
$string['sitewide'] = 'সাইট-ওয়াইড';
$string['sort'] = 'ক্রমানুসারে সাজান';
$string['sortasc'] = 'আরোহী বিন্যাসে সাজানো';
$string['sortbyfirstname'] = 'নামের প্রথম অংশ অনুযায়ী সাজানো';
$string['sortbylastname'] = 'নামের শেষাংশ অনুযায়ী সাজানো';
$string['sortdesc'] = 'অবরোহী বিন্যাসে সাজানো';
$string['standarddeviation'] = 'পরিমিত বিচ্যুতি';
$string['stats'] = 'পরিসংখ্যান';
$string['statslink'] = 'পরিসংখ্যান';
$string['student'] = 'শিক্ষার্থী';
$string['studentsperpage'] = 'প্রতি পৃষ্ঠায় শিক্ষার্থী';
$string['studentsperpage_help'] = 'এ সেটিং নির্ধারণ করে যে গ্রেডার রিপোর্টের প্রতি পৃষ্ঠায় কত সংখ্যক শিক্ষার্থী প্রদর্শন করা হয়।';
$string['subcategory'] = 'সাধারণ ক্যাটেগরি';
$string['submissions'] = 'জমাদেয়া';
$string['submittedon'] = 'জমাকৃত: {$a}';
$string['switchtofullview'] = 'সম্পূর্ণ প্রদর্শনে যাওয়া';
$string['switchtosimpleview'] = 'সহজ প্রদর্শনে যাওয়া';
$string['tabs'] = 'ট্যাব';
$string['topcategory'] = 'সুপার শ্রেণী';
$string['total'] = 'সর্বমোট';
$string['totalweight100'] = 'মোট ওয়েট ১০০ এর সমান';
$string['totalweightnot100'] = 'মোট ওয়েট ১০০ এর সমান নয়';
$string['turnfeedbackoff'] = 'মন্তব্য বন্ধ করা';
$string['turnfeedbackon'] = 'মন্তব্য চালু করা';
$string['typenone'] = 'কোনটি না';
$string['typescale'] = 'স্কেল';
$string['typescale_help'] = 'স্কেলগ্রেডের ধরণ ব্যবহার করার সময় এ সেটিং স্কেল নির্ধারন করে। অ্যাক্টিভিটি সেটিং পৃষ্ঠায় অ্যাক্টিভিটি ভিত্তিক গ্রেড আইটেমের স্কেল নির্ধারণ।';
$string['typetext'] = 'লেখা';
$string['typevalue'] = 'মান';
$string['uncategorised'] = 'ক্যাটেগরি করা হয়নি';
$string['unchangedgrade'] = 'গ্রেড অপরিবর্তিত';
$string['unenrolledusersinimport'] = 'যেসব ব্যবহারকারী বর্তমানে এই কোর্সে এনরোলকৃত নয় সেসব গ্রেড ইম্পোর্ট করে: {$a}';
$string['unlimitedgrades'] = 'অপরিসীম গ্রেড';
$string['unlimitedgrades_help'] = 'পূর্বনির্ধারিতভাবে গ্রেড আইটেমের গ্রেড সর্বোচ্চ এবং সর্বনিম্ন মানের মধ্যে সীমাবদ্ধ। এ সেটিং সক্রিয় করলে মানের এই আর থাকে না, এবং 100% এর উপর গ্রেড সরাসরি গ্রেডবুকে দিয়ে দেয়া যায়। এ সেটিং অফপিক সময়ে সক্রিয় করার জন্য সুপারিশ করা হয় , যেহেতু সব গ্রেড পুনরায় গণনা করা হবে ফলে সার্ভারে উচ্চমাত্রায় চাপ সৃষ্টি হতে পারে';
$string['unlock'] = 'অনবরুদ্ধ';
$string['unlockverbose'] = 'অনবরুদ্ধ {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'অব্যবহৃত';
$string['updatedgradesonly'] = 'শুধু নতুন বা আপডেটকৃত গ্রেড এক্সপোর্ট';
$string['uploadgrades'] = 'গ্রেড আপলোড';
$string['useadvanced'] = 'উচ্চ পর্যায়ের বৈশিষ্ট্য ব্যবহার';
$string['usedcourses'] = 'ব্যবহৃত কোর্স';
$string['usedgradeitem'] = 'ব্যবহৃত গ্রেড আইটেম';
$string['usenooutcome'] = 'আউটকাম ব্যবহার না করা';
$string['usenoscale'] = 'স্কেল ব্যবহার না করা';
$string['usepercent'] = 'শতকরা ব্যবহার';
$string['user'] = 'ব্যবহারকারী';
$string['usergrade'] = 'ব্যবহারকারী {$a->fullname} ({$a->useridnumber}) এই আইটেমে {$a->gradeidnumber}';
$string['userpreferences'] = 'ব্যবহারকারী পছন্দসমূহ';
$string['useweighted'] = 'ওয়েটেড ব্যবহার করা';
$string['verbosescales'] = 'ভার্বোজ স্কেল';
$string['viewbygroup'] = 'গ্রুপ';
$string['viewgrades'] = 'গ্রেড প্রদর্শন';
$string['warningexcludedsum'] = 'সতর্কীকরণ: গ্রেডের এক্সক্লুডিং মোট এগ্রিগেশনের সাথে সঙ্গতিপূর্ণ নয়।';
$string['weight'] = 'ওয়েট';
$string['weightcourse'] = 'কোর্সের জন্য ওয়েটেড গ্রেড ব্যবহার';
$string['weightedascending'] = 'আরোহী ওয়েটেড শতকরা হার অনুযায়ী সাজানো';
$string['weighteddescending'] = 'অবরোহী ওয়েটেড শতকরা হার অনুযায়ী সাজানো';
$string['weightedpct'] = 'ওয়েটেড %';
$string['weightedpctcontribution'] = 'ওয়েটেড % কনট্রিবিউশন';
$string['weightorextracredit'] = 'ওয়েট বা অতিরিক্ত ক্রেডিট';
$string['weights'] = 'ওয়েট';
$string['weightsedit'] = 'ওয়েট এবং অতিরিক্ত ক্রেডিট ব্যবস্থাপনা';
$string['weightuc'] = 'ওয়েট';
$string['writinggradebookinfo'] = 'লেখার গ্রেডবুকের সেটিং';
$string['xml'] = 'XML';
$string['yes'] = 'হ্যাঁ';
$string['yourgrade'] = 'তোমার গ্রেড';
