<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'bn', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsubmission'] = 'জমা সংযুক্ত';
$string['allowdeleting'] = 'অপসারণ অনুমোদন';
$string['allowdeleting_help'] = 'যদি সক্রিয় করা তবে, শিক্ষার্থীরা গ্রেডিং এর জন্য জমা দেয়ার আগে যেকোনো সময় আপলোডকৃত ফাইল অপসারণ করে দিতে পারে।';
$string['allowmaxfiles'] = 'আপলোডকৃত ফাইলের সর্বোচ্চ সংখ্যা';
$string['allowmaxfiles_help'] = 'আপলোড করার মত সর্বোচ্চসংখ্যক ফাইল। যেহেতু এ কাঠামোটি কোথাও প্রদর্শিত হয়নি, এসাইমেন্টের বর্ণনায় এটা উল্লেখ করা আছে বলে পরামর্শ দেয়া আছে।';
$string['allownotes'] = 'টীকা অনুমোদন';
$string['allownotes_help'] = 'যদি সক্রিয় করা থাকে, টেক্সট এরিয়ায় ছাত্ররা অনলাইন টেক্সট এর এসাইনমেন্ট এর মত টীকা যোগ করতে পারে।';
$string['allowresubmit'] = 'পুনরায় জমাদান অনুমোদন';
$string['allowresubmit_help'] = 'যদি সক্রিয় করা হয়, গ্রেড দিয়ে দেয়ার পরও আবার ছাত্ররা এসাইনমেন্ট পুনরায় জমা দিতে পারবে (তাদেরকে পুনরায় গ্রেড দেয়ার  জন্য)';
$string['alreadygraded'] = 'আপনার এসাইনমেন্ট এ ইতোমধ্যে গ্রেড দিয়ে দেয়া হয়েছে এবং পুনরায় জমা দেয়া অনুমোদিত নয়।';
$string['assignment:addinstance'] = 'নতুন প্রতিবেদন যোগ করুন';
$string['assignmentdetails'] = 'এসাইনমেন্ট এর বিস্তারিত বর্ণনা';
$string['assignment:exportownsubmission'] = 'নিজের জমা এক্সপোর্ট করা';
$string['assignment:exportsubmission'] = 'জমা এক্সপোর্ট';
$string['assignment:grade'] = 'এসাইনমেন্টে গ্রেড';
$string['assignmentmail'] = '{$a->teacher} আপনার \'{$a->assignment}\' এর
এসাইনমেন্ট জমা দেয়ার ব্যাপারে মতামত দিয়েছেন

আপনি এটা আপনার এসাইমেন্টে সংযুক্ত অবস্থায় দেখতে পাবেন:

    {$a->url}';
$string['assignmentmailhtml'] = '{$a->teacher} আপনার \'<i>{$a->assignment}</i>\'<br /><br />\' এর
এসাইনমেন্ট জমা দেয়ার ব্যাপারে মতামত দিয়েছেন
আপনি এটা আপনার <a href="{$a->url}">assignment submission</a> এ সংযুক্ত অবস্থায় দেখতে পাবেন।';
$string['assignmentname'] = 'এসাইমেন্টের নাম';
$string['assignmentsubmission'] = 'এসাইনমেন্ট জমা';
$string['assignment:submit'] = 'এসাইনমেন্ট জমা';
$string['assignmenttype'] = 'এসাইনমেন্টের ধরণ';
$string['assignment:view'] = 'এসাইমেন্ট প্রদর্শন';
$string['availabledate'] = 'পাওয়া যায়';
$string['cannotdeletefiles'] = 'ত্রুটি হয়েছে এবং ফাইল অপসারন করা যাচ্ছেনা';
$string['cannotviewassignment'] = 'আপনি এ এসাইনমেন্ট দেখতে পাবেননা';
$string['comment'] = 'মন্তব্য';
$string['commentinline'] = 'ইনলাইন মন্তব্য';
$string['commentinline_help'] = 'যদি সক্রিয় করা থাকে তবে, গ্রেডিং এর সময় ইনলাইন মন্তব্য করা বা মূল টেক্সট সম্পাদনা (ভিন্ন ধরণের রং ব্যবহার) করার জন্য জমার টেক্সটটি মতামতের মন্তব্য এরিয়ায় অনুলিপি করে রাখা হবে।';
$string['configitemstocount'] = 'অনলাইন এসাইনমেন্ট জমা দানের ক্ষেত্রে ছাত্রদের জন্য কিভাবে আইটেমগুলো গণনা করার ধরণ।';
$string['configmaxbytes'] = 'সাইটে সকল এসাইনমেন্টের জন্য পূর্বনির্ধারিত সর্বোচ্চ আকার (কোর্সের পরিধির মধ্যে বিষয় এবং অন্যান্য স্থানীয় সেটিং)';
$string['configshowrecentsubmissions'] = 'সাম্প্রতিক কার্যকলাপের রিপোর্টে জমার ঘোষনা সবাই দেখতে পারে।';
$string['confirmdeletefile'] = 'আপনি কি এ ফাইল অপসারণ করার ব্যাপারে নিশ্চিত?<br /><strong>{$a}</strong>';
$string['coursemisconf'] = 'কোর্সটিকে ঠিকভাবে কনফিগার করা হয়নি';
$string['currentgrade'] = 'গ্রেডবুকে বর্তমান গ্রেড';
$string['deleteallsubmissions'] = 'সব জমা অপসারণ';
$string['deletefilefailed'] = 'ফাইল অপসারণ ব্যর্থ';
$string['description'] = 'বর্ণনা';
$string['downloadall'] = 'সব এসাইনমেন্ট জিপ করা অবস্থায় ডাউনলোড';
$string['draft'] = 'ড্রাফ্ট';
$string['due'] = 'এসাইমেন্ট জমা';
$string['duedate'] = 'নির্ধারিত মেয়াদ';
$string['duedateno'] = 'নির্ধারিত মেয়াদ নেই';
$string['early'] = '{$a} আগে';
$string['editmysubmission'] = 'আমার জমাকৃতটি সম্পাদনা';
$string['editthesefiles'] = 'এ ফাইল সম্পাদনা';
$string['editthisfile'] = 'এ ফাইল হালনাগাদ করা';
$string['emailstudents'] = 'ছাত্রদের জন্য ইমেইল এর মাধ্যমে সতর্কবার্তা';
$string['emailteachermail'] = '{$a->timeupdated} এ {$a->timeupdated} তাদের \'{$a->assignment} এর জন্য এসাইনমেন্ট জমা হালনাগাদ করে নিয়েছে

এখানে পাওয়া যায়:

    {$a->url}';
$string['emailteachermailhtml'] = '{$a->timeupdated} এ {$a->timeupdated} তাদের<i> \'{$a->assignment} এর জন্য এসাইনমেন্ট জমা হালনাগাদ করে নিয়েছে</i><br /><br />
এটা এ ওয়েবসাইটে <a href="{$a->url}"> পাওয়া যায়</a>।';
$string['emailteachers'] = 'শিক্ষকদের জন্য ইমেইল এর মাধ্যমে সতর্কবার্তা';
$string['emailteachers_help'] = 'যদি সক্রিয় করা থাকে তবে, কোনো ছাত্র এসাইনমেন্ট জমা কিছু যোগ করে বা হালনাগাদ করে তখন শিক্ষক ইমেইলের সাহায্যে ঘোষনাটি পেয়ে যায়।

যে শিক্ষকগন ঐ নির্দিষ্ট এসাইনমেন্টে গ্রেড দিতে পারবে তারাই কেবল ঘোষনাটি পাবে। সুতরাং, উদাহরণস্বরূপ, যদি কোর্সে বিভিন্ন গ্রুপ থাকে তবে নির্দিষ্ট গ্রুপের শিক্ষক অন্য গ্রুপের ছাত্রদের জন্য কোনো ঘোষনা পাবে না।';
$string['emptysubmission'] = 'আমরা এখনও কিছু জমা দেয়নি';
$string['enablenotification'] = 'ইমেইলের মাধ্যমে ঘোষনা প্রেরণ';
$string['enablenotification_help'] = 'যদি সক্রিয় করা থাকে, ছাত্রদের এসাইনমেন্টে যখন গ্রেড দেয়া হবে তখন তারা ইমেইলের মাধ্যমে ঘোষনা পাবে।';
$string['errornosubmissions'] = 'ডাউনলোড করার মত কিছু জমা দেয়া হয়নি';
$string['existingfiledeleted'] = 'বিদ্যমান ফাইলটি অপসারণ করা হয়েছে: {$a}';
$string['failedupdatefeedback'] = 'ব্যবহারকারীর জন্য {$a} জমার মন্তব্য হালনাগাদ করতে ব্যর্থ';
$string['feedback'] = 'মন্তব্য';
$string['feedbackfromteacher'] = '{$a} এর মন্তব্য';
$string['feedbackupdated'] = '{$a} ব্যাক্তিবর্গের জন্য জমা দেয়ার মন্তব্য হালনাগাদ';
$string['finalize'] = 'জমার হালনাগাদ প্রতিরোধ';
$string['finalizeerror'] = 'ত্রুটি হয়েছে এবং জমা করা আর চুড়ান্ত করা যাচ্ছেনা';
$string['graded'] = 'গ্রেড';
$string['guestnosubmit'] = 'দুঃখিত, অতিথিগন কোনো এসাইনমেন্ট জমা দিতে পারবে না। কোনো উত্তর জমা দিতে হলে আপনাকে অবশ্যই লগইন বা নিবন্ধন করতে হবে।';
$string['guestnoupload'] = 'দুঃখিত, কোনো অতিথি আপলোড করতে অনুমোদিত নয়';
$string['helpoffline'] = '<p> যখন মুডলের বাহিরে এসাইনমেন্ট করার ক্ষেত্রে এটা খুবই কার্যকরী। এটা ওয়েব এর বাহিরে বা সরাসরি
   হতে পারে।</p><p>ছাত্ররা এসাইনমেন্টের বর্ণনা দেখতে পায়,
   কিন্তু ফাইল আপলোড বা অন্য কিছু করতে পারেনা।  গ্রেডিং সাধারণভাবেই চলতে থাকে, এবং ছাত্ররা নিজেরা তাদের গ্রেডের জন্য ঘোষনা পেয়ে যাবে।</p>';
$string['helponline'] = '<p>এ  ধরন এসাইমেন্টে ব্যবহারকারীকে সাধারণ সম্পাদনার টুলের সাহায্যে টেক্সট
   সম্পাদনা করার ব্যাপারে জিজ্ঞাসা করা হয়। শিক্ষক সেগুলোতে অনলাইনে গ্রেড দিতে পারে এবং এমনকি কোনো মন্তব্য বা পরিবর্তনও করতে পারে।</p>
   <p>(আপনি যদি মুডলে পুরাতন সংস্করণের সাথে পূর্বপরিচিত হয়ে থাকেন সেক্ষেত্রে এ ধরণের এসাইনমেন্ট
   পুরাতন জার্নাল মডিউল এর মত একইভাবে কাজ করে।)</p>';
$string['helpupload'] = '<p>এ ধরণের এসাইনমেন্ট যে কোনো বিন্যাসে এক বা একাধিক ফাইল আপলোড করার জন্য অংশগ্রহণকারীকে অনুমোদন দেয়।
   এটা হতে পারে ওয়ার্ড প্রসেসর, নথি, চিত্র, জিপ করা ওয়েবসাইট, অথবা আপনি যা কিছু জমা দিতে বলেন।</p>
   <p>এছাড়াও বিভিন্ন ধরনের জবাবের ফাইল আপলোড করাও অনুমোদন করে। জবাবের ফাইলগুলো জমা দেয়ার পূর্বেই আপলোড করা যায়, যা
   প্রত্যেক অংশগ্রহণকারীকে বিভিন্ন ফাইল নিয়ে কাজ করার ক্ষেত্রে ব্যবহার করা হয়।</p>
   <p>অংশগ্রহণকারীরা জমাকৃত ফাইল, অগ্রগতির অবস্থান বা যেকোনো টেক্সট এর তথ্যের বর্ণনা দিয়ে নোট লিখতে পারে।</p>
   <p>এ ধরণের এসাইনমেন্ট জমা নিজ হাতে দিতে হয়। আপনি যেকোনো সময় বর্তমান অবস্থা
   রিভিউ করতে, অসম্পূর্ণ এসাইনমেন্ট ড্রাফ্ট হিসাবে চিহ্নিত করতে পারেন। আপনি যেকোনো আনগ্রেডকৃ এসাইনমেন্ট ড্রাফ্টে প্রত্যাবর্তন করাতে পারেন।</p>';
$string['helpuploadsingle'] = '<p>এ ধরণের এসাইনমেন্ট প্রত্যেক অংশগ্রহণকারীকে
   একটি করে ফাইল আপলোড করা অনুমোদন করে।</p> <p>এটা হতে পারে একটি ওয়ার্ড প্রসেসর নথি, চিত্র,
   একটি জিপ করা ওয়েবসাইট, বা আপনি যা জমা দিতে বলেন তাই হতে পারে।</p>';
$string['hideintro'] = 'বিদ্যমান তারিখের আগে বর্ণনা আড়াল করে রাখুন';
$string['hideintro_help'] = 'যদি সক্রিয় করা হয়, "কবে তারিখ থেকে পাওয়া যাবে" সে তারিখের এসাইনমেন্টের বর্ণনা আড়ালকৃত থাকে। শুধুমাত্র এসাইনমেন্ট এর নাম প্রদর্শিত হয়।';
$string['invalidassignment'] = 'ভুল এসাইনমেন্ট';
$string['invalidfileandsubmissionid'] = 'ফাইল বা জমাকৃত আইডি পাওয়া যাচ্ছে না';
$string['invalidid'] = 'এসাইনমেন্টের আইডি ভুল ছিল';
$string['invalidsubmissionid'] = 'অবৈধ জমা আইডি';
$string['invalidtype'] = 'এসাইনমেন্ট এর ধরণ ভুল';
$string['invaliduserid'] = 'ব্যবহারকারীর অকার্যকর আইডি';
$string['itemstocount'] = 'গণনা';
$string['lastgrade'] = 'শেষ গ্রেড';
$string['late'] = '{$a} দেরী';
$string['maximumgrade'] = 'সর্বোচ্চ গ্রেড';
$string['maximumsize'] = 'সর্বোচ্চ আকার';
$string['maxpublishstate'] = 'নির্ধারিত মেয়াদের আগে ব্লগের সর্বোচ্চ দৃশ্যমানতা';
$string['messageprovider:assignment_updates'] = 'এসাইনমেন্ট এর ঘোষনা';
$string['modulename'] = 'এসাইনমেন্ট (2.2)';
$string['modulename_help'] = 'এসাইনমেন্ট শিক্ষককে অনলাইন বা অফলাইন কাজে যেখানে গ্রেড দেয়া যায় তা নির্দিষ্ট করা সক্রিয় করে।';
$string['modulenameplural'] = 'এসাইনমেন্ট';
$string['newsubmissions'] = 'এসাইনমেন্ট জমা';
$string['noassignments'] = 'এখন পর্যন্ত কোনো এসাইনমেন্ট নেই';
$string['noattempts'] = 'এ এসাইনমেন্টে কেউ অংশগ্রহন করেনি';
$string['noblogs'] = 'আপনার জমা দেয়ার মত কোনো ব্লগ এন্ট্রি নেই!';
$string['nofiles'] = 'কোনো ফাইল জমা দেয়া হয়নি';
$string['nofilesyet'] = 'কোনো ফাইল জমা দেয়া হয়নি';
$string['nomoresubmissions'] = 'আর কোনো জমা অনুমোদিত নয়';
$string['norequiregrading'] = 'প্রয়োজনীয় গ্রেডিং কেন এসাইনমেন্ট নেই';
$string['nosubmisson'] = 'কোন এসাইনমেন্ট জমা হয়েছে';
$string['notavailableyet'] = 'দুঃখিত, এ এসাইনমেন্ট এখনও পাওয়া যায়নি।<br />এসাইনমেন্টের তথ্য নিমোক্ত তারিখে প্রদর্শিত হবে।';
$string['notes'] = 'নোট';
$string['notesempty'] = 'প্রবেশ নিষেধ';
$string['notesupdateerror'] = 'নোট হালনাগাদ করার সময় ত্রুটি';
$string['notgradedyet'] = 'এখনও গ্রেড দেয়া হয়নি';
$string['notsubmittedyet'] = 'এখনও জমা দেয়া হয়নি';
$string['onceassignmentsent'] = 'একবার নম্বর প্রদানের জন্য এসাইনমেন্ট দিয়ে ফেললে আপনি আর ';
$string['operation'] = 'অপারেশন';
$string['optionalsettings'] = 'ঐচ্ছিক সেটিং';
$string['overwritewarning'] = 'সতর্কীকরণ: আবার আপলোড করলে আপনার বর্তমানে জমাকৃতটি REPLACE হয়ে যাবে';
$string['pagesize'] = 'প্রতি পৃষ্ঠায় প্রদর্শিত জমা';
$string['pluginadministration'] = 'এসাইনমেন্ট প্রশাসন';
$string['pluginname'] = 'এসাইনমেন্ট (2.2)';
$string['popupinnewwindow'] = 'পপআপ উইন্ডোতে খোলা হবে';
$string['preventlate'] = 'বিলম্বে জমা দানে প্রতিরোধ';
$string['quickgrade'] = 'দ্রুত গ্রেডিং অনুমোদন';
$string['quickgrade_help'] = 'যদি সক্রিয় করা থাকে, একই পৃষ্ঠায় বিবিধ এসাইনমেন্টের গ্রেড দেয়া যাবে। গ্রেড এবং মন্তব্য যোগ করে  "আমার সব মন্তব্য সংরক্ষণ" বোতামে ক্লিক করে পৃষ্ঠার সব পরিবর্তন সংরক্ষণ করা হয়।';
$string['requiregrading'] = 'আবশ্যকীয় গ্রেডিং';
$string['responsefiles'] = 'জবাবের ফাইল';
$string['reviewed'] = 'রিভিউ';
$string['saveallfeedback'] = 'আমার সব মন্তব্য সংরক্ষণ';
$string['selectblog'] = 'আপনি কোন ব্লগ এন্ট্রি জমা দিতে চান তা নির্বাচন';
$string['sendformarking'] = 'আপনার নম্বর প্রেরণ';
$string['showrecentsubmissions'] = 'সাম্রতিক জমা প্রদর্শন';
$string['submission'] = 'জমা';
$string['submissiondraft'] = 'জমা ড্রাফ্ট';
$string['submissionfeedback'] = 'জমা মন্তব্য';
$string['submissions'] = 'জমা';
$string['submissionsaved'] = 'আপনার পরিবর্তন সংরক্ষন করা হয়েছে';
$string['submissionsnotgraded'] = '{$a} জমায় গ্রেড দেয়া হয়নি';
$string['submitassignment'] = 'এ ফর্ম ব্যবহার করে এসাইনমেন্ট জমা';
$string['submitedformarking'] = 'এসাইনমেন্ট ইতোমধ্যে নম্বরের জন্য জমা দেয়া হয়ে গিয়েছে এবং হালনাগাদ করা যায়নি';
$string['submitformarking'] = 'এসাইনমেন্টের নম্বরের জন্য চুড়ান্ত জমা';
$string['submitted'] = 'জমা';
$string['submittedfiles'] = 'জমা ফাইল';
$string['subplugintype_assignment'] = 'এসাইনমেন্টের ধরণ';
$string['subplugintype_assignment_plural'] = 'প্রতিবেদন ধরন';
$string['trackdrafts'] = 'নম্বরের জন্য প্রেরণ সক্রিয়';
$string['trackdrafts_help'] = '"নম্বরের জন্য প্রেরণ" বোতাম দিয়ে ছাত্ররা শিক্ষকদের বুঝাতে পারে যে এ এসাইমেন্টে তাদের কাজ করা শেষ। শিক্ষক চাইলেই এসাইনমেন্টটি ড্রাফ্ট হিসাবে ফেরত পাঠাতে পারে (উদাহরণস্বরূপ, যদি এটাতে আরও কোনো কাজ করতে হয়)।';
$string['typeblog'] = 'ব্লগ পোষ্ট';
$string['typeoffline'] = 'অফলাইন কার্যকলাপ';
$string['typeonline'] = 'অনলাইন টেক্সট';
$string['typeupload'] = 'উচ্চ পর্যায়ের ফাইল আপলোড';
$string['typeuploadsingle'] = 'একক ফাইল আপলোড';
$string['unfinalize'] = 'ড্রাফ্টে ফেরত';
$string['unfinalizeerror'] = 'একটি ত্রুটি ঘটেছে এবং যা জমা দেয়া হয়েছে তা আর ড্রাফ্টে পাঠানো যাচ্ছেনা';
$string['unfinalize_help'] = 'ড্রাফ্টে ফেরত পাঠানো সক্রিয় করা হলে ছাত্ররা তাদের এসাইনমেন্ট হালনাগাদ করতে পারে';
$string['uploadafile'] = 'ফাইল আপলোড';
$string['uploadbadname'] = 'এ ফাইলের নামে কিছু অদ্ভূত অক্ষর রয়েছে এবং এজন্য তা আপলোড করা যাচ্ছেনা';
$string['uploadedfiles'] = 'ফাইল আপলোড';
$string['uploaderror'] = 'সার্ভারে ফাইল আপলোড করা সময় ত্রুটি';
$string['uploadfailnoupdate'] = 'ফাইল ঠিকমত আপলোড হয়েছে কিন্তু জমাকৃতটি হালনাগাদ করা যায়নি!';
$string['uploadfiles'] = 'ফাইল আপলোড';
$string['uploadfiletoobig'] = 'দুঃখিত, ফাইলটি খুব বড় (সীমা {$a} বাইট)';
$string['uploadnofilefound'] = 'কোনো ফাইল পাওয়া যায়নি - আপনি কি নিশ্চিত যে আপনি আপলোড করার জন্য ফাইল নির্বাচন করেছেন?';
$string['uploadnotregistered'] = '\'{$a}\' ঠিকমত আপলোড হয়েছে কিন্তু জমার ব্যাপারটি নিবন্ধন করা হয়নি!';
$string['uploadsuccess'] = '\'{$a}\' সফলভাবে আপলোড করা হয়েছে';
$string['usermisconf'] = 'ব্যাবহারকারীকে ভুলভাবে কনফিগার করা হয়েছে';
$string['usernosubmit'] = 'দুঃখিত, আপনি কোনো এসাইনমেন্ট জমা দিতে অনুমোদিত নন।';
$string['viewfeedback'] = 'এসাইনমেন্টের গ্রেড এবং মন্তব্য প্রদর্শন';
$string['viewmysubmission'] = 'আমার জমা প্রদর্শন';
$string['viewsubmissions'] = '{$a} জমাকৃত এসাইনমেন্ট প্রদর্শন';
$string['yoursubmission'] = 'আপনার জমা';
